package tests::DomainCategoriserTest;

use strict;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::DomainCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::DomainCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../www-domain_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();
    $analyser->initialise();
    $self->assert_isa( 'Lire::WWW::Domain', $analyser->{'analyser'} );

    my $dlf = { 'client_host' => undef };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'client_domain'} );
    $self->assert_null( $dlf->{'country'} );

    $dlf->{'client_host'} = 'invalid host';
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'client_domain'} );
    $self->assert_null( $dlf->{'country'} );

    $dlf->{'client_host'} = '192.168.250.1';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( '192.168.250', $dlf->{'client_domain'} );
    $self->assert_null( $dlf->{'country'} );

    $dlf->{'client_host'} = 'www.logreport.org';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'logreport.org', $dlf->{'client_domain'} );
    $self->assert_str_equals( '.org (Organizations)',
                              $dlf->{'country'} );

    $dlf->{'client_host'} = '241.modemcable.videotron.ca';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'modemcable.videotron.ca',
                              $dlf->{'client_domain'} );
    $self->assert_str_equals( '.ca (Canada)',
                              $dlf->{'country'} );

    $dlf->{'client_host'} = 'myhost.nosuchtld.xyz';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'nosuchtld.xyz',
                              $dlf->{'client_domain'} );
    $self->assert_null( $dlf->{'country'} );

    return;
}


1;
