/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util.bean;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import net.sourceforge.stripes.util.bean.PropertyExpression;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanComparator
implements Comparator<Object> {
    private Locale locale;
    private PropertyExpression[] expressions;

    public BeanComparator(String ... properties) {
        this(Locale.getDefault(), properties);
    }

    public BeanComparator(Locale locale, String ... properties) {
        this.locale = locale;
        this.expressions = new PropertyExpression[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.expressions[i] = PropertyExpression.getExpression(properties[i]);
        }
    }

    @Override
    public int compare(Object o1, Object o2) {
        int retval = 0;
        Collator collator = Collator.getInstance(this.locale);
        for (PropertyExpression expression : this.expressions) {
            PropertyExpressionEvaluation e1 = new PropertyExpressionEvaluation(expression, o1);
            PropertyExpressionEvaluation e2 = new PropertyExpressionEvaluation(expression, o2);
            Object prop1 = e1.getValue();
            Object prop2 = e2.getValue();
            if (prop1 == null && prop2 == null) {
                retval = 0;
            } else if (prop1 == null) {
                retval = 1;
            } else if (prop2 == null) {
                retval = -1;
            } else if (!(prop1 instanceof String) && prop1 instanceof Comparable) {
                retval = ((Comparable)prop1).compareTo(prop2);
            } else {
                String string1 = prop1.toString();
                String string2 = prop2.toString();
                retval = collator.compare(string1, string2);
            }
            if (retval != 0) break;
        }
        return retval;
    }
}

