/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Wizard;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.BindingPolicyManager;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesConstants;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.CollectionUtil;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;
import net.sourceforge.stripes.util.bean.NoSuchPropertyException;
import net.sourceforge.stripes.util.bean.PropertyExpression;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMetadata;
import net.sourceforge.stripes.validation.expression.ExpressionValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionBeanPropertyBinder
implements ActionBeanPropertyBinder {
    private static final Log log = Log.getInstance(DefaultActionBeanPropertyBinder.class);
    private Configuration configuration;

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ValidationErrors bind(ActionBean bean, ActionBeanContext context, boolean validate) {
        ValidationErrors fieldErrors = context.getValidationErrors();
        Map<String, ValidationMetadata> validationInfos = this.configuration.getValidationMetadataProvider().getValidationMetadata(bean.getClass());
        SortedMap<ParameterName, String[]> parameters = this.getParameters(bean);
        if (validate) {
            this.validateRequiredFields(parameters, bean, fieldErrors);
        }
        TreeMap<ParameterName, List<Object>> allConvertedFields = new TreeMap<ParameterName, List<Object>>();
        for (Map.Entry entry : parameters.entrySet()) {
            List<Object> convertedValues = null;
            ParameterName name = (ParameterName)entry.getKey();
            try {
                PropertyExpressionEvaluation eval;
                String pname = name.getName();
                if (StripesConstants.SPECIAL_URL_KEYS.contains(pname) || fieldErrors.containsKey(pname)) continue;
                log.trace("Running binding for property with name: ", name);
                ValidationMetadata validationInfo = validationInfos.get(name.getStrippedName());
                try {
                    eval = new PropertyExpressionEvaluation(PropertyExpression.getExpression(pname), bean);
                }
                catch (Exception e) {
                    if (pname.equals(context.getEventName())) continue;
                    throw e;
                }
                Class<?> type = eval.getType();
                Class<?> scalarType = eval.getScalarType();
                if (!this.isBindingAllowed(eval)) continue;
                if (type == null && (validationInfo == null || validationInfo.converter() == null)) {
                    if (pname.equals(context.getEventName())) continue;
                    log.trace("Could not find type for property '", name.getName(), "' of '", bean.getClass().getSimpleName(), "' probably because it's not ", "a property of the bean.  Skipping binding.");
                    continue;
                }
                String[] values = (String[])entry.getValue();
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                if (validationInfo != null && validationInfo.ignore()) continue;
                if (validate && validationInfo != null) {
                    this.doPreConversionValidations(name, values, validationInfo, errors);
                }
                if (errors.isEmpty()) {
                    convertedValues = this.convert(bean, name, values, type, scalarType, validationInfo, errors);
                    allConvertedFields.put(name, convertedValues);
                }
                if (errors.size() > 0) {
                    fieldErrors.addAll(name.getName(), errors);
                    continue;
                }
                if (convertedValues.size() > 0) {
                    this.bindNonNullValue(bean, eval, convertedValues, type, scalarType);
                    continue;
                }
                this.bindNullValue(bean, name.getName(), type);
            }
            catch (Exception e) {
                this.handlePropertyBindingError(bean, name, convertedValues, e, fieldErrors);
            }
        }
        this.bindMissingValuesAsNull(bean, context);
        StripesRequestWrapper request = StripesRequestWrapper.findStripesWrapper((ServletRequest)context.getRequest());
        if (request.isMultipart()) {
            Enumeration<String> fileParameterNames = request.getFileParameterNames();
            while (fileParameterNames.hasMoreElements()) {
                String fileParameterName = fileParameterNames.nextElement();
                FileBean fileBean = request.getFileParameterValue(fileParameterName);
                log.trace("Attempting to bind file parameter with name [", fileParameterName, "] and value: ", fileBean);
                if (fileBean == null) continue;
                try {
                    this.bind(bean, fileParameterName, fileBean);
                }
                catch (Exception e) {
                    log.debug(e, "Could not bind file property with name [", fileParameterName, "] and value: ", fileBean);
                }
            }
        }
        if (validate) {
            this.doPostConversionValidations(bean, allConvertedFields, fieldErrors);
        }
        return fieldErrors;
    }

    protected boolean isBindingAllowed(PropertyExpressionEvaluation eval) {
        boolean allowed = BindingPolicyManager.getInstance(eval.getBean().getClass()).isBindingAllowed(eval);
        if (!allowed) {
            String param = eval.getExpression().getSource();
            log.warn("Binding denied for parameter [", param, "]");
        }
        return allowed;
    }

    protected void handlePropertyBindingError(ActionBean bean, ParameterName name, List<Object> values, Exception e, ValidationErrors errors) {
        if (e instanceof NoSuchPropertyException) {
            NoSuchPropertyException nspe = (NoSuchPropertyException)e;
            log.debug("Could not bind property with name [", name, "] to bean of type: ", bean.getClass().getSimpleName(), " : ", nspe.getMessage());
        } else {
            log.debug(e, "Could not bind property with name [", name, "] to bean of type: ", bean.getClass().getSimpleName());
        }
    }

    protected void bindMissingValuesAsNull(ActionBean bean, ActionBeanContext context) {
        Set parametersSubmitted = context.getRequest().getParameterMap().keySet();
        for (String name : this.getFieldsPresentInfo(bean)) {
            if (parametersSubmitted.contains(name)) continue;
            try {
                BeanUtil.setPropertyToNull(name, bean);
            }
            catch (Exception e) {
                this.handlePropertyBindingError(bean, new ParameterName(name), null, e, context.getValidationErrors());
            }
        }
    }

    protected Collection<String> getFieldsPresentInfo(ActionBean bean) {
        boolean isWizard;
        ActionBeanContext ctx = bean.getContext();
        String fieldsPresent = ctx.getRequest().getParameter("__fp");
        Wizard wizard = bean.getClass().getAnnotation(Wizard.class);
        boolean bl = isWizard = wizard != null;
        if (fieldsPresent == null || "".equals(fieldsPresent)) {
            if (isWizard && !CollectionUtil.contains(wizard.startEvents(), ctx.getEventName())) {
                throw new StripesRuntimeException("Submission of a wizard form in Stripes absolutely requires that the hidden field Stripes writes containing the names of the fields present on the form is present and encrypted (as Stripes write it). This is necessary to prevent a user from spoofing the system and getting around any security/data checks.");
            }
            return Collections.emptySet();
        }
        fieldsPresent = CryptoUtil.decrypt(fieldsPresent);
        return HtmlUtil.splitValues(fieldsPresent);
    }

    protected void bindNonNullValue(ActionBean bean, PropertyExpressionEvaluation propertyEvaluation, List<Object> valueOrValues, Class targetType, Class scalarType) throws Exception {
        Class<?> valueType = valueOrValues.iterator().next().getClass();
        if (targetType.isArray() && !valueType.isArray()) {
            Object typedArray = Array.newInstance(scalarType, valueOrValues.size());
            for (int i = 0; i < valueOrValues.size(); ++i) {
                Array.set(typedArray, i, valueOrValues.get(i));
            }
            propertyEvaluation.setValue(typedArray);
        } else if (Collection.class.isAssignableFrom(targetType) && !Collection.class.isAssignableFrom(valueType)) {
            Collection collection = null;
            collection = targetType.isInterface() ? (Collection)ReflectUtil.getInterfaceInstance(targetType) : (Collection)targetType.newInstance();
            collection.addAll(valueOrValues);
            propertyEvaluation.setValue(collection);
        } else {
            propertyEvaluation.setValue(valueOrValues.get(0));
        }
    }

    protected void bindNullValue(ActionBean bean, String property, Class<?> type) throws ExpressionException {
        BeanUtil.setPropertyToNull(property, bean);
    }

    protected SortedMap<ParameterName, String[]> getParameters(ActionBean bean) {
        Map requestParameters = bean.getContext().getRequest().getParameterMap();
        Map<String, ValidationMetadata> validations = StripesFilter.getConfiguration().getValidationMetadataProvider().getValidationMetadata(bean.getClass());
        TreeMap<ParameterName, String[]> parameters = new TreeMap<ParameterName, String[]>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            ParameterName paramName = new ParameterName(((String)entry.getKey()).trim());
            ValidationMetadata validation = validations.get(paramName.getStrippedName());
            parameters.put(paramName, this.trim((String[])entry.getValue(), validation));
        }
        return parameters;
    }

    @Override
    public void bind(ActionBean bean, String propertyName, Object propertyValue) throws Exception {
        BeanUtil.setPropertyValue(propertyName, bean, propertyValue);
    }

    protected void validateRequiredFields(Map<ParameterName, String[]> parameters, ActionBean bean, ValidationErrors errors) {
        String[] values;
        log.debug("Running required field validation on bean class ", bean.getClass().getName());
        HashSet<String> indexedParams = new HashSet<String>();
        for (ParameterName name : parameters.keySet()) {
            if (!name.isIndexed()) continue;
            indexedParams.add(name.getStrippedName());
        }
        Map<String, ValidationMetadata> validationInfos = this.configuration.getValidationMetadataProvider().getValidationMetadata(bean.getClass());
        ActionBeanContext context = bean.getContext();
        HttpServletRequest request = context.getRequest();
        StripesRequestWrapper stripesReq = StripesRequestWrapper.findStripesWrapper((ServletRequest)request);
        if (validationInfos != null) {
            boolean wizard = bean.getClass().getAnnotation(Wizard.class) != null;
            Collection<String> fieldsOnPage = this.getFieldsPresentInfo(bean);
            for (Map.Entry<String, ValidationMetadata> entry : validationInfos.entrySet()) {
                String propertyName = entry.getKey();
                ValidationMetadata validationInfo = entry.getValue();
                if (!validationInfo.requiredOn(context.getEventName()) || indexedParams.contains(propertyName) || wizard && !fieldsOnPage.contains(propertyName)) continue;
                values = this.trim(request.getParameterValues(propertyName), validationInfo);
                log.debug("Checking required field: ", propertyName, ", with values: ", values);
                this.checkSingleRequiredField(propertyName, propertyName, values, stripesReq, errors);
            }
        }
        if (indexedParams.size() > 0) {
            HashMap<String, Row> rows = new HashMap<String, Row>();
            for (Map.Entry<ParameterName, String[]> entry : parameters.entrySet()) {
                ParameterName name = entry.getKey();
                String[] values2 = entry.getValue();
                if (!name.isIndexed()) continue;
                String rowKey = name.getName().substring(0, name.getName().indexOf(93) + 1);
                if (!rows.containsKey(rowKey)) {
                    rows.put(rowKey, new Row());
                }
                ((Row)rows.get(rowKey)).put(name, values2);
            }
            for (Row row : rows.values()) {
                if (row.hasNonEmptyValues()) {
                    for (Map.Entry entry : row.entrySet()) {
                        ParameterName name = (ParameterName)entry.getKey();
                        values = (String[])entry.getValue();
                        ValidationMetadata validationInfo = validationInfos.get(name.getStrippedName());
                        if (validationInfo == null || !validationInfo.requiredOn(context.getEventName())) continue;
                        this.checkSingleRequiredField(name.getName(), name.getStrippedName(), values, stripesReq, errors);
                    }
                    continue;
                }
                for (ParameterName name : row.keySet()) {
                    parameters.remove(name);
                }
            }
        }
    }

    protected void checkSingleRequiredField(String name, String strippedName, String[] values, StripesRequestWrapper req, ValidationErrors errors) {
        FileBean file = null;
        if (req.isMultipart() && (file = req.getFileParameterValue(name)) != null) {
            if (file.getSize() <= 0L) {
                errors.add(name, new ScopedLocalizableError("validation.required", "valueNotPresent", new Object[0]));
            }
        } else if (values == null || values.length == 0) {
            ScopedLocalizableError error = new ScopedLocalizableError("validation.required", "valueNotPresent", new Object[0]);
            error.setFieldValue(null);
            errors.add(name, error);
        } else {
            for (String value : values) {
                if (value.length() != 0) continue;
                ScopedLocalizableError error = new ScopedLocalizableError("validation.required", "valueNotPresent", new Object[0]);
                error.setFieldValue(value);
                errors.add(name, error);
            }
        }
    }

    protected void doPreConversionValidations(ParameterName propertyName, String[] values, ValidationMetadata validationInfo, List<ValidationError> errors) {
        for (String value : values) {
            ScopedLocalizableError error;
            if (value == null || value.length() <= 0) continue;
            if (validationInfo.minlength() != null && value.length() < validationInfo.minlength()) {
                error = new ScopedLocalizableError("validation.minlength", "valueTooShort", validationInfo.minlength());
                error.setFieldValue(value);
                errors.add(error);
            }
            if (validationInfo.maxlength() != null && value.length() > validationInfo.maxlength()) {
                error = new ScopedLocalizableError("validation.maxlength", "valueTooLong", validationInfo.maxlength());
                error.setFieldValue(value);
                errors.add(error);
            }
            if (validationInfo.mask() == null || validationInfo.mask().matcher(value).matches()) continue;
            error = new ScopedLocalizableError("validation.mask", "valueDoesNotMatch", new Object[0]);
            error.setFieldValue(value);
            errors.add(error);
        }
    }

    protected void doPostConversionValidations(ActionBean bean, Map<ParameterName, List<Object>> convertedValues, ValidationErrors errors) {
        Map<String, ValidationMetadata> validationInfos = this.configuration.getValidationMetadataProvider().getValidationMetadata(bean.getClass());
        for (Map.Entry<ParameterName, List<Object>> entry : convertedValues.entrySet()) {
            ParameterName name = entry.getKey();
            List<Object> values = entry.getValue();
            ValidationMetadata validationInfo = validationInfos.get(name.getStrippedName());
            if (values.size() == 0 || validationInfo == null) continue;
            for (Object value : values) {
                ScopedLocalizableError error;
                if (!(value instanceof Number)) continue;
                Number number = (Number)value;
                if (validationInfo.minvalue() != null && number.doubleValue() < validationInfo.minvalue()) {
                    error = new ScopedLocalizableError("validation.minvalue", "valueBelowMinimum", validationInfo.minvalue());
                    error.setFieldValue(String.valueOf(value));
                    errors.add(name.getName(), error);
                }
                if (validationInfo.maxvalue() == null || !(number.doubleValue() > validationInfo.maxvalue())) continue;
                error = new ScopedLocalizableError("validation.maxvalue", "valueAboveMaximum", validationInfo.maxvalue());
                error.setFieldValue(String.valueOf(value));
                errors.add(name.getName(), error);
            }
            this.doExpressionValidation(bean, name, values, validationInfo, errors);
        }
    }

    protected void doExpressionValidation(ActionBean bean, ParameterName name, List<Object> values, ValidationMetadata validationInfo, ValidationErrors errors) {
        if (validationInfo.expression() != null) {
            ExpressionValidator.evaluate(bean, name, values, validationInfo, errors);
        }
    }

    protected List<Object> convert(ActionBean bean, ParameterName propertyName, String[] values, Class<?> declaredType, Class<?> scalarType, ValidationMetadata validationInfo, List<ValidationError> errors) throws Exception {
        ArrayList<Object> returns = new ArrayList<Object>();
        Class<?> returnType = null;
        TypeConverterFactory factory = this.configuration.getTypeConverterFactory();
        TypeConverter converter = null;
        Locale locale = bean.getContext().getRequest().getLocale();
        converter = factory.getTypeConverter(declaredType, locale);
        if (validationInfo != null && validationInfo.converter() != null) {
            if (converter != null && validationInfo.converter().isAssignableFrom(converter.getClass())) {
                returnType = declaredType;
            } else {
                converter = factory.getInstance(validationInfo.converter(), locale);
                returnType = scalarType;
            }
        } else if (converter != null) {
            returnType = declaredType;
        } else {
            converter = factory.getTypeConverter(scalarType, locale);
            returnType = scalarType;
        }
        log.debug("Converting ", values.length, " value(s) using ", converter != null ? "converter " + converter.getClass().getName() : "Constructor(String) if available");
        for (String value : values) {
            if ("".equals(value)) continue;
            try {
                if (validationInfo != null && validationInfo.encrypted()) {
                    value = CryptoUtil.decrypt(value);
                }
                Object retval = null;
                if (converter != null) {
                    retval = converter.convert(value, returnType, errors);
                } else {
                    Constructor<?> constructor = returnType.getConstructor(String.class);
                    if (constructor != null) {
                        retval = constructor.newInstance(value);
                    } else {
                        log.debug("Could not find a way to convert the parameter ", propertyName.getName(), " to a ", returnType.getSimpleName(), ". No TypeConverter could be ", "found and the class does not ", "have a constructor that takes a ", "single String parameter.");
                    }
                }
                if (retval != null) {
                    returns.add(retval);
                }
                for (ValidationError error : errors) {
                    error.setFieldName(propertyName.getStrippedName());
                    error.setFieldValue(value);
                }
            }
            catch (Exception e) {
                log.warn(e, "Looks like type converter ", converter, " threw an exception.");
            }
        }
        return returns;
    }

    protected String[] trim(String[] values, ValidationMetadata meta) {
        if (values != null && values.length > 0 && (meta == null || meta.trim())) {
            String[] copy = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                copy[i] = values[i].trim();
            }
            return copy;
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Row
    extends HashMap<ParameterName, String[]> {
        private static final long serialVersionUID = 1L;
        private boolean hasNonEmptyValues = false;

        protected Row() {
        }

        @Override
        public String[] put(ParameterName key, String[] values) {
            if (!this.hasNonEmptyValues) {
                this.hasNonEmptyValues = values != null && values.length > 0 && values[0] != null && values[0].trim().length() > 0;
            }
            return super.put(key, values);
        }

        public boolean hasNonEmptyValues() {
            return this.hasNonEmptyValues;
        }
    }
}

