// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package ovsmodel

import (
	"encoding/json"

	"github.com/ovn-org/libovsdb/model"
	"github.com/ovn-org/libovsdb/ovsdb"
)

// FullDatabaseModel returns the DatabaseModel object to be used in libovsdb
func FullDatabaseModel() (model.ClientDBModel, error) {
	return model.NewClientDBModel("Open_vSwitch", map[string]model.Model{
		"AutoAttach":                &AutoAttach{},
		"Bridge":                    &Bridge{},
		"CT_Timeout_Policy":         &CTTimeoutPolicy{},
		"CT_Zone":                   &CTZone{},
		"Controller":                &Controller{},
		"Datapath":                  &Datapath{},
		"Flow_Sample_Collector_Set": &FlowSampleCollectorSet{},
		"Flow_Table":                &FlowTable{},
		"IPFIX":                     &IPFIX{},
		"Interface":                 &Interface{},
		"Manager":                   &Manager{},
		"Mirror":                    &Mirror{},
		"NetFlow":                   &NetFlow{},
		"Open_vSwitch":              &OpenvSwitch{},
		"Port":                      &Port{},
		"QoS":                       &QoS{},
		"Queue":                     &Queue{},
		"SSL":                       &SSL{},
		"sFlow":                     &SFlow{},
	})
}

var schema = `{
  "name": "Open_vSwitch",
  "version": "8.2.0",
  "tables": {
    "AutoAttach": {
      "columns": {
        "mappings": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 16777215
            },
            "value": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4095
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "system_description": {
          "type": "string"
        },
        "system_name": {
          "type": "string"
        }
      }
    },
    "Bridge": {
      "columns": {
        "auto_attach": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "AutoAttach"
            },
            "min": 0,
            "max": 1
          }
        },
        "controller": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Controller"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "datapath_id": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "datapath_type": {
          "type": "string"
        },
        "datapath_version": {
          "type": "string"
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "fail_mode": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "standalone",
                  "secure"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        },
        "flood_vlans": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4095
            },
            "min": 0,
            "max": 4096
          }
        },
        "flow_tables": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 254
            },
            "value": {
              "type": "uuid",
              "refTable": "Flow_Table"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "ipfix": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "IPFIX"
            },
            "min": 0,
            "max": 1
          }
        },
        "mcast_snooping_enable": {
          "type": "boolean"
        },
        "mirrors": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Mirror"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "name": {
          "type": "string",
          "mutable": false
        },
        "netflow": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "NetFlow"
            },
            "min": 0,
            "max": 1
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "ports": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Port"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "protocols": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "OpenFlow10",
                  "OpenFlow11",
                  "OpenFlow12",
                  "OpenFlow13",
                  "OpenFlow14",
                  "OpenFlow15"
                ]
              ]
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "rstp_enable": {
          "type": "boolean"
        },
        "rstp_status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "sflow": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "sFlow"
            },
            "min": 0,
            "max": 1
          }
        },
        "status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "stp_enable": {
          "type": "boolean"
        }
      },
      "indexes": [
        [
          "name"
        ]
      ]
    },
    "CT_Timeout_Policy": {
      "columns": {
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "timeouts": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "tcp_syn_sent",
                  "tcp_syn_recv",
                  "tcp_established",
                  "tcp_fin_wait",
                  "tcp_close_wait",
                  "tcp_last_ack",
                  "tcp_time_wait",
                  "tcp_close",
                  "tcp_syn_sent2",
                  "tcp_retransmit",
                  "tcp_unack",
                  "udp_first",
                  "udp_single",
                  "udp_multiple",
                  "icmp_first",
                  "icmp_reply"
                ]
              ]
            },
            "value": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "min": 0,
            "max": "unlimited"
          }
        }
      }
    },
    "CT_Zone": {
      "columns": {
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "timeout_policy": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "CT_Timeout_Policy"
            },
            "min": 0,
            "max": 1
          }
        }
      }
    },
    "Controller": {
      "columns": {
        "connection_mode": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "in-band",
                  "out-of-band"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        },
        "controller_burst_limit": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 25
            },
            "min": 0,
            "max": 1
          }
        },
        "controller_queue_size": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1,
              "maxInteger": 512
            },
            "min": 0,
            "max": 1
          }
        },
        "controller_rate_limit": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 100
            },
            "min": 0,
            "max": 1
          }
        },
        "enable_async_messages": {
          "type": {
            "key": {
              "type": "boolean"
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "inactivity_probe": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "is_connected": {
          "type": "boolean",
          "ephemeral": true
        },
        "local_gateway": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "local_ip": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "local_netmask": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "max_backoff": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1000
            },
            "min": 0,
            "max": 1
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "role": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "other",
                  "master",
                  "slave"
                ]
              ]
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "target": {
          "type": "string"
        },
        "type": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "primary",
                  "service"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        }
      }
    },
    "Datapath": {
      "columns": {
        "capabilities": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "ct_zones": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 65535
            },
            "value": {
              "type": "uuid",
              "refTable": "CT_Zone"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "datapath_version": {
          "type": "string"
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        }
      }
    },
    "Flow_Sample_Collector_Set": {
      "columns": {
        "bridge": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Bridge"
            },
            "min": 1,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "id": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "min": 1,
            "max": 1
          }
        },
        "ipfix": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "IPFIX"
            },
            "min": 0,
            "max": 1
          }
        }
      },
      "indexes": [
        [
          "id",
          "bridge"
        ]
      ],
      "isRoot": true
    },
    "Flow_Table": {
      "columns": {
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "flow_limit": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0
            },
            "min": 0,
            "max": 1
          }
        },
        "groups": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "name": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "overflow_policy": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "refuse",
                  "evict"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        },
        "prefixes": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 3
          }
        }
      }
    },
    "IPFIX": {
      "columns": {
        "cache_active_timeout": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4200
            },
            "min": 0,
            "max": 1
          }
        },
        "cache_max_flows": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "obs_domain_id": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "min": 0,
            "max": 1
          }
        },
        "obs_point_id": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "min": 0,
            "max": 1
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "sampling": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1,
              "maxInteger": 4294967295
            },
            "min": 0,
            "max": 1
          }
        },
        "targets": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        }
      }
    },
    "Interface": {
      "columns": {
        "admin_state": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "up",
                  "down"
                ]
              ]
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "bfd": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "bfd_status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "cfm_fault": {
          "type": {
            "key": {
              "type": "boolean"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "cfm_fault_status": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "cfm_flap_count": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "cfm_health": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 100
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "cfm_mpid": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "cfm_remote_mpids": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "cfm_remote_opstate": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "up",
                  "down"
                ]
              ]
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "duplex": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "half",
                  "full"
                ]
              ]
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "error": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "ifindex": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "ingress_policing_burst": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0
            }
          }
        },
        "ingress_policing_rate": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0
            }
          }
        },
        "lacp_current": {
          "type": {
            "key": {
              "type": "boolean"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "link_resets": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "link_speed": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "link_state": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "up",
                  "down"
                ]
              ]
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "lldp": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "mac": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "mac_in_use": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "mtu": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          },
          "ephemeral": true
        },
        "mtu_request": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1
            },
            "min": 0,
            "max": 1
          }
        },
        "name": {
          "type": "string",
          "mutable": false
        },
        "ofport": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "ofport_request": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1,
              "maxInteger": 65279
            },
            "min": 0,
            "max": 1
          }
        },
        "options": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "statistics": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "integer"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "type": {
          "type": "string"
        }
      },
      "indexes": [
        [
          "name"
        ]
      ]
    },
    "Manager": {
      "columns": {
        "connection_mode": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "in-band",
                  "out-of-band"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "inactivity_probe": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "is_connected": {
          "type": "boolean",
          "ephemeral": true
        },
        "max_backoff": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1000
            },
            "min": 0,
            "max": 1
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "target": {
          "type": "string"
        }
      },
      "indexes": [
        [
          "target"
        ]
      ]
    },
    "Mirror": {
      "columns": {
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "name": {
          "type": "string"
        },
        "output_port": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Port",
              "refType": "weak"
            },
            "min": 0,
            "max": 1
          }
        },
        "output_vlan": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 1,
              "maxInteger": 4095
            },
            "min": 0,
            "max": 1
          }
        },
        "select_all": {
          "type": "boolean"
        },
        "select_dst_port": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Port",
              "refType": "weak"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "select_src_port": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Port",
              "refType": "weak"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "select_vlan": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4095
            },
            "min": 0,
            "max": 4096
          }
        },
        "snaplen": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 14,
              "maxInteger": 65535
            },
            "min": 0,
            "max": 1
          }
        },
        "statistics": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "integer"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        }
      }
    },
    "NetFlow": {
      "columns": {
        "active_timeout": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": -1
            }
          }
        },
        "add_id_to_interface": {
          "type": "boolean"
        },
        "engine_id": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 255
            },
            "min": 0,
            "max": 1
          }
        },
        "engine_type": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 255
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "targets": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 1,
            "max": "unlimited"
          }
        }
      }
    },
    "Open_vSwitch": {
      "columns": {
        "bridges": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Bridge"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "cur_cfg": {
          "type": "integer"
        },
        "datapath_types": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "datapaths": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "uuid",
              "refTable": "Datapath"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "db_version": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "dpdk_initialized": {
          "type": "boolean"
        },
        "dpdk_version": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "iface_types": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "manager_options": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Manager"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "next_cfg": {
          "type": "integer"
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "ovs_version": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "ssl": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "SSL"
            },
            "min": 0,
            "max": 1
          }
        },
        "statistics": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "system_type": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "system_version": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        }
      },
      "isRoot": true
    },
    "Port": {
      "columns": {
        "bond_active_slave": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "bond_downdelay": {
          "type": "integer"
        },
        "bond_fake_iface": {
          "type": "boolean"
        },
        "bond_mode": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "balance-tcp",
                  "balance-slb",
                  "active-backup"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        },
        "bond_updelay": {
          "type": "integer"
        },
        "cvlans": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4095
            },
            "min": 0,
            "max": 4096
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "fake_bridge": {
          "type": "boolean"
        },
        "interfaces": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "Interface"
            },
            "min": 1,
            "max": "unlimited"
          }
        },
        "lacp": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "active",
                  "passive",
                  "off"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        },
        "mac": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "name": {
          "type": "string",
          "mutable": false
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "protected": {
          "type": "boolean"
        },
        "qos": {
          "type": {
            "key": {
              "type": "uuid",
              "refTable": "QoS"
            },
            "min": 0,
            "max": 1
          }
        },
        "rstp_statistics": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "integer"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "rstp_status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "statistics": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "integer"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "status": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          },
          "ephemeral": true
        },
        "tag": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4095
            },
            "min": 0,
            "max": 1
          }
        },
        "trunks": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4095
            },
            "min": 0,
            "max": 4096
          }
        },
        "vlan_mode": {
          "type": {
            "key": {
              "type": "string",
              "enum": [
                "set",
                [
                  "trunk",
                  "access",
                  "native-tagged",
                  "native-untagged",
                  "dot1q-tunnel"
                ]
              ]
            },
            "min": 0,
            "max": 1
          }
        }
      },
      "indexes": [
        [
          "name"
        ]
      ]
    },
    "QoS": {
      "columns": {
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "queues": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 4294967295
            },
            "value": {
              "type": "uuid",
              "refTable": "Queue"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "type": {
          "type": "string"
        }
      },
      "isRoot": true
    },
    "Queue": {
      "columns": {
        "dscp": {
          "type": {
            "key": {
              "type": "integer",
              "minInteger": 0,
              "maxInteger": 63
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "other_config": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        }
      },
      "isRoot": true
    },
    "SSL": {
      "columns": {
        "bootstrap_ca_cert": {
          "type": "boolean"
        },
        "ca_cert": {
          "type": "string"
        },
        "certificate": {
          "type": "string"
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "private_key": {
          "type": "string"
        }
      }
    },
    "sFlow": {
      "columns": {
        "agent": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 0,
            "max": 1
          }
        },
        "external_ids": {
          "type": {
            "key": {
              "type": "string"
            },
            "value": {
              "type": "string"
            },
            "min": 0,
            "max": "unlimited"
          }
        },
        "header": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "polling": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "sampling": {
          "type": {
            "key": {
              "type": "integer"
            },
            "min": 0,
            "max": 1
          }
        },
        "targets": {
          "type": {
            "key": {
              "type": "string"
            },
            "min": 1,
            "max": "unlimited"
          }
        }
      }
    }
  }
}`

func Schema() ovsdb.DatabaseSchema {
	var s ovsdb.DatabaseSchema
	err := json.Unmarshal([]byte(schema), &s)
	if err != nil {
		panic(err)
	}
	return s
}
