/* test preamble */

	_testDescription 		= " fit the HKY85+Gamma(5) model to an Influenza A alignment with 349 sequences and 967 nucleotides and perform an EB analysis";
	_expectedLL 			= -10824.9555795;
	ExecuteAFile 			("../Shared/TestInstrumentation.bf");
	startTestTimer 			(_testDescription);
	
/* end test preamble */

timer = Time (1);


VERBOSITY_LEVEL = 1;
OPTIMIZATION_PROGRESS_QUANTUM = 0.5;
OPTIMIZATION_PROGRESS_STATUS  = "OPTIMIZING THE LIKELIHOOD FUNCTION";
OPTIMIZATION_PROGRESS_TEMPLATE = "$1 Log(L) = $2 ($3% done) Time elapsed: $4 LF evals/second: $5 CPU load: $6";


global flu_part_SharedAC = 1;
global flu_part_SharedAT = 1;
global flu_part_SharedCG = 1;
global flu_part_SharedCT = 1;
global flu_part_SharedGT = 1;
global flu_part_Shape2   = 0.25;

global alpha = .5;
alpha:>0.01;alpha:<100;
category flu_part_Categ2 = (5, EQUAL, MEAN, 
				GammaDist(_x_,alpha,alpha), 
				CGammaDist(_x_,alpha,alpha), 
				0 , 
				1e25,
				CGammaDist(_x_,alpha+1,alpha)
			 );


flu_part_REV2={4,4};
flu_part_REV2[0][1]:=flu_part_SharedAC*mu*flu_part_Categ2;
flu_part_REV2[0][2]:=mu*flu_part_Categ2;
flu_part_REV2[0][3]:=flu_part_SharedAT*mu*flu_part_Categ2;
flu_part_REV2[1][0]:=flu_part_SharedAC*mu*flu_part_Categ2;
flu_part_REV2[1][2]:=flu_part_SharedCG*mu*flu_part_Categ2;
flu_part_REV2[1][3]:=flu_part_SharedCT*mu*flu_part_Categ2;
flu_part_REV2[2][0]:=mu*flu_part_Categ2;
flu_part_REV2[2][1]:=flu_part_SharedCG*mu*flu_part_Categ2;
flu_part_REV2[2][3]:=flu_part_SharedGT*mu*flu_part_Categ2;
flu_part_REV2[3][0]:=flu_part_SharedAT*mu*flu_part_Categ2;
flu_part_REV2[3][1]:=flu_part_SharedCT*mu*flu_part_Categ2;
flu_part_REV2[3][2]:=flu_part_SharedGT*mu*flu_part_Categ2;

flu_part_Freqs2={
{    0.321488786102}
{    0.221264478507}
{    0.225765445963}
{    0.231481289428}
};

Model flu_part_REV2_model=(flu_part_REV2,flu_part_Freqs2);

UseModel 	(flu_part_REV2_model);
DataSet flu 				= 	ReadDataFile("../data/fluHA.nex");
Tree Tree_1				=	DATAFILE_TREE;

DataSetFilter flu_part 			= CreateFilter(flu,1);
LikelihoodFunction flu_LF 		= (flu_part,Tree_1);
USE_ADAPTIVE_VARIABLE_STEP		= 1;
VERBOSITY_LEVEL					= 1;
Optimize						(res_flu_LF,flu_LF);

expectedConditionalProbabilities = {
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{2.09265e-14,1.33831e-11,3.20059e-10,1.75442e-09,9.57163e-10}
{4.03972e-14,2.58347e-11,6.178e-10,3.38584e-09,1.84494e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.0572e-05,8.02644e-05,0.000164091,0.000134207,7.14634e-06}
{8.98899e-25,4.86033e-20,1.37319e-17,5.15344e-16,3.07981e-15}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{5.45902e-11,3.88049e-09,2.86376e-08,6.83736e-08,1.77146e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.12183e-05,8.54675e-05,0.000176354,0.000147137,8.33035e-06}
{8.9053e-10,6.04653e-08,3.94045e-07,7.12284e-07,6.87919e-08}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.49031e-06,1.89181e-05,3.87377e-05,3.17963e-05,1.71469e-06}
{5.00872e-05,0.000380226,0.000777071,0.00063505,3.37025e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.40159e-05,0.000106406,0.000217505,0.000177837,9.45879e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.75315e-05,0.000133095,0.000272055,0.00022243,1.18284e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{6.13429e-06,4.67398e-05,9.64721e-05,8.05435e-05,4.57128e-06}
{1.76335e-14,1.1223e-11,2.64915e-10,1.41002e-09,6.91592e-10}
{1.41815e-05,0.000104907,0.000199849,0.000139479,4.20146e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.08543e-33,4.80168e-27,1.4664e-23,3.09124e-21,1.01393e-19}
{1.35775e-05,0.000103459,0.00021358,0.000178384,1.01377e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{8.8852e-10,6.03457e-08,3.93564e-07,7.12625e-07,6.92452e-08}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{7.5207e-29,3.73452e-23,3.61496e-20,3.52576e-18,6.83827e-17}
{4.53285e-06,3.50897e-05,7.56106e-05,6.95167e-05,5.56356e-06}
{3.22026e-15,2.00717e-12,4.4763e-11,2.09738e-10,6.51399e-11}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{7.17228e-37,2.98568e-29,3.33762e-25,2.12149e-22,3.85136e-20}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.42106e-05,0.000107905,0.000220687,0.000180654,9.64942e-06}
{1.59312e-37,6.70651e-30,7.72703e-26,5.25114e-23,1.19815e-20}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.05993e-05,7.84199e-05,0.000149454,0.000104407,3.15575e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.91194e-05,0.000145131,0.000296552,0.000242266,1.28474e-05}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.16746e-09,7.93322e-08,5.18126e-07,9.41167e-07,9.25046e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{6.49921e-07,4.96106e-06,1.02904e-05,8.68615e-06,5.12235e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{7.95965e-14,5.08927e-11,1.21636e-09,6.6583e-09,3.61453e-09}
{1.80621e-14,1.15912e-11,2.79775e-10,1.56433e-09,9.0738e-10}
{5.73333e-05,0.00042419,0.000808456,0.000564785,1.70619e-05}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{3.55574e-05,0.000269934,0.000551709,0.000450967,2.39567e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.84838e-10,2.62027e-08,1.72055e-07,3.16315e-07,3.24387e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.05712e-05,8.02583e-05,0.000164078,0.000134195,7.14537e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.5045e-05,0.000185278,0.000353007,0.000246447,7.43107e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.95371e-10,1.36167e-08,9.52722e-08,2.02017e-07,3.46189e-08}
{7.97046e-10,5.55387e-08,3.88338e-07,8.2224e-07,1.40136e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.6375e-05,0.000124352,0.000254393,0.000208375,1.11563e-05}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.80171e-14,1.12301e-11,2.5046e-10,1.17365e-09,3.64616e-10}
{6.99182e-06,5.30813e-05,0.000108508,8.87261e-05,4.72072e-06}
{7.09915e-06,5.38996e-05,0.0001102,9.01449e-05,4.80288e-06}
{6.19513e-07,4.79565e-06,1.03329e-05,9.49869e-06,7.59799e-07}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.04961e-05,7.9685e-05,0.000162887,0.000133187,7.08512e-06}
{5.05281e-42,1.96582e-33,7.89408e-29,1.44872e-25,1.22965e-22}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{9.96011e-23,5.33721e-18,1.47178e-15,5.23487e-14,2.60519e-13}
{1.40603e-05,0.000106742,0.000218185,0.000178381,9.48526e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.41387e-05,0.000107345,0.000219462,0.000179507,9.56077e-06}
{7.84486e-11,5.46841e-09,3.82756e-08,8.12291e-08,1.39595e-08}
{6.99692e-06,5.17907e-05,9.88261e-05,6.92296e-05,2.1131e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.05094e-05,7.97858e-05,0.000163093,0.000133355,7.09407e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{4.77187e-11,3.24723e-09,2.12896e-08,3.90028e-08,3.94716e-09}
{2.32385e-19,1.3691e-15,1.13108e-13,1.64002e-12,3.06392e-12}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.74999e-05,0.000129456,0.000246624,0.000172137,5.18637e-06}
{2.11134e-05,0.000156201,0.000297649,0.000207865,6.27507e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.43412e-28,1.22867e-22,1.24341e-19,1.3397e-17,3.70295e-16}
{1.60948e-07,1.22675e-06,2.53438e-06,2.1203e-06,1.21232e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{4.59644e-11,3.12138e-09,2.03503e-08,3.68207e-08,3.56848e-09}
{1.41258e-05,0.000107247,0.000219264,0.000179347,9.55268e-06}
{1.81447e-23,9.53792e-19,2.49637e-16,7.89666e-15,2.57925e-14}
{8.62394e-20,5.15847e-16,4.44078e-14,7.06124e-13,1.8326e-12}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{9.1671e-11,6.40921e-09,4.52183e-08,9.76042e-08,1.76486e-08}
{5.42407e-10,3.7932e-08,2.67799e-07,5.78924e-07,1.05251e-07}
{1.14638e-14,7.47033e-12,1.87961e-10,1.15353e-09,9.3236e-10}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.7671e-05,0.000134154,0.000274219,0.000224198,1.19224e-05}
{1.95931e-15,1.25724e-12,3.03366e-11,1.69512e-10,9.80985e-11}
{2.51012e-06,1.90686e-05,3.90465e-05,3.20507e-05,1.72859e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.04672e-05,7.74295e-05,0.0001475,0.000102935,3.09984e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.19157e-10,1.52714e-08,1.06789e-07,2.26144e-07,3.85642e-08}
{1.6246e-33,7.19103e-27,2.19958e-23,4.65323e-21,1.54537e-19}
{8.88629e-10,6.2001e-08,4.35055e-07,9.28416e-07,1.62626e-07}
{3.66504e-06,2.78281e-05,5.69044e-05,4.65651e-05,2.48411e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.49914e-06,2.65694e-05,5.4336e-05,4.44743e-05,2.37518e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.42094e-19,8.36966e-16,6.91048e-14,1.00066e-12,1.86044e-12}
{4.70731e-18,2.69252e-14,2.05309e-12,2.48855e-11,2.46663e-11}
{3.50513e-10,2.442e-08,1.70675e-07,3.61026e-07,6.13219e-08}
{3.65438e-06,2.7842e-05,5.74538e-05,4.79436e-05,2.71618e-06}
{1.40651e-05,0.000106735,0.000217928,0.000177729,9.36665e-06}
{1.75526e-05,0.000129846,0.000247367,0.000172655,5.20202e-06}
{1.12803e-05,8.73085e-05,0.000188046,0.000172715,1.37725e-05}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.43835e-06,3.38128e-05,6.97634e-05,5.81939e-05,3.29247e-06}
{1.1254e-05,8.71081e-05,0.000187631,0.00017237,1.3755e-05}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.4443e-14,9.26792e-12,2.23648e-10,1.24987e-09,7.2369e-10}
{4.0701e-11,2.84754e-09,2.01267e-08,4.36226e-08,8.00521e-09}
{9.82971e-15,6.13283e-12,1.37137e-10,6.46424e-10,2.0511e-10}
{5.89199e-14,3.77037e-11,9.03156e-10,4.96862e-09,2.74497e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{6.77622e-06,5.16241e-05,0.000106515,8.8857e-05,5.02853e-06}
{6.12306e-06,4.6653e-05,9.62863e-05,8.03757e-05,4.55915e-06}
{1.87247e-06,1.44989e-05,3.12635e-05,2.87883e-05,2.31666e-06}
{4.19144e-10,2.9759e-08,2.18908e-07,5.18863e-07,1.30952e-07}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{3.55848e-55,1.05023e-43,1.60301e-37,4.55414e-33,8.52564e-29}
{3.59195e-10,2.50228e-08,1.74849e-07,3.69663e-07,6.26698e-08}
{7.63798e-10,5.32217e-08,3.72134e-07,7.87911e-07,1.34274e-07}
{2.08377e-10,1.45653e-08,1.027e-07,2.21435e-07,4.00146e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.05185e-14,1.96003e-11,4.74089e-10,2.6634e-09,1.57129e-09}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.12023e-06,2.3707e-05,4.85643e-05,3.98993e-05,2.1587e-06}
{3.48176e-10,2.43446e-08,1.71789e-07,3.70969e-07,6.71787e-08}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.11205e-05,0.000160341,0.000327741,0.000267946,1.42462e-05}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.1207e-05,8.67412e-05,0.000186824,0.000171593,1.3683e-05}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.00289e-15,1.95749e-12,4.92979e-11,3.03174e-10,2.46895e-10}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.48416e-06,1.88713e-05,3.86417e-05,3.17172e-05,1.71036e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{6.07261e-15,3.88324e-12,9.28454e-11,5.08682e-10,2.77195e-10}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.45586e-06,3.39462e-05,7.00387e-05,5.84235e-05,3.30546e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.98612e-10,2.08902e-08,1.47628e-07,3.19838e-07,5.86102e-08}
{3.12493e-06,2.37428e-05,4.86376e-05,3.99599e-05,2.16203e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.22965e-06,1.72573e-05,3.71693e-05,3.41396e-05,2.7226e-06}
{1.75842e-05,0.000130096,0.00024793,0.000173184,5.2326e-06}
{7.87916e-19,4.51167e-15,3.45038e-13,4.21016e-12,4.27583e-12}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.47293e-05,0.000264768,0.000547332,0.000458527,2.63325e-05}
{5.24339e-39,2.19217e-31,2.47912e-27,1.616e-24,3.18162e-22}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.12608e-05,8.71604e-05,0.000187742,0.000172468,1.37619e-05}
{9.28101e-14,5.90586e-11,1.39333e-09,7.40788e-09,3.62107e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.41675e-05,0.000104808,0.000199684,0.000139401,4.20307e-06}
{2.46335e-05,0.000183103,0.000353406,0.000254004,8.50351e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.32955e-14,8.50122e-12,2.03204e-10,1.11261e-09,6.04623e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.7264e-14,1.7516e-11,4.24061e-10,2.38715e-09,1.41804e-09}
{1.23786e-05,9.43291e-05,0.000194759,0.000162718,9.25836e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{9.26676e-15,5.7759e-12,1.28812e-10,6.03555e-10,1.87465e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.19747e-05,0.00024748,0.000533013,0.000489526,3.90171e-05}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.54785e-10,1.08127e-08,7.61205e-08,1.63619e-07,2.93711e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.5008e-05,0.000113987,0.000233277,0.000191239,1.02676e-05}
{4.98193e-15,3.1121e-12,6.98222e-11,3.3153e-10,1.07786e-10}
{2.21992e-06,1.69119e-05,3.48921e-05,2.91036e-05,1.64623e-06}
{8.45854e-11,5.90137e-09,4.14042e-08,8.83357e-08,1.54662e-08}
{3.34464e-11,2.33115e-09,1.63111e-08,3.4588e-08,5.92531e-09}
{1.95642e-10,1.36255e-08,9.514e-08,2.00819e-07,3.38523e-08}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.27771e-15,8.34046e-13,2.1083e-11,1.30735e-10,1.0959e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.73815e-11,1.91532e-09,1.35326e-08,2.93245e-08,5.4173e-09}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.19626e-10,2.22684e-08,1.55643e-07,3.29243e-07,5.59186e-08}
{7.69911e-11,5.36965e-09,3.76378e-08,8.01288e-08,1.39224e-08}
{2.13672e-14,1.37199e-11,3.31657e-10,1.86072e-09,1.09244e-09}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{5.33458e-15,3.48587e-12,8.83666e-11,5.51443e-10,4.72698e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{6.74215e-06,5.21852e-05,0.000112405,0.000103259,8.23922e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.0517e-05,7.77979e-05,0.000148201,0.000103425,3.11461e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{6.00141e-07,4.4396e-06,8.45807e-06,5.90397e-06,1.77943e-07}
{4.45879e-06,3.39685e-05,7.00847e-05,5.84619e-05,3.30764e-06}
{1.91291e-10,1.33757e-08,9.43976e-08,2.039e-07,3.69605e-08}
{1.40761e-13,8.81384e-11,1.99016e-09,9.58645e-09,3.28033e-09}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{4.09418e-11,2.78509e-09,1.82424e-08,3.33496e-08,3.34996e-09}
{7.67767e-10,5.37405e-08,3.80337e-07,8.26723e-07,1.5325e-07}
{3.82011e-24,2.06634e-19,5.8443e-17,2.19854e-15,1.32497e-14}
{6.70998e-06,5.19347e-05,0.000111858,0.00010274,8.19302e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.47848e-11,1.76075e-09,1.2973e-08,3.08603e-08,7.88997e-09}
{3.65875e-06,2.77798e-05,5.68029e-05,4.64769e-05,2.47842e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{5.04222e-19,2.88309e-15,2.19634e-13,2.65666e-12,2.61464e-12}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{2.0576e-16,1.3173e-13,3.15948e-12,1.74319e-11,9.73506e-12}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{8.82498e-15,5.50048e-12,1.22665e-10,5.74705e-10,1.78435e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.1203e-05,8.5351e-05,0.000176114,0.000146937,8.31898e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.80455e-19,2.82243e-15,2.31387e-13,3.3002e-12,5.86451e-12}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.00505e-29,1.49176e-23,1.44298e-20,1.40579e-18,2.73054e-17}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.50631e-11,1.75228e-09,1.23625e-08,2.66835e-08,4.82433e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.43336e-06,1.85388e-05,3.82532e-05,3.19158e-05,1.80705e-06}
{1.11474e-05,8.4949e-05,0.000175404,0.000146568,8.34413e-06}
{1.18757e-19,6.99384e-16,5.7718e-14,8.3489e-13,1.54633e-12}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{6.1054e-18,3.49213e-14,2.66262e-12,3.22683e-11,3.19612e-11}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.14952e-23,1.12825e-18,2.94116e-16,9.22044e-15,2.91678e-14}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{8.95501e-06,6.93111e-05,0.000149283,0.000137113,1.09339e-05}
{1.75641e-05,0.000133342,0.00027256,0.000222842,1.18504e-05}
{3.52974e-45,1.25377e-35,1.69764e-30,7.81291e-27,1.89714e-23}
{7.63739e-06,5.81979e-05,0.000120152,0.00010037,5.70871e-06}
{2.82773e-05,0.00021467,0.000438775,0.000358689,1.90631e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.03345e-25,5.66209e-21,1.65805e-18,6.74265e-17,5.36537e-16}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.40537e-05,0.000106697,0.000218118,0.000178374,9.49391e-06}
{3.76823e-14,2.363e-11,5.35729e-10,2.60446e-09,9.2247e-10}
{1.43796e-13,9.08119e-11,2.09879e-09,1.06537e-08,4.40841e-09}
{4.63768e-10,3.24274e-08,2.28836e-07,4.94206e-07,8.95257e-08}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.89568e-05,0.000295738,0.000604439,0.000494046,2.62395e-05}
{6.07551e-07,4.70292e-06,1.01322e-05,9.31253e-06,7.4443e-07}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{3.52025e-24,1.8978e-19,5.32011e-17,1.96355e-15,1.11642e-14}
{1.69126e-14,1.0853e-11,2.61919e-10,1.46402e-09,8.48185e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.0458e-05,7.73612e-05,0.000147369,0.000102844,3.0971e-06}
{1.20034e-13,7.67869e-11,1.83777e-09,1.00903e-08,5.53271e-09}
{1.52402e-09,1.03477e-07,6.74326e-07,1.21882e-06,1.17663e-07}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{4.39699e-41,1.68672e-32,6.51909e-28,1.09816e-24,6.87252e-22}
{9.56104e-21,5.50426e-17,4.27141e-15,5.3855e-14,6.14846e-14}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.79409e-10,1.27446e-08,9.38827e-08,2.23234e-07,5.69894e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.5613e-41,9.67587e-33,3.58766e-28,5.50998e-25,2.49682e-22}
{1.40395e-27,6.89189e-22,6.46723e-19,5.88758e-17,9.0015e-16}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.13154e-14,1.33807e-11,3.04236e-10,1.48872e-09,5.40077e-10}
{6.19339e-14,3.91751e-11,9.09288e-10,4.66053e-09,1.99724e-09}
{5.6245e-37,2.33309e-29,2.58288e-25,1.6056e-22,2.67759e-20}
{2.74766e-14,1.75769e-11,4.20666e-10,2.30958e-09,1.26639e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{2.42918e-06,1.88048e-05,4.05207e-05,3.72559e-05,2.98203e-06}
{1.20215e-50,3.87273e-40,1.7368e-34,1.927e-30,1.17162e-26}
{4.46711e-06,3.45752e-05,7.44687e-05,6.83986e-05,5.45464e-06}
{4.13624e-111,4.65897e-89,5.05059e-77,4.45538e-68,1.96085e-58}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.15176e-10,1.50528e-08,1.06367e-07,2.30404e-07,4.21909e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.138e-13,7.27514e-11,1.73812e-09,9.50597e-09,5.14271e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{6.11854e-06,4.6459e-05,9.50131e-05,7.77697e-05,4.1525e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{8.33924e-19,4.76824e-15,3.63234e-13,4.39334e-12,4.32277e-12}
{1.62318e-41,6.05773e-33,2.17308e-28,3.09888e-25,1.07698e-22}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{5.55167e-11,3.87029e-09,2.70972e-08,5.75414e-08,9.90961e-09}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.24337e-06,9.6263e-06,2.0749e-05,1.909e-05,1.5316e-06}
{4.71087e-18,2.69972e-14,2.06929e-12,2.53761e-11,2.62282e-11}
{3.82979e-10,2.72233e-08,2.00906e-07,4.79786e-07,1.24729e-07}
{2.48692e-05,0.000192484,0.00041457,0.000380756,3.03537e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.30138e-112,2.65713e-90,3.08032e-78,3.15759e-69,2.36938e-59}
{4.32104e-10,3.01022e-08,2.10348e-07,4.44745e-07,7.54219e-08}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{8.70385e-06,6.7364e-05,0.000145071,0.000133207,1.06118e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{8.95852e-06,6.82558e-05,0.000140865,0.000117575,6.66635e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.66581e-24,2.0099e-19,5.89727e-17,2.40864e-15,1.94516e-14}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.13357e-05,0.000157847,0.000300795,0.000210078,6.3435e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.25489e-05,9.7252e-05,0.000210192,0.000194563,1.59467e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.41826e-05,0.000104915,0.000199865,0.00013949,4.20179e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.79722e-09,1.27803e-07,9.44147e-07,2.2593e-06,5.89709e-07}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.22961e-06,1.72541e-05,3.71452e-05,3.40834e-05,2.70935e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{3.8475e-15,2.47488e-12,6.01155e-11,3.40939e-10,2.08044e-10}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.86824e-23,2.09364e-18,5.93117e-16,2.23933e-14,1.36674e-13}
{5.54522e-99,6.8966e-78,2.26638e-66,8.37634e-58,1.54268e-48}
{9.81776e-19,5.76846e-15,4.73133e-13,6.75544e-12,1.20526e-11}
{1.71903e-14,1.10125e-11,2.64582e-10,1.46519e-09,8.27781e-10}
{5.82684e-49,2.08427e-39,2.87643e-34,1.38166e-30,3.91138e-27}
{1.06416e-18,6.23346e-15,5.07059e-13,7.10702e-12,1.18734e-11}
{4.7872e-15,3.07188e-12,7.4128e-11,4.1426e-10,2.39839e-10}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.8586e-16,2.46805e-13,5.90475e-12,3.23967e-11,1.77352e-11}
{4.48332e-06,3.47021e-05,7.47505e-05,6.86749e-05,5.48163e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{2.16912e-14,1.41454e-11,3.56621e-10,2.19842e-09,1.80562e-09}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{8.06824e-06,6.15024e-05,0.000127094,0.000106397,6.0987e-06}
{8.06503e-06,6.12794e-05,0.000125547,0.000103178,5.59061e-06}
{4.24518e-15,2.64608e-12,5.90173e-11,2.76584e-10,8.5956e-11}
{5.74033e-24,3.11244e-19,8.86027e-17,3.38175e-15,2.14521e-14}
{7.92911e-33,3.54294e-26,1.11183e-22,2.49139e-20,1.01714e-18}
{1.39244e-10,9.77999e-09,6.98559e-08,1.54933e-07,3.07033e-08}
{6.24326e-07,4.83295e-06,1.04135e-05,9.57352e-06,7.66121e-07}
{7.71441e-20,4.41671e-16,3.37644e-14,4.11628e-13,4.16669e-13}
{4.56895e-15,2.92174e-12,6.98584e-11,3.82746e-10,2.08478e-10}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.00678e-27,4.99616e-22,4.82797e-19,4.69079e-17,8.97269e-16}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.88341e-05,0.000287297,0.000547435,0.000382261,1.15327e-05}
{4.43554e-24,2.39134e-19,6.70425e-17,2.47483e-15,1.40727e-14}
{8.07202e-07,6.16453e-06,1.28028e-05,1.08367e-05,6.44902e-07}
{1.76551e-10,1.25403e-08,9.23533e-08,2.19465e-07,5.59033e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.15863e-09,7.87054e-08,5.13561e-07,9.30965e-07,9.0843e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{6.14886e-06,4.66893e-05,9.54843e-05,7.81557e-05,4.17317e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.32543e-10,2.32615e-08,1.64337e-07,3.55802e-07,6.50314e-08}
{3.48442e-06,2.64535e-05,5.40767e-05,4.42201e-05,2.35312e-06}
{2.13894e-05,0.000162456,0.000332475,0.000272569,1.46344e-05}
{1.77234e-10,1.25896e-08,9.27325e-08,2.2045e-07,5.62307e-08}
{1.78137e-05,0.000131792,0.000251149,0.000175413,5.29788e-06}
{9.89683e-30,4.42574e-23,1.39191e-19,3.13429e-17,1.30211e-15}
{7.30123e-10,5.10675e-08,3.60686e-07,7.80449e-07,1.42333e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.82036e-11,2.66992e-09,1.88185e-08,4.05626e-08,7.36165e-09}
{2.40547e-06,1.86162e-05,4.00845e-05,3.67936e-05,2.92777e-06}
{2.55914e-15,1.67128e-12,4.22988e-11,2.63017e-10,2.22628e-10}
{3.13487e-06,2.42807e-05,5.23958e-05,4.83296e-05,3.9125e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.34399e-10,1.63303e-08,1.14133e-07,2.41412e-07,4.09957e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{7.99679e-18,4.68659e-14,3.81749e-12,5.36693e-11,9.06282e-11}
{5.08661e-38,2.15965e-30,2.54659e-26,1.82276e-23,5.00243e-21}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.50111e-06,2.5918e-05,4.94716e-05,3.468e-05,1.06115e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.06187e-05,8.06227e-05,0.000164844,0.000134859,7.1878e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{3.44916e-35,1.52735e-28,4.67714e-25,9.92017e-23,3.32624e-21}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{6.71634e-06,5.19854e-05,0.000111976,0.000102865,8.20801e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{2.51676e-11,1.7543e-09,1.22778e-08,2.60506e-08,4.47338e-09}
{1.20815e-23,6.54714e-19,1.86106e-16,7.07972e-15,4.43674e-14}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.1643e-14,7.26842e-12,1.6279e-10,7.7007e-10,2.47405e-10}
{2.70164e-15,1.72896e-12,4.14252e-11,2.28026e-10,1.26303e-10}
{1.63846e-104,2.39009e-85,6.4975e-75,3.32828e-67,4.58863e-59}
{3.0691e-19,1.81719e-15,1.52169e-13,2.27413e-12,4.72992e-12}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.76863e-05,0.000134793,0.000278404,0.000232786,1.32827e-05}
{5.87898e-32,2.60244e-25,7.96215e-22,1.68532e-19,5.60956e-18}
{2.24862e-10,1.52694e-08,9.95398e-08,1.80055e-07,1.74333e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.21241e-06,9.23601e-06,1.9053e-05,1.5888e-05,8.97961e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.18771e-09,2.17283e-07,1.43106e-06,2.64891e-06,2.7851e-07}
{6.87058e-12,4.8511e-10,3.51541e-09,8.06e-09,1.81419e-09}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.2388e-54,4.3638e-45,5.77775e-40,2.5308e-36,5.19862e-33}
{2.80246e-15,1.79682e-12,4.32647e-11,2.40683e-10,1.37627e-10}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.56833e-10,2.48618e-08,1.7379e-07,3.67732e-07,6.2522e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{8.62424e-06,6.57038e-05,0.000135569,0.0001131,6.40167e-06}
{8.95421e-06,6.82191e-05,0.000140767,0.000117452,6.65111e-06}
{1.10949e-15,7.0965e-13,1.69779e-11,9.31461e-11,5.09839e-11}
{5.58492e-26,2.96358e-21,7.95752e-19,2.6653e-17,1.06599e-16}
{1.55982e-75,3.28448e-60,6.96245e-52,9.17773e-46,2.00792e-39}
{1.88451e-68,4.71099e-55,8.53762e-48,1.67953e-42,3.58928e-37}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{5.54912e-11,3.86852e-09,2.70847e-08,5.75152e-08,9.90567e-09}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{4.48902e-10,3.18869e-08,2.34862e-07,5.58277e-07,1.4235e-07}
{2.19398e-26,1.05953e-20,9.51021e-18,7.83523e-16,8.3705e-15}
{1.33433e-19,8.03268e-16,7.03479e-14,1.16112e-12,3.40306e-12}
{1.58783e-05,0.000122776,0.000263728,0.000240778,1.8793e-05}
{4.87924e-06,3.7175e-05,7.67189e-05,6.40307e-05,3.62977e-06}
{3.00667e-18,1.73659e-14,1.35962e-12,1.74878e-11,2.14545e-11}
{4.60862e-15,2.95012e-12,7.07322e-11,3.89927e-10,2.1701e-10}
{6.633e-30,3.21313e-24,2.90823e-21,2.44099e-19,2.78345e-18}
{1.21816e-06,9.2831e-06,1.91686e-05,1.60187e-05,9.12227e-07}
{2.31799e-05,0.000176276,0.000361988,0.000299017,1.64833e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{8.33911e-10,5.6614e-08,3.68824e-07,6.66197e-07,6.41694e-08}
{3.48762e-06,2.64621e-05,5.40066e-05,4.40023e-05,2.31113e-06}
{3.67166e-19,2.10313e-15,1.60986e-13,1.96827e-12,2.01269e-12}
{1.75459e-05,0.000133204,0.000272278,0.000222612,1.18381e-05}
{1.40866e-05,0.000104205,0.000198512,0.000138546,4.17334e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.42266e-05,0.000108005,0.000220774,0.00018051,9.60083e-06}
{3.46963e-09,2.42655e-07,1.71338e-06,3.70498e-06,6.73886e-07}
{1.24342e-06,9.44324e-06,1.93222e-05,1.58338e-05,8.4899e-07}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.55241e-05,0.000118279,0.000244099,0.000203735,1.15498e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{9.70715e-07,7.41694e-06,1.54244e-05,1.3094e-05,7.86864e-07}
{2.19794e-15,1.43601e-12,3.63872e-11,2.26851e-10,1.93774e-10}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{5.00872e-05,0.000380226,0.000777071,0.00063505,3.37025e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.93003e-15,1.23073e-12,2.92025e-11,1.57302e-10,8.07542e-11}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.40855e-05,0.000104204,0.000198547,0.000138628,4.182e-06}
{1.41303e-05,0.000107285,0.00021936,0.00017946,9.56517e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.2051e-06,8.91549e-06,1.69888e-05,1.18641e-05,3.58162e-07}
{6.73554e-10,4.71037e-08,3.32554e-07,7.18903e-07,1.30653e-07}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.15566e-18,1.84107e-14,1.48138e-12,2.02606e-11,3.09912e-11}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.052e-05,7.98666e-05,0.000163259,0.000133491,7.10149e-06}
{3.28165e-10,2.28683e-08,1.59929e-07,3.38761e-07,5.78216e-08}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.39622e-06,2.63019e-05,5.67403e-05,5.23026e-05,4.22515e-06}
{1.57254e-09,1.06943e-07,6.99962e-07,1.27758e-06,1.27691e-07}
{3.04916e-06,2.36053e-05,5.08714e-05,4.67859e-05,3.74863e-06}
{5.99701e-10,4.17735e-08,2.91822e-07,6.16617e-07,1.04327e-07}
{5.75138e-05,0.000436608,0.000892317,0.000729257,3.87005e-05}
{4.21463e-34,1.94917e-27,6.71518e-24,1.8537e-21,1.5813e-19}
{6.53145e-16,4.19186e-13,1.012e-11,5.66136e-11,3.28997e-11}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.81035e-07,3.66998e-06,7.60163e-06,6.39644e-06,3.73118e-07}
{2.31825e-18,1.32597e-14,1.01097e-12,1.22515e-11,1.21373e-11}
{1.18593e-09,8.24897e-08,5.7401e-07,1.20227e-06,1.9708e-07}
{9.93507e-19,5.83446e-15,4.77895e-13,6.80282e-12,1.20101e-11}
{9.02041e-06,6.98217e-05,0.000150409,0.0001382,1.10357e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{4.44718e-06,3.38801e-05,6.99023e-05,5.83097e-05,3.29903e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{9.67238e-07,7.1768e-06,1.37844e-05,9.79665e-06,3.14129e-07}
{2.30357e-32,1.02244e-25,3.15083e-22,6.77792e-20,2.38924e-18}
{5.42653e-19,3.24805e-15,2.80113e-13,4.47175e-12,1.17671e-11}
{4.23813e-49,1.49362e-39,1.97976e-34,8.68668e-31,1.77971e-27}
{3.21907e-19,1.92235e-15,1.64755e-13,2.59375e-12,6.49646e-12}
{3.16453e-10,2.20514e-08,1.54202e-07,3.26568e-07,5.57043e-08}
{5.13849e-10,3.49146e-08,2.27983e-07,4.13955e-07,4.06462e-08}
{1.24022e-06,9.41863e-06,1.927e-05,1.57876e-05,8.45813e-07}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.15664e-15,2.66747e-12,6.43835e-11,3.60007e-10,2.08998e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.09933e-10,7.64968e-09,5.32883e-08,1.11886e-07,1.85068e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{4.05923e-14,2.5326e-11,5.66355e-10,2.67056e-09,8.50456e-10}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.28404e-06,1.70183e-05,3.3053e-05,2.40614e-05,8.32378e-07}
{2.75327e-30,1.38589e-24,1.39191e-21,1.47449e-19,3.83809e-18}
{3.36022e-119,2.98559e-94,1.36757e-80,2.36494e-70,5.26017e-59}
{1.29701e-98,2.15519e-80,1.93259e-70,5.00842e-63,5.61763e-55}
{3.97305e-12,2.73307e-10,1.84533e-09,3.61103e-09,4.62446e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{8.99545e-06,6.8535e-05,0.000141428,0.000118021,6.68684e-06}
{7.35799e-40,3.08635e-32,3.52145e-28,2.3412e-25,4.93817e-23}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.62442e-07,1.20225e-06,2.29341e-06,1.60553e-06,4.89051e-08}
{5.2266e-24,2.86135e-19,8.36142e-17,3.38417e-15,2.64668e-14}
{8.59716e-25,4.63065e-20,1.29493e-17,4.75304e-16,2.6487e-15}
{1.18002e-27,6.20137e-23,1.62203e-20,5.12351e-19,1.66515e-18}
{7.88205e-15,5.04103e-12,1.20573e-10,6.61153e-10,3.61327e-10}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.76278e-20,1.03475e-16,8.46535e-15,1.20184e-13,2.10251e-13}
{1.40181e-05,0.000106423,0.000217539,0.000177866,9.46029e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.23804e-14,7.95686e-12,1.92829e-10,1.08796e-09,6.5172e-10}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.44466e-06,1.86262e-05,3.84409e-05,3.20865e-05,1.8197e-06}
{6.47302e-14,4.21957e-11,1.06268e-09,6.5354e-09,5.32166e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.54626e-10,1.78244e-08,1.26192e-07,2.7465e-07,5.14509e-08}
{1.76292e-05,0.000133843,0.000273623,0.000223782,1.19136e-05}
{7.54579e-10,5.25796e-08,3.67648e-07,7.78422e-07,1.3264e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.37149e-23,7.20219e-19,1.87997e-16,5.91102e-15,1.88948e-14}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.87332e-06,1.42291e-05,2.91255e-05,2.38868e-05,1.28448e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{6.13575e-06,4.65897e-05,9.52806e-05,7.79888e-05,4.16428e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{4.01728e-16,2.59505e-13,6.37643e-12,3.71146e-11,2.48902e-11}
{2.55564e-18,1.52887e-14,1.31662e-12,2.0951e-11,5.44982e-11}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{4.25145e-19,2.43727e-15,1.86989e-13,2.29801e-12,2.3945e-12}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.76584e-10,1.25427e-08,9.23709e-08,2.19507e-07,5.59139e-08}
{1.11309e-19,6.53196e-16,5.33978e-14,7.56804e-13,1.31591e-12}
{1.25527e-53,4.06773e-43,1.85338e-37,2.12936e-33,1.45689e-29}
{1.20754e-19,7.19281e-16,6.12213e-14,9.48986e-13,2.24855e-12}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.94573e-10,1.36134e-08,9.62326e-08,2.0862e-07,3.82945e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.51548e-45,5.34408e-36,7.09483e-31,3.12389e-27,6.47252e-24}
{1.30601e-28,6.48331e-23,6.27132e-20,6.10985e-18,1.1869e-16}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{2.72341e-23,1.43179e-18,3.74886e-16,1.18688e-14,3.8884e-14}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.75954e-18,1.04796e-14,8.91672e-13,1.38118e-11,3.265e-11}
{4.66028e-10,3.2585e-08,2.29941e-07,4.96555e-07,8.99276e-08}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.77197e-05,0.000134527,0.000275001,0.000224873,1.19649e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{4.18443e-06,3.2418e-05,7.00028e-05,6.46684e-05,5.26338e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.48251e-06,3.46857e-05,7.46568e-05,6.84684e-05,5.43104e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.34448e-16,8.77222e-14,2.2147e-12,1.36965e-11,1.13834e-11}
{1.16732e-16,7.49655e-14,1.81295e-12,1.01815e-11,6.00045e-12}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{8.41948e-10,5.71863e-08,3.73025e-07,6.75703e-07,6.57491e-08}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.47293e-05,0.000264768,0.000547332,0.000458527,2.63325e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.0521e-05,0.000158831,0.000342088,0.000314191,2.50497e-05}
{2.0478e-05,0.000156029,0.000322037,0.000268842,1.52516e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.52748e-06,2.67941e-05,5.48486e-05,4.49901e-05,2.42048e-06}
{1.27872e-15,8.18884e-13,1.96558e-11,1.08635e-10,6.10262e-11}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.24648e-18,7.31552e-15,5.98207e-13,8.48371e-12,1.47818e-11}
{8.74647e-06,6.66457e-05,0.000137573,0.000114885,6.52569e-06}
{1.49611e-05,0.000110758,0.000211437,0.000148262,4.54286e-06}
{7.40589e-20,4.35427e-16,3.57775e-14,5.12778e-13,9.25381e-13}
{1.05104e-05,7.97932e-05,0.000163109,0.000133368,7.09493e-06}
{9.95621e-24,5.34367e-19,1.47989e-16,5.31277e-15,2.72278e-14}
{1.05094e-15,6.85308e-13,1.72752e-11,1.06465e-10,8.73784e-11}
{1.75467e-05,0.000129802,0.000247284,0.000172597,5.20029e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.33682e-22,7.03183e-18,1.84381e-15,5.85628e-14,1.94052e-13}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.40728e-05,0.000106838,0.000218388,0.00017856,9.49718e-06}
{6.97993e-06,5.2991e-05,0.000108323,8.85752e-05,4.71269e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{7.95667e-06,6.02903e-05,0.000122602,9.90832e-05,5.05484e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.11438e-05,0.000160517,0.000328102,0.000268241,1.42619e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{6.80697e-10,4.62317e-08,3.01527e-07,5.46024e-07,5.30722e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{7.83936e-14,4.88463e-11,1.08839e-09,5.08955e-09,1.56942e-09}
{8.35503e-32,3.69645e-25,1.12921e-21,2.38206e-19,7.83387e-18}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{7.00704e-06,5.31811e-05,0.000108624,8.86617e-05,4.6869e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.83067e-05,0.000209407,0.000398978,0.000278538,8.39813e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.8344e-05,0.000139263,0.000284662,0.000232735,1.23759e-05}
{1.21599e-06,9.26388e-06,1.91138e-05,1.59445e-05,9.02223e-07}
{5.02161e-11,3.51105e-09,2.47745e-08,5.34926e-08,9.68411e-09}
{7.8518e-19,4.63839e-15,3.86014e-13,5.68955e-12,1.12669e-11}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.59889e-40,5.98234e-32,2.16098e-27,3.13009e-24,1.15059e-21}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.77613e-05,0.00013484,0.000275621,0.000225344,1.19833e-05}
{8.40748e-34,3.82103e-27,1.25563e-23,3.11917e-21,1.83642e-19}
{6.22759e-16,3.99634e-13,9.64483e-12,5.3916e-11,3.12575e-11}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.57474e-09,1.07995e-07,7.23147e-07,1.38929e-06,1.66957e-07}
{2.20274e-15,1.43682e-12,3.62484e-11,2.23793e-10,1.84773e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{5.01693e-11,3.51273e-09,2.48812e-08,5.41825e-08,1.01064e-08}
{6.57869e-11,4.67271e-09,3.44102e-08,8.17602e-08,2.08168e-08}
{6.99272e-06,5.17457e-05,9.8668e-05,6.9006e-05,2.09416e-06}
{1.12319e-09,7.83119e-08,5.48468e-07,1.16552e-06,2.01177e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{6.96606e-06,5.28857e-05,0.000108108,8.83992e-05,4.70334e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.3924e-15,1.53661e-12,3.71745e-11,2.08933e-10,1.23444e-10}
{6.19e-07,4.70017e-06,9.6123e-06,7.86787e-06,4.20131e-07}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.32821e-10,2.36401e-08,1.74097e-07,4.13715e-07,1.05381e-07}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.39814e-05,0.00010613,0.000216862,0.000177167,9.39549e-06}
{7.04164e-06,5.35128e-05,0.000109685,9.02315e-05,4.90376e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{4.46788e-06,3.45811e-05,7.44815e-05,6.84103e-05,5.45554e-06}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{3.08034e-09,2.14576e-07,1.49913e-06,3.16825e-06,5.36212e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{8.93401e-06,6.80638e-05,0.000140439,0.000117164,6.63191e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.26679e-18,7.57123e-15,6.50342e-13,1.02897e-11,2.6235e-11}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.68453e-06,2.80797e-05,5.79889e-05,4.84741e-05,2.7635e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.96574e-05,0.000149419,0.000306447,0.000252422,1.37764e-05}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.67566e-06,2.80042e-05,5.77886e-05,4.82231e-05,2.73204e-06}
{9.7782e-41,4.13636e-33,4.82919e-29,3.38082e-26,8.58654e-24}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.75587e-06,2.90946e-05,6.28072e-05,5.79813e-05,4.70753e-06}
{1.37335e-09,9.75753e-08,7.19122e-07,1.71166e-06,4.38372e-07}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.76875e-11,3.32336e-09,2.32464e-08,4.92622e-08,8.42213e-09}
{1.77613e-05,0.00013484,0.000275621,0.000225344,1.19833e-05}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.39794e-14,9.12491e-12,2.3064e-10,1.42998e-09,1.19871e-09}
{1.39636e-05,0.000103294,0.000196777,0.000137335,4.1368e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{9.13787e-10,6.36855e-08,4.45534e-07,9.44438e-07,1.61627e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{8.94766e-06,6.81678e-05,0.000140654,0.000117343,6.64205e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{8.21369e-22,4.333e-17,1.14509e-14,3.70156e-13,1.30628e-12}
{1.04552e-05,7.73408e-05,0.00014733,0.000102817,3.09628e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{3.36141e-10,2.35117e-08,1.66076e-07,3.59418e-07,6.5586e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{4.72256e-15,3.02308e-12,7.24845e-11,3.9965e-10,2.22708e-10}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.05396e-05,7.80278e-05,0.000148966,0.000104471,3.2016e-06}
{6.0991e-07,4.51662e-06,8.62942e-06,6.0623e-06,1.8695e-07}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{1.15751e-10,8.08599e-09,5.69227e-08,1.22304e-07,2.18393e-08}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.42576e-06,1.79491e-05,3.42176e-05,2.39194e-05,7.24657e-07}
{7.70261e-37,3.25686e-29,3.79761e-25,2.65097e-22,6.65769e-20}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{7.35259e-06,5.60227e-05,0.000115633,9.6542e-05,5.47947e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{5.4337e-05,0.00040233,0.00076839,0.000539305,1.65656e-05}
{5.49948e-37,2.28107e-29,2.52505e-25,1.57004e-22,2.63435e-20}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.5406e-10,2.51492e-08,1.85222e-07,4.40205e-07,1.12177e-07}
{3.4989e-13,2.1808e-10,4.86324e-09,2.27827e-08,7.06663e-09}
{3.04916e-06,2.36053e-05,5.08714e-05,4.67859e-05,3.74863e-06}
{3.67157e-05,0.000284178,0.000612075,0.000562179,4.48158e-05}
{3.55574e-05,0.000269934,0.000551709,0.000450967,2.39567e-05}
{1.05002e-05,7.97144e-05,0.000162939,0.000133214,7.08361e-06}
{6.90453e-50,2.60524e-41,9.62765e-37,1.46672e-33,6.41538e-31}
{8.08215e-07,6.17228e-06,1.2819e-05,1.08506e-05,6.4577e-07}
{1.23734e-05,9.3968e-05,0.000192254,0.000157509,8.43697e-06}
{1.05586e-05,8.01593e-05,0.000163857,0.000133979,7.12726e-06}
{5.22193e-19,3.06592e-15,2.50968e-13,3.56739e-12,6.26419e-12}
{3.20731e-15,2.05111e-12,4.90486e-11,2.68818e-10,1.46592e-10}
{1.22137e-06,9.30486e-06,1.91983e-05,1.60151e-05,9.06219e-07}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{7.23733e-10,5.14068e-08,3.78591e-07,8.99671e-07,2.29096e-07}
{1.35214e-05,0.000103015,0.000212568,0.000177363,1.00439e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{1.46572e-13,9.13617e-11,2.03774e-09,9.54994e-09,2.9666e-09}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{3.48442e-06,2.64535e-05,5.40767e-05,4.42201e-05,2.35312e-06}
{1.31893e-31,5.96386e-25,1.933e-21,4.65721e-19,2.4653e-17}
{6.72747e-06,5.20716e-05,0.000112161,0.000103036,8.22169e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{5.49791e-06,4.06975e-05,7.76703e-05,5.4429e-05,1.66361e-06}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{3.66608e-06,2.78354e-05,5.69167e-05,4.65701e-05,2.48341e-06}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{1.34593e-18,7.71704e-15,5.9227e-13,7.28354e-12,7.59527e-12}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.219889,0.177239,0.0987326,0.026625,0.000250802}
{4.44409e-24,2.3342e-19,6.09605e-17,1.91895e-15,6.15931e-15}
{1.21042e-14,7.75353e-12,1.86241e-10,1.0309e-09,5.81975e-10}
{7.04164e-06,5.35128e-05,0.000109685,9.02315e-05,4.90376e-06}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{5.4337e-05,0.00040233,0.00076839,0.000539305,1.65656e-05}
{0.226709,0.191207,0.120442,0.042757,0.00106745}
{2.87681e-24,1.55105e-19,4.34896e-17,1.60577e-15,9.13622e-15}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{0.216283,0.179544,0.108331,0.0349219,0.000618225}
{2.62623e-11,1.83271e-09,1.28668e-08,2.74918e-08,4.8392e-09}
{3.21725e-07,2.38227e-06,4.55034e-06,3.19471e-06,9.82778e-08}
{0.314118,0.259864,0.155361,0.0491047,0.000818123}
{1.64493e-09,1.11716e-07,7.28535e-07,1.31892e-06,1.28073e-07}
};


exepectedRateClassAssignments =
{{                 0,                 3,                 3,                 0,                 2,                 4,                 0,                 3,                 0,                 0,                 2,                 3,                 0,                 2,                 2,                 0,                 0,                 0,                 2,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 3,                 2,                 0,                 0,                 0,                 0,                 4,                 2,                 0,                 3,                 0,                 0,                 0,                 4,                 2,                 3,                 0,                 0,                 4,                 0,                 2,                 4,                 0,                 0,                 0,                 2,                 0,                 2,                 0,                 0,                 3,                 0,                 2,                 0,                 0,                 3,                 3,                 2,                 0,                 2,                 0,                 0,                 3,                 0,                 0,                 2,                 0,                 0,                 2,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 3,                 2,                 2,                 2,                 0,                 2,                 4,                 0,                 0,                 4,                 2,                 0,                 0,                 0,                 2,                 3,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 4,                 0,                 2,                 2,                 0,                 4,                 2,                 0,                 3,                 2,                 4,                 4,                 0,                 3,                 3,                 3,                 0,                 0,                 2,                 3,                 2,                 0,                 2,                 0,                 3,                 4,                 3,                 2,                 0,                 2,                 0,                 0,                 4,                 3,                 3,                 2,                 2,                 2,                 2,                 0,                 2,                 2,                 0,                 0,                 3,                 3,                 3,                 3,                 0,                 0,                 2,                 2,                 2,                 3,                 0,                 0,                 0,                 0,                 0,                 4,                 3,                 3,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 2,                 3,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 2,                 0,                 0,                 3,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 2,                 0,                 3,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 2,                 4,                 0,                 0,                 0,                 2,                 4,                 0,                 0,                 0,                 0,                 2,                 3,                 0,                 2,                 2,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 2,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 2,                 0,                 0,                 3,                 0,                 0,                 0,                 2,                 3,                 2,                 3,                 3,                 3,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 3,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 2,                 2,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 4,                 2,                 0,                 0,                 0,                 0,                 3,                 2,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 0,                 3,                 0,                 2,                 2,                 4,                 0,                 3,                 0,                 0,                 4,                 0,                 0,                 2,                 2,                 4,                 2,                 2,                 0,                 4,                 0,                 0,                 2,                 3,                 3,                 3,                 0,                 0,                 0,                 0,                 2,                 2,                 0,                 0,                 0,                 4,                 3,                 0,                 0,                 2,                 3,                 3,                 0,                 4,                 4,                 0,                 3,                 0,                 0,                 0,                 4,                 4,                 0,                 0,                 0,                 3,                 3,                 4,                 3,                 0,                 0,                 0,                 2,                 4,                 2,                 4,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 2,                 0,                 3,                 4,                 0,                 3,                 0,                 0,                 2,                 4,                 3,                 2,                 0,                 0,                 4,                 3,                 0,                 2,                 0,                 0,                 2,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 2,                 0,                 2,                 0,                 2,                 0,                 0,                 3,                 0,                 0,                 0,                 2,                 0,                 0,                 3,                 0,                 4,                 4,                 4,                 3,                 4,                 4,                 3,                 0,                 0,                 3,                 2,                 0,                 3,                 0,                 2,                 2,                 3,                 4,                 4,                 3,                 2,                 4,                 3,                 0,                 4,                 0,                 0,                 2,                 4,                 2,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 2,                 0,                 3,                 2,                 2,                 3,                 2,                 4,                 3,                 0,                 0,                 3,                 2,                 3,                 2,                 0,                 3,                 0,                 0,                 0,                 4,                 4,                 0,                 2,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 2,                 0,                 3,                 4,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 4,                 4,                 0,                 2,                 4,                 3,                 0,                 2,                 0,                 3,                 3,                 0,                 4,                 3,                 0,                 0,                 3,                 0,                 2,                 2,                 3,                 4,                 4,                 4,                 0,                 3,                 0,                 0,                 3,                 4,                 4,                 2,                 2,                 4,                 3,                 4,                 2,                 2,                 0,                 0,                 0,                 0,                 0,                 3,                 2,                 4,                 2,                 2,                 0,                 0,                 2,                 3,                 2,                 0,                 0,                 2,                 0,                 2,                 3,                 0,                 0,                 0,                 2,                 0,                 3,                 0,                 2,                 2,                 0,                 2,                 3,                 0,                 0,                 4,                 0,                 2,                 3,                 0,                 2,                 3,                 2,                 3,                 2,                 4,                 3,                 0,                 2,                 3,                 3,                 4,                 2,                 0,                 0,                 2,                 0,                 2,                 4,                 4,                 4,                 4,                 3,                 3,                 2,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 2,                 4,                 4,                 4,                 3,                 0,                 2,                 4,                 0,                 2,                 4,                 4,                 4,                 3,                 0,                 0,                 4,                 2,                 0,                 3,                 0,                 0,                 2,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 2,                 3,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 2,                 0,                 0,                 3,                 4,                 0,                 4,                 0,                 0,                 3,                 4,                 4,                 4,                 0,                 0,                 3,                 0,                 4,                 4,                 0,                 0,                 4,                 0,                 0,                 4,                 3,                 0,                 0,                 2,                 0,                 2,                 0,                 0,                 2,                 0,                 0,                 3,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 2,                 2,                 0,                 0,                 2,                 3,                 0,                 4,                 2,                 2,                 4,                 2,                 4,                 3,                 2,                 0,                 4,                 0,                 0,                 2,                 2,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 2,                 0,                 0,                 3,                 0,                 3,                 4,                 0,                 0,                 2,                 0,                 0,                 0,                 2,                 0,                 2,                 2,                 3,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 2,                 4,                 3,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 3,                 3,                 2,                 3,                 0,                 0,                 0,                 0,                 2,                 0,                 3,                 2,                 0,                 3,                 0,                 0,                 2,                 2,                 0,                 2,                 0,                 0,                 3,                 0,                 0,                 2,                 0,                 0,                 4,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 2,                 4,                 0,                 2,                 3,                 0,                 3,                 2,                 0,                 0,                 3,                 2,                 0,                 3,                 0,                 0,                 2,                 0,                 4,                 2,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 2,                 2,                 0,                 3,                 0,                 2,                 4,                 0,                 0,                 2,                 0,                 2,                 4,                 0,                 0,                 3,                 3,                 2,                 2,                 2,                 2,                 4,                 2,                 2,                 2,                 4,                 3,                 2,                 0,                 0,                 3,                 2,                 0,                 3,                 0,                 2,                 4,                 2,                 0,                 0,                 2,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 3,                 2,                 0,                 2,                 0,                 4,                 0,                 0,                 3,                 2,                 0,                 3}
};


ExecuteAFile ("../Shared/REL_utils.bf");
marginalErrors = checkMarginalReconstruction ( expectedConditionalProbabilities, exepectedRateClassAssignments, "flu_LF");

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult (Abs (res_flu_LF[1][0] - _expectedLL) < 0.01 && marginalErrors[0] < 0.0001 && marginalErrors[1] == 0))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */