/* Copyright (c) 2001-2019, The HSQL Development Group
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the HSQL Development Group nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL HSQL DEVELOPMENT GROUP, HSQLDB.ORG,
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


package org.hsqldb.scriptio;

import org.hsqldb.Database;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowInsertInterface;

/**
 * Base class for all script readers.
 *
 * @author Fred Toussi (fredt@users dot sourceforge.net)
 * @version 2.5.0
 * @since 1.7.2
 */
public abstract class ScriptReaderBase {

    Database           database;
    String             fileNamePath;
    long               lineCount;
    RowInsertInterface inserter;

    ScriptReaderBase(Database db, String fileName) {
        this.database     = db;
        this.fileNamePath = fileName;
    }

    public void setInserter(RowInsertInterface inserter) {
        this.inserter = inserter;
    }

    public abstract void readAll(Session session);

    protected abstract void readDDL(Session session);

    protected abstract void readExistingData(Session session);

    public abstract boolean readLoggedStatement(Session session);

    int                            statementType;
    int                            sessionNumber;
    boolean                        sessionChanged;
    Object[]                       rowData;
    long                           sequenceValue;
    String                         rawStatement;
    String                         statement;
    Table                          currentTable;
    PersistentStore                currentStore;
    NumberSequence                 currentSequence;
    String                         currentSchema;
    RowInsertInterface.ErrorLogger errorLogger;

    public String getFileNamePath() {
        return fileNamePath;
    }

    public int getStatementType() {
        return statementType;
    }

    public int getSessionNumber() {
        return sessionNumber;
    }

    public Object[] getData() {
        return rowData;
    }

    public String getLoggedStatement() {
        return statement;
    }

    public Table getCurrentTable() {
        return currentTable;
    }

    public String getCurrentSchema() {
        return currentSchema;
    }

    public long getLineNumber() {
        return lineCount;
    }

    public abstract void close();
}
