/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package thrift

// Autogenerated by Thrift Compiler (1.0.0-dev)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

/* THE FOLLOWING THRIFT FILE WAS USED TO CREATE THIS

enum TestEnum {
	FIRST = 1,
	SECOND = 2,
	THIRD = 3,
	FOURTH = 4,
}

struct TestStruct {
	1: bool on,
	2: byte b,
	3: i16 int16,
	4: i32 int32,
	5: i64 int64,
	6: double d,
	7: string st,
	8: binary bin,
	9: map<string, string> stringMap,
	10: list<string> stringList,
	11: set<string> stringSet,
	12: TestEnum e,
}
*/

import (
	"fmt"
)

// (needed to ensure safety because of naive import list construction.)
var _ = ZERO
var _ = fmt.Printf

var GoUnusedProtection__ int

type TestEnum int64

const (
	TestEnum_FIRST  TestEnum = 1
	TestEnum_SECOND TestEnum = 2
	TestEnum_THIRD  TestEnum = 3
	TestEnum_FOURTH TestEnum = 4
)

func (p TestEnum) String() string {
	switch p {
	case TestEnum_FIRST:
		return "FIRST"
	case TestEnum_SECOND:
		return "SECOND"
	case TestEnum_THIRD:
		return "THIRD"
	case TestEnum_FOURTH:
		return "FOURTH"
	}
	return "<UNSET>"
}

func TestEnumFromString(s string) (TestEnum, error) {
	switch s {
	case "FIRST":
		return TestEnum_FIRST, nil
	case "SECOND":
		return TestEnum_SECOND, nil
	case "THIRD":
		return TestEnum_THIRD, nil
	case "FOURTH":
		return TestEnum_FOURTH, nil
	}
	return TestEnum(0), fmt.Errorf("not a valid TestEnum string")
}

func TestEnumPtr(v TestEnum) *TestEnum { return &v }

type TestStruct struct {
	On         bool              `thrift:"on,1" json:"on"`
	B          int8              `thrift:"b,2" json:"b"`
	Int16      int16             `thrift:"int16,3" json:"int16"`
	Int32      int32             `thrift:"int32,4" json:"int32"`
	Int64      int64             `thrift:"int64,5" json:"int64"`
	D          float64           `thrift:"d,6" json:"d"`
	St         string            `thrift:"st,7" json:"st"`
	Bin        []byte            `thrift:"bin,8" json:"bin"`
	StringMap  map[string]string `thrift:"stringMap,9" json:"stringMap"`
	StringList []string          `thrift:"stringList,10" json:"stringList"`
	StringSet  map[string]bool   `thrift:"stringSet,11" json:"stringSet"`
	E          TestEnum          `thrift:"e,12" json:"e"`
}

func NewTestStruct() *TestStruct {
	return &TestStruct{}
}

func (p *TestStruct) GetOn() bool {
	return p.On
}

func (p *TestStruct) GetB() int8 {
	return p.B
}

func (p *TestStruct) GetInt16() int16 {
	return p.Int16
}

func (p *TestStruct) GetInt32() int32 {
	return p.Int32
}

func (p *TestStruct) GetInt64() int64 {
	return p.Int64
}

func (p *TestStruct) GetD() float64 {
	return p.D
}

func (p *TestStruct) GetSt() string {
	return p.St
}

func (p *TestStruct) GetBin() []byte {
	return p.Bin
}

func (p *TestStruct) GetStringMap() map[string]string {
	return p.StringMap
}

func (p *TestStruct) GetStringList() []string {
	return p.StringList
}

func (p *TestStruct) GetStringSet() map[string]bool {
	return p.StringSet
}

func (p *TestStruct) GetE() TestEnum {
	return p.E
}
func (p *TestStruct) Read(iprot TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return PrependError(fmt.Sprintf("%T read error: ", p), err)
	}
	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		case 8:
			if err := p.ReadField8(iprot); err != nil {
				return err
			}
		case 9:
			if err := p.ReadField9(iprot); err != nil {
				return err
			}
		case 10:
			if err := p.ReadField10(iprot); err != nil {
				return err
			}
		case 11:
			if err := p.ReadField11(iprot); err != nil {
				return err
			}
		case 12:
			if err := p.ReadField12(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TestStruct) ReadField1(iprot TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return PrependError("error reading field 1: ", err)
	} else {
		p.On = v
	}
	return nil
}

func (p *TestStruct) ReadField2(iprot TProtocol) error {
	if v, err := iprot.ReadByte(); err != nil {
		return PrependError("error reading field 2: ", err)
	} else {
		temp := int8(v)
		p.B = temp
	}
	return nil
}

func (p *TestStruct) ReadField3(iprot TProtocol) error {
	if v, err := iprot.ReadI16(); err != nil {
		return PrependError("error reading field 3: ", err)
	} else {
		p.Int16 = v
	}
	return nil
}

func (p *TestStruct) ReadField4(iprot TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return PrependError("error reading field 4: ", err)
	} else {
		p.Int32 = v
	}
	return nil
}

func (p *TestStruct) ReadField5(iprot TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return PrependError("error reading field 5: ", err)
	} else {
		p.Int64 = v
	}
	return nil
}

func (p *TestStruct) ReadField6(iprot TProtocol) error {
	if v, err := iprot.ReadDouble(); err != nil {
		return PrependError("error reading field 6: ", err)
	} else {
		p.D = v
	}
	return nil
}

func (p *TestStruct) ReadField7(iprot TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return PrependError("error reading field 7: ", err)
	} else {
		p.St = v
	}
	return nil
}

func (p *TestStruct) ReadField8(iprot TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return PrependError("error reading field 8: ", err)
	} else {
		p.Bin = v
	}
	return nil
}

func (p *TestStruct) ReadField9(iprot TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]string, size)
	p.StringMap = tMap
	for i := 0; i < size; i++ {
		var _key0 string
		if v, err := iprot.ReadString(); err != nil {
			return PrependError("error reading field 0: ", err)
		} else {
			_key0 = v
		}
		var _val1 string
		if v, err := iprot.ReadString(); err != nil {
			return PrependError("error reading field 0: ", err)
		} else {
			_val1 = v
		}
		p.StringMap[_key0] = _val1
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TestStruct) ReadField10(iprot TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.StringList = tSlice
	for i := 0; i < size; i++ {
		var _elem2 string
		if v, err := iprot.ReadString(); err != nil {
			return PrependError("error reading field 0: ", err)
		} else {
			_elem2 = v
		}
		p.StringList = append(p.StringList, _elem2)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TestStruct) ReadField11(iprot TProtocol) error {
	_, size, err := iprot.ReadSetBegin()
	if err != nil {
		return PrependError("error reading set begin: ", err)
	}
	tSet := make(map[string]bool, size)
	p.StringSet = tSet
	for i := 0; i < size; i++ {
		var _elem3 string
		if v, err := iprot.ReadString(); err != nil {
			return PrependError("error reading field 0: ", err)
		} else {
			_elem3 = v
		}
		p.StringSet[_elem3] = true
	}
	if err := iprot.ReadSetEnd(); err != nil {
		return PrependError("error reading set end: ", err)
	}
	return nil
}

func (p *TestStruct) ReadField12(iprot TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return PrependError("error reading field 12: ", err)
	} else {
		temp := TestEnum(v)
		p.E = temp
	}
	return nil
}

func (p *TestStruct) Write(oprot TProtocol) error {
	if err := oprot.WriteStructBegin("TestStruct"); err != nil {
		return PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if err := p.writeField1(oprot); err != nil {
		return err
	}
	if err := p.writeField2(oprot); err != nil {
		return err
	}
	if err := p.writeField3(oprot); err != nil {
		return err
	}
	if err := p.writeField4(oprot); err != nil {
		return err
	}
	if err := p.writeField5(oprot); err != nil {
		return err
	}
	if err := p.writeField6(oprot); err != nil {
		return err
	}
	if err := p.writeField7(oprot); err != nil {
		return err
	}
	if err := p.writeField8(oprot); err != nil {
		return err
	}
	if err := p.writeField9(oprot); err != nil {
		return err
	}
	if err := p.writeField10(oprot); err != nil {
		return err
	}
	if err := p.writeField11(oprot); err != nil {
		return err
	}
	if err := p.writeField12(oprot); err != nil {
		return err
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TestStruct) writeField1(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("on", BOOL, 1); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 1:on: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.On)); err != nil {
		return PrependError(fmt.Sprintf("%T.on (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 1:on: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField2(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("b", BYTE, 2); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 2:b: ", p), err)
	}
	if err := oprot.WriteByte(byte(p.B)); err != nil {
		return PrependError(fmt.Sprintf("%T.b (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 2:b: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField3(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("int16", I16, 3); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 3:int16: ", p), err)
	}
	if err := oprot.WriteI16(int16(p.Int16)); err != nil {
		return PrependError(fmt.Sprintf("%T.int16 (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 3:int16: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField4(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("int32", I32, 4); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 4:int32: ", p), err)
	}
	if err := oprot.WriteI32(int32(p.Int32)); err != nil {
		return PrependError(fmt.Sprintf("%T.int32 (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 4:int32: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField5(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("int64", I64, 5); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 5:int64: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.Int64)); err != nil {
		return PrependError(fmt.Sprintf("%T.int64 (5) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 5:int64: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField6(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("d", DOUBLE, 6); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 6:d: ", p), err)
	}
	if err := oprot.WriteDouble(float64(p.D)); err != nil {
		return PrependError(fmt.Sprintf("%T.d (6) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 6:d: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField7(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("st", STRING, 7); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 7:st: ", p), err)
	}
	if err := oprot.WriteString(string(p.St)); err != nil {
		return PrependError(fmt.Sprintf("%T.st (7) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 7:st: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField8(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("bin", STRING, 8); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 8:bin: ", p), err)
	}
	if err := oprot.WriteBinary(p.Bin); err != nil {
		return PrependError(fmt.Sprintf("%T.bin (8) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 8:bin: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField9(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("stringMap", MAP, 9); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 9:stringMap: ", p), err)
	}
	if err := oprot.WriteMapBegin(STRING, STRING, len(p.StringMap)); err != nil {
		return PrependError("error writing map begin: ", err)
	}
	for k, v := range p.StringMap {
		if err := oprot.WriteString(string(k)); err != nil {
			return PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
		if err := oprot.WriteString(string(v)); err != nil {
			return PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return PrependError("error writing map end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 9:stringMap: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField10(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("stringList", LIST, 10); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 10:stringList: ", p), err)
	}
	if err := oprot.WriteListBegin(STRING, len(p.StringList)); err != nil {
		return PrependError("error writing list begin: ", err)
	}
	for _, v := range p.StringList {
		if err := oprot.WriteString(string(v)); err != nil {
			return PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 10:stringList: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField11(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("stringSet", SET, 11); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 11:stringSet: ", p), err)
	}
	if err := oprot.WriteSetBegin(STRING, len(p.StringSet)); err != nil {
		return PrependError("error writing set begin: ", err)
	}
	for v, _ := range p.StringSet {
		if err := oprot.WriteString(string(v)); err != nil {
			return PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteSetEnd(); err != nil {
		return PrependError("error writing set end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 11:stringSet: ", p), err)
	}
	return err
}

func (p *TestStruct) writeField12(oprot TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("e", I32, 12); err != nil {
		return PrependError(fmt.Sprintf("%T write field begin error 12:e: ", p), err)
	}
	if err := oprot.WriteI32(int32(p.E)); err != nil {
		return PrependError(fmt.Sprintf("%T.e (12) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return PrependError(fmt.Sprintf("%T write field end error 12:e: ", p), err)
	}
	return err
}

func (p *TestStruct) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TestStruct(%+v)", *p)
}
