package recoveryservicesbackup

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// BackupItemType enumerates the values for backup item type.
type BackupItemType string

const (
	// AzureSQLDb specifies the azure sql db state for backup item type.
	AzureSQLDb BackupItemType = "AzureSqlDb"
	// Client specifies the client state for backup item type.
	Client BackupItemType = "Client"
	// Exchange specifies the exchange state for backup item type.
	Exchange BackupItemType = "Exchange"
	// FileFolder specifies the file folder state for backup item type.
	FileFolder BackupItemType = "FileFolder"
	// GenericDataSource specifies the generic data source state for backup
	// item type.
	GenericDataSource BackupItemType = "GenericDataSource"
	// Invalid specifies the invalid state for backup item type.
	Invalid BackupItemType = "Invalid"
	// Sharepoint specifies the sharepoint state for backup item type.
	Sharepoint BackupItemType = "Sharepoint"
	// SQLDB specifies the sqldb state for backup item type.
	SQLDB BackupItemType = "SQLDB"
	// SystemState specifies the system state state for backup item type.
	SystemState BackupItemType = "SystemState"
	// VM specifies the vm state for backup item type.
	VM BackupItemType = "VM"
	// VMwareVM specifies the v mware vm state for backup item type.
	VMwareVM BackupItemType = "VMwareVM"
)

// BackupManagementType enumerates the values for backup management type.
type BackupManagementType string

const (
	// BackupManagementTypeAzureBackupServer specifies the backup management
	// type azure backup server state for backup management type.
	BackupManagementTypeAzureBackupServer BackupManagementType = "AzureBackupServer"
	// BackupManagementTypeAzureIaasVM specifies the backup management type
	// azure iaas vm state for backup management type.
	BackupManagementTypeAzureIaasVM BackupManagementType = "AzureIaasVM"
	// BackupManagementTypeAzureSQL specifies the backup management type azure
	// sql state for backup management type.
	BackupManagementTypeAzureSQL BackupManagementType = "AzureSql"
	// BackupManagementTypeDPM specifies the backup management type dpm state
	// for backup management type.
	BackupManagementTypeDPM BackupManagementType = "DPM"
	// BackupManagementTypeInvalid specifies the backup management type invalid
	// state for backup management type.
	BackupManagementTypeInvalid BackupManagementType = "Invalid"
	// BackupManagementTypeMAB specifies the backup management type mab state
	// for backup management type.
	BackupManagementTypeMAB BackupManagementType = "MAB"
)

// ContainerType enumerates the values for container type.
type ContainerType string

const (
	// ContainerTypeAzureBackupServerContainer specifies the container type
	// azure backup server container state for container type.
	ContainerTypeAzureBackupServerContainer ContainerType = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer specifies the container type azure sql
	// container state for container type.
	ContainerTypeAzureSQLContainer ContainerType = "AzureSqlContainer"
	// ContainerTypeCluster specifies the container type cluster state for
	// container type.
	ContainerTypeCluster ContainerType = "Cluster"
	// ContainerTypeDPMContainer specifies the container type dpm container
	// state for container type.
	ContainerTypeDPMContainer ContainerType = "DPMContainer"
	// ContainerTypeIaasVMContainer specifies the container type iaas vm
	// container state for container type.
	ContainerTypeIaasVMContainer ContainerType = "IaasVMContainer"
	// ContainerTypeIaasVMServiceContainer specifies the container type iaas vm
	// service container state for container type.
	ContainerTypeIaasVMServiceContainer ContainerType = "IaasVMServiceContainer"
	// ContainerTypeInvalid specifies the container type invalid state for
	// container type.
	ContainerTypeInvalid ContainerType = "Invalid"
	// ContainerTypeMABContainer specifies the container type mab container
	// state for container type.
	ContainerTypeMABContainer ContainerType = "MABContainer"
	// ContainerTypeUnknown specifies the container type unknown state for
	// container type.
	ContainerTypeUnknown ContainerType = "Unknown"
	// ContainerTypeVCenter specifies the container type v center state for
	// container type.
	ContainerTypeVCenter ContainerType = "VCenter"
	// ContainerTypeWindows specifies the container type windows state for
	// container type.
	ContainerTypeWindows ContainerType = "Windows"
)

// DataSourceType enumerates the values for data source type.
type DataSourceType string

const (
	// DataSourceTypeAzureSQLDb specifies the data source type azure sql db
	// state for data source type.
	DataSourceTypeAzureSQLDb DataSourceType = "AzureSqlDb"
	// DataSourceTypeClient specifies the data source type client state for
	// data source type.
	DataSourceTypeClient DataSourceType = "Client"
	// DataSourceTypeExchange specifies the data source type exchange state for
	// data source type.
	DataSourceTypeExchange DataSourceType = "Exchange"
	// DataSourceTypeFileFolder specifies the data source type file folder
	// state for data source type.
	DataSourceTypeFileFolder DataSourceType = "FileFolder"
	// DataSourceTypeGenericDataSource specifies the data source type generic
	// data source state for data source type.
	DataSourceTypeGenericDataSource DataSourceType = "GenericDataSource"
	// DataSourceTypeInvalid specifies the data source type invalid state for
	// data source type.
	DataSourceTypeInvalid DataSourceType = "Invalid"
	// DataSourceTypeSharepoint specifies the data source type sharepoint state
	// for data source type.
	DataSourceTypeSharepoint DataSourceType = "Sharepoint"
	// DataSourceTypeSQLDB specifies the data source type sqldb state for data
	// source type.
	DataSourceTypeSQLDB DataSourceType = "SQLDB"
	// DataSourceTypeSystemState specifies the data source type system state
	// state for data source type.
	DataSourceTypeSystemState DataSourceType = "SystemState"
	// DataSourceTypeVM specifies the data source type vm state for data source
	// type.
	DataSourceTypeVM DataSourceType = "VM"
	// DataSourceTypeVMwareVM specifies the data source type v mware vm state
	// for data source type.
	DataSourceTypeVMwareVM DataSourceType = "VMwareVM"
)

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday specifies the friday state for day of week.
	Friday DayOfWeek = "Friday"
	// Monday specifies the monday state for day of week.
	Monday DayOfWeek = "Monday"
	// Saturday specifies the saturday state for day of week.
	Saturday DayOfWeek = "Saturday"
	// Sunday specifies the sunday state for day of week.
	Sunday DayOfWeek = "Sunday"
	// Thursday specifies the thursday state for day of week.
	Thursday DayOfWeek = "Thursday"
	// Tuesday specifies the tuesday state for day of week.
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday specifies the wednesday state for day of week.
	Wednesday DayOfWeek = "Wednesday"
)

// EnhancedSecurityState enumerates the values for enhanced security state.
type EnhancedSecurityState string

const (
	// EnhancedSecurityStateDisabled specifies the enhanced security state
	// disabled state for enhanced security state.
	EnhancedSecurityStateDisabled EnhancedSecurityState = "Disabled"
	// EnhancedSecurityStateEnabled specifies the enhanced security state
	// enabled state for enhanced security state.
	EnhancedSecurityStateEnabled EnhancedSecurityState = "Enabled"
	// EnhancedSecurityStateInvalid specifies the enhanced security state
	// invalid state for enhanced security state.
	EnhancedSecurityStateInvalid EnhancedSecurityState = "Invalid"
)

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateActionRequired specifies the health state action required
	// state for health state.
	HealthStateActionRequired HealthState = "ActionRequired"
	// HealthStateActionSuggested specifies the health state action suggested
	// state for health state.
	HealthStateActionSuggested HealthState = "ActionSuggested"
	// HealthStateInvalid specifies the health state invalid state for health
	// state.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStatePassed specifies the health state passed state for health
	// state.
	HealthStatePassed HealthState = "Passed"
)

// HealthStatus enumerates the values for health status.
type HealthStatus string

const (
	// HealthStatusActionRequired specifies the health status action required
	// state for health status.
	HealthStatusActionRequired HealthStatus = "ActionRequired"
	// HealthStatusActionSuggested specifies the health status action suggested
	// state for health status.
	HealthStatusActionSuggested HealthStatus = "ActionSuggested"
	// HealthStatusInvalid specifies the health status invalid state for health
	// status.
	HealthStatusInvalid HealthStatus = "Invalid"
	// HealthStatusPassed specifies the health status passed state for health
	// status.
	HealthStatusPassed HealthStatus = "Passed"
)

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted specifies the accepted state for http status code.
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous specifies the ambiguous state for http status code.
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway specifies the bad gateway state for http status code.
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest specifies the bad request state for http status code.
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict specifies the conflict state for http status code.
	Conflict HTTPStatusCode = "Conflict"
	// Continue specifies the continue state for http status code.
	Continue HTTPStatusCode = "Continue"
	// Created specifies the created state for http status code.
	Created HTTPStatusCode = "Created"
	// ExpectationFailed specifies the expectation failed state for http status
	// code.
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden specifies the forbidden state for http status code.
	Forbidden HTTPStatusCode = "Forbidden"
	// Found specifies the found state for http status code.
	Found HTTPStatusCode = "Found"
	// GatewayTimeout specifies the gateway timeout state for http status code.
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone specifies the gone state for http status code.
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported specifies the http version not supported state
	// for http status code.
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError specifies the internal server error state for http
	// status code.
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired specifies the length required state for http status code.
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed specifies the method not allowed state for http status
	// code.
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved specifies the moved state for http status code.
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently specifies the moved permanently state for http status
	// code.
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices specifies the multiple choices state for http status
	// code.
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent specifies the no content state for http status code.
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation specifies the non authoritative information
	// state for http status code.
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable specifies the not acceptable state for http status code.
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound specifies the not found state for http status code.
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented specifies the not implemented state for http status code.
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified specifies the not modified state for http status code.
	NotModified HTTPStatusCode = "NotModified"
	// OK specifies the ok state for http status code.
	OK HTTPStatusCode = "OK"
	// PartialContent specifies the partial content state for http status code.
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired specifies the payment required state for http status
	// code.
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed specifies the precondition failed state for http
	// status code.
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired specifies the proxy authentication required
	// state for http status code.
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect specifies the redirect state for http status code.
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb specifies the redirect keep verb state for http status
	// code.
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod specifies the redirect method state for http status code.
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable specifies the requested range not
	// satisfiable state for http status code.
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge specifies the request entity too large state for
	// http status code.
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout specifies the request timeout state for http status code.
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong specifies the request uri too long state for http
	// status code.
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent specifies the reset content state for http status code.
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther specifies the see other state for http status code.
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable specifies the service unavailable state for http
	// status code.
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols specifies the switching protocols state for http
	// status code.
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect specifies the temporary redirect state for http status
	// code.
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized specifies the unauthorized state for http status code.
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType specifies the unsupported media type state for http
	// status code.
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused specifies the unused state for http status code.
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired specifies the upgrade required state for http status
	// code.
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy specifies the use proxy state for http status code.
	UseProxy HTTPStatusCode = "UseProxy"
)

// JobOperationType enumerates the values for job operation type.
type JobOperationType string

const (
	// JobOperationTypeBackup specifies the job operation type backup state for
	// job operation type.
	JobOperationTypeBackup JobOperationType = "Backup"
	// JobOperationTypeConfigureBackup specifies the job operation type
	// configure backup state for job operation type.
	JobOperationTypeConfigureBackup JobOperationType = "ConfigureBackup"
	// JobOperationTypeDeleteBackupData specifies the job operation type delete
	// backup data state for job operation type.
	JobOperationTypeDeleteBackupData JobOperationType = "DeleteBackupData"
	// JobOperationTypeDisableBackup specifies the job operation type disable
	// backup state for job operation type.
	JobOperationTypeDisableBackup JobOperationType = "DisableBackup"
	// JobOperationTypeInvalid specifies the job operation type invalid state
	// for job operation type.
	JobOperationTypeInvalid JobOperationType = "Invalid"
	// JobOperationTypeRegister specifies the job operation type register state
	// for job operation type.
	JobOperationTypeRegister JobOperationType = "Register"
	// JobOperationTypeRestore specifies the job operation type restore state
	// for job operation type.
	JobOperationTypeRestore JobOperationType = "Restore"
	// JobOperationTypeUnRegister specifies the job operation type un register
	// state for job operation type.
	JobOperationTypeUnRegister JobOperationType = "UnRegister"
)

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCancelled specifies the job status cancelled state for job
	// status.
	JobStatusCancelled JobStatus = "Cancelled"
	// JobStatusCancelling specifies the job status cancelling state for job
	// status.
	JobStatusCancelling JobStatus = "Cancelling"
	// JobStatusCompleted specifies the job status completed state for job
	// status.
	JobStatusCompleted JobStatus = "Completed"
	// JobStatusCompletedWithWarnings specifies the job status completed with
	// warnings state for job status.
	JobStatusCompletedWithWarnings JobStatus = "CompletedWithWarnings"
	// JobStatusFailed specifies the job status failed state for job status.
	JobStatusFailed JobStatus = "Failed"
	// JobStatusInProgress specifies the job status in progress state for job
	// status.
	JobStatusInProgress JobStatus = "InProgress"
	// JobStatusInvalid specifies the job status invalid state for job status.
	JobStatusInvalid JobStatus = "Invalid"
)

// JobSupportedAction enumerates the values for job supported action.
type JobSupportedAction string

const (
	// JobSupportedActionCancellable specifies the job supported action
	// cancellable state for job supported action.
	JobSupportedActionCancellable JobSupportedAction = "Cancellable"
	// JobSupportedActionInvalid specifies the job supported action invalid
	// state for job supported action.
	JobSupportedActionInvalid JobSupportedAction = "Invalid"
	// JobSupportedActionRetriable specifies the job supported action retriable
	// state for job supported action.
	JobSupportedActionRetriable JobSupportedAction = "Retriable"
)

// MabServerType enumerates the values for mab server type.
type MabServerType string

const (
	// MabServerTypeAzureBackupServerContainer specifies the mab server type
	// azure backup server container state for mab server type.
	MabServerTypeAzureBackupServerContainer MabServerType = "AzureBackupServerContainer"
	// MabServerTypeAzureSQLContainer specifies the mab server type azure sql
	// container state for mab server type.
	MabServerTypeAzureSQLContainer MabServerType = "AzureSqlContainer"
	// MabServerTypeCluster specifies the mab server type cluster state for mab
	// server type.
	MabServerTypeCluster MabServerType = "Cluster"
	// MabServerTypeDPMContainer specifies the mab server type dpm container
	// state for mab server type.
	MabServerTypeDPMContainer MabServerType = "DPMContainer"
	// MabServerTypeIaasVMContainer specifies the mab server type iaas vm
	// container state for mab server type.
	MabServerTypeIaasVMContainer MabServerType = "IaasVMContainer"
	// MabServerTypeIaasVMServiceContainer specifies the mab server type iaas
	// vm service container state for mab server type.
	MabServerTypeIaasVMServiceContainer MabServerType = "IaasVMServiceContainer"
	// MabServerTypeInvalid specifies the mab server type invalid state for mab
	// server type.
	MabServerTypeInvalid MabServerType = "Invalid"
	// MabServerTypeMABContainer specifies the mab server type mab container
	// state for mab server type.
	MabServerTypeMABContainer MabServerType = "MABContainer"
	// MabServerTypeUnknown specifies the mab server type unknown state for mab
	// server type.
	MabServerTypeUnknown MabServerType = "Unknown"
	// MabServerTypeVCenter specifies the mab server type v center state for
	// mab server type.
	MabServerTypeVCenter MabServerType = "VCenter"
	// MabServerTypeWindows specifies the mab server type windows state for mab
	// server type.
	MabServerTypeWindows MabServerType = "Windows"
)

// MonthOfYear enumerates the values for month of year.
type MonthOfYear string

const (
	// MonthOfYearApril specifies the month of year april state for month of
	// year.
	MonthOfYearApril MonthOfYear = "April"
	// MonthOfYearAugust specifies the month of year august state for month of
	// year.
	MonthOfYearAugust MonthOfYear = "August"
	// MonthOfYearDecember specifies the month of year december state for month
	// of year.
	MonthOfYearDecember MonthOfYear = "December"
	// MonthOfYearFebruary specifies the month of year february state for month
	// of year.
	MonthOfYearFebruary MonthOfYear = "February"
	// MonthOfYearInvalid specifies the month of year invalid state for month
	// of year.
	MonthOfYearInvalid MonthOfYear = "Invalid"
	// MonthOfYearJanuary specifies the month of year january state for month
	// of year.
	MonthOfYearJanuary MonthOfYear = "January"
	// MonthOfYearJuly specifies the month of year july state for month of
	// year.
	MonthOfYearJuly MonthOfYear = "July"
	// MonthOfYearJune specifies the month of year june state for month of
	// year.
	MonthOfYearJune MonthOfYear = "June"
	// MonthOfYearMarch specifies the month of year march state for month of
	// year.
	MonthOfYearMarch MonthOfYear = "March"
	// MonthOfYearMay specifies the month of year may state for month of year.
	MonthOfYearMay MonthOfYear = "May"
	// MonthOfYearNovember specifies the month of year november state for month
	// of year.
	MonthOfYearNovember MonthOfYear = "November"
	// MonthOfYearOctober specifies the month of year october state for month
	// of year.
	MonthOfYearOctober MonthOfYear = "October"
	// MonthOfYearSeptember specifies the month of year september state for
	// month of year.
	MonthOfYearSeptember MonthOfYear = "September"
)

// OperationStatusValues enumerates the values for operation status values.
type OperationStatusValues string

const (
	// OperationStatusValuesCanceled specifies the operation status values
	// canceled state for operation status values.
	OperationStatusValuesCanceled OperationStatusValues = "Canceled"
	// OperationStatusValuesFailed specifies the operation status values failed
	// state for operation status values.
	OperationStatusValuesFailed OperationStatusValues = "Failed"
	// OperationStatusValuesInProgress specifies the operation status values in
	// progress state for operation status values.
	OperationStatusValuesInProgress OperationStatusValues = "InProgress"
	// OperationStatusValuesInvalid specifies the operation status values
	// invalid state for operation status values.
	OperationStatusValuesInvalid OperationStatusValues = "Invalid"
	// OperationStatusValuesSucceeded specifies the operation status values
	// succeeded state for operation status values.
	OperationStatusValuesSucceeded OperationStatusValues = "Succeeded"
)

// ProtectedItemState enumerates the values for protected item state.
type ProtectedItemState string

const (
	// ProtectedItemStateInvalid specifies the protected item state invalid
	// state for protected item state.
	ProtectedItemStateInvalid ProtectedItemState = "Invalid"
	// ProtectedItemStateIRPending specifies the protected item state ir
	// pending state for protected item state.
	ProtectedItemStateIRPending ProtectedItemState = "IRPending"
	// ProtectedItemStateProtected specifies the protected item state protected
	// state for protected item state.
	ProtectedItemStateProtected ProtectedItemState = "Protected"
	// ProtectedItemStateProtectionError specifies the protected item state
	// protection error state for protected item state.
	ProtectedItemStateProtectionError ProtectedItemState = "ProtectionError"
	// ProtectedItemStateProtectionPaused specifies the protected item state
	// protection paused state for protected item state.
	ProtectedItemStateProtectionPaused ProtectedItemState = "ProtectionPaused"
	// ProtectedItemStateProtectionStopped specifies the protected item state
	// protection stopped state for protected item state.
	ProtectedItemStateProtectionStopped ProtectedItemState = "ProtectionStopped"
)

// ProtectionState enumerates the values for protection state.
type ProtectionState string

const (
	// ProtectionStateInvalid specifies the protection state invalid state for
	// protection state.
	ProtectionStateInvalid ProtectionState = "Invalid"
	// ProtectionStateIRPending specifies the protection state ir pending state
	// for protection state.
	ProtectionStateIRPending ProtectionState = "IRPending"
	// ProtectionStateProtected specifies the protection state protected state
	// for protection state.
	ProtectionStateProtected ProtectionState = "Protected"
	// ProtectionStateProtectionError specifies the protection state protection
	// error state for protection state.
	ProtectionStateProtectionError ProtectionState = "ProtectionError"
	// ProtectionStateProtectionPaused specifies the protection state
	// protection paused state for protection state.
	ProtectionStateProtectionPaused ProtectionState = "ProtectionPaused"
	// ProtectionStateProtectionStopped specifies the protection state
	// protection stopped state for protection state.
	ProtectionStateProtectionStopped ProtectionState = "ProtectionStopped"
)

// ProtectionStatus enumerates the values for protection status.
type ProtectionStatus string

const (
	// ProtectionStatusInvalid specifies the protection status invalid state
	// for protection status.
	ProtectionStatusInvalid ProtectionStatus = "Invalid"
	// ProtectionStatusNotProtected specifies the protection status not
	// protected state for protection status.
	ProtectionStatusNotProtected ProtectionStatus = "NotProtected"
	// ProtectionStatusProtected specifies the protection status protected
	// state for protection status.
	ProtectionStatusProtected ProtectionStatus = "Protected"
	// ProtectionStatusProtecting specifies the protection status protecting
	// state for protection status.
	ProtectionStatusProtecting ProtectionStatus = "Protecting"
)

// RecoveryPointTierStatus enumerates the values for recovery point tier
// status.
type RecoveryPointTierStatus string

const (
	// RecoveryPointTierStatusDeleted specifies the recovery point tier status
	// deleted state for recovery point tier status.
	RecoveryPointTierStatusDeleted RecoveryPointTierStatus = "Deleted"
	// RecoveryPointTierStatusDisabled specifies the recovery point tier status
	// disabled state for recovery point tier status.
	RecoveryPointTierStatusDisabled RecoveryPointTierStatus = "Disabled"
	// RecoveryPointTierStatusInvalid specifies the recovery point tier status
	// invalid state for recovery point tier status.
	RecoveryPointTierStatusInvalid RecoveryPointTierStatus = "Invalid"
	// RecoveryPointTierStatusValid specifies the recovery point tier status
	// valid state for recovery point tier status.
	RecoveryPointTierStatusValid RecoveryPointTierStatus = "Valid"
)

// RecoveryPointTierType enumerates the values for recovery point tier type.
type RecoveryPointTierType string

const (
	// RecoveryPointTierTypeHardenedRP specifies the recovery point tier type
	// hardened rp state for recovery point tier type.
	RecoveryPointTierTypeHardenedRP RecoveryPointTierType = "HardenedRP"
	// RecoveryPointTierTypeInstantRP specifies the recovery point tier type
	// instant rp state for recovery point tier type.
	RecoveryPointTierTypeInstantRP RecoveryPointTierType = "InstantRP"
	// RecoveryPointTierTypeInvalid specifies the recovery point tier type
	// invalid state for recovery point tier type.
	RecoveryPointTierTypeInvalid RecoveryPointTierType = "Invalid"
)

// RecoveryType enumerates the values for recovery type.
type RecoveryType string

const (
	// RecoveryTypeAlternateLocation specifies the recovery type alternate
	// location state for recovery type.
	RecoveryTypeAlternateLocation RecoveryType = "AlternateLocation"
	// RecoveryTypeInvalid specifies the recovery type invalid state for
	// recovery type.
	RecoveryTypeInvalid RecoveryType = "Invalid"
	// RecoveryTypeOriginalLocation specifies the recovery type original
	// location state for recovery type.
	RecoveryTypeOriginalLocation RecoveryType = "OriginalLocation"
	// RecoveryTypeRestoreDisks specifies the recovery type restore disks state
	// for recovery type.
	RecoveryTypeRestoreDisks RecoveryType = "RestoreDisks"
)

// RetentionDurationType enumerates the values for retention duration type.
type RetentionDurationType string

const (
	// RetentionDurationTypeDays specifies the retention duration type days
	// state for retention duration type.
	RetentionDurationTypeDays RetentionDurationType = "Days"
	// RetentionDurationTypeInvalid specifies the retention duration type
	// invalid state for retention duration type.
	RetentionDurationTypeInvalid RetentionDurationType = "Invalid"
	// RetentionDurationTypeMonths specifies the retention duration type months
	// state for retention duration type.
	RetentionDurationTypeMonths RetentionDurationType = "Months"
	// RetentionDurationTypeWeeks specifies the retention duration type weeks
	// state for retention duration type.
	RetentionDurationTypeWeeks RetentionDurationType = "Weeks"
	// RetentionDurationTypeYears specifies the retention duration type years
	// state for retention duration type.
	RetentionDurationTypeYears RetentionDurationType = "Years"
)

// RetentionScheduleFormat enumerates the values for retention schedule format.
type RetentionScheduleFormat string

const (
	// RetentionScheduleFormatDaily specifies the retention schedule format
	// daily state for retention schedule format.
	RetentionScheduleFormatDaily RetentionScheduleFormat = "Daily"
	// RetentionScheduleFormatInvalid specifies the retention schedule format
	// invalid state for retention schedule format.
	RetentionScheduleFormatInvalid RetentionScheduleFormat = "Invalid"
	// RetentionScheduleFormatWeekly specifies the retention schedule format
	// weekly state for retention schedule format.
	RetentionScheduleFormatWeekly RetentionScheduleFormat = "Weekly"
)

// ScheduleRunType enumerates the values for schedule run type.
type ScheduleRunType string

const (
	// ScheduleRunTypeDaily specifies the schedule run type daily state for
	// schedule run type.
	ScheduleRunTypeDaily ScheduleRunType = "Daily"
	// ScheduleRunTypeInvalid specifies the schedule run type invalid state for
	// schedule run type.
	ScheduleRunTypeInvalid ScheduleRunType = "Invalid"
	// ScheduleRunTypeWeekly specifies the schedule run type weekly state for
	// schedule run type.
	ScheduleRunTypeWeekly ScheduleRunType = "Weekly"
)

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// StorageTypeGeoRedundant specifies the storage type geo redundant state
	// for storage type.
	StorageTypeGeoRedundant StorageType = "GeoRedundant"
	// StorageTypeInvalid specifies the storage type invalid state for storage
	// type.
	StorageTypeInvalid StorageType = "Invalid"
	// StorageTypeLocallyRedundant specifies the storage type locally redundant
	// state for storage type.
	StorageTypeLocallyRedundant StorageType = "LocallyRedundant"
)

// StorageTypeState enumerates the values for storage type state.
type StorageTypeState string

const (
	// StorageTypeStateInvalid specifies the storage type state invalid state
	// for storage type state.
	StorageTypeStateInvalid StorageTypeState = "Invalid"
	// StorageTypeStateLocked specifies the storage type state locked state for
	// storage type state.
	StorageTypeStateLocked StorageTypeState = "Locked"
	// StorageTypeStateUnlocked specifies the storage type state unlocked state
	// for storage type state.
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeBackupProtectedItemCountSummary specifies the type backup protected
	// item count summary state for type.
	TypeBackupProtectedItemCountSummary Type = "BackupProtectedItemCountSummary"
	// TypeBackupProtectionContainerCountSummary specifies the type backup
	// protection container count summary state for type.
	TypeBackupProtectionContainerCountSummary Type = "BackupProtectionContainerCountSummary"
	// TypeInvalid specifies the type invalid state for type.
	TypeInvalid Type = "Invalid"
)

// UsagesUnit enumerates the values for usages unit.
type UsagesUnit string

const (
	// Bytes specifies the bytes state for usages unit.
	Bytes UsagesUnit = "Bytes"
	// BytesPerSecond specifies the bytes per second state for usages unit.
	BytesPerSecond UsagesUnit = "BytesPerSecond"
	// Count specifies the count state for usages unit.
	Count UsagesUnit = "Count"
	// CountPerSecond specifies the count per second state for usages unit.
	CountPerSecond UsagesUnit = "CountPerSecond"
	// Percent specifies the percent state for usages unit.
	Percent UsagesUnit = "Percent"
	// Seconds specifies the seconds state for usages unit.
	Seconds UsagesUnit = "Seconds"
)

// WeekOfMonth enumerates the values for week of month.
type WeekOfMonth string

const (
	// First specifies the first state for week of month.
	First WeekOfMonth = "First"
	// Fourth specifies the fourth state for week of month.
	Fourth WeekOfMonth = "Fourth"
	// Last specifies the last state for week of month.
	Last WeekOfMonth = "Last"
	// Second specifies the second state for week of month.
	Second WeekOfMonth = "Second"
	// Third specifies the third state for week of month.
	Third WeekOfMonth = "Third"
)

// WorkloadType enumerates the values for workload type.
type WorkloadType string

const (
	// WorkloadTypeAzureSQLDb specifies the workload type azure sql db state
	// for workload type.
	WorkloadTypeAzureSQLDb WorkloadType = "AzureSqlDb"
	// WorkloadTypeClient specifies the workload type client state for workload
	// type.
	WorkloadTypeClient WorkloadType = "Client"
	// WorkloadTypeExchange specifies the workload type exchange state for
	// workload type.
	WorkloadTypeExchange WorkloadType = "Exchange"
	// WorkloadTypeFileFolder specifies the workload type file folder state for
	// workload type.
	WorkloadTypeFileFolder WorkloadType = "FileFolder"
	// WorkloadTypeGenericDataSource specifies the workload type generic data
	// source state for workload type.
	WorkloadTypeGenericDataSource WorkloadType = "GenericDataSource"
	// WorkloadTypeInvalid specifies the workload type invalid state for
	// workload type.
	WorkloadTypeInvalid WorkloadType = "Invalid"
	// WorkloadTypeSharepoint specifies the workload type sharepoint state for
	// workload type.
	WorkloadTypeSharepoint WorkloadType = "Sharepoint"
	// WorkloadTypeSQLDB specifies the workload type sqldb state for workload
	// type.
	WorkloadTypeSQLDB WorkloadType = "SQLDB"
	// WorkloadTypeSystemState specifies the workload type system state state
	// for workload type.
	WorkloadTypeSystemState WorkloadType = "SystemState"
	// WorkloadTypeVM specifies the workload type vm state for workload type.
	WorkloadTypeVM WorkloadType = "VM"
	// WorkloadTypeVMwareVM specifies the workload type v mware vm state for
	// workload type.
	WorkloadTypeVMwareVM WorkloadType = "VMwareVM"
)

// AzureBackupServerContainer is azureBackupServer (DPMVenus) workload-specific
// protection container.
type AzureBackupServerContainer struct {
	FriendlyName         *string                   `json:"friendlyName,omitempty"`
	BackupManagementType BackupManagementType      `json:"backupManagementType,omitempty"`
	RegistrationStatus   *string                   `json:"registrationStatus,omitempty"`
	HealthStatus         *string                   `json:"healthStatus,omitempty"`
	ContainerType        ContainerType             `json:"containerType,omitempty"`
	CanReRegister        *bool                     `json:"canReRegister,omitempty"`
	ContainerID          *string                   `json:"containerId,omitempty"`
	ProtectedItemCount   *int64                    `json:"protectedItemCount,omitempty"`
	DpmAgentVersion      *string                   `json:"dpmAgentVersion,omitempty"`
	DPMServers           *[]string                 `json:"DPMServers,omitempty"`
	UpgradeAvailable     *bool                     `json:"UpgradeAvailable,omitempty"`
	ProtectionStatus     *string                   `json:"protectionStatus,omitempty"`
	ExtendedInfo         *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureBackupServerEngine is backup engine type when Azure Backup Server is
// used to manage the backups.
type AzureBackupServerEngine struct {
	FriendlyName                       *string                   `json:"friendlyName,omitempty"`
	BackupManagementType               BackupManagementType      `json:"backupManagementType,omitempty"`
	RegistrationStatus                 *string                   `json:"registrationStatus,omitempty"`
	BackupEngineState                  *string                   `json:"backupEngineState,omitempty"`
	HealthStatus                       *string                   `json:"healthStatus,omitempty"`
	CanReRegister                      *bool                     `json:"canReRegister,omitempty"`
	BackupEngineID                     *string                   `json:"backupEngineId,omitempty"`
	DpmVersion                         *string                   `json:"dpmVersion,omitempty"`
	AzureBackupAgentVersion            *string                   `json:"azureBackupAgentVersion,omitempty"`
	IsAzureBackupAgentUpgradeAvailable *bool                     `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	IsDPMUpgradeAvailable              *bool                     `json:"isDPMUpgradeAvailable,omitempty"`
	ExtendedInfo                       *BackupEngineExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureIaaSClassicComputeVMContainer is iaaS VM workload-specific backup item
// representing a classic virtual machine.
type AzureIaaSClassicComputeVMContainer struct {
	FriendlyName          *string              `json:"friendlyName,omitempty"`
	BackupManagementType  BackupManagementType `json:"backupManagementType,omitempty"`
	RegistrationStatus    *string              `json:"registrationStatus,omitempty"`
	HealthStatus          *string              `json:"healthStatus,omitempty"`
	ContainerType         ContainerType        `json:"containerType,omitempty"`
	VirtualMachineID      *string              `json:"virtualMachineId,omitempty"`
	VirtualMachineVersion *string              `json:"virtualMachineVersion,omitempty"`
	ResourceGroup         *string              `json:"resourceGroup,omitempty"`
}

// AzureIaaSClassicComputeVMProtectableItem is iaaS VM workload-specific backup
// item representing the Classic Compute VM.
type AzureIaaSClassicComputeVMProtectableItem struct {
	BackupManagementType *string          `json:"backupManagementType,omitempty"`
	FriendlyName         *string          `json:"friendlyName,omitempty"`
	ProtectionState      ProtectionStatus `json:"protectionState,omitempty"`
	VirtualMachineID     *string          `json:"virtualMachineId,omitempty"`
}

// AzureIaaSClassicComputeVMProtectedItem is iaaS VM workload-specific backup
// item representing the Classic Compute VM.
type AzureIaaSClassicComputeVMProtectedItem struct {
	BackupManagementType BackupManagementType                  `json:"backupManagementType,omitempty"`
	WorkloadType         DataSourceType                        `json:"workloadType,omitempty"`
	ContainerName        *string                               `json:"containerName,omitempty"`
	SourceResourceID     *string                               `json:"sourceResourceId,omitempty"`
	PolicyID             *string                               `json:"policyId,omitempty"`
	LastRecoveryPoint    *date.Time                            `json:"lastRecoveryPoint,omitempty"`
	FriendlyName         *string                               `json:"friendlyName,omitempty"`
	VirtualMachineID     *string                               `json:"virtualMachineId,omitempty"`
	ProtectionStatus     *string                               `json:"protectionStatus,omitempty"`
	ProtectionState      ProtectionState                       `json:"protectionState,omitempty"`
	HealthStatus         HealthStatus                          `json:"healthStatus,omitempty"`
	HealthDetails        *[]AzureIaaSVMHealthDetails           `json:"healthDetails,omitempty"`
	LastBackupStatus     *string                               `json:"lastBackupStatus,omitempty"`
	LastBackupTime       *date.Time                            `json:"lastBackupTime,omitempty"`
	ProtectedItemDataID  *string                               `json:"protectedItemDataId,omitempty"`
	ExtendedInfo         *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureIaaSComputeVMContainer is iaaS VM workload-specific backup item
// representing an Azure Resource Manager virtual machine.
type AzureIaaSComputeVMContainer struct {
	FriendlyName          *string              `json:"friendlyName,omitempty"`
	BackupManagementType  BackupManagementType `json:"backupManagementType,omitempty"`
	RegistrationStatus    *string              `json:"registrationStatus,omitempty"`
	HealthStatus          *string              `json:"healthStatus,omitempty"`
	ContainerType         ContainerType        `json:"containerType,omitempty"`
	VirtualMachineID      *string              `json:"virtualMachineId,omitempty"`
	VirtualMachineVersion *string              `json:"virtualMachineVersion,omitempty"`
	ResourceGroup         *string              `json:"resourceGroup,omitempty"`
}

// AzureIaaSComputeVMProtectableItem is iaaS VM workload-specific backup item
// representing the Azure Resource Manager VM.
type AzureIaaSComputeVMProtectableItem struct {
	BackupManagementType *string          `json:"backupManagementType,omitempty"`
	FriendlyName         *string          `json:"friendlyName,omitempty"`
	ProtectionState      ProtectionStatus `json:"protectionState,omitempty"`
	VirtualMachineID     *string          `json:"virtualMachineId,omitempty"`
}

// AzureIaaSComputeVMProtectedItem is iaaS VM workload-specific backup item
// representing the Azure Resource Manager VM.
type AzureIaaSComputeVMProtectedItem struct {
	BackupManagementType BackupManagementType                  `json:"backupManagementType,omitempty"`
	WorkloadType         DataSourceType                        `json:"workloadType,omitempty"`
	ContainerName        *string                               `json:"containerName,omitempty"`
	SourceResourceID     *string                               `json:"sourceResourceId,omitempty"`
	PolicyID             *string                               `json:"policyId,omitempty"`
	LastRecoveryPoint    *date.Time                            `json:"lastRecoveryPoint,omitempty"`
	FriendlyName         *string                               `json:"friendlyName,omitempty"`
	VirtualMachineID     *string                               `json:"virtualMachineId,omitempty"`
	ProtectionStatus     *string                               `json:"protectionStatus,omitempty"`
	ProtectionState      ProtectionState                       `json:"protectionState,omitempty"`
	HealthStatus         HealthStatus                          `json:"healthStatus,omitempty"`
	HealthDetails        *[]AzureIaaSVMHealthDetails           `json:"healthDetails,omitempty"`
	LastBackupStatus     *string                               `json:"lastBackupStatus,omitempty"`
	LastBackupTime       *date.Time                            `json:"lastBackupTime,omitempty"`
	ProtectedItemDataID  *string                               `json:"protectedItemDataId,omitempty"`
	ExtendedInfo         *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureIaaSVMErrorInfo is azure IaaS VM workload-specific error information.
type AzureIaaSVMErrorInfo struct {
	ErrorCode       *int32    `json:"errorCode,omitempty"`
	ErrorTitle      *string   `json:"errorTitle,omitempty"`
	ErrorString     *string   `json:"errorString,omitempty"`
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// AzureIaaSVMHealthDetails is azure IaaS VM workload-specific Health Details.
type AzureIaaSVMHealthDetails struct {
	Code            *int32    `json:"code,omitempty"`
	Title           *string   `json:"title,omitempty"`
	Message         *string   `json:"message,omitempty"`
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// AzureIaaSVMJob is azure IaaS VM workload-specifc job object.
type AzureIaaSVMJob struct {
	EntityFriendlyName    *string                     `json:"entityFriendlyName,omitempty"`
	BackupManagementType  BackupManagementType        `json:"backupManagementType,omitempty"`
	Operation             *string                     `json:"operation,omitempty"`
	Status                *string                     `json:"status,omitempty"`
	StartTime             *date.Time                  `json:"startTime,omitempty"`
	EndTime               *date.Time                  `json:"endTime,omitempty"`
	ActivityID            *string                     `json:"activityId,omitempty"`
	Duration              *string                     `json:"duration,omitempty"`
	ActionsInfo           *[]JobSupportedAction       `json:"actionsInfo,omitempty"`
	ErrorDetails          *[]AzureIaaSVMErrorInfo     `json:"errorDetails,omitempty"`
	VirtualMachineVersion *string                     `json:"virtualMachineVersion,omitempty"`
	ExtendedInfo          *AzureIaaSVMJobExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureIaaSVMJobExtendedInfo is azure IaaS VM workload-specific additional
// information for job.
type AzureIaaSVMJobExtendedInfo struct {
	TasksList           *[]AzureIaaSVMJobTaskDetails `json:"tasksList,omitempty"`
	PropertyBag         *map[string]*string          `json:"propertyBag,omitempty"`
	ProgressPercentage  *float64                     `json:"progressPercentage,omitempty"`
	DynamicErrorMessage *string                      `json:"dynamicErrorMessage,omitempty"`
}

// AzureIaaSVMJobTaskDetails is azure IaaS VM workload-specific job task
// details.
type AzureIaaSVMJobTaskDetails struct {
	TaskID             *string    `json:"taskId,omitempty"`
	StartTime          *date.Time `json:"startTime,omitempty"`
	EndTime            *date.Time `json:"endTime,omitempty"`
	InstanceID         *string    `json:"instanceId,omitempty"`
	Duration           *string    `json:"duration,omitempty"`
	Status             *string    `json:"status,omitempty"`
	ProgressPercentage *float64   `json:"progressPercentage,omitempty"`
}

// AzureIaaSVMProtectedItem is iaaS VM workload-specific backup item.
type AzureIaaSVMProtectedItem struct {
	BackupManagementType BackupManagementType                  `json:"backupManagementType,omitempty"`
	WorkloadType         DataSourceType                        `json:"workloadType,omitempty"`
	ContainerName        *string                               `json:"containerName,omitempty"`
	SourceResourceID     *string                               `json:"sourceResourceId,omitempty"`
	PolicyID             *string                               `json:"policyId,omitempty"`
	LastRecoveryPoint    *date.Time                            `json:"lastRecoveryPoint,omitempty"`
	FriendlyName         *string                               `json:"friendlyName,omitempty"`
	VirtualMachineID     *string                               `json:"virtualMachineId,omitempty"`
	ProtectionStatus     *string                               `json:"protectionStatus,omitempty"`
	ProtectionState      ProtectionState                       `json:"protectionState,omitempty"`
	HealthStatus         HealthStatus                          `json:"healthStatus,omitempty"`
	HealthDetails        *[]AzureIaaSVMHealthDetails           `json:"healthDetails,omitempty"`
	LastBackupStatus     *string                               `json:"lastBackupStatus,omitempty"`
	LastBackupTime       *date.Time                            `json:"lastBackupTime,omitempty"`
	ProtectedItemDataID  *string                               `json:"protectedItemDataId,omitempty"`
	ExtendedInfo         *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureIaaSVMProtectedItemExtendedInfo is additional information on Azure IaaS
// VM specific backup item.
type AzureIaaSVMProtectedItemExtendedInfo struct {
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	RecoveryPointCount  *int32     `json:"recoveryPointCount,omitempty"`
	PolicyInconsistent  *bool      `json:"policyInconsistent,omitempty"`
}

// AzureIaaSVMProtectionPolicy is iaaS VM workload-specific backup policy.
type AzureIaaSVMProtectionPolicy struct {
	ProtectedItemsCount *int32           `json:"protectedItemsCount,omitempty"`
	SchedulePolicy      *SchedulePolicy  `json:"schedulePolicy,omitempty"`
	RetentionPolicy     *RetentionPolicy `json:"retentionPolicy,omitempty"`
	TimeZone            *string          `json:"timeZone,omitempty"`
}

// AzureSQLContainer is azure Sql workload-specific container.
type AzureSQLContainer struct {
	FriendlyName         *string              `json:"friendlyName,omitempty"`
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	RegistrationStatus   *string              `json:"registrationStatus,omitempty"`
	HealthStatus         *string              `json:"healthStatus,omitempty"`
	ContainerType        ContainerType        `json:"containerType,omitempty"`
}

// AzureSQLProtectedItem is azure SQL workload-specific backup item.
type AzureSQLProtectedItem struct {
	BackupManagementType BackupManagementType               `json:"backupManagementType,omitempty"`
	WorkloadType         DataSourceType                     `json:"workloadType,omitempty"`
	ContainerName        *string                            `json:"containerName,omitempty"`
	SourceResourceID     *string                            `json:"sourceResourceId,omitempty"`
	PolicyID             *string                            `json:"policyId,omitempty"`
	LastRecoveryPoint    *date.Time                         `json:"lastRecoveryPoint,omitempty"`
	ProtectedItemDataID  *string                            `json:"protectedItemDataId,omitempty"`
	ProtectionState      ProtectedItemState                 `json:"protectionState,omitempty"`
	ExtendedInfo         *AzureSQLProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
}

// AzureSQLProtectedItemExtendedInfo is additional information on Azure Sql
// specific protected item.
type AzureSQLProtectedItemExtendedInfo struct {
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	RecoveryPointCount  *int32     `json:"recoveryPointCount,omitempty"`
	PolicyState         *string    `json:"policyState,omitempty"`
}

// AzureSQLProtectionPolicy is azure SQL workload-specific backup policy.
type AzureSQLProtectionPolicy struct {
	ProtectedItemsCount *int32           `json:"protectedItemsCount,omitempty"`
	RetentionPolicy     *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// BackupEngineBase is the base backup engine class. All workload specific
// backup engines derive from this class.
type BackupEngineBase struct {
	FriendlyName                       *string                   `json:"friendlyName,omitempty"`
	BackupManagementType               BackupManagementType      `json:"backupManagementType,omitempty"`
	RegistrationStatus                 *string                   `json:"registrationStatus,omitempty"`
	BackupEngineState                  *string                   `json:"backupEngineState,omitempty"`
	HealthStatus                       *string                   `json:"healthStatus,omitempty"`
	CanReRegister                      *bool                     `json:"canReRegister,omitempty"`
	BackupEngineID                     *string                   `json:"backupEngineId,omitempty"`
	DpmVersion                         *string                   `json:"dpmVersion,omitempty"`
	AzureBackupAgentVersion            *string                   `json:"azureBackupAgentVersion,omitempty"`
	IsAzureBackupAgentUpgradeAvailable *bool                     `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	IsDPMUpgradeAvailable              *bool                     `json:"isDPMUpgradeAvailable,omitempty"`
	ExtendedInfo                       *BackupEngineExtendedInfo `json:"extendedInfo,omitempty"`
}

// BackupEngineBaseResource is the base backup engine class. All workload
// specific backup engines derive from this class.
type BackupEngineBaseResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Properties        *BackupEngineBase   `json:"properties,omitempty"`
}

// BackupEngineBaseResourceList is list of BackupEngineBase resources
type BackupEngineBaseResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string                     `json:"nextLink,omitempty"`
	Value             *[]BackupEngineBaseResource `json:"value,omitempty"`
}

// BackupEngineBaseResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client BackupEngineBaseResourceList) BackupEngineBaseResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// BackupEngineExtendedInfo is additional information on backup engine.
type BackupEngineExtendedInfo struct {
	DatabaseName            *string    `json:"databaseName,omitempty"`
	ProtectedItemsCount     *int32     `json:"protectedItemsCount,omitempty"`
	ProtectedServersCount   *int32     `json:"protectedServersCount,omitempty"`
	DiskCount               *int32     `json:"diskCount,omitempty"`
	UsedDiskSpace           *float64   `json:"usedDiskSpace,omitempty"`
	AvailableDiskSpace      *float64   `json:"availableDiskSpace,omitempty"`
	RefreshedAt             *date.Time `json:"refreshedAt,omitempty"`
	AzureProtectedInstances *int32     `json:"azureProtectedInstances,omitempty"`
}

// BackupManagementUsage is backup management usages of a vault.
type BackupManagementUsage struct {
	Unit          UsagesUnit `json:"unit,omitempty"`
	QuotaPeriod   *string    `json:"quotaPeriod,omitempty"`
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	CurrentValue  *int64     `json:"currentValue,omitempty"`
	Limit         *int64     `json:"limit,omitempty"`
	Name          *NameInfo  `json:"name,omitempty"`
}

// BackupManagementUsageList is backup management usage for vault.
type BackupManagementUsageList struct {
	autorest.Response `json:"-"`
	Value             *[]BackupManagementUsage `json:"value,omitempty"`
}

// BackupRequest is base class for backup request. Workload-specific backup
// requests are derived from this class.
type BackupRequest struct {
}

// BackupRequestResource is base class for backup request. Workload-specific
// backup requests are derived from this class.
type BackupRequestResource struct {
	ID         *string             `json:"id,omitempty"`
	Name       *string             `json:"name,omitempty"`
	Type       *string             `json:"type,omitempty"`
	Location   *string             `json:"location,omitempty"`
	Tags       *map[string]*string `json:"tags,omitempty"`
	ETag       *string             `json:"eTag,omitempty"`
	Properties *BackupRequest      `json:"properties,omitempty"`
}

// BackupResourceConfig is the resource storage details.
type BackupResourceConfig struct {
	StorageType      StorageType      `json:"storageType,omitempty"`
	StorageTypeState StorageTypeState `json:"storageTypeState,omitempty"`
}

// BackupResourceConfigResource is the resource storage details.
type BackupResourceConfigResource struct {
	autorest.Response `json:"-"`
	ID                *string               `json:"id,omitempty"`
	Name              *string               `json:"name,omitempty"`
	Type              *string               `json:"type,omitempty"`
	Location          *string               `json:"location,omitempty"`
	Tags              *map[string]*string   `json:"tags,omitempty"`
	ETag              *string               `json:"eTag,omitempty"`
	Properties        *BackupResourceConfig `json:"properties,omitempty"`
}

// BackupResourceVaultConfig is backup resource vault config details.
type BackupResourceVaultConfig struct {
	StorageType           StorageType           `json:"storageType,omitempty"`
	StorageTypeState      StorageTypeState      `json:"storageTypeState,omitempty"`
	EnhancedSecurityState EnhancedSecurityState `json:"enhancedSecurityState,omitempty"`
}

// BackupResourceVaultConfigResource is backup resource vault config details.
type BackupResourceVaultConfigResource struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	ETag              *string                    `json:"eTag,omitempty"`
	Properties        *BackupResourceVaultConfig `json:"properties,omitempty"`
}

// BEKDetails is bEK is bitlocker encrpytion key.
type BEKDetails struct {
	SecretURL     *string `json:"secretUrl,omitempty"`
	SecretVaultID *string `json:"secretVaultId,omitempty"`
	SecretData    *string `json:"secretData,omitempty"`
}

// BMSBackupEngineQueryObject is query parameters to fetch list of backup
// engines.
type BMSBackupEngineQueryObject struct {
	Expand *string `json:"expand,omitempty"`
}

// BMSBackupEnginesQueryObject is query parameters to fetch list of backup
// engines.
type BMSBackupEnginesQueryObject struct {
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	FriendlyName         *string              `json:"friendlyName,omitempty"`
	Expand               *string              `json:"expand,omitempty"`
}

// BMSBackupSummariesQueryObject is query parameters to fetch backup summaries.
type BMSBackupSummariesQueryObject struct {
	Type Type `json:"type,omitempty"`
}

// BMSContainerQueryObject is the query filters that can be used with the list
// containers API.
type BMSContainerQueryObject struct {
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	ContainerType        ContainerType        `json:"containerType,omitempty"`
	BackupEngineName     *string              `json:"backupEngineName,omitempty"`
	Status               *string              `json:"status,omitempty"`
	FriendlyName         *string              `json:"friendlyName,omitempty"`
}

// BMSPOQueryObject is filters to list items that can be backed up.
type BMSPOQueryObject struct {
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	Status               *string              `json:"status,omitempty"`
	FriendlyName         *string              `json:"friendlyName,omitempty"`
}

// BMSRPQueryObject is filters to list backup copies.
type BMSRPQueryObject struct {
	StartDate *date.Time `json:"startDate,omitempty"`
	EndDate   *date.Time `json:"endDate,omitempty"`
}

// ClientDiscoveryDisplay is localized display information of an operation.
type ClientDiscoveryDisplay struct {
	Provider    *string `json:"Provider,omitempty"`
	Resource    *string `json:"Resource,omitempty"`
	Operation   *string `json:"Operation,omitempty"`
	Description *string `json:"Description,omitempty"`
}

// ClientDiscoveryForLogSpecification is class to represent shoebox log
// specification in json client discovery.
type ClientDiscoveryForLogSpecification struct {
	Name         *string `json:"name,omitempty"`
	DisplayName  *string `json:"displayName,omitempty"`
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ClientDiscoveryForProperties is class to represent shoebox properties in
// json client discovery.
type ClientDiscoveryForProperties struct {
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification is class to represent shoebox service
// specification in json client discovery.
type ClientDiscoveryForServiceSpecification struct {
	LogSpecifications *[]ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse is operations List response which contains list of
// available APIs.
type ClientDiscoveryResponse struct {
	autorest.Response `json:"-"`
	Value             *[]ClientDiscoveryValueForSingleAPI `json:"Value,omitempty"`
	NextLink          *string                             `json:"NextLink,omitempty"`
}

// ClientDiscoveryResponsePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ClientDiscoveryResponse) ClientDiscoveryResponsePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ClientDiscoveryValueForSingleAPI is available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	Name       *string                       `json:"Name,omitempty"`
	Display    *ClientDiscoveryDisplay       `json:"Display,omitempty"`
	Origin     *string                       `json:"Origin,omitempty"`
	Properties *ClientDiscoveryForProperties `json:"Properties,omitempty"`
}

// ClientScriptForConnect is client script details for file / folder restore.
type ClientScriptForConnect struct {
	ScriptContent    *string `json:"scriptContent,omitempty"`
	ScriptExtension  *string `json:"scriptExtension,omitempty"`
	OsType           *string `json:"osType,omitempty"`
	URL              *string `json:"url,omitempty"`
	ScriptNameSuffix *string `json:"scriptNameSuffix,omitempty"`
}

// DailyRetentionFormat is daily retention format.
type DailyRetentionFormat struct {
	DaysOfTheMonth *[]Day `json:"daysOfTheMonth,omitempty"`
}

// DailyRetentionSchedule is daily retention schedule.
type DailyRetentionSchedule struct {
	RetentionTimes    *[]date.Time       `json:"retentionTimes,omitempty"`
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// Day is day of the week.
type Day struct {
	Date   *int32 `json:"date,omitempty"`
	IsLast *bool  `json:"isLast,omitempty"`
}

// DpmBackupEngine is data Protection Manager (DPM) specific backup engine.
type DpmBackupEngine struct {
	FriendlyName                       *string                   `json:"friendlyName,omitempty"`
	BackupManagementType               BackupManagementType      `json:"backupManagementType,omitempty"`
	RegistrationStatus                 *string                   `json:"registrationStatus,omitempty"`
	BackupEngineState                  *string                   `json:"backupEngineState,omitempty"`
	HealthStatus                       *string                   `json:"healthStatus,omitempty"`
	CanReRegister                      *bool                     `json:"canReRegister,omitempty"`
	BackupEngineID                     *string                   `json:"backupEngineId,omitempty"`
	DpmVersion                         *string                   `json:"dpmVersion,omitempty"`
	AzureBackupAgentVersion            *string                   `json:"azureBackupAgentVersion,omitempty"`
	IsAzureBackupAgentUpgradeAvailable *bool                     `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`
	IsDPMUpgradeAvailable              *bool                     `json:"isDPMUpgradeAvailable,omitempty"`
	ExtendedInfo                       *BackupEngineExtendedInfo `json:"extendedInfo,omitempty"`
}

// DpmContainer is dPM workload-specific protection container.
type DpmContainer struct {
	FriendlyName         *string                   `json:"friendlyName,omitempty"`
	BackupManagementType BackupManagementType      `json:"backupManagementType,omitempty"`
	RegistrationStatus   *string                   `json:"registrationStatus,omitempty"`
	HealthStatus         *string                   `json:"healthStatus,omitempty"`
	ContainerType        ContainerType             `json:"containerType,omitempty"`
	CanReRegister        *bool                     `json:"canReRegister,omitempty"`
	ContainerID          *string                   `json:"containerId,omitempty"`
	ProtectedItemCount   *int64                    `json:"protectedItemCount,omitempty"`
	DpmAgentVersion      *string                   `json:"dpmAgentVersion,omitempty"`
	DPMServers           *[]string                 `json:"DPMServers,omitempty"`
	UpgradeAvailable     *bool                     `json:"UpgradeAvailable,omitempty"`
	ProtectionStatus     *string                   `json:"protectionStatus,omitempty"`
	ExtendedInfo         *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`
}

// DPMContainerExtendedInfo is additional information of the DPMContainer.
type DPMContainerExtendedInfo struct {
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
}

// DpmErrorInfo is dPM workload-specific error information.
type DpmErrorInfo struct {
	ErrorString     *string   `json:"errorString,omitempty"`
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// DpmJob is dPM workload-specifc job object.
type DpmJob struct {
	EntityFriendlyName   *string               `json:"entityFriendlyName,omitempty"`
	BackupManagementType BackupManagementType  `json:"backupManagementType,omitempty"`
	Operation            *string               `json:"operation,omitempty"`
	Status               *string               `json:"status,omitempty"`
	StartTime            *date.Time            `json:"startTime,omitempty"`
	EndTime              *date.Time            `json:"endTime,omitempty"`
	ActivityID           *string               `json:"activityId,omitempty"`
	Duration             *string               `json:"duration,omitempty"`
	DpmServerName        *string               `json:"dpmServerName,omitempty"`
	ContainerName        *string               `json:"containerName,omitempty"`
	ContainerType        *string               `json:"containerType,omitempty"`
	WorkloadType         *string               `json:"workloadType,omitempty"`
	ActionsInfo          *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	ErrorDetails         *[]DpmErrorInfo       `json:"errorDetails,omitempty"`
	ExtendedInfo         *DpmJobExtendedInfo   `json:"extendedInfo,omitempty"`
}

// DpmJobExtendedInfo is additional information on the DPM workload-specific
// job.
type DpmJobExtendedInfo struct {
	TasksList           *[]DpmJobTaskDetails `json:"tasksList,omitempty"`
	PropertyBag         *map[string]*string  `json:"propertyBag,omitempty"`
	DynamicErrorMessage *string              `json:"dynamicErrorMessage,omitempty"`
}

// DpmJobTaskDetails is dPM workload-specific job task details.
type DpmJobTaskDetails struct {
	TaskID    *string    `json:"taskId,omitempty"`
	StartTime *date.Time `json:"startTime,omitempty"`
	EndTime   *date.Time `json:"endTime,omitempty"`
	Duration  *string    `json:"duration,omitempty"`
	Status    *string    `json:"status,omitempty"`
}

// DPMProtectedItem is additional information on Backup engine specific backup
// item.
type DPMProtectedItem struct {
	BackupManagementType         BackupManagementType          `json:"backupManagementType,omitempty"`
	WorkloadType                 DataSourceType                `json:"workloadType,omitempty"`
	ContainerName                *string                       `json:"containerName,omitempty"`
	SourceResourceID             *string                       `json:"sourceResourceId,omitempty"`
	PolicyID                     *string                       `json:"policyId,omitempty"`
	LastRecoveryPoint            *date.Time                    `json:"lastRecoveryPoint,omitempty"`
	FriendlyName                 *string                       `json:"friendlyName,omitempty"`
	BackupEngineName             *string                       `json:"backupEngineName,omitempty"`
	ProtectionState              ProtectedItemState            `json:"protectionState,omitempty"`
	IsScheduledForDeferredDelete *bool                         `json:"isScheduledForDeferredDelete,omitempty"`
	ExtendedInfo                 *DPMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
}

// DPMProtectedItemExtendedInfo is additional information of DPM Protected
// item.
type DPMProtectedItemExtendedInfo struct {
	ProtectableObjectLoadPath    *map[string]*string `json:"protectableObjectLoadPath,omitempty"`
	Protected                    *bool               `json:"protected,omitempty"`
	IsPresentOnCloud             *bool               `json:"isPresentOnCloud,omitempty"`
	LastBackupStatus             *string             `json:"lastBackupStatus,omitempty"`
	LastRefreshedAt              *date.Time          `json:"lastRefreshedAt,omitempty"`
	OldestRecoveryPoint          *date.Time          `json:"oldestRecoveryPoint,omitempty"`
	RecoveryPointCount           *int32              `json:"recoveryPointCount,omitempty"`
	OnPremiseOldestRecoveryPoint *date.Time          `json:"onPremiseOldestRecoveryPoint,omitempty"`
	OnPremiseLatestRecoveryPoint *date.Time          `json:"onPremiseLatestRecoveryPoint,omitempty"`
	OnPremiseRecoveryPointCount  *int32              `json:"onPremiseRecoveryPointCount,omitempty"`
	IsCollocated                 *bool               `json:"isCollocated,omitempty"`
	ProtectionGroupName          *string             `json:"protectionGroupName,omitempty"`
	DiskStorageUsedInBytes       *string             `json:"diskStorageUsedInBytes,omitempty"`
	TotalDiskStorageSizeInBytes  *string             `json:"totalDiskStorageSizeInBytes,omitempty"`
}

// EncryptionDetails is details needed if the VM was encrypted at the time of
// backup.
type EncryptionDetails struct {
	EncryptionEnabled *bool   `json:"encryptionEnabled,omitempty"`
	KekURL            *string `json:"kekUrl,omitempty"`
	SecretKeyURL      *string `json:"secretKeyUrl,omitempty"`
	KekVaultID        *string `json:"kekVaultId,omitempty"`
	SecretKeyVaultID  *string `json:"secretKeyVaultId,omitempty"`
}

// ExportJobsOperationResultInfo is this class is used to send blob details
// after exporting jobs.
type ExportJobsOperationResultInfo struct {
	BlobURL    *string `json:"blobUrl,omitempty"`
	BlobSasKey *string `json:"blobSasKey,omitempty"`
}

// GenericRecoveryPoint is generic backup copy.
type GenericRecoveryPoint struct {
	FriendlyName                *string    `json:"friendlyName,omitempty"`
	RecoveryPointType           *string    `json:"recoveryPointType,omitempty"`
	RecoveryPointTime           *date.Time `json:"recoveryPointTime,omitempty"`
	RecoveryPointAdditionalInfo *string    `json:"recoveryPointAdditionalInfo,omitempty"`
}

// GetProtectedItemQueryObject is filters to list backup items.
type GetProtectedItemQueryObject struct {
	Expand *string `json:"expand,omitempty"`
}

// IaasVMBackupRequest is iaaS VM workload-specific backup request.
type IaasVMBackupRequest struct {
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
}

// IaaSVMContainer is iaaS VM workload-specific container.
type IaaSVMContainer struct {
	FriendlyName          *string              `json:"friendlyName,omitempty"`
	BackupManagementType  BackupManagementType `json:"backupManagementType,omitempty"`
	RegistrationStatus    *string              `json:"registrationStatus,omitempty"`
	HealthStatus          *string              `json:"healthStatus,omitempty"`
	ContainerType         ContainerType        `json:"containerType,omitempty"`
	VirtualMachineID      *string              `json:"virtualMachineId,omitempty"`
	VirtualMachineVersion *string              `json:"virtualMachineVersion,omitempty"`
	ResourceGroup         *string              `json:"resourceGroup,omitempty"`
}

// IaasVMILRRegistrationRequest is restore files/folders from a backup copy of
// IaaS VM.
type IaasVMILRRegistrationRequest struct {
	RecoveryPointID           *string `json:"recoveryPointId,omitempty"`
	VirtualMachineID          *string `json:"virtualMachineId,omitempty"`
	InitiatorName             *string `json:"initiatorName,omitempty"`
	RenewExistingRegistration *bool   `json:"renewExistingRegistration,omitempty"`
}

// IaaSVMProtectableItem is iaaS VM workload-specific backup item.
type IaaSVMProtectableItem struct {
	BackupManagementType *string          `json:"backupManagementType,omitempty"`
	FriendlyName         *string          `json:"friendlyName,omitempty"`
	ProtectionState      ProtectionStatus `json:"protectionState,omitempty"`
	VirtualMachineID     *string          `json:"virtualMachineId,omitempty"`
}

// IaasVMRecoveryPoint is iaaS VM workload specific backup copy.
type IaasVMRecoveryPoint struct {
	RecoveryPointType           *string                         `json:"recoveryPointType,omitempty"`
	RecoveryPointTime           *date.Time                      `json:"recoveryPointTime,omitempty"`
	RecoveryPointAdditionalInfo *string                         `json:"recoveryPointAdditionalInfo,omitempty"`
	SourceVMStorageType         *string                         `json:"sourceVMStorageType,omitempty"`
	IsSourceVMEncrypted         *bool                           `json:"isSourceVMEncrypted,omitempty"`
	KeyAndSecret                *KeyAndSecretDetails            `json:"keyAndSecret,omitempty"`
	IsInstantILRSessionActive   *bool                           `json:"isInstantILRSessionActive,omitempty"`
	RecoveryPointTierDetails    *[]RecoveryPointTierInformation `json:"recoveryPointTierDetails,omitempty"`
	IsManagedVirtualMachine     *bool                           `json:"isManagedVirtualMachine,omitempty"`
	VirtualMachineSize          *string                         `json:"virtualMachineSize,omitempty"`
}

// IaasVMRestoreRequest is iaaS VM workload-specific restore.
type IaasVMRestoreRequest struct {
	RecoveryPointID        *string            `json:"recoveryPointId,omitempty"`
	RecoveryType           RecoveryType       `json:"recoveryType,omitempty"`
	SourceResourceID       *string            `json:"sourceResourceId,omitempty"`
	TargetVirtualMachineID *string            `json:"targetVirtualMachineId,omitempty"`
	TargetResourceGroupID  *string            `json:"targetResourceGroupId,omitempty"`
	StorageAccountID       *string            `json:"storageAccountId,omitempty"`
	VirtualNetworkID       *string            `json:"virtualNetworkId,omitempty"`
	SubnetID               *string            `json:"subnetId,omitempty"`
	TargetDomainNameID     *string            `json:"targetDomainNameId,omitempty"`
	Region                 *string            `json:"region,omitempty"`
	AffinityGroup          *string            `json:"affinityGroup,omitempty"`
	CreateNewCloudService  *bool              `json:"createNewCloudService,omitempty"`
	EncryptionDetails      *EncryptionDetails `json:"encryptionDetails,omitempty"`
}

// ILRRequest is parameters to restore file/folders API.
type ILRRequest struct {
}

// ILRRequestResource is parameters to restore file/folders API.
type ILRRequestResource struct {
	ID         *string             `json:"id,omitempty"`
	Name       *string             `json:"name,omitempty"`
	Type       *string             `json:"type,omitempty"`
	Location   *string             `json:"location,omitempty"`
	Tags       *map[string]*string `json:"tags,omitempty"`
	ETag       *string             `json:"eTag,omitempty"`
	Properties *ILRRequest         `json:"properties,omitempty"`
}

// InstantItemRecoveryTarget is target details for file / folder restore.
type InstantItemRecoveryTarget struct {
	ClientScripts *[]ClientScriptForConnect `json:"clientScripts,omitempty"`
}

// Job is defines workload agnostic properties for a job.
type Job struct {
	EntityFriendlyName   *string              `json:"entityFriendlyName,omitempty"`
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	Operation            *string              `json:"operation,omitempty"`
	Status               *string              `json:"status,omitempty"`
	StartTime            *date.Time           `json:"startTime,omitempty"`
	EndTime              *date.Time           `json:"endTime,omitempty"`
	ActivityID           *string              `json:"activityId,omitempty"`
}

// JobQueryObject is filters to list the jobs.
type JobQueryObject struct {
	Status               JobStatus            `json:"status,omitempty"`
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	Operation            JobOperationType     `json:"operation,omitempty"`
	JobID                *string              `json:"jobId,omitempty"`
	StartTime            *date.Time           `json:"startTime,omitempty"`
	EndTime              *date.Time           `json:"endTime,omitempty"`
}

// JobResource is defines workload agnostic properties for a job.
type JobResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Properties        *Job                `json:"properties,omitempty"`
}

// JobResourceList is list of Job resources
type JobResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string        `json:"nextLink,omitempty"`
	Value             *[]JobResource `json:"value,omitempty"`
}

// JobResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobResourceList) JobResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// KEKDetails is kEK is encryption key for BEK.
type KEKDetails struct {
	KeyURL        *string `json:"keyUrl,omitempty"`
	KeyVaultID    *string `json:"keyVaultId,omitempty"`
	KeyBackupData *string `json:"keyBackupData,omitempty"`
}

// KeyAndSecretDetails is bEK is bitlocker key.
// KEK is encryption key for BEK
// If the VM was encrypted then we will store follwing details :
// 1. Secret(BEK) - Url + Backup Data + vaultId.
// 2. Key(KEK) - Url + Backup Data + vaultId.
// BEK and KEK can potentiallty have different vault ids.
type KeyAndSecretDetails struct {
	KekDetails *KEKDetails `json:"kekDetails,omitempty"`
	BekDetails *BEKDetails `json:"bekDetails,omitempty"`
}

// LongTermRetentionPolicy is long term retention policy.
type LongTermRetentionPolicy struct {
	DailySchedule   *DailyRetentionSchedule   `json:"dailySchedule,omitempty"`
	WeeklySchedule  *WeeklyRetentionSchedule  `json:"weeklySchedule,omitempty"`
	MonthlySchedule *MonthlyRetentionSchedule `json:"monthlySchedule,omitempty"`
	YearlySchedule  *YearlyRetentionSchedule  `json:"yearlySchedule,omitempty"`
}

// LongTermSchedulePolicy is long term policy schedule.
type LongTermSchedulePolicy struct {
}

// MabContainer is container with items backed up using MAB backup engine.
type MabContainer struct {
	FriendlyName         *string                   `json:"friendlyName,omitempty"`
	BackupManagementType BackupManagementType      `json:"backupManagementType,omitempty"`
	RegistrationStatus   *string                   `json:"registrationStatus,omitempty"`
	HealthStatus         *string                   `json:"healthStatus,omitempty"`
	ContainerType        ContainerType             `json:"containerType,omitempty"`
	CanReRegister        *bool                     `json:"canReRegister,omitempty"`
	ContainerID          *int64                    `json:"containerId,omitempty"`
	ProtectedItemCount   *int64                    `json:"protectedItemCount,omitempty"`
	AgentVersion         *string                   `json:"agentVersion,omitempty"`
	ExtendedInfo         *MabContainerExtendedInfo `json:"extendedInfo,omitempty"`
}

// MabContainerExtendedInfo is additional information of the container.
type MabContainerExtendedInfo struct {
	LastRefreshedAt  *date.Time     `json:"lastRefreshedAt,omitempty"`
	BackupItemType   BackupItemType `json:"backupItemType,omitempty"`
	BackupItems      *[]string      `json:"backupItems,omitempty"`
	PolicyName       *string        `json:"policyName,omitempty"`
	LastBackupStatus *string        `json:"lastBackupStatus,omitempty"`
}

// MabErrorInfo is mAB workload-specific error information.
type MabErrorInfo struct {
	ErrorString     *string   `json:"errorString,omitempty"`
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// MabFileFolderProtectedItem is mAB workload-specific backup item.
type MabFileFolderProtectedItem struct {
	BackupManagementType         BackupManagementType                    `json:"backupManagementType,omitempty"`
	WorkloadType                 DataSourceType                          `json:"workloadType,omitempty"`
	ContainerName                *string                                 `json:"containerName,omitempty"`
	SourceResourceID             *string                                 `json:"sourceResourceId,omitempty"`
	PolicyID                     *string                                 `json:"policyId,omitempty"`
	LastRecoveryPoint            *date.Time                              `json:"lastRecoveryPoint,omitempty"`
	FriendlyName                 *string                                 `json:"friendlyName,omitempty"`
	ComputerName                 *string                                 `json:"computerName,omitempty"`
	LastBackupStatus             *string                                 `json:"lastBackupStatus,omitempty"`
	ProtectionState              *string                                 `json:"protectionState,omitempty"`
	IsScheduledForDeferredDelete *bool                                   `json:"isScheduledForDeferredDelete,omitempty"`
	DeferredDeleteSyncTimeInUTC  *int64                                  `json:"deferredDeleteSyncTimeInUTC,omitempty"`
	ExtendedInfo                 *MabFileFolderProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
}

// MabFileFolderProtectedItemExtendedInfo is additional information on the
// backed up item.
type MabFileFolderProtectedItemExtendedInfo struct {
	LastRefreshedAt     *date.Time `json:"lastRefreshedAt,omitempty"`
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	RecoveryPointCount  *int32     `json:"recoveryPointCount,omitempty"`
}

// MabJob is mAB workload-specific job.
type MabJob struct {
	EntityFriendlyName   *string               `json:"entityFriendlyName,omitempty"`
	BackupManagementType BackupManagementType  `json:"backupManagementType,omitempty"`
	Operation            *string               `json:"operation,omitempty"`
	Status               *string               `json:"status,omitempty"`
	StartTime            *date.Time            `json:"startTime,omitempty"`
	EndTime              *date.Time            `json:"endTime,omitempty"`
	ActivityID           *string               `json:"activityId,omitempty"`
	Duration             *string               `json:"duration,omitempty"`
	ActionsInfo          *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	MabServerName        *string               `json:"mabServerName,omitempty"`
	MabServerType        MabServerType         `json:"mabServerType,omitempty"`
	WorkloadType         WorkloadType          `json:"workloadType,omitempty"`
	ErrorDetails         *[]MabErrorInfo       `json:"errorDetails,omitempty"`
	ExtendedInfo         *MabJobExtendedInfo   `json:"extendedInfo,omitempty"`
}

// MabJobExtendedInfo is additional information for the MAB workload-specific
// job.
type MabJobExtendedInfo struct {
	TasksList           *[]MabJobTaskDetails `json:"tasksList,omitempty"`
	PropertyBag         *map[string]*string  `json:"propertyBag,omitempty"`
	DynamicErrorMessage *string              `json:"dynamicErrorMessage,omitempty"`
}

// MabJobTaskDetails is mAB workload-specific job task details.
type MabJobTaskDetails struct {
	TaskID    *string    `json:"taskId,omitempty"`
	StartTime *date.Time `json:"startTime,omitempty"`
	EndTime   *date.Time `json:"endTime,omitempty"`
	Duration  *string    `json:"duration,omitempty"`
	Status    *string    `json:"status,omitempty"`
}

// MabProtectionPolicy is mab container-specific backup policy.
type MabProtectionPolicy struct {
	ProtectedItemsCount *int32           `json:"protectedItemsCount,omitempty"`
	SchedulePolicy      *SchedulePolicy  `json:"schedulePolicy,omitempty"`
	RetentionPolicy     *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// MonthlyRetentionSchedule is monthly retention schedule.
type MonthlyRetentionSchedule struct {
	RetentionScheduleFormatType RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`
	RetentionScheduleDaily      *DailyRetentionFormat   `json:"retentionScheduleDaily,omitempty"`
	RetentionScheduleWeekly     *WeeklyRetentionFormat  `json:"retentionScheduleWeekly,omitempty"`
	RetentionTimes              *[]date.Time            `json:"retentionTimes,omitempty"`
	RetentionDuration           *RetentionDuration      `json:"retentionDuration,omitempty"`
}

// NameInfo is the name of usage.
type NameInfo struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// OperationResultInfo is operation result info.
type OperationResultInfo struct {
	JobList *[]string `json:"jobList,omitempty"`
}

// OperationResultInfoBase is base class for operation result info.
type OperationResultInfoBase struct {
}

// OperationResultInfoBaseResource is base class for operation result info.
type OperationResultInfoBaseResource struct {
	autorest.Response `json:"-"`
	StatusCode        HTTPStatusCode           `json:"statusCode,omitempty"`
	Headers           *map[string][]string     `json:"Headers,omitempty"`
	Operation         *OperationResultInfoBase `json:"operation,omitempty"`
}

// OperationStatus is operation status.
type OperationStatus struct {
	autorest.Response `json:"-"`
	ID                *string                      `json:"id,omitempty"`
	Name              *string                      `json:"name,omitempty"`
	Status            OperationStatusValues        `json:"status,omitempty"`
	StartTime         *date.Time                   `json:"startTime,omitempty"`
	EndTime           *date.Time                   `json:"endTime,omitempty"`
	Error             *OperationStatusError        `json:"error,omitempty"`
	Properties        *OperationStatusExtendedInfo `json:"properties,omitempty"`
}

// OperationStatusError is error information associated with operation status
// call.
type OperationStatusError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// OperationStatusExtendedInfo is base class for additional information of
// operation status.
type OperationStatusExtendedInfo struct {
}

// OperationStatusJobExtendedInfo is operation status job extended info.
type OperationStatusJobExtendedInfo struct {
	JobID *string `json:"jobId,omitempty"`
}

// OperationStatusJobsExtendedInfo is operation status extended info for list
// of jobs.
type OperationStatusJobsExtendedInfo struct {
	JobIds          *[]string           `json:"jobIds,omitempty"`
	FailedJobsError *map[string]*string `json:"failedJobsError,omitempty"`
}

// OperationStatusProvisionILRExtendedInfo is operation status extended info
// for ILR provision action.
type OperationStatusProvisionILRExtendedInfo struct {
	RecoveryTarget *InstantItemRecoveryTarget `json:"recoveryTarget,omitempty"`
}

// OperationWorkerResponse is this is the base class for operation result
// responses.
type OperationWorkerResponse struct {
	StatusCode HTTPStatusCode       `json:"statusCode,omitempty"`
	Headers    *map[string][]string `json:"Headers,omitempty"`
}

// ProtectedItem is base class for backup items.
type ProtectedItem struct {
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	WorkloadType         DataSourceType       `json:"workloadType,omitempty"`
	ContainerName        *string              `json:"containerName,omitempty"`
	SourceResourceID     *string              `json:"sourceResourceId,omitempty"`
	PolicyID             *string              `json:"policyId,omitempty"`
	LastRecoveryPoint    *date.Time           `json:"lastRecoveryPoint,omitempty"`
}

// ProtectedItemQueryObject is filters to list backup items.
type ProtectedItemQueryObject struct {
	HealthState          HealthState          `json:"healthState,omitempty"`
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	ItemType             DataSourceType       `json:"itemType,omitempty"`
	PolicyName           *string              `json:"policyName,omitempty"`
	ContainerName        *string              `json:"containerName,omitempty"`
	BackupEngineName     *string              `json:"backupEngineName,omitempty"`
	FriendlyName         *string              `json:"friendlyName,omitempty"`
}

// ProtectedItemResource is base class for backup items.
type ProtectedItemResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Properties        *ProtectedItem      `json:"properties,omitempty"`
}

// ProtectedItemResourceList is list of ProtectedItem resources
type ProtectedItemResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string                  `json:"nextLink,omitempty"`
	Value             *[]ProtectedItemResource `json:"value,omitempty"`
}

// ProtectedItemResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectedItemResourceList) ProtectedItemResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectionContainer is base class for container with backup items.
// Containers with specific workloads are derived from this class.
type ProtectionContainer struct {
	FriendlyName         *string              `json:"friendlyName,omitempty"`
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
	RegistrationStatus   *string              `json:"registrationStatus,omitempty"`
	HealthStatus         *string              `json:"healthStatus,omitempty"`
	ContainerType        ContainerType        `json:"containerType,omitempty"`
}

// ProtectionContainerResource is base class for container with backup items.
// Containers with specific workloads are derived from this class.
type ProtectionContainerResource struct {
	autorest.Response `json:"-"`
	ID                *string              `json:"id,omitempty"`
	Name              *string              `json:"name,omitempty"`
	Type              *string              `json:"type,omitempty"`
	Location          *string              `json:"location,omitempty"`
	Tags              *map[string]*string  `json:"tags,omitempty"`
	ETag              *string              `json:"eTag,omitempty"`
	Properties        *ProtectionContainer `json:"properties,omitempty"`
}

// ProtectionContainerResourceList is list of ProtectionContainer resources
type ProtectionContainerResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string                        `json:"nextLink,omitempty"`
	Value             *[]ProtectionContainerResource `json:"value,omitempty"`
}

// ProtectionContainerResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectionContainerResourceList) ProtectionContainerResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectionPolicy is base class for backup policy. Workload-specific backup
// policies are derived from this class.
type ProtectionPolicy struct {
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
}

// ProtectionPolicyQueryObject is filters the list backup policies API.
type ProtectionPolicyQueryObject struct {
	BackupManagementType BackupManagementType `json:"backupManagementType,omitempty"`
}

// ProtectionPolicyResource is base class for backup policy. Workload-specific
// backup policies are derived from this class.
type ProtectionPolicyResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Properties        *ProtectionPolicy   `json:"properties,omitempty"`
}

// ProtectionPolicyResourceList is list of ProtectionPolicy resources
type ProtectionPolicyResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string                     `json:"nextLink,omitempty"`
	Value             *[]ProtectionPolicyResource `json:"value,omitempty"`
}

// ProtectionPolicyResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectionPolicyResourceList) ProtectionPolicyResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryPoint is base class for backup copies. Workload-specific backup
// copies are derived from this class.
type RecoveryPoint struct {
}

// RecoveryPointResource is base class for backup copies. Workload-specific
// backup copies are derived from this class.
type RecoveryPointResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Properties        *RecoveryPoint      `json:"properties,omitempty"`
}

// RecoveryPointResourceList is list of RecoveryPoint resources
type RecoveryPointResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string                  `json:"nextLink,omitempty"`
	Value             *[]RecoveryPointResource `json:"value,omitempty"`
}

// RecoveryPointResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryPointResourceList) RecoveryPointResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryPointTierInformation is recovery point tier information.
type RecoveryPointTierInformation struct {
	Type   RecoveryPointTierType   `json:"type,omitempty"`
	Status RecoveryPointTierStatus `json:"status,omitempty"`
}

// Resource is aRM Resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
	ETag     *string             `json:"eTag,omitempty"`
}

// ResourceList is base for all lists of resources.
type ResourceList struct {
	NextLink *string `json:"nextLink,omitempty"`
}

// RestoreRequest is base class for restore request. Workload-specific restore
// requests are derived from this class.
type RestoreRequest struct {
}

// RestoreRequestResource is base class for restore request. Workload-specific
// restore requests are derived from this class.
type RestoreRequestResource struct {
	ID         *string             `json:"id,omitempty"`
	Name       *string             `json:"name,omitempty"`
	Type       *string             `json:"type,omitempty"`
	Location   *string             `json:"location,omitempty"`
	Tags       *map[string]*string `json:"tags,omitempty"`
	ETag       *string             `json:"eTag,omitempty"`
	Properties *RestoreRequest     `json:"properties,omitempty"`
}

// RetentionDuration is retention duration.
type RetentionDuration struct {
	Count        *int32                `json:"count,omitempty"`
	DurationType RetentionDurationType `json:"durationType,omitempty"`
}

// RetentionPolicy is base class for retention policy.
type RetentionPolicy struct {
}

// SchedulePolicy is base class for backup schedule.
type SchedulePolicy struct {
}

// SimpleRetentionPolicy is simple policy retention.
type SimpleRetentionPolicy struct {
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// SimpleSchedulePolicy is simple policy schedule.
type SimpleSchedulePolicy struct {
	ScheduleRunFrequency    ScheduleRunType `json:"scheduleRunFrequency,omitempty"`
	ScheduleRunDays         *[]DayOfWeek    `json:"scheduleRunDays,omitempty"`
	ScheduleRunTimes        *[]date.Time    `json:"scheduleRunTimes,omitempty"`
	ScheduleWeeklyFrequency *int32          `json:"scheduleWeeklyFrequency,omitempty"`
}

// TokenInformation is the token information details.
type TokenInformation struct {
	autorest.Response    `json:"-"`
	Token                *string `json:"token,omitempty"`
	ExpiryTimeInUtcTicks *int64  `json:"expiryTimeInUtcTicks,omitempty"`
	SecurityPIN          *string `json:"securityPIN,omitempty"`
}

// WeeklyRetentionFormat is weekly retention format.
type WeeklyRetentionFormat struct {
	DaysOfTheWeek   *[]DayOfWeek   `json:"daysOfTheWeek,omitempty"`
	WeeksOfTheMonth *[]WeekOfMonth `json:"weeksOfTheMonth,omitempty"`
}

// WeeklyRetentionSchedule is weekly retention schedule.
type WeeklyRetentionSchedule struct {
	DaysOfTheWeek     *[]DayOfWeek       `json:"daysOfTheWeek,omitempty"`
	RetentionTimes    *[]date.Time       `json:"retentionTimes,omitempty"`
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// WorkloadProtectableItem is base class for backup item. Workload-specific
// backup items are derived from this class.
type WorkloadProtectableItem struct {
	BackupManagementType *string          `json:"backupManagementType,omitempty"`
	FriendlyName         *string          `json:"friendlyName,omitempty"`
	ProtectionState      ProtectionStatus `json:"protectionState,omitempty"`
}

// WorkloadProtectableItemResource is base class for backup item.
// Workload-specific backup items are derived from this class.
type WorkloadProtectableItemResource struct {
	ID         *string                  `json:"id,omitempty"`
	Name       *string                  `json:"name,omitempty"`
	Type       *string                  `json:"type,omitempty"`
	Location   *string                  `json:"location,omitempty"`
	Tags       *map[string]*string      `json:"tags,omitempty"`
	ETag       *string                  `json:"eTag,omitempty"`
	Properties *WorkloadProtectableItem `json:"properties,omitempty"`
}

// WorkloadProtectableItemResourceList is list of WorkloadProtectableItem
// resources
type WorkloadProtectableItemResourceList struct {
	autorest.Response `json:"-"`
	NextLink          *string                            `json:"nextLink,omitempty"`
	Value             *[]WorkloadProtectableItemResource `json:"value,omitempty"`
}

// WorkloadProtectableItemResourceListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkloadProtectableItemResourceList) WorkloadProtectableItemResourceListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// YearlyRetentionSchedule is yearly retention schedule.
type YearlyRetentionSchedule struct {
	RetentionScheduleFormatType RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`
	MonthsOfYear                *[]MonthOfYear          `json:"monthsOfYear,omitempty"`
	RetentionScheduleDaily      *DailyRetentionFormat   `json:"retentionScheduleDaily,omitempty"`
	RetentionScheduleWeekly     *WeeklyRetentionFormat  `json:"retentionScheduleWeekly,omitempty"`
	RetentionTimes              *[]date.Time            `json:"retentionTimes,omitempty"`
	RetentionDuration           *RetentionDuration      `json:"retentionDuration,omitempty"`
}
