/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace@gnome.org>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */


#include <sane/sane.h>
#include <gnome-scan-module.h>
#include "gsane-backend.h"
#include "gsane-scanner.h"
#include "gsane-common.h"

G_MODULE_EXPORT void
gnome_scan_module_init (GnomeScanModule *module)
{
	SANE_Status status;
	SANE_Int version;
	/* TODO: version checking */
	status = sane_init(&version, NULL);
	gs_debug (G_STRLOC ": SANE version is %i.%i.%i",
			  SANE_VERSION_MAJOR(version),
			  SANE_VERSION_MINOR(version),
			  SANE_VERSION_BUILD(version));
	
	if (SANE_VERSION_MAJOR(version) != SANE_CURRENT_MAJOR) {
		g_warning (G_STRLOC ": SANE major version must be %i.",
				   SANE_CURRENT_MAJOR);
		return;
	}
	
	gsane_scanner_register_type (G_TYPE_MODULE (module));
	gsane_backend_register_type (G_TYPE_MODULE (module));
}

G_MODULE_EXPORT void
gnome_scan_module_finalize (GnomeScanModule *module)
{
	sane_exit();
}

