------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-number_functions.ads,v 1.15 2008/05/05 12:06:47 vagul Exp $

with Interfaces.C;
with OCI.Thick.Gen_OCINumber;

package OCI.Thick.Number_Functions is

   use Thick.Gen_OCINumber;

   function "abs"  is new Unary_Function (OCINumberAbs);
   function ArcCos is new Unary_Function (OCINumberArcCos);
   function ArcSin is new Unary_Function (OCINumberArcSin);
   function ArcTan is new Unary_Function (OCINumberArcTan);
   function Assign is new Unary_Function (OCINumberAssign);
   function Ceil   is new Unary_Function (OCINumberCeil);
   function Cos    is new Unary_Function (OCINumberCos);
   function Exp    is new Unary_Function (OCINumberExp);
   function Floor  is new Unary_Function (OCINumberFloor);
   function HypCos is new Unary_Function (OCINumberHypCos);
   function HypSin is new Unary_Function (OCINumberHypSin);
   function HypTan is new Unary_Function (OCINumberHypTan);
   function Ln     is new Unary_Function (OCINumberLn);
   function "-"    is new Unary_Function (OCINumberNeg);
   function Sin    is new Unary_Function (OCINumberSin);
   function Sqrt   is new Unary_Function (OCINumberSqrt);
   function Tan    is new Unary_Function (OCINumberTan);

   function ArcTan2 is new Binary_Function (OCINumberArcTan2);
   function "+"     is new Binary_Function (OCINumberAdd);
   pragma Inline ("+");
   function "/"     is new Binary_Function (OCINumberDiv);
   pragma Inline ("/");
   function Log     is new Binary_Function (OCINumberLog);
   function "mod"   is new Binary_Function (OCINumberMod);
   function "*"     is new Binary_Function (OCINumberMul);
   pragma Inline ("*");
   function "**"    is new Binary_Function (OCINumberPower);
   function "-"     is new Binary_Function (OCINumberSub);
   pragma Inline ("-");

   function Round is new Integer_Function (Integer, OCINumberRound);
   function Trunc is new Integer_Function (Integer, OCINumberTrunc);
   function Shift is new Integer_Function (Integer, OCINumberShift);
   function "**" is new Integer_Function (Integer, OCINumberIntPower);

   function ">" is new Compare_Function (Interfaces.C.">");
   function "<" is new Compare_Function (Interfaces.C."<");
   function "=" is new Compare_Function (Interfaces.C."=");

   function To_String
     (From : OCINumber; Format : String := "TM9") return String;

   function To_Number (From : String; Format : String) return OCINumber;

   function To_Long_Float is new Num_To_Float (Long_Float);

   function To_Number is new Float_To_Number (Long_Float);

   function To_Integer is new Num_To_Integer (Integer);

   function To_Number is new Int_To_Number (Integer);

   function To_Long_Integer is new Num_To_Integer (Long_Integer);

   function To_Number is new Int_To_Number (Long_Integer);

   function Sign (Num : in OCINumber) return Integer;

   function Is_Zero (Num : in OCINumber) return Boolean;

end OCI.Thick.Number_Functions;
