------------------------------------------------------------------------------
--  Thin Ada binding to OCI (Oracle Call Interface)                     --
--  Copyright (C) 2007-2008 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $RCSfile: oci-thick-containers-enumeration.ads,v $
--  $Revision: 1.5 $ $Date: 2008/03/13 10:25:26 $ $Author: vagul $

limited with OCI.Thick.DB;

generic
   type Enum is (<>);
package OCI.Thick.Containers.Enumeration is

   type Container_Type is new Containers.Container_Type with private;

   procedure Name_Bind_Positions
     (Container : in out Container_Type; Statement : in DB.Statement);
   --  Initialise container bind names index from DB module

   procedure Name_Define_Positions
     (Container : in out Container_Type; Statement : in DB.Statement);
   --  Initialise container define names index from DB module

   function Index
     (Container : in Container_Type; Name : Enum) return Natural;
   --  Returns index of the name in container.
   --  Return 0 if name does not found.
   pragma Inline (Index);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Integer;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Long_Float;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     String;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     OCINumber;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Ada.Calendar.Time;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Lobs.Locator;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Data_Holder;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Set);

   procedure Clear
     (Container : in out Container_Type;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Clear);

   function Is_Null
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Boolean;
   pragma Inline (Is_Null);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Integer;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Long_Float;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return String;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return OCINumber;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Ada.Calendar.Time;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Lobs.Locator;
   pragma Inline (Get);

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Data_Holder;
   pragma Inline (Get);

   procedure Get
     (Container : in     Container_Type;
      Item      :    out Data_Holder;
      Name      : in     Enum;
      Iteration : in     Positive := 1);
   pragma Inline (Get);

private

   type Index_Type is array (Enum) of Natural;

   type Container_Type is new Containers.Container_Type with record
      Index : Index_Type := (others => 0);
   end record;

end OCI.Thick.Containers.Enumeration;
