// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include <string.h>
#include <sys/types.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include "Six69.h"
#include "Sequencer.h"

void removeNoprint(char *);

int
Six69_sample::load(Sequencer &seq, FILE * modFd, int sampleNo, int cutFactor,
		   void *header, void *)
{
  int bytesRead;
  unsigned char *buf = (unsigned char *)header;

  sampleNum_ = sampleNo;
  mode_ = WAVE_UNSIGNED;
  length_ = INTEL_LONG(buf + 13);
  loopStart = INTEL_LONG(buf + 17);
  loopEnd = INTEL_LONG(buf + 21);

  if (loopEnd > length_)
    loopEnd = 0;

#if 0
  else if (loopEnd == length_)
    loopEnd--;

  if (loopEnd < loopStart)
    {
      loopStart = 0;
      loopEnd = 0;
    }
#endif

  strncpy(name_, buf, 13);
  name_[13] = '\0';
  removeNoprint(name_);

#if 0
  if (loopEnd == 0)
    loopEnd = 1;
  if (loopEnd >= length_)
    loopEnd = 1;
#endif
  
  if (loopEnd > 2)
    mode_ |= WAVE_LOOPING;
  
  baseFreq_ = NTSC_RATE;
  baseNote_ = C2FREQ;

  if (length_ > 0)
    ok_ = !seq.patchLoad(modFd, sampleNo, *this, bytesRead, cutFactor);
  else
    ok_ = 0;

  return bytesRead;
}
