typedef struct {
  int id;
  char* description;
  unsigned int size;
  char** symbols;
} ghmm_alphabet;

%extend ghmm_alphabet {
        ghmm_alphabet(size_t size, char* desc) {
            int len = strlen(desc)+1;
            char *d = malloc(len);
            ghmm_alphabet* a = calloc(1, sizeof(ghmm_alphabet));
            a->symbols = calloc(size, sizeof(char*));
            d = strncpy(d, desc, len);
            a->description = d;
            a->size = size;
            return a;
        }
       ~ghmm_alphabet() {
            int i;
            for(i=0; i<self->size; ++i)
                free(self->symbols[i]);
            free(self->symbols);
            free(self->description);
            free(self);
        }

        char* getSymbol(size_t index) { return self->symbols[index]; }
        void  setSymbol(size_t index, char* s) {
            int len = strlen(s)+1;
            char *sym = malloc(len);
            sym = strncpy(sym, s, len);
            self->symbols[index] = sym;
        }
}