#!/bin/sh -e

conffile="/etc/fwanalog/fwanalog.opts"
debianconf="/etc/default/fwanalog"
fwanalog_cmd="/usr/bin/fwanalog"

[ -x "$fwanalog_cmd" -a -f "$debianconf" -a -f "$conffile" ] || exit 0

. "$debianconf"
. "$conffile"

if [ "$CRON" = "true" ]; then
	# if MAILTO is set we first generate statistics for today and mail them
	if [ "$MAILTO" != "" ]; then
		su fwanalog -c "nice $fwanalog_cmd -t" > /dev/null >&1 && cat "$outdir/today.txt" | mail -s "Daily fwanalog report" $MAILTO
	fi
	# and then we call the script normally
	su fwanalog -c "nice $fwanalog_cmd" > /dev/null >&1
fi
