'''OpenGL extension ATI.fragment_shader

This module customises the behaviour of the 
OpenGL.raw.GL.ATI.fragment_shader to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension exposes a powerful fragment shading model which
	provides a very general means of expressing fragment color blending
	and dependent texture address modification.  The programming is
	a register-based model in which there is a fixed number of 
	instructions, texture lookups, read/write registers, and constants.
	
	The fragment shader extension provides a unified instruction set
	for operating on address or color data and eliminates the 
	distinction between the two.  This extension provides all the 
	interfaces necessary to fully expose this programmable fragment 
	shader in GL.
	
	Although conceived as a device-independent extension which would 
	expose the capabilities of future generations of hardware, changing 
	trends in programmable hardware have affected the lifespan of this 
	extension.  For this reason you will now find a fixed set of 
	features and resources exposed, and the queries to determine this 
	set have been deprecated.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ATI/fragment_shader.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ATI.fragment_shader import *
from OpenGL.raw.GL.ATI.fragment_shader import _EXTENSION_NAME

def glInitFragmentShaderATI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION