'''OpenGL extension HP.image_transform

This module customises the behaviour of the 
OpenGL.raw.GL.HP.image_transform to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides support for scaling, rotation, and translation
	of two-dimensional pixel rectangles at a fixed location in the pixel
	transfer process.  The 2D image transformation attributes are specified
	as individual values so that that implementations may easily detect
	scaling and rotation values that lend themselves to optimization.  2D
	image transformation occurs immediately after the post-convolution color
	table stage of the pixel pipeline.  This extension also defines a color
	table that is applied immediately after the image transformation operation.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/HP/image_transform.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.HP.image_transform import *
from OpenGL.raw.GL.HP.image_transform import _EXTENSION_NAME

def glInitImageTransformHP():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION