/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.AbstractDelegateRule;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleReference
extends AbstractDelegateRule {
    private String name;
    private Properties properties;
    private String message;
    private String description;
    private List<String> examples;
    private String externalInfoUrl;
    private Integer priority;
    private RuleSetReference ruleSetReference;

    public String getOverriddenName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!RuleReference.isSame(name, super.getName()) || this.name != null) {
            this.name = name;
            super.setName(name);
        }
    }

    public Properties getOverriddenProperties() {
        return this.properties;
    }

    @Override
    public void addProperty(String name, String property) {
        if (!super.hasProperty(name) || !RuleReference.isSame(property, super.getStringProperty(name))) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put(name, property);
            super.addProperty(name, property);
        }
    }

    @Override
    public void addProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String getOverriddenMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        if (!RuleReference.isSame(message, super.getMessage()) || this.message != null) {
            this.message = message;
            super.setMessage(message);
        }
    }

    public String getOverriddenDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (!RuleReference.isSame(description, super.getDescription()) || this.description != null) {
            this.description = description;
            super.setDescription(description);
        }
    }

    public List<String> getOverriddenExamples() {
        return this.examples;
    }

    @Override
    public void addExample(String example) {
        if (!RuleReference.contains(super.getExamples(), example)) {
            if (this.examples == null) {
                this.examples = new ArrayList<String>(1);
            }
            this.examples.clear();
            this.examples.add(example);
            super.addExample(example);
        }
    }

    public String getOverriddenExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String externalInfoUrl) {
        if (!RuleReference.isSame(externalInfoUrl, super.getExternalInfoUrl()) || this.externalInfoUrl != null) {
            this.externalInfoUrl = externalInfoUrl;
            super.setExternalInfoUrl(externalInfoUrl);
        }
    }

    public Integer getOverriddenPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        if (priority != super.getPriority() || this.priority != null) {
            this.priority = priority;
            super.setPriority(priority);
        }
    }

    public RuleSetReference getRuleSetReference() {
        return this.ruleSetReference;
    }

    public void setRuleSetReference(RuleSetReference ruleSetReference) {
        this.ruleSetReference = ruleSetReference;
    }

    private static boolean isSame(String s1, String s2) {
        return StringUtil.isSame(s1, s2, true, false, true);
    }

    private static boolean contains(Collection<String> collection, String s1) {
        for (String s2 : collection) {
            if (!RuleReference.isSame(s1, s2)) continue;
            return true;
        }
        return false;
    }
}

