/* $Id: player.h,v 1.9 2003/05/25 18:12:49 paul Exp $ */

#ifndef FFRENZY_PLAYER_H
#define FFRENZY_PLAYER_H

#include "global.h"
#include "model.h"

/** \file
 * Player object specific functions and defines.
 */

/* Player settings */
#define PL_MAX_UNCONC     100   /**< Maximum #ticks unconscious after hit. */
#define PL_MAX_POWEREDUP  400   /**< Maximum #ticks powered up. */
#define PL_MAX_LIFE       1000  /**< Maximum life of player. */
#define PL_MAX_FOOD       12    /**< Size food stack (> PL_X_ACCEL_GROUND). */
#define PL_DEC_LIFE       1     /**< Decrease of players life per tick. */

/* Player mechanics settings */
#define PL_X_MAX_SPEED    80    /**< Maximum X speed. */

#define PL_X_SPEED_JUMP   10    /**< Initial X speed on jump (abs. value) */
#define PL_Y_SPEED_JUMP   175   /**< Initial Y speed on jump. */

#define PL_X_ACCEL_GROUND 18    /**< Acceleration for walking. */
#define PL_X_ACCEL_AIR    13    /**< Acceleration for flying. */

#define PL_X_FRICT_GROUND 30    /**< Friction (decleration) for walking. */
#define PL_X_FRICT_AIR    7     /**< Friction for flying. */

/** Function to make player \a p pickup food of type \a foodtype.
  * \param m        Model player is member of.
  * \param p        Player that wants to pickup the food.
  * \param f        Food object that player may pick up.
  * \return \c FALSE if player can't pickup food (stack full) and
  *         \c TRUE if successful. */
int player_pickup_food(Model *m, Model_object *p, Model_object *f);

/** Function to handle player \a p gets hit by object \a o and
  * becomes unconscious.
  * \param m Model player is member of.
  * \param p Player that possibly gets hit.
  * \param f Food object that player gets hit by.
  * \return \c FALSE if player can't get hit (food has no owner), \c TRUE
  *         if successful. */
int player_gets_hit(Model *m, Model_object *p, Model_object *f);

/** Handles one tick for a player object. Handles flags set on object
 *  that were set in reaction to input from I/O layer:
 *  move in X direction, jump or do action.
 *  Also implements gravity and calculates desired new speed and position.
 *  \param m Model the player lives in.
 *  \param o Player object.
 */
void player_tick(Model *m, Model_object *o);

#endif /* FFRENZY_PLAYER_H */
