/* $Id: levelloader.h,v 1.17 2003/06/12 13:27:59 eneggers Exp $ */
#ifndef FFRENZY_LEVELLOADER_H
#define FFRENZY_LEVELLOADER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#include "global.h"
#include "vector.h"
#include "list.h"

typedef struct {
	int type;
	Vector *pos;
	Vector *size;
	char *svgseries;
} Level_object;

typedef enum {
	LEVEL_VECTOR,
	LEVEL_INT,
	LEVEL_INT32_T
} Level_types;

typedef struct {
	char *name;
	int type;
	union {
		Vector *vval;
		int ival;
		int32_t i32val;
	} data;
} Level_setting;

typedef struct {
	int id;
	Vector *size;
	char *svgseries;
} Level_type;

typedef struct {
	int id;

	Vector *pos;
	Vector *size;
	
	Vector *home_pos;
	Vector *home_size;

	char *svgseries;
	char *home_svgseries;
} Level_player;

typedef struct {
	int gfxid;
	int type;
	char *svgseries;
} _Level_graphic;

typedef struct {
	char *name;
	char *background;
	Vector *size;
	List *types;
	List *graphics;
	List *objects; /* list of Level_object */
	List_ptr *_next_object;
	int numplayers;
	List *players;
	List *settings;
	List_ptr *_next_setting;
} Level;

/* Parse xml level file and store it into a Level */
Level *new_level(char *data);
Level *new_levelfile(char *filename);

/* Destroy levelpack */
void del_level(Level *lp);

/* Get next Level_object or NULL if none is available */
Level_object *level_next_object(Level *l);

/* Reset position in level_objects to beginning of list */
void level_reset_object(Level *l);

/* Get Level_player or NULL if none is available */
Level_player *level_get_player(Level *l, int id);

/* Get svgseries (graphic) for a specific type of object */
char *level_get_svgseries(Level *l, int type);

/* Get default object type size */
Level_type *level_get_type(Level *l, int o_type);
Vector *level_get_type_size(Level *l, int o_type);

/* Get next Level_setting or NULL if none is available */
Level_setting *level_next_setting(Level *l);

/* Reset position in level_settings to beginning of list */
void level_reset_setting(Level *l);

#endif /* FFRENZY_LEVELLOADER_H */
