/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class JavaFile
extends File {
    private static final String[] regexpStr = new String[]{"^java version \"(\\d+)\\.(\\d+).*\"", "^java version \"HP-UX Java [A-Z]\\.\\d+\\.(\\d)(\\d+).*\""};
    private static RE[] regexp = null;
    private static Runtime runtime = null;
    private String fullString;
    private int major;
    private int minor;

    public JavaFile(String path) {
        this(new File(path));
    }

    public JavaFile(File path) {
        this(path.getParent(), path.getName());
    }

    public JavaFile(String parent, String child) {
        this(new File(parent), child);
    }

    public JavaFile(File path, String name) {
        super(path, name);
        this.findVersion();
    }

    private final void findVersion() {
        Process proc;
        if (regexp == null) {
            this.initRegExp();
        }
        if (runtime == null) {
            runtime = Runtime.getRuntime();
        }
        try {
            proc = runtime.exec(this + " -version");
        }
        catch (IOException ioe) {
            System.err.println("While running '" + this + " -version':");
            ioe.printStackTrace();
            proc = null;
        }
        boolean found = false;
        if (proc != null) {
            InputStream is = proc.getErrorStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            block4: while (!found) {
                String line;
                try {
                    line = in.readLine();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    break;
                }
                if (line == null) break;
                for (int i = 0; i < regexp.length; ++i) {
                    REMatch match = regexp[i].getMatch(line);
                    if (match == null) continue;
                    this.fullString = line.substring(match.getStartIndex(), match.getEndIndex());
                    this.major = JavaFile.parseInt(line.substring(match.getSubStartIndex(1), match.getSubEndIndex(1)));
                    this.minor = JavaFile.parseInt(line.substring(match.getSubStartIndex(2), match.getSubEndIndex(2)));
                    found = true;
                    continue block4;
                }
            }
        }
        if (!found) {
            this.fullString = null;
            this.minor = -1;
            this.major = -1;
        }
    }

    public String getVersionString() {
        return this.fullString;
    }

    private static final int parseInt(String intStr) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void initRegExp() {
        String[] stringArray = regexpStr;
        synchronized (regexpStr) {
            regexp = new RE[regexpStr.length];
            int bad = 0;
            for (int i = 0; i < regexpStr.length; ++i) {
                try {
                    JavaFile.regexp[i] = new RE(regexpStr[i]);
                    continue;
                }
                catch (REException ree) {
                    System.err.println("For regexp \"" + regexpStr[i] + "\":");
                    ree.printStackTrace();
                    ++bad;
                    JavaFile.regexp[i] = null;
                }
            }
            if (bad > 0) {
                RE[] tmpRE = new RE[regexp.length - bad];
                int j = 0;
                for (int i = 0; i < regexp.length; ++i) {
                    if (regexp[i] == null) continue;
                    tmpRE[j++] = regexp[i];
                }
                regexp = tmpRE;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final boolean matchMinimum(int major, int minor) {
        return this.major > major || this.major == major && this.minor >= minor;
    }
}

