/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds.server;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.ui.StopButton;

public class TestTDSdataset
implements Runnable {
    private int who;
    private String datasetUrl;
    private StopButton stop;
    public static JPanel main;

    TestTDSdataset(int who, String datasetUrl) {
        this.who = who;
        this.datasetUrl = datasetUrl;
        this.stop = new StopButton("stopit goddammit!");
        main.add(this.stop);
    }

    public void run() {
        long total = 0L;
        long time = 0L;
        System.out.println(this.who + " start");
        try {
            NetcdfFile ncfile = NetcdfDataset.openFile(this.datasetUrl, this.stop);
            List<Variable> vars = ncfile.getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                Variable v = vars.get(i);
                long size = v.getSize() * (long)v.getElementSize();
                System.out.println(this.who + " request " + v.getName() + " size = " + size);
                long start = System.currentTimeMillis();
                v.read();
                long took = System.currentTimeMillis() - start;
                double rate = took == 0L ? 0.0 : (double)(size / took) / 1000.0;
                System.out.println(" ok===" + this.who + " request " + v.getName() + " size = " + size + " took=" + took + " msec = " + rate + "Mbytes/sec");
                total += size;
                time += took;
                if (this.stop.isCancel()) break;
            }
            double totald = (double)total / 1000000.0;
            double rate = (double)(total / time) / 1000.0;
            System.out.println(this.datasetUrl + " == " + this.who + " total= " + totald + " Mbytes; took = " + time / 1000L + "secs = " + rate + "Mbytes/sec");
            ncfile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        int i;
        JFrame frame = new JFrame("TestTDSdataset");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        String dataset = "http://motherlode.ucar.edu:9080/thredds/dodsC/modelsNc/NCEP/NAM/CONUS_80km/NAM_CONUS_80km_20070501_1200.nc";
        DODSNetcdfFile.setAllowCompression(true);
        int n = 1;
        TestTDSdataset[] ta = new TestTDSdataset[n];
        for (i = 0; i < n; ++i) {
            ta[i] = new TestTDSdataset(i, dataset);
        }
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(40, 300);
        frame.setVisible(true);
        for (i = 0; i < n; ++i) {
            Thread t = new Thread(ta[i]);
            t.start();
        }
    }
}

