/*
 * Decompiled with CFR 0.152.
 */
package thredds.viewer.ui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public abstract class Rubberband {
    protected Point anchorPt = new Point(0, 0);
    protected Point stretchedPt = new Point(0, 0);
    protected Point lastPt = new Point(0, 0);
    protected Point endPt = new Point(0, 0);
    protected Component component;
    protected boolean firstStretch = true;
    private boolean active = false;

    public abstract void drawLast(Graphics2D var1);

    public abstract void drawNext(Graphics2D var1);

    public Rubberband(Component c, boolean listen) {
        this.component = c;
        if (listen) {
            this.setListeners();
        }
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public boolean isActive() {
        return this.active;
    }

    private void setListeners() {
        this.component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                Rubberband.this.anchor(event.getPoint());
                Rubberband.this.setActive(true);
            }

            public void mouseReleased(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.end(event.getPoint());
                }
                Rubberband.this.setActive(false);
            }
        });
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.stretch(event.getPoint());
                }
            }
        });
    }

    public Point getAnchor() {
        return this.anchorPt;
    }

    public Point getStretched() {
        return this.stretchedPt;
    }

    public Point getLast() {
        return this.lastPt;
    }

    public Point getEnd() {
        return this.endPt;
    }

    public boolean anchor(Point p) {
        this.firstStretch = true;
        this.anchorPt.x = p.x;
        this.anchorPt.y = p.y;
        this.stretchedPt.x = this.lastPt.x = this.anchorPt.x;
        this.stretchedPt.y = this.lastPt.y = this.anchorPt.y;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stretch(Point p) {
        this.lastPt.x = this.stretchedPt.x;
        this.lastPt.y = this.stretchedPt.y;
        this.stretchedPt.x = p.x;
        this.stretchedPt.y = p.y;
        Graphics2D g = (Graphics2D)this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                if (this.firstStretch) {
                    this.firstStretch = false;
                } else {
                    this.drawLast(g);
                }
                this.drawNext(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Point p) {
        this.lastPt.x = this.endPt.x = p.x;
        this.lastPt.y = this.endPt.y = p.y;
        Graphics2D g = (Graphics2D)this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                this.drawLast(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Graphics2D g = (Graphics2D)this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                this.drawLast(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.stretchedPt.x < this.anchorPt.x ? this.stretchedPt.x : this.anchorPt.x, this.stretchedPt.y < this.anchorPt.y ? this.stretchedPt.y : this.anchorPt.y, Math.abs(this.stretchedPt.x - this.anchorPt.x), Math.abs(this.stretchedPt.y - this.anchorPt.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.lastPt.x < this.anchorPt.x ? this.lastPt.x : this.anchorPt.x, this.lastPt.y < this.anchorPt.y ? this.lastPt.y : this.anchorPt.y, Math.abs(this.lastPt.x - this.anchorPt.x), Math.abs(this.lastPt.y - this.anchorPt.y));
    }
}

