/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.XMLparser;

import gnu.getopt.Getopt;
import java.io.FileInputStream;
import opendap.dap.DAS;
import opendap.dap.DefaultFactory;
import opendap.dap.Server.ServerDDS;

public class XmlTest {
    public static void main(String[] args) throws Exception {
        int c;
        boolean validation = false;
        Getopt g = new Getopt("XmlTest", args, "v::");
        int acount = 0;
        block4: while ((c = g.getopt()) != -1) {
            ++acount;
            switch (c) {
                case 118: {
                    String arg = g.getOptarg();
                    validation = true;
                    continue block4;
                }
                case 63: {
                    System.out.println(" ");
                    System.out.println(" ");
                    System.out.println("Usage: XmlTest [-v] ddxfile1 [ddxfile2] [ddxfile3] ...");
                    System.out.println("Uses the DDSXMLParser to parse OPeNDAP DDX files.");
                    System.out.println("Successful parsing leads to the display of the DDS, DAS");
                    System.out.println("and the original DDX files onto <stdout>.");
                    System.out.println("");
                    System.out.println("Options:");
                    System.out.println("    v   This option causes the XML parser to validate");
                    System.out.println("        the DDX document against the OPeNDAP Schema. The");
                    System.out.println("        Schema used to validate is the one referenced in ");
                    System.out.println("        the DDX file. If the instance is unreachable then");
                    System.out.println("        the parse will fail. Without this option the parser");
                    System.out.println("        WILL NOT schema validate the document.");
                    System.out.println(" ");
                    System.out.println(" ");
                    System.exit(0);
                    continue block4;
                }
            }
            System.out.print("getopt() returned " + c + "\n");
        }
        if (validation) {
            System.out.println("Parser will validate documents using Schema reference.");
        } else {
            System.out.println("Parser will NOT validate documents.");
        }
        for (int i = acount; i < args.length; ++i) {
            System.out.println("Parsing File: '" + args[i] + "'");
            FileInputStream fis = new FileInputStream(args[i]);
            DefaultFactory btf = new DefaultFactory();
            ServerDDS dds = new ServerDDS(btf);
            dds.parseXML(fis, validation);
            System.out.println("\n\n\n\nTHE DDS:\n");
            dds.print(System.out);
            System.out.println("\n\nThe DAS, from DDS.printDAS():\n");
            dds.printDAS(System.out);
            System.out.println("\n\nThe DAS object, from DDS.getDAS():\n");
            DAS thisDAS = dds.getDAS();
            thisDAS.print(System.out);
            dds.printXML(System.out);
        }
    }
}

