/*
 * $Id: telephone_isp_gui_gtk.c,v 1.19 2012-02-22 09:27:21 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-switch.h"
#include "glue.h"

#include "telephone_isp_gui_gtk.h"

#define COMP "telephone_isp"

struct cpssp {
	GtkWidget *widget;

	struct sig_boolean *port_switch;
};

/*
 * Simulator Callbacks
 */
static void
telephone_isp_switch_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_switch_set(GUI_GTK_SWITCH(cpssp->widget), (gboolean) val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
telephone_isp_switched_on_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_switch, cpssp, 1);
}

static void
telephone_isp_switched_off_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_switch, cpssp, 0);
}

void *
telephone_isp_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_telephone *port_phone,
	struct sig_boolean *port_switch
)
{
	static const struct sig_boolean_funcs switch_funcs = {
		.set = telephone_isp_switch_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->widget = gui_gtk_switch_new();
	g_signal_connect(G_OBJECT(cpssp->widget), "switched-on",
			G_CALLBACK(telephone_isp_switched_on_event),
			cpssp);
	g_signal_connect(G_OBJECT(cpssp->widget), "switched-off",
			G_CALLBACK(telephone_isp_switched_off_event),
			cpssp);
	gtk_widget_show(cpssp->widget);
	gui_gtk_comp_add(page, COMP, name, cpssp->widget, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_switch = port_switch;
	sig_boolean_connect_out(port_switch, cpssp, 0);

	/* In */
	sig_boolean_connect_in(port_switch, cpssp, &switch_funcs);

	return cpssp;
}

void 
telephone_isp_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
telephone_isp_gui_gtk_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
telephone_isp_gui_gtk_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	GtkWidget *savewidget = cpssp->widget;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	cpssp->widget = savewidget;
}
