/*
 * $Id: arch_local_ip.c,v 1.4 2009-01-28 12:59:16 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DEBUG_LOCAL_IP	0

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>
#include <netinet/ip.h>

#endif /* INCLUDE */

#ifdef STATE
#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(dump)(const unsigned char *buf, unsigned int len)
{
#if DEBUG_LOCAL_IP
	unsigned int i;

	for (i = 0; i < len; i++) {
		if (i % 16 == 0) {
			fprintf(stderr, "%5u:", i);
		}
		fprintf(stderr, " %02x", buf[i]);
		if (i % 16 == 15) {
			fprintf(stderr, "\n");
		}
	}
	fprintf(stderr, "\n");
#endif
}

static void
NAME_(from_tcp)(void *cpssp, const unsigned char *buf, unsigned int len)
{
	NAME_(dump)(buf, len);
	NAME_(to_route_ip)(cpssp, buf, len);
}

static void
NAME_(from_udp)(void *cpssp, const unsigned char *buf, unsigned int len)
{
	NAME_(dump)(buf, len);
	NAME_(to_route_ip)(cpssp, buf, len);
}

static void
NAME_(from_route_ip)(void *cpssp, const unsigned char *buf, unsigned int len)
{
	const struct ip *iphdr = (const struct ip *) buf;

	NAME_(dump)(buf, len);
	switch (iphdr->ip_p) {
	case 6: /* TCP */
		NAME_(to_tcp)(cpssp, buf, len);
		break;
	case 17: /* UDP */
		NAME_(to_udp)(cpssp, buf, len);
		break;
	default:
		fprintf(stderr, "FAUmachine: WARNING: %s %u.\n",
				__FUNCTION__, iphdr->ip_p);
		break;
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#undef DEBUG_LOCAL_IP

#endif /* BEHAVIOR */
