/*
 * $Id: log.h,v 1.4 2009-01-27 17:44:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef LOG_H_INCLUDED
#define LOG_H_INCLUDED

enum log_level { 
	LOG_ERROR, 
	LOG_WARNING, 
	LOG_NOTICE, 
	LOG_DEBUG, 
	LOG_DEBUG2, 
	LOG_DEBUG3 
};

extern void logit(enum log_level,const char*,...);
extern void fatal_error(const char *,...) __attribute__((__noreturn__));
extern void log_inc(void);
extern void log_dec(void);
extern void log_set_log_level(enum log_level);

#endif /* LOG_H_INCLUDED */
