/* $Id: cim_keyboard.c,v 1.6 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_keyboard.h"

struct cim_keyboard_buf {
	enum {
		CIM_KEYBOARD_KEY_PRESS,
		CIM_KEYBOARD_KEY_RELEASE,
		CIM_KEYBOARD_LED_ON,
		CIM_KEYBOARD_LED_OFF,
	} type;
	union {
		uint32_t key;
		uint32_t led;
	};
};

static int
cim_keyboard__key_press(void *_css, unsigned int key)
{
	struct cim_keyboard *css = (struct cim_keyboard *) _css;
	struct cim_keyboard_buf buf;

	buf.type = CIM_KEYBOARD_KEY_PRESS;
	buf.key = key;

	cim_send(&css->bridge, &buf, sizeof(buf));
	return 0;
}

static int
cim_keyboard__key_release(void *_css, unsigned int key)
{
	struct cim_keyboard *css = (struct cim_keyboard *) _css;
	struct cim_keyboard_buf buf;

	buf.type = CIM_KEYBOARD_KEY_RELEASE;
	buf.key = key;

	cim_send(&css->bridge, &buf, sizeof(buf));
	return 0;
}

static int
cim_keyboard__led_on(void *_css, unsigned int led)
{
	struct cim_keyboard *css = (struct cim_keyboard *) _css;
	struct cim_keyboard_buf buf;

	buf.type = CIM_KEYBOARD_LED_ON;
	buf.led = led;

	cim_send(&css->bridge, &buf, sizeof(buf));
	return 0;
}

static int
cim_keyboard__led_off(void *_css, unsigned int led)
{
	struct cim_keyboard *css = (struct cim_keyboard *) _css;
	struct cim_keyboard_buf buf;

	buf.type = CIM_KEYBOARD_LED_OFF;
	buf.led = led;

	cim_send(&css->bridge, &buf, sizeof(buf));
	return 0;
}

static void
cim_keyboard_interrupt(void *_css, void *_buf, unsigned int bufsize)
{
	struct cim_keyboard *css = (struct cim_keyboard *) _css;
	struct cim_keyboard_buf *buf = (struct cim_keyboard_buf *) _buf;

	assert(bufsize == sizeof(*buf));

	switch (buf->type) {
	case CIM_KEYBOARD_KEY_PRESS:
		(void) sig_keyboard_key_press(css->sig_keyboard, css,
				buf->key);
		break;
	case CIM_KEYBOARD_KEY_RELEASE:
		(void) sig_keyboard_key_release(css->sig_keyboard, css,
				buf->key);
		break;
	case CIM_KEYBOARD_LED_ON:
		(void) sig_keyboard_led_on(css->sig_keyboard, css,
				buf->led);
		break;
	case CIM_KEYBOARD_LED_OFF:
		(void) sig_keyboard_led_off(css->sig_keyboard, css,
				buf->led);
		break;
	default:
		assert(0); /* Cannot happen. */
	}
}

void
cim_keyboard_init(struct cim_keyboard *css, struct sig_keyboard *sig_keyboard)
{
	static const struct sig_keyboard_funcs funcs = {
		.key_press = cim_keyboard__key_press,
		.key_release = cim_keyboard__key_release,
		.led_on = cim_keyboard__led_on,
		.led_off = cim_keyboard__led_off,
	};

	cim_connect(&css->bridge, cim_keyboard_interrupt, css);

	css->sig_keyboard = sig_keyboard;
	sig_keyboard_connect(sig_keyboard, css, &funcs);
}

void
cim_keyboard_create(struct cim_keyboard *css)
{
	cim_create(&css->bridge);
}

void
cim_keyboard_destroy(struct cim_keyboard *css)
{
	cim_destroy(&css->bridge);
}
