/* $Id: cim_audio.c,v 1.7 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_audio.h"

static void
cim_audio_samples_set(void *_cpss, int16_t *buf)
{
	struct cim_audio *cpss = (struct cim_audio *) _cpss;

	cim_send(&cpss->bridge, buf, SIG_SOUND_MTU);
}

static void
cim_audio_receive(void *_cpss, void *_buf, unsigned int bufsize)
{
	struct cim_audio *cpss = (struct cim_audio *) _cpss;
	int16_t *buf = (int16_t *) _buf;

	sig_sound_samples_set(cpss->sig_audio, cpss, buf);
}

void
cim_audio_init(struct cim_audio *cpss, struct sig_sound *sig_audio)
{
	static const struct sig_sound_funcs funcs = {
		.samples_set = cim_audio_samples_set,
	};

	cim_connect(&cpss->bridge, cim_audio_receive, cpss);

	cpss->sig_audio = sig_audio;
	sig_sound_connect(sig_audio, cpss, &funcs);
}

void
cim_audio_create(struct cim_audio *cpss)
{
	cim_create(&cpss->bridge);
}

void
cim_audio_destroy(struct cim_audio *cpss)
{
	cim_destroy(&cpss->bridge);
}
