# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2014 Bastian Kleineidam
from re import compile
from ..scraper import make_scraper
from ..util import tagre, quote, fetchUrl, case_insensitive_re, getPageContent

# SmackJeeves is a crawlers nightmare - users are allowed to edit HTML directly.
# That's why there are so much different search patterns.

_imageSearch = compile(tagre("img", "src", r'([^"]+)', after='id="comic_image"'))
_linkSearch = tagre("a", "href", r'([^>"]*/comics/\d+/[^>"]*)', quote='"?')
_attrs = dict(
    back = case_insensitive_re("back"),
    prev = case_insensitive_re("prev"),
    next = case_insensitive_re("next"),
)
_prevSearch = (
    compile(_linkSearch +
  r'(?:<img[^>]+alt="[^"]*%(prev)s|<img[^>]+(?:button_previous|naviButtons_Previous|nav_prev4|prev|previous|webbuttonback|PrevArrow)\.|[^<]*%(back)s|\s*<<? (?:%(back)s|%(prev)s)|[^<]*%(prev)s)' % _attrs),
    compile(_linkSearch + r'[^<]*Atras<'),
    compile(_linkSearch + tagre("img", "src", r'[^"]+/(?:backrg|JZj4a3C|b5175a677Zd6b)\.png')),
    compile(_linkSearch + tagre("img", "src", r"[^']+/(?:backnav)\.png", quote="'")),
    compile(_linkSearch + r"\s*" + tagre("img", "src", r'[^"]+/prev\.jpg')),
)
_nextSearch = (
    compile(_linkSearch +
  r'(?:<img[^>]+alt="%(next)s|<img[^>]+(?:button_next|naviButtons_Next|nav_next4|next|webbuttonnext-1|NextArrow)\.|\s*<?[^<]*%(next)s)' % _attrs),
    compile(_linkSearch + r'Siguiente'),
    compile(_linkSearch + tagre("img", "src", r'[^"]+/(?:arrow3_zps03f490e3|60ecbaed7gbJs)\.png[^"]*')),
    compile(_linkSearch + tagre("img", "src", r"[^']+/(?:forthnav)\.png[^']*", quote="'")),
)

def add(name, url, description, adult, bounce):
    classname = 'SmackJeeves_' + name

    def modifier(pageUrl):
        if adult:
            # mature content can be viewed directly with:
            # http://www.smackjeeves.com/mature.php?ref=<percent-encoded-url>
            return 'http://www.smackjeeves.com/mature.php?ref=' + quote(pageUrl)
        return pageUrl

    @classmethod
    def _starter(cls):
        """Get start URL."""
        url1 = modifier(url)
        data, baseUrl = getPageContent(url1, cls.session)
        url2 = fetchUrl(url1, data, baseUrl, cls.prevSearch)
        if bounce:
            data, baseUrl = getPageContent(url2, cls.session)
            url3 = fetchUrl(url2, data, baseUrl, _nextSearch)
            return modifier(url3)
        return modifier(url2)

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        parts = pageUrl.split('/')
        name = parts[-2]
        num = parts[-3]
        return "%s_%s" % (name, num)

    globals()[classname] = make_scraper(classname,
        name = 'SmackJeeves/' + name,
        adult = adult,
        url = url,
        starter = _starter,
        prevUrlModifier = lambda cls, url: modifier(url),
        stripUrl = url + '%s/',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        prevUrlMatchesStripUrl = not adult,
        description = description,
        lang = 'es' if name.lower().endswith('spanish') else 'en',
        help = 'Index format: nnnn (some increasing number)',
        namer = namer,
    )


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('12years', 'http://12years.smackjeeves.com/comics/', u'READ [12 ]YEARS ON TAPASTIC! (with background music! come on, i know you like it ;D) http://tapastic.com/series/12years - - - - - "YANAKI TENJOU is a 16 year-old lovesick young lady who received a strangely alluring pendant from an old lady. after a long day, she sleeps and wakes up. ...she wakes up only to find out that she\'s in her 28 year-old body ... 12 years from the future !" - - - - - WARNING: *mediocre art on the first few chapters. i promise i will improve on the later chapters. i promise. *contains mushy mushy romance and heavy drama (on the later chapters, atleast) *contains awful typo errors. please don\'t mind such thing. i know i\'m horrible. +++ SUPPORT [12 YEARS]! http://facebook.com/12saimanga DIRECTION: READ FROM LEFT TO RIGHT. ______________________ [12 years] (C) masayahingArtist 2012-2013', False, True)
add('1cek1dsmuseumofreallycrazystuff', 'http://hai.smackjeeves.com/comics/', u"Hai. This is basicly a dump for my sprites, comics, game ideas, charectors, and basic everyday stuff. Expect nothing that YOU'D call everyday.", False, True)
add('20TimesKirby', 'http://20xkirby.smackjeeves.com/comics/', u"20 kirbies, considered different from all the others by Kirby, go on a journey to find out their past... At least that's what Kirby wants, since he can't stand the fact of knowing nothing about them all. The answers come slowly, the suspense builds, and the question is, are they going to find out everything? Or are they just going to have random adventures, and never know all of it? Updates Mondays and Thursdays.", False, True)
add('2Kingdoms', 'http://2kingdoms.smackjeeves.com/comics/', u'Lost in the middle of the dangerous seaweed forest of Lebanon, Uegon Prince Apollo is searching for the way home. Joined by his cousin Paris, his faithful pet Pyou, and a pair of Uegon sisters named Diane and Juno, the group must face a deceptive maze of seaweed trees, giant flesh eating monsters, the Unknown Dark Lands of the Herse, and the biggest hurdle of all, a war in the royal house of the High Waters! **UPDATES: Saturdays NEWS>>2Kingdoms now has a group page on dA: http://2kingdoms.deviantart.com/ If you have a dA account, please show your support by joining the group. It has special extras that can only be found on dA :D', False, False)
add('355Days', 'http://355days.smackjeeves.com/comics/', u"This was originally a comic where I attempted to make an homage to Kurt Vonnegut's Timequake, but it slowly evolved into A Dada Humor comic, which has now evolved onto a actual storyline that has gone on since April 1st 2012. This is my experimental comic where I attempt to post a comic daily with anything I can get my hands on, just attempting to get at least one page up! ***ENDED AS OF 9/2/12*** If you liked this comic check out my new comic: Euphemistic Eephus. http://www.smackjeeves.com/comicprofile.php?id=127121", False, True)
add('4Ply', 'http://4-ply.smackjeeves.com/comics/', u'Four teens who have been friends since grade school enter their first year of High School. Will their friendship survive and if so, what about their sanity? Kamal: As strong as toilet paper we are. Carmen: Oh would you please just shut up! Kamal: XD', False, True)
add('60SecondComics', 'http://6tsc.smackjeeves.com/comics/', u"Every episode /was/ completed in 60 Second Comics... now I'm not so strict about it, but I do try to do them rather quickly. Still, the title's not innacurate! You can still read them in under 60 Seconds! This comic does update, really! http://www.vivianvideo.com", False, True)
add('9ChancesforLove', 'http://9chances.smackjeeves.com/comics/', u'Finding the right person to love is quite a challenge. Approaching the person you love is an even bigger challenge. But the biggest challenge of them all is to keep that person by your side. When two strangers meet, they can decide to become friends, leave the other to be or become enemies, but what if they happen to share something, something they cannot control and not even really are aware of? (My English is not so good, if you find mistakes it would be great if you could point them out. :) Thank you!) (WARNING: 13/15+ BL)', False, True)
add('AB', 'http://alistairandboggart.smackjeeves.com/comics/', u"*Updates when I'm not working! :D Alistair Wind and Boggart Cabera. slice of life/supernatural/humor If you\u2019re not into BL or Shonen ai or relationships other than hetero then this may not the comic for you. This is a side series which mainly focuses on their relationship aspect from the main series I am working on. Welcome to their unremarkable everyday with the occasional demons and drama. Warning: BL, profanity, sexual themes/contents.", True, True)
add('ADayOut', 'http://adayout.smackjeeves.com/comics/', u'Lizzy is an average soccer playing teen with issues. After distancing from a childhood friend, she must find out what kind of a person she really is, and along the way, discover true potential as a soccer Champion!', False, True)
add('AGirlAndHerShadow', 'http://agirlandhershadow.smackjeeves.com/comics/', u"There's something under the little girl's bed. It likes to play hide-and-seek and it's always hungry. It's also her best friend.", False, True)
add('AGirlontheServer', 'http://girlontheserver.smackjeeves.com/comics/', u"The true and mostly true stories of a girl playing online games and having to deal with all the crap that comes with it. Because apparently, girls don't exist on the Internet!", False, True)
add('AKirbyKomic', 'http://akirbykomic.smackjeeves.com/comics/', u"Join Kirby, Meta, and friends as they travel throughout the Kirby video game series and attempt to stop evil who are trying to destroy this series. It's a daily 4-panel adventure filled with science fiction, humor, and randomness.", False, True)
add('ALaMode', 'http://alamode.smackjeeves.com/comics/', u"Lamode sells talking pretzels to pay the rent. Her apprentice Schulz handles the wilder creations. Her new home Arryn, a college neighborhood pretending to be a town, helps Lamode discover love, acute distaste for movies, and the best way to a customer's stomach. A La Mode updates on Tuesdays and Thursdays.", False, False)
add('ANGELOU', 'http://angelou-esp.smackjeeves.com/comics/', u'ANGELOU Historia y dibujo: CaiN Personajes: CaiN y PatoBorracho Genero: Aventura, Fantasia, Humor y cuanta cosa se me ocurra jajaja Sipnosis: La historia se centra en Nikole Keitaro, una chica de 12 a\xf1os, qui\xe9n emprende un viaje en busca de la persona que asesin\xf3 a su padre, y tambi\xe9n para buscar el misterio se su origen.', False, True)
add('APTComic', 'http://aptcomic.smackjeeves.com/comics/', u'The random adventures of a catgirl named Ammika [who goes by PrincesTomboy the adorable oxymoron], and a bunch of other people. Updates Fridays - If anyone wants to contact me, my email is "PrincesTomboy@yahoo.com " Please note that it and my username are short for \'Princess Tomboy\', not the plural of a prince. -- Until I figure out how to add "tags", here have a large block of things. Ammika Inferno \'ferny Ferny Kumi Kumimi Ally The Pampered Alley Cat Adventures Heroine on Heroin Ember Alex Overcast Helena Foxx High Billy Sometimes Yellow My His Name is Bobby Bunni Bunny Rabbit Candi Candy Sweet Cat Fox Wolf Dog Chicken Sonic the hedgehog Kirby Furry Anthro Cat girl Catgirl So Many Tags Animal ears tail cute cutesy kawaii Keroro gunsou magic updates on fridays.', False, True)
add('AQuestionOfCharacter', 'http://aqoc.smackjeeves.com/comics/', u'Authors ([22/25]); Slash Segary Shard kitsune fire The Magnificent Z Snurple-the-Hedgehog Imperial Ultimate the Hedgehog AnXjak aqua the hedgie Royle McCulloch ClareSilver47 M.Dailey DelSoul 55dubdub Nick Cypher The Flames EclipseTC Punchy GrovyleGoodbye128 Kaizuto Agent Transpire Legoalex-625 Azure_Kite Zonethehedgehog -----PLACES OPEN UP EVERY SUNDAY AT 7PM EST IF ANYONE LEAVES/A PLACE IS MADE AVAILABLE-----', False, True)
add('ASongforElise', 'http://asongforelise.smackjeeves.com/comics/', u"Andi, Marcus and Elise are best friends since high school. But it hasn't been an easy friendship... And it will get worse. How much change will their relationship be able to deal with, whether it's love or death? A yaoi manga with all the EMO that it requires! ;)", True, True)
add('AStrangeTypeofLove', 'http://strangelove.smackjeeves.com/comics/', u"Dory's life took a whole new turn as an old flame of his ends up living in his house after escaping an insane asylum. As time passes by,Dory tries to (Once again) win Damian's heart. Will he succeed? Or will their 'deal' get in the way? You can find out in ASToL. 18+ Content: Sex (GAY sex ohohoh) Language Nudity I am not English,So my speech may be a little bit off. And the comic itself might be too,At times. (It's my first comic after all)", True, False)
add('Adalsysla', 'http://adalsysla.smackjeeves.com/comics/', u"there's a freckly guy who misses his girlfriend a lot and a blue girl who wants to find her brothers. on their way to wherever they're faced with a lot of trouble! but also a lot of friends.drawn and written by piim, also known as Katarina Skott. updates wednesdays and saturdays!", False, True)
add('AddictiveScience', 'http://addictivescience.smackjeeves.com/comics/', u'The day-to-day life of a mad scientist and her roommates, struggling with the daily crasy.', False, True)
add('AdventuresofLumandFriends', 'http://aolaf.smackjeeves.com/comics/', u'The daily life of a group of wild Pokemon. Join a Ralts, Gardevoir and Mawile on their eternal quest for food, money and TMs. May contain violence towards human trainers, other Pokemon and cannibalism. Mmmm Tepig...', False, True)
add('AgeoftheGray', 'http://ageofthegray.smackjeeves.com/comics/', u"It seems the rapture has finally come- although it's a little different than expected. Heaven and Hell have come out of hiding and collapsed into the earth- making it one place. With them have come the demons of Hell and the angels of Heaven. If they're here, then who's to say God and the Devil haven't arrived on Earth as well? A race starts to find either one, a race to the end of the world, and caught in the middle of it are a couple of dumb kids. Featuring a cast of familiar names such as Lucifer, Lilith, Metatron, and a lot more. Rated Mature for drug use.", True, True)
add('Akniatt', 'http://akniatt.smackjeeves.com/comics/', u'This is a finished comic that I drew before "Gnoph," and it shows its age a bit in the art. This story follows the collapse of an empire, an escaped prisoner, and many dragonflies.', False, True)
add('AlPoxalips', 'http://www.alpoxalips.com/comics/', u'A story about a man on a mission. A very well-to-do man, very well educated, and yet not very smart. His mission? To convince as many as possible that the globe is facing many man-caused catastrophes that can only be solved by everyone but Al cutting back on their life style. Dedicated to preserving the planet and his lifestyle, but with as little discomfort to himself as possible.', False, True)
add('AllInLOVE', 'http://allinlove.smackjeeves.com/comics/', u'A young boy starts his new day in another school. This school isn\x92t like others. In this world, exist two species named Kay and Black Angel. Those species are in war, they can not love each other by there differences. This school was made for the two species gather together and make peace in to the world. Roy Figure (main character) is very different than anyone around him. A lot of things happened to him at his new school\x85 He is somehow special to others\x85 in the weird way. Website- http://uty-studio.wix.com/all-in-love Updates every Thursday.', False, True)
add('AllStarHeroes', 'http://allstarheroes.smackjeeves.com/comics/', u'(Massive video game crossover) The planet Corneria is under a constant threat of evil. The All Star Heroes, a team of six individuals with varying skills and abilities, are tasked with protecting this planet. The team consists of a Gremio from Suikoden (the leader), Billy Kane from Fatal Fury (the athlete), Ally Gator from Black & Bruised (the fighter), Coco Bandicoot from Crash Bandicoot (the tech expert), Toad from Mario Bros (the muscle) and Scorch from Army Men (the pyromaniac). Who will this team of six face next? It literally could be anyone.', False, True)
add('Allthatglitters', 'http://atg.smackjeeves.com/comics/', u'The members of the rock band celebrating in the a little pub, despite their troublemaker past someone \'ll undertake to be their manager. The band\'s singer, Istv\xe1n meet with "Andrea", who could change the band\'s future. BL love! Yaoi warning! :) It was a one-shot hungarian BL antology competition, mine didn\'t pass into it. So I\'ll draw other chapters.', True, True)
add('AlwaysDamnedWebcomic', 'http://alwaysdamned.smackjeeves.com/comics/', u'"He\'s been single for as long as I\'ve known him and now that we\'re Seniors in High School, everybody and there MOM wants in his pant!?" Josh tries to confess his love to his childhood friend Demetrius, but it doesn\'t quite work out as he plans. Something or someone is always getting in his way! Will he be able to tell his best-friend how he feels? Or will he let himself be distracted from his goal? Silly comic that will try to update on Mondays (and maybe days in between!) WARNING! This is a BL (Boy\'s Love) comic with Het and GL (Girl\'s Love) as a side serving. Dirty (& improper)language, bad art, pingas, boobs. No smexy stuff yet, but its coming soon!', True, True)
add('AlwaysRainingHere', 'http://alwaysraininghere.smackjeeves.com/comics/', u'MOVED TO http://alwaysraininghere.com/ !! A totally original high school story about a couple of gay guys who annoy each other. Also massive amounts of UST. Updates every Thursday.', False, True)
add('AmorVincitOmnia', 'http://avo.smackjeeves.com/comics/', u"It is said, that on the day I was born an angel descended from the heavens. He delivered unto me a blessing... and a curse. Updates once weekly (Unless I say otherwise) (Oh, and most likely on weekends) Warnings: -This is a Bl comic. That means man on man action. So don't be suprised, 'kay? I may also do het and gl pairings later if I feel like it. -Rating WILL be boosted to mature later on. Also, it can be rated mature for anything. I like to keep my options open.", True, True)
#add('Amya', 'http://amya.smackjeeves.com/comics/', u'Amya is a high-fantasy graphic novel; following the adventures of a mute spell-touched and her unlikely companions as they are dragged into an adventure that is a little beyond them. Ultimately \x96 Amya is a story about self sacrifice for the greater good. It is also a story of how far one will go to obtain unearthly power; even if it includes throwing the world into a mythical war between fate and chaos. Amya updates every Wednesday.', False, True)
add('AnUnexpectedDevelopment', 'http://unexpecteddevelopment.smackjeeves.com/comics/', u'In a world where Megaman and Roll have swapped genders and become a pair of human teenagers, there is a need for new heroes to rise in order to protect the city from both new and old threats. Instead they get Sam and Alex. Two mischievous high-school students find themselves in a predicament which is quite the opposite of Rock and Roll\'s, but just as awkward. Will they be able to get used to their new-found "changes?" ______________________________________ Well, here it is. This is a little project I\'ve been working on for a bit. I guess you could call this my tribute to the old enjoyable Mega Man 7 style comics that popped up here and there during the golden age of spriting. Remember to read "Slight Miscalculation" by Mitchell00 in order to understand what\'s going on in this comic. http://www.smackjeeves.com/comicprofile.php?id=67755', False, True)
add('Anathemacomics', 'http://anathema-comics.smackjeeves.com/comics/', u'1810 England, the height of the Napoleonic wars. It was thought that humans walked the path of enlightenment leaving monsters and dark things behind. However, those monsters and night stalkers merely hide in the darkness, as a young maid, Bernadette, soon finds out.', False, True)
add('AnimalAdventures', 'http://animaladventures.smackjeeves.com/comics/', u'In a world similar to Pokemon minus the humans, intelligent creatures called Animals must use their amazing powers to save the galaxy. Many of the characters and storyline resemble things from various media. Contains action, violence, gore, romance, clean humor, adventure, possibly a few swear words, and extreme cuteness. Is read from left to right. This comic contains a lot of characters. Note: This comic does not update any schedule. I update when a new page is done.', False, True)
add('Animayhem', 'http://animayhem.smackjeeves.com/comics/', u"Twelve-year-old social reject Vera and her best friend Maggie love anime more than life itself. Too bad they live in a world that's hostile to the magic of Japanese cartoons. And go to a school that contains a portal to the Underworld. And have to fight demons when they could be cosplaying or watching a Princess Neko-chan marathon... Vera and Maggie's adventures with the occult are twisted, gory...and so absurd, they can only result in total Animayhem! Written and illustrated by JoJo, currently set to update every other day until there ain't no more pages!", False, True)
add('Anythingaboutnothing', 'http://www.anythingcomic.com/comics/', u'A collection of comics and cartoons about anything and nothing.', False, True)
add('ArchportCityChronicles', 'http://tjs.smackjeeves.com/comics/', u'Archport City is the interdenominational hub and there are always stories to tell... This first one is what happens when you just have to get that picture... Dissatisfied on what was supposed to be a fun trip it was only a matter of time until adventure lured Joe in. Now a group of discredited bounty hunters with a dangerous target have dragged him along for the ride.. updates T and Thr..', False, True)
add('Area9', 'http://area-9.smackjeeves.com/comics/', u"Taishi Iwasaka had always dreamed of working in Area 9, a research facility surrounded by a huge wall that is famous for protecting the people from lethal viruses that have wiped out nearly half of the population. Feeling useless, Taishi has recently given up on his dream, but in a strange turn of events he finds himself trapped in Area 9 as a hostage with a crazy bomber called 'Bomb', who claims to be a terrorist who will blow Area 9 up if they don't hand over everything they own. Is there anything Taishi can do before it's too late? Just who is Bomb, and why does he want to destroy Area 9? Taishi will have to overcome his feelings of helplessness if he's going to do anything about it, as well as make a few shocking discoveries along the way. <<Reads from right to left<<", False, False)
add('AskAltair', 'http://askalty.smackjeeves.com/comics/', u"An Assassin's Creed fan-comic about Altair, Ezio, Desmond, and the crazy fangirl who is intent on keeping them prisoner in her inescapable house.", False, True)
add('AtArmsLength', 'http://atarmslength.smackjeeves.com/comics/', u'The story of three magical ladies and their lives with their husbands, making it in the modern world and dealing with the occasional monster attack. Updated Tuesdays, Thursdays and Saturdays.', False, True)
add('Autophobia', 'http://autophobia.smackjeeves.com/comics/', u"The story of a dude named Louis who tries to accept himself for who he is and to learn to not let others step all over him. It follows him through the course of his life and the relationships he builds with others, particularly with his classmate Daniel. [Updates every Sunday] --- Warning: gay ppl, straight ppl, awkward ppl, a plethora of dialogue, profanity, sexual themes/content, and an absurd amount of fluff. /Mature content is on for some of the future themes explored, but there's nothing explicit./", True, False)
add('Aware', 'http://aware.smackjeeves.com/comics/', u"A journey through the multiverse by a wall-aware feline in order to find a scarf with the power of destruction. It can't really be that simple, can it...?", False, True)
add('AwesomeSauce', 'http://tdawesomesauce.smackjeeves.com/comics/', u"Stupid comics from the dark depths of TD's notebooks. View at your own risk. Updates never.", False, True)
add('BLOT', 'http://blotcomic.smackjeeves.com/comics/', u"In the near future, robots fueled by human blood have begun their uprising - thankfully there's a few folks who won't take that sitting down.", False, True)
add('BabysittingFourDemons', 'http://babysitting4demons.smackjeeves.com/comics/', u'Ezz, also known as Ghost the Echidna on her Smackjeeves account, has become a babysitter. She\'s finally on her own, and starting a nice, steady babysitting service at her home. Little does she know is that the children she is to babysit happen to be four demons... Who are these four? Why, none other than Sonic, Amy, Knuckles and Tails! Open Author Spaces: NONE. DON\'T EVEN ASK. Don\'t even request. Don\'t comment "CAN I JOIN LAWLZ" or I\'ll come after you. Thanks! -Hope Status: No one banned. Please start updating more, people. I\'ve made up my mind that I\'m gonna update more, you guys can help out too. -Hope', False, True)
add('Babywhatsyoursign', 'http://babywhatsyoursign.smackjeeves.com/comics/', u"UPDATES FRIDAYS~ Sometimes even more often! : o Christian and Liam are brothers going to the same prestigious high school. Christian has a big crush on one of his classmates, Tristan. Liam has one on Dominique. But, Dominique's twin brother, Colton has a thing for Liam. My goodness! Not only is there a ridiculous amount of gay and the drama of high school crushes and love triangles, there's also a little detail that has yet to be mentioned. Tristan, Dominique and Colton are only a few members of a large group of individuals keeping a huge secret. A secret that's full of power. But, the last time this secret got out, it put an end to many people's lives. This secret can not get out again. And there are some people who will make sure it won't. CONTENT ADVISORY: Online Comic will not contain anything visually explicit. There is cursing here and there and general sexuality. YES. BL. GAY. YAOI. WELL, MORE LIKE SHONEN-AI. ALSO SOME STRAIGHT. <3", False, True)
add('BadLucktheQuestfortheCodPipe', 'http://badluckthequest.smackjeeves.com/comics/', u'This is the story about Rade, your everyday average guy. He goes to school, plays sports, the only thing weird about him is his best friend Crimp. Things in his average life take a turn for the bizarre, when a young man with a cat show up at his door. Now all of a sudden Rade is caught up in a quest for a magical pipe that can grant a wish to anyone who asks. Not to mention the demon mercenaries following them. The closer they get to the Pipe, the darker and more entangled things become. What starts as a grand adventure, only seems to lead to Bad Luck. Updates Saturday', False, True)
add('BanjoThreeieFancomic', 'http://banjothreeie.smackjeeves.com/comics/', u'Banjo and Kazooie have some new adventures... Without vehicles.', False, True)
add('BassComicAdventures', 'http://basscomicadventures.smackjeeves.com/comics/', u'A sprite comic that follows the (mis)-adventures of the Capcom characters of Bass, Mega Man, and the rest of the group. Featuring original storylines, new characters, a fresh take on the classic games, and some potential amusement. Updates on Mondays, Wednesdays, and Fridays', False, True)
add('BattleSequence', 'http://battlesequence.smackjeeves.com/comics/', u'Trainer Rayne is working hard to train her pokemon to be the best they can be. Is she tough enough to take on all of these new challenges? Follow along with her on her journey to be the very best! UPDATES: Every friday.', False, True)
add('Bearhoney', 'http://bear-honey.smackjeeves.com/comics/', u'Everyday adventures of Bear and Honey. A new adventure every weekend!', False, True)
add('BearlyAbel', 'http://bearlyabel.smackjeeves.com/comics/', u'Abel is a American-Asian boy with an active imagination. He lives with his mom and sister and goes on adventures with his bear, Barry. This webcomic ran from August 2008 until Oct 2010.', False, False)
add('BeautifulLies', 'http://beautiful-lies.smackjeeves.com/comics/', u"Action, Drama, Psychological * Contains some mature contact such as profanity, violence and blood/gore. It's a story about a group of adolescents living dull or miserable lives who seek comfort in their own fantasy world. They all encounter a similar situation which transports them to a lawless, fantasy world that shapes itself to their inner desires. There is no time to age them, no rules to control them, no authority to subdue them. As they search for a way to return to the real world, they begin to question if they want to leave at all.", False, True)
add('BehindTheObsidianMirror', 'http://obsidian-mirror.smackjeeves.com/comics/', u"If you were to awake in a place unknown to you, without remembering anything... you would be happy to be taken in by someone, right? But what if this someone was a god? Aztec gods and BL. What more could you want? x3x Warnings for homosexual content, blood, violence, and possibly gore and sex in the future. Don't like, don't read. UPDATES EVERY MONDAY!! Although I have read a lot about Aztecs and their culture and mythology, I am hardly an expert on that subject. So forgive everything that might be off, or wrong, since I actually don't bother to get everything right or just change things to my liking. The Aztecs and their religion etc. depicted in this comic are far from realistic, and don't aim to be, although I'm trying to make it all seem plausible. Just so you know. Enjoy. ;) Remember to read from right to left, Japanese reading order. ;) Sketch/WIP tumblr: http://teejaystumbles.tumblr.com/", True, True)
add('Behindtheglasscurtain', 'http://g1ass.smackjeeves.com/comics/', u"Scarlet spent all her life in a dismal, dark prison that just so happens to be located in a dismal, dark realm bereft of all flora and fauna. One night she ignores the frog's rule to never look out the window when darkness approaches. What she sees next will change her life and everything she once knew. It's a comic that delves deep into other character's lives and reflects on their back stories. Even though the main story seems to branch off to smaller stories, there is a basic plot, which the reader has to decide on. updated on weekends, but best to check it on Monday. It's finished! COMPLETELY FINISHED! Don't keep on checking for updates. Yes the first 100 pages looked like crap but mind you I started this when I was 14!", False, True)
add('BettencourtHotel', 'http://www.welcometobettencourt.com/comics/', u'"You are advised not to leave your room from midnight to 2 a.m." A little horror story about pretty boys working in a murderous hotel. Some shounen-ai. ~Updates on Fridays~', False, True)
add('BetweenLightandDark', 'http://bld.smackjeeves.com/comics/', u"The adventures of 13 friends as evil turns against them. (Or they go looking for trouble, that's more like it!) Fantasy and adventure webcomic with some humor and romance in the middle. Updates every Sunday and Wednesday. PG-13 due to language here and there and some themes. There are also short comics updating every Tuesday here -> http://bldshortcomics.smackjeeves.com It is not mandatory to read those to know important things in this, but some strips are intended to be connected to the story!", False, True)
add('Betwin', 'http://be-twin.smackjeeves.com/comics/', u'Be-Twin is an amateur comic which smells of powder, shootings, and the mafia. Its true premise however, centers around two destinies which have, with difficulty, found their place in this dangerous world. Two individuals who are different in every way\u2026 or perhaps\u2026 not very different at all. I upload pages every two weeks, on Sundays. I\u2019m French, so please forgive any mistakes I may make. I really wanted to share this story with my non-French readers. ;-; Thank you so much for reading... >w<', False, True)
add('BeyondTemptation', 'http://beyondtemptation.smackjeeves.com/comics/', u"An accidental meeting turns Reimee's life up and down. She finds herself in the middle of an affair regarding enslaved demons, magical artefacts and many temptations of the modern world. Will she get tempted? Or will she be the one to tempt? And finally, will she find what she's looking for in the Eternal City of Rome? Inspired by eastern folklore, religion, Grimm tales and life itself, set in modern times Rome it's a paranormal action romance in which the borderline between good and evil is very thin. (plus guys don't sparkle and girls can kick your butt :D) NOTE: 1.This comic is fruit of immagination and does not reflect anyone's opinions nor real facts nor people. 2.Not marked mature (I find it annoying when I can't see the preview)but may contain some blood here and there and possibly some erotic scenes. 3.Commens are very appreciated. Reviewable if anyone wanted to attempt at it.", False, True)
add('BeyondTheOrdinary', 'http://bto.smackjeeves.com/comics/', u"This comic will feature Beive Ramn who's new to town after her father died. Her mother wanted her to get away from her old life and while everything seems to be pretty calm; it's not. Mystical creatures, mythological beings and Swedish folklore.", False, True)
add('BioRevelation', 'http://biorevelation.smackjeeves.com/comics/', u'Ever wonder what would happen if cloning was made legal? What could they do for mankind? Would they have the same rights as natural born people? Bio-Revelation tells the story of a distopian society of corruption, theocracy, and the underdog. Follow the story of Trevor Watson and his friends battle against the religious fanatics known as the FOH to gain the freedoms they dream of.', False, True)
add('BirdSeed', 'http://birdseed.smackjeeves.com/comics/', u"Recently things have gotten strange in a sleepy little village in the middle of nowhere. After several villagers are attacked Eleanor, a doll created by a strange man named Klaus, is sent on a simple errand to deliver a message to several important people about the troubling matters in town. It's a simple but important task she gladly takes on after being locked away for countless years. However things become complicated when she runs into a living talking pumpkin who calls herself Loraine. Loraine has no idea what her purpose is, she wasn't exactly paying attention to what the strange man in an owl costume said to her. He seemed to have important plans, but she didn't want to take part. There's a strange glowing string though, and she absolutely needs to find out what it connects too. Perhaps her meeting of Eleanor was fate? Together they must find their way--especially when Eleanor finds out that her caretaker wasn't exactly truthful about the state of the world, and Loraine discovers the horrible truth about her destiny.", False, True)
add('Bl3', 'http://bl3.smackjeeves.com/comics/', u'Mostly a crossover of BLEACH and BLAZBLUE (the title may be read as "bl3" or "bleablazblue") All characters here are the property of either Tite Kubo or Arc Systems Works, particularly Toshimichi Mori. There is one original character, but half of that is owned by Daisuke Ishiwatari. This takes place between the Deicide and Lost Agent arcs of BLEACH. Please read RIGHT TO LEFT, like a Japanese manga.', False, True)
add('BlackCollar', 'http://huntedblackcollar.smackjeeves.com/comics/', u"-Read from left to right- This is a comic for all you fantasy action lovers out there. Nobody asks for it, nobody in that messed up world. And yet they are all part of it... the game. Hunted, What does the word really mean? How can someone just be thrown into a place like this? And yet there are so many just like him. Unaware of what's really going on? There's a good amount of violence and blood in this. So be aware before reading. (There are no sexual themes) *NOTE*: The comic was started a while ago, so you will see a huge improvement in both the art spelling, and story by around chapter 2.", False, True)
add('BlackDragon', 'http://blackdragon.smackjeeves.com/comics/', u"Since mankind has subjugated dragons, men struggle for power by using dragons. Sora also wants to become a dragonrider and so he climbs the Dragon-Mountains to catch a dragon This is a manga. Read from the right to the left! If you can't wait, you can get the complete Manga on Amazon: http://www.amazon.com/dp/B007NZGBZ8 http://www.amazon.com/dp/B009MOQLLM http://www.amazon.com/dp/B00BRJHPTW http://www.amazon.com/dp/B00EMHWJVK Update: one chapter per month", False, True)
add('BlackFridayRule', 'http://blackfridayrule.smackjeeves.com/comics/', u'', False, True)
add('BlackandBlue', 'http://black-and-blue.smackjeeves.com/comics/', u'A sci-fi fairytale. A boys nightmare. So, this is about an Evil Empire soldier with a few problems... not the least of which is a slight gender issue and a weird entanglement with an astronaut. Awkwardness ensues. D: I thought "The Crying Game" was a comedy, you\'ve been warned. Ha! e_e Also I started this about 200 years ago and the art is pretty rough I\'M SO SORRY! ;_; FORGIVE ME!', False, True)
add('Blackdemon', 'http://blackdemoncomics.smackjeeves.com/comics/', u"everyone has a demon inside them, even the nicest people in the world has a demon. what happens if the demon inside takes total control of you? it could effect your life style, personality, and for artist's; imagination. that's what this comic is about. a girl with poor social skills and a large imagination, how will she fix both problems? (WARNING:some chapters in this comic are based on real events that occurred in the author's life) comic updates:Monday's, Wednesday's, and Friday's(if not updated, that means i got a LOT of HW or my laptop is damaged)", False, True)
add('BleachRedux', 'http://bleachredux.smackjeeves.com/comics/', u"Myself and others were extremely disappointed with Ulquiorra's death in the official Bleach manga, so I've taken it upon myself to draw out what could've possibly happened had Orihime pulled her head out of her ass and saved him. WARNING: UlquiHime. Any negative comments (or futile attempts at validating other ships that make even less sense (ie: IchiHime)) will be deleted. NOTE: READ RIGHT TO LEFT LIKE JAPANESE MANGA.", False, True)
add('BlindandBlue', 'http://blindandblue.smackjeeves.com/comics/', u"Boy's Love! (Gay relationship romance) Caecus (Case) woke up one morning to find that he was completely blind. He's picked on by the school bully, and things aren't so great. Fortunately for Case, he finds a friend - and eventually a boyfriend - in the new kid, Darryl, and together they make it through the things life throws at them. A smackjeeves mirror to the comic on DrunkDuck, which you can read [url=http://www.drunkduck.com/Case_1048_Blind_and_Blue/]here[/url] Comic contains swearing very rarely,so if you don't like it...you'll be fine actually And if you're homophobic...message me with your reasons why as I am very curious on the topic.", False, False)
add('BloomaPokemonConquestComic', 'http://bloomconquest.smackjeeves.com/comics/', u'According to the Legend of the Ransei region, if all 17 kingdoms of the region are united, the legendary Pokemon that formed the region would appear. Young Saku, along with her stubborn Axew, set off on the road of conquest. However, the warlord Nobunaga is only one kingdom away from uniting the region. Can Saku conquer Ransei before he does? ______________ There is a bit of violence later on, but hey, Pokemon has a certain lack of violence that they need to make up for. Nothing too bad. Also, I am constantly improving, so please ignore the bad art at the beginning. >.< Pokemon (c) Nintendo Updates Wednesdays and Saturdays.', False, True)
add('BlueStreak', 'http://bluestreak.smackjeeves.com/comics/', u"It's a webcomic...musical!", False, False)
add('BlueWell', 'http://www.bluewellcomic.com/comics/', u'Leif Kavanaugh grew up in the country-side and came to the city to attend college. He moves into "The Blue Well" boarding home, which houses several other college students just like himself. While he hopes everything will go smoothly, Leif learns it\'s not the city that makes life crazy, it\'s the people.', False, False)
add('BlueYonder', 'http://www.blueyondercomic.net/comics/', u'Jared Davenport thought he knew what it took to be a hero. He is about to find out otherwise. On the run, Jared takes refuge in the Claremont apartment. There, Jared finds friends and rivals alike amid the bygone superheroes of yesterday. He will need all their help to survive a brutal enemy from his past. But even on the streets, Jared is about to discover the sky is the limit as he becomes . . . Blue Yonder!', False, False)
add('BoilingPointofBrain', 'http://bpob.smackjeeves.com/comics/', u"The company 'Brain' is going through terrible waves of financial depression as their only client 'Erika' has succumbed to the roadblocks in life. It is up to Sir and the Intern as well as the employees to help their client get back up on her feet.", False, True)
add('Boo', 'http://boocomic.smackjeeves.com/comics/', u"* Updates on Fridays * On a Halloween night a little girl named Kat opens a strange box, releasing hundreds of monsters as well as the Boogeyman (AKA Boo) onto her town. Boo and Kat must work together to protect themselves from these monsters that now lurk in the shadows, but is that what they really should be afraid of? Because little do they know a retired hit-man from Boo's past named Cain is coming to Kat's town to make sure the Boogeyman he locked away years ago is still dormant. As the story unfolds we peek into Boo's past, when he was a child. We follow him on his tragic/strange journey to becoming the Boogeyman and ultimately his imprisonment in a box that Kat eventually opens over 100 years later. Cain is on his way for a head-on confrontation with Boo and poor Kat is stuck in the middle of it all. Are there answers in the past that can save their futures? Or are they all doomed to be eaten by the monsters that continue to be constant threat to everyone? Can now be bought on Lulu.com (hint-hint, nudge-nudge)", False, True)
add('BoogeyDancingMonkeyPot', 'http://monkeypot.smackjeeves.com/comics/', u"Prince Jean-Patrick finds young Sarah's bedroom to frighten her. But Sarah isn't an eight year old girl running around in her socks. She's a young adult now and it certainly shows! Together, the Boogey man and human girl journey through their lives. One to become king of his kind and the other to find her place. Two roads cross and destiny determined to keep them together. Monsters do not solely exist in the darkness. rated mature for violence, language, partial nudity and some sexual tension", False, True)
add('Boywithasecret', 'http://www.bwascomic.com/comics/', u'Comic Title: BOY WITH A SECRET (Himitsu no Aru Otoko) Boy with a Secret is an engaging and modern comic that follows the life of a young boy and his hidden secrets. Only a few are privileged to know the truth, and to everyone else, he is a stranger. When Haruhi starts his new life at Fujimoto High School, he befriends the beautiful and compassionate Minako. Rejected by his fellow classmates and tormented by school bullies, Haruhi begins a life-changing journey to find out what real friends are made of. While his secrets unravel and his enemies grow by the day, a friend from the past comes to change everything... ********************************************************* Updates: Every Wednesday GMT -6(US Central Time) Genres: LGBT, Psychological, Romance, Drama, School Life. *warning* some adult situations Rated: 16+ Contain :Violence, Blood,Profanity All pages in FULL COLOR ********************************************************* *READ FROM LEFT TO RIGHT * Comments are always appreciated. :) THANKS!', False, False)
add('BreachofAgency', 'http://breachofagency.smackjeeves.com/comics/', u'Panacea has the gift of healing, which makes her a target for both sides of a civil war. The Minister, leader of the Agency, is determined to have her cure his fatal illness and prolong his life. Forever. But the Gunman and his accomplices want her dead. All Panacea wants is to find her own destiny. When she and her bodyguard, Aegis, stumble upon Traver, who takes them in after they narrowly escape a brush with death, Panacea believes she may have found a real home. But the Agency has eyes everywhere, the Gunman is always waiting in the shadows, and Panacea can never be sure who her allies are.', False, True)
add('BrightStars', 'http://www.brightstarscomic.com/comics/', u'A miscalculation sends Rory into the far reaches of outerspace. WARNING: May contain violence, language, and human-alien relationships.', False, False)
add('BroodKnightShatteredHate', 'http://bksh.smackjeeves.com/comics/', u'A comic about an angel who helps this kid overcome his inner demon within him.', False, True)
add('BrookeandKirby', 'http://brookeandkirby.smackjeeves.com/comics/', u"A comic about my fan character Brooke and Kirby. This is the first webcomic I ever posted here, so expect some mistakes. And don't expect updates daily. I can sometimes get Author's block.", False, True)
add('Bullet', 'http://bulletmanga.smackjeeves.com/comics/', u"Living far below the poverty line, having no friends, not enough food or even the love of a parent, Nikita hopes for no happiness. But as her family's ominous past slowly begins to unveil itself, happiness become the least of her worries, her only refuge becoming a man whom she cannot trust. A man with no heart. A murderer. ------------ Note: This is Not a BL/Gl manga.", False, True)
add('BullyEater', 'http://bullyeater.smackjeeves.com/comics/', u'Bullying is a very serious issue, especially if the bullies are superhuman martial artists! Isao Akia, A high school student, figured that after training in the martial arts his days of being bullied would be over. And they were until he was transferred to "Long Wei High" a school owned by a deadly Chinese syndicate called the "Nine Dragons". At this school a school yard brawl could level an entire city!', False, True)
add('Burn', 'http://burn.smackjeeves.com/comics/', u'Spunky young college student Darryn Gainnes has just turned 20, and decided to tone his wild ways down a bit. All he needs in life are his two best friends, their band, his books, and his music. He thinks nothing of it when he literally bumps into a pretty (and gloomy) High-School-boy at the park. But soon, Darryn finds himself swept up in a world he had never even known existed, a world of intrigues and violence and magic! And of course what is sweeping both boys off their feet is their budding romance... and so many incredible obstacles thrown in their way. Where will it all lead? Who is on their side... and who will be left standing? .:. 3rd place in the "Drama" category of the 2013 Smackie Awards! ^_^ WARNINGS: Occasional violence, "bad" language. BL: This is a Boys\' Love/Yaoi comic! If you don\'t like those, don\'t read this one! DIRECTION: This comic reads right to left, for no other reason than that I like it that way. ALSO: I never have as much time as I would like, so for the most part this comic is pencil sketches and a bit of Photoshop. But I hope you enjoy it. ART: Improves as you go along! I promise. I started this thing a long time ago. ^^;', True, True)
add('Burningashes', 'http://burntashes.smackjeeves.com/comics/', u'A father tries to protect his family during a environmental catastrophe.', False, True)
add('ByTheBook', 'http://bythebook.smackjeeves.com/comics/', u"After stumbling across a copy of 'The Adventurers Handbook 3.5' an orc, goblin and kobold decide to leave the dungeon and become mighty adventurers! Updates every Wednesday and Saturday.", False, False)
add('CROWLEY', 'http://crowley.smackjeeves.com/comics/', u'CHRISTIAN D. CROWLEY. Investigador privado. Detective de lo sobrenatural. Hechicero. Cazador de Demonios. Anticristo (eh... espera un momento)', False, True)
add('CafeSuada', 'http://cafesuada.smackjeeves.com/comics/', u"Down by the riverside there is a quaint little teahouse run by our heroine, Geraldine, who's only desire is to spread her love of the golden beverage - But what's going to happen to her business when a new coffee house springs up right next door?! And what is the meaning of Cafe Suada? Guess you'd better read and find out, huh?", False, True)
add('CafeauLait', 'http://cafeaulait.smackjeeves.com/comics/', u'**NOTE: Updates are currently sketchy - get it?** The four-panel comic with cat boy flavor! (updates saturdays) Illustrations of Milk, Coffee and the others are here: http://nadykun.deviantart.com/gallery/40865689', False, True)
add('CainandUnable', 'http://cainandunable.smackjeeves.com/comics/', u'The Super Sexy Action Comedy Drama of one high school student who happens to be best friends with some super powered teenagers', False, True)
add('CaptiveSoul', 'http://captive-soul.smackjeeves.com/comics/', u'A BL Pirate manga! :P Sai works on the ship "The Liberty", he was taken in at a young age after his town was burned down and he lost his family. The event was traumatizing and Sai lost his ability to speak. He has sworn to hunt down the pirates that destroyed his home and bring them to justice(however that seems a long ways away) However, recently the captain of the ship, Kuragi, has taken an interest in Sai! Will Kuragi\'s advances distract Sai from his goal to avenge his family? A stormy relationship ahead! Will update every tuesday :P', False, True)
#add('Carciphona', 'http://carciphona.smackjeeves.com/comics/', u'In an era where magic is forbidden, a sorceress struggles to restore her once peaceful life.', False, True)
add('Cataclysm', 'http://cataclysm.smackjeeves.com/comics/', u'Set on the last remaining hospitable island on a frozen world, a covert faction known as Militia attempts to overthrow a utopian civilization and their benevolent rulers, The Council.', False, True)
add('Catnip', 'http://catnipmanga.smackjeeves.com/comics/', u'Ikita is a young and impressionable noble, who has been bound to a young lady by arranged marraige. Felix is his hired bodyguard; a quick witted and reliable one at that - but who has more to his past than he would like to reveal. As Felix follows Ikita as his bodyguard, they start to have mixed feelings about their positions, and where the future may lead... Based in an 19th centrury-esque alternate history, this tale consists of friendship, compassion, love and regret.', True, True)
add('Cement', 'http://blocksofsherst.smackjeeves.com/comics/', u"We are a legion of awesomeness, bro! >:{C -------------------------------- Welcome to Cement! A boredom webcomic to discuss/review ideas, movies, fanfiction, and other stuff/shit. We also have: - A sprite showcase, - Some tutorials, - Dreams that make sense, - Debates that make no sense, - Lotsa shitty shit bullshit, - Crack, - Heli-kun~ :3 - Anus - Hentai - Steak - Swagga - What Pumpkin - Overall Trash And much more... Feel free to apply as author if you'd like! (no wait, don't) Gooby plz. I'm touching the description! Hurrdurr! :B Heil Helitler. Calm down Stalin' *shoots helitler in da face* :D Now go back to the top and re-read the description. HoNk hOnK :o) Trying to make a Homestuck reference in the description? You know nothing, Jon Snow. Play with the description they said. It will be fun they said. And it was. Posers. I was messing with the description before it became cool! >:I So there was this Dj who was like kicking off. I dont know what he was doing. But it was sick man. Hands in the air. Like penis out. There were people dancing I think Or maybe they were cops I think they might have been cops", False, True)
add('CerberusCrescendo', 'http://elica.smackjeeves.com/comics/', u'a lot of supervillains who need to be a lot of dead', True, True)
add('ChampionsandHeroesAgeofDragons', 'http://championsandheroes.smackjeeves.com/comics/', u'In a land far away, or possibly in a dimension just next to us, lies the lands of Thedas. The world of Thedas is made up by endless possibilities - a man can be a mage, a rogue, a warrior, even a woman. From the Free Marches to Ferelden we find champions and heroes saving the world... poorly. Updates Mondays. All hail Bioware.', False, True)
add('ChannelDDDNews', 'http://dddnews.smackjeeves.com/comics/', u"Ah, the loyal Reporter Dees, risking life and limb to get a story on air. This comic is a tie-in with Kirby's Dream Adventure, so expect to see the same characters bouncing back and forth! [[Updates Tuesdays, Fridays and Sundays]]", False, True)
add('ChaosAdventuresII', 'http://chaosadventuresii.smackjeeves.com/comics/', u'Creds to: Characters Chaos/Halo - Master Rezz - Nebula Ki - Megablueblastaa Tails - Hypero Sarah \x96 Foxx Etch \x96 No Details Blur - Cylent Nite Thorn/Young Thorn - Cylent Nite Omega - Hypero (customised by me!) The demons - Gardow Styxs - Sakura Courage Solo Backdrops- Wacky Workbench Zone - Shadowbot Green Hill Zone - kinny-man Chemical Plant Zone - Domenico Sky Canyon - kinny-man Emerald Alter - Apocalypse the Hedgehog Angel Island Zone - SkyLights Other Tails\x92 plane - Rogultgot', False, True)
add('ChaoticNation', 'http://chaoticnation.smackjeeves.com/comics/', u'Karians were first born during the cataclysm. Once human, the race mutated. They became stronger, faster, and changed in physical appearance and magical ability. In a world already devastated, a rebellion rises to defend the dwindling human race from the growing fear of the Karian army. Their one hope may lie in a mysterious mage whose kind heart has the courage to stand against the oppression and torture brought on by the impending war. WEEKLY UPDATES ON TUESDAYS Contents - Nudity, Language, Violence, Blood and Gore, Hentai, Yaoi', True, True)
add('Chatuplines', 'http://chatuplines.smackjeeves.com/comics/', u'Welcome to "Chat-up lines"! A South Park Doujinshi from CraigTucker and me. Pairing: Craig x Stan Story: Stan hates Craig and his friends are fags! They haven\'t time for him.. Bad friends.. But in a chatroom.. he meet a guy.. and he is cool. ..and they will be friends... !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! PART 2 !!!! http://www.smackjeeves.com/comicprofile.php?id=121933 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! WE LOVE YOU!', False, True)
add('ChelseaandKitty', 'http://cak.smackjeeves.com/comics/', u'Hi Chelsea and Kitty! This comic is for you guys! A girl named Chelsea and her cat named Kitty have some really awesome views on life and how to live it. And by "awesome" I mean ridiculous. And by "life" I mean literally everything. Prepare yourselves for the oddball adventures of "Chelsea and Kitty!"', False, True)
add('CheneysGotaGun', 'http://cheney.smackjeeves.com/comics/', u"Cheney's back! Ever wonder what Dick Cheney is doing in his secure undisclosed location? The Hunting \ufffdaccident\ufffd was only the beginning. Dick Cheney has now found his true calling. Tag along as the vice president cleans out his guns, and dusts off the ammo boxes as he fights his way through a world of terrorists from Cidy Sheehan to Osama Bin Laden. This is a graphic novel I did a few years ago and have decided to give it a rerun.", False, True)
add('ChesterandFerdie', 'http://caf.smackjeeves.com/comics/', u'Chester and Ferdie updates once a week, usually on the weekend!', False, True)
add('ChickenScratches', 'http://chickenscratches.smackjeeves.com/comics/', u'A slice of life 4-panel comic. A journal about a young man and his troubles in life. Updates Monday to Friday. Sunday is a Sketchbook entry.', False, True)
add('ChildrenoftheEternalSpring', 'http://offspring.smackjeeves.com/comics/', u'Stories about a world made by a woman named Eternal. first chapter: Door Knocker Pendant "two girls in a quest to retrieve a world legend two children searching for each other one pendant to cross their paths and a door to take the children back to their homeland..." it focuses on the final adventure of Hi and her comrades Atta and Rote in their quest to retrieve the Door Knocker pendant from a man who\'s only will was to open one single door and isolate the power he believes he deserved. note: mild violence, dry humour, updates: every week, if possible...', False, True)
add('ChildrenoftheNight', 'http://cotn.smackjeeves.com/comics/', u'Vampires are at the brink of extinction ruled with a heavy hand by the Hunters, an order of vampire slayers that has existed since the beginning of mankind. The centuries-old law is very clear; a vampire can only feed off criminals whose names are on the lists provided by the Hunters. Any other interaction with humans means punishment and even execution if they are harmed. But when an unlikely friendship between a human girl and a vampire starts to grow into something much deeper, can these laws be obeyed? CotN is a romance webcomic set in the Victorian Era, depicting forbidden love amidst a clash between vampires and the Hunters, an order of vampire slayers. :It updates every Monday:', False, True)
add('Chimerical', 'http://chimerical.smackjeeves.com/comics/', u"Ever since he was thirteen, visions of monsters and other supernatural beings have plagued Brett's mind. With the help from Quinn, a wannabe mortician who is infatuated with him, Brett becomes a part of a mission to get rid of these monsters once and for all. Unfortunately, everything is not what it seems and nothing goes as planned. --- warnings for gore/violence and terrible, horrible puns. updates every sunday and wednesday. other website: http://chimerical.the-comic.org", False, True)
add('ChimiMouryou', 'http://cmmr.smackjeeves.com/comics/', u'Near the top of one of Japan\'s many mountains away from all the human villages, there is a forest inhabited by youkai who are constantly learning how to deal with each other. Basically, "The Daily Lives of Crazy Youkai" This comic is a bunch of random short stories and not one continuous one. Everything is acted out in pantomime AKA there are no written words. Chimi mouryou can be roughly translated as "evil monsters in the mountains and rivers". The legend of it keeps the forest safe from humans. I am still researching more about the Edo period and youkai, so I apologize for unintentional inaccuracies. For now, the updates for this comic are random. I apologize!', False, True)
add('ChocolatewithPepper', 'http://chocolate-with-pepper.smackjeeves.com/comics/', u"The story takes place in the 1920s in a lovely small town called Ventura, in Brazil. Its economic growth depends on a local chocolate factory called Bombom, which is very famous for its chocolate. Ana Francisca is a beautiful young girl, but she is from a poor family. She hides her beauty with big glasses, old hairstyle, and outdated clothing. She lost her parents not too long ago and moved to Ventura to live with her other family members. In that family, there are her Grandma Carmen, Uncle Margarido, Cousins Marcia and Timothy, and Dalia, who was accepted into the family. Ana helps out at home until she is accepted a job to work as a janitor at the Chocolate Factory after school. There she meets Ludovico, the factory owner who pretends to be one of the workers at the factory. Ludovico returns to Ventura to investigate his greedy sister Jezebel, who lives like a queen after taking over the factory. While Ana's in Ventura, she falls in love with Danilo, the town's flirt who has dated almost every girl in town. However, his main love interest is the beautiful girl, Olga. Although he says he never fall in love, will that possibly change after meeting Ana Francisca?", False, True)
add('CityFolk', 'http://cityfolk.smackjeeves.com/comics/', u'Tired of a dull life in the wilderness of British Columbia, a beaver and a moose make the trip of a lifetime; into the heart of the city. This is their story. City Folk will not be updating for a while. My computer has finally given up on life and I have no way of scanning/editing/uploading. Life sucks until I can get a new tower.', False, True)
add('ClairetheFlare', 'http://clairetheflare.smackjeeves.com/comics/', u"Claire is new to this whole superhero thing, but she knows what it's all about. Getting famous! But with veteran heroine Bulldozer breathing down her neck its not going to be easy. Updates Three Days a Week! Monday, Wednesday and Friday.", False, False)
add('CleanCure', 'http://cleanpluscure.smackjeeves.com/comics/', u'-A few hundred years into the future, life has changed, but remained relatively the same from a social standpoint. Various government plans to deal with the changing global climate ended in many successes, but many more failures. As a result, certain mutations began to appear in humans as well as animals, and though most were bred out, some remain to the present. -Enter Ezra and Percy; two young men, cat-boys in fact, whom are facing a tough time not only surviving day to day, but making their dreams a reality. After losing their current job, they are offered a new one by a seemingly normal, but secretive man with a lot of money. Their new boss employs them as maids, frilly dresses and all, and makes them clean his and the mansions of others. It quickly becomes apparent that their boss is more interested in the ever mutating rat-like creatures which are making their homes in the dirty world of military cover-ups and powerful family connections. When these two get caught up in the lies and secrecy of their new occupation, will they be able to escape? And what is the connection between mutations and the incident 20 years ago?', False, True)
add('ClockworkAtrium', 'http://www.clockwork-atrium.com/comics/', u'In a misguided attempt to develop their full potential for success, students at a German university are forced to participate in a campus chess "game" in which they are the pieces and the captures could consist of murder. Updates Sundays.', False, True)
add('CloeRemembrance', 'http://cloe.smackjeeves.com/comics/', u"This story is set in the victorian era. Liam is an 11 year-old boy that arrives to a wealthy mansion to work with his father, the gardener. In this place he is asked to be the playmate of the youngest master, Edward, who's about his age. However, Edward turns out to be a spoilt and malicious kid that wants to keep all the attention to himself... What will Liam do to gain his trust and become his friend? ---------------------------------------- This is a young love shounen-ai (boy/boy) Manga format: *Please read from right to left* THIS STORY IS ALREADY FINISHED!", False, False)
add('Codearth', 'http://codearth.smackjeeves.com/comics/', u'A thousand or so years in the future, humanity rests in the palms of two companies. Unknowingly living in a world that could easily collapse and an outside world of vast nothingness. From here we shall mainly focus on two young people; Code Chestock and Dominic Eode as they shift through the world learning its secrets. I try to update every Friday through Sunday and maybe on some other random day, because why not? basically I update whenever I finish a page. So if that means updating everyday, twice a day, or after a long period of time, let it happen. I will take helpful critique for this comic as well, because I know it needs a lot of work.', False, True)
add('Coined', 'http://coined.smackjeeves.com/comics/', u"'Coined!' is a BL (and occassionally nsfw) super hero series that takes place in Samaritan City, a place where special powers are so common that even your neighbours cat can be a villain of a hero. With telephone booths popping up like daisies and the Evil Guild and the FBD spending more time battling lawsuits than each other, Eli Stone has a hard time adjusting to the ever changing city after his seven year prison break. Torn between the life and lover he left behind and becoming the trainer of a lovestruck wannabe hero, he finds that, like himself, the traditional roles of heroes and villains may have changed.", True, True)
add('ColorBlind', 'http://cbcomic.smackjeeves.com/comics/', u'Five 13-year olds discover a world that makes theirs seem grey in comparison in a closet at their school. It is a world of magic, and adventure, and a war that the kids might have gotten sucked into accidentally. Main Site: http://colorblindcomic.com/ Updates are Mondays and Fridays.', False, True)
add('ComicBrozSprites', 'http://brozsprites.smackjeeves.com/comics/', u'Just some sprites sheets by Ultimate and Solar. We also accept requests ALL RUDE COMMENTS DELETED!', False, True)
add('Contradiction', 'http://contradiction.smackjeeves.com/comics/', u"THIS MANGA IS READ FROM RIGHT TO LEFT (Updates every FRIDAY) Ruya Saki received an invitation to attend Teiou Gakuen in Setsuyamachi, a town for magic users. Not knowing the reason why she was invited, Ruya headed towards the mysterious town. A choice between Light and Darkness... an enthusiastic president and his rival... 'Contradiction', the story of Light and Darkness magical users, the story of friends, betrayal, hatred, past, loyalty, revenge, endurance and love.", False, True)
add('ConventionalWisdom', 'http://conventionalwisdom.smackjeeves.com/comics/', u'Ever wondered what goes on inside an anime convention, but are too afraid go anywhere near one yourself? Well, wonder no more! Conventional Wisdom is a comic that shows you what this strange, geeky world is really like, based ENTIRELY ON REAL LIFE! ...well, sort of. (Currently moving over from DrunkDuck, so please be patient)', False, True)
add('Cramberries', 'http://cramberries.smackjeeves.com/comics/', u"Lucinda is just a normal girl who lives with her roommate in an apartment... until her childhood friend came back to visit here. Now, she has been cursed with a demonic eye and almost everyone seems to be after her. Could it be her eye that everyone is after or is it there something more to it? Follow Lucinda and her friends as they uncover dark secrets and traverse their way along a perilous journey filled with all manners of action, humour, evil and good, love and stupidity. Updates are now Mondays and (occasionally) Thursdays! KitKatMuffin: Artist and Creator Seranatis: Editor and Assistant NOTE: The Editor sometimes post some random art and leaves messages when I'm not available on the website; regardless, they are NOT canon.", False, True)
add('CrappilyDrawnMinicomics', 'http://cdminicomics.smackjeeves.com/comics/', u'Welcome to see the antics of Rob and Ian in their increasingly derpy day-to-day lives. Takes place in London 1999. Drawing and handwriting quality will range from semi-good to utterly crappy. Enjoy :)', True, False)
add('CrayonComicStory', 'http://crayoncomic.smackjeeves.com/comics/', u'A drawing comic about anything. If you REALLY must swear, censor it please. Violence is allowed, but not nudity or swearing.', False, True)
add('Crazy', 'http://hanahanacrazy.smackjeeves.com/comics/', u"[\u82b1(Hana)=flower] A SasukexNaruto and KakashixIruka doujinshi: Naruto: A story about a boy who must live his life as a girl and is arranged to be married to a person he can't stand. Iruka: A story about a man who is stuck in a one-sided love with his employer, and to make things worse he is forced to work with a person that he had a one night stand with. updates randomly in bunches rating g-R18", False, True)
add('Crazyghosts', 'http://vbcomics.smackjeeves.com/comics/', u"Hi, my name's Vince and welcome to my comic Crazyghost's. A silly, perverted, goofy for equally silly, pervert, goofy people. I hope they give you a good laugh, or at least a chuckle! ^_^", True, True)
add('CupofOlea', 'http://cupofolea.smackjeeves.com/comics/', u"Cup of Olea is a text-based adventure game inspired by Lunar Hill! Take command of Cliff Gradel and his friends to serve your land and your king! And don't worry if you get confused; it makes the adventure that much more fun. Just submit a command on the latest page and see what happens! Updates Thursdays and Sundays. (Sometimes surprise Friday updates!) Don't be afraid of the page count! It reads quickly!", False, True)
add('CurseLineage', 'http://curselineage.smackjeeves.com/comics/', u'Read from right to left. Ayla Exonuke, A young Yuzcazi is being chased by the Kirimangalou Empire, They think she is the last one of a long-lost lineage. Together with her brother Kokei (not related by blood) They try to survive to the empire attacks and any other things that get in their way. Genre:Action,Adventure,Fantasy. release schedule: Thursday.', False, True)
add('Cynobrowa4', 'http://cynobrowa4.smackjeeves.com/comics/', u'Polish version of Vermilion4 Opowie\u015bc o Amelce i jej k\u0142opotach z "rodzink\u0105". Jest te\u017c odrobin\u0119 o magii i o prawdziwych talentach ;) English version: http://vermilion4.smackjeeves.com/', False, True)
add('DBON', 'http://dbondoujin.smackjeeves.com/comics/', u'An 8 issue long crossover manga of Shounen Jump classics, Dragonball Z, Bleach, One Piece and Naruto. that i did a little while back as something iv always wanted to do/see, and also practice for my own original long running manga Ryak-Lo (Reads Right to Left) this is a fan comic, all characters belong to their respective creators.', False, True)
add('DDSR', 'http://ddsr.smackjeeves.com/comics/', u'A sprite comic that has no Sonic sprites! Seriously, all customly done. Join two friends and there crazy adventures involving demons, robots, explosions and shiny things.', False, True)
add('DEGAF', 'http://degaf.smackjeeves.com/comics/', u"Death God Alchemists from the Future (DEGAF) is a (hopefully) humorous magical girl manga spoof about an ordinary girl named Britney. When a Death God possesses her cat, she learns that her destiny is to lead a magical girl team with fruit related powers. And probably save the world or something. Inter-dimensional demons are involved. Possibly an evil Alchemist. Plot Cat's a little fuzzy on the details... The characters are loosely based on myself and my friends (some of which are not represented by their correct genders). The quality of art has increased over time, but rather than try to redo the original pages, I will focus my energy on furthering the story. Updates Thursdays", False, True)
add('DEMENTED', 'http://demented.smackjeeves.com/comics/', u"// Warning 18+ Only: BL, Violence, Strong Language // We're all going to Hell eventually. But what happens if you've taken a visit to it and a certain little someone followed you back on Earth..? CHAOS ensues. Take a ride with Slayne, a killer-for-hire where everyday is the worst day of his life~", True, True)
add('DanielleDark', 'http://danielledark.smackjeeves.com/comics/', u"Danielle Dark is a vampire trying to make it in the mortal world. It isn't easy, and she is discovering that she is different than other vampires in many ways.", False, True)
add('Dao', 'http://dao.smackjeeves.com/comics/', u"A comic about Boy-love, action, drama, humor and crazy animol-people. I reply to every comment :'D so feel free!", False, True)
add('DarrenandJason', 'http://renandjay.smackjeeves.com/comics/', u'Two male foxes go on a relationship journey, intoducing new characters relatively constantly, explaining their everyday life in the random comic world.', True, True)
add('Dasien', 'http://dasien.smackjeeves.com/comics/', u'Superhero girly goodness! Action series featuring Dasien the Blonde Bombshell, her best friend Parker Lynn Bailey, and an evil superhero extermination squad, The Crimson Gestalt! Humor and suspense. Some adult themes.', True, True)
add('DavidDoesntGetIt', 'http://daviddoesntgetit.smackjeeves.com/comics/', u'A diary comic of me and my three siblings.', False, True)
add('DeadFingers', 'http://deadfingers.smackjeeves.com/comics/', u'Sci-fi/adventure about an indigenous girl growing up among the rest of her tribe within the barren desert. Her passive life becomes an ongoing struggle for survival after the declaration of a 15 year global war by the mainland empire. Contains violence, language and sexual content.', True, True)
add('DeadFishComics', 'http://watghosthunter.smackjeeves.com/comics/', u"I just put random comics I draw here. Mostly: Fancomics (Tiger and Bunny, video games etc) Also: a lot of original comic series: Adventures of a Supervillain In Love: Mad scientist meets guy who won't take off his helmet. Love ensues! Moira Adventures: girl get new job, meets crazies. Wat Ghost Hunter: Guy gets stalked by ghost who wants to take him to Tim Hortons. Succubooks: In a videogame world the tale of a man and his succubus/incubus/book. Pretty much anything could end up here. Contains Bl, yaoi, M/M sex, and nudity of both sexes.", True, True)
add('DeadLine', 'http://deadline12.smackjeeves.com/comics/', u'16 year old girl, goes to school, hangs out with friends, two loving parents and works for the department of death. Where all her jobs have a "deadline" Oh, there\'s also some yaoi/yuri in it, but later in the comic, you\'ll see. I also recommend that if your under the age of fifteen that you would discuss this with your parents due to sexual content and graphic violence', False, True)
add('DeadtoDay', 'http://deadtoday.smackjeeves.com/comics/', u"Elpis, immortal vagrant at ten years old, is taken in by a dysfunctional family. Two of the siblings hate each other, the father's dreadfully nervous, the mother has super strength... Yet the oddest thing is, save Elpis herself, they're all dead. And what's this about the prince of the dead going AWOL? And who's that immortal boy with the mask, running around stealing food? Add some mischievous spiritual healers, extended family complications, violence, and liaisons, and Elpis sometimes wonders if she should just up and leave again! Then, things become further complicated when she receives an ominous, glowing book...", False, True)
add('DeathNoteIridescent', 'http://dn-iridescent.smackjeeves.com/comics/', u'Iridescent: Producing a display of lustrous, rainbowlike colors. Completed. Extra chapters in the making~', False, False)
add('DebtSettlement2OperationExtinction', 'http://debts2.smackjeeves.com/comics/', u'Character info and much more can be found at: http://sites.google.com/site/debtsettlementcomic Direct sequel to "Debt Settlement". (It is recommended to read that before this one): "3 years later. There is trouble on the way as the Red Star Security find their officers being gunned down. Seeing there is no other choice, they decide to make a direct approach towards their rival organization, Blue Labels and see if they know anything about these attakcs. With the old cast and a big list of new ones, DSOE opens up the reality Samantha is now living in. She and the rest of RSS has to learn to work with their old enemies and find a way to survive when someone obviously wants them all dead. Who are the Nightbringers and are they a threat? Can Samantha really deal with the responsibility she chose to carry in the crew? And is rest of her family really willing to let such new arrival just run them over in to the leaders position? A lot of questions are answered and secrets revealed."', True, True)
add('Debtsettlement', 'http://debts.smackjeeves.com/comics/', u'Character info and much more can be found at: http://sites.google.com/site/debtsettlementcomic DEBT SETTLEMENT " Samantha is 14-year-old girl with little to no hope for her own future. Her mother is an alcoholic in a debt trap and after getting even Samantha in to trouble because of her own mistakes, the only people who can help the girl now, are on the side of the family Samantha didn\'t even know existed. Problem is, does she really want their help? " DEBT SETTLEMENT:RUNAWAY BROTHERS " 27 pages long spin-off which will reveal you how did Kiran and Deepak, the brothers from a super religious Aditya family ended up working for RSS. "', True, True)
add('DefineHero', 'http://definehero.smackjeeves.com/comics/', u'A series of adventures staring an evil cat witch, her "evil" minion dragon and their hero...named Hero...who has no idea who...or what he is. Thinking they struck it rich by finding a god-like being that can do what ever they command him to do, Gaffy and Dragon take Hero in as part of their group. As Hero travels with them, however, his instinct to do innocent good deeds such as rescuing pretty damsels, returning lost keys or fighting a monster or two leads them into epic...and sometimes hilarious (mis)adventures. Read from left to right Updates often (2-3 times a week) Accepts ideas for story arcs and spin offs! Comic banner by AnnaLena250199 on Deviant Art! http://annalena250199.deviantart.com/', False, True)
add('DefyingGravityTheFourGreatGuardians', 'http://defyinggravitycomic.smackjeeves.com/comics/', u'It is the year 3015, the sun has begun to fade and the world is cast into shadow. As prophecized, the fate of the world rests on the shoulders of the "Four Great Guardians" who are said to re-ignite the sun and bring an end to the war ravaging the planet. But just who are the four guardians? In mid-apocalyptic Europe, three half-human half-demon citizens are brought together by what can only be called fate. The only question that remains is: Who is the fourth Guardian? Meanwhile, a failed Russian experiment known as the "Dragon" is wreaking havoc upon the already helpless world. ****Updates 3 pages every Sunday****', False, True)
add('DemonEater', 'http://demoneater.smackjeeves.com/comics/', u'A cannibalistic world where the inhabitants only food is each other.', True, False)
add('DenizensAttention', 'http://denizensattention.smackjeeves.com/comics/', u"Alicka and her little brother Winston are sent to Winterkill Boarding School. The number one dumping ground of unwanted troubled teens. A miniature Gormenghast filled with bad seeds and black sheep. +++++++ Winterkill: to kill by or die from exposure to cold winter weather. ++++++ This comic will update when i can. i'm trying for once a week, but not always managing. ++++ Denizens! Attention! how has its very own tumblr http://confessionsofawannabecomicartist.tumblr.com for updates, news and random comic making thoughts and sketches.", False, False)
add('DepthsOfMyEmptySoul', 'http://depthsofmyemptysoul.smackjeeves.com/comics/', u"Zadel, demon prince of Hell 7, struggles to prove himself to his mother and all who he's destined to rule over. The source of his struggles? His arch rival, yet best friend, Angel Abel. The truth is, Zadel rather spend his time enjoying Abel's company than act like the future ruler of Hell 7 and meanwhile other demons have their eyes on the throne. Zadel is being pressured to change his behavior and become a cold and respectable demon prince worthy of inheriting the throne, something that promises to put his friendship with Abel to the test. Will he finally make his final decision and chose his role as demon prince over his friendship with Abel? One night when Zadel's feeling bored and yearning for the company of Abel, he decides to pick on a down on his luck human. He tries and succeeds in persuading the human, Jacob, into making a bet with him wagering his own soul. Soon he realizes that picking on Jacob was not such a good idea. Bickering, jealousy and some romance ensues as Zadel and Abel both battle to doom or save Jacob's soul. But another more threatening battle approaches as well. BL, GL, HL Art improves over time.", True, True)
add('Descendant', 'http://descendant.smackjeeves.com/comics/', u'With the disappearance of her husband and her life dwindling to nothing, Celeste begins her quest to not only reclaim the fervor of her life but to also tangle with the now unfurling chaos that has consumed her being. This fledgling Descendant, with the most powerful relic on earth, finds herself violently hunted by those whose lives stretch back to antiquity. Can she come to terms with the revelation that the whole of humanity knows literally nothing about the nature of their existence and can she muster within herself the will to thwart the anger of an ancient god?', False, True)
add('Destinationunknown', 'http://destination-unknown.smackjeeves.com/comics/', u'The long, convoluted story of Yuri, a recovering drug addict marooned on an alien planet, and the host of characters he encounters as he tries to navigate the difficulties he faces. He may or may not be the key player in a looming crisis that threatens to change the ENTIRE UNIVERSE(!) Among the people who help or hinder him in his journey are: MIRIYAM YUSEF, a rock and roll messiah CAMRUN SHAFT, and old man who apparently knows more than he\'s letting on BISHOP TIADORA, the pope of Iona V SISTER LENA, a nun formerly of the Geul Order JAELL, a choirgirl who is infatuated with Yuri, GRAVES, who may or may not be The Devil, and MALEAH, an "extreme extraction specialist" or assassin from Terra who has a contract to fulfill. Underneath it all, DESTINATION: UNKNOWN explores the theme of Destiny vs. Free Will with rayguns and spaceships (eventually) and rock and roll (soon) Please read on, and I hope you enjoy it!', False, True)
add('DevilsCake', 'http://devilscake.smackjeeves.com/comics/', u"When Kea finds that her bad luck with boys isn't a 'what' but a 'who', will her sanity survive the IN-sanity that ensues? PG-13 Currently Updates Mondays", False, False)
add('DevotoMusicinHell', 'http://devoto.smackjeeves.com/comics/', u"This is the story of how the now-fallen Principality of Music, formerly an angel of some repute, was given an opportunity to provide inspiration for one working man desperately in need of a muse. Other angels, fallen and not, are further compatriots, such as Devoto's surprisingly sympathetic boss and the armadillo aficionado commonly known as Sloth. Though the divines are great, and in some cases terrible, each is coming to appreciate the value of a uniquely human connection. (Gag, right? The important thing is that Guys Make Out. Guaranteed.) Warnings for: - Explicit gay content - Blood/Gore (but not in sexual contexts) Relevant tags: Yaoi , BL , gay , M/M , erotica , pornography , porn , F/F , yuri SJ Note: I understand SJ policy, and thus it's worth noting that this comic does not and will not portray sexual situations with minors or individuals who appear to be minors. Furthermore, this comic will not portray non-consensual (or dubiously consensual) sex.", True, True)
add('DigimonCorruption', 'http://digimoncorruption.smackjeeves.com/comics/', u"The world is in chaos. BlackWarGreymon and Omnimon continue to watch the Digital World collapse around them as Ebonwumon remains imprisoned. Meanwhile, the Daemon Corps is gathering more and more Fractal Code from innocent Digimon as they go about their search for the Code Crowns. But the DigiDestined is back to set things right, and he's no longer alone.", False, True)
add('DigimonSaviors', 'http://digimonsaviors.smackjeeves.com/comics/', u'.:THE ALMOST ORIGINAL:. When 9 children are mysteriously transported to a new world, they come across strange monsters called Digimon. These digimon help them survive the digital world as they try to do anything possible to find an escape from this world... ------------------------------------------------------ After defeating the D-reaper in the Real World, a vision was shown to Neroe and Agumon that the digital world was in danger. Upon returning there, they learn how much trouble they set themselves up for exactly. How will the digidestined fight this ultimate threat? Find out on Arc 5 of Digimon Saviors! Neroe - Agumon Shard - Gaomon AnXjak - Crabmon Ankh - Gotsumon Marly - Impmon Beth - Hawkmon Neo - Guilmon CD - Wormmon Radd - Renamon Van - Veemon anime.... in... space', False, True)
add('DoItYourself', 'http://diy.smackjeeves.com/comics/', u'Lucas had expected a summer full of video games and hanging out with friends before his parents "volunteered" him to put his college degree to use and help his aunt Lola and cousin Noelle renovate their house. Though he is strongly against wasting his summer on backbreaking labor for room and board in a sleepy little town with no cable or internet, he finds it even worse that he has to renovate alongside Noelle\'s best friend Ashley, who is also helping in his spare time out of the goodness of his heart. Lucas is convinced Ashley has an ulterior motive and is determined to ambush him at every angle. This is a BL comic, meaning it will contain scenes with romance between two boys. But I bet you already knew that, amirite? ;) Updates every Friday (at the very least)', False, True)
add('DoodleBeans', 'http://beans.smackjeeves.com/comics/', u'No arms? No legs? No problem! Superheroes, Tentacle Monsters, Video Games, Violence, and PLOT!? If you like it, please comment and +favs Comic updates Monday-Friday at Midnight (PDT)', True, True)
add('DoodlingAround', 'http://doodlingcomic.smackjeeves.com/comics/', u'', False, True)
add('DoomsdayMyDear', 'http://www.doomsdaymydear.com/comics/', u'A turn-of-the-20th century webcomic drama about a modern day plague, the political turmoil that follows in its wake, and the lives of the people it touches.', False, True)
add('DougsMindDougshugs', 'http://dhstrips.smackjeeves.com/comics/', u'', True, True)
add('DragonKid', 'http://dragonkid.smackjeeves.com/comics/', u"Dragon Kid is the story of Keiko Shoda, a little girl from a land called Dragon Haven. Curious and strong-headed, she disobeys her brothers' warnings and ventures into the lair of the Dark Dragon, Kuronaga, accidentally freeing him. Now banished into the Mortal Realms because of her doing, she must become the heroine she is destined to be.", False, True)
add('DragonOrigin', 'http://dragonorigin.smackjeeves.com/comics/', u"On a island somewhere, hidden to the human eye, are shape shifting creatures called dragons. This island is the beginning of almost every dragon. This island is called 'Origin'. Dragons occasionally leave their nest at Origin and venture into the human domains. Some of them form relationships with humans as their guardians and the humans as their tamers. One particularly unlucky dragon decides to leave origin. He spends his life cautious of other living things and always alone. He vowed never to trust any one. That is, until a young girl comes along and earned his trust. Now he has a new vow. To protect this girl that has become his tamer, no matter what. Little does he know, there are more things in store for him then just protecting his new tamer. Contains: Romance, blood, violence.", False, True)
add('Dragonet', 'http://dragonet.smackjeeves.com/comics/', u'A wizard tries to raise an orphaned dragon in a world filled with fantasy, magic, war, and adventure. He soon finds out a dragon does what it wants...and he may make all the difference.', False, True)
add('Dreamcatchers', 'http://dream-catchers.smackjeeves.com/comics/', u"Motsury Sohiru has been suffering from nightmares from long time, but one day fate drives her to a shop, where she finds a dreamcatcher. It would be all nice, but she hasn't got enough money to buy it, so she decides to steal it, but it get soon to an enemy of her, and when Sohiru get it back it is already broken. The next night she gets into a nightmare again, and the dreamcather brings it to the real world with a boy who saved her in the dream. But what can she do with this stranger? And what will happen after dreams and dreams? It will turn out from the manga...", False, False)
add('DungeonHordes', 'http://dungeonhordes.smackjeeves.com/comics/', u'In 1986 Dungeon Hordes was released on the Playtendo and moved 1 million units world wide which is way more successful than its previous release on the Batari 2200 in 1979. Now in 2011 Dungeon Hordes has returned bigger and better than ever with mind numbing graphics and all new enemies to fight. So how do the characters in game feel about this? Only time will tell. Enter the lives of Tiggz and Tomes, two level 5 bosses tired of being easily killed by player 1 and wanting the glory of finally becoming more than just petty bandits. Will they survive the new creatures that the mighty programmers have added to the game? Will they ever kill player 1 and move up the mob boss ladder? Will they ever get a raise from their uptight dungeon boss Kalakis and finally pay off their ale tabs at the Stinky Dragon Inn? Stay tuned and find out..... Will be updated Every Monday, Wednesday and Friday. Dungeon Hordes Facebook http://www.facebook.com/pages/Dungeon-Hordes#!/pages/Dungeon-Hordes/195568970460655', False, True)
add('EATATAU', 'http://eatatau.smackjeeves.com/comics/', u'', False, True)
add('ERAConvergence', 'http://convergence.smackjeeves.com/comics/', u"UPDATES MONDAY AND THURSDAY! The Darkwood corporation is in jeapordy if Velias doesn't manage to retrieve evidence stolen by a pesky rebel rat. He decides to hatch a plan to kidnap the rebel's clueless little sister, but finds that more difficult than he thought...", False, True)
add('ERAIbuki', 'http://eraibuki.smackjeeves.com/comics/', u"A short story about a girl with a kind heart who is faced against a world that's just too strong for her to fight. But it doesn't stop her from trying. Updates DAILY This comic is now a Premium Comic on Manga Magazine! :) If it isn't too much trouble, please give the comic one click over there too! :)", False, True)
add('ERRORERROR', 'http://errorerror.smackjeeves.com/comics/', u'A finnish teenage boy Tomi is a normal nerd. He plays videogames and gets average grades, but also is terribly bored with his life. But one day he accidentally gets inside of his computer and meets there a girl, who calls herself princess Jooda. And there is a profecy about Tomi, sword and Viruses. Warnings: If you are under 13 years old, I do not recommend this comic to you. Contains bad language, blood and somewhat sexual themes. ps. This started out as a test for new tablet, so the start looks like that too. Also, sorry about the style changes, I practice. Updates 2-4 pages a week.', False, False)
add('ElementalSpirits', 'http://elementalspirits.smackjeeves.com/comics/', u"Alex's notes to self #23: Do not grab seemingly innocuous sword. Life changing events and general bad things may follow... Elemental Spirits updates every Monday.", False, True)
add('ElfNHood', 'http://elfnhood.smackjeeves.com/comics/', u'In a fantasy realm known as Hyren, a world of heroes and evil, wars and love. A band of Mercenaries known as "Elf n Hood" try to make a living, doing quest and missions from the locals. Plot based comic, with little jokes on the side.', False, True)
add('ElfenLiedDifferences', 'http://differences.smackjeeves.com/comics/', u"One of my favorite mangas is Lynn Okamoto's famous Elfen Lied (Which likewise I should clarify that I absolutely HATE the anime version) This comic is based on a trilogy story I wrote for FF.Net which I can't say was the best but it was fun nonetheless. --- Differences can be considered an alternate Universe Sequel to the manga. The story revolves around the actions of the second Queen Diclonius. --- It's all I can say, I'm not an artist, I just draw for fun. Enjoy Because it's based off of a Seinen Manga, there's going to be some adult content including Blood and Gore Language Nudity Sorry for inconsistent art as well. Read: Left to Right. When I started it, I didn't do as a traditional manga nor did I feel like changing it up either. Be nice, but feel free to criticize. --- Re-doing Volume I, updates will probably be weekly.", True, True)
add('EmptyWorld', 'http://empty-world.smackjeeves.com/comics/', u'<enter synopsis here> **This manga... -reads from right to left -is released by chapters, not pages -will decrease in quality due to laziness -art will change a lot as chapters go by since im still trying to improve', False, True)
add('EnkeltenKentta', 'http://enkeltenkentta.smackjeeves.com/comics/', u"Sakari Kauria has been living the humble life of a show bartender for a few years. His life isn't glamorous, but when he isn't too self-aware about the quirks in his appearance, it's good enough. He knows who he is, and he knows how the cogwheels of the world run... Except he really doesn't. Luckily during one chaotically eventful night, he encounters Lucifer. A youngster with a similar twist in his appearance, who knows a lot more about the world they live in, and a few answers to some questions about Sakari himself that have plagued him ever since he knew he wasn't like the rest of his kind.", True, True)
add('Entreeuxdeux', 'http://entreuxdeux.smackjeeves.com/comics/', u'"Entre eux deux" est une bande-dessin\xe9e amateur qui sent bon la poudre, les fusillades et la mafia, mais qui en fait se pr\xe9occupe plus des deux destins qui y ont difficilement trouv\xe9 leur place. Deux \xeatres que tout s\xe9pare, mais finalement pas tant que \xe7a... Je poste les pages par quatre (quand j\'y arrive) tous les 15 jour, le dimanche. Merci \xe0 tous ceux qui passent par ici. >w<', False, True)
add('EozinKadonnutKuningas', 'http://eozinkadonnutkuningas.smackjeeves.com/comics/', u'30 vuotta sitten Eozin kuningaskuntaa kohtasi vampyyrien joukkohy\xf6kk\xe4ys jonka taistelussa kruunupari menett\xe4v\xe4t henkens\xe4 ja kruunun perillisist\xe4 vanhempi katoaa j\xe4ljett\xf6miin taistelun keskell\xe4 kun nuorempi perillinen saadaan siirretty\xe4 turvaan, mutta norukaisen olinpaikasta ei ole t\xe4n\xe4k\xe4\xe4n p\xe4iv\xe4n\xe4 mit\xe4\xe4n tietoa. Er\xe4\xe4n\xe4 p\xe4iv\xe4n\xe4 kaapuun pukeutunut vaeltava nuorukainen kohtaa siivekk\xe4\xe4n olennon. Syyst\xe4 tai toisesta he alkavat matkustaa yhdess\xe4 kohdaten matkallaan yst\xe4v\xe4llist\xe4 v\xe4ke\xe4, mutta my\xf6s vaarallista. Matka on tuntematon ja uhmakas, eik\xe4 kaksikon heikko suhde toisiinsa edist\xe4 matkaa, mutta ajan kuluessa tapahtuu molemmille hyvin yll\xe4tyksellisi\xe4 asioita.', False, True)
add('Equsopia', 'http://equsopia.smackjeeves.com/comics/', u'Because of black magic, the king and his loyal knight were sent to another world. Now they must find the way home. Read from left to right. Facebook page : http://www.facebook.com/Equsopia Join me on FB page for more arts, contests, and gifts!', False, True)
add('ErokusosClassics', 'http://erokusosclassics.smackjeeves.com/comics/', u'Here are all my old comics from around 2003-2008 before discovering smackjeeves and making a major overhaul to my comics. You will find out how Merc & Tech were before and the nature of Vyydia was different as well. WARNING! Fuzzy sprites ! !', False, True)
add('EternityConcepts', 'http://eternityconcepts.smackjeeves.com/comics/', u"WARNING: This is a yaoi manga. There is no sex--but there is some suggestion, and a large amount of adult humor. Julian--err, Father Julian--Father Skyy? Just call him Julian--is a priest at Sacred Heart Cathedral. . .and deeply depressed. After a long struggle with his depression, he concludes a deadly solution, convinced it's the only one he has; En route to take his own life, Julian discovers the body of another man who's beaten him to the same punch--and in the snap moment of a life or death situation, Julian forgoes his plans to save a life. Thus he meets Hollow, a depressed Atheist whom Julian now accredits his illumination to happiness to; Having now come to close to experiencing the damage he himself was about to cause, Julian feels transformed--and wants to return the favor to Hollow and do the same for him. If he can't--surely God can! While they agree to disagree, Hollow and Julian form an odd, close friendship--and soon, Julian forgets about converting Hollow and begins to realize his feelings. . .may mean something else. All the while, they're never aware of the danger lurking in the shadows. . .", True, True)
add('EvD', 'http://ev-d.smackjeeves.com/comics/', u'Gail never seems to be able to have peace. Not when everyone is out to get him. And yet the person at the top of that list is himself. Nothing is good and everything hurts. But perhaps.. This is just what the gods wanted. [Contains innappropriate language occassionally] Updates on Wednesdays', False, True)
add('EvilPlan', 'http://evilplan.thewebcomic.com/comics/', u"Evil Plan takes the superhero world and flips it, viewing things from the supervillain's perspective. The story follows Dr. Kinesis' journey on the road to world conquest. On the way, he'll have to deal with a troublesome AI, his unwilling friendship with crazy black-market dealers, and the possibility of romance with his second-in-command. And the superhero. Can't forget that guy. With all this going on, Evil Plan is a comic for people who want to see the bad guy win. If he doesn't blow himself up first. Story and Line Art: Alexis Royce Color: Megan Johnston, Chelsea Capobianco Updates: Every Sunday", False, False)
add('EyesofaDigimon', 'http://eoad.smackjeeves.com/comics/', u'A fictional Digimon manga about a boy and a unique Digimon. Based off the series by Akiyoshi Hongo.', False, True)
add('FailureConfetti', 'http://failureconfetti.smackjeeves.com/comics/', u'Failure Confetti is a webcomic about life, words, science, games, and human observations. Updates weekly, on Wednesdays.', False, False)
add('FairyTaleRejects', 'http://fairytalerejects.thewebcomic.com/comics/', u"A vengeful viking centaur. A drunken cowardly satyr. What do these creatures have in common? Absolutely nothing, but they're on a quest to save little Tomato's mom.", True, True)
add('FairyTales', 'http://fairytales.smackjeeves.com/comics/', u"Forced to move to a new town, 15-year-old Kiki Manders has been given a much-needed chance to start her life over. However, that's not so easy when your family thinks you're crazy. Kiki's certainly does, and maybe they're right. After all, her best friend is a fairy that nobody else can see. And that's the LEAST of her worries. Family trauma, high school drama, and the paranormal; Kiki's life may not be easy, but at least it's never dull.", False, True)
add('FalconersDailyStrips', 'http://falcdaily.smackjeeves.com/comics/', u'Daily comic strips I throw together with little effort just for funzies.', False, True)
add('FallenAngelslove', 'http://fallen-angels-love.smackjeeves.com/comics/', u"A cute BL story No smex for awhile sorry! :D Hiro and Taisuke have known each other for many years, they have been friends for as long as they can remember. However, Hiro is a demon who is fated to be locked up for all his life and Taisuke is an angel who's a bit of a play boy. What will happen when Hiro begins to long for freedom so much he would do anything to obtain it? When Taisuke realizes that his feelings for Hiro are a bit more than friendship will he run away or embrace those feelings? When heaven and hell clash how could such a love be accepted? Sounds cliche but I promise it will be a enjoyable read XD", False, True)
add('FarOutMantic', 'http://meteorflo.smackjeeves.com/comics/', u'a kinda large comic this time. about love, creativity, music and discos!! just a fun comic really, nothing too perpelxing. have fun!!~', False, True)
add('FarOutThere', 'http://faroutthere.smackjeeves.com/comics/', u'A manga-esque Sci-Fi Comedy. Far Out There is the webcomic where things happen... IN SPACE!!! (currently being transfered over from DrunkDuck, so pardon the mess)', False, True)
add('FatedFeather', 'http://fatedfeather.smackjeeves.com/comics/', u"Captain Tjakhlune Hawke, forced by circumstance to take up piracy, has only one goal in her life; she wants to catch a man with no name, and she'll go to any length or time to do it.", False, True)
add('FierceConflict', 'http://fierceconflict.smackjeeves.com/comics/', u"For years, a war devastated the planet called Sapton. The conflict began with a group of rebels who were dissatisfied with the laws of this world attempted a world wide coup d'etat. They slowly gained power and eventually overwhelmed the majority of the opposition and are slowly but surely taking control of the world. Out of this group of rebels 5 have taken full authority and are now attempting to lead the world down the path of darkness.We follow the story of a koopa named Zuke who lost his family and homeland in the war. He travels the world in hopes of finding a way to bring peace. All sprites belong to their respective owners.", False, True)
add('FinalArcanum', 'http://finalarcanum.smackjeeves.com/comics/', u"Anyone can be a hero, even the unsuspecting, unwieldy sky pirate Acacitli. When he gets separated from his ship and crew, he quickly learn there's a little more to life than rum, thievery, and failing a little at life more than he'd care to admit.", False, True)
add('FireEmblemEternalSouls', 'http://eternalsouls.smackjeeves.com/comics/', u'FIRE EMBLEM COLLABORATION! This is a Fire Emblem Collaboration by the people on FE-DA (http://www.fire-emblem-boys.com/forum/index.php) about an alternate world of Fire Emblem, which we create OCs to conquer the darkness and save their precious homeland of Thalassa. SPOTS ARE CURRENTLY OPEN FOR THESE CLASSES: Armored Knight (1) Pegasus Knight (2) Mage (1) Please message me or join our forum to participate! Thank you!! I hope you will enjoy our creation! <ZengQunAn>', False, True)
add('FireWire', 'http://firewire.smackjeeves.com/comics/', u"When Kennedy H'naka's cell phone becomes the new home of the dragon FireWire Balisk, she finds herself sucked into a world of battles, secrets, and shadowy organizations. What's a girl to do when she has to save the world and still pass the tenth grade? Updates: Thursdays Reads: left to right. Comments greatly appreciated ^^", False, True)
add('FireredLisasReise', 'http://lisasreise.smackjeeves.com/comics/', u'This comic is a Firered Nuzlocke run. Lisa, a young girl from kanto starts her journey to become the Pok\xe9mon master. Updates Sundays! Also visit my tumblr account and ask Leaf questions! http://lisa-leaf.tumblr.com/ Laufente has helped me with the coloring until page 63, but I figured I should learn how to do backgrounds and attacks myself so I will do it alone from now on. Laufente has her own Nuzlocke as well so please look at Road to Glory as well :D', False, True)
add('ForcedSeduction', 'http://forced-seduction.smackjeeves.com/comics/', u'"Can you make the next person walking through this door fall in love with you within a month?" "Sounds easy." BL!!! I apologize for the lack of creativity and the super sketchy outlines. I\'m totally being forced XD (Just kidding) Oh, and English is not my first language. It\'d be lovely if you could help me to improve ;) (meaning correct me please XD) Better read from right to left ;)', False, True)
add('ForestHill', 'http://www.foresthillcomic.org/comics/', u'Life happens.', False, False)
add('FramebyFrame', 'http://frame-by-frame.smackjeeves.com/comics/', u"Comic updates Tuesday unless otherwise stated. The hostility between our two lead comic artists is slowly dissipating but lots of things are changing for our little group in general. Many are moving, some are having revaluations about their life, but nothing is going to stop them from enjoying the Halloween Party at the DVDungeon. Volume 2 of Frame by Frame has it all; ghosts, romance, and angry ex girlfriends to boot. +Alex is at his wits end with Tai, his ex-girlfriend and live-in roommate. Has the time come to move on, both physically and emotionally? Maybe something new would do him wonders. +David continues to work hard in both his work and establishing his life there in Poulsbo. He's gaining courage to do something impossible with high hopes of it being possible. However, it's unknown if it'll be a good idea in the end... --WARNINGS-- +The typical warnings: adult language, adult situations, adult nonsense.", True, True)
add('FrenzyRedux', 'http://theadventuresoffrenzy.smackjeeves.com/comics/', u'Neo Arcadia discovers an ancient reploid of immense power. Could he be their ultimate defense against the inevitable arrival of Zero?', False, True)
add('FrobertTheDemon', 'http://frobby.smackjeeves.com/comics/', u"A gag-a-day comic about one little demon's journey to cause mass chaos and wreak havoc upon the poorly-drawn folk known as stix.", False, False)
add('FromnowonImagirl', 'http://fromnowonimagirl.smackjeeves.com/comics/', u"One day out of nowhere Hikaru's girlfriend broke up with him because she found out she is lesbian. He decides he will never fall in love with women again so... he has to love men. with his big sister's help he is no longer hikaru the boy but a girl!(cross-dresser) Hikaru meet Natsu who made his life hell and decides to get his revange and... The rest is still unclear read from right to left Contains BL maybe yaoi, romance,GenderBender and comedy Hope you enjoy *improving drawing style", False, True)
add('FruitMachine', 'http://fruitmachine.smackjeeves.com/comics/', u"Jason Fellows is in love. Now the game is on to see how far Jason can string along his beloved Sheridan before his pennies run out. Just how long will Jason keep playing Sheri like a Fruit Machine before he tells him how he feels? -x-x-x-x-x-x-x-x-x-x- Ladies and gents, it'll be my pleasure to comic for you!", False, True)
add('FruitloopAndMrDownbeat', 'http://fruitbeat.smackjeeves.com/comics/', u'After hitting a bump in the road of life, Danny Lawson ended up moving back to the city where he attended college. His next door neighbor, Alan Taylor, is a senior in high school who falls in love with Danny almost immediately. AND THUS THEY BECAME FRUITLOOP & MR. DOWNBEAT. (bad intro, yes.) (contains boy/boy, girl/girl, foul language, cartoon violence, some sexual themes) Tries to update weekly. (Tries)', False, True)
add('FuckMyLife', 'http://fuckmylife.smackjeeves.com/comics/', u"--HIATUS-- A journal comic of my gay and flamboyant life. Contains: -Me and my friends swearing like sailors -Family drama -Hopeless romance -Ridiculous things you wouldn't expect most people to do Moosefroos@Deviantart", False, True)
add('FuneralOfHearts', 'http://funeralofhearts.smackjeeves.com/comics/', u'STATUS: ongoing A Pokemon (gijinka) doujinshi. READ RIGHT TO LEFT (Pokemon (c) Nintendo)', False, True)
add('FurtherDowntheRabbitHole', 'http://fdtrh.smackjeeves.com/comics/', u"Wonderland has a dark edge to it. After so many years of being told that Wonderland was all made up in his twisted mind, Alex had about enoungh. He returned the very rabbit hole he first fell down in only to find it wasn't there. Was it true then? Was all his adventures and friends he made in Wonderland all made up? Was he really crazy like his family said? This is a Boy love collab. Don't like? Don't care, you don't have to read or join. Also this comic is gonna be a bit insanity/horror. Rules will be posted on first page. Any questions, pm me. Characters needed: Alice:(taken) Hatter:(taken) Tweedle twins:(taken) March Hare: (taken) White Rabbit:.( taken) Red Queen:(taken) White Queen:(taken) Chesire Cat:(taken) Knave:(taken) Catipiller:(taken) Dormouse:(taken) White Knight: (taken)", True, True)
add('FurusatoHouse', 'http://furusatohouse.smackjeeves.com/comics/', u'"Destiny, and coincidence. Everybody believes in either of them. However because of which one I got to the Furusato House, I don\'t know. But that day changed my life." Mayu travels to her never seen aunt, but accidentally gets into an other House, where she meets the old fashioned, and strange boy \u2013 Hiroki, who seems very surprised that she could get in the territory of the House. Moreover, the House doesn\'t let Mayu leave! She has to start a new life full with enemies, friends, love, and with disturbing secrets about the House.', False, True)
add('GRASSNEST', 'http://grassnest.smackjeeves.com/comics/', u"a comic by Snakey Ho Ho Tomoki makes the biggest decision of his life when he decides to study abroad in Canada. Struggling to keep up with his courses, Tomoki finds help from the most unexpected place... the campus gardens. Yes, it's BL.", True, True)
add('GamesPeoplePlayUpdatedWeekly', 'http://gamespeopleplay.smackjeeves.com/comics/', u'A webcomic about the little nuances of table-top roleplaying games, and the people who play them. Updated weekly. Feedback and comments at azalin1@lycos.com', False, True)
add('GardenofHearts', 'http://gardenofhearts.smackjeeves.com/comics/', u"Alyn, royal guardsman to the elven Queen of the North leaves for a quest to the far south with his wise-cracking necromancer friend Skylar. They are seeking a long-lost magical talisman that could dispel the eternal winter of the northern lands--and just perhaps elevate Alyn to Queen's Consort after he returns a hero. To journey into the south Alyn will need the help of his childhood friend, Nirin. Only, Nirin is a lot more enchanting than he remembered and every step closer to the mythical Garden of Hearts is a step further from his goals. story specs: light-hearted fantasy romance BOY X GIRL. tech: hand-drawn, b & w, toned.", False, True)
add('GayBacon', 'http://gaybacon.smackjeeves.com/comics/', u'Here you can read strips about random things in my life or thoughts that may occur in this messed-up head. This is what the quiet, weird kid draws whenever he gets a chance. Updates at random times. [Contains a lot of cursing]', False, True)
add('GetUpandGo', 'http://getupandgo.smackjeeves.com/comics/', u'', True, True)
add('GhostsTaleACrossover', 'http://ghoststory.smackjeeves.com/comics/', u'Willow is taken away from her home and made to look for a special medallion. Supposedly, this amulet has the power to stop a war occurring in a very distant, possibly even other-wordly, land. It sounds simple at first, but it is soon realized that the problem may not lie solely in finding, but retrieving... *This is a story set in a pokemon region, but it does not completely focus on pokemon itself. *Some canons will be included, though they will be much older/more mature than in the anime. *I do not own Pokemon or Pokemon characters. Pokemon is (c) GAME FREAK & co.', False, False)
add('Glasshearts', 'http://glasshearts.smackjeeves.com/comics/', u"After two years, a 16-year-old Charlie McDermott returns to his hometown and to his previous friends. Many things have changed, some things haven't. Old wounds will resurface, and new wounds will possibly appear as well. This isn't just a love story. This is a struggle to survive. A struggle to find an identity. Are you in the status quo of society or are you the embodiment of what the status quo isn't? Are you willing to show the world your true identity? (( romance (hetero + BL/shounen-ai) // drama/angst \\\\ comedy/humor ))", False, False)
add('Gloomverse', 'http://gloomverse.smackjeeves.com/comics/', u'She was just a regular, unwanted kid, until she was lucky enough to get a job under the best magician in the world! Unfortunately for her, her new boss is a self absorbed sociopath. Updates are currently Monday, with some sporadic mid-week updates if I have time! Dark/Twisted Comedy!', False, True)
add('Gnoph', 'http://gnoph.smackjeeves.com/comics/', u'Life, love, and internal parasites.', False, True)
add('GoldenSunGenerationsAftermathVolume1', 'http://gsgbtsyearone.smackjeeves.com/comics/', u"- BEFORE THE STORM SERIES EPISODE I: VOLUME ONE - A fantasy RPG story based from the underrated RPG game series Golden Sun. Three time traveled Adepts granted a second chance at life after living seventeen years in an alternate destroyed reality, must quickly get used to their new surroundings as they are thrown into the fray dealing with new friends, family, emerging enemies and a big sailing adventure they'll never forget. Part 1 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun doushinji. - Rated +13 for slapstick humor, mild language, and fantasy violence VOLUME ONE COMPLETED; VOLUME TWO AVAILABLE HERE: http://gsgaftermathv2.smackjeeves.com/", False, False)
add('GoldenSunGenerationsColossoVolume6', 'http://gsgbtsyearthree.smackjeeves.com/comics/', u'- BEFORE THE STORM: EPISODE III - A fantasy RPG story based from the underrated RPG game series Golden Sun. The main focus is on the character Ethan who has grown up the last two years in terms of height and skill, seeks to win the heart of the werewolf girl Tasha by competing in a tough fighting Tournament. The first round is over and now the festivities truly begin! Part 3 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun Fancomic. - Rated Web +14 for gutter humor, mild language, romantic situations (BxG love) and fantasy violence COMPLETE - SECOND HALF OF COLOSSO BEGINS FEBRUARY 2011: http://gsgcolossov7.smackjeeves.com/', False, False)
add('GoodGame', 'http://goodgame.smackjeeves.com/comics/', u'Three friends want to get some fun and play a computer game in their hi-tech fantasy world. But they got something wrong...', False, True)
add('GoodnightMrsGoose', 'http://goose.smackjeeves.com/comics/', u'Hard working lawyer mom Valerie Clark is letting her work life overcome her family life. However after a magical encounter, she gets the chance to rediscover her childhood and also help cleanse her world of odd creatures.', False, True)
add('GreenKirbyandabunchofotherpeopledoinstuff', 'http://gkandabunchofotherppl.smackjeeves.com/comics/', u"One day a young kirby named GK made a comic world. There, he found friends, and enemies. Let's hope that the good guys prevail. Also, this comic is accepting co-authors! If you like this comic, feel free to apply! No random hating please, because we are fairly new compared to some other comics. Rules:Swearing in comics and comments is 100% unacceptable. NO mature content. No flaming or trolling in comments. Also, post your sprites for each fc you will be using in this comic. Chat rules:No swearing, trolling, or spamming. Not only members can come to the chat, so you can vist if you want. Please remember to come to the chat often, because it's lonely there. :'( Also, this comic isn't just for Kirbys. If you have fcs who are not Kirbys, they can be used.", False, True)
add('GuardianGhost', 'http://guardianghost.smackjeeves.com/comics/', u"After being hit by a car a few months ago, things have been very strange for Max. Not only can he see ghosts, but one in particular claims to have saved him from death! But there are reasons why ghosts are not allowed to save humans. Updates Tuesdays and Thursdays (and Saturdays if there's time)with a massive quality shift from chapter to chapter (and pages before CH5 are slowly getting text fixups)", False, True)
add('GuardiansoftheGalaxialSpaceways', 'http://ggs.smackjeeves.com/comics/', u'Join Captain Taxxi Serbus and the crew of the Artful Dodger as they battle space pirates, giant comic book geeks, and intergalactic viruses in a star-spanning adventure!', False, False)
add('HDMTHCOMICS', 'http://hdmthcomics.smackjeeves.com/comics/', u'My sprite comic shows how me and my friends live in the world of Sonic the hedgehog!', False, False)
add('HIPS', 'http://hips.smackjeeves.com/comics/', u'An admittedly done before bl romance. Here is my attempt at a gripping back cover summary: In an effort to get away from his criminal family, Julius Green has turned witness for the city. He is secreted away and hidden in a posh private academy as...a girl?! Suffocated by the charade, will Julius be able to pull off school life as Penny Adams? And will he be able to save himself when the two rulers of the school, Max Lawson and Alex Watch, take particular interest in him?', True, True)
add('HappinessStartswithYou', 'http://happinessstartswithyou.smackjeeves.com/comics/', u"Looseing a best friend when you're young can hurt more than you think. Sasumi grows up with one memory of his friend, and day by day it fades. Will he ever find out who is friend was or will the memory be just disappear, just like his friend? This is YAOI so prepare yourselves peeps! :3 I hope you enjoy it! :3", False, True)
add('Harfang', 'http://harfang.smackjeeves.com/comics/', u"Here my first time on SmackJeeves ! Harfang is my new comic. It's a fantasy story, based on the Jorinde & Joringel Grimm tale. Designs are inspired from asia (Korea/Mongolia/China). I wish to update it one page every monday ! I hope you'll like it. ^____^ ***************************************** Harfang is now a featured comic on MangaMagazine. Thank you so much for your support ! ^____^ You can now read the pages on www.mangamagazine.net or tapastic.com ~ ***************************************** ENGLISH TRANSLATION ***************************************** My english is bad, don't hesitate to correct my grammar. Thank you ! ^__^ *****************************************", False, True)
add('HarvestMoonParadiseFound', 'http://paradisefound.smackjeeves.com/comics/', u'When a single phone call changes your destiny...do you find the strength to embrace it? A Harvest Moon Doujinshi (fan comic) Read RIGHT to LEFT. Updates Thursdays. (Harvest Moon title and concept are copyright of Marveslous Interactive)', False, True)
add('HatShop', 'http://hatshop.smackjeeves.com/comics/', u'You may be thinking this is a comic about hats. It\'s not. A strange comedy about a boy who is fired in the first panel and accidentally sells his soul to an eccentric hat maker. Shenanigans ensue. Note to new readers: The art gets better. Note on the format: I originally drew it vertically because I did it by hand and that\'s how it would fit on the page (It just seemed like a good idea at the time). Three years later, it\'s stuck. It sometimes changes to full pages if the story needs it, but the vertical format is the default and I\'m not planning on changing it. Updates every three days unless otherwise specified. Note: This is a "whatever the author feels like" comic. You have been warned.', False, False)
add('HatethePlayer', 'http://hatetheplayer.thewebcomic.com/comics/', u"Hate the Player is a comic based on a number of concepts Tron, and Quantum Leap. The overall idea is the character M.C. (A play on words for Main Character). A horrible game magazine reviewer who gets transfer'd into the game world by Beans, who use to be a developer until M.C. ruined him, now an editor who came to get revenge on M.C., He forces M.C. to re-enact the various game worlds as the Hero of the world, until a freak glitch causes issues.", False, True)
add('HauntedHouseSurvivors', 'http://hauntedhouse.smackjeeves.com/comics/', u'Join Ultimate the Hedgehog and his friends as they battle to survive in the haunted mansion of Nightmare, along with other surprising villains. Alright lets do this: Spots: Main (17/20) -Ultimate -Solar -Snaps -Jay-2 -greenblur -jamesthewolf -Leo -Diox -john -Drown -Terra -GMC -Chaos -Kai -Signour -Omega -Helix Villains (6/15) -copafire -metaboo -Starfire -ForteTH -Jake -Kinny Neutral (10/10): -SP3 -mix -abdie -greyouTT -Ms. Kitsune -sonicballzx -Mist The Moonhunter -Felix -Clare -Heli WARNING: spots may vary during the comic Total authors= 37/45 (not counting spear) ONLY 8 SPOTS REMAINING! So... i did some booting so spots are re-opened. You all who want to join better update fast. otherwise wait for the next chapter to introduce yourself. For all those who are leaving, if you were already in the comic make a comic about you either dying or going missing (incase you ever want to join again). ~UTH Co-author applications under new management, sorry ulty had to ~Abdie/Silent dusk', False, True)
add('HavingDifficulty', 'http://having-difficulty.smackjeeves.com/comics/', u"Robby is starting high school. In his mind, he's having difficulty fitting in. He barely knows anyone. Will the next four years change his attitude? Updates twice a week, Mondays and Fridays.", False, True)
add('HedgehogPieceANewEra', 'http://hedgehogpiece.smackjeeves.com/comics/', u'~This is a revival of the original Hedgehog Piece~ Take an adventure throughout a new world of One Piece, in a new Era of Pirates, following 5 major pirate crews of different species and personalities. We also accept cameos in the same format below (also include brief personality and background). PM to ReiKainaric. For ANY problems, PM to sonicmaster05.', False, True)
add('Helix', 'http://helix.smackjeeves.com/comics/', u"A street rat is given a second chance when he is dragged from the gutter and into a new life. Will he accept his position at the side of royalty, or fight every step of the way? *Rated M for sex (both hetero and homo), violence, nudity, language and dark themes.* If you can handle these subjects, I hope you'll enjoy the comic. :) Thanks for reading! ~Join Helix on tumblr at http://helix-comic.tumblr.com ! ~", True, False)
add('HeltonShelton', 'http://heltonshelton.smackjeeves.com/comics/', u'This is a goofy sketch at a party that grew into a two-book saga about a multi-generational battle against the darkness inside us. Shelton1 and Shelton2 set out to fight the Final Boss, but victory carries a cost for Shelton1. A party of heroes begin a quest of vengeance, but can they overcome their rivalries before facing their ultimate foe? A spellcasting musician learns to deal with death, but can she deal with life?', False, True)
add('Hemlock', 'http://hemlock.smackjeeves.com/comics/', u"Hemlock #1 and #2 are now available to buy online! each issue is priced at \xa36 plus postage and packing. they can be bought through lulu.com at my storefront here: http://stores.lulu.com/mildtarantula lulu accepts both card and paypal. since they go straight from lulu to you, they will not be signed or anything like that. if you happen to see me at one of the conventions i will be attending, i will be selling them for \xa35 each and i'll be happy to sign them and do a little sketch for you if you like.", False, True)
add('HiddenStrengthAWhiteNuzlocke', 'http://hsnuzlocke.smackjeeves.com/comics/', u'Clover, Cheren, and Belle graduate from trainer school, looking forward to finally being able to go on a pokemon journey of their own. Things start out like any other adventure, however soon the trio becomes entangled in the mess that is Team Plasma, finding out secrets that have been hiding in plain sight all their lives. How will their adventure unfold? This is a Nuzlocke story comic. [THIS COMIC IS FINISHED]', False, True)
add('Hinata', 'http://hinata.smackjeeves.com/comics/', u'Fifteen years ago, mankind faced a terrible disaster. In order to protect his daughter, Hinata, from danger, Shinsuke Akao retreated deep into the forest. He secluded himself, never leaving the forest while he reared and educated Hinata, never allowing her to leave either. On the morning after her sixteenth birthday, Hinata wakes up to find her father missing. With no clues as to where he went, Hinata casts aside the safety of the forest and forges out for the first time into the post-apocalyptic cityscape on a quest to find her father and discover what exactly happened to the world fifteen years ago.', False, True)
add('HitandMiss', 'http://hitandmiss.smackjeeves.com/comics/', u"It's a autobiographic comic about, well, me and my daily life! Doesn't that sound interesting? WARNING: This comic may contain the following; misspelling, weird situations, gaming, horrible puns, cats, depression, and the occasionally lovey dovey stuff. http://www.theduckwebcomics.com/Hit_and_Miss/ ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ The link to DrunkDuck Hit and Miss!", False, True)
add('Holocrash', 'http://holocrash.smackjeeves.com/comics/', u'Welcome to HoloCrash, the adventures of Commander Teelianna Santo ("Teela") and her Genetically Enhanced Nanotech Android trainer ("G.E.N.A"). Teela, a brilliant science officer and an exceptional athlete, volunteers for a year round trip aboard the cargo freighter Argenta-619 so that she, along with her trainer G.E.N.A, can train for the upcoming Pan System games in heavy gravity conditions. Soon, what seems like a normal freight run to the Cordas System, turns into an adventure like no other!', True, True)
add('HolyBlasphemy', 'http://holyblasphemy.smackjeeves.com/comics/', u'Making fun of religions since 2010. Better stay clear of this comic if you really cannot stand people making fun of Atheism, Buddhism, Christianity, Creationism, Germanic and Greek Polytheism, Hinduism, Islam or Judaism as well as of Abraham, Agni, Aliens, Angels, the Easter Bunny, Great Ctuluh, Isaac, Jahweh, Jesus, John the Baptist, Joseph, Mary, Mohammed, normal humans, Pascal, robots, Santa Claus, Satan, Tantalus, Thor, Vishnu, well-built catholic girls, Zao Jun or Zeus (more religious belief systems and persons may follow). Updates whenever I find the time (on average every 2.4 days or almost three times a week). Comments and voting highly welcome!', False, False)
add('HolyCrap', 'http://holycrap.smackjeeves.com/comics/', u"Hi there! Welcome to what-ma cha' call it? ... Oh that's right Crap Holy. No no... AH! WELCOME TO ME! I AM HOLY CRAP!", False, True)
add('HopeForABreeze', 'http://h4ab.smackjeeves.com/comics/', u'This is a story of a girl named Sophia and her journeys through life. webcomic, web comic, school life, slice of life, school, drama, anime, autobiography, memoirs, manga, cartoon, comic', False, False)
add('HotChocolate', 'http://hot-chocolate.smackjeeves.com/comics/', u"COMPLETE! Other art and doodads will be added, but as for the story, it's finished! Thanks to all the readers!", False, True)
add('Houseofsprite', 'http://sac22.smackjeeves.com/comics/', u'A hotel comic where anything can happen! Rules: no inappropriate updates keep it PG-10ish', False, True)
add('HurrocksFardel', 'http://hurrocksfardel.smackjeeves.com/comics/', u'', False, True)
add('INUSITADOONLINE', 'http://inusitado.smackjeeves.com/comics/', u'Uma simples comedia romantica ;D', False, False)
add('InDebt', 'http://indebt.smackjeeves.com/comics/', u"Meet Kid. A teen straight out of high school with his whole life a head of him. Until it ends in a tragic traffic accident. Meet Grimm Death. A Reaper with the power of life and all other sorts of power at his disposal. He's highly respected in the Reaper realm and is seen as a Godly figure. In truth he is an arrogant, narcissistic, selfish, annoying, loud ego filled man that asks for no permission before doing what he wills. He owns the Deadwood Hotel and his goal is to make the hotel grow to multimillion dollar company. Grimm Death brought Kid back to life and informs the boy that he will now be working as a maid in order to pay off the debt of gaining a new life from Death. There will be boylove, girllove and just love in general. But mostly boys crushing on other boys. I'm currently going back and redoing the first chapter. Please bear with me as I replace the older pages with shiny new ones.", False, True)
add('Ingloriousbasterds', 'http://ingloriousbasterds.smackjeeves.com/comics/', u'Tired of sad stories with a grey and gloomy graphics? Then watch this bright arcade. The comic is not translated into English.', False, True)
add('Inhuman', 'http://inhumancomic.smackjeeves.com/comics/', u"1000 years in the future, a schizophrenic has been kidnapped by a group of rebel soldiers. And it seems they've bitten off more than they can chew...", False, True)
add('InsideOuTAYuriTale', 'http://insideout-a-yuri-tale.smackjeeves.com/comics/', u'A new Yuri series dealing with love, life and true friendship. The story follows new high school student Hitomi who decided to stop pretending to be someone else and start being herself. This decision leads to many odd encounters as she enters high school life and find her life is turned Inside OuT. Warning this manga is read Right to left. <<This way<<', False, False)
add('InspiredByADream', 'http://inspiredbyadream.smackjeeves.com/comics/', u'in\xb7spire |in-spahyuhr| ~to fill or affect with a specified feeling, thought, etc ~to prompt or instigate (utterances, acts, etc.) by influence, without avowal of responsibility dream |dreem| ~a succession of images, thoughts, or emotions passing through the mind during sleep ~a vision voluntarily indulged in while awake; daydream; reverie ~a wild or vain fancy Updates: Saturdays 1-2 pages a week.', False, True)
add('Intoxicated', 'http://intoxicated.smackjeeves.com/comics/', u"This is the story of Robert, who tries to manage his relationships in his life of drug abuse, break up's and strong emotions. The comic is finished, but being redrawn, so quality might change between newer and older chapters. Contains drugs, sex and profanity. Approximately rated: 15", True, True)
add('IslandsofEzdora', 'http://ezdora.smackjeeves.com/comics/', u"Help Tara and friends adventure through the mystical Islands of Ezdora! Feel free to suggest!(Don't be scared of the page count, it reads fast!) Updates daily.", False, True)
add('ItachiArtsandDrawings', 'http://itachiarstanddrawings.smackjeeves.com/comics/', u"I..basically put anything sprite or art related here. And..Imma try my best to bring this dead piece of crap comic back!I will continue to bring this thing to life, or die of boredum trying! >:I Oh..I'm also accepting anyone who wants to be part of this comic thingy. D; I also do requests of art and junk. ; u ; I will update more often now.", False, True)
add('ItsCharacterDevelopment', 'http://characterdevelopment.smackjeeves.com/comics/', u"And now the tale of a party of adventurers who got lost in a dungeon ... and the one Paladin who had no choice but to try and save them. It's Character Development. Daily updated Playmobil toy photo-comic.", False, False)
add('Itsahardlife', 'http://itsahardlife.smackjeeves.com/comics/', u'Robin is ten years old and travels through Kanto with her pok\xe9mon to find a place to call home. This is a story about struggle, survival and friendship in a cruel world. -------------------------- This is a Nuzlocke comic. Contains swearing and occasionally some gore. -------------------------- Updates are sadly quite irregular but I have no plans on giving up on it anytime soon! -------------------------- Extra art and fan art at hardlifeat.tumblr.com/', False, True)
add('Itsan8BitWorldBlankWorld', 'http://8bitblankworld.smackjeeves.com/comics/', u'This comic\'s premise is simple. This is the White Space, or "Blank World" of my It\'s an 8-bit World Comicverse. Here all the characters, past, present, and future can interact and do crazy, random, and all-together odd things for your own entertainment. Of course, they have to be careful so as not to piss off the local Rulers of the Universe...', False, True)
add('JackiesStory', 'http://jackiestory.smackjeeves.com/comics/', u"Jackie's Story is an online flash webcomic adventure story about an alien named Jack (Better known as Jackie) who gets talked into participating in something that she hopes will bring back her dead brother. For the animated version: http://jackiestory.weebly.com/index.html", False, True)
add('JewelCrisis', 'http://jewelcrisis.smackjeeves.com/comics/', u"Imagine 2 strong, determined, awesome superheroes who are surely going to save the World from every danger. Our heroes are not like this at all. And what's more, they need to save more than 1 Worlds. Follow Vanda, Dan, the Chicken, and their other weird friends travelling through places even weirder than themselves. _____________________________________________ UPDATES ON SUNDAYS. _____________________________________________ Don't be afraid to: \u25cf comment \u25cf rate \u25cf +fav if you'd like to ^^ Everything helps to improve this comic (.\u203f.) ______________________________________________ + Follow on jewelcrisis.tumblr for extra infos \u261e Like on facebook for more updates", False, True)
add('JosPokemonJourney', 'http://jpj.smackjeeves.com/comics/', u"Just about a 18 year old twin with an afro who's going on a journey with a few surprises, friends, and foes. :D Updates when it can. :3", False, True)
add('JosephAndYusra', 'http://josephxyusra.smackjeeves.com/comics/', u'Love, Friendship, Religion and supernatural powers? After Yusra lost her parents in a military conflict in the Middle East, she was sent to America to live with her aunt. It was there that she found Joseph, a Jewish boy. They discovered that they were able to talk through telepathy and through that they were able to stay close friends.. However, there is something more to them than just telepathy..or their friendship. UPDATED AT THE END OF EVERY MONTH', False, False)
add('JourneyMan', 'http://journeyman.smackjeeves.com/comics/', u'Life is a journey. Will finally seemed to be going places. But his plans take unexpected turns when cosmic forces intrude with occult plots and alien invasions. Can Will get a life as the galaxy burns? The first chapter includes old art from 2005 that will be fixed, later chapters have much better art.', False, True)
add('JustAnotherDay', 'http://ravenwing.smackjeeves.com/comics/', u'Shanku has left her home behind to explore the wide world around her. Out of her small forest home she finds more of her own kind and new friends. Love, loss, and adventure await her as she discovers the secrets her clan struggled to hide. But at what cost?', False, False)
add('JustAnotherLife', 'http://justanotherlife.smackjeeves.com/comics/', u"This is a comic on my daily life in highschool, and other stuff as well. WARNING: May be uploaded slowly because I am extremely lazy. (Or I don't have anything interesting to draw.) There is also some minor cursing, just saying.", False, True)
add('JustGotta', 'http://justgotta.smackjeeves.com/comics/', u'Your typical story about a girl from our world pulled into the Pok\xe9mon world . . . or is it? Hillaree, known by her friends as the "Mewtwo Queen," is suddenly taken to a world where Pok\xe9mon are real. She is told she will be returned home when she is ready. What could that mean? Well, since she\'s going to be there a while, she might as well catch some Pok\xe9mon! A Pok\xe9mon Fan Comic written and drawn by Vye Brante. Rated Teen for some violence/fighting, blood, and death. Currently updates on Wednesday and Saturday. Please note: This comic does not follow any established canon, but does use characters from the games, anime, and mangas. Histories and personalities may be changed.', False, True)
add('Justmyluck', 'http://justmyluck.smackjeeves.com/comics/', u'Andreia is a normal girl, if you forget the fact that she\x92s the unluckiest girl in the world. Tired of her life, she leaves her home and goes to another town. But of course things don\x92t go as planned. Andreia meets Jason, who is a pain in the ass and very cold to her. She finds herself stuck in the biggest problem of her life, with nowhere to turn.', False, True)
add('KCNO', 'http://kcno.smackjeeves.com/comics/', u"A simple town in love with a simple radio station show. KCNO's Love Me Do, is the most popular show on the airwaves. Its success is owed to the host, Jason who has impeccable advice to give people struggling through love. But when a simple question moves the town to seek out Jason, his attempts at secrecy become the newest talk of the town.", False, True)
add('KaitoShuno', 'http://kaitoshuno.smackjeeves.com/comics/', u"a man named Kaito goes to commit suicide after living a boring, loveless, cubicle job. He meets a strange guy named Shuno...and Shuno immediatly takes a liking to him...almost too fast to be real XD Kaito quickly makes it clear that he isnt gay...but will Shuno's actions toward him make him alittle...'confused'? lol Kaito's been in such a need for love that maybe Shuno's affection doesnt look THAT bad...or does it?:P YAOI!! RSS FEED: http://kaitoshuno.smackjeeves.com/rss/", False, True)
add('KasaKeira', 'http://kasakeira.smackjeeves.com/comics/', u'<b>The story of a girl, her magic umbrella and the hundreds of demons trying to kill her</b>', False, False)
add('Katran', 'http://katran.smackjeeves.com/comics/', u'This is the Story of Nirrod, an almost normal 14 year old boy. He is living with his Family and his clan in a big village in the north of Katran. Build on a giant cliff, it became one of the safest places in the land, and soon a very precious trading point. Nirrod is living his life well protected and without sorrows in the lap of his clan. he is playing with other kids, playing pranks....a normal life. but all of this is going to change....', False, True)
add('KazanatoFuneralPlanningService', 'http://kazanato.smackjeeves.com/comics/', u'Chou and Fuyuka are partners who work for Kazanato Funeral Planning Service. They guarantee that their clients are fully satisfied, especially the deceased.', False, True)
add('KillMeOrDie', 'http://killmeordie.smackjeeves.com/comics/', u"Stephen Sharp is the Raging Corpse. He has been brought back from the dead with the radiation that killed him. Hating the creature that he has become, the Corpse taunts Metro City's heroes to kill him or die!", False, True)
add('Kirbandfriendsshowcase', 'http://kas.smackjeeves.com/comics/', u'a new kirb and friends!^^', False, True)
add('KirbiesoftheAlternateDimension', 'http://kirbyaltdimension.smackjeeves.com/comics/', u"A delightful comic that may contain mild language about the life of the kirbys that live in the other dimension. It is a story about adventure, suspense, and drama, and of course, comedy. (A comic isn't a comic without comedy.) Current Chapter: Kuzer's Arrival, Defeat Daroach! Kuzer has showed up on the Halberd with a special trick up his sleeve. Daroach and his minions battle to the death with Daroach, and Kuzer and his friends fight back!", False, True)
add('KirbyAdventure', 'http://kirbysadventure.smackjeeves.com/comics/', u'Meet the Kirby Adventure Squad: a group of Kirbies who take requests from random clients and attempt to complete them! And mostly fail miserably! Huzzah!', False, False)
add('KirbyFunfestTheOriginals', 'http://kirbyfunfestold.smackjeeves.com/comics/', u'Kirby and his best friend Dee are minding their own business, when Dedede challenges Kirby to a duel! Since then, Kirby and Dee have to save the world from seemingly unstoppable forces of nature, and all the while they still have time to be funny... NOTE: I am restarting this comic, see it at http://kirbyfunfest.smackjeeves.com/', False, False)
add('KirbysDreamAdventure', 'http://kirbyda.smackjeeves.com/comics/', u"What's better than one Kirby? A whole mess of them, that's what! Follow them around their little adventures and daily lives, from the early randomness to the more story-built latter parts. It's a Kirby adventure worth watching, even if the main pink puffball doesn't get as much direct screen time as he should!", False, True)
add('KirbysDreamlandAdventures', 'http://kirbysdreamlandadventures.smackjeeves.com/comics/', u'A retelling of the many adventures Kirby has had over the years since 1992.', False, True)
add('KissParade', 'http://kissparade.smackjeeves.com/comics/', u'shitineedtostopmakingnewcomics A delinquent. 17 year old Isamu. A Playboy. 17 year old Taiki. They both hate eachother, so, so much. One day after winning a fight, Isamu is dragged away by Taiki and is asked a strange question: "Can I kiss you?" BL/Yaoi. I know right. AHA AHAHA. OTL', False, True)
add('KissmeSnow', 'http://kissmesnow.smackjeeves.com/comics/', u'\u201cThe Snow just keeps falling, never melting away, never allowing spring to arrive.\u201d Shirayama, a small mountain town, hasn\u2019t seen spring in decades. Young man named Keiji suffers from fear of cold, and wants nothing more than get away from the town and its prevailing eternal winter. However, when he encounters a mysterious girl called Lumi and finds out the secret behind the mysterious hypothermia deaths, he has to confront his own fears, not only for his own, but also for the entire town\u2019s future. ---------------------- Updates on Mondays', False, True)
add('KissoftheDevil', 'http://kissofthedevil.smackjeeves.com/comics/', u'Vist us at http://www.smackjeeves.com/comicprofile.php?id=110041 Thanks! Shadow Leafeon', False, True)
add('KissoftheDevil20', 'http://kissofthedevil2.smackjeeves.com/comics/', u'This is a remake of the collaboration, "Kiss of the Devil" _____________________ This is a collab for Vampires, Humans,and Werewolves. This has no plot whatsoever so, we are always open to suggestions! This collab is just for fun so do what you want. -------------------------------------------- You may have up to 4 characters!ONLY TWO humans ONE werewolf and ONE Vampire! Extra!The human HAS be a drudge(slave)to a certain vampire or werewolf.Even if you or they dont like it. ----------------------------------------------------- This is NOT a Twlight collab. This has nothing to do with it! -------------------------------------------- Will contain:Blood B/L G/L ------------------------------------------------- Spots open: 0 Sorry guys. I don\'t think we can have anymore characters. We have too many. :( Spots taken: 6 i think.. XD ----------------------------------------- Kissofthedevil(c)Shadow Leafeon', False, True)
add('Knife', 'http://knife.smackjeeves.com/comics/', u'READ LEFT TO RIGHT -------------> It\'s not about bloody stuff and it\'s not about emos. I gave the guy with the black hair long hair because before, I had trouble drawing 2 eyes and making them even =_= so I covered one of them lol. Well he looks kinda cool like that, so all\'s good. Hale is a random dude in school, who sucks terribly at school subjects, but works hard enough to pass his classes with decent grades. Having -red- hair, bullies tease him, but Hale\'s bluntness strikes back at them. Milo is another random dude in school, who does well in school, (not effortlessly, though) He\'s an optimistic fool who has had a "hobby" since an incident that happened 2 years ago, and the "hobby" reawakens. No smut/No p0rn Just shounen ai Art gradually gets better lol.', False, True)
add('KnightsRequiem', 'http://knightsrequiem.smackjeeves.com/comics/', u'With weaponry called Emblems, the knights of NYX had always protected humanity from monsters of the night, the vampires. This is a story of a few new knights discovering just what it is like to become slayers', False, True)
add('Kranburn', 'http://kranburn.thewebcomic.com/comics/', u'An Australian Post Apocalypse Comic', False, True)
add('Kreetor', 'http://kreetor.smackjeeves.com/comics/', u'', False, True)
add('Kurokenshin', 'http://kurokenshin.smackjeeves.com/comics/', u"Started in December 2005, so the first Volume's art is a bit rough. Volume 5 was finished in Spring 2011. The remaining two volumes will be available on my website: http://ko-mangaseries.com/kurokenshin.html After finding a book on the legendary ronin Kokushiryu, Kentaro finds himself on the adventure he's always dreamed of. He joins Rika, a mysterious red-haired demon, who is searching for Kokushiryu's sword - Kurokenshin. However, she isn't the only one pursuing Kokushiryu's legend for the book; a cruel demon from the past is desperate to attain the sword, and he will go through any means to do so. ~READS FROM RIGHT TO LEFT~", False, True)
add('LITTLEREDROBO', 'http://littleredrobo.smackjeeves.com/comics/', u'A little robot tries to make her way in the future.', False, True)
add('LOGOS', 'http://logoscomic.smackjeeves.com/comics/', u'In the far future, on a distant planet, a man made of plastics discovers what it truly means to be human.', True, False)
add('LOKI', 'http://loki.smackjeeves.com/comics/', u'LOKI is the story of Lochlan and Kian, two down on their luck and only vaguely competent guns for hire, and their adventures. Updates on Tuesdays and Fridays!', False, True)
add('LandoftheSky', 'http://landofthesky.smackjeeves.com/comics/', u'While vacationing at the former port town Sin City, the young Fae princess Souri Ada Lodette discovers a mysterious heirloom in her possession. As she tries to understand what it is and where she has seen it before, she comes face to face with the notorious murderer known as Roo the Ripper, who just happens to be in search of the same object! Who exactly is this man... And why does he call her Solas?', False, False)
add('LastLivingSouls', 'http://lastlivingsouls.smackjeeves.com/comics/', u"It's probably safe to assume you know what a zombie is; A living corpse with an insatiable craving for human flesh that mindlessly acts on primal instincts. But, what would happen...if a zombie became able to think? Along side an empty road, a teenager named Eddie awakens, confused and fearful due to his inability to remember anything. He heads towards the nearest city in hopes of getting some help, but realizes it is nearly empty of residents and is instead being slowly consumed by a group of undead. It quickly becomes his purpose to survive and also to understand why these creatures are plaguing the city...and why he is one of them.", False, True)
add('LedbyaMadMan', 'http://ledbyamadman.smackjeeves.com/comics/', u'The country is devoid of life save for five people who try to stay alive the best that they can.', False, True)
add('LegendOfZeldaSwordOfWinds', 'http://swordofwinds.smackjeeves.com/comics/', u'A somewhat loose interpretation of Wind Waker, containing some of the scenes from the game. A pure adventure comic about Ganondorf threatening the World with a sword that can command the Winds. Link must use both the Wind Waker and the Master Sword to counter this Evil! Updates often', False, True)
add('LegendofZeldaAHerosStory', 'http://aherosstory.smackjeeves.com/comics/', u"The story of Ocarina of Time retold, will Link summon the courage to save his friends and the ones he cares about before it's too late? Find out and see!!", False, True)
add('LegendofZeldaStaffofPower', 'http://loz-sop.smackjeeves.com/comics/', u'An ancient weapon created for harmony brought civil war. Shattering it brought tentative peace, until the leader of the Gerudo attempts to slaughter an entire race of people, then turning his hatred upon the monarchy of Hyrule. Defeated by the Hero of Time and the Princess of Destiny, he was sealed away in the Sacred Realm. Years later, he has gained more power, and has broken free. Now it will take the very weapon he seeks to destroy him, and an unlikely wielder to complete the task. Who will win? ~Like the comic? Want to support the author? Click the image at the bottom of the page to do so!~', False, True)
add('LegendofZeldaTheEdgeandTheLight', 'http://legendofzelda.smackjeeves.com/comics/', u'After years of absence, Link finally returns to Hyrule from his travels abroard. Initially expecting to greet Princess Zelda, he instead finds the kingdom in decline, plagued by all kinds of trouble. Just what is causing these problems, and does it have anything to do with why Link left in the first place? NB: Thanks to its unusual format, this updates every FRIDAY.', False, True)
add('LegendsofLyndal', 'http://lyndalcomic.smackjeeves.com/comics/', u'The Knights of the Order of Zerron have protected the world from the forces of destruction for thousands of years. When one of the most renowned Knights uncovers a terrible plot by an ancient enemy, he is forced to set out on an epic journey to reclaim lost relics of the past in order to ensure peace in the world of Lyndal.', False, True)
add('LegendsofMobiusBookOne', 'http://legendsofmobius-bookone.smackjeeves.com/comics/', u'It\'s been two years after Sonic the Hedgehogs last adventures. A hedgehog named Crusade travels around planet Mobius and randomly or not, becomes friends with several other mobians. But on his journey dangerous things happen and concerning news spread. And so, Crusade and his comrads, later known as "Team Element", decide to search for the root of everything. Without knowing that they get involved into a war which will decide about the worlds future...', False, True)
add('LethalDose', 'http://lethaldosecomic.smackjeeves.com/comics/', u"WARNING: This comic contains heterosexual AND homosexual relationship, Drug abuse, sexual themes and violence. READ RIGHT TO LEFT - JAPANESE FORMAT Updates every Sun & Wed. ________________________________ Follows the life paths of various youths. Our main protagonist is Bobby. Although he was a happy kid, various choices in life have led him down a dark and dangerous path. Lonely and stuck with an undesirable life, he has turned to drugs and alcohol to mull the days away with. But after a strange encounter in an alleyway one night, Bobby finds himself trapped in a much more 'hardcore' underground world of drugs and abuse; one that's secrets are so dark it's not too easy to leave behind.", True, False)
add('Lethe', 'http://lethe.smackjeeves.com/comics/', u'On the distant world of Lethe, there lived the Queen of Nephele. Said to be desired by all men for her ethereal beauty. A beauty so divine even the Gods envied her, one particular Goddess decided to bless her favorite warrior with the beautiful woman as his gift, stealing the great Queen from her kingdom. The Queen\'s abduction led to a century long war, spreading throughout many, many lands. The King of Nephele created a rule, that for each city his army conquered, the Strategos would be gifted with the most beautiful maiden from that city. As a twisted take on what had happen to his wife. But one city was at a loss, for its most beautiful maiden, was far from beautiful. It was in fact, hard to find a fair beauty in this city at all. And thus the city panicked, not being able to find a sacrifice could lead to the massacre of their people. So in an act of desperation they gave the Strategos their most beautiful person. Now it is up to this -man- to survive the war in which he as been thrust head first into~ Welcome to the world of Lethe. Where everything beautiful, is possessed. A BL comic loosely inspired by the epic poem "The Iliad" by Homer', True, True)
add('LetsBreakitforReals', 'http://breaktehrecord.smackjeeves.com/comics/', u"LET'S DO THIS. I am Sexy~ - Sexy Rule 1: No explicit content. We can't have that, but you know what humans are like. Rule 2: No getting involved in big advertisements. Rule 3: No alternate accounts. That's just cheating. Rule 4: Spam. No spam. Spam is very, very bad. Rule 5: Link news posts. If you want to link to something, post a comic instead. Rule 6: Let Kurona watch Digimon. VERY IMPORTANT! - Kurona Goal:- 206.your face Current: 88", False, True)
add('LicensedHeroes', 'http://licensedheroes.smackjeeves.com/comics/', u'Join Tempest, newly licensed hero, as he delves deep into the reeking bowels of the dungeons of unemployment, crosses the scorching desert of menial labor and infiltrates the dreaded towers of bureaucracy. Updates Wednesdays and Saturdays.', False, True)
add('LifeafterDeath', 'http://lifead.thewebcomic.com/comics/', u'Life after Death is about an out of work Grim Reaper navigating current events, new roommates and his new found mortality...', False, True)
add('LifeinBeckysRage', 'http://beckysrage.smackjeeves.com/comics/', u'A series of Rage Comics about my everyday life and the people involved! Updates on Wednesday and Sunday every week!', False, True)
add('Lifeonpaper', 'http://lifeonpaper.smackjeeves.com/comics/', u'"Life on Paper". Is a comic strip very loosely based on my life, originally it was titled, "Lil Bastard" It follows me and all my jobs, relationship, and even through marriage. With 2000+ strips. Which will eventually be uploaded here. Please Enjoy my life.', False, True)
add('LightLovers', 'http://lightlovers.smackjeeves.com/comics/', u'The love between Jay and Nicolas gives them a powerful magic. They will be confronted to all kinds of enemies, but the most dangerous is the Shadow and its Prince. (English is not my native language, I apologize for the faults... :-) )', False, True)
add('LightRomantic', 'http://light-romantic.smackjeeves.com/comics/', u'Something like a romance between men.', False, True)
add('LightwithinShadow', 'http://lightwithinshadow.smackjeeves.com/comics/', u"After the truth about her adoption is told and a string of weird dreams a girl named Lizzie sets out on a journey of self discovery....it's more then she bargained for- -But maybe with the help of her goofball best friend, her history teacher,her loyal dog, and a hired mercenary she just might get through this.", False, True)
add('LilLevi', 'http://www.lillevicomic.com/comics/', u"Lil' Levi is 9 years old. His mother is human. His father is The Devil...no really...we're not kidding. His life is going to be one hell of a ride! It's kind of like The Omen...but funnier!", False, True)
add('LiliBleu', 'http://lilibleu.smackjeeves.com/comics/', u'Webcomic en espa\xf1ol La humanidad ha quedado al borde de la extinci\xf3n por causa de un virus que los muta en superhumanos poderosos, dotados de una gran belleza y poder que han tomado control del planeta. De entre el nuevo orden se alza la \xfaltima esperanza de la humanidad: Espartaco Garc\xeda, armado s\xf3lo con una de las mentes m\xe1s brillantes del mundo en contra de seres que pueden derribar monta\xf1as con su mirada. S\xf3lo hay un problema: Quiere salvar el mundo... para gobernarlo \xe9l.', False, True)
add('LittleLink', 'http://littlelink.smackjeeves.com/comics/', u'A great Evil threatens the worlds of your favorite Nintendo characters and Link is the key to stopping it!', False, True)
add('LondonUnderworld', 'http://lunderworld.smackjeeves.com/comics/', u"Miss Ameliea Worton is sick of the rich, upper class, boring world she has been brought up in. She seeks entertainment from London's dark under belly, making friends with crooks and con artists and playing their games against the aristocracy she has grown bitter of. But, when Ameliea decides to join forces with the king of the London Underworld, she discovers how naive she has been, and how dangerous London can really be.", False, True)
add('LostNova', 'http://lostnova.smackjeeves.com/comics/', u'Two women of different birth search for the lost Compass Isle of Nova. One for glory, one for truth. And in the process they will find themselves and each other. Updates Every Week.', False, True)
add('LoveDelicatessen', 'http://lovedeli.smackjeeves.com/comics/', u"Enzo's lost his job, been beaten up and kicked out of his flat.. can things possibly get any worse? Business starts to perk up after Sora arrives, but can the girls keep their business and relationship running smoothly? The realities and complications of relationships start to surface as the Deli's problems seem to ebb away.. Love Delicatessen is NSFW with substance. Yaoi/Yuri and all the things in between.", True, True)
add('LoveHarbor', 'http://shipcentral.smackjeeves.com/comics/', u"This is a comic about shipping your characters. You can do as you please with your shippings, but please try to keep them to a T rating and below. Shipping: To support a relationship between two characters, be it canon or not. You will get a chapter here. All shipping of your design are to be posted in your own chapter. The point is to post pictures of shippings. (Sprites, Drawn, pixel art, etc.) These can be in the form of comics, author comments, etc. Your shippings can be gay, straight, lesbian and bi. So homophobes beware. You may post shipping of other authors. If you have any questions, contact 'aqua the hedgie' for more information. ------ Don't ship real people. At least poke holes in the box.", False, True)
add('LoveandIcecream', 'http://lovexandxicecream.smackjeeves.com/comics/', u"Beware its a Yaoi! (Boy + boy) This comic is about two boys ~surpriseXD~ (GOD the start is ugly) Akio and Bambi is two very different boys who met each other because Bambi had to teach Akio in math. Bambi is the only person who ever believed in Akio which is making Akio fall easily in love with him. Sadly Bambi has a homophobic big brother named Cinder who won't let Akio get closer to Bambi. Will Akio and Bambi ever get a chance for love? Gotta read and find out~ Don't let the ugly start pages scare you away\xa0 I UPDATE WHEN I WANT!!! >8U (Often enough)", False, True)
add('LuffinpuffandEric', 'http://luffinpuff.smackjeeves.com/comics/', u'The magical adventures of a fat kid named Eric and his fanciful imaginary friend, Llewellyn Luffinpuff!', False, True)
add('LumasParadise', 'http://luma.smackjeeves.com/comics/', u"Welcome to Luma's Paradise, the one and only place in the galaxy where you can find sprite comics starring the Lumas!", False, True)
add('MAGISA', 'http://mag-isa.smackjeeves.com/comics/', u'A comic about a loner, an angel, and a psychopathic cult that wants to take over the world.', False, True)
add('MUTE', 'http://muterobot.smackjeeves.com/comics/', u'We fight for what we believe in and for those we care about. With terms and beliefs like these, who is to decide what is right and what is wrong? It is our emotions that fuel our actions, but is allowing them to take over really the right course of action in drastic situations...? Comic completed.', False, True)
add('MYth', 'http://myth.smackjeeves.com/comics/', u"MYth is a collection of original short stories inspired by the Greek mythology. Since it's MY version, the storyline differs from the classic mythology. .: MYth: My Seasons :. Demeter's sudden disappearance left Hades nothing but a daughter named Persephone... .: MYth: Eternal Gift :. The story of Poseidon and his true love... .: MYth: A PROMISE :. Before the time of the Olympians. Promises...made and broken... Between two brothers, only regrets remained. ***MATURE CONTENT APPLIES TO MYth: A PROMISE ONLY*** MYth (c) Zelda C. Wang http://zeldacw.idv.st http://zelda994612.deviantart.com", False, False)
add('Magience', 'http://www.magience.co/comics/', u'------------------------------ Updates: M - W - F at Midnight PST ------------------------------ "Magience" was a new video game, one you could play while awake OR asleep thanks to an innovative headset. No one was quite sure the exact technology behind it, only that it was top-of-the-line and very mysterious. In a world of fantasy, players get one character to level and adventure with, exploring an infinitely growing and evolving world. However, it\'s not long before people start to notice certain oddities, and certain strange theories and rumors start popping up all over the place, both in game and in real life. Crazy as it sounded, what if "Magience" wasn\'t just a game after all?', False, True)
add('Majesty', 'http://majesty.smackjeeves.com/comics/', u"Majesta's life turns upside down when she learns that she is the princess of the pretty-boy filled Unknown Planet! www.enchantma.com", False, True)
add('MarXistemTWC', 'http://marxistem.smackjeeves.com/comics/', u'The worst best worst comic about gaming life and coexistence ever made in the Internet, for the Internet users. (WARNING: CONTAINS STRONG AND SEXUAL LANGUAGE)', False, True)
add('MarceliAndBryk', 'http://mib.smackjeeves.com/comics/', u"Wulfram Bryk is a private-eye. Marceli Szpak is his assistant and a bishounen. Bryk loves peace & quiet - two things that cease to exist when Marceli's around. And Marceli...Marceli loves to torture Bryk.", False, True)
add('MarioandLuigiMisadventures', 'http://mandladventures.smackjeeves.com/comics/', u'Cackletta is up to no good and stuff', False, True)
add('MariosDayJob', 'http://mariosjob.smackjeeves.com/comics/', u'A silly comic about Mario and Luigi\'s "real" jobs as Plumbers. Updates weekly', False, True)
add('MariovsSonicvsMegaMan', 'http://mvsvmm.smackjeeves.com/comics/', u"It's a battle of the three main video game mascots of the late 80's and the early 90's, Mario, Sonic, and Mega Man. Who will win this titanic battle worthy of Pay-Per-View?", False, False)
add('MarsMind', 'http://marsmind.smackjeeves.com/comics/', u'Attempting a comic journal. Lets see where it goes.', False, True)
add('Mascara', 'http://mascara.smackjeeves.com/comics/', u"As the smartest boy in school and a prodigy, everyone expects Ian to be a high achiever--\x97a future Nobel Prize winning genius. But he doesn't want to be the next Einstein. He just wants to be a makeup artist.", False, True)
add('MasqueradeWTTM', 'http://masqueradewttm.smackjeeves.com/comics/', u'Life sucks. Life sucks worse when you\u2019re doing it alone. Elias learns the hard way that falling down can be devastating without friends. And getting up after falling down is never easy. Unless, of course, you\u2019re not alone anymore. --- Masquerade will update on Sunday every week. NOTE: You may read up to two completed chapters ahead at Twelve Gates Manga (http://twelvegatesmanga.com). I post complete chapters there as opposed to weekly pages here. There are a few up already if you prefer to get ahead and read in bulk!', False, True)
add('MaverickDaze', 'http://maverickdaze.smackjeeves.com/comics/', u'A Mega Man X based sprite comic. Set in the year 22XX as the Hunters must face their most challenging threat yet!', False, True)
add('MaytheRainCome', 'http://maytheraincome.smackjeeves.com/comics/', u'William Weasel returns home after seven years of war only to find his hometown deep in a drought, and his life eerily empty and devoid of meaning. ------------ This comic became finished on March 31st, 2013 - about a year and a half after I began it. May the Rain Come is rated PG-13 (for depictions of PTSD and scary moments). Inspirations: Black-and-white movies, cartoon animals, stories passed down through the family about the horrors of war.', False, True)
add('Mazscara', 'http://mazscara.smackjeeves.com/comics/', u'After her tragic suicide, Hollywood celebrity elite Victoria Starfield is ressurected and assigned by a secret supernatural organization called Crowd Control ,to protect five specific children (and her fans) from a slew of demons, serial killers, hellraisers and fallen angels. Her only weapon, 250 feet of razor sharp, flesh splitting barbed wire and an infinite trail of black tears. Call her, Mazscara. WARNING: Mazscara is rated +18 for Graphic Violence, Profanity and Mature Themes.', True, True)
add('MediocreAtBest', 'http://mediocre-at-best.smackjeeves.com/comics/', u'', False, True)
add('MegaManBattleNetwork7TheWorldTournament', 'http://mmbn7-twt.smackjeeves.com/comics/', u'The year is 20XX... People are very lazy because they have Net Navis that do everything for them since even desks are controlled through the internet. Some people use these Net Navis for fighting and are called "Net Battlers". But, who is the strongest Net Battler? This tournament will decide that.', False, True)
add('MegaManTales', 'http://megamantales.smackjeeves.com/comics/', u'Follow the Adventures of G.B.A, a boy who ended up the MegaMan world and must find a way back home. Status: FINISHED! FOR REALZ NOW!', False, True)
add('MegaManiacs', 'http://megamaniacscomics.smackjeeves.com/comics/', u'The adventures of the MM7 cast, plus the fun-loving Andante, in an attempt to stop the forces of evil.', False, True)
add('MegaPain', 'http://megapain.smackjeeves.com/comics/', u"Core and Daniel find an old Mega Man 5 cartridge at a yard sale. As they pop it in, there's more to this game then they realize. A lot more. Updates on Wednesdays and Sundays.", False, True)
add('MelodiesoftheHeart', 'http://melodiesoftheheart.smackjeeves.com/comics/', u"Rhi Grey is your average teenager, he loves music with a passion, he goes to school, hangs out with friends and works a job at his sisters local cafe, but he has a dangerous secret he's keeping from his friends and family, which is about to catch up to him very quickly. And When Lucy Turner, a young blonde writer and her family move back to the town of Chatsford, the two meet by chance, and an awkward start to a relationship begins. Though Love isn't always as simple as it seems, as many of the teens of Chatsford are about to find out. Also follow on facebook: http://www.facebook.com/Mothseries for updates and news on the series", False, True)
add('MelodyAndMacabre', 'http://melodyandmacabre.smackjeeves.com/comics/', u'A little girl befriends Death and encounters those who seek him. An odd little series about obsession and... you guessed it... death.', False, True)
add('MementoMori', 'http://mementomori.smackjeeves.com/comics/', u"Agus & Karina are a lovely couple of college students enjoying their everyday life, until the day Agus receives a shocking new that will change his life forever. This is a pilot comic I did for publishing in my country, but since local publications aren't successful in here, it got scrapped.", True, False)
add('Metabooandfriends', 'http://metabooandfriends.smackjeeves.com/comics/', u'This is a comic where spriters of all skills and types can post their creations for constructive critisism', False, True)
add('MetroJack', 'http://metro-jack.smackjeeves.com/comics/', u'A gay ex-lumberjack and a straight metro-sexual room together while attending Boston College. Humorous shounen-ai hijinks and confused sexual orientations abound. BL/Yaoi UPDATES EVERY SUNDAY! Follow Metro-Jack on Tumblr!: http://metro-jack.tumblr.com/', True, True)
add('Metsastajat', 'http://metsastajat.smackjeeves.com/comics/', u'Tarina kertoo kuudesta lukiolaisesta, joiden el\xe4m\xe4 muuttuu, kun he saavat teht\xe4v\xe4kseen mets\xe4st\xe4\xe4 hirvi\xf6it\xe4. Mist\xe4 ihmeest\xe4 hirvi\xf6t tulevat? Vain suomeksi (only in finnish)', False, True)
add('MidnightPrince', 'http://midnightprince.smackjeeves.com/comics/', u'Jeremy Locke is just a normal high school student, but his best friend Erik has a secret. He\'s a vampire and not just any vampire, a prince! Alexei Drako is Erik\'s ex-fiance and he\'s the prince of Neutrals, a race mostly like the humans but with the power to use magic and known to live longer than five centuries. Two years after his painful break up with Erik, he\'s back to look for a new "wife" and has set his eyes on Jeremy! Will Erik let this happen and will Cleo Saint, Jeremy\'s stalker friend, allow it as well? *Not really planning to put mature things in it yet but it does contain strong language and sometime in the future partial nudity. It\'s not just Shounen Ai, there\'s hetero love too *UPDATES ON FRIDAY AND/OR SATURDAY*', False, True)
add('MineBlockTheOriginal', 'http://mineblock-comic.smackjeeves.com/comics/', u"It's like Minecraft, but it's two dimensional and the sprites are blocky! A story of hero go on their own adventure! Team work, boss battle, Pvp round and much more... NEW: Bridge Battle have open! challenge your friend and try to slay others on the bridge! Original creator/owner: BlueZero12/ EpicGames20 (I found him!) Co-Owner: Stone_Merten", False, True)
add('Minibot', 'http://minibot.smackjeeves.com/comics/', u'Created from the "Minibot Command" threads on the Smackjeeves forums. People gave suggestions of what Minibot should do next and I drew them! Special thanks to MINIBOT COMMANDERS (listed alphabetically) Afrohawkman, AFStaff, Antitime, avian-reader, Bagpipe, Bat McStar, Beany, Bowserknight, BreakCanyon, Eggie, Gibson Twist, granmastern, Hunterkirizaki, Jake48.2, johlin, MacSimon, neoblade42, Pyroman, The Radical, robybang, skystears, SonicBoom01, SuperBiasedMan, Supertoad, and wendy w. Original threads here: http://www.smackjeeves.com/forum/viewtopic.php?t=10155 http://www.smackjeeves.com/forum/viewtopic.php?f=20&t=2534', False, True)
add('MobianChaos', 'http://mobianchaos.smackjeeves.com/comics/', u'Mobian Chaos: What year did rational thinking go out of style again?', False, True)
add('Mokepon', 'http://mokepon.smackjeeves.com/comics/', u"He wants to be the very best! That no one ever was... uh, no. Scratch that. Adventures and friendship were never something that appealed to Atticus... Shame that it's a pokemon world he lives in, and so teenage boys living in Pallet Town are not expected to sit idly by. But the life of a hero is not one he's about to consider; too much hard work for little reward, and so instead he embarks on his quest not to become the greatest... But at least, the richest. Although the biggest challenge may be ignoring the adventures and friendships which may attempt to ensnare him along the way... Updates Mondays and Thursdays.", False, False)
add('MonsterGirl', 'http://monstergirl.smackjeeves.com/comics/', u"An off and on comic first conceived during my elementary school years. The whole thing was pretty much a giant experiment for practice, though it's over now.Hope you like it if you're brave enough to read it! WARNING: This comic is EXTREMELY experimental, so try to ignore the ever changing artwork. Also it's pretty dramatized... Summary: A group of high school students have the ability to transform into animals, but what's the story behind their mysterious powers? Find out on their dangerous search for the answer.", False, True)
add('MoonlightApparition', 'http://moonlightapparition.smackjeeves.com/comics/', u'When Jason and his friends, Toby and Robbie, go out on an adventure to take a look at an old building, they get taken by surprise at the monsters hiding inside! Werewolves! However, it appears there is more to the existence of these creatures than meets the eye. Following along on a bumpy path, Jason and his friends embark on a journey discovering more monsters and their existence as well as the power within themselves. _________ THERE WILL BE STRONG LANGUAGE, SUGGESTIVE SCENES, BLOOD AND GORE, IN THIS COMIC! I RECOMMEND AGES 12 +', False, True)
add('MorphE', 'http://morphe.thewebcomic.com/comics/', u'Updates Tuesday, Thursday and Saturday at 7am EST. After their rescue from a madwoman\'s hellish subterranean caverns, five humans have their eyes opened to the dark truth lurking under normal society. A "benefactor" takes them in, but he\'s a cold-blooded killer with a deadly fixation on the new mages. In a world of magic, mages, and far creeper creatures, can he be trusted? Can anyone? Warning: morphE is a kinetic novel slightly animated in flash. It involves themes of brutal violence, sexuality (gay, straight, and other), and much cruelty. If dark or adult content offends you, this may not be your cup of tea.', False, True)
add('Mortifer', 'http://mortifer.smackjeeves.com/comics/', u"This comic has been completed! RATED WEB14 and up for gore and foul language! A mercenary team compiled of three men, Valentine, the asian prostitute obsessed with money, Mathew, a bloodlusting vampire with an anger problem, and Joey, an intellegent, but very odd, mercenary who always smiles. Things go well, until the presidency of the mercenary company is handed over to Joey, after mysterious death's of his competitors. Things slowly begin to get dangerous... and people's secrets begin to get exposed. Is Joey actually planning good things for the company... or something much more horrible?", False, True)
add('MrFactory', 'http://mrfactory.smackjeeves.com/comics/', u"Dee Bananahead is the coolest gangstah in da hood. Burglarizing 50 banks in 1 night? NO PROBLEM. But when she makes an outrageous promise to blow up the factory that everyone in the city hates, things start getting complicated. Updates, like, everyday. Unless it doesn't. But it typically does.", False, True)
add('MrGrimmsCircusofHorrors', 'http://grimms.smackjeeves.com/comics/', u'Lucia has a less than perfect life. One day she decides to run away. But there is one problem with her plan... She has absolutely no where to go. That is, until a strange flyer smacks her in the face. "A freak show huh? I\'ve never been to a circus before." Rated PG 13. Contains: Violence, some crude humor, blood, some romance.... Later.... This comic is boyXgirl. Reads right to left.', False, False)
add('MyFakeHeart', 'http://myfakeheart.smackjeeves.com/comics/', u"A tale of unending confusion, aggravation, adoration, and exclamation. Amanda's best friend just got dumped. How else to win her ex back than by pretending to date Amanda? Meanwhile, playboy of the school Zach has discovered he's rather bored toying with all the girls who fawn over him. After kissing Amanda's brother Leonard on a dare, he decides to do some follow up; he wants to know if he is so hot a guy would fall for him. Luckily for him, Leonard's already interested in his gender. Less work for Zach! In case you can't tell, it's full of gay kids. There's like, three straight kids total. If that doesn't float your boat, don't rock mine.", False, False)
add('MySistertheDragon', 'http://sisterdragon.smackjeeves.com/comics/', u'A boy finds an egg in the woods, and he and the dragon that hatches from it are raised as brother and sister. Hijinks ensue, including but not limited to the wacky variety.', False, True)
add('MySparklingPrincesama', 'http://kiraouji.smackjeeves.com/comics/', u'Before you start... THIS MANGA IS READ FROM RIGHT TO LEFT! ------------------- \u79c1\u306e\u30ad\u30e9\u30ad\u30e9\u306e\u738b\u5b50\u69d8 \u2665 (My Sparkling Prince-sama \u2665) While Hanami was at the beach during one summer vacation, she met a boy who was making a pendant by the seaside. After he left she found a pendant with a name tag. When she went back to high school the following year, Hanami joined the Jewellery Club, and to her surprise, the president of the club was the student council president, who was a complete... nerd. ------------------- Genre:: SHOUJO, shoujo and more shoujo <_<... (you can tell from that lame title...)', False, True)
add('MyStereoBot', 'http://mystereobot.smackjeeves.com/comics/', u'In the city of Voxen Tin, Infinity, an odd looking stereohead, tries to live his life as best as he can, along with his partner, Cloudburn,and his cousin, Ohm', True, True)
add('MyTrollLife', 'http://mytrolllife.smackjeeves.com/comics/', u"This is a webcomic with rage comics surrounding real events in my life. NOTE: these comics are for jokes and laughs and should not be juged (but if you wanna still bitch then why are you here in the first place, you knew what you were gonna expect in the tittle's picture) UPDATES: *Normal Schedule: Once A Week*", False, True)
add('MyTwoCentsPlusTax', 'http://mtcpt.smackjeeves.com/comics/', u'In the modern world there are many evils out there. Super villains who want to destroy the world, Evil masterminds with plans for revenge, and bad dudes who go around not paying their taxes. It is up to Sanders, Jock, and Payton, three tax collectors, to bring these evil fiends to justice! Contains: [Cartoon Violence.]', False, True)
add('MyZombieDays', 'http://zdays.smackjeeves.com/comics/', u"Gags about zombie movie's cliche.", False, True)
add('MysticanDreams', 'http://mysticandreams.smackjeeves.com/comics/', u'A story about a war torn country lead by the Golden Raced Echo and her insane father who happen to clash against the Silver Raced queen and her plot to take over the entire country of Mystica. (Yuri)', False, True)
add('MysttheBookofAtrusComic', 'http://mystcomic.smackjeeves.com/comics/', u'An unofficial, fan-made graphic adaptation of "Myst the Book of Atrus" by Rand and Robyn Miller with David Wingrove. Prequel to "Myst" (1993), the best-selling PC game created by Cyan, Inc (now Cyan Worlds, Inc). Characters and story used with permission. Story: Atrus and his grandmother live alone in the middle of the desert. His grandmother excites him with stories about the D\'ni, a race of people who lived long ago. Atrus\' father, Gehn, comes to claim Atrus and share with him the amazing power of the D\'ni. When Atrus starts to question what he\'s been taught, how can he find out the truth?', False, True)
add('MythsofUnovaAWhiteNuzlockeRunHardMode', 'http://mythsofunova.smackjeeves.com/comics/', u'Sort of a sequel of my Diamond Nuzlocke Run! You can read the previous nuzlocke comics here: http://ky-nim.deviantart.com/gallery/28245977 Different region, different characters...or are they so different from the first? See how Nina and her two best friends set out on an adventure that may be more life-changing then they initially had wanted...', False, True)
add('NERDALERT', 'http://nerd-alert.smackjeeves.com/comics/', u'The lives of a geek and a nerd - these things really happened. We hit nothing but books! Updates mostly on Sundays and Wednesdays nowadays.', False, True)
add('NIGHTSHADETHEMERRYWIDOW', 'http://nightshadethemerrywidow.smackjeeves.com/comics/', u'The adventures of a middle aged, black widow spider named Nightshade and her friends. "Spiders are the original vampires"', True, True)
add('NIK', 'http://nik.smackjeeves.com/comics/', u"The Character: Nikolai is a young mage who shows great potential. He is able to wield magic without using his hands or chanting words by using the light magic he has webbed around him at all times. The Plot: The world has forever been balanced between good and evil. Each mortal lying somewhere between the two extremes. Now that a new mage has taken over the council, the light beings have a burst of power which breaks the balance they have with the dark beings of the world. And they aren't willing to keep the balance, no, the mage council decides to use this power for all they can and wipe out every ounce of dark-energy in their section of the world... This balance being broken can change many things. The mortals are directly influenced by the energies! But wouldn't a world of pure light magic be a good thing? ... (This is a BL, yaoi, shounen ai, boy-love comic. With some Hetero.)", False, True)
add('Negligence', 'http://negligence.smackjeeves.com/comics/', u"Two kids, a bottle of mouthwash, and an almost non-existent parental figure. What could possibly go wrong, besides cult families, twisted public television shows, a baby's death, and a pseudo-incestuous relationship? Welcome to Negligence, a crazy journey.", False, True)
#add('NekotheKitty', 'http://www.nekothekitty.net/comics/', u"Comic about a cute little kitty cat who's really quite cheerful about how much he hates everything. Ireland's #1 webcomic, online since 2002!", False, True)
add('NemesisKatharsis', 'http://nemesiskatharsis.smackjeeves.com/comics/', u"Jove is the descendant of the most powerful magical clan in Nokt'ader - the Aerin. She is expected to be a magic user of legend by her parents and clan. Unfortunately, she cannot even learn how to... levitate. With almost no affinity for magic, and considered the black sheep of her family, Jove harbors the ridiculous notion of one day becoming the land's... Arch Mistress of Magic! Updating schedule: heavily variable! :s I'm also working on Sailor Moon: The Enemy Next Door, and that's my priority :) but as this here is MY baby, I'll do my best to post often Genre: fantasy/adventure/romance Edit 10.12.2012: Regarding updating, I've decided to get more regular and update at least ONCE per week. What day of the week that will be is literally dependent on the position of the stars. But at least I'm introducing some structure. Yay!", False, False)
add('NeoCrystalAdventures', 'http://neocrystaladventures.smackjeeves.com/comics/', u'My best, and longest lasting attempt at a sprite comic! Has a mix of things, ideas, and characters in it! All put into a dramatic/romantic/comedy setting! Currently numbering at 1200+ comics and still going strong, this comic is updated daily if at all possible! Enjoy your stay, and have fun reading!', False, True)
add('NeonGlow', 'http://neonglow.smackjeeves.com/comics/', u'Animals exposed to a special nuclear radiation and die become what is called a Neons. Neons are a phantom/zombie creatures that can be dangerous. Its up to Zedof and Jake to hunt them down to keep them from harming the public. May have some light boy love, but it is not the main focus of the comic.', False, True)
add('NevermoonawerewolforpokeaPooka', 'http://werewolvesandpookies.smackjeeves.com/comics/', u"Troopers is a young orphaned werewolf who is still learning a lot about his wolf side along with his human side. Not to mention he's got the mysteries murders beast monster out for his blood. But atlest he has found another loving werewolf pack family( who prefer to be called Shifters) who taken him in and are treating him just like family. But that was before Trooper fell off that cliff into the icy river that carried him to a strange part of the woods. Were instead of other werewolf's and shifters, he meets the strange Pookies creatures. What are Pookies? What do they want with stray dogs? How will Trooper get back to his pack? Can he trust his knew friend Iggy the shy young Pooka who found him? Or is Trooper doomed to live the rest of his life as a Pookies pet dog ( even though he's a wolf) . and thats only if the Beast doesn't get him first. some pages are also on dabbycats at deviantart.com you can also read the original story (without drawsing) at thoughts.com under the blog dozzer. look for the same cover art", False, True)
add('NiceKitty', 'http://nicekitty.smackjeeves.com/comics/', u"UPDATES TUESDAY, THURSDAY,and SATURDAY! About Nice Kitty: It is the touching coming of age story of a young boy and his cuddly feline companion, trying to find love and acceptance in a world fraught with peril and harsh realities. Will the mysterious new friend they meet one fateful day be able to answer the call of their lonely hearts, and bring some life and color to their otherwise blue and lonely world? You'll laugh, you'll cry, you'll pray for it to stop, but It won't because you can't stop the rock and why are you still reading this? You came to read the comic so READ already. This drivel certainly won't help you understand the story any better. Get going! And just remember: Be nice to your kitty, and he'll be NICE to you..........", False, False)
add('NighHeavenandHell', 'http://newnighheavenandhell.smackjeeves.com/comics/', u'A grudge as old as mankind. Three travelers entwined by fate. This road, once travelled, can never be undone. Between damnation & salvation, you find the truth hidden by God, Nigh Heaven & Hell. //Updates Every Friday//', False, True)
add('NightKids', 'http://nightkids.smackjeeves.com/comics/', u'A Dramatic Graphic Novel about Trauma and Transcendence.', False, True)
add('NihilWandasJourney', 'http://nihil.smackjeeves.com/comics/', u'I did this comic in coorperation with a friend of mine. Drawings, idea, characters and translation [The originalversion is in German] are all my fault. Wanda strongly believes she is a princess and wants to prove it, since most people just do not want to pay tribute to her. Together with Avis, a wood imp who accompanies her out of pity, Wanda embarks on a journey to the Garucian Mountains to see the mighty wizard Hon-ar, whom she expects to trace her [as she believes] lost, royal parents. Unfortunately it turns out that the world has other plans for the young woman.', False, True)
add('NixsFireRedNuzlocke', 'http://nixnuzlocke.smackjeeves.com/comics/', u"Join Nix across the hell that is Kanto and all its Pokemon, specifically the poison types. oh god, the poison types... Mostly Basic rules: 1)Pokemon faints, it dies. 2)Can only catch the first pokemon on a route -If it's a duplicate you may retry -Exceptions include shinies and gift pokemon -No catching Legendaries -Each area in the safari zone counts individually", False, True)
add('No1Enemy', 'http://no1enemy.smackjeeves.com/comics/', u"Nao Miyagi has made a hobbie out of hating popular school stud Hiroshi Kagawa but he finds out the hard way that hate can easily be turned into love, and first impressions don't always last! :) WARNING; this comic contains Yaoi/bl so if you don't like it don't read it!! thankyou!!! X3 contains some bad language and may get alittle mature! plz enjoy :0 hehe Gopeach", True, True)
add('NormalcyisforWimps', 'http://normalcyisforwimps.smackjeeves.com/comics/', u"Sonic and Tails have gotten bored of living away from civilazation and have decided to move to Onette, at least that's what Sonic decided. Warning: Contains Demonic landlords, magic, insanity, and something else I can't think of right now.", False, True)
add('October20th', 'http://www.october20comic.com/comics/', u'10 years ago, on October the 20th, 6 people from different parts of the globe were each responsible to taking an innocent life. Every anniversary following it, they have been stalked and hunted by a mysterious creature that only shows itself on the infamous date. Only the American called Catherine and the Argentinian called Rai are left. Is this the year they finally discover the truth about the curse that has taken everything from them, and find a way to stop the relentless beast? And who is the shadowy figure oddly called Shields McKloskey, who seems to hold all the answers?', True, True)
add('OldElastikid', 'http://oldelastikid.smackjeeves.com/comics/', u'These are all of the old Elastikid comics from prior to February, 2011. This was before Joe decided to become a superhero, and consists mostly of gag-a-day jokes with no real overall storyline. The tone of the series was rather different, so rather than continue on this comic, I decided to release all of the new strips as a "sequel" comic continuing in the same continuity. You can read the current Elastikid strips at http://elastikid.smackjeeves.com/ which is still being updated.', False, True)
add('Oli', 'http://oli.smackjeeves.com/comics/', u'', False, True)
add('OneFrameGags', 'http://oneframegags.smackjeeves.com/comics/', u'One panel (and occasionally two or more) gag cartoons featuring no main characters.', False, True)
add('OneLastDay', 'http://onelastday.smackjeeves.com/comics/', u'The title "One Last Day" is the basis of all the strips in this series of one page comics. Each page is his "last day". In some vague way or another that is.', True, True)
add('OneRainyDay', 'http://one-rainy-day.smackjeeves.com/comics/', u'Basically a BL story like "the prince and the pauper" No sex scenes (at least not for a hundred pages or so) Mostly a cute story about a developing relationship Aki was abandoned when he was eight, for ten years he\'s lived on the streets with nothing but his wits and strength to support him. Needless to say he is unhappy. But one day he runs into some one who looks exactly like him! This mysterious boy named Ryuuta turns out to be the young master of a large corporation who just wants to be free and discover himself. Aki and this Ryuuta trade lives for the summer and Aki\'s doing fine in his new life until his identity is discovered by the Ryuuta\'s intimidating body guard named Kaidou. Can a love bloom between a stoic individual and a street rat?', True, True)
add('Onlyonelovesong', 'http://onlyonelovesong.smackjeeves.com/comics/', u"[available as a paperback on Indyplanet with a few extra spicy pages, revamped dialogue and prettier speech bubble arrangement!] A spoiled, frustrated and capricious rock star accidentally meets a common girl seemingly imprevious to his charm. Hiding his true identity from her, he selfishly decides to make her fall in love with him. But as he gets to know her better he finds himself falling instead. Only, there's a secret in her past keeping her heart locked away... [story specs: BOY x GIRL romance, mostly comedy, some heavy drama, censored swearing, occasional gratuitous male fanservice] [tech: b&w pages, color covers,hand-drawn&inked then photoscreentoneshopped to death]", False, True)
add('OntheBrightSide', 'http://onthebrightside.smackjeeves.com/comics/', u"Jacob comes home from school one day and finds out a family is moving in next door to him. The oldest daughter, Kaylee, is a very kind and optimistic girl who is the same age as him. And to his surprise, she was his best childhood friend! It\u2019s been eight years since they have last seen eachother, but after Kaylee\u2019s return his life isn\u2019t the same. *Updates: Random for now This is my first comic and I'm always experimenting with new techniques and keep trying to improve, so constructive criticism is always welcome. I'm also in the process of redoing the comic and replacing the old pages. So if you're wondering why my style has changed after a few pages, that's why! Other than that, I hope you enjoy the story!", False, True)
add('OpenSpacesandClosedPlaces', 'http://oscp.smackjeeves.com/comics/', u'Open Spaces and Closed Places is a cute loverly comic about starry eyed youth with lots of flowers featuring gakuran, delinquents, glasses, scary things, fanciful thoughts, eroguro innocence, crack humour, weird characters, and paranormal stuff. Updated on Sunday and Wednesday. Website: http://www.saicoink.com', False, True)
add('OperationTheater', 'http://operation-theater.smackjeeves.com/comics/', u'"It\'s only Paranoia if I\'m wrong. I can handle being wrong, but if I\'m right I\'m screwed!" Bastian Weber is a weird geeky jitterbug, a punching bag for everyone, but his life turned upside down when he met Izrael and Claudius, two strange guys who are living at his attic... [CONTAINS BL/GL, sexual confusions, comedy, drama, gore, horror, blood, some bondage, crazy people and lots of shit XD] So if you like weird people, unprecedented fights, Nerds/Geeks, friendship and a hero who gets mortally injured on a daily basis, get some snacks and look forward to "Operation Theater"! P.s. - I\'m pretty bad at sticking with genres, so this is supposed to be a bloody comedy with added drama and lot\'s of gay jokes :I P.p.s. - It\'s not porn', False, True)
add('OptimalClutter', 'http://www.optimalclutter.com/comics/', u'Day to day, project to project lives of a group of developers/engineers, and the people that surround them. (Updated Tuesday, Thursday, Saturday, and 1st of the month) (Random once a month strips have moved to the Extra Pages site)', False, False)
add('OrangeCloud', 'http://orangecloud.smackjeeves.com/comics/', u'A young man named Sky Rojos sets off to find a rare natural phenomenon, an orange cloud. As he journeys across the world, he makes new friends and encounters many foes. Comic is black and white and Naruto, Bleach, and One Piece inspired. Note: This comic has been discontinued as of Chapter 5.', False, True)
add('Oscurare', 'http://oscurare-comic.smackjeeves.com/comics/', u'Would you give your soul for a chance to search for a missing loved one? That is the price sixteen year old Yoru paid to the forest demon sending her on a journey to the sunless world of Oscurare. In an unfamiliar world does Yoru have what it takes to find her brother and stay alive? Updates once a month Rated-pg 13 now updating: chapter 5', False, True)
add('OverSync', 'http://linearperspective.smackjeeves.com/comics/', u'Oversync is a comic about a young girl who stumbles into another world. Jacqueline dives into the world of Arcadia but soon finds herself tangled in a mess of secrets and conflicts. Can she punch her way out of this mess or will these battles prove to be surprisingly fist proof. A silly web comic focused on character interactions and exploring a fantasy world filled with curious things. New Pages every tuesday, wednesday, and thursday!', False, True)
add('OverfiendComics', 'http://overfiend.smackjeeves.com/comics/', u"MS Paint comics and culinary secrets from Cambridge, England's only person named Stu.", True, True)
add('PMDSkyNuzlocke', 'http://giginuzlocke2.smackjeeves.com/comics/', u"Part 2 of Gigi's Nuzlocke adventures~ This time Gigi loses her memory (again!) when she is mysteriously turned into an Eevee. Joining Kiara the Vulpix, can they solve the mystery of time and space? ~A Pokemon Mystery Dungeon: Sky Nuzlocke", False, True)
add('PMDVictoryFire', 'http://victoryfire.smackjeeves.com/comics/', u"Sometimes the most interesting stories come from the strangest places. Victory Fire starts off as most Mystery Dungeon comics do, a human comes to the pokemon world. But THAT'S where the similarities end.... New pages are posted on Tuesdays and Fridays, please check back :) **Broken images? SmackJeeves servers playing up? VF is mirrored on sulfurbunny.deviantart.com **", False, True)
add('PRAGUERACE', 'http://praguerace.smackjeeves.com/comics/', u'PRace is a story about friendship and adventure. Author is Petra Erika Nordlund, also known as LEPPU and her other artwork can be found from tumblr and deviantart with the same nickname. email for contact is petra.nordlund at gmail.com', False, True)
add('PTO', 'http://pto.smackjeeves.com/comics/', u'"I just want to feel loved" The year is 2374 in the future. What is going to happen, when a gang of useless men adopt an adorable living doll? Well, a lot of drama and heartbreaks, that\'s for sure. ---- UPDATED EVERY DAY! Includes sex, nudity and a bit of violence. Check out also (http://ptobonus.smackjeeves.com/)', True, False)
add('Pahantekija', 'http://pahantekija.smackjeeves.com/comics/', u'When vampires killing humans is an everyday occurrence, one more death is barely worth mentioning. In one village, though, people seem to be a bit too willing to dismiss it, and Ausra the novice decides to find out why. However, her obstinacy backfires and before long she finds herself in a rather life-threatening company. Contains gore, violence and other shady stuff. Be prepared.', False, True)
add('Panacea', 'http://panacea.smackjeeves.com/comics/', u"Caelen is part shapeshifter but his dual heritage becomes a curse when he learns his unstable body is slowly deteriorating. Life seems pretty miserable and pointless. With no faith in himself and even less faith in others he has very much sunken into pitiful state. After hitting his lowest point, landing in the streets with nowhere to be, he manages to catch the attention of a stranger. Will Sairys' compassion and cheerful attitude be enough to break through the barriers Caelen manage to erect around himself? *~*~*~*~*~*~*~*~*~*~*~*~*~*~ Boy Love Warning! Hopefully I'll manage to update once a week. You can expect new pages on Mondays and Thursdays... usually, unless something comes up and I can't make the deadline.", True, False)
add('PantsParty', 'http://partypants.smackjeeves.com/comics/', u"This is the Pants Party! Its a Party With Pants. Three friends live and stink up the Lab of famous Dr. Light, will their shenanigans get them into trouble? or will Z just give Dr. Light a raging boner? Find out at the PANTS PARTY Updates usually whenever. The Pants Party Hosts- Boh - Supreme Commander in Chief (Also known as the God King) The Magnificent Z - The Magnificent Gatamigo - Vice President Joe Biden. If you wanna vote for the Pants Party, just give me a message, you just might get a cameo. Probably a better one than Gata too. Hey, you can't lose right? Vote Pants Party. Edit: But I'm an author now so how the fuck could they get a better cameo than me -Vice President Gata Edit Edit: Because even though you're an author, you're still lowest on the totem pole. - Supreme Commander in Chief Boh. Edit Edit Edit: And I'm sandwiched in between you two. ~Z Edit Edit Edit Edit: Phrasing! Boom! - Boh The Host.", False, True)
add('PanzerDragonandEnigmaCompleteEdition', 'http://panzerdragonandenigma.smackjeeves.com/comics/', u"As a world reaches its peak of prosperity, instability begins to reveal itself as Dragonenix falls into a period of darkness. Three warriors will rise to the challenge to solve the mystery of their world's instability and set things right. The Complete Edition of Panzer Dragon and Enigma contains the full unabridged story of the entire First Arc series, including the first season of the PDE(+) Saga: Twilight Dawn. The last major update was November 16, 2011, with Twilight Dawn added to the archives as of March 20, 2012.", False, True)
add('PanzerDragonandEnigmaZwei', 'http://pdezwei.smackjeeves.com/comics/', u'Panzer Dragon and Enigma Zwei is the re-telling of the original story on SmackJeeves about protagonists Panzer Dragon, Enigma, and Niavana Avalon as they become involved in protecting their home from the move of a mysterious organization, spiraling into a battle that will decide the fate of so many worlds and reveal to this trio their destiny. Click on "PDE: Complete Edition" to check out the original story, but you do NOT have to read the Complete Edition to understand what\'s going on in PDE Zwei. Nevertheless, it\'s still an awesome read and you should check it out if you want an idea of my past works. Comics available every Monday, Thursday, and Saturday!!!', False, True)
add('Paradox', 'http://paradoxcomic.smackjeeves.com/comics/', u'Taken as prisoners of war, Dake and Tommy are sold as slaves, one to a wealthy but kind woman, the other to a man of unknown species who has a very bad habit of eating people. Forced to endure the horrors of war, racism, homophobia, and the occasional molestation, can these two opposites somehow attract? Contains sexual situations, violence, drug use and probably many other bad things.', True, True)
add('Pause', 'http://pause.smackjeeves.com/comics/', u'"Pause" is a light story about a boy, Yoshiro Koizumi, who can freeze time whenever he wants to. When he suddenly meets a girl who is unaffected by his time-freezing powers, his peaceful high school life is thrown into chaos as she discovers his dark secrets which Yoshiro only shows when time is frozen. -Updates daily... most of the time :|', False, True)
add('PepSquad', 'http://pepsquad.smackjeeves.com/comics/', u'the day to day struggles and activities of a group of teenage cheerleaders.', False, True)
add('PerplexingMagnoliaDisruption', 'http://smgpmd.smackjeeves.com/comics/', u"Perplexing Magnolia Disruption is a serious comic filled with love, hate, drama, and... Who are we kidding, it's a Team SMG Pokemon Comic. Don't expect this to be serious at all. COMIC COMPLETED. The sequel can be found here: http://www.smackjeeves.com/comicprofile.php?id=118656", False, True)
add('PeterPan', 'http://peterpan.smackjeeves.com/comics/', u"An adaptation of the classic children's story Peter Pan. Closely following J.M. Barrie's original story, come follow the adventures of Peter and the Darling children in Neverland! If you've never read the book, here's your chance to experience the real story! If you have, and enjoyed it, then this is the comic for you! Updates Sundays and Wednesdays!", False, True)
add('Phantomland', 'http://phantomland.smackjeeves.com/comics/', u"UPDATES ON THURSDAYS Santa Luison is a large city that employs it's strange minority of subhumans at a crime fighting organization. Introduce Chie: a fresh little rookie who receives her training from the baddest, meanest veteran officer around. Phantomland started as a self-published print comic back in 2009 and is now getting it's online debut at Smackjeeves. To know more about this comic, visit the homepage at: http://amph.nipponfever.net/phantomland", False, True)
add('PiandPeasNuzlockeAdventures', 'http://piandpea.smackjeeves.com/comics/', u"Pi embarks on a Nuzlocke Challenge adventure in Unova! Together with her smug Snivy, Pea, she'll have to stop Team Plasma from making a world without Pokemon... Will they be able to work together? Will they make it through, until the end? ...alive?", False, True)
add('PlasticKings', 'http://plastickings.smackjeeves.com/comics/', u"A young king and his rock n' roll queen must give up their party-animal ways and beg the gods for help when their newborn son falls ill. However, this is only the first of many problems facing the kingdom and the gods who watch over it.", False, True)
add('PlayTime', 'http://dollysplaytime.smackjeeves.com/comics/', u'Megumi was just a timid high school girl trying to cope with life until the day a magic ribbon came into her life and a new hero was born!', False, True)
add('PokeVenturous', 'http://pokeventuras.smackjeeves.com/comics/', u"It will all be mine power so divine it's my destiny Team Rocket, it's my destiny Follows the adventures of the trainer Lea who is also a psychic and stuck working for team Rocket, as they fight other corporations for a piece of the global market. Disclaimer: This story uses pokemon from every generation. You have been warned Also Pokemon is a Trademark of Nintendo", False, True)
add('PokefarmingRiseFromtheAshes', 'http://pokefarming.smackjeeves.com/comics/', u'http://pokefarm.org/ IF YOU HAVE A POKEFARM ACCOUNT YOU CAN JOIN. A second Pokefarming since the old one was deleted by some douchebag. >:I All about Pokefarm. Post your eggs and pokemon, etc. Anything Pokefarm related.', False, True)
add('PokemonBeta', 'http://pokemonbeta.smackjeeves.com/comics/', u'The Trygon facility was made to create better Pok\xe9mon that can survive in their world, as species over the years have been dying out. Rymadanas, the head of the Red tower, desire Pok\xe9mon to become equals, with no weaknesses or be disadvantaged. Pok\xe9mon are recruited into the facilities by force if they lack the necessary amount of specimen. The Trygon capture Pokemon and genetically experiment on them, and even themselves to achieve their goals. Those captured unwillingly are wiped of their memories, forcing them to obey without question. Some regions had seen the only way out is to urge their residents to undergo experimentation to keep families from being separated, and body counts low. Opposition to the Trygon Organization has reached an all time pitfall. Only few pieces of land are still free of the shadow cast from the buildings. Is risky science the way to salvation? What is the root cause of Pokemon to be dying out? Unbeknownst to a Totodile, he would find the answers to everything...', False, True)
add('PokemonCrystalDoubleNuzlockeChallenge', 'http://miinuzlocke.smackjeeves.com/comics/', u"Another Nuzlocke Challenge, Pokemon Crystal Version :D. Note: English is not my main language :B, so you're free to correct me anytime.", False, True)
add('PokemonInsanityVersion', 'http://pokemoninsanityversion.smackjeeves.com/comics/', u'This comic is just what the title says... INSANE! This is a bunch of short stories involving Pokemon, a trainer, and just some wacky people! WARNING: Craziness, and radomness has been known to cause blindness and sheer madness. (CURRENTLY A PMD)(Updates every Thursday and occasionally other days) Quoted Characters: Skybyte: BARRELS! (If you get it, youre awesome) Chill: Violet: Hey there, hippo \xe0ddict! Aurora: I have long hair. Your argument is invalid. Vortex: HEWWO THEWE!!!! Christian: Wotters: Feel the tides of fate! Riolo: I have many qoutes. "Math is Eisier than Pi the number." All righty and mighty." Of HORSE I\'ll do it." Why', False, True)
add('PokemonLANDSKY', 'http://www.landxsky.com/comics/', u'LAND//SKY follows the adventures of seventeen year old twins Xander and Lexi as they leave their hometown in the Hoenn region to travel and to see what the world of Pokemon has to offer. Story by Sky King Artwork by Freedomthai', False, True)
add('PokemonMysteryDungeonAdventurersofLight', 'http://pmdal.smackjeeves.com/comics/', u"Based off of the PMD series, rises the imagined sequel Pokemon Mystery Dungeon, Adventurers of light! Introducing a new world! a new team! a new adventure! Join Jason and Luna as they set off on the adventure of a lifetime, making new discoveries, and facing a great evil! For this is Adventurers of light! disclaimer: I don't own Pokemon, this is purely fan made. Rated T for Violence, sexual themes, alcohol reference, Language, and Suggestive Themes.", False, True)
add('PokemonMysteryDungeonTales', 'http://pmdt.smackjeeves.com/comics/', u"Vexx and Mack of the Super Ranked Team, GreenFire, set out on a mission of their own, to explore the world outside their Island! However, things do not go according to plan when enemies of old appear with plans of their own. Along with their new team-mates, friends and allies, Vexx and Mack set a course to continue helping the Pokemon of the world while exploring the new world around them. This is their Tale... Based on the popular Pokemon Mystery Dungeon \xa9 series. Pokemon is copyrighted \xa9 to Nintendo/GameFreak Updates once a week, or whenever possible (Due excuse some long pauses if I'm sick, suffering from Crohn's problems)", False, True)
add('PokemonMysteryDungeonTeamCrystal', 'http://crystalmysterydungeon.smackjeeves.com/comics/', u"Just a little something I wanted to try as a result of playing pkmn mystery dungeon games a lot. Will have a bit of everything category wise :) Will up the rating to M if it calls for it..but hopefully it won't. It IS rated T for language though! Updated whenever I can!", False, True)
add('PokemonSAKOHJU', 'http://sakohju.smackjeeves.com/comics/', u"Different adventures kick off with different characters in different parts of the Pokemon world! There's darkness in the Pokearth, and it's not just Team Plasma. A group by the name of Team Midnight is on the rise. However, their biggest obstacle appears when the protoganists come together to form SAKOHJU, an organization dedicated to ridding the Pokemon world of evil. As the fight rages, it's unclear how many will make it out alive, as it all comes down to SAKOHJU vs. Team Midnight... ____________________ I started this comic a couple years ago so some parts of it (beginning especially) aren't all that good. It's become more of a sketch comic and it's a learning experience for me, I improve and as my first project I'm seeing this thing to the end no matter what. I also have lots of characters based off real people. I will say that now. Also breaks the fourth wall. A LOT. Pokemon (c) Nintendo", False, True)
add('PokemonXDegree', 'http://pokemonxdegree.smackjeeves.com/comics/', u'Pokemon XDegree is a drawn and fully coloured Pokemon comic. A new and exciting, funny and romantic, mysterious and action packed story you would love to read. If you like battles, actions, or even just cute and colourful Pokemon, add Pokemon XDegree to your watch list ;D Lecus is a Pokemon Trainer, read to embark on a new adventure, however..... Any favourites are highly appreciated. Contain minor course language and some violence. Updates every Sunday :D -Lucazke', False, True)
add('PokemonnoRakuen', 'http://pokemon-no-rakuen.smackjeeves.com/comics/', u"Summery- Gray has NEVER had a single girlfriend in his 17 years of life. His mother gets him a Totodile and then weird things happen... The Totodile becomes a human! What's going on?! Will going on a Pokemon journey give Gray the answers to his questions? Why did the Totodile become a human? What does Gray's father have to do with any of this? Will Gray EVER get a girlfriend? (Unlikely) Read to find out For ages 13 and up Warning- May contain death, blood and Implications", False, True)
add('PokemutatesRus', 'http://pokemutatesrus.smackjeeves.com/comics/', u'A showcase about pok\xef\xbf\xbdmon mutations by Flashwatch, Djoing, Digi300, Awesomeness189,Shift, Bowserknight, kitsune fire, himynameischris, Crusty_Kris, Weaver Tyialo, kh_fanatic1995, Snowy death,disturbed1, Chaodude, Jed192, Eddigardo, Rarhq2, naruto_numb,Celtic guardian, Ragethefox, Sparky The Fox, Bresong, Axel1000, Plazmaz, Xp_lulz and ridleykirb!! Also, not to forget, Flashwatch will show off some of his awesome Pokemon to Pokeball fusion art! If you want to request any splices i still do them on my FaceBook page called StrikedDragoon ~Snowy', False, True)
add('Ponzi', 'http://ponzi.smackjeeves.com/comics/', u"About: It's a new beginning, a new age and a new world where people enjoy advanced industrial games, technology and entertainment. At this moment, after a mysterious broadcast, the world media has launched a new tournament called N.E.O.SIN. The prize for this competition is unlike any other, the winners will receive an evolutionary enhancement of their body. This enhancement will improve their physical and mental capacity as a human being. Ever dream of super speed, super vision or any other kind of supernatural enhancement? Who will win the key to the evolution of the human race? (You can read more info on the official site: www.pigtailstudio.com )", False, True)
add('PrincessChroma', 'http://princesschroma.smackjeeves.com/comics/', u"As darkness threatens to engulf all life, the universe cries out for a champion with a pure heart. But they'll have to settle for schoolgirl June Summer. With the help of her friends and her mentor, a winged bunny, June will battle monsters, struggle to maintain a normal school life, and occasionally watch television. Hey, even heroines need a little downtime. -A Magical Girl Parody. Updates Wednesdays!", False, True)
add('Puck', 'http://puck.smackjeeves.com/comics/', u'This site is the Smackjeeves mirror site for Puck where older comics are posted. The actual Puck website contains the latest content at... WWW.PUCKCOMICS.COM', False, True)
add('PulseandBolt', 'http://pulse-bolt.smackjeeves.com/comics/', u'Two female human batteries become armored superheroes.', False, True)
add('PumpkinFlower', 'http://pumpkinflower.smackjeeves.com/comics/', u"CONTAINS: BL When being stalked by an amnesiatic ghost is the best thing going for you there may be a problem. Now if only the ghost could understand the term 'personal space.' FINISHED", False, True)
add('PuppetsandStrings', 'http://puppetsandstrings.smackjeeves.com/comics/', u"Clare Von Brighton didn't know what she was in for when she was moved to Dame Edwin's Academy for Young Ladies. Little did she know she would be unraveling secrets not only about the history of Edward park, but of other people's lives and her own.", False, True)
add('QueerQueen', 'http://queerqueen.smackjeeves.com/comics/', u"Queer Queen is a comedy shounen ai manga centred around Helium, a transvestite male student attending a boys' school, who falls in love with his own form-teacher. For this love is unrequited, he decides to ask out a fellow student to make his teacher jealous. Updated every Thursday, should be read from right to left.", False, True)
add('QuestionDuck', 'http://questionduck.smackjeeves.com/comics/', u'A curious duck and his friend travel the world together. They visit many places, and ask many questions. Often these things are not related.', False, True)
add('QuiteNiceComics', 'http://quitenice.smackjeeves.com/comics/', u"Welcome to a world of mysticism, intrigue, and chaos. Where warring powers turn the tides of time itself to their bidding. Where deception is a virtue and the truth an executioner's axe. ... Actually, that's the comic next door. This is Quite Nice Comics.", False, True)
add('RANDOM', 'http://randomthecomic.smackjeeves.com/comics/', u"Is logic at the door? Well tell it to beat it! You won't need it for this series. RANDOM is about one thing, complete nonsense. Join Joe B. Gamble, Smart T. Guy, Iam 2. Cute, I-I and Speedo. Every comic teaches you a new idiom to use for yourself, except you will learn it in a very unorthodox way. With a cast that gets in your face and glues itself to it too, RANDOM is what it wants and when it wants. No plot, story or sense, just a lot of laughs and idioms; that is RANDOM.", False, True)
add('RIDDICKQLOSSTALES', 'http://riddickqlosstales.smackjeeves.com/comics/', u"Crack detective Riddick Q. Loss' never-ending quest to catch the dastardly villain Sir Dimswitch.", True, True)
add('ROSIER', 'http://rosier.smackjeeves.com/comics/', u"[COMPLETED WORK] A Dark Fantasy Romance: Vanney is a ditzy acolyte at the Temple of the God of Wealth and spends her days daydreaming about adventures with her best friend Jaelia. When the Temple sends the two of them to escort a caravan to the mysterious, far-off border town of Shadow Charing Vanney's time for adventure has come. But her sunny imaginings have nothing to do with the shadowy world of witches, demons, magic and netherworlds her path takes her to...", False, True)
add('RainLGBT', 'http://rainlgbt.smackjeeves.com/comics/', u'Written by Jocelyn Samara DiDomenick (aka LittleLynn84) "Rain" is a comedy/drama that follows the daily life of teenage transsexual (who is coincidentally named Rain) attempting to go through her senior year being only identified as a woman. I\'d like for it to be very funny and entertaining, but the story will also touch on many rather heavy subjects including acceptance from family and piers, blind hatred and many of the other difficulties faced by members of the LGBT community. This comic contains: - Occasionally strong language - Sexual themes and situations (but no nudity) - Gay, lesbian, bi and transgendered (and straight) characters - Lousy or non-existent backgrounds', False, False)
add('RainxSasori', 'http://rxs.smackjeeves.com/comics/', u"WARNING. The art is REALLY bad at first but it gets wayyyy better! Promise! :) This is my first comic so I'm trying new things with it. I'm experimenting and practicing all sorts of things like back grounds, shading and neatness. Horrible handwriting, that can't be helped sorry. BL. YAOI Sasori Mahitto, 19. College student from Japan (just moved to New York). Rain Westong, mid 20's. Demon, man whore. Their paths cross and Sasori's naiveness gets him into a lot of trouble with Rain. Somewhere along the lines of Sasori getting into trouble with Rain he ends up becoming his house maid? And is asked to do some. . .unmentionable things?... contains: a little nudity, foul language, alcohol, cigarettes, sex, demons, cute uke boys, and YAOI. :) Enjoy. :) Updates every Saturday at 7 AM. :) (Currently off schedule. Updates when I finish a page :))", True, True)
add('RavenWolf', 'http://ravenwolf.smackjeeves.com/comics/', u"Due to human negligence the world as we know it has ended and been reborn. The animal spirits that guide man giving them the forms of animals so that they would be able to survive in this new wilderness. Though now carrying the form of beasts man has not forgotten the place they once had, as an existence greater then just what nature wanted of them, an existence above all. Those that worked to gain their humanity are known as domestics, while those who wished to follow the roles the spirits had given them were known as wilds. Both groups grew arrogant and hateful of one another because of how differently they thought. The raven and the wolf spirits grew tired of the destruction and fighting and sided with the wilds in their ideals, the domestics only capable of further destroying nature. In their anger they marked a tribe of wilds with a curse, they being removed from the sacred circle of life, the curse upon them only broken once the domestics are gone once and for all. The cursed tribe now known to all by the name of the spirits whom cursed them. 'Raven Wolf' Updates: Wed, Fri and Sun", False, True)
add('Regina', 'http://regina.smackjeeves.com/comics/', u"'Regina' is a sketch comic. It's a daily sketch challenge comic designed to get me to draw one comic page a day so I can stay in practice everyday. Also to practice page layouts and conversational writing. Regina was drawn using only with a black ball-point pen but now has tones, for a new look. The story of Regina is a slice of life about a girl named Regina and her random group of friends,where what ever happens, happens and I try to make it as interesting as possible. Updates: Daily", False, True)
add('Regnum', 'http://regnum.smackjeeves.com/comics/', u"The kingdom of Regnum is beautiful and ruled by the royal family. But the prince has been kidnapped by a demon! The king hastily throws together a team of elite fighters, soldiers, and weirdos to bring his son back. These 8 strangers are to work together to gather clues, fight, and bring the little shit back home. _______________________________ This collab will most likely contain violence, cursing, and sexual content so BE WARNED _______________________________ This is a BL collab! It is a BL collab but romance doesn't have to be a central theme! Spots Taken 8/8", False, True)
add('ReidyandFriendsShowcase', 'http://reidynfriends.smackjeeves.com/comics/', u"A general showcase where pretty much anyone can post anything they want, barring porn. Maybe. Probably. We also try to be civil whenever possible, so don't go out of your way to piss people off. Other than that just sit back, relax, and enjoy the showcase. Anyways, you should have at least SOME experience spriting before applying to join, should you want to. We don't accept recolors and are very much against sprite thieves.", False, False)
add('Replica', 'http://replica.smackjeeves.com/comics/', u'Edelric Helgard, a young Marquis, returns to the house of his childhood in order to save his family\u2019s lands from an epidemic. During his research, he encounters a foreign slave who looks disturbingly like his first love, his late half-brother. Thus begins a game of replicas mingling memories and reality. -Read from Left to Right -Boys Love -R-18 from chapter 2 onwards -Updates on Fridays', True, True)
add('Republicanattackmachine', 'http://www.republicanattackmachine.us/comics/', u'Life is about many things. But at this site it is mostly about discussion and observation. Here you can have a discussion with a Republican. Not the National Republican Party, nor a Republican office holder, staffer, or aide. Here you will see what one Republican thinks. An individual. And you will discover, hopefully, that we like to laugh as much as anyone. If its your first time talking to a Republican, welcome.', False, True)
add('RequiemShadowbornPariah', 'http://shadowbornpariah.smackjeeves.com/comics/', u"A bad job, a betrayed assassin. Now she's on the run from the very people with whom she once worked. Locked into the world of the Immortals, Anastasia V\xe3duva has lived in the shadows of Eastern Europe for over two centuries. Forced to flee to the New World with the promises of shelter - she finds no salvation. The New Kingdoms are possibly even more dangerous than anything existing within the Elder Illuminati demesnes. Armies march to the drums of the Requiem, nations rise and fall to the whim of the Illuminati - and they want her dead. Updated Sundays and Thursdays", False, True)
add('RestaurantIndustryMafiaComics', 'http://rimcomics.smackjeeves.com/comics/', u"Work doesn't have to suck. Regular updates resume October 3rd!", False, True)
add('ReturntoEden', 'http://rte.smackjeeves.com/comics/', u"When you're the last angel remaining, being mistaken for Satan's lunch is *not* going to make things easier.... (may contain fun stuff like angels, demons, complete disregard for the bible, crazy people and bare butts, sometimes bare-butted crazy people. Add a hint of BL, and you've been warned)", False, True)
add('RevivalPsalm', 'http://revivalpsalm.smackjeeves.com/comics/', u"ISH doesn't know what he is looking for, but he knows there's something more;perhaps it was because of the fiery sword, perhaps it was because of HOP, perhaps it was because of that man who told him that there will be a day when everything will change. Really? The place he lives in is already forgotten by time, nothing here is alive, can anything be changed? =========================== Done in traditional art Fantasy with monsters and stuff... I'm bad at describing things... I'm bad with technology i know not how to do things and I'm still changing things around update weekly..hopefully...", False, True)
add('RockMyWorld', 'http://rockmyworld.smackjeeves.com/comics/', u"The upcoming J-rock band Battle-X balances on the brink of despair. And the cause of all this mess is the vocalist Rin Kawatake, who just can't seem to get a hold of his behaviour. When another bandmember leaves the band for the fifth time this year, the bandmanager puts his last hope into the new guitarist, named Teika Yoshida, the guy who just could be the solution to all of their problems! But not only that.. Because when they meet for the first time, Rin immediately seems to take a very special interest into this cute guy... YAOI/BL!!! :3 Updates whenever I have time, usually a few times a week", False, True)
add('RoyalIcing', 'http://royalicing.smackjeeves.com/comics/', u'AVAILABLE IN PRINT AT AMAZON.COM! Look for "Royal Icing Graphic Novel". Synopsis: When little Emily bakes a cake, she gets more than she bargained for. Strange flora and fauna, a cold-hearted prince, and a mystery that must be solved before she can return home from the Sucre Isles. What adventures await her in the land of curious candies?', False, True)
add('RozeFighter', 'http://rozefighter.smackjeeves.com/comics/', u"The year's 2310A.D in the happenin' city of San Francisco several power hungry teens search for the 9 Rainbow Crystals. Join the Magical-Girl,slice-of-life adventures every Thursday and Saturday. Warning: Strong language and booty! Follow us on tumblr: http://roze-fighter.tumblr.com/ Find us on Facebook: https://www.facebook.com/RozeFighter?ref=hl LGBTQ comic~", False, True)
add('RubyNation', 'http://www.therubynation.com/comics/', u"This is the story of Ruby Harrison, former middle-upper-class American high schooler turned nine-foot-tall post-human person of mass destruction. Dragged into a worldwide conspiracy that treats human beings as mere test subjects, Ruby's goal is to create a safe haven for her fellow post-human victims. But their powers are too valuable for the world to let be, and Ruby and her comrades will have to make hard decisions to preserve her new home.", False, True)
add('RubyRed', 'http://rubyred.smackjeeves.com/comics/', u'', False, True)
add('RuderiQuest', 'http://ruderi.smackjeeves.com/comics/', u'Four kids confront a school full of demonic teachers!', False, True)
add('Rumplestiltskin', 'http://rumplestiltskin.smackjeeves.com/comics/', u"Chris knows there's something out there better for her. She's young, cute, downtrodden (in her opinion) and orphaned; How can she not be destined for greatness? When the chance to prove her worth comes along, she can hardly turn it down... Just a pity the only person she gets for company is a mysterious obnoxious masked fellow who just can't seem to leave her alone. Updates Tuesdays and Fridays. Or alternatively, support me by reading the more rapidly updated version on Manga Magazine- http://www.mangamagazine.net/manga-and-comics/Rumplestiltskin/detail-page/1781?lang=en", False, True)
add('RyakLo', 'http://ryak-lo.smackjeeves.com/comics/', u'', False, True)
add('RyuManwebcomicversion', 'http://ryuman-web.smackjeeves.com/comics/', u'Seven original one-shot manga by Zen Migawa, done as school assignments during his study abroad period in Tokyo from 2009 to 2013. (Read right to left!)', False, True)
add('SChIzO', 'http://schizophrenic.smackjeeves.com/comics/', u"Hector never seems to want to leave Ruby alone. He's always there, bugging her and tracking her every move and she can't stand him much longer. Of course...she has to learn to live with it seeing as he isn't going anywhere. Afterall, he IS just that little voice in her head. Join the schizophrenic Ruby, her mute best friend and roommate Kenneth, their eccentric neighbor Lynn and a whole cast of oddball characters as they try to live through the everyday trials of moving out and living on your own...despite being a little messed up in the head.", False, True)
add('SFCForestofDreams', 'http://sfcforestofdreams.smackjeeves.com/comics/', u'A strict, megalomaniacal lioness. A egocentric, muscular vampire. A sarcastic, antisocial eraser. A surprisingly sane blob. A small, mute pikmin. An optimistic, friendly green thing. A stubborn, determined mouse. A curious woman from the future. A meek, brilliant scientist. A calm, fatherly fighter. A serious, taciturn war veteran. A crazy, hyper girl. A confident, eager architect. A savvy, sly chimpanzee. A frustrated, busty teenager. A sad, lonely emo. A fangirlish, lovestruck fairy. A dominant, genius octopus. A loud, grumpy senior citizen. And a sadistic, creepy alien. Who will win the $1,000,000 grand prize?', False, True)
add('SLightlyabOVeavErage', 'http://slightlyaboveaverage.smackjeeves.com/comics/', u'Keiko Tachibana is an average High school girl. Scratch that. She\'s a self proclaimed "Slighty above average" High school girl who has dedicated herself to being only moderately better than the social norm. However one day she gets a visit from someone Way over the top. An inter dimensional cutie whom goes by the name Llla-Elac Ngtholi Cllegogg, also known as "Laila" to humans. She has come to destroy the sanity, and lives of everyone at Daisuke Ryuzaki high school. However, poor Keiko seems to be the only one at school whom has noticed this terrifying beast, and to make matters worse, she\'s staying at her house!! Will Keiko be driven insane by the ramblings of this terrible alien and her Slightly above average lifestyle tossed to the wind? Or will she succeed in defeating this strange alien menace!? Find out in this incredibly odd web comic inspired by the works of H.P. Lovecraft!', True, True)
add('SONOFSAM', 'http://sonofsam.smackjeeves.com/comics/', u"Walter Cohen hates his school, but in the words of the great Dee Snider: He's not gonna take it anymore!", False, True)
add('SOSRadio', 'http://sosradio.smackjeeves.com/comics/', u'WORKERS WARNING, CONTAINS MUSIC PLAYER "Set at very low volume, Lyrics warning" 50.5 The Sounds Of Survival Apocalyptic Radio "Because it\'s never to late to liberate!" A web-comic of sound, music, and a quest for creative freedom from an entertainment starved tyrannical monarchy where anyone with the gift of art and self expression are not only hunted but enslaved. Chainsaw Adam\'s, a lone pirate radio dj travels a post apocalyptic wasteland broadcasting a message of rebellion. Calling to the abstract souls and the free spirits, he inspires those in hiding from the powers that be to rise up and fight back to create a new society built on the stuff that dreams are made of. "CLIFF-NOTES FOR NEW VIEWERS" After breaching the city walls of Tulsa, Chainsaw finds Rockette, the sister of the woman he seeks "The Girl with Green Eyes" AKA (Quill). Ready to venture to the prison to rescue her, the two find themselves confronted by re-animated robots bent on destruction. Can Chainsaw\'s abilities as a \'Natural\' save them!? WHY READ? Read BEFORE we become popular. THEN when your friends start reading too, you can say "Hey I\'ve been reading for years, suck it!', False, True)
add('SPOON', 'http://spoon.smackjeeves.com/comics/', u'A evil wizard turned Charles\' whole town turned into a kitchen (that\'s right). Cursed with the body of a SPOON, he has embarked on a journey to find the wizard and along the way, he will meet other "cursed" ones. UPDATED MONDAY THROUGH FRIDAY.', False, False)
add('SailorMoontheEnemyNextDoor', 'http://sailormoontheenemynextdoor.smackjeeves.com/comics/', u'A manga version of my Fan Fiction of the same title, art work by Karolina Romanska. The past comes to the present yet again, and the Sailor Scouts shall be called upon once again to put down the latest threat to the safety of Earth, with a new member to the team to help them along! To find the threat, they will not have to look far.', False, True)
add('SaintforRent', 'http://saint-for-rent.smackjeeves.com/comics/', u'Saint runs an inn for Time Travelers, which leaves him little time to write his trashy romance novels. Unfortunately, he also happens to attract more... supernatural "guests," too. [Animated .gif webcomic] Redirects to main site --> http://www.saintforrent.com', False, True)
add('SaintsCalling', 'http://saintscalling.smackjeeves.com/comics/', u'*Please go to the "About" page for a full description. Thanks :)* An ill-tempered girl gets her life flipped up-side-down when her best friend abducts her in an attempt to straighten her out a bit. Little does she know...her friend is an alien king from another planet?! A Scifi Shoujo! (Rated T for Teen. Read from left-to-right. Currently in sketch comic mode until further notice)', False, True)
add('SakuraDAY', 'http://sakuraday.smackjeeves.com/comics/', u'She lived then died and resurrected once more. Join Meija as she meets the strange and mysterious (and oddly interesting) people of LALA dormitory and starts her new adventure in a world strangely familiar but entirely new. P.S. this comic is read in the "manga way": RIGHT TO LEFT. UPDATES WEEKLY { Saturday || Sunday } Enjoy~', False, True)
add('SakuraMishzo', 'http://sakurazo.smackjeeves.com/comics/', u'An original gekiga set in Sengoku Period and featuring the strange relationship between the warlord Nobunaga, his valet Ranmaru and the ninja Mitsubachi.', True, True)
add('SalemUncommons', 'http://salemuncommons.smackjeeves.com/comics/', u"In a hidden corner of Salem MA stands the Salem Uncommon boarding house...It was purchased years ago by Karl (formerly Dr. Frankenstein's nameless monster), and has since attracted every manner of ghoul, ghost, goblin, and monster (as well as a few odd humans)...If you like your humor a little dark but good natured, like the Addams and Munsters of old, stop by. Salem always has room for more Uncommons...", False, True)
add('SallySprocketAndPistonPete', 'http://ssnpp.smackjeeves.com/comics/', u"A novel-length tale, set in the Steampunk-ified Wild West, that follows the adventures of a daddy-daughter duo (except the daddy's an android inventor and the daughter's a cyborg of his handiwork...)", False, False)
add('Sandbox', 'http://sand.smackjeeves.com/comics/', u'Welcome to .:Sandbox:., or just plain "Sandbox" for those of you who dislike the extra dots. Enjoy your stay, because you\'re never leaving. Until you do. We can\'t stop you from leaving or anything.', False, True)
add('Saywhatyoumean', 'http://saywhatyoumean.smackjeeves.com/comics/', u"A comic pulled out of the freaked up author's subconscious. humor and pain, philosophy and non-sense,love and violence and sexy things, based on real events or completely fake, who knows what the next update will bring", False, True)
add('SchoolofRejectsSoRe', 'http://sore.smackjeeves.com/comics/', u"Have you ever wondered what happens to the characters that DON'T make it into the stories? There is a place where rejected, unfinished, and imperfect characters can go to study, play, and talk to each other. A place that an ordinary girl has stumbled upon... This is the School of Rejects.", False, True)
add('Scorch', 'http://scorch.smackjeeves.com/comics/', u'"Looks like the kids of Sludge-High really should have skipped school today." Rated \x91bizarre\x92 for: monsters, zombies, cannibalism, school girls, unrequited love (with a vengeance), government conspiracy, chocolate bunnies, angels vs. demons, all that with a limb or two to spare. Not making any sense? It\x92s not supposed to! So grab a shovel and kick back for one hell of a nightmare.', False, True)
add('ScrappedProject', 'http://scrappedproject.smackjeeves.com/comics/', u'This is a simple tale of what happens when ideas get discarded and go looking for their purpose in life. Told through the eyes of a robot. ~Journey Completed~ (thanks for reading ^.^)', False, True)
add('SecretPowerbk1', 'http://secretpower1.smackjeeves.com/comics/', u"Since the begining of time... There's been a power to control all... It's been locked away, and kept a secret... Until now. Jump threw time, control magic, and learn from a new world known as Spartelia. -Author's note- I created this book, about three-four years ago. i was younger and my art style isn't the best, but i have more that are better. But i'm sure the story will be better than the artwork. ~ Enjoy", False, True)
add('SecretPowerbk2', 'http://secretpower2.smackjeeves.com/comics/', u"book 2, please enjoy book 1 and 2, and if your reading this for your every first time, I wouldn't if I were you, because nothing would make sence, read book 1 first before reading this book.", False, True)
add('Seed', 'http://seedcomic.smackjeeves.com/comics/', u'A fantasy story about three individuals in a time of war against magic. Written and illustrated by Julia Philip http://www.seed-comic.com/', False, True)
add('SenoireDelirium', 'http://senoiredelirium.smackjeeves.com/comics/', u"Omnibus of Senoire Delirium 1: Conquer (2007) and Senoire Delirium 2: Rivalry (2009). Updating almost daily. The Senoires were a team of legendary heroes who saved the world and created the magical Madness Pizza Slices. Generations later, a race of candy people took over the world and humans were moved to the artificial internal planet known as the Bernoulli 2. A woman raised four boys to become the next generation of the Senoires and her timing couldn't be better.", False, True)
add('SeriousTimes', 'http://serioustimes.smackjeeves.com/comics/', u"Let's get serious...", False, True)
add('ShacklesInstallment02', 'http://shackles02.smackjeeves.com/comics/', u'After escaping badly wounded with her target captured, Kas loses conciousness and crashlands on an alien planet. Captured by a tribe of the native aliens, Kas is forced to work together with Otakaog Phimosh, her own prisoner, and she starts to suspect he knows a lot more about her than he should...', False, True)
add('ShamelessAdvertisements', 'http://advertiseat.smackjeeves.com/comics/', u"Ever made a comic that none notice? But do you think the comic would be very successful? Well, you just gotta advertise somewhere, maybe a multi-author comic, but that'll annoy other authors. NOT ANYMORE! In this comic, you can post as many advertisements as you like! Show others your comics, and watch comics from others! That way, everyone will be able to read the latest comics! Please only place advertisements for comics here. So no fillers, no bios, no spritesheets. Don't forget to add a link towards your comic profile in the comments section below the ad! We request that you read the rules & guidelines section if you haven't done so already. Please don't be negative about comics in the comments, no one wants their ad to look bad. For those interested: Last author count: 483 authors (August 8th 2013)", False, True)
add('ShapeshifterAtaleyetuntold', 'http://shapeshiftermanga.thewebcomic.com/comics/', u"It's the year 2012, Planet Earth All has changed... Nothing is as it once was... in the year 2000..., religions expected the end to come.. other people walked about oblivious to what will happen... the end..? In truth.. it couldn't he further from the truth... 2000.. something did happen... what happened..? Skies.. opened up.. foul souls picked up one by one.. took us as hosts.. fallen.. angels.. demons... took our bodies.. It was not the end... it was a new.... hurtful.. beginning.. The people chosen as the hosts of these bodies.. created a new race.. a race of warriors with godly powers and vitality... This race broke out in a day.. and shook the very foundations of the world... they were called.. OUTBREAKERS It's been 12 years now... humans are not in control of our world.. The outbreakers are now.. leading our world", False, True)
add('ShiteWeveHeardBefore', 'http://swhb.smackjeeves.com/comics/', u"We've all heard the story. One person falls for another but they can't be together. Same shit, different day. But this...we'll go about in a different way. Just a note: There will be NSFW moments throughout the comic. The majority will not come til later chapters but small bits here and there in the first few.", True, True)
add('ShotoutofCanon', 'http://akumathfs.smackjeeves.com/comics/', u"Shot out of Canon is the new direction for the former Fallout Shelter Comics. Like the Fallout Shelter Comics, it'll be about the forums (and sometimes comics) I go to. Unlike the former Fallout Shelter Comics, this will deal with things besides there. And unlike that, it won't be Canon with my Main Comics. Formerly: My Fallout Shelter Comics I do for the Fallout Shelter: http://z1.invisionfree.com/forums/The_Fallout_Shelter/index.php?act=idx", False, True)
add('ShowcasimusMaximus', 'http://allaboardthesteamtrain.smackjeeves.com/comics/', u"KURONA, FLUTTER AND LYLA SPAM TIME, FOXPUFF SPRITE AND SPAM, LE SPRITE DUMP, PROBLEM WITH STARLO, DUB'S STUFF BIN, AQUA'S SPRITE HOSTING PLACE...THINGY, ZERO'S SPRITE TEST GROUND, THE REALM OF PUNCHY, AND TTLY NOT A RIPOFF MERGE TO FORM SHOWCASIMUS MAXIMUSSSSSSSSSSSS Scar's here too say hi scar To put in simple terms, this showcase is basically Reidy's for lower-tier spriters. There's chapters for us because there can be and Kurona loved organization. This description is my bitch now. Kitsu is going too sing for you now. YALYALLYALDJFASLKNKADNNDNADSKHANKAC *Applause* No shipping though. That's for Love Harbor, also sponsored by us! *SHAMELESS PLUG* -Syogren. Don't forget the cheese. Nor the muffins! :3", False, True)
add('ShroudofLight', 'http://shroudoflight.smackjeeves.com/comics/', u'Shroud of Light takes place in a world enshrouded in darkness, following a Young Lumin hunter Mina, who on a routine hunt discovers something that could change the world as she knows it', False, True)
add('Signifikat', 'http://signifikat.smackjeeves.com/comics/', u"Life's but a walking shadow, a poor player That struts and frets his hour upon the stage And then is heard no more: it is a tale Told by an idiot, full of sound and fury, Signifying nothing.", True, True)
add('SimonSues', 'http://simonsues.smackjeeves.com/comics/', u"Simon, once brilliant law student at the prestigious Haversford Campus, now finds himself council for those in need of representation against the occult. It's the age old Faustian tale, but this time, Faust has a killer lawyer. ************************************************* WARNING! -Main Comic (Not BL) contains horror and graphic violence. -Bonus Comics contain sexual content/BL. Updates Monday, Wednesday, and Friday! ************************************************* *Check out my tumblr to see process pages and random sketches! http://simonsues.tumblr.com/ You can now read Simon Sues on MangaMagazine.net (http://www.mangamagazine.net/manga-and-comics/Simon-Sues/detail-page/221) and on Manga Fox! (http://mangafox.me/manga/simon_sues/)", False, False)
add('SimpleBear', 'http://simplebear.smackjeeves.com/comics/', u'Bear Copenhagen is just a simple bear and nothing else. Spoiler: Not for long. Simple Bear is an action packed, supernatural thrill ride that uses words like this in the summary to make people want to read it. Also this comic features cartoon animals, not "furries." Just thought I\'d throw that out there. Updates 2-to-3 times a week', False, False)
add('SimplySarah', 'http://simplysarah.smackjeeves.com/comics/', u'This is the story of a young lesbian girls pursuit to follow her heart against all the problems that face her.', False, True)
add('SinPararse', 'http://sinpararse.smackjeeves.com/comics/', u'This is a mirror of http://sinpararse.skyscrapersoup.com It updates every friday. This site is updated in a batch every few weeks. Sin Pararse is a prequel to my other comic, but you can read either of them independently. It follows Gabry and Liam, two popular side characters and details how they met and got together.', False, True)
add('Skeptical', 'http://skeptical.smackjeeves.com/comics/', u'A regular slice of life/death romantic comedy about an unusual family and their relations to a group of creatures that call themselves "skull people". Said human family(and half the comic itself) was created by and belongs to TyrannicalShipper! Warning- there\'s an abundance of foul language, and blood. Lots of blood, including the first page. Also, constructive critiques are always appreciated! Currently updates every four days.', False, True)
add('SlashMaximum', 'http://slashmanga.smackjeeves.com/comics/', u"SLASH (SOUL LINKED AEGIS SUPPORTING HEGEMEMONY), is a mysterious power that prevents a person from being harmed or killed, an enhancement for combat and is used to enforce authority among the weak. It can determine one's social superiority to one who possesses it. Not all may have it. Alizeti ekilore, a rich innocent girl from Trifang mansion, suddenly discovered she has it since she survived a strong explosion that killed all her family. Now that she had survived and obtained such power, Alizeti decided to pursue the murderer of her family using her SLASH. Clash, a veteran slasher(SLASH user), will help Alizeti use and strengthen her SLASH in order to find the culprits. Will they succeed in getting justice for Alizeti's family if the killers are the government's strongest Slashers? Will Alizeti and Clash be able to fully understand and utilize their SLASH to counteract their pursuers? In a society where SLASH enhancement and slashers are made, Alizeti and Clash will experience the inevitable. latest chapters here>> http://www.mangamagazine.net/manga-and-comics/SLASH/detail-page/75", False, True)
add('SlipstreamSingularity', 'http://slipstreamsingularity.smackjeeves.com/comics/', u'350 years have passed since the first and only mission beyond Human Occupied Space was launched. In search of the alien intelligence that sent such wondrous knowledge back to Earth, the Odyssey mission was lost. Now, denied their own home world by the rebellion of their own children creations, the Synthetics, humanity has become a race of despots and wanderers that meander through the stars, eking out an existence. Updated Tuesdays and Saturdays.', False, True)
add('Smashandfriendsshowcase', 'http://smashshowcase.smackjeeves.com/comics/', u'This a a showcase in which any spriter can join. Here you can post: Sprites Pixel art Character bios Cool effects Short comics Memes Ads And More! So Join TODAY!! And now, for some quotes from the authors: Smash: sprite! Pocket_Ninja : ......WHO ARE YOU PEOPLE?!?!?!?!?! Luxbot: EFFECTS IS A NECESSITY FOR ME. :< CamTro: No effects for me to sprite and speak as in same time! ~\xe0\xb2\xa0_\xe0\xb2\xa0~ Sspeedo th: I try to sprite but effects and comics work betta under the microscope. Drago: Spritin epic style. A-A-A-A-A-A-AAAAA- *shot*', False, True)
add('Snippets', 'http://snippets.smackjeeves.com/comics/', u'Snippets is a Compilation of Short Stories!', False, True)
add('SoManyProblems', 'http://somanyproblems.thewebcomic.com/comics/', u"'If the XKCD guy was retarded' Single panel comics about life, love, alcoholism and dick jokes. Updates Mon/Wed/Fri", False, True)
add('Somesprites', 'http://tonzofsprites.smackjeeves.com/comics/', u'', False, True)
add('SomethingLikeaPhenomenon', 'http://somethinglikeaphenomenon.smackjeeves.com/comics/', u'All kinds of love in mid 90s fictional NYC like city. Vampires and other supernatural things included. Updates Wednesdays, unless otherwise specified.', True, True)
add('SongoftheButterfly', 'http://songofthebutterfly.smackjeeves.com/comics/', u'- Little Rim Marie is drawn into another world hidden just under the surface of reality and discovers her self-worth. She is caught in the middle of the eternal struggle between Light and Shadow.', False, True)
add('SonicAuthorAdventII', 'http://saa2.smackjeeves.com/comics/', u'TEH CHAT IS BACK. Dont forget to space between your sentences.- Mr. Jack If you\'ve come to SAAII thinking "Oh my god- another author comic!"- Never fear. this one is the ORIGINAL AND FIRST author comic. Well, it\'s prequel, SAA, run by mostly the the same people, was.-Rikco the Robot Random post of death and doom. ~ Ryan We demand cookies! ~ Shin Guess who\'s back and fluffier than ever! ~ Shard Oh Praise the mightly Lords of the Laziness ~Jayh TEAM JINJO PWNZ YOUR SOULS! AND IM BACK! -2021 Run around for all I care! I have me my flying ceiling! HA! ~Slash Beware the newness! ~3000', False, True)
add('SonicBoom', 'http://sonic-boom.smackjeeves.com/comics/', u"Rules: 1. No random images that have nothing to do with the comic. 2. No content over PG-13. 3. Excessive trolling is prohibited. Some minor jokes are fine, but don't take it too far please. 4. If you're gonna give criticism, be constructive! No blatant insults! 5. Homophobia is also undesired.", False, True)
add('SonicClub', 'http://sonicclub.smackjeeves.com/comics/', u"****RETIRED/DEAD/COMPLETED**** The Characters: Sonic Shadow Amy Tails Knuckles Rouge Capuchino(me) Nikomy(Capuchino's girlfriend) Lola(Capuchino's little sister) Lanz(Capuchino's older brother) Andry(I made him up... he's just a Shadow android) Xavier (Xevious) Degreenfreak Miles-XD(Just Miles) Stochi The Vampire Chao Crackuchino The Hedgehog Crazy China Crappuchino Ghost the Echidna(inlove with Knuckles.. XD) Green Darkness Flame the demon hedgehog Glandor the hedgehog and his brother cendar the fox", False, True)
add('SonicSchoolRedo', 'http://sonicschoolredo.smackjeeves.com/comics/', u'THIS COMIC HAS BEEN MOVED TO CRAZY R US.', False, True)
add('SonicUniverseAsk', 'http://sonicuniverseask.smackjeeves.com/comics/', u'HI THERE! Do you read Sonic: Universe, or Sonic Universe- Sides?... No? WELL! Would you like to learn about it? n...no?... AH WELL! Here you can ask the characters anything you wish! And they will answer as they please! Probable Spoilers for the Main Comic', False, True)
add('SonicWorldAdventures', 'http://sonicworldadventures.smackjeeves.com/comics/', u'Sequel/Spin-Off to Metroid Prime: Altina Through a series of unforunate events, Sonic the Hedgehog has found himself in the past with diminished intelligence and memory, and must complete all his previous adventures to create a Synch Nexus, and fix a space-time rip threatening to destroy... STUFF. Previously called: Sonic World Adventure Created by S of Team Dark Nexus! PG Content!! Daily updates!!! (Hyoxjnn and I are currently in Year 12 so we will be missing updates from time to time, but we will catch up within a few days)', False, True)
add('SoulGuardian', 'http://soulguardian.smackjeeves.com/comics/', u'How far would you go...to get home alive? Ren has been kidnapped, and sent to the future. Upon her arrival, a strange cloaked young man finds her. On hearing her circumstances...he offers to help her, for a price. READ: Right to left UPDATES: Wednesday', False, False)
add('SouthernCross', 'http://southerncross.thewebcomic.com/comics/', u"This a webcomic about a bunch of hopefully amusing people known as the eight state capital cities of Australia. Southern Cross is a moe anthropomorphization comic - in the vein of Hetalia, Afganisu-tan and the OS-tans to name a few - featuring Sydney, Melbourne, Brisbane, Canberra, Hobart, Darwin, Adelaide and Perth. It's about their relationships, their rivalries, their teamwork, their personal tragedies, and the fact that they're all, at heart...a little dysfunctional. Primarily a comedy (or at least trying to be), you don't have to know anything about Australia for this. Hell, you don't even have to care about Australia either. And maybe you'll learn a thing or two...but don't worry. It's not that kind of educational. Updates when I can!", False, True)
add('SovereignTheMostAmazingComicEver', 'http://mostamazingcomicever.smackjeeves.com/comics/', u'Sovereign is the most amazing story ever told about an extremely boring boy, who is fortunately kidnapped by sky pirates. Updates Tuesday and Thursday! Please give our website a second to redirect you.', False, True)
add('SparElricsextras', 'http://sparextras.smackjeeves.com/comics/', u"Just a bunch of random shit that I wanna put up. :P Such as sprite-sheets, W.I.P.s, drawings and more! :D BTW, if you have a problem with that, just click the BACK button and leave. I do NOT tolerate trolls/assholes. Thank you! <33 Also, you're welcome to join in on the fun if you so choose! Just PM me!", False, True)
add('SparkStory', 'http://sparkstory.smackjeeves.com/comics/', u'"INSPIRED BY ABBIMAYS RANDOMNESS (now Void Misadventures, go there while you\'re on the internet)! AUTHOR RULES: 1. AUTHORS MUST UPDATE AT LEAST ONCE EVERY MONTH. If you won\'t be able to update, please PM me saying why, and you\'ll be pardoned if I believe your reason is valid. 2. SWEARING IS WRONG. It\'s okay if you censor it, but this is a rule that I expect to be followed in comics, comments, and chat. 3. TREAT OTHERS WITH RESPECT. I don\'t care who you are or what you said, BE NICE. If you were joking around, I\'ll understand. Any violation of these rules will result in a warning. Three warnings, no matter what the combination, and you will be kicked with an explanation why. You will have one oppourtunity to rejoin, but that will be it. Otherwise, that\'s it. Be safe and have fun. ~Melody-Pika, manager can we still puts things here mels ~Kurrokurro', False, True)
add('Spellcross', 'http://spellcross.smackjeeves.com/comics/', u'In the City of Aria, the last great capital of the world, life revolves around mysterious dungeons and the monsters that crawl from them. Adventurers gather from the world over to battle in these dangerous labyrinths, seeking the fame and fortune that comes from exploring them. Follow Caldwell the Alchemist as he strives to raise himself up the ranks of adventurers, to gather a party of friends, and to overcome his fears. Updates three times a week on Monday, Wednesday, and Friday!', False, True)
add('Spidersilk', 'http://spidersilk.smackjeeves.com/comics/', u"Ah, Kalviva! A bright, bustling city. It's a crossroad for trade and all kinds of people have made their way there. Sometimes ... very strange people. Kalviva is also home to the biggest, most impressive thief system. Prentice, following his exiled brother from the north, stumbles into one such cell (much to the embarrassment of his guildmates) and begins his journey to becoming a thief. His attempts to cast aside his strict warrior training are often fails. But it's better than the alternative. Doing merc board requests wasn't always glamorous. Well ... if ever. Updates twice a week, Monday and Friday! Fantasy/ Comedy/ Drama/ Action/ Adventure/ Romance", False, True)
add('SplitPoison', 'http://splitpoison.smackjeeves.com/comics/', u"Aranya is an ambitious woman. At age 24 she's already the head--and founder--of the local mafia. When she stumbles into a one Takana Damashii Witzbold, she decides to take him on as a side project; to shape the young man into something useful. But Damashii's own goals, sparked to life by the chance presented to him by Aranya, may be much higher than to be just the asset of another. As Damashii draws to his side a wide collection of interesting (and invaluable) companions, he may become a match for even Aranya. Mafia, spiders, very tall men, very crazy men, very girly men, very dominant women, horses with fangs, glasses, a tad bit of fabulousness, circus tents. If any of these offend you, you probably shouldn't read this.", False, True)
add('SplitScreen', 'http://splitscreencomic.smackjeeves.com/comics/', u"Jan Lumeneski and Jeremy Tanner were inseparable best friends from childhood through high school, but Jan wanted more. When things didn't go her way Jan vowed never to speak to Jeremy again. More than a decade later a chance meeting puts the pair together again, but a lot has happened. Jan is a successful fashion designer while Jeremy is now fat and depressed. Still Jan can't help but feel that old flame burning, but is she just going to end up back where she started?", True, True)
add('Spriterschaos', 'http://spriterschaos.smackjeeves.com/comics/', u'random things happen everyday', False, True)
add('Sprytts', 'http://sprytts.smackjeeves.com/comics/', u'---COMPLETE COMIC--- For the past few hundred years, the two great countrys, Carvia and Gloomland, have been enemies. While Carvia, land of the Sprytts, is full of wonder, delight, and magic, Gloomland, land of the Gools is full of demons, nightmares and violence. Blado, a royal guard to Queen Mellaba, is in search of the mysteries behind his past. Not long after he and three other royal guards encounter the princess, they get caught up in the middle of this international conflict.', False, True)
add('StampedeJessicasStory', 'http://www.stampedethewebcomic.com/comics/', u'Youth crime is on the rise in England as the gap between social classes increases. Resulting in an increase in street "gangs." To tackle this problem the government made a plan to reform these unruly teenagers by giving these youths an incentive. Which was providing them with their own housing and "pocket" money but only if they study a course of the government\'s choice, stay out of trouble and attend classes as often as necessary. A quick fix to a very complicated problem. {Stampede:~} Jessica\'s story is about a troubled angry girl stuck under one of the government\'s incentives and her empathetic classmate named Ryam who befriends her. But as Jessica slowly falls back into street gang culture, Ryam also finds himself falling in with her as he tries to help her to stop. Deep into a downward spiral of fight clubs, hatred and gang rivalry. Will both of them get out of it alive or will it end tragically? Is there any hope for a hurt and struggling youth? Has some mature themes and swearing. Based 100% on real life, in my hometown in South London. Its an urban street comic. Updates: Depends. 3-4 pages every week/couple/few weeks max.', False, True)
add('Stay', 'http://stay-comic.smackjeeves.com/comics/', u"Stay is a comic I started in 2008 and I'm just now uploading it in 2012 >_>; It is a Yaoi comic Description: Lee is just an ordinary dude, he's very studious, studies on the weekends and does well in school, but then he meets Jude - a punk guy with streaks in his hair, piercings and tattoos -- his total opposite! Jude is a mysterious guy with a mysterious past that for some reason wants to be all over Lee the nerd, and as he makes his moves hy-jinks ensue!", True, False)
add('StellaInChrome', 'http://stellainchrome.smackjeeves.com/comics/', u'Lost in the rubble at a condominium development lies a key that unlocks more than doors. Can Stella unlock the mystery that surrounds the key itself? Updated 8:00 PM CST each Wednesday, every Wednesday.', False, False)
add('Storyofadamnedlove', 'http://storyofadamnedlove.smackjeeves.com/comics/', u'A typical love, nothing out of the ordianary, just a vamprie and the to be Devil of hell, nothing unusal about this.', False, True)
add('StrangersandFriends', 'http://hemu.smackjeeves.com/comics/', u'The small English town of Wootton Bassett begins to be haunted by a series of mysterious and horrific murders! Hemu, a new-comer to the town, becomes an obvious and easy target to the local community- he does have his fair share of secrets! But what secrets are the other locals hiding? A comic about the peculiar prejudices and customs of small communities, with a hint of social commentary on modern Britain, and a sinister splash of horror ;)', False, False)
add('Strangetimes', 'http://strangetimes.smackjeeves.com/comics/', u'this is a different challenge instead of having regular starter pokemon the main character black first pokemon is mew. updated ever other day', False, True)
add('Striped', 'http://striped.smackjeeves.com/comics/', u"'Altan Silvan is a new transfer student at this highschool. And he's already this popular! But there is something weird about him- he always wears a scarf! Hey, wait, maybe he has a flu... WEll, what's more, since he became one of our students, strange things started to happen at this school! Hey... What's with this blood?! Where's everybody?! Hello?!!' Updated irregularly. Edit: This is my first comic ever, so art is changing and improving (at least I think so xD) with each chapter. WARNING: This comic contains nudity, violence, gore, swearing, because that's how life is.", True, True)
add('SubjecttoChangeCollegeWoes', 'http://subject-to-change.smackjeeves.com/comics/', u'Erin and her friends are about to embark on the greatest test on life and their friendship, going away to college. The five girls will have to survive the tests of roommates (egads!), college tests, and new relationships. Through it all the girls will find out if their friendship can really outlast the world of College Woes.', False, True)
add('SuburbanFreeflow', 'http://suburban-freeflow.smackjeeves.com/comics/', u'That Comic!', False, True)
add('SunmeetsMoon', 'http://sunmeetsmoon.smackjeeves.com/comics/', u"This is a story about a boy and a girl who met in the summer and fell in love. But the end of the summer parted them for a long time. The meeting again wasn't as happy as they expected... Between them stand a lot of differences.She being a loner, attracted by witchcraft and some serious supernatural stuff. He being a sociable fellow with a childish behaviour. But most of all he having a new girlfriend ;) The story has four parts, each one made in a different year: 1. The Riddle ('07) 2. Marg's revenge ('06) 3. Who's that girl? ('07/'08) 4. Passing by Midnight ('08/'09)", False, False)
add('SuperDimensionAfterTheHero', 'http://afterthehero.smackjeeves.com/comics/', u"Updates once every weekend. (Mondays count as weekend.) Super-Dimension comics are just the name I give all my superhero comics. This has no relation to any other Super-Dimension comics. Dennis Lockham was Paladin. A guardian superhero of L.A. But now his powers are gone. He's just a man. And that is the one thing he can't take on. Rated 12+ for *&%$'ed cussing, and violence. Neither of much, though.", False, True)
add('SupermassiveBlackHoleA', 'http://smbhax.smackjeeves.com/comics/', u'Stories of a human civilization at the center of the Milky Way galaxy: an area of space dominated by a gigantic black hole, where energy is abundant and life is cheap. Updates M-F, usually multiple times per day.', False, True)
add('SurvivorFanCharacters', 'http://sfc.smackjeeves.com/comics/', u'Fan Characters will be competing for $1,000,000.', False, True)
add('SwitchMechanism', 'http://switchmechanism.smackjeeves.com/comics/', u'A story about a boy struggling with his demons, mainly the one in the vinyl catsuit.', False, True)
add('Symbios', 'http://symbios.smackjeeves.com/comics/', u"Almost every nation in existence has a tale of terrors and hauntings to pass on to their posterity... Xedondria is no different. Their tale was to keep children from doing wrong, and if they behaved, their reward was to sleep with a clear conscience. But if they didn't behave, not only would they suffer the consequences from man, they would also be visited by the Night Horror: a monstrosity only nightmares could bring, only living in one's sleep... Now one must ask: who is it that sleeps, yet suffers the torture of this very real Horror? ***Comic will be marked mature due to any violence or themes, Thank you!***", True, True)
add('TCWFireRedNuzlockeedition', 'http://tcwfirered.smackjeeves.com/comics/', u'Mewtwo completly destroyed the hidden village of the angels in Kanto. One angel survived the disaster. A girl, Sarachan (or sara). Mewtwo let her alive and challenge her to battle him at Cerulean Cave. But first of doing that, Sara should challenge the Gym and the Elite 4. She accepted, but will she make it until the end?', False, True)
add('TEN', 'http://ten.smackjeeves.com/comics/', u'Two years ago our two main characters jumped from a cliff to escape from a life of confinement and torture. The life of a human guineapig They jumped into a unknown future, a unknown destiny... and maybe death. But both of them survived and now, two years later, they meet again...', False, False)
add('TH3D3AD5H0WCA53', 'http://thedeadshowcase.smackjeeves.com/comics/', u"In this show case it is our goal to have every kind of comic shown manga, anime, sprite etc for critique. So here you can advertise and show your comic pages for critiquing the art, layout, special effects, and style of the comic. There will be 5 sections to this comic. The Art section. A place to review, critique, to get help, and show off art work. The Comic section. A place to review, critique, show off comic pages, and to get help. (not the whole comic just individual pages for review on layout and such) The Advertisement section. That one is self explanatory. The Special effects section. A place to get help, tips, and critiques on custom special effects. And The sprite section. A place to review, critique, show off and get help on sprite work. Anyone and everyone is welcome to join. And sadly there are a few rules (TALKING TO YOU TROLLS LOL) Inappropriate content in either comments or other posts will be deleted. Swearing is allowed as long is it isn't offensive, and remember. Critique and help, not troll. Anyways that is all so enjoy!", False, True)
add('TLAAOK', 'http://tlaaok.smackjeeves.com/comics/', u"Percival Livingston may not entirely look the part, but he is one of the world's leading experts when it comes to authenticating rare artifacts. Thus, he is invited by a private collector to take a look at a rather strange find. However, before Percy is able to get a good look at the object, it is stolen by a thief! Oh hell no! Percy chases the man down, but is sucked into another world when he collides with said thief as he happens to be opening an inter dimensional gate! Now Percy has to deal with the thief, get the artifact, and find a way back home! Of course, knowing Percy, he may just want to do a little exploring in between... Warnings: -It's bl. SilverHyena may have an addiction problem... hmmm... -It's rated mature, because I plan on being a bit... tasteless. Yeeees. -It's on crack. Don't expect anything too serious. XP", True, True)
add('TM47APokemonSilverWebcomic', 'http://tm47.smackjeeves.com/comics/', u'Aaron Asher has just stepped out on his Pokemon journey after a long period of eager preparation to become a Trainer. Nothing could have prepared him for what lies ahead. Be sure to drop by https://www.facebook.com/pages/TM47/398816296840162 for up-to-date information and updates about the comic, including backstory, plot hints, and even sneak-peek releases on upcoming comics!', False, True)
add('TPRPManga', 'http://tprpm.smackjeeves.com/comics/', u"Elizabeth Rodenberg is an eighteen-year-old first-year college student on her way to her apartment with groceries when she hears a voice in an unknown language out of nowhere. She's always known she was a little crazy. But before she can even dismiss it as a hallucination, Liz is suddenly very far away from home - and laying before the soon-to-be Hero of Twilight. There she meets a short Californian girl named Lita, who is equally confused and out-of place. Brought to Hyrule by an unknown person, for an unknown mission, Liz and Lita struggle to understand their situation. They find that Link is more cold and unwilling than they remember, that Midna is more paranoid and irritable, Zelda, more cryptic and distant; and the true reality of what the two girls think they know has yet to fall upon them. Their reckless actions have consequences. Their newly forged friendship will be tested. All for Link. Maybe in the end everything will be worth the struggle. Contains: Corniness, awkwardness, sexual frustration, nerdy references, one-liners, somewhat coarse language, violence, blood. Processed in a plant that handles nuts. Updates weekly. Sometimes more than once.", False, True)
add('TPTruePower', 'http://truepower.smackjeeves.com/comics/', u'A fun comic about friendship, aliens, and flashlights! Updates: Saturdays Visit us on Facebook: https://www.facebook.com/truepowercomic', False, False)
add('TRIPP', 'http://tripp.smackjeeves.com/comics/', u"The story of an ordinary guy stuck in a never-ending acid trip. Tripp must learn to cope with his new psychotropically enhanced existence with the aid of his spirit guide, Edgar Allan Poe. This comic is not an endorsement of drug use, merely one guy's effort to deal with an accidental, perpetual hallucinatory life change. Updates on Mondays (really Sunday night at 11:45) and Thursdays See the official site at http://trippcomic.com", False, True)
add('TaikiTheWebcomic', 'http://taiki.smackjeeves.com/comics/', u"FINISHED! Taiki is a typical shy 16 year old high school student who is starting the 10th grade with her best friend Nikki. Going into the 2nd half of high school, Taiki thinks it\u2019s strange that she has never liked someone or fallen in love. One day she unexpectedly meets someone who changes all of this. However this person turns out to be a girl! Taiki has always wanted to know what it was like to fall in love, but what she didn\u2019t expect was that finding out would also be a journey of self discovery, realizing her sexuality, and maybe even heartbreak. -IMPORTANT!!- This is a mirror of my own website, check it out if you want to see more artwork --> http://www.taikiwebcomic.com/ This comic was started in 2006, so the art in the beginning isn't very good compared to what it is now. This story contains GL and HL, it is MOSTLY GIRL LOVE THOUGH.", False, False)
add('TakingPicturesofStrangers', 'http://darrenandkale.smackjeeves.com/comics/', u"Darren lived the charmed life of barhopping before he met Kale. It was a new guy every night, lots of drinking, lots of sex, etc. But when he snagged big, quiet Kale, Darren uncovered Kale's secret and set into motion a series of events that lead them both down a path no one expected. Warnings: first and foremost, very gay. Gay romance, gay sex, gay gay gay. If this isn't your cup of tea, you probably shouldn't bother continuing reading. Second, the occasional bad word. Third, booze. (Does booze require a warning? It's not underage drinking or anything.) Fourth; drama and cheeze out the wazoo. Fifth and final warning; very badly drawn. (And probably badly spelled, too.)", True, True)
add('TeKscloset', 'http://tekchats.smackjeeves.com/comics/', u"TeK's mind and friends. You're god is now forlorn.", True, True)
add('TeamOblivionsSpriteGalleryandMisc', 'http://osgam.smackjeeves.com/comics/', u"Oh im sure you've seen plenty of these. Basicly I post my sprite edits and such for the world see and as a precaution if my computer failed and I lost all my data, of which I would that blow my computer up (since I hate it already) to little computer bits.", False, True)
add('TeamShapes', 'http://teamshapes.smackjeeves.com/comics/', u"There's a team of MS paint creatures that do random events that include fighting Paint.net, rescuing a monster, getting eaten by it, running from a guy who they owe $500 to, doing missions, stopping a time stopping machine, and simply fooling around. Current chapter: Pizzanonoalofisicadoimmahatanio has created something and is probably trying to get his money back. Roup has become some kind of mutant with multiple fonts and Bulk has to do something without Roups guidance.", False, True)
add('TechnicolorLondon', 'http://technicolorlondon.smackjeeves.com/comics/', u"Toby Landon's love life is a bloody mess.His on and off girlfriend has once again tossed him aside. His mate Mark gives him some advice: Try something different. With a kiss, the lives of these two friends go from being black and white to being full of vivid color. No longer a checkerboard, This is Technicolor London. //Yaoi/Boylove Plus a little bit of everything else// //Updates are Every Tuesday & Friday//", False, False)
add('Tenwaysbendystrawssavedmylife', 'http://bendystraws.smackjeeves.com/comics/', u'an informal window into the way i saw/see life as a teenager and young adult told though the adventures of two rather ordinary kids', False, True)
add('ThatWasntThereYesterday', 'http://twty.smackjeeves.com/comics/', u'A mysterious stranger meets a mysterious road.', False, False)
add('The13thWorld', 'http://the13thworld.smackjeeves.com/comics/', u"In the galaxy known as Andromeda ruled by the Goddess Palutena; creatures known as O'phans rule the thirteen worlds and it is up to her chosen followers to save and bring peace to the thirteen planets. This is a mashup of several anime and video game worlds.", False, True)
add('TheAlliance', 'http://alliance.smackjeeves.com/comics/', u'The year is 3010... The earth has become a poisoned shadow of what it once was. The sky has stained red, a symbol of the endless wars that had emerged below. Animals mutated from the toxic atmosphere that own the lands. Mankind itself has even been mutated. For some, their DNA being matched with various animals. And others gaining different attributes from their darkening hearts. Human kind has now fled to giant toxin purified domes. But even this is beginning to become less then what they need to survive. Their minds have been polluted with evil. Darkness surrounds their hearts. Now there is only one hope........ The Alliance. Contains Violence, blood, romance... Eventually... My comic is BOYXGIRL.', False, True)
add('TheAntihero', 'http://antihero.smackjeeves.com/comics/', u"Most stories have good guys and bad. Some have only good guys, but with antagonists. Then some have only dastardly villains trying to do villainous things to decent people while all along screaming at the top of their lungs into the rain. This is one of those comics This is also a very depressing comic. Seriously. Every chapter is 'death' in a different language, and each title page is the Protagonist about to die. ... I told you it was depressing. Anyways, don't let that stop you! It takes place 20 years in the future. The U.S. has deteriorated into a kind of middle-ages scenario, where the government is corrupt, inflation rules, and the Mafia basically control the country. It doesn't get any better than that. But Isaac, the commander of the NY Mafia, notices there's a new gang in town. The Redblades. And there's something familiar about the commander... I'd rate it about 12+. There's mild gore, blood, and violence. Also comic cussing (!@#$%^& it!). And it's basically aimed at an older audiance, but if you're okay with the above, go ahead.", False, False)
add('TheAttackoftheRecoloursSeason1', 'http://mysticalvalley.smackjeeves.com/comics/', u'The Recolours are attacking and the edits will have to eliminate them. Flash, Leeroy and Kedar500 are creating the recolors and sending them out to fight but Sonic, Josephk and others who are preventing them from succeeding. Will they save the world from whatever Flash and Kedar500 are planning? Read the Seasons and find out! Comic came 13th Place in the 2013 Smackie Awards (Sprite). Oh well... Warning: Mild Language may be used *Completed*', False, True)
add('TheAvianStories', 'http://theavianstories.smackjeeves.com/comics/', u'Sybil and Zakk are a pair of mythical humanoid avian monsters called avians with spirits of birds. When they meet each other they are spewed into a quest to stop genocidal acts on humans from a rouge group of avians.', False, True)
add('TheBookofNosferatu', 'http://www.thebookofnosferatu.com/comics/', u'Two unusual sisters strive to survive a post apocalyptic world where supernatural creatures reign supreme.', False, True)
add('TheBrideoftheShark', 'http://sameyome.smackjeeves.com/comics/', u"Toshio is a pearl diver, dealing with his love problems in Onjuku. 'Ehukai is a shark, instantly falling in love with the boy and claiming him his wife in front of his family...", True, False)
add('TheBucket', 'http://thebucket.smackjeeves.com/comics/', u'An art/comic journal including a psychological side story, "ENS Special".', False, True)
add('TheCafedAlizee', 'http://alizee.smackjeeves.com/comics/', u"Eliza Jones always had a dream of opening a cafe, but met a tragic fate before she ever could. Thus, the Caf\xe9 d'Alizee was opened in her honor. This story really isn't about her, though. Instead, this story follows the interesting, strange, and in some cases eccentric staff of the Cafe d'Alizee as they wander through the trials and tribulations of life. They may not know where they are going, but they have the four most important things in the world: love, life, coffee, and cake. *Updates every Monday and Thursday.* P.S. I should also mention that because this comic deals with the lives of various people, there may be situations that include relationships of any gender combination as well as violence or sexual situations, but there will be nothing graphic. So because they are (mostly) all adults, expect adult situations to occur. :)", False, False)
add('TheClass', 'http://www.theclasscomic.com/comics/', u'The Class is a story about high school students learning to deal with growing up while being confronted with the ability to use powers and fight a growing evil. Written by Jaysen Headley and Illustrated by Jessi Jordan. For more news and info, check out our blog at www.theclasscomic.com', False, True)
add('TheColony', 'http://thecolony.smackjeeves.com/comics/', u"In the secluded hills of upstate New York, there is a place known only to few. It is a haven for all things macabre; werewolves, vampires, zombies. If you fear it, chances are it resides there. Every 300 years, a new regent is crowned, and this time you're invited to the ceremony. The Colony is updated every Tuesday, so come on back!", True, True)
add('TheContract', 'http://the-contract.smackjeeves.com/comics/', u'After a series of dreams, Starken wakes up in another world. There he meets Phalarin, a demon who seems harmless.', False, True)
add('TheDarkAgeofMobius', 'http://thedarkageofmobius.smackjeeves.com/comics/', u'It was 20 years ago that the Emerald war began. Many died. Sonic, and Eggman are but a few. There were, however, survivers. A mysterious overlord has taken over much of the world. There are those who oppose him. This is the story of one.', False, True)
add('TheDestroyer', 'http://heartless-destroyer.smackjeeves.com/comics/', u"A Shadow-cat demon named Kairo Ventaiga finds his solitude interrupted when he finds out his family isn't dead. However, he's gotten used to his deadly lifestyle and doesn't want to change... In a neighboring kingdom, Princess Nicole, a daughter of Light, doesn't want her father's crown. She is strangely sympathetic toward Shadow demons, her kind's mortal enemy. She's determined to befriend the Destroyer; perhaps she knows something Kairo doesn't... Reilyn Ventaiga only wants to find out what happened to his parents the night Kairo disappeared, but getting any answers out of his brother is looking more and more impossible... TakJak, a former thief, starts to notice that the Heartless Destroyer isn't as heartless as he seems... Updates: every Saturday with one or two pages Warning for minors: contains prevalent cursing, blood and gore, violence, and maaaybe farther down the line, partial nudity or hints at it. Also gay people. If you don't like any of the above, I'd advise against reading my comic.", True, True)
add('TheDragonandtheLemur', 'http://dal.smackjeeves.com/comics/', u'The Dragon and the Lemur is a web manga drawn by Vilani Vil\xe1 and scripted by the same and CherryVincent. In few words, a RP between the artist and CherryVincent, which Vilani decided to transform into a Manga. D.a.L (for short) tells us the story of two characters, Hakakku (a humanoid, hybrid between Cat and a Lemur) and Chain (a humanoid, dragon). They both met, probably not under the best circumstances and ended up falling in love. The script is currently finished. This comic contains explicit content and homosexual relationships. Bestiality/shota/incest may be often mentioned. May have blood and gore. NC-17 YAOI/HENTAI/YURI Update schedule: MONDAY Started: Sept 2005 Status: On going', True, True)
add('TheDump', 'http://the1dump.smackjeeves.com/comics/', u"A dumb of random pics and comics, i'll try to upload at least once a week, hopefully more.", False, True)
add('TheElectricRose', 'http://electricrosecomic.smackjeeves.com/comics/', u'What happens when three normal girls in high school are ripped straight out of their beds and brought to a completely different planet? Why, they\u2019re asked to save it, of course! Agreeing to become a Barrier Guardian could mean the lives of Elysia and her friends, but choosing not to could mean the end of their world. So what do they do? And will these three girls even survive long enough to decide?', False, True)
add('TheForestofWhispers', 'http://theforestofwhispers.smackjeeves.com/comics/', u'Kanna is a two year old she-wolf and member of the Whispers Pack. She like to run away from problems that are out of her control or hide behind someone. But this time, not even her best friend, Caleb a young wolf that seems to be in love with her, may no longer be able to save Kanna from the problems that are about to come. When a old and evil force is about to awake and just a shy and small wolf like Kanna has the power to stop it, everything will be lost? Or there will be a chance for salvation? UPDATES EVERY WEEKEND!', False, True)
add('TheGhostWithTheMost', 'http://theghostwiththemost.smackjeeves.com/comics/', u"A romance fan comic, based on the 1980's animated Beetlejuice series. Beetlejuice and Lydia were the best of friends. They did absolutely everything together and were always there for each other. So Beetlejuice never considered the idea that they would ever be separated. That is, until Lydia starts growing up and begins to call upon him less and less. Then, eventually cuts ties with him completely, leaving poor Beetlejuice lonely and confused. He remains loyal and waits for her call. 30 years later, Beetlejuice is suddenly called upon once more. But it's not his dear Lydia.... It's her daughter! But where is Lydia? Can Beetlejuice cope with why she stopped calling all those years ago? Will a romance bloom between Lydia's daughter and Beetlejuice? Find out! Read: The Ghost With The Most Updates Once a Week! ^_^", False, True)
add('TheGlassisBroken', 'http://glassisbroken.smackjeeves.com/comics/', u'The glass is not just half empty, it is broken.', False, True)
add('TheGoddamnPantyBrigade', 'http://thegoddamnpantybrigade.smackjeeves.com/comics/', u'The Goddamn Panty Brigade are a group pop punk trouble-making girls who might just be the only *PROFESSIONAL* adventurers in the music industry.', True, True)
add('TheGoldRiderofPern', 'http://goldrider.smackjeeves.com/comics/', u"I started this comic a little over a year ago, and it's been going strong ever since. Taking place in the 3rd pass of Pernese history, K'mlar, a young genius Masterweaver was placed at Ista Weyr as his first appointment after being given the station of Master. There he impresses a young Gold hatchling, an event completely unheard of in Pernese history. Despite being aggressively anti-social, he manages to make a place for himself at the Weyr that he never would have dreamed possible.", False, True)
add('TheGrayZone', 'http://thegrayzone.smackjeeves.com/comics/', u'A daily cartoon featuring the lives of extraterrestrial "grays"', False, True)
add('TheHeadhunters', 'http://headhunters.smackjeeves.com/comics/', u"It's about people trying to capture a floating head. Every Mondays, Wednesdays and Saturdays.", False, True)
add('TheInfectedWebcomic', 'http://theinfectedwebcomic.smackjeeves.com/comics/', u"Jacob and his sister Chloe fight to survive in a city paralyzed by a disease that only affects the super-human population. Follow along as they meet the heroes trying to save the city from the disease and make the shocking discovery of who's responsible for it.", False, True)
add('TheJosephComics', 'http://josephcomics.smackjeeves.com/comics/', u'What started out as "Joseph and His Comics" in 2003 became the first minimal comic strip series by amateur cartoonist Joseph Scarbrough. The comic centered around fifteen-year-old Joseph Armstrong - just you\'re typical, average, American teenager who just so happens to get himself in and out of random situations that give way to continuing storylines with serial cliffhangers much like the old "Rocky and Bullwinkle" show (which adopted said format from old movies and westerns of the 50s). In 2004, Scarbrough "revamped" the comic strips, renamed it to simply "Joseph Comics" which carried on until Scarbrough announced his retiring from comic strips, thus making Joseph and his friends find their place in the Old Cartoon Stars Retirement Home permanently come 2008.', False, True)
add('TheKeyHotelEnding', 'http://tekeyhotel.smackjeeves.com/comics/', u'Alright, the Key was fun while it lasted, but due to a lack of updates and interaction, I must shut down the Key Hotel. It now belongs to SteamingBullets Uboa. See ya!', False, True)
add('TheKwiddexProtocol', 'http://kwiddexprotocol.smackjeeves.com/comics/', u'Welcome to Satellite Falls. Starstorm has returned after a 15-year absence. So has the White Rose. Plus there\'s a monster tearing up the city. Now, it\'s up to disgraced cop Jerry Binder to find out just what the hell is going on in his city and just what the hell "The Kwiddex Protocol" means. The Kwiddex Protocol is updated every Monday, so come on back!', False, False)
add('TheLegendaryQueen', 'http://legendaryqueen.smackjeeves.com/comics/', u"Being drawn, then written out, this comic is about my character Crystal, a normal 15-year old hedgehog who soon finds out she's worth much more than she ever believed she could be. There will be love, fighting, death..friendship..and above all else, family and self importance. Journey along with her, as she becomes what everyone has been waiting for...and stays true to herself! Updates: Whenever I get pages drawn XD", True, True)
add('TheLegendaryStone', 'http://thelegendarystone.smackjeeves.com/comics/', u'A wacky and hilarious fictional story about two countries pledging war over a stone that can grant immense power for its owner. If you want to read a funny and entertaining story, then this comic is for you.', False, True)
add('TheLegendofMushroomKingdom', 'http://lomk.smackjeeves.com/comics/', u"To put it simply, this is a crossover fan-fictional graphic novel featuring the Super Mario Brothers and Legend of Zelda franchise. Mario and Zelda are the two of the most well-known franchises in Nintendo, not to mention my two favorite video game franchises. It's pretty long, so get the popcorn and drinks ready :D Characters in this story are properties of (c) Nintendo", False, True)
add('TheLegendofZeldaMaidenoftheMoon', 'http://lozx.smackjeeves.com/comics/', u"<>Set roughly 20-30 years after Twilight Princess.<> The return of not one, but two villains has a young, unwilling hero scrambling across the land of Hyrule in search of power enough to defeat them. Reluctant at first to accept his fate, tiny steps taken along with a guiding hand (or two) will help mold just the savior Hyrule needs. || Incorporates a little bit of TP, FS, MC?, and... probably a few others I'm forgetting right off the bat. Legend of Zelda belongs to Nintendo, not me.", False, False)
add('TheLessThanEpicAdventuresofTJandAmal', 'http://tjandamal.smackjeeves.com/comics/', u"NOTE: THIS IS A BACKUP. If you'd like to read this comic, please do so at tjandamal.com. The content management system I use at tjandamal.com is no longer supported, so the main site will point over here eventually. May 16, 2008 - In the span of a single day, Amal calls off his arranged marriage, comes out to his conservative parents, promptly gets disowned, goes on a bender... and wakes up the next morning to find TJ, a lanky, dreadlocked vagrant, frying eggs and singing Paul Simon in his kitchen. TJ claims that the two have made a drunken pact to drive all the way from Berkeley to Providence. As it happens, Amal promised his sister he'd be there for her graduation from Brown University. And TJ, well... TJ has his own reasons. The agreement is simple: Amal does the driving; TJ pays the way - but a 3500 mile journey leaves plenty of time for things to get complicated.", True, True)
add('TheLifeofMagFlamequill', 'http://lifeofmag.smackjeeves.com/comics/', u"The coming of age ceremony is tomorrow. Participants will take their birth-feathers and soar gracefully into the sky, cheered on by their proud friends and relatives. But what if you're Mag Flamequill, the bird-woman with a fear of heights?", False, True)
add('TheLoneSwordsman', 'http://theloneswordsman.smackjeeves.com/comics/', u"Heaven has fallen, including its Leader, Aven, thanks to the Demon King Shutendoji's new Elite Demons. Now Shutendoji has his eyes set on Earth. Can a Lone Swordsman wielding Aven's sword stand a chance against such hopeless odds? Or will the madness of the souls he must absorb destroy him from the inside? Rated PG-13 due to cartoon violence, blood and mild language. The Lone Swordsman and all related subsidiaries are property of Sol's Dawning Creations. The use of such without permission for the purpose of monetary gain is illegal and will be met with legal action.", False, True)
add('TheMegaManandSonicSpriteShowcase', 'http://megamanshowcase.smackjeeves.com/comics/', u"Credit to all the authors listed for the sprites. We do 8 bit, 16, bit and 32 bit sprites (mostly 8 bit) and Sonic sprites. WE TAKE REQUESTS. no trolling, flaming, cussing (some allowed) and ABSOLUTELY NO STEALING SPRITES AND DON'T CLAIM ANY AS YOUR OWN, unless you actually made them and your part of this showcase. *One new rule: I would like to address the fact that THIS IS NO LONGER A SHOWCASE WHERE WE POST RESOURCE SPRITES OR SPRITES WE DIDN'T MAKE! I'm gonna remove the sheets that aren't ours soon. any body else that posts anything that isn't theirs will be punished, if caught, with the following: 1st offense: a warning. 2nd offense: comment privilege taken away. 3rd offense: uploading privilege taken away Anything past the third offense will result in removal from this comic.", False, True)
add('TheMitchellEffect', 'http://themitchelleffect.smackjeeves.com/comics/', u'A typical tale of an ordinary teenager who accidentally summons a demon that eats all his snacks and smokes all his good weed. You know.....a classic :) If you like what you see here come friend me on Facebook for more goodies and funny content: Cornelius Goodfellar', False, True)
add('TheMoistTouch', 'http://themoisttouch.smackjeeves.com/comics/', u'VERY GOOD SMUT WEBCOMIC YOU SHOULD READ IT ITS GOOD 10/10 NO YAOI ONLY HENTAI', True, True)
add('TheMurderofMe', 'http://themurderofme.smackjeeves.com/comics/', u'UPDATED SUMMARY: Sonic, after disappearing for five years, returns to his home, friends, and mother. However, he not only finds that his friends have fallen apart, but his mother is being targeted by an evil, supernatural entity with evil intentions.', False, True)
add('TheMythofRemedy', 'http://mythofremedy.smackjeeves.com/comics/', u'7 paths, 7 destroyers, 1 destiny. Evil is stirring in ancient Europe and will soon envelop the entire world. Only a band of orphans and outcasts stand between the world and oblivion.', False, True)
add('TheNaziandtheStoner', 'http://thenaziandthestoner.smackjeeves.com/comics/', u"There's a little of each in all of us.", False, True)
add('TheNightSurfers', 'http://thenightsurfers.smackjeeves.com/comics/', u'When the coastal city of Costa Nueva is threatened by sand creatures sent by a mysterious evil, four teenagers rise from tragedy to become heroes. They are The Night Surfers. Read it here at Smack Jeeves, or get even more content and the most recent updates at thenightsurfers.com!', False, True)
add('ThePirateBalthasar', 'http://thepiratebalthasar.smackjeeves.com/comics/', u'Wilson Kane wins a fortune and his future bride at a game of dice from the former pirate Balthasar. When he decides to go and get the girl, the pirate way, by kidnapping her, not only he finds out that she is more than a pirate could ever want from a wife... but that she has 4 identical sisters as well. This discovery hits him when his men, who were supposed to help him out, each kidnaps a different girl... and none of them gets the right one! But Wilson Kane wants the girl he had met and no one else! Luckily for him it will be the girl herself to solve his problem and put an end to his dilemma... a solution that will eventually fling her into a new way of life, aboard the Alidivento, across the Mediterranea sea!', False, False)
add('ThePremise', 'http://thepremise.smackjeeves.com/comics/', u'The Premise is a story about two policemen that find one of the members of "The Executioner\'s Sect", that some time ago begun to murder people that deserved punishment, using brutal force.', False, True)
add('ThePrincessandtheGiant', 'http://princess.smackjeeves.com/comics/', u'A silent fairytale about a young princess and another, rather larger individual. Updates Sundays.', False, True)
add('ThePropertyofHate', 'http://tpoh.smackjeeves.com/comics/', u'A voyage.', False, True)
add('TheProtector', 'http://protectorcomic.smackjeeves.com/comics/', u"A story about a boy and his protector. Set in the country of Senobia, a young boy is set on the path of destiny. His companion is one of the country's most celebrated heroes. What adventures awaits the two of them? Started in 2008 and continued in 2010. This is not a BL, it contains little to no sexual scenes at all, this is an adventure story. If you want porn linked to this story (only between adults of course), then please feel free to read my companion story, Sacrifices. Updates Sundays http://sacrificescomic.smackjeeves.com/", False, True)
add('TheRandomObscureFairyTaleNoOnesEverReallyHeardOf', 'http://tro.smackjeeves.com/comics/', u"Yeah, so I ran out of characters for the title. Trust the banner. 12-year-old girl Wolfgang Rock manages to convince her mom to let her stay with her ex-uncle-in-law-in-law instead of having to move. Soon enough, however, the said uncle, Dieter Jung, starts to have an innocent crush on the girl... This was the first full-length comic I ever did. Don't mind the amateur art and the fact that its unrealistic story could only be written by a child (indeed it was) and the JPEG fuzziness and and and... *COMPLETED! *Reads left to right *Not suitable for impressionable young girls/adult men with developing complexes *Nothing inherently inappropriate, either *The original comic before He Who Has Partners, which apparently takes place in an alternate universe", False, False)
add('TheReborn', 'http://reborn.smackjeeves.com/comics/', u'Every teenage girl looks forward to her sixteenth birthday, and Angela is no exception. But on that day her life turns upside. Angela learns a stunning secret about herself, and finds herself caught up in war between two demon clans. Updated Mondays and Fridays. This comic may not be suitable for younger readers. It may contain violence, gore, occasional bad language and other stuff that may not be appropiate for readers under 13.', False, False)
add('TheSilverLeague', 'http://thesilverleague.smackjeeves.com/comics/', u'The Silver League is a comic based around the members of the site of the same name and placing them in our own interpretation of the Pokemon World. Silver August of Harvestone Town is a teen that never really knew life outside his hometown; however after rescuing his Sister from the hands of Team Reaction, Silver becomes motivated to explore the world as a Pok\xc3\xa9mon Trainer! However on his journey, Silver discovers that behind the battles he\'d watch on TV lies corruption because of devices known as "Modifiers" that allow a Trainer to alter a Pokemon\'s stats by force without having to earn them through training. This leads Silver and the friends he makes along the way to form "The Silver League Movement" which vows to travel the region, collecting badges but also recruiting Gym Leaders and convincing them to join their cause so that they can form a league of their own, take down the Team Reaction organization and bring honour, fun and hard work back to Pokemon Battles! http://www.thesilverleague.com/', False, True)
add('TheSixthBar', 'http://thesixthbar.smackjeeves.com/comics/', u'The war between Del-Naaj and Saam-Sara has ended, but Nero knows otherwise. A false peace has been created by the Del-Naajan fear of the Saam-Saran psychics. Torn by the death of his close companion Lynn, Nero has trained for the past six years, sharpening his skills so that he may better protect his city. But a plot is brewing: a plot that will rekindle hostilities between the two cities.', False, True)
add('TheSomewhereOther', 'http://somewhere-other.smackjeeves.com/comics/', u'Who would have thought fitting into such a weird world would be so hard.', False, True)
add('TheSpritersShowcase30', 'http://thespritersshowcase3.smackjeeves.com/comics/', u"Welcome to the third installment of the spriter's showcase! RULES 1.Give credit for any and all sprite sheets. 2.Treat all other authors with respect. Critique is fine. Flaming isn\u2019t. 3.Stick to a posting schedule. (Whatever works for you. Just don\u2019t post one thing and go missing for a month.) 4.No adult content. 5. No recolors or very easy edits are to be posted, this rule is only in place to keep you from getting flamed/trolled. Recolors are looked down upon in this comic. 6. Spriters must have at least some experience with sprites before applying to join. If they do not, their application will be denied. 7. Flaming, spam, and arguing in the comments will not be tolerated, and will be deleted. If you have any questions, concerns, or suggestions, drop a PM my way. -Noland", False, True)
add('TheStoryWithNoName', 'http://cityofdepression.smackjeeves.com/comics/', u"#TW:Self Harm Have you ever died repeatedly because of a misunderstanding and a plot to take over the world? Conner Has. Now lets see where the streets of Depression takes us. (SWNN is a big learning opportunity to discover the rights and wrongs in comic design as well as composition, coloring, and stylistics. As the aesthetics of SWNN progress further in the story so will the personalities of the characters, so please pardon their blandness, predictability and plain boring nature. I promise you they will become not lame dumbfucks further on. The Story with No Name is a BIG complex creature that I've designed to teach very personal lessons on how not to be a huge dick.)", False, True)
add('TheSummerofBlakeSinclair', 'http://blake-sinclair.smackjeeves.com/comics/', u"A slice of life comic set in the summer of a student's university life. about hipsters, Punks, and ultimately self reflection and 'honesty'. This comic is Apparently what you would call a 'social comedy' and a sattire on generation Y. loosely based on my recently passed student experiences =) Hopefuly this comic will remind you of summer when you read it; enjoy!", False, True)
add('TheTalesofSerendipity', 'http://talesofserendipity.smackjeeves.com/comics/', u'Serendipity is the phenomenon of finding wonderful things you were never searching for. With that said, join the herd into the land of Equestria and beyond, seeing the intertwining lives of the ponies who live there.', False, True)
add('TheThanatosComplex', 'http://thanatoscomplex.smackjeeves.com/comics/', u"What if you only had a month to live and could do whatever you wanted with no consequences? That is the question posed by Allen Pearson, the protagonist of my graphic novel, The Thanatos Complex. This documentary-style, realist story in the visual style of Alex Maleev and the film A Scanner Darkly, is comprised of images from the final months before Allen's planned suicide. Allen, a high-powered California mortgage broker, is thirty-one years old and seems to have it but he knows that his life is actually a monotonously boring and, ultimately, meaningless. Determined to give his life meaning, if only for a little while, Allen embarks on a freewheeling journey of self-destructive hedonism. Will Allen manage to turn his life around before he closes the book forever? Told through the lens of a documentary crew and increasingly delusional vision, The Thanatos Complex ponders the darkest recesses of the human soul and examines that most basic of questions: Why are we here?", False, True)
add('TheTimeDog', 'http://timedog.smackjeeves.com/comics/', u'Ayaka travels through time with "the time-dog". A strange and weird story :)', False, True)
add('TheWhiteTower', 'http://thewhitetower.smackjeeves.com/comics/', u'Cotton has no memory of who he is. He just woke up from a seven month coma. His hair is completely gone. And no one is telling him anything. A sci-fi/mystery/drama comic. Warning: partial nudity, some violence and cursing.', False, True)
add('TheWinterCampaign', 'http://winterc.smackjeeves.com/comics/', u'Japan, 1919. 16-year-old Akio and his mother move into a new home with the mysterious Kikugawa family: A secretive father, a fragile and reclusive son, and the shadow of a mother whose death years ago may be more than it appears. The lines between truth and fantasy, and friend and enemy begin to blur as winter sets in... Drama/Historical/Coming-Of-Age/Romance? Contains angsty teenagers, Taishou-era geekery on the part of the author, and some BL. Updates once or twice a week.', False, True)
add('TheYoshiHerd', 'http://theyoshiherd.smackjeeves.com/comics/', u"A comic about a young Yoshi, and his efforts to become a hero. To evolve, become something more than he was meant to be; little does he know, more people than he alone depend on this. I swear, it's better than it sounds. Not by a LOT but it IS. The Yoshi Herd. Wish I could say it's updated weekly - so I decided to start updating weekly! Every Wednesday, usually late at night - Australian time anyway - point is, there's roughly a six hour window every Wednesday where you might see it pop up. But, uh, keep it on the down-low. People might start EXPECTING it to update. As if it was MAKING A COMEBACK or something. So this? This is between you, and me. If you tell anyone - look, just don't tell anyone. You don't wanna know, capiche?", False, True)
add('TheZeroSpriteTestgrounds', 'http://thezerospritetestgrounds.smackjeeves.com/comics/', u'This is where all the magic gets tested.', False, True)
add('Theatrics', 'http://theatrics.smackjeeves.com/comics/', u'A weekly movie review comic, starring two ruthless critics who will bash a different cinematic release, both new blockbusters and obscure classics, every week. By Itamar Katz', False, True)
add('ThehumanBEing', 'http://thehumanbeing.smackjeeves.com/comics/', u'"A story about friends and enemies; love and hate; forgiving and forgetting; holding on and letting go. A story about being human, and being MORE..." Follow the story of ten friends as they survive college, friendship, love, and life in general. No matter who we are, what we know, or what we believe, we are all HUMAN. Updates: Tuesdays Reads left to right', False, False)
add('TheiaMania', 'http://theia-mania.smackjeeves.com/comics/', u"My own take on Greek mythology. Join Hermes, Hades, Persephone, Athena and the others as they try to deal with themselves, their complicated family and those strange humans. NEKYIA: A journey down to the Underworld. A philosopher and a necromantic priestess enter Hades' realm to find the answer to the question what a good life really is. At the same time, the messenger god Hermes arrives with a message to Hades... DADDY'S GIRL: Athena is miraculously born from her father's head. She's stronger and more intelligent than most people, but deep down she is just a confused child who tries to understand herself, her family and the world around her. This story takes place long before the events in NEKYIA. HERO BONES: A short story about Hermes, love and fossils. Has some mature content, but nothing too explicit. Takes place after NEKYIA DESTROYER OF LIGHT: Tells the story of Persephone and her life with her mother, the harvest goddess Demeter, before she became the queen of the Underworld. Snakes, flowers and dark secrets. Has some mature content. Updates usually once a week.", False, True)
add('ThelaughingDeath', 'http://thelaughingdeath.smackjeeves.com/comics/', u'When Leyr was a little boy, he was taken from the head of the business organisation "Ligth" - River, who forms him for purposes of the organization to a perfect assassin. But for many reasons, with the passing years, members of the organization get more and more terrified of Leyr. In the end, they decide to kill him ... "Please read from right to left! ^^"', False, True)
add('Themadman', 'http://themadman.smackjeeves.com/comics/', u'everyday insanity, taking what life throws at you just a notch further to show what could happen^^ updates once a week', False, True)
add('ThiefCatcherRingTail', 'http://tcringtail.smackjeeves.com/comics/', u"RingTail is the hero name of the main character, Lynia, who is actually formally a thief! After her family is arrested she is hired by her rich, genius classmate Rose to test out her superhero inventions. Together, they stop thieves and uncover the sinister plot of Arcadio, Lynia's former employer. This comic reads Left to Right.", False, True)
add('ThinkBeforeYouThink', 'http://thinkbeforeyouthink.smackjeeves.com/comics/', u'A funny, awkward, and spontaneous comic about a guy who can read minds. Updates Fridays.', False, True)
add('ThisistheWorstIdeaYouveEverHad', 'http://twiyeh.smackjeeves.com/comics/', u'TWIYEH! is a an urban fantasy comic about idiots with magic powers and also there are monsters and stuff. This is a mirror of the main site located at http://worstidea.skyscrapersoup.com which updates every Monday and Wednesday. I batch update over here every 10 pages or so.', False, True)
add('ThornTopia', 'http://tnt100.smackjeeves.com/comics/', u"Thorn is reknown for her alts. This a showcase of all the ones she's got! This series is now completed! Many thanks to all the contributors and followers for sticking around!", False, True)
add('ThornsComic', 'http://thornscomic.smackjeeves.com/comics/', u"Isabella's life changes when she meets a centuries-old cursed vagabond prince from another world. Suddenly she is pulled into the curse and demons that control his life. Will she believe in the truth of fairy tales in time to help him? Updates every Sunday. Thorns updates a page ahead on it's original website www.thornscomic.com", False, True)
add('TinyPinkRobots', 'http://tinypinkrobots.smackjeeves.com/comics/', u'Featuring me, my beatnik lumberjack husband, mild cat torture, dancing and the occasional tiny robot. Updates Monday & Wednesday!', False, True)
add('TitleUnrelated', 'http://www.titleunrelated.com/comics/', u'The Newest Iteration.', False, True)
add('TotalDramaSurvivor', 'http://totaldramasurvivor.smackjeeves.com/comics/', u"We're bringing back some of your favorite Total Drama contestants for a chance at another million dollars! Who will win? Who will lose? Find out here... on Total Drama Survivor!", False, True)
add('TotallyCrossover', 'http://totallycrossover.smackjeeves.com/comics/', u'There are a lot of typical generic gaming webcomics out there. This one, however, is not one of them. Where most comics are fully happy to parody the gaming world one game at a time, Totally Crossover will parody them all. At the same time. The gaming stars of 2010 unite to face an unknown enemy which could destroy all of time and space itself. This should be fun.', False, True)
add('TransUMan', 'http://transuman.smackjeeves.com/comics/', u'Mutants. Aliens and Zombies, Oh My! It starts simply enough: another day of survival. But then...', True, True)
add('Transfusions', 'http://transfusions.smackjeeves.com/comics/', u"Boy meets a vampire. What happens when they get to know each other? This comic will have lotsa boylove stuff in it, so if you have a problem with that, get rid of that problem and then come back here and enjoy the comic. If you don't have a problem with BL then... enjoy the comic anyways!<3 Updates every Sunday.", False, True)
add('TroubledWatersAnEmeraldNuzlocke', 'http://troubledwaters.smackjeeves.com/comics/', u"Thrown into the midst of a terrible disaster in the Pok\xe9mon world, KK must get to the bottom of the mystery - before it's too late. Lives are at stake, the world of Pok\xe9mon is falling into ruin, and the team has to try and find out where the Nuzlocke disease came from. Only danger lies down that road, but that's where destiny leads. Of course, because Professor Birch asked him to do it, he's got to take a Pok\xe9dex with him too. Go figure. _______________ Updates every Monday at 00:00 GMT.", False, True)
add('Troublenextdoor', 'http://troublenextdoor.smackjeeves.com/comics/', u"Ilona hates her new neighbor! Sure he might be a tall, athletic, motorcycle-riding hot model kind of a guy but he's snarky and rude. Just like the jocks in school that used to make fun of Ilona because she was a nerdy tomboy girl. And did he say something about Ilona's panties?! This means war! Ilona wants him gone, right now! Because he's a horrible person...but wait, he actually has a kind side? ...and how come he's always helping her out when she's in a pinch? this is...(you guessed it!) a BOYxGIRL romance sprinkled with a lot of humor and a few tearjerking moments. Hand-drawn, scanned and screentoned.", False, True)
add('UglyPeoplesClub', 'http://upc.smackjeeves.com/comics/', u"Lesley, finally a high school freshman, is a pretty girl with an ugly temper. One day, while skipping class with her only friend, she's caught and given detention. But instead of an after-school punishment, she finds a small group of really ugly students, known as the Ugly People's Club. And they want her to be their leader. **This is an American comic; please read left to right!** UPDATES: This comic updates EVERY Friday, with occasional Monday/Wednesday updates. ;)", False, True)
add('Uglygame', 'http://uglygame.smackjeeves.com/comics/', u'so takumis had a crush on his teacher mr. asakura (who he lovingly call sensei) for a long time now, but there are these dumb games that the girls play to see who can get a specific teacher to fall in love with them first, then dump them afterwards. and asakura\u2019s next in the game. not only that, but this kid satoru, whos always bullying takumi, is getting in on the game too and according to everyone hes in the lead. takumi knows what a little shit satoru is and doesn\u2019t want sensei to get hurt, and basically gets tricked into playing the game too. now hes gotta get sensei to fall in love with him before its too late. plots based off scramble game (it made me so mad I thought I could do it better HA) reads from left to right bl/yaoi will have nasty stuff later on~~', False, True)
add('UnicampaLapis', 'http://ual.smackjeeves.com/comics/', u'A vida universitaria transformada em manga!', False, True)
add('UnicycleofViolence', 'http://unicycleofviolence.smackjeeves.com/comics/', u'A webcom romcom spamtacular on horse back with robots, lies and explosions* *warning, product may not contain any of the following: romance, spam, taculars (of any kind), horses, robots, robot-horses or explosions.', True, True)
add('UnityCircuit', 'http://yurimecha.smackjeeves.com/comics/', u'An anime/manga inspired comic that blends the yuri (lesbian romance) and mecha (giant robots) genres. The only thing standing between humanity and an alien invasion are Mecha called Behemotic Constructs. Violet is a new pilot and finds out that the girl she had a crush on in school is now her copilot. WARNING: Some pages contain nudity and explicit content.', True, True)
add('Vacan7', 'http://vacan7.smackjeeves.com/comics/', u"Django is living with his younger brother in the heart of the big city named Los Perdidos. He's been stuck in a limbo between being a policeman and being a detective for a while now, and he finds himself falling for his new trainer and partner. On top of that Django starts to see and hear things others can't, and hopes his odd behaviour won't get him in trouble. Six voices seek the seventh, Django. Are they here to help or harm him? Updates Thursdays. Contains m/m. Mature: Occasional swearing and half naked dudes.", True, True)
add('VampireFetish', 'http://vampire-fetish.smackjeeves.com/comics/', u'A crossdressing vampire hunter takes on OCD vampires in modern London, all the while trying to break into the writing business using the name of the girl he was accused of murdering years ago. YA Graphic Novel: Urban Fantasy (Other Genres: Action, Comedy, Drama, Fantasy, Horror, Supernatural) ----------------------- Read full chapters online monthly @ Manga Magazine Online! http://www.mangamagazine.net loomcomics.com', False, True)
add('VerloreGeleentheid', 'http://verlore.thewebcomic.com/comics/', u'"Verlore Geleentheid" is \'n wetenskapfiksie strokiesprent wat hom deur van die ouer wetenskapfiksie soos "All the Way Back" (Michael Shaara) en "Die Oorlewendes" en "Ruimteskip Celeste" (albei deur Johan Bredell) laat inspireer. "Lost Opportunity" is a sci-fi webcomic which is inspired by older SF like "All the Way Back" (Michael Shaara) and "The Survivors" and "Spaceship Celeste" (both by Johan Bredell). It is in Afrikaans. The English version is here: http://lost-opportunity.thewebcomic.com/', False, True)
add('Vermilion4', 'http://vermilion4.smackjeeves.com/comics/', u'English version of Cynobrowa4 A story about Amelia and her troublesome "family". There\'s also a bit about magic and true talents ;) Polish version: http://cynobrowa4.smackjeeves.com/', False, True)
add('Virus000', 'http://virus000.smackjeeves.com/comics/', u'Rei, a 15 year old student, has to switch to a new school because of an accident he caused at his previous one. Rei knows there is something wrong with him because everytime he\'s angry, any living thing he touches gets mysteriously ill. On Rei\'s first day at his new school, his bad luck lands him a detention and he ends up injuring himself on some misplaced equipment. Harumi, a girl in Rei\'s class, attempts to help him but backs off after seeing his wound heal itself before her eyes. Rei, not wanting to have this discovery spread, and not wanting to move schools again, decides that his only option is to make a deal and keep a sharp eye on Harumi, even if stalking is necessary. But, even with Rei\'s efforts to keep his ability secret, somehow people find out about it... These people call themselves "viruses" that have the intention to harm Rei for being the "one of immortal blood". Due to the constant attacks, Rei and the friends he meets along the way search to find answers about Rei\'s past and why these "viruses" are after him. *** FB: https://www.facebook.com/virus000manga {READ RIGHT TO LEFT} >Shounen >Updates every Wednesday and Saturday :D', False, True)
add('VoidMisadventures', 'http://voidmisadventures.smackjeeves.com/comics/', u"Quotes ------------------------------------------------------- Alexini: GAAAH! SPARK! Y U TOOK MAH BUCKET?!?!?!?! :C \\_/ Burey: By the name of Daucaus, I shall EAT those cookies! Carbon: i brought a fake gun to school and i didn't get suspended i'm so hardcore Dry: Doctor Robotnik's deadly speed traps Firekitty: Meow. *coughs up burning hairball onto something flammable* Gigi: You've gotta tell me when you turn on the mic, ok? Wait, it's already on?! HOW COUL- Jason: cavestorycavestorycavestorycavestorycavestorycaoeocirvgiarbvrsvoefssr Lucas: (oo) Spark: *gets burning hairball coughed onto hair* AAAAAAAAAAAAAAAAAAAHHHH *grabs Alexini's bucket and pours it on self* Tater: crossing of the animals: fresh foliage", False, True)
add('WHATaboutSHADOWS', 'http://was.smackjeeves.com/comics/', u'Charlie is a relatively normal teenage boy, who enjoys hunting supernatural creatures with his homemade "ghost-tracking-device" in his spare time. One day he meets a strange man, who has lost his cane. Charlie then decides to help the man find it, which was probably the worst decision he ever made. Updates Mondays (or Tuesday sometimes whoops).', False, True)
add('WakeEcho', 'http://echo.smackjeeves.com/comics/', u'After an encounter with a soul-stealing shadow, Arial sets off on a journey to reclaim what he has lost. However, his task is much more complicated than he bargains for, and he quickly begins to learn the consequences of wandering into the dark...', False, True)
add('WantedDeadorDead', 'http://wanteddeadordead.smackjeeves.com/comics/', u'Two greedy undead bandits cause havoc in the wild west until one day a misterious little girl in a weird outfit hires them in order to help her father. Demons, monsters and wild west action! Beware of violence and foul language. Read L-->R Updates: Wednesday and Friday. Comment plz! :3', False, True)
add('WeAreGolden', 'http://wearegolden.smackjeeves.com/comics/', u'"We are not what you think we are, we are golden" (Mika, We are Golden 2009) A story of self-discovery, sexuality and relationships. When Olivia Barclay was forced to move from her high class private school to a scummy comprehensive it felt like the end of the world. But it was only the beginning... (God, anyone want some wine with that cheese? I\'m really no good at taglines!) Warning: contains examples of British humour. If there\'s any slang you don\'t understand, just ask :) Also, yaoi, yuri, het and any other kind of relationships you can think of. Updated Wednesday and Sunday. Mostly.', True, True)
add('Weaponry', 'http://weaponry.smackjeeves.com/comics/', u"A life of piracy on the high seas of Uphelios is as dangerous as it can be rewarding - in more ways than one. For the enlisted youths of Weaponry Academy, there is one ultimate goal - to gain the Captain's Seal and thereby obtain a pirate ship of their own. Competition amongst an all-male crew make tensions and temperatures rise. Choose Your Weapon! Follow Arrow, Blade and Gun as they strive to come out on top in this colourful yaoi adventure. By voicing your opinion on how events should unfold, the readers shape the relationships and outcomes possible between our protagonists. VERSI\xd3N ESPA\xd1OL: http://weaponry-espanol.smackjeeves.com/ VERSION FRAN\xc7AISE: http://weaponry-francaise.smackjeeves.com/ Nederlandse Versie:", True, True)
add('WelcomeBackToTheLandOfForgottenMemories', 'http://wbttlofm.smackjeeves.com/comics/', u'A surreal comic that takes place in New York city and the dream world of CommonFictura, a world created by a boy named Jacob White.', False, True)
add('WelcometoFreakshow', 'http://welcometofreakshow.smackjeeves.com/comics/', u'The audience roars, the acrobats and performers provide them with a spectacle unrivaled in all of Europe. The lights die, and the audience is now the entertainment for the apathetic circus. As blood and bone rush to the surface, one man leads the troupe downward to the darkest ring of all. Welcome to the Freakshow. //Updates Every Friday//', False, False)
add('WelcometothePCA', 'http://welcometothepca.smackjeeves.com/comics/', u'Pokemon Combat Academy - where fighting is your schoolwork! Timid little Cyndaquil Hirohiko Rangoku has to square off against a monster of a delinquent for his Combat mid-terms! Not only must he conquer his fears, he must also contend with a little battlefield drama, too! Loosely based off the FurAffinity/DeviantArt art-and-RP community of the same name.', False, True)
add('WestburyDetectives', 'http://westbury.smackjeeves.com/comics/', u"After his ex-girlfriend's accident, young Manhattan investigator Jack Arthur is transferred to an independent detective agency in Nassau County. At the same time, up-and-coming mob boss Pinhead Miyamoto is determined to avenge the murder of his adopted father. As the violent attacks on detectives and civilians increase, Jack is thrown into a violent rivalry with Miyamoto, finding he may be the only man able to keep the village from falling apart... Updated unevenly. Warnings for violence and mild sexual situations.", False, True)
add('WhatAboutLove', 'http://whataboutlove.smackjeeves.com/comics/', u"Takao has had a secret crush on his classmate, Hisoka, since he first entered high school. Now it's Takao's last year and he figures it's now or never so he does the crazy thing and confesses. Much to his surprise, Hisoka agrees to be his boyfriend. Takao is in pure bliss... until he realizes Hisoka has different aims. While Takao wants an actual relationship all Hisoka seems to be interested in is, well, physical stuff. So now Takao has to figure out a way to make Hisoka see him in a different way, but that's not easy since other men (realizing Hisoka goes that way) have taken an interest. Can Takao fend off potential rivals and get the guy he loves to love him back while facing all the other drama that comes with high school? Probably not, but that won't stop him from trying! Warning: - This is a Yaoi comic. I think that should be self-explanatory, but that means man on man action.", True, True)
add('WhatHappensinCarpediem', 'http://whic.smackjeeves.com/comics/', u'a comic by Piggy Ho Ho Welcome to Carpediem, the world of the massively popular MMORPG. When Naoto and Chris set out to find a strong attacker for their party, Kurogawa is not quite what they expected... *This is a BL story*', True, True)
add('Whatisdeepinonesheart', 'http://ones-mindt.smackjeeves.com/comics/', u'loosely translated: " inner feelings /what is deep in one\'s heart" The one that devoured the Eceshion bible holds the source to the worlds survival; Those who are being destroyed and those who are now conquering. Take heed that the one who devoured such a powerful book needs to know how to control it or it will cause destruction to all living beings. Claim it as your own, but don\'t let it sit forever unclaimed, for in the end one must decide what is more important, the ones close to you, our survival or the one we are omitted to care for. contains: boys love, cross dressing, monsters,vampires, animal people all around dementedness. NOTES: (Posting because it is a collaborative comic with Dani) 1. the comic was drawn back in 2009, so the art is a bit wonky till it catches up 2. The comic content does contain yaoi, However, due to smack jeeves rules and regulations: that content WILL NOT be seen on this site. The yaoi version of the comic in full will be seen on a Tumblr. this version is the version that contains black out pages and currently redrawn to contain version without Yaoi. 3. posting will be daily till it\'s caught up to the latest page: 1 page a day.', False, True)
add('WhenSheWasBad', 'http://whenshewasbad.smackjeeves.com/comics/', u'For every story about a hero, there is a "bad guy". Only, this story isn\'t about the hero. It\'s about the smart-alec, tough-as-nails villain. About her fights, her triumphs, her losses, her lackeys... And maybe her love life. If she can ever get the guts to ask the girl of her dreams out. (contains mostly yuri/GL and a bit of background het...Beware of foul language. It\'s mostly rated "mature" for violence and cursing. Sort of like an extremely f-d up reverse version of a magical girl story.) Read L->R, western style. For now, due to my work schedule, updates will be on either Sunday or Monday, sometimes both. This is subject to change, since my schedule/days off changes every few months. A lot of the shading from Interlude 1 and #13 done by Jovat. <3 Sidenote... This comic is not for horny guys hoping to see "HOTT LESBO ACTION ZOMG!!!11ONE" Yes, the main character happens to be a lesbian. But this story is about the plot, not "porn".', False, True)
add('Whenweweresilent', 'http://silence.smackjeeves.com/comics/', u'Two girls with different pasts, problems and ambitions - one future and one friendship.', False, False)
add('WhereaboutsOfTime', 'http://wot.smackjeeves.com/comics/', u"Inuyasha (c) Rumiko Takahashi Kagome Chronicles-Whereabouts of Time(c) matsujun4me aka Catherine Fermin Sukujou & Renkayasha(c) matsujun4me So this is my story: Whereabouts of Time or WOT for short. The full name is really long: Kagome Chronicles-Whereabouts of Time. I forgot to write the date I actually started this, but I believe that it was in June 09, 2009. This is actually the first comic that I post to the public. I've done others but they're old works. So this is more practice for the future. This is a story more based on Kagome and her adventures three years after defeating Naraku. I don't write much of the story itself here cause once you see the first page, you'll see the description. The cover pgs didn't come out so good. But the story will be better, I promise. There will things that are not expected.", False, True)
add('WhiteHeart', 'http://whiteheart.smackjeeves.com/comics/', u'"Lady Love received a magical book of the dark powers to her hands, and summoned a great, divine spirit. The spirit promises that Lady can make one wish, if she catches all the eight special albino souls and brings them to the spirit. Greedy Lady accepts the mission, and so the bloody collecting of albino humans begin... White is a tough and intense young man from the streets. He has been running away from Lady ever since when Love killed his gang and beloved. White is thirsty for revenge, but can do nothing but run away from Love and her henchmen... However, White finally meets Black, a friendly musician, who takes White with him and wants to help him in any way he possibly can. Both of them become good friends, but living in the same apartment makes both of them feel something stronger than just friendship..." WARNING: This comic contains gay relationships, sex, blood, swearing, crying and angsting, confusing scenes, drama and possible grammar mistakes. NOTICE! I started the comic in 2008, so the first four chapters are pretty awful to read... but please bear it, \'cause I\'m saving all the re-drawn pages for the possible-author\'s edition.', True, False)
#add('WhiteNoise', 'http://whitenoise.smackjeeves.com/comics/', u'Good monsters have bad times.', False, True)
add('WildWingBoys', 'http://wwb.smackjeeves.com/comics/', u"It's the original Wild Wing Boys, never before seen in its entirety on the Internet! Follow the wacky hijinks of the Gundam Wing characters with sandwich obsessions, meat collecting, and cameos a-plenty! Updates when I can get around to it because school is killer.", False, True)
add('WildWingBoysKoathArc', 'http://wwbka.smackjeeves.com/comics/', u'When a freak dimensional portal sends the five main characters of Gundam Wing into a fantasy world and puts Heero in a coma, the four remaining pilots, accompanied by a young catboy named Toko, must conquer various obstacles in finding a cure...and a way home.', False, True)
add('Wildflowers', 'http://wildflowers.smackjeeves.com/comics/', u'A web comic about love, life, and trying to comes to terms with being transgender. Sometimes dark, sometimes light, and always an attempt at a honest look at transexual life. Updating every day, including weekends!', False, True)
add('Willem', 'http://willemcomic.smackjeeves.com/comics/', u"Willem the robot wants desperately to become a super hero, but the Hero Academy doesn't allow robots! While searching for a loophole he finds a long lost hero named Moonshadow and makes some new friends in the process.", True, True)
add('WingsOverEthereal', 'http://wings-over-ethereal.smackjeeves.com/comics/', u'The age-old fantasy story of a boy and a princess, yet a tale unlike any other... ********************************************* Set in the fictional world of Chrona, "Wings Over Ethereal" is a twisting tale of love and hate set in two Kingdoms living with the tension of an ever-present threat of war. While the beings of these kingdoms go on with their lives either fearing war or welcoming it, they remain blind to the true darkness that seeks to change the course of their world forever. The fate of these two Kingdoms, and perhaps the entire world, rests in the Love between a Human... And an Angel... *********************************************', False, True)
add('WintersinLavelle', 'http://wintersinlavelle.smackjeeves.com/comics/', u'Winters in Lavelle follows siblings Kari and Aiden as they discover an old family heirloom is more than it seems. Lost in a strange world, they must find a way to stay together and alive amid strange cloaked men, human/deer hybrids, dragon kings, and magic amber that will change the course of their lives.', False, True)
add('WitchsQuarry', 'http://witchsquarry.smackjeeves.com/comics/', u"For most current pages see Witch's Quarry at Mangamagazine.net. http://www.mangamagazine.net/manga-and-comics/Witchs-Quarry/detail-page/357?lang=en Currently Updating Here Wednesdays 3:00am EST! This is the tale of Sir Veolynn Moreshire's greatest and strangest achievement. Fate would have her/him led by the whims of a powerful witch. This is what really happened in the Second Great War for Oladuan; when heroes and villains were neither righteous or evil. There were other hidden creatures that placed high stakes in the outcome of the human's conflict. And there were a great many funny things that just didn't go as planned. All's fair game in love, war and species propagation! Rated PG-13 *warning* some adult situations/humor/GLBT themes Rogue X Knight Intermission short story of Wesyng Reedle meets a man who shares the same face, Sir Deshad Bright. Suggested age +16 for mature themes.", False, True)
add('WithACherryOnTop', 'http://wacot.smackjeeves.com/comics/', u"Started in 2006, currently in Issue 6 Kira Morishita is just your everyday high school student: average grades, many friends and plays on Sakio Highs Boys soccer team. His secret? He\x92s actually a she! After finding out that Sakio High no longer has a girls\x92 team, Kira disguises herself as a boy to play. As the saying goes, \x93Whatever can go wrong, will. Her new best friend fell in love with her at first sight, she likes the boy that sits next to her in class, but he hates her, and on top of that she\x92s a benchwarmer until further notice: is this what she traded her skirt in for? Will Kira be able to become a star on the boys\x92 soccer team, and keep the others from finding out she's a girl? ~READS RIGHT to LEFT~ ^_^ Should update regularly, but we don't really know :/", False, True)
add('Wootlabs', 'http://wootlabs.thewebcomic.com/comics/', u'"Square Woot is the worst supervillain I ever fought. She held her death ray backwards and vaporized half of her robot army." - Riot Girl, superhero "An uplifting story for anyone that loves cute things in hats." - Penguin Parade Weekly "THIS IS THE STORY OF CATBOT 9000. EVERYONE ELSE IN IT IS STUPID AND NOT CATBOT 9000." - Catbot 9000 Square Woot is a genius with robots, weapons, and that funky little thing called science. Joined by her penguin sidekick and her family of creations, all she wants to do is rule the world. At least, that\'s all she used to want. A chance encounter has the group thinking that it might be more fun to be heroes from now on. Is the city ready to be saved through mad science?', False, True)
add('XYZ', 'http://xyz.smackjeeves.com/comics/', u'[COMPLETE] ~~~READS LEFT-TO-RIGHT~~~ Two twin sisters, Tomi and Tori, grew up with the average twin sister life- sharing everything: their faces, their clothes, their grades... And then they hit puberty. Tomi went through the expected changes- filling out in places, and going all out "girly". As for Tori...not so much. What her sister got in chest she got in height, and that was basically it. This unexplainable change makes everyone think Tori is a guy, and more particularly, Tomi\'s brother (which helps Tomi out alot). However, crossing the line can be painful and dangerous, and above all, lonely. {ZOMG, It\'s actually a romance/shoujo *_*} UPDATES Tues, Thurs Saturday and/or Sunday', False, True)
add('YamanaokiHighSchool', 'http://yamanaokihs.smackjeeves.com/comics/', u"there're a lot of dimensions on this world and Honjitsu is where 8 students will live the adventure of their lives... Facebook page: http://www.facebook.com/#!/pages/Yamanaoki/167250876624086 version espa\xf1ol: http://yamanaoki.smackjeeves.com be nice 8D", False, True)
add('YonkomaNuzlockeFireRed', 'http://yonkomanuzlocke-fr.smackjeeves.com/comics/', u"Gary Oak is fed up with his wimpy friend Doug constantly clinging to him. With the help of his grandpa, professor Oak, he sends the self-esteemless boy into the dangerous world where giant rock-bodied snakes and bugs with poisonous venom will be the least of his problems. Hilarity ensues when Doug gathers a team of Pok\xe9mon completely unfitting for a coward like him. Then again, it's never just fun and games and this is the one thing Doug might actually know better than anybody else... --- Adaptation of a finished Pok\xe9mon Fire Red Nuzlocke run. Consists mostly but not exclusively of four-panel (yonkoma) comedic strips. Gets better... (=\u203f=)", False, True)
add('YoshisForever', 'http://yoshi.smackjeeves.com/comics/', u'', False, True)
add('YoungCannibals', 'http://youngcannibals.smackjeeves.com/comics/', u"The story of one girl's battle NOT to kill her friends. Updates every Monday & Friday.", False, True)
add('ZaenWell', 'http://zaenwell.smackjeeves.com/comics/', u'Thrown into the well of the Gods as part of an initiation, Renee Nathans has fourteen days to find a suitable God to bring back into the world of humanity. Danger lurks behind every corner, however, and when a rogue God decides humanity is no longer necessary, an already difficult task becomes even harder...', False, True)
add('Zodiac', 'http://zodiac.smackjeeves.com/comics/', u"A curse has fallen on the ten students along with their two teachers, and they must work together to find the source and break it, so they can spent their lives like it was before. The story will be, most of the time, stupid. You've been warned :D Updates: !!! When a page is out/I'll try to update once in weekend maybe once with one page or three pages if i'm lucky", False, False)
add('_A_', 'http://a-the-stalker.smackjeeves.com/comics/', u'"A" is a light story of how a young girl, Ryza Hartfelt, learns how to deal with infatuation, stress, friendship, and an unknown person who calls himself "A". At first, she dislikes "A" for being a stalker, but that soon changes as she goes through a journey of self-discovery with him. This manga series was completed on July 10, 2013 Please read from right to left ^^', False, True)
