# -*- coding: utf-8 -*-
"""The common module of dolfin"""
from dolfin.common import globalparameters
from dolfin.common import constants
from dolfin.common import plotting
from dolfin.common import time
from dolfin.common import memory
from dolfin.common import math
from dolfin.common import timer

from .globalparameters import *
from .constants import *
from .plotting import *
from .time import *
from .memory import *
from .math import *
from .timer import *

# NOTE: The automatic documentation system in DOLFIN requires to _not_ define
# NOTE: classes or functions within this file. Use separate modules for that
# NOTE: purpose.

__all__ = globalparameters.__all__ + constants.__all__ + \
          time.__all__ + memory.__all__ + math.__all__ + \
          plotting.__all__ + timer.__all__
