package sysx

import "syscall"

// These functions will be generated by generate.sh
//    $ GOOS=linux GOARCH=386 ./generate.sh xattr
//    $ GOOS=linux GOARCH=amd64 ./generate.sh xattr
//    $ GOOS=linux GOARCH=arm ./generate.sh xattr
//    $ GOOS=linux GOARCH=arm64 ./generate.sh xattr
//    $ GOOS=linux GOARCH=ppc64 ./generate.sh xattr
//    $ GOOS=linux GOARCH=ppc64le ./generate.sh xattr
//    $ GOOS=linux GOARCH=s390x ./generate.sh xattr

// Listxattr calls syscall listxattr and reads all content
// and returns a string array
func Listxattr(path string) ([]string, error) {
	return listxattrAll(path, syscall.Listxattr)
}

// Removexattr calls syscall removexattr
func Removexattr(path string, attr string) (err error) {
	return syscall.Removexattr(path, attr)
}

// Setxattr calls syscall setxattr
func Setxattr(path string, attr string, data []byte, flags int) (err error) {
	return syscall.Setxattr(path, attr, data, flags)
}

// Getxattr calls syscall getxattr
func Getxattr(path, attr string) ([]byte, error) {
	return getxattrAll(path, attr, syscall.Getxattr)
}

//sys llistxattr(path string, dest []byte) (sz int, err error)

// LListxattr lists xattrs, not following symlinks
func LListxattr(path string) ([]string, error) {
	return listxattrAll(path, llistxattr)
}

//sys lremovexattr(path string, attr string) (err error)

// LRemovexattr removes an xattr, not following symlinks
func LRemovexattr(path string, attr string) (err error) {
	return lremovexattr(path, attr)
}

//sys lsetxattr(path string, attr string, data []byte, flags int) (err error)

// LSetxattr sets an xattr, not following symlinks
func LSetxattr(path string, attr string, data []byte, flags int) (err error) {
	return lsetxattr(path, attr, data, flags)
}

//sys lgetxattr(path string, attr string, dest []byte) (sz int, err error)

// LGetxattr gets an xattr, not following symlinks
func LGetxattr(path, attr string) ([]byte, error) {
	return getxattrAll(path, attr, lgetxattr)
}
