/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "k8s.io/api/resource/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	resourcev1alpha1 "k8s.io/client-go/applyconfigurations/resource/v1alpha1"
	scheme "k8s.io/client-go/kubernetes/scheme"
	rest "k8s.io/client-go/rest"
)

// PodSchedulingsGetter has a method to return a PodSchedulingInterface.
// A group's client should implement this interface.
type PodSchedulingsGetter interface {
	PodSchedulings(namespace string) PodSchedulingInterface
}

// PodSchedulingInterface has methods to work with PodScheduling resources.
type PodSchedulingInterface interface {
	Create(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.CreateOptions) (*v1alpha1.PodScheduling, error)
	Update(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.UpdateOptions) (*v1alpha1.PodScheduling, error)
	UpdateStatus(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.UpdateOptions) (*v1alpha1.PodScheduling, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.PodScheduling, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.PodSchedulingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodScheduling, err error)
	Apply(ctx context.Context, podScheduling *resourcev1alpha1.PodSchedulingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PodScheduling, err error)
	ApplyStatus(ctx context.Context, podScheduling *resourcev1alpha1.PodSchedulingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PodScheduling, err error)
	PodSchedulingExpansion
}

// podSchedulings implements PodSchedulingInterface
type podSchedulings struct {
	client rest.Interface
	ns     string
}

// newPodSchedulings returns a PodSchedulings
func newPodSchedulings(c *ResourceV1alpha1Client, namespace string) *podSchedulings {
	return &podSchedulings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the podScheduling, and returns the corresponding podScheduling object, and an error if there is any.
func (c *podSchedulings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.PodScheduling, err error) {
	result = &v1alpha1.PodScheduling{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podschedulings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PodSchedulings that match those selectors.
func (c *podSchedulings) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PodSchedulingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.PodSchedulingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podschedulings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested podSchedulings.
func (c *podSchedulings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("podschedulings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a podScheduling and creates it.  Returns the server's representation of the podScheduling, and an error, if there is any.
func (c *podSchedulings) Create(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.CreateOptions) (result *v1alpha1.PodScheduling, err error) {
	result = &v1alpha1.PodScheduling{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("podschedulings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podScheduling).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a podScheduling and updates it. Returns the server's representation of the podScheduling, and an error, if there is any.
func (c *podSchedulings) Update(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.UpdateOptions) (result *v1alpha1.PodScheduling, err error) {
	result = &v1alpha1.PodScheduling{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podschedulings").
		Name(podScheduling.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podScheduling).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *podSchedulings) UpdateStatus(ctx context.Context, podScheduling *v1alpha1.PodScheduling, opts v1.UpdateOptions) (result *v1alpha1.PodScheduling, err error) {
	result = &v1alpha1.PodScheduling{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podschedulings").
		Name(podScheduling.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podScheduling).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the podScheduling and deletes it. Returns an error if one occurs.
func (c *podSchedulings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podschedulings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *podSchedulings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podschedulings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched podScheduling.
func (c *podSchedulings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodScheduling, err error) {
	result = &v1alpha1.PodScheduling{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("podschedulings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied podScheduling.
func (c *podSchedulings) Apply(ctx context.Context, podScheduling *resourcev1alpha1.PodSchedulingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PodScheduling, err error) {
	if podScheduling == nil {
		return nil, fmt.Errorf("podScheduling provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(podScheduling)
	if err != nil {
		return nil, err
	}
	name := podScheduling.Name
	if name == nil {
		return nil, fmt.Errorf("podScheduling.Name must be provided to Apply")
	}
	result = &v1alpha1.PodScheduling{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("podschedulings").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *podSchedulings) ApplyStatus(ctx context.Context, podScheduling *resourcev1alpha1.PodSchedulingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.PodScheduling, err error) {
	if podScheduling == nil {
		return nil, fmt.Errorf("podScheduling provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(podScheduling)
	if err != nil {
		return nil, err
	}

	name := podScheduling.Name
	if name == nil {
		return nil, fmt.Errorf("podScheduling.Name must be provided to Apply")
	}

	result = &v1alpha1.PodScheduling{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("podschedulings").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
