/*
 * table1.c
 *
 * Example 1 of the Debian package diploma
 *
 * Copyright (C) 1999 Andreas Franzen
 *
 * See the file copyright for details.
 *
 * This program creates the file with the table data which is included
 * in the TeX text and also the resulting lattice constant in result.tex.
 */
#include <stdio.h>
#include <math.h>
/*
 * We include the definitions of some parameters.
 */
#include "../inc/salt.h"
int main()
{
/*
 * These are the step numbers of the peaks in res/salt2.dat.
 */
   int steps[17]={1105,1182,1360,1910,2176,2494,2683,2841,3446,3506,
                 3892,4026,4604,5055,5884,6479,6714};
/*
 * These are the corresponding (hkl)s.
 */
  int h[17]={1,2,2,2,2,2,3,2,4,4,3,4,4,5,4,5,4};
  int k[17]={1,0,0,2,2,2,1,2,0,2,3,2,2,1,4,3,4};
  int l[17]={1,0,0,0,0,2,1,2,0,0,1,0,2,1,0,1,2};
/*
 * 'a' means Co-Kalpha and 'b' means Co-Kbeta line.
 */
  char t[17]={'a','b','a','b','a','b','a','a','a','b',
              'a','a','a','a','a','a','a'};

  double diffangles[17],d[17];
  int i;
  FILE *f;
  double pi;
  
  pi=4.0*atan(1.0);
/*
 * We calculate the diffraction angle from the step number.
 */  
  for(i=0;i<17;i++)
    diffangles[i]=(max2theta-min2theta)/(stepnumber-1)*(steps[i]-1)+min2theta;
/*
 * Then, we calculate the lattice plane spacing with the appropriate
 * wavelength.
 */
  for(i=0;i<17;i++)
    {
      if(t[i]=='a') 
        d[i]=lambdaKalpha1/2.0/sin(pi/180.0*diffangles[i]/2.0);
      else
        d[i]=lambdaKbeta/2.0/sin(pi/180.0*diffangles[i]/2.0);
    }
/*
 * We calculate the lattice parameter and write the lines of the
 * table.
 */
  for(i=0;i<17;i++)
    if(t[i]=='a')
      printf("%6.2f&%6.4f&(%d%d%d)&%6.4f&&&\\\\\n",diffangles[i],d[i]*1.0e9,
        h[i],k[i],l[i],d[i]*sqrt(h[i]*h[i]+k[i]*k[i]+l[i]*l[i])*1.0e9);  
    else  
      printf("%6.2f&&&&%6.4f&(%d%d%d)&%6.4f\\\\\n",diffangles[i],d[i]*1.0e9,
        h[i],k[i],l[i],d[i]*sqrt(h[i]*h[i]+k[i]*k[i]+l[i]*l[i])*1.0e9);  
/*
 * Now, we write res/result.tex.
 */
  f=fopen("res/result.tex","w");
  i=16;
  fprintf(f,"%6.4f\\pm 0.0001\\,\\mathrm{nm}",
    d[i]*sqrt(h[i]*h[i]+k[i]*k[i]+l[i]*l[i])*1.0e9);  
  fclose(f);
/*
 * return(0) tells the make command that this program was successfully
 * terminated.
 */
  return(0);
}
