#include "ipstore"

IPStore::StoreMap IPStore::store;
bool IPStore::onoff = false;

int IPStore::target(struct in_addr clientip) {
    // Weed out the store, for decisions later
    weed();

    // Let's see if we know the client.
    if (store.count(clientip) > 0) {
	if (config.verbose()) {
	    Timestamp tm(store[clientip].lastaccess);
	    msg(Mstr("Client IP ") + Mstr(inet_ntoa(clientip)) +
		" last visited on " + tm.desc() + " and went to " +
		balancer.backend(store[clientip].targetbackend).description() +
		"\n");
	}
	return store[clientip].targetbackend;
    }
    return -1;
}
    
