((typeof exports !== "undefined" && exports !== null) ? exports : this)["Viz"] = function(src, format) {
  var Module = {};
  Module["return"] = "";
  Module["print"] = function(text) {
    Module["return"] += text + "\n";
  }
// Note: Some Emscripten settings will significantly limit the speed of the generated code.
// Note: Some Emscripten settings may limit the speed of the generated code.
try {
  this['Module'] = Module;
} catch(e) {
  this['Module'] = Module = {};
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function(filename) { return Module['read'](filename, true) };
  Module['load'] = function(f) {
    globalEval(read(f));
  };
  if (!Module['arguments']) {
    Module['arguments'] = process['argv'].slice(2);
  }
}
if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  Module['read'] = read;
  Module['readBinary'] = function(f) {
    return read(f, 'binary');
  };
  if (!Module['arguments']) {
    if (typeof scriptArgs != 'undefined') {
      Module['arguments'] = scriptArgs;
    } else if (typeof arguments != 'undefined') {
      Module['arguments'] = arguments;
    }
  }
}
if (ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER) {
  if (!Module['print']) {
    Module['print'] = function(x) {
      console.log(x);
    };
  }
  if (!Module['printErr']) {
    Module['printErr'] = function(x) {
      console.log(x);
    };
  }
}
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (!Module['arguments']) {
    if (typeof arguments != 'undefined') {
      Module['arguments'] = arguments;
    }
  }
}
if (ENVIRONMENT_IS_WORKER) {
  // We can do very little here...
  var TRY_USE_DUMP = false;
  if (!Module['print']) {
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }
  Module['load'] = importScripts;
}
if (!ENVIRONMENT_IS_WORKER && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_SHELL) {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
if (!Module['preRun']) Module['preRun'] = [];
if (!Module['postRun']) Module['postRun'] = [];
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      var logg = log2(quantum);
      return '((((' +target + ')+' + (quantum-1) + ')>>' + logg + ')<<' + logg + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (/^\[\d+\ x\ (.*)\]/.test(type)) return true; // [15 x ?] blocks. Like structs
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type, quantumSize) {
    if (Runtime.QUANTUM_SIZE == 1) return 1;
    var size = {
      '%i1': 1,
      '%i8': 1,
      '%i16': 2,
      '%i32': 4,
      '%i64': 8,
      "%float": 4,
      "%double": 8
    }['%'+type]; // add '%' since float and double confuse Closure compiler as keys, and also spidermonkey as a compiler will remove 's from '_i8' etc
    if (!size) {
      if (type.charAt(type.length-1) == '*') {
        size = Runtime.QUANTUM_SIZE; // A pointer
      } else if (type[0] == 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 == 0);
        size = bits/8;
      }
    }
    return size;
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    type.flatIndexes = type.fields.map(function(field) {
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        size = Types.types[field].flatSize;
        alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else {
        throw 'Unclear type in struct: ' + field + ', in ' + type.name_ + ' :: ' + dump(Types.types[type.name_]);
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2 + 2*i;
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xff;
      if (needed) {
        buffer.push(code);
        needed--;
      }
      if (buffer.length == 0) {
        if (code < 128) return String.fromCharCode(code);
        buffer.push(code);
        if (code > 191 && code < 224) {
          needed = 1;
        } else {
          needed = 2;
        }
        return '';
      }
      if (needed > 0) return '';
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var ret;
      if (c1 > 191 && c1 < 224) {
        ret = String.fromCharCode(((c1 & 31) << 6) | (c2 & 63));
      } else {
        ret = String.fromCharCode(((c1 & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = ((((STACKTOP)+7)>>3)<<3); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = ((((STATICTOP)+7)>>3)<<3); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = ((((DYNAMICTOP)+7)>>3)<<3); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+(((low)>>>(0))))+((+(((high)>>>(0))))*(+(4294967296)))) : ((+(((low)>>>(0))))+((+(((high)|(0))))*(+(4294967296))))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function abort(text) {
  Module.print(text + ':\n' + (new Error).stack);
  ABORT = true;
  throw "Assertion: " + text;
}
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = globalScope['Module']['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length+1);
      writeStringToMemory(value, ret);
      return ret;
    } else if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,Math.min(Math.floor((value)/(+(4294967296))), (+(4294967295)))>>>0],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    HEAPU8.set(new Uint8Array(slab), ret);
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return ((x+4095)>>12)<<12;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value, or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(!!Int32Array && !!Float64Array && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATINIT__ = []; // functions called during startup
var __ATMAIN__ = []; // functions called when main() is to be run
var __ATEXIT__ = []; // functions called during shutdown
var runtimeInitialized = false;
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math.imul) Math.imul = function(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyTracking = {};
var calledInit = false, calledRun = false;
var runDependencyWatcher = null;
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            Module.printErr('still waiting on run dependencies:');
          }
          Module.printErr('dependency: ' + dep);
        }
        if (shown) {
          Module.printErr('(end of list)');
        }
      }, 6000);
    }
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    } 
    // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
    if (!calledRun && shouldRunNow) run();
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
function addPreRun(func) {
  if (!Module['preRun']) Module['preRun'] = [];
  else if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
  Module['preRun'].push(func);
}
var awaitingMemoryInitializer = false;
function loadMemoryInitializer(filename) {
  function applyData(data) {
    HEAPU8.set(data, STATIC_BASE);
    runPostSets();
  }
  // always do this asynchronously, to keep shell and web as similar as possible
  addPreRun(function() {
    if (ENVIRONMENT_IS_NODE || ENVIRONMENT_IS_SHELL) {
      applyData(Module['readBinary'](filename));
    } else {
      Browser.asyncLoad(filename, function(data) {
        applyData(data);
      }, function(data) {
        throw 'could not load memory initializer ' + filename;
      });
    }
  });
  awaitingMemoryInitializer = false;
}
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 168584;
var _stdout;
var _stderr;
var _stdout = _stdout=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stderr = _stderr=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* memory initializer */ allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,1,0,0,50,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,1,0,0,0,0,0,0,36,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,2,0,0,0,0,0,0,134,1,0,0,196,1,0,0,166,1,0,0,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,0,0,0,232,0,0,0,248,0,0,0,8,1,0,0,24,1,0,0,40,1,0,0,56,1,0,0,72,1,0,0,232,0,0,0,232,0,0,0,40,1,0,0,40,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,119,2,0,200,104,2,0,232,91,2,0,136,77,2,0,200,65,2,0,240,54,2,0,32,43,2,0,88,29,2,0,152,18,2,0,40,9,2,0,32,1,2,0,88,250,1,0,56,241,1,0,120,231,1,0,168,223,1,0,40,219,1,0,174,0,0,0,0,0,0,0,188,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,1,0,0,76,1,0,0,0,0,0,0,0,0,0,0,254,1,0,0,0,0,0,0,202,0,0,0,34,1,0,0,90,0,0,0,204,0,0,0,8,0,0,0,0,0,0,0,100,0,0,0,116,0,0,0,92,0,0,0,146,0,0,0,158,2,0,0,98,2,0,0,204,1,0,0,78,0,0,0,2,2,0,0,28,1,0,0,46,0,0,0,146,1,0,0,210,0,0,0,108,0,0,0,26,0,0,0,94,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,0,0,0,0,0,0,0,0,0,1,1,64,0,0,0,250,1,0,0,210,1,0,0,98,1,0,0,178,0,0,0,210,1,0,0,226,0,0,0,228,0,0,0,236,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,112,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,1,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,1,0,0,0,0,0,0,62,2,0,0,58,2,0,0,188,1,0,0,230,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,37,117,2,154,8,27,218,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,44,212,154,230,29,167,234,63,106,222,113,138,142,228,232,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,93,220,70,3,120,11,226,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,208,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,93,220,70,3,120,11,226,63,93,220,70,3,120,11,226,63,93,220,70,3,120,11,226,63,13,113,172,139,219,104,220,63,100,93,220,70,3,120,237,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,16,122,54,171,62,87,229,63,210,111,95,7,206,25,231,63,120,11,36,40,126,140,227,63,181,21,251,203,238,201,225,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,88,168,53,205,59,78,213,63,136,133,90,211,188,227,216,63,210,111,95,7,206,25,231,63,120,11,36,40,126,140,227,63,196,66,173,105,222,113,236,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,181,21,251,203,238,201,225,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,181,21,251,203,238,201,225,63,120,11,36,40,126,140,227,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,134,56,214,197,109,52,238,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,120,11,36,40,126,140,227,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,166,10,70,37,117,2,222,63,0,0,0,0,0,0,224,63,88,168,53,205,59,78,213,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,13,113,172,139,219,104,220,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,106,222,113,138,142,228,232,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,88,168,53,205,59,78,213,63,136,133,90,211,188,227,216,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,210,111,95,7,206,25,231,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,13,113,172,139,219,104,220,63,244,108,86,125,174,182,222,63,17,54,60,189,82,150,201,63,244,108,86,125,174,182,222,63,59,1,77,132,13,79,225,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,62,232,217,172,250,92,197,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,130,115,70,148,246,6,199,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,7,240,22,72,80,252,220,63,162,180,55,248,194,100,214,63,88,168,53,205,59,78,213,63,13,113,172,139,219,104,220,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,208,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,196,66,173,105,222,113,236,63,0,0,0,0,0,0,208,63,127,217,61,121,88,168,209,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,120,11,36,40,126,140,227,63,210,111,95,7,206,25,231,63,196,66,173,105,222,113,236,63,19,242,65,207,102,213,211,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,16,122,54,171,62,87,229,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,210,111,95,7,206,25,231,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,16,219,1,0,58,0,0,0,96,186,1,0,56,1,0,0,32,184,1,0,126,1,0,0,8,127,1,0,194,0,0,0,64,182,1,0,104,0,0,0,8,180,1,0,150,0,0,0,16,205,1,0,146,2,0,0,208,176,1,0,8,1,0,0,120,175,1,0,160,2,0,0,200,173,1,0,202,1,0,0,40,172,1,0,76,0,0,0,248,170,1,0,150,2,0,0,112,125,1,0,182,1,0,0,184,166,1,0,246,0,0,0,56,165,1,0,6,0,0,0,72,163,1,0,6,0,0,0,240,161,1,0,216,0,0,0,112,160,1,0,90,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,192,244,1,0,232,203,1,0,56,183,1,0,0,166,1,0,160,150,1,0,64,134,1,0,48,118,1,0,232,104,1,0,248,122,2,0,248,108,2,0,48,95,2,0,240,81,2,0,40,69,2,0,32,58,2,0,32,46,2,0,64,32,2,0,136,21,2,0,40,12,2,0,56,3,2,0,240,251,1,0,232,243,1,0,240,233,1,0,8,226,1,0,224,219,1,0,184,217,1,0,248,214,1,0,64,212,1,0,48,210,1,0,0,208,1,0,208,205,1,0,168,203,1,0,40,201,1,0,232,198,1,0,232,196,1,0,56,195,1,0,56,193,1,0,48,191,1,0,248,188,1,0,48,187,1,0,32,185,1,0,16,183,1,0,248,180,1,0,40,179,1,0,120,177,1,0,248,175,1,0,72,174,1,0,176,172,1,0,104,171,1,0,8,170,1,0,80,167,1,0,232,165,1,0,248,163,1,0,104,162,1,0,24,161,1,0,136,159,1,0,16,158,1,0,176,156,1,0,72,155,1,0,248,153,1,0,8,152,1,0,144,150,1,0,160,148,1,0,64,147,1,0,200,145,1,0,112,144,1,0,176,142,1,0,16,141,1,0,224,138,1,0,120,137,1,0,104,135,1,0,24,134,1,0,80,132,1,0,240,130,1,0,32,129,1,0,128,127,1,0,16,126,1,0,48,124,1,0,232,122,1,0,16,121,1,0,64,119,1,0,24,118,1,0,136,116,1,0,64,115,1,0,16,114,1,0,216,112,1,0,112,111,1,0,64,110,1,0,192,108,1,0,136,107,1,0,240,105,1,0,184,104,1,0,192,102,1,0,112,101,1,0,64,100,1,0,224,98,1,0,184,97,1,0,144,96,1,0,72,95,1,0,56,125,2,0,216,123,2,0,208,122,2,0,240,120,2,0,136,119,2,0,96,118,2,0,24,117,2,0,224,115,2,0,176,114,2,0,104,113,2,0,224,111,2,0,72,110,2,0,192,108,2,0,8,107,2,0,128,105,2,0,16,104,2,0,120,102,2,0,56,101,2,0,64,100,2,0,8,99,2,0,192,97,2,0,40,96,2,0,248,94,2,0,144,93,2,0,88,92,2,0,8,91,2,0,224,89,2,0,176,88,2,0,64,87,2,0,184,85,2,0,152,84,2,0,8,83,2,0,184,81,2,0,200,79,2,0,80,78,2,0,224,76,2,0,88,75,2,0,104,74,2,0,80,73,2,0,8,72,2,0,240,70,2,0,224,69,2,0,0,69,2,0,88,67,2,0,128,66,2,0,64,65,2,0,56,64,2,0,40,63,2,0,48,62,2,0,0,0,0,0,114,0,0,0,0,0,0,0,232,0,0,0,140,1,0,0,158,1,0,0,118,0,0,0,244,0,0,0,252,0,0,0,50,0,0,0,212,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,0,0,0,232,1,0,0,212,0,0,0,238,1,0,0,24,0,0,0,94,2,0,0,0,0,0,0,0,0,0,0,88,0,0,0,0,0,0,0,198,1,0,0,90,2,0,0,154,1,0,0,128,2,0,0,126,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,54,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,1,0,0,226,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,114,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,176,193,0,0,0,0,0,0,0,0,0,0,0,0,0,88,1,0,0,16,0,0,0,1,0,0,0,0,0,0,0,0,16,0,2,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,176,193,0,0,0,0,0,0,0,0,0,0,0,16,64,16,13,0,0,147,0,0,0,1,0,0,0,0,0,0,0,0,32,3,2,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,144,195,0,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,16,0,0,0,0,0,0,0,0,0,0,0,0,16,64,80,64,0,0,8,0,0,0,1,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,66,0,0,0,148,1,0,0,56,2,0,0,70,2,0,0,92,2,0,0,122,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,135,1,0,8,119,1,0,200,105,1,0,176,123,2,0,24,110,2,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,0,0,0,0,102,1,0,0,142,0,0,0,52,0,0,0,0,0,0,0,136,2,0,0,0,0,0,0,6,1,0,0,36,0,0,0,136,1,0,0,222,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,1,0,0,2,0,0,0,130,1,0,0,4,1,0,0,234,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,1,0,0,0,0,0,0,116,2,0,0,158,0,0,0,172,0,0,0,218,0,0,0,170,2,0,0,42,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,108,2,0,48,110,2,0,168,252,1,0,136,206,1,0,136,185,1,0,104,168,1,0,112,152,1,0,248,135,1,0,136,206,1,0,128,119,1,0,56,106,1,0,136,206,1,0,16,124,2,0,184,110,2,0,128,96,2,0,88,83,2,0,32,70,2,0,40,59,2,0,136,47,2,0,104,33,2,0,192,22,2,0,88,13,2,0,0,4,2,0,224,252,1,0,72,245,1,0,16,235,1,0,8,227,1,0,24,220,1,0,8,218,1,0,48,215,1,0,120,212,1,0,96,210,1,0,96,208,1,0,152,206,1,0,136,206,1,0,8,204,1,0,96,201,1,0,48,199,1,0,64,197,1,0,136,206,1,0,120,195,1,0,96,193,1,0,176,190,1,0,192,188,1,0,152,206,1,0,136,206,1,0,0,187,1,0,208,184,1,0,192,182,1,0,152,180,1,0,192,178,1,0,16,177,1,0,208,175,1,0,16,174,1,0,136,172,1,0,64,171,1,0,136,206,1,0,216,169,1,0,24,167,1,0,176,165,1,0,192,163,1,0,48,162,1,0,136,206,1,0,208,160,1,0,96,159,1,0,240,157,1,0,144,156,1,0,32,155,1,0,216,153,1,0,240,151,1,0,104,150,1,0,128,148,1,0,240,146,1,0,168,145,1,0,88,144,1,0,152,206,1,0,136,206,1,0,144,142,1,0,240,140,1,0,184,138,1,0,104,33,2,0,136,206,1,0,56,137,1,0,24,136,1,0,248,133,1,0,40,132,1,0,216,130,1,0,0,129,1,0,96,127,1,0,184,125,1,0,16,124,1,0,200,122,1,0,104,33,2,0,136,206,1,0,208,120,1,0,16,119,1,0,248,117,1,0,104,116,1,0,24,115,1,0,248,113,1,0,192,112,1,0,96,111,1,0,152,206,1,0,136,206,1,0,48,110,1,0,176,108,1,0,120,107,1,0,224,105,1,0,168,104,1,0,168,102,1,0,96,101,1,0,48,100,1,0,208,98,1,0,160,97,1,0,128,96,1,0,152,206,1,0,136,206,1,0,40,95,1,0,32,125,2,0,136,206,1,0,200,123,2,0,160,122,2,0,224,120,2,0,144,119,2,0,104,118,2,0,40,117,2,0,232,115,2,0,192,114,2,0,112,113,2,0,136,206,1,0,240,111,2,0,136,206,1,0,96,110,2,0,32,109,2,0,64,107,2,0,144,105,2,0,32,104,2,0,160,102,2,0,152,206,1,0,136,206,1,0,64,101,2,0,136,206,1,0,72,100,2,0,24,99,2,0,200,97,2,0,56,96,2,0,8,95,2,0,184,93,2,0,112,92,2,0,104,33,2,0,136,206,1,0,16,91,2,0,136,206,1,0,240,89,2,0,248,88,2,0,80,87,2,0,248,85,2,0,160,84,2,0,24,83,2,0,200,81,2,0,136,206,1,0,248,79,2,0,96,78,2,0,232,76,2,0,216,75,2,0,120,74,2,0,88,73,2,0,16,72,2,0,248,70,2,0,136,206,1,0,240,69,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,89,64,0,0,0,0,0,136,195,64,0,0,0,0,132,215,151,65,0,128,224,55,121,195,65,67,23,110,5,181,181,184,147,70,245,249,63,233,3,79,56,77,50,29,48,249,72,119,130,90,60,191,115,127,221,79,21,117,40,116,1,0,96,102,1,0,152,120,2,0,0,0,0,0,0,0,0,0,4,0,0,0,216,106,2,0,0,0,0,0,0,0,0,0,88,93,2,0,96,102,1,0,152,120,2,0,0,0,0,0,160,79,2,0,5,0,0,0,216,106,2,0,0,0,0,0,40,67,2,0,64,56,2,0,96,102,1,0,96,44,2,0,0,0,0,0,0,0,0,0,6,0,0,0,216,106,2,0,176,30,2,0,0,0,0,0,200,19,2,0,96,102,1,0,96,44,2,0,0,0,0,0,160,79,2,0,7,0,0,0,216,106,2,0,176,30,2,0,40,67,2,0,120,10,2,0,224,1,2,0,96,44,2,0,0,0,0,0,0,0,0,0,10,0,0,0,32,251,1,0,176,30,2,0,0,0,0,0,96,242,1,0,224,1,2,0,96,44,2,0,0,0,0,0,40,67,2,0,11,0,0,0,32,251,1,0,176,30,2,0,40,67,2,0,80,232,1,0,224,1,2,0,152,224,1,0,0,0,0,0,0,0,0,0,8,0,0,0,32,251,1,0,0,0,0,0,0,0,0,0,96,219,1,0,224,1,2,0,152,224,1,0,0,0,0,0,40,67,2,0,9,0,0,0,32,251,1,0,0,0,0,0,40,67,2,0,0,217,1,0,0,217,1,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,80,214,1,0,0,0,0,0,0,0,0,0,200,211,1,0,0,217,1,0,176,30,2,0,0,0,0,0,0,0,0,0,14,0,0,0,80,214,1,0,176,30,2,0,0,0,0,0,168,209,1,0,0,217,1,0,176,30,2,0,0,0,0,0,160,79,2,0,15,0,0,0,80,214,1,0,176,30,2,0,40,67,2,0,152,207,1,0,0,217,1,0,0,0,0,0,0,0,0,0,160,79,2,0,13,0,0,0,80,214,1,0,0,0,0,0,40,67,2,0,72,205,1,0,72,205,1,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,216,106,2,0,0,0,0,0,0,0,0,0,32,203,1,0,72,205,1,0,176,30,2,0,0,0,0,0,0,0,0,0,18,0,0,0,216,106,2,0,176,30,2,0,0,0,0,0,160,200,1,0,72,205,1,0,176,30,2,0,0,0,0,0,160,79,2,0,19,0,0,0,216,106,2,0,176,30,2,0,40,67,2,0,136,198,1,0,72,205,1,0,0,0,0,0,152,196,1,0,0,0,0,0,20,0,0,0,216,106,2,0,0,0,0,0,0,0,0,0,208,194,1,0,72,205,1,0,176,30,2,0,152,196,1,0,0,0,0,0,22,0,0,0,216,106,2,0,176,30,2,0,0,0,0,0,176,192,1,0,72,205,1,0,176,30,2,0,152,196,1,0,160,79,2,0,23,0,0,0,216,106,2,0,176,30,2,0,40,67,2,0,96,190,1,0,72,205,1,0,0,0,0,0,152,196,1,0,160,79,2,0,21,0,0,0,216,106,2,0,0,0,0,0,40,67,2,0,88,188,1,0,72,205,1,0,0,0,0,0,0,0,0,0,160,79,2,0,17,0,0,0,216,106,2,0,0,0,0,0,40,67,2,0,168,186,1,0,80,184,1,0,176,30,2,0,0,0,0,0,0,0,0,0,26,0,0,0,32,251,1,0,176,30,2,0,0,0,0,0,160,182,1,0,80,184,1,0,176,30,2,0,0,0,0,0,40,67,2,0,27,0,0,0,32,251,1,0,176,30,2,0,40,67,2,0,96,180,1,0,80,184,1,0,0,0,0,0,0,0,0,0,40,67,2,0,25,0,0,0,32,251,1,0,0,0,0,0,40,67,2,0,152,178,1,0,80,184,1,0,8,177,1,0,0,0,0,0,0,0,0,0,24,0,0,0,32,251,1,0,0,0,0,0,0,0,0,0,192,175,1,0,248,173,1,0,176,30,2,0,0,0,0,0,0,0,0,0,30,0,0,0,32,251,1,0,176,30,2,0,0,0,0,0,112,172,1,0,248,173,1,0,176,30,2,0,0,0,0,0,40,67,2,0,31,0,0,0,32,251,1,0,176,30,2,0,40,67,2,0,48,171,1,0,248,173,1,0,0,0,0,0,0,0,0,0,40,67,2,0,29,0,0,0,32,251,1,0,0,0,0,0,40,67,2,0,200,169,1,0,248,173,1,0,8,177,1,0,0,0,0,0,0,0,0,0,28,0,0,0,32,251,1,0,0,0,0,0,0,0,0,0,240,166,1,0,240,166,1,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,168,165,1,0,0,0,0,0,0,0,0,0,144,163,1,0,32,162,1,0,176,30,2,0,0,0,0,0,0,0,0,0,2,0,0,0,32,251,1,0,176,30,2,0,0,0,0,0,184,160,1,0,32,162,1,0,176,30,2,0,0,0,0,0,40,67,2,0,3,0,0,0,32,251,1,0,176,30,2,0,40,67,2,0,80,159,1,0,32,162,1,0,0,0,0,0,0,0,0,0,40,67,2,0,1,0,0,0,32,251,1,0,0,0,0,0,40,67,2,0,224,157,1,0,32,162,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,1,0,0,0,0,0,0,0,0,0,96,156,1,0,0,155,1,0,192,153,1,0,0,0,0,0,40,67,2,0,33,0,0,0,32,251,1,0,0,0,0,0,40,67,2,0,176,151,1,0,72,150,1,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,0,0,168,165,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,1,0,0,144,0,0,0,164,1,0,0,208,1,0,0,138,0,0,0,242,1,0,0,152,143,1,0,192,141,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,144,0,0,0,164,1,0,0,130,2,0,0,0,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,217,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,51,51,51,51,51,227,63,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,128,102,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,128,102,64,154,153,153,153,153,153,217,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,128,102,64,123,20,174,71,225,122,228,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,20,174,71,225,122,228,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,51,51,51,51,51,211,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,128,70,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,128,70,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,7,2,0,32,0,2,0,208,248,1,0,88,239,1,0,24,230,1,0,176,222,1,0,216,218,1,0,88,216,1,0,128,213,1,0,56,211,1,0,8,209,1,0,48,207,1,0,184,204,1,0,120,202,1,0,8,200,1,0,40,198,1,0,32,196,1,0,64,194,1,0,8,192,1,0,192,189,1,0,232,187,1,0,0,0,0,0,2,3,4,5,6,7,8,0,0,9,10,11,12,13,14,15,16,17,0,0,0,0,0,0,0,0,0,0,0,0,18,19,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,23,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,4,254,255,255,135,254,255,255,7,0,0,0,0,0,0,0,0,255,255,127,255,255,255,127,255,255,255,255,255,255,255,243,127,254,253,255,255,255,255,255,127,255,255,255,255,255,255,255,255,15,224,255,255,255,255,49,252,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,1,0,248,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,215,255,255,251,255,255,255,255,127,127,84,253,255,15,0,254,223,255,255,255,255,255,255,255,255,254,223,255,255,255,255,3,0,255,255,255,255,255,255,159,25,255,255,255,207,63,3,0,0,0,0,0,0,254,255,255,255,127,2,254,255,255,255,127,0,0,0,0,0,0,0,0,0,255,255,255,7,7,0,0,0,0,0,254,255,255,7,254,7,0,0,0,0,254,255,255,255,255,255,255,255,255,124,255,127,47,0,96,0,0,0,224,255,255,255,255,255,255,35,0,0,0,255,3,0,0,0,224,159,249,255,255,253,197,3,0,0,0,176,3,0,3,0,224,135,249,255,255,253,109,3,0,0,0,94,0,0,28,0,224,175,251,255,255,253,237,35,0,0,0,0,1,0,0,0,224,159,249,255,255,253,205,35,0,0,0,176,3,0,0,0,224,199,61,214,24,199,191,3,0,0,0,0,0,0,0,0,224,223,253,255,255,253,239,3,0,0,0,0,3,0,0,0,224,223,253,255,255,253,239,3,0,0,0,64,3,0,0,0,224,223,253,255,255,253,255,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,255,127,13,0,63,0,0,0,0,0,0,0,150,37,240,254,174,108,13,32,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,63,0,255,255,255,255,127,0,237,218,7,0,0,0,0,80,1,80,49,130,171,98,44,0,0,0,0,64,0,201,128,245,7,0,0,0,0,8,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31,0,0,0,0,64,76,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,254,3,0,0,254,255,255,255,255,255,255,255,255,255,31,0,254,255,255,255,255,255,255,255,255,255,255,7].concat([224,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,255,7,254,255,255,135,254,255,255,7,0,0,0,0,0,0,128,0,255,255,127,255,255,255,127,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,1,0,248,3,0,3,0,0,0,0,0,255,255,255,255,255,255,255,255,63,0,0,0,3,0,0,0,192,215,255,255,251,255,255,255,255,127,127,84,253,255,15,0,254,223,255,255,255,255,255,255,255,255,254,223,255,255,255,255,123,0,255,255,255,255,255,255,159,25,255,255,255,207,63,3,0,0,0,0,0,0,254,255,255,255,127,2,254,255,255,255,127,0,254,255,251,255,255,187,22,0,255,255,255,7,7,0,0,0,0,0,254,255,255,7,255,255,7,0,255,3,255,255,255,255,255,255,255,255,255,124,255,127,239,255,255,61,255,3,238,255,255,255,255,255,255,243,255,63,30,255,207,255,0,0,238,159,249,255,255,253,197,211,159,57,128,176,207,255,3,0,228,135,249,255,255,253,109,211,135,57,0,94,192,255,31,0,238,175,251,255,255,253,237,243,191,59,0,0,193,255,0,0,238,159,249,255,255,253,205,243,143,57,192,176,195,255,0,0,236,199,61,214,24,199,191,195,199,61,128,0,128,255,0,0,238,223,253,255,255,253,239,195,223,61,96,0,195,255,0,0,236,223,253,255,255,253,239,195,223,61,96,64,195,255,0,0,236,223,253,255,255,253,255,195,207,61,128,0,195,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,255,127,255,7,255,127,255,3,0,0,0,0,150,37,240,254,174,108,255,59,95,63,255,3,0,0,0,0,0,0,0,3,255,3,160,194,255,254,255,255,255,3,254,255,223,15,191,254,255,63,254,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,31,2,0,0,0,160,0,0,0,254,255,62,0,254,255,255,255,255,255,255,255,255,255,31,102,254,255,255,255,255,255,255,255,255,255,255,119,25,3,26,27,28,29,30,0,0,31,32,33,34,35,36,37,16,17,0,0,0,0,0,0,0,0,0,0,0,0,18,19,38,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,23,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,46,57,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,1,0,0,118,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,2,0,0,0,0,0,0,20,2,0,0,8,2,0,0,184,0,0,0,152,0,0,0,96,1,0,0,106,1,0,0,162,1,0,0,214,0,0,0,32,2,0,0,48,1,0,0,132,1,0,0,54,2,0,0,16,0,0,0,224,0,0,0,240,1,0,0,190,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,116,0,0,0,92,0,0,0,146,0,0,0,158,2,0,0,98,2,0,0,204,1,0,0,78,0,0,0,2,2,0,0,28,1,0,0,46,0,0,0,146,1,0,0,210,0,0,0,108,0,0,0,72,0,0,0,214,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,252,1,0,8,0,0,0,3,0,0,0,232,244,1,0,160,234,1,0,11,0,0,0,6,0,0,0,144,226,1,0,8,220,1,0,2,0,0,0,1,0,0,0,248,217,1,0,32,215,1,0,4,0,0,0,2,0,0,0,104,212,1,0,80,210,1,0,4,0,0,0,4,0,0,0,80,208,1,0,128,206,1,0,5,0,0,0,5,0,0,0,248,203,1,0,80,201,1,0,4,0,0,0,7,0,0,0,32,199,1,0,8,197,1,0,5,0,0,0,9,0,0,0,104,195,1,0,1,208,209,210,211,212,213,214,215,216,217,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,116,0,0,0,92,0,0,0,146,0,0,0,158,2,0,0,98,2,0,0,204,1,0,0,78,0,0,0,2,2,0,0,28,1,0,0,46,0,0,0,146,1,0,0,210,0,0,0,108,0,0,0,26,0,0,0,94,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,0,0,0,0,0,0,0,0,0,1,1,64,0,0,0,250,1,0,0,210,1,0,0,98,1,0,0,178,0,0,0,210,1,0,0,226,0,0,0,228,0,0,0,236,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,66,1,0,0,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,109,108,61,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,88,77,76,47,49,57,57,56,47,110,97,109,101,115,112,97,99,101,0,0,0,0,0,0,0,0,136,249,1,0,222,0,0,0,104,240,1,0,70,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,0,0,23,16,17,18,19,30,36,38,40,42,44,45,1,27,23,23,23,23,2,28,29,36,38,40,42,47,48,30,203,30,4,30,46,30,83,30,30,5,6,77,78,49,4,7,8,9,10,11,12,5,6,46,72,49,52,7,8,9,10,11,12,66,217,55,66,70,58,72,75,4,23,16,17,18,19,4,85,52,37,39,41,43,5,6,88,90,91,92,7,8,9,10,11,12,4,79,57,55,51,54,71,5,6,80,76,84,0,7,8,9,10,11,12,4,60,0,0,58,0,0,5,6,0,0,0,0,7,8,9,10,11,12,4,0,0,0,0,61,0,5,6,0,0,0,0,7,8,9,10,11,12,4,0,0,0,0,0,63,5,6,0,0,0,4,7,8,9,10,11,12,5,6,0,0,0,0,7,8,9,10,11,12,0,0,0,2,3,3,1,1,2,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,0,6,1,3,3,3,3,1,0,1,2,0,4,1,2,0,4,0,4,0,4,0,3,2,1,0,0,0,0,0,0,0,0,31,32,32,32,33,34,34,35,35,35,35,35,35,35,35,36,37,38,39,40,41,42,43,44,45,46,47,48,48,49,49,51,50,52,52,52,52,52,53,53,54,54,56,55,57,57,59,58,60,58,61,58,62,58,63,63,0,0,0,0,0,0,0,245,245,23,246,247,255,61,0,60,1,55,2,71,245,245,245,245,245,254,62,245,31,34,245,33,245,245,32,245,245,245,245,245,0,0,0,0,0,0,0,11,0,245,255,151,0,13,0,245,255,245,255,16,0,245,255,245,255,245,255,245,255,245,255,245,255,12,0,151,0,245,255,151,0,151,0,151,0,151,0,151,0,151,0,245,255,39,0,245,255,17,0,3,0,245,255,245,255,245,255,245,255,151,0,151,0,151,0,151,0,20,0,30,0,42,0,63,0,40,0,82,0,48,0,101,0,50,0,120,0,139,0,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,245,255,59,0,245,255,56,0,245,255,43,0,57,0,245,255,18,0,28,0,245,255,20,0,245,255,245,255,72,0,245,255,245,255,74,0,245,255,245,255,245,255,245,255,75,0,76,0,245,255,77,0,245,255,245,255,245,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,3,13,14,15,31,50,32,53,33,56,34,59,20,62,21,64,22,35,24,65,25,26,67,68,69,73,74,87,86,89,81,82,0,0,0,0,0,0,0,0,4,40,0,30,29,0,16,18,20,22,24,26,0,5,7,40,40,40,40,0,0,9,8,34,0,0,1,28,2,6,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,31,3,32,17,10,35,19,11,36,21,13,38,23,12,37,25,14,27,15,0,43,0,41,0,40,42,40,0,45,39,33,56,0,49,47,0,51,44,46,55,0,0,54,0,50,48,52,0,0,0,2,2,2,2,2,14,16,17,18,19,20,21,1,0,16,17,18,19,7,3,8,31,32,33,34,8,23,36,10,38,12,40,12,42,6,44,45,19,20,21,22,11,12,25,26,27,28,29,30,19,20,12,24,11,14,25,26,27,28,29,30,5,23,15,5,9,16,24,70,12,72,72,72,72,72,12,4,14,16,17,18,19,19,20,10,10,10,10,25,26,27,28,29,30,12,72,41,15,37,39,67,19,20,72,70,73,255,25,26,27,28,29,30,12,43,255,255,16,255,255,19,20,255,255,255,255,25,26,27,28,29,30,12,255,255,255,255,17,255,19,20,255,255,255,255,25,26,27,28,29,30,12,255,255,255,255,255,18,19,20,255,255,255,12,25,26,27,28,29,30,19,20,255,255,255,255,25,26,27,28,29,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,114,1,0,1,0,0,0,152,1,0,0,32,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,181,1,0,1,0,0,0,224,3,0,0,64,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,253,1,0,1,0,0,0,96,15,0,0,96,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,69,2,0,1,0,0,0,112,18,0,0,128,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,80,135,1,0,1,0,0,0,24,44,0,0,160,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,1,0,1,0,0,0,112,64,0,0,192,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,201,1,0,1,0,0,0,168,79,0,0,224,17,0,0,4,0,0,0,64,181,1,0,1,0,0,0,40,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,208,1,0,120,89,1,0,16,208,1,0,248,88,1,0,15,0,0,0,56,151,1,0,1,0,0,0,0,79,0,0,0,0,0,0,16,0,0,0,176,46,2,0,1,0,0,0,0,79,0,0,0,0,0,0,17,0,0,0,232,217,1,0,1,0,0,0,0,79,0,0,0,0,0,0,17,0,0,0,80,195,1,0,1,0,0,0,0,79,0,0,0,0,0,0,17,0,0,0,24,176,1,0,1,0,0,0,0,79,0,0,0,0,0,0,19,0,0,0,168,159,1,0,1,0,0,0,32,79,0,0,0,0,0,0,20,0,0,0,152,144,1,0,1,0,0,0,32,79,0,0,0,0,0,0,21,0,0,0,176,127,1,0,1,0,0,0,32,79,0,0,0,0,0,0,21,0,0,0,16,113,1,0,1,0,0,0,32,79,0,0,0,0,0,0,21,0,0,0,32,99,1,0,1,0,0,0,32,79,0,0,0,0,0,0,22,0,0,0,112,117,2,0,1,0,0,0,240,78,0,0,0,0,0,0,23,0,0,0,8,103,2,0,1,0,0,0,240,78,0,0,0,0,0,0,24,0,0,0,56,90,2,0,1,0,0,0,240,78,0,0,0,0,0,0,24,0,0,0,168,75,2,0,1,0,0,0,240,78,0,0,0,0,0,0,24,0,0,0,112,64,2,0,1,0,0,0,240,78,0,0,0,0,0,0,25,0,0,0,128,53,2,0,1,0,0,0,16,79,0,0,0,0,0,0,25,0,0,0,136,41,2,0,1,0,0,0,16,79,0,0,0,0,0,0,25,0,0,0,168,27,2,0,1,0,0,0,16,79,0,0,0,0,0,0,25,0,0,0,120,17,2,0,1,0,0,0,16,79,0,0,0,0,0,0,26,0,0,0,112,7,2,0,1,0,0,0,8,79,0,0,0,0,0,0,10,0,0,0,40,0,2,0,1,0,0,0,24,79,0,0,0,0,0,0,11,0,0,0,224,248,1,0,1,0,0,0,24,79,0,0,0,0,0,0,12,0,0,0,112,239,1,0,1,0,0,0,24,79,0,0,0,0,0,0,12,0,0,0,32,230,1,0,1,0,0,0,24,79,0,0,0,0,0,0,12,0,0,0,184,222,1,0,1,0,0,0,24,79,0,0,0,0,0,0,14,0,0,0,224,218,1,0,1,0,0,0,24,79,0,0,0,0,0,0,14,0,0,0,96,216,1,0,1,0,0,0,24,79,0,0,0,0,0,0,13,0,0,0,136,213,1,0,1,0,0,0,24,79,0,0,0,0,0,0,5,0,0,0,64,211,1,0,1,0,0,0,24,79,0,0,0,0,0,0,6,0,0,0,16,209,1,0,1,0,0,0,24,79,0,0,0,0,0,0,7,0,0,0,56,207,1,0,1,0,0,0,24,79,0,0,0,0,0,0,7,0,0,0,192,204,1,0,1,0,0,0,24,79,0,0,0,0,0,0,7,0,0,0,128,202,1,0,1,0,0,0,24,79,0,0,0,0,0,0,9,0,0,0,16,200,1,0,1,0,0,0,24,79,0,0,0,0,0,0,9,0,0,0,48,198,1,0,1,0,0,0,24,79,0,0,0,0,0,0,8,0,0,0,40,196,1,0,1,0,0,0,24,79,0,0,0,0,0,0,0,0,0,0,72,194,1,0,1,0,0,0,232,78,0,0,0,0,0,0,1,0,0,0,16,192,1,0,1,0,0,0,232,78,0,0,0,0,0,0,2,0,0,0,200,189,1,0,1,0,0,0,232,78,0,0,0,0,0,0,2,0,0,0,240,187,1,0,1,0,0,0,232,78,0,0,0,0,0,0,2,0,0,0,64,186,1,0,1,0,0,0,232,78,0,0,0,0,0,0,4,0,0,0,8,184,1,0,1,0,0,0,232,78,0,0,0,0,0,0,4,0,0,0,32,182,1,0,1,0,0,0,232,78,0,0,0,0,0,0,3,0,0,0,232,179,1,0,1,0,0,0,232,78,0,0,0,0,0,0,18,0,0,0,64,178,1,0,1,0,0,0,0,79,0,0,0,0,0,0,27,0,0,0,184,176,1,0,1,0,0,0,248,78,0,0,0,0,0,0,28,0,0,0,96,175,1,0,1,0,0,0,248,78,0,0,0,0,0,0,29,0,0,0,168,173,1,0,1,0,0,0,248,78,0,0,0,0,0,0,29,0,0,0,16,172,1,0,1,0,0,0,248,78,0,0,0,0,0,0,29,0,0,0,224,170,1,0,1,0,0,0,248,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,84,2,0,0,0,0,0,160,79,0,0,152,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,48,193,1,0,200,1,0,0,144,73,2,0,76,2,0,0,152,228,1,0,76,2,0,0,120,199,1,0,162,2,0,0,88,179,1,0,162,2,0,0,144,162,1,0,10,0,0,0,232,146,1,0,10,0,0,0,176,130,1,0,180,0,0,0,232,114,1,0,180,0,0,0,32,101,1,0,40,0,0,0,40,119,2,0,40,0,0,0,8,105,2,0,156,0,0,0,200,91,2,0,156,0,0,0,128,81,2,0,86,1,0,0,0,0,0,0,240,100,1,0,1,0,0,0,0,0,0,0,144,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,67,2,0,1,0,0,0,0,0,0,0,200,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,96,2,0,1,0,0,0,0,0,0,0,0,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,67,2,0,1,0,0,0,0,0,0,0,56,81,0,0,1,0,0,0,136,66,2,0,1,0,0,0,0,0,0,0,56,81,0,0,2,0,0,0,72,65,2,0,1,0,0,0,0,0,0,0,24,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,240,29,2,0,1,0,0,0,0,0,0,0,112,81,0,0,2,0,0,0,192,213,1,0,1,0,0,0,0,0,0,0,168,81,0,0,0,0,0,0,32,192,1,0,1,0,0,0,0,0,0,0,168,81,0,0,3,0,0,0,136,173,1,0,1,0,0,0,0,0,0,0,168,81,0,0,0,0,0,0,80,157,1,0,1,0,0,0,0,0,0,0,112,81,0,0,3,0,0,0,128,141,1,0,1,0,0,0,0,0,0,0,112,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,75,2,0,1,0,0,0,0,0,0,0,224,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,164,1,0,1,0,0,0,0,0,0,0,80,82,0,0,0,0,0,0,232,148,1,0,1,0,0,0,0,0,0,0,80,82,0,0,1,0,0,0,152,132,1,0,1,0,0,0,0,0,0,0,136,82,0,0,2,0,0,0,208,116,1,0,1,0,0,0,0,0,0,0,80,82,0,0,3,0,0,0,32,103,1,0,1,0,0,0,0,0,0,0,80,82,0,0,4,0,0,0,72,121,2,0,1,0,0,0,0,0,0,0,80,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,0,0,0,208,0,0,0,22,2,0,0,166,2,0,0,48,2,0,0,2,1,0,0,114,2,0,0,154,2,0,0,174,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,207,1,0,192,205,1,0,160,203,1,0,0,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,100,0,0,0,32,201,1,0,224,198,1,0,224,196,1,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,139,2,0,72,139,2,0,24,139,2,0,64,139,2,0,48,139,2,0,32,139,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,205,1,0,104,2,0,0,168,202,1,0,140,2,0,0,40,200,1,0,60,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,1,0,112,199,1,0,80,179,1,0,136,162,1,0,224,146,1,0,168,130,1,0,224,114,1,0,24,101,1,0,0,0,0,0,0,0,0,0,14,2,0,0,144,1,0,0,0,0,0,0,0,0,0,0,84,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,2,0,0,148,2,0,0,82,1,0,0,18,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,1,0,0,82,2,0,0,224,1,0,0,156,2,0,0,32,0,0,0,30,2,0,0,108,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,2,0,0,126,0,0,0,164,1,0,0,60,0,0,0,0,0,0,0,38,0,0,0,80,191,1,0,198,0,0,0,24,189,1,0,193,0,0,0,80,187,1,0,194,0,0,0,152,185,1,0,192,0,0,0,64,183,1,0,145,3,0,0,32,181,1,0,197,0,0,0,72,179,1,0,195,0,0,0,152,177,1,0,196,0,0,0,48,176,1,0,146,3,0,0,128,174,1,0,199,0,0,0,224,172,1,0,167,3,0,0,144,171,1,0,33,32,0,0,40,170,1,0,148,3,0,0,112,168,1,0,208,0,0,0,32,166,1,0,201,0,0,0,32,164,1,0,202,0,0,0,168,162,1,0,200,0,0,0,88,161,1,0,149,3,0,0,192,159,1,0,151,3,0,0,56,158,1,0,203,0,0,0,216,156,1,0,147,3,0,0,120,155,1,0,205,0,0,0,56,154,1,0,206,0,0,0,144,152,1,0,204,0,0,0,184,150,1,0,153,3,0,0,192,148,1,0,207,0,0,0,104,147,1,0,154,3,0,0,240,145,1,0,155,3,0,0,176,144,1,0,156,3,0,0,248,142,1,0,209,0,0,0,64,141,1,0,157,3,0,0,8,139,1,0,82,1,0,0,168,137,1,0,211,0,0,0,16,136,1,0,212,0,0,0,88,134,1,0,210,0,0,0,120,132,1,0,169,3,0,0,32,131,1,0,159,3,0,0,88,129,1,0,216,0,0,0,208,127,1,0,213,0,0,0,64,126,1,0,214,0,0,0,112,124,1,0,166,3,0,0,16,123,1,0,160,3,0,0,56,121,1,0,51,32,0,0,192,119,1,0,168,3,0,0,72,118,1,0,161,3,0,0,176,116,1,0,96,1,0,0,104,115,1,0,163,3,0,0,72,114,1,0,222,0,0,0,40,113,1,0,164,3,0,0,152,111,1,0,152,3,0,0,104,110,1,0,218,0,0,0,248,108,1,0,219,0,0,0,184,107,1,0,217,0,0,0,88,106,1,0,165,3,0,0,240,104,1,0,220,0,0,0,240,102,1,0,158,3,0,0,160,101,1,0,221,0,0,0,136,100,1,0,120,1,0,0,40,99,1,0,150,3,0,0,232,97,1,0,225,0,0,0,200,96,1,0,226,0,0,0,120,95,1,0,180,0,0,0,104,125,2,0,230,0,0,0,56,124,2,0,224,0,0,0,8,123,2,0,53,33,0,0,24,121,2,0,177,3,0,0,184,119,2,0,38,0,0,0,168,118,2,0,39,34,0,0,144,117,2,0,32,34,0,0,16,116,2,0,229,0,0,0,232,114,2,0,72,34,0,0,152,113,2,0,227,0,0,0,56,112,2,0,228,0,0,0,200,110,2,0,30,32,0,0,8,109,2,0,178,3,0,0,120,107,2,0,166,0,0,0,72,106,2,0,34,32,0,0,160,104,2,0,41,34,0,0,80,103,2,0,231,0,0,0,240,101,2,0,184,0,0,0,176,100,2,0,162,0,0,0,160,99,2,0,199,3,0,0,80,98,2,0,198,2,0,0,176,96,2,0,99,38,0,0,128,95,2,0,69,34,0,0,40,94,2,0,169,0,0,0,248,92,2,0,181,33,0,0,112,91,2,0,42,34,0,0,128,90,2,0,164,0,0,0,56,89,2,0,211,33,0,0,224,87,2,0,32,32,0,0,104,86,2,0,147,33,0,0,40,85,2,0,176,0,0,0,224,83,2,0,180,3,0,0,96,82,2,0,102,38,0,0,184,80,2,0,247,0,0,0,32,79,2,0,233,0,0,0,120,76,2,0,234,0,0,0,48,76,2,0,232,0,0,0,216,74,2,0,5,34,0,0,216,73,2,0,3,32,0,0,120,72,2,0,2,32,0,0,64,71,2,0,181,3,0,0,112,70,2,0,97,34,0,0,104,69,2,0,183,3,0,0,232,67,2,0,240,0,0,0,208,66,2,0,235,0,0,0,176,65,2,0,172,32,0,0,192,64,2,0,3,34,0,0,192,63,2,0,146,1,0,0,176,62,2,0,0,34,0,0,80,61,2,0,189,0,0,0,96,60,2,0,188,0,0,0,144,59,2,0,190,0,0,0,112,58,2,0,68,32,0,0,8,57,2,0,179,3,0,0,232,55,2,0,101,34,0,0,216,54,2,0,62,0,0,0,216,53,2,0,212,33,0,0,200,52,2,0,148,33,0,0,232,51,2,0,101,38,0,0,248,50,2,0,38,32,0,0,72,49,2,0,237,0,0,0,72,48,2,0,238,0,0,0,128,46,2,0,161,0,0,0,72,45,2,0,236,0,0,0,0,44,2,0,17,33,0,0,8,43,2,0,30,34,0,0,248,41,2,0,43,34,0,0,232,40,2,0,185,3,0,0,224,39,2,0,191,0,0,0,248,38,2,0,8,34,0,0,160,34,2,0,239,0,0,0,200,33,2,0,186,3,0,0,144,32,2,0,208,33,0,0,128,31,2,0,187,3,0,0,80,30,2,0,41,35,0,0,64,29,2,0,171,0,0,0,88,28,2,0,144,33,0,0,32,27,2,0,8,35,0,0,64,26,2,0,28,32,0,0,88,25,2,0,100,34,0,0,24,24,2,0,10,35,0,0,32,23,2,0,23,34,0,0,16,22,2,0,202,37,0,0,184,20,2,0,14,32,0,0,120,19,2,0,57,32,0,0,128,18,2,0,24,32,0,0,200,17,2,0,60,0,0,0,8,17,2,0,175,0,0,0,56,16,2,0,20,32,0,0,72,15,2,0,181,0,0,0,112,14,2,0,183,0,0,0,184,13,2,0,18,34,0,0,168,12,2,0,188,3,0,0,136,11,2,0,7,34,0,0,32,10,2,0,160,0,0,0,32,9,2,0,19,32,0,0,224,7,2,0,96,34,0,0,240,6,2,0,11,34,0,0,40,6,2,0,172,0,0,0,128,5,2,0,9,34,0,0,224,4,2,0,132,34,0,0,80,4,2,0,241,0,0,0,136,3,2,0,189,3,0,0,192,2,2,0,243,0,0,0,192,1,2,0,244,0,0,0,24,1,2,0,83,1,0,0,112,0,2,0,242,0,0,0,208,255,1,0,62,32,0,0,72,255,1,0,201,3,0,0,136,254,1,0,191,3,0,0,224,253,1,0,149,34,0,0,64,253,1,0,40,34,0,0,72,252,1,0,170,0,0,0,168,251,1,0,186,0,0,0,0,251,1,0,248,0,0,0,80,250,1,0,245,0,0,0,80,249,1,0,151,34,0,0,160,248,1,0,246,0,0,0,248,247,1,0,182,0,0,0,72,247,1,0,2,34,0,0,136,246,1,0,48,32,0,0,200,245,1,0,165,34,0,0,96,244,1,0,198,3,0,0,104,243,1,0,192,3,0,0,40,242,1,0,214,3,0,0,48,241,1,0,177,0,0,0,216,239,1,0,163,0,0,0,248,238,1,0,50,32,0,0,0,238,1,0,15,34,0,0,96,237,1,0,29,34,0,0,120,236,1,0,200,3,0,0,144,235,1,0,34,0,0,0,72,234,1,0,210,33,0,0,24,233,1,0,26,34,0,0,24,232,1,0,42,35,0,0,112,231,1,0,187,0,0,0,144,230,1,0,146,33,0,0,208,229,1,0,9,35,0,0,88,229,1,0,29,32,0,0,224,228,1,0,28,33,0,0,8,228,1,0,174,0,0,0,120,227,1,0,11,35,0,0,80,226,1,0,193,3,0,0,104,225,1,0,15,32,0,0,112,224,1,0,58,32,0,0,192,223,1,0,25,32,0,0,144,222,1,0,26,32,0,0,104,222,1,0,97,1,0,0,160,221,1,0,197,34,0,0,32,221,1,0,167,0,0,0,120,220,1,0,173,0,0,0,96,220,1,0,195,3,0,0,0,220,1,0,194,3,0,0,192,219,1,0,60,34,0,0,88,219,1,0,96,38,0,0,48,219,1,0,130,34,0,0,8,219,1,0,134,34,0,0,208,218,1,0,17,34,0,0,176,218,1,0,131,34,0,0,136,218,1,0,185,0,0,0,104,218,1,0,178,0,0,0,80,218,1,0,179,0,0,0,224,217,1,0,135,34,0,0,88,217,1,0,223,0,0,0,248,216,1,0,196,3,0,0,208,216,1,0,52,34,0,0,160,216,1,0,184,3,0,0,64,216,1,0,209,3,0,0,8,216,1,0,9,32,0,0,224,215,1,0,254,0,0,0,144,215,1,0,220,2,0,0,120,215,1,0,215,0,0,0,24,215,1,0,34,33,0,0,168,214,1,0,209,33,0,0,72,214,1,0,250,0,0,0,232,213,1,0,145,33,0,0,176,213,1,0,251,0,0,0,120,213,1,0,249,0,0,0,80,213,1,0,168,0,0,0,40,213,1,0,210,3,0,0,8,213,1,0,197,3,0,0,176,212,1,0,252,0,0,0,96,212,1,0,24,33,0,0,16,212,1,0,190,3,0,0,192,211,1,0,253,0,0,0,160,211,1,0,165,0,0,0,88,211,1,0,255,0,0,0,32,211,1,0,182,3,0,0,0,211,1,0,13,32,0,0,216,210,1,0,12,32,0,0,186,0,0,0,0,0,0,0,10,1,0,0,0,0,0,0,164,0,0,0,0,0,0,0,44,2,0,0,0,0,0,0,118,1,0,0,0,0,0,0,44,1,0,0,0,0,0,0,160,1,0,0,0,0,0,0,140,0,0,0,0,0,0,0,64,46,0,0,136,79,1,0,16,2,0,0,176,77,1,0,176,77,1,0,200,44,0,0,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,78,2,0,0,28,0,0,0,0,0,0,0,0,0,0,0,40,1,0,0,50,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,79,84,65,84,73,79,78,40,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,78,77,84,79,75,69,78,83,0,0,0,0,0,0,0,0,78,77,84,79,75,69,78,0,73,68,82,69,70,83,0,0,73,68,82,69,70,0,0,0,73,68,0,0,0,0,0,0,69,78,84,73,84,89,0,0,69,78,84,73,84,73,69,83,0,0,0,0,0,0,0,0,67,68,65,84,65,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,96,0,0,0,0,0,0,0,0,0,0,0,0,0,66,64,0,0,0,0,0,0,66,64,0,0,0,0,0,32,131,64,0,0,0,0,0,192,136,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,2,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,150,64,0,0,0,0,0,128,150,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,64,0,0,0,0,0,0,66,64,0,0,0,0,0,32,131,64,0,0,0,0,0,192,136,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,153,1,0,224,150,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,212,1,0,85,93,201,127,201,127,255,0,104,191,1,0,187,45,212,190,174,212,255,0,232,172,1,0,20,119,253,253,192,134,255,0,224,156,1,0,85,93,201,127,201,127,255,0,72,141,1,0,187,45,212,190,174,212,255,0,120,124,1,0,20,119,253,253,192,134,255,0,128,110,1,0,42,102,255,255,255,153,255,0,224,96,1,0,85,93,201,127,201,127,255,0,0,115,2,0,187,45,212,190,174,212,255,0,128,100,2,0,20,119,253,253,192,134,255,0,176,87,2,0,42,102,255,255,255,153,255,0,168,73,2,0,151,173,176,56,108,176,255,0,112,62,2,0,85,93,201,127,201,127,255,0,168,51,2,0,187,45,212,190,174,212,255,0,160,39,2,0,20,119,253,253,192,134,255,0,0,26,2,0,42,102,255,255,255,153,255,0,248,15,2,0,151,173,176,56,108,176,255,0,216,5,2,0,232,252,240,240,2,127,255,0,16,255,1,0,85,93,201,127,201,127,255,0,192,247,1,0,187,45,212,190,174,212,255,0,192,237,1,0,20,119,253,253,192,134,255,0,32,229,1,0,42,102,255,255,255,153,255,0,96,221,1,0,151,173,176,56,108,176,255,0,144,218,1,0,232,252,240,240,2,127,255,0,232,215,1,0,17,224,191,191,91,23,255,0,48,213,1,0,85,93,201,127,201,127,255,0,224,210,1,0,187,45,212,190,174,212,255,0,192,208,1,0,20,119,253,253,192,134,255,0,240,206,1,0,42,102,255,255,255,153,255,0,120,204,1,0,151,173,176,56,108,176,255,0,8,202,1,0,232,252,240,240,2,127,255,0,200,199,1,0,17,224,191,191,91,23,255,0,224,197,1,0,0,0,102,102,102,102,255,0,232,195,1,0,147,25,247,222,235,247,255,0,248,193,1,0,142,75,225,158,202,225,255,0,168,191,1,0,145,188,189,49,130,189,255,0,128,189,1,0,159,16,255,239,243,255,255,0,168,187,1,0,143,46,231,189,215,231,255,0,248,185,1,0,143,127,214,107,174,214,255,0,144,183,1,0,147,208,181,33,113,181,255,0,136,181,1,0,159,16,255,239,243,255,255,0,176,179,1,0,143,46,231,189,215,231,255,0,0,178,1,0,143,127,214,107,174,214,255,0,128,176,1,0,145,188,189,49,130,189,255,0,0,175,1,0,149,241,156,8,81,156,255,0,56,173,1,0,159,16,255,239,243,255,255,0,216,171,1,0,148,43,239,198,219,239,255,0,112,170,1,0,142,75,225,158,202,225,255,0,216,168,1,0,143,127,214,107,174,214,255,0,96,166,1,0,145,188,189,49,130,189,255,0,136,164,1,0,149,241,156,8,81,156,255,0,232,162,1,0,159,16,255,239,243,255,255,0,152,161,1,0,148,43,239,198,219,239,255,0,24,160,1,0,142,75,225,158,202,225,255,0,176,158,1,0,143,127,214,107,174,214,255,0,64,157,1,0,144,169,198,66,146,198,255,0,192,155,1,0,147,208,181,33,113,181,255,0,136,154,1,0,151,241,148,8,69,148,255,0,24,153,1,0,148,8,255,247,251,255,255,0,16,151,1,0,147,25,247,222,235,247,255,0,56,149,1,0,148,43,239,198,219,239,255,0,176,147,1,0,142,75,225,158,202,225,255,0,64,146,1,0,143,127,214,107,174,214,255,0,240,144,1,0,144,169,198,66,146,198,255,0,112,143,1,0,147,208,181,33,113,181,255,0,160,141,1,0,151,241,148,8,69,148,255,0,32,140,1,0,148,8,255,247,251,255,255,0,240,137,1,0,147,25,247,222,235,247,255,0,144,136,1,0,148,43,239,198,219,239,255,0,160,134,1,0,142,75,225,158,202,225,255,0,224,132,1,0,143,127,214,107,174,214,255,0,96,131,1,0,144,169,198,66,146,198,255,0,152,129,1,0,147,208,181,33,113,181,255,0,24,128,1,0,149,241,156,8,81,156,255,0,184,126,1,0,152,235,107,8,48,107,255,0,192,124,1,0,23,239,84,84,48,5,255,0,104,123,1,0,119,255,60,0,60,48,255,0,168,121,1,0,23,236,140,140,81,10,255,0,56,120,1,0,24,194,191,191,129,45,255,0,136,118,1,0,29,112,223,223,194,125,255,0,56,117,1,0,30,52,246,246,232,195,255,0,216,115,1,0,121,38,234,199,234,229,255,0,136,114,1,0,120,95,205,128,205,193,255,0,112,113,1,0,124,165,151,53,151,143,255,0,32,112,1,0,124,252,102,1,102,94,255,0,208,110,1,0,23,239,84,84,48,5,255,0,104,109,1,0,124,252,102,1,102,94,255,0,24,108,1,0,119,255,60,0,60,48,255,0,176,106,1,0,23,236,140,140,81,10,255,0,64,105,1,0,24,194,191,191,129,45,255,0,176,103,1,0,29,112,223,223,194,125,255,0,0,102,1,0,30,52,246,246,232,195,255,0,208,100,1,0,0,0,245,245,245,245,255,0,112,99,1,0,121,38,234,199,234,229,255,0,88,98,1,0,120,95,205,128,205,193,255,0,32,97,1,0,124,165,151,53,151,143,255,0,240,95,1,0,28,135,216,216,179,101,255,0,144,94,1,0,0,0,245,245,245,245,255,0,144,124,2,0,123,127,180,90,180,172,255,0,72,123,2,0,21,215,166,166,97,26,255,0,184,121,2,0,29,112,223,223,194,125,255,0,24,120,2,0,120,95,205,128,205,193,255,0,232,118,2,0,121,253,133,1,133,113,255,0,208,117,2,0,21,215,166,166,97,26,255,0,120,116,2,0,29,112,223,223,194,125,255,0,56,115,2,0,0,0,245,245,245,245,255,0,232,113,2,0,120,95,205,128,205,193,255,0,168,112,2,0,121,253,133,1,133,113,255,0,96,111,2,0,23,236,140,140,81,10,255,0,128,109,2,0,28,135,216,216,179,101,255,0,216,107,2,0,30,52,246,246,232,195,255,0,80,106,2,0,121,38,234,199,234,229,255,0,168,104,2,0,123,127,180,90,180,172,255,0,88,103,2,0,124,252,102,1,102,94,255,0,248,101,2,0,23,236,140,140,81,10,255,0,184,100,2,0,28,135,216,216,179,101,255,0,168,99,2,0,30,52,246,246,232,195,255,0,96,98,2,0,0,0,245,245,245,245,255,0,32,97,2,0,121,38,234,199,234,229,255,0,136,95,2,0,123,127,180,90,180,172,255,0,72,94,2,0,124,252,102,1,102,94,255,0,0,93,2,0,23,236,140,140,81,10,255,0,184,91,2,0,24,194,191,191,129,45,255,0,136,90,2,0,29,112,223,223,194,125,255,0,64,89,2,0,30,52,246,246,232,195,255,0,232,87,2,0,121,38,234,199,234,229,255,0,112,86,2,0,120,95,205,128,205,193,255,0,56,85,2,0,124,165,151,53,151,143,255,0,232,83,2,0,124,252,102,1,102,94,255,0,104,82,2,0,23,236,140,140,81,10,255,0,192,80,2,0,24,194,191,191,129,45,255,0,40,79,2,0,29,112,223,223,194,125,255,0,104,77,2,0,30,52,246,246,232,195,255,0,56,76,2,0,0,0,245,245,245,245,255,0,224,74,2,0,121,38,234,199,234,229,255,0,224,73,2,0,120,95,205,128,205,193,255,0,128,72,2,0,124,165,151,53,151,143,255,0,80,71,2,0,124,252,102,1,102,94,255,0,120,70,2,0,135,20,249,229,245,249,255,0,112,69,2,0,117,74,216,153,216,201,255,0,248,67,2,0,103,185,162,44,162,95,255,0,216,66,2,0,136,14,251,237,248,251,255,0,184,65,2,0,127,54,226,178,226,226,255,0,200,64,2,0,113,120,194,102,194,164,255,0,200,63,2,0,98,190,139,35,139,69,255,0,184,62,2,0,136,14,251,237,248,251,255,0,88,61,2,0,127,54,226,178,226,226,255,0,112,60,2,0,113,120,194,102,194,164,255,0,152,59,2,0,103,185,162,44,162,95,255,0,120,58,2,0,102,255,109,0,109,44,255,0,16,57,2,0,136,14,251,237,248,251,255,0,240,55,2,0,119,34,236,204,236,230,255,0,224,54,2,0,117,74,216,153,216,201,255,0,224,53,2,0,113,120,194,102,194,164,255,0,208,52,2,0,103,185,162,44,162,95,255,0,240,51,2,0,102,255,109,0,109,44,255,0,0,51,2,0,136,14,251,237,248,251,255,0,96,49,2,0,119,34,236,204,236,230,255,0,80,48,2,0,117,74,216,153,216,201,255,0,136,46,2,0,113,120,194,102,194,164,255,0,80,45,2,0,105,159,174,65,174,118,255,0,8,44,2,0,98,190,139,35,139,69,255,0,16,43,2,0,102,255,88,0,88,36,255,0,0,42,2,0,134,6,253,247,252,253,255,0,240,40,2,0,135,20,249,229,245,249,255,0,232,39,2,0,119,34,236,204,236,230,255,0,0,39,2,0,117,74,216,153,216,201,255,0,176,34,2,0,113,120,194,102,194,164,255,0,208,33,2,0,105,159,174,65,174,118,255,0,152,32,2,0,98,190,139,35,139,69,255,0,136,31,2,0,102,255,88,0,88,36,255,0,88,30,2,0,134,6,253,247,252,253,255,0,72,29,2,0,135,20,249,229,245,249,255,0,96,28,2,0,119,34,236,204,236,230,255,0,40,27,2,0,117,74,216,153,216,201,255,0,72,26,2,0,113,120,194,102,194,164,255,0,96,25,2,0,105,159,174,65,174,118,255,0,40,24,2,0,98,190,139,35,139,69,255,0,40,23,2,0,102,255,109,0,109,44,255,0,24,22,2,0,101,255,68,0,68,27,255,0,192,20,2,0,144,20,244,224,236,244,255,0,128,19,2,0,148,70,218,158,188,218,255,0,136,18,2,0,196,123,167,136,86,167,255,0,208,17,2,0,136,14,251,237,248,251,255,0,16,17,2,0,146,53,227,179,205,227,255,0,64,16,2,0,162,74,198,140,150,198,255,0,80,15,2,0,202,149,157,136,65,157,255,0,128,14,2,0,136,14,251,237,248,251,255,0,192,13,2,0,146,53,227,179,205,227,255,0,176,12,2,0,162,74,198,140,150,198,255,0,144,11,2,0,196,123,167,136,86,167,255,0,40,10,2,0,214,225,129,129,15,124,255,0,240,9,2,0,136,14,251,237,248,251,255,0,240,8,2,0,148,43,230,191,211,230,255,0,176,7,2,0,148,70,218,158,188,218,255,0,192,6,2,0,162,74,198,140,150,198,255,0,248,5,2,0,196,123,167,136,86,167,255,0,96,5,2,0,214,225,129,129,15,124,255,0,192,4,2,0,136,14,251,237,248,251,255,0,48,4,2,0,148,43,230,191,211,230,255,0,104,3,2,0,148,70,218,158,188,218,255,0,152,2,2,0,162,74,198,140,150,198,255,0,152,1,2,0,190,100,177,140,107,177,255,0,248,0,2,0,202,149,157,136,65,157,255,0,80,0,2,0,213,252,110,110,1,107,255,0,176,255,1,0,134,6,253,247,252,253,255,0,40,255,1,0,144,20,244,224,236,244,255,0,96,254,1,0,148,43,230,191,211,230,255,0,184,253,1,0,148,70,218,158,188,218,255,0,32,253,1,0,162,74,198,140,150,198,255,0,40,252,1,0,190,100,177,140,107,177,255,0,128,251,1,0,202,149,157,136,65,157,255,0,224,250,1,0,213,252,110,110,1,107,255,0,48,250,1,0,134,6,253,247,252,253,255,0,48,249,1,0,144,20,244,224,236,244,255,0,128,248,1,0,148,43,230,191,211,230,255,0,216,247,1,0,148,70,218,158,188,218,255,0,40,247,1,0,162,74,198,140,150,198,255,0,88,246,1,0,190,100,177,140,107,177,255,0,168,245,1,0,202,149,157,136,65,157,255,0,120,244,1,0,214,225,129,129,15,124,255,0,48,243,1,0,213,255,77,77,0,75,255,0,248,241,1,0,114,211,158,27,158,119,255,0,192,240,1,0,18,252,217,217,95,2,255,0,168,239,1,0,173,95,179,117,112,179,255,0,200,238,1,0,114,211,158,27,158,119,255,0,216,237,1,0,18,252,217,217,95,2,255,0,64,237,1,0,173,95,179,117,112,179,255,0,72,236,1,0,233,209,231,231,41,138,255,0,96,235,1,0,114,211,158,27,158,119,255,0,24,234,1,0,18,252,217,217,95,2,255,0,232,232,1,0,173,95,179,117,112,179,255,0,240,231,1,0,233,209,231,231,41,138,255,0,64,231,1,0,62,208,166,102,166,30,255,0,88,230,1,0,114,211,158,27,158,119,255,0,176,229,1,0,18,252,217,217,95,2,255,0,56,229,1,0,173,95,179,117,112,179,255,0,176,228,1,0,233,209,231,231,41,138,255,0,224,227,1,0,62,208,166,102,166,30,255,0,72,227,1,0,31,252,230,230,171,2,255,0,48,226,1,0,114,211,158,27,158,119,255,0,48,225,1,0,18,252,217,217,95,2,255,0,80,224,1,0,173,95,179,117,112,179,255,0,136,223,1,0,233,209,231,231,41,138,255,0,248,222,1,0,62,208,166,102,166,30,255,0,56,222,1,0,31,252,230,230,171,2,255,0,128,221,1,0,27,210,166,166,118,29,255,0,0,221,1,0,114,211,158,27,158,119,255,0,104,220,1,0,18,252,217,217,95,2,255,0,64,220,1,0,173,95,179,117,112,179,255,0,240,219,1,0,233,209,231,231,41,138,255,0,160,219,1,0,62,208,166,102,166,30,255,0,72,219,1,0,31,252,230,230,171,2,255,0,24,219,1,0,27,210,166,166,118,29,255,0,248,218,1,0,0,0,102,102,102,102,255,0,192,218,1,0,76,25,243,224,243,219,255,0,160,218,1,0,95,61,221,168,221,181,255,0,120,218,1,0,140,170,202,67,162,202,255,0,88,218,1,0,65,17,249,240,249,232,255,0,48,218,1,0,87,46,228,186,228,188,255,0,200,217,1,0,123,101,204,123,204,196,255,0,64,217,1,0,141,197,190,43,140,190,255,0,232,216,1,0,65,17,249,240,249,232,255,0,176,216,1,0,87,46,228,186,228,188,255,0,144,216,1,0,123,101,204,123,204,196,255,0,48,216,1,0,140,170,202,67,162,202,255,0,248,215,1,0,145,243,172,8,104,172,255,0,184,215,1,0,65,17,249,240,249,232,255,0,128,215,1,0,77,41,235,204,235,197,255,0,80,215,1,0,95,61,221,168,221,181,255,0,8,215,1,0,123,101,204,123,204,196,255,0,144,214,1,0,140,170,202,67,162,202,255,0,56,214,1,0,145,243,172,8,104,172,255,0,208,213,1,0,65,17,249,240,249,232,255,0,160,213,1,0,77,41,235,204,235,197,255,0,104,213,1,0,95,61,221,168,221,181,255,0,64,213,1,0,123,101,204,123,204,196,255,0,24,213,1,0,137,160,211,78,179,211,255,0,224,212,1,0,141,197,190,43,140,190,255,0,152,212,1,0,147,242,158,8,88,158,255,0,80,212,1,0,60,12,252,247,252,240,255,0,248,211,1,0,76,25,243,224,243,219,255,0,176,211,1,0,77,41,235,204,235,197,255,0,104,211,1,0,95,61,221,168,221,181,255,0,72,211,1,0,123,101,204,123,204,196,255,0,16,211,1,0,137,160,211,78,179,211,255,0,240,210,1,0,141,197,190,43,140,190,255,0,200,210,1,0,147,242,158,8,88,158,255,0,160,210,1,0,60,12,252,247,252,240,255,0,136,210,1,0,76,25,243,224,243,219,255,0,64,210,1,0,77,41,235,204,235,197,255,0,224,209,1,0,95,61,221,168,221,181,255,0,152,209,1,0,123,101,204,123,204,196,255,0,80,209,1,0,137,160,211,78,179,211,255,0,24,209,1,0,141,197,190,43,140,190,255,0,232,208,1,0,145,243,172,8,104,172,255,0,208,208,1,0,150,239,129,8,64,129,255,0,176,208,1,0,74,21,245,229,245,224,255,0,136,208,1,0,80,72,217,161,217,155,255,0,112,208,1,0,98,178,163,49,163,84,255,0,24,208,1,0,73,15,248,237,248,233,255,0,224,207,1,0,78,54,228,186,228,179,255,0,136,207,1,0,86,104,196,116,196,118,255,0,112,207,1,0,98,190,139,35,139,69,255,0,72,207,1,0,73,15,248,237,248,233,255,0,24,207,1,0,78,54,228,186,228,179,255,0,0,207,1,0,86,104,196,116,196,118,255,0,224,206,1,0,98,178,163,49,163,84,255,0,200,206,1,0,102,255,109,0,109,44,255,0,176,206,1,0,73,15,248,237,248,233,255,0,232,205,1,0,77,44,233,199,233,192,255,0,152,205,1,0,80,72,217,161,217,155,255,0,56,205,1,0,86,104,196,116,196,118,255,0,32,205,1,0,98,178,163,49,163,84,255,0,0,205,1,0,102,255,109,0,109,44,255,0,160,204,1,0,73,15,248,237,248,233,255,0,136,204,1,0,77,44,233,199,233,192,255,0,104,204,1,0,80,72,217,161,217,155,255,0,80,204,1,0,86,104,196,116,196,118,255,0,64,204,1,0,96,158,171,65,171,93,255,0,216,203,1,0,98,190,139,35,139,69,255,0,88,203,1,0,108,255,90,0,90,50,255,0,16,203,1,0,72,7,252,247,252,245,255,0,240,202,1,0,74,21,245,229,245,224,255,0,152,202,1,0,77,44,233,199,233,192,255,0,88,202,1,0,80,72,217,161,217,155,255,0,24,202,1,0,86,104,196,116,196,118,255,0,248,201,1,0,96,158,171,65,171,93,255,0,184,201,1,0,98,190,139,35,139,69,255,0,152,201,1,0,108,255,90,0,90,50,255,0,64,201,1,0,72,7,252,247,252,245,255,0,240,200,1,0,74,21,245,229,245,224,255,0,144,200,1,0,77,44,233,199,233,192,255,0,64,200,1,0,80,72,217,161,217,155,255,0,24,200,1,0,86,104,196,116,196,118,255,0,248,199,1,0,96,158,171,65,171,93,255,0,216,199,1,0,98,190,139,35,139,69,255,0,184,199,1,0,102,255,109,0,109,44,255,0,128,199,1,0,101,255,68,0,68,27,255,0,96,199,1,0,0,0,240,240,240,240,255,0,240,198,1,0,0,0,189,189,189,189,255,0,200,198,1,0,0,0,99,99,99,99,255,0,120,198,1,0,0,0,247,247,247,247,255,0,96,198,1,0,0,0,204,204,204,204,255,0,56,198,1,0,0,0,150,150,150,150,255,0,24,198,1,0,0,0,82,82,82,82,255,0,240,197,1,0,0,0,247,247,247,247,255,0,208,197,1,0,0,0,204,204,204,204,255,0,160,197,1,0,0,0,150,150,150,150,255,0,136,197,1,0,0,0,99,99,99,99,255,0,248,196,1,0,0,0,37,37,37,37,255,0,200,196,1,0,0,0,247,247,247,247,255,0,136,196,1,0,0,0,217,217,217,217,255,0,104,196,1,0,0,0,189,189,189,189,255,0,48,196,1,0,0,0,150,150,150,150,255,0,16,196,1,0,0,0,99,99,99,99,255,0,248,195,1,0,0,0,37,37,37,37,255,0,216,195,1,0,0,0,247,247,247,247,255,0,176,195,1,0,0,0,217,217,217,217,255,0,160,195,1,0,0,0,189,189,189,189,255,0,88,195,1,0,0,0,150,150,150,150,255,0,24,195,1,0,0,0,115,115,115,115,255,0,192,194,1,0,0,0,82,82,82,82,255,0,160,194,1,0,0,0,37,37,37,37,255,0,88,194,1,0,0,0,255,255,255,255,255,0,48,194,1,0,0,0,240,240,240,240,255,0,8,194,1,0,0,0,217,217,217,217,255,0,232,193,1,0,0,0,189,189,189,189,255,0,136,193,1,0,0,0,150,150,150,150,255,0,120,193,1,0,0,0,115,115,115,115,255,0,72,193,1,0,0,0,82,82,82,82,255,0,240,192,1,0,0,0,37,37,37,37,255,0,160,192,1,0,0,0,255,255,255,255,255,0,128,192,1,0,0,0,240,240,240,240,255,0,48,192,1,0,0,0,217,217,217,217,255,0,248,191,1,0,0,0,189,189,189,189,255,0,216,191,1,0,0,0,150,150,150,150,255,0,152,191,1,0,0,0,115,115,115,115,255,0,120,191,1,0,0,0,82,82,82,82,255,0,88,191,1,0,0,0,37,37,37,37,255,0,64,191,1,0,0,0,0,0,0,0,255,0,224,190,1,0,21,48,254,254,230,206,255,0,80,190,1,0,19,147,253,253,174,107,255,0,8,190,1,0,14,240,230,230,85,13,255,0,216,189,1,0,19,32,254,254,237,222,255,0,176,189,1,0,20,120,253,253,190,133,255,0,144,189,1,0,17,194,253,253,141,60,255,0,112,189,1,0,13,253,217,217,71,1,255,0,48,189,1,0,19,32,254,254,237,222,255,0,32,189,1,0,20,120,253,253,190,133,255,0,8,189,1,0,17,194,253,253,141,60,255,0,208,188,1,0,14,240,230,230,85,13,255,0,72,188,1,0,13,250,166,166,54,3,255,0,48,188,1,0,19,32,254,254,237,222,255,0,0,188,1,0,21,91,253,253,208,162,255,0,216,187,1,0,19,147,253,253,174,107,255,0,184,187,1,0,17,194,253,253,141,60,255,0,152,187,1,0,14,240,230,230,85,13,255,0,104,187,1,0,13,250,166,166,54,3,255,0,88,187,1,0,19,32,254,254,237,222,255,0,64,187,1,0,21,91,253,253,208,162,255,0,16,187,1,0,19,147,253,253,174,107,255,0,152,186,1,0,17,194,253,253,141,60,255,0,128,186,1,0,16,234,241,241,105,19,255,0,80,186,1,0,13,253,217,217,72,1,255,0,40,186,1,0,12,247,140,140,45,4,255,0,8,186,1,0,21,20,255,255,245,235,255,0,232,185,1,0,21,48,254,254,230,206,255,0,184,185,1,0,21,91,253,253,208,162,255,0,160,185,1,0,19,147,253,253,174,107,255,0,72,185,1,0,17,194,253,253,141,60,255,0,248,184,1,0,16,234,241,241,105,19,255,0,64,184,1,0,13,253,217,217,72,1,255,0,48,184,1,0,12,247,140,140,45,4,255,0,16,184,1,0,21,20,255,255,245,235,255,0,248,183,1,0,21,48,254,254,230,206,255,0,160,183,1,0,21,91,253,253,208,162,255,0,128,183,1,0,19,147,253,253,174,107,255,0,88,183,1,0,17,194,253,253,141,60,255,0,72,183,1,0,16,234,241,241,105,19,255,0,40,183,1,0,13,253,217,217,72,1,255,0,0,183,1,0,13,250,166,166,54,3,255,0,120,182,1,0,12,246,127,127,39,4,255,0,104,182,1,0,25,54,254,254,232,200,255,0,48,182,1,0,19,121,253,253,187,132,255,0,8,182,1,0,5,197,227,227,74,51,255,0,152,181,1,0,26,37,254,254,240,217,255,0,120,181,1,0,24,115,253,253,204,138,255,0,72,181,1,0,13,164,252,252,141,89,255,0,40,181,1,0,3,218,215,215,48,31,255,0,16,181,1,0,26,37,254,254,240,217,255,0,232,180,1,0,24,115,253,253,204,138,255,0,80,180,1,0,13,164,252,252,141,89,255,0,56,180,1,0,5,197,227,227,74,51,255,0,248,179,1,0,0,255,179,179,0,0,255,0,216,179,1,0,26,37,254,254,240,217,255,0,192,179,1,0,24,95,253,253,212,158,255,0,160,179,1,0,19,121,253,253,187,132,255,0,120,179,1,0,13,164,252,252,141,89,255,0,104,179,1,0,5,197,227,227,74,51,255,0,56,179,1,0,0,255,179,179,0,0,255,0,24,179,1,0,26,37,254,254,240,217,255,0,136,178,1,0,24,95,253,253,212,158,255,0,120,178,1,0,19,121,253,253,187,132,255,0,72,178,1,0,13,164,252,252,141,89,255,0,48,178,1,0,7,178,239,239,101,72,255,0,16,178,1,0,3,218,215,215,48,31,255,0,240,177,1,0,0,255,153,153,0,0,255,0,200,177,1,0,24,18,255,255,247,236,255,0,184,177,1,0,25,54,254,254,232,200,255,0,136,177,1,0,24,95,253,253,212,158,255,0,104,177,1,0,19,121,253,253,187,132,255,0,248,176,1,0,13,164,252,252,141,89,255,0,232,176,1,0,7,178,239,239,101,72,255,0,192,176,1,0,3,218,215,215,48,31,255,0,168,176,1,0,0,255,153,153,0,0,255,0,144,176,1,0,24,18,255,255,247,236,255,0,112,176,1,0,25,54,254,254,232,200,255,0,72,176,1,0,24,95,253,253,212,158,255,0,56,176,1,0,19,121,253,253,187,132,255,0,32,176,1,0,13,164,252,252,141,89,255,0,232,175,1,0,7,178,239,239,101,72,255,0,176,175,1,0,3,218,215,215,48,31,255,0,152,175,1,0,0,255,179,179,0,0,255,0,104,175,1,0,0,255,127,127,0,0,255,0,80,175,1,0,142,68,227,166,206,227,255,0,16,175,1,0,190,153,154,106,61,154,255,0,240,174,1,0,144,211,180,31,120,180,255,0,160,174,1,0,65,97,223,178,223,138,255,0,144,174,1,0,82,184,160,51,160,44,255,0,112,174,1,0,0,99,251,251,154,153,255,0,40,174,1,0,254,225,227,227,26,28,255,0,232,173,1,0,23,143,253,253,191,111,255,0,216,173,1,0,21,255,255,255,127,0,255,0,184,173,1,0,198,42,214,202,178,214,255,0,152,173,1,0,142,68,227,166,206,227,255,0,72,173,1,0,190,153,154,106,61,154,255,0,40,173,1,0,42,102,255,255,255,153,255,0,8,173,1,0,144,211,180,31,120,180,255,0,248,172,1,0,65,97,223,178,223,138,255,0,208,172,1,0,82,184,160,51,160,44,255,0,160,172,1,0,0,99,251,251,154,153,255,0,96,172,1,0,254,225,227,227,26,28,255,0,80,172,1,0,23,143,253,253,191,111,255,0,24,172,1,0,21,255,255,255,127,0,255,0,0,172,1,0,198,42,214,202,178,214,255,0,232,171,1,0,142,68,227,166,206,227,255,0,200,171,1,0,190,153,154,106,61,154,255,0,168,171,1,0,42,102,255,255,255,153,255,0,152,171,1,0,15,197,177,177,89,40,255,0,128,171,1,0,144,211,180,31,120,180,255,0,88,171,1,0,65,97,223,178,223,138,255,0,32,171,1,0,82,184,160,51,160,44,255,0,16,171,1,0,0,99,251,251,154,153,255,0,232,170,1,0,254,225,227,227,26,28,255,0,208,170,1,0,23,143,253,253,191,111,255,0,128,170,1,0,21,255,255,255,127,0,255,0,96,170,1,0,198,42,214,202,178,214,255,0,64,170,1,0,142,68,227,166,206,227,255,0,48,170,1,0,144,211,180,31,120,180,255,0,24,170,1,0,65,97,223,178,223,138,255,0,248,169,1,0,142,68,227,166,206,227,255,0,184,169,1,0,144,211,180,31,120,180,255,0,168,169,1,0,65,97,223,178,223,138,255,0,136,169,1,0,82,184,160,51,160,44,255,0,24,169,1,0,142,68,227,166,206,227,255,0,232,168,1,0,144,211,180,31,120,180,255,0,200,168,1,0,65,97,223,178,223,138,255,0,168,168,1,0,82,184,160,51,160,44,255,0,144,168,1,0,0,99,251,251,154,153,255,0,184,167,1,0,142,68,227,166,206,227,255,0,64,167,1,0,144,211,180,31,120,180,255,0,224,166,1,0,65,97,223,178,223,138,255,0,208,166,1,0,82,184,160,51,160,44,255,0,168,166,1,0,0,99,251,251,154,153,255,0,144,166,1,0,254,225,227,227,26,28,255,0,120,166,1,0,142,68,227,166,206,227,255,0,80,166,1,0,144,211,180,31,120,180,255,0,56,166,1,0,65,97,223,178,223,138,255,0,40,166,1,0,82,184,160,51,160,44,255,0,16,166,1,0,0,99,251,251,154,153,255,0,216,165,1,0,254,225,227,227,26,28,255,0,152,165,1,0,23,143,253,253,191,111,255,0,72,165,1,0,142,68,227,166,206,227,255,0,24,165,1,0,144,211,180,31,120,180,255,0,232,164,1,0,65,97,223,178,223,138,255,0,168,164,1,0,82,184,160,51,160,44,255,0,120,164,1,0,0,99,251,251,154,153,255,0,80,164,1,0,254,225,227,227,26,28,255,0,40,164,1,0,23,143,253,253,191,111,255,0,16,164,1,0,21,255,255,255,127,0,255,0,232,163,1,0,142,68,227,166,206,227,255,0,128,163,1,0,144,211,180,31,120,180,255,0,88,163,1,0,65,97,223,178,223,138,255,0,56,163,1,0,82,184,160,51,160,44,255,0,24,163,1,0,0,99,251,251,154,153,255,0,248,162,1,0,254,225,227,227,26,28,255,0,216,162,1,0,23,143,253,253,191,111,255,0,192,162,1,0,21,255,255,255,127,0,255,0,176,162,1,0,198,42,214,202,178,214,255,0,152,162,1,0,3,78,251,251,180,174,255,0,88,162,1,0,146,53,227,179,205,227,255,0,16,162,1,0,77,41,235,204,235,197,255,0,0,162,1,0,3,78,251,251,180,174,255,0,224,161,1,0,146,53,227,179,205,227,255,0,200,161,1,0,77,41,235,204,235,197,255,0,168,161,1,0,202,27,228,222,203,228,255,0,136,161,1,0,3,78,251,251,180,174,255,0,112,161,1,0,146,53,227,179,205,227,255,0,96,161,1,0,77,41,235,204,235,197,255,0,72,161,1,0,202,27,228,222,203,228,255,0,8,161,1,0,24,88,254,254,217,166,255,0,168,160,1,0,3,78,251,251,180,174,255,0,152,160,1,0,146,53,227,179,205,227,255,0,96,160,1,0,77,41,235,204,235,197,255,0,64,160,1,0,202,27,228,222,203,228,255,0,40,160,1,0,24,88,254,254,217,166,255,0,8,160,1,0,42,50,255,255,255,204,255,0,240,159,1,0,3,78,251,251,180,174,255,0,224,159,1,0,146,53,227,179,205,227,255,0,176,159,1,0,77,41,235,204,235,197,255,0,120,159,1,0,202,27,228,222,203,228,255,0,64,159,1,0,24,88,254,254,217,166,255,0,48,159,1,0,42,50,255,255,255,204,255,0,16,159,1,0,28,44,229,229,216,189,255,0,248,158,1,0,3,78,251,251,180,174,255,0,192,158,1,0,146,53,227,179,205,227,255,0,160,158,1,0,77,41,235,204,235,197,255,0,88,158,1,0,202,27,228,222,203,228,255,0,72,158,1,0,24,88,254,254,217,166,255,0,40,158,1,0,42,50,255,255,255,204,255,0,0,158,1,0,28,44,229,229,216,189,255,0,208,157,1,0,233,35,253,253,218,236,255,0,192,157,1,0,3,78,251,251,180,174,255,0,144,157,1,0,146,53,227,179,205,227,255,0,120,157,1,0,77,41,235,204,235,197,255,0,96,157,1,0,202,27,228,222,203,228,255,0,48,157,1,0,24,88,254,254,217,166,255,0,16,157,1,0,42,50,255,255,255,204,255,0,240,156,1,0,28,44,229,229,216,189,255,0,200,156,1,0,233,35,253,253,218,236,255,0,160,156,1,0,0,0,242,242,242,242,255,0,128,156,1,0,108,53,226,179,226,205,255,0,80,156,1,0,17,81,253,253,205,172,255,0,40,156,1,0,155,31,232,203,213,232,255,0,232,155,1,0,108,53,226,179,226,205,255,0,208,155,1,0,17,81,253,253,205,172,255,0,176,155,1,0,155,31,232,203,213,232,255,0,144,155,1,0,228,43,244,244,202,228,255,0,128,155,1,0,108,53,226,179,226,205,255,0,104,155,1,0,17,81,253,253,205,172,255,0,56,155,1,0,155,31,232,203,213,232,255,0,16,155,1,0,228,43,244,244,202,228,255,0,240,154,1,0,56,45,245,230,245,201,255,0,208,154,1,0,108,53,226,179,226,205,255,0,176,154,1,0,17,81,253,253,205,172,255,0,152,154,1,0,155,31,232,203,213,232,255,0,120,154,1,0,228,43,244,244,202,228,255,0,80,154,1,0,56,45,245,230,245,201,255,0,64,154,1,0,35,81,255,255,242,174,255,0,40,154,1,0,108,53,226,179,226,205,255,0,232,153,1,0,17,81,253,253,205,172,255,0,200,153,1,0,155,31,232,203,213,232,255,0,176,153,1,0,228,43,244,244,202,228,255,0,112,153,1,0,56,45,245,230,245,201,255,0,64,153,1,0,35,81,255,255,242,174,255,0,40,153,1,0,25,39,241,241,226,204,255,0,8,153,1,0,108,53,226,179,226,205,255,0,184,152,1,0,17,81,253,253,205,172,255,0,152,152,1,0,155,31,232,203,213,232,255,0,88,152,1,0,228,43,244,244,202,228,255,0,248,151,1,0,56,45,245,230,245,201,255,0,192,151,1,0,35,81,255,255,242,174,255,0,160,151,1,0,25,39,241,241,226,204,255,0,96,151,1,0,0,0,204,204,204,204,255,0,64,151,1,0,230,253,142,142,1,82,255,0,32,151,1,0,77,191,100,39,100,25,255,0,240,150,1,0,230,220,197,197,27,125,255,0,208,150,1,0,232,118,222,222,119,174,255,0,192,150,1,0])
.concat([229,62,241,241,182,218,255,0,168,150,1,0,233,29,253,253,224,239,255,0,128,150,1,0,59,38,245,230,245,208,255,0,88,150,1,0,61,103,225,184,225,134,255,0,56,150,1,0,63,166,188,127,188,65,255,0,176,149,1,0,68,197,146,77,146,33,255,0,128,149,1,0,230,253,142,142,1,82,255,0,72,149,1,0,68,197,146,77,146,33,255,0,40,149,1,0,77,191,100,39,100,25,255,0,240,148,1,0,230,220,197,197,27,125,255,0,200,148,1,0,232,118,222,222,119,174,255,0,176,148,1,0,229,62,241,241,182,218,255,0,144,148,1,0,233,29,253,253,224,239,255,0,96,148,1,0,0,0,247,247,247,247,255,0,56,148,1,0,59,38,245,230,245,208,255,0,248,147,1,0,61,103,225,184,225,134,255,0,224,147,1,0,63,166,188,127,188,65,255,0,192,147,1,0,231,76,233,233,163,201,255,0,160,147,1,0,0,0,247,247,247,247,255,0,128,147,1,0,63,129,215,161,215,106,255,0,112,147,1,0,228,220,208,208,28,139,255,0,88,147,1,0,229,62,241,241,182,218,255,0,48,147,1,0,61,103,225,184,225,134,255,0,192,146,1,0,72,198,172,77,172,38,255,0,176,146,1,0,228,220,208,208,28,139,255,0,136,146,1,0,229,62,241,241,182,218,255,0,112,146,1,0,0,0,247,247,247,247,255,0,80,146,1,0,61,103,225,184,225,134,255,0,48,146,1,0,72,198,172,77,172,38,255,0,8,146,1,0,230,220,197,197,27,125,255,0,248,145,1,0,231,76,233,233,163,201,255,0,224,145,1,0,233,29,253,253,224,239,255,0,184,145,1,0,59,38,245,230,245,208,255,0,136,145,1,0,63,129,215,161,215,106,255,0,120,145,1,0,68,197,146,77,146,33,255,0,56,145,1,0,230,220,197,197,27,125,255,0,24,145,1,0,231,76,233,233,163,201,255,0,0,145,1,0,233,29,253,253,224,239,255,0,224,144,1,0,0,0,247,247,247,247,255,0,200,144,1,0,59,38,245,230,245,208,255,0,184,144,1,0,63,129,215,161,215,106,255,0,160,144,1,0,68,197,146,77,146,33,255,0,96,144,1,0,230,220,197,197,27,125,255,0,72,144,1,0,232,118,222,222,119,174,255,0,56,144,1,0,229,62,241,241,182,218,255,0,208,143,1,0,233,29,253,253,224,239,255,0,160,143,1,0,59,38,245,230,245,208,255,0,128,143,1,0,61,103,225,184,225,134,255,0,96,143,1,0,63,166,188,127,188,65,255,0,72,143,1,0,68,197,146,77,146,33,255,0,8,143,1,0,230,220,197,197,27,125,255,0,208,142,1,0,232,118,222,222,119,174,255,0,160,142,1,0,229,62,241,241,182,218,255,0,128,142,1,0,233,29,253,253,224,239,255,0,112,142,1,0,0,0,247,247,247,247,255,0,248,141,1,0,59,38,245,230,245,208,255,0,200,141,1,0,61,103,225,184,225,134,255,0,176,141,1,0,63,166,188,127,188,65,255,0,144,141,1,0,68,197,146,77,146,33,255,0,104,141,1,0,206,255,75,64,0,75,255,0,88,141,1,0,101,255,68,0,68,27,255,0,48,141,1,0,206,173,131,118,42,131,255,0,0,141,1,0,199,87,171,153,112,171,255,0,224,140,1,0,199,51,207,194,165,207,255,0,208,140,1,0,210,21,232,231,212,232,255,0,128,140,1,0,76,30,240,217,240,211,255,0,80,140,1,0,80,68,219,166,219,160,255,0,48,140,1,0,88,123,174,90,174,97,255,0,56,139,1,0,97,197,120,27,120,55,255,0,32,139,1,0,206,255,75,64,0,75,255,0,16,139,1,0,97,197,120,27,120,55,255,0,248,138,1,0,101,255,68,0,68,27,255,0,208,138,1,0,206,173,131,118,42,131,255,0,144,138,1,0,199,87,171,153,112,171,255,0,128,138,1,0,199,51,207,194,165,207,255,0,72,138,1,0,210,21,232,231,212,232,255,0,24,138,1,0,0,0,247,247,247,247,255,0,0,138,1,0,76,30,240,217,240,211,255,0,224,137,1,0,80,68,219,166,219,160,255,0,192,137,1,0,88,123,174,90,174,97,255,0,176,137,1,0,196,70,195,175,141,195,255,0,152,137,1,0,0,0,247,247,247,247,255,0,104,137,1,0,82,90,191,127,191,123,255,0,40,137,1,0,201,168,148,123,50,148,255,0,24,137,1,0,199,51,207,194,165,207,255,0,224,136,1,0,80,68,219,166,219,160,255,0,200,136,1,0,102,255,136,0,136,55,255,0,160,136,1,0,201,168,148,123,50,148,255,0,112,136,1,0,199,51,207,194,165,207,255,0,80,136,1,0,0,0,247,247,247,247,255,0,56,136,1,0,80,68,219,166,219,160,255,0,232,135,1,0,102,255,136,0,136,55,255,0,88,135,1,0,206,173,131,118,42,131,255,0,56,135,1,0,196,70,195,175,141,195,255,0,40,135,1,0,210,21,232,231,212,232,255,0,0,135,1,0,76,30,240,217,240,211,255,0,200,134,1,0,82,90,191,127,191,123,255,0,176,134,1,0,97,197,120,27,120,55,255,0,144,134,1,0,206,173,131,118,42,131,255,0,112,134,1,0,196,70,195,175,141,195,255,0,96,134,1,0,210,21,232,231,212,232,255,0,72,134,1,0,0,0,247,247,247,247,255,0,8,134,1,0,76,30,240,217,240,211,255,0,232,133,1,0,82,90,191,127,191,123,255,0,216,133,1,0,97,197,120,27,120,55,255,0,96,133,1,0,206,173,131,118,42,131,255,0,40,133,1,0,199,87,171,153,112,171,255,0,240,132,1,0,199,51,207,194,165,207,255,0,208,132,1,0,210,21,232,231,212,232,255,0,168,132,1,0,76,30,240,217,240,211,255,0,128,132,1,0,80,68,219,166,219,160,255,0,104,132,1,0,88,123,174,90,174,97,255,0,64,132,1,0,97,197,120,27,120,55,255,0,0,132,1,0,206,173,131,118,42,131,255,0,216,131,1,0,199,87,171,153,112,171,255,0,176,131,1,0,199,51,207,194,165,207,255,0,144,131,1,0,210,21,232,231,212,232,255,0,120,131,1,0,0,0,247,247,247,247,255,0,80,131,1,0,76,30,240,217,240,211,255,0,56,131,1,0,80,68,219,166,219,160,255,0,40,131,1,0,88,123,174,90,174,97,255,0,16,131,1,0,97,197,120,27,120,55,255,0,224,130,1,0,189,11,242,236,231,242,255,0,184,130,1,0,151,61,219,166,189,219,255,0,152,130,1,0,141,197,190,43,140,190,255,0,112,130,1,0,185,8,246,241,238,246,255,0,240,129,1,0,155,40,225,189,201,225,255,0,168,129,1,0,145,112,207,116,169,207,255,0,136,129,1,0,143,247,176,5,112,176,255,0,112,129,1,0,185,8,246,241,238,246,255,0,96,129,1,0,155,40,225,189,201,225,255,0,72,129,1,0,145,112,207,116,169,207,255,0,16,129,1,0,141,197,190,43,140,190,255,0,232,128,1,0,143,247,141,4,90,141,255,0,192,128,1,0,185,8,246,241,238,246,255,0,160,128,1,0,168,24,230,208,209,230,255,0,104,128,1,0,151,61,219,166,189,219,255,0,40,128,1,0,145,112,207,116,169,207,255,0,8,128,1,0,141,197,190,43,140,190,255,0,232,127,1,0,143,247,141,4,90,141,255,0,216,127,1,0,185,8,246,241,238,246,255,0,192,127,1,0,168,24,230,208,209,230,255,0,112,127,1,0,151,61,219,166,189,219,255,0,80,127,1,0,145,112,207,116,169,207,255,0,64,127,1,0,142,183,192,54,144,192,255,0,24,127,1,0,143,247,176,5,112,176,255,0,224,126,1,0,143,248,123,3,78,123,255,0,200,126,1,0,233,8,255,255,247,251,255,0,168,126,1,0,189,11,242,236,231,242,255,0,144,126,1,0,168,24,230,208,209,230,255,0,80,126,1,0,151,61,219,166,189,219,255,0,48,126,1,0,145,112,207,116,169,207,255,0,0,126,1,0,142,183,192,54,144,192,255,0,168,125,1,0,143,247,176,5,112,176,255,0,152,125,1,0,143,248,123,3,78,123,255,0,120,125,1,0,233,8,255,255,247,251,255,0,16,125,1,0,189,11,242,236,231,242,255,0,208,124,1,0,168,24,230,208,209,230,255,0,176,124,1,0,151,61,219,166,189,219,255,0,152,124,1,0,145,112,207,116,169,207,255,0,136,124,1,0,142,183,192,54,144,192,255,0,96,124,1,0,143,247,176,5,112,176,255,0,24,124,1,0,143,247,141,4,90,141,255,0,0,124,1,0,143,249,88,2,56,88,255,0,240,123,1,0,200,14,240,236,226,240,255,0,216,123,1,0,151,61,219,166,189,219,255,0,160,123,1,0,130,208,153,28,144,153,255,0,128,123,1,0,207,8,247,246,239,247,255,0,88,123,1,0,155,40,225,189,201,225,255,0,40,123,1,0,143,128,207,103,169,207,255,0,24,123,1,0,130,251,138,2,129,138,255,0,0,123,1,0,207,8,247,246,239,247,255,0,216,122,1,0,155,40,225,189,201,225,255,0,184,122,1,0,143,128,207,103,169,207,255,0,168,122,1,0,130,208,153,28,144,153,255,0,144,122,1,0,119,252,108,1,108,89,255,0,8,122,1,0,207,8,247,246,239,247,255,0,184,121,1,0,168,24,230,208,209,230,255,0,152,121,1,0,151,61,219,166,189,219,255,0,80,121,1,0,143,128,207,103,169,207,255,0,64,121,1,0,130,208,153,28,144,153,255,0,40,121,1,0,119,252,108,1,108,89,255,0,0,121,1,0,207,8,247,246,239,247,255,0,192,120,1,0,168,24,230,208,209,230,255,0,176,120,1,0,151,61,219,166,189,219,255,0,112,120,1,0,143,128,207,103,169,207,255,0,88,120,1,0,142,183,192,54,144,192,255,0,72,120,1,0,130,251,138,2,129,138,255,0,40,120,1,0,118,252,100,1,100,80,255,0,232,119,1,0,233,8,255,255,247,251,255,0,200,119,1,0,200,14,240,236,226,240,255,0,176,119,1,0,168,24,230,208,209,230,255,0,32,119,1,0,151,61,219,166,189,219,255,0,248,118,1,0,143,128,207,103,169,207,255,0,232,118,1,0,142,183,192,54,144,192,255,0,200,118,1,0,130,251,138,2,129,138,255,0,168,118,1,0,118,252,100,1,100,80,255,0,152,118,1,0,233,8,255,255,247,251,255,0,120,118,1,0,200,14,240,236,226,240,255,0,96,118,1,0,168,24,230,208,209,230,255,0,80,118,1,0,151,61,219,166,189,219,255,0,56,118,1,0,143,128,207,103,169,207,255,0,8,118,1,0,142,183,192,54,144,192,255,0,232,117,1,0,130,251,138,2,129,138,255,0,216,117,1,0,119,252,108,1,108,89,255,0,176,117,1,0,117,251,70,1,70,54,255,0,152,117,1,0,18,238,127,127,59,8,255,0,72,117,1,0,195,255,75,45,0,75,255,0,40,117,1,0,20,246,179,179,88,6,255,0,224,116,1,0,22,232,224,224,130,20,255,0,192,116,1,0,23,155,253,253,184,99,255,0,160,116,1,0,24,72,254,254,224,182,255,0,120,116,1,0,165,20,235,216,218,235,255,0,72,116,1,0,177,47,210,178,171,210,255,0,56,116,1,0,179,84,172,128,115,172,255,0,16,116,1,0,189,181,136,84,39,136,255,0,0,116,1,0,18,238,127,127,59,8,255,0,232,115,1,0,189,181,136,84,39,136,255,0,200,115,1,0,195,255,75,45,0,75,255,0,128,115,1,0,20,246,179,179,88,6,255,0,112,115,1,0,22,232,224,224,130,20,255,0,88,115,1,0,23,155,253,253,184,99,255,0,48,115,1,0,24,72,254,254,224,182,255,0,0,115,1,0,0,0,247,247,247,247,255,0,240,114,1,0,165,20,235,216,218,235,255,0,192,114,1,0,177,47,210,178,171,210,255,0,176,114,1,0,179,84,172,128,115,172,255,0,160,114,1,0,23,187,241,241,163,64,255,0,120,114,1,0,0,0,247,247,247,247,255,0,96,114,1,0,178,69,195,153,142,195,255,0,80,114,1,0,17,253,230,230,97,1,255,0,56,114,1,0,23,155,253,253,184,99,255,0,32,114,1,0,177,47,210,178,171,210,255,0,224,113,1,0,185,155,153,94,60,153,255,0,208,113,1,0,17,253,230,230,97,1,255,0,160,113,1,0,23,155,253,253,184,99,255,0,144,113,1,0,0,0,247,247,247,247,255,0,128,113,1,0,177,47,210,178,171,210,255,0,96,113,1,0,185,155,153,94,60,153,255,0,64,113,1,0,20,246,179,179,88,6,255,0,48,113,1,0,23,187,241,241,163,64,255,0,24,113,1,0,24,72,254,254,224,182,255,0,224,112,1,0,165,20,235,216,218,235,255,0,176,112,1,0,178,69,195,153,142,195,255,0,160,112,1,0,189,181,136,84,39,136,255,0,80,112,1,0,20,246,179,179,88,6,255,0,64,112,1,0,23,187,241,241,163,64,255,0,48,112,1,0,24,72,254,254,224,182,255,0,16,112,1,0,0,0,247,247,247,247,255,0,240,111,1,0,165,20,235,216,218,235,255,0,184,111,1,0,178,69,195,153,142,195,255,0,160,111,1,0,189,181,136,84,39,136,255,0,120,111,1,0,20,246,179,179,88,6,255,0,80,111,1,0,22,232,224,224,130,20,255,0,64,111,1,0,23,155,253,253,184,99,255,0,0,111,1,0,24,72,254,254,224,182,255,0,240,110,1,0,165,20,235,216,218,235,255,0,224,110,1,0,177,47,210,178,171,210,255,0,192,110,1,0,179,84,172,128,115,172,255,0,160,110,1,0,189,181,136,84,39,136,255,0,144,110,1,0,20,246,179,179,88,6,255,0,112,110,1,0,22,232,224,224,130,20,255,0,72,110,1,0,23,155,253,253,184,99,255,0,240,109,1,0,24,72,254,254,224,182,255,0,224,109,1,0,0,0,247,247,247,247,255,0,152,109,1,0,165,20,235,216,218,235,255,0,136,109,1,0,177,47,210,178,171,210,255,0,120,109,1,0,179,84,172,128,115,172,255,0,88,109,1,0,189,181,136,84,39,136,255,0,32,109,1,0,188,14,239,231,225,239,255,0,16,109,1,0,214,67,201,201,148,199,255,0,0,109,1,0,234,222,221,221,28,119,255,0,216,108,1,0,185,8,246,241,238,246,255,0,160,108,1,0,211,41,216,215,181,216,255,0,144,108,1,0,228,139,223,223,101,176,255,0,72,108,1,0,239,232,206,206,18,86,255,0,56,108,1,0,185,8,246,241,238,246,255,0,40,108,1,0,211,41,216,215,181,216,255,0,8,108,1,0,228,139,223,223,101,176,255,0,224,107,1,0,234,222,221,221,28,119,255,0,208,107,1,0,236,255,152,152,0,67,255,0,192,107,1,0,185,8,246,241,238,246,255,0,152,107,1,0,204,38,218,212,185,218,255,0,104,107,1,0,214,67,201,201,148,199,255,0,88,107,1,0,228,139,223,223,101,176,255,0,224,106,1,0,234,222,221,221,28,119,255,0,208,106,1,0,236,255,152,152,0,67,255,0,192,106,1,0,185,8,246,241,238,246,255,0,160,106,1,0,204,38,218,212,185,218,255,0,136,106,1,0,214,67,201,201,148,199,255,0,112,106,1,0,228,139,223,223,101,176,255,0,96,106,1,0,233,209,231,231,41,138,255,0,8,106,1,0,239,232,206,206,18,86,255,0,208,105,1,0,236,255,145,145,0,63,255,0,184,105,1,0,195,5,249,247,244,249,255,0,112,105,1,0,188,14,239,231,225,239,255,0,96,105,1,0,204,38,218,212,185,218,255,0,80,105,1,0,214,67,201,201,148,199,255,0,48,105,1,0,228,139,223,223,101,176,255,0,24,105,1,0,233,209,231,231,41,138,255,0,8,105,1,0,239,232,206,206,18,86,255,0,248,104,1,0,236,255,145,145,0,63,255,0,200,104,1,0,195,5,249,247,244,249,255,0,152,104,1,0,188,14,239,231,225,239,255,0,136,104,1,0,204,38,218,212,185,218,255,0,40,104,1,0,214,67,201,201,148,199,255,0,16,104,1,0,228,139,223,223,101,176,255,0,224,103,1,0,233,209,231,231,41,138,255,0,128,103,1,0,239,232,206,206,18,86,255,0,48,103,1,0,236,255,152,152,0,67,255,0,16,103,1,0,242,255,103,103,0,31,255,0,248,102,1,0,180,8,245,239,237,245,255,0,208,102,1,0,168,37,220,188,189,220,255,0,128,102,1,0,176,100,177,117,107,177,255,0,112,102,1,0,182,7,247,242,240,247,255,0,56,102,1,0,173,28,226,203,201,226,255,0,40,102,1,0,173,58,200,158,154,200,255,0,24,102,1,0,182,128,163,106,81,163,255,0,240,101,1,0,182,7,247,242,240,247,255,0,208,101,1,0,173,28,226,203,201,226,255,0,184,101,1,0,173,58,200,158,154,200,255,0,168,101,1,0,176,100,177,117,107,177,255,0,128,101,1,0,188,185,143,84,39,143,255,0,80,101,1,0,182,7,247,242,240,247,255,0,64,101,1,0,170,18,235,218,218,235,255,0,40,101,1,0,168,37,220,188,189,220,255,0,8,101,1,0,173,58,200,158,154,200,255,0,248,100,1,0,176,100,177,117,107,177,255,0,224,100,1,0,188,185,143,84,39,143,255,0,176,100,1,0,182,7,247,242,240,247,255,0,160,100,1,0,170,18,235,218,218,235,255,0,144,100,1,0,168,37,220,188,189,220,255,0,88,100,1,0,173,58,200,158,154,200,255,0,24,100,1,0,172,83,186,128,125,186,255,0,8,100,1,0,182,128,163,106,81,163,255,0,176,99,1,0,190,216,134,74,20,134,255,0,160,99,1,0,191,2,253,252,251,253,255,0,144,99,1,0,180,8,245,239,237,245,255,0,128,99,1,0,170,18,235,218,218,235,255,0,80,99,1,0,168,37,220,188,189,220,255,0,64,99,1,0,173,58,200,158,154,200,255,0,48,99,1,0,172,83,186,128,125,186,255,0,240,98,1,0,182,128,163,106,81,163,255,0,192,98,1,0,190,216,134,74,20,134,255,0,176,98,1,0,191,2,253,252,251,253,255,0,152,98,1,0,180,8,245,239,237,245,255,0,136,98,1,0,170,18,235,218,218,235,255,0,120,98,1,0,168,37,220,188,189,220,255,0,104,98,1,0,173,58,200,158,154,200,255,0,64,98,1,0,172,83,186,128,125,186,255,0,32,98,1,0,182,128,163,106,81,163,255,0,240,97,1,0,188,185,143,84,39,143,255,0,200,97,1,0,191,255,125,63,0,125,255,0,144,97,1,0,242,255,103,103,0,31,255,0,128,97,1,0,150,241,97,5,48,97,255,0,96,97,1,0,249,220,178,178,24,43,255,0,80,97,1,0,5,163,214,214,96,77,255,0,64,97,1,0,13,119,244,244,165,130,255,0,48,97,1,0,15,54,253,253,219,199,255,0,0,97,1,0,142,32,240,209,229,240,255,0,240,96,1,0,141,87,222,146,197,222,255,0,208,96,1,0,143,167,195,67,147,195,255,0,160,96,1,0,148,206,172,33,102,172,255,0,112,96,1,0,242,255,103,103,0,31,255,0,88,96,1,0,148,206,172,33,102,172,255,0,48,96,1,0,150,241,97,5,48,97,255,0,32,96,1,0,249,220,178,178,24,43,255,0,16,96,1,0,5,163,214,214,96,77,255,0,0,96,1,0,13,119,244,244,165,130,255,0,208,95,1,0,15,54,253,253,219,199,255,0,144,95,1,0,0,0,247,247,247,247,255,0,128,95,1,0,142,32,240,209,229,240,255,0,88,95,1,0,141,87,222,146,197,222,255,0,24,95,1,0,143,167,195,67,147,195,255,0,8,95,1,0,12,150,239,239,138,98,255,0,208,94,1,0,0,0,247,247,247,247,255,0,192,94,1,0,143,128,207,103,169,207,255,0,176,94,1,0,248,255,202,202,0,32,255,0,160,94,1,0,13,119,244,244,165,130,255,0,144,125,2,0,141,87,222,146,197,222,255,0,128,125,2,0,143,247,176,5,113,176,255,0,112,125,2,0,248,255,202,202,0,32,255,0,72,125,2,0,13,119,244,244,165,130,255,0,16,125,2,0,0,0,247,247,247,247,255,0,0,125,2,0,141,87,222,146,197,222,255,0,208,124,2,0,143,247,176,5,113,176,255,0,192,124,2,0,249,220,178,178,24,43,255,0,176,124,2,0,12,150,239,239,138,98,255,0,160,124,2,0,15,54,253,253,219,199,255,0,112,124,2,0,142,32,240,209,229,240,255,0,80,124,2,0,143,128,207,103,169,207,255,0,64,124,2,0,148,206,172,33,102,172,255,0,240,123,2,0,249,220,178,178,24,43,255,0,184,123,2,0,12,150,239,239,138,98,255,0,160,123,2,0,15,54,253,253,219,199,255,0,136,123,2,0,0,0,247,247,247,247,255,0,120,123,2,0,142,32,240,209,229,240,255,0,104,123,2,0,143,128,207,103,169,207,255,0,88,123,2,0,148,206,172,33,102,172,255,0,48,123,2,0,249,220,178,178,24,43,255,0,32,123,2,0,5,163,214,214,96,77,255,0,16,123,2,0,13,119,244,244,165,130,255,0,224,122,2,0,15,54,253,253,219,199,255,0,144,122,2,0,142,32,240,209,229,240,255,0,128,122,2,0,141,87,222,146,197,222,255,0,32,122,2,0,143,167,195,67,147,195,255,0,8,122,2,0,148,206,172,33,102,172,255,0,216,121,2,0,249,220,178,178,24,43,255,0,200,121,2,0,5,163,214,214,96,77,255,0,88,121,2,0,13,119,244,244,165,130,255,0,56,121,2,0,15,54,253,253,219,199,255,0,32,121,2,0,0,0,247,247,247,247,255,0,248,120,2,0,142,32,240,209,229,240,255,0,176,120,2,0,141,87,222,146,197,222,255,0,160,120,2,0,143,167,195,67,147,195,255,0,88,120,2,0,148,206,172,33,102,172,255,0,72,120,2,0,242,255,103,103,0,31,255,0,56,120,2,0,0,0,26,26,26,26,255,0,40,120,2,0,249,220,178,178,24,43,255,0,240,119,2,0,5,163,214,214,96,77,255,0,224,119,2,0,13,119,244,244,165,130,255,0,192,119,2,0,15,54,253,253,219,199,255,0,160,119,2,0,0,0,224,224,224,224,255,0,120,119,2,0,0,0,186,186,186,186,255,0,104,119,2,0,0,0,135,135,135,135,255,0,64,119,2,0,0,0,77,77,77,77,255,0,48,119,2,0,242,255,103,103,0,31,255,0,16,119,2,0,0,0,77,77,77,77,255,0,248,118,2,0,0,0,26,26,26,26,255,0,208,118,2,0,249,220,178,178,24,43,255,0,192,118,2,0,5,163,214,214,96,77,255,0,176,118,2,0,13,119,244,244,165,130,255,0,120,118,2,0,15,54,253,253,219,199,255,0,72,118,2,0,0,0,255,255,255,255,255,0,56,118,2,0,0,0,224,224,224,224,255,0,16,118,2,0,0,0,186,186,186,186,255,0,0,118,2,0,0,0,135,135,135,135,255,0,240,117,2,0,12,150,239,239,138,98,255,0,224,117,2,0,0,0,255,255,255,255,255,0,184,117,2,0,0,0,153,153,153,153,255,0,168,117,2,0,248,255,202,202,0,32,255,0,152,117,2,0,13,119,244,244,165,130,255,0,56,117,2,0,0,0,186,186,186,186,255,0,8,117,2,0,0,0,64,64,64,64,255,0,248,116,2,0,248,255,202,202,0,32,255,0,184,116,2,0,13,119,244,244,165,130,255,0,168,116,2,0,0,0,255,255,255,255,255,0,152,116,2,0,0,0,186,186,186,186,255,0,136,116,2,0,0,0,64,64,64,64,255,0,96,116,2,0,249,220,178,178,24,43,255,0,48,116,2,0,12,150,239,239,138,98,255,0,24,116,2,0,15,54,253,253,219,199,255,0,248,115,2,0,0,0,224,224,224,224,255,0,208,115,2,0,0,0,153,153,153,153,255,0,192,115,2,0,0,0,77,77,77,77,255,0,120,115,2,0,249,220,178,178,24,43,255,0,104,115,2,0,12,150,239,239,138,98,255,0,88,115,2,0,15,54,253,253,219,199,255,0,72,115,2,0,0,0,255,255,255,255,255,0,32,115,2,0,0,0,224,224,224,224,255,0,16,115,2,0,0,0,153,153,153,153,255,0,240,114,2,0,0,0,77,77,77,77,255,0,200,114,2,0,249,220,178,178,24,43,255,0,160,114,2,0,5,163,214,214,96,77,255,0,144,114,2,0,13,119,244,244,165,130,255,0,40,114,2,0,15,54,253,253,219,199,255,0,24,114,2,0,0,0,224,224,224,224,255,0,8,114,2,0,0,0,186,186,186,186,255,0,248,113,2,0,0,0,135,135,135,135,255,0,200,113,2,0,0,0,77,77,77,77,255,0,184,113,2,0,249,220,178,178,24,43,255,0,160,113,2,0,5,163,214,214,96,77,255,0,120,113,2,0,13,119,244,244,165,130,255,0,88,113,2,0,15,54,253,253,219,199,255,0,72,113,2,0,0,0,255,255,255,255,255,0,232,112,2,0,0,0,224,224,224,224,255,0,216,112,2,0,0,0,186,186,186,186,255,0,200,112,2,0,0,0,135,135,135,135,255,0,184,112,2,0,0,0,77,77,77,77,255,0,96,112,2,0,3,32,253,253,224,221,255,0,80,112,2,0,244,92,250,250,159,181,255,0,64,112,2,0,227,220,197,197,27,138,255,0,24,112,2,0,13,28,254,254,235,226,255,0,208,111,2,0,252,72,251,251,180,185,255,0,192,111,2,0,238,147,247,247,104,161,255,0,160,111,2,0,224,253,174,174,1,126,255,0,144,111,2,0,13,28,254,254,235,226,255,0,128,111,2,0,252,72,251,251,180,185,255,0,112,111,2,0,238,147,247,247,104,161,255,0,40,111,2,0,227,220,197,197,27,138,255,0,224,110,2,0,213,252,122,122,1,119,255,0,208,110,2,0,13,28,254,254,235,226,255,0,152,110,2,0,3,60,252,252,197,192,255,0,32,110,2,0,244,92,250,250,159,181,255,0,8,110,2,0,238,147,247,247,104,161,255,0,224,109,2,0,227,220,197,197,27,138,255,0,176,109,2,0,213,252,122,122,1,119,255,0,160,109,2,0,13,28,254,254,235,226,255,0,144,109,2,0,3,60,252,252,197,192,255,0,96,109,2,0,244,92,250,250,159,181,255,0,80,109,2,0,238,147,247,247,104,161,255,0,16,109,2,0,230,195,221,221,52,151,255,0,224,108,2,0,224,253,174,174,1,126,255,0,176,108,2,0,213,252,122,122,1,119,255,0,160,108,2,0,14,12,255,255,247,243,255,0,72,108,2,0,3,32,253,253,224,221,255,0,48,108,2,0,3,60,252,252,197,192,255,0,248,107,2,0,244,92,250,250,159,181,255,0,232,107,2,0,238,147,247,247,104,161,255,0,184,107,2,0,230,195,221,221,52,151,255,0,152,107,2,0,224,253,174,174,1,126,255,0,128,107,2,0,213,252,122,122,1,119,255,0,88,107,2,0,14,12,255,255,247,243,255,0,248,106,2,0,3,32,253,253,224,221,255,0,232,106,2,0,3,60,252,252,197,192,255,0,144,106,2,0,244,92,250,250,159,181,255,0,128,106,2,0,238,147,247,247,104,161,255,0,112,106,2,0,230,195,221,221,52,151,255,0,96,106,2,0,224,253,174,174,1,126,255,0,56,106,2,0,213,252,122,122,1,119,255,0,24,106,2,0,199,255,106,73,0,106,255,0,8,106,2,0,245,255,165,165,0,38,255,0,176,105,2,0,167,171,149,49,54,149,255,0,112,105,2,0,2,208,215,215,48,39,255,0,88,105,2,0,10,184,244,244,109,67,255,0,48,105,2,0,20,157,253,253,174,97,255,0,32,105,2,0,30,110,254,254,224,144,255,0,16,105,2,0,136,24,248,224,243,248,255,0,184,104,2,0,138,67,233,171,217,233,255,0,144,104,2,0,143,113,209,116,173,209,255,0,128,104,2,0,151,157,180,69,117,180,255,0,112,104,2,0,245,255,165,165,0,38,255,0,80,104,2,0,151,157,180,69,117,180,255,0,232,103,2,0,167,171,149,49,54,149,255,0,216,103,2,0,2,208,215,215,48,39,255,0,152,103,2,0,10,184,244,244,109,67,255,0,136,103,2,0,20,157,253,253,174,97,255,0,120,103,2,0,30,110,254,254,224,144,255,0,104,103,2,0,42,64,255,255,255,191,255,0,64,103,2,0,136,24,248,224,243,248,255,0,48,103,2,0,138,67,233,171,217,233,255,0,32,103,2,0,143,113,209,116,173,209,255,0,248,102,2,0,13,164,252,252,141,89,255,0,104,102,2,0,42,64,255,255,255,191,255,0,88,102,2,0,143,86,219,145,191,219,255,0,56,102,2,0,254,225,215,215,25,28,255,0,40,102,2,0,20,157,253,253,174,97,255,0,24,102,2,0,138,67,233,171,217,233,255,0,8,102,2,0,145,193,182,44,123,182,255,0,224,101,2,0,254,225,215,215,25,28,255,0,152,101,2,0,20,157,253,253,174,97,255,0,136,101,2,0,42,64,255,255,255,191,255,0,104,101,2,0,138,67,233,171,217,233,255,0,40,101,2,0,145,193,182,44,123,182,255,0,24,101,2,0,2,208,215,215,48,39,255,0,248,100,2,0,13,164,252,252,141,89,255,0,232,100,2,0,30,110,254,254,224,144,255,0,216,100,2,0,136,24,248,224,243,248,255,0,200,100,2,0,143,86,219,145,191,219,255,0,160,100,2,0,151,157,180,69,117,180,255,0,144,100,2,0,2,208,215,215,48,39,255,0,112,100,2,0,13,164,252,252,141,89,255,0,88,100,2,0,30,110,254,254,224,144,255,0,48,100,2,0,42,64,255,255,255,191,255,0,32,100,2,0,136,24,248,224,243,248,255,0,240,99,2,0,143,86,219,145,191,219,255,0,216,99,2,0,151,157,180,69,117,180,255,0,200,99,2,0,2,208,215,215,48,39,255,0,184,99,2,0,10,184,244,244,109,67,255,0,144,99,2,0,20,157,253,253,174,97,255,0,128,99,2,0,30,110,254,254,224,144,255,0,112,99,2,0,136,24,248,224,243,248,255,0,48,99,2,0,138,67,233,171,217,233,255,0,248,98,2,0,143,113,209,116,173,209,255,0,232,98,2,0,151,157,180,69,117,180,255,0,160,98,2,0,2,208,215,215,48,39,255,0,144,98,2,0,10,184,244,244,109,67,255,0,128,98,2,0,20,157,253,253,174,97,255,0,112,98,2,0,30,110,254,254,224,144,255,0,64,98,2,0,42,64,255,255,255,191,255,0,48,98,2,0,136,24,248,224,243,248,255,0,32,98,2,0,138,67,233,171,217,233,255,0,224,97,2,0,143,113,209,116,173,209,255,0,176,97,2,0,151,157,180,69,117,180,255,0,160,97,2,0,245,255,165,165,0,38,255,0,96,97,2,0,107,255,104,0,104,55,255,0,80,97,2,0,2,208,215,215,48,39,255,0,64,97,2,0,10,184,244,244,109,67,255,0,48,97,2,0,20,157,253,253,174,97,255,0,224,96,2,0,31,115,254,254,224,139,255,0,208,96,2,0,51,106,239,217,239,139,255,0,184,96,2,0,62,130,217,166,217,106,255,0,80,96,2,0,83,121,189,102,189,99,255,0,24,96,2,0,103,211,152,26,152,80,255,0,248,95,2,0,245,255,165,165,0,38,255,0,216,95,2,0,103,211,152,26,152,80,255,0,200,95,2,0,107,255,104,0,104,55,255,0,184,95,2,0,2,208,215,215,48,39,255,0,152,95,2,0,10,184,244,244,109,67,255,0,112,95,2,0,20,157,253,253,174,97,255,0,96,95,2,0,31,115,254,254,224,139,255,0,80,95,2,0,42,64,255,255,255,191,255,0,32,95,2,0,51,106,239,217,239,139,255,0,232,94,2,0,62,130,217,166,217,106,255,0,216,94,2,0,83,121,189,102,189,99,255,0,176,94,2,0,13,164,252,252,141,89,255,0,152,94,2,0,42,64,255,255,255,191,255,0,104,94,2,0,66,136,207,145,207,96,255,0,88,94,2,0,254,225,215,215,25,28,255,0,24,94,2,0,20,157,253,253,174,97,255,0,0,94,2,0,62,130,217,166,217,106,255,0,224,93,2,0,98,210,150,26,150,65,255,0,192,93,2,0,254,225,215,215,25,28,255,0,128,93,2,0,20,157,253,253,174,97,255,0,112,93,2,0,42,64,255,255,255,191,255,0,64,93,2,0,62,130,217,166,217,106,255,0,48,93,2,0,98,210,150,26,150,65,255,0,32,93,2,0,2,208,215,215,48,39,255,0,16,93,2,0,13,164,252,252,141,89,255,0,232,92,2,0,31,115,254,254,224,139,255,0,216,92,2,0,51,106,239,217,239,139,255,0,184,92,2,0,66,136,207,145,207,96,255,0,128,92,2,0,103,211,152,26,152,80,255,0,72,92,2,0,2,208,215,215,48,39,255,0,48,92,2,0,13,164,252,252,141,89,255,0,32,92,2,0,31,115,254,254,224,139,255,0,0,92,2,0,42,64,255,255,255,191,255,0,240,91,2,0,51,106,239,217,239,139,255,0,216,91,2,0,66,136,207,145,207,96,255,0,96,91,2,0,103,211,152,26,152,80,255,0,72,91,2,0,2,208,215,215,48,39,255,0,56,91,2,0,10,184,244,244,109,67,255,0,32,91,2,0,20,157,253,253,174,97,255,0,240,90,2,0,31,115,254,254,224,139,255,0,224,90,2,0,51,106,239,217,239,139,255,0,208,90,2,0,62,130,217,166,217,106,255,0,184,90,2,0,83,121,189,102,189,99,255,0,168,90,2,0,103,211,152,26,152,80,255,0,152,90,2,0,2,208,215,215,48,39,255,0,112,90,2,0,10,184,244,244,109,67,255,0,96,90,2,0,20,157,253,253,174,97,255,0,80,90,2,0,31,115,254,254,224,139,255,0,40,90,2,0,42,64,255,255,255,191,255,0,208,89,2,0,51,106,239,217,239,139,255,0,192,89,2,0,62,130,217,166,217,106,255,0,176,89,2,0,83,121,189,102,189,99,255,0,112,89,2,0,103,211,152,26,152,80,255,0,96,89,2,0,13,44,254,254,224,210,255,0,80,89,2,0,9,139,252,252,146,114,255,0,40,89,2,0,1,211,222,222,45,38,255,0,8,89,2,0,13,37,254,254,229,217,255,0,232,88,2,0,11,108,252,252,174,145,255,0,200,88,2,0,7,179,251,251,106,74,255,0,160,88,2,0,253,224,203,203,24,29,255,0,144,88,2,0,13,37,254,254,229,217,255,0,120,88,2,0,11,108,252,252,174,145,255,0,24,88,2,0,7,179,251,251,106,74,255,0,8,88,2,0,1,211,222,222,45,38,255,0,248,87,2,0,253,231,165,165,15,21,255,0,208,87,2,0,13,37,254,254,229,217,255,0,192,87,2,0,12,92,252,252,187,161,255,0,160,87,2,0,9,139,252,252,146,114,255,0,96,87,2,0,7,179,251,251,106,74,255,0,48,87,2,0,1,211,222,222,45,38,255,0,32,87,2,0,253,231,165,165,15,21,255,0,16,87,2,0,13,37,254,254,229,217,255,0,224,86,2,0,12,92,252,252,187,161,255,0,144,86,2,0,9,139,252,252,146,114,255,0,128,86,2,0,7,179,251,251,106,74,255,0,88,86,2,0,3,208,239,239,59,44,255,0,72,86,2,0,253,224,203,203,24,29,255,0,56,86,2,0,251,255,153,153,0,13,255,0,24,86,2,0,14,15,255,255,245,240,255,0,168,85,2,0,13,44,254,254,224,210,255,0,152,85,2,0,12,92,252,252,187,161,255,0,136,85,2,0,9,139,252,252,146,114,255,0,104,85,2,0,7,179,251,251,106,74,255,0,88,85,2,0,3,208,239,239,59,44,255,0,72,85,2,0,253,224,203,203,24,29,255,0,24,85,2,0,251,255,153,153,0,13,255,0,8,85,2,0,14,15,255,255,245,240,255,0,248,84,2,0,13,44,254,254,224,210,255,0,176,84,2,0,12,92,252,252,187,161,255,0,136,84,2,0,9,139,252,252,146,114,255,0,120,84,2,0,7,179,251,251,106,74,255,0,104,84,2,0,3,208,239,239,59,44,255,0,24,84,2,0,253,224,203,203,24,29,255,0,8,84,2,0,253,231,165,165,15,21,255,0,248,83,2,0,249,255,103,103,0,13,255,0,208,83,2,0,254,225,228,228,26,28,255,0,192,83,2,0,146,178,184,55,126,184,255,0,168,83,2,0,83,147,175,77,175,74,255,0,64,83,2,0,254,225,228,228,26,28,255,0,248,82,2,0,146,178,184,55,126,184,255,0,232,82,2,0,83,147,175,77,175,74,255,0,216,82,2,0,207,132,163,152,78,163,255,0,184,82,2,0,254,225,228,228,26,28,255,0,168,82,2,0,146,178,184,55,126,184,255,0,152,82,2,0,83,147,175,77,175,74,255,0,80,82,2,0,207,132,163,152,78,163,255,0,64,82,2,0,21,255,255,255,127,0,255,0,48,82,2,0,254,225,228,228,26,28,255,0,224,81,2,0,146,178,184,55,126,184,255,0,168,81,2,0,83,147,175,77,175,74,255,0,152,81,2,0,207,132,163,152,78,163,255,0,112,81,2,0,21,255,255,255,127,0,255,0,16,81,2,0,42,204,255,255,255,51,255,0,232,80,2,0,254,225,228,228,26,28,255,0,216,80,2,0,146,178,184,55,126,184,255,0,168,80,2,0,83,147,175,77,175,74,255,0,120,80,2,0,207,132,163,152,78,163,255,0,96,80,2,0,21,255,255,255,127,0,255,0,72,80,2,0,42,204,255,255,255,51,255,0,184,79,2,0,15,193,166,166,86,40,255,0,168,79,2,0,254,225,228,228,26,28,255,0,144,79,2,0,146,178,184,55,126,184,255,0,88,79,2,0,83,147,175,77,175,74,255,0,72,79,2,0,207,132,163,152,78,163,255,0,56,79,2,0,21,255,255,255,127,0,255,0,16,79,2,0,42,204,255,255,255,51,255,0,0,79,2,0,15,193,166,166,86,40,255,0,240,78,2,0,232,121,247,247,129,191,255,0,168,78,2,0,254,225,228,228,26,28,255,0,64,78,2,0,146,178,184,55,126,184,255,0,224,77,2,0,83,147,175,77,175,74,255,0,208,77,2,0,207,132,163,152,78,163,255,0,160,77,2,0,21,255,255,255,127,0,255,0,144,77,2,0,42,204,255,255,255,51,255,0,120,77,2,0,15,193,166,166,86,40,255,0,80,77,2,0,232,121,247,247,129,191,255,0,56,77,2,0,0,0,153,153,153,153,255,0,40,77,2,0,114,120,194,102,194,165,255,0,24,77,2,0,11,155,252,252,141,98,255,0,200,76,2,0,156,77,203,141,160,203,255,0,184,76,2,0,114,120,194,102,194,165,255,0,168,76,2,0,11,155,252,252,141,98,255,0,104,76,2,0,156,77,203,141,160,203,255,0,88,76,2,0,228,102,231,231,138,195,255,0,72,76,2,0,114,120,194,102,194,165,255,0,32,76,2,0,11,155,252,252,141,98,255,0,16,76,2,0,156,77,203,141,160,203,255,0,200,75,2,0,228,102,231,231,138,195,255,0,184,75,2,0,58,155,216,166,216,84,255,0,72,75,2,0,114,120,194,102,194,165,255,0,56,75,2,0,11,155,252,252,141,98,255,0,40,75,2,0,156,77,203,141,160,203,255,0,16,75,2,0,228,102,231,231,138,195,255,0,0,75,2,0,58,155,216,166,216,84,255,0,240,74,2,0,34,208,255,255,217,47,255,0,200,74,2,0,114,120,194,102,194,165,255,0,168,74,2,0,11,155,252,252,141,98,255,0,152,74,2,0,156,77,203,141,160,203,255,0,128,74,2,0,228,102,231,231,138,195,255,0,88,74,2,0,58,155,216,166,216,84,255,0,72,74,2,0,34,208,255,255,217,47,255,0,56,74,2,0,25,90,229,229,196,148,255,0,16,74,2,0,114,120,194,102,194,165,255,0,0,74,2,0,11,155,252,252,141,98,255,0,240,73,2,0,156,77,203,141,160,203,255,0,200,73,2,0,228,102,231,231,138,195,255,0,184,73,2,0,58,155,216,166,216,84,255,0,152,73,2,0,34,208,255,255,217,47,255,0,128,73,2,0,25,90,229,229,196,148,255,0,64,73,2,0,0,0,179,179,179,179,255,0,48,73,2,0,120,84,211,141,211,199,255,0,32,73,2,0,211,82,189,188,128,189,255,0,0,73,2,0,42,76,255,255,255,179,255,0,240,72,2,0,175,37,218,190,186,218,255,0,144,72,2,0,4,139,251,251,128,114,255,0,104,72,2,0,144,100,211,128,177,211,255,0,88,72,2,0,22,156,253,253,180,98,255,0,72,72,2,0,58,134,222,179,222,105,255,0,56,72,2,0,233,47,252,252,205,229,255,0,248,71,2,0,0,0,217,217,217,217,255,0,168,71,2,0,120,84,211,141,211,199,255,0,152,71,2,0,211,82,189,188,128,189,255,0,128,71,2,0,77,41,235,204,235,197,255,0,112,71,2,0,42,76,255,255,255,179,255,0,96,71,2,0,175,37,218,190,186,218,255,0,48,71,2,0,4,139,251,251,128,114,255,0,32,71,2,0,144,100,211,128,177,211,255,0,16,71,2,0,22,156,253,253,180,98,255,0,0,71,2,0,58,134,222,179,222,105,255,0,224,70,2,0,233,47,252,252,205,229,255,0,208,70,2,0,0,0,217,217,217,217,255,0,192,70,2,0,120,84,211,141,211,199,255,0,168,70,2,0,211,82,189,188,128,189,255,0,152,70,2,0,77,41,235,204,235,197,255,0,136,70,2,0,37,144,255,255,237,111,255,0,96,70,2,0,42,76,255,255,255,179,255,0,80,70,2,0,175,37,218,190,186,218,255,0,56,70,2,0,4,139,251,251,128,114,255,0,0,70,2,0,144,100,211,128,177,211,255,0,208,69,2,0,22,156,253,253,180,98,255,0,192,69,2,0,58,134,222,179,222,105,255,0,176,69,2,0,233,47,252,252,205,229,255,0,160,69,2,0,0,0,217,217,217,217,255,0,144,69,2,0,120,84,211,141,211,199,255,0,128,69,2,0,42,76,255,255,255,179,255,0,88,69,2,0,175,37,218,190,186,218,255,0,72,69,2,0,120,84,211,141,211,199,255,0,56,69,2,0,42,76,255,255,255,179,255,0,24,69,2,0,175,37,218,190,186,218,255,0,240,68,2,0,4,139,251,251,128,114,255,0,224,68,2,0,120,84,211,141,211,199,255,0,96,68,2,0,42,76,255,255,255,179,255,0,72,68,2,0,175,37,218,190,186,218,255,0,24,68,2,0,4,139,251,251,128,114,255,0,8,68,2,0,144,100,211,128,177,211,255,0,216,67,2,0,120,84,211,141,211,199,255,0,168,67,2,0,42,76,255,255,255,179,255,0,144,67,2,0,175,37,218,190,186,218,255,0,128,67,2,0,4,139,251,251,128,114,255,0,64,67,2,0,144,100,211,128,177,211,255,0,48,67,2,0,22,156,253,253,180,98,255,0,24,67,2,0,120,84,211,141,211,199,255,0,8,67,2,0,42,76,255,255,255,179,255,0,248,66,2,0,175,37,218,190,186,218,255,0,232,66,2,0,4,139,251,251,128,114,255,0,192,66,2,0,144,100,211,128,177,211,255,0,176,66,2,0,22,156,253,253,180,98,255,0,160,66,2,0,58,134,222,179,222,105,255,0,144,66,2,0,120,84,211,141,211,199,255,0,112,66,2,0,42,76,255,255,255,179,255,0,72,66,2,0,175,37,218,190,186,218,255,0,0,66,2,0,4,139,251,251,128,114,255,0,240,65,2,0,144,100,211,128,177,211,255,0,224,65,2,0,22,156,253,253,180,98,255,0,208,65,2,0,58,134,222,179,222,105,255,0,160,65,2,0,233,47,252,252,205,229,255,0,136,65,2,0,120,84,211,141,211,199,255,0,96,65,2,0,42,76,255,255,255,179,255,0,80,65,2,0,175,37,218,190,186,218,255,0,48,65,2,0,4,139,251,251,128,114,255,0,24,65,2,0,144,100,211,128,177,211,255,0,8,65,2,0,22,156,253,253,180,98,255,0,248,64,2,0,58,134,222,179,222,105,255,0,232,64,2,0,233,47,252,252,205,229,255,0,216,64,2,0,0,0,217,217,217,217,255,0,176,64,2,0,237,253,158,158,1,66,255,0,160,64,2,0,177,130,162,94,79,162,255,0,144,64,2,0,250,180,213,213,62,79,255,0,128,64,2,0,10,184,244,244,109,67,255,0,40,64,2,0,20,157,253,253,174,97,255,0,24,64,2,0,31,115,254,254,224,139,255,0,8,64,2,0,49,96,245,230,245,152,255,0,248,63,2,0,79,65,221,171,221,164,255,0,232,63,2,0,114,120,194,102,194,165,255,0,216,63,2,0,143,187,189,50,136,189,255,0,176,63,2,0,237,253,158,158,1,66,255,0,104,63,2,0,143,187,189,50,136,189,255,0,88,63,2,0,177,130,162,94,79,162,255,0,64,63,2,0,250,180,213,213,62,79,255,0,24,63,2,0,10,184,244,244])
.concat([109,67,255,0,8,63,2,0,20,157,253,253,174,97,255,0,248,62,2,0,31,115,254,254,224,139,255,0,232,62,2,0,42,64,255,255,255,191,255,0,216,62,2,0,49,96,245,230,245,152,255,0,200,62,2,0,79,65,221,171,221,164,255,0,160,62,2,0,114,120,194,102,194,165,255,0,144,62,2,0,13,164,252,252,141,89,255,0,128,62,2,0,42,64,255,255,255,191,255,0,80,62,2,0,81,77,213,153,213,148,255,0,32,62,2,0,254,225,215,215,25,28,255,0,16,62,2,0,20,157,253,253,174,97,255,0,0,62,2,0,79,65,221,171,221,164,255,0,240,61,2,0,143,196,186,43,131,186,255,0,224,61,2,0,254,225,215,215,25,28,255,0,208,61,2,0,20,157,253,253,174,97,255,0,64,61,2,0,42,64,255,255,255,191,255,0,48,61,2,0,79,65,221,171,221,164,255,0,32,61,2,0,143,196,186,43,131,186,255,0,16,61,2,0,250,180,213,213,62,79,255,0,224,60,2,0,13,164,252,252,141,89,255,0,208,60,2,0,31,115,254,254,224,139,255,0,176,60,2,0,49,96,245,230,245,152,255,0,160,60,2,0,81,77,213,153,213,148,255,0,144,60,2,0,143,187,189,50,136,189,255,0,128,60,2,0,250,180,213,213,62,79,255,0,80,60,2,0,13,164,252,252,141,89,255,0,64,60,2,0,31,115,254,254,224,139,255,0,48,60,2,0,42,64,255,255,255,191,255,0,32,60,2,0,49,96,245,230,245,152,255,0,248,59,2,0,81,77,213,153,213,148,255,0,232,59,2,0,143,187,189,50,136,189,255,0,216,59,2,0,250,180,213,213,62,79,255,0,200,59,2,0,10,184,244,244,109,67,255,0,184,59,2,0,20,157,253,253,174,97,255,0,168,59,2,0,31,115,254,254,224,139,255,0,128,59,2,0,49,96,245,230,245,152,255,0,112,59,2,0,79,65,221,171,221,164,255,0,80,59,2,0,114,120,194,102,194,165,255,0,16,59,2,0,143,187,189,50,136,189,255,0,216,58,2,0,250,180,213,213,62,79,255,0,200,58,2,0,10,184,244,244,109,67,255,0,184,58,2,0,20,157,253,253,174,97,255,0,168,58,2,0,31,115,254,254,224,139,255,0,152,58,2,0,42,64,255,255,255,191,255,0,136,58,2,0,49,96,245,230,245,152,255,0,96,58,2,0,79,65,221,171,221,164,255,0,80,58,2,0,114,120,194,102,194,165,255,0,64,58,2,0,143,187,189,50,136,189,255,0,48,58,2,0,147,15,255,240,248,255,255,0,224,57,2,0,24,35,250,250,235,215,255,0,208,57,2,0,127,255,255,0,255,255,255,0,152,57,2,0,113,128,255,127,255,212,255,0,120,57,2,0,127,15,255,240,255,255,255,0,72,57,2,0,42,26,245,245,245,220,255,0,56,57,2,0,23,58,255,255,228,196,255,0,248,56,2,0,0,0,0,0,0,0,255,0,216,56,2,0,25,49,255,255,235,205,255,0,192,56,2,0,170,255,255,0,0,255,255,0,176,56,2,0,192,206,226,138,43,226,255,0,104,56,2,0,0,190,165,165,42,42,255,0,80,56,2,0,23,99,222,222,184,135,255,0,48,56,2,0,128,103,160,95,158,160,255,0,32,56,2,0,63,255,255,127,255,0,255,0,16,56,2,0,17,218,210,210,105,30,255,0,0,56,2,0,11,175,255,255,127,80,255,0,208,55,2,0,154,147,237,100,149,237,255,0,192,55,2,0,33,34,255,255,248,220,255,0,176,55,2,0,246,231,220,220,20,60,255,0,160,55,2,0,127,255,255,0,255,255,255,0,128,55,2,0,170,255,139,0,0,139,255,0,104,55,2,0,127,255,139,0,139,139,255,0,80,55,2,0,30,239,184,184,134,11,255,0,24,55,2,0,0,0,169,169,169,169,255,0,8,55,2,0,85,255,100,0,100,0,255,0,248,54,2,0,0,0,169,169,169,169,255,0,200,54,2,0,39,110,189,189,183,107,255,0,176,54,2,0,212,255,139,139,0,139,255,0,152,54,2,0,58,142,107,85,107,47,255,0,128,54,2,0,23,255,255,255,140,0,255,0,96,54,2,0,198,192,204,153,50,204,255,0,72,54,2,0,0,255,139,139,0,0,255,0,56,54,2,0,10,121,233,233,150,122,255,0,32,54,2,0,85,61,188,143,188,143,255,0,8,54,2,0,175,143,139,72,61,139,255,0,240,53,2,0,127,103,79,47,79,79,255,0,192,53,2,0,127,103,79,47,79,79,255,0,168,53,2,0,128,255,209,0,206,209,255,0,152,53,2,0,199,255,211,148,0,211,255,0,136,53,2,0,232,235,255,255,20,147,255,0,56,53,2,0,138,255,255,0,191,255,255,0,40,53,2,0,0,0,105,105,105,105,255,0,24,53,2,0,0,0,105,105,105,105,255,0,8,53,2,0,148,225,255,30,144,255,255,0,248,52,2,0,0,206,178,178,34,34,255,0,224,52,2,0,28,15,255,255,250,240,255,0,176,52,2,0,85,192,139,34,139,34,255,0,160,52,2,0,212,255,255,255,0,255,255,0,144,52,2,0,0,0,220,220,220,220,255,0,120,52,2,0,170,7,255,248,248,255,255,0,88,52,2,0,35,255,255,255,215,0,255,0,72,52,2,0,30,217,218,218,165,32,255,0,56,52,2,0,0,0,128,128,128,128,255,0,40,52,2,0,85,255,128,0,128,0,255,0,16,52,2,0,59,208,255,173,255,47,255,0,0,52,2,0,0,0,128,128,128,128,255,0,216,51,2,0,85,15,255,240,255,240,255,0,200,51,2,0,233,150,255,255,105,180,255,0,184,51,2,0,0,140,205,205,92,92,255,0,152,51,2,0,194,255,130,75,0,130,255,0,112,51,2,0,42,15,255,255,255,240,255,0,96,51,2,0,38,106,240,240,230,140,255,0,80,51,2,0,170,20,250,230,230,250,255,0,56,51,2,0,240,15,255,255,240,245,255,0,40,51,2,0,64,255,252,124,252,0,255,0,16,51,2,0,38,49,255,255,250,205,255,0,232,50,2,0,137,63,230,173,216,230,255,0,96,50,2,0,0,119,240,240,128,128,255,0,80,50,2,0,127,31,255,224,255,255,255,0,48,50,2,0,42,40,250,250,250,210,255,0,240,49,2,0,0,0,211,211,211,211,255,0,224,49,2,0,85,100,238,144,238,144,255,0,208,49,2,0,0,0,211,211,211,211,255,0,160,49,2,0,248,73,255,255,182,193,255,0,136,49,2,0,12,132,255,255,160,122,255,0,112,49,2,0,125,209,178,32,178,170,255,0,48,49,2,0,143,117,250,135,206,250,255,0,24,49,2,0,148,56,153,119,136,153,255,0,0,49,2,0,148,56,153,119,136,153,255,0,232,48,2,0,151,52,222,176,196,222,255,0,176,48,2,0,42,31,255,255,255,224,255,0,160,48,2,0,85,255,255,0,255,0,255,0,144,48,2,0,85,192,205,50,205,50,255,0,128,48,2,0,21,20,250,250,240,230,255,0,112,48,2,0,212,255,255,255,0,255,255,0,96,48,2,0,0,255,128,128,0,0,255,0,48,48,2,0,113,128,205,102,205,170,255,0,232,47,2,0,170,255,205,0,0,205,255,0,176,47,2,0,204,152,211,186,85,211,255,0,96,47,2,0,183,124,219,147,112,219,255,0,24,47,2,0,103,169,179,60,179,113,255,0,0,47,2,0,176,143,238,123,104,238,255,0,232,46,2,0,111,255,250,0,250,154,255,0,208,46,2,0,125,167,209,72,209,204,255,0,184,46,2,0,228,228,199,199,21,133,255,0,152,46,2,0,170,198,112,25,25,112,255,0,104,46,2,0,106,9,255,245,255,250,255,0,88,46,2,0,4,30,255,255,228,225,255,0,72,46,2,0,26,73,255,255,228,181,255,0,48,46,2,0,25,81,255,255,222,173,255,0,248,45,2,0,170,255,128,0,0,128,255,0,232,45,2,0,27,23,253,253,245,230,255,0,176,45,2,0,42,255,128,128,128,0,255,0,152,45,2,0,56,192,142,107,142,35,255,0,112,45,2,0,27,255,255,255,165,0,255,0,96,45,2,0,11,255,255,255,69,0,255,0,56,45,2,0,214,123,218,218,112,214,255,0,248,44,2,0,38,72,238,238,232,170,255,0,224,44,2,0,85,100,251,152,251,152,255,0,200,44,2,0,127,67,238,175,238,238,255,0,120,44,2,0,241,124,219,219,112,147,255,0,104,44,2,0,26,41,255,255,239,213,255,0,72,44,2,0,20,70,255,255,218,185,255,0,56,44,2,0,20,176,205,205,133,63,255,0,40,44,2,0,247,63,255,255,192,203,255,0,24,44,2,0,212,70,221,221,160,221,255,0,240,43,2,0,132,59,230,176,224,230,255,0,224,43,2,0,212,255,128,128,0,128,255,0,208,43,2,0,0,255,255,255,0,0,255,0,192,43,2,0,0,61,188,188,143,143,255,0,152,43,2,0,159,181,225,65,105,225,255,0,112,43,2,0,17,220,139,139,69,19,255,0,96,43,2,0,4,138,250,250,128,114,255,0,80,43,2,0,19,154,244,244,164,96,255,0,56,43,2,0,103,170,139,46,139,87,255,0,40,43,2,0,17,16,255,255,245,238,255,0,248,42,2,0,13,183,160,160,82,45,255,0,232,42,2,0,0,0,192,192,192,192,255,0,216,42,2,0,139,108,235,135,206,235,255,0,200,42,2,0,175,143,205,106,90,205,255,0,112,42,2,0,148,56,144,112,128,144,255,0,88,42,2,0,148,56,144,112,128,144,255,0,72,42,2,0,0,5,255,255,250,250,255,0,48,42,2,0,106,255,255,0,255,127,255,0,32,42,2,0,146,155,180,70,130,180,255,0,16,42,2,0,24,84,210,210,180,140,255,0,232,41,2,0,127,255,128,0,128,128,255,0,216,41,2,0,212,29,216,216,191,216,255,0,200,41,2,0,6,184,255,255,99,71,255,0,168,41,2,0,123,182,224,64,224,208,255,0,88,41,2,0,212,115,238,238,130,238,255,0,72,41,2,0,27,68,245,245,222,179,255,0,56,41,2,0,0,0,255,255,255,255,255,0,40,41,2,0,0,0,245,245,245,245,255,0,24,41,2,0,42,255,255,255,255,0,255,0,0,41,2,0,56,192,205,154,205,50,255,0,216,40,2,0,45,67,252,247,252,185,255,0,200,40,2,0,68,91,221,173,221,142,255,0,184,40,2,0,98,178,163,49,163,84,255,0,112,40,2,0,42,50,255,255,255,204,255,0,72,40,2,0,62,85,230,194,230,153,255,0,56,40,2,0,85,100,198,120,198,121,255,0,40,40,2,0,99,187,132,35,132,67,255,0,24,40,2,0,42,50,255,255,255,204,255,0,8,40,2,0,62,85,230,194,230,153,255,0,248,39,2,0,85,100,198,120,198,121,255,0,208,39,2,0,98,178,163,49,163,84,255,0,192,39,2,0,107,255,104,0,104,55,255,0,176,39,2,0,42,50,255,255,255,204,255,0,144,39,2,0,55,81,240,217,240,163,255,0,96,39,2,0,68,91,221,173,221,142,255,0,80,39,2,0,85,100,198,120,198,121,255,0,64,39,2,0,98,178,163,49,163,84,255,0,48,39,2,0,107,255,104,0,104,55,255,0,32,39,2,0,42,50,255,255,255,204,255,0,16,39,2,0,55,81,240,217,240,163,255,0,200,35,2,0,68,91,221,173,221,142,255,0,184,35,2,0,85,100,198,120,198,121,255,0,128,35,2,0,96,158,171,65,171,93,255,0,112,35,2,0,99,187,132,35,132,67,255,0,64,35,2,0,108,255,90,0,90,50,255,0,0,35,2,0,42,25,255,255,255,229,255,0,240,34,2,0,45,67,252,247,252,185,255,0,224,34,2,0,55,81,240,217,240,163,255,0,208,34,2,0,68,91,221,173,221,142,255,0,192,34,2,0,85,100,198,120,198,121,255,0,144,34,2,0,96,158,171,65,171,93,255,0,128,34,2,0,99,187,132,35,132,67,255,0,112,34,2,0,108,255,90,0,90,50,255,0,96,34,2,0,42,25,255,255,255,229,255,0,48,34,2,0,45,67,252,247,252,185,255,0,32,34,2,0,55,81,240,217,240,163,255,0,16,34,2,0,68,91,221,173,221,142,255,0,0,34,2,0,85,100,198,120,198,121,255,0,240,33,2,0,96,158,171,65,171,93,255,0,224,33,2,0,99,187,132,35,132,67,255,0,168,33,2,0,107,255,104,0,104,55,255,0,152,33,2,0,110,255,69,0,69,41,255,0,112,33,2,0,49,73,248,237,248,177,255,0,88,33,2,0,117,97,205,127,205,187,255,0,248,32,2,0,144,194,184,44,127,184,255,0,232,32,2,0,42,50,255,255,255,204,255,0,216,32,2,0,99,66,218,161,218,180,255,0,200,32,2,0,132,170,196,65,182,196,255,0,184,32,2,0,150,203,168,34,94,168,255,0,168,32,2,0,42,50,255,255,255,204,255,0,128,32,2,0,99,66,218,161,218,180,255,0,112,32,2,0,132,170,196,65,182,196,255,0,96,32,2,0,144,194,184,44,127,184,255,0,80,32,2,0,164,191,148,37,52,148,255,0,24,32,2,0,42,50,255,255,255,204,255,0,8,32,2,0,69,58,233,199,233,180,255,0,232,31,2,0,117,97,205,127,205,187,255,0,208,31,2,0,132,170,196,65,182,196,255,0,168,31,2,0,144,194,184,44,127,184,255,0,152,31,2,0,164,191,148,37,52,148,255,0,112,31,2,0,42,50,255,255,255,204,255,0,88,31,2,0,69,58,233,199,233,180,255,0,64,31,2,0,117,97,205,127,205,187,255,0,48,31,2,0,132,170,196,65,182,196,255,0,200,30,2,0,139,216,192,29,145,192,255,0,184,30,2,0,150,203,168,34,94,168,255,0,160,30,2,0,158,231,132,12,44,132,255,0,136,30,2,0,42,38,255,255,255,217,255,0,120,30,2,0,49,73,248,237,248,177,255,0,104,30,2,0,69,58,233,199,233,180,255,0,64,30,2,0,117,97,205,127,205,187,255,0,48,30,2,0,132,170,196,65,182,196,255,0,16,30,2,0,139,216,192,29,145,192,255,0,0,30,2,0,150,203,168,34,94,168,255,0,200,29,2,0,158,231,132,12,44,132,255,0,176,29,2,0,42,38,255,255,255,217,255,0,160,29,2,0,49,73,248,237,248,177,255,0,144,29,2,0,69,58,233,199,233,180,255,0,128,29,2,0,117,97,205,127,205,187,255,0,96,29,2,0,132,170,196,65,182,196,255,0,48,29,2,0,139,216,192,29,145,192,255,0,32,29,2,0,150,203,168,34,94,168,255,0,16,29,2,0,164,191,148,37,52,148,255,0,0,29,2,0,158,231,88,8,29,88,255,0,208,28,2,0,37,66,255,255,247,188,255,0,176,28,2,0,28,175,254,254,196,79,255,0,160,28,2,0,16,238,217,217,95,14,255,0,144,28,2,0,42,42,255,255,255,212,255,0,128,28,2,0,28,112,254,254,217,142,255,0,112,28,2,0,22,213,254,254,153,41,255,0,72,28,2,0,15,252,204,204,76,2,255,0,56,28,2,0,42,42,255,255,255,212,255,0,40,28,2,0,28,112,254,254,217,142,255,0,16,28,2,0,22,213,254,254,153,41,255,0,136,27,2,0,16,238,217,217,95,14,255,0,120,27,2,0,13,248,153,153,52,4,255,0,104,27,2,0,42,42,255,255,255,212,255,0,88,27,2,0,31,109,254,254,227,145,255,0,72,27,2,0,28,175,254,254,196,79,255,0,56,27,2,0,22,213,254,254,153,41,255,0,16,27,2,0,16,238,217,217,95,14,255,0,0,27,2,0,13,248,153,153,52,4,255,0,240,26,2,0,42,42,255,255,255,212,255,0,208,26,2,0,31,109,254,254,227,145,255,0,168,26,2,0,28,175,254,254,196,79,255,0,152,26,2,0,22,213,254,254,153,41,255,0,136,26,2,0,18,233,236,236,112,20,255,0,120,26,2,0,15,252,204,204,76,2,255,0,104,26,2,0,12,247,140,140,45,4,255,0,88,26,2,0,42,25,255,255,255,229,255,0,48,26,2,0,37,66,255,255,247,188,255,0,32,26,2,0,31,109,254,254,227,145,255,0,16,26,2,0,28,175,254,254,196,79,255,0,240,25,2,0,22,213,254,254,153,41,255,0,192,25,2,0,18,233,236,236,112,20,255,0,176,25,2,0,15,252,204,204,76,2,255,0,160,25,2,0,12,247,140,140,45,4,255,0,144,25,2,0,42,25,255,255,255,229,255,0,128,25,2,0,37,66,255,255,247,188,255,0,112,25,2,0,31,109,254,254,227,145,255,0,72,25,2,0,28,175,254,254,196,79,255,0,56,25,2,0,22,213,254,254,153,41,255,0,40,25,2,0,18,233,236,236,112,20,255,0,192,24,2,0,15,252,204,204,76,2,255,0,144,24,2,0,13,248,153,153,52,4,255,0,128,24,2,0,13,240,102,102,37,6,255,0,112,24,2,0,34,95,255,255,237,160,255,0,96,24,2,0,24,178,254,254,178,76,255,0,80,24,2,0,5,221,240,240,59,32,255,0,56,24,2,0,42,77,255,255,255,178,255,0,8,24,2,0,29,162,254,254,204,92,255,0,248,23,2,0,17,194,253,253,141,60,255,0,232,23,2,0,254,225,227,227,26,28,255,0,216,23,2,0,42,77,255,255,255,178,255,0,152,23,2,0,29,162,254,254,204,92,255,0,136,23,2,0,17,194,253,253,141,60,255,0,120,23,2,0,5,221,240,240,59,32,255,0,88,23,2,0,246,255,189,189,0,38,255,0,72,23,2,0,42,77,255,255,255,178,255,0,56,23,2,0,30,136,254,254,217,118,255,0,16,23,2,0,24,178,254,254,178,76,255,0,0,23,2,0,17,194,253,253,141,60,255,0,240,22,2,0,5,221,240,240,59,32,255,0,224,22,2,0,246,255,189,189,0,38,255,0,120,22,2,0,42,77,255,255,255,178,255,0,104,22,2,0,30,136,254,254,217,118,255,0,88,22,2,0,24,178,254,254,178,76,255,0,72,22,2,0,17,194,253,253,141,60,255,0,56,22,2,0,7,212,252,252,78,42,255,0,40,22,2,0,254,225,227,227,26,28,255,0,0,22,2,0,245,255,177,177,0,38,255,0,240,21,2,0,42,50,255,255,255,204,255,0,224,21,2,0,34,95,255,255,237,160,255,0,160,21,2,0,30,136,254,254,217,118,255,0,96,21,2,0,24,178,254,254,178,76,255,0,80,21,2,0,17,194,253,253,141,60,255,0,16,21,2,0,7,212,252,252,78,42,255,0,248,20,2,0,254,225,227,227,26,28,255,0,232,20,2,0,245,255,177,177,0,38,255,0,208,20,2,0,42,50,255,255,255,204,255,0,168,20,2,0,34,95,255,255,237,160,255,0,136,20,2,0,30,136,254,254,217,118,255,0,120,20,2,0,24,178,254,254,178,76,255,0,96,20,2,0,17,194,253,253,141,60,255,0,0,20,2,0,7,212,252,252,78,42,255,0,240,19,2,0,254,225,227,227,26,28,255,0,224,19,2,0,246,255,189,189,0,38,255,0,184,19,2,0,242,255,128,128,0,38,255,0,160,19,2,0,147,15,255,240,248,255,255,0,144,19,2,0,24,35,250,250,235,215,255,0,104,19,2,0,23,36,255,255,239,219,255,0,88,19,2,0,23,36,238,238,223,204,255,0,72,19,2,0,23,36,205,205,192,176,255,0,56,19,2,0,24,34,139,139,131,120,255,0,248,18,2,0,113,128,255,127,255,212,255,0,216,18,2,0,113,128,255,127,255,212,255,0,200,18,2,0,113,128,238,118,238,198,255,0,184,18,2,0,113,128,205,102,205,170,255,0,168,18,2,0,113,128,139,69,139,116,255,0,160,18,2,0,127,15,255,240,255,255,255,0,120,18,2,0,127,15,255,240,255,255,255,0,112,18,2,0,127,15,238,224,238,238,255,0,104,18,2,0,127,14,205,193,205,205,255,0,96,18,2,0,127,14,139,131,139,139,255,0,48,18,2,0,42,26,245,245,245,220,255,0,8,18,2,0,23,58,255,255,228,196,255,0,248,17,2,0,23,58,255,255,228,196,255,0,240,17,2,0,23,58,238,238,213,183,255,0,232,17,2,0,22,58,205,205,183,158,255,0,224,17,2,0,23,58,139,139,125,107,255,0,192,17,2,0,0,0,0,0,0,0,255,0,176,17,2,0,25,49,255,255,235,205,255,0,168,17,2,0,170,255,255,0,0,255,255,0,160,17,2,0,170,255,255,0,0,255,255,0,104,17,2,0,170,255,238,0,0,238,255,0,72,17,2,0,170,255,205,0,0,205,255,0,64,17,2,0,170,255,139,0,0,139,255,0,48,17,2,0,192,206,226,138,43,226,255,0,40,17,2,0,0,190,165,165,42,42,255,0,32,17,2,0,0,191,255,255,64,64,255,0,0,17,2,0,0,191,238,238,59,59,255,0,248,16,2,0,0,191,205,205,51,51,255,0,240,16,2,0,0,190,139,139,35,35,255,0,216,16,2,0,23,99,222,222,184,135,255,0,184,16,2,0,23,100,255,255,211,155,255,0,144,16,2,0,23,99,238,238,197,145,255,0,128,16,2,0,23,99,205,205,170,125,255,0,112,16,2,0,23,99,139,139,115,85,255,0,96,16,2,0,128,103,160,95,158,160,255,0,80,16,2,0,131,103,255,152,245,255,255,0,40,16,2,0,131,102,238,142,229,238,255,0,24,16,2,0,131,103,205,122,197,205,255,0,8,16,2,0,131,102,139,83,134,139,255,0,232,15,2,0,63,255,255,127,255,0,255,0,200,15,2,0,63,255,255,127,255,0,255,0,160,15,2,0,63,255,238,118,238,0,255,0,144,15,2,0,63,255,205,102,205,0,255,0,128,15,2,0,63,255,139,69,139,0,255,0,112,15,2,0,17,218,210,210,105,30,255,0,96,15,2,0,17,219,255,255,127,36,255,0,56,15,2,0,17,219,238,238,118,33,255,0,40,15,2,0,17,218,205,205,102,29,255,0,24,15,2,0,17,220,139,139,69,19,255,0,16,15,2,0,11,175,255,255,127,80,255,0,216,14,2,0,7,169,255,255,114,86,255,0,192,14,2,0,6,169,238,238,106,80,255,0,184,14,2,0,6,169,205,205,91,69,255,0,176,14,2,0,6,168,139,139,62,47,255,0,160,14,2,0,154,147,237,100,149,237,255,0,144,14,2,0,33,34,255,255,248,220,255,0,96,14,2,0,33,34,255,255,248,220,255,0,80,14,2,0,34,35,238,238,232,205,255,0,64,14,2,0,34,34,205,205,200,177,255,0,48,14,2,0,35,34,139,139,136,120,255,0,16,14,2,0,246,231,220,220,20,60,255,0,240,13,2,0,127,255,255,0,255,255,255,0,232,13,2,0,127,255,255,0,255,255,255,0,224,13,2,0,127,255,238,0,238,238,255,0,216,13,2,0,127,255,205,0,205,205,255,0,208,13,2,0,127,255,139,0,139,139,255,0,168,13,2,0,30,239,184,184,134,11,255,0,152,13,2,0,30,240,255,255,185,15,255,0,136,13,2,0,30,240,238,238,173,14,255,0,120,13,2,0,30,240,205,205,149,12,255,0,32,13,2,0,30,240,139,139,101,8,255,0,0,13,2,0,85,255,100,0,100,0,255,0,240,12,2,0,39,110,189,189,183,107,255,0,224,12,2,0,58,142,107,85,107,47,255,0,208,12,2,0,58,143,255,202,255,112,255,0,192,12,2,0,58,143,238,188,238,104,255,0,152,12,2,0,58,143,205,162,205,90,255,0,136,12,2,0,58,143,139,110,139,61,255,0,120,12,2,0,23,255,255,255,140,0,255,0,104,12,2,0,21,255,255,255,127,0,255,0,24,12,2,0,21,255,238,238,118,0,255,0,248,11,2,0,21,255,205,205,102,0,255,0,224,11,2,0,21,255,139,139,69,0,255,0,192,11,2,0,198,192,204,153,50,204,255,0,176,11,2,0,198,193,255,191,62,255,255,0,160,11,2,0,198,192,238,178,58,238,255,0,120,11,2,0,198,192,205,154,50,205,255,0,96,11,2,0,198,192,139,104,34,139,255,0,80,11,2,0,10,121,233,233,150,122,255,0,56,11,2,0,85,61,188,143,188,143,255,0,176,10,2,0,85,62,255,193,255,193,255,0,152,10,2,0,85,62,238,180,238,180,255,0,136,10,2,0,85,62,205,155,205,155,255,0,104,10,2,0,85,62,139,105,139,105,255,0,88,10,2,0,175,143,139,72,61,139,255,0,56,10,2,0,127,103,79,47,79,79,255,0,16,10,2,0,127,104,255,151,255,255,255,0,0,10,2,0,127,103,238,141,238,238,255,0,224,9,2,0,127,104,205,121,205,205,255,0,208,9,2,0,127,104,139,82,139,139,255,0,144,9,2,0,127,103,79,47,79,79,255,0,120,9,2,0,128,255,209,0,206,209,255,0,96,9,2,0,199,255,211,148,0,211,255,0,80,9,2,0,232,235,255,255,20,147,255,0,64,9,2,0,232,235,255,255,20,147,255,0,48,9,2,0,232,235,238,238,18,137,255,0,16,9,2,0,232,235,205,205,16,118,255,0,0,9,2,0,231,236,139,139,10,80,255,0,216,8,2,0,138,255,255,0,191,255,255,0,200,8,2,0,138,255,255,0,191,255,255,0,168,8,2,0,138,255,238,0,178,238,255,0,96,8,2,0,138,255,205,0,154,205,255,0,80,8,2,0,138,255,139,0,104,139,255,0,0,8,2,0,0,0,105,105,105,105,255,0,248,7,2,0,0,0,105,105,105,105,255,0,232,7,2,0,148,225,255,30,144,255,255,0,208,7,2,0,148,225,255,30,144,255,255,0,192,7,2,0,148,225,238,28,134,238,255,0,160,7,2,0,148,225,205,24,116,205,255,0,144,7,2,0,148,225,139,16,78,139,255,0,88,7,2,0,0,206,178,178,34,34,255,0,56,7,2,0,0,207,255,255,48,48,255,0,40,7,2,0,0,207,238,238,44,44,255,0,24,7,2,0,0,207,205,205,38,38,255,0,8,7,2,0,0,207,139,139,26,26,255,0,248,6,2,0,28,15,255,255,250,240,255,0,224,6,2,0,85,192,139,34,139,34,255,0,208,6,2,0,0,0,220,220,220,220,255,0,176,6,2,0,170,7,255,248,248,255,255,0,152,6,2,0,35,255,255,255,215,0,255,0,120,6,2,0,35,255,255,255,215,0,255,0,96,6,2,0,35,255,238,238,201,0,255,0,88,6,2,0,35,255,205,205,173,0,255,0,80,6,2,0,35,255,139,139,117,0,255,0,64,6,2,0,30,217,218,218,165,32,255,0,48,6,2,0,30,218,255,255,193,37,255,0,24,6,2,0,30,218,238,238,180,34,255,0,8,6,2,0,30,218,205,205,155,29,255,0,232,5,2,0,30,218,139,139,105,20,255,0,208,5,2,0,0,0,192,192,192,192,255,0,184,5,2,0,0,0,0,0,0,0,255,0,168,5,2,0,0,0,3,3,3,3,255,0,160,5,2,0,0,0,26,26,26,26,255,0,152,5,2,0,0,0,255,255,255,255,255,0,144,5,2,0,0,0,28,28,28,28,255,0,136,5,2,0,0,0,31,31,31,31,255,0,120,5,2,0,0,0,33,33,33,33,255,0,112,5,2,0,0,0,36,36,36,36,255,0,88,5,2,0,0,0,38,38,38,38,255,0,80,5,2,0,0,0,41,41,41,41,255,0,48,5,2,0,0,0,43,43,43,43,255,0,24,5,2,0,0,0,46,46,46,46,255,0,16,5,2,0,0,0,48,48,48,48,255,0,8,5,2,0,0,0,5,5,5,5,255,0,0,5,2,0,0,0,51,51,51,51,255,0,248,4,2,0,0,0,54,54,54,54,255,0,216,4,2,0,0,0,56,56,56,56,255,0,208,4,2,0,0,0,59,59,59,59,255,0,184,4,2,0,0,0,61,61,61,61,255,0,176,4,2,0,0,0,64,64,64,64,255,0,136,4,2,0,0,0,66,66,66,66,255,0,120,4,2,0,0,0,69,69,69,69,255,0,112,4,2,0,0,0,71,71,71,71,255,0,104,4,2,0,0,0,74,74,74,74,255,0,96,4,2,0,0,0,8,8,8,8,255,0,88,4,2,0,0,0,77,77,77,77,255,0,72,4,2,0,0,0,79,79,79,79,255,0,64,4,2,0,0,0,82,82,82,82,255,0,40,4,2,0,0,0,84,84,84,84,255,0,32,4,2,0,0,0,87,87,87,87,255,0,208,3,2,0,0,0,89,89,89,89,255,0,176,3,2,0,0,0,92,92,92,92,255,0,168,3,2,0,0,0,94,94,94,94,255,0,160,3,2,0,0,0,97,97,97,97,255,0,152,3,2,0,0,0,99,99,99,99,255,0,144,3,2,0,0,0,10,10,10,10,255,0,128,3,2,0,0,0,102,102,102,102,255,0,120,3,2,0,0,0,105,105,105,105,255,0,96,3,2,0,0,0,107,107,107,107,255,0,88,3,2,0,0,0,110,110,110,110,255,0,48,3,2,0,0,0,112,112,112,112,255,0,32,3,2,0,0,0,115,115,115,115,255,0,16,3,2,0,0,0,117,117,117,117,255,0,0,3,2,0,0,0,120,120,120,120,255,0,248,2,2,0,0,0,122,122,122,122,255,0,240,2,2,0,0,0,125,125,125,125,255,0,184,2,2,0,0,0,13,13,13,13,255,0,168,2,2,0,0,0,127,127,127,127,255,0,144,2,2,0,0,0,130,130,130,130,255,0,128,2,2,0,0,0,133,133,133,133,255,0,8,2,2,0,0,0,135,135,135,135,255,0,248,1,2,0,0,0,138,138,138,138,255,0,240,1,2,0,0,0,140,140,140,140,255,0,216,1,2,0,0,0,143,143,143,143,255,0,208,1,2,0,0,0,145,145,145,145,255,0,200,1,2,0,0,0,148,148,148,148,255,0,176,1,2,0,0,0,150,150,150,150,255,0,168,1,2,0,0,0,15,15,15,15,255,0,144,1,2,0,0,0,153,153,153,153,255,0,136,1,2,0,0,0,156,156,156,156,255,0,112,1,2,0,0,0,158,158,158,158,255,0,88,1,2,0,0,0,161,161,161,161,255,0,64,1,2,0,0,0,163,163,163,163,255,0,56,1,2,0,0,0,166,166,166,166,255,0,48,1,2,0,0,0,168,168,168,168,255,0,40,1,2,0,0,0,171,171,171,171,255,0,16,1,2,0,0,0,173,173,173,173,255,0,8,1,2,0,0,0,176,176,176,176,255,0,240,0,2,0,0,0,18,18,18,18,255,0,232,0,2,0,0,0,179,179,179,179,255,0,208,0,2,0,0,0,181,181,181,181,255,0,176,0,2,0,0,0,184,184,184,184,255,0,168,0,2,0,0,0,186,186,186,186,255,0,160,0,2,0,0,0,189,189,189,189,255,0,128,0,2,0,0,0,191,191,191,191,255,0,120,0,2,0,0,0,194,194,194,194,255,0,104,0,2,0,0,0,196,196,196,196,255,0,96,0,2,0,0,0,199,199,199,199,255,0,72,0,2,0,0,0,201,201,201,201,255,0,64,0,2,0,0,0,20,20,20,20,255,0,24,0,2,0,0,0,204,204,204,204,255,0,248,255,1,0,0,0,207,207,207,207,255,0,240,255,1,0,0,0,209,209,209,209,255,0,232,255,1,0,0,0,212,212,212,212,255,0,224,255,1,0,0,0,214,214,214,214,255,0,216,255,1,0,0,0,217,217,217,217,255,0,200,255,1,0,0,0,219,219,219,219,255,0,192,255,1,0,0,0,222,222,222,222,255,0,168,255,1,0,0,0,224,224,224,224,255,0,152,255,1,0,0,0,227,227,227,227,255,0,136,255,1,0,0,0,23,23,23,23,255,0,112,255,1,0,0,0,229,229,229,229,255,0,104,255,1,0,0,0,232,232,232,232,255,0,96,255,1,0,0,0,235,235,235,235,255,0,88,255,1,0,0,0,237,237,237,237,255,0,80,255,1,0,0,0,240,240,240,240,255,0,64,255,1,0,0,0,242,242,242,242,255,0,56,255,1,0,0,0,245,245,245,245,255,0,32,255,1,0,0,0,247,247,247,247,255,0,8,255,1,0,0,0,250,250,250,250,255,0,240,254,1,0,0,0,252,252,252,252,255,0,176,254,1,0,85,255,255,0,255,0,255,0,168,254,1,0,85,255,255,0,255,0,255,0,160,254,1,0,85,255,238,0,238,0,255,0,152,254,1,0,85,255,205,0,205,0,255,0,144,254,1,0,85,255,139,0,139,0,255,0,120,254,1,0,59,208,255,173,255,47,255,0,112,254,1,0,0,0,192,192,192,192,255,0,88,254,1,0,0,0,0,0,0,0,255,0,80,254,1,0,0,0,3,3,3,3,255,0,56,254,1,0,0,0,26,26,26,26,255,0,24,254,1,0,0,0,255,255,255,255,255,0,8,254,1,0,0,0,28,28,28,28,255,0,0,254,1,0,0,0,31,31,31,31,255,0,248,253,1,0,0,0,33,33,33,33,255,0,240,253,1,0,0,0,36,36,36,36,255,0,216,253,1,0,0,0,38,38,38,38,255,0,200,253,1,0,0,0,41,41,41,41,255,0,176,253,1,0,0,0,43,43,43,43,255,0,168,253,1,0,0,0,46,46,46,46,255,0,120,253,1,0,0,0,48,48,48,48,255,0,104,253,1,0,0,0,5,5,5,5,255,0,96,253,1,0,0,0,51,51,51,51,255,0,88,253,1,0,0,0,54,54,54,54,255,0,80,253,1,0,0,0,56,56,56,56,255,0,72,253,1,0,0,0,59,59,59,59,255,0,56,253,1,0,0,0,61,61,61,61,255,0,48,253,1,0,0,0,64,64,64,64,255,0,24,253,1,0,0,0,66,66,66,66,255,0,16,253,1,0,0,0,69,69,69,69,255,0,208,252,1,0,0,0,71,71,71,71,255,0,144,252,1,0,0,0,74,74,74,74,255,0,136,252,1,0,0,0,8,8,8,8,255,0,128,252,1,0,0,0,77,77,77,77,255,0,88,252,1,0,0,0,79,79,79,79,255,0,80,252,1,0,0,0,82,82,82,82,255,0,64,252,1,0,0,0,84,84,84,84,255,0,56,252,1,0,0,0,87,87,87,87,255,0,32,252,1,0,0,0,89,89,89,89,255,0,24,252,1,0,0,0,92,92,92,92,255,0,232,251,1,0,0,0,94,94,94,94,255,0,224,251,1,0,0,0,97,97,97,97,255,0,208,251,1,0,0,0,99,99,99,99,255,0,192,251,1,0,0,0,10,10,10,10,255,0,184,251,1,0,0,0,102,102,102,102,255,0,176,251,1,0,0,0,105,105,105,105,255,0,160,251,1,0,0,0,107,107,107,107,255,0,144,251,1,0,0,0,110,110,110,110,255,0,120,251,1,0,0,0,112,112,112,112,255,0,112,251,1,0,0,0,115,115,115,115,255,0,56,251,1,0,0,0,117,117,117,117,255,0,48,251,1,0,0,0,120,120,120,120,255,0,40,251,1,0,0,0,122,122,122,122,255,0,24,251,1,0,0,0,125,125,125,125,255,0,16,251,1,0,0,0,13,13,13,13,255,0,8,251,1,0,0,0,127,127,127,127,255,0,248,250,1,0,0,0,130,130,130,130,255,0,240,250,1,0,0,0,133,133,133,133,255,0,216,250,1,0,0,0,135,135,135,135,255,0,208,250,1,0,0,0,138,138,138,138,255,0,160,250,1,0,0,0,140,140,140,140,255,0,152,250,1,0,0,0,143,143,143,143,255,0,120,250,1,0,0,0,145,145,145,145,255,0,112,250,1,0,0,0,148,148,148,148,255,0,104,250,1,0,0,0,150,150,150,150,255,0,96,250,1,0,0,0,15,15,15,15,255,0,72,250,1,0,0,0,153,153,153,153,255,0,64,250,1,0,0,0,156,156,156,156,255,0,40,250,1,0,0,0,158,158,158,158,255,0,232,249,1,0,0,0,161,161,161,161,255,0,192,249,1,0,0,0,163,163,163,163,255,0,128,249,1,0,0,0,166,166,166,166,255,0,120,249,1,0,0,0,168,168,168,168,255,0,112,249,1,0,0,0,171,171,171,171,255,0,104,249,1,0,0,0,173,173,173,173,255,0,88,249,1,0,0,0,176,176,176,176,255,0,72,249,1,0,0,0,18,18,18,18,255,0,64,249,1,0,0,0,179,179,179,179,255,0,40,249,1,0,0,0,181,181,181,181,255,0,16,249,1,0,0,0,184,184,184,184,255,0,216,248,1,0,0,0,186,186,186,186,255,0,200,248,1,0,0,0,189,189,189,189,255,0,192,248,1,0,0,0,191,191,191,191,255,0,184,248,1,0,0,0,194,194,194,194,255,0,176,248,1,0,0,0,196,196,196,196,255,0,168,248,1,0,0,0,199,199,199,199,255,0,152,248,1,0,0,0,201,201,201,201,255,0,144,248,1,0,0,0,20,20,20,20,255,0,120,248,1,0,0,0,204,204,204,204,255,0,112,248,1,0,0,0,207,207,207,207,255,0,40,248,1,0,0,0,209,209,209,209,255,0,32,248,1,0,0,0,212,212,212,212,255,0,24,248,1,0,0,0,214,214,214,214,255,0,16,248,1,0,0,0,217,217,217,217,255,0,8,248,1,0,0,0,219,219,219,219,255,0,0,248,1,0,0,0,222,222,222,222,255,0,240,247,1,0,0,0,224,224,224,224,255,0,232,247,1,0,0,0,227,227,227,227,255,0,208,247,1,0,0,0,23,23,23,23,255,0,184,247,1,0,0,0,229,229,229,229,255,0,120,247,1,0,0,0,232,232,232,232,255,0,112,247,1,0,0,0,235,235,235,235,255,0,104,247,1,0,0,0,237,237,237,237,255,0,96,247,1,0,0,0,240,240,240,240,255,0,88,247,1,0,0,0,242,242,242,242,255,0,80,247,1,0,0,0,245,245,245,245,255,0,64,247,1,0,0,0,247,247,247,247,255,0,56,247,1,0,0,0,250,250,250,250,255,0,32,247,1,0,0,0,252,252,252,252,255,0,16,247,1,0,85,15,255,240,255,240,255,0,240,246,1,0,85,15,255,240,255,240,255,0,224,246,1,0,85,15,238,224,238,224,255,0,208,246,1,0,85,14,205,193,205,193,255,0,176,246,1,0,85,14,139,131,139,131,255,0,168,246,1,0,233,150,255,255,105,180,255,0,152,246,1,0,234,145,255,255,110,180,255,0,120,246,1,0,235,141,238,238,106,167,255,0,104,246,1,0,236,135,205,205,96,144,255,0,72,246,1,0,234,148,139,139,58,98,255,0,56,246,1,0,0,140,205,205,92,92,255,0,16,246,1,0,0,148,255,255,106,106,255,0,0,246,1,0,0,148,238,238,99,99,255,0,240,245,1,0,0,149,205,205,85,85,255,0,224,245,1,0,0,148,139,139,58,58,255,0,216,245,1,0,194,255,130,75,0,130,255,0,208,245,1,0,42,0,255,255,255,254,0,0,192,245,1,0,42,15,255,255,255,240,255,0,184,245,1,0,42,15,255,255,255,240,255,0,160,245,1,0,42,15,238,238,238,224,255,0,128,245,1,0,42,14,205,205,205,193,255,0,240,244,1,0,42,14,139,139,139,131,255,0,224,244,1,0,38,106,240,240,230,140,255,0,216,244,1,0,39,112,255,255,246,143,255,0,208,244,1,0,39,112,238,238,230,133,255,0,184,244,1,0,39,111,205,205,198,115,255,0,176,244,1,0,39,111,139,139,134,78,255,0,152,244,1,0,170,20,250,230,230,250,255,0,136,244,1,0,240,15,255,255,240,245,255,0,104,244,1,0,240,15,255,255,240,245,255,0,32,244,1,0,239,15,238,238,224,229,255,0,216,243,1,0,240,14,205,205,193,197,255,0,200,243,1,0,239,14,139,139,131,134,255,0,176,243,1,0,64,255,252,124,252,0,255,0,144,243,1,0,38,49,255,255,250,205,255,0,128,243,1,0,38,49,255,255,250,205,255,0,112,243,1,0,37,50,238,238,233,191,255,0,88,243,1,0,38,49,205,205,201,165,255,0,64,243,1,0,39,49,139,139,137,112,255,0,32,243,1,0,137,63,230,173,216,230,255,0,16,243,1,0,138,64,255,191,239,255,255,0,152,242,1,0,138,64,238,178,223,238,255,0,136,242,1,0,138,63,205,154,192,205,255,0,120,242,1,0,137,64,139,104,131,139,255,0,80,242,1,0,0,119,240,240,128,128,255,0,64,242,1,0,127,31,255,224,255,255,255,0,48,242,1,0,127,31,255,224,255,255,255,0,24,242,1,0,127,31,238,209,238,238,255,0,8,242,1,0,127,31,205,180,205,205,255,0,232,241,1,0,127,31,139,122,139,139,255,0,216,241,1,0,35,115,238,238,221,130,255,0,176,241,1,0,35,116,255,255,236,139,255,0,160,241,1,0,35,115,238,238,220,130,255,0,120,241,1,0,35,115,205,205,190,112,255,0,104,241,1,0,35,115,139,139,129,76,255,0,80,241,1,0,42,40,250,250,250,210,255,0,64,241,1,0,0,0,211,211,211,211,255,0,32,241,1,0,0,0,211,211,211,211,255,0,208,240,1,0,248,73,255,255,182,193,255,0,176,240,1,0,249,81,255,255,174,185,255,0,144,240,1,0,248,81,238,238,162,173,255,0,112,240,1,0,249,80,205,205,140,149,255,0,88,240,1,0,249,80,139,139,95,101,255,0,72,240,1,0,12,132,255,255,160,122,255,0,56,240,1,0,12,132,255,255,160,122,255,0,40,240,1,0,11,132,238,238,149,114,255,0,24,240,1,0,12,133,205,205,129,98,255,0,200,239,1,0,12,133,139,139,87,66,255,0,184,239,1,0,125,209,178,32,178,170,255,0,152,239,1,0,143,117,250,135,206,250,255,0,136,239,1,0,143,79,255,176,226,255,255,0,96,239,1,0,143,79,238,164,211,238,255,0,72,239,1,0,142,79,205,141,182,205,255,0,56,239,1,0,143,78,139,96,123,139,255,0,32,239,1,0,175,143,255,132,112,255,255,0,16,239,1,0,148,56,153,119,136,153,255,0,0,239,1,0,148,56,153,119,136,153,255,0,232,238,1,0,151,52,222,176,196,222,255,0,216,238,1,0,151,53,255,202,225,255,255,0,184,238,1,0,151,53,238,188,210,238,255,0,144,238,1,0,151,53,205,162,181,205,255,0,104,238,1,0,150,53,139,110,123,139,255,0,88,238,1,0,42,31,255,255,255,224,255,0,56,238,1,0,42,31,255,255,255,224,255,0,40,238,1,0,42,31,238,238,238,209,255,0,24,238,1,0,42,31,205,205,205,180,255,0,8,238,1,0,42,31,139,139,139,122,255,0,240,237,1,0,85,192,205,50,205,50,255,0,232,237,1,0,21,20,250,250,240,230,255,0,208,237,1,0,212,255,255,255,0,255,255,0,176,237,1,0,212,255,255,255,0,255,255,0,160,237,1,0,212,255,238,238,0,238,255,0,144,237,1,0,212,255,205,205,0,205,255,0,128,237,1,0,212,255,139,139,0,139,255,0,120,237,1,0,239,185,176,176,48,96,255,0,112,237,1,0,228,203,255,255,52,179,255,0,104,237,1,0,228,203,238,238,48,167,255,0,88,237,1,0,228,204,205,205,41,144,255,0,80,237,1,0,228,203,139,139,28,98,255,0,40,237,1,0,113,128,205,102,205,170,255,0,24,237,1,0,170,255,205,0,0,205,255,0,232,236,1,0,204,152,211,186,85,211,255,0,216,236,1,0,203,153,255,224,102,255,255,0,200,236,1,0,203,153,238,209,95,238,255,0,184,236,1,0,203,153,205,180,82,205,255,0,152,236,1,0,203,154,139,122,55,139,255,0,136,236,1,0,183,124,219,147,112,219,255,0,104,236,1,0,183,125,255,171,130,255,255,0,88,236,1,0,183,125,238,159,121,238,255,0,56,236,1,0,183,125,205,137,104,205,255,0,40,236,1,0,183,124,139,93,71,139,255,0,240,235,1,0,103,169,179,60,179,113,255,0,224,235,1,0,176,143,238,123,104,238,255,0,200,235,1,0,111,255,250,0,250,154,255,0,184,235,1,0,125,167,209,72,209,204,255,0,168,235,1,0,228,228,199,199,21,133,255,0,152,235,1,0,170,198,112,25,25,112,255,0,128,235,1,0,106,9,255,245,255,250,255,0,112,235,1,0,4,30,255,255,228,225,255,0,80,235,1,0,4,30,255,255,228,225,255,0,56,235,1,0,4,30,238,238,213,210,255,0,176,234,1,0,3,29,205,205,183,181,255,0,144,234,1,0,5,29,139,139,125,123,255,0,128,234,1,0,26,73,255,255,228,181,255,0,112,234,1,0,25,81,255,255,222,173,255,0,96,234,1,0,25,81,255,255,222,173,255,0,80,234,1,0,25,82,238,238,207,161,255,0,56,234,1,0,25,82,205,205,179,139,255,0,40,234,1,0,25,82,139,139,121,94,255,0,16,234,1,0,170,255,128,0,0,128,255,0,0,234,1,0,170,255,128,0,0,128,255,0,232,233,1,0,42,0,255,255,255,254,0,0,224,233,1,0,27,23,253,253,245,230,255,0,192,233,1,0,56,192,142,107,142,35,255,0,168,233,1,0,56,193,255,192,255,62,255,0])
.concat([144,233,1,0,56,192,238,179,238,58,255,0,128,233,1,0,56,192,205,154,205,50,255,0,8,233,1,0,56,192,139,105,139,34,255,0,248,232,1,0,27,255,255,255,165,0,255,0,208,232,1,0,27,255,255,255,165,0,255,0,160,232,1,0,27,255,238,238,154,0,255,0,120,232,1,0,27,255,205,205,133,0,255,0,112,232,1,0,27,255,139,139,90,0,255,0,96,232,1,0,11,255,255,255,69,0,255,0,64,232,1,0,11,255,255,255,69,0,255,0,48,232,1,0,11,255,238,238,64,0,255,0,32,232,1,0,11,255,205,205,55,0,255,0,8,232,1,0,11,255,139,139,37,0,255,0,0,232,1,0,214,123,218,218,112,214,255,0,232,231,1,0,214,124,255,255,131,250,255,0,224,231,1,0,214,124,238,238,122,233,255,0,208,231,1,0,214,124,205,205,105,201,255,0,200,231,1,0,213,124,139,139,71,137,255,0,176,231,1,0,38,72,238,238,232,170,255,0,160,231,1,0,85,100,251,152,251,152,255,0,144,231,1,0,85,101,255,154,255,154,255,0,128,231,1,0,85,100,238,144,238,144,255,0,96,231,1,0,85,100,205,124,205,124,255,0,80,231,1,0,85,100,139,84,139,84,255,0,48,231,1,0,127,67,238,175,238,238,255,0,32,231,1,0,127,68,255,187,255,255,255,0,16,231,1,0,127,68,238,174,238,238,255,0,216,230,1,0,127,68,205,150,205,205,255,0,200,230,1,0,127,67,139,102,139,139,255,0,184,230,1,0,241,124,219,219,112,147,255,0,168,230,1,0,241,125,255,255,130,171,255,0,152,230,1,0,241,125,238,238,121,159,255,0,128,230,1,0,241,125,205,205,104,137,255,0,104,230,1,0,241,124,139,139,71,93,255,0,72,230,1,0,26,41,255,255,239,213,255,0,56,230,1,0,20,70,255,255,218,185,255,0,40,230,1,0,20,70,255,255,218,185,255,0,8,230,1,0,19,69,238,238,203,173,255,0,248,229,1,0,19,69,205,205,175,149,255,0,232,229,1,0,20,69,139,139,119,101,255,0,224,229,1,0,20,176,205,205,133,63,255,0,216,229,1,0,247,63,255,255,192,203,255,0,200,229,1,0,245,73,255,255,181,197,255,0,192,229,1,0,245,73,238,238,169,184,255,0,168,229,1,0,245,74,205,205,145,158,255,0,160,229,1,0,245,73,139,139,99,108,255,0,144,229,1,0,212,70,221,221,160,221,255,0,136,229,1,0,212,68,255,255,187,255,255,0,128,229,1,0,212,68,238,238,174,238,255,0,120,229,1,0,212,68,205,205,150,205,255,0,112,229,1,0,212,67,139,139,102,139,255,0,96,229,1,0,132,59,230,176,224,230,255,0,80,229,1,0,196,221,240,160,32,240,255,0,72,229,1,0,191,207,255,155,48,255,255,0,48,229,1,0,192,207,238,145,44,238,255,0,24,229,1,0,192,207,205,125,38,205,255,0,16,229,1,0,192,207,139,85,26,139,255,0,8,229,1,0,0,255,255,255,0,0,255,0,0,229,1,0,0,255,255,255,0,0,255,0,248,228,1,0,0,255,238,238,0,0,255,0,240,228,1,0,0,255,205,205,0,0,255,0,232,228,1,0,0,255,139,139,0,0,255,0,208,228,1,0,0,61,188,188,143,143,255,0,192,228,1,0,0,62,255,255,193,193,255,0,160,228,1,0,0,62,238,238,180,180,255,0,136,228,1,0,0,62,205,205,155,155,255,0,112,228,1,0,0,62,139,139,105,105,255,0,96,228,1,0,159,181,225,65,105,225,255,0,80,228,1,0,159,183,255,72,118,255,255,0,64,228,1,0,159,183,238,67,110,238,255,0,48,228,1,0,159,182,205,58,95,205,255,0,24,228,1,0,159,183,139,39,64,139,255,0,248,227,1,0,17,220,139,139,69,19,255,0,240,227,1,0,4,138,250,250,128,114,255,0,216,227,1,0,9,150,255,255,140,105,255,0,208,227,1,0,9,150,238,238,130,98,255,0,200,227,1,0,9,150,205,205,112,84,255,0,192,227,1,0,9,150,139,139,76,57,255,0,176,227,1,0,19,154,244,244,164,96,255,0,160,227,1,0,103,170,139,46,139,87,255,0,144,227,1,0,103,171,255,84,255,159,255,0,128,227,1,0,103,171,238,78,238,148,255,0,104,227,1,0,103,171,205,67,205,128,255,0,88,227,1,0,103,170,139,46,139,87,255,0,56,227,1,0,17,16,255,255,245,238,255,0,40,227,1,0,17,16,255,255,245,238,255,0,152,226,1,0,18,17,238,238,229,222,255,0,128,226,1,0,18,17,205,205,197,191,255,0,112,226,1,0,18,16,139,139,134,130,255,0,104,226,1,0,13,183,160,160,82,45,255,0,96,226,1,0,13,184,255,255,130,71,255,0,88,226,1,0,13,184,238,238,121,66,255,0,72,226,1,0,13,184,205,205,104,57,255,0,64,226,1,0,13,185,139,139,71,38,255,0,40,226,1,0,139,108,235,135,206,235,255,0,24,226,1,0,144,120,255,135,206,255,255,0,248,225,1,0,144,120,238,126,192,238,255,0,232,225,1,0,144,120,205,108,166,205,255,0,192,225,1,0,145,119,139,74,112,139,255,0,168,225,1,0,175,143,205,106,90,205,255,0,128,225,1,0,175,144,255,131,111,255,255,0,112,225,1,0,175,144,238,122,103,238,255,0,88,225,1,0,175,144,205,105,89,205,255,0,64,225,1,0,175,144,139,71,60,139,255,0,32,225,1,0,148,56,144,112,128,144,255,0,16,225,1,0,149,56,255,198,226,255,255,0,192,224,1,0,149,56,238,185,211,238,255,0,176,224,1,0,148,57,205,159,182,205,255,0,160,224,1,0,149,56,139,108,123,139,255,0,136,224,1,0,148,56,144,112,128,144,255,0,128,224,1,0,0,5,255,255,250,250,255,0,120,224,1,0,0,5,255,255,250,250,255,0,104,224,1,0,0,5,238,238,233,233,255,0,96,224,1,0,0,4,205,205,201,201,255,0,72,224,1,0,0,3,139,139,137,137,255,0,56,224,1,0,106,255,255,0,255,127,255,0,40,224,1,0,106,255,255,0,255,127,255,0,24,224,1,0,106,255,238,0,238,118,255,0,248,223,1,0,106,255,205,0,205,102,255,0,232,223,1,0,106,255,139,0,139,69,255,0,216,223,1,0,146,155,180,70,130,180,255,0,200,223,1,0,146,156,255,99,184,255,255,0,176,223,1,0,146,156,238,92,172,238,255,0,152,223,1,0,146,156,205,79,148,205,255,0,120,223,1,0,147,155,139,54,100,139,255,0,112,223,1,0,24,84,210,210,180,140,255,0,104,223,1,0,20,176,255,255,165,79,255,0,96,223,1,0,20,176,238,238,154,73,255,0,80,223,1,0,20,176,205,205,133,63,255,0,72,223,1,0,20,176,139,139,90,43,255,0,64,223,1,0,212,29,216,216,191,216,255,0,48,223,1,0,212,30,255,255,225,255,255,0,24,223,1,0,212,30,238,238,210,238,255,0,8,223,1,0,212,29,205,205,181,205,255,0,208,222,1,0,212,29,139,139,123,139,255,0,200,222,1,0,6,184,255,255,99,71,255,0,192,222,1,0,6,184,255,255,99,71,255,0,168,222,1,0,6,184,238,238,92,66,255,0,160,222,1,0,6,184,205,205,79,57,255,0,152,222,1,0,6,185,139,139,54,38,255,0,128,222,1,0,42,0,255,255,255,254,0,0,112,222,1,0,123,182,224,64,224,208,255,0,88,222,1,0,129,255,255,0,245,255,255,0,72,222,1,0,129,255,238,0,229,238,255,0,40,222,1,0,129,255,205,0,197,205,255,0,24,222,1,0,129,255,139,0,134,139,255,0,0,222,1,0,212,115,238,238,130,238,255,0,232,221,1,0,227,215,208,208,32,144,255,0,216,221,1,0,235,193,255,255,62,150,255,0,200,221,1,0,235,192,238,238,58,140,255,0,184,221,1,0,235,192,205,205,50,120,255,0,168,221,1,0,235,192,139,139,34,82,255,0,152,221,1,0,27,68,245,245,222,179,255,0,144,221,1,0,27,69,255,255,231,186,255,0,120,221,1,0,27,68,238,238,216,174,255,0,112,221,1,0,27,68,205,205,186,150,255,0,88,221,1,0,27,67,139,139,126,102,255,0,80,221,1,0,0,0,255,255,255,255,255,0,64,221,1,0,0,0,245,245,245,245,255,0,56,221,1,0,42,255,255,255,255,0,255,0,48,221,1,0,42,255,255,255,255,0,255,0,40,221,1,0,42,255,238,238,238,0,255,0,24,221,1,0,42,255,205,205,205,0,255,0,16,221,1,0,42,255,139,139,139,0,255,0,240,220,1,0,56,192,205,154,205,50,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,219,1,0,30,0,0,0,16,188,1,0,252,1,0,0,96,186,1,0,56,1,0,0,32,184,1,0,126,1,0,0,64,182,1,0,104,0,0,0,8,180,1,0,150,0,0,0,16,205,1,0,146,2,0,0,88,178,1,0,206,1,0,0,208,176,1,0,8,1,0,0,120,175,1,0,160,2,0,0,200,173,1,0,202,1,0,0,40,172,1,0,76,0,0,0,248,170,1,0,150,2,0,0,152,169,1,0,4,2,0,0,184,166,1,0,246,0,0,0,56,165,1,0,6,0,0,0,72,163,1,0,6,0,0,0,240,161,1,0,216,0,0,0,112,160,1,0,90,1,0,0,8,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,219,1,0,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,2,0,0,30,1,0,0,20,0,0,0,24,2,0,0,240,0,0,0,170,1,0,0,110,0,0,0,134,2,0,0,100,2,0,0,36,1,0,0,152,2,0,0,20,1,0,0,106,2,0,0,64,1,0,0,198,0,0,0,102,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,140,2,0,216,139,2,0,208,139,2,0,200,139,2,0,232,139,2,0,240,139,2,0,160,139,2,0,144,139,2,0,100,0,0,0,116,0,0,0,92,0,0,0,146,0,0,0,158,2,0,0,98,2,0,0,204,1,0,0,78,0,0,0,2,2,0,0,28,1,0,0,46,0,0,0,146,1,0,0,210,0,0,0,108,0,0,0,96,0,0,0,214,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,244,108,86,125,174,182,214,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,196,66,173,105,222,113,236,63,16,122,54,171,62,87,229,63,245,219,215,129,115,70,204,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,136,133,90,211,188,227,216,63,1,77,132,13,79,175,226,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,1,77,132,13,79,175,226,63,1,77,132,13,79,175,226,63,1,77,132,13,79,175,226,63,181,21,251,203,238,201,225,63,204,93,75,200,7,61,240,63,16,122,54,171,62,87,229,63,16,122,54,171,62,87,229,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,120,11,36,40,126,140,227,63,106,222,113,138,142,228,232,63,210,111,95,7,206,25,231,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,16,122,54,171,62,87,229,63,181,21,251,203,238,201,225,63,44,212,154,230,29,167,234,63,210,111,95,7,206,25,231,63,106,222,113,138,142,228,232,63,16,122,54,171,62,87,229,63,106,222,113,138,142,228,232,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,120,11,36,40,126,140,227,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,134,56,214,197,109,52,238,63,16,122,54,171,62,87,229,63,16,122,54,171,62,87,229,63,120,11,36,40,126,140,227,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,166,10,70,37,117,2,222,63,181,21,251,203,238,201,225,63,72,191,125,29,56,103,204,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,224,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,72,191,125,29,56,103,204,63,72,191,125,29,56,103,204,63,0,0,0,0,0,0,224,63,72,191,125,29,56,103,204,63,44,212,154,230,29,167,234,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,224,63,210,111,95,7,206,25,231,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,2,154,8,27,158,94,213,63,224,190,14,156,51,162,208,63,2,154,8,27,158,94,213,63,1,77,132,13,79,175,226,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,62,232,217,172,250,92,197,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,29,56,103,68,105,111,200,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,231,29,167,232,72,46,225,63,162,180,55,248,194,100,214,63,72,191,125,29,56,103,204,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,211,188,227,20,29,201,209,63,120,11,36,40,126,140,227,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,240,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,240,63,211,188,227,20,29,201,209,63,234,149,178,12,113,172,215,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,106,222,113,138,142,228,232,63,0,0,0,0,0,0,240,63,152,221,147,135,133,90,215,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,196,66,173,105,222,113,236,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,72,191,125,29,56,103,204,63,120,11,36,40,126,140,227,63,134,56,214,197,109,52,238,63,120,11,36,40,126,140,227,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,3,0,0,0,104,62,0,0,3,0,0,0,64,62,0,0,3,0,0,0,176,61,0,0,3,0,0,0,96,61,0,0,3,0,0,0,56,61,0,0,3,0,0,0,16,61,0,0,3,0,0,0,232,60,0,0,0,0,0,0,200,55,0,0,0,0,0,0,160,55,0,0,0,0,0,0,120,55,0,0,0,0,0,0,80,55,0,0,0,0,0,0,40,55,0,0,0,0,0,0,0,55,0,0,0,0,0,0,216,54,0,0,4,0,0,0,72,56,0,0,0,0,0,0,0,0,0,0,1,0,0,0,72,60,0,0,0,0,0,0,0,0,0,0,144,191,1,0,24,191,1,0,224,188,1,0,32,187,1,0,8,185,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,20,14,2,2,2,2,2,2,2,2,2,2,2,2,2,19,18,2,17,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,15,2,16,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,12,2,13,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,3,4,5,6,7,8,9,10,11,0,0,0,0,0,13,65,57,55,251,1,9,2,3,4,85,16,87,19,66,20,68,40,21,22,17,10,11,23,24,229,10,11,23,24,7,8,57,88,89,18,59,42,10,11,19,39,20,64,44,21,22,67,10,11,23,24,230,10,11,46,76,210,207,49,52,62,53,70,69,78,59,203,71,80,81,200,86,82,73,74,0,75,0,0,45,0,0,0,0,0,0,0,0,2,0,6,1,0,1,0,1,2,1,2,1,1,1,3,0,0,1,3,2,0,1,3,1,1,1,0,1,2,1,2,1,1,1,1,1,2,1,2,1,0,2,4,0,3,0,0,5,0,0,5,2,0,4,2,0,4,4,0,5,0,4,1,2,1,1,1,3,0,0,0,0,21,23,22,22,22,24,24,25,25,25,25,26,26,26,27,27,28,28,29,30,30,31,32,33,33,34,34,35,35,36,36,36,37,37,37,37,38,38,39,40,41,41,41,43,42,45,46,44,47,48,44,49,50,49,49,51,49,52,53,52,54,52,52,55,56,56,57,57,0,0,0,188,188,188,188,188,188,1,188,14,188,189,216,188,218,188,52,188,188,13,188,188,188,188,188,188,188,188,188,206,188,188,15,188,188,188,250,188,0,0,0,4,188,188,188,27,6,44,188,188,188,188,188,188,188,247,8,25,12,188,188,188,188,188,29,188,22,188,31,39,188,37,188,49,40,188,188,50,48,45,188,188,12,44,188,188,188,188,188,53,44,188,53,12,44,12,51,47,188,54,45,22,188,17,188,46,188,56,188,57,188,188,188,44,188,59,63,188,188,44,188,188,188,188,53,53,188,188,188,188,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,187,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,5,15,12,6,25,56,72,43,60,61,26,58,27,28,29,30,31,32,33,50,34,47,35,48,77,51,79,63,83,84,36,54,41,37,38,14,0,0,0,0,4,8,10,0,0,7,9,11,1,65,67,2,6,66,0,0,0,68,32,12,13,14,0,61,0,38,0,0,28,30,35,44,41,33,34,36,63,40,59,64,0,16,37,3,29,31,21,0,0,39,0,0,0,0,0,0,24,17,25,22,45,0,47,42,50,0,23,0,62,19,18,16,20,52,55,40,21,0,21,58,60,15,0,0,48,43,51,54,57,0,0,0,0,0,0,6,51,42,41,0,1,0,3,4,5,77,20,79,1,52,3,54,23,6,7,12,9,10,11,12,13,9,10,11,12,3,4,72,83,84,10,42,15,9,10,1,12,3,49,13,6,7,53,9,10,11,12,13,9,10,18,62,8,8,19,12,8,17,16,13,19,72,8,14,13,13,8,78,72,60,62,255,62,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,72,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,4,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,176,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,244,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,176,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,120,109,108,110,115,47,0,0,0,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,88,77,76,47,49,57,57,56,47,110,97,109,101,115,112,97,99,101,0,0,0,0,47,98,114,98,103,51,47,50,0,0,0,0,0,0,0,0,47,114,100,98,117,52,47,50,0,0,0,0,0,0,0,0,47,114,100,98,117,52,47,49,0,0,0,0,0,0,0,0,47,114,100,98,117,51,47,51,0,0,0,0,0,0,0,0,47,114,100,98,117,51,47,50,0,0,0,0,0,0,0,0,32,32,32,60,83,67,82,73,80,84,32,76,65,78,71,85,65,71,69,61,39,74,97,118,97,115,99,114,105,112,116,39,62,10,0,0,0,0,0,0,47,114,100,98,117,51,47,49,0,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,57,0,0,0,0,0,0,0,47,101,110,100,112,97,103,101,32,123,32,115,104,111,119,112,97,103,101,32,125,32,98,105,110,100,32,100,101,102,0,0,109,105,110,116,99,114,101,97,109,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,56,0,0,0,0,0,0,0,116,97,105,108,99,108,105,112,0,0,0,0,0,0,0,0,97,99,117,116,101,0,0,0,47,114,100,98,117,49,49,47,55,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,54,0,0,0,0,0,0,0,111,114,100,101,114,105,110,103,32,39,37,115,39,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,10,0,0,0,0,47,114,100,98,117,49,49,47,53,0,0,0,0,0,0,0,108,97,98,101,108,116,111,111,108,116,105,112,0,0,0,0,47,98,114,98,103,51,47,49,0,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,52,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,51,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,50,0,0,0,0,0,0,0,47,114,100,98,117,49,49,47,49,49,0,0,0,0,0,0,60,33,45,45,32,80,97,103,101,115,58,32,37,100,32,45,45,62,10,0,0,0,0,0,47,114,100,98,117,49,49,47,49,48,0,0,0,0,0,0,112,111,108,121,32,37,115,0,47,114,100,98,117,49,49,47,49,0,0,0,0,0,0,0,9,115,101,116,109,97,116,114,105,120,0,0,0,0,0,0,109,105,100,110,105,103,104,116,98,108,117,101,0,0,0,0,47,114,100,98,117,49,48,47,57,0,0,0,0,0,0,0,99,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,98,103,99,111,108,111,114,0,97,99,105,114,99,0,0,0,47,114,100,98,117,49,48,47,56,0,0,0,0,0,0,0,47,97,99,99,101,110,116,53,47,49,0,0,0,0,0,0,47,114,100,98,117,49,48,47,55,0,0,0,0,0,0,0,47,114,100,98,117,49,48,47,54,0,0,0,0,0,0,0,101,100,103,101,116,111,111,108,116,105,112,0,0,0,0,0,47,98,114,98,103,49,49,47,57,0,0,0,0,0,0,0,47,114,100,98,117,49,48,47,53,0,0,0,0,0,0,0,47,114,100,98,117,49,48,47,52,0,0,0,0,0,0,0,47,114,100,98,117,49,48,47,51,0,0,0,0,0,0,0,47,114,100,98,117,49,48,47,50,0,0,0,0,0,0,0,60,47,84,73,84,76,69,62,0,0,0,0,0,0,0,0,47,114,100,98,117,49,48,47,49,48,0,0,0,0,0,0,47,114,100,98,117,49,48,47,49,0,0,0,0,0,0,0,9,48,32,48,32,49,32,48,32,51,54,48,32,97,114,99,0,0,0,0,0,0,0,0,109,101,100,105,117,109,118,105,111,108,101,116,114,101,100,0,47,112,117,114,112,108,101,115,57,47,57,0,0,0,0,0,97,114,114,111,119,115,105,122,101,0,0,0,0,0,0,0,97,97,99,117,116,101,0,0,47,112,117,114,112,108,101,115,57,47,56,0,0,0,0,0,117,115,105,110,103,32,37,115,32,102,111,114,32,117,110,107,110,111,119,110,32,115,104,97,112,101,32,37,115,10,0,0,47,112,117,114,112,108,101,115,57,47,55,0,0,0,0,0,37,100,32,98,111,120,101,115,58,10,0,0,0,0,0,0,47,112,117,114,112,108,101,115,57,47,54,0,0,0,0,0,116,111,111,108,116,105,112,0,47,98,114,98,103,49,49,47,56,0,0,0,0,0,0,0,47,112,117,114,112,108,101,115,57,47,53,0,0,0,0,0,47,112,117,114,112,108,101,115,57,47,52,0,0,0,0,0,47,112,117,114,112,108,101,115,57,47,51,0,0,0,0,0,47,112,117,114,112,108,101,115,57,47,50,0,0,0,0,0,60,84,73,84,76,69,62,0,47,112,117,114,112,108,101,115,57,47,49,0,0,0,0,0,47,112,117,114,112,108,101,115,56,47,56,0,0,0,0,0,9,114,120,32,114,121,32,115,99,97,108,101,0,0,0,0,109,101,100,105,117,109,116,117,114,113,117,111,105,115,101,0,47,112,117,114,112,108,101,115,56,47,55,0,0,0,0,0,100,101,108,121,32,62,61,32,48,0,0,0,0,0,0,0,100,101,99,111,114,97,116,101,0,0,0,0,0,0,0,0,106,112,103,58,102,105,103,0,90,101,116,97,0,0,0,0,47,112,117,114,112,108,101,115,56,47,54,0,0,0,0,0,47,112,117,114,112,108,101,115,56,47,53,0,0,0,0,0,47,112,117,114,112,108,101,115,56,47,52,0,0,0,0,0,104,101,97,100,116,97,114,103,101,116,0,0,0,0,0,0,47,98,114,98,103,49,49,47,55,0,0,0,0,0,0,0,47,112,117,114,112,108,101,115,56,47,51,0,0,0,0,0,47,112,117,114,112,108,101,115,56,47,50,0,0,0,0,0,47,112,117,114,112,108,101,115,56,47,49,0,0,0,0,0,47,112,117,114,112,108,101,115,55,47,55,0,0,0,0,0,60,77,69,84,65,32,104,116,116,112,45,101,113,117,105,118,61,34,67,111,110,116,101,110,116,45,84,121,112,101,34,32,99,111,110,116,101,110,116,61,34,116,101,120,116,47,104,116,109,108,59,32,99,104,97,114,115,101,116,61,85,84,70,45,56,34,62,10,0,0,0,0,47,112,117,114,112,108,101,115,55,47,54,0,0,0,0,0,47,112,117,114,112,108,101,115,55,47,53,0,0,0,0,0,84,68,0,0,0,0,0,0,9,120,32,121,32,116,114,97,110,115,108,97,116,101,0,0,109,101,100,105,117,109,115,112,114,105,110,103,103,114,101,101,110,0,0,0,0,0,0,0,47,112,117,114,112,108,101,115,55,47,52,0,0,0,0,0,97,103,115,116,114,102,114,101,101,32,108,111,115,116,32,37,115,10,0,0,0,0,0,0,109,105,110,108,101,110,0,0,89,117,109,108,0,0,0,0,47,112,117,114,112,108,101,115,55,47,51,0,0,0,0,0,47,112,117,114,112,108,101,115,55,47,50,0,0,0,0,0,47,112,117,114,112,108,101,115,55,47,49,0,0,0,0,0,116,97,105,108,116,97,114,103,101,116,0,0,0,0,0,0,47,98,114,98,103,49,49,47,54,0,0,0,0,0,0,0,47,112,117,114,112,108,101,115,54,47,54,0,0,0,0,0,118,109,108,58,118,109,108,0,47,112,117,114,112,108,101,115,54,47,53,0,0,0,0,0,47,112,117,114,112,108,101,115,54,47,52,0,0,0,0,0,121,101,108,108,111,119,0,0,112,108,117,115,0,0,0,0,47,112,117,114,112,108,101,115,54,47,51,0,0,0,0,0,60,72,69,65,68,62,0,0,47,112,117,114,112,108,101,115,54,47,50,0,0,0,0,0,47,112,117,114,112,108,101,115,54,47,49,0,0,0,0,0,9,110,101,119,112,97,116,104,0,0,0,0,0,0,0,0,109,101,100,105,117,109,115,108,97,116,101,98,108,117,101,0,47,112,117,114,112,108,101,115,53,47,53,0,0,0,0,0,108,97,98,101,108,97,110,103,108,101,0,0,0,0,0,0,89,97,99,117,116,101,0,0,47,112,117,114,112,108,101,115,53,47,52,0,0,0,0,0,47,112,117,114,112,108,101,115,53,47,51,0,0,0,0,0,58,32,0,0,0,0,0,0,47,112,117,114,112,108,101,115,53,47,50,0,0,0,0,0,108,97,98,101,108,116,97,114,103,101,116,0,0,0,0,0,47,112,117,114,112,108,101,115,53,47,49,0,0,0,0,0,47,98,114,98,103,49,49,47,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,112,117,114,112,108,101,115,52,47,52,0,0,0,0,0,47,112,117,114,112,108,101,115,52,47,51,0,0,0,0,0,47,112,117,114,112,108,101,115,52,47,50,0,0,0,0,0,60,47,66,79,68,89,62,10,60,47,72,84,77,76,62,10,0,0,0,0,0,0,0,0,85,82,87,32,71,111,116,104,105,99,32,76,0,0,0,0,47,112,117,114,112,108,101,115,52,47,49,0,0,0,0,0,47,112,117,114,112,108,101,115,51,47,51,0,0,0,0,0,100,117,112,108,105,99,97,116,101,32,97,116,116,114,105,98,117,116,101,0,0,0,0,0,9,109,97,116,114,105,120,32,99,117,114,114,101,110,116,109,97,116,114,105,120,0,0,0,109,101,100,105,117,109,115,101,97,103,114,101,101,110,0,0,47,112,117,114,112,108,101,115,51,47,50,0,0,0,0,0,108,97,98,101,108,100,105,115,116,97,110,99,101,0,0,0,88,105,0,0,0,0,0,0,47,112,117,114,112,108,101,115,51,47,49,0,0,0,0,0,38,103,116,59,0,0,0,0,47,112,117,114,100,57,47,57,0,0,0,0,0,0,0,0,112,108,97,105,110,45,101,120,116,58,100,111,116,0,0,0,47,112,117,114,100,57,47,56,0,0,0,0,0,0,0,0,101,100,103,101,116,97,114,103,101,116,0,0,0,0,0,0,37,115,32,45,62,32,37,115,58,32,104,101,97,100,32,105,115,32,105,110,115,105,100,101,32,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,10,0,0,0,0,0,0,0,47,112,117,114,100,57,47,55,0,0,0,0,0,0,0,0,110,111,32,109,101,109,111,114,121,32,102,114,111,109,32,122,109,97,108,108,111,99,40,41,10,0,0,0,0,0,0,0,47,98,114,98,103,49,49,47,52,0,0,0,0,0,0,0,109,101,109,111,114,121,32,97,108,108,111,99,97,116,105,111,110,32,102,97,105,108,117,114,101,10,0,0,0,0,0,0,47,112,117,114,100,57,47,54,0,0,0,0,0,0,0,0,32,123,10,0,0,0,0,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,112,110])
.concat([108,115,0,0,0,0,0,0,47,112,117,114,100,57,47,53,0,0,0,0,0,0,0,0,112,111,115,0,0,0,0,0,47,112,117,114,100,57,47,52,0,0,0,0,0,0,0,0,60,33,45,45,32,105,110,115,101,114,116,32,97,110,121,32,111,116,104,101,114,32,78,79,78,45,73,69,32,104,116,109,108,32,99,111,110,116,101,110,116,32,104,101,114,101,32,45,45,62,10,0,0,0,0,0,95,76,84,88,95,108,105,98,114,97,114,121,0,0,0,0,84,82,65,73,76,69,82,0,47,112,117,114,100,57,47,51,0,0,0,0,0,0,0,0,47,112,117,114,100,57,47,50,0,0,0,0,0,0,0,0,9,47,120,32,101,120,99,104,32,100,101,102,0,0,0,0,109,101,100,105,117,109,112,117,114,112,108,101,0,0,0,0,47,112,117,114,100,57,47,49,0,0,0,0,0,0,0,0,108,97,98,101,108,102,111,110,116,99,111,108,111,114,0,0,98,108,97,99,107,0,0,0,85,117,109,108,0,0,0,0,47,112,117,114,100,56,47,56,0,0,0,0,0,0,0,0,47,112,117,114,100,56,47,55,0,0,0,0,0,0,0,0,47,112,117,114,100,56,47,54,0,0,0,0,0,0,0,0,116,97,114,103,101,116,0,0,47,112,117,114,100,56,47,53,0,0,0,0,0,0,0,0,47,98,114,98,103,49,49,47,51,0,0,0,0,0,0,0,47,112,117,114,100,56,47,52,0,0,0,0,0,0,0,0,47,112,117,114,100,56,47,51,0,0,0,0,0,0,0,0,47,112,117,114,100,56,47,50,0,0,0,0,0,0,0,0,60,68,73,86,32,105,100,61,39,95,110,111,116,86,77,76,50,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,34,62,10,0,0,0,0,0,0,0,0,47,112,117,114,100,56,47,49,0,0,0,0,0,0,0,0,115,111,117,114,99,101,0,0,47,112,117,114,100,55,47,55,0,0,0,0,0,0,0,0,9,47,121,32,101,120,99,104,32,100,101,102,0,0,0,0,109,101,100,105,117,109,111,114,99,104,105,100,0,0,0,0,105,110,0,0,0,0,0,0,47,112,117,114,100,55,47,54,0,0,0,0,0,0,0,0,108,97,98,101,108,102,111,110,116,110,97,109,101,0,0,0,104,112,0,0,0,0,0,0,110,111,0,0,0,0,0,0,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,52,53,32,47,104,121,112,104,101,110,32,112,117,116,0,0,0,85,112,115,105,108,111,110,0,47,112,117,114,100,55,47,53,0,0,0,0,0,0,0,0,47,112,117,114,100,55,47,52,0,0,0,0,0,0,0,0,102,105,108,108,101,100,0,0,47,112,117,114,100,55,47,51,0,0,0,0,0,0,0,0,104,101,97,100,85,82,76,0,47,112,117,114,100,55,47,50,0,0,0,0,0,0,0,0,47,98,114,98,103,49,49,47,50,0,0,0,0,0,0,0,47,112,117,114,100,55,47,49,0,0,0,0,0,0,0,0,47,112,117,114,100,54,47,54,0,0,0,0,0,0,0,0,47,112,117,114,100,54,47,53,0,0,0,0,0,0,0,0,60,72,50,62,83,111,114,114,121,44,32,116,104,105,115,32,100,105,97,103,114,97,109,32,119,105,108,108,32,111,110,108,121,32,100,105,115,112,108,97,121,32,99,111,114,114,101,99,116,108,121,32,111,110,32,73,110,116,101,114,110,101,116,32,69,120,112,108,111,114,101,114,32,53,32,40,97,110,100,32,117,112,41,32,98,114,111,119,115,101,114,115,46,60,47,72,50,62,10,0,0,0,0,0,47,112,117,114,100,54,47,52,0,0,0,0,0,0,0,0,47,112,117,114,100,54,47,51,0,0,0,0,0,0,0,0,9,47,114,120,32,101,120,99,104,32,100,101,102,0,0,0,109,101,100,105,117,109,98,108,117,101,0,0,0,0,0,0,47,112,117,114,100,54,47,50,0,0,0,0,0,0,0,0,108,97,98,101,108,102,111,110,116,115,105,122,101,0,0,0,85,103,114,97,118,101,0,0,47,112,117,114,100,54,47,49,0,0,0,0,0,0,0,0,47,112,117,114,100,53,47,53,0,0,0,0,0,0,0,0,47,112,117,114,100,53,47,52,0,0,0,0,0,0,0,0,104,101,97,100,104,114,101,102,0,0,0,0,0,0,0,0,112,101,110,0,0,0,0,0,47,112,117,114,100,53,47,51,0,0,0,0,0,0,0,0,47,98,114,98,103,49,49,47,49,49,0,0,0,0,0,0,47,112,117,114,100,53,47,50,0,0,0,0,0,0,0,0,47,112,117,114,100,53,47,49,0,0,0,0,0,0,0,0,47,112,117,114,100,52,47,52,0,0,0,0,0,0,0,0,60,33,45,45,32,116,104,105,115,32,115,104,111,117,108,100,32,111,110,108,121,32,100,105,115,112,108,97,121,32,111,110,32,78,79,78,45,73,69,32,98,114,111,119,115,101,114,115,32,45,45,62,10,0,0,0,47,112,117,114,100,52,47,51,0,0,0,0,0,0,0,0,47,112,117,114,100,52,47,50,0,0,0,0,0,0,0,0,9,47,114,121,32,101,120,99,104,32,100,101,102,0,0,0,109,101,100,105,117,109,97,113,117,97,109,97,114,105,110,101,0,0,0,0,0,0,0,0,47,112,117,114,100,52,47,49,0,0,0,0,0,0,0,0,116,97,105,108,108,97,98,101,108,0,0,0,0,0,0,0,85,99,105,114,99,0,0,0,47,112,117,114,100,51,47,51,0,0,0,0,0,0,0,0,47,112,117,114,100,51,47,50,0,0,0,0,0,0,0,0,47,112,117,114,100,51,47,49,0,0,0,0,0,0,0,0,116,97,105,108,85,82,76,0,111,114,100,101,114,105,110,103,32,39,37,115,39,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,46,10,0,0,47,112,117,111,114,57,47,57,0,0,0,0,0,0,0,0,47,98,114,98,103,49,49,47,49,48,0,0,0,0,0,0,47,112,117,111,114,57,47,56,0,0,0,0,0,0,0,0,47,112,117,111,114,57,47,55,0,0,0,0,0,0,0,0,47,112,117,111,114,57,47,54,0,0,0,0,0,0,0,0,60,68,73,86,32,105,100,61,39,95,110,111,116,86,77,76,49,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,34,62,10,0,0,0,0,0,0,0,0,47,112,117,111,114,57,47,53,0,0,0,0,0,0,0,0,47,112,117,111,114,57,47,52,0,0,0,0,0,0,0,0,99,105,114,99,108,101,32,37,115,32,37,100,44,37,100,44,37,100,10,0,0,0,0,0,109,101,109,111,114,121,32,101,120,104,97,117,115,116,101,100,0,0,0,0,0,0,0,0,47,101,108,108,105,112,115,101,95,112,97,116,104,32,123,0,109,97,114,111,111,110,0,0,47,112,117,111,114,57,47,51,0,0,0,0,0,0,0,0,104,101,97,100,108,97,98,101,108,0,0,0,0,0,0,0,85,97,99,117,116,101,0,0,47,112,117,111,114,57,47,50,0,0,0,0,0,0,0,0,47,97,99,99,101,110,116,52,47,52,0,0,0,0,0,0,47,112,117,111,114,57,47,49,0,0,0,0,0,0,0,0,47,112,117,111,114,56,47,56,0,0,0,0,0,0,0,0,116,97,105,108,104,114,101,102,0,0,0,0,0,0,0,0,47,112,117,111,114,56,47,55,0,0,0,0,0,0,0,0,47,98,114,98,103,49,49,47,49,0,0,0,0,0,0,0,47,112,117,111,114,56,47,54,0,0,0,0,0,0,0,0,47,112,117,111,114,56,47,53,0,0,0,0,0,0,0,0,47,112,117,111,114,56,47,52,0,0,0,0,0,0,0,0,60,33,45,45,32,105,110,115,101,114,116,32,97,110,121,32,111,116,104,101,114,32,104,116,109,108,32,99,111,110,116,101,110,116,32,104,101,114,101,32,45,45,62,10,0,0,0,0,47,112,117,111,114,56,47,51,0,0,0,0,0,0,0,0,47,112,117,111,114,56,47,50,0,0,0,0,0,0,0,0,9,9,99,108,111,115,101,112,97,116,104,0,0,0,0,0,109,97,103,101,110,116,97,0,47,112,117,111,114,56,47,49,0,0,0,0,0,0,0,0,97,114,114,111,119,116,97,105,108,0,0,0,0,0,0,0,84,104,101,116,97,0,0,0,47,112,117,111,114,55,47,55,0,0,0,0,0,0,0,0,119,0,0,0,0,0,0,0,47,112,117,111,114,55,47,54,0,0,0,0,0,0,0,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,101,110,100,32,112,111,114,116,32,110,111,116,32,105,110,32,108,97,115,116,32,98,111,120,10,0,47,112,117,111,114,55,47,53,0,0,0,0,0,0,0,0,108,97,98,101,108,85,82,76,0,0,0,0,0,0,0,0,47,112,117,111,114,55,47,52,0,0,0,0,0,0,0,0,47,98,114,98,103,49,48,47,57,0,0,0,0,0,0,0,47,112,117,111,114,55,47,51,0,0,0,0,0,0,0,0,47,112,117,111,114,55,47,50,0,0,0,0,0,0,0,0,47,112,117,111,114,55,47,49,0,0,0,0,0,0,0,0,60,68,73,86,32,105,100,61,39,95,86,77,76,50,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,118,105,115,105,98,105,108,105,116,121,58,104,105,100,100,101,110,34,62,10,0,0,47,112,117,111,114,54,47,54,0,0,0,0,0,0,0,0,47,112,117,111,114,54,47,53,0,0,0,0,0,0,0,0,9,9,112,111,112,32,110,101,103,32,48,32,114,108,105,110,101,116,111,0,0,0,0,0,108,105,110,101,110,0,0,0,47,112,117,111,114,54,47,52,0,0,0,0,0,0,0,0,100,101,108,120,32,62,61,32,48,0,0,0,0,0,0,0,97,114,114,111,119,104,101,97,100,0,0,0,0,0,0,0,106,112,101,58,102,105,103,0,47,112,117,111,114,54,47,51,0,0,0,0,0,0,0,0,84,97,117,0,0,0,0,0,47,112,117,111,114,54,47,50,0,0,0,0,0,0,0,0,47,112,117,111,114,54,47,49,0,0,0,0,0,0,0,0,108,97,98,101,108,104,114,101,102,0,0,0,0,0,0,0,47,112,117,111,114,53,47,53,0,0,0,0,0,0,0,0,47,98,114,98,103,49,48,47,56,0,0,0,0,0,0,0,47,112,117,111,114,53,47,52,0,0,0,0,0,0,0,0,47,112,117,111,114,53,47,51,0,0,0,0,0,0,0,0,47,112,117,111,114,53,47,50,0,0,0,0,0,0,0,0,60,47,68,73,86,62,10,0,69,68,95,116,111,95,118,105,114,116,40,101,41,32,61,61,32,78,85,76,76,0,0,0,47,112,117,111,114,53,47,49,0,0,0,0,0,0,0,0,47,112,117,111,114,52,47,52,0,0,0,0,0,0,0,0,84,72,0,0,0,0,0,0,9,9,48,32,101,120,99,104,32,114,108,105,110,101,116,111,0,0,0,0,0,0,0,0,108,105,109,101,103,114,101,101,110,0,0,0,0,0,0,0,47,112,117,111,114,52,47,51,0,0,0,0,0,0,0,0,100,105,114,0,0,0,0,0,47,112,117,111,114,52,47,50,0,0,0,0,0,0,0,0,84,72,79,82,78,0,0,0,47,112,117,111,114,52,47,49,0,0,0,0,0,0,0,0,47,112,117,111,114,51,47,51,0,0,0,0,0,0,0,0,101,100,103,101,85,82,76,0,47,112,117,111,114,51,47,50,0,0,0,0,0,0,0,0,47,98,114,98,103,49,48,47,55,0,0,0,0,0,0,0,118,109,108,0,0,0,0,0,47,112,117,111,114,51,47,49,0,0,0,0,0,0,0,0,47,112,117,111,114,49,49,47,57,0,0,0,0,0,0,0,47,112,117,111,114,49,49,47,56,0,0,0,0,0,0,0,60,47,118,58,103,114,111,117,112,62,10,0,0,0,0,0,119,104,105,116,101,0,0,0,75,80,95,68,111,119,110,0,47,112,117,111,114,49,49,47,55,0,0,0,0,0,0,0,47,112,117,111,114,49,49,47,54,0,0,0,0,0,0,0,110,111,100,101,0,0,0,0,9,9,101,120,99,104,32,48,32,114,108,105,110,101,116,111,0,0,0,0,0,0,0,0,47,112,117,111,114,49,49,47,53,0,0,0,0,0,0,0,108,105,109,101,0,0,0,0,108,97,98,101,108,102,108,111,97,116,0,0,0,0,0,0,47,112,117,111,114,49,49,47,52,0,0,0,0,0,0,0,83,105,103,109,97,0,0,0,47,112,117,111,114,49,49,47,51,0,0,0,0,0,0,0,47,112,117,111,114,49,49,47,50,0,0,0,0,0,0,0,101,100,103,101,104,114,101,102,0,0,0,0,0,0,0,0,117,115,101,114,111,117,116,58,32,99,111,117,108,100,32,110,111,116,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,10,0,0,0,0,0,47,112,117,111,114,49,49,47,49,49,0,0,0,0,0,0,47,98,114,98,103,49,48,47,54,0,0,0,0,0,0,0,47,112,117,111,114,49,49,47,49,48,0,0,0,0,0,0,97,117,120,103,0,0,0,0,47,112,117,111,114,49,49,47,49,0,0,0,0,0,0,0,47,112,117,111,114,49,48,47,57,0,0,0,0,0,0,0,62,10,0,0,0,0,0,0,65,118,97,110,116,71,97,114,100,101,45,66,111,111,107,0,47,112,117,111,114,49,48,47,56,0,0,0,0,0,0,0,47,112,117,111,114,49,48,47,55,0,0,0,0,0,0,0,109,105,115,109,97,116,99,104,101,100,32,116,97,103,0,0,9,9,50,32,99,111,112,121,0,0,0,0,0,0,0,0,47,112,117,111,114,49,48,47,54,0,0,0,0,0,0,0,108,105,103,104,116,121,101,108,108,111,119,0,0,0,0,0,119,101,105,103,104,116,0,0,47,112,117,111,114,49,48,47,53,0,0,0,0,0,0,0,83,99,97,114,111,110,0,0,38,108,116,59,0,0,0,0,47,112,117,111,114,49,48,47,52,0,0,0,0,0,0,0,112,108,97,105,110,58,100,111,116,0,0,0,0,0,0,0,47,112,117,111,114,49,48,47,51,0,0,0,0,0,0,0,85,82,76,0,0,0,0,0,37,115,32,45,62,32,37,115,58,32,116,97,105,108,32,110,111,116,32,105,110,115,105,100,101,32,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,10,0,0,0,0,0,0,47,112,117,111,114,49,48,47,50,0,0,0,0,0,0,0,47,98,114,98,103,49,48,47,53,0,0,0,0,0,0,0,47,112,117,111,114,49,48,47,49,48,0,0,0,0,0,0,37,100,32,116,101,120,116,115,10,0,0,0,0,0,0,0,95,97,110,111,110,121,109,111,117,115,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,100,113,46,112,110,108,115,0,0,48,0,0,0,0,0,0,0,47,112,117,111,114,49,48,47,49,0,0,0,0,0,0,0,115,116,111,112,10,0,0,0,47,112,117,98,117,103,110,57,47,57,0,0,0,0,0,0,32,116,97,114,103,101,116,61,34,37,115,34,0,0,0,0,69,78,68,0,0,0,0,0,47,112,117,98,117,103,110,57,47,56,0,0,0,0,0,0,47,112,117,98,117,103,110,57,47,55,0,0,0,0,0,0,9,9,109,111,118,101,116,111,0,0,0,0,0,0,0,0,47,112,117,98,117,103,110,57,47,54,0,0,0,0,0,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,0,0,122,0,0,0,0,0,0,0,98,105,115,113,117,101,0,0,47,112,117,98,117,103,110,57,47,53,0,0,0,0,0,0,82,104,111,0,0,0,0,0,47,112,117,98,117,103,110,57,47,52,0,0,0,0,0,0,47,112,117,98,117,103,110,57,47,51,0,0,0,0,0,0,104,114,101,102,0,0,0,0,47,112,117,98,117,103,110,57,47,50,0,0,0,0,0,0,47,98,114,98,103,49,48,47,52,0,0,0,0,0,0,0,47,112,117,98,117,103,110,57,47,49,0,0,0,0,0,0,47,112,117,98,117,103,110,56,47,56,0,0,0,0,0,0,46,46,46,32,37,115,32,46,46,46,10,0,0,0,0,0,47,112,117,98,117,103,110,56,47,55,0,0,0,0,0,0,32,116,105,116,108,101,61,34,37,115,34,0,0,0,0,0,47,112,117,98,117,103,110,56,47,54,0,0,0,0,0,0,47,112,117,98,117,103,110,56,47,53,0,0,0,0,0,0,109,105,110,0,0,0,0,0,9,9,52,32,50,32,114,111,108,108,0,0,0,0,0,0,47,112,117,98,117,103,110,56,47,52,0,0,0,0,0,0,114,101,109,105,110,99,114,111,115,115,0,0,0,0,0,0,108,105,103,104,116,115,108,97,116,101,103,114,101,121,0,0,104,101,105,103,104,116,61,34,37,108,102,37,50,115,34,0,118,101,114,116,105,99,101,115,0,0,0,0,0,0,0,0,110,115,108,105,109,105,116,0,102,97,108,115,101,0,0,0,73,83,79,76,97,116,105,110,49,69,110,99,111,100,105,110,103,32,48,32,50,53,53,32,103,101,116,105,110,116,101,114,118,97,108,32,112,117,116,105,110,116,101,114,118,97,108,0,47,112,117,98,117,103,110,56,47,51,0,0,0,0,0,0,80,115,105,0,0,0,0,0,47,112,117,98,117,103,110,56,47,50,0,0,0,0,0,0,115,101,116,108,105,110,101,119,105,100,116,104,0,0,0,0,47,112,117,98,117,103,110,56,47,49,0,0,0,0,0,0,78,111,32,99,111,109,109,97,32,105,110,32,99,111,108,111,114,32,115,112,101,99,32,34,37,115,34,32,105,110,32,99,111,108,111,114,32,97,116,116,114,105,98,117,116,101,32,0,47,112,117,98,117,103,110,55,47,55,0,0,0,0,0,0,47,98,114,98,103,49,48,47,51,0,0,0,0,0,0,0,47,112,117,98,117,103,110,55,47,54,0,0,0,0,0,0,47,112,117,98,117,103,110,55,47,53,0,0,0,0,0,0,47,62,10,0,0,0,0,0,47,112,117,98,117,103,110,55,47,52,0,0,0,0,0,0,67,69,76,76,83,66,79,82,68,69,82,0,0,0,0,0,35,37,50,120,37,50,120,37,50,120,37,50,120,0,0,0,32,104,114,101,102,61,34,37,115,34,0,0,0,0,0,0,47,112,117,98,117,103,110,55,47,51,0,0,0,0,0,0,47,112,117,98,117,103,110,55,47,50,0,0,0,0,0,0,47,98,111,120,112,114,105,109,32,123,9,9,9,9,37,32,120,99,111,114,110,101,114,32,121,99,111,114,110,101,114,32,120,115,105,122,101,32,121,115,105,122,101,0,0,0,0,0,47,112,117,98,117,103,110,55,47,49,0,0,0,0,0,0,108,105,103,104,116,115,108,97,116,101,103,114,97,121,0,0,99,111,109,109,101,110,116,0,47,112,117,98,117,103,110,54,47,54,0,0,0,0,0,0,80,114,105,109,101,0,0,0,47,112,117,98,117,103,110,54,47,53,0,0,0,0,0,0,47,112,117,98,117,103,110,54,47,52,0,0,0,0,0,0,73,108,108,101,103,97,108,32,108,101,110,103,116,104,32,118,97,108,117,101,32,105,110,32,34,37,115,34,32,99,111,108,111,114,32,97,116,116,114,105,98,117,116,101,32,0,0,0,118,101,101,0,0,0,0,0,47,112,117,98,117,103,110,54,47,51,0,0,0,0,0,0,47,98,114,98,103,49,48,47,50,0,0,0,0,0,0,0,47,112,117,98,117,103,110,54,47,50,0,0,0,0,0,0,115,112,108,105,110,101,115,46,99,0,0,0,0,0,0,0,110,111,100,101,32,39,37,115,39,44,32,103,114,97,112,104,32,39,37,115,39,32,115,105,122,101,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,108,97,98,101,108,10,0,47,112,117,98,117,103,110,54,47,49,0,0,0,0,0,0,34,32,119,105,100,116,104,61,34,37,103,112,120,34,32,104,101,105,103,104,116,61,34,37,103,112,120,34,32,112,114,101,115,101,114,118,101,65,115,112,101,99,116,82,97,116,105,111,61,34,120,77,105,110,89,77,105,110,32,109,101,101,116,34,32,120,61,34,37,103,34,32,121,61,34,37,103,34,0,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,83,84,89,76,69,32,45,32,105,103,110,111,114,101,100,10,0,0,0,47,112,117,98,117,103,110,53,47,53,0,0,0,0,0,0,60,97,0,0,0,0,0,0,47,112,117,98,117,103,110,53,47,52,0,0,0,0,0,0,47,112,117,98,117,103,110,53,47,51,0,0,0,0,0,0,9,103,114,101,115,116,111,114,101,0,0,0,0,0,0,0,47,112,117,98,117,103,110,53,47,50,0,0,0,0,0,0,108,105,103,104,116,115,107,121,98,108,117,101,0,0,0,0,103,114,111,117,112,0,0,0,47,112,117,98,117,103,110,53,47,49,0,0,0,0,0,0,80,105,0,0,0,0,0,0,47,112,117,98,117,103,110,52,47,52,0,0,0,0,0,0,47,112,117,98,117,103,110,52,47,51,0,0,0,0,0,0,48,45,108,101,110,103,116,104,32,105,110,32,99,111,108,111,114,32,115,112,101,99,32,34,37,115,34,10,0,0,0,0,47,112,117,98,117,103,110,52,47,50,0,0,0,0,0,0,47,98,114,98,103,49,48,47,49,48,0,0,0,0,0,0,105,110,0,0,0,0,0,0,47,112,117,98,117,103,110,52,47,49,0,0,0,0,0,0,108,97,98,101,108,108,111,99,0,0,0,0,0,0,0,0,47,112,117,98,117,103,110,51,47,51,0,0,0,0,0,0,32,116,114,97,110,115,102,111,114,109,61,34,114,111,116,97,116,101,40,37,100,32,37,103,32,37,103,41,34,0,0,0,79,85,78,68,69,68,0,0,47,112,117,98,117,103,110,51,47,50,0,0,0,0,0,0,60,47,97,62,10,0,0,0,47,112,117,98,117,103,110,51,47,49,0,0,0,0,0,0,47,112,117,98,117,57,47,57,0,0,0,0,0,0,0,0,9,9,125,32,105,102,0,0,47,112,117,98,117,57,47,56,0,0,0,0,0,0,0,0,102,108,97,116,46,99,0,0,108,105,103,104,116,115,101,97,103,114,101,101,110,0,0,0,108,97,121,101,114,0,0,0,114,101,99,116,32,37,115,32,37,100,44,37,100,32,37,100,44,37,100,10,0,0,0,0,47,112,117,98,117,57,47,55,0,0,0,0,0,0,0,0,80,104,105,0,0,0,0,0,47,97,99,99,101,110,116,52,47,51,0,0,0,0,0,0,47,112,117,98,117,57,47,54,0,0,0,0,0,0,0,0,47,112,117,98,117,57,47,53,0,0,0,0,0,0,0,0,32,45,45,32,0,0,0,0,47,112,117,98,117,57,47,52,0,0,0,0,0,0,0,0,47,98,114,98,103,49,48,47,49,0,0,0,0,0,0,0,47,112,117,98,117,57,47,51,0,0,0,0,0,0,0,0,78,111,32,111,114,32,105,109,112,114,111,112,101,114,32,105,109,97,103,101,61,34,37,115,34,32,102,111,114,32,110,111,100,101,32,34,37,115,34,10,0,0,0,0,0,0,0,0,47,112,117,98,117,57,47,50,0,0,0,0,0,0,0,0,34,32,119,105,100,116,104,61,34,37,103,112,120,34,32,104,101,105,103,104,116,61,34,37,103,112,120,34,32,112,114,101,115,101,114,118,101,65,115,112,101,99,116,82,97,116,105,111,61,34,120,77,105,100,89,77,105,100,32,109,101,101,116,34,32,120,61,34,37,103,34,32,121,61,34,37,103,34,0,0,115,116,121,108,101,0,0,0,47,112,117,98,117,57,47,49,0,0,0,0,0,0,0,0,60,47,118,58,114,101,99,116,62,10,0,0,0,0,0,0,47,112,117,98,117,56,47,56,0,0,0,0,0,0,0,0,47,112,117,98,117,56,47,55,0,0,0,0,0,0,0,0,9,9,9,116,101,120,116,32,115,116,114,105,110,103,119,105,100,116,104,32,112,111,112,32,119,105,100,116,104,32,101,120,99,104,32,115,117,98,32,116,101,120,116,32,108,101,110,103,116,104,32,100,105,118,32,48,32,116,101,120,116,32,97,115,104,111,119,0,0,0,0,0,47,112,117,98,117,56,47,54,0,0,0,0,0,0,0,0,108,105,103,104,116,115,97,108,109,111,110,0,0,0,0,0,110,111,106,117,115,116,105,102,121,0,0,0,0,0,0,0,47,112,117,98,117,56,47,53,0,0,0,0,0,0,0,0,79,117,109,108,0,0,0,0,110,0,0,0,0,0,0,0,47,112,117,98,117,56,47,52,0,0,0,0,0,0,0,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,115,116,97,114,116,32,112,111,114,116,32,110,111,116,32,105,110,32,102,105,114,115,116,32,98,111,120,10,0,0,0,0,0,0,47,112,117,98,117,56,47,51,0,0,0,0,0,0,0,0,32,45,62,32,0,0,0,0,47,112,117,98,117,56,47,50,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,57,0,0,0,0,0,0,0,47,112,117,98,117,56,47,49,0,0,0,0,0,0,0,0,60,110,105,108,62,0,0,0,47,112,117,98,117,55,47,55,0,0,0,0,0,0,0,0,60,105,109,97,103,101,32,120,108,105,110,107,58,104,114,101,102,61,34,0,0,0,0,0,99,101,108,108,98,111,114,100,101,114,0,0,0,0,0,0,47,112,117,98,117,55,47,54,0,0,0,0,0,0,0,0,60,47,99,101,110,116,101,114,62,60,47,118,58,116,101,120,116,98,111,120,62,10,0,0,47,112,117,98,117,55,47,53,0,0,0,0,0,0,0,0,47,112,117,98,117,55,47,52,0,0,0,0,0,0,0,0,9,9,9,91,93,32,48,32,115,101,116,100,97,115,104,0,47,112,117,98,117,55,47,51,0,0,0,0,0,0,0,0,108,105,103,104,116,112,105,110,107,0,0,0,0,0,0,0,104,116,109,108,116,97,98,108,101,46,99,0,0,0,0,0,105,109,97,103,101,115,99,97,108,101,0,0,0,0,0,0,106,112,101,103,58,102,105,103,0,0,0,0,0,0,0,0,47,112,117,98,117,55,47,50,0,0,0,0,0,0,0,0,79,116,105,108,100,101,0,0,47,112,117,98,117,55,47,49,0,0,0,0,0,0,0,0,47,112,117,98,117,54,47,54,0,0,0,0,0,0,0,0,105,110,32,101,100,103,101,32,37,115,37,115,37,115,10,0,47,112,117,98,117,54,47,53,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,56,0,0,0,0,0,0,0,47,112,117,98,117,54,47,52,0,0,0,0,0,0,0,0,78,111,32,111,114,32,105,109,112,114,111,112,101,114,32,115,104,97,112,101,102,105,108,101,61,34,37,115,34,32,102,111,114,32,110,111,100,101,32,34,37,115,34,10,0,0,0,0,47,112,117,98,117,54,47,51,0,0,0,0,0,0,0,0,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,60,84,65,66,76,69,62,0,47,112,117,98,117,54,47,50,0,0,0,0,0,0,0,0,34,62,60,99,101,110,116,101,114,62,0,0,0,0,0,0,47,112,117,98,117,54,47,49,0,0,0,0,0,0,0,0,109,101,114,103,101,95,111,110,101,119,97,121,32,103,108,105,116,99,104,10,0,0,0,0,47,112,117,98,117,53,47,53,0,0,0,0,0,0,0,0,84,82,0,0,0,0,0,0,9,9,119,105,100,116,104,32,48,32,103,116,32,123,0,0,47,112,117,98,117,53,47,52,0,0,0,0,0,0,0,0,108,105,103,104,116,103,114,101,121,0,0,0,0,0,0,0,45,45,0,0,0,0,0,0,102,105,120,101,100,115,105,122,101,0,0,0,0,0,0,0,47,112,117,98,117,53,47,51,0,0,0,0,0,0,0,0,79,115,108,97,115,104,0,0,47,112,117,98,117,53,47,50,0,0,0,0,0,0,0,0,47,112,117,98,117,53,47,49,0,0,0,0,0,0,0,0,58,0,0,0,0,0,0,0,47,112,117,98,117,52,47,52,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,55,0,0,0,0,0,0,0,47,112,117,98,117,52,47,51,0,0,0,0,0,0,0,0,69,114,114,111,114,32,100,117,114,105,110,103,32,99,111,110,118,101,114,115,105,111,110,32,116,111,32,34,85,84,70,45,56,34,46,32,32,81,117,105,116,105,110,103,46,10,0,0,114,101,103,117,108,97,114,0,47,112,117,98,117,52,47,50,0,0,0,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,32,37,100,32,37,115,10,0,0,0,0,0,0,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,65,76,73,71,78,32,105,110,32,84,68,32,45,32,105,103,110,111,114,101,100,10,0,0,0,0,0,47,112,117,98,117,52,47,49,0,0,0,0,0,0,0,0,99,111,108,111,114,58,35,37,48,50,120,37,48,50,120,37,48,50,120,59,0,0,0,0,47,112,117,98,117,51,47,51,0,0,0,0,0,0,0,0,114,101,100,0,0,0,0,0,68,111,119,110,0,0,0,0,47,112,117,98,117,51,47,50,0,0,0,0,0,0,0,0,32,45,100,97,115,104,32,50,0,0,0,0,0,0,0,0,9,103,115,97,118,101,0,0,47,112,117,98,117,51,47,49,0,0,0,0,0,0,0,0,108,105,103,104,116,103,114,101,101,110,0,0,0,0,0,0,100,105,115,116,111,114,116,105,111,110,0,0,0,0,0,0,47,112,114,103,110,57,47,57,0,0,0,0,0,0,0,0,79,109,105,99,114,111,110,0,47,112,114,103,110,57,47,56,0,0,0,0,0,0,0,0,47,112,114,103,110,57,47,55,0,0,0,0,0,0,0,0,37,115,45,37,115,0,0,0,47,112,114,103,110,57,47,54,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,54,0,0,0,0,0,0,0,87,97,114,110,105,110,103,0,47,112,114,103,110,57,47,53,0,0,0,0,0,0,0,0,37,108,102,44,37,108,102,0,47,112,114,103,110,57,47,52,0,0,0,0,0,0,0,0,125,10,0,0,0,0,0,0,108,97,98,101,108,0,0,0,47,112,114,103,110,57,47,51,0,0,0,0,0,0,0,0,69,88,84,0,0,0,0,0,99,111,108,111,114,58,37,115,59,0,0,0,0,0,0,0,47,112,114,103,110,57,47,50,0,0,0,0,0,0,0,0,91,105,110,116,101,114,110,97,108,32,116,105,109,101,115,93,0,0,0,0,0,0,0,0,47,112,114,103,110,57,47,49,0,0,0,0,0,0,0,0,112,97,114,116,105,97,108,32,99,104,97,114,97,99,116,101,114,0,0,0,0,0,0,0,9,47,119,105,100,116,104,32,101,120,99,104,32,100,101,102,0,0,0,0,0,0,0,0,47,112,114,103,110,56,47,56,0,0,0,0,0,0,0,0,108,105,103,104,116,103,114,97,121,0,0,0,0,0,0,0,115,107,101,119,0,0,0,0,47,112,114,103,110,56,47,55,0,0,0,0,0,0,0,0,79,109,101,103,97,0,0,0,47,112,114,103,110,56,47,54,0,0,0,0,0,0,0,0,38,97,109,112,59,0,0,0,99,97,110,111,110,58,100,111,116,0,0,0,0,0,0,0,47,112,114,103,110,56,47,53,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,98,101,122,45,62,101,102,108,97,103,0,0,0,0,0,0,47,112,114,103,110,56,47,52,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,53,0,0,0,0,0,0,0,47,112,114,103,110,56,47,51,0,0,0,0,0,0,0,0,109,97,114,103,105,110,0,0,103,114,97,112,104,0,0,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,100,113,46,112,110,108,115,0,0,0,47,112,114,103,110,56,47,50,0,0,0,0,0,0,0,0,37,100,32,101,108,108,105,112,115,101,115,10,0,0,0,0,32,32,125,10,0,0,0,0,101,100,103,101,0,0,0,0,32,0,0,0,0,0,0,0,47,112,114,103,110,56,47,49,0,0,0,0,0,0,0,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,66,65,76,73,71,78,32,105,110,32,84,68,32,45,32,105,103,110,111,114,101,100,10,0,0,0,0,32,102,111,110,116,45,115,105,122,101,58,32,37,46,50,102,112,116,59,0,0,0,0,0,76,97,121,111,117,116,32,119,97,115,32,110,111,116,32,100,111,110,101,10,0,0,0,0,66,69,71,73,78,0,0,0,47,112,114,103,110,55,47,55,0,0,0,0,0,0,0,0,47,112,114,103,110,55,47,54,0,0,0,0,0,0,0,0,9,47,116,101,120,116,32,101,120,99,104,32,100,101,102,0,47,112,114,103,110,55,47,53,0,0,0,0,0,0,0,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,121,101,108,108,111,119,0,0,0,0,112,101,114,105,112,104,101,114,105,101,115,0,0,0,0,0,98,101,105,103,101,0,0,0,47,112,114,103,110,55,47,52,0,0,0,0,0,0,0,0,79,103,114,97,118,101,0,0,47,112,114,103,110,55,47,51,0,0,0,0,0,0,0,0,47,112,114,103,110,55,47,50,0,0,0,0,0,0,0,0,116,97,105,108,108,97,98,101,108,0,0,0,0,0,0,0,47,112,114,103,110,55,47,49,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,52,0,0,0,0,0,0,0,47,112,114,103,110,54,47,54,0,0,0,0,0,0,0,0,92,78,0,0,0,0,0,0,47,112,114,103,110,54,47,53,0,0,0,0,0,0,0,0,32,32,32,32,116,101,120,116,117,114,101,32,73,109,97,103,101,84,101,120,116,117,114,101,32,123,32,117,114,108,32,34,37,115,34,32,125,10,0,0,47,112,114,103,110,54,47,52,0,0,0,0,0,0,0,0,66,79,82,68,69,82,0,0,102,111,110,116,45,115,116,121,108,101,58,32,37,115,59,0,47,112,114,103,110,54,47,51,0,0,0,0,0,0,0,0,47,112,114,103,110,54,47,50,0,0,0,0,0,0,0,0,115,97,109,101,0,0,0,0,109,97,112,0,0,0,0,0,47,112,114,103,110,54,47,49,0,0,0,0,0,0,0,0,108,105,103,104,116,99,121,97,110,0,0,0,0,0,0,0,119,105,100,116,104,61,34,37,108,102,37,50,115,34,0,0,115,105,100,101,115,0,0,0,69,100,103,101,32,108,101,110,103,116,104,32,37,102,32,108,97,114,103,101,114,32,116,104,97,110,32,109,97,120,105,109,117,109,32,37,117,32,97,108,108,111,119,101,100,46,10,67,104,101,99,107,32,102,111,114,32,111,118,101,114,119,105,100,101,32,110,111,100,101,40,115,41,46,10,0,0,0,0,0,47,0,0,0,0,0,0,0,47,112,114,103,110,53,47,53,0,0,0,0,0,0,0,0,32,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,48,0,0,0,0,0,0,0,79,99,105,114,99,0,0,0,47,97,108,105,103,110,101,100,116,101,120,116,32,123,9,9,9,37,32,119,105,100,116,104,32,116,101,120,116,0,0,0,47,112,114,103,110,53,47,52,0,0,0,0,0,0,0,0,98,111,108,100,0,0,0,0,47,112,114,103,110,53,47,51,0,0,0,0,0,0,0,0,104,101,97,100,108,97,98,101,108,0,0,0,0,0,0,0,47,112,114,103,110,53,47,50,0,0,0,0,0,0,0,0,115,104,97,112,101,115,46,99,0,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,51,0,0,0,0,0,0,0,47,112,114,103,110,53,47,49,0,0,0,0,0,0,0,0,98,97,100,32,108,97,98,101,108,32,102,111,114,109,97,116,32,37,115,10,0,0,0,0,47,112,114,103,110,52,47,52,0,0,0,0,0,0,0,0,32,32,32,32,125,10,0,0,47,112,114,103,110,52,47,51,0,0,0,0,0,0,0,0,67,69,76,76,80,65,68,68,73,78,71,0,0,0,0,0,102,111,110,116,45,115,116,114,101,116,99,104,58,32,37,115,59,0,0,0,0,0,0,0,47,112,114,103,110,52,47,50,0,0,0,0,0,0,0,0,47,112,114,103,110,52,47,49,0,0,0,0,0,0,0,0,37,32,100,114,97,119,32,116,101,120,116,32,102,105,116,116,101,100,32,116,111,32,105,116,115,32,101,120,112,101,99,116,101,100,32,119,105,100,116,104,0,0,0,0,0,0,0,0,47,112,114,103,110,51,47,51,0,0,0,0,0,0,0,0,108,105,103,104,116,99,111,114,97,108,0,0,0,0,0,0,112,101,110,119,105,100,116,104,0,0,0,0,0,0,0,0,47,112,114,103,110,51,47,50,0,0,0,0,0,0,0,0,79,97,99,117,116,101,0,0,47,112,114,103,110,51,47,49,0,0,0,0,0,0,0,0,47,112,114,103,110,49,49,47,57,0,0,0,0,0,0,0,108,97,98,101,108,0,0,0,105,110,118,0,0,0,0,0,47,112,114,103,110,49,49,47,56,0,0,0,0,0,0,0,47,98,108,117,101,115,57,47,50,0,0,0,0,0,0,0,47,112,114,103,110,49,49,47,55,0,0,0,0,0,0,0,102,97,108,115,101,0,0,0,47,112,114,103,110,49,49,47,54,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,100,105,102,102,117,115,101,67,111,108,111,114,32,49,32,49,32,49,10,0,0,0,0,0,47,112,114,103,110,49,49,47,53,0,0,0,0,0,0,0,67,69,76,76,83,80,65,67,73,78,71,0,0,0,0,0,102,111,110,116,45,119,101,105,103,104,116,58,32,37,115,59,0,0,0,0,0,0,0,0,47,112,114,103,110,49,49,47,52,0,0,0,0,0,0,0,47,112,114,103,110,49,49,47,51,0,0,0,0,0,0,0,99,97,110,110,111,116,32,97,108,108,111,99,97,116,101,32,112,115,10,0,0,0,0,0,9,115,99,97,108,101,102,111,110,116,32,115,101,116,102,111,110,116,0,0,0,0,0,0,47,112,114,103,110,49,49,47,50,0,0,0,0,0,0,0,108,105,103,104,116,98,108,117,101,0,0,0,0,0,0,0,120,108,97,98,101,108,0,0,47,112,114,103,110,49,49,47,49,49,0,0,0,0,0,0,79,69,108,105,103,0,0,0,47,112,114,103,110,49,49,47,49,48,0,0,0,0,0,0,47,112,114,103,110,49,49,47,49,0,0,0,0,0,0,0,102,97,108,115,101,0,0,0,47,112,114,103,110,49,48,47,57,0,0,0,0,0,0,0,47,112,97,116,104,98,111,120,32,123,10,32,32,32,32,47,88,32,101,120,99,104,32,110,101,103,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,89,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,120,32,101,120,99,104,32,110,101,103,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,121,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,110,101,119,112,97,116,104,32,120,32,121,32,109,111,118,101,116,111,10,32,32,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,32,32,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,125,32,100,101,102,10,0,0,47,98,108,117,101,115,57,47,49,0,0,0,0,0,0,0,47,112,114,103,110,49,48,47,56,0,0,0,0,0,0,0,105,109,97,103,101,0,0,0,111,117,116,0,0,0,0,0,47,112,114,103,110,49,48,47,55,0,0,0,0,0,0,0,32,32,32,32,32,32,97,109,98,105,101,110,116,73,110,116,101,110,115,105,116,121,32,48,46,51,51,10,0,0,0,0,47,112,114,103,110,49,48,47,54,0,0,0,0,0,0,0,67,79,76,83,80,65,78,32,118,97,108,117,101,32,99,97,110,110,111,116,32,98,101,32,48,32,45,32,105,103,110,111,114,101,100,10,0,0,0,0,102,111,110,116,45,102,97,109,105,108,121,58,32,39,37,115,39,59,0,0,0,0,0,0,47,112,114,103,110,49,48,47,53,0,0,0,0,0,0,0,47,112,114,103,110,49,48,47,52,0,0,0,0,0,0,0,9,102,105,110,100,102,111,110,116,32,101,120,99,104,0,0,47,112,114,103,110,49,48,47,51,0,0,0,0,0,0,0,108,101,109,111,110,99,104,105,102,102,111,110,0,0,0,0,102,111,110,116,99,111,108,111,114,0,0,0,0,0,0,0,47,112,114,103,110,49,48,47,50,0,0,0,0,0,0,0,78,117,0,0,0,0,0,0,47,97,99,99,101,110,116,52,47,50,0,0,0,0,0,0,47,112,114,103,110,49,48,47,49,48,0,0,0,0,0,0,47,112,114,103,110,49,48,47,49,0,0,0,0,0,0,0,105,110,118,105,115,0,0,0,99,109,97,112,120,95,110,112,58,109,97,112,0,0,0,0,47,112,105,121,103,57,47,57,0,0,0,0,0,0,0,0,47,98,108,117,101,115,56,47,56,0,0,0,0,0,0,0,47,112,105,121,103,57,47,56,0,0,0,0,0,0,0,0,102,105,108,108,101,100,0,0,47,112,105,121,103,57,47,55,0,0,0,0,0,0,0,0,32,32,32,32,109,97,116,101,114,105,97,108,32,77,97,116,101,114,105,97,108,32,123,10,0,0,0,0,0,0,0,0,47,112,105,121,103,57,47,54,0,0,0,0,0,0,0,0,67,79,76,83,80,65,78,0,60,118,58,116,101,120,116,98,111,120,32,105,110,115,101,116,61,34,48,44,48,44,48,44,48,34,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,118,45,116,101,120,116,45,119,114,97,112,112,105,110,103,58,39,102,97,108,115,101,39,59,112,97,100,100,105,110,103,58,39,48,39,59,0,0,0,0,0,0,0,47,112,105,121,103,57,47,53,0,0,0,0,0,0,0,0,47,112,105,121,103,57,47,52,0,0,0,0,0,0,0,0,47,115,101,116,95,102,111,110,116,32,123,0,0,0,0,0,47,112,105,121,103,57,47,51,0,0,0,0,0,0,0,0,108,97,119,110,103,114,101,101,110,0,0,0,0,0,0,0,102,111,110,116,110,97,109,101,0,0,0,0,0,0,0,0,47,112,105,121,103,57,47,50,0,0,0,0,0,0,0,0,110,101,116,119,111,114,107,32,115,105,109,112,108,101,120,58,32,0,0,0,0,0,0,0,78,116,105,108,100,101,0,0,101,0,0,0,0,0,0,0,47,112,105,121,103,57,47,49,0,0,0,0,0,0,0,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,98,111,120,101,115,32,37,100,32,97,110,100,32,37,100,32,100,111,110,39,116,32,116,111,117,99,104,10,0,0,0,0,0,0,47,112,105,121,103,56,47,56,0,0,0,0,0,0,0,0,45,45,0,0,0,0,0,0,47,112,105,121,103,56,47,55,0,0,0,0,0,0,0,0,47,98,108,117,101,115,56,47,55,0,0,0,0,0,0,0,47,112,105,121,103,56,47,54,0,0,0,0,0,0,0,0,9,37,115,32,37,100,10,0,105,110,118,105,115,0,0,0,47,112,105,121,103,56,47,53,0,0,0,0,0,0,0,0,32,32,97,112,112,101,97,114,97,110,99,101,32,65,112,112,101,97,114,97,110,99,101,32,123,10,0,0,0,0,0,0,47,112,105,121,103,56,47,52,0,0,0,0,0,0,0,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,70,73,88,69,68,83,73,90,69,32,45,32,105,103,110,111,114,101,100])
.concat([10,0,0,0,0,0,0,0,32,115,116,114,111,107,101,100,61,34,102,97,108,115,101,34,32,102,105,108,108,101,100,61,34,102,97,108,115,101,34,62,10,0,0,0,0,0,0,0,47,112,105,121,103,56,47,51,0,0,0,0,0,0,0,0,47,112,105,121,103,56,47,50,0,0,0,0,0,0,0,0,9,125,32,105,102,0,0,0,47,112,105,121,103,56,47,49,0,0,0,0,0,0,0,0,108,97,118,101,110,100,101,114,98,108,117,115,104,0,0,0,102,111,110,116,115,105,122,101,0,0,0,0,0,0,0,0,60,84,65,66,76,69,62,0,103,105,102,58,102,105,103,0,47,112,105,121,103,55,47,55,0,0,0,0,0,0,0,0,77,117,0,0,0,0,0,0,47,112,105,121,103,55,47,54,0,0,0,0,0,0,0,0,47,112,105,121,103,55,47,53,0,0,0,0,0,0,0,0,45,62,0,0,0,0,0,0,47,112,105,121,103,55,47,52,0,0,0,0,0,0,0,0,47,98,108,117,101,115,56,47,54,0,0,0,0,0,0,0,47,112,105,121,103,55,47,51,0,0,0,0,0,0,0,0,35,102,56,102,56,102,56,0,47,112,105,121,103,55,47,50,0,0,0,0,0,0,0,0,83,104,97,112,101,32,123,10,0,0,0,0,0,0,0,0,47,112,105,121,103,55,47,49,0,0,0,0,0,0,0,0,65,76,83,69,0,0,0,0,60,118,58,114,101,99,116,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,0,0,0,0,0,0,47,112,105,121,103,54,47,54,0,0,0,0,0,0,0,0,47,112,105,121,103,54,47,53,0,0,0,0,0,0,0,0,118,105,114,116,117,97,108,0,84,65,66,76,69,0,0,0,9,9,103,114,101,115,116,111,114,101,0,0,0,0,0,0,47,112,105,121,103,54,47,52,0,0,0,0,0,0,0,0,108,97,118,101,110,100,101,114,0,0,0,0,0,0,0,0,115,116,121,108,101,0,0,0,47,112,105,121,103,54,47,51,0,0,0,0,0,0,0,0,76,97,109,98,100,97,0,0,47,112,105,121,103,54,47,50,0,0,0,0,0,0,0,0,47,112,105,121,103,54,47,49,0,0,0,0,0,0,0,0,98,122,46,115,105,122,101,32,37,32,51,32,61,61,32,49,0,0,0,0,0,0,0,0,47,112,105,121,103,53,47,53,0,0,0,0,0,0,0,0,47,98,108,117,101,115,56,47,53,0,0,0,0,0,0,0,47,112,105,121,103,53,47,52,0,0,0,0,0,0,0,0,38,35,51,57,59,0,0,0,35,49,48,49,48,49,48,0,47,112,105,121,103,53,47,51,0,0,0,0,0,0,0,0,110,0,0,0,0,0,0,0,47,112,105,121,103,53,47,50,0,0,0,0,0,0,0,0,82,85,69,0,0,0,0,0,60,47,118,58,111,118,97,108,62,10,0,0,0,0,0,0,47,112,105,121,103,53,47,49,0,0,0,0,0,0,0,0,47,112,105,121,103,52,47,52,0,0,0,0,0,0,0,0,32,45,100,97,115,104,32,53,0,0,0,0,0,0,0,0,109,97,103,101,110,116,97,0,75,80,95,85,112,0,0,0,9,9,9,40,92,40,41,32,115,104,111,119,32,105,32,115,116,114,32,99,118,115,32,115,104,111,119,32,40,44,41,32,115,104,111,119,32,106,32,115,116,114,32,99,118,115,32,115,104,111,119,32,40,92,41,41,32,115,104,111,119,0,0,0,47,112,105,121,103,52,47,51,0,0,0,0,0,0,0,0,107,104,97,107,105,0,0,0,102,105,108,108,99,111,108,111,114,0,0,0,0,0,0,0,47,112,105,121,103,52,47,50,0,0,0,0,0,0,0,0,75,97,112,112,97,0,0,0,47,112,105,121,103,52,47,49,0,0,0,0,0,0,0,0,47,112,105,121,103,51,47,51,0,0,0,0,0,0,0,0,98,122,46,115,105,122,101,32,62,32,48,0,0,0,0,0,47,112,105,121,103,51,47,50,0,0,0,0,0,0,0,0,47,98,108,117,101,115,56,47,52,0,0,0,0,0,0,0,47,112,105,121,103,51,47,49,0,0,0,0,0,0,0,0,35,102,48,102,48,102,48,0,69,114,114,111,114,0,0,0,47,112,105,121,103,49,49,47,57,0,0,0,0,0,0,0,111,98,106,0,0,0,0,0,47,112,105,121,103,49,49,47,56,0,0,0,0,0,0,0,72,69,73,71,72,84,0,0,32,119,105,100,116,104,58,32,37,46,50,102,59,32,104,101,105,103,104,116,58,32,37,46,50,102,34,0,0,0,0,0,123,37,115,125,0,0,0,0,47,112,105,121,103,49,49,47,55,0,0,0,0,0,0,0,91,105,110,116,101,114,110,97,108,32,97,114,105,97,108,93,0,0,0,0,0,0,0,0,47,112,105,121,103,49,49,47,54,0,0,0,0,0,0,0,117,110,99,108,111,115,101,100,32,116,111,107,101,110,0,0,9,9,9,48,32,48,32,109,111,118,101,116,111,0,0,0,47,112,105,121,103,49,49,47,53,0,0,0,0,0,0,0,105,118,111,114,121,0,0,0,99,111,108,111,114,0,0,0,47,112,105,121,103,49,49,47,52,0,0,0,0,0,0,0,73,117,109,108,0,0,0,0,47,112,105,121,103,49,49,47,51,0,0,0,0,0,0,0,107,105,110,100,32,61,61,32,76,84,95,78,79,78,69,0,103,118,58,100,111,116,0,0,47,112,105,121,103,49,49,47,50,0,0,0,0,0,0,0,115,112,108,45,62,115,105,122,101,32,62,32,48,0,0,0,98,101,122,45,62,115,102,108,97,103,0,0,0,0,0,0,100,105,103,114,97,112,104,0,47,112,105,121,103,49,49,47,49,49,0,0,0,0,0,0,47,98,108,117,101,115,56,47,51,0,0,0,0,0,0,0,47,112,105,121,103,49,49,47,49,48,0,0,0,0,0,0,35,101,48,101,48,101,48,0,37,100,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,111,112,115,0,0,0,0,0,0,47,112,105,121,103,49,49,47,49,0,0,0,0,0,0,0,103,114,101,115,116,111,114,101,10,0,0,0,0,0,0,0,108,105,103,104,116,103,114,101,121,0,0,0,0,0,0,0,47,112,105,121,103,49,48,47,57,0,0,0,0,0,0,0,37,100,32,98,101,122,105,101,114,115,32,37,100,32,112,111,105,110,116,115,10,0,0,0,82,79,87,83,80,65,78,32,118,97,108,117,101,32,99,97,110,110,111,116,32,98,101,32,48,32,45,32,105,103,110,111,114,101,100,10,0,0,0,0,32,108,101,102,116,58,32,37,46,50,102,59,32,116,111,112,58,32,37,46,50,102,59,0,78,111,32,108,105,98,122,32,115,117,112,112,111,114,116,10,0,0,0,0,0,0,0,0,69,79,70,0,0,0,0,0,47,112,105,121,103,49,48,47,56,0,0,0,0,0,0,0,68,105,110,103,98,97,116,115,0,0,0,0,0,0,0,0,47,112,105,121,103,49,48,47,55,0,0,0,0,0,0,0,9,9,9,99,111,111,114,100,102,111,110,116,32,115,101,116,102,111,110,116,0,0,0,0,47,112,105,121,103,49,48,47,54,0,0,0,0,0,0,0,105,110,100,105,103,111,0,0,115,104,97,112,101,0,0,0,97,122,117,114,101,0,0,0,47,112,105,121,103,49,48,47,53,0,0,0,0,0,0,0,73,111,116,97,0,0,0,0,47,112,105,121,103,49,48,47,52,0,0,0,0,0,0,0,47,112,105,121,103,49,48,47,51,0,0,0,0,0,0,0,115,101,116,108,105,110,101,119,105,100,116,104,0,49,0,0,47,112,105,121,103,49,48,47,50,0,0,0,0,0,0,0,105,109,97,103,101,115,99,97,108,101,0,0,0,0,0,0,47,98,108,117,101,115,56,47,50,0,0,0,0,0,0,0,47,112,105,121,103,49,48,47,49,48,0,0,0,0,0,0,35,101,56,101,56,101,56,0,112,110,103,58,115,118,103,0,47,112,105,121,103,49,48,47,49,0,0,0,0,0,0,0,117,115,101,114,95,115,104,97,112,101,95,37,100,10,0,0,47,112,97,115,116,101,108,50,56,47,56,0,0,0,0,0,82,79,87,83,80,65,78,0,32,32,60,118,58,111,118,97,108,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,0,0,0,0,0,47,112,97,115,116,101,108,50,56,47,55,0,0,0,0,0,90,97,112,102,68,105,110,103,98,97,116,115,0,0,0,0,47,112,97,115,116,101,108,50,56,47,54,0,0,0,0,0,97,103,116,97,105,108,40,101,41,32,61,61,32,85,70,95,102,105,110,100,40,97,103,116,97,105,108,40,101,41,41,0,9,9,103,115,97,118,101,0,47,112,97,115,116,101,108,50,56,47,53,0,0,0,0,0,105,110,100,105,97,110,114,101,100,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,119,105,100,116,104,0,0,0,99,111,110,116,97,105,110,95,110,111,100,101,115,32,99,108,117,115,116,32,37,115,32,114,97,110,107,32,37,100,32,109,105,115,115,105,110,103,32,110,111,100,101,10,0,0,0,0,47,112,97,115,116,101,108,50,56,47,52,0,0,0,0,0,37,115,37,115,37,115,0,0,47,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,50,53,54,32,97,114,114,97,121,32,100,101,102,0,0,0,73,103,114,97,118,101,0,0,47,112,97,115,116,101,108,50,56,47,51,0,0,0,0,0,105,110,118,105,115,105,98,108,101,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,56,47,50,0,0,0,0,0,83,121,110,116,97,120,32,101,114,114,111,114,58,32,110,111,110,45,115,112,97,99,101,32,115,116,114,105,110,103,32,117,115,101,100,32,98,101,102,111,114,101,32,60,84,65,66,76,69,62,0,0,0,0,0,0,115,111,108,105,100,0,0,0,47,112,97,115,116,101,108,50,56,47,49,0,0,0,0,0,47,98,108,117,101,115,56,47,49,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,55,47,55,0,0,0,0,0,35,51,48,51,48,51,48,0,47,112,97,115,116,101,108,50,55,47,54,0,0,0,0,0,103,115,97,118,101,32,37,103,32,37,103,32,116,114,97,110,115,108,97,116,101,32,110,101,119,112,97,116,104,10,0,0,47,112,97,115,116,101,108,50,55,47,53,0,0,0,0,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,86,65,76,73,71,78,32,45,32,105,103,110,111,114,101,100,10,0,0,120,32,101,32,34,47,62,0,47,112,97,115,116,101,108,50,55,47,52,0,0,0,0,0,109,101,100,105,117,109,0,0,47,112,97,115,116,101,108,50,55,47,51,0,0,0,0,0,9,110,112,97,103,101,115,32,49,32,103,116,32,123,0,0,47,112,97,115,116,101,108,50,55,47,50,0,0,0,0,0,104,111,116,112,105,110,107,0,104,101,105,103,104,116,0,0,100,121,110,97,109,105,99,32,108,111,97,100,105,110,103,32,110,111,116,32,97,118,97,105,108,97,98,108,101,10,0,0,47,112,97,115,116,101,108,50,55,47,49,0,0,0,0,0,73,99,105,114,99,0,0,0,47,112,97,115,116,101,108,50,54,47,54,0,0,0,0,0,47,112,97,115,116,101,108,50,54,47,53,0,0,0,0,0,84,105,109,101,115,45,82,111,109,97,110,0,0,0,0,0,110,111,110,101,0,0,0,0,47,112,97,115,116,101,108,50,54,47,52,0,0,0,0,0,47,98,108,117,101,115,55,47,55,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,54,47,51,0,0,0,0,0,35,102,99,102,99,102,99,0,47,112,97,115,116,101,108,50,54,47,50,0,0,0,0,0,93,32,32,37,100,32,102,97,108,115,101,32,37,115,10,0,47,112,97,115,116,101,108,50,54,47,49,0,0,0,0,0,73,68,68,76,69,0,0,0,108,32,0,0,0,0,0,0,47,112,97,115,116,101,108,50,53,47,53,0,0,0,0,0,85,82,87,32,67,104,97,110,99,101,114,121,32,76,0,0,47,112,97,115,116,101,108,50,53,47,52,0,0,0,0,0,9,47,115,116,114,32,49,48,32,115,116,114,105,110,103,32,100,101,102,0,0,0,0,0,47,112,97,115,116,101,108,50,53,47,51,0,0,0,0,0,104,111,110,101,121,100,101,119,0,0,0,0,0,0,0,0,111,114,100,101,114,105,110,103,0,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,53,47,50,0,0,0,0,0,73,97,99,117,116,101,0,0,47,112,97,115,116,101,108,50,53,47,49,0,0,0,0,0,47,112,97,115,116,101,108,50,52,47,52,0,0,0,0,0,112,101,110,119,105,100,116,104,0,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,52,47,51,0,0,0,0,0,47,98,108,117,101,115,55,47,54,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,52,47,50,0,0,0,0,0,35,56,48,56,48,56,48,0,47,112,97,115,116,101,108,50,52,47,49,0,0,0,0,0,93,32,32,37,100,32,116,114,117,101,32,37,115,10,0,0,78,68,95,111,114,100,101,114,40,118,41,32,60,32,78,68,95,111,114,100,101,114,40,119,41,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,51,47,51,0,0,0,0,0,79,80,0,0,0,0,0,0,37,46,48,102,32,37,46,48,102,32,0,0,0,0,0,0,47,112,97,115,116,101,108,50,51,47,50,0,0,0,0,0,90,97,112,102,67,104,97,110,99,101,114,121,45,77,101,100,105,117,109,73,116,97,108,105,99,0,0,0,0,0,0,0,47,112,97,115,116,101,108,50,51,47,49,0,0,0,0,0,9,47,105,32,101,120,99,104,32,100,101,102,0,0,0,0,47,112,97,115,116,101,108,49,57,47,57,0,0,0,0,0,103,114,101,121,0,0,0,0,114,101,115,111,108,117,116,105,111,110,0,0,0,0,0,0,47,112,97,115,116,101,108,49,57,47,56,0,0,0,0,0,71,97,109,109,97,0,0,0,47,97,99,99,101,110,116,52,47,49,0,0,0,0,0,0,47,112,97,115,116,101,108,49,57,47,55,0,0,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,47,112,97,115,116,101,108,49,57,47,54,0,0,0,0,0,112,101,114,105,112,104,101,114,105,101,115,0,0,0,0,0,47,112,97,115,116,101,108,49,57,47,53,0,0,0,0,0,47,98,108,117,101,115,55,47,53,0,0,0,0,0,0,0,105,109,97,112,95,110,112,58,109,97,112,0,0,0,0,0,47,112,97,115,116,101,108,49,57,47,52,0,0,0,0,0,105,110,118,105,115,0,0,0,47,112,97,115,116,101,108,49,57,47,51,0,0,0,0,0,37,103,32,37,103,32,0,0,47,112,97,115,116,101,108,49,57,47,50,0,0,0,0,0,79,84,84,79,77,0,0,0,32,102,105,108,108,101,100,61,34,102,97,108,115,101,34,32,0,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,57,47,49,0,0,0,0,0,47,112,97,115,116,101,108,49,56,47,56,0,0,0,0,0,84,105,109,101,115,45,82,111,109,97,110,0,0,0,0,0,9,47,106,32,101,120,99,104,32,100,101,102,0,0,0,0,47,112,97,115,116,101,108,49,56,47,55,0,0,0,0,0,103,114,101,101,110,121,101,108,108,111,119,0,0,0,0,0,100,112,105,0,0,0,0,0,47,112,97,115,116,101,108,49,56,47,54,0,0,0,0,0,69,117,109,108,0,0,0,0,115,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,56,47,53,0,0,0,0,0,47,112,97,115,116,101,108,49,56,47,52,0,0,0,0,0,112,97,103,101,100,105,114,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,98,111,120,32,37,100,32,104,97,115,32,76,76,32,99,111,111,114,100,32,62,32,85,82,32,99,111,111,114,100,10,0,0,0,47,112,97,115,116,101,108,49,56,47,51,0,0,0,0,0,47,98,108,117,101,115,55,47,52,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,56,47,50,0,0,0,0,0,116,114,111,117,98,108,101,32,105,110,32,105,110,105,116,95,114,97,110,107,10,0,0,0,100,105,97,103,111,110,97,108,115,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,56,47,49,0,0,0,0,0,91,32,0,0,0,0,0,0,47,112,97,115,116,101,108,49,55,47,55,0,0,0,0,0,87,73,68,84,72,0,0,0,34,32,0,0,0,0,0,0,47,112,97,115,116,101,108,49,55,47,54,0,0,0,0,0,47,112,97,115,116,101,108,49,55,47,53,0,0,0,0,0,84,105,109,101,115,45,73,116,97,108,105,99,0,0,0,0,9,47,110,112,97,103,101,115,32,101,120,99,104,32,100,101,102,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,55,47,52,0,0,0,0,0,103,114,101,101,110,0,0,0,99,111,110,99,101,110,116,114,97,116,101,0,0,0,0,0,99,111,108,103,0,0,0,0,112,110,103,58,102,105,103,0,47,112,97,115,116,101,108,49,55,47,51,0,0,0,0,0,69,116,97,0,0,0,0,0,109,101,109,111,114,121,32,101,120,104,97,117,115,116,101,100,0,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,55,47,50,0,0,0,0,0,47,112,97,115,116,101,108,49,55,47,49,0,0,0,0,0,66,76,0,0,0,0,0,0,47,112,97,115,116,101,108,49,54,47,54,0,0,0,0,0,47,98,108,117,101,115,55,47,51,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,54,47,53,0,0,0,0,0,114,111,117,110,100,101,100,0,47,112,97,115,116,101,108,49,54,47,52,0,0,0,0,0,117,115,45,62,110,97,109,101,0,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,54,47,51,0,0,0,0,0,119,105,100,116,104,0,0,0,32,102,105,108,108,101,100,61,34,116,114,117,101,34,32,102,105,108,108,99,111,108,111,114,61,34,0,0,0,0,0,0,47,112,97,115,116,101,108,49,54,47,50,0,0,0,0,0,47,112,97,115,116,101,108,49,54,47,49,0,0,0,0,0,84,105,109,101,115,45,66,111,108,100,73,116,97,108,105,99,0,0,0,0,0,0,0,0,47,98,101,103,105,110,112,97,103,101,32,123,9,37,32,105,32,106,32,110,112,97,103,101,115,0,0,0,0,0,0,0,85,110,99,108,111,115,101,100,32,99,111,109,109,101,110,116,10,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,53,47,53,0,0,0,0,0,103,114,97,121,0,0,0,0,99,108,117,115,116,101,114,114,97,110,107,0,0,0,0,0,102,105,110,100,95,102,97,115,116,95,110,111,100,101,40,103,44,32,110,41,0,0,0,0,47,112,97,115,116,101,108,49,53,47,52,0,0,0,0,0,69,112,115,105,108,111,110,0,47,112,97,115,116,101,108,49,53,47,51,0,0,0,0,0,47,112,97,115,116,101,108,49,53,47,50,0,0,0,0,0,112,97,100,0,0,0,0,0,47,112,97,115,116,101,108,49,53,47,49,0,0,0,0,0,47,98,108,117,101,115,55,47,50,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,52,47,52,0,0,0,0,0,38,113,117,111,116,59,0,0,102,105,108,108,101,100,0,0,47,112,97,115,116,101,108,49,52,47,51,0,0,0,0,0,117,115,0,0,0,0,0,0,47,112,97,115,116,101,108,49,52,47,50,0,0,0,0,0,118,97,108,105,103,110,0,0,34,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,52,47,49,0,0,0,0,0,47,112,97,115,116,101,108,49,51,47,51,0,0,0,0,0,84,105,109,101,115,0,0,0,32,45,102,105,108,108,32,0,47,110,111,112,99,111,108,111,114,32,123,112,111,112,32,112,111,112,32,112,111,112,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,0,0,0,47,112,97,115,116,101,108,49,51,47,50,0,0,0,0,0,103,111,108,100,101,110,114,111,100,0,0,0,0,0,0,0,108,97,110,100,115,99,97,112,101,0,0,0,0,0,0,0,103,114,101,101,110,0,0,0,85,112,0,0,0,0,0,0,47,112,97,115,116,101,108,49,51,47,49,0,0,0,0,0,69,103,114,97,118,101,0,0,47,112,97,105,114,101,100,57,47,57,0,0,0,0,0,0,47,112,97,105,114,101,100,57,47,56,0,0,0,0,0,0,37,108,102,44,37,108,102,0,47,112,97,105,114,101,100,57,47,55,0,0,0,0,0,0,47,98,108,117,101,115,55,47,49,0,0,0,0,0,0,0,47,112,97,105,114,101,100,57,47,54,0,0,0,0,0,0,108,105,103,104,116,103,114,101,121,0,0,0,0,0,0,0,47,112,97,105,114,101,100,57,47,53,0,0,0,0,0,0,106,111,98,0,0,0,0,0,37,115,58,32,0,0,0,0,47,112,97,105,114,101,100,57,47,52,0,0,0,0,0,0,116,111,111,108,116,105,112,0,0,0,0,0,0,0,0,0,47,112,97,105,114,101,100,57,47,51,0,0,0,0,0,0,104,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,49,48,48,48,48,0,0,0,47,112,97,105,114,101,100,57,47,50,0,0,0,0,0,0,84,105,109,101,115,45,66,111,108,100,0,0,0,0,0,0,110,111,116,32,119,101,108,108,45,102,111,114,109,101,100,32,40,105,110,118,97,108,105,100,32,116,111,107,101,110,41,0,47,103,114,97,112,104,99,111,108,111,114,32,123,32,115,101,116,104,115,98,99,111,108,111,114,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,47,112,97,105,114,101,100,57,47,49,0,0,0,0,0,0,103,111,108,100,0,0,0,0,111,114,105,101,110,116,97,116,105,111,110,0,0,0,0,0,47,112,97,105,114,101,100,56,47,56,0,0,0,0,0,0,69,99,105,114,99,0,0,0,47,112,97,105,114,101,100,56,47,55,0,0,0,0,0,0,108,97,98,101,108,115,46,99,0,0,0,0,0,0,0,0,100,111,116,58,100,111,116,0,47,112,97,105,114,101,100,56,47,54,0,0,0,0,0,0,109,97,114,103,105,110,0,0,99,111,109,112,111,117,110,100,46,99,0,0,0,0,0,0,47,112,97,105,114,101,100,56,47,53,0,0,0,0,0,0,47,98,108,117,101,115,54,47,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,116,114,105,99,116,32,0,47,112,97,105,114,101,100,56,47,52,0,0,0,0,0,0,98,108,97,99,107,0,0,0,104,101,97,100,112,111,114,116,0,0,0,0,0,0,0,0,108,105,98,112,97,116,104,47,37,115,58,37,100,58,32,37,115,10,0,0,0,0,0,0,47,112,97,105,114,101,100,56,47,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,118,108,111,97,100,105,109,97,103,101,95,99,111,114,101,46,99,0,0,0,0,0,0,47,112,97,105,114,101,100,56,47,50,0,0,0,0,0,0,37,115,32,105,110,32,108,105,110,101,32,37,100,32,10,0,116,105,116,108,101,0,0,0,99,32,0,0,0,0,0,0,47,112,97,105,114,101,100,56,47,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,97,110,39,116,32,111,112,101,110,32,108,105,98,114,97,114,121,32,102,105,108,101,32,37,115,10,0,0,0,0,0,37,100,32,112,111,108,121,108,105,110,101,115,32,37,100,32,112,111,105,110,116,115,10,0,47,112,97,105,114,101,100,55,47,55,0,0,0,0,0,0,102,97,110,116,97,115,121,0,47,101,100,103,101,99,111,108,111,114,32,123,32,115,101,116,104,115,98,99,111,108,111,114,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,47,112,97,105,114,101,100,55,47,54,0,0,0,0,0,0,103,104,111,115,116,119,104,105,116,101,0,0,0,0,0,0,114,111,116,97,116,101,0,0,97,113,117,97,109,97,114,105,110,101,0,0,0,0,0,0,47,112,97,105,114,101,100,55,47,53,0,0,0,0,0,0,69,97,99,117,116,101,0,0,47,112,97,105,114,101,100,55,47,52,0,0,0,0,0,0,47,112,97,105,114,101,100,55,47,51,0,0,0,0,0,0,58,9,32,0,0,0,0,0,47,112,97,105,114,101,100,55,47,50,0,0,0,0,0,0,47,98,108,117,101,115,54,47,53,0,0,0,0,0,0,0,1,112,114,111,116,111,0,0,47,112,97,105,114,101,100,55,47,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,112,97,105,114,101,100,54,47,54,0,0,0,0,0,0,32,47,62,10,0,0,0,0,47,112,97,105,114,101,100,54,47,53,0,0,0,0,0,0,116,97,114,103,101,116,0,0,37,115,37,46,48,102,44,37,46,48,102,32,0,0,0,0,47,112,97,105,114,101,100,54,47,52,0,0,0,0,0,0,47,112,97,105,114,101,100,54,47,51,0,0,0,0,0,0,83,121,109,98,111,108,0,0,97,103,104,101,97,100,40,101,41,32,61,61,32,85,70,95,102,105,110,100,40,97,103,104,101,97,100,40,101,41,41,0,47,110,111,100,101,99,111,108,111,114,32,123,32,115,101,116,104,115,98,99,111,108,111,114,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,47,112,97,105,114,101,100,54,47,50,0,0,0,0,0,0,103,97,105,110,115,98,111,114,111,0,0,0,0,0,0,0,34,37,115,34,32,119,97,115,32,110,111,116,32,102,111,117,110,100,32,97,115,32,97,32,102,105,108,101,32,111,114,32,97,115,32,97,32,115,104,97,112,101,32,108,105,98,114,97,114,121,32,109,101,109,98,101,114,10,0,0,0,0,0,0,99,101,110,116,101,114,0,0,110,101,120,116,35,105,116,101,114,61,37,100,10,0,0,0,47,112,97,105,114,101,100,54,47,49,0,0,0,0,0,0,80,97,116,104,32,112,114,111,118,105,100,101,100,32,116,111,32,102,105,108,101,58,32,34,37,115,34,32,104,97,115,32,98,101,101,110,32,105,103,110,111,114,101,100,32,98,101,99,97,117,115,101,32,102,105,108,101,115,32,97,114,101,32,111,110,108,121,32,112,101,114,109,105,116,116,101,100,32,116,111,32,98,101,32,108,111,97,100,101,100,32,102,114,111,109,32,116,104,101,32,100,105,114,101,99,116,111,114,105,101,115,32,105,110,32,34,37,115,34,32,119,104,101,110,32,114,117,110,110,105,110,103,32,105,110,32,97,110,32,104,116,116,112,32,115,101,114,118,101,114,46,10,0,0,0,0,0,0,0,0,109,97,114,107,0,0,0,0,69,84,72,0,0,0,0,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,111,112,115,0,0,0,0,0,0,0,47,112,97,105,114,101,100,53,47,53,0,0,0,0,0,0,105,110,118,105,115,0,0,0,47,112,97,105,114,101,100,53,47,52,0,0,0,0,0,0,108,97,121,101,114,115,101,112,0,0,0,0,0,0,0,0,47,112,97,105,114,101,100,53,47,51,0,0,0,0,0,0,47,98,108,117,101,115,54,47,52,0,0,0,0,0,0,0,47,112,97,105,114,101,100,53,47,50,0,0,0,0,0,0,110,111,100,101,32,37,115,44,32,112,111,114,116,32,37,115,32,117,110,114,101,99,111,103,110,105,122,101,100,10,0,0,47,112,97,105,114,101,100,53,47,49,0,0,0,0,0,0,60,118,58,105,109,97,103,101,32,115,114,99,61,34,37,115,34,32,115,116,121,108,101,61,34,32,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,119,105,100,116,104,58,37,46,50,102,59,32,104,101,105,103,104,116,58,37,46,50,102,59,32,108,101,102,116,58,37,46,50,102,32,59,32,116,111,112,58,37,46,50,102,34,0,0,0,0,0,47,112,97,105,114,101,100,52,47,52,0,0,0,0,0,0,114,111,119,115,112,97,110,0,109,32,0,0,0,0,0,0,47,112,97,105,114,101,100,52,47,51,0,0,0,0,0,0,47,112,97,105,114,101,100,52,47,50,0,0,0,0,0,0,80,97,108,97,116,105,110,111,45,82,111,109,97,110,0,0,37,32,104,111,111,107,115,32,102,111,114,32,115,101,116,116,105,110,103,32,99,111,108,111,114,32,0,0,0,0,0,0,47,112,97,105,114,101,100,52,47,49,0,0,0,0,0,0,102,117,99,104,115,105,97,0,112,97,103,101,0,0,0,0,47,112,97,105,114,101,100,51,47,51,0,0,0,0,0,0,68,101,108,116,97,0,0,0,47,112,97,105,114,101,100,51,47,50,0,0,0,0,0,0,47,112,97,105,114,101,100,51,47,49,0,0,0,0,0,0,108,97,121,101,114,115,0,0,100,111,116,0,0,0,0,0,47,112,97,105,114,101,100,49,50,47,57,0,0,0,0,0,47,98,108,117,101,115,54,47,51,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,50,47,56,0,0,0,0,0,110,111,100,101,32,37,115,44,32,112,111,114,116,32,37,115,44,32,117,110,114,101,99,111,103,110,105,122,101,100,32,99,111,109,112,97,115,115,32,112,111,105,110,116,32,39,37,115,39,32,45,32,105,103,110,111,114,101,100,10,0,0,0,0,47,112,97,105,114,101,100,49,50,47,55,0,0,0,0,0,106,112,103,58,118,109,108,0,47,112,97,105,114,101,100,49,50,47,54,0,0,0,0,0,112,111,114,116,0,0,0,0,47,62,60,47,118,58,115,104,97,112,101,62,10,0,0,0,47,112,97,105,114,101,100,49,50,47,53,0,0,0,0,0,47,112,97,105,114,101,100,49,50,47,52,0,0,0,0,0,80,97,108,97,116,105,110,111,45,73,116,97,108,105,99,0,47,100,105,97,103,111,110,97,108,115,32,123,32,125,32,98,105,110,100,32,100,101,102,0,47,112,97,105,114,101,100,49,50,47,51,0,0,0,0,0,102,111,114,101,115,116,103,114,101,101,110,0,0,0,0,0,115,105,122,101,0,0,0,0,47,112,97,105,114,101,100,49,50,47,50,0,0,0,0,0,68,97,103,103,101,114,0,0,47,112,97,105,114,101,100,49,50,47,49,50,0,0,0,0,47,112,97,105,114,101,100,49,50,47,49,49,0,0,0,0,100,103,101,115,102,105,114,115,116,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,50,47,49,48,0,0,0,0,47,98,108,117,101,115,54,47,50,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,50,47,49,0,0,0,0,0,95,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,57,0,0,0,0,0,106,112,101,58,118,109,108,0,47,112,97,105,114,101,100,49,49,47,56,0,0,0,0,0,105,100,0,0,0,0,0,0,115,117,114,112,114,105,115,101,10,0,0,0,0,0,0,0,60,118,58,112,97,116,104,32,32,118,61,34,0,0,0,0,47,112,97,105,114,101,100,49,49,47,55,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,54,0,0,0,0,0,80,97,108,97,116,105,110,111,45,66,111,108,100,73,116,97,108,105,99,0,0,0,0,0,47,114,111,117,110,100,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,0,0,47,112,97,105,114,101,100,49,49,47,53,0,0,0,0,0,102,108,111,114,97,108,119,104,105,116,101,0,0,0,0,0,102,111,110,116,110,97,109,101,115,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,52,0,0,0,0,0,67,104,105,0,0,0,0,0,47,97,99,99,101,110,116,51,47,51,0,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,51,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,50,0,0,0,0,0,111,100,101,115,102,105,114,115,116,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,49,49,0,0,0,0,47,98,108,117,101,115,54,47,49,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,49,48,0,0,0,0,37,46,53,103,32,37,46,53,103,32,116,114,97,110,115,108,97,116,101,32,110,101,119,112,97,116,104,32,117,115,101,114,95,115,104,97,112,101,95,37,100,10,0,0,0,0,0,0,99,109,97,112,120,58,109,97,112,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,49,47,49,0,0,0,0,0,106,112,101,103,58,118,109,108,0,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,48,47,57,0,0,0,0,0,104,114,101,102,0,0,0,0,32,62,0,0,0,0,0,0,47,112,97,105,114,101,100,49,48,47,56,0,0,0,0,0,47,112,97,105,114,101,100,49,48,47,55,0,0,0,0,0,80,97,108,97,116,105,110,111,32,76,105,110,111,116,121,112,101,0,0,0,0,0,0,0,47,117,110,102,105,108,108,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,0,47,112,97,105,114,101,100,49,48,47,54,0,0,0,0,0,102,97,115,116,103,114,46,99,0,0,0,0,0,0,0,0,102,105,114,101,98,114,105,99,107,0,0,0,0,0,0,0,115,104,111,119,98,111,120,101,115,0,0,0,0,0,0,0,38,97,109,112,59,0,0,0,47,112,97,105,114,101,100,49,48,47,53,0,0,0,0,0,67,99,101,100,105,108,0,0,99,117,115,116,111,109,0,0,47,112,97,105,114,101,100,49,48,47,52,0,0,0,0,0,47,112,97,105,114,101,100,49,48,47,51,0,0,0,0,0,111,117,116,112,117,116,111,114,100,101,114,0,0,0,0,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,98,111,120,32,48,32,104,97,115,32,76,76,32,99,111,111,114,100,32,62,32,85,82,32,99,111,111,114,100,10,0,0,0,0,47,112,97,105,114,101,100,49,48,47,50,0,0,0,0,0,47,98,108,117,101,115,53,47,53,0,0,0,0,0,0,0,47,112,97,105,114,101,100,49,48,47,49,48,0,0,0,0,37,115,37,100,32,110,111,100,101,115,32,37,100,32,101,100,103,101,115,32,37,100,32,105,116,101,114,32,37,46,50,102,32,115,101,99,10,0,0,0,77,114,101,99,111,114,100,0,47,112,97,105,114,101,100,49,48,47,49,0,0,0,0,0,103,105,102,58,118,109,108,0,47,111,114,114,100,57,47,57,0,0,0,0,0,0,0,0,104,101,105,103,104,116,0,0,32,119,105,100,116,104,58,32,37,100,59,32,104,101,105,103,104,116,58,32,37,100,34,0,47,111,114,114,100,57,47,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,111,114,114,100,57,47,55,0,0,0,0,0,0,0,0,80,97,108,97,116,105,110,111,45,66,111,108,100,0,0,0,47,102,105,108,108,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,47,111,114,114,100,57,47,54,0,0,0,0,0,0,0,0,100,111,100,103,101,114,98,108,117,101,0,0,0,0,0,0,101,113,117,97,108,108,121,0,114,111,119,103,0,0,0,0,106,112,103,58,115,118,103,0,47,111,114,114,100,57,47,53,0,0,0,0,0,0,0,0,66,101,116,97,0,0,0,0,47,111,114,114,100,57,47,52,0,0,0,0,0,0,0,0,47,111,114,114,100,57,47,51,0,0,0,0,0,0,0,0,37,108,102,44,37,108,102,44,37,108,102,44,37,108,102,44,37,108,102,0,0,0,0,0,47,111,114,114,100,57,47,50,0,0,0,0,0,0,0,0,47,98,108,117,101,115,53,47,52,0,0,0,0,0,0,0,47,111,114,114,100,57,47,49,0,0,0,0,0,0,0,0,114,101,99,111,114,100,0,0,47,111,114,114,100,56,47,56,0,0,0,0,0,0,0,0,112,110,103,58,118,109,108,0,47,111,114,114,100,56,47,55,0,0,0,0,0,0,0,0,102,105,120,101,100,115,105,122,101,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,47,111,114,114,100,56,47,54,0,0,0,0,0,0,0,0,47,111,114,114,100,56,47,53,0,0,0,0,0,0,0,0,114,111,109,97,110,0,0,0,47,98,111,108,100,32,123,32,50,32,115,101,116,108,105,110,101,119,105,100,116,104,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,0,0,76,97,98,101,108,32,99,108,111,115,101,100,32,98,101,102,111,114,101,32,101,110,100,32,111,102,32,72,84,77,76,32,101,108,101,109,101,110,116,10,0,0,0,0,0,0,0,0,47,111,114,114,100,56,47,52,0,0,0,0,0,0,0,0,100,105,109,103,114,101,121,0,114,97,110,107,115,101,112,0,47,111,114,114,100,56,47,51,0,0,0,0,0,0,0,0,65,117,109,108,0,0,0,0,78,68,95,110,101,120,116,40,118,41,32,61,61,32,78,85,76,76,0,0,0,0,0,0,47,111,114,114,100,56,47,50,0,0,0,0,0,0,0,0,47,111,114,114,100,56,47,49,0,0,0,0,0,0,0,0,37,108,102,44,37,108,102,44,37,108,102,44,37,91,94,44,93,37,115,0,0,0,0,0,47,111,114,114,100,55,47,55,0,0,0,0,0,0,0,0,47,98,108,117,101,115,53,47,51,0,0,0,0,0,0,0,47,111,114,114,100,55,47,54,0,0,0,0,0,0,0,0,38,35,49,54,48,59,0,0,77,99,105,114,99,108,101,0,47,111,114,114,100,55,47,53,0,0,0,0,0,0,0,0,115,118,103,58,115,118,103,0,47,111,114,114,100,55,47,52,0,0,0,0,0,0,0,0,99,111,108,115,112,97,110,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,118,109,108,46,99,0,0,0,0,0,47,111,114,114,100,55,47,51,0,0,0,0,0,0,0,0,47,111,114,114,100,55,47,50,0,0,0,0,0,0,0,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,82,111,109,97,110,0,0,32,99,114,101,97,116,101,32,108,105,110,101,32,0,0,0,47,105,110,118,105,115,32,123,47,102,105,108,108,32,123,110,101,119,112,97,116,104,125,32,100,101,102,32,47,115,116,114,111,107,101,32,123,110,101,119,112,97,116,104,125,32,100,101,102,32,47,115,104,111,119,32,123,112,111,112,32,110,101,119,112,97,116,104,125,32,100,101,102,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,47,111,114,114,100,55,47,49,0,0,0,0,0,0,0,0,100,105,109,103,114,97,121,0,110,111,100,101,115,101,112,0,47,111,114,114,100,54,47,54,0,0,0,0,0,0,0,0,65,116,105,108,100,101,0,0,99,121,97,110,0,0,0,0,75,80,95,82,105,103,104,116,0,0,0,0,0,0,0,0,47,111,114,114,100,54,47,53,0,0,0,0,0,0,0,0,47,111,114,114,100,54,47,52,0,0,0,0,0,0,0,0,37,108,102,44,37,108,102,44,37,108,102,44,39,37,91,94,39,93,39,0,0,0,0,0,47,111,114,114,100,54,47,51,0,0,0,0,0,0,0,0,47,98,108,117,101,115,53,47,50,0,0,0,0,0,0,0,47,111,114,114,100,54,47,50,0,0,0,0,0,0,0,0,77,115,113,117,97,114,101,0,47,111,114,114,100,54,47,49,0,0,0,0,0,0,0,0,115,118,103,58,120,100,111,116,0,0,0,0,0,0,0,0,47,111,114,114,100,53,47,53,0,0,0,0,0,0,0,0,99,101,108,108,115,112,97,99,105,110,103,0,0,0,0,0,60,117,110,107,110,111,119,110,62,0,0,0,0,0,0,0,35,37,48,50,120,37,48,50,120,37,48,50,120,0,0,0,47,111,114,114,100,53,47,52,0,0,0,0,0,0,0,0,97,114,105,97,108,0,0,0,47,111,114,114,100,53,47,51,0,0,0,0,0,0,0,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,73,116,97,108,105,99,0,115,111,117,114,99,101,0,0,110,111,32,101,108,101,109,101,110,116,32,102,111,117,110,100,0,0,0,0,0,0,0,0,47,100,111,116,116,101,100,32,123,32,91,49,32,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,109,117,108,32,54,32,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,109,117,108,93,32,48,32,115,101,116,100,97,115,104,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,0,47,111,114,114,100,53,47,50,0,0,0,0,0,0,0,0,100,101,101,112,115,107,121,98,108,117,101,0,0,0,0,0,82,76,0,0,0,0,0,0,47,111,114,114,100,53,47,49,0,0,0,0,0,0,0,0,65,114,105,110,103,0,0,0,47,111,114,114,100,52,47,52,0,0,0,0,0,0,0,0,45,45,0,0,0,0,0,0,120,100,111,116,0,0,0,0,47,111,114,114,100,52,47,51,0,0,0,0,0,0,0,0,118,105,101,119,112,111,114,116,0,0,0,0,0,0,0,0,99,108,117,115,116,101,114,46,99,0,0,0,0,0,0,0,47,111,114,114,100,52,47,50,0,0,0,0,0,0,0,0,47,98,108,117,101,115,53,47,49,0,0,0,0,0,0,0,47,111,114,114,100,52,47,49,0,0,0,0,0,0,0,0,116,97,105,108,112,111,114,116,0,0,0,0,0,0,0,0,77,100,105,97,109,111,110,100,0,0,0,0,0,0,0,0,116,107,0,0,0,0,0,0,84,97,114,103,101,116,32,65,82,32,61,32,37,103,10,0,99,97,110,110,111,116,32,102,105,110,100,32,116,114,105,97,110,103,108,101,32,112,97,116,104,0,0,0,0,0,0,0,32,45,45,32,0,0,0,0,47,111,114,114,100,51,47,51,0,0,0,0,0,0,0,0,98,108,97,99,107,0,0,0,101,112,115,58,120,100,111,116,0,0,0,0,0,0,0,0,47,111,114,114,100,51,47,50,0,0,0,0,0,0,0,0,99,101,108,108,112,97,100,100,105,110,103,0,0,0,0,0,110,111,110,101,0,0,0,0,98,98,0,0,0,0,0,0,114,0,0,0,0,0,0,0,47,111,114,114,100,51,47,49,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,57,47,57,0,0,0,0,0,37,100,32,112,111,108,121,103,111,110,115,32,37,100,32,112,111,105,110,116,115,10,0,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,66,111,108,100,73,116,97,108,105,99,0,0,0,0,0,47,100,97,115,104,101,100,32,123,32,91,57,32,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,109,117,108,32,100,117,112,32,93,32,48,32,115,101,116,100,97,115,104,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,0,47,111,114,97,110,103,101,115,57,47,56,0,0,0,0,0,100,101,101,112,112,105,110,107,0,0,0,0,0,0,0,0,66,84,0,0,0,0,0,0,47,111,114,97,110,103,101,115,57,47,55,0,0,0,0,0,97,113,117,97,0,0,0,0,65,108,112,104,97,0,0,0,47,111,114,97,110,103,101,115,57,47,54,0,0,0,0,0,47,111,114,97,110,103,101,115,57,47,53,0,0,0,0,0,112,97,103,101,100,105,114,61,37,115,32,105,103,110,111,114,101,100,10,0,0,0,0,0,47,111,114,97,110,103,101,115,57,47,52,0,0,0,0,0,47,98,108,117,101,115,52,47,52,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,57,47,51,0,0,0,0,0,105,110,118,104,111,117,115,101,0,0,0,0,0,0,0,0,37,115,32,45,62,32,37,115,58,32,116,97,105,108,32,105,115,32,105,110,115,105,100,101,32,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,10,0,0,0,0,0,0,0,101,100,103,101,0,0,0,0,47,111,114,97,110,103,101,115,57,47,50,0,0,0,0,0])
.concat([112,115,58,120,100,111,116,0,47,111,114,97,110,103,101,115,57,47,49,0,0,0,0,0,98,111,114,100,101,114,0,0,34,32,47,62,0,0,0,0,47,111,114,97,110,103,101,115,56,47,56,0,0,0,0,0,47,111,114,97,110,103,101,115,56,47,55,0,0,0,0,0,67,101,110,116,117,114,121,32,83,99,104,111,111,108,98,111,111,107,32,76,0,0,0,0,40,78,68,95,85,70,95,115,105,122,101,40,110,41,32,60,61,32,49,41,32,124,124,32,40,110,32,61,61,32,108,101,97,100,101,114,41,0,0,0,112,114,101,102,105,120,32,109,117,115,116,32,110,111,116,32,98,101,32,98,111,117,110,100,32,116,111,32,111,110,101,32,111,102,32,116,104,101,32,114,101,115,101,114,118,101,100,32,110,97,109,101,115,112,97,99,101,32,110,97,109,101,115,0,47,115,111,108,105,100,32,123,32,91,93,32,48,32,115,101,116,100,97,115,104,32,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,56,47,54,0,0,0,0,0,108,111,97,100,105,109,97,103,101,0,0,0,0,0,0,0,76,82,0,0,0,0,0,0,100,97,114,107,118,105,111,108,101,116,0,0,0,0,0,0,37,115,32,119,104,105,108,101,32,111,112,101,110,105,110,103,32,37,115,10,0,0,0,0,47,111,114,97,110,103,101,115,56,47,53,0,0,0,0,0,71,111,105,110,103,32,116,111,32,97,112,112,108,121,32,97,110,111,116,104,101,114,32,101,120,112,97,110,115,105,111,110,46,10,0,0,0,0,0,0,58,0,0,0,0,0,0,0,47,115,101,116,117,112,76,97,116,105,110,49,32,123,0,0,65,103,114,97,118,101,0,0,47,111,114,97,110,103,101,115,56,47,52,0,0,0,0,0,100,111,116,116,101,100,0,0,47,111,114,97,110,103,101,115,56,47,51,0,0,0,0,0,114,101,110,100,101,114,101,114,32,102,111,114,32,37,115,32,105,115,32,117,110,97,118,97,105,108,97,98,108,101,10,0,47,111,114,97,110,103,101,115,56,47,50,0,0,0,0,0,47,98,108,117,101,115,52,47,51,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,56,47,49,0,0,0,0,0,105,110,118,116,114,97,112,101,122,105,117,109,0,0,0,0,47,111,114,97,110,103,101,115,55,47,55,0,0,0,0,0,95,37,100,0,0,0,0,0,106,112,103,58,120,100,111,116,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,55,47,54,0,0,0,0,0,98,103,99,111,108,111,114,0,34,32,100,97,115,104,115,116,121,108,101,61,34,100,111,116,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,55,47,53,0,0,0,0,0,41,10,0,0,0,0,0,0,47,111,114,97,110,103,101,115,55,47,52,0,0,0,0,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,66,111,108,100,0,0,0,114,101,115,101,114,118,101,100,32,112,114,101,102,105,120,32,40,120,109,108,110,115,41,32,109,117,115,116,32,110,111,116,32,98,101,32,100,101,99,108,97,114,101,100,32,111,114,32,117,110,100,101,99,108,97,114,101,100,0,0,0,0,0,0,37,32,115,116,121,108,101,115,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,55,47,51,0,0,0,0,0,100,101,118,105,99,101,0,0,114,97,110,107,100,105,114,0,100,97,114,107,116,117,114,113,117,111,105,115,101,0,0,0,47,111,114,97,110,103,101,115,55,47,50,0,0,0,0,0,65,99,105,114,99,0,0,0,47,111,114,97,110,103,101,115,55,47,49,0,0,0,0,0,47,111,114,97,110,103,101,115,54,47,54,0,0,0,0,0,108,97,121,111,117,116,32,119,97,115,32,110,111,116,32,100,111,110,101,10,0,0,0,0,100,105,97,109,111,110,100,0,47,111,114,97,110,103,101,115,54,47,53,0,0,0,0,0,47,98,108,117,101,115,52,47,50,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,54,47,52,0,0,0,0,0,105,110,118,116,114,105,97,110,103,108,101,0,0,0,0,0,47,111,114,97,110,103,101,115,54,47,51,0,0,0,0,0,50,48,0,0,0,0,0,0,106,112,101,58,120,100,111,116,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,54,47,50,0,0,0,0,0,98,97,108,105,103,110,0,0,34,32,100,97,115,104,115,116,121,108,101,61,34,100,97,115,104,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,54,47,49,0,0,0,0,0,32,40,0,0,0,0,0,0,47,111,114,97,110,103,101,115,53,47,53,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,79,98,108,105,113,117,101,0,0,0,0,0,0,0,114,101,115,101,114,118,101,100,32,112,114,101,102,105,120,32,40,120,109,108,41,32,109,117,115,116,32,110,111,116,32,98,101,32,117,110,100,101,99,108,97,114,101,100,32,111,114,32,98,111,117,110,100,32,116,111,32,97,110,111,116,104,101,114,32,110,97,109,101,115,112,97,99,101,32,110,97,109,101,0,32,32,32,32,32,32,32,115,99,97,108,101,0,0,0,0,47,111,114,97,110,103,101,115,53,47,52,0,0,0,0,0,116,101,120,116,108,97,121,111,117,116,0,0,0,0,0,0,113,117,97,110,116,117,109,0,100,97,114,107,115,108,97,116,101,103,114,101,121,0,0,0,47,111,114,97,110,103,101,115,53,47,51,0,0,0,0,0,65,97,99,117,116,101,0,0,47,111,114,97,110,103,101,115,53,47,50,0,0,0,0,0,47,111,114,97,110,103,101,115,53,47,49,0,0,0,0,0,76,97,121,111,117,116,32,119,97,115,32,110,111,116,32,100,111,110,101,46,32,32,77,105,115,115,105,110,103,32,108,97,121,111,117,116,32,112,108,117,103,105,110,115,63,32,10,0,47,111,114,97,110,103,101,115,52,47,52,0,0,0,0,0,47,98,108,117,101,115,52,47,49,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,52,47,51,0,0,0,0,0,116,114,105,112,108,101,111,99,116,97,103,111,110,0,0,0,47,111,114,97,110,103,101,115,52,47,50,0,0,0,0,0,49,57,0,0,0,0,0,0,106,112,101,103,58,120,100,111,116,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,52,47,49,0,0,0,0,0,60,84,68,62,0,0,0,0,34,32,119,101,105,103,104,116,61,34,37,46,48,102,112,116,0,0,0,0,0,0,0,0,47,111,114,97,110,103,101,115,51,47,51,0,0,0,0,0,32,118,101,114,115,105,111,110,32,0,0,0,0,0,0,0,71,68,95,114,97,110,107,40,103,41,91,114,93,46,110,32,60,61,32,71,68,95,114,97,110,107,40,103,41,91,114,93,46,97,110,0,0,0,0,0,47,111,114,97,110,103,101,115,51,47,50,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,45,79,98,108,105,113,117,101,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,115,117,115,112,101,110,100,32,105,110,32,101,120,116,101,114,110,97,108,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,0,0,0,0,0,32,32,32,32,32,32,32,100,117,112,32,49,32,101,120,99,104,32,100,105,118,32,47,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,101,120,99,104,32,100,101,102,0,0,47,111,114,97,110,103,101,115,51,47,49,0,0,0,0,0,100,101,115,116,105,110,97,116,105,111,110,32,112,111,105,110,116,32,110,111,116,32,105,110,32,97,110,121,32,116,114,105,97,110,103,108,101,0,0,0,108,97,121,111,117,116,0,0,71,68,70,79,78,84,80,65,84,72,61,0,0,0,0,0,100,97,114,107,115,108,97,116,101,103,114,97,121,0,0,0,47,103,114,101,121,115,57,47,57,0,0,0,0,0,0,0,65,69,108,105,103,0,0,0,47,103,114,101,121,115,57,47,56,0,0,0,0,0,0,0,47,97,99,99,101,110,116,51,47,50,0,0,0,0,0,0,47,103,114,101,121,115,57,47,55,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,114,101,110,100,101,114,0,0,47,103,114,101,121,115,57,47,54,0,0,0,0,0,0,0,47,98,108,117,101,115,51,47,51,0,0,0,0,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,44,32,115,116,97,116,101,109,101,110,116,32,115,107,105,112,112,101,100,0,47,103,114,101,121,115,57,47,53,0,0,0,0,0,0,0,100,111,117,98,108,101,111,99,116,97,103,111,110,0,0,0,47,103,114,101,121,115,57,47,52,0,0,0,0,0,0,0,49,56,0,0,0,0,0,0,103,105,102,58,120,100,111,116,0,0,0,0,0,0,0,0,105,109,97,112,58,109,97,112,0,0,0,0,0,0,0,0,47,103,114,101,121,115,57,47,51,0,0,0,0,0,0,0,37,115,32,118,97,108,117,101,32,37,115,32,60,32,37,100,32,45,32,116,111,111,32,115,109,97,108,108,32,45,32,105,103,110,111,114,101,100,0,0,60,118,58,115,116,114,111,107,101,32,99,111,108,111,114,61,34,0,0,0,0,0,0,0,47,103,114,101,121,115,57,47,50,0,0,0,0,0,0,0,35,32,71,101,110,101,114,97,116,101,100,32,98,121,32,0,47,103,114,101,121,115,57,47,49,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,45,66,111,108,100,79,98,108,105,113,117,101,0,0,0,0,112,97,114,115,105,110,103,32,102,105,110,105,115,104,101,100,0,0,0,0,0,0,0,0,32,50,10,0,0,0,0,0,47,103,114,101,121,115,56,47,56,0,0,0,0,0,0,0,78,68,95,114,97,110,107,40,102,114,111,109,41,32,60,32,78,68,95,114,97,110,107,40,116,111,41,0,0,0,0,0,68,79,84,70,79,78,84,80,65,84,72,0,0,0,0,0,81,0,0,0,0,0,0,0,100,97,114,107,115,108,97,116,101,98,108,117,101,0,0,0,47,103,114,101,121,115,56,47,55,0,0,0,0,0,0,0,98,122,46,115,105,122,101,0,47,115,101,116,95,115,99,97,108,101,32,123,0,0,0,0,101,112,115,102,0,0,0,0,47,103,114,101,121,115,56,47,54,0,0,0,0,0,0,0,47,103,114,101,121,115,56,47,53,0,0,0,0,0,0,0,117,110,109,97,116,99,104,101,100,32,39,40,39,32,105,110,32,115,116,121,108,101,58,32,37,115,10,0,0,0,0,0,105,110,32,114,111,117,116,101,115,112,108,105,110,101,115,44,32,99,97,110,110,111,116,32,102,105,110,100,32,78,79,82,77,65,76,32,101,100,103,101,10,0,0,0,0,0,0,0,47,103,114,101,121,115,56,47,52,0,0,0,0,0,0,0,47,98,108,117,101,115,51,47,50,0,0,0,0,0,0,0,47,103,114,101,121,115,56,47,51,0,0,0,0,0,0,0,37,100,32,0,0,0,0,0,100,111,117,98,108,101,99,105,114,99,108,101,0,0,0,0,47,103,114,101,121,115,56,47,50,0,0,0,0,0,0,0,49,55,0,0,0,0,0,0,112,110,103,58,120,100,111,116,0,0,0,0,0,0,0,0,47,103,114,101,121,115,56,47,49,0,0,0,0,0,0,0,37,115,32,118,97,108,117,101,32,37,115,32,62,32,37,100,32,45,32,116,111,111,32,108,97,114,103,101,32,45,32,105,103,110,111,114,101,100,0,0,60,47,118,58,115,104,97,112,101,62,10,0,0,0,0,0,47,103,114,101,121,115,55,47,55,0,0,0,0,0,0,0,32,80,97,103,101,115,58,32,37,100,10,0,0,0,0,0,47,103,114,101,121,115,55,47,54,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,45,66,111,108,100,0,0,0,112,97,114,115,105,110,103,32,97,98,111,114,116,101,100,0,85,115,105,110,103,32,37,115,58,32,37,115,58,37,115,10,0,0,0,0,0,0,0,0,49,50,48,48,0,0,0,0,47,103,114,101,121,115,55,47,53,0,0,0,0,0,0,0,102,111,110,116,112,97,116,104,0,0,0,0,0,0,0,0,100,97,114,107,115,101,97,103,114,101,101,110,0,0,0,0,37,100,0,0,0,0,0,0,106,112,101,58,115,118,103,0,47,103,114,101,121,115,55,47,52,0,0,0,0,0,0,0,120,109,108,0,0,0,0,0,115,112,108,105,110,101,115,0,47,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,49,46,48,32,100,101,102,0,34,32,110,97,109,101,61,34,0,0,0,0,0,0,0,0,47,103,114,101,121,115,55,47,51,0,0,0,0,0,0,0,47,103,114,101,121,115,55,47,50,0,0,0,0,0,0,0,116,114,117,110,99,97,116,105,110,103,32,115,116,121,108,101,32,39,37,115,39,10,0,0,47,103,114,101,121,115,55,47,49,0,0,0,0,0,0,0,47,98,108,117,101,115,51,47,49,0,0,0,0,0,0,0,47,103,114,101,121,115,54,47,54,0,0,0,0,0,0,0,115,113,117,97,114,101,0,0,47,103,114,101,121,115,54,47,53,0,0,0,0,0,0,0,49,54,0,0,0,0,0,0,115,118,103,58,100,111,116,0,47,103,114,101,121,115,54,47,52,0,0,0,0,0,0,0,73,109,112,114,111,112,101,114,32,37,115,32,118,97,108,117,101,32,37,115,32,45,32,105,103,110,111,114,101,100,0,0,34,47,62,0,0,0,0,0,47,103,114,101,121,115,54,47,51,0,0,0,0,0,0,0,32,84,105,116,108,101,58,32,0,0,0,0,0,0,0,0,47,103,114,101,121,115,54,47,50,0,0,0,0,0,0,0,99,111,110,100,101,110,115,101,100,0,0,0,0,0,0,0,112,97,114,115,101,114,32,110,111,116,32,115,117,115,112,101,110,100,101,100,0,0,0,0,45,50,10,0,0,0,0,0,47,103,114,101,121,115,54,47,49,0,0,0,0,0,0,0,45,45,0,0,0,0,0,0,115,118,103,0,0,0,0,0,100,97,114,107,115,97,108,109,111,110,0,0,0,0,0,0,47,103,114,101,121,115,53,47,53,0,0,0,0,0,0,0,60,63,120,109,108,0,0,0,85,110,107,110,111,119,110,32,34,115,112,108,105,110,101,115,34,32,118,97,108,117,101,58,32,34,37,115,34,32,45,32,105,103,110,111,114,101,100,10,0,0,0,0,0,0,0,0,47,99,111,111,114,100,102,111,110,116,32,99,111,111,114,100,45,102,111,110,116,45,102,97,109,105,108,121,32,102,105,110,100,102,111,110,116,32,56,32,115,99,97,108,101,102,111,110,116,32,100,101,102,0,0,0,60,109,97,112,32,105,100,61,34,0,0,0,0,0,0,0,47,103,114,101,121,115,53,47,52,0,0,0,0,0,0,0,117,32,33,61,32,118,0,0,47,103,114,101,121,115,53,47,51,0,0,0,0,0,0,0,117,110,109,97,116,99,104,101,100,32,39,41,39,32,105,110,32,115,116,121,108,101,58,32,37,115,10,0,0,0,0,0,47,103,114,101,121,115,53,47,50,0,0,0,0,0,0,0,47,97,99,99,101,110,116,56,47,56,0,0,0,0,0,0,47,103,114,101,121,115,53,47,49,0,0,0,0,0,0,0,38,35,52,53,59,0,0,0,114,101,99,116,97,110,103,108,101,0,0,0,0,0,0,0,47,103,114,101,121,115,52,47,52,0,0,0,0,0,0,0,49,53,0,0,0,0,0,0,101,112,115,58,100,111,116,0,47,103,114,101,121,115,52,47,51,0,0,0,0,0,0,0,80,79,73,78,84,45,83,73,90,69,0,0,0,0,0,0,32,101,32,0,0,0,0,0,47,103,114,101,121,115,52,47,50,0,0,0,0,0,0,0,35,0,0,0,0,0,0,0,47,103,114,101,121,115,52,47,49,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,112,97,114,115,101,114,32,115,117,115,112,101,110,100,101,100,0,0,0,0,0,0,0,0,83,105,110,103,108,101,10,0,47,103,114,101,121,115,51,47,51,0,0,0,0,0,0,0,58,0,0,0,0,0,0,0,112,115,0,0,0,0,0,0,100,97,114,107,114,101,100,0,47,103,114,101,121,115,51,47,50,0,0,0,0,0,0,0,102,111,110,116,110,97,109,101,58,32,34,37,115,34,32,114,101,115,111,108,118,101,100,32,116,111,58,32,37,115,10,0,101,112,115,0,0,0,0,0,101,115,0,0,0,0,0,0,47,100,101,102,97,117,108,116,45,102,111,110,116,45,102,97,109,105,108,121,32,47,84,105,109,101,115,45,82,111,109,97,110,32,100,101,102,0,0,0,32,0,0,0,0,0,0,0,47,103,114,101,121,115,51,47,49,0,0,0,0,0,0,0,98,108,117,101,0,0,0,0,82,105,103,104,116,0,0,0,47,103,114,101,101,110,115,57,47,57,0,0,0,0,0,0,110,101,115,116,105,110,103,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,115,116,121,108,101,58,32,37,115,10,0,0,0,0,0,0,0,47,103,114,101,101,110,115,57,47,56,0,0,0,0,0,0,47,97,99,99,101,110,116,56,47,55,0,0,0,0,0,0,47,103,114,101,101,110,115,57,47,55,0,0,0,0,0,0,114,101,99,116,0,0,0,0,49,48,48,46,48,48,10,0,47,103,114,101,101,110,115,57,47,54,0,0,0,0,0,0,49,52,0,0,0,0,0,0,112,115,58,100,111,116,0,0,47,103,114,101,101,110,115,57,47,53,0,0,0,0,0,0,112,111,105,110,116,45,115,105,122,101,0,0,0,0,0,0,32,108,32,0,0,0,0,0,47,103,114,101,101,110,115,57,47,52,0,0,0,0,0,0,32,45,97,110,99,104,111,114,32,101,0,0,0,0,0,0,91,105,110,116,101,114,110,97,108,32,99,111,117,114,105,101,114,93,0,0,0,0,0,0,37,115,58,37,100,58,32,37,115,32,110,101,97,114,32,108,105,110,101,32,37,100,10,0,47,103,114,101,101,110,115,57,47,51,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,66,111,108,100,79,98,108,105,113,117,101,0,0,0,105,108,108,101,103,97,108,32,99,104,97,114,97,99,116,101,114,40,115,41,32,105,110,32,112,117,98,108,105,99,32,105,100,0,0,0,0,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,47,103,114,101,101,110,115,57,47,50,0,0,0,0,0,0,102,105,103,0,0,0,0,0,111,117,116,32,111,102,32,109,101,109,111,114,121,10,0,0,37,100,0,0,0,0,0,0,103,100,0,0,0,0,0,0,100,97,114,107,111,114,99,104,105,100,0,0,0,0,0,0,114,97,110,107,0,0,0,0,47,103,114,101,101,110,115,57,47,49,0,0,0,0,0,0,197,208,211,198,0,0,0,0,114,117,101,0,0,0,0,0,47,99,111,111,114,100,45,102,111,110,116,45,102,97,109,105,108,121,32,47,84,105,109,101,115,45,82,111,109,97,110,32,100,101,102,0,0,0,0,0,100,101,102,97,117,108,116,32,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,56,47,56,0,0,0,0,0,0,45,62,0,0,0,0,0,0,100,111,116,0,0,0,0,0,47,103,114,101,101,110,115,56,47,55,0,0,0,0,0,0,108,105,103,104,116,103,114,101,121,0,0,0,0,0,0,0,69,68,95,116,111,95,118,105,114,116,40,111,114,105,103,41,32,33,61,32,78,85,76,76,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,56,47,54,0,0,0,0,0,0,47,97,99,99,101,110,116,56,47,54,0,0,0,0,0,0,47,103,114,101,101,110,115,56,47,53,0,0,0,0,0,0,107,101,121,0,0,0,0,0,99,111,109,112,111,110,101,110,116,0,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,111,112,115,0,0,0,0,0,0,47,103,114,101,101,110,115,56,47,52,0,0,0,0,0,0,76,101,116,116,101,114,10,0,115,111,108,105,100,0,0,0,49,51,0,0,0,0,0,0,106,112,103,58,100,111,116,0,37,108,102,44,37,100,0,0,32,45,62,32,0,0,0,0,47,103,114,101,101,110,115,56,47,51,0,0,0,0,0,0,102,97,99,101,0,0,0,0,37,46,48,102,44,37,46,48,102,32,0,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,0,0,0,0,0,99,97,110,39,116,32,102,105,110,100,32,108,105,98,114,97,114,121,32,102,105,108,101,32,37,115,10,0,0,0,0,0,47,103,114,101,101,110,115,56,47,50,0,0,0,0,0,0,32,45,97,110,99,104,111,114,32,119,0,0,0,0,0,0,47,103,114,101,101,110,115,56,47,49,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,45,66,111,108,100,0,0,116,101,120,116,32,100,101,99,108,97,114,97,116,105,111,110,32,110,111,116,32,119,101,108,108,45,102,111,114,109,101,100,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,55,47,55,0,0,0,0,0,0,37,115,37,100,32,45,0,0,37,100,32,111,112,115,32,37,46,50,102,32,115,101,99,10,0,0,0,0,0,0,0,0,37,46,53,103,44,37,46,53,103,44,37,46,53,103,44,37,46,53,103,32,0,0,0,0,110,111,110,101,0,0,0,0,100,97,114,107,111,114,97,110,103,101,0,0,0,0,0,0,103,118,119,114,105,116,101,95,110,111,95,122,32,112,114,111,98,108,101,109,32,37,100,10,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,55,47,54,0,0,0,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,0,0,0,0,112,100,102,0,0,0,0,0,112,108,105,110,101,0,0,0,37,37,66,101,103,105,110,82,101,115,111,117,114,99,101,58,32,112,114,111,99,115,101,116,32,103,114,97,112,104,118,105,122,32,48,32,48,0,0,0,98,97,115,101,32,114,101,102,101,114,101,114,10,0,0,0,47,103,114,101,101,110,115,55,47,53,0,0,0,0,0,0,47,103,114,101,101,110,115,55,47,52,0,0,0,0,0,0,98,108,97,99,107,0,0,0,47,103,114,101,101,110,115,55,47,51,0,0,0,0,0,0,47,97,99,99,101,110,116,56,47,53,0,0,0,0,0,0,47,103,114,101,101,110,115,55,47,50,0,0,0,0,0,0,98,111,120,51,100,0,0,0,47,103,114,101,101,110,115,55,47,49,0,0,0,0,0,0,73,110,99,104,101,115,10,0,49,50,0,0,0,0,0,0,106,112,101,58,100,111,116,0,37,115,32,45,62,32,37,115,58,32,104,101,97,100,32,110,111,116,32,105,110,115,105,100,101,32,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,10,0,0,0,0,0,0,110,111,100,101,0,0,0,0,47,103,114,101,101,110,115,54,47,54,0,0,0,0,0,0,99,111,108,111,114,0,0,0,32,109,32,0,0,0,0,0,47,103,114,101,101,110,115,54,47,53,0,0,0,0,0,0,32,37,100,125,0,0,0,0,47,103,114,101,101,110,115,54,47,52,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,108,101,97,100,101,114,32,33,61,32,78,85,76,76,0,0,88,77,76,32,100,101,99,108,97,114,97,116,105,111,110,32,110,111,116,32,119,101,108,108,45,102,111,114,109,101,100,0,95,116,108,100,114,97,119,95,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,54,47,51,0,0,0,0,0,0,37,46,53,103,44,37,46,53,103,44,37,46,53,103,44,37,46,53,103,0,0,0,0,0,103,108,111,98,97,108,0,0,108,97,121,111,117,116,0,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,0,0,114,0,0,0,0,0,0,0,47,103,114,101,101,110,115,54,47,50,0,0,0,0,0,0,68,117,109,109,121,61,37,100,10,0,0,0,0,0,0,0,102,105,108,101,32,108,111,97,100,105,110,103,32,105,115,32,100,105,115,97,98,108,101,100,32,98,101,99,97,117,115,101,32,116,104,101,32,101,110,118,105,114,111,110,109,101,110,116,32,99,111,110,116,97,105,110,115,32,83,69,82,86,69,82,95,78,65,77,69,61,34,37,115,34,110,97,110,100,32,116,104,101,114,101,32,105,115,32,110,111,32,71,86,95,70,73,76,69,95,80,65,84,72,32,118,97,114,105,97,98,108,101,32,115,101,116,46,10,0,0,37,80,68,70,45,0,0,0,0,0,0,0,0,0,0,0,111,108,121,108,105,110,101,0,125,32,98,105,110,100,32,100,101,102,0,0,0,0,0,0,60,47,109,97,112,62,10,0,47,103,114,101,101,110,115,54,47,49,0,0,0,0,0,0,100,97,115,104,101,100,0,0,47,103,114,101,101,110,115,53,47,53,0,0,0,0,0,0,98,103,99,111,108,111,114,0,47,103,114,101,101,110,115,53,47,52,0,0,0,0,0,0,47,97,99,99,101,110,116,56,47,52,0,0,0,0,0,0,47,103,114,101,101,110,115,53,47,51,0,0,0,0,0,0,102,111,108,100,101,114,0,0,47,103,114,101,101,110,115,53,47,50,0,0,0,0,0,0,67,101,110,116,101,114,10,0,49,49,0,0,0,0,0,0,106,112,101,103,58,100,111,116,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,53,47,49,0,0,0,0,0,0,60,70,79,78,84,62,0,0,60,118,58,112,97,116,104,32,118,61,34,0,0,0,0,0,47,103,114,101,101,110,115,52,47,52,0,0,0,0,0,0,34,0,0,0,0,0,0,0,47,103,114,101,101,110,115,52,47,51,0,0,0,0,0,0,67,111,117,114,105,101,114,45,79,98,108,105,113,117,101,0,105,110,99,111,109,112,108,101,116,101,32,109,97,114,107,117,112,32,105,110,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,0,0,0,95,104,108,100,114,97,119,95,0,0,0,0,0,0,0,0,47,103,114,101,101,110,115,52,47,50,0,0,0,0,0,0,37,100,32,37,100,32,0,0,108,111,99,97,108,0,0,0,100,97,114,107,109,97,103,101,110,116,97,0,0,0,0,0,99,111,114,101,0,0,0,0,47,103,114,101,101,110,115,52,47,49,0,0,0,0,0,0,100,111,116,95,108,97,121,111,117,116,0,0,0,0,0,0,105,110,32,108,97,98,101,108,32,111,102,32,103,114,97,112,104,32,37,115,10,0,0,0,106,112,101,103,0,0,0,0,114,116,104,111,0,0,0,0,99,108,101,97,114,116,111,109,97,114,107,0,0,0,0,0,47,103,114,101,101,110,115,51,47,51,0,0,0,0,0,0,34,62,10,0,0,0,0,0,47,103,114,101,101,110,115,51,47,50,0,0,0,0,0,0,102,105,108,108,99,111,108,111,114,0,0,0,0,0,0,0,98,111,120,0,0,0,0,0,47,103,114,101,101,110,115,51,47,49,0,0,0,0,0,0,47,97,99,99,101,110,116,56,47,51,0,0,0,0,0,0,47,103,110,98,117,57,47,57,0,0,0,0,0,0,0,0,116,97,98,0,0,0,0,0,47,103,110,98,117,57,47,56,0,0,0,0,0,0,0,0,80,111,114,116,114,97,105,116,10,0,0,0,0,0,0,0,49,48,0,0,0,0,0,0,103,105,102,58,100,111,116,0,47,103,110,98,117,57,47,55,0,0,0,0,0,0,0,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,65,76,73,71,78,32,45,32,105,103,110,111,114,101,100,10,0,0,0,47,103,110,98,117,57,47,54,0,0,0,0,0,0,0,0,32,119,105,100,116,104,58,32,37,100,59,32,104,101,105,103,104,116,58,32,37,100,34,32,102,105,108,108,101,100,61,34,102,97,108,115,101,34,62,0,32,45,102,111,110,116,32,123,0,0,0,0,0,0,0,0,47,103,110,98,117,57,47,53,0,0,0,0,0,0,0,0,67,111,117,114,105,101,114,45,66,111,108,100,79,98,108,105,113,117,101,0,0,0,0,0,109,117,115,116,32,110,111,116,32,117,110,100,101,99,108,97,114,101,32,112,114,101,102,105,120,0,0,0,0,0,0,0,47,103,110,98,117,57,47,52,0,0,0,0,0,0,0,0,95,116,100,114,97,119,95,0,100,111,116,115,112,108,105,110,101,115,46,99,0,0,0,0,99,111,109,98,105,65,82,32,61,32,37,108,102,10,0,0,101,44,37,46,53,103,44,37,46,53,103,32,0,0,0,0,100,105,103,114,97,112,104,0,100,97,114,107,107,104,97,107,105,0,0,0,0,0,0,0,47,103,110,98,117,57,47,51,0,0,0,0,0,0,0,0,255,216,255,224,0,0,0,0,111,0,0,0,0,0,0,0,47,67,111,117,114,105,101,114,45,66,111,108,100,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,0,47,103,110,98,117,57,47,50,0,0,0,0,0,0,0,0,34,47,62,10,0,0,0,0,47,103,110,98,117,57,47,49,0,0,0,0,0,0,0,0,110,97,109,101,0,0,0,0,112,101,110,99,111,108,111,114,0,0,0,0,0,0,0,0,47,103,110,98,117,56,47,56,0,0,0,0,0,0,0,0,122,119,110,106,0,0,0,0,47,97,99,99,101,110,116,56,47,50,0,0,0,0,0,0,47,103,110,98,117,56,47,55,0,0,0,0,0,0,0,0,122,119,106,0,0,0,0,0,110,111,116,101,0,0,0,0,47,103,110,98,117,56,47,54,0,0,0,0,0,0,0,0,122,101,116,97,0,0,0,0,35,32,80,97,103,101,115,58,32,37,100,10,0,0,0,0,57,0,0,0,0,0,0,0,112,110,103,58,100,111,116,0,47,103,110,98,117,56,47,53,0,0,0,0,0,0,0,0,121,117,109,108,0,0,0,0,69,78,84,69,82,0,0,0,47,103,110,98,117,56,47,52,0,0,0,0,0,0,0,0,32,60,118,58,115,104,97,112,101,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,0,0,0,0,121,101,110,0,0,0,0,0,125,0,0,0,0,0,0,0,47,103,110,98,117,56,47,51,0,0,0,0,0,0,0,0,121,97,99,117,116,101,0,0,67,111,117,114,105,101,114,45,66,111,108,100,0,0,0,0,117,110,98,111,117,110,100,32,112,114,101,102,105,120,0,0,109,105,110,99,114,111,115,115,46,99,0,0,0,0,0,0,47,103,110,98,117,56,47,50,0,0,0,0,0,0,0,0,95,104,100,114,97,119,95,0,120,105,0,0,0,0,0,0,9,37,112,32,37,115,44,37,115,10,0,0,0,0,0,0,115,44,37,46,53,103,44,37,46,53,103,32,0,0,0,0,103,114,97,112,104,0,0,0,100,97,114,107,103,114,101,121,0,0,0,0,0,0,0,0,47,103,110,98,117,56,47,49,0,0,0,0,0,0,0,0,119,101,105,101,114,112,0,0,103,105,102,0,0,0,0,0,111,110,101,0,0,0,0,0,47,67,111,117,114,105,101,114,45,66,111,108,100,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,47,103,110,98,117,55,47,55,0,0,0,0,0,0,0,0,44,37,100,44,37,100,0,0,117,117,109,108,0,0,0,0,47,97,99,99,101,110,116,51,47,49,0,0,0,0,0,0,71,68,95,109,105,110,114,97,110,107,40,103,41,32,61,61,32,48,0,0,0,0,0,0,47,103,110,98,117,55,47,54,0,0,0,0,0,0,0,0,80,45,62,101,110,100,46,116,104,101,116,97,32,60,32,50,32,42,32,77,95,80,73,0,117,112,115,105,108,111,110,0,99,111,108,111,114,0,0,0,47,103,110,98,117,55,47,53,0,0,0,0,0,0,0,0,117,112,115,105,104,0,0,0,47,97,99,99,101,110,116,56,47,49,0,0,0,0,0,0,47,103,110,98,117,55,47,52,0,0,0,0,0,0,0,0,117,109,108,0,0,0,0,0,111,99,116,97,103,111,110,0,116,114,117,101,0,0,0,0,47,103,110,98,117,55,47,51,0,0,0,0,0,0,0,0,117,103,114,97,118,101,0,0,56,0,0,0,0,0,0,0,115,118,103,58,109,97,112,0,35,32,84,105,116,108,101,58,32,37,115,10,0,0,0,0,47,103,110,98,117,55,47,50,0,0,0,0,0,0,0,0,117,99,105,114,99,0,0,0,69,70,84,0,0,0,0,0,99,109,97,112,58,109,97,112,0,0,0,0,0,0,0,0,47,103,110,98,117,55,47,49,0,0,0,0,0,0,0,0,32,45,45,62,10,0,0,0,117,97,114,114,0,0,0,0,97,103,105,110,105,116,40,41,32,99,97,108,108,101,100,32,109,117,108,116,105,112,108,121,32,119,105,116,104,32,105,110,99,111,110,115,105,115,116,101,110,116,32,97,114,103,115,10,0,0,0,0,0,0,0,0,32,45,116,101,120,116,32,123,0,0,0,0,0,0,0,0,47,103,110,98,117,54,47,54,0,0,0,0,0,0,0,0,117,97,99,117,116,101,0,0,109,111,110,111,115,112,97,99,101,0,0,0,0,0,0,0,99,97,110,110,111,116,32,99,104,97,110,103,101,32,115,101,116,116,105,110,103,32,111,110,99,101,32,112,97,114,115,105,110,103,32,104,97,115,32,98,101,103,117,110,0,0,0,0,47,103,110,98,117,54,47,53,0,0,0,0,0,0,0,0,95,108,100,114,97,119,95,0,117,65,114,114,0,0,0,0,115,111,117,114,99,101,32,112,111,105,110,116,32,110,111,116,32,105,110,32,97,110,121,32,116,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,37,46,53,103,32,37,46,53,103,0,0,0,0,0,0,0,115,117,98,103,114,97,112,104,0,0,0,0,0,0,0,0,100,97,114,107,103,114,101,101,110,0,0,0,0,0,0,0,47,103,110,98,117,54,47,52,0,0,0,0,0,0,0,0,116,114,97,100,101,0,0,0,71,73,70,56,0,0,0,0,105,110,101,0,0,0,0,0,47,67,111,117,114,105,101,114,45,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,103,110,98,117,54,47,51,0,0,0,0,0,0,0,0,115,104,97,112,101,102,105,108,101,0,0,0,0,0,0,0,37,100,44,37,100,0,0,0,116,105,109,101,115,0,0,0,47,103,110,98,117,54,47,50,0,0,0,0,0,0,0,0,116,105,108,100,101,0,0,0,35,102,56,102,56,102,56,0,99,97,110,110,111,116,32,114,101,45,97,108,108,111,99,97,116,101,32,112,115,10,0,0,47,103,110,98,117,54,47,49,0,0,0,0,0,0,0,0,108,111,115,116,32,37,115,32,37,115,32,101,100,103,101,10,0,0,0,0,0,0,0,0,116,104,111,114,110,0,0,0,47,97,99,99,101,110,116,55,47,55,0,0,0,0,0,0,47,103,110,98,117,53,47,53,0,0,0,0,0,0,0,0,116,104,105,110,115,112,0,0,115,101,97,114,99,104,115,105,122,101,0,0,0,0,0,0,115,101,112,116,97,103,111,110,0,0,0,0,0,0,0,0,47,103,110,98,117,53,47,52,0,0,0,0,0,0,0,0,116,104,101,116,97,115,121,109,0,0,0,0,0,0,0,0,103,114,97,112,104,32,0,0,55,0,0,0,0,0,0,0,101,112,115,58,109,97,112,0,35,32,71,101,110,101,114,97,116,101,100,32,98,121,32,37,115,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,10,0,0,0,0,0,0,47,103,110,98,117,53,47,51,0,0,0,0,0,0,0,0,116,104,101,116,97,0,0,0,73,71,72,84,0,0,0,0,47,103,110,98,117,53,47,50,0,0,0,0,0,0,0,0,32,32,32,32,32,32,60,33,45,45,32,0,0,0,0,0,116,104,101,114,101,52,0,0,32,99,114,101,97,116,101,32,116,101,120,116,32,0,0,0,47,103,110,98,117,53,47,49,0,0,0,0,0,0,0,0,116,97,117,0,0,0,0,0,67,111,117,114,105,101,114,0,114,101,113,117,101,115,116,101,100,32,102,101,97,116,117,114,101,32,114,101,113,117,105,114,101,115,32,88,77,76,95,68,84,68,32,115,117,112,112,111,114,116,32,105,110,32,69,120,112,97,116,0,0,0,0,0,47,103,110,98,117,52,47,52,0,0,0,0,0,0,0,0,49,46,50,0,0,0,0,0,115,122,108,105,103,0,0,0,37,115,32,119,97,115,32,97,108,114,101,97,100,121,32,105,110,32,97,32,114,97,110,107,115,101,116,44,32,100,101,108,101,116,101,100,32,102,114,111,109,32,99,108,117,115,116,101,114,32,37,115,10,0,0,0,115,97,109,112,108,101,112,111,105,110,116,115,0,0,0,0,110,111,100,101,0,0,0,0,37,108,102,0,0,0,0,0,100,97,114,107,103,114,97,121,0,0,0,0,0,0,0,0,47,103,110,98,117,52,47,51,0,0,0,0,0,0,0,0,98,108,97,99,107,0,0,0,115,117,112,101,0,0,0,0,106,112,101,103,58,115,118,103,0,0,0,0,0,0,0,0,98,109,112,0,0,0,0,0,97,108,115,101,0,0,0,0,47,67,111,117,114,105,101,114,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,115,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,47,103,110,98,117,52,47,50,0,0,0,0,0,0,0,0,37,100,44,37,100,44,37,100,44,37,100,0,0,0,0,0,115,117,112,51,0,0,0,0,47,103,110,98,117,52,47,49,0,0,0,0,0,0,0,0,115,117,112,50,0,0,0,0,35,49,48,49,48,49,48,0,47,103,110,98,117,51,47,51,0,0,0,0,0,0,0,0,115,117,112,49,0,0,0,0,47,97,99,99,101,110,116,55,47,54,0,0,0,0,0,0,47,103,110,98,117,51,47,50,0,0,0,0,0,0,0,0,115,117,112,0,0,0,0,0,104,101,120,97,103,111,110,0,47,103,110,98,117,51,47,49,0,0,0,0,0,0,0,0,115,117,109,0,0,0,0,0,54,0,0,0,0,0,0,0,112,115,58,109,97,112,0,0,35,70,73,71,32,51,46,50,10,0,0,0,0,0,0,0,47,100,97,114,107,50,56,47,56,0,0,0,0,0,0,0,115,117,98,101,0,0,0,0,97,108,105,103,110,0,0,0,47,100,97,114,107,50,56,47,55,0,0,0,0,0,0,0,121,101,108,108,111,119,0,0,115,117,98,0,0,0,0,0,32,99,114,101,97,116,101,32,111,118,97,108,32,0,0,0,47,100,97,114,107,50,56,47,54,0,0,0,0,0,0,0,115,112,97,100,101,115,0,0,66,111,111,107,109,97,110,45,76,105,103,104,116,73,116,97,108,105,99,0,0,0,0,0,101,110,116,105,116,121,32,100,101,99,108,97,114,101,100,32,105,110,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,0,0,0,0,0,47,100,97,114,107,50,56,47,53,0,0,0,0,0,0,0,120,100,111,116,118,101,114,115,105,111,110,0,0,0,0,0,115,105,109,0,0,0,0,0,60,47,72,84,77,76,62,0,114,101,99,111,114,100,0,0,101,100,103,101,0,0,0,0,100,97,114,107,103,111,108,100,101,110,114,111,100,0,0,0,47,100,97,114,107,50,56,47,52,0,0,0,0,0,0,0,115,105,103,109,97,102,0,0,66,77,0,0,0,0,0,0,111,109,112,111,117,110,100,0,47,72,101,108,118,101,116,105,99,97,45,66,111,108,100,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,47,100,97,114,107,50,56,47,51,0,0,0,0,0,0,0,37,100,44,37,100,44,37,100,0,0,0,0,0,0,0,0,115,105,103,109,97,0,0,0,47,100,97,114,107,50,56,47,50,0,0,0,0,0,0,0,115,104,121,0,0,0,0,0,35,102,48,102,48,102,48,0,32,99,111,111,114,100,115,61,34,0,0,0,0,0,0,0,108,97,98,101,108,0,0,0,115,104,97,112,101,102,105,108,101,0,0,0,0,0,0,0,47,37,115,47,37,115,0,0,88,49,49,47,0,0,0,0,105,103,104,116,103,114,101,121,0,0,0,0,0,0,0,0,104,105,116,101,0,0,0,0,108,97,99,107,0,0,0,0,110,32,33,61,32,78,68,95,110,101,120,116,40,110,41,0,121,101,108,108,111,119,103,114,101,101,110,0,0,0,0,0,47,100,97,114,107,50,56,47,49,0,0,0,0,0,0,0,121,101,108,108,111,119,52,0,121,101,108,108,111,119,51,0,115,101,99,116,0,0,0,0,121,101,108,108,111,119,50,0,121,101,108,108,111,119,49,0,121,101,108,108,111,119,0,0,119,104,105,116,101,115,109,111,107,101,0,0,0,0,0,0,119,104,105,116,101,0,0,0,119,104,101,97,116,52,0,0,47,97,99,99,101,110,116,55,47,53,0,0,0,0,0,0,119,104,101,97,116,51,0,0,119,104,101,97,116,50,0,0,47,100,97,114,107,50,55,47,55,0,0,0,0,0,0,0,119,104,101,97,116,49,0,0,119,104,101,97,116,0,0,0,115,100,111,116,0,0,0,0,118,105,111,108,101,116,114,101,100,52,0,0,0,0,0,0,118,105,111,108,101,116,114,101,100,51,0,0,0,0,0,0,118,105,111,108,101,116,114,101,100,50,0,0,0,0,0,0,118,105,111,108,101,116,114,101,100,49,0,0,0,0,0,0,118,105,111,108,101,116,114,101,100,0,0,0,0,0,0,0,38,103,116,59,0,0,0,0,118,105,111,108,101,116,0,0,112,101,110,116,97,103,111,110,0,0,0,0,0,0,0,0,116,117,114,113,117,111,105,115,101,52,0,0,0,0,0,0,116,117,114,113,117,111,105,115,101,51,0,0,0,0,0,0,47,100,97,114,107,50,55,47,54,0,0,0,0,0,0,0,116,117,114,113,117,111,105,115,101,50,0,0,0,0,0,0,116,117,114,113,117,111,105,115,101,49,0,0,0,0,0,0,115,99,97,114,111,110,0,0,116,117,114,113,117,111,105,115,101,0,0,0,0,0,0,0,116,114,97,110,115,112,97,114,101,110,116,0,0,0,0,0,115,98,113,117,111,0,0,0,116,111,109,97,116,111,52,0,116,111,109,97,116,111,51,0,116,111,109,97,116,111,50,0,53,0,0,0,0,0,0,0,106,112,103,58,109,97,112,0,116,111,109,97,116,111,49,0,116,111,109,97,116,111,0,0,116,104,105,115,116,108,101,52,0,0,0,0,0,0,0,0,35,32,101,110,100,32,111,102,32,70,73,71,32,102,105,108,101,10,0,0,0,0,0,0,47,100,97,114,107,50,55,47,53,0,0,0,0,0,0,0,116,104,105,115,116,108,101,51,0,0,0,0,0,0,0,0,116,104,105,115,116,108,101,50,0,0,0,0,0,0,0,0,35,101,48,101,48,101,48,0,116,104,105,115,116,108,101,49,0,0,0,0,0,0,0,0,116,104,105,115,116,108,101,0,116,97,110,52,0,0,0,0,116,97,110,51,0,0,0,0,60,66,82,62,0,0,0,0,116,97,110,50,0,0,0,0,116,97,110,49,0,0,0,0,116,97,110,0,0,0,0,0,115,116,101,101,108,98,108,117,101,52,0,0,0,0,0,0,47,100,97,114,107,50,55,47,52,0,0,0,0,0,0,0,115,116,101,101,108,98,108,117,101,51,0,0,0,0,0,0,119,104,105,116,101,0,0,0,115,116,101,101,108,98,108,117,101,50,0,0,0,0,0,0,114,115,113,117,111,0,0,0,115,116,101,101,108,98,108,117,101,49,0,0,0,0,0,0,115,116,101,101,108,98,108,117,101,0,0,0,0,0,0,0,115,112,114,105,110,103,103,114,101,101,110,52,0,0,0,0,115,112,114,105,110,103,103,114,101,101,110,51,0,0,0,0])
.concat([32,45,111,117,116,108,105,110,101,32,0,0,0,0,0,0,115,112,114,105,110,103,103,114,101,101,110,50,0,0,0,0,115,112,114,105,110,103,103,114,101,101,110,49,0,0,0,0,115,112,114,105,110,103,103,114,101,101,110,0,0,0,0,0,115,110,111,119,52,0,0,0,47,100,97,114,107,50,55,47,51,0,0,0,0,0,0,0,115,110,111,119,51,0,0,0,115,110,111,119,50,0,0,0,114,115,97,113,117,111,0,0,115,110,111,119,49,0,0,0,115,110,111,119,0,0,0,0,115,108,97,116,101,103,114,101,121,0,0,0,0,0,0,0,108,105,103,104,116,0,0,0,115,108,97,116,101,103,114,97,121,52,0,0,0,0,0,0,115,108,97,116,101,103,114,97,121,51,0,0,0,0,0,0,115,108,97,116,101,103,114,97,121,50,0,0,0,0,0,0,117,110,101,120,112,101,99,116,101,100,32,112,97,114,115,101,114,32,115,116,97,116,101,32,45,32,112,108,101,97,115,101,32,115,101,110,100,32,97,32,98,117,103,32,114,101,112,111,114,116,0,0,0,0,0,0,35,32,0,0,0,0,0,0,115,108,97,116,101,103,114,97,121,49,0,0,0,0,0,0,115,108,97,116,101,103,114,97,121,0,0,0,0,0,0,0,47,100,97,114,107,50,55,47,50,0,0,0,0,0,0,0,115,108,97,116,101,98,108,117,101,52,0,0,0,0,0,0,95,100,114,97,119,95,0,0,115,108,97,116,101,98,108,117,101,51,0,0,0,0,0,0,114,108,109,0,0,0,0,0,115,108,97,116,101,98,108,117,101,50,0,0,0,0,0,0,115,108,97,116,101,98,108,117,101,49,0,0,0,0,0,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,111,112,115,0,0,0,0,0,0,0,115,108,97,116,101,98,108,117,101,0,0,0,0,0,0,0,37,46,53,103,0,0,0,0,115,107,121,98,108,117,101,52,0,0,0,0,0,0,0,0,116,97,105,108,112,111,114,116,0,0,0,0,0,0,0,0,108,97,98,101,108,0,0,0,115,107,121,98,108,117,101,51,0,0,0,0,0,0,0,0,115,107,121,98,108,117,101,50,0,0,0,0,0,0,0,0,100,97,114,107,99,121,97,110,0,0,0,0,0,0,0,0,115,107,121,98,108,117,101,49,0,0,0,0,0,0,0,0,115,107,121,98,108,117,101,0,47,100,97,114,107,50,55,47,49,0,0,0,0,0,0,0,115,105,101,110,110,97,52,0,115,105,101,110,110,97,51,0,114,104,111,0,0,0,0,0,115,105,101,110,110,97,50,0,115,105,101,110,110,97,49,0,115,105,101,110,110,97,0,0,115,101,97,115,104,101,108,108,52,0,0,0,0,0,0,0,115,101,97,115,104,101,108,108,51,0,0,0,0,0,0,0,112,115,0,0,0,0,0,0,115,101,97,115,104,101,108,108,50,0,0,0,0,0,0,0,85,84,70,56,32,99,111,100,101,115,32,62,32,51,32,98,121,116,101,115,32,97,114,101,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,101,100,46,32,79,114,32,112,101,114,104,97,112,115,32,34,45,71,99,104,97,114,115,101,116,61,108,97,116,105,110,49,34,32,105,115,32,110,101,101,100,101,100,63,10,0,0,0,0,0,47,72,101,108,118,101,116,105,99,97,45,66,111,108,100,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,115,101,97,115,104,101,108,108,49,0,0,0,0,0,0,0,115,101,97,115,104,101,108,108,0,0,0,0,0,0,0,0,47,100,97,114,107,50,54,47,54,0,0,0,0,0,0,0,115,101,97,103,114,101,101,110,52,0,0,0,0,0,0,0,115,101,97,103,114,101,101,110,51,0,0,0,0,0,0,0,114,102,108,111,111,114,0,0,115,101,97,103,114,101,101,110,50,0,0,0,0,0,0,0,115,101,97,103,114,101,101,110,49,0,0,0,0,0,0,0,115,101,97,103,114,101,101,110,0,0,0,0,0,0,0,0,115,97,110,100,121,98,114,111,119,110,0,0,0,0,0,0,115,97,108,109,111,110,52,0,115,97,108,109,111,110,51,0,115,97,108,109,111,110,50,0,115,97,108,109,111,110,49,0,47,100,97,114,107,50,54,47,53,0,0,0,0,0,0,0,115,97,108,109,111,110,0,0,115,97,100,100,108,101,98,114,111,119,110,0,0,0,0,0,114,101,103,0,0,0,0,0,116,101,101,0,0,0,0,0,114,111,121,97,108,98,108,117,101,52,0,0,0,0,0,0,32,97,108,116,61,34,34,0,114,111,121,97,108,98,108,117,101,51,0,0,0,0,0,0,114,111,121,97,108,98,108,117,101,50,0,0,0,0,0,0,114,111,121,97,108,98,108,117,101,49,0,0,0,0,0,0,114,111,121,97,108,98,108,117,101,0,0,0,0,0,0,0,114,111,115,121,98,114,111,119,110,52,0,0,0,0,0,0,98,108,97,99,107,0,0,0,114,111,115,121,98,114,111,119,110,51,0,0,0,0,0,0,75,80,95,76,101,102,116,0,114,111,115,121,98,114,111,119,110,50,0,0,0,0,0,0,47,100,97,114,107,50,54,47,52,0,0,0,0,0,0,0,114,111,115,121,98,114,111,119,110,49,0,0,0,0,0,0,114,111,115,121,98,114,111,119,110,0,0,0,0,0,0,0,114,101,97,108,0,0,0,0,114,101,100,52,0,0,0,0,114,101,100,51,0,0,0,0,114,101,100,50,0,0,0,0,114,101,100,49,0,0,0,0,114,101,100,0,0,0,0,0,112,117,114,112,108,101,52,0,112,117,114,112,108,101,51,0,47,97,99,99,101,110,116,55,47,52,0,0,0,0,0,0,112,117,114,112,108,101,50,0,47,100,97,114,107,50,54,47,51,0,0,0,0,0,0,0,112,117,114,112,108,101,49,0,112,117,114,112,108,101,0,0,114,100,113,117,111,0,0,0,112,111,119,100,101,114,98,108,117,101,0,0,0,0,0,0,112,108,117,109,52,0,0,0,112,108,117,109,51,0,0,0,112,108,117,109,50,0,0,0,112,108,117,109,49,0,0,0,112,108,117,109,0,0,0,0,104,111,117,115,101,0,0,0,112,105,110,107,52,0,0,0,112,105,110,107,51,0,0,0,47,100,97,114,107,50,54,47,50,0,0,0,0,0,0,0,112,105,110,107,50,0,0,0,112,105,110,107,49,0,0,0,114,99,101,105,108,0,0,0,112,105,110,107,0,0,0,0,112,101,114,117,0,0,0,0,112,101,97,99,104,112,117,102,102,52,0,0,0,0,0,0,112,101,97,99,104,112,117,102,102,51,0,0,0,0,0,0,112,101,97,99,104,112,117,102,102,50,0,0,0,0,0,0,52,0,0,0,0,0,0,0,106,112,101,58,109,97,112,0,112,101,97,99,104,112,117,102,102,49,0,0,0,0,0,0,112,101,97,99,104,112,117,102,102,0,0,0,0,0,0,0,112,97,112,97,121,97,119,104,105,112,0,0,0,0,0,0,47,100,97,114,107,50,54,47,49,0,0,0,0,0,0,0,112,97,108,101,118,105,111,108,101,116,114,101,100,52,0,0,37,48,51,111,0,0,0,0,112,97,108,101,118,105,111,108,101,116,114,101,100,51,0,0,114,97,114,114,0,0,0,0,112,97,108,101,118,105,111,108,101,116,114,101,100,50,0,0,112,97,108,101,118,105,111,108,101,116,114,101,100,49,0,0,112,97,108,101,118,105,111,108,101,116,114,101,100,0,0,0,112,97,108,101,116,117,114,113,117,111,105,115,101,52,0,0,112,97,108,101,116,117,114,113,117,111,105,115,101,51,0,0,73,108,108,101,103,97,108,32,97,116,116,114,105,98,117,116,101,32,37,115,32,105,110,32,37,115,32,45,32,105,103,110,111,114,101,100,10,0,0,0,112,97,108,101,116,117,114,113,117,111,105,115,101,50,0,0,112,97,108,101,116,117,114,113,117,111,105,115,101,49,0,0,112,97,108,101,116,117,114,113,117,111,105,115,101,0,0,0,47,100,97,114,107,50,53,47,53,0,0,0,0,0,0,0,112,97,108,101,103,114,101,101,110,52,0,0,0,0,0,0,112,97,108,101,103,114,101,101,110,51,0,0,0,0,0,0,114,97,113,117,111,0,0,0,116,101,97,108,0,0,0,0,112,97,108,101,103,114,101,101,110,50,0,0,0,0,0,0,112,97,108,101,103,114,101,101,110,49,0,0,0,0,0,0,112,97,108,101,103,114,101,101,110,0,0,0,0,0,0,0,112,97,108,101,103,111,108,100,101,110,114,111,100,0,0,0,119,104,105,116,101,0,0,0,111,114,99,104,105,100,52,0,111,114,99,104,105,100,51,0,99,111,117,114,0,0,0,0,111,114,99,104,105,100,50,0,111,114,99,104,105,100,49,0,47,100,97,114,107,50,53,47,52,0,0,0,0,0,0,0,111,114,99,104,105,100,0,0,111,114,97,110,103,101,114,101,100,52,0,0,0,0,0,0,114,97,110,103,0,0,0,0,111,114,97,110,103,101,114,101,100,51,0,0,0,0,0,0,111,114,97,110,103,101,114,101,100,50,0,0,0,0,0,0,111,114,97,110,103,101,114,101,100,49,0,0,0,0,0,0,66,111,111,107,109,97,110,45,76,105,103,104,116,0,0,0,111,114,97,110,103,101,114,101,100,0,0,0,0,0,0,0,111,114,97,110,103,101,52,0,111,114,97,110,103,101,51,0,100,111,99,117,109,101,110,116,32,105,115,32,110,111,116,32,115,116,97,110,100,97,108,111,110,101,0,0,0,0,0,0,111,114,97,110,103,101,50,0,110,111,110,116,101,114,109,105,110,97,116,101,100,32,99,111,109,109,101,110,116,32,105,110,32,108,105,110,101,32,37,100,10,0,0,0,0,0,0,0,111,114,97,110,103,101,49,0,111,117,116,32,111,102,32,109,101,109,111,114,121,0,0,0,47,100,97,114,107,50,53,47,51,0,0,0,0,0,0,0,111,114,97,110,103,101,0,0,84,32,0,0,0,0,0,0,111,108,105,118,101,100,114,97,98,52,0,0,0,0,0,0,114,97,100,105,99,0,0,0,100,111,116,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,116,104,101,32,97,115,112,101,99,116,32,97,116,116,114,105,98,117,116,101,32,102,111,114,32,100,105,115,99,111,110,110,101,99,116,101,100,32,103,114,97,112,104,115,32,111,114,32,103,114,97,112,104,115,32,119,105,116,104,32,99,108,117,115,116,101,114,115,10,0,0,0,0,0,0,111,108,105,118,101,100,114,97,98,51,0,0,0,0,0,0,111,108,105,118,101,100,114,97,98,50,0,0,0,0,0,0,93,59,10,0,0,0,0,0,111,108,105,118,101,100,114,97,98,49,0,0,0,0,0,0,44,37,46,53,103,0,0,0,111,108,105,118,101,100,114,97,98,0,0,0,0,0,0,0,104,101,97,100,112,111,114,116,0,0,0,0,0,0,0,0,111,108,100,108,97,99,101,0,110,111,110,101,0,0,0,0,100,97,114,107,98,108,117,101,0,0,0,0,0,0,0,0,110,97,118,121,98,108,117,101,0,0,0,0,0,0,0,0,110,97,118,121,0,0,0,0,47,100,97,114,107,50,53,47,50,0,0,0,0,0,0,0,110,97,118,97,106,111,119,104,105,116,101,52,0,0,0,0,110,97,118,97,106,111,119,104,105,116,101,51,0,0,0,0,114,65,114,114,0,0,0,0,110,97,118,97,106,111,119,104,105,116,101,50,0,0,0,0,110,97,118,97,106,111,119,104,105,116,101,49,0,0,0,0,110,97,118,97,106,111,119,104,105,116,101,0,0,0,0,0,109,111,99,99,97,115,105,110,0,0,0,0,0,0,0,0,109,105,115,116,121,114,111,115,101,52,0,0,0,0,0,0,37,33,80,83,45,65,100,111,98,101,45,0,0,0,0,0,109,105,115,116,121,114,111,115,101,51,0,0,0,0,0,0,73,110,118,97,108,105,100,32,51,45,98,121,116,101,32,85,84,70,56,32,102,111,117,110,100,32,105,110,32,105,110,112,117,116,46,32,80,101,114,104,97,112,115,32,34,45,71,99,104,97,114,115,101,116,61,108,97,116,105,110,49,34,32,105,115,32,110,101,101,100,101,100,63,10,0,0,0,0,0,0,47,72,101,108,118,101,116,105,99,97,45,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,0,0,0,109,105,115,116,121,114,111,115,101,50,0,0,0,0,0,0,120,120,120,0,0,0,0,0,109,105,115,116,121,114,111,115,101,49,0,0,0,0,0,0,47,100,97,114,107,50,53,47,49,0,0,0,0,0,0,0,109,105,115,116,121,114,111,115,101,0,0,0,0,0,0,0,109,105,110,116,99,114,101,97,109,0,0,0,0,0,0,0,113,117,111,116,0,0,0,0,109,105,100,110,105,103,104,116,98,108,117,101,0,0,0,0,109,101,100,105,117,109,118,105,111,108,101,116,114,101,100,0,109,101,100,105,117,109,116,117,114,113,117,111,105,115,101,0,109,101,100,105,117,109,115,112,114,105,110,103,103,114,101,101,110,0,0,0,0,0,0,0,109,101,100,105,117,109,115,108,97,116,101,98,108,117,101,0,109,101,100,105,117,109,115,101,97,103,114,101,101,110,0,0,105,110,32,108,97,98,101,108,32,111,102,32,101,100,103,101,32,37,115,32,37,115,32,37,115,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,101,100,105,117,109,112,117,114,112,108,101,52,0,0,0,109,101,100,105,117,109,112,117,114,112,108,101,51,0,0,0,47,100,97,114,107,50,52,47,52,0,0,0,0,0,0,0,109,101,100,105,117,109,112,117,114,112,108,101,50,0,0,0,109,101,100,105,117,109,112,117,114,112,108,101,49,0,0,0,112,115,105,0,0,0,0,0,35,101,56,101,56,101,56,0,109,101,100,105,117,109,112,117,114,112,108,101,0,0,0,0,109,101,100,105,117,109,111,114,99,104,105,100,52,0,0,0,32,116,105,116,108,101,61,34,0,0,0,0,0,0,0,0,109,101,100,105,117,109,111,114,99,104,105,100,51,0,0,0,109,101,100,105,117,109,111,114,99,104,105,100,50,0,0,0,109,101,100,105,117,109,111,114,99,104,105,100,49,0,0,0,109,101,100,105,117,109,111,114,99,104,105,100,0,0,0,0,69,68,95,116,111,95,118,105,114,116,40,111,114,105,103,41,32,61,61,32,78,85,76,76,0,0,0,0,0,0,0,0,109,101,100,105,117,109,98,108,117,101,0,0,0,0,0,0,109,101,100,105,117,109,97,113,117,97,109,97,114,105,110,101,0,0,0,0,0,0,0,0,47,100,97,114,107,50,52,47,51,0,0,0,0,0,0,0,109,97,114,111,111,110,52,0,109,97,114,111,111,110,51,0,112,114,111,112,0,0,0,0,109,97,114,111,111,110,50,0,109,97,114,111,111,110,49,0,109,97,114,111,111,110,0,0,109,97,103,101,110,116,97,52,0,0,0,0,0,0,0,0,109,97,103,101,110,116,97,51,0,0,0,0,0,0,0,0,109,97,103,101,110,116,97,50,0,0,0,0,0,0,0,0,109,97,103,101,110,116,97,49,0,0,0,0,0,0,0,0,47,97,99,99,101,110,116,55,47,51,0,0,0,0,0,0,109,97,103,101,110,116,97,0,47,100,97,114,107,50,52,47,50,0,0,0,0,0,0,0,108,105,110,101,110,0,0,0,108,105,109,101,103,114,101,101,110,0,0,0,0,0,0,0,112,114,111,100,0,0,0,0,108,105,103,104,116,121,101,108,108,111,119,52,0,0,0,0,108,105,103,104,116,121,101,108,108,111,119,51,0,0,0,0,108,105,103,104,116,121,101,108,108,111,119,50,0,0,0,0,108,105,103,104,116,121,101,108,108,111,119,49,0,0,0,0,80,114,111,116,111,71,114,97,112,104,0,0,0,0,0,0,108,105,103,104,116,121,101,108,108,111,119,0,0,0,0,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,52,0,41,10,0,0,0,0,0,0,112,97,114,97,108,108,101,108,111,103,114,97,109,0,0,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,51,0,108,105,98,112,97,116,104,47,37,115,58,37,100,58,32,37,115,10,0,0,0,0,0,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,50,0,47,100,97,114,107,50,52,47,49,0,0,0,0,0,0,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,49,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,0,0,112,114,105,109,101,0,0,0,108,105,103,104,116,115,108,97,116,101,103,114,101,121,0,0,108,105,103,104,116,115,108,97,116,101,103,114,97,121,0,0,108,105,103,104,116,115,108,97,116,101,98,108,117,101,0,0,110,111,100,101,32,0,0,0,108,105,103,104,116,115,107,121,98,108,117,101,52,0,0,0,108,105,103,104,116,115,107,121,98,108,117,101,51,0,0,0,51,0,0,0,0,0,0,0,108,105,103,104,116,115,107,121,98,108,117,101,50,0,0,0,106,112,101,103,58,109,97,112,0,0,0,0,0,0,0,0,32,40,0,0,0,0,0,0,108,105,103,104,116,115,107,121,98,108,117,101,49,0,0,0,108,105,103,104,116,115,107,121,98,108,117,101,0,0,0,0,47,100,97,114,107,50,51,47,51,0,0,0,0,0,0,0,108,105,103,104,116,115,101,97,103,114,101,101,110,0,0,0,108,105,103,104,116,115,97,108,109,111,110,52,0,0,0,0,112,111,117,110,100,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,46,52,102,32,37,100,32,37,46,49,102,32,37,46,49,102,32,37,100,32,37,100,32,37,115,92,48,48,49,10,0,0,108,105,103,104,116,115,97,108,109,111,110,51,0,0,0,0,108,105,103,104,116,115,97,108,109,111,110,50,0,0,0,0,108,105,103,104,116,115,97,108,109,111,110,49,0,0,0,0,108,105,103,104,116,115,97,108,109,111,110,0,0,0,0,0,108,105,103,104,116,112,105,110,107,52,0,0,0,0,0,0,115,114,99,0,0,0,0,0,108,105,103,104,116,112,105,110,107,51,0,0,0,0,0,0,32,118,101,114,115,105,111,110,32,0,0,0,0,0,0,0,108,105,103,104,116,112,105,110,107,50,0,0,0,0,0,0,97,115,112,101,99,116,0,0,0,0,0,0,0,0,0,0,108,105,103,104,116,112,105,110,107,49,0,0,0,0,0,0,47,100,97,114,107,50,51,47,50,0,0,0,0,0,0,0,108,105,103,104,116,112,105,110,107,0,0,0,0,0,0,0,76,97,121,111,117,116,32,116,121,112,101,58,32,34,37,115,34,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,46,32,85,115,101,32,111,110,101,32,111,102,58,37,115,10,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,108,105,103,104,116,103,114,101,121,0,0,0,0,0,0,0,112,108,117,115,109,110,0,0,115,105,108,118,101,114,0,0,108,105,103,104,116,103,114,97,121,0,0,0,0,0,0,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,121,101,108,108,111,119,0,0,0,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,52,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,51,0,32,99,114,101,97,116,101,32,112,111,108,121,103,111,110,32,0,0,0,0,0,0,0,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,50,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,49,0,60,33,45,45,32,71,101,110,101,114,97,116,101,100,32,98,121,32,0,0,0,0,0,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,0,0,108,105,103,104,116,99,121,97,110,52,0,0,0,0,0,0,47,100,97,114,107,50,51,47,49,0,0,0,0,0,0,0,108,105,103,104,116,99,121,97,110,51,0,0,0,0,0,0,108,105,103,104,116,99,121,97,110,50,0,0,0,0,0,0,112,105,118,0,0,0,0,0,108,105,103,104,116,99,121,97,110,49,0,0,0,0,0,0,108,105,103,104,116,99,121,97,110,0,0,0,0,0,0,0,108,105,103,104,116,99,111,114,97,108,0,0,0,0,0,0,66,111,111,107,109,97,110,45,68,101,109,105,73,116,97,108,105,99,0,0,0,0,0,0,108,105,103,104,116,98,108,117,101,52,0,0,0,0,0,0,108,105,103,104,116,98,108,117,101,51,0,0,0,0,0,0,108,105,103,104,116,98,108,117,101,50,0,0,0,0,0,0,101,114,114,111,114,32,105,110,32,112,114,111,99,101,115,115,105,110,103,32,101,120,116,101,114,110,97,108,32,101,110,116,105,116,121,32,114,101,102,101,114,101,110,99,101,0,0,0,32,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,71,114,97,112,104,105,99,115,47,83,86,71,47,49,46,49,47,68,84,68,47,115,118,103,49,49,46,100,116,100,34,62,10,0,0,0,108,105,103,104,116,98,108,117,101,49,0,0,0,0,0,0,108,105,103,104,116,98,108,117,101,0,0,0,0,0,0,0,47,98,117,112,117,57,47,57,0,0,0,0,0,0,0,0,108,101,109,111,110,99,104,105,102,102,111,110,52,0,0,0,70,32,37,102,32,0,0,0,108,101,109,111,110,99,104,105,102,102,111,110,51,0,0,0,112,105,0,0,0,0,0,0,108,101,109,111,110,99,104,105,102,102,111,110,50,0,0,0,108,101,109,111,110,99,104,105,102,102,111,110,49,0,0,0,108,101,109,111,110,99,104,105,102,102,111,110,0,0,0,0,37,46,53,103,44,37,46,53,103,44,37,46,53,103,0,0,108,97,119,110,103,114,101,101,110,0,0,0,0,0,0,0,107,101,121,0,0,0,0,0,108,97,118,101,110,100,101,114,98,108,117,115,104,52,0,0,108,97,118,101,110,100,101,114,98,108,117,115,104,51,0,0,99,121,97,110,0,0,0,0,60,33,68,79,67,84,89,80,69,32,115,118,103,32,80,85,66,76,73,67,32,34,45,47,47,87,51,67,47,47,68,84,68,32,83,86,71,32,49,46,49,47,47,69,78,34,10,0,108,97,118,101,110,100,101,114,98,108,117,115,104,50,0,0,78,68,95,105,110,40,114,105,103,104,116,41,46,115,105,122,101,32,43,32,78,68,95,111,117,116,40,114,105,103,104,116,41,46,115,105,122,101,32,61,61,32,48,0,0,0,0,0,112,104,105,0,0,0,0,0,108,97,118,101,110,100,101,114,98,108,117,115,104,49,0,0,47,98,117,112,117,57,47,56,0,0,0,0,0,0,0,0,108,97,118,101,110,100,101,114,98,108,117,115,104,0,0,0,108,97,118,101,110,100,101,114,0,0,0,0,0,0,0,0,32,32,34,37,115,34,10,0,107,104,97,107,105,52,0,0,107,104,97,107,105,51,0,0,97,108,105,99,101,98,108,117,101,0,0,0,0,0,0,0,107,104,97,107,105,50,0,0,107,104,97,107,105,49,0,0,107,104,97,107,105,0,0,0,112,110,103,0,0,0,0,0,105,118,111,114,121,52,0,0,73,110,118,97,108,105,100,32,50,45,98,121,116,101,32,85,84,70,56,32,102,111,117,110,100,32,105,110,32,105,110,112,117,116,46,32,80,101,114,104,97,112,115,32,34,45,71,99,104,97,114,115,101,116,61,108,97,116,105,110,49,34,32,105,115,32,110,101,101,100,101,100,63,10,0,0,0,0,0,0,47,72,101,108,118,101,116,105,99,97,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,0,0,0,34,32,116,121,112,101,61,34,116,101,120,116,47,99,115,115,34,63,62,10,0,0,0,0,105,118,111,114,121,51,0,0,78,111,32,108,105,98,122,32,115,117,112,112,111,114,116,46,10,0,0,0,0,0,0,0,105,118,111,114,121,50,0,0,47,98,117,112,117,57,47,55,0,0,0,0,0,0,0,0,105,118,111,114,121,49,0,0,105,118,111,114,121,0,0,0,112,101,114,112,0,0,0,0,105,110,118,105,115,0,0,0,105,110,100,105,103,111,0,0,105,110,100,105,97,110,114,101,100,52,0,0,0,0,0,0,105,110,100,105,97,110,114,101,100,51,0,0,0,0,0,0,105,110,100,105,97,110,114,101,100,50,0,0,0,0,0,0,105,110,100,105,97,110,114,101,100,49,0,0,0,0,0,0,60,63,120,109,108,45,115,116,121,108,101,115,104,101,101,116,32,104,114,101,102,61,34,0,105,110,100,105,97,110,114,101,100,0,0,0,0,0,0,0,104,111,116,112,105,110,107,52,0,0,0,0,0,0,0,0,47,98,117,112,117,57,47,54,0,0,0,0,0,0,0,0,104,111,116,112,105,110,107,51,0,0,0,0,0,0,0,0,104,111,116,112,105,110,107,50,0,0,0,0,0,0,0,0,112,101,114,109,105,108,0,0,35,51,48,51,48,51,48,0,104,111,116,112,105,110,107,49,0,0,0,0,0,0,0,0,104,111,116,112,105,110,107,0,104,111,110,101,121,100,101,119,52,0,0,0,0,0,0,0,32,116,97,114,103,101,116,61,34,0,0,0,0,0,0,0,104,111,110,101,121,100,101,119,51,0,0,0,0,0,0,0,104,111,110,101,121,100,101,119,50,0,0,0,0,0,0,0,104,111,110,101,121,100,101,119,49,0,0,0,0,0,0,0,115,116,121,108,101,115,104,101,101,116,0,0,0,0,0,0,104,111,110,101,121,100,101,119,0,0,0,0,0,0,0,0,103,114,101,121,57,57,0,0,47,98,117,112,117,57,47,53,0,0,0,0,0,0,0,0,103,114,101,121,57,56,0,0,103,114,101,121,57,55,0,0,112,97,114,116,0,0,0,0,103,114,101,121,57,54,0,0,103,114,101,121,57,53,0,0,103,114,101,121,57,52,0,0,103,114,101,121,57,51,0,0,103,114,101,121,57,50,0,0,103,114,101,121,57,49,0,0,60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,32,115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,0,103,114,101,121,57,48,0,0,47,97,99,99,101,110,116,55,47,50,0,0,0,0,0,0,103,114,101,121,57,0,0,0,47,98,117,112,117,57,47,52,0,0,0,0,0,0,0,0,103,114,101,121,56,57,0,0,103,114,101,121,56,56,0,0,112,97,114,97,0,0,0,0,103,114,101,121,56,55,0,0,103,114,101,121,56,54,0,0,103,114,101,121,56,53,0,0,103,114,101,121,56,52,0,0,103,114,101,121,56,51,0,0,103,114,101,121,56,50,0,0,32,120,109,108,110,115,58,120,108,105,110,107,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,120,108,105,110,107,34,0,0,0,0,0,116,114,97,112,101,122,105,117,109,0,0,0,0,0,0,0,103,114,101,121,56,49,0,0,103,114,101,121,56,48,0,0,47,98,117,112,117,57,47,51,0,0,0,0,0,0,0,0,103,114,101,121,56,0,0,0,103,114,101,121,55,57,0,0,111,117,109,108,0,0,0,0,103,114,101,121,55,56,0,0,103,114,101,121,55,55,0,0,103,114,101,121,55,54,0,0,103,114,101,121,55,53,0,0,103,114,101,121,55,52,0,0,50,0,0,0,0,0,0,0,103,114,101,121,55,51,0,0,103,105,102,58,109,97,112,0,32,120,109,108,110,115,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,0,0,0,0,0,103,114,101,121,55,50,0,0,50,48,49,49,48,53,48,55,46,48,51,50,55,0,0,0,103,114,101,121,55,49,0,0,47,98,117,112,117,57,47,50,0,0,0,0,0,0,0,0,103,114,101,121,55,48,0,0,103,114,101,121,55,0,0,0,111,116,105,109,101,115,0,0,103,114,101,121,54,57,0,0,48,0,0,0,0,0,0,0,103,114,101,121,54,56,0,0,103,114,101,121,54,55,0,0,103,114,101,121,54,54,0,0,103,114,101,121,54,53,0,0,115,99,97,108,101,0,0,0,116,111,111,32,109,97,110,121,32,115,97,109,101,123,104,101,97,100,44,116,97,105,108,125,32,103,114,111,117,112,115,32,102,111,114,32,110,111,100,101,32,37,115,10,0,0,0,0,103,114,101,121,54,52,0,0,32,118,105,101,119,66,111,120,61,34,37,46,50,102,32,37,46,50,102,32,37,46,50,102,32,37,46,50,102,34,0,0,103,114,101,121,54,51,0,0,37,115,32,45,62,32,37,115,58,32,115,112,108,105,110,101,32,115,105,122,101,32,62,32,49,32,110,111,116,32,115,117,112,112,111,114,116,101,100,10,0,0,0,0,0,0,0,0,103,114,97,112,104,0,0,0,103,114,101,121,54,50,0,0,47,98,117,112,117,57,47,49,0,0,0,0,0,0,0,0,103,114,101,121,54,49,0,0,103,114,101,121,54,48,0,0,111,116,105,108,100,101,0,0,114,101,100,0,0,0,0,0,103,114,101,121,54,0,0,0,103,114,101,121,53,57,0,0,103,114,101,121,53,56,0,0,103,114,101,121,53,55,0,0,32,45,115,109,111,111,116,104,32,98,101,122,105,101,114,32,0,0,0,0,0,0,0,0,103,114,101,121,53,54,0,0,103,114,101,121,53,53,0,0,60,115,118,103,32,119,105,100,116,104,61,34,37,100,112,116,34,32,104,101,105,103,104,116,61,34,37,100,112,116,34,10,0,0,0,0,0,0,0,0,103,114,101,121,53,52,0,0,103,114,101,121,53,51,0,0,47,98,117,112,117,56,47,56,0,0,0,0,0,0,0,0,103,114,101,121,53,50,0,0,103,114,101,121,53,49,0,0,111,115,108,97,115,104,0,0,103,114,101,121,53,48,0,0,103,114,101,121,53,0,0,0,103,114,101,121,52,57,0,0,115,101,114,105,102,0,0,0,103,114,101,121,52,56,0,0,103,114,101,121,52,55,0,0,103,114,101,121,52,54,0,0,117,110,99,108,111,115,101,100,32,67,68,65,84,65,32,115,101,99,116,105,111,110,0,0,114,97,110,107,46,99,0,0,32,80,97,103,101,115,58,32,37,100,32,45,45,62,10,0,103,114,101,121,52,53,0,0,103,114,101,121,52,52,0,0,47,98,117,112,117,56,47,55,0,0,0,0,0,0,0,0,103,114,101,121,52,51,0,0,101,32,0,0,0,0,0,0,103,114,101,121,52,50,0,0,111,114,100,109,0,0,0,0,103,114,101,121,52,49,0,0,103,114,101,121,52,48,0,0,103,114,101,121,52,0,0,0,98,98,0,0,0,0,0,0,103,114,101,121,51,57,0,0,104,114,101,102,0,0,0,0,103,114,101,121,51,56,0,0,103,114,101,121,51,55,0,0,99,114,105,109,115,111,110,0,32,84,105,116,108,101,58,32,0,0,0,0,0,0,0,0,117,115,45,62,110,97,109,101,0,0,0,0,0,0,0,0,103,114,101,121,51,54,0,0,103,114,101,121,51,53,0,0,47,98,117,112,117,56,47,54,0,0,0,0,0,0,0,0,103,114,101,121,51,52,0,0,103,114,101,121,51,51,0,0,111,114,100,102,0,0,0,0,103,114,101,121,51,50,0,0,103,114,101,121,51,49,0,0,65,82,61,37,48,46,52,108,102,9,32,65,114,101,97,61,32,37,48,46,52,108,102,9,0,0,0,0,0,0,0,0,103,114,101,121,51,48,0,0,103,114,101,121,51,0,0,0,103,114,101,121,50,57,0,0,117,32,61,61,32,85,70,95,102,105,110,100,40,117,41,0,68,111,116,68,105,99,116,32,98,101,103,105,110,0,0,0,60,33,45,45,0,0,0,0,137,80,78,71,13,10,26,10,0,0,0,0,0,0,0,0,103,114,101,121,50,56,0,0,37,100,0,0,0,0,0,0,47,84,105,109,101,115,45,66,111,108,100,73,116,97,108,105,99,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,0,0,0,0,115,118,103,0,0,0,0,0,103,114,101,121,50,55,0,0,103,114,101,121,50,54,0,0,47,98,117,112,117,56,47,53,0,0,0,0,0,0,0,0,103,114,101,121,50,53,0,0,103,114,101,121,50,52,0,0,111,114,0,0,0,0,0,0,103,114,101,121,50,51,0,0,103,114,101,121,50,50,0,0,103,114,101,121,50,49,0,0,103,114,101,121,50,48,0,0,103,114,101,121,50,0,0,0,60,47,115,118,103,62,10,0,103,114,101,121,49,57,0,0,37,37,37,37,67,114,101,97,116,111,114,58,32,37,115,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,10,0,0,0,0,0,0,0,0,103,114,101,121,49,56,0,0,103,114,101,121,49,55,0,0,47,98,117,112,117,56,47,52,0,0,0,0,0,0,0,0,103,114,101,121,49,54,0,0,115,111,108,105,100,0,0,0,103,114,101,121,49,53,0,0,111,112,108,117,115,0,0,0,35,102,99,102,99,102,99,0,103,114,101,121,49,52,0,0,103,114,101,121,49,51,0,0,103,114,101,121,49,50,0,0,103,114,101,121,49,49,0,0,32,104,114,101,102,61,34,0,103,114,101,121,49,48,48,0,34,32,99,108,97,115,115,61,34,108,97,121,101,114,34,62,10,0,0,0,0,0,0,0,103,114,101,121,49,48,0,0,32,69,80,83,70,45,51,46,48,10,0,0,0,0,0,0,103,114,101,121,49,0,0,0,103,114,101,121,48,0,0,0,47,98,117,112,117,56,47,51,0,0,0,0,0,0,0,0,103,114,101,121,0,0,0,0,103,114,101,101,110,121,101,108,108,111,119,0,0,0,0,0,111,109,105,99,114,111,110,0,103,114,101,101,110,52,0,0,103,114,101,101,110,51,0,0,103,114,101,101,110,50,0,0,103,114,101,101,110,49,0,0,103,114,101,101,110,0,0,0,32,116,114,97,110,115,102,111,114,109,61,34,115,99,97,108,101,40,37,103,32,37,103,41,32,114,111,116,97,116,101,40,37,100,41,32,116,114,97,110,115,108,97,116,101,40,37,103,32,37,103,41,34,62,10,0,103,114,97,121,57,57,0,0,37,33,80,83,45,65,100,111,98,101,45,51,46,48,0,0,103,114,97,121,57,56,0,0,47,97,99,99,101,110,116,55,47,49,0,0,0,0,0,0,103,114,97,121,57,55,0,0,47,98,117,112,117,56,47,50,0,0,0,0,0,0,0,0,103,114,97,121,57,54,0,0,103,114,97,121,57,53,0,0,111,109,101,103,97,0,0,0,103,114,97,121,57,52,0,0,103,114,97,121,57,51,0,0,103,114,97,121,57,50,0,0,103,114,97,121,57,49,0,0,103,114,97,121,57,48,0,0,34,32,99,108,97,115,115,61,34,103,114,97,112,104,34,0,103,114,97,121,57,0,0,0,37,37,69,79,70,10,0,0,103,114,97,121,56,57,0,0,100,105,97,109,111,110,100,0,103,114,97,121,56,56,0,0,47,98,117,112,117,56,47,49,0,0,0,0,0,0,0,0,103,114,97,121,56,55,0,0,103,114,97,121,56,54,0,0,111,108,105,110,101,0,0,0,103,114,97,121,56,53,0,0,103,114,97,121,56,52,0,0,103,114,97,121,56,51,0,0,103,114,97,121,56,50,0,0,103,114,97,121,56,49,0,0,34,32,99,108,97,115,115,61,34,99,108,117,115,116,101,114,34,62,0,0,0,0,0,0,103,114,97,121,56,48,0,0,49,0,0,0,0,0,0,0,112,110,103,58,109,97,112,0,101,110,100,10,114,101,115,116,111,114,101,10,0,0,0,0,103,114,97,121,56,0,0,0,103,114,97,121,55,57,0,0,47,98,117,112,117,55,47,55,0,0,0,0,0,0,0,0,103,114,97,121,55,56,0,0,103,114,97,121,55,55,0,0,111,103,114,97,118,101,0,0,103,114,97,121,55,54,0,0,103,114,97,121,55,53,0,0,37,100,32,37,100,32,35,37,48,50,120,37,48,50,120,37,48,50,120,10,0,0,0,0,103,114,97,121,55,52,0,0,103,114,97,121,55,51,0,0,103,114,97,121,55,50,0,0,60,73,77,71,62,0,0,0,34,32,99,108,97,115,115,61,34,110,111,100,101,34,62,0,103,114,97,121,55,49,0,0,37,37,37,37,80,97,103,101,115,58,32,37,100,10,0,0,103,114,97,121,55,48,0,0,103,114,97,121,55,0,0,0,47,98,117,112,117,55,47,54,0,0,0,0,0,0,0,0,103,114,97,121,54,57,0,0,103,114,97,121,54,56,0,0,111,101,108,105,103,0,0,0,112,117,114,112,108,101,0,0,103,114,97,121,54,55,0,0,103,114,97,121,54,54,0,0,103,114,97,121,54,53,0,0,103,114,97,121,54,52,0,0,32,45,119,105,100,116,104,32,0,0,0,0,0,0,0,0,103,114,97,121,54,51,0,0,60,47,116,105,116,108,101,62,10,0,0,0,0,0,0,0,103,114,97,121,54,50,0,0,37,37,84,114,97,105,108,101,114,10,0,0,0,0,0,0,103,114,97,121,54,49,0,0,103,114,97,121,54,48,0,0,47,98,117,112,117,55,47,53,0,0,0,0,0,0,0,0,103,114,97,121,54,0,0,0,103,114,97,121,53,57,0,0,35,56,48,56,48,56,48,0,111,99,105,114,99,0,0,0,103,114,97,121,53,56,0,0,103,114,97,121,53,55,0,0,103,114,97,121,53,54,0,0,85,82,87,32,66,111,111,107,109,97,110,32,76,0,0,0,103,114,97,121,53,53,0,0,103,114,97,121,53,52,0,0,92,69,0,0,0,0,0,0,103,114,97,121,53,51,0,0,101,110,99,111,100,105,110,103,32,115,112,101,99,105,102,105,101,100,32,105,110,32,88,77,76,32,100,101,99,108,97,114,97,116,105,111,110,32,105,115,32,105,110,99,111,114,114,101,99,116,0,0,0,0,0,0,91,32,123,67,97,116,97,108,111,103,125,32,60,60,32,47,85,82,73,32,60,60,32,47,66,97,115,101,32,40,37,115,41,32,62,62,32,62,62,10,47,80,85,84,32,112,100,102,109,97,114,107,10,0,0,0,103,114,97,121,53,50,0,0,92,76,0,0,0,0,0,0,103,114,97,121,53,49,0,0,47,98,117,112,117,55,47,52,0,0,0,0,0,0,0,0,103,114,97,121,53,48,0,0,69,32,0,0,0,0,0,0,103,114,97,121,53,0,0,0,111,97,99,117,116,101,0,0,100,101,103,101,110,101,114,97,116,101,32,99,111,110,99,101,110,116,114,97,116,101,100,32,114,97,110,107,32,37,115,44,37,100,10,0,0,0,0,0,103,114,97,121,52,57,0,0,103,114,97,121,52,56,0,0,103,114,97,121,52,55,0,0,37,46,50,102,0,0,0,0,103,114,97,121,52,54,0,0,85,82,76,0,0,0,0,0,103,114,97,121,52,53,0,0,60,116,105,116,108,101,62,0,103,114,97,121,52,52,0,0,99,111,114,110,115,105,108,107,0,0,0,0,0,0,0,0,115,101,116,117,112,76,97,116,105,110,49,10,0,0,0,0,103,114,97,121,52,51,0,0,103,114,97,121,52,50,0,0,47,98,117,112,117,55,47,51,0,0,0,0,0,0,0,0,103,114,97,121,52,49,0,0,103,114,97,121,52,48,0,0,110,117,0,0,0,0,0,0,103,114,97,121,52,0,0,0,103,114,97,121,51,57,0,0,103,114,97,121,51,56,0,0,103,114,97,121,51,55,0,0,103,114,97,121,51,54,0,0,34,32,99,108,97,115,115,61,34,101,100,103,101,34,62,0,40,108,105,98,41,0,0,0,103,114,97,121,51,53,0,0,95,95,99,108,117,115,116,101,114,110,111,100,101,115,0,0,37,37,69,110,100,67,111,109,109,101,110,116,115,10,115,97,118,101,10,0,0,0,0,0,47,84,105,109,101,115,45,66,111,108,100,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,0,0,103,114,97,121,51,52,0,0,103,114,97,121,51,51,0,0,47,98,117,112,117,55,47,50,0,0,0,0,0,0,0,0,103,114,97,121,51,50,0,0,103,114,97,121,51,49,0,0,110,116,105,108,100,101,0,0,103,114,97,121,51,48,0,0,103,114,97,121,51,0,0,0,103,114,97,121,50,57,0,0,103,114,97,121,50,56,0,0,103,114,97,121,50,55,0,0,60,103,32,105,100,61,34,0,103,114,97,121,50,54,0,0,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,103,114,97,121,50,53,0,0,103,114,97,121,50,52,0,0,47,98,117,112,117,55,47,49,0,0,0,0,0,0,0,0,103,114,97,121,50,51,0,0,103,114,97,121,50,50,0,0,110,115,117,98,0,0,0,0,95,100,114,97,119,95,0,0,110,111,114,109,97,108,0,0,103,114,97,121,50,49,0,0,103,114,97,121,50,48,0,0,103,114,97,121,50,0,0,0,103,114,97,121,49,57,0,0,103,114,97,121,49,56,0,0,34,0,0,0,0,0,0,0,60,47,103,62,10,0,0,0,103,114,97,121,49,55,0,0,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,40,97,116,101,110,100,41,10,0,103,114,97,121,49,54,0,0,103,114,97,121,49,53,0,0,47,98,117,112,117,54,47,54,0,0,0,0,0,0,0,0,103,114,97,121,49,52,0,0,103,114,97,121,49,51,0,0,110,111,116,105,110,0,0,0,103,114,97,121,49,50,0,0,103,114,97,121,49,49,0,0,103,114,97,121,49,48,48,0,103,114,97,121,49,48,0,0,103,114,97,121,49,0,0,0,62,10,0,0,0,0,0,0,103,114,97,121,48,0,0,0,37,37,80,97,103,101,115,58,32,49,10,0,0,0,0,0,103,114,97,121,0,0,0,0,47,97,99,99,101,110,116,54,47,54,0,0,0,0,0,0,103,111,108,100,101,110,114,111,100,52,0,0,0,0,0,0,47,98,117,112,117,54,47,53,0,0,0,0,0,0,0,0,103,111,108,100,101,110,114,111,100,51,0,0,0,0,0,0,103,111,108,100,101,110,114,111,100,50,0,0,0,0,0,0,110,111,116,0,0,0,0,0,103,111,108,100,101,110,114,111,100,49,0,0,0,0,0,0,103,111,108,100,101,110,114,111,100,0,0,0,0,0,0,0,103,111,108,100,52,0,0,0,103,111,108,100,51,0,0,0,103,111,108,100,50,0,0,0,32,116,97,114,103,101,116,61,34,0,0,0,0,0,0,0,103,111,108,100,49,0,0,0,37,37,80,97,103,101,115,58,32,40,97,116,101,110,100,41,10,0,0,0,0,0,0,0,103,111,108,100,0,0,0,0,112,108,97,105,110,116,101,120,116,0,0,0,0,0,0,0,103,104,111,115,116,119,104,105,116,101,0,0,0,0,0,0,47,98,117,112,117,54,47,52,0,0,0,0,0,0,0,0,103,97,105,110,115,98,111,114,111,0,0,0,0,0,0,0,102,111,114,101,115,116,103,114,101,101,110,0,0,0,0,0,110,105,0,0,0,0,0,0,102,108,111,114,97,108,119,104,105,116,101,0,0,0,0,0,102,105,114,101,98,114,105,99,107,52,0,0,0,0,0,0,102,105,114,101,98,114,105,99,107,51,0,0,0,0,0,0,102,105,114,101,98,114,105,99,107,50,0,0,0,0,0,0,102,105,114,101,98,114,105,99,107,49,0,0,0,0,0,0,32,120,108,105,110,107,58,116,105,116,108,101,61,34,0,0,102,105,114,101,98,114,105,99,107,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,40,108,105,98,41,58,112,115,0,0,0,0,0,0,0,0,37,37,37,37,84,105,116,108,101,58,32,37,115,10,0,0,100,111,100,103,101,114,98,108,117,101,52,0,0,0,0,0,100,111,100,103,101,114,98,108,117,101,51,0,0,0,0,0,47,98,117,112,117,54,47,51,0,0,0,0,0,0,0,0,100,111,100,103,101,114,98,108,117,101,50,0,0,0,0,0,100,111,100,103,101,114,98,108,117,101,49,0,0,0,0,0,110,101,0,0,0,0,0,0,100,111,100,103,101,114,98,108,117,101,0,0,0,0,0,0,100,105,109,103,114,101,121,0,100,105,109,103,114,97,121,0])
.concat([37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,51,102,32,37,100,32,37,46,52,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,0,0,0,100,101,101,112,115,107,121,98,108,117,101,52,0,0,0,0,100,101,101,112,115,107,121,98,108,117,101,51,0,0,0,0,85,110,107,110,111,119,110,32,72,84,77,76,32,101,108,101,109,101,110,116,32,60,37,115,62,32,111,110,32,108,105,110,101,32,37,100,32,10,0,0,32,120,108,105,110,107,58,104,114,101,102,61,34,0,0,0,100,101,101,112,115,107,121,98,108,117,101,50,0,0,0,0,37,100,32,37,100,32,115,101,116,108,97,121,101,114,10,0,100,101,101,112,115,107,121,98,108,117,101,49,0,0,0,0,100,101,101,112,115,107,121,98,108,117,101,0,0,0,0,0,45,45,0,0,0,0,0,0,47,98,117,112,117,54,47,50,0,0,0,0,0,0,0,0,100,101,101,112,112,105,110,107,52,0,0,0,0,0,0,0,100,101,101,112,112,105,110,107,51,0,0,0,0,0,0,0,110,100,97,115,104,0,0,0,111,108,105,118,101,0,0,0,100,101,101,112,112,105,110,107,50,0,0,0,0,0,0,0,100,101,101,112,112,105,110,107,49,0,0,0,0,0,0,0,100,101,101,112,112,105,110,107,0,0,0,0,0,0,0,0,100,97,114,107,118,105,111,108,101,116,0,0,0,0,0,0,36,99,0,0,0,0,0,0,100,97,114,107,116,117,114,113,117,111,105,115,101,0,0,0,60,97,0,0,0,0,0,0,100,97,114,107,115,108,97,116,101,103,114,101,121,0,0,0,91,32,47,67,114,111,112,66,111,120,32,91,37,100,32,37,100,32,37,100,32,37,100,93,32,47,80,65,71,69,83,32,112,100,102,109,97,114,107,10,0,0,0,0,0,0,0,0,100,97,114,107,115,108,97,116,101,103,114,97,121,52,0,0,100,97,114,107,115,108,97,116,101,103,114,97,121,51,0,0,47,98,117,112,117,54,47,49,0,0,0,0,0,0,0,0,100,97,114,107,115,108,97,116,101,103,114,97,121,50,0,0,100,97,114,107,115,108,97,116,101,103,114,97,121,49,0,0,110,98,115,112,0,0,0,0,47,98,117,112,117,53,47,53,0,0,0,0,0,0,0,0,100,97,114,107,115,108,97,116,101,103,114,97,121,0,0,0,99,111,108,111,114,115,99,104,101,109,101,0,0,0,0,0,100,97,114,107,115,108,97,116,101,98,108,117,101,0,0,0,100,97,114,107,115,101,97,103,114,101,101,110,52,0,0,0,66,111,111,107,109,97,110,45,68,101,109,105,0,0,0,0,100,97,114,107,115,101,97,103,114,101,101,110,51,0,0,0,100,97,114,107,115,101,97,103,114,101,101,110,50,0,0,0,60,47,97,62,10,0,0,0,100,97,114,107,115,101,97,103,114,101,101,110,49,0,0,0,117,110,107,110,111,119,110,32,101,110,99,111,100,105,110,103,0,0,0,0,0,0,0,0,99,97,110,118,97,115,32,115,105,122,101,32,40,37,100,44,37,100,41,32,101,120,99,101,101,100,115,32,80,68,70,32,108,105,109,105,116,32,40,37,100,41,10,9,40,115,117,103,103,101,115,116,32,115,101,116,116,105,110,103,32,97,32,98,111,117,110,100,105,110,103,32,98,111,120,32,115,105,122,101,44,32,115,101,101,32,100,111,116,40,49,41,41,10,0,0,100,97,114,107,115,101,97,103,114,101,101,110,0,0,0,0,92,84,0,0,0,0,0,0,100,97,114,107,115,97,108,109,111,110,0,0,0,0,0,0,100,97,114,107,111,114,99,104,105,100,52,0,0,0,0,0,67,32,0,0,0,0,0,0,100,97,114,107,111,114,99,104,105,100,51,0,0,0,0,0,110,97,98,108,97,0,0,0,47,98,117,112,117,53,47,52,0,0,0,0,0,0,0,0,100,97,114,107,111,114,99,104,105,100,50,0,0,0,0,0,100,97,114,107,111,114,99,104,105,100,49,0,0,0,0,0,100,97,114,107,111,114,99,104,105,100,0,0,0,0,0,0,37,46,53,103,44,37,46,53,103,0,0,0,0,0,0,0,100,97,114,107,111,114,97,110,103,101,52,0,0,0,0,0,119,0,0,0,0,0,0,0,100,97,114,107,111,114,97,110,103,101,51,0,0,0,0,0,60,47,116,101,120,116,62,10,0,0,0,0,0,0,0,0,100,97,114,107,111,114,97,110,103,101,50,0,0,0,0,0,99,111,114,110,102,108,111,119,101,114,98,108,117,101,0,0,37,103,32,37,103,32,115,101,116,95,115,99,97,108,101,32,37,100,32,114,111,116,97,116,101,32,37,103,32,37,103,32,116,114,97,110,115,108,97,116,101,10,0,0,0,0,0,0,100,97,114,107,111,114,97,110,103,101,49,0,0,0,0,0,100,97,114,107,111,114,97,110,103,101,0,0,0,0,0,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,52,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,51,0,109,117,0,0,0,0,0,0,47,98,117,112,117,53,47,51,0,0,0,0,0,0,0,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,50,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,49,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,0,0,100,97,114,107,107,104,97,107,105,0,0,0,0,0,0,0,100,97,114,107,103,114,101,101,110,0,0,0,0,0,0,0,62,0,0,0,0,0,0,0,115,118,103,0,0,0,0,0,100,97,114,107,103,111,108,100,101,110,114,111,100,52,0,0,103,115,97,118,101,10,37,100,32,37,100,32,37,100,32,37,100,32,98,111,120,112,114,105,109,32,99,108,105,112,32,110,101,119,112,97,116,104,10,0,47,84,105,109,101,115,45,73,116,97,108,105,99,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,100,97,114,107,103,111,108,100,101,110,114,111,100,51,0,0,100,97,114,107,103,111,108,100,101,110,114,111,100,50,0,0,100,97,114,107,103,111,108,100,101,110,114,111,100,49,0,0,100,97,114,107,103,111,108,100,101,110,114,111,100,0,0,0,109,105,110,117,115,0,0,0,47,98,117,112,117,53,47,50,0,0,0,0,0,0,0,0,99,121,97,110,52,0,0,0,99,121,97,110,51,0,0,0,99,121,97,110,50,0,0,0,99,121,97,110,49,0,0,0,99,121,97,110,0,0,0,0,32,102,105,108,108,61,34,35,37,48,50,120,37,48,50,120,37,48,50,120,34,0,0,0,99,114,105,109,115,111,110,0,37,100,32,37,100,32,37,100,32,98,101,103,105,110,112,97,103,101,10,0,0,0,0,0,99,111,114,110,115,105,108,107,52,0,0,0,0,0,0,0,99,111,114,110,115,105,108,107,51,0,0,0,0,0,0,0,99,111,114,110,115,105,108,107,50,0,0,0,0,0,0,0,99,111,114,110,115,105,108,107,49,0,0,0,0,0,0,0,109,105,100,100,111,116,0,0,98,111,116,104,0,0,0,0,47,98,117,112,117,53,47,49,0,0,0,0,0,0,0,0,99,111,114,110,115,105,108,107,0,0,0,0,0,0,0,0,99,111,114,110,102,108,111,119,101,114,98,108,117,101,0,0,99,111,114,97,108,52,0,0,99,111,114,97,108,51,0,0,99,111,114,97,108,50,0,0,32,102,105,108,108,61,34,37,115,34,0,0,0,0,0,0,99,111,114,97,108,49,0,0,32,105,100,61,34,0,0,0,60,60,32,47,80,97,103,101,83,105,122,101,32,91,37,100,32,37,100,93,32,62,62,32,115,101,116,112,97,103,101,100,101,118,105,99,101,10,0,0,99,111,114,97,108,0,0,0,99,104,111,99,111,108,97,116,101,52,0,0,0,0,0,0,99,104,111,99,111,108,97,116,101,51,0,0,0,0,0,0,99,104,111,99,111,108,97,116,101,50,0,0,0,0,0,0,109,105,99,114,111,0,0,0,47,98,117,112,117,52,47,52,0,0,0,0,0,0,0,0,99,104,111,99,111,108,97,116,101,49,0,0,0,0,0,0,99,104,111,99,111,108,97,116,101,0,0,0,0,0,0,0,99,104,97,114,116,114,101,117,115,101,52,0,0,0,0,0,99,104,97,114,116,114,101,117,115,101,51,0,0,0,0,0,99,104,97,114,116,114,101,117,115,101,50,0,0,0,0,0,32,102,111,110,116,45,115,105,122,101,61,34,37,46,50,102,34,0,0,0,0,0,0,0,99,104,97,114,116,114,101,117,115,101,49,0,0,0,0,0,80,111,114,116,114,97,105,116,0,0,0,0,0,0,0,0,99,104,97,114,116,114,101,117,115,101,0,0,0,0,0,0,47,97,99,99,101,110,116,54,47,53,0,0,0,0,0,0,99,97,100,101,116,98,108,117,101,52,0,0,0,0,0,0,99,97,100,101,116,98,108,117,101,51,0,0,0,0,0,0,99,97,100,101,116,98,108,117,101,50,0,0,0,0,0,0,109,100,97,115,104,0,0,0,47,98,117,112,117,52,47,51,0,0,0,0,0,0,0,0,99,97,100,101,116,98,108,117,101,49,0,0,0,0,0,0,99,97,100,101,116,98,108,117,101,0,0,0,0,0,0,0,98,117,114,108,121,119,111,111,100,52,0,0,0,0,0,0,98,117,114,108,121,119,111,111,100,51,0,0,0,0,0,0,98,117,114,108,121,119,111,111,100,50,0,0,0,0,0,0,32,102,111,110,116,45,102,97,109,105,108,121,61,34,37,115,34,0,0,0,0,0,0,0,98,117,114,108,121,119,111,111,100,49,0,0,0,0,0,0,76,97,110,100,115,99,97,112,101,0,0,0,0,0,0,0,98,117,114,108,121,119,111,111,100,0,0,0,0,0,0,0,110,111,110,101,0,0,0,0,98,114,111,119,110,52,0,0,98,114,111,119,110,51,0,0,98,114,111,119,110,50,0,0,109,97,99,114,0,0,0,0,47,98,117,112,117,52,47,50,0,0,0,0,0,0,0,0,98,114,111,119,110,49,0,0,98,114,111,119,110,0,0,0,98,108,117,101,118,105,111,108,101,116,0,0,0,0,0,0,98,108,117,101,52,0,0,0,98,108,117,101,51,0,0,0,32,102,111,110,116,45,115,116,121,108,101,61,34,37,115,34,0,0,0,0,0,0,0,0,98,108,117,101,50,0,0,0,45,45,0,0,0,0,0,0,112,115,58,108,97,115,105,0,37,37,37,37,80,97,103,101,79,114,105,101,110,116,97,116,105,111,110,58,32,37,115,10,0,0,0,0,0,0,0,0,98,108,117,101,49,0,0,0,98,108,117,101,0,0,0,0,98,108,97,110,99,104,101,100,97,108,109,111,110,100,0,0,98,108,97,99,107,0,0,0,108,116,0,0,0,0,0,0,47,98,117,112,117,52,47,49,0,0,0,0,0,0,0,0,98,105,115,113,117,101,52,0,98,105,115,113,117,101,51,0,98,105,115,113,117,101,50,0,98,105,115,113,117,101,49,0,32,37,100,0,0,0,0,0,98,105,115,113,117,101,0,0,73,77,71,0,0,0,0,0,32,102,111,110,116,45,115,116,114,101,116,99,104,61,34,37,115,34,0,0,0,0,0,0,98,101,105,103,101,0,0,0,37,37,37,37,80,97,103,101,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,0,0,97,122,117,114,101,52,0,0,97,122,117,114,101,51,0,0,97,122,117,114,101,50,0,0,97,122,117,114,101,49,0,0,108,115,113,117,111,0,0,0,47,98,117,112,117,51,47,51,0,0,0,0,0,0,0,0,110,97,118,121,0,0,0,0,97,122,117,114,101,0,0,0,97,113,117,97,109,97,114,105,110,101,52,0,0,0,0,0,97,113,117,97,109,97,114,105,110,101,51,0,0,0,0,0,97,113,117,97,109,97,114,105,110,101,50,0,0,0,0,0,97,113,117,97,109,97,114,105,110,101,49,0,0,0,0,0,35,37,48,50,120,37,48,50,120,37,48,50,120,0,0,0,97,113,117,97,109,97,114,105,110,101,0,0,0,0,0,0,32,102,111,110,116,45,119,101,105,103,104,116,61,34,37,115,34,0,0,0,0,0,0,0,37,37,37,37,80,97,103,101,58,32,37,100,32,37,100,10,0,0,0,0,0,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,52,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,51,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,50,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,49,0,0,0,108,115,97,113,117,111,0,0,47,98,117,112,117,51,47,50,0,0,0,0,0,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,0,0,0,0,97,108,105,99,101,98,108,117,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,57,0,0,0,0,0,0,65,118,97,110,116,71,97,114,100,101,45,68,101,109,105,79,98,108,105,113,117,101,0,0,47,121,108,111,114,114,100,57,47,56,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,55,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,54,0,0,0,0,0,0,44,37,115,0,0,0,0,0,88,77,76,32,111,114,32,116,101,120,116,32,100,101,99,108,97,114,97,116,105,111,110,32,110,111,116,32,97,116,32,115,116,97,114,116,32,111,102,32,101,110,116,105,116,121,0,0,37,37,37,37,69,110,100,80,97,103,101,58,32,37,100,10,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,53,0,0,0,0,0,0,92,72,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,52,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,51,0,0,0,0,0,0,115,101,116,108,105,110,101,119,105,100,116,104,0,0,0,0,47,121,108,111,114,114,100,57,47,50,0,0,0,0,0,0,108,114,109,0,0,0,0,0,47,98,117,112,117,51,47,49,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,57,47,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,56,47,56,0,0,0,0,0,0,47,121,108,111,114,114,100,56,47,55,0,0,0,0,0,0,108,104,101,105,103,104,116,0,47,121,108,111,114,114,100,56,47,54,0,0,0,0,0,0,45,62,0,0,0,0,0,0,66,111,117,110,100,105,110,103,66,111,120,32,110,111,116,32,102,111,117,110,100,32,105,110,32,101,112,115,102,32,102,105,108,101,32,37,115,10,0,0,47,121,108,111,114,114,100,56,47,53,0,0,0,0,0,0,47,121,108,111,114,114,100,56,47,52,0,0,0,0,0,0,32,102,111,110,116,45,102,97,109,105,108,121,61,34,37,115,0,0,0,0,0,0,0,0,99,111,114,97,108,0,0,0,37,37,80,97,103,101,84,114,97,105,108,101,114,10,0,0,47,121,108,111,114,114,100,56,47,51,0,0,0,0,0,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,32,37,115,32,37,115,32,114,97,110,107,32,37,100,32,105,32,61,32,37,100,32,97,110,32,61,32,48,10,0,0,0,0,47,121,108,111,114,114,100,56,47,50,0,0,0,0,0,0,47,121,108,111,114,114,100,56,47,49,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,55,0,0,0,0,0,0,108,111,122,0,0,0,0,0,47,98,117,103,110,57,47,57,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,54,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,53,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,52,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,51,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,50,0,0,0,0,0,0,47,121,108,111,114,114,100,55,47,49,0,0,0,0,0,0,32,120,61,34,37,103,34,32,121,61,34,37,103,34,0,0,60,115,118,103,0,0,0,0,101,110,100,112,97,103,101,10,115,104,111,119,112,97,103,101,10,103,114,101,115,116,111,114,101,10,0,0,0,0,0,0,47,84,105,109,101,115,45,82,111,109,97,110,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,0,0,0,0,47,121,108,111,114,114,100,54,47,54,0,0,0,0,0,0,47,121,108,111,114,114,100,54,47,53,0,0,0,0,0,0,47,121,108,111,114,114,100,54,47,52,0,0,0,0,0,0,47,121,108,111,114,114,100,54,47,51,0,0,0,0,0,0,108,111,119,97,115,116,0,0,47,98,117,103,110,57,47,56,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,54,47,50,0,0,0,0,0,0,47,121,108,111,114,114,100,54,47,49,0,0,0,0,0,0,47,121,108,111,114,114,100,53,47,53,0,0,0,0,0,0,37,108,102,37,108,102,37,108,102,0,0,0,0,0,0,0,47,121,108,111,114,114,100,53,47,52,0,0,0,0,0,0,47,121,108,111,114,114,100,53,47,51,0,0,0,0,0,0,47,121,108,111,114,114,100,53,47,50,0,0,0,0,0,0,32,116,101,120,116,45,97,110,99,104,111,114,61,34,109,105,100,100,108,101,34,0,0,0,48,32,48,32,48,32,101,100,103,101,99,111,108,111,114,10,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,53,47,49,0,0,0,0,0,0,47,121,108,111,114,114,100,52,47,52,0,0,0,0,0,0,47,121,108,111,114,114,100,52,47,51,0,0,0,0,0,0,47,121,108,111,114,114,100,52,47,50,0,0,0,0,0,0,108,102,108,111,111,114,0,0,98,97,99,107,0,0,0,0,47,98,117,103,110,57,47,55,0,0,0,0,0,0,0,0,47,121,108,111,114,114,100,52,47,49,0,0,0,0,0,0,48,0,0,0,0,0,0,0,47,121,108,111,114,114,100,51,47,51,0,0,0,0,0,0,47,121,108,111,114,114,100,51,47,50,0,0,0,0,0,0,47,121,108,111,114,114,100,51,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,57,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,56,0,0,0,0,0,0,32,116,101,120,116,45,97,110,99,104,111,114,61,34,101,110,100,34,0,0,0,0,0,0,37,37,32,37,115,10,0,0,47,121,108,111,114,98,114,57,47,55,0,0,0,0,0,0,78,68,95,111,117,116,40,118,41,46,115,105,122,101,32,61,61,32,50,0,0,0,0,0,60,97,114,101,97,32,115,104,97,112,101,61,34,112,111,108,121,34,0,0,0,0,0,0,71,115,116,97,99,107,32,117,110,100,101,114,102,108,111,119,32,105,110,32,103,114,97,112,104,32,112,97,114,115,101,114,10,0,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,54,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,53,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,52,0,0,0,0,0,0,108,101,0,0,0,0,0,0,47,98,117,103,110,57,47,54,0,0,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,51,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,50,0,0,0,0,0,0,47,121,108,111,114,98,114,57,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,56,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,55,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,54,0,0,0,0,0,0,32,116,101,120,116,45,97,110,99,104,111,114,61,34,115,116,97,114,116,34,0,0,0,0,103,115,97,118,101,10,0,0,47,121,108,111,114,98,114,56,47,53,0,0,0,0,0,0,47,97,99,99,101,110,116,54,47,52,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,52,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,51,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,50,0,0,0,0,0,0,108,100,113,117,111,0,0,0,47,98,117,103,110,57,47,53,0,0,0,0,0,0,0,0,47,121,108,111,114,98,114,56,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,55,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,54,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,53,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,52,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,51,0,0,0,0,0,0,60,116,101,120,116,0,0,0,103,114,101,115,116,111,114,101,10,0,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,50,0,0,0,0,0,0,116,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,47,121,108,111,114,98,114,55,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,54,47,54,0,0,0,0,0,0,47,121,108,111,114,98,114,54,47,53,0,0,0,0,0,0,108,99,101,105,108,0,0,0,47,98,117,103,110,57,47,52,0,0,0,0,0,0,0,0,47,121,108,111,114,98,114,54,47,52,0,0,0,0,0,0,47,121,108,111,114,98,114,54,47,51,0,0,0,0,0,0,47,121,108,111,114,98,114,54,47,50,0,0,0,0,0,0,47,121,108,111,114,98,114,54,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,53,47,53,0,0,0,0,0,0,47,121,108,111,114,98,114,53,47,52,0,0,0,0,0,0,47,62,10,0,0,0,0,0,45,62,0,0,0,0,0,0,112,115,58,112,115,0,0,0,32,32,47,66,111,114,100,101,114,32,91,32,48,32,48,32,48,32,93,10,32,32,47,65,99,116,105,111,110,32,60,60,32,47,83,117,98,116,121,112,101,32,47,85,82,73,32,47,85,82,73,32,37,115,32,62,62,10,32,32,47,83,117,98,116,121,112,101,32,47,76,105,110,107,10,47,65,78,78,32,112,100,102,109,97,114,107,10,0,0,0,0,0,0,0,0,47,121,108,111,114,98,114,53,47,51,0,0,0,0,0,0,45,62,0,0,0,0,0,0,47,121,108,111,114,98,114,53,47,50,0,0,0,0,0,0,47,121,108,111,114,98,114,53,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,52,47,52,0,0,0,0,0,0,108,97,114,114,0,0,0,0,47,98,117,103,110,57,47,51,0,0,0,0,0,0,0,0,47,121,108,111,114,98,114,52,47,51,0,0,0,0,0,0,47,121,108,111,114,98,114,52,47,50,0,0,0,0,0,0,47,121,108,111,114,98,114,52,47,49,0,0,0,0,0,0,47,121,108,111,114,98,114,51,47,51,0,0,0,0,0,0,47,121,108,111,114,98,114,51,47,50,0,0,0,0,0,0,32,37,115,10,0,0,0,0,66,82,0,0,0,0,0,0,47,121,108,111,114,98,114,51,47,49,0,0,0,0,0,0,32,114,120,61,34,37,103,34,32,114,121,61,34,37,103,34,0,0,0,0,0,0,0,0,32,93,10,0,0,0,0,0,47,121,108,103,110,98,117,57,47,57,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,56,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,55,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,54,0,0,0,0,0,0,108,97,113,117,111,0,0,0,47,98,117,103,110,57,47,50,0,0,0,0,0,0,0,0,109,97,114,111,111,110,0,0,47,121,108,103,110,98,117,57,47,53,0,0,0,0,0,0,37,100,32,37,49,91,34,93,37,110,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,52,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,51,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,50,0,0,0,0,0,0,47,121,108,103,110,98,117,57,47,49,0,0,0,0,0,0,34,34,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,56,0,0,0,0,0,0,32,99,120,61,34,37,103,34,32,99,121,61,34,37,103,34,0,0,0,0,0,0,0,0,105,115,109,97,112,58,109,97,112,0,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,55,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,54,0,0,0,0,0,0,91,32,47,82,101,99,116,32,91,32,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,53,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,52,0,0,0,0,0,0,108,97,110,103,0,0,0,0,47,98,117,103,110,57,47,49,0,0,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,51,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,50,0,0,0,0,0,0,47,121,108,103,110,98,117,56,47,49,0,0,0,0,0,0,99,111,109,109,101,110,116,0,47,121,108,103,110,98,117,55,47,55,0,0,0,0,0,0,98,111,108,100,0,0,0,0,47,121,108,103,110,98,117,55,47,54,0,0,0,0,0,0,47,121,108,103,110,98,117,55,47,53,0,0,0,0,0,0,60,101,108,108,105,112,115,101,0,0,0,0,0,0,0,0,114,101,102,101,114,101,110,99,101,32,116,111,32,101,120,116,101,114,110,97,108,32,101,110,116,105,116,121,32,105,110,32,97,116,116,114,105,98,117,116,101,0,0,0,0,0,0,0,32,37,115,32,97,108,105,103,110,101,100,116,101,120,116,10,0,0,0,0,0,0,0,0,47,121,108,103,110,98,117,55,47,52,0,0,0,0,0,0,47,121,108,103,110,98,117,55,47,51,0,0,0,0,0,0,92,69,0,0,0,0,0,0,47,121,108,103,110,98,117,55,47,50,0,0,0,0,0,0,98,111,108,100,0,0,0,0,47,121,108,103,110,98,117,55,47,49,0,0,0,0,0,0,108,97,109,98,100,97,0,0,47,98,117,103,110,56,47,56,0,0,0,0,0,0,0,0,47,121,108,103,110,98,117,54,47,54,0,0,0,0,0,0,47,121,108,103,110,98,117,54,47,53,0,0,0,0,0,0,69,100,103,101,32,37,112,32,119,97,115,32,110,111,116,32,102,111,117,110,100,10,0,0,47,121,108,103,110,98,117,54,47,52,0,0,0,0,0,0,108,119,105,100,116,104,0,0,47,121,108,103,110,98,117,54,47,51,0,0,0,0,0,0,116,111,111,108,116,105,112,0,114,101,97,100,0,0,0,0,47,121,108,103,110,98,117,54,47,50,0,0,0,0,0,0,47,121,108,103,110,98,117,54,47,49,0,0,0,0,0,0,37,103,44,37,103,0,0,0,32,109,111,118,101,116,111,32,0,0,0,0,0,0,0,0,99,104,111,99,111,108,97,116,101,0,0,0,0,0,0,0,47,121,108,103,110,98,117,53,47,53,0,0,0,0,0,0,47,121,108,103,110,98,117,53,47,52,0,0,0,0,0,0,47,121,108,103,110,98,117,53,47,51,0,0,0,0,0,0,47,121,108,103,110,98,117,53,47,50,0,0,0,0,0,0,108,65,114,114,0,0,0,0,47,98,117,103,110,56,47,55,0,0,0,0,0,0,0,0,47,121,108,103,110,98,117,53,47,49,0,0,0,0,0,0,47,121,108,103,110,98,117,52,47,52,0,0,0,0,0,0,47,121,108,103,110,98,117,52,47,51,0,0,0,0,0,0,47,121,108,103,110,98,117,52,47,50,0,0,0,0,0,0,47,121,108,103,110,98,117,52,47,49,0,0,0,0,0,0,47,121,108,103,110,98,117,51,47,51,0,0,0,0,0,0,60,112,111,108,121,103,111,110,0,0,0,0,0,0,0,0,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,0,0,0,0,32,47,37,115,32,115,101,116,95,102,111,110,116,10,0,0,104,101,97,100,112,111,114,116,0,0,0,0,0,0,0,0,47,121,108,103,110,98,117,51,47,50,0,0,0,0,0,0,125,32,100,101,102,0,0,0,47,121,108,103,110,98,117,51,47,49,0,0,0,0,0,0,101,114,114,111,114,32,105,110,32,99,111,108,120,108,97,116,101,40,41,10,0,0,0,0,47,121,108,103,110,57,47,57,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,56,0,0,0,0,0,0,0,0,115,105,100,101,115,32,61,61,32,52,0,0,0,0,0,0,107,97,112,112,97,0,0,0,47,98,117,103,110,56,47,54,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,55,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,54,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,53,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,52,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,51,0,0,0,0,0,0,0,0,47,121,108,103,110,57,47,50,0,0,0,0,0,0,0,0,37,99,37,103,44,37,103,0,32,101,108,108,105,112,115,101,95,112,97,116,104,32,115,116,114,111,107,101,10,0,0,0,47,121,108,103,110,57,47,49,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,56,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,55,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,54,0,0,0,0,0,0,0,0,105,117,109,108,0,0,0,0,102,111,114,119,97,114,100,0,47,98,117,103,110,56,47,53,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,53,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,52,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,51,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,50,0,0,0,0,0,0,0,0,47,121,108,103,110,56,47,49,0,0,0,0,0,0,0,0,114,111,117,116,101,115,112,108,105,110,101,115,58,32,37,100,32,101,100,103,101,115,44,32,37,100,32,98,111,120,101,115,32,37,46,50,102,32,115,101,99,10,0,0,0,0,0,0,47,121,108,103,110,55,47,55,0,0,0,0,0,0,0,0,32,100,61,34,0,0,0,0,32,101,108,108,105,112,115,101,95,112,97,116,104,32,102,105,108,108,10,0,0,0,0,0,47,121,108,103,110,55,47,54,0,0,0,0,0,0,0,0,47,121,108,103,110,55,47,53,0,0,0,0,0,0,0,0,60,97,114,101,97,32,115,104,97,112,101,61,34,114,101,99,116,34,0,0,0,0,0,0,95,97,110,111,110,121,109,111,117,115,95,37,100,0,0,0,47,121,108,103,110,55,47,52,0,0,0,0,0,0,0,0,47,121,108,103,110,55,47,51,0,0,0,0,0,0,0,0,47,112,97,116,104,98,111,120,32,123,10,32,32,32,32,47,89,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,88,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,121,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,120,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,110,101,119,112,97,116,104,32,120,32,121,32,109,111,118,101,116,111,10,32,32,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,32,32,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,32,125,32,100,101,102,10,47,100,98,103,115,116,97,114,116,32,123,32,103,115,97,118,101,32,37,46,53,103,32,37,46,53,103,32,116,114,97,110,115,108,97,116,101,32,125,32,100,101,102,10,47,97,114,114,111,119,108,101,110,103,116,104,32,49,48,32,100,101,102,10,47,97,114,114,111,119,119,105,100,116,104,32,97,114,114,111,119,108,101,110,103,116,104,32,50,32,100,105,118,32,100,101,102,10,47,97,114,114,111,119,104,101,97,100,32,123,10,32,32,32,32,103,115,97,118,101,10,32,32,32,32,114,111,116,97,116,101,10,32,32,32,32,99,117,114,114,101,110,116,112,111,105,110,116,10,32,32,32,32,110,101,119,112,97,116,104,10,32,32,32,32,109,111,118,101,116,111,10,32,32,32,32,97,114,114,111,119,108,101,110,103,116,104,32,97,114,114,111,119,119,105,100,116,104,32,50,32,100,105,118,32,114,108,105,110,101,116,111,10,32,32,32,32,48,32,97,114,114,111,119,119,105,100,116,104,32,110,101,103,32,114,108,105,110,101,116,111,10,32,32,32,32,99,108,111,115,101,112,97,116,104,32,102,105,108,108,10,32,32,32,32,103,114,101,115,116,111,114,101,10,125,32,98,105,110,100,32,100,101,102,10,47,109,97,107,101,97,114,114,111,119,32,123,10,32,32,32,32,99,117,114,114,101,110,116,112,111,105,110,116,32,101,120,99,104,32,112,111,112,32,115,117,98,32,101,120,99,104,32,99,117,114,114,101,110,116,112,111,105,110,116,32,112,111,112,32,115,117,98,32,97,116,97,110,10,32,32,32,32,97,114,114,111,119,104,101,97,100,10,125,32,98,105,110,100,32,100,101,102,10,47,112,111,105,110,116,32,123,32,32,32,32,110,101,119,112,97,116,104,32,32,32,32,50,32,48,32,51,54,48,32,97,114,99,32,102,105,108,108,125,32,100,101,102,47,109,97,107,101,118,101,99,32,123,10,32,32,32,32,47,89,32,101,120,99,104,32,100,101,102,10,32,32,32,32,47,88,32,101,120,99,104,32,100,101,102,10,32,32,32,32,47,121,32,101,120,99,104,32,100,101,102,10,32,32,32,32,47,120,32,101,120,99,104,32,100,101,102,10,32,32,32,32,110,101,119,112,97,116,104,32,120,32,121,32,109,111,118,101,116,111,10,32,32,32,32,88,32,89,32,108,105,110,101,116,111,32,115,116,114,111,107,101,10,32,32,32,32,88,32,89,32,109,111,118,101,116,111,10,32,32,32,32,120,32,121,32,109,97,107,101,97,114,114,111,119,10,125,32,100,101,102,10,0,0,0,0,0,0,105,115,105,110,0,0,0,0,47,98,117,103,110,56,47,52,0,0,0,0,0,0,0,0,47,121,108,103,110,55,47,50,0,0,0,0,0,0,0,0,47,121,108,103,110,55,47,49,0,0,0,0,0,0,0,0,47,121,108,103,110,54,47,54,0,0,0,0,0,0,0,0,47,121,108,103,110,54,47,53,0,0,0,0,0,0,0,0,47,121,108,103,110,54,47,52,0,0,0,0,0,0,0,0,47,121,108,103,110,54,47,51,0,0,0,0,0,0,0,0,60,112,97,116,104,0,0,0,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,0,0,0,0,0,0,0,47,121,108,103,110,54,47,50,0,0,0,0,0,0,0,0,47,97,99,99,101,110,116,54,47,51,0,0,0,0,0,0,47,121,108,103,110,54,47,49,0,0,0,0,0,0,0,0,47,121,108,103,110,53,47,53,0,0,0,0,0,0,0,0,47,121,108,103,110,53,47,52,0,0,0,0,0,0,0,0,105,113,117,101,115,116,0,0,47,98,117,103,110,56,47,51,0,0,0,0,0,0,0,0,47,121,108,103,110,53,47,51,0,0,0,0,0,0,0,0,47,121,108,103,110,53,47,50,0,0,0,0,0,0,0,0,47,121,108,103,110,53,47,49,0,0,0,0,0,0,0,0,47,121,108,103,110,52,47,52,0,0,0,0,0,0,0,0,47,121,108,103,110,52,47,51,0,0,0,0,0,0,0,0,47,121,108,103,110,52,47,50,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,99,108,111,115,101,112,97,116,104,32,102,105,108,108,10,0,47,121,108,103,110,52,47,49,0,0,0,0,0,0,0,0,37,115,32,37,100,32,110,111,100,101,115,32,37,100,32,101,100,103,101,115,32,109,97,120,105,116,101,114,61,37,100,32,98,97,108,97,110,99,101,61,37,100,10,0,0,0,0,0,101,103,103,0,0,0,0,0,47,121,108,103,110,51,47,51,0,0,0,0,0,0,0,0,47,121,108,103,110,51,47,50,0,0,0,0,0,0,0,0,47,121,108,103,110,51,47,49,0,0,0,0,0,0,0,0,105,111,116,97,0,0,0,0,47,98,117,103,110,56,47,50,0,0,0,0,0,0,0,0,47,115,118,103,47,121,101,108,108,111,119,103,114,101,101,110,0,0,0,0,0,0,0,0,47,115,118,103,47,121,101,108,108,111,119,0,0,0,0,0,47,115,118,103,47,119,104,105,116,101,115,109,111,107,101,0,47,115,118,103,47,119,104,105,116,101,0,0,0,0,0,0,47,115,118,103,47,119,104,101,97,116,0,0,0,0,0,0,47,115,118,103,47,118,105,111,108,101,116,0,0,0,0,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,115,118,103,46,99,0,0,0,0,0,99,111,108,111,114,0,0,0,101,112,115,58,108,97,115,105,0,0,0,0,0,0,0,0,32,99,117,114,118,101,116,111,10,0,0,0,0,0,0,0,47,115,118,103,47,116,117,114,113,117,111,105,115,101,0,0,116,101,120,116,108,97,121,111,117,116,0,0,0,0,0,0,47,115,118,103,47,116,111,109,97,116,111,0,0,0,0,0,47,115,118,103,47,116,104,105,115,116,108,101,0,0,0,0,47,115,118,103,47,116,101,97,108,0,0,0,0,0,0,0,105,110,116,0,0,0,0,0,47,98,117,103,110,56,47,49,0,0,0,0,0,0,0,0,47,115,118,103,47,116,97,110,0,0,0,0,0,0,0,0,47,115,118,103,47,115,116,101,101,108,98,108,117,101,0,0,47,115,118,103,47,115,112,114,105,110,103,103,114,101,101,110,0,0,0,0,0,0,0,0,47,115,118,103,47,115,110,111,119,0,0,0,0,0,0,0,47,115,118,103,47,115,108,97,116,101,103,114,101,121,0,0,83,85,66,0,0,0,0,0,47,115,118,103,47,115,108,97,116,101,103,114,97,121,0,0,35,37,48,50,120,37,48,50,120,37,48,50,120,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,115,116,114,111,107,101,10,0,47,115,118,103,47,115,108,97,116,101,98,108,117,101,0,0,47,115,118,103,47,115,107,121,98,108,117,101,0,0,0,0,47,115,118,103,47,115,105,108,118,101,114,0,0,0,0,0,47,115,118,103,47,115,105,101,110,110,97,0,0,0,0,0,105,110,102,105,110,0,0,0,47,98,117,103,110,55,47,55,0,0,0,0,0,0,0,0,108,105,109,101,0,0,0,0,47,115,118,103,47,115,101,97,115,104,101,108,108,0,0,0,47,115,118,103,47,115,101,97,103,114,101,101,110,0,0,0,108,105,110,101,0,0,0,0,47,115,118,103,47,115,97,110,100,121,98,114,111,119,110,0,47,115,118,103,47,115,97,108,109,111,110,0,0,0,0,0,47,115,118,103,47,115,97,100,100,108,101,98,114,111,119,110,0,0,0,0,0,0,0,0,32,45,116,97,103,115,32,123,37,100,37,115,37,100,125,0,47,115,118,103,47,114,111,121,97,108,98,108,117,101,0,0,53,44,50,0,0,0,0,0,32,108,105,110,101,116,111,10,0,0,0,0,0,0,0,0,47,115,118,103,47,114,111,115,121,98,114,111,119,110,0,0,47,115,118,103,47,114,101,100,0,0,0,0,0,0,0,0,47,115,118,103,47,112,117,114,112,108,101,0,0,0,0,0,47,115,118,103,47,112,111,119,100,101,114,98,108,117,101,0,105,109,97,103,101,0,0,0,47,98,117,103,110,55,47,54,0,0,0,0,0,0,0,0,47,115,118,103,47,112,108,117,109,0,0,0,0,0,0,0,47,115,118,103,47,112,105,110,107,0,0,0,0,0,0,0,47,115,118,103,47,112,101,114,117,0,0,0,0,0,0,0,47,115,118,103,47,112,101,97,99,104,112,117,102,102,0,0,37,108,100,0,0,0,0,0,100,101,109,105,0,0,0,0,47,115,118,103,47,112,97,112,97,121,97,119,104,105,112,0,47,115,118,103,47,112,97,108,101,118,105,111,108,101,116,114,101,100,0,0,0,0,0,0,49,44,53,0,0,0,0,0,114,101,102,101,114,101,110,99,101,32,116,111,32,98,105,110,97,114,121,32,101,110,116,105,116,121,0,0,0,0,0,0,32,109,111,118,101,116,111,10,0,0,0,0,0,0,0,0,47,115,118,103,47,112,97,108,101,116,117,114,113,117,111,105,115,101,0,0,0,0,0,0,47,115,118,103,47,112,97,108,101,103,114,101,101,110,0,0,92,78,0,0,0,0,0,0,47,115,118,103,47,112,97,108,101,103,111,108,100,101,110,114,111,100,0,0,0,0,0,0,102,105,108,108,101,100,0,0,102,108,97,116,105,110,100,101,120,40,97,103,116,97,105,108,40,101,41,41,32,60,32,77,45,62,110,99,111,108,115,0,47,115,118,103,47,111,114,99,104,105,100,0,0,0,0,0,105,103,114,97,118,101,0,0,47,98,117,103,110,55,47,53,0,0,0,0,0,0,0,0,47,115,118,103,47,111,114,97,110,103,101,114,101,100,0,0,47,115,118,103,47,111,114,97,110,103,101,0,0,0,0,0,34,34,0,0,0,0,0,0,115,104,111,114,116,101,115,116,46,99,0,0,0,0,0,0,47,115,118,103,47,111,108,105,118,101,100,114,97,98,0,0,116,97,105,108,95,108,112,0,47,115,118,103,47,111,108,105,118,101,0,0,0,0,0,0,114,0,0,0,0,0,0,0,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,0,0,0,0,47,115,118,103,47,111,108,100,108,97,99,101,0,0,0,0,47,115,118,103,47,110,97,118,121,0,0,0,0,0,0,0,34,0,0,0,0,0,0,0,110,101,119,112,97,116,104,32,0,0,0,0,0,0,0,0,99,104,97,114,116,114,101,117,115,101,0,0,0,0,0,0,47,115,118,103,47,110,97,118,97,106,111,119,104,105,116,101,0,0,0,0,0,0,0,0,47,115,118,103,47,109,111,99,99,97,115,105,110,0,0,0,47,115,118,103,47,109,105,115,116,121,114,111,115,101,0,0,47,115,118,103,47,109,105,110,116,99,114,101,97,109,0,0,102,97,108,115,101,0,0,0,105,101,120,99,108,0,0,0,47,98,117,103,110,55,47,52,0,0,0,0,0,0,0,0,47,115,118,103,47,109,105,100,110,105,103,104,116,98,108,117,101,0,0,0,0,0,0,0,103,105,102,58,115,118,103,0,47,115,118,103,47,109,101,100,105,117,109,118,105,111,108,101,116,114,101,100,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,116,117,114,113,117,111,105,115,101,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,115,112,114,105,110,103,103,114,101,101,110,0,0,47,115,118,103,47,109,101,100,105,117,109,115,108,97,116,101,98,108,117,101,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,115,101,97,103,114,101,101,110,0,0,0,0,0,34,32,115,116,114,111,107,101,45,111,112,97,99,105,116,121,61,34,37,102,0,0,0,0,37,37,66,111,117,110,100,105,110,103,66,111,120,58,0,0,10,0,0,0,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,112,117,114,112,108,101,0,0,0,0,0,0,0,116,97,105,108,112,111,114,116,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,99,117,114,114,101,110,116,100,105,99,116,32,101,110,100,32,100,101,102,105,110,101,102,111,110,116,0,0,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,111,114,99,104,105,100,0,0,0,0,0,0,0,37,115,32,105,115,32,110,111,116,32,97,32,107,110,111,119,110,32,99,111,108,111,114,46,10,0,0,0,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,98,108,117,101,0,83,121,110,116,97,120,32,101,114,114,111,114,58,32,110,111])
.concat([110,45,115,112,97,99,101,32,115,116,114,105,110,103,32,117,115,101,100,32,97,102,116,101,114,32,60,47,84,65,66,76,69,62,0,0,0,0,0,0,47,115,118,103,47,109,101,100,105,117,109,97,113,117,97,109,97,114,105,110,101,0,0,0,105,99,105,114,99,0,0,0,47,98,117,103,110,55,47,51,0,0,0,0,0,0,0,0,47,115,118,103,47,109,97,114,111,111,110,0,0,0,0,0,47,115,118,103,47,109,97,103,101,110,116,97,0,0,0,0,47,115,118,103,47,108,105,110,101,110,0,0,0,0,0,0,47,115,118,103,47,108,105,109,101,103,114,101,101,110,0,0,47,115,118,103,47,108,105,109,101,0,0,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,121,101,108,108,111,119,0,0,0,0,0,0,0,0,34,32,115,116,114,111,107,101,45,100,97,115,104,97,114,114,97,121,61,34,37,115,0,0,37,32,0,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,115,116,101,101,108,98,108,117,101,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,115,108,97,116,101,103,114,101,121,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,115,108,97,116,101,103,114,97,121,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,115,107,121,98,108,117,101,0,0,0,0,0,0,0,105,97,99,117,116,101,0,0,105,110,118,101,109,112,116,121,0,0,0,0,0,0,0,0,47,98,117,103,110,55,47,50,0,0,0,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,115,101,97,103,114,101,101,110,0,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,115,97,108,109,111,110,0,0,0,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,112,105,110,107,0,0,102,108,97,116,105,110,100,101,120,40,97,103,104,101,97,100,40,101,41,41,32,60,32,77,45,62,110,114,111,119,115,0,47,115,118,103,47,108,105,103,104,116,103,114,101,121,0,0,47,115,118,103,47,108,105,103,104,116,103,114,101,101,110,0,47,115,118,103,47,108,105,103,104,116,103,114,97,121,0,0,34,32,115,116,114,111,107,101,45,119,105,100,116,104,61,34,37,103,0,0,0,0,0,0,37,46,53,103,32,37,46,53,103,32,37,46,53,103,32,37,115,99,111,108,111,114,10,0,47,115,118,103,47,108,105,103,104,116,103,111,108,100,101,110,114,111,100,121,101,108,108,111,119,0,0,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,99,121,97,110,0,0,47,115,118,103,47,108,105,103,104,116,99,111,114,97,108,0,60,97,114,101,97,32,115,104,97,112,101,61,34,99,105,114,99,108,101,34,0,0,0,0,80,108,101,97,115,101,32,117,115,101,32,97,32,115,105,110,103,108,101,32,100,101,102,105,110,105,116,105,111,110,32,111,102,32,116,104,101,32,115,117,98,103,114,97,112,104,32,119,105,116,104,105,110,32,116,104,101,32,99,111,110,116,101,120,116,32,111,102,32,105,116,115,32,112,97,114,101,110,116,32,103,114,97,112,104,32,34,37,115,34,10,0,0,0,0,0,47,115,118,103,47,108,105,103,104,116,98,108,117,101,0,0,104,101,108,108,105,112,0,0,47,98,117,103,110,55,47,49,0,0,0,0,0,0,0,0,47,115,118,103,47,108,101,109,111,110,99,104,105,102,102,111,110,0,0,0,0,0,0,0,47,115,118,103,47,108,97,119,110,103,114,101,101,110,0,0,47,115,118,103,47,108,97,118,101,110,100,101,114,98,108,117,115,104,0,0,0,0,0,0,47,115,118,103,47,108,97,118,101,110,100,101,114,0,0,0,47,115,118,103,47,107,104,97,107,105,0,0,0,0,0,0,47,115,118,103,47,105,118,111,114,121,0,0,0,0,0,0,34,32,115,116,114,111,107,101,61,34,0,0,0,0,0,0,115,101,116,104,115,98,0,0,47,115,118,103,47,105,110,100,105,103,111,0,0,0,0,0,47,97,99,99,101,110,116,54,47,50,0,0,0,0,0,0,47,115,118,103,47,105,110,100,105,97,110,114,101,100,0,0,47,115,118,103,47,104,111,116,112,105,110,107,0,0,0,0,47,115,118,103,47,104,111,110,101,121,100,101,119,0,0,0,104,101,97,114,116,115,0,0,47,98,117,103,110,54,47,54,0,0,0,0,0,0,0,0,47,115,118,103,47,103,114,101,121,0,0,0,0,0,0,0,47,115,118,103,47,103,114,101,101,110,121,101,108,108,111,119,0,0,0,0,0,0,0,0,47,115,118,103,47,103,114,101,101,110,0,0,0,0,0,0,47,115,118,103,47,103,114,97,121,0,0,0,0,0,0,0,47,115,118,103,47,103,111,108,100,101,110,114,111,100,0,0,47,115,118,103,47,103,111,108,100,0,0,0,0,0,0,0,110,111,110,101,0,0,0,0,101,100,103,101,0,0,0,0,47,115,118,103,47,103,104,111,115,116,119,104,105,116,101,0,112,111,105,110,116,0,0,0,47,115,118,103,47,103,97,105,110,115,98,111,114,111,0,0,47,115,118,103,47,102,117,99,104,115,105,97,0,0,0,0,47,115,118,103,47,102,111,114,101,115,116,103,114,101,101,110,0,0,0,0,0,0,0,0,104,97,114,114,0,0,0,0,47,98,117,103,110,54,47,53,0,0,0,0,0,0,0,0,47,115,118,103,47,102,108,111,114,97,108,119,104,105,116,101,0,0,0,0,0,0,0,0,47,115,118,103,47,102,105,114,101,98,114,105,99,107,0,0,47,115,118,103,47,100,111,100,103,101,114,98,108,117,101,0,47,115,118,103,47,100,105,109,103,114,101,121,0,0,0,0,47,115,118,103,47,100,105,109,103,114,97,121,0,0,0,0,47,115,118,103,47,100,101,101,112,115,107,121,98,108,117,101,0,0,0,0,0,0,0,0,34,32,102,105,108,108,45,111,112,97,99,105,116,121,61,34,37,102,0,0,0,0,0,0,112,101,110,99,111,108,111,114,0,0,0,0,0,0,0,0,110,111,100,101,0,0,0,0,101,112,115,58,112,115,0,0,47,115,118,103,47,100,101,101,112,112,105,110,107,0,0,0,47,115,118,103,47,100,97,114,107,118,105,111,108,101,116,0,47,115,118,103,47,100,97,114,107,116,117,114,113,117,111,105,115,101,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,115,108,97,116,101,103,114,101,121,0,0,0,0,0,0,104,65,114,114,0,0,0,0,47,98,117,103,110,54,47,52,0,0,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,115,108,97,116,101,103,114,97,121,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,115,108,97,116,101,98,108,117,101,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,115,101,97,103,114,101,101,110,0,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,115,97,108,109,111,110,0,47,115,118,103,47,100,97,114,107,114,101,100,0,0,0,0,83,85,80,0,0,0,0,0,47,115,118,103,47,100,97,114,107,111,114,99,104,105,100,0,32,102,105,108,108,61,34,0,103,114,97,112,104,0,0,0,47,115,118,103,47,100,97,114,107,111,114,97,110,103,101,0,110,32,62,61,32,52,0,0,47,115,118,103,47,100,97,114,107,111,108,105,118,101,103,114,101,101,110,0,0,0,0,0,47,115,118,103,47,100,97,114,107,109,97,103,101,110,116,97,0,0,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,107,104,97,107,105,0,0,103,116,0,0,0,0,0,0,47,98,117,103,110,54,47,51,0,0,0,0,0,0,0,0,103,114,101,101,110,0,0,0,47,115,118,103,47,100,97,114,107,103,114,101,121,0,0,0,47,115,118,103,47,100,97,114,107,103,114,101,101,110,0,0,47,115,118,103,47,100,97,114,107,103,114,97,121,0,0,0,37,115,58,37,100,58,32,115,116,114,105,110,103,32,114,97,110,32,112,97,115,116,32,101,110,100,32,111,102,32,108,105,110,101,10,0,0,0,0,0,47,115,118,103,47,100,97,114,107,103,111,108,100,101,110,114,111,100,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,99,121,97,110,0,0,0,48,0,0,0,0,0,0,0,47,115,118,103,47,100,97,114,107,98,108,117,101,0,0,0,34,47,62,10,0,0,0,0,37,115,10,0,0,0,0,0,47,115,118,103,47,99,121,97,110,0,0,0,0,0,0,0,47,115,118,103,47,99,114,105,109,115,111,110,0,0,0,0,47,115,118,103,47,99,111,114,110,115,105,108,107,0,0,0,47,115,118,103,47,99,111,114,110,102,108,111,119,101,114,98,108,117,101,0,0,0,0,0,103,101,0,0,0,0,0,0,47,98,117,103,110,54,47,50,0,0,0,0,0,0,0,0,47,115,118,103,47,99,111,114,97,108,0,0,0,0,0,0,47,115,118,103,47,99,104,111,99,111,108,97,116,101,0,0,47,115,118,103,47,99,104,97,114,116,114,101,117,115,101,0,47,115,118,103,47,99,97,100,101,116,98,108,117,101,0,0,65,118,97,110,116,71,97,114,100,101,45,68,101,109,105,0,47,115,118,103,47,98,117,114,108,121,119,111,111,100,0,0,101,100,103,101,0,0,0,0,47,115,118,103,47,98,114,111,119,110,0,0,0,0,0,0,37,103,44,37,103,32,0,0,114,101,102,101,114,101,110,99,101,32,116,111,32,105,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,32,110,117,109,98,101,114,0,0,0,105,110,118,105,115,0,0,0,47,115,118,103,47,98,108,117,101,118,105,111,108,101,116,0,47,115,118,103,47,98,108,117,101,0,0,0,0,0,0,0,92,71,0,0,0,0,0,0,47,115,118,103,47,98,108,97,110,99,104,101,100,97,108,109,111,110,100,0,0,0,0,0,83,32,0,0,0,0,0,0,47,115,118,103,47,98,108,97,99,107,0,0,0,0,0,0,103,97,109,109,97,0,0,0,47,98,117,103,110,54,47,49,0,0,0,0,0,0,0,0,69,68,95,116,111,95,118,105,114,116,40,101,41,32,33,61,32,78,85,76,76,0,0,0,47,115,118,103,47,98,105,115,113,117,101,0,0,0,0,0,47,115,118,103,47,98,101,105,103,101,0,0,0,0,0,0,44,32,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,116,114,105,115,0,0,0,0,0,47,115,118,103,47,97,122,117,114,101,0,0,0,0,0,0,60,72,84,77,76,62,0,0,104,101,97,100,95,108,112,0,47,115,118,103,47,97,113,117,97,109,97,114,105,110,101,0,110,101,119,46,103,118,0,0,99,111,117,108,100,110,39,116,32,111,112,101,110,32,101,112,115,102,32,102,105,108,101,32,37,115,10,0,0,0,0,0,47,115,118,103,47,97,113,117,97,0,0,0,0,0,0,0,47,115,118,103,47,97,110,116,105,113,117,101,119,104,105,116,101,0,0,0,0,0,0,0,32,112,111,105,110,116,115,61,34,0,0,0,0,0,0,0,37,115,32,0,0,0,0,0,115,97,109,101,104,101,97,100,0,0,0,0,0,0,0,0,99,97,100,101,116,98,108,117,101,0,0,0,0,0,0,0,47,115,118,103,47,97,108,105,99,101,98,108,117,101,0,0,47,115,112,101,99,116,114,97,108,57,47,57,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,56,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,55,0,0,0,0,102,114,97,115,108,0,0,0,47,98,117,103,110,53,47,53,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,54,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,53,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,52,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,51,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,50,0,0,0,0,47,115,112,101,99,116,114,97,108,57,47,49,0,0,0,0,60,112,111,108,121,108,105,110,101,0,0,0,0,0,0,0,109,109,0,0,0,0,0,0,115,101,116,108,105,110,101,119,105,100,116,104,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,56,0,0,0,0,98,108,97,99,107,0,0,0,32,32,32,32,32,32,32,32,47,69,110,99,111,100,105,110,103,32,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,100,101,102,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,55,0,0,0,0,99,111,108,111,114,32,37,115,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,54,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,53,0,0,0,0,102,114,97,99,51,52,0,0,47,98,117,103,110,53,47,52,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,52,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,51,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,50,0,0,0,0,47,115,112,101,99,116,114,97,108,56,47,49,0,0,0,0,47,115,112,101,99,116,114,97,108,55,47,55,0,0,0,0,47,115,112,101,99,116,114,97,108,55,47,54,0,0,0,0,32,45,45,62,10,0,0,0,32,115,101,116,108,105,110,101,119,105,100,116,104,10,0,0,47,115,112,101,99,116,114,97,108,55,47,53,0,0,0,0,47,115,112,101,99,116,114,97,108,55,47,52,0,0,0,0,47,115,112,101,99,116,114,97,108,55,47,51,0,0,0,0,47,115,112,101,99,116,114,97,108,55,47,50,0,0,0,0,102,114,97,99,49,52,0,0,104,97,108,102,0,0,0,0,47,98,117,103,110,53,47,51,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,55,47,49,0,0,0,0,47,115,112,101,99,116,114,97,108,54,47,54,0,0,0,0,47,115,112,101,99,116,114,97,108,54,47,53,0,0,0,0,47,115,112,101,99,116,114,97,108,54,47,52,0,0,0,0,78,68,95,114,97,110,107,40,118,41,32,61,61,32,114,0,47,115,112,101,99,116,114,97,108,54,47,51,0,0,0,0,47,115,112,101,99,116,114,97,108,54,47,50,0,0,0,0,60,33,45,45,32,0,0,0,32,93,32,32,37,100,32,102,97,108,115,101,32,37,115,10,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,54,47,49,0,0,0,0,47,115,112,101,99,116,114,97,108,53,47,53,0,0,0,0,47,115,112,101,99,116,114,97,108,53,47,52,0,0,0,0,47,115,112,101,99,116,114,97,108,53,47,51,0,0,0,0,102,114,97,99,49,50,0,0,47,98,117,103,110,53,47,50,0,0,0,0,0,0,0,0,114,101,99,116,97,110,103,108,101,32,40,37,100,44,37,100,41,32,40,37,100,44,37,100,41,32,37,115,32,37,115,10,0,0,0,0,0,0,0,0,84,104,105,115,32,109,97,121,32,99,97,117,115,101,32,117,110,101,120,112,101,99,116,101,100,32,98,101,104,97,118,105,111,114,32,111,114,32,99,114,97,115,104,32,116,104,101,32,112,114,111,103,114,97,109,46,10,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,53,47,50,0,0,0,0,47,115,112,101,99,116,114,97,108,53,47,49,0,0,0,0,47,115,112,101,99,116,114,97,108,52,47,52,0,0,0,0,47,115,112,101,99,116,114,97,108,52,47,51,0,0,0,0,47,115,112,101,99,116,114,97,108,52,47,50,0,0,0,0,47,115,112,101,99,116,114,97,108,52,47,49,0,0,0,0,121,101,108,108,111,119,103,114,101,101,110,0,0,0,0,0,32,93,32,32,37,100,32,116,114,117,101,32,37,115,10,0,47,115,112,101,99,116,114,97,108,51,47,51,0,0,0,0,101,32,33,61,32,78,85,76,76,0,0,0,0,0,0,0,47,97,99,99,101,110,116,54,47,49,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,51,47,50,0,0,0,0,47,115,112,101,99,116,114,97,108,51,47,49,0,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,57,0,0,0,102,111,114,97,108,108,0,0,47,98,117,103,110,53,47,49,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,56,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,55,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,54,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,53,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,52,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,51,0,0,0,121,101,108,108,111,119,0,0,38,108,116,59,0,0,0,0,32,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,50,0,0,0,99,105,114,99,108,101,0,0,47,115,112,101,99,116,114,97,108,49,49,47,49,49,0,0,47,115,112,101,99,116,114,97,108,49,49,47,49,48,0,0,101,110,100,32,112,111,114,116,58,32,40,37,46,53,103,44,32,37,46,53,103,41,44,32,116,97,110,103,101,110,116,32,97,110,103,108,101,58,32,37,46,53,103,44,32,37,115,10,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,49,49,47,49,0,0,0,102,110,111,102,0,0,0,0,47,98,117,103,110,52,47,52,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,57,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,56,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,55,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,54,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,53,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,52,0,0,0,119,104,105,116,101,115,109,111,107,101,0,0,0,0,0,0,78,111,32,111,114,32,105,109,112,114,111,112,101,114,32,105,109,97,103,101,32,102,105,108,101,61,34,37,115,34,10,0,91,32,0,0,0,0,0,0,106,112,103,58,118,114,109,108,0,0,0,0,0,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,51,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,50,0,0,0,47,115,112,101,99,116,114,97,108,49,48,47,49,48,0,0,47,115,112,101,99,116,114,97,108,49,48,47,49,0,0,0,101,120,105,115,116,0,0,0,47,98,117,103,110,52,47,51,0,0,0,0,0,0,0,0,47,115,101,116,51,57,47,57,0,0,0,0,0,0,0,0,47,115,101,116,51,57,47,56,0,0,0,0,0,0,0,0,47,115,101,116,51,57,47,55,0,0,0,0,0,0,0,0,47,115,101,116,51,57,47,54,0,0,0,0,0,0,0,0,47,115,101,116,51,57,47,53,0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,0,47,115,101,116,51,57,47,52,0,0,0,0,0,0,0,0,119,104,105,116,101,0,0,0,101,112,115,58,112,115,0,0,47,115,101,116,51,57,47,51,0,0,0,0,0,0,0,0,47,115,101,116,51,57,47,50,0,0,0,0,0,0,0,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,102,105,103,46,99,0,0,0,0,0,47,115,101,116,51,57,47,49,0,0,0,0,0,0,0,0,71,0,0,0,0,0,0,0,47,115,101,116,51,56,47,56,0,0,0,0,0,0,0,0,101,117,114,111,0,0,0,0,47,98,117,103,110,52,47,50,0,0,0,0,0,0,0,0,103,114,97,121,0,0,0,0,47,115,101,116,51,56,47,55,0,0,0,0,0,0,0,0,47,115,101,116,51,56,47,54,0,0,0,0,0,0,0,0,47,115,101,116,51,56,47,53,0,0,0,0,0,0,0,0,47,115,101,116,51,56,47,52,0,0,0,0,0,0,0,0,110,111,110,45,116,101,114,109,105,110,97,116,101,100,32,72,84,77,76,32,115,116,114,105,110,103,32,115,116,97,114,116,105,110,103,32,108,105,110,101,32,37,100,44,32,102,105,108,101,32,37,115,10,0,0,0,47,115,101,116,51,56,47,51,0,0,0,0,0,0,0,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,116,107,46,99,0,0,0,0,0,0,47,115,101,116,51,56,47,50,0,0,0,0,0,0,0,0,119,104,101,97,116,0,0,0,112,115,50,58,112,115,0,0,47,115,101,116,51,56,47,49,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,55,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,54,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,53,0,0,0,0,0,0,0,0,101,117,109,108,0,0,0,0,47,98,117,103,110,52,47,49,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,52,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,51,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,50,0,0,0,0,0,0,0,0,47,115,101,116,51,55,47,49,0,0,0,0,0,0,0,0,105,116,97,108,105,99,0,0,47,115,101,116,51,54,47,54,0,0,0,0,0,0,0,0,47,115,101,116,51,54,47,53,0,0,0,0,0,0,0,0,110,111,100,101,0,0,0,0,118,105,111,108,101,116,0,0,97,115,121,110,99,104,114,111,110,111,117,115,32,101,110,116,105,116,121,0,0,0,0,0,112,115,58,112,115,0,0,0,47,115,101,116,51,54,47,52,0,0,0,0,0,0,0,0,47,115,101,116,51,54,47,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,115,101,116,51,54,47,50,0,0,0,0,0,0,0,0,115,101,116,108,105,110,101,119,105,100,116,104,40,37,46,51,102,41,0,0,0,0,0,0,116,107,58,116,107,0,0,0,47,115,101,116,51,54,47,49,0,0,0,0,0,0,0,0,101,116,104,0,0,0,0,0,119,101,105,103,104,116,0,0,47,98,117,103,110,51,47,51,0,0,0,0,0,0,0,0,47,115,101,116,51,53,47,53,0,0,0,0,0,0,0,0,47,115,101,116,51,53,47,52,0,0,0,0,0,0,0,0,44,10,0,0,0,0,0,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,116,114,105,115,0,0,0,0,0,0,47,115,101,116,51,53,47,51,0,0,0,0,0,0,0,0,108,112,0,0,0,0,0,0,47,115,101,116,51,53,47,50,0,0,0,0,0,0,0,0,85,84,70,45,56,32,105,110,112,117,116,32,117,115,101,115,32,110,111,110,45,76,97,116,105,110,49,32,99,104,97,114,97,99,116,101,114,115,32,119,104,105,99,104,32,99,97,110,110,111,116,32,98,101,32,104,97,110,100,108,101,100,32,98,121,32,116,104,105,115,32,80,111,115,116,83,99,114,105,112,116,32,100,114,105,118,101,114,10,0,0,0,0,0,0,0,103,114,97,112,104,118,105,122,0,0,0,0,0,0,0,0,47,115,101,116,51,53,47,49,0,0,0,0,0,0,0,0,47,115,101,116,51,52,47,52,0,0,0,0,0,0,0,0,116,117,114,113,117,111,105,115,101,0,0,0,0,0,0,0,112,115,0,0,0,0,0,0,47,115,101,116,51,52,47,51,0,0,0,0,0,0,0,0,98,117,114,108,121,119,111,111,100,0,0,0,0,0,0,0,47,115,101,116,51,52,47,50,0,0,0,0,0,0,0,0,47,115,101,116,51,52,47,49,0,0,0,0,0,0,0,0,47,115,101,116,51,51,47,51,0,0,0,0,0,0,0,0,101,116,97,0,0,0,0,0,47,98,117,103,110,51,47,50,0,0,0,0,0,0,0,0,47,115,101,116,51,51,47,50,0,0,0,0,0,0,0,0,47,115,101,116,51,51,47,49,0,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,57,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,56,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,55,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,54,0,0,0,0,0,0,0,116,111,109,97,116,111,0,0,99,109,0,0,0,0,0,0,37,37,69,110,100,83,101,116,117,112,0,0,0,0,0,0,47,115,101,116,51,49,50,47,53,0,0,0,0,0,0,0,84,105,109,101,115,45,82,111,109,97,110,0,0,0,0,0,32,32,32,32,32,32,32,32,125,32,102,111,114,97,108,108,0,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,52,0,0,0,0,0,0,0,98,111,116,104,0,0,0,0,47,115,101,116,51,49,50,47,51,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,50,0,0,0,0,0,0,0,101,113,117,105,118,0,0,0,47,98,117,103,110,51,47,49,0,0,0,0,0,0,0,0,47,115,101,116,51,49,50,47,49,50,0,0,0,0,0,0,47,115,101,116,51,49,50,47,49,49,0,0,0,0,0,0,47,115,101,116,51,49,50,47,49,48,0,0,0,0,0,0,41,10,45,45,62,10,0,0,47,115,101,116,51,49,50,47,49,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,57,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,56,0,0,0,0,0,0,0,116,104,105,115,116,108,101,0,125,32,105,102,0,0,0,0,47,115,101,116,51,49,49,47,55,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,54,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,53,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,52,0,0,0,0,0,0,0,101,112,115,105,108,111,110,0,101,0,0,0,0,0,0,0,47,98,114,98,103,57,47,57,0,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,51,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,50,0,0,0,0,0,0,0,47,115,101,116,51,49,49,47,49,49,0,0,0,0,0,0,32,40,0,0,0,0,0,0,47,115,101,116,51,49,49,47,49,48,0,0,0,0,0,0,47,115,101,116,51,49,49,47,49,0,0,0,0,0,0,0,109,105,110,99,114,111,115,115,58,32,112,97,115,115,32,37,100,32,105,116,101,114,32,37,100,32,116,114,121,105,110,103,32,37,100,32,99,117,114,95,99,114,111,115,115,32,37,100,32,98,101,115,116,95,99,114,111,115,115,32,37,100,10,0,47,115,101,116,51,49,48,47,57,0,0,0,0,0,0,0,116,101,97,108,0,0,0,0,32,32,32,32,117,115,101,114,100,105,99,116,32,40,62,62,41,32,99,118,110,32,40,91,41,32,99,118,110,32,108,111,97,100,32,112,117,116,0,0,47,115,101,116,51,49,48,47,56,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,55,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,54,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,53,0,0,0,0,0,0,0,101,110,115,112,0,0,0,0,47,98,114,98,103,57,47,56,0,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,52,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,84,104,101,32,117,115,101,32,111,102,32,34,115,117,98,103,114,97,112,104,32,37,115,34,44,32,108,105,110,101,32,37,100,44,32,119,105,116,104,111,117,116,32,97,32,98,111,100,121,32,105,115,32,100,101,112,114,101,99,97,116,101,100,46,10,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,51,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,50,0,0,0,0,0,0,0,32,118,101,114,115,105,111,110,32,0,0,0,0,0,0,0,47,115,101,116,51,49,48,47,49,48,0,0,0,0,0,0,47,115,101,116,51,49,48,47,49,0,0,0,0,0,0,0,47,115,101,116,50,56,47,56,0,0,0,0,0,0,0,0,116,97,110,0,0,0,0,0,32,32,32,32,117,115,101,114,100,105,99,116,32,40,60,60,41,32,99,118,110,32,40,91,41,32,99,118,110,32,108,111,97,100,32,112,117,116,0,0,47,115,101,116,50,56,47,55,0,0,0,0,0,0,0,0,76,101,102,116,0,0,0,0,47,115,101,116,50,56,47,54,0,0,0,0,0,0,0,0,47,97,99,99,101,110,116,53,47,53,0,0,0,0,0,0,47,115,101,116,50,56,47,53,0,0,0,0,0,0,0,0,47,115,101,116,50,56,47,52,0,0,0,0,0,0,0,0,101,109,115,112,0,0,0,0,47,98,114,98,103,57,47,55,0,0,0,0,0,0,0,0,47,115,101,116,50,56,47,51,0,0,0,0,0,0,0,0,47,115,101,116,50,56,47,50,0,0,0,0,0,0,0,0,47,115,101,116,50,56,47,49,0,0,0,0,0,0,0,0,10,60,33,45,45,32,71,101,110,101,114,97,116,101,100,32,98,121,32,0,0,0,0,0,47,115,101,116,50,55,47,55,0,0,0,0,0,0,0,0,47,115,101,116,50,55,47,54,0,0,0,0,0,0,0,0,47,115,101,116,50,55,47,53,0,0,0,0,0,0,0,0,115,116,101,101,108,98,108,117,101,0,0,0,0,0,0,0,50,32,108,116,32,123,0,0,47,115,101,116,50,55,47,52,0,0,0,0,0,0,0,0,111,118,97,108,0,0,0,0,47,115,101,116,50,55,47,51,0,0,0,0,0,0,0,0,47,115,101,116,50,55,47,50,0,0,0,0,0,0,0,0,110,111,116,32,99,111,110,115,116,114,97,105,110,101,100,0,47,115,101,116,50,55,47,49,0,0,0,0,0,0,0,0,101,109,112,116,121,0,0,0,47,98,114,98,103,57,47,54,0,0,0,0,0,0,0,0,47,115,101,116,50,54,47,54,0,0,0,0,0,0,0,0,47,115,101,116,50,54,47,53,0,0,0,0,0,0,0,0,47,115,101,116,50,54,47,52,0,0,0,0,0,0,0,0,60,72,84,77,76,62,10,0,47,115,101,116,50,54,47,51,0,0,0,0,0,0,0,0,47,115,101,116,50,54,47,50,0,0,0,0,0,0,0,0,47,115,101,116,50,54,47,49,0,0,0,0,0,0,0,0,115,112,114,105,110,103,103,114,101,101,110,0,0,0,0,0,102,105,120,101,100,32,99,101,108,108,32,115,105,122,101,32,119,105,116,104,32,117,110,115,112,101,99,105,102,105,101,100,32,119,105,100,116,104,32,111,114,32,104,101,105,103,104,116,10,0,0,0,0,0,0,0,102,105,103,58,102,105,103,0,106,112,101,58,118,114,109,108,0,0,0,0,0,0,0,0,47,115,101,116,50,53,47,53,0,0,0,0,0,0,0,0,47,115,101,116,50,53,47,52,0,0,0,0,0,0,0,0,47,108,97,110,103,117,97,103,101,108,101,118,101,108,32,119,104,101,114,101,32,123,112,111,112,32,108,97,110,103,117,97,103,101,108,101,118,101,108,125,123,49,125,32,105,102,101,108,115,101,0,0,0,0,0,0,47,115,101,116,50,53,47,51,0,0,0,0,0,0,0,0,47,115,101,116,50,53,47,50,0,0,0,0,0,0,0,0,101,103,114,97,118,101,0,0,47,98,114,98,103,57,47,53,0,0,0,0,0,0,0,0,47,115,101,116,50,53,47,49,0,0,0,0,0,0,0,0,47,115,101,116,50,52,47,52,0,0,0,0,0,0,0,0,47,115,101,116,50,52,47,51,0,0,0,0,0,0,0,0,101,99,105,114,99,0,0,0,32,99,111,111,114,100,111,114,105,103,105,110,61,34,48,44,48,34,32,99,111,111,114,100,115,105,122,101,61,34,37,100,44,37,100,34,32,62,0,0,47,115,101,116,50,52,47,50,0,0,0,0,0,0,0,0,47,115,101,116,50,52,47,49,0,0,0,0,0,0,0,0,47,115,101,116,50,51,47,51,0,0,0,0,0,0,0,0,85,0,0,0,0,0,0,0,115,110,111,119,0,0,0,0,37,32,109,97,107,101,32,39,60,60,39,32,97,110,100,32,39,62,62,39,32,115,97,102,101,32,111,110,32,80,83,32,76,101,118,101,108,32,49,32,100,101,118,105,99,101,115,0,47,115,101,116,50,51,47,50,0,0,0,0,0,0,0,0,47,115,101,116,50,51,47,49,0,0,0,0,0,0,0,0,47,115,101,116,49,57,47,57,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,47,115,101,116,49,57,47,56,0,0,0,0,0,0,0,0,108,0,0,0,0,0,0,0,47,98,114,98,103,57,47,52,0,0,0,0,0,0,0,0,47,115,101,116,49,57,47,55,0,0,0,0,0,0,0,0,102,117,99,104,115,105,97,0,47,115,101,116,49,57,47,54,0,0,0,0,0,0,0,0,47,115,101,116,49,57,47,53,0,0,0,0,0,0,0,0,32,119,105,100,116,104,58,32,37,100,112,116,59,32,104,101,105,103,104,116,58,32,37,100,112,116,34,0,0,0,0,0,47,115,101,116,49,57,47,52,0,0,0,0,0,0,0,0,47,115,101,116,49,57,47,51,0,0,0,0,0,0,0,0,103,114,97,112,104,32,108,97,98,101,108,0,0,0,0,0,37,115,58,37,100,58,32,97,109,98,105,103,117,111,117,115,32,34,37,115,34,32,115,112,108,105,116,115,32,105,110,116,111,32,116,119,111,32,110,97,109,101,115,58,32,34,37,115,34,32,97,110,100,32,34,37,115,34,10,0,0,0,0,0,47,115,101,116,49,57,47,50,0,0,0,0,0,0,0,0,115,108,97,116,101,103,114,101,121,0,0,0,0,0,0,0,47,112,100,102,109,97,114,107,32,119,104,101,114,101,32,123,112,111,112,125,32,123,117,115,101,114,100,105,99,116,32,47,112,100,102,109,97,114,107,32,47,99,108,101,97,114,116,111,109,97,114,107,32,108,111,97,100,32,112,117,116,125,32,105,102,101,108,115,101,0,0,0,47,115,101,116,49,57,47,49,0,0,0,0,0,0,0,0,102,111,110,116,110,97,109,101,58,32,117,110,97,98,108,101,32,116,111,32,114,101,115,111,108,118,101,32,34,37,115,34,10,0,0,0,0,0,0,0,115,97,109,101,116,97,105,108,0,0,0,0,0,0,0,0,47,115,101,116,49,56,47,56,0,0,0,0,0,0,0,0,47,115,101,116,49,56,47,55,0,0,0,0,0,0,0,0,47,115,101,116,49,56,47,54,0,0,0,0,0,0,0,0,101,97,99,117,116,101,0,0,47,98,114,98,103,57,47,51,0,0,0,0,0,0,0,0,47,115,101,116,49,56,47,53,0,0,0,0,0,0,0,0,47,115,101,116,49,56,47,52,0,0,0,0,0,0,0,0,47,115,101,116,49,56,47,51,0,0,0,0,0,0,0,0,32,60,118,58,103,114,111,117,112,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,32,0,0,0,0,47,115,101,116,49,56,47,50,0,0,0,0,0,0,0,0,111,98,108,105,113,117,101,0,47,115,101,116,49,56,47,49,0,0,0,0,0,0,0,0,47,115,101,116,49,55,47,55,0,0,0,0,0,0,0,0,115,108,97,116,101,103,114,97,121,0,0,0,0,0,0,0,114,101,99,117,114,115,105,118,101,32,101,110,116,105,116,121,32,114,101,102,101,114,101,110,99,101,0,0,0,0,0,0,37,32,109,97,107,101,32,115,117,114,101,32,112,100,102,109,97,114,107,32,105,115,32,104,97,114,109,108,101,115,115,32,102,111,114,32,80,83,45,105,110,116,101,114,112,114,101,116,101,114,115,32,111,116,104,101,114,32,116,104,97,110,32,68,105,115,116,105,108,108,101,114,0,0,0,0,0,0,0,0,47,115,101,116,49,55,47,54,0,0,0,0,0,0,0,0,103,114,97,112,104,0,0,0,47,115,101,116,49,55,47,53,0,0,0,0,0,0,0,0,38,35,51,57,59,0,0,0,47,115,101,116,49,55,47,52,0,0,0,0,0,0,0,0,35,37,48,50,120,37,48,50,120,37,48,50,120,37,48,50,120,0,0,0,0,0,0,0,32,91,0,0,0,0,0,0,47,115,101,116,49,55,47,51,0,0,0,0,0,0,0,0,100,105,118,105,100,101,0,0,47,98,114,98,103,57,47,50,0,0,0,0,0,0,0,0,108,104,101,97,100,0,0,0,47,115,101,116,49,55,47,50,0,0,0,0,0,0,0,0,47,115,101,116,49,55,47,49,0,0,0,0,0,0,0,0,97,103,117,115,101,114,103,114,97,112,104,0,0,0,0,0,114,111,117,116,101,46,99,0,47,115,101,116,49,54,47,54,0,0,0,0,0,0,0,0,120,108,112,0,0,0,0,0,60,120,109,108,58,110,97,109,101,115,112,97,99,101,32,110,115,61,34,117,114,110,58,115,99,104,101,109,97,115,45,109,105,99,114,111,115,111,102,116,45,99,111,109,58,118,109,108,34,32,112,114,101,102,105,120,61,34,118,34,32,47,62,10,0,0,0,0,0,0,0,0,47,115,101,116,49,54,47,53,0,0,0,0,0,0,0,0,70,0,0,0,0,0,0,0,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,0,47,115,101,116,49,54,47,52,0,0,0,0,0,0,0,0,47,115,101,116,49,54,47,51,0,0,0,0,0,0,0,0,115,108,97,116,101,98,108,117,101,0,0,0,0,0,0,0,37,32,47,97,114,114,111,119,119,105,100,116,104,32,53,32,100,101,102,0,0,0,0,0,47,115,101,116,49,54,47,50,0,0,0,0,0,0,0,0,98,114,111,119,110,0,0,0,76,97,121,111,117,116,32,116,121,112,101,58,32,34,37,115,34,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,46,32,85,115,101,32,111,110,101,32,111,102,58,37,115,10,0,0,0,0,0,0,0,0,47,115,101,116,49,54,47,49,0,0,0,0,0,0,0,0,47,115,101,116,49,53,47,53,0,0,0,0,0,0,0,0,47,115,101,116,49,53,47,52,0,0,0,0,0,0,0,0,100,105,97,109,115,0,0,0,47,98,114,98,103,57,47,49,0,0,0,0,0,0,0,0,99,108,117,115,116,101,114,32,110,97,109,101,100,32,37,115,32,110,111,116,32,102,111,117,110,100,10,0,0,0,0,0,47,115,101,116,49,53,47,51,0,0,0,0,0,0,0,0,47,115,101,116,49,53,47,50,0,0,0,0,0,0,0,0,47,115,101,116,49,53,47,49,0,0,0,0,0,0,0,0,60,47,83,84,89,76,69,62,10,0,0,0,0,0,0,0,47,115,101,116,49,52,47,52,0,0,0,0,0,0,0,0,47,115,101,116,49,52,47,51,0,0,0,0,0,0,0,0,47,115,101,116,49,52,47,50,0,0,0,0,0,0,0,0,115,107,121,98,108,117,101,0,34,0,0,0,0,0,0,0,37,32,47,97,114,114,111,119,108,101,110,103,116,104,32,49,48,32,100,101,102,0,0,0,110,115,108,105,109,105,116,49,0,0,0,0,0,0,0,0,47,115,101,116,49,52,47,49,0,0,0,0,0,0,0,0,101,108,108,105,112,115,101,0,32,32,32,32,32,32,32,32,123,32,49,32,105,110,100,101,120,32,47,70,73,68,32,110,101,32,123,32,100,101,102,32,125,123,32,112,111,112,32,112,111,112,32,125,32,105,102,101,108,115,101,0,0,0,0,0,116,114,105,97,110,103,117,108,97,116,105,111,110,32,102,97,105,108,101,100,0,0,0,0,47,115,101,116,49,51,47,51,0,0,0,0,0,0,0,0,104,101,105,103,104,116,0,0,47,115,101,116,49,51,47,50,0,0,0,0,0,0,0,0,47,115,101,116,49,51,47,49,0,0,0,0,0,0,0,0,100,101,108,116,97,0,0,0,47,98,114,98,103,56,47,56,0,0,0,0,0,0,0,0,47,114,101,100,115,57,47,57,0,0,0,0,0,0,0,0,47,114,101,100,115,57,47,56,0,0,0,0,0,0,0,0,47,114,101,100,115,57,47,55,0,0,0,0,0,0,0,0,118,92,58,42,32,123,32,98,101,104,97,118,105,111,114,58,32,117,114,108,40,35,100,101,102,97,117,108,116,35,86,77,76,41,59,100,105,115,112,108,97,121,58,105,110,108,105,110,101,45,98,108,111,99,107,125,10,0,0,0,0,0,0,0,47,114,101,100,115,57,47,54,0,0,0,0,0,0,0,0,47,114,101,100,115,57,47,53,0,0,0,0,0,0,0,0,47,114,101,100,115,57,47,52,0,0,0,0,0,0,0,0,115,105,108,118,101,114,0,0,49,32,115,101,116,109,105,116,101,114,108,105,109,105,116,0,47,114,101,100,115,57,47,51,0,0,0,0,0,0,0,0,105,110,32,108,97,98,101,108,32,111,102,32,110,111,100,101,32,37,115,10,0,0,0,0,69,68,95,108,97,98,101,108,40,102,101,41,0,0,0,0,73,32,0,0,0,0,0,0,100,111,116,0,0,0,0,0,47,114,101,100,115,57,47,50,0,0,0,0,0,0,0,0,47,114,101,100,115,57,47,49,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,56,0,0,0,0,0,0,0,0,100,101,103,0,0,0,0,0,99,114,111,119,0,0,0,0,47,98,114,98,103,56,47,55,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,55,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,54,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,53,0,0,0,0,0,0,0,0,60,83,84,89,76,69,62,10,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,52,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,51,0,0,0,0,0,0,0,0,47,114,101,100,115,56,47,50,0,0,0,0,0,0,0,0,115,105,101,110,110,97,0,0,109,101,114,103,101,50,58,32,103,114,97,112,104,32,37,115,44,32,114,97,110,107,32,37,100,32,104,97,115,32,111,110,108,121,32,37,100,32,60,32,37,100,32,110,111,100,101,115,10,0,0,0,0,0,0,0,49,52,32,100,101,102,97,117,108,116,45,102,111,110,116,45,102,97,109,105,108,121,32,115,101,116,95,102,111,110,116,0,47,114,101,100,115,56,47,49,0,0,0,0,0,0,0,0,99,108,97,115,115,50,46,99,0,0,0,0,0,0,0,0,47,114,101,100,115,55,47,55,0,0,0,0,0,0,0,0,47,114,101,100,115,55,47,54,0,0,0,0,0,0,0,0,47,114,101,100,115,55,47,53,0,0,0,0,0,0,0,0,100,97,114,114,0,0,0,0,47,98,114,98,103,56,47,54,0,0,0,0,0,0,0,0,47,114,101,100,115,55,47,52,0,0,0,0,0,0,0,0,47,114,101,100,115,55,47,51,0,0,0,0,0,0,0,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,109,97,112,46,99,0,0,0,0,0,71,115,116,97,99,107,32,111,118,101,114,102,108,111,119,32,105,110,32,103,114,97,112,104,32,112,97,114,115,101,114,10,0,0,0,0,0,0,0,0,47,114,101,100,115,55,47,50,0,0,0,0,0,0,0,0,32,119,105,100,116,104,58,32,37,100,112,116,59,32,104,101,105,103,104,116,58,32,37,100,112,116,34,62,10,0,0,0,47,114,101,100,115,55,47,49,0,0,0,0,0,0,0,0,47,114,101,100,115,54,47,54,0,0,0,0,0,0,0,0,47,114,101,100,115,54,47,53,0,0,0,0,0,0,0,0,115,101,97,115,104,101,108,108,0,0,0,0,0,0,0,0,37,37,66,101,103,105,110,83,101,116,117,112,0,0,0,0,47,114,101,100,115,54,47,52,0,0,0,0,0,0,0,0,85,110,115,117,112,112,111,114,116,101,100,32,99,104,97,114,115,101,116,32,34,37,115,34,32,45,32,97,115,115,117,109,105,110,103,32,117,116,102,45,56,10,0,0,0,0,0,0,47,114,101,100,115,54,47,51,0,0,0,0,0,0,0,0,47,97,99,99,101,110,116,53,47,52,0,0,0,0,0,0,47,114,101,100,115,54,47,50,0,0,0,0,0,0,0,0,47,114,101,100,115,54,47,49,0,0,0,0,0,0,0,0,100,97,103,103,101,114,0,0,47,98,114,98,103,56,47,53,0,0,0,0,0,0,0,0,47,114,101,100,115,53,47,53,0,0,0,0,0,0,0,0])
.concat([47,114,101,100,115,53,47,52,0,0,0,0,0,0,0,0,47,114,101,100,115,53,47,51,0,0,0,0,0,0,0,0,60,68,73,86,32,105,100,61,39,95,86,77,76,49,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,32,100,105,115,112,108,97,121,58,105,110,108,105,110,101,59,32,118,105,115,105,98,105,108,105,116,121,58,104,105,100,100,101,110,0,0,0,0,47,114,101,100,115,53,47,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,114,101,100,115,53,47,49,0,0,0,0,0,0,0,0,47,114,101,100,115,52,47,52,0,0,0,0,0,0,0,0,115,101,97,103,114,101,101,110,0,0,0,0,0,0,0,0,99,32,0,0,0,0,0,0,47,114,101,100,115,52,47,51,0,0,0,0,0,0,0,0,117,116,102,56,0,0,0,0,101,108,108,105,112,115,101,0,47,114,101,100,115,52,47,50,0,0,0,0,0,0,0,0,37,37,69,110,100,80,114,111,108,111,103,0,0,0,0,0,47,114,101,100,115,52,47,49,0,0,0,0,0,0,0,0,99,111,110,115,116,114,97,105,110,101,100,0,0,0,0,0,47,114,101,100,115,51,47,51,0,0,0,0,0,0,0,0,100,65,114,114,0,0,0,0,47,98,114,98,103,56,47,52,0,0,0,0,0,0,0,0,47,114,101,100,115,51,47,50,0,0,0,0,0,0,0,0,47,114,101,100,115,51,47,49,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,57,0,0,0,0,0,0,32,0,0,0,0,0,0,0,60,66,79,68,89,32,111,110,108,111,97,100,61,39,98,114,111,119,115,101,114,99,104,101,99,107,40,41,59,39,62,10,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,56,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,55,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,54,0,0,0,0,0,0,115,97,110,100,121,98,114,111,119,110,0,0,0,0,0,0,37,37,69,110,100,82,101,115,111,117,114,99,101,0,0,0,99,101,108,108,32,115,105,122,101,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,99,111,110,116,101,110,116,10,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,53,0,0,0,0,0,0,106,112,101,103,58,118,114,109,108,0,0,0,0,0,0,0,98,105,103,53,0,0,0,0,47,114,100,121,108,103,110,57,47,52,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,51,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,50,0,0,0,0,0,0,99,117,114,114,101,110,0,0,47,98,114,98,103,56,47,51,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,57,47,49,0,0,0,0,0,0,47,114,100,121,108,103,110,56,47,56,0,0,0,0,0,0,47,114,100,121,108,103,110,56,47,55,0,0,0,0,0,0,60,47,72,69,65,68,62,0,47,114,100,121,108,103,110,56,47,54,0,0,0,0,0,0,47,114,100,121,108,103,110,56,47,53,0,0,0,0,0,0,47,114,100,121,108,103,110,56,47,52,0,0,0,0,0,0,66,0,0,0,0,0,0,0,115,97,108,109,111,110,0,0,47,99,117,114,108,97,121,101,114,32,48,32,100,101,102,0,47,114,100,121,108,103,110,56,47,51,0,0,0,0,0,0,98,105,103,45,53,0,0,0,47,114,100,121,108,103,110,56,47,50,0,0,0,0,0,0,47,114,100,121,108,103,110,56,47,49,0,0,0,0,0,0,92,78,0,0,0,0,0,0,47,114,100,121,108,103,110,55,47,55,0,0,0,0,0,0,99,117,112,0,0,0,0,0,115,104,97,112,101,102,105,108,101,32,110,111,116,32,115,101,116,32,111,114,32,110,111,116,32,102,111,117,110,100,32,102,111,114,32,101,112,115,102,32,110,111,100,101,32,37,115,10,0,0,0,0,0,0,0,0,32,37,100,32,37,100,0,0,47,98,114,98,103,56,47,50,0,0,0,0,0,0,0,0,75,80,95,83,117,98,116,114,97,99,116,0,0,0,0,0,47,114,100,121,108,103,110,55,47,54,0,0,0,0,0,0,98,108,117,101,0,0,0,0,47,114,100,121,108,103,110,55,47,53,0,0,0,0,0,0,47,114,100,121,108,103,110,55,47,52,0,0,0,0,0,0,32,32,32,60,47,83,67,82,73,80,84,62,10,0,0,0,47,114,100,121,108,103,110,55,47,51,0,0,0,0,0,0,47,114,100,121,108,103,110,55,47,50,0,0,0,0,0,0,103,114,97,112,104,0,0,0,47,114,100,121,108,103,110,55,47,49,0,0,0,0,0,0,115,97,100,100,108,101,98,114,111,119,110,0,0,0,0,0,32,60,60,60,32,0,0,0,9,123,105,110,118,105,115,125,32,105,102,0,0,0,0,0,47,114,100,121,108,103,110,54,47,54,0,0,0,0,0,0,99,111,109,112,111,117,110,100,0,0,0,0,0,0,0,0,59,10,0,0,0,0,0,0,73,83,79,45,73,82,45,49,48,48,0,0,0,0,0,0,47,114,100,121,108,103,110,54,47,53,0,0,0,0,0,0,115,97,109,101,104,101,97,100,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,54,47,52,0,0,0,0,0,0,47,114,100,121,108,103,110,54,47,51,0,0,0,0,0,0,99,114,97,114,114,0,0,0,47,98,114,98,103,56,47,49,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,54,47,50,0,0,0,0,0,0,47,114,100,121,108,103,110,54,47,49,0,0,0,0,0,0,47,114,100,121,108,103,110,53,47,53,0,0,0,0,0,0,47,114,100,121,108,103,110,53,47,52,0,0,0,0,0,0,32,32,32,125,10,0,0,0,65,118,97,110,116,71,97,114,100,101,45,66,111,111,107,79,98,108,105,113,117,101,0,0,47,114,100,121,108,103,110,53,47,51,0,0,0,0,0,0,47,114,100,121,108,103,110,53,47,50,0,0,0,0,0,0,114,111,121,97,108,98,108,117,101,0,0,0,0,0,0,0,117,110,100,101,102,105,110,101,100,32,101,110,116,105,116,121,0,0,0,0,0,0,0,0,9,111,114,0,0,0,0,0,47,114,100,121,108,103,110,53,47,49,0,0,0,0,0,0,73,83,79,56,56,53,57,45,49,0,0,0,0,0,0,0,47,114,100,121,108,103,110,52,47,52,0,0,0,0,0,0,105,100,0,0,0,0,0,0,38,113,117,111,116,59,0,0,47,114,100,121,108,103,110,52,47,51,0,0,0,0,0,0,37,100,32,37,100,32,0,0,47,114,100,121,108,103,110,52,47,50,0,0,0,0,0,0,99,111,112,121,0,0,0,0,69,68,95,116,111,95,118,105,114,116,40,101,41,32,61,61,32,78,85,76,76,0,0,0,47,98,114,98,103,55,47,55,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,52,47,49,0,0,0,0,0,0,47,114,100,121,108,103,110,51,47,51,0,0,0,0,0,0,123,10,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,112,110,108,112,115,0,0,0,0,47,114,100,121,108,103,110,51,47,50,0,0,0,0,0,0,104,101,105,103,104,116,0,0,47,114,100,121,108,103,110,51,47,49,0,0,0,0,0,0,32,32,32,32,32,125,10,0,37,37,69,110,100,68,111,99,117,109,101,110,116,10,0,0,47,114,100,121,108,103,110,49,49,47,57,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,56,0,0,0,0,0,114,111,115,121,98,114,111,119,110,0,0,0,0,0,0,0,9,99,117,114,108,97,121,101,114,32,109,121,117,112,112,101,114,32,103,116,0,0,0,0,47,114,100,121,108,103,110,49,49,47,55,0,0,0,0,0,98,108,117,101,118,105,111,108,101,116,0,0,0,0,0,0,73,83,79,95,56,56,53,57,45,49,0,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,54,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,53,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,52,0,0,0,0,0,99,111,110,103,0,0,0,0,47,98,114,98,103,55,47,54,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,51,0,0,0,0,0,40,37,46,53,103,44,37,46,53,103,41,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,50,0,0,0,0,0,47,114,100,121,108,103,110,49,49,47,49,49,0,0,0,0,47,114,100,121,108,103,110,49,49,47,49,48,0,0,0,0,32,32,32,32,32,125,101,108,115,101,123,10,0,0,0,0,47,114,100,121,108,103,110,49,49,47,49,0,0,0,0,0,115,118,103,58,115,118,103,0,114,97,110,107,0,0,0,0,47,114,100,121,108,103,110,49,48,47,57,0,0,0,0,0,114,101,100,0,0,0,0,0,112,116,0,0,0,0,0,0,9,99,117,114,108,97,121,101,114,32,109,121,108,111,119,101,114,32,108,116,0,0,0,0,47,114,100,121,108,103,110,49,48,47,56,0,0,0,0,0,99,111,110,99,46,99,0,0,108,49,0,0,0,0,0,0,103,118,117,115,101,114,115,104,97,112,101,46,99,0,0,0,32,32,32,32,32,32,32,32,100,117,112,32,100,117,112,32,102,105,110,100,102,111,110,116,32,100,117,112,32,108,101,110,103,116,104,32,100,105,99,116,32,98,101,103,105,110,0,0,99,108,117,98,115,0,0,0,47,114,100,121,108,103,110,49,48,47,55,0,0,0,0,0,119,105,100,116,104,0,0,0,47,114,100,121,108,103,110,49,48,47,54,0,0,0,0,0,47,114,100,121,108,103,110,49,48,47,53,0,0,0,0,0,67,111,117,108,100,32,110,111,116,32,112,97,114,115,101,32,34,95,100,114,97,119,95,34,32,97,116,116,114,105,98,117,116,101,32,105,110,32,103,114,97,112,104,32,37,115,10,0,47,98,114,98,103,55,47,53,0,0,0,0,0,0,0,0,47,114,100,121,108,103,110,49,48,47,52,0,0,0,0,0,47,114,100,121,108,103,110,49,48,47,51,0,0,0,0,0,47,114,100,121,108,103,110,49,48,47,50,0,0,0,0,0,47,114,100,121,108,103,110,49,48,47,49,48,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,105,116,101,109,46,115,116,121,108,101,46,118,105,115,105,98,105,108,105,116,121,61,39,104,105,100,100,101,110,39,59,10,0,0,0,0,0,47,114,100,121,108,103,110,49,48,47,49,0,0,0,0,0,47,114,100,121,108,98,117,57,47,57,0,0,0,0,0,0,112,117,114,112,108,101,0,0,9,47,109,121,108,111,119,101,114,32,101,120,99,104,32,100,101,102,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,56,0,0,0,0,0,0,108,97,116,105,110,49,0,0,67,111,117,108,100,32,110,111,116,32,111,112,101,110,32,34,37,115,34,32,102,111,114,32,119,114,105,116,105,110,103,32,58,32,37,115,10,0,0,0,47,114,100,121,108,98,117,57,47,55,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,54,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,53,0,0,0,0,0,0,99,105,114,99,0,0,0,0,114,0,0,0,0,0,0,0,47,98,114,98,103,55,47,52,0,0,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,52,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,51,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,50,0,0,0,0,0,0,47,114,100,121,108,98,117,57,47,49,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,105,116,101,109,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,86,77,76,110,111,91,120,93,41,59,10,0,0,0,0,0,47,114,100,121,108,98,117,56,47,56,0,0,0,0,0,0,47,114,100,121,108,98,117,56,47,55,0,0,0,0,0,0,112,111,119,100,101,114,98,108,117,101,0,0,0,0,0,0,9,47,109,121,117,112,112,101,114,32,101,120,99,104,32,100,101,102,0,0,0,0,0,0,47,114,100,121,108,98,117,56,47,54,0,0,0,0,0,0,108,97,116,105,110,45,49,0,109,105,110,99,114,111,115,115,32,37,115,58,32,37,100,32,99,114,111,115,115,105,110,103,115,44,32,37,46,50,102,32,115,101,99,115,46,10,0,0,47,114,100,121,108,98,117,56,47,53,0,0,0,0,0,0,47,114,100,121,108,98,117,56,47,52,0,0,0,0,0,0,47,114,100,121,108,98,117,56,47,51,0,0,0,0,0,0,99,104,105,0,0,0,0,0,47,98,114,98,103,55,47,51,0,0,0,0,0,0,0,0,47,114,100,121,108,98,117,56,47,50,0,0,0,0,0,0,47,114,100,121,108,98,117,56,47,49,0,0,0,0,0,0,47,114,100,121,108,98,117,55,47,55,0,0,0,0,0,0,10,0,0,0,0,0,0,0,47,114,100,121,108,98,117,55,47,54,0,0,0,0,0,0,32,32,32,32,32,32,32,102,111,114,32,40,120,32,105,110,32,86,77,76,110,111,41,123,10,0,0,0,0,0,0,0,47,114,100,121,108,98,117,55,47,53,0,0,0,0,0,0,47,114,100,121,108,98,117,55,47,52,0,0,0,0,0,0,112,108,117,109,0,0,0,0,47,111,110,108,97,121,101,114,115,32,123,0,0,0,0,0,47,114,100,121,108,98,117,55,47,51,0,0,0,0,0,0,117,116,102,45,56,0,0,0,47,114,100,121,108,98,117,55,47,50,0,0,0,0,0,0,47,97,99,99,101,110,116,53,47,51,0,0,0,0,0,0,47,114,100,121,108,98,117,55,47,49,0,0,0,0,0,0,47,114,100,121,108,98,117,54,47,54,0,0,0,0,0,0,99,101,110,116,0,0,0,0,47,98,114,98,103,55,47,50,0,0,0,0,0,0,0,0,47,114,100,121,108,98,117,54,47,53,0,0,0,0,0,0,47,114,100,121,108,98,117,54,47,52,0,0,0,0,0,0,47,114,100,121,108,98,117,54,47,51,0,0,0,0,0,0,47,114,100,121,108,98,117,54,47,50,0,0,0,0,0,0,32,32,32,32,32,32,32,125,10,0,0,0,0,0,0,0,47,114,100,121,108,98,117,54,47,49,0,0,0,0,0,0,47,114,100,121,108,98,117,53,47,53,0,0,0,0,0,0,112,105,110,107,0,0,0,0,47,111,110,108,97,121,101,114,32,123,32,99,117,114,108,97,121,101,114,32,110,101,32,123,105,110,118,105,115,125,32,105,102,32,125,32,100,101,102,0,47,114,100,121,108,98,117,53,47,52,0,0,0,0,0,0,99,104,97,114,115,101,116,0,112,111,108,121,103,111,110,0,47,114,100,121,108,98,117,53,47,51,0,0,0,0,0,0,47,114,100,121,108,98,117,53,47,50,0,0,0,0,0,0,115,116,97,114,116,32,112,111,114,116,58,32,40,37,46,53,103,44,32,37,46,53,103,41,44,32,116,97,110,103,101,110,116,32,97,110,103,108,101,58,32,37,46,53,103,44,32,37,115,10,0,0,0,0,0,0,47,114,100,121,108,98,117,53,47,49,0,0,0,0,0,0,99,101,100,105,108,0,0,0,47,98,114,98,103,55,47,49,0,0,0,0,0,0,0,0,47,114,100,121,108,98,117,52,47,52,0,0,0,0,0,0,47,114,100,121,108,98,117,52,47,51,0,0,0,0,0,0,47,114,100,121,108,98,117,52,47,50,0,0,0,0,0,0,47,114,100,121,108,98,117,52,47,49,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,125,10,0,0,0,0,0,47,114,100,121,108,98,117,51,47,51,0,0,0,0,0,0,47,114,100,121,108,98,117,51,47,50,0,0,0,0,0,0,112,101,114,117,0,0,0,0,78,111,32,108,111,97,100,105,109,97,103,101,32,112,108,117,103,105,110,32,102,111,114,32,34,37,115,34,10,0,0,0,9,47,103,114,97,112,104,99,111,108,111,114,32,123,110,111,112,99,111,108,111,114,125,32,100,101,102,0,0,0,0,0,102,105,120,101,100,32,116,97,98,108,101,32,115,105,122,101,32,119,105,116,104,32,117,110,115,112,101,99,105,102,105,101,100,32,119,105,100,116,104,32,111,114,32,104,101,105,103,104,116,10,0,0,0,0,0,0,47,114,100,121,108,98,117,51,47,49,0,0,0,0,0,0,103,105,102,58,118,114,109,108,0,0,0,0,0,0,0,0,102,105,108,108,0,0,0,0,47,114,100,121,108,98,117,49,49,47,57,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,56,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,55,0,0,0,0,0,99,99,101,100,105,108,0,0,47,98,114,98,103,54,47,54,0,0,0,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,54,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,53,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,52,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,51,0,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,105,116,101,109,46,115,116,121,108,101,46,118,105,115,105,98,105,108,105,116,121,61,39,118,105,115,105,98,108,101,39,59,10,0,0,0,0,47,114,100,121,108,98,117,49,49,47,50,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,49,49,0,0,0,0,70,79,78,84,0,0,0,0,115,97,109,101,116,97,105,108,0,0,0,0,0,0,0,0,112,101,97,99,104,112,117,102,102,0,0,0,0,0,0,0,9,47,101,100,103,101,99,111,108,111,114,32,123,110,111,112,99,111,108,111,114,125,32,100,101,102,0,0,0,0,0,0,112,111,115,105,116,105,111,110,46,99,0,0,0,0,0,0,47,114,100,121,108,98,117,49,49,47,49,48,0,0,0,0,101,120,112,97,110,100,0,0,50,46,50,56,46,48,0,0,47,114,100,121,108,98,117,49,49,47,49,0,0,0,0,0,47,114,100,121,108,98,117,49,48,47,57,0,0,0,0,0,47,114,100,121,108,98,117,49,48,47,56,0,0,0,0,0,99,97,112,0,0,0,0,0,47,98,114,98,103,54,47,53,0,0,0,0,0,0,0,0,47,114,100,121,108,98,117,49,48,47,55,0,0,0,0,0,98,108,97,99,107,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,0,109,105,110,117,115,0,0,0,47,114,100,121,108,98,117,49,48,47,54,0,0,0,0,0,47,114,100,121,108,98,117,49,48,47,53,0,0,0,0,0,47,114,100,121,108,98,117,49,48,47,52,0,0,0,0,0,32,32,32,32,32,32,32,32,32,105,102,32,40,105,116,101,109,41,32,123,10,0,0,0,47,114,100,121,108,98,117,49,48,47,51,0,0,0,0,0,101,100,103,101,0,0,0,0,47,114,100,121,108,98,117,49,48,47,50,0,0,0,0,0,112,97,112,97,121,97,119,104,105,112,0,0,0,0,0,0,9,47,110,111,100,101,99,111,108,111,114,32,123,110,111,112,99,111,108,111,114,125,32,100,101,102,0,0,0,0,0,0,47,114,100,121,108,98,117,49,48,47,49,48,0,0,0,0,108,116,97,105,108,0,0,0,108,105,98,97,103,32,101,114,114,111,114,32,45,45,32,97,103,105,110,105,116,40,41,32,119,97,115,32,110,111,116,32,99,97,108,108,101,100,10,0,99,111,109,112,114,101,115,115,0,0,0,0,0,0,0,0,32,62,62,62,32,0,0,0,47,114,100,121,108,98,117,49,48,47,49,0,0,0,0,0,47,114,100,112,117,57,47,57,0,0,0,0,0,0,0,0,116,97,105,108,112,111,114,116,0,0,0,0,0,0,0,0,47,114,100,112,117,57,47,56,0,0,0,0,0,0,0,0,98,117,108,108,0,0,0,0,47,98,114,98,103,54,47,52,0,0,0,0,0,0,0,0,47,114,100,112,117,57,47,55,0,0,0,0,0,0,0,0,47,114,100,112,117,57,47,54,0,0,0,0,0,0,0,0,47,114,100,112,117,57,47,53,0,0,0,0,0,0,0,0,47,114,100,112,117,57,47,52,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,105,116,101,109,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,86,77,76,121,101,115,91,120,93,41,59,10,0,0,0,0,115,97,110,115,45,83,101,114,105,102,0,0,0,0,0,0,47,114,100,112,117,57,47,51,0,0,0,0,0,0,0,0,47,114,100,112,117,57,47,50,0,0,0,0,0,0,0,0,112,97,108,101,118,105,111,108,101,116,114,101,100,0,0,0,105,108,108,101,103,97,108,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,32,114,101,102,101,114,101,110,99,101,0,0,0,0,0,0,9,97,108,111,97,100,32,112,111,112,32,115,101,116,104,115,98,99,111,108,111,114,0,0,47,114,100,112,117,57,47,49,0,0,0,0,0,0,0,0,97,117,116,111,0,0,0,0,99,108,117,115,116,101,114,0,98,114,118,98,97,114,0,0,47,114,100,112,117,56,47,56,0,0,0,0,0,0,0,0,38,35,49,54,48,59,0,0,47,114,100,112,117,56,47,55,0,0,0,0,0,0,0,0,111,98,106,0,0,0,0,0,32,37,100,32,0,0,0,0,47,114,100,112,117,56,47,54,0,0,0,0,0,0,0,0,117,116,105,108,115,46,99,0,48,0,0,0,0,0,0,0,47,98,114,98,103,54,47,51,0,0,0,0,0,0,0,0,47,114,100,112,117,56,47,53,0,0,0,0,0,0,0,0,47,114,100,112,117,56,47,52,0,0,0,0,0,0,0,0,115,117,98,103,114,97,112,104,32,0,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,112,110,108,115,0,0,0,0,0,47,114,100,112,117,56,47,51,0,0,0,0,0,0,0,0,119,105,100,116,104,0,0,0,47,114,100,112,117,56,47,50,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,102,111,114,32,40,120,32,105,110,32,86,77,76,121,101,115,41,123,10,0,0,0,0,0,0,110,111,110,97,109,101,46,103,118,0,0,0,0,0,0,0,37,37,66,101,103,105,110,68,111,99,117,109,101,110,116,58,10,0,0,0,0,0,0,0,47,114,100,112,117,56,47,49,0,0,0,0,0,0,0,0,47,114,100,112,117,55,47,55,0,0,0,0,0,0,0,0,112,97,108,101,116,117,114,113,117,111,105,115,101,0,0,0,37,37,66,101,103,105,110,80,114,111,108,111,103,0,0,0,47,114,100,112,117,55,47,54,0,0,0,0,0,0,0,0,114,97,116,105,111,0,0,0,98,108,117,101,0,0,0,0,117,115,0,0,0,0,0,0,98,101,116,97,0,0,0,0,47,114,100,112,117,55,47,53,0,0,0,0,0,0,0,0,9,108,97,121,101,114,99,111,108,111,114,115,101,113,32,99,117,114,108,97,121,101,114,32,49,32,115,117,98,32,108,97,121,101,114,108,101,110,32,109,111,100,32,103,101,116,0,0,47,114,100,112,117,55,47,52,0,0,0,0,0,0,0,0,47,114,100,112,117,55,47,51,0,0,0,0,0,0,0,0,102,111,110,116,99,111,108,111,114,0,0,0,0,0,0,0,47,98,114,98,103,54,47,50,0,0,0,0,0,0,0,0,47,114,100,112,117,55,47,50,0,0,0,0,0,0,0,0,47,114,100,112,117,55,47,49,0,0,0,0,0,0,0,0,47,114,100,112,117,54,47,54,0,0,0,0,0,0,0,0,114,97,110,107,40,103,44,32,50,44,32,110,115,105,116,101,114,50,40,103,41,41,32,61,61,32,48,0,0,0,0,0,47,114,100,112,117,54,47,53,0,0,0,0,0,0,0,0,32,32,32,32,32,32,105,102,32,40,105,101,118,101,114,115,62,61,53,41,123,10,0,0,47,114,100,112,117,54,47,52,0,0,0,0,0,0,0,0,115,105,110,107,0,0,0,0,47,114,100,112,117,54,47,51,0,0,0,0,0,0,0,0,47,68,111,116,68,105,99,116,32,50,48,48,32,100,105,99,116,32,100,101,102,0,0,0,112,97,108,101,103,114,101,101,110,0,0,0,0,0,0,0,112,99,0,0,0,0,0,0,47,115,101,116,108,97,121,101,114,32,123,47,109,97,120,108,97,121,101,114,32,101,120,99,104,32,100,101,102,32,47,99,117,114,108,97,121,101,114,32,101,120,99,104,32,100,101,102,0,0,0,0,0,0,0,0,47,114,100,112,117,54,47,50,0,0,0,0,0,0,0,0,37,108,102,37,99,0,0,0,121,101,115,0,0,0,0,0,47,115,116,97,114,110,101,116,73,83,79,32,123,0,0,0,98,100,113,117,111,0,0,0,47,114,100,112,117,54,47,49,0,0,0,0,0,0,0,0,47,114,100,112,117,53,47,53,0,0,0,0,0,0,0,0,103,118,114,101,110,100,101,114,95,115,101,116,95,115,116,121,108,101,58,32,117,110,115,117,112,112,111,114,116,101,100,32,115,116,121,108,101,32,37,115,32,45,32,105,103,110,111,114,105,110,103,10,0,0,0,0,47,114,100,112,117,53,47,52,0,0,0,0,0,0,0,0,108,97,121,101,114,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,105,110,32,37,115,32,111,117,116,112,117,116,10,0,0,0,0,0,0,47,98,114,98,103,54,47,49,0,0,0,0,0,0,0,0,47,114,100,112,117,53,47,51,0,0,0,0,0,0,0,0,47,114,100,112,117,53,47,50,0,0,0,0,0,0,0,0,47,114,100,112,117,53,47,49,0,0,0,0,0,0,0,0,47,114,100,112,117,52,47,52,0,0,0,0,0,0,0,0,32,32,32,32,32,32,125,10,0,0,0,0,0,0,0,0,47,114,100,112,117,52,47,51,0,0,0,0,0,0,0,0,47,114,100,112,117,52,47,50,0,0,0,0,0,0,0,0,112,97,108,101,103,111,108,100,101,110,114,111,100,0,0,0,47,108,97,121,101,114,108,101,110,32,108,97,121,101,114,99,111,108,111,114,115,101,113,32,108,101,110,103,116,104,32,100,101,102,0,0,0,0,0,0,47,114,100,112,117,52,47,49,0,0,0,0,0,0,0,0,37,108,102,44,37,108,102,37,99,0,0,0,0,0,0,0,97,117,109,108,0,0,0,0,47,114,100,112,117,51,47,51,0,0,0,0,0,0,0,0,47,114,100,112,117,51,47,50,0,0,0,0,0,0,0,0,47,114,100,112,117,51,47,49,0,0,0,0,0,0,0,0,73,109,97,103,101,115,32,117,110,115,117,112,112,111,114,116,101,100,32,105,110,32,34,98,97,99,107,103,114,111,117,110,100,34,32,97,116,116,114,105,98,117,116,101,10,0,0,0,111,0,0,0,0,0,0,0,47,98,114,98,103,53,47,53,0,0,0,0,0,0,0,0,47,114,100,103,121,57,47,57,0,0,0,0,0,0,0,0,47,114,100,103,121,57,47,56,0,0,0,0,0,0,0,0,47,114,100,103,121,57,47,55,0,0,0,0,0,0,0,0,47,114,100,103,121,57,47,54,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,105,101,118,101,114,115,61,32,112,97,114,115,101,73,110,116,32,40,117,97,46,115,117,98,115,116,114,105,110,103,32,40,109,115,105,101,43,53,44,32,117,97,46,105,110,100,101,120,79,102,32,40,39,46,39,44,32,109,115,105,101,32,41,41,41,10,0,0,0,0,0,47,114,100,103,121,57,47,53,0,0,0,0,0,0,0,0,47,114,100,103,121,57,47,52,0,0,0,0,0,0,0,0,111,114,99,104,105,100,0,0,100,101,102,0,0,0,0,0,47,114,100,103,121,57,47,51,0,0,0,0,0,0,0,0,108,97,98,101,108,106,117,115,116,0,0,0,0,0,0,0,97,116,105,108,100,101,0,0,47,114,100,103,121,57,47,50,0,0,0,0,0,0,0,0,109,99,108,105,109,105,116,0,47,114,100,103,121,57,47,49,0,0,0,0,0,0,0,0,47,114,100,103,121,56,47,56,0,0,0,0,0,0,0,0,116,114,97,110,115,112,97,114,101,110,116,0,0,0,0,0,47,98,114,98,103,53,47,52,0,0,0,0,0,0,0,0,47,114,100,103,121,56,47,55,0,0,0,0,0,0,0,0,47,114,100,103,121,56,47,54,0,0,0,0,0,0,0,0,47,114,100,103,121,56,47,53,0,0,0,0,0,0,0,0,47,114,100,103,121,56,47,52,0,0,0,0,0,0,0,0,32,32,32,32,32,32,105,102,32,40,32,109,115,105,101,32,62,32,48,32,41,123,32,32,32,32,32,32,47,47,32,73,102,32,73,110,116,101,114,110,101,116,32,69,120,112,108,111,114,101,114,44,32,114,101,116,117,114,110,32,118,101,114,115,105,111,110,32,110,117,109,98,101,114,10,0,0,0,0,0,32,37,100,44,37,100,0,0,47,114,100,103,121,56,47,51,0,0,0,0,0,0,0,0,47,114,100,103,121,56,47,50,0,0,0,0,0,0,0,0,111,114,97,110,103,101,114,101,100,0,0,0,0,0,0,0,9,93,0,0,0,0,0,0,47,114,100,103,121,56,47,49,0,0,0,0,0,0,0,0,108,97,98,101,108,108,111,99,0,0,0,0,0,0,0,0,97,115,121,109,112,0,0,0,47,114,100,103,121,55,47,55,0,0,0,0,0,0,0,0,47,97,99,99,101,110,116,53,47,50,0,0,0,0,0,0,47,114,100,103,121,55,47,54,0,0,0,0,0,0,0,0,47,114,100,103,121,55,47,53,0,0,0,0,0,0,0,0,119,104,105,116,101,0,0,0,47,98,114,98,103,53,47,51,0,0,0,0,0,0,0,0,47,114,100,103,121,55,47,52,0,0,0,0,0,0,0,0,47,114,100,103,121,55,47,51,0,0,0,0,0,0,0,0,47,114,100,103,121,55,47,50,0,0,0,0,0,0,0,0,47,114,100,103,121,55,47,49,0,0,0,0,0,0,0,0,32,32,32,32,32,32,118,97,114,32,86,77,76,110,111,61,110,101,119,32,65,114,114,97,121,40,39,95,110,111,116,86,77,76,49,95,39,44,39,95,110,111,116,86,77,76,50,95,39,41,59,10,0,0,0,0,47,114,100,103,121,54,47,54,0,0,0,0,0,0,0,0,47,114,100,103,121,54,47,53,0,0,0,0,0,0,0,0,111,114,97,110,103,101,0,0,9,9,91,46,56,32,46,56,32,46,56,93,0,0,0,0,47,114,100,103,121,54,47,52,0,0,0,0,0,0,0,0,98,108,97,99,107,0,0,0,97,114,105,110,103,0,0,0,47,114,100,103,121,54,47,51,0,0,0,0,0,0,0,0,98,111,120,0,0,0,0,0,47,114,100,103,121,54,47,50,0,0,0,0,0,0,0,0,37,100,32,40,37,46,53,103,44,32,37,46,53,103,41,44,32,40,37,46,53,103,44,32,37,46,53,103,41,10,0,0,47,114,100,103,121,54,47,49,0,0,0,0,0,0,0,0,108,97,121,101,114,0,0,0,47,98,114,98,103,53,47,50,0,0,0,0,0,0,0,0,47,114,100,103,121,53,47,53,0,0,0,0,0,0,0,0,47,114,100,103,121,53,47,52,0,0,0,0,0,0,0,0,47,114,100,103,121,53,47,51,0,0,0,0,0,0,0,0,47,114,100,103,121,53,47,50,0,0,0,0,0,0,0,0,32,32,32,32,32,32,118,97,114,32,86,77,76,121,101,115,61,110,101,119,32,65,114,114,97,121,40,39,95,86,77,76,49,95,39,44,39,95,86,77,76,50,95,39,41,59,10,0,47,114,100,103,121,53,47,49,0,0,0,0,0,0,0,0,47,114,100,103,121,52,47,52,0,0,0,0,0,0,0,0,111,108,105,118,101,100,114,97,98,0,0,0,0,0,0,0,9,9,91,46,54,32,46,56,32,46,56,93,0,0,0,0,47,114,100,103,121,52,47,51,0,0,0,0,0,0,0,0,116,97,98,108,101,32,115,105,122,101,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,99,111,110,116,101,110,116,10,0,0,0,0,0,0,0,112,110,103,58,118,114,109,108,0,0,0,0,0,0,0,0,84,105,109,101,115,45,82,111,109,97,110,0,0,0,0,0,97,110,103,0,0,0,0,0,47,114,100,103,121,52,47,50,0,0,0,0,0,0,0,0,47,114,100,103,121,52,47,49,0,0,0,0,0,0,0,0,47,114,100,103,121,51,47,51,0,0,0,0,0,0,0,0,114,111,117,110,100,101,100,0,47,98,114,98,103,53,47,49,0,0,0,0,0,0,0,0,47,114,100,103,121,51,47,50,0,0,0,0,0,0,0,0,47,114,100,103,121,51,47,49,0,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,57,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,56,0,0,0,0,0,0,0,32,32,32,32,32,32,118,97,114,32,105,116,101,109,59,10,0,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,55,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,54,0,0,0,0,0,0,0,72,84,77,76,0,0,0,0,111,108,105,118,101,0,0,0,9,9,91,46,52,32,46,56,32,46,56,93,0,0,0,0,47,114,100,103,121,49,49,47,53,0,0,0,0,0,0,0,85,110,115,117,112,112,111,114,116,101,100,32,99,104,97,114,115,101,116,32,118,97,108,117,101,32,37,100,10,0,0,0,97,110,100,0,0,0,0,0,47,114,100,103,121,49,49,47,52,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,51,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,50,0,0,0,0,0,0,0,115,116,121,108,101,0,0,0,47,98,114,98,103,52,47,52,0,0,0,0,0,0,0,0,47,114,100,103,121,49,49,47,49,49,0,0,0,0,0,0,97,113,117,97,0,0,0,0,47,114,100,103,121,49,49,47,49,48,0,0,0,0,0,0,35,32,37,115,10,0,0,0,75,80,95,65,100,100,0,0,47,114,100,103,121,49,49,47,49,0,0,0,0,0,0,0,47,114,100,103,121,49,48,47,57,0,0,0,0,0,0,0,32,32,32,32,32,32,118,97,114,32,105,101,118,101,114,115,59,10,0,0,0,0,0,0,47,114,100,103,121,49,48,47,56,0,0,0,0,0,0,0,47,114,100,103,121,49,48,47,55,0,0,0,0,0,0,0,111,108,100,108,97,99,101,0,9,9,91,46,50,32,46,56,32,46,56,93,0,0,0,0,47,114,100,103,121,49,48,47,54,0,0,0,0,0,0,0,66,73,71,45,53,0,0,0,97,109,112,0,0,0,0,0,47,114,100,103,121,49,48,47,53,0,0,0,0,0,0,0,99,111,110,116,101,120,116,58,32,0,0,0,0,0,0,0,47,114,100,103,121,49,48,47,52,0,0,0,0,0,0,0,47,114,100,103,121,49,48,47,51,0,0,0,0,0,0,0,102,105,108,108,101,100,0,0,104,101,97,100,112,111,114,116,0,0,0,0,0,0,0,0,47,98,114,98,103,52,47,51,0,0,0,0,0,0,0,0,47,114,100,103,121,49,48,47,50,0,0,0,0,0,0,0,47,114,100,103,121,49,48,47,49,48,0,0,0,0,0,0,47,114,100,103,121,49,48,47,49,0,0,0,0,0,0,0,47,114,100,98,117,57,47,57,0,0,0,0,0,0,0,0,32,32,32,32,32,32,118,97,114,32,109,115,105,101,32,61,32,117,97,46,105,110,100,101,120,79,102,32,40,32,39,77,83,73,69,32,39,32,41,10,0,0,0,0,0,0,0,0,98,111,111,107,0,0,0,0,47,114,100,98,117,57,47,56,0,0,0,0,0,0,0,0,47,114,100,98,117,57,47,55,0,0,0,0,0,0,0,0,106,117,110,107,32,97,102,116,101,114,32,100,111,99,117,109,101,110,116,32,101,108,101,109,101,110,116,0,0,0,0,0,9,9,91,48,32,48,32,48,93,0,0,0,0,0,0,0,110,97,118,121,0,0,0,0,47,114,100,98,117,57,47,54,0,0,0,0,0,0,0,0,73,83,79,45,56,56,53,57,45,49,0,0,0,0,0,0,97,108,112,104,97,0,0,0,47,114,100,98,117,57,47,53,0,0,0,0,0,0,0,0,38,35,52,53,59,0,0,0,47,114,100,98,117,57,47,52,0,0,0,0,0,0,0,0,120,100,111,116,58,120,100,111,116,0,0,0,0,0,0,0,47,114,100,98,117,57,47,51,0,0,0,0,0,0,0,0,101,109,105,116,46,99,0,0,115,97,109,112,108,101,112,111,105,110,116,115,0,0,0,0,115,101,103,109,101,110,116,32,91,37,115,44,37,115,93,32,100,111,101,115,32,110,111,116,32,105,110,116,101,114,115,101,99,116,32,98,111,120,32,108,108,61,37,115,44,117,114,61,37,115,10,0,0,0,0,0,47,98,114,98,103,52,47,50,0,0,0,0,0,0,0,0,47,114,100,98,117,57,47,50,0,0,0,0,0,0,0,0,47,114,100,98,117,57,47,49,0,0,0,0,0,0,0,0,125,10,0,0,0,0,0,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,112,110,108,112,115,0,0,0,0,0,47,114,100,98,117,56,47,56,0,0,0,0,0,0,0,0,114,101,99,116,115,0,0,0,47,114,100,98,117,56,47,55,0,0,0,0,0,0,0,0,32,32,32,32,32,32,118,97,114,32,117,97,32,61,32,119,105,110,100,111,119,46,110,97,118,105,103,97,116,111,114,46,117,115,101,114,65,103,101,110,116,10,0,0,0,0,0,0,46,37,100,0,0,0,0,0,47,117,115,101,114,95,115,104,97,112,101,95,37,100,32,123,10,0,0,0,0,0,0,0,47,114,100,98,117,56,47,54,0,0,0,0,0,0,0,0,47,114,100,98,117,56,47,53,0,0,0,0,0,0,0,0,9,91,9,37,32,108,97,121,101,114,32,99,111,108,111,114,32,115,101,113,117,101,110,99,101,32,45,32,100,97,114,107,101,115,116,32,116,111,32,108,105,103,104,116,101,115,116,0,110,97,118,97,106,111,119,104,105,116,101,0,0,0,0,0,47,114,100,98,117,56,47,52,0,0,0,0,0,0,0,0,85,84,70,45,56,0,0,0,98,108,97,110,99,104,101,100,97,108,109,111,110,100,0,0,97,108,101,102,115,121,109,0,47,114,100,98,117,56,47,51,0,0,0,0,0,0,0,0,47,114,100,98,117,56,47,50,0,0,0,0,0,0,0,0,47,114,100,98,117,56,47,49,0,0,0,0,0,0,0,0,97,108,108,0,0,0,0,0,47,98,114,98,103,52,47,49,0,0,0,0,0,0,0,0,47,114,100,98,117,55,47,55,0,0,0,0,0,0,0,0,47,114,100,98,117,55,47,54,0,0,0,0,0,0,0,0,47,114,100,98,117,55,47,53,0,0,0,0,0,0,0,0,47,114,100,98,117,55,47,52,0,0,0,0,0,0,0,0,32,32,32,123,10,0,0,0,47,114,100,98,117,55,47,51,0,0,0,0,0,0,0,0,109,97,120,0,0,0,0,0,47,114,100,98,117,55,47,50,0,0,0,0,0,0,0,0,47,108,97,121,101,114,99,111,108,111,114,115,101,113,0,0,109,111,99,99,97,115,105,110,0,0,0,0,0,0,0,0,112,120,0,0,0,0,0,0,47,114,100,98,117,55,47,49,0,0,0,0,0,0,0,0,105,100,0,0,0,0,0,0,116,114,117,101,0,0,0,0,37,32,83,101,116,32,117,112,32,73,83,79,32,76,97,116,105,110,32,49,32,99,104,97,114,97,99,116,101,114,32,101,110,99,111,100,105,110,103,0,97,103,114,97,118,101,0,0,47,114,100,98,117,54,47,54,0,0,0,0,0,0,0,0,47,114,100,98,117,54,47,53,0,0,0,0,0,0,0,0,117,110,102,105,108,108,101,100,0,0,0,0,0,0,0,0,47,114,100,98,117,54,47,52,0,0,0,0,0,0,0,0,104,101,97,100,116,111,111,108,116,105,112,0,0,0,0,0,47,98,114,98,103,51,47,51,0,0,0,0,0,0,0,0,47,114,100,98,117,54,47,51,0,0,0,0,0,0,0,0,47,114,100,98,117,54,47,50,0,0,0,0,0,0,0,0,47,114,100,98,117,54,47,49,0,0,0,0,0,0,0,0,47,114,100,98,117,53,47,53,0,0,0,0,0,0,0,0,32,32,32,102,117,110,99,116,105,111,110,32,98,114,111,119,115,101,114,99,104,101,99,107,40,41,10,0,0,0,0,0,47,114,100,98,117,53,47,52,0,0,0,0,0,0,0,0,47,114,100,98,117,53,47,51,0,0,0,0,0,0,0,0,47,115,104,111,119,112,97,103,101,32,123,32,125,32,100,101,102,0,0,0,0,0,0,0,109,105,115,116,121,114,111,115,101,0,0,0,0,0,0,0,47,114,100,98,117,53,47,50,0,0,0,0,0,0,0,0,104,101,97,100,99,108,105,112,0,0,0,0,0,0,0,0,97,101,108,105,103,0,0,0,47,114,100,98,117,53,47,49,0,0,0,0,0,0,0,0,47,114,100,98,117,52,47,52,0,0,0,0,0,0,0,0,47,114,100,98,117,52,47,51,0,0,0,0,0,0,0,0,116,97,105,108,116,111,111,108,116,105,112,0,0,0,0,0,109,112,116,121,0,0,0,0,100,111,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,109,108,95,116,101,120,116,112,97,114,97,0,0,0,0,118,109,108,95,112,114,105,110,116,95,99,111,108,111,114,0,116,114,97,110,115,112,111,115,101,95,115,116,101,112,0,0,116,107,103,101,110,95,112,114,105,110,116,95,116,97,103,115,0,0,0,0,0,0,0,0,116,107,103,101,110,95,112,114,105,110,116,95,99,111,108,111,114,0,0,0,0,0,0,0,115,118,103,95,116,101,120,116,112,97,114,97,0,0,0,0])
.concat([115,118,103,95,112,114,105,110,116,95,99,111,108,111,114,0,115,101,116,98,111,117,110,100,115,0,0,0,0,0,0,0,115,97,102,101,95,100,101,108,101,116,101,95,102,97,115,116,95,101,100,103,101,0,0,0,114,111,117,110,100,95,99,111,114,110,101,114,115,0,0,0,112,111,115,116,111,114,100,101,114,0,0,0,0,0,0,0,112,111,115,95,104,116,109,108,95,116,98,108,0,0,0,0,112,111,112,95,111,98,106,95,115,116,97,116,101,0,0,0,111,118,101,114,108,97,112,95,98,101,122,105,101,114,0,0,109,105,110,109,97,120,95,101,100,103,101,115,0,0,0,0,109,101,114,103,101,118,105,114,116,117,97,108,0,0,0,0,109,101,114,103,101,95,111,110,101,119,97,121,0,0,0,0,109,101,114,103,101,95,99,104,97,105,110,0,0,0,0,0,109,97,112,95,112,97,116,104,0,0,0,0,0,0,0,0,109,97,112,95,111,117,116,112,117,116,95,115,104,97,112,101,0,0,0,0,0,0,0,0,109,97,112,78,0,0,0,0,109,97,107,101,95,108,97,98,101,108,0,0,0,0,0,0,109,97,107,101,95,99,104,97,105,110,0,0,0,0,0,0,109,97,107,101,83,101,108,102,69,100,103,101,0,0,0,0,109,97,107,101,67,111,109,112,111,117,110,100,69,100,103,101,0,0,0,0,0,0,0,0,105,110,116,101,114,99,108,101,120,112,0,0,0,0,0,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,0,105,110,105,116,95,115,112,108,105,110,101,115,95,98,98,0,103,118,117,115,101,114,115,104,97,112,101,95,102,105,108,101,95,97,99,99,101,115,115,0,102,108,97,116,95,115,101,97,114,99,104,0,0,0,0,0,102,105,103,95,114,101,115,111,108,118,101,95,99,111,108,111,114,0,0,0,0,0,0,0,102,105,103,95,98,101,122,105,101,114,0,0,0,0,0,0,102,97,115,116,95,110,111,100,101,97,112,112,0,0,0,0,102,97,115,116,95,110,111,100,101,0,0,0,0,0,0,0,101,110,100,112,97,116,104,0,101,109,105,116,95,101,100,103,101,95,108,97,98,101,108,0,100,111,116,95,112,111,115,105,116,105,111,110,0,0,0,0,100,101,108,101,116,101,95,102,108,97,116,95,101,100,103,101,0,0,0,0,0,0,0,0,100,101,108,101,116,101,95,102,97,115,116,95,110,111,100,101,0,0,0,0,0,0,0,0,100,101,108,101,116,101,95,102,97,115,116,95,101,100,103,101,0,0,0,0,0,0,0,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,118,114,109,108,0,0,0,0,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,115,118,103,0,0,0,0,0,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,112,115,108,105,98,0,0,0,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,112,115,0,0,0,0,0,0,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,102,105,103,0,0,0,0,0,0,99,111,110,110,101,99,116,71,114,97,112,104,0,0,0,0,99,108,117,115,116,101,114,95,108,101,97,100,101,114,0,0,98,111,120,73,110,116,101,114,115,101,99,116,102,0,0,0,98,101,122,105,101,114,95,98,98,0,0,0,0,0,0,0,98,101,103,105,110,112,97,116,104,0,0,0,0,0,0,0,98,97,108,97,110,99,101,0,97,98,111,109,105,110,97,116,105,111,110,0,0,0,0,0,95,100,111,116,95,115,112,108,105,110,101,115,0,0,0,0,85,70,95,115,101,116,110,97,109,101,0,0,0,0,0,0,124,2,0,0,4,0,0,0,132,0,0,0,64,0,0,0,124,2,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,232,1,0,224,200,1,0,128,180,1,0,160,163,1,0,112,148,1,0,16,132,1,0,88,116,1,0,144,102,1,0,192,120,2,0,24,107,2,0,160,93,2,0,216,79,2,0,96,67,2,0,128,56,2,0,152,44,2,0,232,30,2,0,24,20,2,0,192,10,2,0,16,2,2,0,64,251,1,0,168,242,1,0,128,232,1,0,208,224,1,0,120,219,1,0,8,217,1,0,96,214,1,0,216,211,1,0,192,209,1,0,168,207,1,0,104,205,1,0,48,203,1,0,184,200,1,0,168,198,1,0,168,196,1,0,232,194,1,0,208,192,1,0,128,190,1,0,112,188,1,0,192,186,1,0,144,184,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,0,21,0,101,0,8,0,103,0,12,0,110,0,17,0,100,0,1,0,105,0,2,0,103,0,3,0,114,0,4,0,97,0,5,0,112,0,6,0,104,0,7,0,100,0,9,0,103,0,10,0,101,0,11,0,114,0,13,0,97,0,14,0,112,0,15,0,104,0,16,0,111,0,18,0,100,0,19,0,101,0,20,0,116,0,22,0,117,0,27,0,114,0,23,0,105,0,24,0,99,0,25,0,116,0,26,0,98,0,28,0,103,0,29,0,114,0,30,0,97,0,31,0,112,0,32,0,104,0,33,0,0,0,0,0,255,255,0,0,88,32,4,0,255,255,5,0,0,1,0,0,255,255,6,0,64,0,0,0,255,255,7,0,0,0,2,0,255,255,8,0,1,0,0,0,255,255,9,0,0,128,0,0,255,255,10,0,128,0,0,0,3,1,11,0,0,0,0,0,255,255,11,0,8,0,0,0,255,255,12,0,64,0,0,0,255,255,13,0,16,0,0,0,6,1,14,0,0,0,0,0,255,255,14,0,0,0,2,0,255,255,15,0,1,0,0,0,255,255,16,0,0,128,0,0,255,255,17,0,128,0,0,0,2,1,18,0,0,0,0,0,255,255,18,0,0,64,0,0,255,255,19,0,8,0,0,0,255,255,20,0,16,0,0,0,5,1,21,0,0,0,0,0,255,255,21,0,0,0,24,0,255,255,23,0,0,0,2,0,255,255,24,0,0,1,0,0,255,255,25,0,4,0,0,0,255,255,26,0,0,0,8,0,4,1,27,0,0,0,0,0,255,255,27,0,2,0,0,0,255,255,28,0,64,0,0,0,255,255,29,0,0,0,2,0,255,255,30,0,1,0,0,0,255,255,31,0,0,128,0,0,255,255,32,0,128,0,0,0,10,1,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,116,2,0,144,27,0,0,96,34,0,0,0,0,0,0,128,101,2,0,144,27,0,0,160,30,0,0,0,0,0,0,224,88,2,0,144,27,0,0,224,32,0,0,0,0,0,0,144,74,2,0,144,27,0,0,224,32,0,0,0,0,0,0,80,63,2,0,144,27,0,0,0,34,0,0,0,0,0,0,136,52,2,0,216,27,0,0,0,34,0,0,0,0,0,0,176,40,2,0,144,27,0,0,16,33,0,0,0,0,0,0,224,26,2,0,144,27,0,0,176,29,0,0,0,0,0,0,232,16,2,0,144,27,0,0,208,30,0,0,0,0,0,0,160,6,2,0,144,27,0,0,208,30,0,0,0,0,0,0,160,255,1,0,144,27,0,0,160,33,0,0,0,0,0,0,96,248,1,0,144,27,0,0,224,29,0,0,0,0,0,0,128,238,1,0,144,27,0,0,48,31,0,0,0,0,0,0,152,229,1,0,144,27,0,0,80,32,0,0,0,0,0,0,8,222,1,0,144,27,0,0,0,31,0,0,0,0,0,0,184,218,1,0,144,27,0,0,128,32,0,0,0,0,0,0,32,216,1,0,144,27,0,0,112,30,0,0,0,0,0,0,88,213,1,0,144,27,0,0,96,31,0,0,0,0,0,0,8,211,1,0,144,27,0,0,144,31,0,0,0,0,0,0,224,208,1,0,144,27,0,0,16,30,0,0,0,0,0,0,16,207,1,0,144,27,0,0,176,32,0,0,0,0,0,0,152,204,1,0,144,27,0,0,48,34,0,0,0,0,0,0,48,202,1,0,144,27,0,0,208,33,0,0,0,0,0,0,232,199,1,0,144,27,0,0,96,34,0,0,0,0,0,0,8,198,1,0,144,27,0,0,96,34,0,0,0,0,0,0,8,196,1,0,144,27,0,0,64,30,0,0,0,0,0,0,32,194,1,0,144,27,0,0,112,33,0,0,0,0,0,0,232,191,1,0,144,27,0,0,64,33,0,0,0,0,0,0,160,189,1,0,144,27,0,0,128,29,0,0,0,0,0,0,200,187,1,0,144,27,0,0,192,31,0,0,0,0,0,0,24,186,1,0,144,27,0,0,240,31,0,0,0,0,0,0,176,183,1,0,144,27,0,0,32,32,0,0,0,0,0,0,184,181,1,0,144,27,0,0,192,34,0,0,0,0,0,0,208,179,1,0,144,27,0,0,144,34,0,0,0,0,0,0,40,178,1,0,144,27,0,0,240,34,0,0,0,0,0,0,160,176,1,0,0,18,0,0,0,0,0,0,0,0,0,0,72,175,1,0,0,18,0,0,0,0,0,0,0,0,0,0,112,193,1,0,240,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,68,2,0,104,104,2,0,24,249,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,101,115,0,0,0,0,0,118,101,114,115,105,111,110,0,115,116,97,110,100,97,108,111,110,101,0,0,0,0,0,0,110,111,0,0,0,0,0,0,101,110,99,111,100,105,110,103,0,0,0,0,0,0,0,0,85,84,70,45,56,0,0,0,85,84,70,45,49,54,76,69,0,0,0,0,0,0,0,0,85,84,70,45,49,54,66,69,0,0,0,0,0,0,0,0,85,84,70,45,49,54,0,0,85,83,45,65,83,67,73,73,0,0,0,0,0,0,0,0,83,89,83,84,69,77,0,0,82,69,81,85,73,82,69,68,0,0,0,0,0,0,0,0,80,85,66,76,73,67,0,0,80,67,68,65,84,65,0,0,78,79,84,65,84,73,79,78,0,0,0,0,0,0,0,0,78,77,84,79,75,69,78,83,0,0,0,0,0,0,0,0,78,77,84,79,75,69,78,0,78,68,65,84,65,0,0,0,73,83,79,45,56,56,53,57,45,49,0,0,0,0,0,0,73,77,80,76,73,69,68,0,73,68,82,69,70,83,0,0,73,68,82,69,70,0,0,0,73,68,0,0,0,0,0,0,70,73,88,69,68,0,0,0,69,78,84,73,84,89,0,0,69,78,84,73,84,73,69,83,0,0,0,0,0,0,0,0,69,77,80,84,89,0,0,0,69,76,69,77,69,78,84,0,68,79,67,84,89,80,69,0,67,68,65,84,65,0,0,0,65,84,84,76,73,83,84,0,65,78,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,190,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,180,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,131,2,0,0,0,0,0,96,131,2,0,0,0,0,0,104,131,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,16,0,0,0,32,0,0,0,64,0,0,0,128,0,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,16,0,0,0,32,0,0,0,64,0,0,0,128,0,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,16,0,0,0,32,0,0,0,64,0,0,0,128,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,172,1,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,42,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,224,63,242,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,12,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,51,51,51,51,51,51,243,63,130,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,154,153,153,153,153,153,233,63,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,49,2,0,25,0,0,0,0,0,0,0,0,0,0,0,240,4,2,0,1,0,0,0,48,85,2,0,2,0,0,0,16,228,1,0,3,0,0,0,168,208,1,0,4,0,0,0,144,187,1,0,5,0,0,0,88,170,1,0,6,0,0,0,112,154,1,0,0,0,0,0,216,137,1,0,17,0,0,0,144,121,1,0,18,0,0,0,0,108,1,0,18,0,0,0,176,125,2,0,1,0,0,0,0,0,0,0,0,0,0,0,160,112,2,0,8,0,0,0,88,98,2,0,64,0,0,0,96,77,2,0,32,0,0,0,72,71,2,0,8,0,0,0,104,60,2,0,32,0,0,0,0,0,0,0,0,0,0,0,168,34,2,0,0,0,0,0,1,0,0,0,32,24,2,0,1,0,0,0,0,0,0,0,120,14,2,0,1,0,0,0,1,0,0,0,112,154,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
function runPostSets() {
}
if (!awaitingMemoryInitializer) runPostSets();
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  function _strncmp(px, py, n) {
      var i = 0;
      while (i < n) {
        var x = HEAPU8[(((px)+(i))|0)];
        var y = HEAPU8[(((py)+(i))|0)];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
      return 0;
    }function _strcmp(px, py) {
      return _strncmp(px, py, TOTAL_MEMORY);
    }
  Module["_memcmp"] = _memcmp;
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  var _sqrt=Math.sqrt;
  Module["_strlen"] = _strlen;
  function _parseXDotF() {
  Module['printErr']('missing function: parseXDotF'); abort(-1);
  }
  function _statXDot() {
  Module['printErr']('missing function: statXDot'); abort(-1);
  }
  var ERRNO_CODES={E2BIG:7,EACCES:13,EADDRINUSE:98,EADDRNOTAVAIL:99,EAFNOSUPPORT:97,EAGAIN:11,EALREADY:114,EBADF:9,EBADMSG:74,EBUSY:16,ECANCELED:125,ECHILD:10,ECONNABORTED:103,ECONNREFUSED:111,ECONNRESET:104,EDEADLK:35,EDESTADDRREQ:89,EDOM:33,EDQUOT:122,EEXIST:17,EFAULT:14,EFBIG:27,EHOSTUNREACH:113,EIDRM:43,EILSEQ:84,EINPROGRESS:115,EINTR:4,EINVAL:22,EIO:5,EISCONN:106,EISDIR:21,ELOOP:40,EMFILE:24,EMLINK:31,EMSGSIZE:90,EMULTIHOP:72,ENAMETOOLONG:36,ENETDOWN:100,ENETRESET:102,ENETUNREACH:101,ENFILE:23,ENOBUFS:105,ENODATA:61,ENODEV:19,ENOENT:2,ENOEXEC:8,ENOLCK:37,ENOLINK:67,ENOMEM:12,ENOMSG:42,ENOPROTOOPT:92,ENOSPC:28,ENOSR:63,ENOSTR:60,ENOSYS:38,ENOTCONN:107,ENOTDIR:20,ENOTEMPTY:39,ENOTRECOVERABLE:131,ENOTSOCK:88,ENOTSUP:95,ENOTTY:25,ENXIO:6,EOPNOTSUPP:45,EOVERFLOW:75,EOWNERDEAD:130,EPERM:1,EPIPE:32,EPROTO:71,EPROTONOSUPPORT:93,EPROTOTYPE:91,ERANGE:34,EROFS:30,ESPIPE:29,ESRCH:3,ESTALE:116,ETIME:62,ETIMEDOUT:110,ETXTBSY:26,EWOULDBLOCK:11,EXDEV:18};
  function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      if (!___setErrNo.ret) ___setErrNo.ret = allocate([0], 'i32', ALLOC_NORMAL);
      HEAP32[((___setErrNo.ret)>>2)]=value
      return value;
    }
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  var __impure_ptr=allocate(1, "i32*", ALLOC_STATIC);var FS={currentPath:"/",nextInode:2,streams:[null],ignorePermissions:true,joinPath:function (parts, forceRelative) {
        var ret = parts[0];
        for (var i = 1; i < parts.length; i++) {
          if (ret[ret.length-1] != '/') ret += '/';
          ret += parts[i];
        }
        if (forceRelative && ret[0] == '/') ret = ret.substr(1);
        return ret;
      },absolutePath:function (relative, base) {
        if (typeof relative !== 'string') return null;
        if (base === undefined) base = FS.currentPath;
        if (relative && relative[0] == '/') base = '';
        var full = base + '/' + relative;
        var parts = full.split('/').reverse();
        var absolute = [''];
        while (parts.length) {
          var part = parts.pop();
          if (part == '' || part == '.') {
            // Nothing.
          } else if (part == '..') {
            if (absolute.length > 1) absolute.pop();
          } else {
            absolute.push(part);
          }
        }
        return absolute.length == 1 ? '/' : absolute.join('/');
      },analyzePath:function (path, dontResolveLastLink, linksVisited) {
        var ret = {
          isRoot: false,
          exists: false,
          error: 0,
          name: null,
          path: null,
          object: null,
          parentExists: false,
          parentPath: null,
          parentObject: null
        };
        path = FS.absolutePath(path);
        if (path == '/') {
          ret.isRoot = true;
          ret.exists = ret.parentExists = true;
          ret.name = '/';
          ret.path = ret.parentPath = '/';
          ret.object = ret.parentObject = FS.root;
        } else if (path !== null) {
          linksVisited = linksVisited || 0;
          path = path.slice(1).split('/');
          var current = FS.root;
          var traversed = [''];
          while (path.length) {
            if (path.length == 1 && current.isFolder) {
              ret.parentExists = true;
              ret.parentPath = traversed.length == 1 ? '/' : traversed.join('/');
              ret.parentObject = current;
              ret.name = path[0];
            }
            var target = path.shift();
            if (!current.isFolder) {
              ret.error = ERRNO_CODES.ENOTDIR;
              break;
            } else if (!current.read) {
              ret.error = ERRNO_CODES.EACCES;
              break;
            } else if (!current.contents.hasOwnProperty(target)) {
              ret.error = ERRNO_CODES.ENOENT;
              break;
            }
            current = current.contents[target];
            if (current.link && !(dontResolveLastLink && path.length == 0)) {
              if (linksVisited > 40) { // Usual Linux SYMLOOP_MAX.
                ret.error = ERRNO_CODES.ELOOP;
                break;
              }
              var link = FS.absolutePath(current.link, traversed.join('/'));
              ret = FS.analyzePath([link].concat(path).join('/'),
                                   dontResolveLastLink, linksVisited + 1);
              return ret;
            }
            traversed.push(target);
            if (path.length == 0) {
              ret.exists = true;
              ret.path = traversed.join('/');
              ret.object = current;
            }
          }
        }
        return ret;
      },findObject:function (path, dontResolveLastLink) {
        FS.ensureRoot();
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },createObject:function (parent, name, properties, canRead, canWrite) {
        if (!parent) parent = '/';
        if (typeof parent === 'string') parent = FS.findObject(parent);
        if (!parent) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent path must exist.');
        }
        if (!parent.isFolder) {
          ___setErrNo(ERRNO_CODES.ENOTDIR);
          throw new Error('Parent must be a folder.');
        }
        if (!parent.write && !FS.ignorePermissions) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent folder must be writeable.');
        }
        if (!name || name == '.' || name == '..') {
          ___setErrNo(ERRNO_CODES.ENOENT);
          throw new Error('Name must not be empty.');
        }
        if (parent.contents.hasOwnProperty(name)) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          throw new Error("Can't overwrite object.");
        }
        parent.contents[name] = {
          read: canRead === undefined ? true : canRead,
          write: canWrite === undefined ? false : canWrite,
          timestamp: Date.now(),
          inodeNumber: FS.nextInode++
        };
        for (var key in properties) {
          if (properties.hasOwnProperty(key)) {
            parent.contents[name][key] = properties[key];
          }
        }
        return parent.contents[name];
      },createFolder:function (parent, name, canRead, canWrite) {
        var properties = {isFolder: true, isDevice: false, contents: {}};
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createPath:function (parent, path, canRead, canWrite) {
        var current = FS.findObject(parent);
        if (current === null) throw new Error('Invalid parent.');
        path = path.split('/').reverse();
        while (path.length) {
          var part = path.pop();
          if (!part) continue;
          if (!current.contents.hasOwnProperty(part)) {
            FS.createFolder(current, part, canRead, canWrite);
          }
          current = current.contents[part];
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        properties.isFolder = false;
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createDataFile:function (parent, name, data, canRead, canWrite) {
        if (typeof data === 'string') {
          var dataArray = new Array(data.length);
          for (var i = 0, len = data.length; i < len; ++i) dataArray[i] = data.charCodeAt(i);
          data = dataArray;
        }
        var properties = {
          isDevice: false,
          contents: data.subarray ? data.subarray(0) : data // as an optimization, create a new array wrapper (not buffer) here, to help JS engines understand this object
        };
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          var LazyUint8Array = function(chunkSize, length) {
            this.length = length;
            this.chunkSize = chunkSize;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % chunkSize;
            var chunkNum = Math.floor(idx / chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function(getter) {
            this.getter = getter;
          }
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var chunkSize = 1024*1024; // Chunk size in bytes
          if (!hasByteServing) chunkSize = datalength;
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = new LazyUint8Array(chunkSize, datalength);
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * lazyArray.chunkSize;
            var end = (chunkNum+1) * lazyArray.chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile) {
        Browser.init();
        var fullname = FS.joinPath([parent, name], true);
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },createLink:function (parent, name, target, canRead, canWrite) {
        var properties = {isDevice: false, link: target};
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createDevice:function (parent, name, input, output) {
        if (!(input || output)) {
          throw new Error('A device must have at least one callback defined.');
        }
        var ops = {isDevice: true, input: input, output: output};
        return FS.createFile(parent, name, ops, Boolean(input), Boolean(output));
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },ensureRoot:function () {
        if (FS.root) return;
        // The main file system tree. All the contents are inside this.
        FS.root = {
          read: true,
          write: true,
          isFolder: true,
          isDevice: false,
          timestamp: Date.now(),
          inodeNumber: 1,
          contents: {}
        };
      },init:function (input, output, error) {
        // Make sure we initialize only once.
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        FS.ensureRoot();
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        input = input || Module['stdin'];
        output = output || Module['stdout'];
        error = error || Module['stderr'];
        // Default handlers.
        var stdinOverridden = true, stdoutOverridden = true, stderrOverridden = true;
        if (!input) {
          stdinOverridden = false;
          input = function() {
            if (!input.cache || !input.cache.length) {
              var result;
              if (typeof window != 'undefined' &&
                  typeof window.prompt == 'function') {
                // Browser.
                result = window.prompt('Input: ');
                if (result === null) result = String.fromCharCode(0); // cancel ==> EOF
              } else if (typeof readline == 'function') {
                // Command line.
                result = readline();
              }
              if (!result) result = '';
              input.cache = intArrayFromString(result + '\n', true);
            }
            return input.cache.shift();
          };
        }
        var utf8 = new Runtime.UTF8Processor();
        function simpleOutput(val) {
          if (val === null || val === 10) {
            output.printer(output.buffer.join(''));
            output.buffer = [];
          } else {
            output.buffer.push(utf8.processCChar(val));
          }
        }
        if (!output) {
          stdoutOverridden = false;
          output = simpleOutput;
        }
        if (!output.printer) output.printer = Module['print'];
        if (!output.buffer) output.buffer = [];
        if (!error) {
          stderrOverridden = false;
          error = simpleOutput;
        }
        if (!error.printer) error.printer = Module['print'];
        if (!error.buffer) error.buffer = [];
        // Create the temporary folder, if not already created
        try {
          FS.createFolder('/', 'tmp', true, true);
        } catch(e) {}
        // Create the I/O devices.
        var devFolder = FS.createFolder('/', 'dev', true, true);
        var stdin = FS.createDevice(devFolder, 'stdin', input);
        var stdout = FS.createDevice(devFolder, 'stdout', null, output);
        var stderr = FS.createDevice(devFolder, 'stderr', null, error);
        FS.createDevice(devFolder, 'tty', input, output);
        // Create default streams.
        FS.streams[1] = {
          path: '/dev/stdin',
          object: stdin,
          position: 0,
          isRead: true,
          isWrite: false,
          isAppend: false,
          isTerminal: !stdinOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[2] = {
          path: '/dev/stdout',
          object: stdout,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          isTerminal: !stdoutOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[3] = {
          path: '/dev/stderr',
          object: stderr,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          isTerminal: !stderrOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        // TODO: put these low in memory like we used to assert on: assert(Math.max(_stdin, _stdout, _stderr) < 15000); // make sure these are low, we flatten arrays with these
        HEAP32[((_stdin)>>2)]=1;
        HEAP32[((_stdout)>>2)]=2;
        HEAP32[((_stderr)>>2)]=3;
        // Other system paths
        FS.createPath('/', 'dev/shm/tmp', true, true); // temp files
        // Newlib initialization
        for (var i = FS.streams.length; i < Math.max(_stdin, _stdout, _stderr) + 4; i++) {
          FS.streams[i] = null; // Make sure to keep FS.streams dense
        }
        FS.streams[_stdin] = FS.streams[1];
        FS.streams[_stdout] = FS.streams[2];
        FS.streams[_stderr] = FS.streams[3];
        allocate([ allocate(
          [0, 0, 0, 0, _stdin, 0, 0, 0, _stdout, 0, 0, 0, _stderr, 0, 0, 0],
          'void*', ALLOC_DYNAMIC) ], 'void*', ALLOC_NONE, __impure_ptr);
      },quit:function () {
        if (!FS.init.initialized) return;
        // Flush any partially-printed lines in stdout and stderr. Careful, they may have been closed
        if (FS.streams[2] && FS.streams[2].object.output.buffer.length > 0) FS.streams[2].object.output(10);
        if (FS.streams[3] && FS.streams[3].object.output.buffer.length > 0) FS.streams[3].object.output(10);
      },standardizePath:function (path) {
        if (path.substr(0, 2) == './') path = path.substr(2);
        return path;
      },deleteFile:function (path) {
        path = FS.analyzePath(path);
        if (!path.parentExists || !path.exists) {
          throw 'Invalid path ' + path;
        }
        delete path.parentObject.contents[path.name];
      }};
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var contents = stream.object.contents;
        while (contents.length < offset) contents.push(0);
        for (var i = 0; i < nbyte; i++) {
          contents[offset + i] = HEAPU8[(((buf)+(i))|0)];
        }
        stream.object.timestamp = Date.now();
        return i;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        if (stream.object.isDevice) {
          if (stream.object.output) {
            for (var i = 0; i < nbyte; i++) {
              try {
                stream.object.output(HEAP8[(((buf)+(i))|0)]);
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
            }
            stream.object.timestamp = Date.now();
            return i;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var bytesWritten = _pwrite(fildes, buf, nbyte, stream.position);
          if (bytesWritten != -1) stream.position += bytesWritten;
          return bytesWritten;
        }
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = flagAlternative ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (flagAlwaysSigned) {
                if (currArg < 0) {
                  prefix = '-' + prefix;
                } else {
                  prefix = '+' + prefix;
                }
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (flagAlwaysSigned && currArg >= 0) {
                  argText = '+' + argText;
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }
  function ___assert_func(filename, line, func, condition) {
      throw 'Assertion failed: ' + (condition ? Pointer_stringify(condition) : 'unknown condition') + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + new Error().stack;
    }
  function _strdup(ptr) {
      var len = _strlen(ptr);
      var newStr = _malloc(len + 1);
      _memcpy(newStr, ptr, len);
      HEAP8[(((newStr)+(len))|0)]=0;
      return newStr;
    }
  function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }
  function _setlocale(category, locale) {
      if (!_setlocale.ret) _setlocale.ret = allocate([0], 'i8', ALLOC_NORMAL);
      return _setlocale.ret;
    }
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i32=_memset;
  function __isFloat(text) {
      return !!(/^[+-]?[0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?$/.exec(text));
    }function __scanString(format, get, unget, varargs) {
      if (!__scanString.whiteSpace) {
        __scanString.whiteSpace = {};
        __scanString.whiteSpace[32] = 1;
        __scanString.whiteSpace[9] = 1;
        __scanString.whiteSpace[10] = 1;
        __scanString.whiteSpace[' '] = 1;
        __scanString.whiteSpace['\t'] = 1;
        __scanString.whiteSpace['\n'] = 1;
      }
      // Supports %x, %4x, %d.%d, %lld, %s, %f, %lf.
      // TODO: Support all format specifiers.
      format = Pointer_stringify(format);
      var soFar = 0;
      if (format.indexOf('%n') >= 0) {
        // need to track soFar
        var _get = get;
        get = function() {
          soFar++;
          return _get();
        }
        var _unget = unget;
        unget = function() {
          soFar--;
          return _unget();
        }
      }
      var formatIndex = 0;
      var argsi = 0;
      var fields = 0;
      var argIndex = 0;
      var next;
      mainLoop:
      for (var formatIndex = 0; formatIndex < format.length;) {
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'n') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          HEAP32[((argPtr)>>2)]=soFar;
          formatIndex += 2;
          continue;
        }
        // TODO: Support strings like "%5c" etc.
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'c') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          fields++;
          next = get();
          HEAP8[(argPtr)]=next
          formatIndex += 2;
          continue;
        }
        // remove whitespace
        while (1) {
          next = get();
          if (next == 0) return fields;
          if (!(next in __scanString.whiteSpace)) break;
        }
        unget();
        if (format[formatIndex] === '%') {
          formatIndex++;
          var suppressAssignment = false;
          if (format[formatIndex] == '*') {
            suppressAssignment = true;
            formatIndex++;
          }
          var maxSpecifierStart = formatIndex;
          while (format[formatIndex].charCodeAt(0) >= 48 &&
                 format[formatIndex].charCodeAt(0) <= 57) {
            formatIndex++;
          }
          var max_;
          if (formatIndex != maxSpecifierStart) {
            max_ = parseInt(format.slice(maxSpecifierStart, formatIndex), 10);
          }
          var long_ = false;
          var half = false;
          var longLong = false;
          if (format[formatIndex] == 'l') {
            long_ = true;
            formatIndex++;
            if(format[formatIndex] == 'l') {
              longLong = true;
              formatIndex++;
            }
          } else if (format[formatIndex] == 'h') {
            half = true;
            formatIndex++;
          }
          var type = format[formatIndex];
          formatIndex++;
          var curr = 0;
          var buffer = [];
          // Read characters according to the format. floats are trickier, they may be in an unfloat state in the middle, then be a valid float later
          if (type == 'f' || type == 'e' || type == 'g' || type == 'E') {
            var last = 0;
            next = get();
            while (next > 0) {
              buffer.push(String.fromCharCode(next));
              if (__isFloat(buffer.join(''))) {
                last = buffer.length;
              }
              next = get();
            }
            for (var i = 0; i < buffer.length - last + 1; i++) {
              unget();
            }
            buffer.length = last;
          } else {
            next = get();
            var first = true;
            while ((curr < max_ || isNaN(max_)) && next > 0) {
              if (!(next in __scanString.whiteSpace) && // stop on whitespace
                  (type == 's' ||
                   ((type === 'd' || type == 'u' || type == 'i') && ((next >= 48 && next <= 57) ||
                                                                     (first && next == 45))) ||
                   (type === 'x' && (next >= 48 && next <= 57 ||
                                     next >= 97 && next <= 102 ||
                                     next >= 65 && next <= 70))) &&
                  (formatIndex >= format.length || next !== format[formatIndex].charCodeAt(0))) { // Stop when we read something that is coming up
                buffer.push(String.fromCharCode(next));
                next = get();
                curr++;
                first = false;
              } else {
                break;
              }
            }
            unget();
          }
          if (buffer.length === 0) return 0;  // Failure.
          if (suppressAssignment) continue;
          var text = buffer.join('');
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          switch (type) {
            case 'd': case 'u': case 'i':
              if (half) {
                HEAP16[((argPtr)>>1)]=parseInt(text, 10);
              } else if(longLong) {
                (tempI64 = [parseInt(text, 10)>>>0,Math.min(Math.floor((parseInt(text, 10))/(+(4294967296))), (+(4294967295)))>>>0],HEAP32[((argPtr)>>2)]=tempI64[0],HEAP32[(((argPtr)+(4))>>2)]=tempI64[1]);
              } else {
                HEAP32[((argPtr)>>2)]=parseInt(text, 10);
              }
              break;
            case 'x':
              HEAP32[((argPtr)>>2)]=parseInt(text, 16)
              break;
            case 'f':
            case 'e':
            case 'g':
            case 'E':
              // fallthrough intended
              if (long_) {
                HEAPF64[((argPtr)>>3)]=parseFloat(text)
              } else {
                HEAPF32[((argPtr)>>2)]=parseFloat(text)
              }
              break;
            case 's':
              var array = intArrayFromString(text);
              for (var j = 0; j < array.length; j++) {
                HEAP8[(((argPtr)+(j))|0)]=array[j]
              }
              break;
          }
          fields++;
        } else if (format[formatIndex] in __scanString.whiteSpace) {
          next = get();
          while (next in __scanString.whiteSpace) {
            if (next <= 0) break mainLoop;  // End of input.
            next = get();
          }
          unget(next);
          formatIndex++;
        } else {
          // Not a specifier.
          next = get();
          if (format[formatIndex].charCodeAt(0) !== next) {
            unget(next);
            break mainLoop;
          }
          formatIndex++;
        }
      }
      return fields;
    }function _sscanf(s, format, varargs) {
      // int sscanf(const char *restrict s, const char *restrict format, ... );
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/scanf.html
      var index = 0;
      var get = function() { return HEAP8[(((s)+(index++))|0)]; };
      var unget = function() { index--; };
      return __scanString(format, get, unget, varargs);
    }
  var ___strtok_state=0;
  function _strtok_r(s, delim, lasts) {
      var skip_leading_delim = 1;
      var spanp;
      var c, sc;
      var tok;
      if (s == 0 && (s = getValue(lasts, 'i8*')) == 0) {
        return 0;
      }
      cont: while (1) {
        c = getValue(s++, 'i8');
        for (spanp = delim; (sc = getValue(spanp++, 'i8')) != 0;) {
          if (c == sc) {
            if (skip_leading_delim) {
              continue cont;
            } else {
              setValue(lasts, s, 'i8*');
              setValue(s - 1, 0, 'i8');
              return s - 1;
            }
          }
        }
        break;
      }
      if (c == 0) {
        setValue(lasts, 0, 'i8*');
        return 0;
      }
      tok = s - 1;
      for (;;) {
        c = getValue(s++, 'i8');
        spanp = delim;
        do {
          if ((sc = getValue(spanp++, 'i8')) == c) {
            if (c == 0) {
              s = 0;
            } else {
              setValue(s - 1, 0, 'i8');
            }
            setValue(lasts, s, 'i8*');
            return tok;
          }
        } while (sc != 0);
      }
      abort('strtok_r error!');
    }function _strtok(s, delim) {
      return _strtok_r(s, delim, ___strtok_state);
    }
  function _isspace(chr) {
      return chr in { 32: 0, 9: 0, 10: 0, 11: 0, 12: 0, 13: 0 };
    }
  Module["_strcpy"] = _strcpy;
  Module["_strcat"] = _strcat;
  function _strchr(ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = HEAP8[(ptr)];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }
  var _cos=Math.cos;
  var _sin=Math.sin;
  var _atan2=Math.atan2;
  function __parseInt(str, endptr, base, min, max, bits, unsign) {
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
      // Check for a plus/minus sign.
      var multiplier = 1;
      if (HEAP8[(str)] == 45) {
        multiplier = -1;
        str++;
      } else if (HEAP8[(str)] == 43) {
        str++;
      }
      // Find base.
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            str++;
          }
        }
      }
      if (!finalBase) finalBase = 10;
      // Get digits.
      var chr;
      var ret = 0;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          ret = ret * finalBase + digit;
          str++;
        }
      }
      // Apply sign.
      ret *= multiplier;
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
      // Unsign if needed.
      if (unsign) {
        if (Math.abs(ret) > max) {
          ret = max;
          ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          ret = unSign(ret, bits);
        }
      }
      // Validate range.
      if (ret > max || ret < min) {
        ret = ret > max ? max : min;
        ___setErrNo(ERRNO_CODES.ERANGE);
      }
      if (bits == 64) {
        return ((asm.setTempRet0(Math.min(Math.floor((ret)/(+(4294967296))), (+(4294967295)))>>>0),ret>>>0)|0);
      }
      return ret;
    }function _strtol(str, endptr, base) {
      return __parseInt(str, endptr, base, -2147483648, 2147483647, 32);  // LONG_MIN, LONG_MAX.
    }function _atoi(ptr) {
      return _strtol(ptr, null, 10);
    }
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead = 0;
        while (stream.ungotten.length && nbyte > 0) {
          HEAP8[((buf++)|0)]=stream.ungotten.pop()
          nbyte--;
          bytesRead++;
        }
        var contents = stream.object.contents;
        var size = Math.min(contents.length - offset, nbyte);
        if (contents.subarray) { // typed array
          HEAPU8.set(contents.subarray(offset, offset+size), buf);
        } else
        if (contents.slice) { // normal array
          for (var i = 0; i < size; i++) {
            HEAP8[(((buf)+(i))|0)]=contents[offset + i]
          }
        } else {
          for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
            HEAP8[(((buf)+(i))|0)]=contents.get(offset + i)
          }
        }
        bytesRead += size;
        return bytesRead;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead;
        if (stream.object.isDevice) {
          if (stream.object.input) {
            bytesRead = 0;
            while (stream.ungotten.length && nbyte > 0) {
              HEAP8[((buf++)|0)]=stream.ungotten.pop()
              nbyte--;
              bytesRead++;
            }
            for (var i = 0; i < nbyte; i++) {
              try {
                var result = stream.object.input();
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              HEAP8[(((buf)+(i))|0)]=result
            }
            return bytesRead;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var ungotSize = stream.ungotten.length;
          bytesRead = _pread(fildes, buf, nbyte, stream.position);
          if (bytesRead != -1) {
            stream.position += (stream.ungotten.length - ungotSize) + bytesRead;
          }
          return bytesRead;
        }
      }
    }function _fgetc(stream) {
      // int fgetc(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgetc.html
      if (!FS.streams[stream]) return -1;
      var streamObj = FS.streams[stream];
      if (streamObj.eof || streamObj.error) return -1;
      var ret = _read(stream, _fgetc.ret, 1);
      if (ret == 0) {
        streamObj.eof = true;
        return -1;
      } else if (ret == -1) {
        streamObj.error = true;
        return -1;
      } else {
        return HEAPU8[((_fgetc.ret)|0)];
      }
    }function _fgets(s, n, stream) {
      // char *fgets(char *restrict s, int n, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgets.html
      if (!FS.streams[stream]) return 0;
      var streamObj = FS.streams[stream];
      if (streamObj.error || streamObj.eof) return 0;
      var byte_;
      for (var i = 0; i < n - 1 && byte_ != 10; i++) {
        byte_ = _fgetc(stream);
        if (byte_ == -1) {
          if (streamObj.error || (streamObj.eof && i == 0)) return 0;
          else if (streamObj.eof) break;
        }
        HEAP8[(((s)+(i))|0)]=byte_
      }
      HEAP8[(((s)+(i))|0)]=0
      return s;
    }
  function _strrchr(ptr, chr) {
      var ptr2 = ptr + _strlen(ptr);
      do {
        if (HEAP8[(ptr2)] == chr) return ptr2;
        ptr2--;
      } while (ptr2 >= ptr);
      return 0;
    }
  function _access(path, amode) {
      // int access(const char *path, int amode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/access.html
      path = Pointer_stringify(path);
      var target = FS.findObject(path);
      if (target === null) return -1;
      if ((amode & 2 && !target.write) ||  // W_OK.
          ((amode & 1 || amode & 4) && !target.read)) {  // X_OK, R_OK.
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else {
        return 0;
      }
    }
  var _fabs=Math.abs;
  Module["_strncpy"] = _strncpy;
  function _bsearch(key, base, num, size, compar) {
      var cmp = function(x, y) {
        return Runtime.dynCall('iii', compar, [x, y])
      };
      var left = 0;
      var right = num;
      var mid, test, addr;
      while (left < right) {
        mid = (left + right) >>> 1;
        addr = base + (mid * size);
        test = cmp(key, addr);
        if (test < 0) {
          right = mid;
        } else if (test > 0) {
          left = mid + 1;
        } else {
          return addr;
        }
      }
      return 0;
    }
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      function ExitStatus() {
        this.name = "ExitStatus";
        this.message = "Program terminated with exit(" + status + ")";
        this.status = status;
        Module.print('Exit Status: ' + status);
      };
      ExitStatus.prototype = new Error();
      ExitStatus.prototype.constructor = ExitStatus;
      exitRuntime();
      ABORT = true;
      throw new ExitStatus();
    }function _exit(status) {
      __exit(status);
    }
  Module["_tolower"] = _tolower;
  function _rand() {
      return Math.floor(Math.random()*0x80000000);
    }
  function _abort() {
      ABORT = true;
      throw 'abort() at ' + (new Error().stack);
    }
  function _toupper(chr) {
      if (chr >= 97 && chr <= 122) {
        return chr - 97 + 65;
      } else {
        return chr;
      }
    }
  function _fputc(c, stream) {
      // int fputc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputc.html
      var chr = unSign(c & 0xFF);
      HEAP8[((_fputc.ret)|0)]=chr
      var ret = _write(stream, _fputc.ret, 1);
      if (ret == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return -1;
      } else {
        return chr;
      }
    }
  function _hypot(a, b) {
       return Math.sqrt(a*a + b*b);
    }
  function _isupper(chr) {
      return chr >= 65 && chr <= 90;
    }
  var ___dirent_struct_layout={__size__:1040,d_ino:0,d_name:4,d_off:1028,d_reclen:1032,d_type:1036};function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      // NOTE: This implementation tries to mimic glibc rather than strictly
      // following the POSIX standard.
      var mode = HEAP32[((varargs)>>2)];
      // Simplify flags.
      var accessMode = oflag & 3;
      var isWrite = accessMode != 0;
      var isRead = accessMode != 1;
      var isCreate = Boolean(oflag & 512);
      var isExistCheck = Boolean(oflag & 2048);
      var isTruncate = Boolean(oflag & 1024);
      var isAppend = Boolean(oflag & 8);
      // Verify path.
      var origPath = path;
      path = FS.analyzePath(Pointer_stringify(path));
      if (!path.parentExists) {
        ___setErrNo(path.error);
        return -1;
      }
      var target = path.object || null;
      var finalPath;
      // Verify the file exists, create if needed and allowed.
      if (target) {
        if (isCreate && isExistCheck) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          return -1;
        }
        if ((isWrite || isCreate || isTruncate) && target.isFolder) {
          ___setErrNo(ERRNO_CODES.EISDIR);
          return -1;
        }
        if (isRead && !target.read || isWrite && !target.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        }
        if (isTruncate && !target.isDevice) {
          target.contents = [];
        } else {
          if (!FS.forceLoadFile(target)) {
            ___setErrNo(ERRNO_CODES.EIO);
            return -1;
          }
        }
        finalPath = path.path;
      } else {
        if (!isCreate) {
          ___setErrNo(ERRNO_CODES.ENOENT);
          return -1;
        }
        if (!path.parentObject.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        }
        target = FS.createDataFile(path.parentObject, path.name, [],
                                   mode & 0x100, mode & 0x80);  // S_IRUSR, S_IWUSR.
        finalPath = path.parentPath + '/' + path.name;
      }
      // Actually create an open stream.
      var id = FS.streams.length; // Keep dense
      if (target.isFolder) {
        var entryBuffer = 0;
        if (___dirent_struct_layout) {
          entryBuffer = _malloc(___dirent_struct_layout.__size__);
        }
        var contents = [];
        for (var key in target.contents) contents.push(key);
        FS.streams[id] = {
          path: finalPath,
          object: target,
          // An index into contents. Special values: -2 is ".", -1 is "..".
          position: -2,
          isRead: true,
          isWrite: false,
          isAppend: false,
          error: false,
          eof: false,
          ungotten: [],
          // Folder-specific properties:
          // Remember the contents at the time of opening in an array, so we can
          // seek between them relying on a single order.
          contents: contents,
          // Each stream has its own area for readdir() returns.
          currentEntry: entryBuffer
        };
      } else {
        FS.streams[id] = {
          path: finalPath,
          object: target,
          position: 0,
          isRead: isRead,
          isWrite: isWrite,
          isAppend: isAppend,
          error: false,
          eof: false,
          ungotten: []
        };
      }
      return id;
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 512;
        flags |= 1024;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 512;
        flags |= 8;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var ret = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return (ret == -1) ? 0 : ret;
    }
  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      if (FS.streams[fildes]) {
        if (FS.streams[fildes].currentEntry) {
          _free(FS.streams[fildes].currentEntry);
        }
        FS.streams[fildes] = null;
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      if (FS.streams[fildes]) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      _fsync(stream);
      return _close(stream);
    }
  function _strstr(ptr1, ptr2) {
      var check = 0, start;
      do {
        if (!check) {
          start = ptr1;
          check = ptr2;
        }
        var curr1 = HEAP8[((ptr1++)|0)];
        var curr2 = HEAP8[((check++)|0)];
        if (curr2 == 0) return start;
        if (curr2 != curr1) {
          // rewind to one character after start, to find ez in eeez
          ptr1 = start + 1;
          check = 0;
        }
      } while (curr1);
      return 0;
    }
  var ___stat_struct_layout={__size__:68,st_dev:0,st_ino:4,st_mode:8,st_nlink:12,st_uid:16,st_gid:20,st_rdev:24,st_size:28,st_atime:32,st_spare1:36,st_mtime:40,st_spare2:44,st_ctime:48,st_spare3:52,st_blksize:56,st_blocks:60,st_spare4:64};function _stat(path, buf, dontResolveLastLink) {
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/stat.html
      // int stat(const char *path, struct stat *buf);
      // NOTE: dontResolveLastLink is a shortcut for lstat(). It should never be
      //       used in client code.
      var obj = FS.findObject(Pointer_stringify(path), dontResolveLastLink);
      if (obj === null || !FS.forceLoadFile(obj)) return -1;
      var offsets = ___stat_struct_layout;
      // Constants.
      HEAP32[(((buf)+(offsets.st_nlink))>>2)]=1
      HEAP32[(((buf)+(offsets.st_uid))>>2)]=0
      HEAP32[(((buf)+(offsets.st_gid))>>2)]=0
      HEAP32[(((buf)+(offsets.st_blksize))>>2)]=4096
      // Variables.
      HEAP32[(((buf)+(offsets.st_ino))>>2)]=obj.inodeNumber
      var time = Math.floor(obj.timestamp / 1000);
      if (offsets.st_atime === undefined) {
        offsets.st_atime = offsets.st_atim.tv_sec;
        offsets.st_mtime = offsets.st_mtim.tv_sec;
        offsets.st_ctime = offsets.st_ctim.tv_sec;
        var nanosec = (obj.timestamp % 1000) * 1000;
        HEAP32[(((buf)+(offsets.st_atim.tv_nsec))>>2)]=nanosec
        HEAP32[(((buf)+(offsets.st_mtim.tv_nsec))>>2)]=nanosec
        HEAP32[(((buf)+(offsets.st_ctim.tv_nsec))>>2)]=nanosec
      }
      HEAP32[(((buf)+(offsets.st_atime))>>2)]=time
      HEAP32[(((buf)+(offsets.st_mtime))>>2)]=time
      HEAP32[(((buf)+(offsets.st_ctime))>>2)]=time
      var mode = 0;
      var size = 0;
      var blocks = 0;
      var dev = 0;
      var rdev = 0;
      if (obj.isDevice) {
        //  Device numbers reuse inode numbers.
        dev = rdev = obj.inodeNumber;
        size = blocks = 0;
        mode = 0x2000;  // S_IFCHR.
      } else {
        dev = 1;
        rdev = 0;
        // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
        //       but this is not required by the standard.
        if (obj.isFolder) {
          size = 4096;
          blocks = 1;
          mode = 0x4000;  // S_IFDIR.
        } else {
          var data = obj.contents || obj.link;
          size = data.length;
          blocks = Math.ceil(data.length / 4096);
          mode = obj.link === undefined ? 0x8000 : 0xA000;  // S_IFREG, S_IFLNK.
        }
      }
      HEAP32[(((buf)+(offsets.st_dev))>>2)]=dev;
      HEAP32[(((buf)+(offsets.st_rdev))>>2)]=rdev;
      HEAP32[(((buf)+(offsets.st_size))>>2)]=size
      HEAP32[(((buf)+(offsets.st_blocks))>>2)]=blocks
      if (obj.read) mode |= 0x16D;  // S_IRUSR | S_IXUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH.
      if (obj.write) mode |= 0x92;  // S_IWUSR | S_IWGRP | S_IWOTH.
      HEAP32[(((buf)+(offsets.st_mode))>>2)]=mode
      return 0;
    }function _fstat(fildes, buf) {
      // int fstat(int fildes, struct stat *buf);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/fstat.html
      if (!FS.streams[fildes]) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else {
        var pathArray = intArrayFromString(FS.streams[fildes].path);
        return _stat(allocate(pathArray, 'i8', ALLOC_STACK), buf);
      }
    }
  function _fileno(stream) {
      // int fileno(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fileno.html
      // We use file descriptor numbers and FILE* streams interchangeably.
      return stream;
    }
  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      if (FS.streams[fildes] && !FS.streams[fildes].object.isDevice) {
        var stream = FS.streams[fildes];
        var position = offset;
        if (whence === 1) {  // SEEK_CUR.
          position += stream.position;
        } else if (whence === 2) {  // SEEK_END.
          position += stream.object.contents.length;
        }
        if (position < 0) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        } else {
          stream.ungotten = [];
          stream.position = position;
          return position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var ret = _lseek(stream, offset, whence);
      if (ret == -1) {
        return -1;
      } else {
        FS.streams[stream].eof = false;
        return 0;
      }
    }
  function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) return 0;
      var bytesRead = _read(stream, ptr, bytesToRead);
      var streamObj = FS.streams[stream];
      if (bytesRead == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        if (bytesRead < bytesToRead) streamObj.eof = true;
        return Math.floor(bytesRead / size);
      }
    }
  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = 'root';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/emscripten';
        ENV['LANG'] = 'en_US.UTF-8';
        ENV['_'] = './this.program';
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        for (var j = 0; j < line.length; j++) {
          HEAP8[(((poolPtr)+(j))|0)]=line.charCodeAt(j);
        }
        HEAP8[(((poolPtr)+(j))|0)]=0;
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }
  function _putenv(string) {
      // int putenv(char *string);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/putenv.html
      // WARNING: According to the standard (and the glibc implementation), the
      //          string is taken by reference so future changes are reflected.
      //          We copy it instead, possibly breaking some uses.
      if (string === 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      }
      string = Pointer_stringify(string);
      var splitPoint = string.indexOf('=')
      if (string === '' || string.indexOf('=') === -1) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      }
      var name = string.slice(0, splitPoint);
      var value = string.slice(splitPoint + 1);
      if (!(name in ENV) || ENV[name] !== value) {
        ENV[name] = value;
        ___buildEnvironment(ENV);
      }
      return 0;
    }
  function _freeXDot() {
  Module['printErr']('missing function: freeXDot'); abort(-1);
  }
  var ___tms_struct_layout={__size__:16,tms_utime:0,tms_stime:4,tms_cutime:8,tms_cstime:12};function _times(buffer) {
      // clock_t times(struct tms *buffer);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/times.html
      // NOTE: This is fake, since we can't calculate real CPU time usage in JS.
      if (buffer !== 0) {
        _memset(buffer, 0, ___tms_struct_layout.__size__);
      }
      return 0;
    }
  var ERRNO_MESSAGES={1:"Operation not permitted",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"Input/output error",6:"No such device or address",8:"Exec format error",9:"Bad file descriptor",10:"No child processes",11:"Resource temporarily unavailable",12:"Cannot allocate memory",13:"Permission denied",14:"Bad address",16:"Device or resource busy",17:"File exists",18:"Invalid cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Inappropriate ioctl for device",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read-only file system",31:"Too many links",32:"Broken pipe",33:"Numerical argument out of domain",34:"Numerical result out of range",35:"Resource deadlock avoided",36:"File name too long",37:"No locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many levels of symbolic links",42:"No message of desired type",43:"Identifier removed",45:"Op not supported on transport endpoint",60:"Device not a stream",61:"No data available",62:"Timer expired",63:"Out of streams resources",67:"Link has been severed",71:"Protocol error",72:"Multihop attempted",74:"Bad message",75:"Value too large for defined data type",84:"Invalid or incomplete multibyte or wide character",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Protocol not supported",95:"Operation not supported",97:"Address family not supported by protocol",98:"Address already in use",99:"Cannot assign requested address",100:"Network is down",101:"Network is unreachable",102:"Network dropped connection on reset",103:"Software caused connection abort",104:"Connection reset by peer",105:"No buffer space available",106:"Transport endpoint is already connected",107:"Transport endpoint is not connected",110:"Connection timed out",111:"Connection refused",113:"No route to host",114:"Operation already in progress",115:"Operation now in progress",116:"Stale NFS file handle",122:"Disk quota exceeded",125:"Operation canceled",130:"Owner died",131:"State not recoverable"};function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          for (var i = 0; i < msg.length; i++) {
            HEAP8[(((strerrbuf)+(i))|0)]=msg.charCodeAt(i)
          }
          HEAP8[(((strerrbuf)+(i))|0)]=0
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }
  function ___errno_location() {
      if (!___setErrNo.ret) {
        ___setErrNo.ret = allocate([0], 'i32', ALLOC_NORMAL);
        HEAP32[((___setErrNo.ret)>>2)]=0
      }
      return ___setErrNo.ret;
    }var ___errno=___errno_location;
  function _ferror(stream) {
      // int ferror(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ferror.html
      return Number(FS.streams[stream] && FS.streams[stream].error);
    }
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      var flush = function(filedes) {
        // Right now we write all data directly, except for output devices.
        if (FS.streams[filedes] && FS.streams[filedes].object.output) {
          if (!FS.streams[filedes].isTerminal) { // don't flush terminals, it would cause a \n to also appear
            FS.streams[filedes].object.output(null);
          }
        }
      };
      try {
        if (stream === 0) {
          for (var i = 0; i < FS.streams.length; i++) if (FS.streams[i]) flush(i);
        } else {
          flush(stream);
        }
        return 0;
      } catch (e) {
        ___setErrNo(ERRNO_CODES.EIO);
        return -1;
      }
    }
  var _llvm_va_start=undefined;
  function _vsprintf(s, format, va_arg) {
      return _sprintf(s, format, HEAP32[((va_arg)>>2)]);
    }
  function _llvm_va_end() {}
  function _feof(stream) {
      // int feof(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/feof.html
      return Number(FS.streams[stream] && FS.streams[stream].eof);
    }
  var _llvm_pow_f64=Math.pow;
  function _isalnum(chr) {
      return (chr >= 48 && chr <= 57) ||
             (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }
  function _isalpha(chr) {
      return (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }
  function _islower(chr) {
      return chr >= 97 && chr <= 122;
    }
  function _ispunct(chr) {
      return (chr >= 33 && chr <= 47) ||
             (chr >= 58 && chr <= 64) ||
             (chr >= 91 && chr <= 96) ||
             (chr >= 123 && chr <= 126);
    }
  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      if (FS.streams[stream]) {
        stream = FS.streams[stream];
        if (stream.object.isDevice) {
          ___setErrNo(ERRNO_CODES.ESPIPE);
          return -1;
        } else {
          return stream.position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  function _vfprintf(s, f, va_arg) {
      return _fprintf(s, f, HEAP32[((va_arg)>>2)]);
    }
  function _tmpnam(s, dir, prefix) {
      // char *tmpnam(char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/tmpnam.html
      // NOTE: The dir and prefix arguments are for internal use only.
      var folder = FS.findObject(dir || '/tmp');
      if (!folder || !folder.isFolder) {
        dir = '/tmp';
        folder = FS.findObject(dir);
        if (!folder || !folder.isFolder) return 0;
      }
      var name = prefix || 'file';
      do {
        name += String.fromCharCode(65 + Math.floor(Math.random() * 25));
      } while (name in folder.contents);
      var result = dir + '/' + name;
      if (!_tmpnam.buffer) _tmpnam.buffer = _malloc(256);
      if (!s) s = _tmpnam.buffer;
      for (var i = 0; i < result.length; i++) {
        HEAP8[(((s)+(i))|0)]=result.charCodeAt(i);
      }
      HEAP8[(((s)+(i))|0)]=0;
      return s;
    }function _tmpfile() {
      // FILE *tmpfile(void);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/tmpfile.html
      // TODO: Delete the created file on closing.
      if (_tmpfile.mode) {
        _tmpfile.mode = allocate(intArrayFromString('w+'), 'i8', ALLOC_NORMAL);
      }
      return _fopen(_tmpnam(0), _tmpfile.mode);
    }
  function _vsnprintf(s, n, format, va_arg) {
      return _snprintf(s, n, format, HEAP32[((va_arg)>>2)]);
    }
  function _iscntrl(chr) {
      return (0 <= chr && chr <= 0x1F) || chr === 0x7F;
    }
  function _qsort(base, num, size, cmp) {
      if (num == 0 || size == 0) return;
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var comparator = function(x, y) {
        return Runtime.dynCall('iii', cmp, [x, y]);
      }
      var keys = [];
      for (var i = 0; i < num; i++) keys.push(i);
      keys.sort(function(a, b) {
        return comparator(base+a*size, base+b*size);
      });
      // apply the sort
      var temp = _malloc(num*size);
      _memcpy(temp, base, num*size);
      for (var i = 0; i < num; i++) {
        if (keys[i] == i) continue; // already in place
        _memcpy(base+i*size, temp+keys[i]*size, size);
      }
      _free(temp);
    }
  var _ceil=Math.ceil;
  function _bcopy() {
  Module['printErr']('missing function: bcopy'); abort(-1);
  }
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  function _srand(seed) {}
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 8: return PAGE_SIZE;
        case 54:
        case 56:
        case 21:
        case 61:
        case 63:
        case 22:
        case 67:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 69:
        case 28:
        case 101:
        case 70:
        case 71:
        case 29:
        case 30:
        case 199:
        case 75:
        case 76:
        case 32:
        case 43:
        case 44:
        case 80:
        case 46:
        case 47:
        case 45:
        case 48:
        case 49:
        case 42:
        case 82:
        case 33:
        case 7:
        case 108:
        case 109:
        case 107:
        case 112:
        case 119:
        case 121:
          return 200809;
        case 13:
        case 104:
        case 94:
        case 95:
        case 34:
        case 35:
        case 77:
        case 81:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 91:
        case 94:
        case 95:
        case 110:
        case 111:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 120:
        case 40:
        case 16:
        case 79:
        case 19:
          return -1;
        case 92:
        case 93:
        case 5:
        case 72:
        case 6:
        case 74:
        case 92:
        case 93:
        case 96:
        case 97:
        case 98:
        case 99:
        case 102:
        case 103:
        case 105:
          return 1;
        case 38:
        case 66:
        case 50:
        case 51:
        case 4:
          return 1024;
        case 15:
        case 64:
        case 41:
          return 32;
        case 55:
        case 37:
        case 17:
          return 2147483647;
        case 18:
        case 1:
          return 47839;
        case 59:
        case 57:
          return 99;
        case 68:
        case 58:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 14: return 32768;
        case 73: return 32767;
        case 39: return 16384;
        case 60: return 1000;
        case 106: return 700;
        case 52: return 256;
        case 62: return 255;
        case 2: return 100;
        case 65: return 64;
        case 36: return 20;
        case 100: return 16;
        case 20: return 6;
        case 53: return 4;
        case 10: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  var _llvm_memset_p0i8_i64=_memset;
  Module["_memmove"] = _memmove;var _llvm_memmove_p0i8_p0i8_i32=_memmove;
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (Browser.initted) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : console.log("warning: cannot create object URLs");
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        function getMimetype(name) {
          return {
            'jpg': 'image/jpeg',
            'jpeg': 'image/jpeg',
            'png': 'image/png',
            'bmp': 'image/bmp',
            'ogg': 'audio/ogg',
            'wav': 'audio/wav',
            'mp3': 'audio/mpeg'
          }[name.substr(name.lastIndexOf('.')+1)];
        }
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = [];
        var imagePlugin = {};
        imagePlugin['canHandle'] = function(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/.exec(name);
        };
        imagePlugin['handle'] = function(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: getMimetype(name) });
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            setTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'];
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule) {
        var ctx;
        try {
          if (useWebGL) {
            ctx = canvas.getContext('experimental-webgl', {
              alpha: false
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        this.lockPointer = lockPointer;
        this.resizeCanvas = resizeCanvas;
        if (typeof this.lockPointer === 'undefined') this.lockPointer = true;
        if (typeof this.resizeCanvas === 'undefined') this.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!this.fullScreenHandlersInstalled) {
          this.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen(); 
      },requestAnimationFrame:function (func) {
        if (!window.requestAnimationFrame) {
          window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                         window['mozRequestAnimationFrame'] ||
                                         window['webkitRequestAnimationFrame'] ||
                                         window['msRequestAnimationFrame'] ||
                                         window['oRequestAnimationFrame'] ||
                                         window['setTimeout'];
        }
        window.requestAnimationFrame(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        Browser.updateResizeListeners();
      }};
__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___strtok_state = Runtime.staticAlloc(4);
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
___buildEnvironment(ENV);
Module["requestFullScreen"] = function(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function(func) { Browser.requestAnimationFrame(func) };
  Module["pauseMainLoop"] = function() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function() { Browser.mainLoop.resume() };
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
var Math_min = Math.min;
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module.dynCall_iiiii(index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_viiiffi(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module.dynCall_viiiffi(index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module.dynCall_viiiii(index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module.dynCall_vi(index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module.dynCall_vii(index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module.dynCall_ii(index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module.dynCall_iiii(index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module.dynCall_viii(index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_v(index) {
  try {
    Module.dynCall_v(index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module.dynCall_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module.dynCall_viiiiii(index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module.dynCall_iii(index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module.dynCall_iiiiii(index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module.dynCall_viiii(index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm.setThrew(1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'use asm';
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);
  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var _stdout=env._stdout|0;
  var _stderr=env._stderr|0;
  var NaN=+env.NaN;
  var Infinity=+env.Infinity;
  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;
  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var abort=env.abort;
  var assert=env.assert;
  var asmPrintInt=env.asmPrintInt;
  var asmPrintFloat=env.asmPrintFloat;
  var copyTempDouble=env.copyTempDouble;
  var copyTempFloat=env.copyTempFloat;
  var Math_min=env.min;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_viiiffi=env.invoke_viiiffi;
  var invoke_viiiii=env.invoke_viiiii;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_ii=env.invoke_ii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_viii=env.invoke_viii;
  var invoke_v=env.invoke_v;
  var invoke_viiiiiiiii=env.invoke_viiiiiiiii;
  var invoke_viiiiii=env.invoke_viiiiii;
  var invoke_iii=env.invoke_iii;
  var invoke_iiiiii=env.invoke_iiiiii;
  var invoke_viiii=env.invoke_viiii;
  var _lseek=env._lseek;
  var __scanString=env.__scanString;
  var _fclose=env._fclose;
  var __isFloat=env.__isFloat;
  var _fflush=env._fflush;
  var _strtol=env._strtol;
  var _fputc=env._fputc;
  var _strtok=env._strtok;
  var _fwrite=env._fwrite;
  var _tmpnam=env._tmpnam;
  var _isspace=env._isspace;
  var _read=env._read;
  var _ceil=env._ceil;
  var _fileno=env._fileno;
  var _strstr=env._strstr;
  var _fsync=env._fsync;
  var _strcmp=env._strcmp;
  var _strncmp=env._strncmp;
  var _tmpfile=env._tmpfile;
  var _snprintf=env._snprintf;
  var _fgetc=env._fgetc;
  var _hypot=env._hypot;
  var _fgets=env._fgets;
  var _close=env._close;
  var _strchr=env._strchr;
  var ___setErrNo=env.___setErrNo;
  var _access=env._access;
  var _ftell=env._ftell;
  var _exit=env._exit;
  var _sprintf=env._sprintf;
  var _strrchr=env._strrchr;
  var _ferror=env._ferror;
  var _cos=env._cos;
  var _putenv=env._putenv;
  var _times=env._times;
  var _bsearch=env._bsearch;
  var _islower=env._islower;
  var __exit=env.__exit;
  var _isupper=env._isupper;
  var _rand=env._rand;
  var _setlocale=env._setlocale;
  var _bcopy=env._bcopy;
  var _toupper=env._toupper;
  var _pread=env._pread;
  var _fopen=env._fopen;
  var _open=env._open;
  var _isalnum=env._isalnum;
  var _qsort=env._qsort;
  var _isalpha=env._isalpha;
  var _strdup=env._strdup;
  var _srand=env._srand;
  var __formatString=env.__formatString;
  var _getenv=env._getenv;
  var _atoi=env._atoi;
  var _vfprintf=env._vfprintf;
  var _llvm_pow_f64=env._llvm_pow_f64;
  var _sbrk=env._sbrk;
  var ___errno_location=env.___errno_location;
  var _strerror=env._strerror;
  var _fstat=env._fstat;
  var __parseInt=env.__parseInt;
  var _freeXDot=env._freeXDot;
  var _vsprintf=env._vsprintf;
  var _vsnprintf=env._vsnprintf;
  var _sscanf=env._sscanf;
  var _sysconf=env._sysconf;
  var _fread=env._fread;
  var _strtok_r=env._strtok_r;
  var _abort=env._abort;
  var _fprintf=env._fprintf;
  var ___buildEnvironment=env.___buildEnvironment;
  var _feof=env._feof;
  var _statXDot=env._statXDot;
  var _ispunct=env._ispunct;
  var _fabs=env._fabs;
  var __reallyNegative=env.__reallyNegative;
  var _fseek=env._fseek;
  var _sqrt=env._sqrt;
  var _write=env._write;
  var _sin=env._sin;
  var _stat=env._stat;
  var _parseXDotF=env._parseXDotF;
  var _llvm_va_end=env._llvm_va_end;
  var ___assert_func=env.___assert_func;
  var _pwrite=env._pwrite;
  var _strerror_r=env._strerror_r;
  var _iscntrl=env._iscntrl;
  var _atan2=env._atan2;
  var _time=env._time;
// EMSCRIPTEN_START_FUNCS
function stackAlloc(size) {
  size = size | 0;
  var ret = 0;
  ret = STACKTOP;
  STACKTOP = STACKTOP + size | 0;
  STACKTOP = STACKTOP + 7 >> 3 << 3;
  return ret | 0;
}
function stackSave() {
  return STACKTOP | 0;
}
function stackRestore(top) {
  top = top | 0;
  STACKTOP = top;
}
function setThrew(threw, value) {
  threw = threw | 0;
  value = value | 0;
  if ((__THREW__ | 0) == 0) {
    __THREW__ = threw;
    threwValue = value;
  }
}
function setTempRet0(value) {
  value = value | 0;
  tempRet0 = value;
}
function setTempRet1(value) {
  value = value | 0;
  tempRet1 = value;
}
function setTempRet2(value) {
  value = value | 0;
  tempRet2 = value;
}
function setTempRet3(value) {
  value = value | 0;
  tempRet3 = value;
}
function setTempRet4(value) {
  value = value | 0;
  tempRet4 = value;
}
function setTempRet5(value) {
  value = value | 0;
  tempRet5 = value;
}
function setTempRet6(value) {
  value = value | 0;
  tempRet6 = value;
}
function setTempRet7(value) {
  value = value | 0;
  tempRet7 = value;
}
function setTempRet8(value) {
  value = value | 0;
  tempRet8 = value;
}
function setTempRet9(value) {
  value = value | 0;
  tempRet9 = value;
}
function _dtflatten($dt) {
  $dt = $dt | 0;
  var $data = 0, $0 = 0, $type = 0, $1 = 0, $and = 0, $tobool = 0, $here = 0, $2 = 0, $and4 = 0, $tobool5 = 0, $_htab = 0, $3 = 0, $ntab = 0, $4 = 0, $add_ptr = 0, $cmp46 = 0, $s_049 = 0, $last_048 = 0, $list_047 = 0, $5 = 0, $tobool9 = 0, $tobool11 = 0, $right = 0, $list_1_ph = 0, $last_1_ph = 0, $last_1 = 0, $right14 = 0, $6 = 0, $tobool15 = 0, $list_2 = 0, $last_2 = 0, $incdec_ptr = 0, $cmp = 0, $and21 = 0, $tobool22 = 0, $hh25 = 0, $_head = 0, $7 = 0, $here28 = 0, $8 = 0, $tobool29 = 0, $hl40 = 0, $_left41 = 0, $9 = 0, $tobool3242 = 0, $r_0_lcssa = 0, $r_1_in35 = 0, $r_136 = 0, $tobool4137 = 0, $10 = 0, $hl44 = 0, $r_043 = 0, $right34 = 0, $11 = 0, $12 = 0, $_c34 = 0, $hl = 0, $_left = 0, $13 = 0, $tobool32 = 0, $r_139 = 0, $r_1_in38 = 0, $hl43 = 0, $_left44 = 0, $14 = 0, $tobool45 = 0, $r_0_pn_be = 0, $r_1_in = 0, $r_1 = 0, $tobool41 = 0, $t_0 = 0, $r_2 = 0, $right47 = 0, $15 = 0, $16 = 0, $_c = 0, $hl51 = 0, $_left52 = 0, $17 = 0, $tobool53 = 0, $list_3 = 0, $18 = 0, $here63 = 0, $19 = 0, $type65 = 0, $20 = 0, $or = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $data = $dt + 8 | 0;
    $0 = HEAP32[$data >> 2] | 0;
    $type = $0 | 0;
    $1 = HEAP32[$type >> 2] | 0;
    $and = $1 & 4096;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $here = $0 + 4 | 0;
    $2 = HEAP32[$here >> 2] | 0;
    $retval_0 = $2;
    label = 24;
    break;
   case 4:
    $and4 = $1 & 3;
    $tobool5 = ($and4 | 0) == 0;
    if ($tobool5) {
      label = 13;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $_htab = $0 + 8 | 0;
    $3 = HEAP32[$_htab >> 2] | 0;
    $ntab = $0 + 12 | 0;
    $4 = HEAP32[$ntab >> 2] | 0;
    $add_ptr = $3 + ($4 << 2) | 0;
    $cmp46 = ($4 | 0) > 0;
    if ($cmp46) {
      $list_047 = 0;
      $last_048 = 0;
      $s_049 = $3;
      label = 6;
      break;
    } else {
      $list_3 = 0;
      label = 23;
      break;
    }
   case 6:
    $5 = HEAP32[$s_049 >> 2] | 0;
    $tobool9 = ($5 | 0) == 0;
    if ($tobool9) {
      $last_2 = $last_048;
      $list_2 = $list_047;
      label = 12;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $tobool11 = ($last_048 | 0) == 0;
    if ($tobool11) {
      $last_1_ph = $5;
      $list_1_ph = $5;
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $right = $last_048 | 0;
    HEAP32[$right >> 2] = $5;
    $last_1_ph = $last_048;
    $list_1_ph = $list_047;
    label = 9;
    break;
   case 9:
    $last_1 = $last_1_ph;
    label = 10;
    break;
   case 10:
    $right14 = $last_1 | 0;
    $6 = HEAP32[$right14 >> 2] | 0;
    $tobool15 = ($6 | 0) == 0;
    if ($tobool15) {
      label = 11;
      break;
    } else {
      $last_1 = $6;
      label = 10;
      break;
    }
   case 11:
    HEAP32[$s_049 >> 2] = $last_1;
    $last_2 = $last_1;
    $list_2 = $list_1_ph;
    label = 12;
    break;
   case 12:
    $incdec_ptr = $s_049 + 4 | 0;
    $cmp = $incdec_ptr >>> 0 < $add_ptr >>> 0;
    if ($cmp) {
      $list_047 = $list_2;
      $last_048 = $last_2;
      $s_049 = $incdec_ptr;
      label = 6;
      break;
    } else {
      $list_3 = $list_2;
      label = 23;
      break;
    }
   case 13:
    $and21 = $1 & 112;
    $tobool22 = ($and21 | 0) == 0;
    if ($tobool22) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $hh25 = $0 + 8 | 0;
    $_head = $hh25;
    $7 = HEAP32[$_head >> 2] | 0;
    $list_3 = $7;
    label = 23;
    break;
   case 15:
    $here28 = $0 + 4 | 0;
    $8 = HEAP32[$here28 >> 2] | 0;
    $tobool29 = ($8 | 0) == 0;
    if ($tobool29) {
      $list_3 = 0;
      label = 23;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $hl40 = $8 + 4 | 0;
    $_left41 = $hl40;
    $9 = HEAP32[$_left41 >> 2] | 0;
    $tobool3242 = ($9 | 0) == 0;
    if ($tobool3242) {
      $r_0_lcssa = $8;
      label = 17;
      break;
    } else {
      $r_043 = $8;
      $hl44 = $hl40;
      $10 = $9;
      label = 18;
      break;
    }
   case 17:
    $r_1_in35 = $r_0_lcssa | 0;
    $r_136 = HEAP32[$r_1_in35 >> 2] | 0;
    $tobool4137 = ($r_136 | 0) == 0;
    if ($tobool4137) {
      $list_3 = $r_0_lcssa;
      label = 23;
      break;
    } else {
      $r_1_in38 = $r_1_in35;
      $r_139 = $r_136;
      label = 19;
      break;
    }
   case 18:
    $right34 = $10 | 0;
    $11 = HEAP32[$right34 >> 2] | 0;
    $12 = $hl44 | 0;
    $_c34 = $11;
    HEAP32[$12 >> 2] = $_c34;
    HEAP32[$right34 >> 2] = $r_043;
    $hl = $10 + 4 | 0;
    $_left = $hl;
    $13 = HEAP32[$_left >> 2] | 0;
    $tobool32 = ($13 | 0) == 0;
    if ($tobool32) {
      $r_0_lcssa = $10;
      label = 17;
      break;
    } else {
      $r_043 = $10;
      $hl44 = $hl;
      $10 = $13;
      label = 18;
      break;
    }
   case 19:
    $hl43 = $r_139 + 4 | 0;
    $_left44 = $hl43;
    $14 = HEAP32[$_left44 >> 2] | 0;
    $tobool45 = ($14 | 0) == 0;
    if ($tobool45) {
      $r_0_pn_be = $r_139;
      label = 20;
      break;
    } else {
      $r_2 = $r_139;
      $t_0 = $14;
      label = 21;
      break;
    }
   case 20:
    $r_1_in = $r_0_pn_be | 0;
    $r_1 = HEAP32[$r_1_in >> 2] | 0;
    $tobool41 = ($r_1 | 0) == 0;
    if ($tobool41) {
      $list_3 = $r_0_lcssa;
      label = 23;
      break;
    } else {
      $r_1_in38 = $r_1_in;
      $r_139 = $r_1;
      label = 19;
      break;
    }
   case 21:
    $right47 = $t_0 | 0;
    $15 = HEAP32[$right47 >> 2] | 0;
    $16 = $r_2 + 4 | 0;
    $_c = $15;
    HEAP32[$16 >> 2] = $_c;
    HEAP32[$right47 >> 2] = $r_2;
    $hl51 = $t_0 + 4 | 0;
    $_left52 = $hl51;
    $17 = HEAP32[$_left52 >> 2] | 0;
    $tobool53 = ($17 | 0) == 0;
    if ($tobool53) {
      label = 22;
      break;
    } else {
      $r_2 = $t_0;
      $t_0 = $17;
      label = 21;
      break;
    }
   case 22:
    HEAP32[$r_1_in38 >> 2] = $t_0;
    $r_0_pn_be = $t_0;
    label = 20;
    break;
   case 23:
    $18 = HEAP32[$data >> 2] | 0;
    $here63 = $18 + 4 | 0;
    HEAP32[$here63 >> 2] = $list_3;
    $19 = HEAP32[$data >> 2] | 0;
    $type65 = $19 | 0;
    $20 = HEAP32[$type65 >> 2] | 0;
    $or = $20 | 4096;
    HEAP32[$type65 >> 2] = $or;
    $retval_0 = $list_3;
    label = 24;
    break;
   case 24:
    return $retval_0 | 0;
  }
  return 0;
}
function _vizRenderFromString($string, $format) {
  $string = $string | 0;
  $format = $format | 0;
  var $call = 0, $call1 = 0, $0 = 0;
  $call = _gvContext() | 0;
  _gvAddLibrary($call, 14400);
  _gvAddLibrary($call, 14392);
  $call1 = _agmemread($string) | 0;
  $0 = $call1;
  _gvLayout($call, $0, 163256);
  _gvRender($call, $0, $format, HEAP32[_stdout >> 2] | 0);
  _gvFreeLayout(0, $0);
  _agclose($call1);
  _gvFreeContext($call);
  return;
}
function _dtclose($dt) {
  $dt = $dt | 0;
  var $tobool = 0, $nview = 0, $0 = 0, $cmp = 0, $disc1 = 0, $1 = 0, $eventf = 0, $2 = 0, $tobool2 = 0, $call = 0, $cmp4 = 0, $ev_0 = 0, $view = 0, $3 = 0, $tobool7 = 0, $call9 = 0, $cmp11 = 0, $meth = 0, $4 = 0, $searchf = 0, $5 = 0, $call13 = 0, $call14 = 0, $cmp15 = 0, $data = 0, $6 = 0, $ntab = 0, $7 = 0, $cmp18 = 0, $memoryf = 0, $8 = 0, $_htab = 0, $9 = 0, $10 = 0, $call21 = 0, $memoryf23 = 0, $11 = 0, $12 = 0, $13 = 0, $call25 = 0, $type = 0, $14 = 0, $cmp27 = 0, $15 = 0, $cmp32 = 0, $or_cond = 0, $memoryf34 = 0, $16 = 0, $17 = 0, $call35 = 0, $18 = 0, $tobool39 = 0, $call42 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tobool = ($dt | 0) == 0;
    if ($tobool) {
      $retval_0 = -1;
      label = 19;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $nview = $dt + 24 | 0;
    $0 = HEAP32[$nview >> 2] | 0;
    $cmp = ($0 | 0) > 0;
    if ($cmp) {
      $retval_0 = -1;
      label = 19;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $disc1 = $dt + 4 | 0;
    $1 = HEAP32[$disc1 >> 2] | 0;
    $eventf = $1 + 32 | 0;
    $2 = HEAP32[$eventf >> 2] | 0;
    $tobool2 = ($2 | 0) == 0;
    if ($tobool2) {
      $ev_0 = 0;
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $call = FUNCTION_TABLE_iiiii[$2 & 1023]($dt, 2, 0, $1) | 0;
    $cmp4 = ($call | 0) < 0;
    if ($cmp4) {
      $retval_0 = -1;
      label = 19;
      break;
    } else {
      $ev_0 = $call;
      label = 6;
      break;
    }
   case 6:
    $view = $dt + 28 | 0;
    $3 = HEAP32[$view >> 2] | 0;
    $tobool7 = ($3 | 0) == 0;
    if ($tobool7) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $call9 = _dtview($dt, 0) | 0;
    label = 8;
    break;
   case 8:
    $cmp11 = ($ev_0 | 0) == 0;
    if ($cmp11) {
      label = 9;
      break;
    } else {
      label = 13;
      break;
    }
   case 9:
    $meth = $dt + 16 | 0;
    $4 = HEAP32[$meth >> 2] | 0;
    $searchf = $4 | 0;
    $5 = HEAP32[$searchf >> 2] | 0;
    $call13 = FUNCTION_TABLE_iiii[$5 & 1023]($dt, 0, 64) | 0;
    $call14 = _dtsize($dt) | 0;
    $cmp15 = ($call14 | 0) > 0;
    if ($cmp15) {
      $retval_0 = -1;
      label = 19;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $data = $dt + 8 | 0;
    $6 = HEAP32[$data >> 2] | 0;
    $ntab = $6 + 12 | 0;
    $7 = HEAP32[$ntab >> 2] | 0;
    $cmp18 = ($7 | 0) > 0;
    if ($cmp18) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    $memoryf = $dt + 12 | 0;
    $8 = HEAP32[$memoryf >> 2] | 0;
    $_htab = $6 + 8 | 0;
    $9 = HEAP32[$_htab >> 2] | 0;
    $10 = $9;
    $call21 = FUNCTION_TABLE_iiiii[$8 & 1023]($dt, $10, 0, $1) | 0;
    label = 12;
    break;
   case 12:
    $memoryf23 = $dt + 12 | 0;
    $11 = HEAP32[$memoryf23 >> 2] | 0;
    $12 = HEAP32[$data >> 2] | 0;
    $13 = $12;
    $call25 = FUNCTION_TABLE_iiiii[$11 & 1023]($dt, $13, 0, $1) | 0;
    label = 13;
    break;
   case 13:
    $type = $dt + 20 | 0;
    $14 = HEAP32[$type >> 2] | 0;
    $cmp27 = ($14 | 0) == 0;
    if ($cmp27) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    $15 = $dt;
    _free($15);
    label = 17;
    break;
   case 15:
    $cmp32 = ($14 | 0) == 1;
    $or_cond = $cmp11 & $cmp32;
    if ($or_cond) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    $memoryf34 = $dt + 12 | 0;
    $16 = HEAP32[$memoryf34 >> 2] | 0;
    $17 = $dt;
    $call35 = FUNCTION_TABLE_iiiii[$16 & 1023]($dt, $17, 0, $1) | 0;
    label = 17;
    break;
   case 17:
    $18 = HEAP32[$eventf >> 2] | 0;
    $tobool39 = ($18 | 0) == 0;
    if ($tobool39) {
      $retval_0 = 0;
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    $call42 = FUNCTION_TABLE_iiiii[$18 & 1023]($dt, 6, 0, $1) | 0;
    $retval_0 = 0;
    label = 19;
    break;
   case 19:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtdisc($dt, $disc, $type) {
  $dt = $dt | 0;
  $disc = $disc | 0;
  $type = $type | 0;
  var $disc1 = 0, $0 = 0, $tobool = 0, $memoryf = 0, $1 = 0, $memoryf3 = 0, $tobool4 = 0, $dtmemory_ = 0, $tobool8 = 0, $meth = 0, $2 = 0, $searchf11 = 0, $3 = 0, $data = 0, $4 = 0, $type12 = 0, $5 = 0, $and = 0, $tobool13 = 0, $call = 0, $eventf = 0, $6 = 0, $tobool14 = 0, $7 = 0, $call16 = 0, $cmp = 0, $memoryf20 = 0, $8 = 0, $memoryf21 = 0, $tobool22 = 0, $dtmemory_51 = 0, $9 = 0, $type27 = 0, $10 = 0, $and28 = 0, $tobool29 = 0, $and33 = 0, $tobool34 = 0, $and36 = 0, $tobool37 = 0, $and43 = 0, $tobool44 = 0, $11 = 0, $12 = 0, $and54 = 0, $tobool55 = 0, $call58 = 0, $13 = 0, $type60 = 0, $14 = 0, $and61 = 0, $15 = 0, $here = 0, $16 = 0, $size = 0, $17 = 0, $type65 = 0, $18 = 0, $and66 = 0, $tobool67 = 0, $tobool7452 = 0, $and76 = 0, $tobool77 = 0, $link = 0, $size86 = 0, $key = 0, $hashf = 0, $_htab = 0, $19 = 0, $ntab = 0, $20 = 0, $add_ptr = 0, $cmp7155 = 0, $s_056 = 0, $incdec_ptr = 0, $cmp71 = 0, $r_053 = 0, $right = 0, $21 = 0, $22 = 0, $cmp79 = 0, $obj = 0, $23 = 0, $24 = 0, $25 = 0, $idx_neg = 0, $add_ptr83 = 0, $cond85 = 0, $26 = 0, $cmp87 = 0, $27 = 0, $add_ptr89 = 0, $28 = 0, $29 = 0, $cond94 = 0, $30 = 0, $tobool95 = 0, $call98 = 0, $31 = 0, $call101 = 0, $cond103 = 0, $_hash = 0, $32 = 0, $call105 = 0, $tobool74 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $disc1 = $dt + 4 | 0;
    $0 = HEAP32[$disc1 >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    HEAP32[$disc1 >> 2] = $disc;
    $memoryf = $disc + 28 | 0;
    $1 = HEAP32[$memoryf >> 2] | 0;
    $memoryf3 = $dt + 12 | 0;
    $tobool4 = ($1 | 0) == 0;
    $dtmemory_ = $tobool4 ? 238 : $1;
    HEAP32[$memoryf3 >> 2] = $dtmemory_;
    $retval_0 = $disc;
    label = 31;
    break;
   case 4:
    $tobool8 = ($disc | 0) == 0;
    if ($tobool8) {
      $retval_0 = $0;
      label = 31;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $meth = $dt + 16 | 0;
    $2 = HEAP32[$meth >> 2] | 0;
    $searchf11 = $2 | 0;
    $3 = HEAP32[$searchf11 >> 2] | 0;
    $data = $dt + 8 | 0;
    $4 = HEAP32[$data >> 2] | 0;
    $type12 = $4 | 0;
    $5 = HEAP32[$type12 >> 2] | 0;
    $and = $5 & 4096;
    $tobool13 = ($and | 0) == 0;
    if ($tobool13) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $call = _dtrestore($dt, 0) | 0;
    label = 7;
    break;
   case 7:
    $eventf = $0 + 32 | 0;
    $6 = HEAP32[$eventf >> 2] | 0;
    $tobool14 = ($6 | 0) == 0;
    if ($tobool14) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $7 = $disc;
    $call16 = FUNCTION_TABLE_iiiii[$6 & 1023]($dt, 3, $7, $0) | 0;
    $cmp = ($call16 | 0) < 0;
    if ($cmp) {
      $retval_0 = 0;
      label = 31;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    HEAP32[$disc1 >> 2] = $disc;
    $memoryf20 = $disc + 28 | 0;
    $8 = HEAP32[$memoryf20 >> 2] | 0;
    $memoryf21 = $dt + 12 | 0;
    $tobool22 = ($8 | 0) == 0;
    $dtmemory_51 = $tobool22 ? 238 : $8;
    HEAP32[$memoryf21 >> 2] = $dtmemory_51;
    $9 = HEAP32[$data >> 2] | 0;
    $type27 = $9 | 0;
    $10 = HEAP32[$type27 >> 2] | 0;
    $and28 = $10 & 112;
    $tobool29 = ($and28 | 0) == 0;
    if ($tobool29) {
      label = 10;
      break;
    } else {
      $retval_0 = $0;
      label = 31;
      break;
    }
   case 10:
    $and33 = $10 & 2;
    $tobool34 = ($and33 | 0) == 0;
    if ($tobool34) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $and36 = $type & 2;
    $tobool37 = ($and36 | 0) == 0;
    if ($tobool37) {
      label = 15;
      break;
    } else {
      $retval_0 = $0;
      label = 31;
      break;
    }
   case 12:
    $and43 = $10 & 3;
    $tobool44 = ($and43 | 0) == 0;
    if ($tobool44) {
      label = 14;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $11 = $type & 3;
    $12 = ($11 | 0) == 3;
    if ($12) {
      $retval_0 = $0;
      label = 31;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    $and54 = $type & 1;
    $tobool55 = ($and54 | 0) == 0;
    if ($tobool55) {
      label = 15;
      break;
    } else {
      $retval_0 = $0;
      label = 31;
      break;
    }
   case 15:
    $call58 = _dtflatten($dt) | 0;
    $13 = HEAP32[$data >> 2] | 0;
    $type60 = $13 | 0;
    $14 = HEAP32[$type60 >> 2] | 0;
    $and61 = $14 & -4097;
    HEAP32[$type60 >> 2] = $and61;
    $15 = HEAP32[$data >> 2] | 0;
    $here = $15 + 4 | 0;
    HEAP32[$here >> 2] = 0;
    $16 = HEAP32[$data >> 2] | 0;
    $size = $16 + 16 | 0;
    HEAP32[$size >> 2] = 0;
    $17 = HEAP32[$data >> 2] | 0;
    $type65 = $17 | 0;
    $18 = HEAP32[$type65 >> 2] | 0;
    $and66 = $18 & 3;
    $tobool67 = ($and66 | 0) == 0;
    if ($tobool67) {
      label = 16;
      break;
    } else {
      label = 18;
      break;
    }
   case 16:
    $tobool7452 = ($call58 | 0) == 0;
    if ($tobool7452) {
      $retval_0 = $0;
      label = 31;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    $and76 = $type & 2;
    $tobool77 = ($and76 | 0) == 0;
    $link = $disc + 8 | 0;
    $size86 = $disc + 4 | 0;
    $key = $disc | 0;
    $hashf = $disc + 24 | 0;
    $r_053 = $call58;
    label = 20;
    break;
   case 18:
    $_htab = $17 + 8 | 0;
    $19 = HEAP32[$_htab >> 2] | 0;
    $ntab = $17 + 12 | 0;
    $20 = HEAP32[$ntab >> 2] | 0;
    $add_ptr = $19 + ($20 << 2) | 0;
    $cmp7155 = ($20 | 0) > 0;
    if ($cmp7155) {
      $s_056 = $19;
      label = 19;
      break;
    } else {
      label = 16;
      break;
    }
   case 19:
    $incdec_ptr = $s_056 + 4 | 0;
    HEAP32[$s_056 >> 2] = 0;
    $cmp71 = $incdec_ptr >>> 0 < $add_ptr >>> 0;
    if ($cmp71) {
      $s_056 = $incdec_ptr;
      label = 19;
      break;
    } else {
      label = 16;
      break;
    }
   case 20:
    $right = $r_053 | 0;
    $21 = HEAP32[$right >> 2] | 0;
    if ($tobool77) {
      label = 21;
      break;
    } else {
      label = 30;
      break;
    }
   case 21:
    $22 = HEAP32[$link >> 2] | 0;
    $cmp79 = ($22 | 0) < 0;
    if ($cmp79) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    $obj = $r_053 + 8 | 0;
    $23 = $obj;
    $24 = HEAP32[$23 >> 2] | 0;
    $cond85 = $24;
    label = 24;
    break;
   case 23:
    $25 = $r_053;
    $idx_neg = -$22 | 0;
    $add_ptr83 = $25 + $idx_neg | 0;
    $cond85 = $add_ptr83;
    label = 24;
    break;
   case 24:
    $26 = HEAP32[$size86 >> 2] | 0;
    $cmp87 = ($26 | 0) < 0;
    $27 = HEAP32[$key >> 2] | 0;
    $add_ptr89 = $cond85 + $27 | 0;
    if ($cmp87) {
      label = 25;
      break;
    } else {
      $cond94 = $add_ptr89;
      label = 26;
      break;
    }
   case 25:
    $28 = $add_ptr89;
    $29 = HEAP32[$28 >> 2] | 0;
    $cond94 = $29;
    label = 26;
    break;
   case 26:
    $30 = HEAP32[$hashf >> 2] | 0;
    $tobool95 = ($30 | 0) == 0;
    if ($tobool95) {
      label = 28;
      break;
    } else {
      label = 27;
      break;
    }
   case 27:
    $call98 = FUNCTION_TABLE_iiii[$30 & 1023]($dt, $cond94, $disc) | 0;
    $cond103 = $call98;
    label = 29;
    break;
   case 28:
    $31 = HEAP32[$size86 >> 2] | 0;
    $call101 = _dtstrhash(0, $cond94, $31) | 0;
    $cond103 = $call101;
    label = 29;
    break;
   case 29:
    $_hash = $r_053 + 4 | 0;
    HEAP32[$_hash >> 2] = $cond103;
    label = 30;
    break;
   case 30:
    $32 = $r_053;
    $call105 = FUNCTION_TABLE_iiii[$3 & 1023]($dt, $32, 32) | 0;
    $tobool74 = ($21 | 0) == 0;
    if ($tobool74) {
      $retval_0 = $0;
      label = 31;
      break;
    } else {
      $r_053 = $21;
      label = 20;
      break;
    }
   case 31:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtmemory($dt, $addr, $size, $disc) {
  $dt = $dt | 0;
  $addr = $addr | 0;
  $size = $size | 0;
  $disc = $disc | 0;
  var $tobool = 0, $cmp3 = 0, $call = 0, $call4 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tobool = ($addr | 0) == 0;
    $cmp3 = ($size | 0) == 0;
    if ($tobool) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    if ($cmp3) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    _free($addr);
    $retval_0 = 0;
    label = 8;
    break;
   case 5:
    $call = _realloc($addr, $size) | 0;
    $retval_0 = $call;
    label = 8;
    break;
   case 6:
    if ($cmp3) {
      $retval_0 = 0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $call4 = _malloc($size) | 0;
    $retval_0 = $call4;
    label = 8;
    break;
   case 8:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtlist($dt, $obj, $type) {
  $dt = $dt | 0;
  $obj = $obj | 0;
  $type = $type | 0;
  var $data = 0, $0 = 0, $type1 = 0, $1 = 0, $and = 0, $tobool = 0, $2 = 0, $call = 0, $disc2 = 0, $3 = 0, $key3 = 0, $4 = 0, $size = 0, $5 = 0, $link = 0, $6 = 0, $comparf = 0, $7 = 0, $type4 = 0, $8 = 0, $and5 = 0, $tobool6 = 0, $and7 = 0, $tobool8 = 0, $9 = 0, $hh = 0, $_head = 0, $10 = 0, $tobool11 = 0, $and13 = 0, $tobool14 = 0, $11 = 0, $here199 = 0, $hl = 0, $_left = 0, $12 = 0, $13 = 0, $here = 0, $tobool18 = 0, $r_0201 = 0, $cmp = 0, $obj21 = 0, $14 = 0, $15 = 0, $16 = 0, $idx_neg = 0, $add_ptr = 0, $and28 = 0, $tobool29 = 0, $17 = 0, $type32 = 0, $18 = 0, $and33 = 0, $tobool34 = 0, $hh36 = 0, $_head37 = 0, $19 = 0, $tobool38 = 0, $and42 = 0, $tobool43 = 0, $freef = 0, $20 = 0, $tobool45 = 0, $21 = 0, $cmp48 = 0, $22 = 0, $hh51 = 0, $_head52 = 0, $23 = 0, $tobool53205 = 0, $memoryf = 0, $cmp58 = 0, $idx_neg62 = 0, $r_2206 = 0, $right = 0, $24 = 0, $25 = 0, $tobool55 = 0, $obj60 = 0, $26 = 0, $27 = 0, $28 = 0, $add_ptr63 = 0, $cond65 = 0, $29 = 0, $cmp68 = 0, $tobool53 = 0, $30 = 0, $31 = 0, $call70 = 0, $32 = 0, $here74 = 0, $33 = 0, $34 = 0, $35 = 0, $size79 = 0, $and82 = 0, $tobool83 = 0, $makef = 0, $36 = 0, $tobool85 = 0, $and86 = 0, $tobool87 = 0, $call90 = 0, $tobool91 = 0, $obj_addr_0 = 0, $cmp94 = 0, $add_ptr96 = 0, $memoryf98 = 0, $37 = 0, $call99 = 0, $tobool100 = 0, $obj102 = 0, $38 = 0, $39 = 0, $tobool105 = 0, $freef107 = 0, $40 = 0, $tobool108 = 0, $and110 = 0, $tobool111 = 0, $r_3_in = 0, $r_3 = 0, $41 = 0, $type118 = 0, $42 = 0, $and119 = 0, $tobool120 = 0, $and122 = 0, $tobool123 = 0, $and129 = 0, $tobool130 = 0, $and132 = 0, $tobool133 = 0, $here136 = 0, $43 = 0, $tobool137 = 0, $right139 = 0, $44 = 0, $tobool140 = 0, $right144 = 0, $45 = 0, $r_3_c196 = 0, $hl148 = 0, $_left149 = 0, $hh159 = 0, $_head160 = 0, $46 = 0, $cmp161 = 0, $hl164 = 0, $_left165 = 0, $47 = 0, $hl166 = 0, $_left167 = 0, $right170 = 0, $right171 = 0, $48 = 0, $r_3_c195 = 0, $and179 = 0, $tobool180 = 0, $49 = 0, $hh183 = 0, $_head184 = 0, $50 = 0, $right185 = 0, $tobool186 = 0, $hl188 = 0, $_left189 = 0, $51 = 0, $hl190 = 0, $_left191 = 0, $52 = 0, $r_3_c194 = 0, $hl195 = 0, $_left196 = 0, $53 = 0, $54 = 0, $55 = 0, $hh203 = 0, $_head204 = 0, $56 = 0, $tobool205 = 0, $hl207 = 0, $_left208 = 0, $57 = 0, $right209 = 0, $58 = 0, $hl212 = 0, $_left213 = 0, $59 = 0, $r_3_c192 = 0, $60 = 0, $r_3_c = 0, $hl220 = 0, $_left221 = 0, $right223 = 0, $61 = 0, $size228 = 0, $62 = 0, $cmp229 = 0, $add = 0, $63 = 0, $here235 = 0, $cmp236 = 0, $obj238 = 0, $64 = 0, $65 = 0, $idx_neg240 = 0, $add_ptr241 = 0, $and245 = 0, $tobool246 = 0, $66 = 0, $here249 = 0, $67 = 0, $tobool250 = 0, $cmp252 = 0, $obj254 = 0, $68 = 0, $69 = 0, $70 = 0, $idx_neg256 = 0, $add_ptr257 = 0, $cond259 = 0, $cmp260 = 0, $cmp266 = 0, $add_ptr268 = 0, $71 = 0, $72 = 0, $cond274 = 0, $73 = 0, $hh276 = 0, $_head277 = 0, $cmp281 = 0, $cmp289 = 0, $tobool296 = 0, $cmp300 = 0, $idx_neg285 = 0, $r_4_in = 0, $r_4 = 0, $tobool279 = 0, $obj283 = 0, $74 = 0, $75 = 0, $76 = 0, $add_ptr286 = 0, $cond288 = 0, $add_ptr291 = 0, $77 = 0, $78 = 0, $cond295 = 0, $call298 = 0, $call302 = 0, $call304 = 0, $cond308 = 0, $cmp309 = 0, $right313 = 0, $r_5 = 0, $tobool316 = 0, $79 = 0, $or = 0, $and320 = 0, $tobool321 = 0, $r_6 = 0, $right323 = 0, $80 = 0, $tobool324 = 0, $hl326 = 0, $_left327 = 0, $81 = 0, $82 = 0, $_c191 = 0, $83 = 0, $hh333 = 0, $_head334 = 0, $84 = 0, $cmp335 = 0, $85 = 0, $86 = 0, $_c189 = 0, $87 = 0, $hh342 = 0, $_head343 = 0, $88 = 0, $tobool344 = 0, $hl346 = 0, $_left347 = 0, $89 = 0, $90 = 0, $_c190 = 0, $hl356 = 0, $_left357 = 0, $91 = 0, $right358 = 0, $hl359 = 0, $_left360 = 0, $92 = 0, $cmp361 = 0, $93 = 0, $94 = 0, $_c = 0, $95 = 0, $here370 = 0, $96 = 0, $cmp371 = 0, $97 = 0, $cond376 = 0, $98 = 0, $here378 = 0, $99 = 0, $size380 = 0, $100 = 0, $sub = 0, $cmp381 = 0, $obj383 = 0, $101 = 0, $102 = 0, $103 = 0, $idx_neg385 = 0, $add_ptr386 = 0, $cond388 = 0, $freef389 = 0, $104 = 0, $tobool390 = 0, $and392 = 0, $tobool393 = 0, $105 = 0, $cmp398 = 0, $memoryf400 = 0, $106 = 0, $107 = 0, $call401 = 0, $and404 = 0, $tobool405 = 0, $right407 = 0, $108 = 0, $and409 = 0, $tobool410 = 0, $109 = 0, $hh413 = 0, $_head414 = 0, $110 = 0, $cmp415 = 0, $111 = 0, $here426203 = 0, $hl418 = 0, $_left419 = 0, $112 = 0, $r_7 = 0, $113 = 0, $here426 = 0, $tobool427 = 0, $cmp429 = 0, $obj431 = 0, $114 = 0, $115 = 0, $116 = 0, $idx_neg433 = 0, $add_ptr434 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $data = $dt + 8 | 0;
    $0 = HEAP32[$data >> 2] | 0;
    $type1 = $0 | 0;
    $1 = HEAP32[$type1 >> 2] | 0;
    $and = $1 & 4096;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $2 = $dt;
    $call = _dtrestore($2, 0) | 0;
    label = 4;
    break;
   case 4:
    $disc2 = $dt + 4 | 0;
    $3 = HEAP32[$disc2 >> 2] | 0;
    $key3 = $3 | 0;
    $4 = HEAP32[$key3 >> 2] | 0;
    $size = $3 + 4 | 0;
    $5 = HEAP32[$size >> 2] | 0;
    $link = $3 + 8 | 0;
    $6 = HEAP32[$link >> 2] | 0;
    $comparf = $3 + 20 | 0;
    $7 = HEAP32[$comparf >> 2] | 0;
    $type4 = $dt + 20 | 0;
    $8 = HEAP32[$type4 >> 2] | 0;
    $and5 = $8 & -32769;
    HEAP32[$type4 >> 2] = $and5;
    $tobool6 = ($obj | 0) == 0;
    if ($tobool6) {
      label = 5;
      break;
    } else {
      label = 30;
      break;
    }
   case 5:
    $and7 = $type & 384;
    $tobool8 = ($and7 | 0) == 0;
    if ($tobool8) {
      label = 13;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $9 = HEAP32[$data >> 2] | 0;
    $hh = $9 + 8 | 0;
    $_head = $hh;
    $10 = HEAP32[$_head >> 2] | 0;
    $tobool11 = ($10 | 0) == 0;
    if ($tobool11) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $and13 = $type & 256;
    $tobool14 = ($and13 | 0) == 0;
    if ($tobool14) {
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 8:
    $11 = HEAP32[$data >> 2] | 0;
    $here199 = $11 + 4 | 0;
    HEAP32[$here199 >> 2] = $10;
    $r_0201 = $10;
    label = 10;
    break;
   case 9:
    $hl = $10 + 4 | 0;
    $_left = $hl;
    $12 = HEAP32[$_left >> 2] | 0;
    $13 = HEAP32[$data >> 2] | 0;
    $here = $13 + 4 | 0;
    HEAP32[$here >> 2] = $12;
    $tobool18 = ($12 | 0) == 0;
    if ($tobool18) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      $r_0201 = $12;
      label = 10;
      break;
    }
   case 10:
    $cmp = ($6 | 0) < 0;
    if ($cmp) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    $obj21 = $r_0201 + 8 | 0;
    $14 = $obj21;
    $15 = HEAP32[$14 >> 2] | 0;
    $retval_0 = $15;
    label = 117;
    break;
   case 12:
    $16 = $r_0201;
    $idx_neg = -$6 | 0;
    $add_ptr = $16 + $idx_neg | 0;
    $retval_0 = $add_ptr;
    label = 117;
    break;
   case 13:
    $and28 = $type & 4098;
    $tobool29 = ($and28 | 0) == 0;
    if ($tobool29) {
      label = 16;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $17 = HEAP32[$data >> 2] | 0;
    $type32 = $17 | 0;
    $18 = HEAP32[$type32 >> 2] | 0;
    $and33 = $18 & 144;
    $tobool34 = ($and33 | 0) == 0;
    if ($tobool34) {
      label = 15;
      break;
    } else {
      $retval_0 = 0;
      label = 117;
      break;
    }
   case 15:
    $hh36 = $17 + 8 | 0;
    $_head37 = $hh36;
    $19 = HEAP32[$_head37 >> 2] | 0;
    $tobool38 = ($19 | 0) == 0;
    if ($tobool38) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      $r_6 = $19;
      label = 90;
      break;
    }
   case 16:
    $and42 = $type & 64;
    $tobool43 = ($and42 | 0) == 0;
    if ($tobool43) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    $freef = $3 + 16 | 0;
    $20 = HEAP32[$freef >> 2] | 0;
    $tobool45 = ($20 | 0) == 0;
    if ($tobool45) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    $21 = HEAP32[$link >> 2] | 0;
    $cmp48 = ($21 | 0) < 0;
    if ($cmp48) {
      label = 19;
      break;
    } else {
      label = 29;
      break;
    }
   case 19:
    $22 = HEAP32[$data >> 2] | 0;
    $hh51 = $22 + 8 | 0;
    $_head52 = $hh51;
    $23 = HEAP32[$_head52 >> 2] | 0;
    $tobool53205 = ($23 | 0) == 0;
    if ($tobool53205) {
      label = 29;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    $memoryf = $dt + 12 | 0;
    $cmp58 = ($6 | 0) < 0;
    $idx_neg62 = -$6 | 0;
    $r_2206 = $23;
    label = 21;
    break;
   case 21:
    $right = $r_2206 | 0;
    $24 = HEAP32[$right >> 2] | 0;
    $25 = HEAP32[$freef >> 2] | 0;
    $tobool55 = ($25 | 0) == 0;
    if ($tobool55) {
      label = 26;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    if ($cmp58) {
      label = 23;
      break;
    } else {
      label = 24;
      break;
    }
   case 23:
    $obj60 = $r_2206 + 8 | 0;
    $26 = $obj60;
    $27 = HEAP32[$26 >> 2] | 0;
    $cond65 = $27;
    label = 25;
    break;
   case 24:
    $28 = $r_2206;
    $add_ptr63 = $28 + $idx_neg62 | 0;
    $cond65 = $add_ptr63;
    label = 25;
    break;
   case 25:
    FUNCTION_TABLE_viii[$25 & 1023]($dt, $cond65, $3);
    label = 26;
    break;
   case 26:
    $29 = HEAP32[$link >> 2] | 0;
    $cmp68 = ($29 | 0) < 0;
    if ($cmp68) {
      label = 28;
      break;
    } else {
      label = 27;
      break;
    }
   case 27:
    $tobool53 = ($24 | 0) == 0;
    if ($tobool53) {
      label = 29;
      break;
    } else {
      $r_2206 = $24;
      label = 21;
      break;
    }
   case 28:
    $30 = HEAP32[$memoryf >> 2] | 0;
    $31 = $r_2206;
    $call70 = FUNCTION_TABLE_iiiii[$30 & 1023]($dt, $31, 0, $3) | 0;
    label = 27;
    break;
   case 29:
    $32 = HEAP32[$data >> 2] | 0;
    $here74 = $32 + 4 | 0;
    HEAP32[$here74 >> 2] = 0;
    $33 = HEAP32[$data >> 2] | 0;
    $34 = $33 + 8 | 0;
    HEAP32[$34 >> 2] = 0;
    $35 = HEAP32[$data >> 2] | 0;
    $size79 = $35 + 16 | 0;
    HEAP32[$size79 >> 2] = 0;
    $retval_0 = 0;
    label = 117;
    break;
   case 30:
    $and82 = $type & 2049;
    $tobool83 = ($and82 | 0) == 0;
    if ($tobool83) {
      label = 66;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    $makef = $3 + 12 | 0;
    $36 = HEAP32[$makef >> 2] | 0;
    $tobool85 = ($36 | 0) == 0;
    if ($tobool85) {
      $obj_addr_0 = $obj;
      label = 34;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    $and86 = $type & 1;
    $tobool87 = ($and86 | 0) == 0;
    if ($tobool87) {
      $obj_addr_0 = $obj;
      label = 34;
      break;
    } else {
      label = 33;
      break;
    }
   case 33:
    $call90 = FUNCTION_TABLE_iiii[$36 & 1023]($dt, $obj, $3) | 0;
    $tobool91 = ($call90 | 0) == 0;
    if ($tobool91) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      $obj_addr_0 = $call90;
      label = 34;
      break;
    }
   case 34:
    $cmp94 = ($6 | 0) > -1;
    if ($cmp94) {
      label = 35;
      break;
    } else {
      label = 36;
      break;
    }
   case 35:
    $add_ptr96 = $obj_addr_0 + $6 | 0;
    $r_3_in = $add_ptr96;
    label = 42;
    break;
   case 36:
    $memoryf98 = $dt + 12 | 0;
    $37 = HEAP32[$memoryf98 >> 2] | 0;
    $call99 = FUNCTION_TABLE_iiiii[$37 & 1023]($dt, 0, 12, $3) | 0;
    $tobool100 = ($call99 | 0) == 0;
    if ($tobool100) {
      label = 38;
      break;
    } else {
      label = 37;
      break;
    }
   case 37:
    $obj102 = $call99 + 8 | 0;
    $38 = $obj102;
    HEAP32[$38 >> 2] = $obj_addr_0;
    $r_3_in = $call99;
    label = 42;
    break;
   case 38:
    $39 = HEAP32[$makef >> 2] | 0;
    $tobool105 = ($39 | 0) == 0;
    if ($tobool105) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 39;
      break;
    }
   case 39:
    $freef107 = $3 + 16 | 0;
    $40 = HEAP32[$freef107 >> 2] | 0;
    $tobool108 = ($40 | 0) == 0;
    if ($tobool108) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    $and110 = $type & 1;
    $tobool111 = ($and110 | 0) == 0;
    if ($tobool111) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 41;
      break;
    }
   case 41:
    FUNCTION_TABLE_viii[$40 & 1023]($dt, $obj_addr_0, $3);
    $retval_0 = 0;
    label = 117;
    break;
   case 42:
    $r_3 = $r_3_in;
    $41 = HEAP32[$data >> 2] | 0;
    $type118 = $41 | 0;
    $42 = HEAP32[$type118 >> 2] | 0;
    $and119 = $42 & 128;
    $tobool120 = ($and119 | 0) == 0;
    if ($tobool120) {
      label = 44;
      break;
    } else {
      label = 43;
      break;
    }
   case 43:
    $and122 = $type & 8192;
    $tobool123 = ($and122 | 0) == 0;
    if ($tobool123) {
      label = 53;
      break;
    } else {
      label = 57;
      break;
    }
   case 44:
    $and129 = $42 & 16;
    $tobool130 = ($and129 | 0) == 0;
    if ($tobool130) {
      label = 52;
      break;
    } else {
      label = 45;
      break;
    }
   case 45:
    $and132 = $type & 8192;
    $tobool133 = ($and132 | 0) == 0;
    $here136 = $41 + 4 | 0;
    $43 = HEAP32[$here136 >> 2] | 0;
    $tobool137 = ($43 | 0) != 0;
    if ($tobool133) {
      label = 49;
      break;
    } else {
      label = 46;
      break;
    }
   case 46:
    if ($tobool137) {
      label = 47;
      break;
    } else {
      label = 57;
      break;
    }
   case 47:
    $right139 = $43 | 0;
    $44 = HEAP32[$right139 >> 2] | 0;
    $tobool140 = ($44 | 0) == 0;
    if ($tobool140) {
      label = 57;
      break;
    } else {
      label = 48;
      break;
    }
   case 48:
    $right144 = $r_3_in;
    HEAP32[$right144 >> 2] = $44;
    $45 = $44 + 4 | 0;
    $r_3_c196 = $r_3_in;
    HEAP32[$45 >> 2] = $r_3_c196;
    $hl148 = $r_3_in + 4 | 0;
    $_left149 = $hl148;
    HEAP32[$_left149 >> 2] = $43;
    HEAP32[$right139 >> 2] = $r_3;
    label = 61;
    break;
   case 49:
    if ($tobool137) {
      label = 50;
      break;
    } else {
      label = 53;
      break;
    }
   case 50:
    $hh159 = $41 + 8 | 0;
    $_head160 = $hh159;
    $46 = HEAP32[$_head160 >> 2] | 0;
    $cmp161 = ($43 | 0) == ($46 | 0);
    if ($cmp161) {
      label = 53;
      break;
    } else {
      label = 51;
      break;
    }
   case 51:
    $hl164 = $43 + 4 | 0;
    $_left165 = $hl164;
    $47 = HEAP32[$_left165 >> 2] | 0;
    $hl166 = $r_3_in + 4 | 0;
    $_left167 = $hl166;
    HEAP32[$_left167 >> 2] = $47;
    $right170 = $47 | 0;
    HEAP32[$right170 >> 2] = $r_3;
    $right171 = $r_3_in;
    HEAP32[$right171 >> 2] = $43;
    $48 = $hl164 | 0;
    $r_3_c195 = $r_3_in;
    HEAP32[$48 >> 2] = $r_3_c195;
    label = 61;
    break;
   case 52:
    $and179 = $42 & 32;
    $tobool180 = ($and179 | 0) == 0;
    if ($tobool180) {
      label = 57;
      break;
    } else {
      label = 53;
      break;
    }
   case 53:
    $49 = HEAP32[$data >> 2] | 0;
    $hh183 = $49 + 8 | 0;
    $_head184 = $hh183;
    $50 = HEAP32[$_head184 >> 2] | 0;
    $right185 = $r_3_in;
    HEAP32[$right185 >> 2] = $50;
    $tobool186 = ($50 | 0) == 0;
    if ($tobool186) {
      label = 55;
      break;
    } else {
      label = 54;
      break;
    }
   case 54:
    $hl188 = $50 + 4 | 0;
    $_left189 = $hl188;
    $51 = HEAP32[$_left189 >> 2] | 0;
    $hl190 = $r_3_in + 4 | 0;
    $_left191 = $hl190;
    HEAP32[$_left191 >> 2] = $51;
    $52 = $hl188 | 0;
    $r_3_c194 = $r_3_in;
    HEAP32[$52 >> 2] = $r_3_c194;
    label = 56;
    break;
   case 55:
    $hl195 = $r_3_in + 4 | 0;
    $_left196 = $hl195;
    HEAP32[$_left196 >> 2] = $r_3;
    label = 56;
    break;
   case 56:
    $53 = HEAP32[$data >> 2] | 0;
    $54 = $53 + 8 | 0;
    HEAP32[$54 >> 2] = $right185;
    label = 61;
    break;
   case 57:
    $55 = HEAP32[$data >> 2] | 0;
    $hh203 = $55 + 8 | 0;
    $_head204 = $hh203;
    $56 = HEAP32[$_head204 >> 2] | 0;
    $tobool205 = ($56 | 0) == 0;
    if ($tobool205) {
      label = 59;
      break;
    } else {
      label = 58;
      break;
    }
   case 58:
    $hl207 = $56 + 4 | 0;
    $_left208 = $hl207;
    $57 = HEAP32[$_left208 >> 2] | 0;
    $right209 = $57 | 0;
    HEAP32[$right209 >> 2] = $r_3;
    $58 = HEAP32[$_left208 >> 2] | 0;
    $hl212 = $r_3_in + 4 | 0;
    $_left213 = $hl212;
    HEAP32[$_left213 >> 2] = $58;
    $59 = $hl207 | 0;
    $r_3_c192 = $r_3_in;
    HEAP32[$59 >> 2] = $r_3_c192;
    label = 60;
    break;
   case 59:
    $60 = $hh203 | 0;
    $r_3_c = $r_3_in;
    HEAP32[$60 >> 2] = $r_3_c;
    $hl220 = $r_3_in + 4 | 0;
    $_left221 = $hl220;
    HEAP32[$_left221 >> 2] = $r_3;
    label = 60;
    break;
   case 60:
    $right223 = $r_3_in;
    HEAP32[$right223 >> 2] = 0;
    label = 61;
    break;
   case 61:
    $61 = HEAP32[$data >> 2] | 0;
    $size228 = $61 + 16 | 0;
    $62 = HEAP32[$size228 >> 2] | 0;
    $cmp229 = ($62 | 0) > -1;
    if ($cmp229) {
      label = 62;
      break;
    } else {
      label = 63;
      break;
    }
   case 62:
    $add = $62 + 1 | 0;
    HEAP32[$size228 >> 2] = $add;
    label = 63;
    break;
   case 63:
    $63 = HEAP32[$data >> 2] | 0;
    $here235 = $63 + 4 | 0;
    HEAP32[$here235 >> 2] = $r_3;
    $cmp236 = ($6 | 0) < 0;
    if ($cmp236) {
      label = 64;
      break;
    } else {
      label = 65;
      break;
    }
   case 64:
    $obj238 = $r_3_in + 8 | 0;
    $64 = $obj238;
    $65 = HEAP32[$64 >> 2] | 0;
    $retval_0 = $65;
    label = 117;
    break;
   case 65:
    $idx_neg240 = -$6 | 0;
    $add_ptr241 = $r_3_in + $idx_neg240 | 0;
    $retval_0 = $add_ptr241;
    label = 117;
    break;
   case 66:
    $and245 = $type & 512;
    $tobool246 = ($and245 | 0) != 0;
    if ($tobool246) {
      $cond274 = $obj;
      label = 75;
      break;
    } else {
      label = 67;
      break;
    }
   case 67:
    $66 = HEAP32[$data >> 2] | 0;
    $here249 = $66 + 4 | 0;
    $67 = HEAP32[$here249 >> 2] | 0;
    $tobool250 = ($67 | 0) == 0;
    if ($tobool250) {
      label = 73;
      break;
    } else {
      label = 68;
      break;
    }
   case 68:
    $cmp252 = ($6 | 0) < 0;
    if ($cmp252) {
      label = 69;
      break;
    } else {
      label = 70;
      break;
    }
   case 69:
    $obj254 = $67 + 8 | 0;
    $68 = $obj254;
    $69 = HEAP32[$68 >> 2] | 0;
    $cond259 = $69;
    label = 71;
    break;
   case 70:
    $70 = $67;
    $idx_neg256 = -$6 | 0;
    $add_ptr257 = $70 + $idx_neg256 | 0;
    $cond259 = $add_ptr257;
    label = 71;
    break;
   case 71:
    $cmp260 = ($cond259 | 0) == ($obj | 0);
    if ($cmp260) {
      $r_5 = $67;
      label = 88;
      break;
    } else {
      label = 72;
      break;
    }
   case 72:
    if ($tobool246) {
      $cond274 = $obj;
      label = 75;
      break;
    } else {
      label = 73;
      break;
    }
   case 73:
    $cmp266 = ($5 | 0) < 0;
    $add_ptr268 = $obj + $4 | 0;
    if ($cmp266) {
      label = 74;
      break;
    } else {
      $cond274 = $add_ptr268;
      label = 75;
      break;
    }
   case 74:
    $71 = $add_ptr268;
    $72 = HEAP32[$71 >> 2] | 0;
    $cond274 = $72;
    label = 75;
    break;
   case 75:
    $73 = HEAP32[$data >> 2] | 0;
    $hh276 = $73 + 8 | 0;
    $_head277 = $hh276;
    $cmp281 = ($6 | 0) < 0;
    $cmp289 = ($5 | 0) < 0;
    $tobool296 = ($7 | 0) == 0;
    $cmp300 = ($5 | 0) < 1;
    $idx_neg285 = -$6 | 0;
    $r_4_in = $_head277;
    label = 76;
    break;
   case 76:
    $r_4 = HEAP32[$r_4_in >> 2] | 0;
    $tobool279 = ($r_4 | 0) == 0;
    if ($tobool279) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 77;
      break;
    }
   case 77:
    if ($cmp281) {
      label = 78;
      break;
    } else {
      label = 79;
      break;
    }
   case 78:
    $obj283 = $r_4 + 8 | 0;
    $74 = $obj283;
    $75 = HEAP32[$74 >> 2] | 0;
    $cond288 = $75;
    label = 80;
    break;
   case 79:
    $76 = $r_4;
    $add_ptr286 = $76 + $idx_neg285 | 0;
    $cond288 = $add_ptr286;
    label = 80;
    break;
   case 80:
    $add_ptr291 = $cond288 + $4 | 0;
    if ($cmp289) {
      label = 81;
      break;
    } else {
      $cond295 = $add_ptr291;
      label = 82;
      break;
    }
   case 81:
    $77 = $add_ptr291;
    $78 = HEAP32[$77 >> 2] | 0;
    $cond295 = $78;
    label = 82;
    break;
   case 82:
    if ($tobool296) {
      label = 84;
      break;
    } else {
      label = 83;
      break;
    }
   case 83:
    $call298 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $cond274, $cond295, $3) | 0;
    $cond308 = $call298;
    label = 87;
    break;
   case 84:
    if ($cmp300) {
      label = 85;
      break;
    } else {
      label = 86;
      break;
    }
   case 85:
    $call302 = _strcmp($cond274 | 0, $cond295 | 0) | 0;
    $cond308 = $call302;
    label = 87;
    break;
   case 86:
    $call304 = _memcmp($cond274 | 0, $cond295 | 0, $5 | 0) | 0;
    $cond308 = $call304;
    label = 87;
    break;
   case 87:
    $cmp309 = ($cond308 | 0) == 0;
    $right313 = $r_4 | 0;
    if ($cmp309) {
      $r_5 = $r_4;
      label = 88;
      break;
    } else {
      $r_4_in = $right313;
      label = 76;
      break;
    }
   case 88:
    $tobool316 = ($r_5 | 0) == 0;
    if ($tobool316) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 89;
      break;
    }
   case 89:
    $79 = HEAP32[$type4 >> 2] | 0;
    $or = $79 | 32768;
    HEAP32[$type4 >> 2] = $or;
    $and320 = $type & 4098;
    $tobool321 = ($and320 | 0) == 0;
    if ($tobool321) {
      label = 107;
      break;
    } else {
      $r_6 = $r_5;
      label = 90;
      break;
    }
   case 90:
    $right323 = $r_6 | 0;
    $80 = HEAP32[$right323 >> 2] | 0;
    $tobool324 = ($80 | 0) == 0;
    if ($tobool324) {
      label = 92;
      break;
    } else {
      label = 91;
      break;
    }
   case 91:
    $hl326 = $r_6 + 4 | 0;
    $_left327 = $hl326;
    $81 = HEAP32[$_left327 >> 2] | 0;
    $82 = $80 + 4 | 0;
    $_c191 = $81;
    HEAP32[$82 >> 2] = $_c191;
    label = 92;
    break;
   case 92:
    $83 = HEAP32[$data >> 2] | 0;
    $hh333 = $83 + 8 | 0;
    $_head334 = $hh333;
    $84 = HEAP32[$_head334 >> 2] | 0;
    $cmp335 = ($r_6 | 0) == ($84 | 0);
    $85 = HEAP32[$right323 >> 2] | 0;
    if ($cmp335) {
      label = 93;
      break;
    } else {
      label = 95;
      break;
    }
   case 93:
    $86 = $hh333 | 0;
    $_c189 = $85 | 0;
    HEAP32[$86 >> 2] = $_c189;
    $87 = HEAP32[$data >> 2] | 0;
    $hh342 = $87 + 8 | 0;
    $_head343 = $hh342;
    $88 = HEAP32[$_head343 >> 2] | 0;
    $tobool344 = ($88 | 0) == 0;
    if ($tobool344) {
      label = 97;
      break;
    } else {
      label = 94;
      break;
    }
   case 94:
    $hl346 = $84 + 4 | 0;
    $_left347 = $hl346;
    $89 = HEAP32[$_left347 >> 2] | 0;
    $90 = $88 + 4 | 0;
    $_c190 = $89;
    HEAP32[$90 >> 2] = $_c190;
    label = 97;
    break;
   case 95:
    $hl356 = $r_6 + 4 | 0;
    $_left357 = $hl356;
    $91 = HEAP32[$_left357 >> 2] | 0;
    $right358 = $91 | 0;
    HEAP32[$right358 >> 2] = $85;
    $hl359 = $84 + 4 | 0;
    $_left360 = $hl359;
    $92 = HEAP32[$_left360 >> 2] | 0;
    $cmp361 = ($r_6 | 0) == ($92 | 0);
    if ($cmp361) {
      label = 96;
      break;
    } else {
      label = 97;
      break;
    }
   case 96:
    $93 = HEAP32[$_left357 >> 2] | 0;
    $94 = $hl359 | 0;
    $_c = $93;
    HEAP32[$94 >> 2] = $_c;
    label = 97;
    break;
   case 97:
    $95 = HEAP32[$data >> 2] | 0;
    $here370 = $95 + 4 | 0;
    $96 = HEAP32[$here370 >> 2] | 0;
    $cmp371 = ($r_6 | 0) == ($96 | 0);
    if ($cmp371) {
      label = 98;
      break;
    } else {
      $cond376 = 0;
      label = 99;
      break;
    }
   case 98:
    $97 = HEAP32[$right323 >> 2] | 0;
    $cond376 = $97;
    label = 99;
    break;
   case 99:
    $98 = HEAP32[$data >> 2] | 0;
    $here378 = $98 + 4 | 0;
    HEAP32[$here378 >> 2] = $cond376;
    $99 = HEAP32[$data >> 2] | 0;
    $size380 = $99 + 16 | 0;
    $100 = HEAP32[$size380 >> 2] | 0;
    $sub = $100 - 1 | 0;
    HEAP32[$size380 >> 2] = $sub;
    $cmp381 = ($6 | 0) < 0;
    if ($cmp381) {
      label = 100;
      break;
    } else {
      label = 101;
      break;
    }
   case 100:
    $obj383 = $r_6 + 8 | 0;
    $101 = $obj383;
    $102 = HEAP32[$101 >> 2] | 0;
    $cond388 = $102;
    label = 102;
    break;
   case 101:
    $103 = $r_6;
    $idx_neg385 = -$6 | 0;
    $add_ptr386 = $103 + $idx_neg385 | 0;
    $cond388 = $add_ptr386;
    label = 102;
    break;
   case 102:
    $freef389 = $3 + 16 | 0;
    $104 = HEAP32[$freef389 >> 2] | 0;
    $tobool390 = ($104 | 0) == 0;
    if ($tobool390) {
      label = 105;
      break;
    } else {
      label = 103;
      break;
    }
   case 103:
    $and392 = $type & 2;
    $tobool393 = ($and392 | 0) == 0;
    if ($tobool393) {
      label = 105;
      break;
    } else {
      label = 104;
      break;
    }
   case 104:
    FUNCTION_TABLE_viii[$104 & 1023]($dt, $cond388, $3);
    label = 105;
    break;
   case 105:
    $105 = HEAP32[$link >> 2] | 0;
    $cmp398 = ($105 | 0) < 0;
    if ($cmp398) {
      label = 106;
      break;
    } else {
      $retval_0 = $cond388;
      label = 117;
      break;
    }
   case 106:
    $memoryf400 = $dt + 12 | 0;
    $106 = HEAP32[$memoryf400 >> 2] | 0;
    $107 = $r_6;
    $call401 = FUNCTION_TABLE_iiiii[$106 & 1023]($dt, $107, 0, $3) | 0;
    $retval_0 = $cond388;
    label = 117;
    break;
   case 107:
    $and404 = $type & 8;
    $tobool405 = ($and404 | 0) == 0;
    if ($tobool405) {
      label = 109;
      break;
    } else {
      label = 108;
      break;
    }
   case 108:
    $right407 = $r_5 | 0;
    $108 = HEAP32[$right407 >> 2] | 0;
    $r_7 = $108;
    label = 113;
    break;
   case 109:
    $and409 = $type & 16;
    $tobool410 = ($and409 | 0) == 0;
    if ($tobool410) {
      $r_7 = $r_5;
      label = 113;
      break;
    } else {
      label = 110;
      break;
    }
   case 110:
    $109 = HEAP32[$data >> 2] | 0;
    $hh413 = $109 + 8 | 0;
    $_head414 = $hh413;
    $110 = HEAP32[$_head414 >> 2] | 0;
    $cmp415 = ($r_5 | 0) == ($110 | 0);
    if ($cmp415) {
      label = 111;
      break;
    } else {
      label = 112;
      break;
    }
   case 111:
    $111 = HEAP32[$data >> 2] | 0;
    $here426203 = $111 + 4 | 0;
    HEAP32[$here426203 >> 2] = 0;
    $retval_0 = 0;
    label = 117;
    break;
   case 112:
    $hl418 = $r_5 + 4 | 0;
    $_left419 = $hl418;
    $112 = HEAP32[$_left419 >> 2] | 0;
    $r_7 = $112;
    label = 113;
    break;
   case 113:
    $113 = HEAP32[$data >> 2] | 0;
    $here426 = $113 + 4 | 0;
    HEAP32[$here426 >> 2] = $r_7;
    $tobool427 = ($r_7 | 0) == 0;
    if ($tobool427) {
      $retval_0 = 0;
      label = 117;
      break;
    } else {
      label = 114;
      break;
    }
   case 114:
    $cmp429 = ($6 | 0) < 0;
    if ($cmp429) {
      label = 115;
      break;
    } else {
      label = 116;
      break;
    }
   case 115:
    $obj431 = $r_7 + 8 | 0;
    $114 = $obj431;
    $115 = HEAP32[$114 >> 2] | 0;
    $retval_0 = $115;
    label = 117;
    break;
   case 116:
    $116 = $r_7;
    $idx_neg433 = -$6 | 0;
    $add_ptr434 = $116 + $idx_neg433 | 0;
    $retval_0 = $add_ptr434;
    label = 117;
    break;
   case 117:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtopen($disc, $meth) {
  $disc = $disc | 0;
  $meth = $meth | 0;
  var $data = 0, $tobool = 0, $tobool1 = 0, $or_cond = 0, $call = 0, $0 = 0, $tobool2 = 0, $searchf = 0, $meth5 = 0, $1 = 0, $disc6 = 0, $2 = 0, $call7 = 0, $type = 0, $eventf = 0, $3 = 0, $tobool8 = 0, $4 = 0, $5 = 0, $call11 = 0, $cmp = 0, $cmp13 = 0, $6 = 0, $tobool15 = 0, $type17 = 0, $7 = 0, $type18 = 0, $8 = 0, $and = 0, $tobool19 = 0, $memoryf = 0, $9 = 0, $tobool23 = 0, $10 = 0, $call27 = 0, $11 = 0, $tobool28 = 0, $searchf31 = 0, $meth32 = 0, $12 = 0, $disc33 = 0, $13 = 0, $call34 = 0, $type35 = 0, $14 = 0, $nview36 = 0, $15 = 0, $walk37 = 0, $16 = 0, $view38 = 0, $17 = 0, $dt_0 = 0, $memoryf42 = 0, $18 = 0, $call43 = 0, $19 = 0, $tobool44 = 0, $dt_1 = 0, $20 = 0, $type47 = 0, $21 = 0, $type48 = 0, $22 = 0, $here = 0, $23 = 0, $_htab = 0, $24 = 0, $loop = 0, $25 = 0, $size = 0, $26 = 0, $ntab = 0, $27 = 0, $minp = 0, $dt_2 = 0, $28 = 0, $data49 = 0, $searchf50 = 0, $29 = 0, $searchf51 = 0, $meth52 = 0, $30 = 0, $tobool54 = 0, $31 = 0, $call57 = 0, $retval_0 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $data = __stackBase__ | 0;
    $tobool = ($disc | 0) == 0;
    $tobool1 = ($meth | 0) == 0;
    $or_cond = $tobool | $tobool1;
    if ($or_cond) {
      $retval_0 = 0;
      label = 17;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $call = _malloc(40) | 0;
    $0 = $call;
    $tobool2 = ($call | 0) == 0;
    if ($tobool2) {
      $retval_0 = 0;
      label = 17;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $searchf = $call;
    HEAP32[$searchf >> 2] = 0;
    $meth5 = $call + 16 | 0;
    $1 = $meth5;
    HEAP32[$1 >> 2] = 0;
    $disc6 = $call + 4 | 0;
    $2 = $disc6;
    HEAP32[$2 >> 2] = 0;
    $call7 = _dtdisc($0, $disc, 0) | 0;
    $type = $call + 20 | 0;
    $eventf = $disc + 32 | 0;
    _memset($type | 0, 0, 20);
    $3 = HEAP32[$eventf >> 2] | 0;
    $tobool8 = ($3 | 0) == 0;
    if ($tobool8) {
      $dt_0 = $0;
      label = 12;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    HEAP32[$data >> 2] = 0;
    $4 = HEAP32[$eventf >> 2] | 0;
    $5 = $data;
    $call11 = FUNCTION_TABLE_iiiii[$4 & 1023]($0, 1, $5, $disc) | 0;
    $cmp = ($call11 | 0) < 0;
    if ($cmp) {
      $dt_1 = $0;
      label = 13;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $cmp13 = ($call11 | 0) > 0;
    if ($cmp13) {
      label = 7;
      break;
    } else {
      $dt_0 = $0;
      label = 12;
      break;
    }
   case 7:
    $6 = HEAP32[$data >> 2] | 0;
    $tobool15 = ($6 | 0) == 0;
    if ($tobool15) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $type17 = $6 | 0;
    $7 = HEAP32[$type17 >> 2] | 0;
    $type18 = $meth + 4 | 0;
    $8 = HEAP32[$type18 >> 2] | 0;
    $and = $8 & $7;
    $tobool19 = ($and | 0) == 0;
    if ($tobool19) {
      $dt_1 = $0;
      label = 13;
      break;
    } else {
      $dt_2 = $0;
      label = 15;
      break;
    }
   case 9:
    $memoryf = $disc + 28 | 0;
    $9 = HEAP32[$memoryf >> 2] | 0;
    $tobool23 = ($9 | 0) == 0;
    if ($tobool23) {
      $dt_1 = $0;
      label = 13;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    _free($call);
    $10 = HEAP32[$memoryf >> 2] | 0;
    $call27 = FUNCTION_TABLE_iiiii[$10 & 1023](0, 0, 40, $disc) | 0;
    $11 = $call27;
    $tobool28 = ($call27 | 0) == 0;
    if ($tobool28) {
      $retval_0 = 0;
      label = 17;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $searchf31 = $call27;
    HEAP32[$searchf31 >> 2] = 0;
    $meth32 = $call27 + 16 | 0;
    $12 = $meth32;
    HEAP32[$12 >> 2] = 0;
    $disc33 = $call27 + 4 | 0;
    $13 = $disc33;
    HEAP32[$13 >> 2] = 0;
    $call34 = _dtdisc($11, $disc, 0) | 0;
    $type35 = $call27 + 20 | 0;
    $14 = $type35;
    HEAP32[$14 >> 2] = 1;
    $nview36 = $call27 + 24 | 0;
    $15 = $nview36;
    HEAP32[$15 >> 2] = 0;
    $walk37 = $call27 + 32 | 0;
    $16 = $walk37;
    HEAP32[$16 >> 2] = 0;
    $view38 = $call27 + 28 | 0;
    $17 = $view38;
    HEAP32[$17 >> 2] = 0;
    $dt_0 = $11;
    label = 12;
    break;
   case 12:
    $memoryf42 = $dt_0 + 12 | 0;
    $18 = HEAP32[$memoryf42 >> 2] | 0;
    $call43 = FUNCTION_TABLE_iiiii[$18 & 1023]($dt_0, 0, 28, $disc) | 0;
    $19 = $call43;
    HEAP32[$data >> 2] = $19;
    $tobool44 = ($call43 | 0) == 0;
    if ($tobool44) {
      $dt_1 = $dt_0;
      label = 13;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    $20 = $dt_1;
    _free($20);
    $retval_0 = 0;
    label = 17;
    break;
   case 14:
    $type47 = $meth + 4 | 0;
    $21 = HEAP32[$type47 >> 2] | 0;
    $type48 = $call43;
    HEAP32[$type48 >> 2] = $21;
    $22 = HEAP32[$data >> 2] | 0;
    $here = $22 + 4 | 0;
    HEAP32[$here >> 2] = 0;
    $23 = HEAP32[$data >> 2] | 0;
    $_htab = $23 + 8 | 0;
    HEAP32[$_htab >> 2] = 0;
    $24 = HEAP32[$data >> 2] | 0;
    $loop = $24 + 20 | 0;
    HEAP32[$loop >> 2] = 0;
    $25 = HEAP32[$data >> 2] | 0;
    $size = $25 + 16 | 0;
    HEAP32[$size >> 2] = 0;
    $26 = HEAP32[$data >> 2] | 0;
    $ntab = $26 + 12 | 0;
    HEAP32[$ntab >> 2] = 0;
    $27 = HEAP32[$data >> 2] | 0;
    $minp = $27 + 24 | 0;
    HEAP32[$minp >> 2] = 0;
    $dt_2 = $dt_0;
    label = 15;
    break;
   case 15:
    $28 = HEAP32[$data >> 2] | 0;
    $data49 = $dt_2 + 8 | 0;
    HEAP32[$data49 >> 2] = $28;
    $searchf50 = $meth | 0;
    $29 = HEAP32[$searchf50 >> 2] | 0;
    $searchf51 = $dt_2 | 0;
    HEAP32[$searchf51 >> 2] = $29;
    $meth52 = $dt_2 + 16 | 0;
    HEAP32[$meth52 >> 2] = $meth;
    $30 = HEAP32[$eventf >> 2] | 0;
    $tobool54 = ($30 | 0) == 0;
    if ($tobool54) {
      $retval_0 = $dt_2;
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $31 = $dt_2;
    $call57 = FUNCTION_TABLE_iiiii[$30 & 1023]($dt_2, 5, $31, $disc) | 0;
    $retval_0 = $dt_2;
    label = 17;
    break;
   case 17:
    STACKTOP = __stackBase__;
    return $retval_0 | 0;
  }
  return 0;
}
function _dtsize($dt) {
  $dt = $dt | 0;
  var $data = 0, $0 = 0, $type = 0, $1 = 0, $and = 0, $tobool = 0, $call = 0, $2 = 0, $size2 = 0, $3 = 0, $cmp = 0, $type4 = 0, $4 = 0, $and5 = 0, $tobool6 = 0, $here = 0, $5 = 0, $call9 = 0, $and14 = 0, $tobool15 = 0, $hh = 0, $_head = 0, $t_010 = 0, $tobool1811 = 0, $t_013 = 0, $size_012 = 0, $add = 0, $right = 0, $t_0 = 0, $tobool18 = 0, $size_0_lcssa = 0, $6 = 0, $size20 = 0, $7 = 0, $size24 = 0, $8 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $data = $dt + 8 | 0;
    $0 = HEAP32[$data >> 2] | 0;
    $type = $0 | 0;
    $1 = HEAP32[$type >> 2] | 0;
    $and = $1 & 4096;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $call = _dtrestore($dt, 0) | 0;
    label = 4;
    break;
   case 4:
    $2 = HEAP32[$data >> 2] | 0;
    $size2 = $2 + 16 | 0;
    $3 = HEAP32[$size2 >> 2] | 0;
    $cmp = ($3 | 0) < 0;
    if ($cmp) {
      label = 5;
      break;
    } else {
      label = 11;
      break;
    }
   case 5:
    $type4 = $2 | 0;
    $4 = HEAP32[$type4 >> 2] | 0;
    $and5 = $4 & 12;
    $tobool6 = ($and5 | 0) == 0;
    if ($tobool6) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $here = $2 + 4 | 0;
    $5 = HEAP32[$here >> 2] | 0;
    $call9 = _treecount($5) | 0;
    HEAP32[$size2 >> 2] = $call9;
    label = 11;
    break;
   case 7:
    $and14 = $4 & 112;
    $tobool15 = ($and14 | 0) == 0;
    if ($tobool15) {
      label = 11;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $hh = $2 + 8 | 0;
    $_head = $hh;
    $t_010 = HEAP32[$_head >> 2] | 0;
    $tobool1811 = ($t_010 | 0) == 0;
    if ($tobool1811) {
      $size_0_lcssa = 0;
      label = 10;
      break;
    } else {
      $size_012 = 0;
      $t_013 = $t_010;
      label = 9;
      break;
    }
   case 9:
    $add = $size_012 + 1 | 0;
    $right = $t_013 | 0;
    $t_0 = HEAP32[$right >> 2] | 0;
    $tobool18 = ($t_0 | 0) == 0;
    if ($tobool18) {
      $size_0_lcssa = $add;
      label = 10;
      break;
    } else {
      $size_012 = $add;
      $t_013 = $t_0;
      label = 9;
      break;
    }
   case 10:
    $6 = HEAP32[$data >> 2] | 0;
    $size20 = $6 + 16 | 0;
    HEAP32[$size20 >> 2] = $size_0_lcssa;
    label = 11;
    break;
   case 11:
    $7 = HEAP32[$data >> 2] | 0;
    $size24 = $7 + 16 | 0;
    $8 = HEAP32[$size24 >> 2] | 0;
    return $8 | 0;
  }
  return 0;
}
function _treecount($e) {
  $e = $e | 0;
  var $tobool = 0, $hl = 0, $_left = 0, $0 = 0, $call = 0, $right = 0, $1 = 0, $call1 = 0, $add = 0, $add2 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tobool = ($e | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $hl = $e + 4 | 0;
    $_left = $hl;
    $0 = HEAP32[$_left >> 2] | 0;
    $call = _treecount($0) | 0;
    $right = $e | 0;
    $1 = HEAP32[$right >> 2] | 0;
    $call1 = _treecount($1) | 0;
    $add = $call + 1 | 0;
    $add2 = $add + $call1 | 0;
    return $add2 | 0;
   case 4:
    return 0;
  }
  return 0;
}
function _dtstrhash($h, $args, $n) {
  $h = $h | 0;
  $args = $args | 0;
  $n = $n | 0;
  var $cmp = 0, $0 = 0, $cmp120 = 0, $1 = 0, $h_addr_022 = 0, $s_021 = 0, $conv = 0, $shl = 0, $add = 0, $arrayidx4 = 0, $2 = 0, $conv5 = 0, $add6 = 0, $mul = 0, $tobool = 0, $cond = 0, $add_ptr = 0, $3 = 0, $cmp1 = 0, $h_addr_0_lcssa = 0, $s_0_lcssa = 0, $sub_ptr_lhs_cast = 0, $sub_ptr_rhs_cast = 0, $sub_ptr_sub = 0, $add_ptr9_sum = 0, $add_ptr10 = 0, $cmp1224 = 0, $h_addr_126 = 0, $s_125 = 0, $4 = 0, $conv16 = 0, $shl17 = 0, $add18 = 0, $arrayidx19 = 0, $5 = 0, $conv20 = 0, $add21 = 0, $mul22 = 0, $add_ptr24 = 0, $cmp12 = 0, $h_addr_1_lcssa = 0, $s_1_lcssa = 0, $cmp26 = 0, $6 = 0, $conv30 = 0, $shl31 = 0, $add32 = 0, $mul33 = 0, $n_addr_0 = 0, $h_addr_2 = 0, $add35 = 0, $mul36 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $cmp = ($n | 0) < 1;
    if ($cmp) {
      label = 3;
      break;
    } else {
      label = 6;
      break;
    }
   case 3:
    $0 = HEAP8[$args] | 0;
    $cmp120 = $0 << 24 >> 24 == 0;
    if ($cmp120) {
      $s_0_lcssa = $args;
      $h_addr_0_lcssa = $h;
      label = 5;
      break;
    } else {
      $s_021 = $args;
      $h_addr_022 = $h;
      $1 = $0;
      label = 4;
      break;
    }
   case 4:
    $conv = $1 & 255;
    $shl = $conv << 8;
    $add = $shl + $h_addr_022 | 0;
    $arrayidx4 = $s_021 + 1 | 0;
    $2 = HEAP8[$arrayidx4] | 0;
    $conv5 = $2 & 255;
    $add6 = $add + $conv5 | 0;
    $mul = Math_imul($add6, 17109811);
    $tobool = $2 << 24 >> 24 != 0;
    $cond = $tobool ? 2 : 1;
    $add_ptr = $s_021 + $cond | 0;
    $3 = HEAP8[$add_ptr] | 0;
    $cmp1 = $3 << 24 >> 24 == 0;
    if ($cmp1) {
      $s_0_lcssa = $add_ptr;
      $h_addr_0_lcssa = $mul;
      label = 5;
      break;
    } else {
      $s_021 = $add_ptr;
      $h_addr_022 = $mul;
      $1 = $3;
      label = 4;
      break;
    }
   case 5:
    $sub_ptr_lhs_cast = $s_0_lcssa;
    $sub_ptr_rhs_cast = $args;
    $sub_ptr_sub = $sub_ptr_lhs_cast - $sub_ptr_rhs_cast | 0;
    $h_addr_2 = $h_addr_0_lcssa;
    $n_addr_0 = $sub_ptr_sub;
    label = 10;
    break;
   case 6:
    $add_ptr9_sum = $n - 1 | 0;
    $add_ptr10 = $args + $add_ptr9_sum | 0;
    $cmp1224 = ($add_ptr9_sum | 0) > 0;
    if ($cmp1224) {
      $s_125 = $args;
      $h_addr_126 = $h;
      label = 7;
      break;
    } else {
      $s_1_lcssa = $args;
      $h_addr_1_lcssa = $h;
      label = 8;
      break;
    }
   case 7:
    $4 = HEAP8[$s_125] | 0;
    $conv16 = $4 & 255;
    $shl17 = $conv16 << 8;
    $add18 = $shl17 + $h_addr_126 | 0;
    $arrayidx19 = $s_125 + 1 | 0;
    $5 = HEAP8[$arrayidx19] | 0;
    $conv20 = $5 & 255;
    $add21 = $add18 + $conv20 | 0;
    $mul22 = Math_imul($add21, 17109811);
    $add_ptr24 = $s_125 + 2 | 0;
    $cmp12 = $add_ptr24 >>> 0 < $add_ptr10 >>> 0;
    if ($cmp12) {
      $s_125 = $add_ptr24;
      $h_addr_126 = $mul22;
      label = 7;
      break;
    } else {
      $s_1_lcssa = $add_ptr24;
      $h_addr_1_lcssa = $mul22;
      label = 8;
      break;
    }
   case 8:
    $cmp26 = $s_1_lcssa >>> 0 > $add_ptr10 >>> 0;
    if ($cmp26) {
      $h_addr_2 = $h_addr_1_lcssa;
      $n_addr_0 = $n;
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $6 = HEAP8[$s_1_lcssa] | 0;
    $conv30 = $6 & 255;
    $shl31 = $conv30 << 8;
    $add32 = $shl31 + $h_addr_1_lcssa | 0;
    $mul33 = Math_imul($add32, 17109811);
    $h_addr_2 = $mul33;
    $n_addr_0 = $n;
    label = 10;
    break;
   case 10:
    $add35 = $h_addr_2 + $n_addr_0 | 0;
    $mul36 = Math_imul($add35, 17109811);
    return $mul36 | 0;
  }
  return 0;
}
function _dttree($dt, $obj, $type) {
  $dt = $dt | 0;
  $obj = $obj | 0;
  $type = $type | 0;
  var $link = 0, $turn = 0, $data = 0, $0 = 0, $type1 = 0, $1 = 0, $and = 0, $tobool = 0, $2 = 0, $call = 0, $disc2 = 0, $3 = 0, $key3 = 0, $4 = 0, $size = 0, $5 = 0, $link4 = 0, $6 = 0, $comparf = 0, $7 = 0, $type5 = 0, $8 = 0, $and6 = 0, $9 = 0, $here = 0, $10 = 0, $tobool8 = 0, $tobool9 = 0, $and10 = 0, $tobool11 = 0, $and13 = 0, $tobool14 = 0, $freef = 0, $11 = 0, $tobool16 = 0, $12 = 0, $cmp19 = 0, $memoryf = 0, $cmp30 = 0, $idx_neg = 0, $root_0 = 0, $hl = 0, $_left = 0, $13 = 0, $tobool21 = 0, $right = 0, $14 = 0, $15 = 0, $_c389 = 0, $right25 = 0, $16 = 0, $17 = 0, $tobool27 = 0, $obj32 = 0, $18 = 0, $19 = 0, $20 = 0, $add_ptr = 0, $cond35 = 0, $21 = 0, $cmp38 = 0, $22 = 0, $23 = 0, $call40 = 0, $tobool42 = 0, $24 = 0, $size45 = 0, $25 = 0, $here47 = 0, $and48 = 0, $tobool49 = 0, $right52431 = 0, $26 = 0, $tobool53432 = 0, $hl63425 = 0, $_left64426 = 0, $27 = 0, $tobool65427 = 0, $28 = 0, $right52434 = 0, $root_1433 = 0, $hl55 = 0, $_left56 = 0, $29 = 0, $30 = 0, $root_1_c = 0, $right52 = 0, $31 = 0, $tobool53 = 0, $32 = 0, $hl63429 = 0, $root_2428 = 0, $right67 = 0, $33 = 0, $34 = 0, $_c = 0, $hl63 = 0, $_left64 = 0, $35 = 0, $tobool65 = 0, $root_3 = 0, $36 = 0, $here74 = 0, $cmp75 = 0, $obj77 = 0, $37 = 0, $38 = 0, $39 = 0, $idx_neg79 = 0, $add_ptr80 = 0, $meth = 0, $40 = 0, $type84 = 0, $41 = 0, $cmp85 = 0, $and86 = 0, $tobool87 = 0, $cmp89 = 0, $add_ptr91 = 0, $42 = 0, $43 = 0, $cond95 = 0, $searchf96 = 0, $44 = 0, $call97 = 0, $tobool98496 = 0, $tobool106 = 0, $cmp110 = 0, $o_0497 = 0, $add_ptr101 = 0, $45 = 0, $46 = 0, $cond105 = 0, $call108 = 0, $call112 = 0, $call114 = 0, $cond118 = 0, $cmp119 = 0, $cmp122 = 0, $47 = 0, $here125 = 0, $48 = 0, $hl126 = 0, $_left127 = 0, $49 = 0, $right128 = 0, $right129 = 0, $50 = 0, $51 = 0, $_c411 = 0, $52 = 0, $call135 = 0, $tobool98 = 0, $and137 = 0, $tobool138 = 0, $and140 = 0, $tobool141 = 0, $cmp144 = 0, $add_ptr146 = 0, $53 = 0, $54 = 0, $cond152 = 0, $tobool153 = 0, $and157 = 0, $tobool158 = 0, $55 = 0, $cmp160 = 0, $obj162 = 0, $56 = 0, $57 = 0, $idx_neg164 = 0, $add_ptr165 = 0, $cond167 = 0, $cmp168 = 0, $add_ptr170 = 0, $58 = 0, $59 = 0, $cond174 = 0, $tobool175 = 0, $tobool179 = 0, $cmp181 = 0, $obj183 = 0, $60 = 0, $61 = 0, $62 = 0, $idx_neg185 = 0, $add_ptr186 = 0, $cond188 = 0, $cmp189 = 0, $cmp191 = 0, $add_ptr193 = 0, $63 = 0, $64 = 0, $key_0 = 0, $me_0 = 0, $obj_addr_0 = 0, $65 = 0, $type199 = 0, $66 = 0, $cmp200 = 0, $67 = 0, $minp203 = 0, $68 = 0, $cmp204 = 0, $and206 = 0, $tobool207 = 0, $cmp212 = 0, $cmp220 = 0, $tobool227 = 0, $cmp231 = 0, $idx_neg216 = 0, $l_2_ph = 0, $r_2_ph = 0, $root_6_ph = 0, $cmp317 = 0, $cmp325 = 0, $tobool332 = 0, $cmp373 = 0, $idx_neg358 = 0, $cmp336 = 0, $idx_neg321 = 0, $cmp437 = 0, $idx_neg422 = 0, $t_0 = 0, $n_0 = 0, $cmp210 = 0, $cmp266485 = 0, $obj214 = 0, $69 = 0, $70 = 0, $71 = 0, $add_ptr217 = 0, $cond219 = 0, $add_ptr222 = 0, $72 = 0, $73 = 0, $cond226 = 0, $call229 = 0, $call233 = 0, $call235 = 0, $cond239 = 0, $cmp240 = 0, $obj244 = 0, $74 = 0, $75 = 0, $76 = 0, $idx_neg246 = 0, $add_ptr247 = 0, $arrayidx = 0, $cmp251 = 0, $hl253 = 0, $_left254 = 0, $right256 = 0, $cond258_in = 0, $cond258 = 0, $tobool259 = 0, $inc = 0, $root_4489 = 0, $n_1488 = 0, $r_0487 = 0, $l_0486 = 0, $arrayidx268 = 0, $77 = 0, $cmp269 = 0, $hl271 = 0, $_left272 = 0, $78 = 0, $add407 = 0, $arrayidx273 = 0, $79 = 0, $cmp274 = 0, $right276 = 0, $80 = 0, $81 = 0, $_c409 = 0, $82 = 0, $_c410 = 0, $hl282 = 0, $_left283 = 0, $right285 = 0, $83 = 0, $root_4_c408 = 0, $right288 = 0, $right291 = 0, $84 = 0, $add292405 = 0, $arrayidx293 = 0, $85 = 0, $cmp294 = 0, $hl296 = 0, $_left297 = 0, $86 = 0, $87 = 0, $root_4_c = 0, $right301 = 0, $right302 = 0, $88 = 0, $_c406 = 0, $right306 = 0, $hl307 = 0, $_left308 = 0, $l_1 = 0, $r_1 = 0, $root_5_in = 0, $root_5 = 0, $add312 = 0, $cmp266 = 0, $r_2 = 0, $root_6 = 0, $obj319 = 0, $89 = 0, $90 = 0, $91 = 0, $add_ptr322 = 0, $cond324 = 0, $add_ptr327 = 0, $92 = 0, $93 = 0, $cond331 = 0, $call334 = 0, $call338 = 0, $call340 = 0, $cond344 = 0, $cmp345 = 0, $cmp348 = 0, $hl350 = 0, $_left351 = 0, $94 = 0, $tobool352 = 0, $obj356 = 0, $95 = 0, $96 = 0, $97 = 0, $add_ptr359 = 0, $cond361 = 0, $add_ptr364 = 0, $98 = 0, $99 = 0, $cond368 = 0, $call371 = 0, $call375 = 0, $call377 = 0, $cond381 = 0, $cmp382 = 0, $right384 = 0, $100 = 0, $101 = 0, $_c403 = 0, $102 = 0, $_c404 = 0, $hl390 = 0, $_left391 = 0, $103 = 0, $tobool392 = 0, $cmp396 = 0, $104 = 0, $root_6_c402 = 0, $right401 = 0, $105 = 0, $root_6_c401 = 0, $right404 = 0, $106 = 0, $tobool405 = 0, $107 = 0, $root_6_c400 = 0, $right415 = 0, $108 = 0, $tobool416 = 0, $obj420 = 0, $109 = 0, $110 = 0, $111 = 0, $add_ptr423 = 0, $cond425 = 0, $add_ptr428 = 0, $112 = 0, $113 = 0, $cond432 = 0, $call435 = 0, $call439 = 0, $call441 = 0, $cond445 = 0, $cmp446 = 0, $hl448 = 0, $_left449 = 0, $114 = 0, $115 = 0, $root_6_c = 0, $right453 = 0, $right454 = 0, $116 = 0, $tobool455 = 0, $l_2_ph459 = 0, $r_2_ph460 = 0, $root_6_ph461 = 0, $cmp459 = 0, $right461 = 0, $117 = 0, $_c399 = 0, $right465 = 0, $hl466 = 0, $_left467 = 0, $118 = 0, $tobool468 = 0, $right474 = 0, $l_3 = 0, $r_3 = 0, $me_1 = 0, $root_7 = 0, $obj_addr_1 = 0, $tobool482 = 0, $119 = 0, $or = 0, $hl485 = 0, $_left486 = 0, $120 = 0, $right487 = 0, $right488 = 0, $121 = 0, $122 = 0, $_c396 = 0, $and491 = 0, $tobool492 = 0, $root_8 = 0, $right494 = 0, $123 = 0, $124 = 0, $_c391 = 0, $hl497 = 0, $_left498 = 0, $125 = 0, $right499 = 0, $126 = 0, $type501 = 0, $127 = 0, $and502 = 0, $tobool503 = 0, $and505 = 0, $tobool506 = 0, $cmp508 = 0, $obj510 = 0, $128 = 0, $129 = 0, $130 = 0, $idx_neg512 = 0, $add_ptr513 = 0, $cond515 = 0, $cmp516 = 0, $add_ptr518 = 0, $131 = 0, $132 = 0, $cond522 = 0, $hl524442 = 0, $_left525443 = 0, $133 = 0, $tobool526444 = 0, $tobool555 = 0, $cmp559 = 0, $idx_neg544 = 0, $134 = 0, $hl524446 = 0, $root_9445 = 0, $right529436 = 0, $135 = 0, $tobool530437 = 0, $136 = 0, $right529439 = 0, $t_1438 = 0, $hl532 = 0, $_left533 = 0, $137 = 0, $138 = 0, $t_1_c393 = 0, $right529 = 0, $139 = 0, $tobool530 = 0, $right529_lcssa = 0, $t_1_lcssa = 0, $140 = 0, $t_1_c = 0, $obj542 = 0, $141 = 0, $142 = 0, $143 = 0, $add_ptr545 = 0, $cond547 = 0, $add_ptr550 = 0, $144 = 0, $145 = 0, $cond554 = 0, $call557 = 0, $call561 = 0, $call563 = 0, $cond567 = 0, $cmp568 = 0, $146 = 0, $_c392 = 0, $hl524 = 0, $_left525 = 0, $147 = 0, $tobool526 = 0, $root_10 = 0, $148 = 0, $here578 = 0, $cmp579 = 0, $obj581 = 0, $149 = 0, $150 = 0, $151 = 0, $idx_neg583 = 0, $add_ptr584 = 0, $and588 = 0, $tobool589 = 0, $right591 = 0, $152 = 0, $153 = 0, $_c398 = 0, $obj_addr_1421 = 0, $r_3414 = 0, $hl596 = 0, $_left597 = 0, $154 = 0, $tobool598 = 0, $hl601453 = 0, $_left602454 = 0, $155 = 0, $tobool603455 = 0, $156 = 0, $hl601457 = 0, $root_11456 = 0, $right605 = 0, $157 = 0, $158 = 0, $_c395 = 0, $hl601 = 0, $_left602 = 0, $159 = 0, $tobool603 = 0, $root_11_lcssa = 0, $right610 = 0, $160 = 0, $161 = 0, $_c394 = 0, $and615 = 0, $tobool616 = 0, $hl618 = 0, $_left619 = 0, $162 = 0, $163 = 0, $164 = 0, $root_7_c397 = 0, $obj_addr_1424 = 0, $r_3416 = 0, $right625 = 0, $165 = 0, $tobool626 = 0, $right629448 = 0, $166 = 0, $tobool630449 = 0, $167 = 0, $right629451 = 0, $root_12450 = 0, $hl632 = 0, $_left633 = 0, $168 = 0, $169 = 0, $root_12_c = 0, $right629 = 0, $170 = 0, $tobool630 = 0, $root_12_lcssa = 0, $hl638 = 0, $_left639 = 0, $171 = 0, $and643 = 0, $tobool644 = 0, $r_4 = 0, $root_13 = 0, $cmp646 = 0, $obj648 = 0, $172 = 0, $173 = 0, $174 = 0, $idx_neg650 = 0, $add_ptr651 = 0, $cond653 = 0, $freef654 = 0, $175 = 0, $tobool655 = 0, $and657 = 0, $tobool658 = 0, $176 = 0, $cmp663 = 0, $memoryf665 = 0, $177 = 0, $178 = 0, $call666 = 0, $179 = 0, $size669 = 0, $180 = 0, $sub = 0, $cmp670 = 0, $181 = 0, $size673 = 0, $and676 = 0, $tobool677 = 0, $182 = 0, $type680 = 0, $183 = 0, $and681 = 0, $tobool682 = 0, $184 = 0, $hl687 = 0, $_left688 = 0, $185 = 0, $186 = 0, $root_7_c = 0, $and693 = 0, $tobool694 = 0, $187 = 0, $type697 = 0, $188 = 0, $and698 = 0, $tobool699 = 0, $freef701 = 0, $189 = 0, $tobool702 = 0, $190 = 0, $cmp707 = 0, $memoryf709 = 0, $191 = 0, $192 = 0, $call710 = 0, $193 = 0, $hl715 = 0, $_left716 = 0, $194 = 0, $right717 = 0, $195 = 0, $me_1_c = 0, $196 = 0, $size721 = 0, $197 = 0, $add722 = 0, $obj_addr_1422 = 0, $me_1418 = 0, $r_3415 = 0, $l_3413 = 0, $198 = 0, $right733 = 0, $and734 = 0, $tobool735 = 0, $and738 = 0, $tobool739 = 0, $and742 = 0, $tobool743 = 0, $r_5_ph = 0, $obj_addr_2_ph = 0, $r_5 = 0, $hl746 = 0, $_left747 = 0, $199 = 0, $tobool748 = 0, $right751 = 0, $200 = 0, $201 = 0, $_c390 = 0, $hl754 = 0, $_left755 = 0, $202 = 0, $203 = 0, $here757 = 0, $and758 = 0, $tobool759 = 0, $cond763 = 0, $and765 = 0, $tobool766 = 0, $obj_addr_1423 = 0, $root_7419 = 0, $r_3417 = 0, $makef = 0, $204 = 0, $tobool768 = 0, $and770 = 0, $tobool771 = 0, $call774 = 0, $obj_addr_3 = 0, $tobool776 = 0, $cmp778 = 0, $add_ptr780 = 0, $205 = 0, $memoryf782 = 0, $206 = 0, $call783 = 0, $207 = 0, $tobool784 = 0, $obj786 = 0, $208 = 0, $209 = 0, $tobool789 = 0, $freef791 = 0, $210 = 0, $tobool792 = 0, $and794 = 0, $tobool795 = 0, $root_14 = 0, $tobool802 = 0, $211 = 0, $size805 = 0, $212 = 0, $cmp806 = 0, $add810 = 0, $and814 = 0, $tobool815 = 0, $213 = 0, $size818 = 0, $214 = 0, $add819 = 0, $retval_0 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 128 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $link = __stackBase__ | 0;
    $turn = __stackBase__ + 8 | 0;
    $data = $dt + 8 | 0;
    $0 = HEAP32[$data >> 2] | 0;
    $type1 = $0 | 0;
    $1 = HEAP32[$type1 >> 2] | 0;
    $and = $1 & 4096;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $2 = $dt;
    $call = _dtrestore($2, 0) | 0;
    label = 4;
    break;
   case 4:
    $disc2 = $dt + 4 | 0;
    $3 = HEAP32[$disc2 >> 2] | 0;
    $key3 = $3 | 0;
    $4 = HEAP32[$key3 >> 2] | 0;
    $size = $3 + 4 | 0;
    $5 = HEAP32[$size >> 2] | 0;
    $link4 = $3 + 8 | 0;
    $6 = HEAP32[$link4 >> 2] | 0;
    $comparf = $3 + 20 | 0;
    $7 = HEAP32[$comparf >> 2] | 0;
    $type5 = $dt + 20 | 0;
    $8 = HEAP32[$type5 >> 2] | 0;
    $and6 = $8 & -32769;
    HEAP32[$type5 >> 2] = $and6;
    $9 = HEAP32[$data >> 2] | 0;
    $here = $9 + 4 | 0;
    $10 = HEAP32[$here >> 2] | 0;
    $tobool8 = ($obj | 0) == 0;
    if ($tobool8) {
      label = 5;
      break;
    } else {
      label = 30;
      break;
    }
   case 5:
    $tobool9 = ($10 | 0) == 0;
    if ($tobool9) {
      $retval_0 = 0;
      label = 231;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $and10 = $type & 448;
    $tobool11 = ($and10 | 0) == 0;
    if ($tobool11) {
      $retval_0 = 0;
      label = 231;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $and13 = $type & 64;
    $tobool14 = ($and13 | 0) == 0;
    if ($tobool14) {
      label = 22;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $freef = $3 + 16 | 0;
    $11 = HEAP32[$freef >> 2] | 0;
    $tobool16 = ($11 | 0) == 0;
    if ($tobool16) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    $12 = HEAP32[$link4 >> 2] | 0;
    $cmp19 = ($12 | 0) < 0;
    if ($cmp19) {
      label = 10;
      break;
    } else {
      label = 21;
      break;
    }
   case 10:
    $memoryf = $dt + 12 | 0;
    $cmp30 = ($6 | 0) < 0;
    $idx_neg = -$6 | 0;
    $root_0 = $10;
    label = 11;
    break;
   case 11:
    $hl = $root_0 + 4 | 0;
    $_left = $hl;
    $13 = HEAP32[$_left >> 2] | 0;
    $tobool21 = ($13 | 0) == 0;
    if ($tobool21) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $right = $13 | 0;
    $14 = HEAP32[$right >> 2] | 0;
    $15 = $hl | 0;
    $_c389 = $14;
    HEAP32[$15 >> 2] = $_c389;
    HEAP32[$right >> 2] = $root_0;
    $root_0 = $13;
    label = 11;
    break;
   case 13:
    $right25 = $root_0 | 0;
    $16 = HEAP32[$right25 >> 2] | 0;
    $17 = HEAP32[$freef >> 2] | 0;
    $tobool27 = ($17 | 0) == 0;
    if ($tobool27) {
      label = 18;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    if ($cmp30) {
      label = 15;
      break;
    } else {
      label = 16;
      break;
    }
   case 15:
    $obj32 = $root_0 + 8 | 0;
    $18 = $obj32;
    $19 = HEAP32[$18 >> 2] | 0;
    $cond35 = $19;
    label = 17;
    break;
   case 16:
    $20 = $root_0;
    $add_ptr = $20 + $idx_neg | 0;
    $cond35 = $add_ptr;
    label = 17;
    break;
   case 17:
    FUNCTION_TABLE_viii[$17 & 1023]($dt, $cond35, $3);
    label = 18;
    break;
   case 18:
    $21 = HEAP32[$link4 >> 2] | 0;
    $cmp38 = ($21 | 0) < 0;
    if ($cmp38) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    $22 = HEAP32[$memoryf >> 2] | 0;
    $23 = $root_0;
    $call40 = FUNCTION_TABLE_iiiii[$22 & 1023]($dt, $23, 0, $3) | 0;
    label = 20;
    break;
   case 20:
    $tobool42 = ($16 | 0) == 0;
    if ($tobool42) {
      label = 21;
      break;
    } else {
      $root_0 = $16;
      label = 11;
      break;
    }
   case 21:
    $24 = HEAP32[$data >> 2] | 0;
    $size45 = $24 + 16 | 0;
    HEAP32[$size45 >> 2] = 0;
    $25 = HEAP32[$data >> 2] | 0;
    $here47 = $25 + 4 | 0;
    HEAP32[$here47 >> 2] = 0;
    $retval_0 = 0;
    label = 231;
    break;
   case 22:
    $and48 = $type & 256;
    $tobool49 = ($and48 | 0) == 0;
    if ($tobool49) {
      label = 24;
      break;
    } else {
      label = 23;
      break;
    }
   case 23:
    $right52431 = $10 | 0;
    $26 = HEAP32[$right52431 >> 2] | 0;
    $tobool53432 = ($26 | 0) == 0;
    if ($tobool53432) {
      $root_3 = $10;
      label = 27;
      break;
    } else {
      $root_1433 = $10;
      $right52434 = $right52431;
      $28 = $26;
      label = 25;
      break;
    }
   case 24:
    $hl63425 = $10 + 4 | 0;
    $_left64426 = $hl63425;
    $27 = HEAP32[$_left64426 >> 2] | 0;
    $tobool65427 = ($27 | 0) == 0;
    if ($tobool65427) {
      $root_3 = $10;
      label = 27;
      break;
    } else {
      $root_2428 = $10;
      $hl63429 = $hl63425;
      $32 = $27;
      label = 26;
      break;
    }
   case 25:
    $hl55 = $28 + 4 | 0;
    $_left56 = $hl55;
    $29 = HEAP32[$_left56 >> 2] | 0;
    HEAP32[$right52434 >> 2] = $29;
    $30 = $hl55 | 0;
    $root_1_c = $root_1433;
    HEAP32[$30 >> 2] = $root_1_c;
    $right52 = $28 | 0;
    $31 = HEAP32[$right52 >> 2] | 0;
    $tobool53 = ($31 | 0) == 0;
    if ($tobool53) {
      $root_3 = $28;
      label = 27;
      break;
    } else {
      $root_1433 = $28;
      $right52434 = $right52;
      $28 = $31;
      label = 25;
      break;
    }
   case 26:
    $right67 = $32 | 0;
    $33 = HEAP32[$right67 >> 2] | 0;
    $34 = $hl63429 | 0;
    $_c = $33;
    HEAP32[$34 >> 2] = $_c;
    HEAP32[$right67 >> 2] = $root_2428;
    $hl63 = $32 + 4 | 0;
    $_left64 = $hl63;
    $35 = HEAP32[$_left64 >> 2] | 0;
    $tobool65 = ($35 | 0) == 0;
    if ($tobool65) {
      $root_3 = $32;
      label = 27;
      break;
    } else {
      $root_2428 = $32;
      $hl63429 = $hl63;
      $32 = $35;
      label = 26;
      break;
    }
   case 27:
    $36 = HEAP32[$data >> 2] | 0;
    $here74 = $36 + 4 | 0;
    HEAP32[$here74 >> 2] = $root_3;
    $cmp75 = ($6 | 0) < 0;
    if ($cmp75) {
      label = 28;
      break;
    } else {
      label = 29;
      break;
    }
   case 28:
    $obj77 = $root_3 + 8 | 0;
    $37 = $obj77;
    $38 = HEAP32[$37 >> 2] | 0;
    $retval_0 = $38;
    label = 231;
    break;
   case 29:
    $39 = $root_3;
    $idx_neg79 = -$6 | 0;
    $add_ptr80 = $39 + $idx_neg79 | 0;
    $retval_0 = $add_ptr80;
    label = 231;
    break;
   case 30:
    $meth = $dt + 16 | 0;
    $40 = HEAP32[$meth >> 2] | 0;
    $type84 = $40 + 4 | 0;
    $41 = HEAP32[$type84 >> 2] | 0;
    $cmp85 = ($41 | 0) == 8;
    if ($cmp85) {
      label = 31;
      break;
    } else {
      label = 47;
      break;
    }
   case 31:
    $and86 = $type & 4098;
    $tobool87 = ($and86 | 0) == 0;
    if ($tobool87) {
      label = 47;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    $cmp89 = ($5 | 0) < 0;
    $add_ptr91 = $obj + $4 | 0;
    if ($cmp89) {
      label = 33;
      break;
    } else {
      $cond95 = $add_ptr91;
      label = 34;
      break;
    }
   case 33:
    $42 = $add_ptr91;
    $43 = HEAP32[$42 >> 2] | 0;
    $cond95 = $43;
    label = 34;
    break;
   case 34:
    $searchf96 = $dt;
    $44 = HEAP32[$searchf96 >> 2] | 0;
    $call97 = FUNCTION_TABLE_iiii[$44 & 1023]($dt, $obj, 4) | 0;
    $tobool98496 = ($call97 | 0) == 0;
    if ($tobool98496) {
      label = 47;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    $tobool106 = ($7 | 0) == 0;
    $cmp110 = ($5 | 0) < 1;
    $o_0497 = $call97;
    label = 36;
    break;
   case 36:
    $add_ptr101 = $o_0497 + $4 | 0;
    if ($cmp89) {
      label = 37;
      break;
    } else {
      $cond105 = $add_ptr101;
      label = 38;
      break;
    }
   case 37:
    $45 = $add_ptr101;
    $46 = HEAP32[$45 >> 2] | 0;
    $cond105 = $46;
    label = 38;
    break;
   case 38:
    if ($tobool106) {
      label = 40;
      break;
    } else {
      label = 39;
      break;
    }
   case 39:
    $call108 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $cond95, $cond105, $3) | 0;
    $cond118 = $call108;
    label = 43;
    break;
   case 40:
    if ($cmp110) {
      label = 41;
      break;
    } else {
      label = 42;
      break;
    }
   case 41:
    $call112 = _strcmp($cond95 | 0, $cond105 | 0) | 0;
    $cond118 = $call112;
    label = 43;
    break;
   case 42:
    $call114 = _memcmp($cond95 | 0, $cond105 | 0, $5 | 0) | 0;
    $cond118 = $call114;
    label = 43;
    break;
   case 43:
    $cmp119 = ($cond118 | 0) == 0;
    if ($cmp119) {
      label = 44;
      break;
    } else {
      label = 47;
      break;
    }
   case 44:
    $cmp122 = ($o_0497 | 0) == ($obj | 0);
    if ($cmp122) {
      label = 45;
      break;
    } else {
      label = 46;
      break;
    }
   case 45:
    $47 = HEAP32[$data >> 2] | 0;
    $here125 = $47 + 4 | 0;
    $48 = HEAP32[$here125 >> 2] | 0;
    $hl126 = $48 + 4 | 0;
    $_left127 = $hl126;
    $49 = HEAP32[$_left127 >> 2] | 0;
    $right128 = $link | 0;
    HEAP32[$right128 >> 2] = $49;
    $right129 = $48 | 0;
    $50 = HEAP32[$right129 >> 2] | 0;
    $51 = $link + 4 | 0;
    $_c411 = $50;
    HEAP32[$51 >> 2] = $_c411;
    $root_13 = $48;
    $r_4 = $link;
    label = 187;
    break;
   case 46:
    $52 = HEAP32[$searchf96 >> 2] | 0;
    $call135 = FUNCTION_TABLE_iiii[$52 & 1023]($dt, $o_0497, 8) | 0;
    $tobool98 = ($call135 | 0) == 0;
    if ($tobool98) {
      label = 47;
      break;
    } else {
      $o_0497 = $call135;
      label = 36;
      break;
    }
   case 47:
    $and137 = $type & 2565;
    $tobool138 = ($and137 | 0) == 0;
    if ($tobool138) {
      label = 52;
      break;
    } else {
      label = 48;
      break;
    }
   case 48:
    $and140 = $type & 512;
    $tobool141 = ($and140 | 0) == 0;
    if ($tobool141) {
      label = 49;
      break;
    } else {
      $cond152 = $obj;
      label = 51;
      break;
    }
   case 49:
    $cmp144 = ($5 | 0) < 0;
    $add_ptr146 = $obj + $4 | 0;
    if ($cmp144) {
      label = 50;
      break;
    } else {
      $cond152 = $add_ptr146;
      label = 51;
      break;
    }
   case 50:
    $53 = $add_ptr146;
    $54 = HEAP32[$53 >> 2] | 0;
    $cond152 = $54;
    label = 51;
    break;
   case 51:
    $tobool153 = ($10 | 0) == 0;
    if ($tobool153) {
      $l_3413 = $link;
      $r_3415 = $link;
      $me_1418 = 0;
      $obj_addr_1422 = $obj;
      label = 207;
      break;
    } else {
      $obj_addr_0 = $obj;
      $me_0 = 0;
      $key_0 = $cond152;
      label = 66;
      break;
    }
   case 52:
    $and157 = $type & 32;
    $tobool158 = ($and157 | 0) == 0;
    if ($tobool158) {
      label = 59;
      break;
    } else {
      label = 53;
      break;
    }
   case 53:
    $55 = $obj;
    $cmp160 = ($6 | 0) < 0;
    if ($cmp160) {
      label = 54;
      break;
    } else {
      label = 55;
      break;
    }
   case 54:
    $obj162 = $obj + 8 | 0;
    $56 = $obj162;
    $57 = HEAP32[$56 >> 2] | 0;
    $cond167 = $57;
    label = 56;
    break;
   case 55:
    $idx_neg164 = -$6 | 0;
    $add_ptr165 = $obj + $idx_neg164 | 0;
    $cond167 = $add_ptr165;
    label = 56;
    break;
   case 56:
    $cmp168 = ($5 | 0) < 0;
    $add_ptr170 = $cond167 + $4 | 0;
    if ($cmp168) {
      label = 57;
      break;
    } else {
      $cond174 = $add_ptr170;
      label = 58;
      break;
    }
   case 57:
    $58 = $add_ptr170;
    $59 = HEAP32[$58 >> 2] | 0;
    $cond174 = $59;
    label = 58;
    break;
   case 58:
    $tobool175 = ($10 | 0) == 0;
    if ($tobool175) {
      $l_3413 = $link;
      $r_3415 = $link;
      $me_1418 = $55;
      $obj_addr_1422 = $cond167;
      label = 207;
      break;
    } else {
      $obj_addr_0 = $cond167;
      $me_0 = $55;
      $key_0 = $cond174;
      label = 66;
      break;
    }
   case 59:
    $tobool179 = ($10 | 0) == 0;
    if ($tobool179) {
      $l_3413 = $link;
      $r_3415 = $link;
      $me_1418 = 0;
      $obj_addr_1422 = $obj;
      label = 207;
      break;
    } else {
      label = 60;
      break;
    }
   case 60:
    $cmp181 = ($6 | 0) < 0;
    if ($cmp181) {
      label = 61;
      break;
    } else {
      label = 62;
      break;
    }
   case 61:
    $obj183 = $10 + 8 | 0;
    $60 = $obj183;
    $61 = HEAP32[$60 >> 2] | 0;
    $cond188 = $61;
    label = 63;
    break;
   case 62:
    $62 = $10;
    $idx_neg185 = -$6 | 0;
    $add_ptr186 = $62 + $idx_neg185 | 0;
    $cond188 = $add_ptr186;
    label = 63;
    break;
   case 63:
    $cmp189 = ($cond188 | 0) == ($obj | 0);
    if ($cmp189) {
      $obj_addr_1 = $obj;
      $root_7 = $10;
      $me_1 = 0;
      $r_3 = $link;
      $l_3 = $link;
      label = 146;
      break;
    } else {
      label = 64;
      break;
    }
   case 64:
    $cmp191 = ($5 | 0) < 0;
    $add_ptr193 = $obj + $4 | 0;
    if ($cmp191) {
      label = 65;
      break;
    } else {
      $obj_addr_0 = $obj;
      $me_0 = 0;
      $key_0 = $add_ptr193;
      label = 66;
      break;
    }
   case 65:
    $63 = $add_ptr193;
    $64 = HEAP32[$63 >> 2] | 0;
    $obj_addr_0 = $obj;
    $me_0 = 0;
    $key_0 = $64;
    label = 66;
    break;
   case 66:
    $65 = HEAP32[$meth >> 2] | 0;
    $type199 = $65 + 4 | 0;
    $66 = HEAP32[$type199 >> 2] | 0;
    $cmp200 = ($66 | 0) == 4;
    if ($cmp200) {
      label = 67;
      break;
    } else {
      $root_6_ph = $10;
      $r_2_ph = $link;
      $l_2_ph = $link;
      label = 70;
      break;
    }
   case 67:
    $67 = HEAP32[$data >> 2] | 0;
    $minp203 = $67 + 24 | 0;
    $68 = HEAP32[$minp203 >> 2] | 0;
    $cmp204 = ($68 | 0) == 0;
    if ($cmp204) {
      $root_6_ph = $10;
      $r_2_ph = $link;
      $l_2_ph = $link;
      label = 70;
      break;
    } else {
      label = 68;
      break;
    }
   case 68:
    $and206 = $type & 516;
    $tobool207 = ($and206 | 0) == 0;
    if ($tobool207) {
      $root_6_ph = $10;
      $r_2_ph = $link;
      $l_2_ph = $link;
      label = 70;
      break;
    } else {
      label = 69;
      break;
    }
   case 69:
    $cmp212 = ($6 | 0) < 0;
    $cmp220 = ($5 | 0) < 0;
    $tobool227 = ($7 | 0) == 0;
    $cmp231 = ($5 | 0) < 1;
    $idx_neg216 = -$6 | 0;
    $n_0 = 0;
    $t_0 = $10;
    label = 71;
    break;
   case 70:
    $cmp317 = ($6 | 0) < 0;
    $cmp325 = ($5 | 0) < 0;
    $tobool332 = ($7 | 0) != 0;
    $cmp373 = ($5 | 0) < 1;
    $idx_neg358 = -$6 | 0;
    $cmp336 = ($5 | 0) < 1;
    $idx_neg321 = -$6 | 0;
    $cmp437 = ($5 | 0) < 1;
    $idx_neg422 = -$6 | 0;
    $root_6_ph461 = $root_6_ph;
    $r_2_ph460 = $r_2_ph;
    $l_2_ph459 = $l_2_ph;
    label = 141;
    break;
   case 71:
    $cmp210 = ($n_0 | 0) < ($68 | 0);
    if ($cmp210) {
      label = 73;
      break;
    } else {
      label = 72;
      break;
    }
   case 72:
    $cmp266485 = ($68 | 0) > 0;
    if ($cmp266485) {
      $l_0486 = $link;
      $r_0487 = $link;
      $n_1488 = 0;
      $root_4489 = $10;
      label = 91;
      break;
    } else {
      $root_6_ph = $10;
      $r_2_ph = $link;
      $l_2_ph = $link;
      label = 70;
      break;
    }
   case 73:
    if ($cmp212) {
      label = 74;
      break;
    } else {
      label = 75;
      break;
    }
   case 74:
    $obj214 = $t_0 + 8 | 0;
    $69 = $obj214;
    $70 = HEAP32[$69 >> 2] | 0;
    $cond219 = $70;
    label = 76;
    break;
   case 75:
    $71 = $t_0;
    $add_ptr217 = $71 + $idx_neg216 | 0;
    $cond219 = $add_ptr217;
    label = 76;
    break;
   case 76:
    $add_ptr222 = $cond219 + $4 | 0;
    if ($cmp220) {
      label = 77;
      break;
    } else {
      $cond226 = $add_ptr222;
      label = 78;
      break;
    }
   case 77:
    $72 = $add_ptr222;
    $73 = HEAP32[$72 >> 2] | 0;
    $cond226 = $73;
    label = 78;
    break;
   case 78:
    if ($tobool227) {
      label = 80;
      break;
    } else {
      label = 79;
      break;
    }
   case 79:
    $call229 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $key_0, $cond226, $3) | 0;
    $cond239 = $call229;
    label = 83;
    break;
   case 80:
    if ($cmp231) {
      label = 81;
      break;
    } else {
      label = 82;
      break;
    }
   case 81:
    $call233 = _strcmp($key_0 | 0, $cond226 | 0) | 0;
    $cond239 = $call233;
    label = 83;
    break;
   case 82:
    $call235 = _memcmp($key_0 | 0, $cond226 | 0, $5 | 0) | 0;
    $cond239 = $call235;
    label = 83;
    break;
   case 83:
    $cmp240 = ($cond239 | 0) == 0;
    if ($cmp240) {
      label = 84;
      break;
    } else {
      label = 87;
      break;
    }
   case 84:
    if ($cmp212) {
      label = 85;
      break;
    } else {
      label = 86;
      break;
    }
   case 85:
    $obj244 = $t_0 + 8 | 0;
    $74 = $obj244;
    $75 = HEAP32[$74 >> 2] | 0;
    $retval_0 = $75;
    label = 231;
    break;
   case 86:
    $76 = $t_0;
    $idx_neg246 = -$6 | 0;
    $add_ptr247 = $76 + $idx_neg246 | 0;
    $retval_0 = $add_ptr247;
    label = 231;
    break;
   case 87:
    $arrayidx = $turn + ($n_0 << 2) | 0;
    HEAP32[$arrayidx >> 2] = $cond239;
    $cmp251 = ($cond239 | 0) < 0;
    if ($cmp251) {
      label = 88;
      break;
    } else {
      label = 89;
      break;
    }
   case 88:
    $hl253 = $t_0 + 4 | 0;
    $_left254 = $hl253;
    $cond258_in = $_left254;
    label = 90;
    break;
   case 89:
    $right256 = $t_0 | 0;
    $cond258_in = $right256;
    label = 90;
    break;
   case 90:
    $cond258 = HEAP32[$cond258_in >> 2] | 0;
    $tobool259 = ($cond258 | 0) == 0;
    $inc = $n_0 + 1 | 0;
    if ($tobool259) {
      $retval_0 = 0;
      label = 231;
      break;
    } else {
      $n_0 = $inc;
      $t_0 = $cond258;
      label = 71;
      break;
    }
   case 91:
    $arrayidx268 = $turn + ($n_1488 << 2) | 0;
    $77 = HEAP32[$arrayidx268 >> 2] | 0;
    $cmp269 = ($77 | 0) < 0;
    if ($cmp269) {
      label = 92;
      break;
    } else {
      label = 95;
      break;
    }
   case 92:
    $hl271 = $root_4489 + 4 | 0;
    $_left272 = $hl271;
    $78 = HEAP32[$_left272 >> 2] | 0;
    $add407 = $n_1488 | 1;
    $arrayidx273 = $turn + ($add407 << 2) | 0;
    $79 = HEAP32[$arrayidx273 >> 2] | 0;
    $cmp274 = ($79 | 0) < 0;
    if ($cmp274) {
      label = 93;
      break;
    } else {
      label = 94;
      break;
    }
   case 93:
    $right276 = $78 | 0;
    $80 = HEAP32[$right276 >> 2] | 0;
    $81 = $hl271 | 0;
    $_c409 = $80;
    HEAP32[$81 >> 2] = $_c409;
    HEAP32[$right276 >> 2] = $root_4489;
    $82 = $r_0487 + 4 | 0;
    $_c410 = $78;
    HEAP32[$82 >> 2] = $_c410;
    $hl282 = $78 + 4 | 0;
    $_left283 = $hl282;
    $root_5_in = $_left283;
    $r_1 = $78;
    $l_1 = $l_0486;
    label = 98;
    break;
   case 94:
    $right285 = $l_0486 | 0;
    HEAP32[$right285 >> 2] = $78;
    $83 = $r_0487 + 4 | 0;
    $root_4_c408 = $root_4489;
    HEAP32[$83 >> 2] = $root_4_c408;
    $right288 = $78 | 0;
    $root_5_in = $right288;
    $r_1 = $root_4489;
    $l_1 = $78;
    label = 98;
    break;
   case 95:
    $right291 = $root_4489 | 0;
    $84 = HEAP32[$right291 >> 2] | 0;
    $add292405 = $n_1488 | 1;
    $arrayidx293 = $turn + ($add292405 << 2) | 0;
    $85 = HEAP32[$arrayidx293 >> 2] | 0;
    $cmp294 = ($85 | 0) > 0;
    if ($cmp294) {
      label = 96;
      break;
    } else {
      label = 97;
      break;
    }
   case 96:
    $hl296 = $84 + 4 | 0;
    $_left297 = $hl296;
    $86 = HEAP32[$_left297 >> 2] | 0;
    HEAP32[$right291 >> 2] = $86;
    $87 = $hl296 | 0;
    $root_4_c = $root_4489;
    HEAP32[$87 >> 2] = $root_4_c;
    $right301 = $l_0486 | 0;
    HEAP32[$right301 >> 2] = $84;
    $right302 = $84 | 0;
    $root_5_in = $right302;
    $r_1 = $r_0487;
    $l_1 = $84;
    label = 98;
    break;
   case 97:
    $88 = $r_0487 + 4 | 0;
    $_c406 = $84;
    HEAP32[$88 >> 2] = $_c406;
    $right306 = $l_0486 | 0;
    HEAP32[$right306 >> 2] = $root_4489;
    $hl307 = $84 + 4 | 0;
    $_left308 = $hl307;
    $root_5_in = $_left308;
    $r_1 = $84;
    $l_1 = $root_4489;
    label = 98;
    break;
   case 98:
    $root_5 = HEAP32[$root_5_in >> 2] | 0;
    $add312 = $n_1488 + 2 | 0;
    $cmp266 = ($add312 | 0) < ($68 | 0);
    if ($cmp266) {
      $l_0486 = $l_1;
      $r_0487 = $r_1;
      $n_1488 = $add312;
      $root_4489 = $root_5;
      label = 91;
      break;
    } else {
      $root_6_ph = $root_5;
      $r_2_ph = $r_1;
      $l_2_ph = $l_1;
      label = 70;
      break;
    }
   case 99:
    if ($cmp317) {
      label = 100;
      break;
    } else {
      label = 101;
      break;
    }
   case 100:
    $obj319 = $root_6 + 8 | 0;
    $89 = $obj319;
    $90 = HEAP32[$89 >> 2] | 0;
    $cond324 = $90;
    label = 102;
    break;
   case 101:
    $91 = $root_6;
    $add_ptr322 = $91 + $idx_neg321 | 0;
    $cond324 = $add_ptr322;
    label = 102;
    break;
   case 102:
    $add_ptr327 = $cond324 + $4 | 0;
    if ($cmp325) {
      label = 103;
      break;
    } else {
      $cond331 = $add_ptr327;
      label = 104;
      break;
    }
   case 103:
    $92 = $add_ptr327;
    $93 = HEAP32[$92 >> 2] | 0;
    $cond331 = $93;
    label = 104;
    break;
   case 104:
    if ($tobool332) {
      label = 105;
      break;
    } else {
      label = 106;
      break;
    }
   case 105:
    $call334 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $key_0, $cond331, $3) | 0;
    $cond344 = $call334;
    label = 109;
    break;
   case 106:
    if ($cmp336) {
      label = 107;
      break;
    } else {
      label = 108;
      break;
    }
   case 107:
    $call338 = _strcmp($key_0 | 0, $cond331 | 0) | 0;
    $cond344 = $call338;
    label = 109;
    break;
   case 108:
    $call340 = _memcmp($key_0 | 0, $cond331 | 0, $5 | 0) | 0;
    $cond344 = $call340;
    label = 109;
    break;
   case 109:
    $cmp345 = ($cond344 | 0) == 0;
    if ($cmp345) {
      $obj_addr_1 = $obj_addr_0;
      $root_7 = $root_6;
      $me_1 = $me_0;
      $r_3 = $r_2;
      $l_3 = $l_2_ph459;
      label = 146;
      break;
    } else {
      label = 110;
      break;
    }
   case 110:
    $cmp348 = ($cond344 | 0) < 0;
    if ($cmp348) {
      label = 111;
      break;
    } else {
      label = 128;
      break;
    }
   case 111:
    $hl350 = $root_6 + 4 | 0;
    $_left351 = $hl350;
    $94 = HEAP32[$_left351 >> 2] | 0;
    $tobool352 = ($94 | 0) == 0;
    if ($tobool352) {
      label = 127;
      break;
    } else {
      label = 112;
      break;
    }
   case 112:
    if ($cmp317) {
      label = 113;
      break;
    } else {
      label = 114;
      break;
    }
   case 113:
    $obj356 = $94 + 8 | 0;
    $95 = $obj356;
    $96 = HEAP32[$95 >> 2] | 0;
    $cond361 = $96;
    label = 115;
    break;
   case 114:
    $97 = $94;
    $add_ptr359 = $97 + $idx_neg358 | 0;
    $cond361 = $add_ptr359;
    label = 115;
    break;
   case 115:
    $add_ptr364 = $cond361 + $4 | 0;
    if ($cmp325) {
      label = 116;
      break;
    } else {
      $cond368 = $add_ptr364;
      label = 117;
      break;
    }
   case 116:
    $98 = $add_ptr364;
    $99 = HEAP32[$98 >> 2] | 0;
    $cond368 = $99;
    label = 117;
    break;
   case 117:
    if ($tobool332) {
      label = 118;
      break;
    } else {
      label = 119;
      break;
    }
   case 118:
    $call371 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $key_0, $cond368, $3) | 0;
    $cond381 = $call371;
    label = 122;
    break;
   case 119:
    if ($cmp373) {
      label = 120;
      break;
    } else {
      label = 121;
      break;
    }
   case 120:
    $call375 = _strcmp($key_0 | 0, $cond368 | 0) | 0;
    $cond381 = $call375;
    label = 122;
    break;
   case 121:
    $call377 = _memcmp($key_0 | 0, $cond368 | 0, $5 | 0) | 0;
    $cond381 = $call377;
    label = 122;
    break;
   case 122:
    $cmp382 = ($cond381 | 0) < 0;
    if ($cmp382) {
      label = 123;
      break;
    } else {
      label = 124;
      break;
    }
   case 123:
    $right384 = $94 | 0;
    $100 = HEAP32[$right384 >> 2] | 0;
    $101 = $hl350 | 0;
    $_c403 = $100;
    HEAP32[$101 >> 2] = $_c403;
    HEAP32[$right384 >> 2] = $root_6;
    $102 = $r_2 + 4 | 0;
    $_c404 = $94;
    HEAP32[$102 >> 2] = $_c404;
    $hl390 = $94 + 4 | 0;
    $_left391 = $hl390;
    $103 = HEAP32[$_left391 >> 2] | 0;
    $tobool392 = ($103 | 0) == 0;
    if ($tobool392) {
      $l_3413 = $l_2_ph459;
      $r_3415 = $94;
      $me_1418 = $me_0;
      $obj_addr_1422 = $obj_addr_0;
      label = 207;
      break;
    } else {
      $root_6 = $103;
      $r_2 = $94;
      label = 99;
      break;
    }
   case 124:
    $cmp396 = ($cond381 | 0) == 0;
    if ($cmp396) {
      label = 125;
      break;
    } else {
      label = 126;
      break;
    }
   case 125:
    $104 = $r_2 + 4 | 0;
    $root_6_c402 = $root_6;
    HEAP32[$104 >> 2] = $root_6_c402;
    $obj_addr_1 = $obj_addr_0;
    $root_7 = $94;
    $me_1 = $me_0;
    $r_3 = $root_6;
    $l_3 = $l_2_ph459;
    label = 146;
    break;
   case 126:
    $right401 = $l_2_ph459 | 0;
    HEAP32[$right401 >> 2] = $94;
    $105 = $r_2 + 4 | 0;
    $root_6_c401 = $root_6;
    HEAP32[$105 >> 2] = $root_6_c401;
    $right404 = $94 | 0;
    $106 = HEAP32[$right404 >> 2] | 0;
    $tobool405 = ($106 | 0) == 0;
    if ($tobool405) {
      $l_3413 = $94;
      $r_3415 = $root_6;
      $me_1418 = $me_0;
      $obj_addr_1422 = $obj_addr_0;
      label = 207;
      break;
    } else {
      $root_6_ph461 = $106;
      $r_2_ph460 = $root_6;
      $l_2_ph459 = $94;
      label = 141;
      break;
    }
   case 127:
    $107 = $r_2 + 4 | 0;
    $root_6_c400 = $root_6;
    HEAP32[$107 >> 2] = $root_6_c400;
    $l_3413 = $l_2_ph459;
    $r_3415 = $root_6;
    $me_1418 = $me_0;
    $obj_addr_1422 = $obj_addr_0;
    label = 207;
    break;
   case 128:
    $right415 = $root_6 | 0;
    $108 = HEAP32[$right415 >> 2] | 0;
    $tobool416 = ($108 | 0) == 0;
    if ($tobool416) {
      label = 145;
      break;
    } else {
      label = 129;
      break;
    }
   case 129:
    if ($cmp317) {
      label = 130;
      break;
    } else {
      label = 131;
      break;
    }
   case 130:
    $obj420 = $108 + 8 | 0;
    $109 = $obj420;
    $110 = HEAP32[$109 >> 2] | 0;
    $cond425 = $110;
    label = 132;
    break;
   case 131:
    $111 = $108;
    $add_ptr423 = $111 + $idx_neg422 | 0;
    $cond425 = $add_ptr423;
    label = 132;
    break;
   case 132:
    $add_ptr428 = $cond425 + $4 | 0;
    if ($cmp325) {
      label = 133;
      break;
    } else {
      $cond432 = $add_ptr428;
      label = 134;
      break;
    }
   case 133:
    $112 = $add_ptr428;
    $113 = HEAP32[$112 >> 2] | 0;
    $cond432 = $113;
    label = 134;
    break;
   case 134:
    if ($tobool332) {
      label = 135;
      break;
    } else {
      label = 136;
      break;
    }
   case 135:
    $call435 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $key_0, $cond432, $3) | 0;
    $cond445 = $call435;
    label = 139;
    break;
   case 136:
    if ($cmp437) {
      label = 137;
      break;
    } else {
      label = 138;
      break;
    }
   case 137:
    $call439 = _strcmp($key_0 | 0, $cond432 | 0) | 0;
    $cond445 = $call439;
    label = 139;
    break;
   case 138:
    $call441 = _memcmp($key_0 | 0, $cond432 | 0, $5 | 0) | 0;
    $cond445 = $call441;
    label = 139;
    break;
   case 139:
    $cmp446 = ($cond445 | 0) > 0;
    if ($cmp446) {
      label = 140;
      break;
    } else {
      label = 142;
      break;
    }
   case 140:
    $hl448 = $108 + 4 | 0;
    $_left449 = $hl448;
    $114 = HEAP32[$_left449 >> 2] | 0;
    HEAP32[$right415 >> 2] = $114;
    $115 = $hl448 | 0;
    $root_6_c = $root_6;
    HEAP32[$115 >> 2] = $root_6_c;
    $right453 = $l_2_ph459 | 0;
    HEAP32[$right453 >> 2] = $108;
    $right454 = $108 | 0;
    $116 = HEAP32[$right454 >> 2] | 0;
    $tobool455 = ($116 | 0) == 0;
    if ($tobool455) {
      $l_3413 = $108;
      $r_3415 = $r_2;
      $me_1418 = $me_0;
      $obj_addr_1422 = $obj_addr_0;
      label = 207;
      break;
    } else {
      $root_6_ph461 = $116;
      $r_2_ph460 = $r_2;
      $l_2_ph459 = $108;
      label = 141;
      break;
    }
   case 141:
    $root_6 = $root_6_ph461;
    $r_2 = $r_2_ph460;
    label = 99;
    break;
   case 142:
    $cmp459 = ($cond445 | 0) == 0;
    if ($cmp459) {
      label = 143;
      break;
    } else {
      label = 144;
      break;
    }
   case 143:
    $right461 = $l_2_ph459 | 0;
    HEAP32[$right461 >> 2] = $root_6;
    $obj_addr_1 = $obj_addr_0;
    $root_7 = $108;
    $me_1 = $me_0;
    $r_3 = $r_2;
    $l_3 = $root_6;
    label = 146;
    break;
   case 144:
    $117 = $r_2 + 4 | 0;
    $_c399 = $108;
    HEAP32[$117 >> 2] = $_c399;
    $right465 = $l_2_ph459 | 0;
    HEAP32[$right465 >> 2] = $root_6;
    $hl466 = $108 + 4 | 0;
    $_left467 = $hl466;
    $118 = HEAP32[$_left467 >> 2] | 0;
    $tobool468 = ($118 | 0) == 0;
    if ($tobool468) {
      $l_3413 = $root_6;
      $r_3415 = $108;
      $me_1418 = $me_0;
      $obj_addr_1422 = $obj_addr_0;
      label = 207;
      break;
    } else {
      $root_6_ph461 = $118;
      $r_2_ph460 = $108;
      $l_2_ph459 = $root_6;
      label = 141;
      break;
    }
   case 145:
    $right474 = $l_2_ph459 | 0;
    HEAP32[$right474 >> 2] = $root_6;
    $l_3413 = $root_6;
    $r_3415 = $r_2;
    $me_1418 = $me_0;
    $obj_addr_1422 = $obj_addr_0;
    label = 207;
    break;
   case 146:
    $tobool482 = ($root_7 | 0) == 0;
    if ($tobool482) {
      $l_3413 = $l_3;
      $r_3415 = $r_3;
      $me_1418 = $me_1;
      $obj_addr_1422 = $obj_addr_1;
      label = 207;
      break;
    } else {
      label = 147;
      break;
    }
   case 147:
    $119 = HEAP32[$type5 >> 2] | 0;
    $or = $119 | 32768;
    HEAP32[$type5 >> 2] = $or;
    $hl485 = $root_7 + 4 | 0;
    $_left486 = $hl485;
    $120 = HEAP32[$_left486 >> 2] | 0;
    $right487 = $l_3 | 0;
    HEAP32[$right487 >> 2] = $120;
    $right488 = $root_7 | 0;
    $121 = HEAP32[$right488 >> 2] | 0;
    $122 = $r_3 + 4 | 0;
    $_c396 = $121;
    HEAP32[$122 >> 2] = $_c396;
    $and491 = $type & 516;
    $tobool492 = ($and491 | 0) == 0;
    if ($tobool492) {
      label = 174;
      break;
    } else {
      $root_8 = $root_7;
      label = 148;
      break;
    }
   case 148:
    $right494 = $link | 0;
    $123 = HEAP32[$right494 >> 2] | 0;
    $124 = $root_8 + 4 | 0;
    $_c391 = $123;
    HEAP32[$124 >> 2] = $_c391;
    $hl497 = $link + 4 | 0;
    $_left498 = $hl497;
    $125 = HEAP32[$_left498 >> 2] | 0;
    $right499 = $root_8 | 0;
    HEAP32[$right499 >> 2] = $125;
    $126 = HEAP32[$meth >> 2] | 0;
    $type501 = $126 + 4 | 0;
    $127 = HEAP32[$type501 >> 2] | 0;
    $and502 = $127 & 8;
    $tobool503 = ($and502 | 0) == 0;
    if ($tobool503) {
      $root_10 = $root_8;
      label = 171;
      break;
    } else {
      label = 149;
      break;
    }
   case 149:
    $and505 = $type & 516;
    $tobool506 = ($and505 | 0) == 0;
    if ($tobool506) {
      $root_10 = $root_8;
      label = 171;
      break;
    } else {
      label = 150;
      break;
    }
   case 150:
    $cmp508 = ($6 | 0) < 0;
    if ($cmp508) {
      label = 151;
      break;
    } else {
      label = 152;
      break;
    }
   case 151:
    $obj510 = $root_8 + 8 | 0;
    $128 = $obj510;
    $129 = HEAP32[$128 >> 2] | 0;
    $cond515 = $129;
    label = 153;
    break;
   case 152:
    $130 = $root_8;
    $idx_neg512 = -$6 | 0;
    $add_ptr513 = $130 + $idx_neg512 | 0;
    $cond515 = $add_ptr513;
    label = 153;
    break;
   case 153:
    $cmp516 = ($5 | 0) < 0;
    $add_ptr518 = $cond515 + $4 | 0;
    if ($cmp516) {
      label = 154;
      break;
    } else {
      $cond522 = $add_ptr518;
      label = 155;
      break;
    }
   case 154:
    $131 = $add_ptr518;
    $132 = HEAP32[$131 >> 2] | 0;
    $cond522 = $132;
    label = 155;
    break;
   case 155:
    $hl524442 = $root_8 + 4 | 0;
    $_left525443 = $hl524442;
    $133 = HEAP32[$_left525443 >> 2] | 0;
    $tobool526444 = ($133 | 0) == 0;
    if ($tobool526444) {
      $root_10 = $root_8;
      label = 171;
      break;
    } else {
      label = 156;
      break;
    }
   case 156:
    $tobool555 = ($7 | 0) == 0;
    $cmp559 = ($5 | 0) < 1;
    $idx_neg544 = -$6 | 0;
    $root_9445 = $root_8;
    $hl524446 = $hl524442;
    $134 = $133;
    label = 157;
    break;
   case 157:
    $right529436 = $134 | 0;
    $135 = HEAP32[$right529436 >> 2] | 0;
    $tobool530437 = ($135 | 0) == 0;
    if ($tobool530437) {
      $t_1_lcssa = $134;
      $right529_lcssa = $right529436;
      label = 159;
      break;
    } else {
      $t_1438 = $134;
      $right529439 = $right529436;
      $136 = $135;
      label = 158;
      break;
    }
   case 158:
    $hl532 = $136 + 4 | 0;
    $_left533 = $hl532;
    $137 = HEAP32[$_left533 >> 2] | 0;
    HEAP32[$right529439 >> 2] = $137;
    $138 = $hl532 | 0;
    $t_1_c393 = $t_1438;
    HEAP32[$138 >> 2] = $t_1_c393;
    $right529 = $136 | 0;
    $139 = HEAP32[$right529 >> 2] | 0;
    $tobool530 = ($139 | 0) == 0;
    if ($tobool530) {
      $t_1_lcssa = $136;
      $right529_lcssa = $right529;
      label = 159;
      break;
    } else {
      $t_1438 = $136;
      $right529439 = $right529;
      $136 = $139;
      label = 158;
      break;
    }
   case 159:
    $140 = $hl524446 | 0;
    $t_1_c = $t_1_lcssa;
    HEAP32[$140 >> 2] = $t_1_c;
    if ($cmp508) {
      label = 160;
      break;
    } else {
      label = 161;
      break;
    }
   case 160:
    $obj542 = $t_1_lcssa + 8 | 0;
    $141 = $obj542;
    $142 = HEAP32[$141 >> 2] | 0;
    $cond547 = $142;
    label = 162;
    break;
   case 161:
    $143 = $t_1_lcssa;
    $add_ptr545 = $143 + $idx_neg544 | 0;
    $cond547 = $add_ptr545;
    label = 162;
    break;
   case 162:
    $add_ptr550 = $cond547 + $4 | 0;
    if ($cmp516) {
      label = 163;
      break;
    } else {
      $cond554 = $add_ptr550;
      label = 164;
      break;
    }
   case 163:
    $144 = $add_ptr550;
    $145 = HEAP32[$144 >> 2] | 0;
    $cond554 = $145;
    label = 164;
    break;
   case 164:
    if ($tobool555) {
      label = 166;
      break;
    } else {
      label = 165;
      break;
    }
   case 165:
    $call557 = FUNCTION_TABLE_iiiii[$7 & 1023]($dt, $cond522, $cond554, $3) | 0;
    $cond567 = $call557;
    label = 169;
    break;
   case 166:
    if ($cmp559) {
      label = 167;
      break;
    } else {
      label = 168;
      break;
    }
   case 167:
    $call561 = _strcmp($cond522 | 0, $cond554 | 0) | 0;
    $cond567 = $call561;
    label = 169;
    break;
   case 168:
    $call563 = _memcmp($cond522 | 0, $cond554 | 0, $5 | 0) | 0;
    $cond567 = $call563;
    label = 169;
    break;
   case 169:
    $cmp568 = ($cond567 | 0) == 0;
    if ($cmp568) {
      label = 170;
      break;
    } else {
      $root_10 = $root_9445;
      label = 171;
      break;
    }
   case 170:
    $146 = HEAP32[$right529_lcssa >> 2] | 0;
    $_c392 = $146;
    HEAP32[$140 >> 2] = $_c392;
    HEAP32[$right529_lcssa >> 2] = $root_9445;
    $hl524 = $t_1_lcssa + 4 | 0;
    $_left525 = $hl524;
    $147 = HEAP32[$_left525 >> 2] | 0;
    $tobool526 = ($147 | 0) == 0;
    if ($tobool526) {
      $root_10 = $t_1_lcssa;
      label = 171;
      break;
    } else {
      $root_9445 = $t_1_lcssa;
      $hl524446 = $hl524;
      $134 = $147;
      label = 157;
      break;
    }
   case 171:
    $148 = HEAP32[$data >> 2] | 0;
    $here578 = $148 + 4 | 0;
    HEAP32[$here578 >> 2] = $root_10;
    $cmp579 = ($6 | 0) < 0;
    if ($cmp579) {
      label = 172;
      break;
    } else {
      label = 173;
      break;
    }
   case 172:
    $obj581 = $root_10 + 8 | 0;
    $149 = $obj581;
    $150 = HEAP32[$149 >> 2] | 0;
    $retval_0 = $150;
    label = 231;
    break;
   case 173:
    $151 = $root_10;
    $idx_neg583 = -$6 | 0;
    $add_ptr584 = $151 + $idx_neg583 | 0;
    $retval_0 = $add_ptr584;
    label = 231;
    break;
   case 174:
    $and588 = $type & 8;
    $tobool589 = ($and588 | 0) == 0;
    if ($tobool589) {
      label = 180;
      break;
    } else {
      label = 175;
      break;
    }
   case 175:
    $right591 = $link | 0;
    $152 = HEAP32[$right591 >> 2] | 0;
    $153 = $hl485 | 0;
    $_c398 = $152;
    HEAP32[$153 >> 2] = $_c398;
    HEAP32[$right488 >> 2] = 0;
    HEAP32[$right591 >> 2] = $root_7;
    $r_3414 = $r_3;
    $obj_addr_1421 = $obj_addr_1;
    label = 176;
    break;
   case 176:
    $hl596 = $link + 4 | 0;
    $_left597 = $hl596;
    $154 = HEAP32[$_left597 >> 2] | 0;
    $tobool598 = ($154 | 0) == 0;
    if ($tobool598) {
      $obj_addr_2_ph = $obj_addr_1421;
      $r_5_ph = $r_3414;
      label = 210;
      break;
    } else {
      label = 177;
      break;
    }
   case 177:
    $hl601453 = $154 + 4 | 0;
    $_left602454 = $hl601453;
    $155 = HEAP32[$_left602454 >> 2] | 0;
    $tobool603455 = ($155 | 0) == 0;
    if ($tobool603455) {
      $root_11_lcssa = $154;
      label = 179;
      break;
    } else {
      $root_11456 = $154;
      $hl601457 = $hl601453;
      $156 = $155;
      label = 178;
      break;
    }
   case 178:
    $right605 = $156 | 0;
    $157 = HEAP32[$right605 >> 2] | 0;
    $158 = $hl601457 | 0;
    $_c395 = $157;
    HEAP32[$158 >> 2] = $_c395;
    HEAP32[$right605 >> 2] = $root_11456;
    $hl601 = $156 + 4 | 0;
    $_left602 = $hl601;
    $159 = HEAP32[$_left602 >> 2] | 0;
    $tobool603 = ($159 | 0) == 0;
    if ($tobool603) {
      $root_11_lcssa = $156;
      label = 179;
      break;
    } else {
      $root_11456 = $156;
      $hl601457 = $hl601;
      $156 = $159;
      label = 178;
      break;
    }
   case 179:
    $right610 = $root_11_lcssa | 0;
    $160 = HEAP32[$right610 >> 2] | 0;
    $161 = $hl596 | 0;
    $_c394 = $160;
    HEAP32[$161 >> 2] = $_c394;
    $root_8 = $root_11_lcssa;
    label = 148;
    break;
   case 180:
    $and615 = $type & 16;
    $tobool616 = ($and615 | 0) == 0;
    if ($tobool616) {
      label = 186;
      break;
    } else {
      label = 181;
      break;
    }
   case 181:
    $hl618 = $link + 4 | 0;
    $_left619 = $hl618;
    $162 = HEAP32[$_left619 >> 2] | 0;
    HEAP32[$right488 >> 2] = $162;
    $163 = $hl485 | 0;
    HEAP32[$163 >> 2] = 0;
    $164 = $hl618 | 0;
    $root_7_c397 = $root_7;
    HEAP32[$164 >> 2] = $root_7_c397;
    $r_3416 = $r_3;
    $obj_addr_1424 = $obj_addr_1;
    label = 182;
    break;
   case 182:
    $right625 = $link | 0;
    $165 = HEAP32[$right625 >> 2] | 0;
    $tobool626 = ($165 | 0) == 0;
    if ($tobool626) {
      $obj_addr_2_ph = $obj_addr_1424;
      $r_5_ph = $r_3416;
      label = 210;
      break;
    } else {
      label = 183;
      break;
    }
   case 183:
    $right629448 = $165 | 0;
    $166 = HEAP32[$right629448 >> 2] | 0;
    $tobool630449 = ($166 | 0) == 0;
    if ($tobool630449) {
      $root_12_lcssa = $165;
      label = 185;
      break;
    } else {
      $root_12450 = $165;
      $right629451 = $right629448;
      $167 = $166;
      label = 184;
      break;
    }
   case 184:
    $hl632 = $167 + 4 | 0;
    $_left633 = $hl632;
    $168 = HEAP32[$_left633 >> 2] | 0;
    HEAP32[$right629451 >> 2] = $168;
    $169 = $hl632 | 0;
    $root_12_c = $root_12450;
    HEAP32[$169 >> 2] = $root_12_c;
    $right629 = $167 | 0;
    $170 = HEAP32[$right629 >> 2] | 0;
    $tobool630 = ($170 | 0) == 0;
    if ($tobool630) {
      $root_12_lcssa = $167;
      label = 185;
      break;
    } else {
      $root_12450 = $167;
      $right629451 = $right629;
      $167 = $170;
      label = 184;
      break;
    }
   case 185:
    $hl638 = $root_12_lcssa + 4 | 0;
    $_left639 = $hl638;
    $171 = HEAP32[$_left639 >> 2] | 0;
    HEAP32[$right625 >> 2] = $171;
    $root_8 = $root_12_lcssa;
    label = 148;
    break;
   case 186:
    $and643 = $type & 4098;
    $tobool644 = ($and643 | 0) == 0;
    if ($tobool644) {
      label = 197;
      break;
    } else {
      $root_13 = $root_7;
      $r_4 = $r_3;
      label = 187;
      break;
    }
   case 187:
    $cmp646 = ($6 | 0) < 0;
    if ($cmp646) {
      label = 188;
      break;
    } else {
      label = 189;
      break;
    }
   case 188:
    $obj648 = $root_13 + 8 | 0;
    $172 = $obj648;
    $173 = HEAP32[$172 >> 2] | 0;
    $cond653 = $173;
    label = 190;
    break;
   case 189:
    $174 = $root_13;
    $idx_neg650 = -$6 | 0;
    $add_ptr651 = $174 + $idx_neg650 | 0;
    $cond653 = $add_ptr651;
    label = 190;
    break;
   case 190:
    $freef654 = $3 + 16 | 0;
    $175 = HEAP32[$freef654 >> 2] | 0;
    $tobool655 = ($175 | 0) == 0;
    if ($tobool655) {
      label = 193;
      break;
    } else {
      label = 191;
      break;
    }
   case 191:
    $and657 = $type & 2;
    $tobool658 = ($and657 | 0) == 0;
    if ($tobool658) {
      label = 193;
      break;
    } else {
      label = 192;
      break;
    }
   case 192:
    FUNCTION_TABLE_viii[$175 & 1023]($dt, $cond653, $3);
    label = 193;
    break;
   case 193:
    $176 = HEAP32[$link4 >> 2] | 0;
    $cmp663 = ($176 | 0) < 0;
    if ($cmp663) {
      label = 194;
      break;
    } else {
      label = 195;
      break;
    }
   case 194:
    $memoryf665 = $dt + 12 | 0;
    $177 = HEAP32[$memoryf665 >> 2] | 0;
    $178 = $root_13;
    $call666 = FUNCTION_TABLE_iiiii[$177 & 1023]($dt, $178, 0, $3) | 0;
    label = 195;
    break;
   case 195:
    $179 = HEAP32[$data >> 2] | 0;
    $size669 = $179 + 16 | 0;
    $180 = HEAP32[$size669 >> 2] | 0;
    $sub = $180 - 1 | 0;
    HEAP32[$size669 >> 2] = $sub;
    $cmp670 = ($sub | 0) < 0;
    if ($cmp670) {
      label = 196;
      break;
    } else {
      $obj_addr_2_ph = $cond653;
      $r_5_ph = $r_4;
      label = 210;
      break;
    }
   case 196:
    $181 = HEAP32[$data >> 2] | 0;
    $size673 = $181 + 16 | 0;
    HEAP32[$size673 >> 2] = -1;
    $obj_addr_2_ph = $cond653;
    $r_5_ph = $r_4;
    label = 210;
    break;
   case 197:
    $and676 = $type & 2049;
    $tobool677 = ($and676 | 0) == 0;
    if ($tobool677) {
      label = 200;
      break;
    } else {
      label = 198;
      break;
    }
   case 198:
    $182 = HEAP32[$meth >> 2] | 0;
    $type680 = $182 + 4 | 0;
    $183 = HEAP32[$type680 >> 2] | 0;
    $and681 = $183 & 4;
    $tobool682 = ($and681 | 0) == 0;
    if ($tobool682) {
      label = 199;
      break;
    } else {
      $root_8 = $root_7;
      label = 148;
      break;
    }
   case 199:
    $184 = $hl485 | 0;
    HEAP32[$184 >> 2] = 0;
    $hl687 = $link + 4 | 0;
    $_left688 = $hl687;
    $185 = HEAP32[$_left688 >> 2] | 0;
    HEAP32[$right488 >> 2] = $185;
    $186 = $hl687 | 0;
    $root_7_c = $root_7;
    HEAP32[$186 >> 2] = $root_7_c;
    $r_3417 = $r_3;
    $root_7419 = $root_7;
    $obj_addr_1423 = $obj_addr_1;
    label = 214;
    break;
   case 200:
    $and693 = $type & 32;
    $tobool694 = ($and693 | 0) == 0;
    if ($tobool694) {
      $retval_0 = 0;
      label = 231;
      break;
    } else {
      label = 201;
      break;
    }
   case 201:
    $187 = HEAP32[$meth >> 2] | 0;
    $type697 = $187 + 4 | 0;
    $188 = HEAP32[$type697 >> 2] | 0;
    $and698 = $188 & 4;
    $tobool699 = ($and698 | 0) == 0;
    if ($tobool699) {
      label = 206;
      break;
    } else {
      label = 202;
      break;
    }
   case 202:
    $freef701 = $3 + 16 | 0;
    $189 = HEAP32[$freef701 >> 2] | 0;
    $tobool702 = ($189 | 0) == 0;
    if ($tobool702) {
      label = 204;
      break;
    } else {
      label = 203;
      break;
    }
   case 203:
    FUNCTION_TABLE_viii[$189 & 1023]($dt, $obj_addr_1, $3);
    label = 204;
    break;
   case 204:
    $190 = HEAP32[$link4 >> 2] | 0;
    $cmp707 = ($190 | 0) < 0;
    if ($cmp707) {
      label = 205;
      break;
    } else {
      $root_8 = $root_7;
      label = 148;
      break;
    }
   case 205:
    $memoryf709 = $dt + 12 | 0;
    $191 = HEAP32[$memoryf709 >> 2] | 0;
    $192 = $me_1;
    $call710 = FUNCTION_TABLE_iiiii[$191 & 1023]($dt, $192, 0, $3) | 0;
    $root_8 = $root_7;
    label = 148;
    break;
   case 206:
    $193 = $me_1 + 4 | 0;
    HEAP32[$193 >> 2] = 0;
    $hl715 = $link + 4 | 0;
    $_left716 = $hl715;
    $194 = HEAP32[$_left716 >> 2] | 0;
    $right717 = $me_1 | 0;
    HEAP32[$right717 >> 2] = $194;
    $195 = $hl715 | 0;
    $me_1_c = $me_1;
    HEAP32[$195 >> 2] = $me_1_c;
    $196 = HEAP32[$data >> 2] | 0;
    $size721 = $196 + 16 | 0;
    $197 = HEAP32[$size721 >> 2] | 0;
    $add722 = $197 + 1 | 0;
    HEAP32[$size721 >> 2] = $add722;
    $root_8 = $root_7;
    label = 148;
    break;
   case 207:
    $198 = $r_3415 + 4 | 0;
    HEAP32[$198 >> 2] = 0;
    $right733 = $l_3413 | 0;
    HEAP32[$right733 >> 2] = 0;
    $and734 = $type & 8;
    $tobool735 = ($and734 | 0) == 0;
    if ($tobool735) {
      label = 208;
      break;
    } else {
      $r_3414 = $r_3415;
      $obj_addr_1421 = $obj_addr_1422;
      label = 176;
      break;
    }
   case 208:
    $and738 = $type & 16;
    $tobool739 = ($and738 | 0) == 0;
    if ($tobool739) {
      label = 209;
      break;
    } else {
      $r_3416 = $r_3415;
      $obj_addr_1424 = $obj_addr_1422;
      label = 182;
      break;
    }
   case 209:
    $and742 = $type & 516;
    $tobool743 = ($and742 | 0) == 0;
    if ($tobool743) {
      label = 213;
      break;
    } else {
      $obj_addr_2_ph = $obj_addr_1422;
      $r_5_ph = $r_3415;
      label = 210;
      break;
    }
   case 210:
    $r_5 = $r_5_ph;
    label = 211;
    break;
   case 211:
    $hl746 = $r_5 + 4 | 0;
    $_left747 = $hl746;
    $199 = HEAP32[$_left747 >> 2] | 0;
    $tobool748 = ($199 | 0) == 0;
    if ($tobool748) {
      label = 212;
      break;
    } else {
      $r_5 = $199;
      label = 211;
      break;
    }
   case 212:
    $right751 = $link | 0;
    $200 = HEAP32[$right751 >> 2] | 0;
    $201 = $hl746 | 0;
    $_c390 = $200;
    HEAP32[$201 >> 2] = $_c390;
    $hl754 = $link + 4 | 0;
    $_left755 = $hl754;
    $202 = HEAP32[$_left755 >> 2] | 0;
    $203 = HEAP32[$data >> 2] | 0;
    $here757 = $203 + 4 | 0;
    HEAP32[$here757 >> 2] = $202;
    $and758 = $type & 2;
    $tobool759 = ($and758 | 0) != 0;
    $cond763 = $tobool759 ? $obj_addr_2_ph : 0;
    $retval_0 = $cond763;
    label = 231;
    break;
   case 213:
    $and765 = $type & 2049;
    $tobool766 = ($and765 | 0) == 0;
    if ($tobool766) {
      label = 229;
      break;
    } else {
      $r_3417 = $r_3415;
      $root_7419 = 0;
      $obj_addr_1423 = $obj_addr_1422;
      label = 214;
      break;
    }
   case 214:
    $makef = $3 + 12 | 0;
    $204 = HEAP32[$makef >> 2] | 0;
    $tobool768 = ($204 | 0) == 0;
    if ($tobool768) {
      $obj_addr_3 = $obj_addr_1423;
      label = 217;
      break;
    } else {
      label = 215;
      break;
    }
   case 215:
    $and770 = $type & 1;
    $tobool771 = ($and770 | 0) == 0;
    if ($tobool771) {
      $obj_addr_3 = $obj_addr_1423;
      label = 217;
      break;
    } else {
      label = 216;
      break;
    }
   case 216:
    $call774 = FUNCTION_TABLE_iiii[$204 & 1023]($dt, $obj_addr_1423, $3) | 0;
    $obj_addr_3 = $call774;
    label = 217;
    break;
   case 217:
    $tobool776 = ($obj_addr_3 | 0) == 0;
    if ($tobool776) {
      $root_14 = $root_7419;
      label = 226;
      break;
    } else {
      label = 218;
      break;
    }
   case 218:
    $cmp778 = ($6 | 0) > -1;
    if ($cmp778) {
      label = 219;
      break;
    } else {
      label = 220;
      break;
    }
   case 219:
    $add_ptr780 = $obj_addr_3 + $6 | 0;
    $205 = $add_ptr780;
    $root_14 = $205;
    label = 226;
    break;
   case 220:
    $memoryf782 = $dt + 12 | 0;
    $206 = HEAP32[$memoryf782 >> 2] | 0;
    $call783 = FUNCTION_TABLE_iiiii[$206 & 1023]($dt, 0, 12, $3) | 0;
    $207 = $call783;
    $tobool784 = ($call783 | 0) == 0;
    if ($tobool784) {
      label = 222;
      break;
    } else {
      label = 221;
      break;
    }
   case 221:
    $obj786 = $call783 + 8 | 0;
    $208 = $obj786;
    HEAP32[$208 >> 2] = $obj_addr_3;
    $root_14 = $207;
    label = 226;
    break;
   case 222:
    $209 = HEAP32[$makef >> 2] | 0;
    $tobool789 = ($209 | 0) == 0;
    if ($tobool789) {
      $root_14 = $207;
      label = 226;
      break;
    } else {
      label = 223;
      break;
    }
   case 223:
    $freef791 = $3 + 16 | 0;
    $210 = HEAP32[$freef791 >> 2] | 0;
    $tobool792 = ($210 | 0) == 0;
    if ($tobool792) {
      $root_14 = $207;
      label = 226;
      break;
    } else {
      label = 224;
      break;
    }
   case 224:
    $and794 = $type & 1;
    $tobool795 = ($and794 | 0) == 0;
    if ($tobool795) {
      $root_14 = $207;
      label = 226;
      break;
    } else {
      label = 225;
      break;
    }
   case 225:
    FUNCTION_TABLE_viii[$210 & 1023]($dt, $obj_addr_3, $3);
    $root_14 = $207;
    label = 226;
    break;
   case 226:
    $tobool802 = ($root_14 | 0) == 0;
    if ($tobool802) {
      $obj_addr_2_ph = $obj_addr_3;
      $r_5_ph = $r_3417;
      label = 210;
      break;
    } else {
      label = 227;
      break;
    }
   case 227:
    $211 = HEAP32[$data >> 2] | 0;
    $size805 = $211 + 16 | 0;
    $212 = HEAP32[$size805 >> 2] | 0;
    $cmp806 = ($212 | 0) > -1;
    if ($cmp806) {
      label = 228;
      break;
    } else {
      $root_8 = $root_14;
      label = 148;
      break;
    }
   case 228:
    $add810 = $212 + 1 | 0;
    HEAP32[$size805 >> 2] = $add810;
    $root_8 = $root_14;
    label = 148;
    break;
   case 229:
    $and814 = $type & 32;
    $tobool815 = ($and814 | 0) == 0;
    if ($tobool815) {
      $obj_addr_2_ph = 0;
      $r_5_ph = $r_3415;
      label = 210;
      break;
    } else {
      label = 230;
      break;
    }
   case 230:
    $213 = HEAP32[$data >> 2] | 0;
    $size818 = $213 + 16 | 0;
    $214 = HEAP32[$size818 >> 2] | 0;
    $add819 = $214 + 1 | 0;
    HEAP32[$size818 >> 2] = $add819;
    $root_8 = $me_1418;
    label = 148;
    break;
   case 231:
    STACKTOP = __stackBase__;
    return $retval_0 | 0;
  }
  return 0;
}
function _inside($inside_context, $p) {
  $inside_context = $inside_context | 0;
  $p = $p | 0;
  var $1 = 0, $sub = 0.0, $sub13 = 0.0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  $1 = HEAP32[$inside_context >> 2] | 0;
  $sub = +HEAPF64[$p >> 3] - +HEAPF64[$1 >> 3];
  $sub13 = +HEAPF64[$p + 8 >> 3] - +HEAPF64[$1 + 8 >> 3];
  STACKTOP = __stackBase__;
  return $sub * $sub + $sub13 * $sub13 <= +HEAPF64[HEAP32[$inside_context + 4 >> 2] >> 3] & 1 | 0;
}
function _dtrestore($dt, $list) {
  $dt = $dt | 0;
  $list = $list | 0;
  var $meth = 0, $0 = 0, $searchf1 = 0, $1 = 0, $data = 0, $2 = 0, $type2 = 0, $3 = 0, $and = 0, $tobool = 0, $tobool3 = 0, $here = 0, $4 = 0, $size = 0, $5 = 0, $cmp = 0, $list_addr_0 = 0, $type_0 = 0, $6 = 0, $type11 = 0, $7 = 0, $and12 = 0, $8 = 0, $type14 = 0, $9 = 0, $and15 = 0, $tobool16 = 0, $here19 = 0, $tobool20 = 0, $10 = 0, $_htab = 0, $11 = 0, $ntab = 0, $12 = 0, $add_ptr = 0, $cmp2430 = 0, $list_addr_132 = 0, $s_031 = 0, $13 = 0, $tobool25 = 0, $right = 0, $14 = 0, $list_addr_2 = 0, $incdec_ptr = 0, $cmp24 = 0, $size31 = 0, $tobool3227 = 0, $list_addr_328 = 0, $right33 = 0, $15 = 0, $16 = 0, $call = 0, $tobool32 = 0, $and38 = 0, $tobool39 = 0, $here45 = 0, $17 = 0, $18 = 0, $list_addr_0_c = 0, $tobool49 = 0, $19 = 0, $size52 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $meth = $dt + 16 | 0;
    $0 = HEAP32[$meth >> 2] | 0;
    $searchf1 = $0 | 0;
    $1 = HEAP32[$searchf1 >> 2] | 0;
    $data = $dt + 8 | 0;
    $2 = HEAP32[$data >> 2] | 0;
    $type2 = $2 | 0;
    $3 = HEAP32[$type2 >> 2] | 0;
    $and = $3 & 4096;
    $tobool = ($list | 0) == 0;
    if ($tobool) {
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 3:
    $tobool3 = ($and | 0) == 0;
    if ($tobool3) {
      $retval_0 = -1;
      label = 19;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $here = $2 + 4 | 0;
    $4 = HEAP32[$here >> 2] | 0;
    $type_0 = $and;
    $list_addr_0 = $4;
    label = 6;
    break;
   case 5:
    $size = $2 + 16 | 0;
    $5 = HEAP32[$size >> 2] | 0;
    $cmp = ($5 | 0) == 0;
    if ($cmp) {
      $type_0 = 0;
      $list_addr_0 = $list;
      label = 6;
      break;
    } else {
      $retval_0 = -1;
      label = 19;
      break;
    }
   case 6:
    $6 = HEAP32[$data >> 2] | 0;
    $type11 = $6 | 0;
    $7 = HEAP32[$type11 >> 2] | 0;
    $and12 = $7 & -4097;
    HEAP32[$type11 >> 2] = $and12;
    $8 = HEAP32[$data >> 2] | 0;
    $type14 = $8 | 0;
    $9 = HEAP32[$type14 >> 2] | 0;
    $and15 = $9 & 3;
    $tobool16 = ($and15 | 0) == 0;
    if ($tobool16) {
      label = 14;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $here19 = $8 + 4 | 0;
    HEAP32[$here19 >> 2] = 0;
    $tobool20 = ($type_0 | 0) == 0;
    $10 = HEAP32[$data >> 2] | 0;
    if ($tobool20) {
      label = 12;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $_htab = $10 + 8 | 0;
    $11 = HEAP32[$_htab >> 2] | 0;
    $ntab = $10 + 12 | 0;
    $12 = HEAP32[$ntab >> 2] | 0;
    $add_ptr = $11 + ($12 << 2) | 0;
    $cmp2430 = ($12 | 0) > 0;
    if ($cmp2430) {
      $s_031 = $11;
      $list_addr_132 = $list_addr_0;
      label = 9;
      break;
    } else {
      $retval_0 = 0;
      label = 19;
      break;
    }
   case 9:
    $13 = HEAP32[$s_031 >> 2] | 0;
    $tobool25 = ($13 | 0) == 0;
    if ($tobool25) {
      $list_addr_2 = $list_addr_132;
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    HEAP32[$s_031 >> 2] = $list_addr_132;
    $right = $13 | 0;
    $14 = HEAP32[$right >> 2] | 0;
    HEAP32[$right >> 2] = 0;
    $list_addr_2 = $14;
    label = 11;
    break;
   case 11:
    $incdec_ptr = $s_031 + 4 | 0;
    $cmp24 = $incdec_ptr >>> 0 < $add_ptr >>> 0;
    if ($cmp24) {
      $s_031 = $incdec_ptr;
      $list_addr_132 = $list_addr_2;
      label = 9;
      break;
    } else {
      $retval_0 = 0;
      label = 19;
      break;
    }
   case 12:
    $size31 = $10 + 16 | 0;
    HEAP32[$size31 >> 2] = 0;
    $tobool3227 = ($list_addr_0 | 0) == 0;
    if ($tobool3227) {
      $retval_0 = 0;
      label = 19;
      break;
    } else {
      $list_addr_328 = $list_addr_0;
      label = 13;
      break;
    }
   case 13:
    $right33 = $list_addr_328 | 0;
    $15 = HEAP32[$right33 >> 2] | 0;
    $16 = $list_addr_328;
    $call = FUNCTION_TABLE_iiii[$1 & 1023]($dt, $16, 32) | 0;
    $tobool32 = ($15 | 0) == 0;
    if ($tobool32) {
      $retval_0 = 0;
      label = 19;
      break;
    } else {
      $list_addr_328 = $15;
      label = 13;
      break;
    }
   case 14:
    $and38 = $9 & 12;
    $tobool39 = ($and38 | 0) == 0;
    $here45 = $8 + 4 | 0;
    if ($tobool39) {
      label = 16;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    HEAP32[$here45 >> 2] = $list_addr_0;
    label = 17;
    break;
   case 16:
    HEAP32[$here45 >> 2] = 0;
    $17 = HEAP32[$data >> 2] | 0;
    $18 = $17 + 8 | 0;
    $list_addr_0_c = $list_addr_0 | 0;
    HEAP32[$18 >> 2] = $list_addr_0_c;
    label = 17;
    break;
   case 17:
    $tobool49 = ($type_0 | 0) == 0;
    if ($tobool49) {
      label = 18;
      break;
    } else {
      $retval_0 = 0;
      label = 19;
      break;
    }
   case 18:
    $19 = HEAP32[$data >> 2] | 0;
    $size52 = $19 + 16 | 0;
    HEAP32[$size52 >> 2] = -1;
    $retval_0 = 0;
    label = 19;
    break;
   case 19:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtview($dt, $view) {
  $dt = $dt | 0;
  $view = $view | 0;
  var $data = 0, $0 = 0, $type = 0, $1 = 0, $and = 0, $tobool = 0, $call = 0, $tobool1 = 0, $data2 = 0, $2 = 0, $type3 = 0, $3 = 0, $and4 = 0, $tobool5 = 0, $call7 = 0, $meth = 0, $4 = 0, $meth11 = 0, $5 = 0, $cmp = 0, $tobool1423 = 0, $d_024 = 0, $cmp15 = 0, $view18 = 0, $6 = 0, $tobool14 = 0, $view19 = 0, $7 = 0, $tobool20 = 0, $nview = 0, $8 = 0, $sub = 0, $walk = 0, $meth26 = 0, $9 = 0, $searchf = 0, $10 = 0, $searchf27 = 0, $searchf30 = 0, $nview31 = 0, $11 = 0, $add = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $data = $dt + 8 | 0;
    $0 = HEAP32[$data >> 2] | 0;
    $type = $0 | 0;
    $1 = HEAP32[$type >> 2] | 0;
    $and = $1 & 4096;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $call = _dtrestore($dt, 0) | 0;
    label = 4;
    break;
   case 4:
    $tobool1 = ($view | 0) != 0;
    if ($tobool1) {
      label = 5;
      break;
    } else {
      label = 11;
      break;
    }
   case 5:
    $data2 = $view + 8 | 0;
    $2 = HEAP32[$data2 >> 2] | 0;
    $type3 = $2 | 0;
    $3 = HEAP32[$type3 >> 2] | 0;
    $and4 = $3 & 4096;
    $tobool5 = ($and4 | 0) == 0;
    if ($tobool5) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $call7 = _dtrestore($view, 0) | 0;
    label = 7;
    break;
   case 7:
    $meth = $view + 16 | 0;
    $4 = HEAP32[$meth >> 2] | 0;
    $meth11 = $dt + 16 | 0;
    $5 = HEAP32[$meth11 >> 2] | 0;
    $cmp = ($4 | 0) == ($5 | 0);
    if ($cmp) {
      label = 8;
      break;
    } else {
      $retval_0 = 0;
      label = 16;
      break;
    }
   case 8:
    $tobool1423 = ($view | 0) == 0;
    if ($tobool1423) {
      label = 11;
      break;
    } else {
      $d_024 = $view;
      label = 9;
      break;
    }
   case 9:
    $cmp15 = ($d_024 | 0) == ($dt | 0);
    if ($cmp15) {
      $retval_0 = 0;
      label = 16;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $view18 = $d_024 + 28 | 0;
    $6 = HEAP32[$view18 >> 2] | 0;
    $tobool14 = ($6 | 0) == 0;
    if ($tobool14) {
      label = 11;
      break;
    } else {
      $d_024 = $6;
      label = 9;
      break;
    }
   case 11:
    $view19 = $dt + 28 | 0;
    $7 = HEAP32[$view19 >> 2] | 0;
    $tobool20 = ($7 | 0) == 0;
    if ($tobool20) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $nview = $7 + 24 | 0;
    $8 = HEAP32[$nview >> 2] | 0;
    $sub = $8 - 1 | 0;
    HEAP32[$nview >> 2] = $sub;
    label = 13;
    break;
   case 13:
    $walk = $dt + 32 | 0;
    HEAP32[$walk >> 2] = 0;
    HEAP32[$view19 >> 2] = 0;
    if ($tobool1) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $meth26 = $dt + 16 | 0;
    $9 = HEAP32[$meth26 >> 2] | 0;
    $searchf = $9 | 0;
    $10 = HEAP32[$searchf >> 2] | 0;
    $searchf27 = $dt | 0;
    HEAP32[$searchf27 >> 2] = $10;
    $retval_0 = $7;
    label = 16;
    break;
   case 15:
    HEAP32[$view19 >> 2] = $view;
    $searchf30 = $dt | 0;
    HEAP32[$searchf30 >> 2] = 650;
    $nview31 = $view + 24 | 0;
    $11 = HEAP32[$nview31 >> 2] | 0;
    $add = $11 + 1 | 0;
    HEAP32[$nview31 >> 2] = $add;
    $retval_0 = $view;
    label = 16;
    break;
   case 16:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtvsearch($dt, $obj, $type) {
  $dt = $dt | 0;
  $obj = $obj | 0;
  $type = $type | 0;
  var $and = 0, $tobool = 0, $meth = 0, $0 = 0, $searchf = 0, $1 = 0, $call = 0, $and1 = 0, $tobool2 = 0, $and3 = 0, $tobool4 = 0, $meth5 = 0, $2 = 0, $type6 = 0, $3 = 0, $and7 = 0, $tobool8 = 0, $tobool10100 = 0, $d_0101 = 0, $meth11 = 0, $4 = 0, $searchf12 = 0, $5 = 0, $call13 = 0, $tobool14 = 0, $view = 0, $6 = 0, $tobool10 = 0, $d_0_lcssa = 0, $o_1 = 0, $walk = 0, $meth18 = 0, $7 = 0, $type19 = 0, $8 = 0, $and20 = 0, $tobool21 = 0, $and23 = 0, $tobool24 = 0, $tobool2893 = 0, $and57 = 0, $tobool58 = 0, $and62 = 0, $tobool63 = 0, $d_197 = 0, $p_096 = 0, $nk_095 = 0, $n_094 = 0, $meth30 = 0, $9 = 0, $searchf31 = 0, $10 = 0, $call32 = 0, $tobool33 = 0, $disc = 0, $11 = 0, $key = 0, $12 = 0, $size = 0, $13 = 0, $comparf = 0, $14 = 0, $cmp39 = 0, $add_ptr = 0, $15 = 0, $16 = 0, $cond = 0, $tobool41 = 0, $tobool43 = 0, $17 = 0, $call46 = 0, $cmp48 = 0, $call50 = 0, $call52 = 0, $cond56 = 0, $cmp60 = 0, $or_cond = 0, $cmp65 = 0, $or_cond80 = 0, $or_cond112 = 0, $n_1 = 0, $nk_1 = 0, $p_1 = 0, $view70 = 0, $18 = 0, $tobool28 = 0, $p_0_lcssa = 0, $n_0_lcssa = 0, $walk72 = 0, $and74 = 0, $tobool75 = 0, $walk78 = 0, $19 = 0, $tobool79 = 0, $disc82 = 0, $20 = 0, $link83 = 0, $21 = 0, $cmp84 = 0, $data = 0, $22 = 0, $here = 0, $23 = 0, $obj87 = 0, $24 = 0, $25 = 0, $26 = 0, $idx_neg = 0, $add_ptr95 = 0, $cond97 = 0, $cmp98 = 0, $tobool10191 = 0, $d_292 = 0, $meth103 = 0, $27 = 0, $searchf104 = 0, $28 = 0, $call105 = 0, $tobool106 = 0, $view110 = 0, $29 = 0, $tobool101 = 0, $obj_addr_0 = 0, $30 = 0, $meth118 = 0, $31 = 0, $searchf119 = 0, $32 = 0, $call120 = 0, $and144 = 0, $tobool145 = 0, $d_3_ph = 0, $obj_addr_1_ph = 0, $tobool12288 = 0, $cmp12482 = 0, $meth136 = 0, $obj_addr_189 = 0, $p_283 = 0, $meth127 = 0, $33 = 0, $searchf128 = 0, $34 = 0, $call129 = 0, $tobool130 = 0, $view134 = 0, $35 = 0, $cmp124 = 0, $36 = 0, $searchf137 = 0, $37 = 0, $call138 = 0, $tobool122 = 0, $view139 = 0, $38 = 0, $tobool141 = 0, $meth147 = 0, $39 = 0, $searchf148 = 0, $40 = 0, $call149 = 0, $call153 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $and = $type & 99;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $meth = $dt + 16 | 0;
    $0 = HEAP32[$meth >> 2] | 0;
    $searchf = $0 | 0;
    $1 = HEAP32[$searchf >> 2] | 0;
    $call = FUNCTION_TABLE_iiii[$1 & 1023]($dt, $obj, $type) | 0;
    $retval_0 = $call;
    label = 50;
    break;
   case 4:
    $and1 = $type & 516;
    $tobool2 = ($and1 | 0) == 0;
    if ($tobool2) {
      label = 5;
      break;
    } else {
      label = 7;
      break;
    }
   case 5:
    $and3 = $type & 384;
    $tobool4 = ($and3 | 0) == 0;
    if ($tobool4) {
      label = 11;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $meth5 = $dt + 16 | 0;
    $2 = HEAP32[$meth5 >> 2] | 0;
    $type6 = $2 + 4 | 0;
    $3 = HEAP32[$type6 >> 2] | 0;
    $and7 = $3 & 12;
    $tobool8 = ($and7 | 0) == 0;
    if ($tobool8) {
      label = 7;
      break;
    } else {
      label = 11;
      break;
    }
   case 7:
    $tobool10100 = ($dt | 0) == 0;
    if ($tobool10100) {
      $o_1 = 0;
      $d_0_lcssa = 0;
      label = 10;
      break;
    } else {
      $d_0101 = $dt;
      label = 8;
      break;
    }
   case 8:
    $meth11 = $d_0101 + 16 | 0;
    $4 = HEAP32[$meth11 >> 2] | 0;
    $searchf12 = $4 | 0;
    $5 = HEAP32[$searchf12 >> 2] | 0;
    $call13 = FUNCTION_TABLE_iiii[$5 & 1023]($d_0101, $obj, $type) | 0;
    $tobool14 = ($call13 | 0) == 0;
    if ($tobool14) {
      label = 9;
      break;
    } else {
      $o_1 = $call13;
      $d_0_lcssa = $d_0101;
      label = 10;
      break;
    }
   case 9:
    $view = $d_0101 + 28 | 0;
    $6 = HEAP32[$view >> 2] | 0;
    $tobool10 = ($6 | 0) == 0;
    if ($tobool10) {
      $o_1 = 0;
      $d_0_lcssa = 0;
      label = 10;
      break;
    } else {
      $d_0101 = $6;
      label = 8;
      break;
    }
   case 10:
    $walk = $dt + 32 | 0;
    HEAP32[$walk >> 2] = $d_0_lcssa;
    $retval_0 = $o_1;
    label = 50;
    break;
   case 11:
    $meth18 = $dt + 16 | 0;
    $7 = HEAP32[$meth18 >> 2] | 0;
    $type19 = $7 + 4 | 0;
    $8 = HEAP32[$type19 >> 2] | 0;
    $and20 = $8 & 12;
    $tobool21 = ($and20 | 0) == 0;
    if ($tobool21) {
      label = 28;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $and23 = $type & 408;
    $tobool24 = ($and23 | 0) == 0;
    if ($tobool24) {
      $retval_0 = 0;
      label = 50;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $tobool2893 = ($dt | 0) == 0;
    if ($tobool2893) {
      $n_0_lcssa = 0;
      $p_0_lcssa = 0;
      label = 27;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $and57 = $type & 136;
    $tobool58 = ($and57 | 0) != 0;
    $and62 = $type & 272;
    $tobool63 = ($and62 | 0) != 0;
    $n_094 = 0;
    $nk_095 = 0;
    $p_096 = 0;
    $d_197 = $dt;
    label = 15;
    break;
   case 15:
    $meth30 = $d_197 + 16 | 0;
    $9 = HEAP32[$meth30 >> 2] | 0;
    $searchf31 = $9 | 0;
    $10 = HEAP32[$searchf31 >> 2] | 0;
    $call32 = FUNCTION_TABLE_iiii[$10 & 1023]($d_197, $obj, $type) | 0;
    $tobool33 = ($call32 | 0) == 0;
    if ($tobool33) {
      $p_1 = $p_096;
      $nk_1 = $nk_095;
      $n_1 = $n_094;
      label = 26;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $disc = $d_197 + 4 | 0;
    $11 = HEAP32[$disc >> 2] | 0;
    $key = $11 | 0;
    $12 = HEAP32[$key >> 2] | 0;
    $size = $11 + 4 | 0;
    $13 = HEAP32[$size >> 2] | 0;
    $comparf = $11 + 20 | 0;
    $14 = HEAP32[$comparf >> 2] | 0;
    $cmp39 = ($13 | 0) < 0;
    $add_ptr = $call32 + $12 | 0;
    if ($cmp39) {
      label = 17;
      break;
    } else {
      $cond = $add_ptr;
      label = 18;
      break;
    }
   case 17:
    $15 = $add_ptr;
    $16 = HEAP32[$15 >> 2] | 0;
    $cond = $16;
    label = 18;
    break;
   case 18:
    $tobool41 = ($n_094 | 0) == 0;
    if ($tobool41) {
      label = 25;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    $tobool43 = ($14 | 0) == 0;
    if ($tobool43) {
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    $17 = HEAP32[$disc >> 2] | 0;
    $call46 = FUNCTION_TABLE_iiiii[$14 & 1023]($d_197, $cond, $nk_095, $17) | 0;
    $cond56 = $call46;
    label = 24;
    break;
   case 21:
    $cmp48 = ($13 | 0) < 1;
    if ($cmp48) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    $call50 = _strcmp($cond | 0, $nk_095 | 0) | 0;
    $cond56 = $call50;
    label = 24;
    break;
   case 23:
    $call52 = _memcmp($cond | 0, $nk_095 | 0, $13 | 0) | 0;
    $cond56 = $call52;
    label = 24;
    break;
   case 24:
    $cmp60 = ($cond56 | 0) < 0;
    $or_cond = $tobool58 & $cmp60;
    $cmp65 = ($cond56 | 0) > 0;
    $or_cond80 = $tobool63 & $cmp65;
    $or_cond112 = $or_cond | $or_cond80;
    if ($or_cond112) {
      label = 25;
      break;
    } else {
      $p_1 = $p_096;
      $nk_1 = $nk_095;
      $n_1 = $n_094;
      label = 26;
      break;
    }
   case 25:
    $p_1 = $d_197;
    $nk_1 = $cond;
    $n_1 = $call32;
    label = 26;
    break;
   case 26:
    $view70 = $d_197 + 28 | 0;
    $18 = HEAP32[$view70 >> 2] | 0;
    $tobool28 = ($18 | 0) == 0;
    if ($tobool28) {
      $n_0_lcssa = $n_1;
      $p_0_lcssa = $p_1;
      label = 27;
      break;
    } else {
      $n_094 = $n_1;
      $nk_095 = $nk_1;
      $p_096 = $p_1;
      $d_197 = $18;
      label = 15;
      break;
    }
   case 27:
    $walk72 = $dt + 32 | 0;
    HEAP32[$walk72 >> 2] = $p_0_lcssa;
    $retval_0 = $n_0_lcssa;
    label = 50;
    break;
   case 28:
    $and74 = $type & 24;
    $tobool75 = ($and74 | 0) == 0;
    if ($tobool75) {
      $retval_0 = 0;
      label = 50;
      break;
    } else {
      label = 29;
      break;
    }
   case 29:
    $walk78 = $dt + 32 | 0;
    $19 = HEAP32[$walk78 >> 2] | 0;
    $tobool79 = ($19 | 0) == 0;
    if ($tobool79) {
      label = 34;
      break;
    } else {
      label = 30;
      break;
    }
   case 30:
    $disc82 = $19 + 4 | 0;
    $20 = HEAP32[$disc82 >> 2] | 0;
    $link83 = $20 + 8 | 0;
    $21 = HEAP32[$link83 >> 2] | 0;
    $cmp84 = ($21 | 0) < 0;
    $data = $19 + 8 | 0;
    $22 = HEAP32[$data >> 2] | 0;
    $here = $22 + 4 | 0;
    $23 = HEAP32[$here >> 2] | 0;
    if ($cmp84) {
      label = 31;
      break;
    } else {
      label = 32;
      break;
    }
   case 31:
    $obj87 = $23 + 8 | 0;
    $24 = $obj87;
    $25 = HEAP32[$24 >> 2] | 0;
    $cond97 = $25;
    label = 33;
    break;
   case 32:
    $26 = $23;
    $idx_neg = -$21 | 0;
    $add_ptr95 = $26 + $idx_neg | 0;
    $cond97 = $add_ptr95;
    label = 33;
    break;
   case 33:
    $cmp98 = ($cond97 | 0) == ($obj | 0);
    if ($cmp98) {
      $obj_addr_0 = $obj;
      label = 39;
      break;
    } else {
      label = 34;
      break;
    }
   case 34:
    $tobool10191 = ($dt | 0) == 0;
    if ($tobool10191) {
      label = 38;
      break;
    } else {
      $d_292 = $dt;
      label = 35;
      break;
    }
   case 35:
    $meth103 = $d_292 + 16 | 0;
    $27 = HEAP32[$meth103 >> 2] | 0;
    $searchf104 = $27 | 0;
    $28 = HEAP32[$searchf104 >> 2] | 0;
    $call105 = FUNCTION_TABLE_iiii[$28 & 1023]($d_292, $obj, 4) | 0;
    $tobool106 = ($call105 | 0) == 0;
    if ($tobool106) {
      label = 37;
      break;
    } else {
      label = 36;
      break;
    }
   case 36:
    HEAP32[$walk78 >> 2] = $d_292;
    $obj_addr_0 = $call105;
    label = 39;
    break;
   case 37:
    $view110 = $d_292 + 28 | 0;
    $29 = HEAP32[$view110 >> 2] | 0;
    $tobool101 = ($29 | 0) == 0;
    if ($tobool101) {
      label = 38;
      break;
    } else {
      $d_292 = $29;
      label = 35;
      break;
    }
   case 38:
    HEAP32[$walk78 >> 2] = 0;
    $retval_0 = 0;
    label = 50;
    break;
   case 39:
    $30 = HEAP32[$walk78 >> 2] | 0;
    $meth118 = $30 + 16 | 0;
    $31 = HEAP32[$meth118 >> 2] | 0;
    $searchf119 = $31 | 0;
    $32 = HEAP32[$searchf119 >> 2] | 0;
    $call120 = FUNCTION_TABLE_iiii[$32 & 1023]($30, $obj_addr_0, $type) | 0;
    $and144 = $type & 8;
    $tobool145 = ($and144 | 0) == 0;
    $obj_addr_1_ph = $call120;
    $d_3_ph = $30;
    label = 40;
    break;
   case 40:
    $tobool12288 = ($obj_addr_1_ph | 0) == 0;
    if ($tobool12288) {
      label = 46;
      break;
    } else {
      label = 41;
      break;
    }
   case 41:
    $cmp12482 = ($d_3_ph | 0) == ($dt | 0);
    $meth136 = $d_3_ph + 16 | 0;
    $obj_addr_189 = $obj_addr_1_ph;
    label = 42;
    break;
   case 42:
    if ($cmp12482) {
      $retval_0 = $obj_addr_189;
      label = 50;
      break;
    } else {
      $p_283 = $dt;
      label = 43;
      break;
    }
   case 43:
    $meth127 = $p_283 + 16 | 0;
    $33 = HEAP32[$meth127 >> 2] | 0;
    $searchf128 = $33 | 0;
    $34 = HEAP32[$searchf128 >> 2] | 0;
    $call129 = FUNCTION_TABLE_iiii[$34 & 1023]($p_283, $obj_addr_189, 4) | 0;
    $tobool130 = ($call129 | 0) == 0;
    if ($tobool130) {
      label = 44;
      break;
    } else {
      label = 45;
      break;
    }
   case 44:
    $view134 = $p_283 + 28 | 0;
    $35 = HEAP32[$view134 >> 2] | 0;
    $cmp124 = ($35 | 0) == ($d_3_ph | 0);
    if ($cmp124) {
      $retval_0 = $obj_addr_189;
      label = 50;
      break;
    } else {
      $p_283 = $35;
      label = 43;
      break;
    }
   case 45:
    $36 = HEAP32[$meth136 >> 2] | 0;
    $searchf137 = $36 | 0;
    $37 = HEAP32[$searchf137 >> 2] | 0;
    $call138 = FUNCTION_TABLE_iiii[$37 & 1023]($d_3_ph, $obj_addr_189, $type) | 0;
    $tobool122 = ($call138 | 0) == 0;
    if ($tobool122) {
      label = 46;
      break;
    } else {
      $obj_addr_189 = $call138;
      label = 42;
      break;
    }
   case 46:
    $view139 = $d_3_ph + 28 | 0;
    $38 = HEAP32[$view139 >> 2] | 0;
    HEAP32[$walk78 >> 2] = $38;
    $tobool141 = ($38 | 0) == 0;
    if ($tobool141) {
      $retval_0 = 0;
      label = 50;
      break;
    } else {
      label = 47;
      break;
    }
   case 47:
    $meth147 = $38 + 16 | 0;
    $39 = HEAP32[$meth147 >> 2] | 0;
    $searchf148 = $39 | 0;
    $40 = HEAP32[$searchf148 >> 2] | 0;
    if ($tobool145) {
      label = 49;
      break;
    } else {
      label = 48;
      break;
    }
   case 48:
    $call149 = FUNCTION_TABLE_iiii[$40 & 1023]($38, 0, 128) | 0;
    $obj_addr_1_ph = $call149;
    $d_3_ph = $38;
    label = 40;
    break;
   case 49:
    $call153 = FUNCTION_TABLE_iiii[$40 & 1023]($38, 0, 256) | 0;
    $obj_addr_1_ph = $call153;
    $d_3_ph = $38;
    label = 40;
    break;
   case 50:
    return $retval_0 | 0;
  }
  return 0;
}
function _dtwalk($dt, $userf, $data) {
  $dt = $dt | 0;
  $userf = $userf | 0;
  $data = $data | 0;
  var $searchf = 0, $0 = 0, $call = 0, $walk1 = 0, $callee_knr_cast = 0, $obj_0 = 0, $tobool = 0, $1 = 0, $tobool2 = 0, $dt_ = 0, $2 = 0, $call4 = 0, $call5 = 0, $cmp = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $searchf = $dt | 0;
    $0 = HEAP32[$searchf >> 2] | 0;
    $call = FUNCTION_TABLE_iiii[$0 & 1023]($dt, 0, 128) | 0;
    $walk1 = $dt + 32 | 0;
    $callee_knr_cast = $userf;
    $obj_0 = $call;
    label = 3;
    break;
   case 3:
    $tobool = ($obj_0 | 0) == 0;
    if ($tobool) {
      $retval_0 = 0;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $1 = HEAP32[$walk1 >> 2] | 0;
    $tobool2 = ($1 | 0) == 0;
    $dt_ = $tobool2 ? $dt : $1;
    $2 = HEAP32[$searchf >> 2] | 0;
    $call4 = FUNCTION_TABLE_iiii[$2 & 1023]($dt, $obj_0, 8) | 0;
    $call5 = FUNCTION_TABLE_iiii[$callee_knr_cast & 1023]($dt_, $obj_0, $data) | 0;
    $cmp = ($call5 | 0) < 0;
    if ($cmp) {
      $retval_0 = $call5;
      label = 5;
      break;
    } else {
      $obj_0 = $call4;
      label = 3;
      break;
    }
   case 5:
    return $retval_0 | 0;
  }
  return 0;
}
function _arrow_flags($e, $sflag, $eflag) {
  $e = $e | 0;
  $sflag = $sflag | 0;
  $eflag = $eflag | 0;
  var $s0 = 0, $e0 = 0, $tail = 0, $0 = 0, $graph = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $and = 0, $5 = 0, $tobool1 = 0, $6 = 0, $index = 0, $7 = 0, $call = 0, $8 = 0, $tobool2 = 0, $9 = 0, $call10 = 0, $tobool11 = 0, $arrowdir_028_lcssa = 0, $sflag13 = 0, $10 = 0, $eflag14 = 0, $11 = 0, $12 = 0, $tobool16 = 0, $13 = 0, $cmp18 = 0, $14 = 0, $index21 = 0, $15 = 0, $call22 = 0, $16 = 0, $tobool25 = 0, $17 = 0, $tobool28 = 0, $18 = 0, $cmp30 = 0, $19 = 0, $index33 = 0, $20 = 0, $call34 = 0, $21 = 0, $tobool37 = 0, $conc_opp_flag = 0, $22 = 0, $tobool40 = 0, $head = 0, $23 = 0, $graph42 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $call45 = 0, $29 = 0, $30 = 0, $31 = 0, $or = 0, $32 = 0, $33 = 0, $or46 = 0, $call10_1 = 0, $tobool11_1 = 0, $call10_2 = 0, $tobool11_2 = 0, $cmp_3 = 0, $call10_3 = 0, $tobool11_3 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $s0 = __stackBase__ | 0;
    $e0 = __stackBase__ + 8 | 0;
    HEAP32[$sflag >> 2] = 0;
    $tail = $e + 16 | 0;
    $0 = HEAP32[$tail >> 2] | 0;
    $graph = $0 + 20 | 0;
    $1 = HEAP32[$graph >> 2] | 0;
    $2 = $1;
    $3 = HEAP32[$2 >> 2] | 0;
    $4 = $3 >>> 4;
    $and = $4 & 1;
    HEAP32[$eflag >> 2] = $and;
    $5 = HEAP32[41946] | 0;
    $tobool1 = ($5 | 0) == 0;
    if ($tobool1) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $6 = $e | 0;
    $index = $5 + 8 | 0;
    $7 = HEAP32[$index >> 2] | 0;
    $call = _agxget($6, $7) | 0;
    $8 = HEAP8[$call] | 0;
    $tobool2 = $8 << 24 >> 24 == 0;
    if ($tobool2) {
      label = 7;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $9 = HEAP8[$call] | 0;
    if (($9 << 24 >> 24 | 0) == 102) {
      label = 5;
      break;
    } else if (($9 << 24 >> 24 | 0) == 98) {
      label = 18;
      break;
    } else if (($9 << 24 >> 24 | 0) == 110) {
      label = 21;
      break;
    } else {
      label = 7;
      break;
    }
   case 5:
    $call10 = _strcmp($call | 0, 139944) | 0;
    $tobool11 = ($call10 | 0) == 0;
    if ($tobool11) {
      $arrowdir_028_lcssa = 168464;
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    $sflag13 = $arrowdir_028_lcssa + 4 | 0;
    $10 = HEAP32[$sflag13 >> 2] | 0;
    HEAP32[$sflag >> 2] = $10;
    $eflag14 = $arrowdir_028_lcssa + 8 | 0;
    $11 = HEAP32[$eflag14 >> 2] | 0;
    HEAP32[$eflag >> 2] = $11;
    label = 7;
    break;
   case 7:
    $12 = HEAP32[41964] | 0;
    $tobool16 = ($12 | 0) == 0;
    if ($tobool16) {
      label = 11;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $13 = HEAP32[$eflag >> 2] | 0;
    $cmp18 = ($13 | 0) == 1;
    if ($cmp18) {
      label = 9;
      break;
    } else {
      label = 11;
      break;
    }
   case 9:
    $14 = $e | 0;
    $index21 = $12 + 8 | 0;
    $15 = HEAP32[$index21 >> 2] | 0;
    $call22 = _agxget($14, $15) | 0;
    $16 = HEAP8[$call22] | 0;
    $tobool25 = $16 << 24 >> 24 == 0;
    if ($tobool25) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    _arrow_match_name($call22, $eflag);
    label = 11;
    break;
   case 11:
    $17 = HEAP32[41960] | 0;
    $tobool28 = ($17 | 0) == 0;
    if ($tobool28) {
      label = 15;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $18 = HEAP32[$sflag >> 2] | 0;
    $cmp30 = ($18 | 0) == 1;
    if ($cmp30) {
      label = 13;
      break;
    } else {
      label = 15;
      break;
    }
   case 13:
    $19 = $e | 0;
    $index33 = $17 + 8 | 0;
    $20 = HEAP32[$index33 >> 2] | 0;
    $call34 = _agxget($19, $20) | 0;
    $21 = HEAP8[$call34] | 0;
    $tobool37 = $21 << 24 >> 24 == 0;
    if ($tobool37) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    _arrow_match_name($call34, $sflag);
    label = 15;
    break;
   case 15:
    $conc_opp_flag = $e + 169 | 0;
    $22 = HEAP8[$conc_opp_flag] | 0;
    $tobool40 = $22 << 24 >> 24 == 0;
    if ($tobool40) {
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $head = $e + 12 | 0;
    $23 = HEAP32[$head >> 2] | 0;
    $graph42 = $23 + 20 | 0;
    $24 = HEAP32[$graph42 >> 2] | 0;
    $25 = HEAP32[$tail >> 2] | 0;
    $26 = $24;
    $27 = $23;
    $28 = $25;
    $call45 = _agfindedge($26, $27, $28) | 0;
    $29 = $call45;
    _arrow_flags($29, $s0, $e0);
    $30 = HEAP32[$eflag >> 2] | 0;
    $31 = HEAP32[$s0 >> 2] | 0;
    $or = $31 | $30;
    HEAP32[$eflag >> 2] = $or;
    $32 = HEAP32[$sflag >> 2] | 0;
    $33 = HEAP32[$e0 >> 2] | 0;
    $or46 = $33 | $32;
    HEAP32[$sflag >> 2] = $or46;
    label = 17;
    break;
   case 17:
    STACKTOP = __stackBase__;
    return;
   case 18:
    $call10_1 = _strcmp($call | 0, 137248) | 0;
    $tobool11_1 = ($call10_1 | 0) == 0;
    if ($tobool11_1) {
      $arrowdir_028_lcssa = 168476;
      label = 6;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    $call10_2 = _strcmp($call | 0, 134776) | 0;
    $tobool11_2 = ($call10_2 | 0) == 0;
    if ($tobool11_2) {
      $arrowdir_028_lcssa = 168488;
      label = 6;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    $cmp_3 = $9 << 24 >> 24 == 110;
    if ($cmp_3) {
      label = 21;
      break;
    } else {
      label = 7;
      break;
    }
   case 21:
    $call10_3 = _strcmp($call | 0, 105072) | 0;
    $tobool11_3 = ($call10_3 | 0) == 0;
    if ($tobool11_3) {
      $arrowdir_028_lcssa = 168500;
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
  }
}
function _arrow_match_name($name, $flag) {
  $name = $name | 0;
  $flag = $flag | 0;
  var $f = 0, $0 = 0, $cmp5 = 0, $i_07 = 0, $rest_06 = 0, $call = 0, $1 = 0, $mul = 0, $shl = 0, $2 = 0, $or = 0, $inc = 0, $3 = 0, $cmp = 0, $cmp2 = 0, $or_cond = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $f = __stackBase__ | 0;
    HEAP32[$flag >> 2] = 0;
    $0 = HEAP8[$name] | 0;
    $cmp5 = $0 << 24 >> 24 == 0;
    if ($cmp5) {
      label = 4;
      break;
    } else {
      $rest_06 = $name;
      $i_07 = 0;
      label = 3;
      break;
    }
   case 3:
    HEAP32[$f >> 2] = 0;
    $call = _arrow_match_shape($rest_06, $f) | 0;
    $1 = HEAP32[$f >> 2] | 0;
    $mul = $i_07 << 3;
    $shl = $1 << $mul;
    $2 = HEAP32[$flag >> 2] | 0;
    $or = $2 | $shl;
    HEAP32[$flag >> 2] = $or;
    $inc = $i_07 + 1 | 0;
    $3 = HEAP8[$call] | 0;
    $cmp = $3 << 24 >> 24 != 0;
    $cmp2 = ($inc | 0) < 4;
    $or_cond = $cmp & $cmp2;
    if ($or_cond) {
      $rest_06 = $call;
      $i_07 = $inc;
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_length($e, $flag) {
  $e = $e | 0;
  $flag = $flag | 0;
  var $and = 0, $arrowtype_0 = 0, $gen = 0, $0 = 0, $tobool = 0, $type = 0, $1 = 0, $cmp3 = 0, $incdec_ptr = 0, $lenfact4 = 0, $2 = 0.0, $add = 0.0, $lenfact_1 = 0.0, $shr_110 = 0, $and_1 = 0, $arrowtype_0_1 = 0, $gen_1 = 0, $3 = 0, $tobool_1 = 0, $type_1 = 0, $4 = 0, $cmp3_1 = 0, $incdec_ptr_1 = 0, $lenfact4_1 = 0, $5 = 0.0, $add_1 = 0.0, $lenfact_1_1 = 0.0, $shr_211 = 0, $and_2 = 0, $arrowtype_0_2 = 0, $gen_2 = 0, $6 = 0, $tobool_2 = 0, $type_2 = 0, $7 = 0, $cmp3_2 = 0, $incdec_ptr_2 = 0, $lenfact4_2 = 0, $8 = 0.0, $add_2 = 0.0, $lenfact_1_2 = 0.0, $shr_312 = 0, $and_3 = 0, $arrowtype_0_3 = 0, $gen_3 = 0, $9 = 0, $tobool_3 = 0, $type_3 = 0, $10 = 0, $cmp3_3 = 0, $incdec_ptr_3 = 0, $lenfact4_3 = 0, $11 = 0.0, $add_3 = 0.0, $lenfact_1_3 = 0.0, $mul7 = 0.0, $12 = 0, $13 = 0, $call = 0.0, $mul8 = 0.0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $and = $flag & 7;
    $arrowtype_0 = 168136;
    label = 3;
    break;
   case 3:
    $gen = $arrowtype_0 + 16 | 0;
    $0 = HEAP32[$gen >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      $lenfact_1 = 0.0;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $type = $arrowtype_0 | 0;
    $1 = HEAP32[$type >> 2] | 0;
    $cmp3 = ($and | 0) == ($1 | 0);
    $incdec_ptr = $arrowtype_0 + 24 | 0;
    if ($cmp3) {
      label = 5;
      break;
    } else {
      $arrowtype_0 = $incdec_ptr;
      label = 3;
      break;
    }
   case 5:
    $lenfact4 = $arrowtype_0 + 8 | 0;
    $2 = +HEAPF64[$lenfact4 >> 3];
    $add = $2 + 0.0;
    $lenfact_1 = $add;
    label = 6;
    break;
   case 6:
    $shr_110 = $flag >>> 8;
    $and_1 = $shr_110 & 7;
    $arrowtype_0_1 = 168136;
    label = 7;
    break;
   case 7:
    $gen_1 = $arrowtype_0_1 + 16 | 0;
    $3 = HEAP32[$gen_1 >> 2] | 0;
    $tobool_1 = ($3 | 0) == 0;
    if ($tobool_1) {
      $lenfact_1_1 = $lenfact_1;
      label = 10;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $type_1 = $arrowtype_0_1 | 0;
    $4 = HEAP32[$type_1 >> 2] | 0;
    $cmp3_1 = ($and_1 | 0) == ($4 | 0);
    $incdec_ptr_1 = $arrowtype_0_1 + 24 | 0;
    if ($cmp3_1) {
      label = 9;
      break;
    } else {
      $arrowtype_0_1 = $incdec_ptr_1;
      label = 7;
      break;
    }
   case 9:
    $lenfact4_1 = $arrowtype_0_1 + 8 | 0;
    $5 = +HEAPF64[$lenfact4_1 >> 3];
    $add_1 = $lenfact_1 + $5;
    $lenfact_1_1 = $add_1;
    label = 10;
    break;
   case 10:
    $shr_211 = $flag >>> 16;
    $and_2 = $shr_211 & 7;
    $arrowtype_0_2 = 168136;
    label = 11;
    break;
   case 11:
    $gen_2 = $arrowtype_0_2 + 16 | 0;
    $6 = HEAP32[$gen_2 >> 2] | 0;
    $tobool_2 = ($6 | 0) == 0;
    if ($tobool_2) {
      $lenfact_1_2 = $lenfact_1_1;
      label = 14;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $type_2 = $arrowtype_0_2 | 0;
    $7 = HEAP32[$type_2 >> 2] | 0;
    $cmp3_2 = ($and_2 | 0) == ($7 | 0);
    $incdec_ptr_2 = $arrowtype_0_2 + 24 | 0;
    if ($cmp3_2) {
      label = 13;
      break;
    } else {
      $arrowtype_0_2 = $incdec_ptr_2;
      label = 11;
      break;
    }
   case 13:
    $lenfact4_2 = $arrowtype_0_2 + 8 | 0;
    $8 = +HEAPF64[$lenfact4_2 >> 3];
    $add_2 = $lenfact_1_1 + $8;
    $lenfact_1_2 = $add_2;
    label = 14;
    break;
   case 14:
    $shr_312 = $flag >>> 24;
    $and_3 = $shr_312 & 7;
    $arrowtype_0_3 = 168136;
    label = 15;
    break;
   case 15:
    $gen_3 = $arrowtype_0_3 + 16 | 0;
    $9 = HEAP32[$gen_3 >> 2] | 0;
    $tobool_3 = ($9 | 0) == 0;
    if ($tobool_3) {
      $lenfact_1_3 = $lenfact_1_2;
      label = 18;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $type_3 = $arrowtype_0_3 | 0;
    $10 = HEAP32[$type_3 >> 2] | 0;
    $cmp3_3 = ($and_3 | 0) == ($10 | 0);
    $incdec_ptr_3 = $arrowtype_0_3 + 24 | 0;
    if ($cmp3_3) {
      label = 17;
      break;
    } else {
      $arrowtype_0_3 = $incdec_ptr_3;
      label = 15;
      break;
    }
   case 17:
    $lenfact4_3 = $arrowtype_0_3 + 8 | 0;
    $11 = +HEAPF64[$lenfact4_3 >> 3];
    $add_3 = $lenfact_1_2 + $11;
    $lenfact_1_3 = $add_3;
    label = 18;
    break;
   case 18:
    $mul7 = $lenfact_1_3 * 10.0;
    $12 = $e | 0;
    $13 = HEAP32[41962] | 0;
    $call = +_late_double($12, $13, 1.0, 0.0);
    $mul8 = $mul7 * $call;
    return +$mul8;
  }
  return 0.0;
}
function _arrowEndClip($e, $ps, $startp, $endp, $spl, $eflag) {
  $e = $e | 0;
  $ps = $ps | 0;
  $startp = $startp | 0;
  $endp = $endp | 0;
  $spl = $spl | 0;
  $eflag = $eflag | 0;
  var $inside_context = 0, $sp = 0, $elen2 = 0, $call = 0.0, $mul = 0.0, $eflag1 = 0, $ep = 0, $add = 0, $arrayidx = 0, $0 = 0, $1 = 0, $cmp = 0, $x = 0, $2 = 0.0, $x5 = 0, $3 = 0.0, $sub = 0.0, $mul12 = 0.0, $y = 0, $4 = 0.0, $y16 = 0, $5 = 0.0, $sub17 = 0.0, $mul24 = 0.0, $add25 = 0.0, $6 = 0.0, $cmp26 = 0, $sub27 = 0, $endp_addr_0 = 0, $arrayidx28 = 0, $arrayidx29 = 0, $7 = 0, $8 = 0, $arrayidx30 = 0, $add31 = 0, $arrayidx32 = 0, $9 = 0, $10 = 0, $arrayidx33 = 0, $add34 = 0, $arrayidx35 = 0, $11 = 0, $12 = 0, $arrayidx36 = 0, $13 = 0, $p = 0, $r = 0, $add48 = 0, $arrayidx49 = 0, $14 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 80 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $inside_context = __stackBase__ | 0;
    $sp = __stackBase__ + 8 | 0;
    $elen2 = __stackBase__ + 72 | 0;
    $call = +_arrow_length($e, $eflag);
    $mul = $call * $call;
    HEAPF64[$elen2 >> 3] = $mul;
    $eflag1 = $spl + 12 | 0;
    HEAP32[$eflag1 >> 2] = $eflag;
    $ep = $spl + 32 | 0;
    $add = $endp + 3 | 0;
    $arrayidx = $ps + ($add << 4) | 0;
    $0 = $ep;
    $1 = $arrayidx;
    HEAP32[$0 >> 2] = HEAP32[$1 >> 2] | 0;
    HEAP32[$0 + 4 >> 2] = HEAP32[$1 + 4 >> 2] | 0;
    HEAP32[$0 + 8 >> 2] = HEAP32[$1 + 8 >> 2] | 0;
    HEAP32[$0 + 12 >> 2] = HEAP32[$1 + 12 >> 2] | 0;
    $cmp = ($endp | 0) > ($startp | 0);
    if ($cmp) {
      label = 3;
      break;
    } else {
      $endp_addr_0 = $endp;
      label = 5;
      break;
    }
   case 3:
    $x = $ps + ($endp << 4) | 0;
    $2 = +HEAPF64[$x >> 3];
    $x5 = $arrayidx | 0;
    $3 = +HEAPF64[$x5 >> 3];
    $sub = $2 - $3;
    $mul12 = $sub * $sub;
    $y = $ps + ($endp << 4) + 8 | 0;
    $4 = +HEAPF64[$y >> 3];
    $y16 = $ps + ($add << 4) + 8 | 0;
    $5 = +HEAPF64[$y16 >> 3];
    $sub17 = $4 - $5;
    $mul24 = $sub17 * $sub17;
    $add25 = $mul12 + $mul24;
    $6 = +HEAPF64[$elen2 >> 3];
    $cmp26 = $add25 < $6;
    if ($cmp26) {
      label = 4;
      break;
    } else {
      $endp_addr_0 = $endp;
      label = 5;
      break;
    }
   case 4:
    $sub27 = $endp - 3 | 0;
    $endp_addr_0 = $sub27;
    label = 5;
    break;
   case 5:
    $arrayidx28 = $sp + 48 | 0;
    $arrayidx29 = $ps + ($endp_addr_0 << 4) | 0;
    $7 = $arrayidx28;
    $8 = $arrayidx29;
    HEAP32[$7 >> 2] = HEAP32[$8 >> 2] | 0;
    HEAP32[$7 + 4 >> 2] = HEAP32[$8 + 4 >> 2] | 0;
    HEAP32[$7 + 8 >> 2] = HEAP32[$8 + 8 >> 2] | 0;
    HEAP32[$7 + 12 >> 2] = HEAP32[$8 + 12 >> 2] | 0;
    $arrayidx30 = $sp + 32 | 0;
    $add31 = $endp_addr_0 + 1 | 0;
    $arrayidx32 = $ps + ($add31 << 4) | 0;
    $9 = $arrayidx30;
    $10 = $arrayidx32;
    HEAP32[$9 >> 2] = HEAP32[$10 >> 2] | 0;
    HEAP32[$9 + 4 >> 2] = HEAP32[$10 + 4 >> 2] | 0;
    HEAP32[$9 + 8 >> 2] = HEAP32[$10 + 8 >> 2] | 0;
    HEAP32[$9 + 12 >> 2] = HEAP32[$10 + 12 >> 2] | 0;
    $arrayidx33 = $sp + 16 | 0;
    $add34 = $endp_addr_0 + 2 | 0;
    $arrayidx35 = $ps + ($add34 << 4) | 0;
    $11 = $arrayidx33;
    $12 = $arrayidx35;
    HEAP32[$11 >> 2] = HEAP32[$12 >> 2] | 0;
    HEAP32[$11 + 4 >> 2] = HEAP32[$12 + 4 >> 2] | 0;
    HEAP32[$11 + 8 >> 2] = HEAP32[$12 + 8 >> 2] | 0;
    HEAP32[$11 + 12 >> 2] = HEAP32[$12 + 12 >> 2] | 0;
    $arrayidx36 = $sp | 0;
    $13 = $sp;
    HEAP32[$13 >> 2] = HEAP32[$0 >> 2] | 0;
    HEAP32[$13 + 4 >> 2] = HEAP32[$0 + 4 >> 2] | 0;
    HEAP32[$13 + 8 >> 2] = HEAP32[$0 + 8 >> 2] | 0;
    HEAP32[$13 + 12 >> 2] = HEAP32[$0 + 12 >> 2] | 0;
    $p = $inside_context | 0;
    HEAP32[$p >> 2] = $arrayidx36;
    $r = $inside_context + 4 | 0;
    HEAP32[$r >> 2] = $elen2;
    _bezier_clip($inside_context, 600, $arrayidx36, 1);
    HEAP32[$8 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$8 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$8 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$8 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    HEAP32[$10 >> 2] = HEAP32[$9 >> 2] | 0;
    HEAP32[$10 + 4 >> 2] = HEAP32[$9 + 4 >> 2] | 0;
    HEAP32[$10 + 8 >> 2] = HEAP32[$9 + 8 >> 2] | 0;
    HEAP32[$10 + 12 >> 2] = HEAP32[$9 + 12 >> 2] | 0;
    HEAP32[$12 >> 2] = HEAP32[$11 >> 2] | 0;
    HEAP32[$12 + 4 >> 2] = HEAP32[$11 + 4 >> 2] | 0;
    HEAP32[$12 + 8 >> 2] = HEAP32[$11 + 8 >> 2] | 0;
    HEAP32[$12 + 12 >> 2] = HEAP32[$11 + 12 >> 2] | 0;
    $add48 = $endp_addr_0 + 3 | 0;
    $arrayidx49 = $ps + ($add48 << 4) | 0;
    $14 = $arrayidx49;
    HEAP32[$14 >> 2] = HEAP32[$13 >> 2] | 0;
    HEAP32[$14 + 4 >> 2] = HEAP32[$13 + 4 >> 2] | 0;
    HEAP32[$14 + 8 >> 2] = HEAP32[$13 + 8 >> 2] | 0;
    HEAP32[$14 + 12 >> 2] = HEAP32[$13 + 12 >> 2] | 0;
    STACKTOP = __stackBase__;
    return $endp_addr_0 | 0;
  }
  return 0;
}
function _arrowStartClip($e, $ps, $startp, $endp, $spl, $sflag) {
  $e = $e | 0;
  $ps = $ps | 0;
  $startp = $startp | 0;
  $endp = $endp | 0;
  $spl = $spl | 0;
  $sflag = $sflag | 0;
  var $inside_context = 0, $sp = 0, $slen2 = 0, $call = 0.0, $mul = 0.0, $sflag1 = 0, $sp2 = 0, $arrayidx = 0, $0 = 0, $1 = 0, $cmp = 0, $x = 0, $2 = 0.0, $add = 0, $x5 = 0, $3 = 0.0, $sub = 0.0, $mul12 = 0.0, $y = 0, $4 = 0.0, $y16 = 0, $5 = 0.0, $sub17 = 0.0, $mul24 = 0.0, $add25 = 0.0, $6 = 0.0, $cmp26 = 0, $startp_addr_0 = 0, $arrayidx28 = 0, $add29 = 0, $arrayidx30 = 0, $7 = 0, $8 = 0, $arrayidx31 = 0, $add32 = 0, $arrayidx33 = 0, $9 = 0, $10 = 0, $arrayidx34 = 0, $add35 = 0, $arrayidx36 = 0, $11 = 0, $12 = 0, $arrayidx37 = 0, $13 = 0, $p = 0, $r = 0, $arrayidx41 = 0, $14 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 80 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $inside_context = __stackBase__ | 0;
    $sp = __stackBase__ + 8 | 0;
    $slen2 = __stackBase__ + 72 | 0;
    $call = +_arrow_length($e, $sflag);
    $mul = $call * $call;
    HEAPF64[$slen2 >> 3] = $mul;
    $sflag1 = $spl + 8 | 0;
    HEAP32[$sflag1 >> 2] = $sflag;
    $sp2 = $spl + 16 | 0;
    $arrayidx = $ps + ($startp << 4) | 0;
    $0 = $sp2;
    $1 = $arrayidx;
    HEAP32[$0 >> 2] = HEAP32[$1 >> 2] | 0;
    HEAP32[$0 + 4 >> 2] = HEAP32[$1 + 4 >> 2] | 0;
    HEAP32[$0 + 8 >> 2] = HEAP32[$1 + 8 >> 2] | 0;
    HEAP32[$0 + 12 >> 2] = HEAP32[$1 + 12 >> 2] | 0;
    $cmp = ($endp | 0) > ($startp | 0);
    if ($cmp) {
      label = 3;
      break;
    } else {
      $startp_addr_0 = $startp;
      label = 5;
      break;
    }
   case 3:
    $x = $arrayidx | 0;
    $2 = +HEAPF64[$x >> 3];
    $add = $startp + 3 | 0;
    $x5 = $ps + ($add << 4) | 0;
    $3 = +HEAPF64[$x5 >> 3];
    $sub = $2 - $3;
    $mul12 = $sub * $sub;
    $y = $ps + ($startp << 4) + 8 | 0;
    $4 = +HEAPF64[$y >> 3];
    $y16 = $ps + ($add << 4) + 8 | 0;
    $5 = +HEAPF64[$y16 >> 3];
    $sub17 = $4 - $5;
    $mul24 = $sub17 * $sub17;
    $add25 = $mul12 + $mul24;
    $6 = +HEAPF64[$slen2 >> 3];
    $cmp26 = $add25 < $6;
    if ($cmp26) {
      label = 4;
      break;
    } else {
      $startp_addr_0 = $startp;
      label = 5;
      break;
    }
   case 4:
    $startp_addr_0 = $add;
    label = 5;
    break;
   case 5:
    $arrayidx28 = $sp | 0;
    $add29 = $startp_addr_0 + 3 | 0;
    $arrayidx30 = $ps + ($add29 << 4) | 0;
    $7 = $sp;
    $8 = $arrayidx30;
    HEAP32[$7 >> 2] = HEAP32[$8 >> 2] | 0;
    HEAP32[$7 + 4 >> 2] = HEAP32[$8 + 4 >> 2] | 0;
    HEAP32[$7 + 8 >> 2] = HEAP32[$8 + 8 >> 2] | 0;
    HEAP32[$7 + 12 >> 2] = HEAP32[$8 + 12 >> 2] | 0;
    $arrayidx31 = $sp + 16 | 0;
    $add32 = $startp_addr_0 + 2 | 0;
    $arrayidx33 = $ps + ($add32 << 4) | 0;
    $9 = $arrayidx31;
    $10 = $arrayidx33;
    HEAP32[$9 >> 2] = HEAP32[$10 >> 2] | 0;
    HEAP32[$9 + 4 >> 2] = HEAP32[$10 + 4 >> 2] | 0;
    HEAP32[$9 + 8 >> 2] = HEAP32[$10 + 8 >> 2] | 0;
    HEAP32[$9 + 12 >> 2] = HEAP32[$10 + 12 >> 2] | 0;
    $arrayidx34 = $sp + 32 | 0;
    $add35 = $startp_addr_0 + 1 | 0;
    $arrayidx36 = $ps + ($add35 << 4) | 0;
    $11 = $arrayidx34;
    $12 = $arrayidx36;
    HEAP32[$11 >> 2] = HEAP32[$12 >> 2] | 0;
    HEAP32[$11 + 4 >> 2] = HEAP32[$12 + 4 >> 2] | 0;
    HEAP32[$11 + 8 >> 2] = HEAP32[$12 + 8 >> 2] | 0;
    HEAP32[$11 + 12 >> 2] = HEAP32[$12 + 12 >> 2] | 0;
    $arrayidx37 = $sp + 48 | 0;
    $13 = $arrayidx37;
    HEAP32[$13 >> 2] = HEAP32[$0 >> 2] | 0;
    HEAP32[$13 + 4 >> 2] = HEAP32[$0 + 4 >> 2] | 0;
    HEAP32[$13 + 8 >> 2] = HEAP32[$0 + 8 >> 2] | 0;
    HEAP32[$13 + 12 >> 2] = HEAP32[$0 + 12 >> 2] | 0;
    $p = $inside_context | 0;
    HEAP32[$p >> 2] = $arrayidx37;
    $r = $inside_context + 4 | 0;
    HEAP32[$r >> 2] = $slen2;
    _bezier_clip($inside_context, 600, $arrayidx28, 0);
    $arrayidx41 = $ps + ($startp_addr_0 << 4) | 0;
    $14 = $arrayidx41;
    HEAP32[$14 >> 2] = HEAP32[$13 >> 2] | 0;
    HEAP32[$14 + 4 >> 2] = HEAP32[$13 + 4 >> 2] | 0;
    HEAP32[$14 + 8 >> 2] = HEAP32[$13 + 8 >> 2] | 0;
    HEAP32[$14 + 12 >> 2] = HEAP32[$13 + 12 >> 2] | 0;
    HEAP32[$12 >> 2] = HEAP32[$11 >> 2] | 0;
    HEAP32[$12 + 4 >> 2] = HEAP32[$11 + 4 >> 2] | 0;
    HEAP32[$12 + 8 >> 2] = HEAP32[$11 + 8 >> 2] | 0;
    HEAP32[$12 + 12 >> 2] = HEAP32[$11 + 12 >> 2] | 0;
    HEAP32[$10 >> 2] = HEAP32[$9 >> 2] | 0;
    HEAP32[$10 + 4 >> 2] = HEAP32[$9 + 4 >> 2] | 0;
    HEAP32[$10 + 8 >> 2] = HEAP32[$9 + 8 >> 2] | 0;
    HEAP32[$10 + 12 >> 2] = HEAP32[$9 + 12 >> 2] | 0;
    HEAP32[$8 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$8 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$8 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$8 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    STACKTOP = __stackBase__;
    return $startp_addr_0 | 0;
  }
  return 0;
}
function _arrowOrthoClip($e, $ps, $startp, $endp, $spl, $sflag, $eflag) {
  $e = $e | 0;
  $ps = $ps | 0;
  $startp = $startp | 0;
  $endp = $endp | 0;
  $spl = $spl | 0;
  $sflag = $sflag | 0;
  $eflag = $eflag | 0;
  var $tobool = 0, $tobool1 = 0, $tobool1_not = 0, $or_cond_not = 0, $cmp = 0, $or_cond174 = 0, $arrayidx = 0, $p_sroa_0_0__idx93 = 0, $p_sroa_0_0_copyload94 = 0.0, $p_sroa_1_8__idx121 = 0, $p_sroa_1_8_copyload122 = 0.0, $add = 0, $arrayidx3 = 0, $q_sroa_0_0__idx45 = 0, $q_sroa_0_0_copyload46 = 0.0, $q_sroa_1_8__idx69 = 0, $q_sroa_1_8_copyload70 = 0.0, $call = 0.0, $call4 = 0.0, $sub = 0.0, $mul = 0.0, $sub10 = 0.0, $mul14 = 0.0, $add15 = 0.0, $call16 = 0.0, $add17 = 0.0, $cmp18 = 0, $div = 0.0, $tlen_0 = 0.0, $hlen_0 = 0.0, $cmp22 = 0, $cmp29 = 0, $sub32 = 0.0, $add35 = 0.0, $add38 = 0.0, $sub41 = 0.0, $cmp50 = 0, $sub53 = 0.0, $add56 = 0.0, $add60 = 0.0, $sub63 = 0.0, $s_sroa_1_0 = 0.0, $s_sroa_0_0 = 0.0, $t_sroa_1_0 = 0.0, $t_sroa_0_0 = 0.0, $add68 = 0, $arrayidx69 = 0, $s_sroa_0_0__idx = 0, $s_sroa_1_8__idx21 = 0, $0 = 0, $1 = 0, $add70 = 0, $arrayidx71 = 0, $2 = 0, $3 = 0, $eflag74 = 0, $p_sroa_0_0__idx85 = 0, $p_sroa_1_8__idx112 = 0, $sflag75 = 0, $call80 = 0.0, $p_sroa_0_0__idx83 = 0, $p_sroa_0_0_copyload84 = 0.0, $p_sroa_1_8__idx110 = 0, $p_sroa_1_8_copyload111 = 0.0, $add82 = 0, $arrayidx83 = 0, $q_sroa_0_0__idx37 = 0, $q_sroa_0_0_copyload38 = 0.0, $q_sroa_1_8__idx60 = 0, $q_sroa_1_8_copyload61 = 0.0, $sub86 = 0.0, $mul90 = 0.0, $sub93 = 0.0, $mul97 = 0.0, $add98 = 0.0, $call99 = 0.0, $mul100 = 0.0, $cmp101 = 0, $hlen_1 = 0.0, $cmp106 = 0, $cmp112 = 0, $sub115 = 0.0, $add119 = 0.0, $cmp127 = 0, $sub130 = 0.0, $add134 = 0.0, $r_sroa_1_0 = 0.0, $r_sroa_0_0 = 0.0, $add138 = 0, $p_sroa_0_0__idx77 = 0, $p_sroa_1_8__idx103 = 0, $add140 = 0, $arrayidx141 = 0, $4 = 0, $5 = 0, $eflag144 = 0, $q_sroa_0_0__idx31 = 0, $q_sroa_1_8__idx53 = 0, $hlen_2 = 0.0, $call149 = 0.0, $arrayidx150 = 0, $p_sroa_0_0__idx75 = 0, $p_sroa_0_0_copyload76 = 0.0, $p_sroa_1_8__idx101 = 0, $p_sroa_1_8_copyload102 = 0.0, $add151 = 0, $q_sroa_0_0__idx29 = 0, $q_sroa_0_0_copyload30 = 0.0, $q_sroa_1_8__idx51 = 0, $q_sroa_1_8_copyload52 = 0.0, $sub155 = 0.0, $mul159 = 0.0, $sub162 = 0.0, $mul166 = 0.0, $add167 = 0.0, $call168 = 0.0, $mul169 = 0.0, $cmp170 = 0, $tlen_1 = 0.0, $cmp175 = 0, $cmp181 = 0, $add184 = 0.0, $sub188 = 0.0, $cmp196 = 0, $add199 = 0.0, $sub203 = 0.0, $r_sroa_1_1 = 0.0, $r_sroa_0_1 = 0.0, $add208 = 0, $arrayidx209 = 0, $r_sroa_0_0__idx = 0, $r_sroa_1_8__idx24 = 0, $6 = 0, $7 = 0, $add210 = 0, $q_sroa_0_0__idx = 0, $q_sroa_1_8__idx47 = 0, $sflag212 = 0, $p_sroa_0_0__idx = 0, $p_sroa_1_8__idx95 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tobool = ($sflag | 0) != 0;
    $tobool1 = ($eflag | 0) == 0;
    $tobool1_not = $tobool1 ^ 1;
    $or_cond_not = $tobool & $tobool1_not;
    $cmp = ($endp | 0) == ($startp | 0);
    $or_cond174 = $or_cond_not & $cmp;
    if ($or_cond174) {
      label = 3;
      break;
    } else {
      label = 13;
      break;
    }
   case 3:
    $arrayidx = $ps + ($endp << 4) | 0;
    $p_sroa_0_0__idx93 = $arrayidx | 0;
    $p_sroa_0_0_copyload94 = +HEAPF64[$p_sroa_0_0__idx93 >> 3];
    $p_sroa_1_8__idx121 = $ps + ($endp << 4) + 8 | 0;
    $p_sroa_1_8_copyload122 = +HEAPF64[$p_sroa_1_8__idx121 >> 3];
    $add = $endp + 3 | 0;
    $arrayidx3 = $ps + ($add << 4) | 0;
    $q_sroa_0_0__idx45 = $arrayidx3 | 0;
    $q_sroa_0_0_copyload46 = +HEAPF64[$q_sroa_0_0__idx45 >> 3];
    $q_sroa_1_8__idx69 = $ps + ($add << 4) + 8 | 0;
    $q_sroa_1_8_copyload70 = +HEAPF64[$q_sroa_1_8__idx69 >> 3];
    $call = +_arrow_length($e, $sflag);
    $call4 = +_arrow_length($e, $eflag);
    $sub = $p_sroa_0_0_copyload94 - $q_sroa_0_0_copyload46;
    $mul = $sub * $sub;
    $sub10 = $p_sroa_1_8_copyload122 - $q_sroa_1_8_copyload70;
    $mul14 = $sub10 * $sub10;
    $add15 = $mul + $mul14;
    $call16 = +Math_sqrt(+$add15);
    $add17 = $call + $call4;
    $cmp18 = $add17 < $call16;
    if ($cmp18) {
      $hlen_0 = $call4;
      $tlen_0 = $call;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $div = $call16 / 3.0;
    $hlen_0 = $div;
    $tlen_0 = $div;
    label = 5;
    break;
   case 5:
    $cmp22 = $p_sroa_1_8_copyload122 == $q_sroa_1_8_copyload70;
    if ($cmp22) {
      label = 6;
      break;
    } else {
      label = 9;
      break;
    }
   case 6:
    $cmp29 = $p_sroa_0_0_copyload94 < $q_sroa_0_0_copyload46;
    if ($cmp29) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    $sub32 = $q_sroa_0_0_copyload46 - $hlen_0;
    $add35 = $p_sroa_0_0_copyload94 + $tlen_0;
    $t_sroa_0_0 = $sub32;
    $t_sroa_1_0 = $p_sroa_1_8_copyload122;
    $s_sroa_0_0 = $add35;
    $s_sroa_1_0 = $p_sroa_1_8_copyload122;
    label = 12;
    break;
   case 8:
    $add38 = $q_sroa_0_0_copyload46 + $hlen_0;
    $sub41 = $p_sroa_0_0_copyload94 - $tlen_0;
    $t_sroa_0_0 = $add38;
    $t_sroa_1_0 = $p_sroa_1_8_copyload122;
    $s_sroa_0_0 = $sub41;
    $s_sroa_1_0 = $p_sroa_1_8_copyload122;
    label = 12;
    break;
   case 9:
    $cmp50 = $p_sroa_1_8_copyload122 < $q_sroa_1_8_copyload70;
    if ($cmp50) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    $sub53 = $q_sroa_1_8_copyload70 - $hlen_0;
    $add56 = $p_sroa_1_8_copyload122 + $tlen_0;
    $t_sroa_0_0 = $p_sroa_0_0_copyload94;
    $t_sroa_1_0 = $sub53;
    $s_sroa_0_0 = $p_sroa_0_0_copyload94;
    $s_sroa_1_0 = $add56;
    label = 12;
    break;
   case 11:
    $add60 = $q_sroa_1_8_copyload70 + $hlen_0;
    $sub63 = $p_sroa_1_8_copyload122 - $tlen_0;
    $t_sroa_0_0 = $p_sroa_0_0_copyload94;
    $t_sroa_1_0 = $add60;
    $s_sroa_0_0 = $p_sroa_0_0_copyload94;
    $s_sroa_1_0 = $sub63;
    label = 12;
    break;
   case 12:
    $add68 = $endp + 1 | 0;
    $arrayidx69 = $ps + ($add68 << 4) | 0;
    $s_sroa_0_0__idx = $arrayidx69 | 0;
    HEAPF64[$s_sroa_0_0__idx >> 3] = $s_sroa_0_0;
    $s_sroa_1_8__idx21 = $ps + ($add68 << 4) + 8 | 0;
    HEAPF64[$s_sroa_1_8__idx21 >> 3] = $s_sroa_1_0;
    $0 = $arrayidx;
    $1 = $arrayidx69;
    HEAP32[$0 >> 2] = HEAP32[$1 >> 2] | 0;
    HEAP32[$0 + 4 >> 2] = HEAP32[$1 + 4 >> 2] | 0;
    HEAP32[$0 + 8 >> 2] = HEAP32[$1 + 8 >> 2] | 0;
    HEAP32[$0 + 12 >> 2] = HEAP32[$1 + 12 >> 2] | 0;
    $add70 = $endp + 2 | 0;
    $arrayidx71 = $ps + ($add70 << 4) | 0;
    HEAPF64[$q_sroa_0_0__idx45 >> 3] = $t_sroa_0_0;
    HEAPF64[$q_sroa_1_8__idx69 >> 3] = $t_sroa_1_0;
    $2 = $arrayidx71;
    $3 = $arrayidx3;
    HEAP32[$2 >> 2] = HEAP32[$3 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$3 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$3 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$3 + 12 >> 2] | 0;
    $eflag74 = $spl + 12 | 0;
    HEAP32[$eflag74 >> 2] = $eflag;
    $p_sroa_0_0__idx85 = $spl + 32 | 0;
    $p_sroa_1_8__idx112 = $spl + 40 | 0;
    $sflag75 = $spl + 8 | 0;
    HEAP32[$sflag75 >> 2] = $sflag;
    HEAPF64[$p_sroa_0_0__idx85 >> 3] = $q_sroa_0_0_copyload46;
    HEAPF64[$p_sroa_1_8__idx112 >> 3] = $q_sroa_1_8_copyload70;
    label = 31;
    break;
   case 13:
    if ($tobool1) {
      $hlen_2 = 0.0;
      label = 22;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $call80 = +_arrow_length($e, $eflag);
    $p_sroa_0_0__idx83 = $ps + ($endp << 4) | 0;
    $p_sroa_0_0_copyload84 = +HEAPF64[$p_sroa_0_0__idx83 >> 3];
    $p_sroa_1_8__idx110 = $ps + ($endp << 4) + 8 | 0;
    $p_sroa_1_8_copyload111 = +HEAPF64[$p_sroa_1_8__idx110 >> 3];
    $add82 = $endp + 3 | 0;
    $arrayidx83 = $ps + ($add82 << 4) | 0;
    $q_sroa_0_0__idx37 = $arrayidx83 | 0;
    $q_sroa_0_0_copyload38 = +HEAPF64[$q_sroa_0_0__idx37 >> 3];
    $q_sroa_1_8__idx60 = $ps + ($add82 << 4) + 8 | 0;
    $q_sroa_1_8_copyload61 = +HEAPF64[$q_sroa_1_8__idx60 >> 3];
    $sub86 = $p_sroa_0_0_copyload84 - $q_sroa_0_0_copyload38;
    $mul90 = $sub86 * $sub86;
    $sub93 = $p_sroa_1_8_copyload111 - $q_sroa_1_8_copyload61;
    $mul97 = $sub93 * $sub93;
    $add98 = $mul90 + $mul97;
    $call99 = +Math_sqrt(+$add98);
    $mul100 = $call99 * .9;
    $cmp101 = $call80 < $mul100;
    $hlen_1 = $cmp101 ? $call80 : $mul100;
    $cmp106 = $p_sroa_1_8_copyload111 == $q_sroa_1_8_copyload61;
    if ($cmp106) {
      label = 15;
      break;
    } else {
      label = 18;
      break;
    }
   case 15:
    $cmp112 = $p_sroa_0_0_copyload84 < $q_sroa_0_0_copyload38;
    if ($cmp112) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    $sub115 = $q_sroa_0_0_copyload38 - $hlen_1;
    $r_sroa_0_0 = $sub115;
    $r_sroa_1_0 = $p_sroa_1_8_copyload111;
    label = 21;
    break;
   case 17:
    $add119 = $q_sroa_0_0_copyload38 + $hlen_1;
    $r_sroa_0_0 = $add119;
    $r_sroa_1_0 = $p_sroa_1_8_copyload111;
    label = 21;
    break;
   case 18:
    $cmp127 = $p_sroa_1_8_copyload111 < $q_sroa_1_8_copyload61;
    if ($cmp127) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    $sub130 = $q_sroa_1_8_copyload61 - $hlen_1;
    $r_sroa_0_0 = $p_sroa_0_0_copyload84;
    $r_sroa_1_0 = $sub130;
    label = 21;
    break;
   case 20:
    $add134 = $q_sroa_1_8_copyload61 + $hlen_1;
    $r_sroa_0_0 = $p_sroa_0_0_copyload84;
    $r_sroa_1_0 = $add134;
    label = 21;
    break;
   case 21:
    $add138 = $endp + 1 | 0;
    $p_sroa_0_0__idx77 = $ps + ($add138 << 4) | 0;
    HEAPF64[$p_sroa_0_0__idx77 >> 3] = $p_sroa_0_0_copyload84;
    $p_sroa_1_8__idx103 = $ps + ($add138 << 4) + 8 | 0;
    HEAPF64[$p_sroa_1_8__idx103 >> 3] = $p_sroa_1_8_copyload111;
    $add140 = $endp + 2 | 0;
    $arrayidx141 = $ps + ($add140 << 4) | 0;
    HEAPF64[$q_sroa_0_0__idx37 >> 3] = $r_sroa_0_0;
    HEAPF64[$q_sroa_1_8__idx60 >> 3] = $r_sroa_1_0;
    $4 = $arrayidx141;
    $5 = $arrayidx83;
    HEAP32[$4 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$4 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$4 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$4 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    $eflag144 = $spl + 12 | 0;
    HEAP32[$eflag144 >> 2] = $eflag;
    $q_sroa_0_0__idx31 = $spl + 32 | 0;
    HEAPF64[$q_sroa_0_0__idx31 >> 3] = $q_sroa_0_0_copyload38;
    $q_sroa_1_8__idx53 = $spl + 40 | 0;
    HEAPF64[$q_sroa_1_8__idx53 >> 3] = $q_sroa_1_8_copyload61;
    $hlen_2 = $hlen_1;
    label = 22;
    break;
   case 22:
    if ($tobool) {
      label = 23;
      break;
    } else {
      label = 31;
      break;
    }
   case 23:
    $call149 = +_arrow_length($e, $sflag);
    $arrayidx150 = $ps + ($startp << 4) | 0;
    $p_sroa_0_0__idx75 = $arrayidx150 | 0;
    $p_sroa_0_0_copyload76 = +HEAPF64[$p_sroa_0_0__idx75 >> 3];
    $p_sroa_1_8__idx101 = $ps + ($startp << 4) + 8 | 0;
    $p_sroa_1_8_copyload102 = +HEAPF64[$p_sroa_1_8__idx101 >> 3];
    $add151 = $startp + 3 | 0;
    $q_sroa_0_0__idx29 = $ps + ($add151 << 4) | 0;
    $q_sroa_0_0_copyload30 = +HEAPF64[$q_sroa_0_0__idx29 >> 3];
    $q_sroa_1_8__idx51 = $ps + ($add151 << 4) + 8 | 0;
    $q_sroa_1_8_copyload52 = +HEAPF64[$q_sroa_1_8__idx51 >> 3];
    $sub155 = $p_sroa_0_0_copyload76 - $q_sroa_0_0_copyload30;
    $mul159 = $sub155 * $sub155;
    $sub162 = $p_sroa_1_8_copyload102 - $q_sroa_1_8_copyload52;
    $mul166 = $sub162 * $sub162;
    $add167 = $mul159 + $mul166;
    $call168 = +Math_sqrt(+$add167);
    $mul169 = $call168 * .9;
    $cmp170 = $call149 < $mul169;
    $tlen_1 = $cmp170 ? $call149 : $mul169;
    $cmp175 = $p_sroa_1_8_copyload102 == $q_sroa_1_8_copyload52;
    if ($cmp175) {
      label = 24;
      break;
    } else {
      label = 27;
      break;
    }
   case 24:
    $cmp181 = $p_sroa_0_0_copyload76 < $q_sroa_0_0_copyload30;
    if ($cmp181) {
      label = 25;
      break;
    } else {
      label = 26;
      break;
    }
   case 25:
    $add184 = $p_sroa_0_0_copyload76 + $tlen_1;
    $r_sroa_0_1 = $add184;
    $r_sroa_1_1 = $p_sroa_1_8_copyload102;
    label = 30;
    break;
   case 26:
    $sub188 = $p_sroa_0_0_copyload76 - $hlen_2;
    $r_sroa_0_1 = $sub188;
    $r_sroa_1_1 = $p_sroa_1_8_copyload102;
    label = 30;
    break;
   case 27:
    $cmp196 = $p_sroa_1_8_copyload102 < $q_sroa_1_8_copyload52;
    if ($cmp196) {
      label = 28;
      break;
    } else {
      label = 29;
      break;
    }
   case 28:
    $add199 = $hlen_2 + $p_sroa_1_8_copyload102;
    $r_sroa_0_1 = $p_sroa_0_0_copyload76;
    $r_sroa_1_1 = $add199;
    label = 30;
    break;
   case 29:
    $sub203 = $p_sroa_1_8_copyload102 - $hlen_2;
    $r_sroa_0_1 = $p_sroa_0_0_copyload76;
    $r_sroa_1_1 = $sub203;
    label = 30;
    break;
   case 30:
    $add208 = $startp + 1 | 0;
    $arrayidx209 = $ps + ($add208 << 4) | 0;
    $r_sroa_0_0__idx = $arrayidx209 | 0;
    HEAPF64[$r_sroa_0_0__idx >> 3] = $r_sroa_0_1;
    $r_sroa_1_8__idx24 = $ps + ($add208 << 4) + 8 | 0;
    HEAPF64[$r_sroa_1_8__idx24 >> 3] = $r_sroa_1_1;
    $6 = $arrayidx150;
    $7 = $arrayidx209;
    HEAP32[$6 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    $add210 = $startp + 2 | 0;
    $q_sroa_0_0__idx = $ps + ($add210 << 4) | 0;
    HEAPF64[$q_sroa_0_0__idx >> 3] = $q_sroa_0_0_copyload30;
    $q_sroa_1_8__idx47 = $ps + ($add210 << 4) + 8 | 0;
    HEAPF64[$q_sroa_1_8__idx47 >> 3] = $q_sroa_1_8_copyload52;
    $sflag212 = $spl + 8 | 0;
    HEAP32[$sflag212 >> 2] = $sflag;
    $p_sroa_0_0__idx = $spl + 16 | 0;
    HEAPF64[$p_sroa_0_0__idx >> 3] = $p_sroa_0_0_copyload76;
    $p_sroa_1_8__idx95 = $spl + 24 | 0;
    HEAPF64[$p_sroa_1_8__idx95 >> 3] = $p_sroa_1_8_copyload102;
    label = 31;
    break;
   case 31:
    return;
  }
}
function _arrow_bb($agg_result, $p, $u, $arrowsize, $flag) {
  $agg_result = $agg_result | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $flag = $flag | 0;
  var $x = 0, $x1 = 0, $y = 0, $y2 = 0, $sub3 = 0.0, $4 = 0.0, $div = 0.0, $5 = 0.0, $mul22 = 0.0, $8 = 0.0, $div24 = 0.0, $div26 = 0.0, $9 = 0.0, $sub28 = 0.0, $10 = 0.0, $sub30 = 0.0, $add32 = 0.0, $add34 = 0.0, $add36 = 0.0, $add38 = 0.0, $add40 = 0.0, $add42 = 0.0, $cond44 = 0.0, $add32_cond44 = 0.0, $cond80 = 0.0, $add34_cond80 = 0.0, $cond117 = 0.0, $add32_cond117 = 0.0, $cond153 = 0.0, $add34_cond153 = 0.0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  $x = $p | 0;
  $x1 = $u | 0;
  HEAPF64[$x1 >> 3] = +HEAPF64[$x1 >> 3] - +HEAPF64[$x >> 3];
  $y = $p + 8 | 0;
  $y2 = $u + 8 | 0;
  $sub3 = +HEAPF64[$y2 >> 3] - +HEAPF64[$y >> 3];
  HEAPF64[$y2 >> 3] = $sub3;
  $4 = +HEAPF64[$x1 >> 3];
  $div = $arrowsize * 10.0 / (+Math_sqrt(+($4 * $4 + $sub3 * $sub3)) + 1.0e-4);
  HEAPF64[$x1 >> 3] = $4 + ($4 >= 0.0 ? 1.0e-4 : -1.0e-4);
  $5 = +HEAPF64[$y2 >> 3];
  HEAPF64[$y2 >> 3] = $5 + ($5 >= 0.0 ? 1.0e-4 : -1.0e-4);
  HEAPF64[$x1 >> 3] = $div * +HEAPF64[$x1 >> 3];
  $mul22 = $div * +HEAPF64[$y2 >> 3];
  HEAPF64[$y2 >> 3] = $mul22;
  $8 = +HEAPF64[$x1 >> 3];
  $div24 = $8 * .5;
  $div26 = $mul22 * .5;
  $9 = +HEAPF64[$x >> 3];
  $sub28 = $9 - $div26;
  $10 = +HEAPF64[$y >> 3];
  $sub30 = $10 - $div24;
  $add32 = $9 + $div26;
  $add34 = $div24 + $10;
  $add36 = $8 + $sub28;
  $add38 = $mul22 + $sub30;
  $add40 = $8 + $add32;
  $add42 = $mul22 + $add34;
  $cond44 = $add36 > $add40 ? $add36 : $add40;
  $add32_cond44 = $add32 > $cond44 ? $add32 : $cond44;
  $cond80 = $add38 > $add42 ? $add38 : $add42;
  $add34_cond80 = $add34 > $cond80 ? $add34 : $cond80;
  $cond117 = $add36 < $add40 ? $add36 : $add40;
  $add32_cond117 = $add32 < $cond117 ? $add32 : $cond117;
  $cond153 = $add38 < $add42 ? $add38 : $add42;
  $add34_cond153 = $add34 < $cond153 ? $add34 : $cond153;
  HEAPF64[$agg_result >> 3] = $sub28 < $add32_cond117 ? $sub28 : $add32_cond117;
  HEAPF64[$agg_result + 8 >> 3] = $sub30 < $add34_cond153 ? $sub30 : $add34_cond153;
  HEAPF64[$agg_result + 16 >> 3] = $sub28 > $add32_cond44 ? $sub28 : $add32_cond44;
  HEAPF64[$agg_result + 24 >> 3] = $sub30 > $add34_cond80 ? $sub30 : $add34_cond80;
  STACKTOP = __stackBase__;
  return;
}
function _arrow_gen($job, $emit_state, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $emit_state = $emit_state | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $tmp = 0, $obj1 = 0, $0 = 0, $emit_state2 = 0, $1 = 0, $gvc = 0, $2 = 0, $defaultlinestyle = 0, $3 = 0, $x = 0, $4 = 0.0, $x4 = 0, $5 = 0.0, $sub = 0.0, $y = 0, $6 = 0.0, $y5 = 0, $7 = 0.0, $sub6 = 0.0, $8 = 0.0, $mul = 0.0, $mul11 = 0.0, $add = 0.0, $call = 0.0, $add12 = 0.0, $div = 0.0, $cmp = 0, $cond = 0.0, $add15 = 0.0, $9 = 0.0, $cmp17 = 0, $cond18 = 0.0, $add20 = 0.0, $10 = 0.0, $mul22 = 0.0, $11 = 0.0, $mul24 = 0.0, $12 = 0, $13 = 0, $i_010 = 0, $mul26 = 0, $shr = 0, $and = 0, $cmp27 = 0, $inc = 0, $cmp25 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tmp = __stackBase__ | 0;
    $obj1 = $job + 16 | 0;
    $0 = HEAP32[$obj1 >> 2] | 0;
    $emit_state2 = $0 + 12 | 0;
    $1 = HEAP32[$emit_state2 >> 2] | 0;
    HEAP32[$emit_state2 >> 2] = $emit_state;
    $gvc = $job | 0;
    $2 = HEAP32[$gvc >> 2] | 0;
    $defaultlinestyle = $2 + 304 | 0;
    $3 = HEAP32[$defaultlinestyle >> 2] | 0;
    _gvrender_set_style($job, $3);
    $x = $p | 0;
    $4 = +HEAPF64[$x >> 3];
    $x4 = $u | 0;
    $5 = +HEAPF64[$x4 >> 3];
    $sub = $5 - $4;
    HEAPF64[$x4 >> 3] = $sub;
    $y = $p + 8 | 0;
    $6 = +HEAPF64[$y >> 3];
    $y5 = $u + 8 | 0;
    $7 = +HEAPF64[$y5 >> 3];
    $sub6 = $7 - $6;
    HEAPF64[$y5 >> 3] = $sub6;
    $8 = +HEAPF64[$x4 >> 3];
    $mul = $8 * $8;
    $mul11 = $sub6 * $sub6;
    $add = $mul + $mul11;
    $call = +Math_sqrt(+$add);
    $add12 = $call + 1.0e-4;
    $div = 10.0 / $add12;
    $cmp = $8 >= 0.0;
    $cond = $cmp ? 1.0e-4 : -1.0e-4;
    $add15 = $8 + $cond;
    HEAPF64[$x4 >> 3] = $add15;
    $9 = +HEAPF64[$y5 >> 3];
    $cmp17 = $9 >= 0.0;
    $cond18 = $cmp17 ? 1.0e-4 : -1.0e-4;
    $add20 = $9 + $cond18;
    HEAPF64[$y5 >> 3] = $add20;
    $10 = +HEAPF64[$x4 >> 3];
    $mul22 = $div * $10;
    HEAPF64[$x4 >> 3] = $mul22;
    $11 = +HEAPF64[$y5 >> 3];
    $mul24 = $div * $11;
    HEAPF64[$y5 >> 3] = $mul24;
    $12 = $p;
    $13 = $tmp;
    $i_010 = 0;
    label = 3;
    break;
   case 3:
    $mul26 = $i_010 << 3;
    $shr = $flag >> $mul26;
    $and = $shr & 255;
    $cmp27 = ($and | 0) == 0;
    if ($cmp27) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    _arrow_gen_type($tmp, $job, $p, $u, $arrowsize, $penwidth, $and);
    HEAP32[$12 >> 2] = HEAP32[$13 >> 2] | 0;
    HEAP32[$12 + 4 >> 2] = HEAP32[$13 + 4 >> 2] | 0;
    HEAP32[$12 + 8 >> 2] = HEAP32[$13 + 8 >> 2] | 0;
    HEAP32[$12 + 12 >> 2] = HEAP32[$13 + 12 >> 2] | 0;
    $inc = $i_010 + 1 | 0;
    $cmp25 = ($inc | 0) < 4;
    if ($cmp25) {
      $i_010 = $inc;
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    HEAP32[$emit_state2 >> 2] = $1;
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_gen_type($agg_result, $job, $p, $u, $arrowsize, $penwidth, $flag) {
  $agg_result = $agg_result | 0;
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $and = 0, $arrowtype_0 = 0, $type = 0, $0 = 0, $tobool = 0, $cmp = 0, $incdec_ptr = 0, $lenfact = 0, $1 = 0.0, $mul = 0.0, $x = 0, $2 = 0.0, $mul2 = 0.0, $3 = 0.0, $mul4 = 0.0, $y = 0, $4 = 0.0, $mul5 = 0.0, $gen = 0, $5 = 0, $x6 = 0, $6 = 0.0, $7 = 0.0, $add = 0.0, $y9 = 0, $8 = 0.0, $9 = 0.0, $add11 = 0.0, $10 = 0, $11 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $and = $flag & 7;
    $arrowtype_0 = 168136;
    label = 3;
    break;
   case 3:
    $type = $arrowtype_0 | 0;
    $0 = HEAP32[$type >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $cmp = ($and | 0) == ($0 | 0);
    $incdec_ptr = $arrowtype_0 + 24 | 0;
    if ($cmp) {
      label = 5;
      break;
    } else {
      $arrowtype_0 = $incdec_ptr;
      label = 3;
      break;
    }
   case 5:
    $lenfact = $arrowtype_0 + 8 | 0;
    $1 = +HEAPF64[$lenfact >> 3];
    $mul = $1 * $arrowsize;
    $x = $u | 0;
    $2 = +HEAPF64[$x >> 3];
    $mul2 = $2 * $mul;
    HEAPF64[$x >> 3] = $mul2;
    $3 = +HEAPF64[$lenfact >> 3];
    $mul4 = $3 * $arrowsize;
    $y = $u + 8 | 0;
    $4 = +HEAPF64[$y >> 3];
    $mul5 = $4 * $mul4;
    HEAPF64[$y >> 3] = $mul5;
    $gen = $arrowtype_0 + 16 | 0;
    $5 = HEAP32[$gen >> 2] | 0;
    FUNCTION_TABLE_viiiffi[$5 & 1023]($job, $p, $u, $arrowsize, $penwidth, $flag);
    $x6 = $p | 0;
    $6 = +HEAPF64[$x6 >> 3];
    $7 = +HEAPF64[$x >> 3];
    $add = $6 + $7;
    HEAPF64[$x6 >> 3] = $add;
    $y9 = $p + 8 | 0;
    $8 = +HEAPF64[$y9 >> 3];
    $9 = +HEAPF64[$y >> 3];
    $add11 = $8 + $9;
    HEAPF64[$y9 >> 3] = $add11;
    label = 6;
    break;
   case 6:
    $10 = $agg_result;
    $11 = $p;
    HEAP32[$10 >> 2] = HEAP32[$11 >> 2] | 0;
    HEAP32[$10 + 4 >> 2] = HEAP32[$11 + 4 >> 2] | 0;
    HEAP32[$10 + 8 >> 2] = HEAP32[$11 + 8 >> 2] | 0;
    HEAP32[$10 + 12 >> 2] = HEAP32[$11 + 12 >> 2] | 0;
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_type_normal($job, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $a = 0, $cmp = 0, $div = 0.0, $mul = 0.0, $arrowwidth_0 = 0.0, $y = 0, $0 = 0.0, $sub = 0.0, $mul1 = 0.0, $x2 = 0, $1 = 0.0, $mul3 = 0.0, $x5 = 0, $2 = 0.0, $add = 0.0, $y8 = 0, $3 = 0.0, $add10 = 0.0, $and = 0, $tobool = 0, $arrayidx = 0, $arrayidx13 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0.0, $sub16 = 0.0, $x18 = 0, $8 = 0.0, $sub21 = 0.0, $y23 = 0, $q_sroa_0_0__idx10 = 0, $q_sroa_1_8__idx14 = 0, $9 = 0.0, $add27 = 0.0, $x29 = 0, $10 = 0.0, $add32 = 0.0, $y34 = 0, $q_sroa_0_0__idx = 0, $q_sroa_1_8__idx13 = 0, $11 = 0, $sub39 = 0.0, $x41 = 0, $sub44 = 0.0, $y46 = 0, $arrayidx47 = 0, $12 = 0, $13 = 0, $add50 = 0.0, $x52 = 0, $add55 = 0.0, $y57 = 0, $and59 = 0, $tobool60 = 0, $and62 = 0, $and62_lobit = 0, $14 = 0, $conv = 0, $and65 = 0, $tobool66 = 0, $arrayidx68 = 0, $and69 = 0, $and69_lobit = 0, $15 = 0, $conv73 = 0, $arrayidx75 = 0, $and76 = 0, $and76_lobit = 0, $16 = 0, $conv80 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 80 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $a = __stackBase__ | 0;
    $cmp = $penwidth > 4.0;
    if ($cmp) {
      label = 3;
      break;
    } else {
      $arrowwidth_0 = .35;
      label = 4;
      break;
    }
   case 3:
    $div = $penwidth * .25;
    $mul = $div * .35;
    $arrowwidth_0 = $mul;
    label = 4;
    break;
   case 4:
    $y = $u + 8 | 0;
    $0 = +HEAPF64[$y >> 3];
    $sub = -0.0 - $0;
    $mul1 = $arrowwidth_0 * $sub;
    $x2 = $u | 0;
    $1 = +HEAPF64[$x2 >> 3];
    $mul3 = $arrowwidth_0 * $1;
    $x5 = $p | 0;
    $2 = +HEAPF64[$x5 >> 3];
    $add = $1 + $2;
    $y8 = $p + 8 | 0;
    $3 = +HEAPF64[$y8 >> 3];
    $add10 = $0 + $3;
    $and = $flag & 16;
    $tobool = ($and | 0) == 0;
    $arrayidx = $a | 0;
    $arrayidx13 = $a + 64 | 0;
    $4 = $arrayidx13;
    if ($tobool) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $5 = $p;
    HEAP32[$4 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$4 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$4 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$4 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    $6 = $a;
    HEAP32[$6 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    $7 = +HEAPF64[$x5 >> 3];
    $sub16 = $7 - $mul1;
    $x18 = $a + 16 | 0;
    HEAPF64[$x18 >> 3] = $sub16;
    $8 = +HEAPF64[$y8 >> 3];
    $sub21 = $8 - $mul3;
    $y23 = $a + 24 | 0;
    HEAPF64[$y23 >> 3] = $sub21;
    $q_sroa_0_0__idx10 = $a + 32 | 0;
    HEAPF64[$q_sroa_0_0__idx10 >> 3] = $add;
    $q_sroa_1_8__idx14 = $a + 40 | 0;
    HEAPF64[$q_sroa_1_8__idx14 >> 3] = $add10;
    $9 = +HEAPF64[$x5 >> 3];
    $add27 = $mul1 + $9;
    $x29 = $a + 48 | 0;
    HEAPF64[$x29 >> 3] = $add27;
    $10 = +HEAPF64[$y8 >> 3];
    $add32 = $mul3 + $10;
    $y34 = $a + 56 | 0;
    HEAPF64[$y34 >> 3] = $add32;
    label = 7;
    break;
   case 6:
    $q_sroa_0_0__idx = $a + 64 | 0;
    HEAPF64[$q_sroa_0_0__idx >> 3] = $add;
    $q_sroa_1_8__idx13 = $a + 72 | 0;
    HEAPF64[$q_sroa_1_8__idx13 >> 3] = $add10;
    $11 = $a;
    HEAP32[$11 >> 2] = HEAP32[$4 >> 2] | 0;
    HEAP32[$11 + 4 >> 2] = HEAP32[$4 + 4 >> 2] | 0;
    HEAP32[$11 + 8 >> 2] = HEAP32[$4 + 8 >> 2] | 0;
    HEAP32[$11 + 12 >> 2] = HEAP32[$4 + 12 >> 2] | 0;
    $sub39 = $add - $mul1;
    $x41 = $a + 16 | 0;
    HEAPF64[$x41 >> 3] = $sub39;
    $sub44 = $add10 - $mul3;
    $y46 = $a + 24 | 0;
    HEAPF64[$y46 >> 3] = $sub44;
    $arrayidx47 = $a + 32 | 0;
    $12 = $arrayidx47;
    $13 = $p;
    HEAP32[$12 >> 2] = HEAP32[$13 >> 2] | 0;
    HEAP32[$12 + 4 >> 2] = HEAP32[$13 + 4 >> 2] | 0;
    HEAP32[$12 + 8 >> 2] = HEAP32[$13 + 8 >> 2] | 0;
    HEAP32[$12 + 12 >> 2] = HEAP32[$13 + 12 >> 2] | 0;
    $add50 = $mul1 + $add;
    $x52 = $a + 48 | 0;
    HEAPF64[$x52 >> 3] = $add50;
    $add55 = $mul3 + $add10;
    $y57 = $a + 56 | 0;
    HEAPF64[$y57 >> 3] = $add55;
    label = 7;
    break;
   case 7:
    $and59 = $flag & 32;
    $tobool60 = ($and59 | 0) == 0;
    if ($tobool60) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $and62 = $flag >>> 3;
    $and62_lobit = $and62 & 1;
    $14 = $and62_lobit ^ 1;
    $conv = $14 & 255;
    _gvrender_polygon($job, $arrayidx, 3, $conv);
    label = 12;
    break;
   case 9:
    $and65 = $flag & 64;
    $tobool66 = ($and65 | 0) == 0;
    if ($tobool66) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $arrayidx68 = $a + 32 | 0;
    $and69 = $flag >>> 3;
    $and69_lobit = $and69 & 1;
    $15 = $and69_lobit ^ 1;
    $conv73 = $15 & 255;
    _gvrender_polygon($job, $arrayidx68, 3, $conv73);
    label = 12;
    break;
   case 11:
    $arrayidx75 = $a + 16 | 0;
    $and76 = $flag >>> 3;
    $and76_lobit = $and76 & 1;
    $16 = $and76_lobit ^ 1;
    $conv80 = $16 & 255;
    _gvrender_polygon($job, $arrayidx75, 3, $conv80);
    label = 12;
    break;
   case 12:
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_type_crow($job, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $a = 0, $mul = 0.0, $cmp = 0, $and = 0, $tobool = 0, $div = 0.0, $mul2 = 0.0, $arrowwidth_0 = 0.0, $cmp3 = 0, $and5 = 0, $tobool6 = 0, $sub = 0.0, $mul8 = 0.0, $div9 = 0.0, $shaftwidth_0 = 0.0, $y = 0, $0 = 0.0, $sub11 = 0.0, $mul12 = 0.0, $x13 = 0, $1 = 0.0, $mul14 = 0.0, $mul18 = 0.0, $mul21 = 0.0, $x23 = 0, $2 = 0.0, $add = 0.0, $y26 = 0, $3 = 0.0, $add28 = 0.0, $mul32 = 0.0, $add33 = 0.0, $mul37 = 0.0, $add38 = 0.0, $and40 = 0, $tobool41 = 0, $arrayidx = 0, $arrayidx43 = 0, $4 = 0, $5 = 0, $6 = 0, $sub46 = 0.0, $x48 = 0, $sub51 = 0.0, $y53 = 0, $sub56 = 0.0, $x58 = 0, $sub61 = 0.0, $y63 = 0, $sub66 = 0.0, $x68 = 0, $sub71 = 0.0, $y73 = 0, $q_sroa_0_0__idx21 = 0, $q_sroa_1_8__idx27 = 0, $add77 = 0.0, $x79 = 0, $add82 = 0.0, $y84 = 0, $add87 = 0.0, $x89 = 0, $add92 = 0.0, $y94 = 0, $add97 = 0.0, $x99 = 0, $add102 = 0.0, $y104 = 0, $q_sroa_0_0__idx = 0, $q_sroa_1_8__idx25 = 0, $7 = 0, $8 = 0.0, $sub109 = 0.0, $x111 = 0, $9 = 0.0, $sub114 = 0.0, $y116 = 0, $sub119 = 0.0, $x121 = 0, $sub124 = 0.0, $y126 = 0, $10 = 0.0, $x129 = 0, $11 = 0.0, $y132 = 0, $arrayidx133 = 0, $12 = 0, $13 = 0, $14 = 0.0, $x136 = 0, $15 = 0.0, $y139 = 0, $add142 = 0.0, $x144 = 0, $add147 = 0.0, $y149 = 0, $16 = 0.0, $add152 = 0.0, $x154 = 0, $17 = 0.0, $add157 = 0.0, $y159 = 0, $and161 = 0, $tobool162 = 0, $and165 = 0, $tobool166 = 0, $arrayidx168 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 144 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $a = __stackBase__ | 0;
    $mul = $arrowsize * 4.0;
    $cmp = $mul < $penwidth;
    if ($cmp) {
      label = 3;
      break;
    } else {
      $arrowwidth_0 = .45;
      label = 5;
      break;
    }
   case 3:
    $and = $flag & 16;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      $arrowwidth_0 = .45;
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $div = $penwidth / $mul;
    $mul2 = $div * .45;
    $arrowwidth_0 = $mul2;
    label = 5;
    break;
   case 5:
    $cmp3 = $penwidth > 1.0;
    if ($cmp3) {
      label = 6;
      break;
    } else {
      $shaftwidth_0 = 0.0;
      label = 8;
      break;
    }
   case 6:
    $and5 = $flag & 16;
    $tobool6 = ($and5 | 0) == 0;
    if ($tobool6) {
      $shaftwidth_0 = 0.0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $sub = $penwidth + -1.0;
    $mul8 = $sub * .05;
    $div9 = $mul8 / $arrowsize;
    $shaftwidth_0 = $div9;
    label = 8;
    break;
   case 8:
    $y = $u + 8 | 0;
    $0 = +HEAPF64[$y >> 3];
    $sub11 = -0.0 - $0;
    $mul12 = $arrowwidth_0 * $sub11;
    $x13 = $u | 0;
    $1 = +HEAPF64[$x13 >> 3];
    $mul14 = $arrowwidth_0 * $1;
    $mul18 = $shaftwidth_0 * $sub11;
    $mul21 = $shaftwidth_0 * $1;
    $x23 = $p | 0;
    $2 = +HEAPF64[$x23 >> 3];
    $add = $1 + $2;
    $y26 = $p + 8 | 0;
    $3 = +HEAPF64[$y26 >> 3];
    $add28 = $0 + $3;
    $mul32 = $1 * .5;
    $add33 = $2 + $mul32;
    $mul37 = $0 * .5;
    $add38 = $mul37 + $3;
    $and40 = $flag & 16;
    $tobool41 = ($and40 | 0) == 0;
    $arrayidx = $a | 0;
    $arrayidx43 = $a + 128 | 0;
    $4 = $arrayidx43;
    if ($tobool41) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $5 = $p;
    HEAP32[$4 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$4 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$4 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$4 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    $6 = $a;
    HEAP32[$6 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    $sub46 = $add - $mul12;
    $x48 = $a + 16 | 0;
    HEAPF64[$x48 >> 3] = $sub46;
    $sub51 = $add28 - $mul14;
    $y53 = $a + 24 | 0;
    HEAPF64[$y53 >> 3] = $sub51;
    $sub56 = $add33 - $mul18;
    $x58 = $a + 32 | 0;
    HEAPF64[$x58 >> 3] = $sub56;
    $sub61 = $add38 - $mul21;
    $y63 = $a + 40 | 0;
    HEAPF64[$y63 >> 3] = $sub61;
    $sub66 = $add - $mul18;
    $x68 = $a + 48 | 0;
    HEAPF64[$x68 >> 3] = $sub66;
    $sub71 = $add28 - $mul21;
    $y73 = $a + 56 | 0;
    HEAPF64[$y73 >> 3] = $sub71;
    $q_sroa_0_0__idx21 = $a + 64 | 0;
    HEAPF64[$q_sroa_0_0__idx21 >> 3] = $add;
    $q_sroa_1_8__idx27 = $a + 72 | 0;
    HEAPF64[$q_sroa_1_8__idx27 >> 3] = $add28;
    $add77 = $mul18 + $add;
    $x79 = $a + 80 | 0;
    HEAPF64[$x79 >> 3] = $add77;
    $add82 = $mul21 + $add28;
    $y84 = $a + 88 | 0;
    HEAPF64[$y84 >> 3] = $add82;
    $add87 = $mul18 + $add33;
    $x89 = $a + 96 | 0;
    HEAPF64[$x89 >> 3] = $add87;
    $add92 = $mul21 + $add38;
    $y94 = $a + 104 | 0;
    HEAPF64[$y94 >> 3] = $add92;
    $add97 = $mul12 + $add;
    $x99 = $a + 112 | 0;
    HEAPF64[$x99 >> 3] = $add97;
    $add102 = $mul14 + $add28;
    $y104 = $a + 120 | 0;
    HEAPF64[$y104 >> 3] = $add102;
    label = 11;
    break;
   case 10:
    $q_sroa_0_0__idx = $a + 128 | 0;
    HEAPF64[$q_sroa_0_0__idx >> 3] = $add;
    $q_sroa_1_8__idx25 = $a + 136 | 0;
    HEAPF64[$q_sroa_1_8__idx25 >> 3] = $add28;
    $7 = $a;
    HEAP32[$7 >> 2] = HEAP32[$4 >> 2] | 0;
    HEAP32[$7 + 4 >> 2] = HEAP32[$4 + 4 >> 2] | 0;
    HEAP32[$7 + 8 >> 2] = HEAP32[$4 + 8 >> 2] | 0;
    HEAP32[$7 + 12 >> 2] = HEAP32[$4 + 12 >> 2] | 0;
    $8 = +HEAPF64[$x23 >> 3];
    $sub109 = $8 - $mul12;
    $x111 = $a + 16 | 0;
    HEAPF64[$x111 >> 3] = $sub109;
    $9 = +HEAPF64[$y26 >> 3];
    $sub114 = $9 - $mul14;
    $y116 = $a + 24 | 0;
    HEAPF64[$y116 >> 3] = $sub114;
    $sub119 = $add33 - $mul18;
    $x121 = $a + 32 | 0;
    HEAPF64[$x121 >> 3] = $sub119;
    $sub124 = $add38 - $mul21;
    $y126 = $a + 40 | 0;
    HEAPF64[$y126 >> 3] = $sub124;
    $10 = +HEAPF64[$x23 >> 3];
    $x129 = $a + 48 | 0;
    HEAPF64[$x129 >> 3] = $10;
    $11 = +HEAPF64[$y26 >> 3];
    $y132 = $a + 56 | 0;
    HEAPF64[$y132 >> 3] = $11;
    $arrayidx133 = $a + 64 | 0;
    $12 = $arrayidx133;
    $13 = $p;
    HEAP32[$12 >> 2] = HEAP32[$13 >> 2] | 0;
    HEAP32[$12 + 4 >> 2] = HEAP32[$13 + 4 >> 2] | 0;
    HEAP32[$12 + 8 >> 2] = HEAP32[$13 + 8 >> 2] | 0;
    HEAP32[$12 + 12 >> 2] = HEAP32[$13 + 12 >> 2] | 0;
    $14 = +HEAPF64[$x23 >> 3];
    $x136 = $a + 80 | 0;
    HEAPF64[$x136 >> 3] = $14;
    $15 = +HEAPF64[$y26 >> 3];
    $y139 = $a + 88 | 0;
    HEAPF64[$y139 >> 3] = $15;
    $add142 = $mul18 + $add33;
    $x144 = $a + 96 | 0;
    HEAPF64[$x144 >> 3] = $add142;
    $add147 = $mul21 + $add38;
    $y149 = $a + 104 | 0;
    HEAPF64[$y149 >> 3] = $add147;
    $16 = +HEAPF64[$x23 >> 3];
    $add152 = $mul12 + $16;
    $x154 = $a + 112 | 0;
    HEAPF64[$x154 >> 3] = $add152;
    $17 = +HEAPF64[$y26 >> 3];
    $add157 = $mul14 + $17;
    $y159 = $a + 120 | 0;
    HEAPF64[$y159 >> 3] = $add157;
    label = 11;
    break;
   case 11:
    $and161 = $flag & 32;
    $tobool162 = ($and161 | 0) == 0;
    if ($tobool162) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    _gvrender_polygon($job, $arrayidx, 6, 1);
    label = 16;
    break;
   case 13:
    $and165 = $flag & 64;
    $tobool166 = ($and165 | 0) == 0;
    if ($tobool166) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $arrayidx168 = $a + 48 | 0;
    _gvrender_polygon($job, $arrayidx168, 6, 1);
    label = 16;
    break;
   case 15:
    _gvrender_polygon($job, $arrayidx, 9, 1);
    label = 16;
    break;
   case 16:
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_type_tee($job, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $a = 0, $y = 0, $0 = 0.0, $x1 = 0, $1 = 0.0, $x3 = 0, $2 = 0.0, $add = 0.0, $y6 = 0, $3 = 0.0, $add8 = 0.0, $mul = 0.0, $add12 = 0.0, $mul16 = 0.0, $add17 = 0.0, $mul21 = 0.0, $add22 = 0.0, $mul26 = 0.0, $add27 = 0.0, $add31 = 0.0, $arrayidx = 0, $x32 = 0, $add35 = 0.0, $y37 = 0, $sub40 = 0.0, $x42 = 0, $sub45 = 0.0, $y47 = 0, $sub50 = 0.0, $x52 = 0, $sub55 = 0.0, $y57 = 0, $add60 = 0.0, $x62 = 0, $add65 = 0.0, $y67 = 0, $and = 0, $tobool = 0, $and70 = 0, $tobool71 = 0, $4 = 0, $5 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 64 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $a = __stackBase__ | 0;
    $y = $u + 8 | 0;
    $0 = +HEAPF64[$y >> 3];
    $x1 = $u | 0;
    $1 = +HEAPF64[$x1 >> 3];
    $x3 = $p | 0;
    $2 = +HEAPF64[$x3 >> 3];
    $add = $1 + $2;
    $y6 = $p + 8 | 0;
    $3 = +HEAPF64[$y6 >> 3];
    $add8 = $0 + $3;
    $mul = $1 * .2;
    $add12 = $2 + $mul;
    $mul16 = $0 * .2;
    $add17 = $mul16 + $3;
    $mul21 = $1 * .6;
    $add22 = $2 + $mul21;
    $mul26 = $0 * .6;
    $add27 = $mul26 + $3;
    $add31 = $add12 - $0;
    $arrayidx = $a | 0;
    $x32 = $a | 0;
    HEAPF64[$x32 >> 3] = $add31;
    $add35 = $1 + $add17;
    $y37 = $a + 8 | 0;
    HEAPF64[$y37 >> 3] = $add35;
    $sub40 = $0 + $add12;
    $x42 = $a + 16 | 0;
    HEAPF64[$x42 >> 3] = $sub40;
    $sub45 = $add17 - $1;
    $y47 = $a + 24 | 0;
    HEAPF64[$y47 >> 3] = $sub45;
    $sub50 = $0 + $add22;
    $x52 = $a + 32 | 0;
    HEAPF64[$x52 >> 3] = $sub50;
    $sub55 = $add27 - $1;
    $y57 = $a + 40 | 0;
    HEAPF64[$y57 >> 3] = $sub55;
    $add60 = $add22 - $0;
    $x62 = $a + 48 | 0;
    HEAPF64[$x62 >> 3] = $add60;
    $add65 = $1 + $add27;
    $y67 = $a + 56 | 0;
    HEAPF64[$y67 >> 3] = $add65;
    $and = $flag & 32;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    HEAPF64[$x32 >> 3] = $add12;
    HEAPF64[$y37 >> 3] = $add17;
    HEAPF64[$x62 >> 3] = $add22;
    HEAPF64[$y67 >> 3] = $add27;
    label = 6;
    break;
   case 4:
    $and70 = $flag & 64;
    $tobool71 = ($and70 | 0) == 0;
    if ($tobool71) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    HEAPF64[$x42 >> 3] = $add12;
    HEAPF64[$y47 >> 3] = $add17;
    HEAPF64[$x52 >> 3] = $add22;
    HEAPF64[$y57 >> 3] = $add27;
    label = 6;
    break;
   case 6:
    _gvrender_polygon($job, $arrayidx, 4, 1);
    $4 = $a;
    $5 = $p;
    HEAP32[$4 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$4 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$4 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$4 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    HEAPF64[$x42 >> 3] = $add;
    HEAPF64[$y47 >> 3] = $add8;
    _gvrender_polyline($job, $arrayidx, 2);
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_type_box($job, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $a = 0, $y = 0, $0 = 0.0, $mul = 0.0, $x1 = 0, $1 = 0.0, $mul2 = 0.0, $x4 = 0, $2 = 0.0, $mul6 = 0.0, $add = 0.0, $y8 = 0, $3 = 0.0, $mul10 = 0.0, $add11 = 0.0, $add15 = 0.0, $add19 = 0.0, $add23 = 0.0, $arrayidx = 0, $x24 = 0, $4 = 0.0, $add27 = 0.0, $y29 = 0, $5 = 0.0, $sub32 = 0.0, $arrayidx33 = 0, $x34 = 0, $6 = 0.0, $sub37 = 0.0, $y39 = 0, $sub42 = 0.0, $x44 = 0, $sub47 = 0.0, $y49 = 0, $add52 = 0.0, $x54 = 0, $add57 = 0.0, $y59 = 0, $and = 0, $tobool = 0, $7 = 0, $8 = 0, $and62 = 0, $tobool63 = 0, $9 = 0, $10 = 0, $and68 = 0, $and68_lobit = 0, $11 = 0, $conv = 0, $q_sroa_0_0__idx = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 64 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $a = __stackBase__ | 0;
    $y = $u + 8 | 0;
    $0 = +HEAPF64[$y >> 3];
    $mul = $0 * -.4;
    $x1 = $u | 0;
    $1 = +HEAPF64[$x1 >> 3];
    $mul2 = $1 * .4;
    $x4 = $p | 0;
    $2 = +HEAPF64[$x4 >> 3];
    $mul6 = $1 * .8;
    $add = $2 + $mul6;
    $y8 = $p + 8 | 0;
    $3 = +HEAPF64[$y8 >> 3];
    $mul10 = $0 * .8;
    $add11 = $mul10 + $3;
    $add15 = $1 + $2;
    $add19 = $0 + $3;
    $add23 = $mul + $2;
    $arrayidx = $a | 0;
    $x24 = $a | 0;
    HEAPF64[$x24 >> 3] = $add23;
    $4 = +HEAPF64[$y8 >> 3];
    $add27 = $mul2 + $4;
    $y29 = $a + 8 | 0;
    HEAPF64[$y29 >> 3] = $add27;
    $5 = +HEAPF64[$x4 >> 3];
    $sub32 = $5 - $mul;
    $arrayidx33 = $a + 16 | 0;
    $x34 = $arrayidx33 | 0;
    HEAPF64[$x34 >> 3] = $sub32;
    $6 = +HEAPF64[$y8 >> 3];
    $sub37 = $6 - $mul2;
    $y39 = $a + 24 | 0;
    HEAPF64[$y39 >> 3] = $sub37;
    $sub42 = $add - $mul;
    $x44 = $a + 32 | 0;
    HEAPF64[$x44 >> 3] = $sub42;
    $sub47 = $add11 - $mul2;
    $y49 = $a + 40 | 0;
    HEAPF64[$y49 >> 3] = $sub47;
    $add52 = $mul + $add;
    $x54 = $a + 48 | 0;
    HEAPF64[$x54 >> 3] = $add52;
    $add57 = $mul2 + $add11;
    $y59 = $a + 56 | 0;
    HEAPF64[$y59 >> 3] = $add57;
    $and = $flag & 32;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $7 = $a;
    $8 = $p;
    HEAP32[$7 >> 2] = HEAP32[$8 >> 2] | 0;
    HEAP32[$7 + 4 >> 2] = HEAP32[$8 + 4 >> 2] | 0;
    HEAP32[$7 + 8 >> 2] = HEAP32[$8 + 8 >> 2] | 0;
    HEAP32[$7 + 12 >> 2] = HEAP32[$8 + 12 >> 2] | 0;
    HEAPF64[$x54 >> 3] = $add;
    HEAPF64[$y59 >> 3] = $add11;
    label = 6;
    break;
   case 4:
    $and62 = $flag & 64;
    $tobool63 = ($and62 | 0) == 0;
    if ($tobool63) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $9 = $arrayidx33;
    $10 = $p;
    HEAP32[$9 >> 2] = HEAP32[$10 >> 2] | 0;
    HEAP32[$9 + 4 >> 2] = HEAP32[$10 + 4 >> 2] | 0;
    HEAP32[$9 + 8 >> 2] = HEAP32[$10 + 8 >> 2] | 0;
    HEAP32[$9 + 12 >> 2] = HEAP32[$10 + 12 >> 2] | 0;
    HEAPF64[$x44 >> 3] = $add;
    HEAPF64[$y49 >> 3] = $add11;
    label = 6;
    break;
   case 6:
    $and68 = $flag >>> 3;
    $and68_lobit = $and68 & 1;
    $11 = $and68_lobit ^ 1;
    $conv = $11 & 255;
    _gvrender_polygon($job, $arrayidx, 4, $conv);
    HEAPF64[$x24 >> 3] = $add;
    HEAPF64[$y29 >> 3] = $add11;
    $q_sroa_0_0__idx = $a + 16 | 0;
    HEAPF64[$q_sroa_0_0__idx >> 3] = $add15;
    HEAPF64[$y39 >> 3] = $add19;
    _gvrender_polyline($job, $arrayidx, 2);
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_type_diamond($job, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $a = 0, $y = 0, $0 = 0.0, $sub = 0.0, $div = 0.0, $x1 = 0, $1 = 0.0, $div2 = 0.0, $x4 = 0, $2 = 0.0, $div6 = 0.0, $add = 0.0, $y8 = 0, $3 = 0.0, $div10 = 0.0, $add11 = 0.0, $add15 = 0.0, $add19 = 0.0, $arrayidx = 0, $arrayidx21 = 0, $q_sroa_0_0__idx = 0, $q_sroa_1_8__idx5 = 0, $4 = 0, $5 = 0, $add24 = 0.0, $x26 = 0, $add29 = 0.0, $y31 = 0, $arrayidx32 = 0, $6 = 0, $7 = 0, $sub35 = 0.0, $x37 = 0, $sub40 = 0.0, $y42 = 0, $and = 0, $tobool = 0, $and44 = 0, $and44_lobit = 0, $8 = 0, $conv = 0, $and46 = 0, $tobool47 = 0, $and49 = 0, $and49_lobit = 0, $9 = 0, $conv53 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 80 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $a = __stackBase__ | 0;
    $y = $u + 8 | 0;
    $0 = +HEAPF64[$y >> 3];
    $sub = -0.0 - $0;
    $div = $sub / 3.0;
    $x1 = $u | 0;
    $1 = +HEAPF64[$x1 >> 3];
    $div2 = $1 / 3.0;
    $x4 = $p | 0;
    $2 = +HEAPF64[$x4 >> 3];
    $div6 = $1 * .5;
    $add = $div6 + $2;
    $y8 = $p + 8 | 0;
    $3 = +HEAPF64[$y8 >> 3];
    $div10 = $0 * .5;
    $add11 = $div10 + $3;
    $add15 = $1 + $2;
    $add19 = $0 + $3;
    $arrayidx = $a | 0;
    $arrayidx21 = $a + 64 | 0;
    $q_sroa_0_0__idx = $a + 64 | 0;
    HEAPF64[$q_sroa_0_0__idx >> 3] = $add15;
    $q_sroa_1_8__idx5 = $a + 72 | 0;
    HEAPF64[$q_sroa_1_8__idx5 >> 3] = $add19;
    $4 = $a;
    $5 = $arrayidx21;
    HEAP32[$4 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$4 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$4 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$4 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    $add24 = $div + $add;
    $x26 = $a + 16 | 0;
    HEAPF64[$x26 >> 3] = $add24;
    $add29 = $div2 + $add11;
    $y31 = $a + 24 | 0;
    HEAPF64[$y31 >> 3] = $add29;
    $arrayidx32 = $a + 32 | 0;
    $6 = $arrayidx32;
    $7 = $p;
    HEAP32[$6 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    $sub35 = $add - $div;
    $x37 = $a + 48 | 0;
    HEAPF64[$x37 >> 3] = $sub35;
    $sub40 = $add11 - $div2;
    $y42 = $a + 56 | 0;
    HEAPF64[$y42 >> 3] = $sub40;
    $and = $flag & 32;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $and44 = $flag >>> 3;
    $and44_lobit = $and44 & 1;
    $8 = $and44_lobit ^ 1;
    $conv = $8 & 255;
    _gvrender_polygon($job, $arrayidx32, 3, $conv);
    label = 7;
    break;
   case 4:
    $and46 = $flag & 64;
    $tobool47 = ($and46 | 0) == 0;
    $and49 = $flag >>> 3;
    $and49_lobit = $and49 & 1;
    $9 = $and49_lobit ^ 1;
    $conv53 = $9 & 255;
    if ($tobool47) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    _gvrender_polygon($job, $arrayidx, 3, $conv53);
    label = 7;
    break;
   case 6:
    _gvrender_polygon($job, $arrayidx, 4, $conv53);
    label = 7;
    break;
   case 7:
    STACKTOP = __stackBase__;
    return;
  }
}
function _arrow_type_dot($job, $p, $u, $arrowsize, $penwidth, $flag) {
  $job = $job | 0;
  $p = $p | 0;
  $u = $u | 0;
  $arrowsize = +$arrowsize;
  $penwidth = +$penwidth;
  $flag = $flag | 0;
  var $AF = 0, $x = 0, $0 = 0.0, $y = 0, $1 = 0.0, $div = 0.0, $x4 = 0, $y9 = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 32 | 0;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  tempParam = $u;
  $u = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$u >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$u + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$u + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$u + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  $AF = __stackBase__ | 0;
  $x = $u | 0;
  $0 = +HEAPF64[$x >> 3];
  $y = $u + 8 | 0;
  $1 = +HEAPF64[$y >> 3];
  $div = +Math_sqrt(+($0 * $0 + $1 * $1)) * .5;
  $x4 = $p | 0;
  HEAPF64[$AF >> 3] = $0 * .5 + +HEAPF64[$x4 >> 3] - $div;
  $y9 = $p + 8 | 0;
  HEAPF64[$AF + 8 >> 3] = +HEAPF64[$y9 >> 3] + +HEAPF64[$y >> 3] * .5 - $div;
  HEAPF64[$AF + 16 >> 3] = $div + (+HEAPF64[$x4 >> 3] + +HEAPF64[$x >> 3] * .5);
  HEAPF64[$AF + 24 >> 3] = $div + (+HEAPF64[$y9 >> 3] + +HEAPF64[$y >> 3] * .5);
  _gvrender_ellipse($job, $AF | 0, 0, ($flag >>> 3 & 1 ^ 1) & 255);
  STACKTOP = __stackBase__;
  return;
}
function _arrow_match_shape($name, $flag) {
  $name = $name | 0;
  $flag = $flag | 0;
  var $f = 0, $call = 0, $cmp = 0, $rest_0 = 0, $call1 = 0, $cmp2 = 0, $call3 = 0, $rest_1 = 0, $0 = 0, $tobool = 0, $and = 0, $tobool4 = 0, $or_cond = 0, $or = 0, $1 = 0, $2 = 0, $or7 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $f = __stackBase__ | 0;
    HEAP32[$f >> 2] = 0;
    $call = _arrow_match_name_frag($name, 168304, $f) | 0;
    $cmp = ($call | 0) == ($name | 0);
    if ($cmp) {
      $rest_0 = $call;
      label = 3;
      break;
    } else {
      $rest_1 = $call;
      label = 5;
      break;
    }
   case 3:
    $call1 = _arrow_match_name_frag($rest_0, 168416, $f) | 0;
    $cmp2 = ($rest_0 | 0) == ($call1 | 0);
    if ($cmp2) {
      label = 4;
      break;
    } else {
      $rest_0 = $call1;
      label = 3;
      break;
    }
   case 4:
    $call3 = _arrow_match_name_frag($call1, 168320, $f) | 0;
    $rest_1 = $call3;
    label = 5;
    break;
   case 5:
    $0 = HEAP32[$f >> 2] | 0;
    $tobool = ($0 | 0) != 0;
    $and = $0 & 7;
    $tobool4 = ($and | 0) == 0;
    $or_cond = $tobool & $tobool4;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    $or = $0 | 1;
    HEAP32[$f >> 2] = $or;
    label = 7;
    break;
   case 7:
    $1 = HEAP32[$f >> 2] | 0;
    $2 = HEAP32[$flag >> 2] | 0;
    $or7 = $2 | $1;
    HEAP32[$flag >> 2] = $or7;
    STACKTOP = __stackBase__;
    return $rest_1 | 0;
  }
  return 0;
}
function _arrow_match_name_frag($name, $arrownames, $flag) {
  $name = $name | 0;
  $arrownames = $arrownames | 0;
  $flag = $flag | 0;
  var $arrowname_0 = 0, $name1 = 0, $0 = 0, $tobool = 0, $call = 0, $call4 = 0, $cmp = 0, $incdec_ptr = 0, $type = 0, $1 = 0, $2 = 0, $or = 0, $add_ptr = 0, $rest_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $arrowname_0 = $arrownames;
    label = 3;
    break;
   case 3:
    $name1 = $arrowname_0 | 0;
    $0 = HEAP32[$name1 >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      $rest_0 = $name;
      label = 6;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $call = _strlen($0 | 0) | 0;
    $call4 = _strncmp($name | 0, $0 | 0, $call | 0) | 0;
    $cmp = ($call4 | 0) == 0;
    $incdec_ptr = $arrowname_0 + 8 | 0;
    if ($cmp) {
      label = 5;
      break;
    } else {
      $arrowname_0 = $incdec_ptr;
      label = 3;
      break;
    }
   case 5:
    $type = $arrowname_0 + 4 | 0;
    $1 = HEAP32[$type >> 2] | 0;
    $2 = HEAP32[$flag >> 2] | 0;
    $or = $2 | $1;
    HEAP32[$flag >> 2] = $or;
    $add_ptr = $name + $call | 0;
    $rest_0 = $add_ptr;
    label = 6;
    break;
   case 6:
    return $rest_0 | 0;
  }
  return 0;
}
function _init_xdot($g) {
  $g = $g | 0;
  var $stats = 0, $0 = 0, $call = 0, $tobool = 0, $1 = 0, $tobool1 = 0, $2 = 0, $tobool2 = 0, $call4 = 0, $tobool5 = 0, $name = 0, $3 = 0, $call7 = 0, $call8 = 0, $4 = 0, $tobool10 = 0, $call12 = 0.0, $call13 = 0, $5 = 0, $cnt = 0, $6 = 0, $call14 = 0, $7 = 0, $n_polygon = 0, $8 = 0, $n_polygon_pts = 0, $9 = 0, $call15 = 0, $10 = 0, $n_polyline = 0, $11 = 0, $n_polyline_pts = 0, $12 = 0, $call16 = 0, $13 = 0, $n_bezier = 0, $14 = 0, $n_bezier_pts = 0, $15 = 0, $call17 = 0, $16 = 0, $n_ellipse = 0, $17 = 0, $call18 = 0, $18 = 0, $n_text = 0, $19 = 0, $call19 = 0, $xd_0 = 0, $20 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 56 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $stats = __stackBase__ | 0;
    $0 = $g | 0;
    $call = _agget($0, 132328) | 0;
    $tobool = ($call | 0) == 0;
    if ($tobool) {
      $xd_0 = 0;
      label = 10;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $1 = HEAP8[$call] | 0;
    $tobool1 = $1 << 24 >> 24 == 0;
    if ($tobool1) {
      $xd_0 = 0;
      label = 10;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $2 = HEAP8[164912] | 0;
    $tobool2 = $2 << 24 >> 24 == 0;
    if ($tobool2) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    _start_timer();
    label = 6;
    break;
   case 6:
    $call4 = _parseXDotF($call | 0, 0, 96) | 0;
    $tobool5 = ($call4 | 0) == 0;
    if ($tobool5) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    $name = $g + 12 | 0;
    $3 = HEAP32[$name >> 2] | 0;
    $call7 = _agerr(0, 155888, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $3, tempInt) | 0) | 0;
    $call8 = _agerr(3, 128168, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $call, tempInt) | 0) | 0;
    label = 8;
    break;
   case 8:
    $4 = HEAP8[164912] | 0;
    $tobool10 = $4 << 24 >> 24 == 0;
    if ($tobool10) {
      $xd_0 = $call4;
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $call12 = +_elapsed_sec();
    $call13 = _statXDot($call4 | 0, $stats | 0) | 0;
    $5 = HEAP32[_stderr >> 2] | 0;
    $cnt = $stats | 0;
    $6 = HEAP32[$cnt >> 2] | 0;
    $call14 = _fprintf($5 | 0, 117616, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $6, HEAPF64[tempInt + 8 >> 3] = $call12, tempInt) | 0) | 0;
    $7 = HEAP32[_stderr >> 2] | 0;
    $n_polygon = $stats + 8 | 0;
    $8 = HEAP32[$n_polygon >> 2] | 0;
    $n_polygon_pts = $stats + 12 | 0;
    $9 = HEAP32[$n_polygon_pts >> 2] | 0;
    $call15 = _fprintf($7 | 0, 112264, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $8, HEAP32[tempInt + 8 >> 2] = $9, tempInt) | 0) | 0;
    $10 = HEAP32[_stderr >> 2] | 0;
    $n_polyline = $stats + 16 | 0;
    $11 = HEAP32[$n_polyline >> 2] | 0;
    $n_polyline_pts = $stats + 20 | 0;
    $12 = HEAP32[$n_polyline_pts >> 2] | 0;
    $call16 = _fprintf($10 | 0, 107904, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $11, HEAP32[tempInt + 8 >> 2] = $12, tempInt) | 0) | 0;
    $13 = HEAP32[_stderr >> 2] | 0;
    $n_bezier = $stats + 24 | 0;
    $14 = HEAP32[$n_bezier >> 2] | 0;
    $n_bezier_pts = $stats + 28 | 0;
    $15 = HEAP32[$n_bezier_pts >> 2] | 0;
    $call17 = _fprintf($13 | 0, 103872, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $14, HEAP32[tempInt + 8 >> 2] = $15, tempInt) | 0) | 0;
    $16 = HEAP32[_stderr >> 2] | 0;
    $n_ellipse = $stats + 4 | 0;
    $17 = HEAP32[$n_ellipse >> 2] | 0;
    $call18 = _fprintf($16 | 0, 99640, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $17, tempInt) | 0) | 0;
    $18 = HEAP32[_stderr >> 2] | 0;
    $n_text = $stats + 32 | 0;
    $19 = HEAP32[$n_text >> 2] | 0;
    $call19 = _fprintf($18 | 0, 95576, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $19, tempInt) | 0) | 0;
    $xd_0 = $call4;
    label = 10;
    break;
   case 10:
    $20 = $xd_0;
    STACKTOP = __stackBase__;
    return $20 | 0;
  }
  return 0;
}
function _push_obj_state($job) {
  $job = $job | 0;
  var $call = 0, $0 = 0, $tobool = 0, $call1 = 0, $obj2 = 0, $1 = 0, $parent3 = 0, $tobool5 = 0, $pencolor = 0, $pencolor7 = 0, $2 = 0, $fillcolor = 0, $fillcolor8 = 0, $3 = 0, $pen = 0, $4 = 0, $pen9 = 0, $5 = 0, $fill = 0, $6 = 0, $fill10 = 0, $7 = 0, $penwidth = 0, $8 = 0.0, $penwidth11 = 0, $9 = 0, $pen12 = 0, $10 = 0, $fill13 = 0, $11 = 0, $penwidth14 = 0, $12 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $call = _zmalloc(256) | 0;
    $0 = $call;
    $tobool = ($call | 0) == 0;
    if ($tobool) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    $call1 = _agerr(1, 92048, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
    label = 4;
    break;
   case 4:
    $obj2 = $job + 16 | 0;
    $1 = HEAP32[$obj2 >> 2] | 0;
    $parent3 = $call;
    HEAP32[$parent3 >> 2] = $1;
    HEAP32[$obj2 >> 2] = $0;
    $tobool5 = ($1 | 0) == 0;
    if ($tobool5) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $pencolor = $call + 16 | 0;
    $pencolor7 = $1 + 16 | 0;
    $2 = $pencolor7;
    HEAP32[$pencolor >> 2] = HEAP32[$2 >> 2] | 0;
    HEAP32[$pencolor + 4 >> 2] = HEAP32[$2 + 4 >> 2] | 0;
    HEAP32[$pencolor + 8 >> 2] = HEAP32[$2 + 8 >> 2] | 0;
    HEAP32[$pencolor + 12 >> 2] = HEAP32[$2 + 12 >> 2] | 0;
    HEAP32[$pencolor + 16 >> 2] = HEAP32[$2 + 16 >> 2] | 0;
    HEAP32[$pencolor + 20 >> 2] = HEAP32[$2 + 20 >> 2] | 0;
    HEAP32[$pencolor + 24 >> 2] = HEAP32[$2 + 24 >> 2] | 0;
    HEAP32[$pencolor + 28 >> 2] = HEAP32[$2 + 28 >> 2] | 0;
    HEAP32[$pencolor + 32 >> 2] = HEAP32[$2 + 32 >> 2] | 0;
    HEAP32[$pencolor + 36 >> 2] = HEAP32[$2 + 36 >> 2] | 0;
    $fillcolor = $call + 56 | 0;
    $fillcolor8 = $1 + 56 | 0;
    $3 = $fillcolor8;
    HEAP32[$fillcolor >> 2] = HEAP32[$3 >> 2] | 0;
    HEAP32[$fillcolor + 4 >> 2] = HEAP32[$3 + 4 >> 2] | 0;
    HEAP32[$fillcolor + 8 >> 2] = HEAP32[$3 + 8 >> 2] | 0;
    HEAP32[$fillcolor + 12 >> 2] = HEAP32[$3 + 12 >> 2] | 0;
    HEAP32[$fillcolor + 16 >> 2] = HEAP32[$3 + 16 >> 2] | 0;
    HEAP32[$fillcolor + 20 >> 2] = HEAP32[$3 + 20 >> 2] | 0;
    HEAP32[$fillcolor + 24 >> 2] = HEAP32[$3 + 24 >> 2] | 0;
    HEAP32[$fillcolor + 28 >> 2] = HEAP32[$3 + 28 >> 2] | 0;
    HEAP32[$fillcolor + 32 >> 2] = HEAP32[$3 + 32 >> 2] | 0;
    HEAP32[$fillcolor + 36 >> 2] = HEAP32[$3 + 36 >> 2] | 0;
    $pen = $1 + 96 | 0;
    $4 = HEAP32[$pen >> 2] | 0;
    $pen9 = $call + 96 | 0;
    $5 = $pen9;
    HEAP32[$5 >> 2] = $4;
    $fill = $1 + 100 | 0;
    $6 = HEAP32[$fill >> 2] | 0;
    $fill10 = $call + 100 | 0;
    $7 = $fill10;
    HEAP32[$7 >> 2] = $6;
    $penwidth = $1 + 104 | 0;
    $8 = +HEAPF64[$penwidth >> 3];
    $penwidth11 = $call + 104 | 0;
    $9 = $penwidth11;
    HEAPF64[$9 >> 3] = $8;
    label = 7;
    break;
   case 6:
    $pen12 = $call + 96 | 0;
    $10 = $pen12;
    HEAP32[$10 >> 2] = 3;
    $fill13 = $call + 100 | 0;
    $11 = $fill13;
    HEAP32[$11 >> 2] = 0;
    $penwidth14 = $call + 104 | 0;
    $12 = $penwidth14;
    HEAPF64[$12 >> 3] = 1.0;
    label = 7;
    break;
   case 7:
    STACKTOP = __stackBase__;
    return $0 | 0;
  }
  return 0;
}
function _initMapData($job, $lbl, $url, $tooltip, $target, $id, $gobj) {
  $job = $job | 0;
  $lbl = $lbl | 0;
  $url = $url | 0;
  $tooltip = $tooltip | 0;
  $target = $target | 0;
  $id = $id | 0;
  $gobj = $gobj | 0;
  var $obj1 = 0, $0 = 0, $flags2 = 0, $1 = 0, $and = 0, $tobool = 0, $tobool3 = 0, $or_cond = 0, $label = 0, $and4 = 0, $tobool5 = 0, $call = 0, $id7 = 0, $tobool8 = 0, $2 = 0, $tobool10 = 0, $call12 = 0, $url13 = 0, $assigned_0 = 0, $and16 = 0, $tobool17 = 0, $tobool19 = 0, $3 = 0, $tobool23 = 0, $call25 = 0, $tooltip26 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $label27 = 0, $8 = 0, $tobool28 = 0, $call31 = 0, $tooltip32 = 0, $assigned_1 = 0, $and36 = 0, $tobool37 = 0, $tobool39 = 0, $or_cond23 = 0, $9 = 0, $tobool43 = 0, $call45 = 0, $target46 = 0, $assigned_2 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $obj1 = $job + 16 | 0;
    $0 = HEAP32[$obj1 >> 2] | 0;
    $flags2 = $job + 152 | 0;
    $1 = HEAP32[$flags2 >> 2] | 0;
    $and = $1 & 32768;
    $tobool = ($and | 0) == 0;
    $tobool3 = ($lbl | 0) == 0;
    $or_cond = $tobool | $tobool3;
    if ($or_cond) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $label = $0 + 144 | 0;
    HEAP32[$label >> 2] = $lbl;
    label = 4;
    break;
   case 4:
    $and4 = $1 & 65536;
    $tobool5 = ($and4 | 0) == 0;
    if ($tobool5) {
      $assigned_0 = 0;
      label = 8;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $call = _strdup_and_subst_obj($id, $gobj) | 0;
    $id7 = $0 + 164 | 0;
    HEAP32[$id7 >> 2] = $call;
    $tobool8 = ($url | 0) == 0;
    if ($tobool8) {
      $assigned_0 = 0;
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $2 = HEAP8[$url] | 0;
    $tobool10 = $2 << 24 >> 24 == 0;
    if ($tobool10) {
      $assigned_0 = 0;
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $call12 = _strdup_and_subst_obj($url, $gobj) | 0;
    $url13 = $0 + 160 | 0;
    HEAP32[$url13 >> 2] = $call12;
    $assigned_0 = 1;
    label = 8;
    break;
   case 8:
    $and16 = $1 & 4194304;
    $tobool17 = ($and16 | 0) == 0;
    if ($tobool17) {
      $assigned_1 = $assigned_0;
      label = 14;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $tobool19 = ($tooltip | 0) == 0;
    if ($tobool19) {
      label = 12;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $3 = HEAP8[$tooltip] | 0;
    $tobool23 = $3 << 24 >> 24 == 0;
    if ($tobool23) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $call25 = _strdup_and_subst_obj($tooltip, $gobj) | 0;
    $tooltip26 = $0 + 180 | 0;
    HEAP32[$tooltip26 >> 2] = $call25;
    $4 = $0 + 212 | 0;
    $5 = $4;
    $6 = HEAP32[$5 >> 2] | 0;
    $7 = $6 | 1;
    HEAP32[$5 >> 2] = $7;
    $assigned_1 = 1;
    label = 14;
    break;
   case 12:
    $label27 = $0 + 144 | 0;
    $8 = HEAP32[$label27 >> 2] | 0;
    $tobool28 = ($8 | 0) == 0;
    if ($tobool28) {
      $assigned_1 = $assigned_0;
      label = 14;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $call31 = _strdup($8 | 0) | 0;
    $tooltip32 = $0 + 180 | 0;
    HEAP32[$tooltip32 >> 2] = $call31;
    $assigned_1 = 1;
    label = 14;
    break;
   case 14:
    $and36 = $1 & 8388608;
    $tobool37 = ($and36 | 0) == 0;
    $tobool39 = ($target | 0) == 0;
    $or_cond23 = $tobool37 | $tobool39;
    if ($or_cond23) {
      $assigned_2 = $assigned_1;
      label = 17;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    $9 = HEAP8[$target] | 0;
    $tobool43 = $9 << 24 >> 24 == 0;
    if ($tobool43) {
      $assigned_2 = $assigned_1;
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $call45 = _strdup_and_subst_obj($target, $gobj) | 0;
    $target46 = $0 + 196 | 0;
    HEAP32[$target46 >> 2] = $call45;
    $assigned_2 = 1;
    label = 17;
    break;
   case 17:
    return $assigned_2 | 0;
  }
  return 0;
}
function _getObjId($job, $obj, $xb) {
  $job = $job | 0;
  $obj = $obj | 0;
  $xb = $xb | 0;
  var $buf = 0, $gvc = 0, $0 = 0, $g = 0, $1 = 0, $drawing = 0, $2 = 0, $id1 = 0, $3 = 0, $call = 0, $tobool = 0, $4 = 0, $tobool2 = 0, $5 = 0, $6 = 0, $7 = 0, $bf_val_sext = 0, $meta_node = 0, $8 = 0, $9 = 0, $id3 = 0, $10 = 0, $id5 = 0, $11 = 0, $12 = 0, $id7 = 0, $13 = 0, $14 = 0, $idnum_0 = 0, $pfx_0 = 0, $tobool8 = 0, $call10 = 0, $ptr = 0, $15 = 0, $eptr = 0, $16 = 0, $cmp = 0, $call12 = 0, $17 = 0, $incdec_ptr = 0, $call15 = 0, $arraydecay = 0, $call16 = 0, $call18 = 0, $ptr19 = 0, $18 = 0, $eptr20 = 0, $19 = 0, $cmp21 = 0, $call24 = 0, $20 = 0, $buf30 = 0, $21 = 0, $retval_0 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 32 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $buf = __stackBase__ | 0;
    $gvc = $job | 0;
    $0 = HEAP32[$gvc >> 2] | 0;
    $g = $0 + 128 | 0;
    $1 = HEAP32[$g >> 2] | 0;
    $drawing = $1 + 48 | 0;
    $2 = HEAP32[$drawing >> 2] | 0;
    $id1 = $2 + 92 | 0;
    $3 = HEAP32[$id1 >> 2] | 0;
    $call = _agget($obj, 155120) | 0;
    $tobool = ($call | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $4 = HEAP8[$call] | 0;
    $tobool2 = $4 << 24 >> 24 == 0;
    if ($tobool2) {
      label = 4;
      break;
    } else {
      $retval_0 = $call;
      label = 15;
      break;
    }
   case 4:
    $5 = $obj;
    $6 = HEAP32[$5 >> 2] | 0;
    $7 = $6 << 28;
    $bf_val_sext = $7 >> 28;
    if (($bf_val_sext | 0) == 3) {
      label = 5;
      break;
    } else if (($bf_val_sext | 0) == 1) {
      label = 6;
      break;
    } else if (($bf_val_sext | 0) == 2) {
      label = 7;
      break;
    } else {
      $pfx_0 = 0;
      $idnum_0 = 0;
      label = 8;
      break;
    }
   case 5:
    $meta_node = $obj + 36 | 0;
    $8 = $meta_node;
    $9 = HEAP32[$8 >> 2] | 0;
    $id3 = $9 + 16 | 0;
    $10 = HEAP32[$id3 >> 2] | 0;
    $pfx_0 = 151640;
    $idnum_0 = $10;
    label = 8;
    break;
   case 6:
    $id5 = $obj + 16 | 0;
    $11 = $id5;
    $12 = HEAP32[$11 >> 2] | 0;
    $pfx_0 = 148304;
    $idnum_0 = $12;
    label = 8;
    break;
   case 7:
    $id7 = $obj + 20 | 0;
    $13 = $id7;
    $14 = HEAP32[$13 >> 2] | 0;
    $pfx_0 = 145504;
    $idnum_0 = $14;
    label = 8;
    break;
   case 8:
    $tobool8 = ($3 | 0) == 0;
    if ($tobool8) {
      label = 12;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $call10 = _agxbput($xb, $3) | 0;
    $ptr = $xb + 4 | 0;
    $15 = HEAP32[$ptr >> 2] | 0;
    $eptr = $xb + 8 | 0;
    $16 = HEAP32[$eptr >> 2] | 0;
    $cmp = $15 >>> 0 < $16 >>> 0;
    if ($cmp) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $call12 = _agxbmore($xb, 1) | 0;
    label = 11;
    break;
   case 11:
    $17 = HEAP32[$ptr >> 2] | 0;
    $incdec_ptr = $17 + 1 | 0;
    HEAP32[$ptr >> 2] = $incdec_ptr;
    HEAP8[$17] = 95;
    label = 12;
    break;
   case 12:
    $call15 = _agxbput($xb, $pfx_0) | 0;
    $arraydecay = $buf | 0;
    $call16 = _sprintf($arraydecay | 0, 142424, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $idnum_0, tempInt) | 0) | 0;
    $call18 = _agxbput($xb, $arraydecay) | 0;
    $ptr19 = $xb + 4 | 0;
    $18 = HEAP32[$ptr19 >> 2] | 0;
    $eptr20 = $xb + 8 | 0;
    $19 = HEAP32[$eptr20 >> 2] | 0;
    $cmp21 = $18 >>> 0 < $19 >>> 0;
    if ($cmp21) {
      label = 14;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $call24 = _agxbmore($xb, 1) | 0;
    label = 14;
    break;
   case 14:
    $20 = HEAP32[$ptr19 >> 2] | 0;
    HEAP8[$20] = 0;
    $buf30 = $xb | 0;
    $21 = HEAP32[$buf30 >> 2] | 0;
    HEAP32[$ptr19 >> 2] = $21;
    $retval_0 = $21;
    label = 15;
    break;
   case 15:
    STACKTOP = __stackBase__;
    return $retval_0 | 0;
  }
  return 0;
}
function _emit_map_rect($job, $b) {
  $job = $job | 0;
  $b = $b | 0;
  var $obj1 = 0, $0 = 0, $flags2 = 0, $1 = 0, $and = 0, $tobool = 0, $and3 = 0, $tobool4 = 0, $url_map_shape = 0, $url_map_n = 0, $url_map_n7 = 0, $url_map_p = 0, $2 = 0, $3 = 0, $url_map_n8 = 0, $4 = 0, $mul = 0, $call = 0, $5 = 0, $6 = 0, $arrayidx10 = 0, $UR = 0, $7 = 0, $and11 = 0, $tobool12 = 0, $call14 = 0, label = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  tempParam = $b;
  $b = STACKTOP;
  STACKTOP = STACKTOP + 32 | 0;
  _memcpy($b, tempParam, 32);
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $obj1 = $job + 16 | 0;
    $0 = HEAP32[$obj1 >> 2] | 0;
    $flags2 = $job + 152 | 0;
    $1 = HEAP32[$flags2 >> 2] | 0;
    $and = $1 & 4259840;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 10;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $and3 = $1 & 131072;
    $tobool4 = ($and3 | 0) != 0;
    $url_map_shape = $0 + 216 | 0;
    if ($tobool4) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    HEAP32[$url_map_shape >> 2] = 0;
    $url_map_n = $0 + 220 | 0;
    HEAP32[$url_map_n >> 2] = 2;
    label = 6;
    break;
   case 5:
    HEAP32[$url_map_shape >> 2] = 2;
    $url_map_n7 = $0 + 220 | 0;
    HEAP32[$url_map_n7 >> 2] = 4;
    label = 6;
    break;
   case 6:
    $url_map_p = $0 + 224 | 0;
    $2 = HEAP32[$url_map_p >> 2] | 0;
    $3 = $2;
    _free($3);
    $url_map_n8 = $0 + 220 | 0;
    $4 = HEAP32[$url_map_n8 >> 2] | 0;
    $mul = $4 << 4;
    $call = _zmalloc($mul) | 0;
    $5 = $call;
    HEAP32[$url_map_p >> 2] = $5;
    $6 = $b;
    HEAP32[$call >> 2] = HEAP32[$6 >> 2] | 0;
    HEAP32[$call + 4 >> 2] = HEAP32[$6 + 4 >> 2] | 0;
    HEAP32[$call + 8 >> 2] = HEAP32[$6 + 8 >> 2] | 0;
    HEAP32[$call + 12 >> 2] = HEAP32[$6 + 12 >> 2] | 0;
    $arrayidx10 = $call + 16 | 0;
    $UR = $b + 16 | 0;
    $7 = $UR;
    HEAP32[$arrayidx10 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$arrayidx10 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$arrayidx10 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$arrayidx10 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    $and11 = $1 & 8192;
    $tobool12 = ($and11 | 0) == 0;
    if ($tobool12) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    $call14 = _gvrender_ptf_A($job, $5, $5, 2) | 0;
    label = 8;
    break;
   case 8:
    if ($tobool4) {
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    _rect2poly($5);
    label = 10;
    break;
   case 10:
    STACKTOP = __stackBase__;
    return;
  }
}
function _pop_obj_state($job) {
  $job = $job | 0;
  var $obj1 = 0, $0 = 0, $tobool = 0, $id = 0, $1 = 0, $url = 0, $2 = 0, $labelurl = 0, $3 = 0, $tailurl = 0, $4 = 0, $headurl = 0, $5 = 0, $tooltip = 0, $6 = 0, $labeltooltip = 0, $7 = 0, $tailtooltip = 0, $8 = 0, $headtooltip = 0, $9 = 0, $target = 0, $10 = 0, $labeltarget = 0, $11 = 0, $tailtarget = 0, $12 = 0, $headtarget = 0, $13 = 0, $url_map_p = 0, $14 = 0, $15 = 0, $url_bsplinemap_p = 0, $16 = 0, $17 = 0, $url_bsplinemap_n = 0, $18 = 0, $19 = 0, $parent = 0, $20 = 0, $21 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $obj1 = $job + 16 | 0;
    $0 = HEAP32[$obj1 >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    ___assert_func(162152, 110, 163952, 158632);
   case 4:
    $id = $0 + 164 | 0;
    $1 = HEAP32[$id >> 2] | 0;
    _free($1);
    $url = $0 + 160 | 0;
    $2 = HEAP32[$url >> 2] | 0;
    _free($2);
    $labelurl = $0 + 168 | 0;
    $3 = HEAP32[$labelurl >> 2] | 0;
    _free($3);
    $tailurl = $0 + 172 | 0;
    $4 = HEAP32[$tailurl >> 2] | 0;
    _free($4);
    $headurl = $0 + 176 | 0;
    $5 = HEAP32[$headurl >> 2] | 0;
    _free($5);
    $tooltip = $0 + 180 | 0;
    $6 = HEAP32[$tooltip >> 2] | 0;
    _free($6);
    $labeltooltip = $0 + 184 | 0;
    $7 = HEAP32[$labeltooltip >> 2] | 0;
    _free($7);
    $tailtooltip = $0 + 188 | 0;
    $8 = HEAP32[$tailtooltip >> 2] | 0;
    _free($8);
    $headtooltip = $0 + 192 | 0;
    $9 = HEAP32[$headtooltip >> 2] | 0;
    _free($9);
    $target = $0 + 196 | 0;
    $10 = HEAP32[$target >> 2] | 0;
    _free($10);
    $labeltarget = $0 + 200 | 0;
    $11 = HEAP32[$labeltarget >> 2] | 0;
    _free($11);
    $tailtarget = $0 + 204 | 0;
    $12 = HEAP32[$tailtarget >> 2] | 0;
    _free($12);
    $headtarget = $0 + 208 | 0;
    $13 = HEAP32[$headtarget >> 2] | 0;
    _free($13);
    $url_map_p = $0 + 224 | 0;
    $14 = HEAP32[$url_map_p >> 2] | 0;
    $15 = $14;
    _free($15);
    $url_bsplinemap_p = $0 + 236 | 0;
    $16 = HEAP32[$url_bsplinemap_p >> 2] | 0;
    $17 = $16;
    _free($17);
    $url_bsplinemap_n = $0 + 232 | 0;
    $18 = HEAP32[$url_bsplinemap_n >> 2] | 0;
    $19 = $18;
    _free($19);
    $parent = $0 | 0;
    $20 = HEAP32[$parent >> 2] | 0;
    HEAP32[$obj1 >> 2] = $20;
    $21 = $0;
    _free($21);
    return;
  }
}
function _validlayer($job) {
  $job = $job | 0;
  return (HEAP32[$job + 160 >> 2] | 0) <= (HEAP32[$job + 156 >> 2] | 0) & 1 | 0;
}
function _firstpage($job) {
  $job = $job | 0;
  var $0 = 0, $1 = 0, $2$1 = 0;
  $0 = $job + 172 | 0;
  $1 = $job + 196 | 0;
  $2$1 = HEAP32[$0 + 4 >> 2] | 0;
  HEAP32[$1 >> 2] = HEAP32[$0 >> 2] | 0;
  HEAP32[$1 + 4 >> 2] = $2$1;
  return;
}
function _validpage($job) {
  $job = $job | 0;
  var $x = 0, $0 = 0, $cmp = 0, $x3 = 0, $1 = 0, $cmp4 = 0, $y = 0, $2 = 0, $cmp7 = 0, $y11 = 0, $3 = 0, $cmp12 = 0, $phitmp = 0, $4 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $x = $job + 196 | 0;
    $0 = HEAP32[$x >> 2] | 0;
    $cmp = ($0 | 0) > -1;
    if ($cmp) {
      label = 3;
      break;
    } else {
      $4 = 0;
      label = 6;
      break;
    }
   case 3:
    $x3 = $job + 164 | 0;
    $1 = HEAP32[$x3 >> 2] | 0;
    $cmp4 = ($0 | 0) < ($1 | 0);
    if ($cmp4) {
      label = 4;
      break;
    } else {
      $4 = 0;
      label = 6;
      break;
    }
   case 4:
    $y = $job + 200 | 0;
    $2 = HEAP32[$y >> 2] | 0;
    $cmp7 = ($2 | 0) > -1;
    if ($cmp7) {
      label = 5;
      break;
    } else {
      $4 = 0;
      label = 6;
      break;
    }
   case 5:
    $y11 = $job + 168 | 0;
    $3 = HEAP32[$y11 >> 2] | 0;
    $cmp12 = ($2 | 0) < ($3 | 0);
    $phitmp = $cmp12 & 1;
    $4 = $phitmp;
    label = 6;
    break;
   case 6:
    return $4 | 0;
  }
  return 0;
}
function _nextlayer($job) {
  $job = $job | 0;
  var $layerNum = 0;
  $layerNum = $job + 160 | 0;
  HEAP32[$layerNum >> 2] = (HEAP32[$layerNum >> 2] | 0) + 1 | 0;
  return;
}
function _update_bb_bz($bb, $cp) {
  $bb = $bb | 0;
  $cp = $cp | 0;
  var $left = 0, $right = 0, $tmp = 0, $x = 0, $0 = 0.0, $x1 = 0, $1 = 0.0, $cmp = 0, $x4 = 0, $2 = 0.0, $cmp5 = 0, $y = 0, $3 = 0.0, $y9 = 0, $4 = 0.0, $cmp10 = 0, $y15 = 0, $5 = 0.0, $cmp16 = 0, $x19 = 0, $6 = 0.0, $cmp22 = 0, $cmp28 = 0, $or_cond = 0, $y31 = 0, $7 = 0.0, $cmp34 = 0, $cmp40 = 0, $or_cond54 = 0, $x43 = 0, $8 = 0.0, $cmp46 = 0, $cmp52 = 0, $or_cond55 = 0, $y55 = 0, $9 = 0.0, $cmp58 = 0, $cmp64 = 0, $or_cond56 = 0, $x67 = 0, $10 = 0.0, $cmp70 = 0, $cmp76 = 0, $or_cond57 = 0, $y79 = 0, $11 = 0.0, $cmp82 = 0, $cmp88 = 0, $or_cond58 = 0, $call = 0, $tobool = 0, $y115 = 0, $y126 = 0, $x104 = 0, $x92 = 0, $12 = 0.0, $13 = 0.0, $cmp95 = 0, $14 = 0.0, $cmp105 = 0, $y113 = 0, $15 = 0.0, $16 = 0.0, $cmp116 = 0, $17 = 0.0, $cmp127 = 0, $x92_1 = 0, $18 = 0.0, $19 = 0.0, $cmp95_1 = 0, $arraydecay = 0, $arraydecay136 = 0, $20 = 0.0, $cmp105_1 = 0, $y113_1 = 0, $21 = 0.0, $22 = 0.0, $cmp116_1 = 0, $23 = 0.0, $cmp127_1 = 0, $x92_2 = 0, $24 = 0.0, $25 = 0.0, $cmp95_2 = 0, $26 = 0.0, $cmp105_2 = 0, $y113_2 = 0, $27 = 0.0, $28 = 0.0, $cmp116_2 = 0, $29 = 0.0, $cmp127_2 = 0, $x92_3 = 0, $30 = 0.0, $31 = 0.0, $cmp95_3 = 0, $32 = 0.0, $cmp105_3 = 0, $y113_3 = 0, $33 = 0.0, $34 = 0.0, $cmp116_3 = 0, $35 = 0.0, $cmp127_3 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 144 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $left = __stackBase__ | 0;
    $right = __stackBase__ + 64 | 0;
    $tmp = __stackBase__ + 128 | 0;
    $x = $cp | 0;
    $0 = +HEAPF64[$x >> 3];
    $x1 = $bb + 16 | 0;
    $1 = +HEAPF64[$x1 >> 3];
    $cmp = $0 > $1;
    if ($cmp) {
      label = 12;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $x4 = $bb | 0;
    $2 = +HEAPF64[$x4 >> 3];
    $cmp5 = $0 < $2;
    if ($cmp5) {
      label = 12;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $y = $cp + 8 | 0;
    $3 = +HEAPF64[$y >> 3];
    $y9 = $bb + 24 | 0;
    $4 = +HEAPF64[$y9 >> 3];
    $cmp10 = $3 > $4;
    if ($cmp10) {
      label = 12;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $y15 = $bb + 8 | 0;
    $5 = +HEAPF64[$y15 >> 3];
    $cmp16 = $3 < $5;
    if ($cmp16) {
      label = 12;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $x19 = $cp + 16 | 0;
    $6 = +HEAPF64[$x19 >> 3];
    $cmp22 = $6 > $1;
    $cmp28 = $6 < $2;
    $or_cond = $cmp22 | $cmp28;
    if ($or_cond) {
      label = 12;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $y31 = $cp + 24 | 0;
    $7 = +HEAPF64[$y31 >> 3];
    $cmp34 = $7 > $4;
    $cmp40 = $7 < $5;
    $or_cond54 = $cmp34 | $cmp40;
    if ($or_cond54) {
      label = 12;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $x43 = $cp + 32 | 0;
    $8 = +HEAPF64[$x43 >> 3];
    $cmp46 = $8 > $1;
    $cmp52 = $8 < $2;
    $or_cond55 = $cmp46 | $cmp52;
    if ($or_cond55) {
      label = 12;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $y55 = $cp + 40 | 0;
    $9 = +HEAPF64[$y55 >> 3];
    $cmp58 = $9 > $4;
    $cmp64 = $9 < $5;
    $or_cond56 = $cmp58 | $cmp64;
    if ($or_cond56) {
      label = 12;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $x67 = $cp + 48 | 0;
    $10 = +HEAPF64[$x67 >> 3];
    $cmp70 = $10 > $1;
    $cmp76 = $10 < $2;
    $or_cond57 = $cmp70 | $cmp76;
    if ($or_cond57) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $y79 = $cp + 56 | 0;
    $11 = +HEAPF64[$y79 >> 3];
    $cmp82 = $11 > $4;
    $cmp88 = $11 < $5;
    $or_cond58 = $cmp82 | $cmp88;
    if ($or_cond58) {
      label = 12;
      break;
    } else {
      label = 23;
      break;
    }
   case 12:
    $call = _check_control_points($cp) | 0;
    $tobool = ($call | 0) == 0;
    if ($tobool) {
      label = 22;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $y115 = $bb + 24 | 0;
    $y126 = $bb + 8 | 0;
    $x104 = $bb | 0;
    $x92 = $cp | 0;
    $12 = +HEAPF64[$x92 >> 3];
    $13 = +HEAPF64[$x1 >> 3];
    $cmp95 = $12 > $13;
    if ($cmp95) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAPF64[$x1 >> 3] = $12;
    label = 17;
    break;
   case 15:
    $14 = +HEAPF64[$x104 >> 3];
    $cmp105 = $12 < $14;
    if ($cmp105) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    HEAPF64[$x104 >> 3] = $12;
    label = 17;
    break;
   case 17:
    $y113 = $cp + 8 | 0;
    $15 = +HEAPF64[$y113 >> 3];
    $16 = +HEAPF64[$y115 >> 3];
    $cmp116 = $15 > $16;
    if ($cmp116) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    HEAPF64[$y115 >> 3] = $15;
    label = 21;
    break;
   case 19:
    $17 = +HEAPF64[$y126 >> 3];
    $cmp127 = $15 < $17;
    if ($cmp127) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    HEAPF64[$y126 >> 3] = $15;
    label = 21;
    break;
   case 21:
    $x92_1 = $cp + 16 | 0;
    $18 = +HEAPF64[$x92_1 >> 3];
    $19 = +HEAPF64[$x1 >> 3];
    $cmp95_1 = $18 > $19;
    if ($cmp95_1) {
      label = 26;
      break;
    } else {
      label = 24;
      break;
    }
   case 22:
    $arraydecay = $left | 0;
    $arraydecay136 = $right | 0;
    _Bezier($tmp, $cp, 3, .5, $arraydecay, $arraydecay136);
    _update_bb_bz($bb, $arraydecay);
    _update_bb_bz($bb, $arraydecay136);
    label = 23;
    break;
   case 23:
    STACKTOP = __stackBase__;
    return;
   case 24:
    $20 = +HEAPF64[$x104 >> 3];
    $cmp105_1 = $18 < $20;
    if ($cmp105_1) {
      label = 25;
      break;
    } else {
      label = 27;
      break;
    }
   case 25:
    HEAPF64[$x104 >> 3] = $18;
    label = 27;
    break;
   case 26:
    HEAPF64[$x1 >> 3] = $18;
    label = 27;
    break;
   case 27:
    $y113_1 = $cp + 24 | 0;
    $21 = +HEAPF64[$y113_1 >> 3];
    $22 = +HEAPF64[$y115 >> 3];
    $cmp116_1 = $21 > $22;
    if ($cmp116_1) {
      label = 30;
      break;
    } else {
      label = 28;
      break;
    }
   case 28:
    $23 = +HEAPF64[$y126 >> 3];
    $cmp127_1 = $21 < $23;
    if ($cmp127_1) {
      label = 29;
      break;
    } else {
      label = 31;
      break;
    }
   case 29:
    HEAPF64[$y126 >> 3] = $21;
    label = 31;
    break;
   case 30:
    HEAPF64[$y115 >> 3] = $21;
    label = 31;
    break;
   case 31:
    $x92_2 = $cp + 32 | 0;
    $24 = +HEAPF64[$x92_2 >> 3];
    $25 = +HEAPF64[$x1 >> 3];
    $cmp95_2 = $24 > $25;
    if ($cmp95_2) {
      label = 34;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    $26 = +HEAPF64[$x104 >> 3];
    $cmp105_2 = $24 < $26;
    if ($cmp105_2) {
      label = 33;
      break;
    } else {
      label = 35;
      break;
    }
   case 33:
    HEAPF64[$x104 >> 3] = $24;
    label = 35;
    break;
   case 34:
    HEAPF64[$x1 >> 3] = $24;
    label = 35;
    break;
   case 35:
    $y113_2 = $cp + 40 | 0;
    $27 = +HEAPF64[$y113_2 >> 3];
    $28 = +HEAPF64[$y115 >> 3];
    $cmp116_2 = $27 > $28;
    if ($cmp116_2) {
      label = 38;
      break;
    } else {
      label = 36;
      break;
    }
   case 36:
    $29 = +HEAPF64[$y126 >> 3];
    $cmp127_2 = $27 < $29;
    if ($cmp127_2) {
      label = 37;
      break;
    } else {
      label = 39;
      break;
    }
   case 37:
    HEAPF64[$y126 >> 3] = $27;
    label = 39;
    break;
   case 38:
    HEAPF64[$y115 >> 3] = $27;
    label = 39;
    break;
   case 39:
    $x92_3 = $cp + 48 | 0;
    $30 = +HEAPF64[$x92_3 >> 3];
    $31 = +HEAPF64[$x1 >> 3];
    $cmp95_3 = $30 > $31;
    if ($cmp95_3) {
      label = 42;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    $32 = +HEAPF64[$x104 >> 3];
    $cmp105_3 = $30 < $32;
    if ($cmp105_3) {
      label = 41;
      break;
    } else {
      label = 43;
      break;
    }
   case 41:
    HEAPF64[$x104 >> 3] = $30;
    label = 43;
    break;
   case 42:
    HEAPF64[$x1 >> 3] = $30;
    label = 43;
    break;
   case 43:
    $y113_3 = $cp + 56 | 0;
    $33 = +HEAPF64[$y113_3 >> 3];
    $34 = +HEAPF64[$y115 >> 3];
    $cmp116_3 = $33 > $34;
    if ($cmp116_3) {
      label = 46;
      break;
    } else {
      label = 44;
      break;
    }
   case 44:
    $35 = +HEAPF64[$y126 >> 3];
    $cmp127_3 = $33 < $35;
    if ($cmp127_3) {
      label = 45;
      break;
    } else {
      label = 23;
      break;
    }
   case 45:
    HEAPF64[$y126 >> 3] = $33;
    label = 23;
    break;
   case 46:
    HEAPF64[$y115 >> 3] = $33;
    label = 23;
    break;
  }
}
function _check_control_points($cp) {
  $cp = $cp | 0;
  var $arrayidx1 = 0, $call = 0.0;
  $arrayidx1 = $cp + 48 | 0;
  $call = +_ptToLine2($cp, $arrayidx1, $cp + 16 | 0);
  return $call < 4.0 & +_ptToLine2($cp, $arrayidx1, $cp + 32 | 0) < 4.0 & 1 | 0;
}
function _emit_graph($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $flags1 = 0, $0 = 0, $zoom = 0, $1 = 0.0, $x = 0, $2 = 0.0, $mul = 0.0, $div = 0.0, $x2 = 0, $3 = 0.0, $y = 0, $4 = 0.0, $mul5 = 0.0, $div6 = 0.0, $y8 = 0, $5 = 0.0, $div11 = 0.0, $x12 = 0, $6 = 0.0, $div15 = 0.0, $y17 = 0, $7 = 0, $and = 0, $8 = 0, $9 = 0, $10 = 0, $mul22 = 0.0, $rotation = 0, $11 = 0, $tobool23 = 0, $width = 0, $12 = 0, $conv = 0.0, $13 = 0.0, $div27 = 0.0, $y28 = 0, $height = 0, $14 = 0, $conv29 = 0.0, $15 = 0.0, $div32 = 0.0, $x34 = 0, $16 = 0.0, $div39 = 0.0, $x41 = 0, $height42 = 0, $17 = 0, $conv43 = 0.0, $18 = 0.0, $div46 = 0.0, $y48 = 0, $19 = 0, $call = 0, $call50 = 0, $and51 = 0, $tobool52 = 0, $20 = 0, $call55 = 0, $tobool5650 = 0, $n_0_in51 = 0, $state = 0, $21 = 0, $call57 = 0, $tobool56 = 0, $call5948 = 0, $tobool6049 = 0, $numLayers = 0, $22 = 0, $cmp = 0, $call6646 = 0, $tobool6747 = 0, $call66 = 0, $tobool67 = 0, $23 = 0, $cmp72 = 0, $call59 = 0, $tobool60 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $flags1 = $job + 152 | 0;
    $0 = HEAP32[$flags1 >> 2] | 0;
    $zoom = $job + 352 | 0;
    $1 = +HEAPF64[$zoom >> 3];
    $x = $job + 432 | 0;
    $2 = +HEAPF64[$x >> 3];
    $mul = $1 * $2;
    $div = $mul / 72.0;
    $x2 = $job + 488 | 0;
    HEAPF64[$x2 >> 3] = $div;
    $3 = +HEAPF64[$zoom >> 3];
    $y = $job + 440 | 0;
    $4 = +HEAPF64[$y >> 3];
    $mul5 = $3 * $4;
    $div6 = $mul5 / 72.0;
    $y8 = $job + 496 | 0;
    HEAPF64[$y8 >> 3] = $div6;
    $5 = +HEAPF64[$x >> 3];
    $div11 = $5 / 72.0;
    $x12 = $job + 520 | 0;
    HEAPF64[$x12 >> 3] = $div11;
    $6 = +HEAPF64[$y >> 3];
    $div15 = $6 / 72.0;
    $y17 = $job + 528 | 0;
    HEAPF64[$y17 >> 3] = $div15;
    $7 = HEAP32[$flags1 >> 2] | 0;
    $and = $7 & 4096;
    $8 = HEAP32[41182] | 0;
    $9 = $and | $8;
    $10 = ($9 | 0) == 0;
    if ($10) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $mul22 = $div15 * -1.0;
    HEAPF64[$y17 >> 3] = $mul22;
    label = 4;
    break;
   case 4:
    $rotation = $job + 360 | 0;
    $11 = HEAP32[$rotation >> 2] | 0;
    $tobool23 = ($11 | 0) == 0;
    $width = $job + 448 | 0;
    $12 = HEAP32[$width >> 2] | 0;
    $conv = +($12 >>> 0 >>> 0);
    if ($tobool23) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $13 = +HEAPF64[$y8 >> 3];
    $div27 = $conv / $13;
    $y28 = $job + 376 | 0;
    HEAPF64[$y28 >> 3] = $div27;
    $height = $job + 452 | 0;
    $14 = HEAP32[$height >> 2] | 0;
    $conv29 = +($14 >>> 0 >>> 0);
    $15 = +HEAPF64[$x2 >> 3];
    $div32 = $conv29 / $15;
    $x34 = $job + 368 | 0;
    HEAPF64[$x34 >> 3] = $div32;
    label = 7;
    break;
   case 6:
    $16 = +HEAPF64[$x2 >> 3];
    $div39 = $conv / $16;
    $x41 = $job + 368 | 0;
    HEAPF64[$x41 >> 3] = $div39;
    $height42 = $job + 452 | 0;
    $17 = HEAP32[$height42 >> 2] | 0;
    $conv43 = +($17 >>> 0 >>> 0);
    $18 = +HEAPF64[$y8 >> 3];
    $div46 = $conv43 / $18;
    $y48 = $job + 376 | 0;
    HEAPF64[$y48 >> 3] = $div46;
    label = 7;
    break;
   case 7:
    $19 = $g | 0;
    $call = _agfindattr($19, 138904) | 0;
    $call50 = _late_string($19, $call, 136112) | 0;
    _gvrender_comment($job, $call50);
    _emit_begin_graph($job, $g);
    $and51 = $0 & 2;
    $tobool52 = ($and51 | 0) == 0;
    if ($tobool52) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    _emit_colors($job, $g);
    label = 9;
    break;
   case 9:
    $20 = $g;
    $call55 = _agfstnode($20) | 0;
    $tobool5650 = ($call55 | 0) == 0;
    if ($tobool5650) {
      label = 11;
      break;
    } else {
      $n_0_in51 = $call55;
      label = 10;
      break;
    }
   case 10:
    $state = $n_0_in51 + 132 | 0;
    $21 = $state;
    HEAP8[$21] = 0;
    $call57 = _agnxtnode($20, $n_0_in51) | 0;
    $tobool56 = ($call57 | 0) == 0;
    if ($tobool56) {
      label = 11;
      break;
    } else {
      $n_0_in51 = $call57;
      label = 10;
      break;
    }
   case 11:
    _firstlayer($job);
    $call5948 = _validlayer($job) | 0;
    $tobool6049 = $call5948 << 24 >> 24 == 0;
    if ($tobool6049) {
      label = 20;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $numLayers = $job + 156 | 0;
    label = 13;
    break;
   case 13:
    $22 = HEAP32[$numLayers >> 2] | 0;
    $cmp = ($22 | 0) > 1;
    if ($cmp) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    _gvrender_begin_layer($job);
    label = 15;
    break;
   case 15:
    _firstpage($job);
    $call6646 = _validpage($job) | 0;
    $tobool6747 = $call6646 << 24 >> 24 == 0;
    if ($tobool6747) {
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    _emit_page($job, $g);
    _nextpage($job);
    $call66 = _validpage($job) | 0;
    $tobool67 = $call66 << 24 >> 24 == 0;
    if ($tobool67) {
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 17:
    $23 = HEAP32[$numLayers >> 2] | 0;
    $cmp72 = ($23 | 0) > 1;
    if ($cmp72) {
      label = 18;
      break;
    } else {
      label = 19;
      break;
    }
   case 18:
    _gvrender_end_layer($job);
    label = 19;
    break;
   case 19:
    _nextlayer($job);
    $call59 = _validlayer($job) | 0;
    $tobool60 = $call59 << 24 >> 24 == 0;
    if ($tobool60) {
      label = 20;
      break;
    } else {
      label = 13;
      break;
    }
   case 20:
    _emit_end_graph($job);
    return;
  }
}
function _emit_begin_graph($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $call = 0;
  $call = _push_obj_state($job) | 0;
  HEAP32[$call + 4 >> 2] = 0;
  HEAP32[$call + 8 >> 2] = $g;
  HEAP32[$call + 12 >> 2] = 0;
  _initObjMapData($job, HEAP32[$g + 52 >> 2] | 0, $g | 0);
  _gvrender_begin_graph($job, $g);
  return;
}
function _emit_colors($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $0 = 0, $call = 0, $cmp = 0, $1 = 0, $tobool = 0, $call1 = 0, $cmp2 = 0, $2 = 0, $tobool7 = 0, $3 = 0, $call10 = 0, $tobool1147 = 0, $n_0_in48 = 0, $4 = 0, $call12 = 0, $cmp13 = 0, $5 = 0, $tobool18 = 0, $call21 = 0, $cmp22 = 0, $6 = 0, $tobool27 = 0, $call30 = 0, $cmp31 = 0, $7 = 0, $tobool36 = 0, $call39 = 0, $tobool4145 = 0, $e_0_in46 = 0, $8 = 0, $call43 = 0, $cmp44 = 0, $9 = 0, $tobool49 = 0, $call51 = 0, $tobool52 = 0, $call54 = 0, $call55 = 0, $tobool5743 = 0, $str_044 = 0, $10 = 0, $tobool60 = 0, $call63 = 0, $tobool57 = 0, $call66 = 0, $cmp67 = 0, $11 = 0, $tobool72 = 0, $call76 = 0, $tobool41 = 0, $call79 = 0, $tobool11 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    _gvrender_set_fillcolor($job, 117192);
    $0 = $g | 0;
    $call = _agget($0, 118488) | 0;
    $cmp = ($call | 0) == 0;
    if ($cmp) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $1 = HEAP8[$call] | 0;
    $tobool = $1 << 24 >> 24 == 0;
    if ($tobool) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    _gvrender_set_fillcolor($job, $call);
    label = 5;
    break;
   case 5:
    $call1 = _agget($0, 159088) | 0;
    $cmp2 = ($call1 | 0) == 0;
    if ($cmp2) {
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $2 = HEAP8[$call1] | 0;
    $tobool7 = $2 << 24 >> 24 == 0;
    if ($tobool7) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    _gvrender_set_pencolor($job, $call1);
    label = 8;
    break;
   case 8:
    _emit_cluster_colors($job, $g);
    $3 = $g;
    $call10 = _agfstnode($3) | 0;
    $tobool1147 = ($call10 | 0) == 0;
    if ($tobool1147) {
      label = 33;
      break;
    } else {
      $n_0_in48 = $call10;
      label = 9;
      break;
    }
   case 9:
    $4 = $n_0_in48 | 0;
    $call12 = _agget($4, 120080) | 0;
    $cmp13 = ($call12 | 0) == 0;
    if ($cmp13) {
      label = 12;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $5 = HEAP8[$call12] | 0;
    $tobool18 = $5 << 24 >> 24 == 0;
    if ($tobool18) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    _gvrender_set_pencolor($job, $call12);
    label = 12;
    break;
   case 12:
    $call21 = _agget($4, 118936) | 0;
    $cmp22 = ($call21 | 0) == 0;
    if ($cmp22) {
      label = 15;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $6 = HEAP8[$call21] | 0;
    $tobool27 = $6 << 24 >> 24 == 0;
    if ($tobool27) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    _gvrender_set_fillcolor($job, $call21);
    label = 15;
    break;
   case 15:
    $call30 = _agget($4, 159088) | 0;
    $cmp31 = ($call30 | 0) == 0;
    if ($cmp31) {
      label = 18;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $7 = HEAP8[$call30] | 0;
    $tobool36 = $7 << 24 >> 24 == 0;
    if ($tobool36) {
      label = 18;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    _gvrender_set_pencolor($job, $call30);
    label = 18;
    break;
   case 18:
    $call39 = _agfstout($3, $n_0_in48) | 0;
    $tobool4145 = ($call39 | 0) == 0;
    if ($tobool4145) {
      label = 32;
      break;
    } else {
      $e_0_in46 = $call39;
      label = 19;
      break;
    }
   case 19:
    $8 = $e_0_in46 | 0;
    $call43 = _agget($8, 120080) | 0;
    $cmp44 = ($call43 | 0) == 0;
    if ($cmp44) {
      label = 28;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    $9 = HEAP8[$call43] | 0;
    $tobool49 = $9 << 24 >> 24 == 0;
    if ($tobool49) {
      label = 28;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    $call51 = _strchr($call43 | 0, 58) | 0;
    $tobool52 = ($call51 | 0) == 0;
    if ($tobool52) {
      label = 27;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    $call54 = _strdup($call43 | 0) | 0;
    $call55 = _strtok($call54 | 0, 98688) | 0;
    $tobool5743 = ($call55 | 0) == 0;
    if ($tobool5743) {
      label = 26;
      break;
    } else {
      $str_044 = $call55;
      label = 23;
      break;
    }
   case 23:
    $10 = HEAP8[$str_044] | 0;
    $tobool60 = $10 << 24 >> 24 == 0;
    if ($tobool60) {
      label = 25;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    _gvrender_set_pencolor($job, $str_044);
    label = 25;
    break;
   case 25:
    $call63 = _strtok(0, 98688) | 0;
    $tobool57 = ($call63 | 0) == 0;
    if ($tobool57) {
      label = 26;
      break;
    } else {
      $str_044 = $call63;
      label = 23;
      break;
    }
   case 26:
    _free($call54);
    label = 28;
    break;
   case 27:
    _gvrender_set_pencolor($job, $call43);
    label = 28;
    break;
   case 28:
    $call66 = _agget($8, 159088) | 0;
    $cmp67 = ($call66 | 0) == 0;
    if ($cmp67) {
      label = 31;
      break;
    } else {
      label = 29;
      break;
    }
   case 29:
    $11 = HEAP8[$call66] | 0;
    $tobool72 = $11 << 24 >> 24 == 0;
    if ($tobool72) {
      label = 31;
      break;
    } else {
      label = 30;
      break;
    }
   case 30:
    _gvrender_set_pencolor($job, $call66);
    label = 31;
    break;
   case 31:
    $call76 = _agnxtout($3, $e_0_in46) | 0;
    $tobool41 = ($call76 | 0) == 0;
    if ($tobool41) {
      label = 32;
      break;
    } else {
      $e_0_in46 = $call76;
      label = 19;
      break;
    }
   case 32:
    $call79 = _agnxtnode($3, $n_0_in48) | 0;
    $tobool11 = ($call79 | 0) == 0;
    if ($tobool11) {
      label = 33;
      break;
    } else {
      $n_0_in48 = $call79;
      label = 9;
      break;
    }
   case 33:
    return;
  }
}
function _firstlayer($job) {
  $job = $job | 0;
  var $gvc = 0, $0 = 0, $numLayers = 0, $1 = 0, $numLayers1 = 0, $cmp = 0, $flags = 0, $2 = 0, $and = 0, $tobool = 0, $output_langname = 0, $3 = 0, $call = 0, $layerNum = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $gvc = $job | 0;
    $0 = HEAP32[$gvc >> 2] | 0;
    $numLayers = $0 + 284 | 0;
    $1 = HEAP32[$numLayers >> 2] | 0;
    $numLayers1 = $job + 156 | 0;
    HEAP32[$numLayers1 >> 2] = $1;
    $cmp = ($1 | 0) > 1;
    if ($cmp) {
      label = 3;
      break;
    } else {
      label = 5;
      break;
    }
   case 3:
    $flags = $job + 152 | 0;
    $2 = HEAP32[$flags >> 2] | 0;
    $and = $2 & 64;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    $output_langname = $job + 52 | 0;
    $3 = HEAP32[$output_langname >> 2] | 0;
    $call = _agerr(0, 159544, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $3, tempInt) | 0) | 0;
    HEAP32[$numLayers1 >> 2] = 1;
    label = 5;
    break;
   case 5:
    $layerNum = $job + 160 | 0;
    HEAP32[$layerNum >> 2] = 1;
    STACKTOP = __stackBase__;
    return;
  }
}
function _emit_page($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $obj1 = 0, $0 = 0, $flags2 = 0, $1 = 0, $2 = 0, $call = 0, $and = 0, $tobool = 0, $url = 0, $3 = 0, $tobool3 = 0, $4 = 0, $5 = 0, $6 = 0, $_mask53 = 0, $tobool4 = 0, $and5 = 0, $tobool6 = 0, $and8 = 0, $tobool9 = 0, $url_map_shape = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $mul = 0, $call12 = 0, $12 = 0, $pageBox = 0, $13 = 0, $arrayidx13 = 0, $UR = 0, $14 = 0, $nump_1 = 0, $p_0 = 0, $and20 = 0, $tobool21 = 0, $call23 = 0, $url_map_p = 0, $url_map_n = 0, $and26 = 0, $tobool27 = 0, $label = 0, $15 = 0, $tobool29 = 0, $text = 0, $16 = 0, $label31 = 0, $and33 = 0, $tobool34 = 0, $url36 = 0, $17 = 0, $tobool37 = 0, $18 = 0, $19 = 0, $20 = 0, $_mask = 0, $tobool42 = 0, $clip = 0, $21 = 0, $tooltip = 0, $22 = 0, $target = 0, $23 = 0, $id = 0, $24 = 0, $numLayers = 0, $25 = 0, $cmp = 0, $label49 = 0, $26 = 0, $tobool50 = 0, $url58 = 0, $27 = 0, $tobool59 = 0, $28 = 0, $29 = 0, $30 = 0, $_mask52 = 0, $tobool64 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $obj1 = $job + 16 | 0;
    $0 = HEAP32[$obj1 >> 2] | 0;
    $flags2 = $job + 152 | 0;
    $1 = HEAP32[$flags2 >> 2] | 0;
    $2 = $g | 0;
    $call = _agget($2, 133704) | 0;
    _setColorScheme($call);
    _setup_page($job);
    _gvrender_begin_page($job);
    _gvrender_set_pencolor($job, 117856);
    _gvrender_set_fillcolor($job, 117192);
    $and = $1 & 4259840;
    $tobool = ($and | 0) == 0;
    if ($tobool) {
      label = 11;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $url = $0 + 160 | 0;
    $3 = HEAP32[$url >> 2] | 0;
    $tobool3 = ($3 | 0) == 0;
    if ($tobool3) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    $4 = $0 + 212 | 0;
    $5 = $4;
    $6 = HEAP32[$5 >> 2] | 0;
    $_mask53 = $6 & 1;
    $tobool4 = ($_mask53 | 0) == 0;
    if ($tobool4) {
      label = 11;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $and5 = $1 & 655360;
    $tobool6 = ($and5 | 0) == 0;
    if ($tobool6) {
      $p_0 = 0;
      $nump_1 = 0;
      label = 8;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $and8 = $1 & 131072;
    $tobool9 = ($and8 | 0) == 0;
    $url_map_shape = $0 + 216 | 0;
    $7 = $and8 >>> 16;
    $8 = $7 ^ 2;
    $9 = $and8 >>> 16;
    $10 = $9 ^ 2;
    $11 = $10 + 2 | 0;
    HEAP32[$url_map_shape >> 2] = $8;
    $mul = $11 << 4;
    $call12 = _zmalloc($mul) | 0;
    $12 = $call12;
    $pageBox = $job + 288 | 0;
    $13 = $pageBox;
    HEAP32[$call12 >> 2] = HEAP32[$13 >> 2] | 0;
    HEAP32[$call12 + 4 >> 2] = HEAP32[$13 + 4 >> 2] | 0;
    HEAP32[$call12 + 8 >> 2] = HEAP32[$13 + 8 >> 2] | 0;
    HEAP32[$call12 + 12 >> 2] = HEAP32[$13 + 12 >> 2] | 0;
    $arrayidx13 = $call12 + 16 | 0;
    $UR = $job + 304 | 0;
    $14 = $UR;
    HEAP32[$arrayidx13 >> 2] = HEAP32[$14 >> 2] | 0;
    HEAP32[$arrayidx13 + 4 >> 2] = HEAP32[$14 + 4 >> 2] | 0;
    HEAP32[$arrayidx13 + 8 >> 2] = HEAP32[$14 + 8 >> 2] | 0;
    HEAP32[$arrayidx13 + 12 >> 2] = HEAP32[$14 + 12 >> 2] | 0;
    if ($tobool9) {
      label = 7;
      break;
    } else {
      $p_0 = $12;
      $nump_1 = $11;
      label = 8;
      break;
    }
   case 7:
    _rect2poly($12);
    $p_0 = $12;
    $nump_1 = $11;
    label = 8;
    break;
   case 8:
    $and20 = $1 & 8192;
    $tobool21 = ($and20 | 0) == 0;
    if ($tobool21) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    $call23 = _gvrender_ptf_A($job, $p_0, $p_0, $nump_1) | 0;
    label = 10;
    break;
   case 10:
    $url_map_p = $0 + 224 | 0;
    HEAP32[$url_map_p >> 2] = $p_0;
    $url_map_n = $0 + 220 | 0;
    HEAP32[$url_map_n >> 2] = $nump_1;
    label = 11;
    break;
   case 11:
    $and26 = $1 & 32768;
    $tobool27 = ($and26 | 0) == 0;
    if ($tobool27) {
      label = 14;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $label = $g + 52 | 0;
    $15 = HEAP32[$label >> 2] | 0;
    $tobool29 = ($15 | 0) == 0;
    if ($tobool29) {
      label = 14;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $text = $15 | 0;
    $16 = HEAP32[$text >> 2] | 0;
    $label31 = $0 + 144 | 0;
    HEAP32[$label31 >> 2] = $16;
    label = 14;
    break;
   case 14:
    $and33 = $1 & 4;
    $tobool34 = ($and33 | 0) != 0;
    if ($tobool34) {
      label = 18;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    $url36 = $0 + 160 | 0;
    $17 = HEAP32[$url36 >> 2] | 0;
    $tobool37 = ($17 | 0) == 0;
    if ($tobool37) {
      label = 16;
      break;
    } else {
      label = 17;
      break;
    }
   case 16:
    $18 = $0 + 212 | 0;
    $19 = $18;
    $20 = HEAP32[$19 >> 2] | 0;
    $_mask = $20 & 1;
    $tobool42 = ($_mask | 0) == 0;
    if ($tobool42) {
      label = 18;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    $clip = $job + 256 | 0;
    _emit_map_rect($job, $clip);
    $21 = HEAP32[$url36 >> 2] | 0;
    $tooltip = $0 + 180 | 0;
    $22 = HEAP32[$tooltip >> 2] | 0;
    $target = $0 + 196 | 0;
    $23 = HEAP32[$target >> 2] | 0;
    $id = $0 + 164 | 0;
    $24 = HEAP32[$id >> 2] | 0;
    _gvrender_begin_anchor($job, $21, $22, $23, $24);
    label = 18;
    break;
   case 18:
    $numLayers = $job + 156 | 0;
    $25 = HEAP32[$numLayers >> 2] | 0;
    $cmp = ($25 | 0) == 1;
    if ($cmp) {
      label = 19;
      break;
    } else {
      label = 20;
      break;
    }
   case 19:
    _emit_background($job, $g);
    label = 20;
    break;
   case 20:
    $label49 = $g + 52 | 0;
    $26 = HEAP32[$label49 >> 2] | 0;
    $tobool50 = ($26 | 0) == 0;
    if ($tobool50) {
      label = 22;
      break;
    } else {
      label = 21;
      break;
    }
   case 21:
    _emit_label($job, 4, $26);
    label = 22;
    break;
   case 22:
    if ($tobool34) {
      label = 26;
      break;
    } else {
      label = 23;
      break;
    }
   case 23:
    $url58 = $0 + 160 | 0;
    $27 = HEAP32[$url58 >> 2] | 0;
    $tobool59 = ($27 | 0) == 0;
    if ($tobool59) {
      label = 24;
      break;
    } else {
      label = 25;
      break;
    }
   case 24:
    $28 = $0 + 212 | 0;
    $29 = $28;
    $30 = HEAP32[$29 >> 2] | 0;
    $_mask52 = $30 & 1;
    $tobool64 = ($_mask52 | 0) == 0;
    if ($tobool64) {
      label = 26;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    _gvrender_end_anchor($job);
    label = 26;
    break;
   case 26:
    _emit_view($job, $g, $1);
    _gvrender_end_page($job);
    return;
  }
}
function _nextpage($job) {
  $job = $job | 0;
  var $tmp = 0, $tmpcast = 0, $tmp13 = 0, $tmpcast11 = 0, $pagesArrayElem = 0, $pagesArrayMinor = 0, $0 = 0, $ld$0$0 = 0, $1$0 = 0, $ld$1$1 = 0, $1$1 = 0, $st$2$0 = 0, $st$3$1 = 0, $call = 0, $cmp = 0, $pagesArrayMajor = 0, $y = 0, $2 = 0, $tobool = 0, $x = 0, $3 = 0, $x5 = 0, $y7 = 0, $4 = 0, $y9 = 0, $ld$4$0 = 0, $5$0 = 0, $ld$5$1 = 0, $5$1 = 0, $st$6$0 = 0, $st$7$1 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tmp = __stackBase__ | 0;
    $tmpcast = $tmp;
    $tmp13 = STACKTOP;
    STACKTOP = STACKTOP + 8 | 0;
    $tmpcast11 = $tmp13;
    $pagesArrayElem = $job + 196 | 0;
    $pagesArrayMinor = $job + 188 | 0;
    _add_point($tmpcast, $pagesArrayElem, $pagesArrayMinor);
    $0 = $pagesArrayElem;
    $ld$0$0 = $tmp | 0;
    $1$0 = HEAP32[$ld$0$0 >> 2] | 0;
    $ld$1$1 = $tmp + 4 | 0;
    $1$1 = HEAP32[$ld$1$1 >> 2] | 0;
    $st$2$0 = $0 | 0;
    HEAP32[$st$2$0 >> 2] = $1$0;
    $st$3$1 = $0 + 4 | 0;
    HEAP32[$st$3$1 >> 2] = $1$1;
    $call = _validpage($job) | 0;
    $cmp = $call << 24 >> 24 == 0;
    if ($cmp) {
      label = 3;
      break;
    } else {
      label = 7;
      break;
    }
   case 3:
    $pagesArrayMajor = $job + 180 | 0;
    $y = $job + 184 | 0;
    $2 = HEAP32[$y >> 2] | 0;
    $tobool = ($2 | 0) == 0;
    if ($tobool) {
      label = 5;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $x = $job + 172 | 0;
    $3 = HEAP32[$x >> 2] | 0;
    $x5 = $pagesArrayElem | 0;
    HEAP32[$x5 >> 2] = $3;
    label = 6;
    break;
   case 5:
    $y7 = $job + 176 | 0;
    $4 = HEAP32[$y7 >> 2] | 0;
    $y9 = $job + 200 | 0;
    HEAP32[$y9 >> 2] = $4;
    label = 6;
    break;
   case 6:
    _add_point($tmpcast11, $pagesArrayElem, $pagesArrayMajor);
    $ld$4$0 = $tmp13 | 0;
    $5$0 = HEAP32[$ld$4$0 >> 2] | 0;
    $ld$5$1 = $tmp13 + 4 | 0;
    $5$1 = HEAP32[$ld$5$1 >> 2] | 0;
    $st$6$0 = $0 | 0;
    HEAP32[$st$6$0 >> 2] = $5$0;
    $st$7$1 = $0 + 4 | 0;
    HEAP32[$st$7$1 >> 2] = $5$1;
    label = 7;
    break;
   case 7:
    STACKTOP = __stackBase__;
    return;
  }
}
function _emit_end_graph($job) {
  $job = $job | 0;
  _gvrender_end_graph($job);
  _pop_obj_state($job);
  return;
}
function _emit_once($str) {
  $str = $str | 0;
  var $0 = 0, $cmp = 0, $1 = 0, $2 = 0, $call = 0, $3 = 0, $searchf = 0, $4 = 0, $call1 = 0, $tobool = 0, $5 = 0, $searchf3 = 0, $6 = 0, $call4 = 0, $call5 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = HEAP32[1014] | 0;
    $cmp = ($0 | 0) == 0;
    if ($cmp) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    $1 = HEAP32[41978] | 0;
    $2 = $1;
    $call = _dtopen(4064, $2) | 0;
    HEAP32[1014] = $call;
    label = 4;
    break;
   case 4:
    $3 = HEAP32[1014] | 0;
    $searchf = $3 | 0;
    $4 = HEAP32[$searchf >> 2] | 0;
    $call1 = FUNCTION_TABLE_iiii[$4 & 1023]($3, $str, 4) | 0;
    $tobool = ($call1 | 0) == 0;
    if ($tobool) {
      label = 5;
      break;
    } else {
      $retval_0 = 0;
      label = 6;
      break;
    }
   case 5:
    $5 = HEAP32[1014] | 0;
    $searchf3 = $5 | 0;
    $6 = HEAP32[$searchf3 >> 2] | 0;
    $call4 = _agstrdup($str) | 0;
    $call5 = FUNCTION_TABLE_iiii[$6 & 1023]($5, $call4, 1) | 0;
    $retval_0 = 1;
    label = 6;
    break;
   case 6:
    return $retval_0 | 0;
  }
  return 0;
}
function _emit_once_reset() {
  var $0 = 0, $tobool = 0, $call = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = HEAP32[1014] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $call = _dtclose($0) | 0;
    HEAP32[1014] = 0;
    label = 4;
    break;
   case 4:
    return;
  }
}
function _emit_clusters($job, $g, $flags) {
  $job = $job | 0;
  $g = $g | 0;
  $flags = $flags | 0;
  var $istyle = 0, $AF = 0, $n_cluster = 0, $0 = 0, $cmp103 = 0, $clust = 0, $and = 0, $tobool = 0, $obj6 = 0, $and186 = 0, $tobool187 = 0, $arrayidx125 = 0, $1 = 0, $arrayidx128 = 0, $2 = 0, $x = 0, $x133 = 0, $y = 0, $y136 = 0, $x138 = 0, $x140 = 0, $y142 = 0, $y144 = 0, $c_0104 = 0, $3 = 0, $arrayidx = 0, $4 = 0, $call = 0, $cmp2 = 0, $5 = 0, $url = 0, $6 = 0, $tobool7 = 0, $7 = 0, $8 = 0, $9 = 0, $_mask = 0, $tobool8 = 0, $10 = 0, $11 = 0, $call9 = 0, $_not = 0, $brmerge = 0, $bb = 0, $12 = 0, $tooltip = 0, $13 = 0, $target = 0, $14 = 0, $id = 0, $15 = 0, $call17 = 0, $tobool18 = 0, $16 = 0, $and20 = 0, $filled_0 = 0, $gui_state = 0, $17 = 0, $conv26 = 0, $and27 = 0, $tobool28 = 0, $18 = 0, $call30 = 0, $19 = 0, $call31 = 0, $and35 = 0, $tobool36 = 0, $20 = 0, $call38 = 0, $21 = 0, $call39 = 0, $and44 = 0, $tobool45 = 0, $22 = 0, $call47 = 0, $23 = 0, $call48 = 0, $and53 = 0, $tobool54 = 0, $24 = 0, $call56 = 0, $25 = 0, $call57 = 0, $call59 = 0, $cmp60 = 0, $26 = 0, $tobool65 = 0, $_call59 = 0, $pencolor_0 = 0, $call68 = 0, $cmp69 = 0, $27 = 0, $tobool74 = 0, $pencolor_0_call68 = 0, $pencolor_1 = 0, $call77 = 0, $cmp78 = 0, $28 = 0, $tobool83 = 0, $pencolor_0_call77 = 0, $fillcolor_1 = 0, $tobool86 = 0, $call88 = 0, $cmp89 = 0, $29 = 0, $tobool94 = 0, $fillcolor_1_call88 = 0, $filled_0_ = 0, $pencolor_2 = 0, $fillcolor_2 = 0, $filled_1 = 0, $tobool101 = 0, $_pencolor_2 = 0, $tobool104 = 0, $fillcolor_3 = 0, $30 = 0, $tobool107 = 0, $index = 0, $31 = 0, $call109 = 0, $tobool110 = 0, $32 = 0, $tobool114 = 0, $call116 = 0.0, $33 = 0, $and118 = 0, $tobool119 = 0, $34 = 0, $call121 = 0, $35 = 0, $36 = 0, $bb127 = 0, $37 = 0, $UR = 0, $38 = 0, $39 = 0.0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $43 = 0, $and145 = 0, $44 = 0, $call148 = 0, $tobool149 = 0, $bb152 = 0, $conv153 = 0, $tobool155 = 0, $cmp159 = 0, $bb164 = 0, $conv165 = 0, $label = 0, $45 = 0, $tobool170 = 0, $bb179 = 0, $46 = 0, $tooltip181 = 0, $47 = 0, $target182 = 0, $48 = 0, $id183 = 0, $49 = 0, $50 = 0, $call189 = 0, $tobool191101 = 0, $n_0_in102 = 0, $n_0 = 0, $call193 = 0, $tobool19599 = 0, $e_0_in100 = 0, $e_0 = 0, $call197 = 0, $tobool195 = 0, $call199 = 0, $tobool191 = 0, $inc = 0, $51 = 0, $cmp = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 72 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $istyle = __stackBase__ | 0;
    $AF = __stackBase__ + 8 | 0;
    $n_cluster = $g + 212 | 0;
    $0 = HEAP32[$n_cluster >> 2] | 0;
    $cmp103 = ($0 | 0) < 1;
    if ($cmp103) {
      label = 57;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $clust = $g + 216 | 0;
    $and = $flags & 4;
    $tobool = ($and | 0) != 0;
    $obj6 = $job + 16 | 0;
    $and186 = $flags & 8;
    $tobool187 = ($and186 | 0) == 0;
    $arrayidx125 = $AF | 0;
    $1 = $AF;
    $arrayidx128 = $AF + 32 | 0;
    $2 = $arrayidx128;
    $x = $arrayidx128 | 0;
    $x133 = $AF + 16 | 0;
    $y = $AF + 8 | 0;
    $y136 = $AF + 24 | 0;
    $x138 = $AF | 0;
    $x140 = $AF + 48 | 0;
    $y142 = $AF + 40 | 0;
    $y144 = $AF + 56 | 0;
    $c_0104 = 1;
    label = 4;
    break;
   case 4:
    $3 = HEAP32[$clust >> 2] | 0;
    $arrayidx = $3 + ($c_0104 << 2) | 0;
    $4 = HEAP32[$arrayidx >> 2] | 0;
    $call = _clust_in_layer($job, $4) | 0;
    $cmp2 = $call << 24 >> 24 == 0;
    if ($cmp2) {
      label = 56;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    if ($tobool) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    _emit_clusters($job, $4, $flags);
    label = 7;
    break;
   case 7:
    _emit_begin_cluster($job, $4);
    $5 = HEAP32[$obj6 >> 2] | 0;
    $url = $5 + 160 | 0;
    $6 = HEAP32[$url >> 2] | 0;
    $tobool7 = ($6 | 0) == 0;
    if ($tobool7) {
      label = 8;
      break;
    } else {
      $10 = 1;
      label = 9;
      break;
    }
   case 8:
    $7 = $5 + 212 | 0;
    $8 = $7;
    $9 = HEAP32[$8 >> 2] | 0;
    $_mask = $9 & 1;
    $tobool8 = ($_mask | 0) != 0;
    $10 = $tobool8;
    label = 9;
    break;
   case 9:
    $11 = $4 | 0;
    $call9 = _agget($11, 133704) | 0;
    _setColorScheme($call9);
    $_not = $10 ^ 1;
    $brmerge = $tobool | $_not;
    if ($brmerge) {
      label = 11;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $bb = $4 + 56 | 0;
    _emit_map_rect($job, $bb);
    $12 = HEAP32[$url >> 2] | 0;
    $tooltip = $5 + 180 | 0;
    $13 = HEAP32[$tooltip >> 2] | 0;
    $target = $5 + 196 | 0;
    $14 = HEAP32[$target >> 2] | 0;
    $id = $5 + 164 | 0;
    $15 = HEAP32[$id >> 2] | 0;
    _gvrender_begin_anchor($job, $12, $13, $14, $15);
    label = 11;
    break;
   case 11:
    HEAP32[$istyle >> 2] = 0;
    $call17 = _checkClusterStyle($4, $istyle) | 0;
    $tobool18 = ($call17 | 0) == 0;
    if ($tobool18) {
      $filled_0 = 0;
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    _gvrender_set_style($job, $call17);
    $16 = HEAP32[$istyle >> 2] | 0;
    $and20 = $16 & 1;
    $filled_0 = $and20;
    label = 13;
    break;
   case 13:
    $gui_state = $4 + 152 | 0;
    $17 = HEAP8[$gui_state] | 0;
    $conv26 = $17 & 255;
    $and27 = $conv26 & 1;
    $tobool28 = ($and27 | 0) == 0;
    if ($tobool28) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    $18 = HEAP32[41872] | 0;
    $call30 = _late_nnstring($11, $18, 131512) | 0;
    $19 = HEAP32[41874] | 0;
    $call31 = _late_nnstring($11, $19, 130536) | 0;
    $filled_1 = 1;
    $fillcolor_2 = $call31;
    $pencolor_2 = $call30;
    label = 30;
    break;
   case 15:
    $and35 = $conv26 & 2;
    $tobool36 = ($and35 | 0) == 0;
    if ($tobool36) {
      label = 17;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $20 = HEAP32[41872] | 0;
    $call38 = _late_nnstring($11, $20, 128656) | 0;
    $21 = HEAP32[41874] | 0;
    $call39 = _late_nnstring($11, $21, 126080) | 0;
    $filled_1 = 1;
    $fillcolor_2 = $call39;
    $pencolor_2 = $call38;
    label = 30;
    break;
   case 17:
    $and44 = $conv26 & 8;
    $tobool45 = ($and44 | 0) == 0;
    if ($tobool45) {
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    $22 = HEAP32[41868] | 0;
    $call47 = _late_nnstring($11, $22, 122664) | 0;
    $23 = HEAP32[41870] | 0;
    $call48 = _late_nnstring($11, $23, 121984) | 0;
    $filled_1 = 1;
    $fillcolor_2 = $call48;
    $pencolor_2 = $call47;
    label = 30;
    break;
   case 19:
    $and53 = $conv26 & 4;
    $tobool54 = ($and53 | 0) == 0;
    if ($tobool54) {
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    $24 = HEAP32[41858] | 0;
    $call56 = _late_nnstring($11, $24, 121456) | 0;
    $25 = HEAP32[41860] | 0;
    $call57 = _late_nnstring($11, $25, 120728) | 0;
    $filled_1 = 1;
    $fillcolor_2 = $call57;
    $pencolor_2 = $call56;
    label = 30;
    break;
   case 21:
    $call59 = _agget($11, 120080) | 0;
    $cmp60 = ($call59 | 0) == 0;
    if ($cmp60) {
      $pencolor_0 = 0;
      label = 23;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    $26 = HEAP8[$call59] | 0;
    $tobool65 = $26 << 24 >> 24 == 0;
    $_call59 = $tobool65 ? 0 : $call59;
    $pencolor_0 = $_call59;
    label = 23;
    break;
   case 23:
    $call68 = _agget($11, 119480) | 0;
    $cmp69 = ($call68 | 0) == 0;
    if ($cmp69) {
      $pencolor_1 = $pencolor_0;
      label = 25;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    $27 = HEAP8[$call68] | 0;
    $tobool74 = $27 << 24 >> 24 == 0;
    $pencolor_0_call68 = $tobool74 ? $pencolor_0 : $call68;
    $pencolor_1 = $pencolor_0_call68;
    label = 25;
    break;
   case 25:
    $call77 = _agget($11, 118936) | 0;
    $cmp78 = ($call77 | 0) == 0;
    if ($cmp78) {
      $fillcolor_1 = $pencolor_0;
      label = 27;
      break;
    } else {
      label = 26;
      break;
    }
   case 26:
    $28 = HEAP8[$call77] | 0;
    $tobool83 = $28 << 24 >> 24 == 0;
    $pencolor_0_call77 = $tobool83 ? $pencolor_0 : $call77;
    $fillcolor_1 = $pencolor_0_call77;
    label = 27;
    break;
   case 27:
    $tobool86 = ($filled_0 | 0) == 0;
    if ($tobool86) {
      label = 28;
      break;
    } else {
      $filled_1 = $filled_0;
      $fillcolor_2 = $fillcolor_1;
      $pencolor_2 = $pencolor_1;
      label = 30;
      break;
    }
   case 28:
    $call88 = _agget($11, 118488) | 0;
    $cmp89 = ($call88 | 0) == 0;
    if ($cmp89) {
      $filled_1 = 0;
      $fillcolor_2 = $fillcolor_1;
      $pencolor_2 = $pencolor_1;
      label = 30;
      break;
    } else {
      label = 29;
      break;
    }
   case 29:
    $29 = HEAP8[$call88] | 0;
    $tobool94 = $29 << 24 >> 24 == 0;
    $fillcolor_1_call88 = $tobool94 ? $fillcolor_1 : $call88;
    $filled_0_ = $tobool94 ? $filled_0 : 1;
    $filled_1 = $filled_0_;
    $fillcolor_2 = $fillcolor_1_call88;
    $pencolor_2 = $pencolor_1;
    label = 30;
    break;
   case 30:
    $tobool101 = ($pencolor_2 | 0) == 0;
    $_pencolor_2 = $tobool101 ? 117856 : $pencolor_2;
    $tobool104 = ($fillcolor_2 | 0) == 0;
    $fillcolor_3 = $tobool104 ? 117192 : $fillcolor_2;
    $30 = HEAP32[41864] | 0;
    $tobool107 = ($30 | 0) == 0;
    if ($tobool107) {
      label = 34;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    $index = $30 + 8 | 0;
    $31 = HEAP32[$index >> 2] | 0;
    $call109 = _agxget($11, $31) | 0;
    $tobool110 = ($call109 | 0) == 0;
    if ($tobool110) {
      label = 34;
      break;
    } else {
      label = 32;
      break;
    }
   case 32:
    $32 = HEAP8[$call109] | 0;
    $tobool114 = $32 << 24 >> 24 == 0;
    if ($tobool114) {
      label = 34;
      break;
    } else {
      label = 33;
      break;
    }
   case 33:
    $call116 = +_late_double($11, $30, 1.0, 0.0);
    _gvrender_set_penwidth($job, $call116);
    label = 34;
    break;
   case 34:
    $33 = HEAP32[$istyle >> 2] | 0;
    $and118 = $33 & 2;
    $tobool119 = ($and118 | 0) == 0;
    if ($tobool119) {
      label = 37;
      break;
    } else {
      label = 35;
      break;
    }
   case 35:
    $34 = HEAP32[41862] | 0;
    $call121 = _late_int($11, $34, 1, 0) | 0;
    $35 = $call121 | $filled_1;
    $36 = ($35 | 0) == 0;
    if ($36) {
      label = 43;
      break;
    } else {
      label = 36;
      break;
    }
   case 36:
    $bb127 = $4 + 56 | 0;
    $37 = $bb127;
    HEAP32[$1 >> 2] = HEAP32[$37 >> 2] | 0;
    HEAP32[$1 + 4 >> 2] = HEAP32[$37 + 4 >> 2] | 0;
    HEAP32[$1 + 8 >> 2] = HEAP32[$37 + 8 >> 2] | 0;
    HEAP32[$1 + 12 >> 2] = HEAP32[$37 + 12 >> 2] | 0;
    $UR = $4 + 72 | 0;
    $38 = $UR;
    HEAP32[$2 >> 2] = HEAP32[$38 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$38 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$38 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$38 + 12 >> 2] | 0;
    $39 = +HEAPF64[$x >> 3];
    HEAPF64[$x133 >> 3] = $39;
    $40 = +HEAPF64[$y >> 3];
    HEAPF64[$y136 >> 3] = $40;
    $41 = +HEAPF64[$x138 >> 3];
    HEAPF64[$x140 >> 3] = $41;
    $42 = +HEAPF64[$y142 >> 3];
    HEAPF64[$y144 >> 3] = $42;
    $43 = HEAP32[$istyle >> 2] | 0;
    $and145 = $43 & 1;
    _round_corners($job, $fillcolor_3, $_pencolor_2, $arrayidx125, 4, $43, $and145);
    label = 43;
    break;
   case 37:
    _gvrender_set_pencolor($job, $_pencolor_2);
    _gvrender_set_fillcolor($job, $fillcolor_3);
    $44 = HEAP32[41862] | 0;
    $call148 = _late_int($11, $44, 1, 0) | 0;
    $tobool149 = ($call148 | 0) == 0;
    if ($tobool149) {
      label = 39;
      break;
    } else {
      label = 38;
      break;
    }
   case 38:
    $bb152 = $4 + 56 | 0;
    $conv153 = $filled_1 & 255;
    _gvrender_box($job, $bb152, $conv153);
    label = 43;
    break;
   case 39:
    $tobool155 = ($filled_1 | 0) == 0;
    if ($tobool155) {
      label = 43;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    $cmp159 = ($fillcolor_3 | 0) == ($_pencolor_2 | 0);
    if ($cmp159) {
      label = 42;
      break;
    } else {
      label = 41;
      break;
    }
   case 41:
    _gvrender_set_pencolor($job, $fillcolor_3);
    label = 42;
    break;
   case 42:
    $bb164 = $4 + 56 | 0;
    $conv165 = $filled_1 & 255;
    _gvrender_box($job, $bb164, $conv165);
    label = 43;
    break;
   case 43:
    $label = $4 + 52 | 0;
    $45 = HEAP32[$label >> 2] | 0;
    $tobool170 = ($45 | 0) == 0;
    if ($tobool170) {
      label = 45;
      break;
    } else {
      label = 44;
      break;
    }
   case 44:
    _emit_label($job, 5, $45);
    label = 45;
    break;
   case 45:
    if ($10) {
      label = 46;
      break;
    } else {
      label = 49;
      break;
    }
   case 46:
    if ($tobool) {
      label = 47;
      break;
    } else {
      label = 48;
      break;
    }
   case 47:
    $bb179 = $4 + 56 | 0;
    _emit_map_rect($job, $bb179);
    $46 = HEAP32[$url >> 2] | 0;
    $tooltip181 = $5 + 180 | 0;
    $47 = HEAP32[$tooltip181 >> 2] | 0;
    $target182 = $5 + 196 | 0;
    $48 = HEAP32[$target182 >> 2] | 0;
    $id183 = $5 + 164 | 0;
    $49 = HEAP32[$id183 >> 2] | 0;
    _gvrender_begin_anchor($job, $46, $47, $48, $49);
    label = 48;
    break;
   case 48:
    _gvrender_end_anchor($job);
    label = 49;
    break;
   case 49:
    if ($tobool187) {
      label = 54;
      break;
    } else {
      label = 50;
      break;
    }
   case 50:
    $50 = $4;
    $call189 = _agfstnode($50) | 0;
    $tobool191101 = ($call189 | 0) == 0;
    if ($tobool191101) {
      label = 54;
      break;
    } else {
      $n_0_in102 = $call189;
      label = 51;
      break;
    }
   case 51:
    $n_0 = $n_0_in102;
    _emit_node($job, $n_0);
    $call193 = _agfstout($50, $n_0_in102) | 0;
    $tobool19599 = ($call193 | 0) == 0;
    if ($tobool19599) {
      label = 53;
      break;
    } else {
      $e_0_in100 = $call193;
      label = 52;
      break;
    }
   case 52:
    $e_0 = $e_0_in100;
    _emit_edge($job, $e_0);
    $call197 = _agnxtout($50, $e_0_in100) | 0;
    $tobool195 = ($call197 | 0) == 0;
    if ($tobool195) {
      label = 53;
      break;
    } else {
      $e_0_in100 = $call197;
      label = 52;
      break;
    }
   case 53:
    $call199 = _agnxtnode($50, $n_0_in102) | 0;
    $tobool191 = ($call199 | 0) == 0;
    if ($tobool191) {
      label = 54;
      break;
    } else {
      $n_0_in102 = $call199;
      label = 51;
      break;
    }
   case 54:
    _emit_end_cluster($job, $g);
    if ($tobool) {
      label = 56;
      break;
    } else {
      label = 55;
      break;
    }
   case 55:
    _emit_clusters($job, $4, $flags);
    label = 56;
    break;
   case 56:
    $inc = $c_0104 + 1 | 0;
    $51 = HEAP32[$n_cluster >> 2] | 0;
    $cmp = ($inc | 0) > ($51 | 0);
    if ($cmp) {
      label = 57;
      break;
    } else {
      $c_0104 = $inc;
      label = 4;
      break;
    }
   case 57:
    STACKTOP = __stackBase__;
    return;
  }
}
function _clust_in_layer($job, $sg) {
  $job = $job | 0;
  $sg = $sg | 0;
  var $numLayers = 0, $0 = 0, $cmp = 0, $1 = 0, $call = 0, $call1 = 0, $call2 = 0, $tobool = 0, $2 = 0, $tobool5 = 0, $3 = 0, $call8 = 0, $tobool910 = 0, $n_0_in11 = 0, $n_0 = 0, $call10 = 0, $tobool11 = 0, $call14 = 0, $tobool9 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $numLayers = $job + 156 | 0;
    $0 = HEAP32[$numLayers >> 2] | 0;
    $cmp = ($0 | 0) < 2;
    if ($cmp) {
      $retval_0 = 1;
      label = 8;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $1 = $sg | 0;
    $call = _agfindattr($1, 160880) | 0;
    $call1 = _late_string($1, $call, 136112) | 0;
    $call2 = _selectedlayer($job, $call1) | 0;
    $tobool = $call2 << 24 >> 24 == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      $retval_0 = 1;
      label = 8;
      break;
    }
   case 4:
    $2 = HEAP8[$call1] | 0;
    $tobool5 = $2 << 24 >> 24 == 0;
    if ($tobool5) {
      label = 5;
      break;
    } else {
      $retval_0 = 0;
      label = 8;
      break;
    }
   case 5:
    $3 = $sg;
    $call8 = _agfstnode($3) | 0;
    $tobool910 = ($call8 | 0) == 0;
    if ($tobool910) {
      $retval_0 = 0;
      label = 8;
      break;
    } else {
      $n_0_in11 = $call8;
      label = 6;
      break;
    }
   case 6:
    $n_0 = $n_0_in11;
    $call10 = _node_in_layer($job, $sg, $n_0) | 0;
    $tobool11 = $call10 << 24 >> 24 == 0;
    if ($tobool11) {
      label = 7;
      break;
    } else {
      $retval_0 = 1;
      label = 8;
      break;
    }
   case 7:
    $call14 = _agnxtnode($3, $n_0_in11) | 0;
    $tobool9 = ($call14 | 0) == 0;
    if ($tobool9) {
      $retval_0 = 0;
      label = 8;
      break;
    } else {
      $n_0_in11 = $call14;
      label = 6;
      break;
    }
   case 8:
    return $retval_0 | 0;
  }
  return 0;
}
function _emit_begin_cluster($job, $sg) {
  $job = $job | 0;
  $sg = $sg | 0;
  var $call = 0;
  $call = _push_obj_state($job) | 0;
  HEAP32[$call + 4 >> 2] = 1;
  HEAP32[$call + 8 >> 2] = $sg;
  HEAP32[$call + 12 >> 2] = 1;
  _initObjMapData($job, HEAP32[$sg + 52 >> 2] | 0, $sg | 0);
  _gvrender_begin_cluster($job, 0);
  return;
}
function _checkClusterStyle($sg, $flagp) {
  $sg = $sg | 0;
  $flagp = $flagp | 0;
  var $0 = 0, $call = 0, $cmp = 0, $1 = 0, $tobool = 0, $call1 = 0, $or11 = 0, $istyle_0_ph = 0, $pp_0_ph = 0, $pp_0 = 0, $2 = 0, $tobool2 = 0, $call3 = 0, $cmp4 = 0, $or = 0, $incdec_ptr = 0, $call7 = 0, $cmp8 = 0, $incdec_ptr15 = 0, $qp_0 = 0, $incdec_ptr12 = 0, $3 = 0, $4 = 0, $tobool13 = 0, $istyle_1 = 0, $pstyle_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = $sg | 0;
    $call = _agget($0, 161504) | 0;
    $cmp = ($call | 0) == 0;
    if ($cmp) {
      $pstyle_0 = 0;
      $istyle_1 = 0;
      label = 12;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $1 = HEAP8[$call] | 0;
    $tobool = $1 << 24 >> 24 == 0;
    if ($tobool) {
      $pstyle_0 = 0;
      $istyle_1 = 0;
      label = 12;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $call1 = _parse_style($call) | 0;
    $pp_0_ph = 7280;
    $istyle_0_ph = 0;
    label = 6;
    break;
   case 5:
    $or11 = $istyle_0_ph | 2;
    $pp_0_ph = $pp_0;
    $istyle_0_ph = $or11;
    label = 6;
    break;
   case 6:
    $pp_0 = $pp_0_ph;
    label = 7;
    break;
   case 7:
    $2 = HEAP32[$pp_0 >> 2] | 0;
    $tobool2 = ($2 | 0) == 0;
    if ($tobool2) {
      $pstyle_0 = 7280;
      $istyle_1 = $istyle_0_ph;
      label = 12;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $call3 = _strcmp($2 | 0, 161792) | 0;
    $cmp4 = ($call3 | 0) == 0;
    if ($cmp4) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    $or = $istyle_0_ph | 1;
    $incdec_ptr = $pp_0 + 4 | 0;
    $pp_0_ph = $incdec_ptr;
    $istyle_0_ph = $or;
    label = 6;
    break;
   case 10:
    $call7 = _strcmp($2 | 0, 161224) | 0;
    $cmp8 = ($call7 | 0) == 0;
    $incdec_ptr15 = $pp_0 + 4 | 0;
    if ($cmp8) {
      $qp_0 = $pp_0;
      label = 11;
      break;
    } else {
      $pp_0 = $incdec_ptr15;
      label = 7;
      break;
    }
   case 11:
    $incdec_ptr12 = $qp_0 + 4 | 0;
    $3 = HEAP32[$incdec_ptr12 >> 2] | 0;
    HEAP32[$qp_0 >> 2] = $3;
    $4 = HEAP32[$incdec_ptr12 >> 2] | 0;
    $tobool13 = ($4 | 0) == 0;
    if ($tobool13) {
      label = 5;
      break;
    } else {
      $qp_0 = $incdec_ptr12;
      label = 11;
      break;
    }
   case 12:
    HEAP32[$flagp >> 2] = $istyle_1;
    return $pstyle_0 | 0;
  }
  return 0;
}
function _emit_node($job, $n) {
  $job = $job | 0;
  $n = $n | 0;
  var $gvc1 = 0, $0 = 0, $shape = 0, $1 = 0, $tobool = 0, $graph = 0, $2 = 0, $call = 0, $tobool2 = 0, $clip = 0, $call4 = 0, $tobool6 = 0, $state = 0, $3 = 0, $conv9 = 0, $viewNum = 0, $4 = 0, $cmp = 0, $conv13 = 0, $name = 0, $5 = 0, $6 = 0, $7 = 0, $call16 = 0, $8 = 0, $tobool17 = 0, $9 = 0, $call19 = 0, $10 = 0, $tobool21 = 0, $call23 = 0, $11 = 0, $tobool2426 = 0, $12 = 0, $incdec_ptr27 = 0, $13 = 0, $cmp27 = 0, $incdec_ptr = 0, $14 = 0, $tobool24 = 0, $call30 = 0, $tobool31 = 0, $15 = 0, $fns = 0, $16 = 0, $codefn = 0, $17 = 0, $xlabel = 0, $18 = 0, $tobool38 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $gvc1 = $job | 0;
    $0 = HEAP32[$gvc1 >> 2] | 0;
    $shape = $n + 24 | 0;
    $1 = HEAP32[$shape >> 2] | 0;
    $tobool = ($1 | 0) == 0;
    if ($tobool) {
      label = 16;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $graph = $n + 20 | 0;
    $2 = HEAP32[$graph >> 2] | 0;
    $call = _node_in_layer($job, $2, $n) | 0;
    $tobool2 = $call << 24 >> 24 == 0;
    if ($tobool2) {
      label = 16;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $clip = $job + 256 | 0;
    $call4 = _node_in_box($n, $clip) | 0;
    $tobool6 = $call4 << 24 >> 24 == 0;
    if ($tobool6) {
      label = 16;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $state = $n + 132 | 0;
    $3 = HEAP8[$state] | 0;
    $conv9 = $3 << 24 >> 24;
    $viewNum = $0 + 28 | 0;
    $4 = HEAP32[$viewNum >> 2] | 0;
    $cmp = ($conv9 | 0) == ($4 | 0);
    if ($cmp) {
      label = 16;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $conv13 = $4 & 255;
    HEAP8[$state] = $conv13;
    $name = $n + 12 | 0;
    $5 = HEAP32[$name >> 2] | 0;
    _gvrender_comment($job, $5);
    $6 = $n | 0;
    $7 = HEAP32[41614] | 0;
    $call16 = _late_string($6, $7, 136112) | 0;
    $8 = HEAP8[$call16] | 0;
    $tobool17 = $8 << 24 >> 24 == 0;
    if ($tobool17) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    _gvrender_comment($job, $call16);
    label = 8;
    break;
   case 8:
    $9 = HEAP32[41560] | 0;
    $call19 = _late_string($6, $9, 136112) | 0;
    $10 = HEAP8[$call19] | 0;
    $tobool21 = $10 << 24 >> 24 == 0;
    if ($tobool21) {
      label = 13;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $call23 = _parse_style($call19) | 0;
    $11 = HEAP32[1820] | 0;
    $tobool2426 = ($11 | 0) == 0;
    if ($tobool2426) {
      label = 13;
      break;
    } else {
      $incdec_ptr27 = 7284;
      $12 = $11;
      label = 10;
      break;
    }
   case 10:
    $13 = HEAP8[$12] | 0;
    $cmp27 = $13 << 24 >> 24 == 105;
    if ($cmp27) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $incdec_ptr = $incdec_ptr27 + 4 | 0;
    $14 = HEAP32[$incdec_ptr27 >> 2] | 0;
    $tobool24 = ($14 | 0) == 0;
    if ($tobool24) {
      label = 13;
      break;
    } else {
      $incdec_ptr27 = $incdec_ptr;
      $12 = $14;
      label = 10;
      break;
    }
   case 12:
    $call30 = _strcmp($12 | 0, 101752) | 0;
    $tobool31 = ($call30 | 0) == 0;
    if ($tobool31) {
      label = 16;
      break;
    } else {
      label = 11;
      break;
    }
   case 13:
    _emit_begin_node($job, $n);
    $15 = HEAP32[$shape >> 2] | 0;
    $fns = $15 + 4 | 0;
    $16 = HEAP32[$fns >> 2] | 0;
    $codefn = $16 + 20 | 0;
    $17 = HEAP32[$codefn >> 2] | 0;
    FUNCTION_TABLE_vii[$17 & 1023]($job, $n);
    $xlabel = $n + 124 | 0;
    $18 = HEAP32[$xlabel >> 2] | 0;
    $tobool38 = ($18 | 0) == 0;
    if ($tobool38) {
      label = 15;
      break;
    } else {
      label = 14;
      break;
    }
   case 14:
    _emit_label($job, 10, $18);
    label = 15;
    break;
   case 15:
    _emit_end_node($job);
    label = 16;
    break;
   case 16:
    return;
  }
}
function _emit_edge($job, $e) {
  $job = $job | 0;
  $e = $e | 0;
  var $clip = 0, $call = 0, $tobool = 0, $head = 0, $call1 = 0, $tobool3 = 0, $tail = 0, $0 = 0, $name = 0, $1 = 0, $call4 = 0, $2 = 0, $name6 = 0, $3 = 0, $call7 = 0, $add8 = 0, $add9 = 0, $call10 = 0, $4 = 0, $name12 = 0, $5 = 0, $call13 = 0, $6 = 0, $graph15 = 0, $7 = 0, $8 = 0, $9 = 0, $and = 0, $tobool16 = 0, $strlen = 0, $endptr = 0, $10 = 0, $name21 = 0, $11 = 0, $call22 = 0, $12 = 0, $13 = 0, $call23 = 0, $14 = 0, $tobool24 = 0, $15 = 0, $call27 = 0, $16 = 0, $tobool29 = 0, $call31 = 0, $17 = 0, $tobool3231 = 0, $18 = 0, $incdec_ptr32 = 0, $19 = 0, $cmp = 0, $incdec_ptr = 0, $20 = 0, $tobool32 = 0, $call37 = 0, $tobool38 = 0, $styles_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $clip = $job + 256 | 0;
    $call = _edge_in_box($e, $clip) | 0;
    $tobool = $call << 24 >> 24 == 0;
    if ($tobool) {
      label = 15;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $head = $e + 12 | 0;
    $call1 = _edge_in_layer($job, $e) | 0;
    $tobool3 = $call1 << 24 >> 24 == 0;
    if ($tobool3) {
      label = 15;
      break;
    } else {
      label = 4;
      break;
    }
   case 4:
    $tail = $e + 16 | 0;
    $0 = HEAP32[$tail >> 2] | 0;
    $name = $0 + 12 | 0;
    $1 = HEAP32[$name >> 2] | 0;
    $call4 = _strlen($1 | 0) | 0;
    $2 = HEAP32[$head >> 2] | 0;
    $name6 = $2 + 12 | 0;
    $3 = HEAP32[$name6 >> 2] | 0;
    $call7 = _strlen($3 | 0) | 0;
    $add8 = $call4 + 3 | 0;
    $add9 = $add8 + $call7 | 0;
    $call10 = _malloc($add9) | 0;
    $4 = HEAP32[$tail >> 2] | 0;
    $name12 = $4 + 12 | 0;
    $5 = HEAP32[$name12 >> 2] | 0;
    $call13 = _strcpy($call10 | 0, $5 | 0) | 0;
    $6 = HEAP32[$head >> 2] | 0;
    $graph15 = $6 + 20 | 0;
    $7 = HEAP32[$graph15 >> 2] | 0;
    $8 = $7;
    $9 = HEAP32[$8 >> 2] | 0;
    $and = $9 & 16;
    $tobool16 = ($and | 0) == 0;
    $strlen = _strlen($call10 | 0) | 0;
    $endptr = $call10 + $strlen | 0;
    if ($tobool16) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    HEAP8[$endptr] = HEAP8[102616] | 0;
    HEAP8[$endptr + 1 | 0] = HEAP8[102617 | 0] | 0;
    HEAP8[$endptr + 2 | 0] = HEAP8[102618 | 0] | 0;
    label = 7;
    break;
   case 6:
    HEAP8[$endptr] = HEAP8[102232] | 0;
    HEAP8[$endptr + 1 | 0] = HEAP8[102233 | 0] | 0;
    HEAP8[$endptr + 2 | 0] = HEAP8[102234 | 0] | 0;
    label = 7;
    break;
   case 7:
    $10 = HEAP32[$head >> 2] | 0;
    $name21 = $10 + 12 | 0;
    $11 = HEAP32[$name21 >> 2] | 0;
    $call22 = _strcat($call10 | 0, $11 | 0) | 0;
    _gvrender_comment($job, $call10);
    _free($call10);
    $12 = $e | 0;
    $13 = HEAP32[41956] | 0;
    $call23 = _late_string($12, $13, 136112) | 0;
    $14 = HEAP8[$call23] | 0;
    $tobool24 = $14 << 24 >> 24 == 0;
    if ($tobool24) {
      label = 9;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    _gvrender_comment($job, $call23);
    label = 9;
    break;
   case 9:
    $15 = HEAP32[41904] | 0;
    $call27 = _late_string($12, $15, 136112) | 0;
    $16 = HEAP8[$call27] | 0;
    $tobool29 = $16 << 24 >> 24 == 0;
    if ($tobool29) {
      $styles_0 = 0;
      label = 14;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $call31 = _parse_style($call27) | 0;
    $17 = HEAP32[1820] | 0;
    $tobool3231 = ($17 | 0) == 0;
    if ($tobool3231) {
      $styles_0 = 7280;
      label = 14;
      break;
    } else {
      $incdec_ptr32 = 7284;
      $18 = $17;
      label = 11;
      break;
    }
   case 11:
    $19 = HEAP8[$18] | 0;
    $cmp = $19 << 24 >> 24 == 105;
    if ($cmp) {
      label = 13;
      break;
    } else {
      label = 12;
      break;
    }
   case 12:
    $incdec_ptr = $incdec_ptr32 + 4 | 0;
    $20 = HEAP32[$incdec_ptr32 >> 2] | 0;
    $tobool32 = ($20 | 0) == 0;
    if ($tobool32) {
      $styles_0 = 7280;
      label = 14;
      break;
    } else {
      $incdec_ptr32 = $incdec_ptr;
      $18 = $20;
      label = 11;
      break;
    }
   case 13:
    $call37 = _strcmp($18 | 0, 101752) | 0;
    $tobool38 = ($call37 | 0) == 0;
    if ($tobool38) {
      label = 15;
      break;
    } else {
      label = 12;
      break;
    }
   case 14:
    _emit_begin_edge($job, $e, $styles_0);
    _emit_edge_graphics($job, $e, $styles_0);
    _emit_end_edge($job);
    label = 15;
    break;
   case 15:
    return;
  }
}
function _emit_end_cluster($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  _gvrender_end_cluster($job, 0);
  _pop_obj_state($job);
  return;
}
function _parse_style($s) {
  $s = $s | 0;
  var $buf = 0, $p = 0, $xb = 0, $_b = 0, $arraydecay = 0, $ptr = 0, $eptr = 0, $buf34 = 0, $fun_0_ph = 0, $in_parens_0_ph = 0, $in_parens_0 = 0, $call = 0, $tobool1 = 0, $call3 = 0, $cmp6 = 0, $call9 = 0, $cmp12 = 0, $cmp15 = 0, $call18 = 0, $arrayidx = 0, $0 = 0, $1 = 0, $cmp20 = 0, $call22 = 0, $2 = 0, $incdec_ptr = 0, $3 = 0, $inc = 0, $arrayidx23 = 0, $fun_1 = 0, $4 = 0, $5 = 0, $cmp25 = 0, $call28 = 0, $6 = 0, $7 = 0, $call36 = 0, $8 = 0, $9 = 0, $cmp37 = 0, $call40 = 0, $10 = 0, $incdec_ptr44 = 0, $tobool45 = 0, $call47 = 0, $arrayidx49 = 0, $11 = 0, $12 = 0, $cmp50 = 0, $call53 = 0, $13 = 0, $14 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 152 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $buf = __stackBase__ | 0;
    $p = __stackBase__ + 128 | 0;
    $xb = __stackBase__ + 136 | 0;
    $_b = HEAP8[7536] | 0;
    if ($_b) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _agxbinit(4840, 128, 9008);
    HEAP8[7536] = 1;
    label = 4;
    break;
   case 4:
    $arraydecay = $buf | 0;
    _agxbinit($xb, 128, $arraydecay);
    HEAP32[$p >> 2] = $s;
    $ptr = $xb + 4 | 0;
    $eptr = $xb + 8 | 0;
    $buf34 = $xb | 0;
    $in_parens_0_ph = 0;
    $fun_0_ph = 0;
    label = 5;
    break;
   case 5:
    $in_parens_0 = $in_parens_0_ph;
    label = 6;
    break;
   case 6:
    $call = _style_token($p, $xb) | 0;
    if (($call | 0) == 40) {
      label = 7;
      break;
    } else if (($call | 0) == 41) {
      label = 9;
      break;
    } else if (($call | 0) == 0) {
      label = 22;
      break;
    } else {
      label = 11;
      break;
    }
   case 7:
    $tobool1 = $in_parens_0 << 24 >> 24 == 0;
    if ($tobool1) {
      $in_parens_0 = 1;
      label = 6;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $call3 = _agerr(1, 116624, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $s, tempInt) | 0) | 0;
    HEAP32[1820] = 0;
    _agxbfree($xb);
    label = 27;
    break;
   case 9:
    $cmp6 = $in_parens_0 << 24 >> 24 == 0;
    if ($cmp6) {
      label = 10;
      break;
    } else {
      $in_parens_0 = 0;
      label = 6;
      break;
    }
   case 10:
    $call9 = _agerr(1, 116144, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $s, tempInt) | 0) | 0;
    HEAP32[1820] = 0;
    _agxbfree($xb);
    label = 27;
    break;
   case 11:
    $cmp12 = $in_parens_0 << 24 >> 24 == 0;
    if ($cmp12) {
      label = 12;
      break;
    } else {
      $fun_1 = $fun_0_ph;
      label = 17;
      break;
    }
   case 12:
    $cmp15 = ($fun_0_ph | 0) == 63;
    if ($cmp15) {
      label = 13;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    $call18 = _agerr(0, 115648, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $s, tempInt) | 0) | 0;
    $arrayidx = 7280 + ($fun_0_ph << 2) | 0;
    HEAP32[$arrayidx >> 2] = 0;
    _agxbfree($xb);
    label = 27;
    break;
   case 14:
    $0 = HEAP32[1211] | 0;
    $1 = HEAP32[1212] | 0;
    $cmp20 = $0 >>> 0 < $1 >>> 0;
    if ($cmp20) {
      label = 16;
      break;
    } else {
      label = 15;
      break;
    }
   case 15:
    $call22 = _agxbmore(4840, 1) | 0;
    label = 16;
    break;
   case 16:
    $2 = HEAP32[1211] | 0;
    $incdec_ptr = $2 + 1 | 0;
    HEAP32[1211] = $incdec_ptr;
    HEAP8[$2] = 0;
    $3 = HEAP32[1211] | 0;
    $inc = $fun_0_ph + 1 | 0;
    $arrayidx23 = 7280 + ($fun_0_ph << 2) | 0;
    HEAP32[$arrayidx23 >> 2] = $3;
    $fun_1 = $inc;
    label = 17;
    break;
   case 17:
    $4 = HEAP32[$ptr >> 2] | 0;
    $5 = HEAP32[$eptr >> 2] | 0;
    $cmp25 = $4 >>> 0 < $5 >>> 0;
    if ($cmp25) {
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    $call28 = _agxbmore($xb, 1) | 0;
    label = 19;
    break;
   case 19:
    $6 = HEAP32[$ptr >> 2] | 0;
    HEAP8[$6] = 0;
    $7 = HEAP32[$buf34 >> 2] | 0;
    HEAP32[$ptr >> 2] = $7;
    $call36 = _agxbput(4840, $7) | 0;
    $8 = HEAP32[1211] | 0;
    $9 = HEAP32[1212] | 0;
    $cmp37 = $8 >>> 0 < $9 >>> 0;
    if ($cmp37) {
      label = 21;
      break;
    } else {
      label = 20;
      break;
    }
   case 20:
    $call40 = _agxbmore(4840, 1) | 0;
    label = 21;
    break;
   case 21:
    $10 = HEAP32[1211] | 0;
    $incdec_ptr44 = $10 + 1 | 0;
    HEAP32[1211] = $incdec_ptr44;
    HEAP8[$10] = 0;
    $in_parens_0_ph = $in_parens_0;
    $fun_0_ph = $fun_1;
    label = 5;
    break;
   case 22:
    $tobool45 = $in_parens_0 << 24 >> 24 == 0;
    if ($tobool45) {
      label = 24;
      break;
    } else {
      label = 23;
      break;
    }
   case 23:
    $call47 = _agerr(1, 115096, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $s, tempInt) | 0) | 0;
    HEAP32[1820] = 0;
    _agxbfree($xb);
    label = 27;
    break;
   case 24:
    $arrayidx49 = 7280 + ($fun_0_ph << 2) | 0;
    HEAP32[$arrayidx49 >> 2] = 0;
    _agxbfree($xb);
    $11 = HEAP32[1211] | 0;
    $12 = HEAP32[1212] | 0;
    $cmp50 = $11 >>> 0 < $12 >>> 0;
    if ($cmp50) {
      label = 26;
      break;
    } else {
      label = 25;
      break;
    }
   case 25:
    $call53 = _agxbmore(4840, 1) | 0;
    label = 26;
    break;
   case 26:
    $13 = HEAP32[1211] | 0;
    HEAP8[$13] = 0;
    $14 = HEAP32[1210] | 0;
    HEAP32[1211] = $14;
    label = 27;
    break;
   case 27:
    STACKTOP = __stackBase__;
    return 7280;
  }
  return 0;
}
function _style_token($s, $xb) {
  $s = $s | 0;
  $xb = $xb | 0;
  var $0 = 0, $1 = 0, $tobool16 = 0, $2 = 0, $p_017 = 0, $conv = 0, $call = 0, $tobool2 = 0, $3 = 0, $cmp = 0, $incdec_ptr = 0, $4 = 0, $tobool = 0, $p_0_lcssa = 0, $5 = 0, $conv5 = 0, $6 = 0, $conv1012 = 0, $call1113 = 0, $lnot14 = 0, $ptr = 0, $eptr = 0, $incdec_ptr7 = 0, $7 = 0, $conv8 = 0, $8 = 0, $p_115 = 0, $9 = 0, $10 = 0, $cmp14 = 0, $call16 = 0, $11 = 0, $incdec_ptr18 = 0, $incdec_ptr20 = 0, $12 = 0, $conv10 = 0, $call11 = 0, $lnot = 0, $token_0 = 0, $p_2 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = HEAP32[$s >> 2] | 0;
    $1 = HEAP8[$0] | 0;
    $tobool16 = $1 << 24 >> 24 == 0;
    if ($tobool16) {
      $p_0_lcssa = $0;
      label = 6;
      break;
    } else {
      $p_017 = $0;
      $2 = $1;
      label = 3;
      break;
    }
   case 3:
    $conv = $2 << 24 >> 24;
    $call = _isspace($conv | 0) | 0;
    $tobool2 = ($call | 0) == 0;
    if ($tobool2) {
      label = 4;
      break;
    } else {
      label = 5;
      break;
    }
   case 4:
    $3 = HEAP8[$p_017] | 0;
    $cmp = $3 << 24 >> 24 == 44;
    if ($cmp) {
      label = 5;
      break;
    } else {
      $p_0_lcssa = $p_017;
      label = 6;
      break;
    }
   case 5:
    $incdec_ptr = $p_017 + 1 | 0;
    $4 = HEAP8[$incdec_ptr] | 0;
    $tobool = $4 << 24 >> 24 == 0;
    if ($tobool) {
      $p_0_lcssa = $incdec_ptr;
      label = 6;
      break;
    } else {
      $p_017 = $incdec_ptr;
      $2 = $4;
      label = 3;
      break;
    }
   case 6:
    $5 = HEAP8[$p_0_lcssa] | 0;
    $conv5 = $5 << 24 >> 24;
    if (($conv5 | 0) == 40 | ($conv5 | 0) == 41) {
      label = 9;
      break;
    } else if (($conv5 | 0) == 0) {
      $p_2 = $p_0_lcssa;
      $token_0 = 0;
      label = 13;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $6 = HEAP8[$p_0_lcssa] | 0;
    $conv1012 = $6 << 24 >> 24;
    $call1113 = _is_style_delim($conv1012) | 0;
    $lnot14 = $call1113 << 24 >> 24 == 0;
    if ($lnot14) {
      label = 8;
      break;
    } else {
      $p_2 = $p_0_lcssa;
      $token_0 = 1;
      label = 13;
      break;
    }
   case 8:
    $ptr = $xb + 4 | 0;
    $eptr = $xb + 8 | 0;
    $p_115 = $p_0_lcssa;
    $8 = $6;
    label = 10;
    break;
   case 9:
    $incdec_ptr7 = $p_0_lcssa + 1 | 0;
    $7 = HEAP8[$p_0_lcssa] | 0;
    $conv8 = $7 << 24 >> 24;
    $p_2 = $incdec_ptr7;
    $token_0 = $conv8;
    label = 13;
    break;
   case 10:
    $9 = HEAP32[$ptr >> 2] | 0;
    $10 = HEAP32[$eptr >> 2] | 0;
    $cmp14 = $9 >>> 0 < $10 >>> 0;
    if ($cmp14) {
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $call16 = _agxbmore($xb, 1) | 0;
    label = 12;
    break;
   case 12:
    $11 = HEAP32[$ptr >> 2] | 0;
    $incdec_ptr18 = $11 + 1 | 0;
    HEAP32[$ptr >> 2] = $incdec_ptr18;
    HEAP8[$11] = $8;
    $incdec_ptr20 = $p_115 + 1 | 0;
    $12 = HEAP8[$incdec_ptr20] | 0;
    $conv10 = $12 << 24 >> 24;
    $call11 = _is_style_delim($conv10) | 0;
    $lnot = $call11 << 24 >> 24 == 0;
    if ($lnot) {
      $p_115 = $incdec_ptr20;
      $8 = $12;
      label = 10;
      break;
    } else {
      $p_2 = $incdec_ptr20;
      $token_0 = 1;
      label = 13;
      break;
    }
   case 13:
    HEAP32[$s >> 2] = $p_2;
    return $token_0 | 0;
  }
  return 0;
}
function _gv_fixLocale($set) {
  $set = $set | 0;
  var $tobool = 0, $0 = 0, $inc = 0, $cmp = 0, $call = 0, $call2 = 0, $call3 = 0, $cmp4 = 0, $dec = 0, $cmp6 = 0, $1 = 0, $call8 = 0, $2 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $tobool = ($set | 0) == 0;
    $0 = HEAP32[4042] | 0;
    if ($tobool) {
      label = 5;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $inc = $0 + 1 | 0;
    HEAP32[4042] = $inc;
    $cmp = ($0 | 0) == 0;
    if ($cmp) {
      label = 4;
      break;
    } else {
      label = 8;
      break;
    }
   case 4:
    $call = _setlocale(4, 0) | 0;
    $call2 = _strdup($call | 0) | 0;
    HEAP32[4040] = $call2;
    $call3 = _setlocale(4, 114568) | 0;
    label = 8;
    break;
   case 5:
    $cmp4 = ($0 | 0) > 0;
    if ($cmp4) {
      label = 6;
      break;
    } else {
      label = 8;
      break;
    }
   case 6:
    $dec = $0 - 1 | 0;
    HEAP32[4042] = $dec;
    $cmp6 = ($dec | 0) == 0;
    if ($cmp6) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    $1 = HEAP32[4040] | 0;
    $call8 = _setlocale(4, $1 | 0) | 0;
    $2 = HEAP32[4040] | 0;
    _free($2);
    label = 8;
    break;
   case 8:
    return;
  }
}
function _gvRenderJobs($gvc, $g) {
  $gvc = $gvc | 0;
  $g = $g | 0;
  var $drawing = 0, $0 = 0, $tobool = 0, $call = 0, $keybindings = 0, $1 = 0, $numkeys = 0, $call1 = 0, $tobool257 = 0, $gvg = 0, $common = 0, $type = 0, $active_jobs = 0, $viewNum = 0, $job_058 = 0, $2 = 0, $tobool3 = 0, $input_filename = 0, $3 = 0, $input_filename6 = 0, $4 = 0, $graph_index = 0, $5 = 0, $graph_index8 = 0, $input_filename9 = 0, $graph_index10 = 0, $common12 = 0, $6 = 0, $layout_type = 0, $7 = 0, $tobool15 = 0, $call17 = 0, $output_langname = 0, $8 = 0, $call19 = 0, $output_lang = 0, $9 = 0, $call23 = 0, $flags = 0, $10 = 0, $or = 0, $flags27 = 0, $11 = 0, $or28 = 0, $call29 = 0, $flags30 = 0, $12 = 0, $or31 = 0, $13 = 0, $tobool32 = 0, $flags34 = 0, $14 = 0, $and = 0, $tobool35 = 0, $15 = 0, $output_langname37 = 0, $16 = 0, $call38 = 0, $tobool39 = 0, $_pr = 0, $tobool46 = 0, $next_active = 0, $17 = 0, $output_file = 0, $18 = 0, $output_file48 = 0, $call50 = 0, $tobool51 = 0, $next_active56 = 0, $callbacks = 0, $flags57 = 0, $19 = 0, $and58 = 0, $tobool59 = 0, $20 = 0, $21 = 0, $show_boxes = 0, $call63 = 0, $tobool2 = 0, $retval_0 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $drawing = $g + 48 | 0;
    $0 = HEAP32[$drawing >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    $call = _agerr(1, 113984, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
    $retval_0 = -1;
    label = 30;
    break;
   case 4:
    _init_bb($g);
    _init_gvc($gvc, $g);
    _init_layering($gvc, $g);
    $keybindings = $gvc + 104 | 0;
    HEAP32[$keybindings >> 2] = 15480;
    $1 = HEAP32[3868] | 0;
    $numkeys = $gvc + 108 | 0;
    HEAP32[$numkeys >> 2] = $1;
    _gv_fixLocale(1);
    $call1 = _gvjobs_first($gvc) | 0;
    $tobool257 = ($call1 | 0) == 0;
    if ($tobool257) {
      label = 29;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $gvg = $gvc + 56 | 0;
    $common = $gvc | 0;
    $type = $gvc + 156 | 0;
    $active_jobs = $gvc + 164 | 0;
    $viewNum = $gvc + 28 | 0;
    $job_058 = $call1;
    label = 6;
    break;
   case 6:
    $2 = HEAP32[$gvg >> 2] | 0;
    $tobool3 = ($2 | 0) == 0;
    if ($tobool3) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $input_filename = $2 + 8 | 0;
    $3 = HEAP32[$input_filename >> 2] | 0;
    $input_filename6 = $job_058 + 20 | 0;
    HEAP32[$input_filename6 >> 2] = $3;
    $4 = HEAP32[$gvg >> 2] | 0;
    $graph_index = $4 + 12 | 0;
    $5 = HEAP32[$graph_index >> 2] | 0;
    $graph_index8 = $job_058 + 24 | 0;
    HEAP32[$graph_index8 >> 2] = $5;
    label = 9;
    break;
   case 8:
    $input_filename9 = $job_058 + 20 | 0;
    HEAP32[$input_filename9 >> 2] = 0;
    $graph_index10 = $job_058 + 24 | 0;
    HEAP32[$graph_index10 >> 2] = 0;
    label = 9;
    break;
   case 9:
    $common12 = $job_058 + 12 | 0;
    HEAP32[$common12 >> 2] = $common;
    $6 = HEAP32[$type >> 2] | 0;
    $layout_type = $job_058 + 28 | 0;
    HEAP32[$layout_type >> 2] = $6;
    $7 = HEAP32[$drawing >> 2] | 0;
    $tobool15 = ($7 | 0) == 0;
    if ($tobool15) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    $call17 = _agerr(1, 113528, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
    _gv_fixLocale(0);
    $retval_0 = -1;
    label = 30;
    break;
   case 11:
    $output_langname = $job_058 + 52 | 0;
    $8 = HEAP32[$output_langname >> 2] | 0;
    $call19 = _gvrender_select($job_058, $8) | 0;
    $output_lang = $job_058 + 56 | 0;
    HEAP32[$output_lang >> 2] = $call19;
    if (($call19 | 0) == 999) {
      label = 12;
      break;
    } else if (($call19 | 0) == 21) {
      label = 13;
      break;
    } else if (($call19 | 0) == 24) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 12:
    $9 = HEAP32[$output_langname >> 2] | 0;
    $call23 = _agerr(1, 113096, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $9, tempInt) | 0) | 0;
    _gv_fixLocale(0);
    $retval_0 = -1;
    label = 30;
    break;
   case 13:
    $flags = $job_058 + 152 | 0;
    $10 = HEAP32[$flags >> 2] | 0;
    $or = $10 | 1;
    HEAP32[$flags >> 2] = $or;
    label = 16;
    break;
   case 14:
    $flags27 = $job_058 + 152 | 0;
    $11 = HEAP32[$flags27 >> 2] | 0;
    $or28 = $11 | 520;
    HEAP32[$flags27 >> 2] = $or28;
    label = 16;
    break;
   case 15:
    $call29 = _chkOrder($g) | 0;
    $flags30 = $job_058 + 152 | 0;
    $12 = HEAP32[$flags30 >> 2] | 0;
    $or31 = $12 | $call29;
    HEAP32[$flags30 >> 2] = $or31;
    label = 16;
    break;
   case 16:
    $13 = HEAP32[$active_jobs >> 2] | 0;
    $tobool32 = ($13 | 0) == 0;
    if ($tobool32) {
      label = 20;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    $flags34 = $13 + 152 | 0;
    $14 = HEAP32[$flags34 >> 2] | 0;
    $and = $14 & 32;
    $tobool35 = ($and | 0) == 0;
    if ($tobool35) {
      label = 19;
      break;
    } else {
      label = 18;
      break;
    }
   case 18:
    $15 = HEAP32[$output_langname >> 2] | 0;
    $output_langname37 = $13 + 52 | 0;
    $16 = HEAP32[$output_langname37 >> 2] | 0;
    $call38 = _strcmp($15 | 0, $16 | 0) | 0;
    $tobool39 = ($call38 | 0) == 0;
    if ($tobool39) {
      label = 21;
      break;
    } else {
      label = 19;
      break;
    }
   case 19:
    _gvrender_end_job($13);
    HEAP32[$active_jobs >> 2] = 0;
    HEAP32[$viewNum >> 2] = 0;
    HEAP32[4044] = 0;
    label = 23;
    break;
   case 20:
    HEAP32[4044] = 0;
    label = 23;
    break;
   case 21:
    $_pr = HEAP32[4044] | 0;
    $tobool46 = ($_pr | 0) == 0;
    if ($tobool46) {
      label = 23;
      break;
    } else {
      label = 22;
      break;
    }
   case 22:
    $next_active = $_pr + 8 | 0;
    HEAP32[$next_active >> 2] = $job_058;
    $17 = HEAP32[4044] | 0;
    $output_file = $17 + 36 | 0;
    $18 = HEAP32[$output_file >> 2] | 0;
    $output_file48 = $job_058 + 36 | 0;
    HEAP32[$output_file48 >> 2] = $18;
    label = 25;
    break;
   case 23:
    $call50 = _gvrender_begin_job($job_058) | 0;
    $tobool51 = ($call50 | 0) == 0;
    if ($tobool51) {
      label = 24;
      break;
    } else {
      label = 28;
      break;
    }
   case 24:
    HEAP32[$active_jobs >> 2] = $job_058;
    label = 25;
    break;
   case 25:
    $next_active56 = $job_058 + 8 | 0;
    HEAP32[$next_active56 >> 2] = 0;
    $callbacks = $job_058 + 104 | 0;
    HEAP32[$callbacks >> 2] = 16120;
    _init_job_pad($job_058);
    _init_job_margin($job_058);
    _init_job_dpi($job_058, $g);
    _init_job_viewport($job_058, $g);
    _init_job_pagination($job_058, $g);
    $flags57 = $job_058 + 152 | 0;
    $19 = HEAP32[$flags57 >> 2] | 0;
    $and58 = $19 & 128;
    $tobool59 = ($and58 | 0) == 0;
    if ($tobool59) {
      label = 26;
      break;
    } else {
      label = 27;
      break;
    }
   case 26:
    $20 = HEAP32[41362] | 0;
    $21 = HEAP32[$common12 >> 2] | 0;
    $show_boxes = $21 + 20 | 0;
    HEAP32[$show_boxes >> 2] = $20;
    _emit_graph($job_058, $g);
    label = 27;
    break;
   case 27:
    HEAP32[4044] = $job_058;
    label = 28;
    break;
   case 28:
    $call63 = _gvjobs_next($gvc) | 0;
    $tobool2 = ($call63 | 0) == 0;
    if ($tobool2) {
      label = 29;
      break;
    } else {
      $job_058 = $call63;
      label = 6;
      break;
    }
   case 29:
    _gv_fixLocale(0);
    $retval_0 = 0;
    label = 30;
    break;
   case 30:
    STACKTOP = __stackBase__;
    return $retval_0 | 0;
  }
  return 0;
}
function _init_bb($g) {
  $g = $g | 0;
  var $0 = 0, $call = 0, $tobool5 = 0, $n_0_in6 = 0, $n_0 = 0, $call1 = 0, $tobool = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = $g;
    $call = _agfstnode($0) | 0;
    $tobool5 = ($call | 0) == 0;
    if ($tobool5) {
      label = 4;
      break;
    } else {
      $n_0_in6 = $call;
      label = 3;
      break;
    }
   case 3:
    $n_0 = $n_0_in6;
    _init_bb_node($g, $n_0);
    $call1 = _agnxtnode($0, $n_0_in6) | 0;
    $tobool = ($call1 | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      $n_0_in6 = $call1;
      label = 3;
      break;
    }
   case 4:
    return;
  }
}
function _init_gvc($gvc, $g) {
  $gvc = $gvc | 0;
  $g = $g | 0;
  var $xf = 0, $yf = 0, $g1 = 0, $graph_sets_margin = 0, $0 = 0, $call = 0, $tobool = 0, $call2 = 0, $cmp = 0, $1 = 0.0, $mul = 0.0, $y = 0, $x = 0, $cmp5 = 0, $2 = 0.0, $mul7 = 0.0, $graph_sets_pad = 0, $call13 = 0, $tobool14 = 0, $call16 = 0, $cmp17 = 0, $3 = 0.0, $mul19 = 0.0, $y20 = 0, $x22 = 0, $cmp23 = 0, $4 = 0.0, $mul25 = 0.0, $graph_sets_pageSize = 0, $pageSize = 0, $drawing = 0, $5 = 0, $page = 0, $6 = 0, $7 = 0, $8 = 0, $x35 = 0, $9 = 0.0, $cmp36 = 0, $y40 = 0, $10 = 0.0, $cmp41 = 0, $11 = 0, $landscape = 0, $12 = 0, $tobool47 = 0, $rotation = 0, $_ = 0, $pagedir = 0, $call51 = 0, $tobool52 = 0, $13 = 0, $tobool54 = 0, $bb = 0, $bb59 = 0, $14 = 0, $15 = 0, $root = 0, $16 = 0, $17 = 0, $call60 = 0, $18 = 0, $19 = 0, $call62 = 0, $proto = 0, $20 = 0, $n = 0, $21 = 0, $22 = 0, $23 = 0, $call63 = 0, $defaultfontname = 0, $24 = 0, $n65 = 0, $25 = 0, $26 = 0, $27 = 0, $call66 = 0.0, $defaultfontsize = 0, $defaultlinestyle = 0, $name = 0, $28 = 0, $graphname = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $xf = __stackBase__ | 0;
    $yf = __stackBase__ + 8 | 0;
    $g1 = $gvc + 128 | 0;
    HEAP32[$g1 >> 2] = $g;
    $graph_sets_margin = $gvc + 269 | 0;
    HEAP8[$graph_sets_margin] = 0;
    $0 = $g | 0;
    $call = _agget($0, 107616) | 0;
    $tobool = ($call | 0) == 0;
    if ($tobool) {
      label = 7;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $call2 = _sscanf($call | 0, 107216, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $xf, HEAP32[tempInt + 8 >> 2] = $yf, tempInt) | 0) | 0;
    $cmp = ($call2 | 0) > 0;
    if ($cmp) {
      label = 4;
      break;
    } else {
      label = 7;
      break;
    }
   case 4:
    $1 = +HEAPF64[$xf >> 3];
    $mul = $1 * 72.0;
    $y = $gvc + 184 | 0;
    HEAPF64[$y >> 3] = $mul;
    $x = $gvc + 176 | 0;
    HEAPF64[$x >> 3] = $mul;
    $cmp5 = ($call2 | 0) > 1;
    if ($cmp5) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    $2 = +HEAPF64[$yf >> 3];
    $mul7 = $2 * 72.0;
    HEAPF64[$y >> 3] = $mul7;
    label = 6;
    break;
   case 6:
    HEAP8[$graph_sets_margin] = 1;
    label = 7;
    break;
   case 7:
    $graph_sets_pad = $gvc + 268 | 0;
    HEAP8[$graph_sets_pad] = 0;
    $call13 = _agget($0, 106880) | 0;
    $tobool14 = ($call13 | 0) == 0;
    if ($tobool14) {
      label = 12;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $call16 = _sscanf($call13 | 0, 107216, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $xf, HEAP32[tempInt + 8 >> 2] = $yf, tempInt) | 0) | 0;
    $cmp17 = ($call16 | 0) > 0;
    if ($cmp17) {
      label = 9;
      break;
    } else {
      label = 12;
      break;
    }
   case 9:
    $3 = +HEAPF64[$xf >> 3];
    $mul19 = $3 * 72.0;
    $y20 = $gvc + 200 | 0;
    HEAPF64[$y20 >> 3] = $mul19;
    $x22 = $gvc + 192 | 0;
    HEAPF64[$x22 >> 3] = $mul19;
    $cmp23 = ($call16 | 0) > 1;
    if ($cmp23) {
      label = 10;
      break;
    } else {
      label = 11;
      break;
    }
   case 10:
    $4 = +HEAPF64[$yf >> 3];
    $mul25 = $4 * 72.0;
    HEAPF64[$y20 >> 3] = $mul25;
    label = 11;
    break;
   case 11:
    HEAP8[$graph_sets_pad] = 1;
    label = 12;
    break;
   case 12:
    $graph_sets_pageSize = $gvc + 270 | 0;
    HEAP8[$graph_sets_pageSize] = 0;
    $pageSize = $gvc + 208 | 0;
    $drawing = $g + 48 | 0;
    $5 = HEAP32[$drawing >> 2] | 0;
    $page = $5 + 48 | 0;
    $6 = $pageSize;
    $7 = $page;
    HEAP32[$6 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    $8 = HEAP32[$drawing >> 2] | 0;
    $x35 = $8 + 48 | 0;
    $9 = +HEAPF64[$x35 >> 3];
    $cmp36 = $9 > .001;
    if ($cmp36) {
      label = 13;
      break;
    } else {
      label = 15;
      break;
    }
   case 13:
    $y40 = $8 + 56 | 0;
    $10 = +HEAPF64[$y40 >> 3];
    $cmp41 = $10 > .001;
    if ($cmp41) {
      label = 14;
      break;
    } else {
      label = 15;
      break;
    }
   case 14:
    HEAP8[$graph_sets_pageSize] = 1;
    label = 15;
    break;
   case 15:
    $11 = HEAP32[$drawing >> 2] | 0;
    $landscape = $11 + 81 | 0;
    $12 = HEAP8[$landscape] | 0;
    $tobool47 = $12 << 24 >> 24 == 0;
    $rotation = $gvc + 264 | 0;
    $_ = $tobool47 ? 0 : 90;
    HEAP32[$rotation >> 2] = $_;
    $pagedir = $gvc + 168 | 0;
    HEAP32[$pagedir >> 2] = 106496;
    $call51 = _agget($0, 106088) | 0;
    $tobool52 = ($call51 | 0) == 0;
    if ($tobool52) {
      label = 18;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $13 = HEAP8[$call51] | 0;
    $tobool54 = $13 << 24 >> 24 == 0;
    if ($tobool54) {
      label = 18;
      break;
    } else {
      label = 17;
      break;
    }
   case 17:
    HEAP32[$pagedir >> 2] = $call51;
    label = 18;
    break;
   case 18:
    $bb = $gvc + 232 | 0;
    $bb59 = $g + 56 | 0;
    $14 = $bb;
    $15 = $bb59;
    HEAP32[$14 >> 2] = HEAP32[$15 >> 2] | 0;
    HEAP32[$14 + 4 >> 2] = HEAP32[$15 + 4 >> 2] | 0;
    HEAP32[$14 + 8 >> 2] = HEAP32[$15 + 8 >> 2] | 0;
    HEAP32[$14 + 12 >> 2] = HEAP32[$15 + 12 >> 2] | 0;
    HEAP32[$14 + 16 >> 2] = HEAP32[$15 + 16 >> 2] | 0;
    HEAP32[$14 + 20 >> 2] = HEAP32[$15 + 20 >> 2] | 0;
    HEAP32[$14 + 24 >> 2] = HEAP32[$15 + 24 >> 2] | 0;
    HEAP32[$14 + 28 >> 2] = HEAP32[$15 + 28 >> 2] | 0;
    $root = $g + 32 | 0;
    $16 = HEAP32[$root >> 2] | 0;
    $17 = $16 | 0;
    $call60 = _agfindattr($17, 105760) | 0;
    HEAP32[41862] = $call60;
    $18 = HEAP32[$root >> 2] | 0;
    $19 = $18 | 0;
    $call62 = _agfindattr($19, 105376) | 0;
    HEAP32[41864] = $call62;
    $proto = $g + 40 | 0;
    $20 = HEAP32[$proto >> 2] | 0;
    $n = $20 | 0;
    $21 = HEAP32[$n >> 2] | 0;
    $22 = $21 | 0;
    $23 = HEAP32[41598] | 0;
    $call63 = _late_nnstring($22, $23, 105056) | 0;
    $defaultfontname = $gvc + 288 | 0;
    HEAP32[$defaultfontname >> 2] = $call63;
    $24 = HEAP32[$proto >> 2] | 0;
    $n65 = $24 | 0;
    $25 = HEAP32[$n65 >> 2] | 0;
    $26 = $25 | 0;
    $27 = HEAP32[41596] | 0;
    $call66 = +_late_double($26, $27, 14.0, 1.0);
    $defaultfontsize = $gvc + 296 | 0;
    HEAPF64[$defaultfontsize >> 3] = $call66;
    $defaultlinestyle = $gvc + 304 | 0;
    HEAP32[$defaultlinestyle >> 2] = 21184;
    $name = $g + 12 | 0;
    $28 = HEAP32[$name >> 2] | 0;
    $graphname = $gvc + 160 | 0;
    HEAP32[$graphname >> 2] = $28;
    STACKTOP = __stackBase__;
    return;
  }
}
function _init_layering($gvc, $g) {
  $gvc = $gvc | 0;
  $g = $g | 0;
  var $layers = 0, $0 = 0, $tobool = 0, $layerIDs = 0, $1 = 0, $tobool3 = 0, $2 = 0, $3 = 0, $call = 0, $cmp = 0, $call9 = 0, $numLayers = 0, $numLayers11 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $layers = $gvc + 276 | 0;
    $0 = HEAP32[$layers >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _free($0);
    HEAP32[$layers >> 2] = 0;
    label = 4;
    break;
   case 4:
    $layerIDs = $gvc + 280 | 0;
    $1 = HEAP32[$layerIDs >> 2] | 0;
    $tobool3 = ($1 | 0) == 0;
    if ($tobool3) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $2 = $1;
    _free($2);
    HEAP32[$layerIDs >> 2] = 0;
    label = 6;
    break;
   case 6:
    $3 = $g | 0;
    $call = _agget($3, 109136) | 0;
    $cmp = ($call | 0) == 0;
    if ($cmp) {
      label = 8;
      break;
    } else {
      label = 7;
      break;
    }
   case 7:
    $call9 = _parse_layers($gvc, $g, $call) | 0;
    $numLayers = $gvc + 284 | 0;
    HEAP32[$numLayers >> 2] = $call9;
    label = 9;
    break;
   case 8:
    HEAP32[$layerIDs >> 2] = 0;
    $numLayers11 = $gvc + 284 | 0;
    HEAP32[$numLayers11 >> 2] = 1;
    label = 9;
    break;
   case 9:
    return;
  }
}
function _chkOrder($g) {
  $g = $g | 0;
  var $0 = 0, $call = 0, $tobool = 0, $1 = 0, $add_ptr = 0, $call2 = 0, $tobool3 = 0, $add_ptr9 = 0, $call10 = 0, $tobool11 = 0, $retval_0 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = $g | 0;
    $call = _agget($0, 110256) | 0;
    $tobool = ($call | 0) == 0;
    if ($tobool) {
      label = 6;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $1 = HEAP8[$call] | 0;
    if (($1 << 24 >> 24 | 0) == 110) {
      label = 4;
      break;
    } else if (($1 << 24 >> 24 | 0) == 101) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 4:
    $add_ptr = $call + 1 | 0;
    $call2 = _strcmp($add_ptr | 0, 109848) | 0;
    $tobool3 = ($call2 | 0) == 0;
    if ($tobool3) {
      $retval_0 = 1;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    $add_ptr9 = $call + 1 | 0;
    $call10 = _strcmp($add_ptr9 | 0, 109496) | 0;
    $tobool11 = ($call10 | 0) == 0;
    if ($tobool11) {
      $retval_0 = 16;
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $retval_0 = 0;
    label = 7;
    break;
   case 7:
    return $retval_0 | 0;
  }
  return 0;
}
function _init_job_pad($job) {
  $job = $job | 0;
  var $gvc1 = 0, $0 = 0, $graph_sets_pad = 0, $1 = 0, $tobool = 0, $pad = 0, $pad2 = 0, $2 = 0, $3 = 0, $output_lang = 0, $4 = 0, $cond = 0, $features = 0, $5 = 0, $default_pad = 0, $6 = 0.0, $y = 0, $x = 0, $y6 = 0, $x8 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $gvc1 = $job | 0;
    $0 = HEAP32[$gvc1 >> 2] | 0;
    $graph_sets_pad = $0 + 268 | 0;
    $1 = HEAP8[$graph_sets_pad] | 0;
    $tobool = $1 << 24 >> 24 == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $pad = $job + 240 | 0;
    $pad2 = $0 + 192 | 0;
    $2 = $pad;
    $3 = $pad2;
    HEAP32[$2 >> 2] = HEAP32[$3 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$3 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$3 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$3 + 12 >> 2] | 0;
    label = 7;
    break;
   case 4:
    $output_lang = $job + 56 | 0;
    $4 = HEAP32[$output_lang >> 2] | 0;
    $cond = ($4 | 0) == 300;
    if ($cond) {
      label = 5;
      break;
    } else {
      label = 6;
      break;
    }
   case 5:
    $features = $job + 68 | 0;
    $5 = HEAP32[$features >> 2] | 0;
    $default_pad = $5 + 8 | 0;
    $6 = +HEAPF64[$default_pad >> 3];
    $y = $job + 248 | 0;
    HEAPF64[$y >> 3] = $6;
    $x = $job + 240 | 0;
    HEAPF64[$x >> 3] = $6;
    label = 7;
    break;
   case 6:
    $y6 = $job + 248 | 0;
    HEAPF64[$y6 >> 3] = 4.0;
    $x8 = $job + 240 | 0;
    HEAPF64[$x8 >> 3] = 4.0;
    label = 7;
    break;
   case 7:
    return;
  }
}
function _init_job_margin($job) {
  $job = $job | 0;
  var $gvc1 = 0, $0 = 0, $graph_sets_margin = 0, $1 = 0, $tobool = 0, $margin = 0, $margin2 = 0, $2 = 0, $3 = 0, $output_lang = 0, $4 = 0, $margin3 = 0, $features = 0, $5 = 0, $default_margin = 0, $6 = 0, $7 = 0, $y = 0, $x = 0, $x10 = 0, $8 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $gvc1 = $job | 0;
    $0 = HEAP32[$gvc1 >> 2] | 0;
    $graph_sets_margin = $0 + 269 | 0;
    $1 = HEAP8[$graph_sets_margin] | 0;
    $tobool = $1 << 24 >> 24 == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $margin = $job + 416 | 0;
    $margin2 = $0 + 176 | 0;
    $2 = $margin;
    $3 = $margin2;
    HEAP32[$2 >> 2] = HEAP32[$3 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$3 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$3 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$3 + 12 >> 2] | 0;
    label = 8;
    break;
   case 4:
    $output_lang = $job + 56 | 0;
    $4 = HEAP32[$output_lang >> 2] | 0;
    if (($4 | 0) == 300) {
      label = 5;
      break;
    } else if (($4 | 0) == 2 | ($4 | 0) == 3 | ($4 | 0) == 4 | ($4 | 0) == 22 | ($4 | 0) == 21 | ($4 | 0) == 30) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 5:
    $margin3 = $job + 416 | 0;
    $features = $job + 84 | 0;
    $5 = HEAP32[$features >> 2] | 0;
    $default_margin = $5 + 8 | 0;
    $6 = $margin3;
    $7 = $default_margin;
    HEAP32[$6 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    label = 8;
    break;
   case 6:
    $y = $job + 424 | 0;
    HEAPF64[$y >> 3] = 36.0;
    $x = $job + 416 | 0;
    HEAPF64[$x >> 3] = 36.0;
    label = 8;
    break;
   case 7:
    $x10 = $job + 416 | 0;
    $8 = $x10;
    _memset($8 | 0, 0, 16);
    label = 8;
    break;
   case 8:
    return;
  }
}
function _init_job_dpi($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $gvc = 0, $0 = 0, $active_jobs = 0, $1 = 0, $drawing = 0, $2 = 0, $dpi = 0, $3 = 0.0, $cmp = 0, $y = 0, $x = 0, $tobool = 0, $device_sets_dpi = 0, $4 = 0, $tobool6 = 0, $dpi8 = 0, $device_dpi = 0, $5 = 0, $6 = 0, $output_lang = 0, $7 = 0, $cond = 0, $dpi10 = 0, $features = 0, $8 = 0, $default_dpi = 0, $9 = 0, $10 = 0, $y12 = 0, $x14 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $gvc = $job | 0;
    $0 = HEAP32[$gvc >> 2] | 0;
    $active_jobs = $0 + 164 | 0;
    $1 = HEAP32[$active_jobs >> 2] | 0;
    $drawing = $g + 48 | 0;
    $2 = HEAP32[$drawing >> 2] | 0;
    $dpi = $2 + 24 | 0;
    $3 = +HEAPF64[$dpi >> 3];
    $cmp = $3 != 0.0;
    if ($cmp) {
      label = 3;
      break;
    } else {
      label = 4;
      break;
    }
   case 3:
    $y = $job + 440 | 0;
    HEAPF64[$y >> 3] = $3;
    $x = $job + 432 | 0;
    HEAPF64[$x >> 3] = $3;
    label = 10;
    break;
   case 4:
    $tobool = ($1 | 0) == 0;
    if ($tobool) {
      label = 7;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $device_sets_dpi = $1 + 128 | 0;
    $4 = HEAP8[$device_sets_dpi] | 0;
    $tobool6 = $4 << 24 >> 24 == 0;
    if ($tobool6) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $dpi8 = $job + 432 | 0;
    $device_dpi = $1 + 112 | 0;
    $5 = $dpi8;
    $6 = $device_dpi;
    HEAP32[$5 >> 2] = HEAP32[$6 >> 2] | 0;
    HEAP32[$5 + 4 >> 2] = HEAP32[$6 + 4 >> 2] | 0;
    HEAP32[$5 + 8 >> 2] = HEAP32[$6 + 8 >> 2] | 0;
    HEAP32[$5 + 12 >> 2] = HEAP32[$6 + 12 >> 2] | 0;
    label = 10;
    break;
   case 7:
    $output_lang = $job + 56 | 0;
    $7 = HEAP32[$output_lang >> 2] | 0;
    $cond = ($7 | 0) == 300;
    $dpi10 = $job + 432 | 0;
    if ($cond) {
      label = 8;
      break;
    } else {
      label = 9;
      break;
    }
   case 8:
    $features = $job + 84 | 0;
    $8 = HEAP32[$features >> 2] | 0;
    $default_dpi = $8 + 40 | 0;
    $9 = $dpi10;
    $10 = $default_dpi;
    HEAP32[$9 >> 2] = HEAP32[$10 >> 2] | 0;
    HEAP32[$9 + 4 >> 2] = HEAP32[$10 + 4 >> 2] | 0;
    HEAP32[$9 + 8 >> 2] = HEAP32[$10 + 8 >> 2] | 0;
    HEAP32[$9 + 12 >> 2] = HEAP32[$10 + 12 >> 2] | 0;
    label = 10;
    break;
   case 9:
    $y12 = $job + 440 | 0;
    HEAPF64[$y12 >> 3] = 96.0;
    $x14 = $dpi10 | 0;
    HEAPF64[$x14 >> 3] = 96.0;
    label = 10;
    break;
   case 10:
    return;
  }
}
function _init_job_viewport($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $X = 0, $Y = 0, $Z = 0, $x = 0, $y = 0, $gvc1 = 0, $0 = 0, $UR_sroa_0_0__idx = 0, $UR_sroa_0_0_copyload = 0.0, $UR_sroa_1_8__idx33 = 0, $UR_sroa_1_8_copyload = 0.0, $LL_sroa_0_0__idx = 0, $LL_sroa_0_0_copyload = 0.0, $LL_sroa_1_8__idx36 = 0, $LL_sroa_1_8_copyload = 0.0, $x6 = 0, $1 = 0.0, $sub = 0.0, $x9 = 0, $y12 = 0, $2 = 0.0, $sub13 = 0.0, $y16 = 0, $3 = 0.0, $add = 0.0, $x22 = 0, $4 = 0.0, $add26 = 0.0, $y29 = 0, $5 = 0.0, $6 = 0.0, $sub36 = 0.0, $7 = 0.0, $sub44 = 0.0, $drawing = 0, $8 = 0, $x47 = 0, $9 = 0.0, $cmp = 0, $y51 = 0, $10 = 0.0, $cmp52 = 0, $cmp58 = 0, $cmp61 = 0, $or_cond = 0, $filled = 0, $11 = 0, $tobool = 0, $cmp68 = 0, $or_cond63 = 0, $cmp73 = 0, $or_cond64 = 0, $div = 0.0, $div80 = 0.0, $cmp81 = 0, $div_div80 = 0.0, $add92 = 0.0, $div93 = 0.0, $add96 = 0.0, $div97 = 0.0, $12 = 0, $rotation = 0, $13 = 0, $rotation99 = 0, $14 = 0.0, $mul = 0.0, $mul102 = 0.0, $15 = 0, $call = 0, $tobool103 = 0, $call105 = 0, $add106 = 0, $call107 = 0, $call108 = 0, $add109 = 0, $call110 = 0, $call111 = 0, $cmp112 = 0, $root = 0, $16 = 0, $17 = 0, $call115 = 0, $tobool116 = 0, $u118 = 0, $coord = 0, $x119 = 0, $18 = 0.0, $y122 = 0, $19 = 0, $20 = 0.0, $call124 = 0, $cmp125 = 0, $root128 = 0, $21 = 0, $22 = 0, $call129 = 0, $tobool130 = 0, $u132 = 0, $coord133 = 0, $x134 = 0, $23 = 0.0, $y137 = 0, $24 = 0, $25 = 0.0, $call140 = 0, $26 = 0.0, $x144 = 0, $27 = 0.0, $y146 = 0, $28 = 0.0, $zoom = 0, $29 = 0.0, $x147 = 0, $30 = 0.0, $y149 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 40 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $X = __stackBase__ | 0;
    $Y = __stackBase__ + 8 | 0;
    $Z = __stackBase__ + 16 | 0;
    $x = __stackBase__ + 24 | 0;
    $y = __stackBase__ + 32 | 0;
    $gvc1 = $job | 0;
    $0 = HEAP32[$gvc1 >> 2] | 0;
    $UR_sroa_0_0__idx = $0 + 248 | 0;
    $UR_sroa_0_0_copyload = +HEAPF64[$UR_sroa_0_0__idx >> 3];
    $UR_sroa_1_8__idx33 = $0 + 256 | 0;
    $UR_sroa_1_8_copyload = +HEAPF64[$UR_sroa_1_8__idx33 >> 3];
    $LL_sroa_0_0__idx = $0 + 232 | 0;
    $LL_sroa_0_0_copyload = +HEAPF64[$LL_sroa_0_0__idx >> 3];
    $LL_sroa_1_8__idx36 = $0 + 240 | 0;
    $LL_sroa_1_8_copyload = +HEAPF64[$LL_sroa_1_8__idx36 >> 3];
    $x6 = $job + 240 | 0;
    $1 = +HEAPF64[$x6 >> 3];
    $sub = $LL_sroa_0_0_copyload - $1;
    $x9 = $job + 208 | 0;
    HEAPF64[$x9 >> 3] = $sub;
    $y12 = $job + 248 | 0;
    $2 = +HEAPF64[$y12 >> 3];
    $sub13 = $LL_sroa_1_8_copyload - $2;
    $y16 = $job + 216 | 0;
    HEAPF64[$y16 >> 3] = $sub13;
    $3 = +HEAPF64[$x6 >> 3];
    $add = $UR_sroa_0_0_copyload + $3;
    $x22 = $job + 224 | 0;
    HEAPF64[$x22 >> 3] = $add;
    $4 = +HEAPF64[$y12 >> 3];
    $add26 = $UR_sroa_1_8_copyload + $4;
    $y29 = $job + 232 | 0;
    HEAPF64[$y29 >> 3] = $add26;
    $5 = +HEAPF64[$x22 >> 3];
    $6 = +HEAPF64[$x9 >> 3];
    $sub36 = $5 - $6;
    $7 = +HEAPF64[$y16 >> 3];
    $sub44 = $add26 - $7;
    HEAPF64[$Z >> 3] = 1.0;
    $drawing = $g + 48 | 0;
    $8 = HEAP32[$drawing >> 2] | 0;
    $x47 = $8 + 64 | 0;
    $9 = +HEAPF64[$x47 >> 3];
    $cmp = $9 > .001;
    if ($cmp) {
      label = 3;
      break;
    } else {
      label = 7;
      break;
    }
   case 3:
    $y51 = $8 + 72 | 0;
    $10 = +HEAPF64[$y51 >> 3];
    $cmp52 = $10 > .001;
    if ($cmp52) {
      label = 4;
      break;
    } else {
      label = 7;
      break;
    }
   case 4:
    $cmp58 = $9 < $sub36;
    $cmp61 = $10 < $sub44;
    $or_cond = $cmp58 | $cmp61;
    if ($or_cond) {
      label = 6;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $filled = $8 + 80 | 0;
    $11 = HEAP8[$filled] | 0;
    $tobool = $11 << 24 >> 24 != 0;
    $cmp68 = $9 > $sub36;
    $or_cond63 = $tobool & $cmp68;
    $cmp73 = $10 > $sub44;
    $or_cond64 = $or_cond63 & $cmp73;
    if ($or_cond64) {
      label = 6;
      break;
    } else {
      label = 7;
      break;
    }
   case 6:
    $div = $9 / $sub36;
    $div80 = $10 / $sub44;
    $cmp81 = $div < $div80;
    $div_div80 = $cmp81 ? $div : $div80;
    HEAPF64[$Z >> 3] = $div_div80;
    label = 7;
    break;
   case 7:
    $add92 = $UR_sroa_0_0_copyload + $LL_sroa_0_0_copyload;
    $div93 = $add92 * .5;
    HEAPF64[$x >> 3] = $div93;
    $add96 = $UR_sroa_1_8_copyload + $LL_sroa_1_8_copyload;
    $div97 = $add96 * .5;
    HEAPF64[$y >> 3] = $div97;
    $12 = HEAP32[$gvc1 >> 2] | 0;
    $rotation = $12 + 264 | 0;
    $13 = HEAP32[$rotation >> 2] | 0;
    $rotation99 = $job + 360 | 0;
    HEAP32[$rotation99 >> 2] = $13;
    $14 = +HEAPF64[$Z >> 3];
    $mul = $sub36 * $14;
    HEAPF64[$X >> 3] = $mul;
    $mul102 = $sub44 * $14;
    HEAPF64[$Y >> 3] = $mul102;
    $15 = $g | 0;
    $call = _agget($15, 111960) | 0;
    $tobool103 = ($call | 0) == 0;
    if ($tobool103) {
      label = 16;
      break;
    } else {
      label = 8;
      break;
    }
   case 8:
    $call105 = _strlen($call | 0) | 0;
    $add106 = $call105 + 1 | 0;
    $call107 = _malloc($add106) | 0;
    $call108 = _strlen($call | 0) | 0;
    $add109 = $call108 + 1 | 0;
    $call110 = _malloc($add109) | 0;
    $call111 = _sscanf($call | 0, 111496, (tempInt = STACKTOP, STACKTOP = STACKTOP + 32 | 0, HEAP32[tempInt >> 2] = $X, HEAP32[tempInt + 8 >> 2] = $Y, HEAP32[tempInt + 16 >> 2] = $Z, HEAP32[tempInt + 24 >> 2] = $call107, tempInt) | 0) | 0;
    $cmp112 = ($call111 | 0) == 4;
    if ($cmp112) {
      label = 9;
      break;
    } else {
      label = 11;
      break;
    }
   case 9:
    $root = $g + 32 | 0;
    $16 = HEAP32[$root >> 2] | 0;
    $17 = $16;
    $call115 = _agfindnode($17, $call107) | 0;
    $tobool116 = ($call115 | 0) == 0;
    if ($tobool116) {
      label = 15;
      break;
    } else {
      label = 10;
      break;
    }
   case 10:
    $u118 = $call115 + 24 | 0;
    $coord = $u118 + 8 | 0;
    $x119 = $coord;
    $18 = +HEAPF64[$x119 >> 3];
    HEAPF64[$x >> 3] = $18;
    $y122 = $u118 + 16 | 0;
    $19 = $y122;
    $20 = +HEAPF64[$19 >> 3];
    HEAPF64[$y >> 3] = $20;
    label = 15;
    break;
   case 11:
    $call124 = _sscanf($call | 0, 111064, (tempInt = STACKTOP, STACKTOP = STACKTOP + 40 | 0, HEAP32[tempInt >> 2] = $X, HEAP32[tempInt + 8 >> 2] = $Y, HEAP32[tempInt + 16 >> 2] = $Z, HEAP32[tempInt + 24 >> 2] = $call107, HEAP32[tempInt + 32 >> 2] = $call110, tempInt) | 0) | 0;
    $cmp125 = ($call124 | 0) == 4;
    if ($cmp125) {
      label = 12;
      break;
    } else {
      label = 14;
      break;
    }
   case 12:
    $root128 = $g + 32 | 0;
    $21 = HEAP32[$root128 >> 2] | 0;
    $22 = $21;
    $call129 = _agfindnode($22, $call107) | 0;
    $tobool130 = ($call129 | 0) == 0;
    if ($tobool130) {
      label = 15;
      break;
    } else {
      label = 13;
      break;
    }
   case 13:
    $u132 = $call129 + 24 | 0;
    $coord133 = $u132 + 8 | 0;
    $x134 = $coord133;
    $23 = +HEAPF64[$x134 >> 3];
    HEAPF64[$x >> 3] = $23;
    $y137 = $u132 + 16 | 0;
    $24 = $y137;
    $25 = +HEAPF64[$24 >> 3];
    HEAPF64[$y >> 3] = $25;
    label = 15;
    break;
   case 14:
    $call140 = _sscanf($call | 0, 110680, (tempInt = STACKTOP, STACKTOP = STACKTOP + 40 | 0, HEAP32[tempInt >> 2] = $X, HEAP32[tempInt + 8 >> 2] = $Y, HEAP32[tempInt + 16 >> 2] = $Z, HEAP32[tempInt + 24 >> 2] = $x, HEAP32[tempInt + 32 >> 2] = $y, tempInt) | 0) | 0;
    label = 15;
    break;
   case 15:
    _free($call107);
    _free($call110);
    label = 16;
    break;
   case 16:
    $26 = +HEAPF64[$X >> 3];
    $x144 = $job + 368 | 0;
    HEAPF64[$x144 >> 3] = $26;
    $27 = +HEAPF64[$Y >> 3];
    $y146 = $job + 376 | 0;
    HEAPF64[$y146 >> 3] = $27;
    $28 = +HEAPF64[$Z >> 3];
    $zoom = $job + 352 | 0;
    HEAPF64[$zoom >> 3] = $28;
    $29 = +HEAPF64[$x >> 3];
    $x147 = $job + 336 | 0;
    HEAPF64[$x147 >> 3] = $29;
    $30 = +HEAPF64[$y >> 3];
    $y149 = $job + 344 | 0;
    HEAPF64[$y149 >> 3] = $30;
    STACKTOP = __stackBase__;
    return;
  }
}
function _exch_xyf($agg_result, $p) {
  $agg_result = $agg_result | 0;
  $p = $p | 0;
  var $1 = 0.0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 16 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  HEAP32[$p + 8 >> 2] = HEAP32[tempParam + 8 >> 2] | 0;
  HEAP32[$p + 12 >> 2] = HEAP32[tempParam + 12 >> 2] | 0;
  $1 = +HEAPF64[$p >> 3];
  HEAPF64[$agg_result >> 3] = +HEAPF64[$p + 8 >> 3];
  HEAPF64[$agg_result + 8 >> 3] = $1;
  STACKTOP = __stackBase__;
  return;
}
function _pagecode($agg_result, $job, $c) {
  $agg_result = $agg_result | 0;
  $job = $job | 0;
  $c = $c | 0;
  var $conv = 0, $y1 = 0, $0 = 0, $sub = 0, $y2 = 0, $x10 = 0, $1 = 0, $sub11 = 0, $x13 = 0, $rv_sroa_1_0 = 0, $rv_sroa_0_0 = 0, $rv_sroa_0_0__idx = 0, $rv_sroa_1_4__idx1 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $conv = $c << 24 >> 24;
    if (($conv | 0) == 84) {
      label = 3;
      break;
    } else if (($conv | 0) == 66) {
      label = 4;
      break;
    } else if (($conv | 0) == 76) {
      label = 5;
      break;
    } else if (($conv | 0) == 82) {
      label = 6;
      break;
    } else {
      $rv_sroa_0_0 = 0;
      $rv_sroa_1_0 = 0;
      label = 7;
      break;
    }
   case 3:
    $y1 = $job + 168 | 0;
    $0 = HEAP32[$y1 >> 2] | 0;
    $sub = $0 - 1 | 0;
    $y2 = $job + 176 | 0;
    HEAP32[$y2 >> 2] = $sub;
    $rv_sroa_0_0 = 0;
    $rv_sroa_1_0 = -1;
    label = 7;
    break;
   case 4:
    $rv_sroa_0_0 = 0;
    $rv_sroa_1_0 = 1;
    label = 7;
    break;
   case 5:
    $rv_sroa_0_0 = 1;
    $rv_sroa_1_0 = 0;
    label = 7;
    break;
   case 6:
    $x10 = $job + 164 | 0;
    $1 = HEAP32[$x10 >> 2] | 0;
    $sub11 = $1 - 1 | 0;
    $x13 = $job + 172 | 0;
    HEAP32[$x13 >> 2] = $sub11;
    $rv_sroa_0_0 = -1;
    $rv_sroa_1_0 = 0;
    label = 7;
    break;
   case 7:
    $rv_sroa_0_0__idx = $agg_result | 0;
    HEAP32[$rv_sroa_0_0__idx >> 2] = $rv_sroa_0_0;
    $rv_sroa_1_4__idx1 = $agg_result + 4 | 0;
    HEAP32[$rv_sroa_1_4__idx1 >> 2] = $rv_sroa_1_0;
    return;
  }
}
function _exch_xy($agg_result, $p) {
  $agg_result = $agg_result | 0;
  $p = $p | 0;
  var $1 = 0, tempParam = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  tempParam = $p;
  $p = STACKTOP;
  STACKTOP = STACKTOP + 8 | 0;
  HEAP32[$p >> 2] = HEAP32[tempParam >> 2] | 0;
  HEAP32[$p + 4 >> 2] = HEAP32[tempParam + 4 >> 2] | 0;
  $1 = HEAP32[$p >> 2] | 0;
  HEAP32[$agg_result >> 2] = HEAP32[$p + 4 >> 2] | 0;
  HEAP32[$agg_result + 4 >> 2] = $1;
  STACKTOP = __stackBase__;
  return;
}
function _init_job_pagination($job, $g) {
  $job = $job | 0;
  $g = $g | 0;
  var $pageSize = 0, $imageSize = 0, $margin = 0, $centering = 0, $tmp = 0, $tmp219 = 0, $tmpcast = 0, $tmp223 = 0, $tmpcast85 = 0, $tmp241 = 0, $tmpcast88 = 0, $tmp243 = 0, $tmpcast89 = 0, $tmp275 = 0, $tmp276 = 0, $tmp277 = 0, $tmp278 = 0, $tmp456 = 0, $tmpcast86 = 0, $tmp461 = 0, $tmpcast87 = 0, $gvc1 = 0, $0 = 0, $1 = 0, $view = 0, $2 = 0, $3 = 0, $rotation = 0, $4 = 0, $tobool = 0, $5 = 0, $margin2 = 0, $6 = 0, $7 = 0, $graph_sets_pageSize = 0, $8 = 0, $tobool3 = 0, $flags = 0, $9 = 0, $and = 0, $tobool4 = 0, $x = 0, $10 = 0.0, $x7 = 0, $11 = 0.0, $mul = 0.0, $sub = 0.0, $x8 = 0, $y = 0, $12 = 0.0, $y10 = 0, $13 = 0.0, $mul11 = 0.0, $sub12 = 0.0, $y13 = 0, $14 = 0.0, $cmp = 0, $x17 = 0, $x18 = 0, $15 = 0.0, $div = 0.0, $conv20 = 0, $x22 = 0, $16 = 0.0, $conv26 = 0.0, $17 = 0.0, $mul28 = 0.0, $sub29 = 0.0, $cmp30 = 0, $inc = 0, $18 = 0.0, $cmp38 = 0, $y42 = 0, $y44 = 0, $19 = 0.0, $div46 = 0.0, $conv47 = 0, $y49 = 0, $20 = 0.0, $conv53 = 0.0, $21 = 0.0, $mul55 = 0.0, $sub56 = 0.0, $cmp57 = 0, $inc62 = 0, $x66 = 0, $22 = 0, $y68 = 0, $23 = 0, $mul69 = 0, $numPages = 0, $x70 = 0, $24 = 0.0, $25 = 0.0, $cmp72 = 0, $_ = 0.0, $y77 = 0, $26 = 0.0, $27 = 0.0, $cmp79 = 0, $cond86 = 0.0, $features = 0, $28 = 0, $tobool89 = 0, $features91 = 0, $29 = 0, $x92 = 0, $30 = 0.0, $x93 = 0, $31 = 0.0, $mul94 = 0.0, $sub95 = 0.0, $x96 = 0, $cmp98 = 0, $storemerge = 0.0, $32 = 0, $y106 = 0, $33 = 0.0, $y107 = 0, $34 = 0.0, $mul108 = 0.0, $sub109 = 0.0, $y110 = 0, $cmp112 = 0, $35 = 0, $numPages121 = 0, $y123 = 0, $x125 = 0, $x126 = 0, $36 = 0.0, $x127 = 0, $37 = 0.0, $cmp128 = 0, $y134 = 0, $38 = 0.0, $y135 = 0, $39 = 0.0, $cmp136 = 0, $x143 = 0, $40 = 0.0, $x144 = 0, $41 = 0.0, $mul145 = 0.0, $add = 0.0, $x146 = 0, $42 = 0.0, $mul147 = 0.0, $div148 = 0.0, $cmp149 = 0, $add160 = 0.0, $sub171 = 0.0, $add160_sink = 0.0, $conv161 = 0, $width = 0, $y175 = 0, $43 = 0.0, $y176 = 0, $44 = 0.0, $mul177 = 0.0, $add178 = 0.0, $y180 = 0, $45 = 0.0, $mul181 = 0.0, $div182 = 0.0, $cmp183 = 0, $add194 = 0.0, $sub205 = 0.0, $add194_sink = 0.0, $conv195 = 0, $height = 0, $pagesArrayMinor = 0, $x211 = 0, $pagesArrayMajor = 0, $x214 = 0, $x217 = 0, $pagedir = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $ld$0$0 = 0, $50$0 = 0, $ld$1$1 = 0, $50$1 = 0, $st$2$0 = 0, $st$3$1 = 0, $51 = 0, $arrayidx222 = 0, $52 = 0, $53 = 0, $ld$4$0 = 0, $54$0 = 0, $ld$5$1 = 0, $54$1 = 0, $st$6$0 = 0, $st$7$1 = 0, $55 = 0, $56 = 0, $add228 = 0, $ispos = 0, $neg = 0, $call = 0, $cmp229 = 0, $y212 = 0, $y209 = 0, $57 = 0, $58 = 0, $add235 = 0, $ispos90 = 0, $neg91 = 0, $call236 = 0, $cmp237 = 0, $ld$8$0 = 0, $59$0 = 0, $ld$9$1 = 0, $59$1 = 0, $st$10$0 = 0, $st$11$1 = 0, $ld$12$0 = 0, $60$0 = 0, $ld$13$1 = 0, $60$1 = 0, $st$14$0 = 0, $st$15$1 = 0, $61 = 0, $call245 = 0, $drawing = 0, $62 = 0, $centered = 0, $63 = 0, $tobool247 = 0, $64 = 0.0, $x250 = 0, $65 = 0.0, $cmp251 = 0, $sub256 = 0.0, $div257 = 0.0, $x258 = 0, $66 = 0.0, $y261 = 0, $67 = 0.0, $cmp262 = 0, $sub267 = 0.0, $div268 = 0.0, $y269 = 0, $68 = 0, $tobool273 = 0, $69 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0.0, $x281 = 0, $75 = 0.0, $add282 = 0.0, $x283 = 0, $76 = 0.0, $y285 = 0, $77 = 0.0, $add286 = 0.0, $y289 = 0, $78 = 0.0, $79 = 0.0, $add292 = 0.0, $x293 = 0, $80 = 0.0, $add294 = 0.0, $x296 = 0, $81 = 0.0, $82 = 0.0, $add299 = 0.0, $y300 = 0, $83 = 0.0, $add301 = 0.0, $y304 = 0, $84 = 0.0, $zoom = 0, $85 = 0.0, $div306 = 0.0, $x308 = 0, $86 = 0.0, $87 = 0.0, $div311 = 0.0, $y313 = 0, $88 = 0.0, $89 = 0.0, $mul319 = 0.0, $div320 = 0.0, $cmp321 = 0, $add331 = 0.0, $sub341 = 0.0, $add331_sink = 0.0, $conv332 = 0, $pageBoundingBox = 0, $LL345 = 0, $x346 = 0, $90 = 0.0, $91 = 0.0, $mul352 = 0.0, $div353 = 0.0, $cmp354 = 0, $add364 = 0.0, $sub374 = 0.0, $add364_sink = 0.0, $conv365 = 0, $y380 = 0, $92 = 0.0, $93 = 0.0, $mul386 = 0.0, $div387 = 0.0, $cmp388 = 0, $add398 = 0.0, $sub408 = 0.0, $add398_sink = 0.0, $conv399 = 0, $UR413 = 0, $x414 = 0, $94 = 0.0, $95 = 0.0, $mul420 = 0.0, $div421 = 0.0, $cmp422 = 0, $add432 = 0.0, $sub442 = 0.0, $add432_sink = 0.0, $conv433 = 0, $y448 = 0, $96 = 0, $tobool450 = 0, $97 = 0, $ld$16$0 = 0, $98$0 = 0, $ld$17$1 = 0, $98$1 = 0, $st$18$0 = 0, $st$19$1 = 0, $99 = 0, $ld$20$0 = 0, $100$0 = 0, $ld$21$1 = 0, $100$1 = 0, $st$22$0 = 0, $st$23$1 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 88 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $pageSize = __stackBase__ | 0;
    $imageSize = __stackBase__ + 16 | 0;
    $margin = __stackBase__ + 32 | 0;
    $centering = __stackBase__ + 48 | 0;
    $tmp = __stackBase__ + 64 | 0;
    $tmp219 = __stackBase__ + 80 | 0;
    $tmpcast = $tmp219;
    $tmp223 = STACKTOP;
    STACKTOP = STACKTOP + 8 | 0;
    $tmpcast85 = $tmp223;
    $tmp241 = STACKTOP;
    STACKTOP = STACKTOP + 8 | 0;
    $tmpcast88 = $tmp241;
    $tmp243 = STACKTOP;
    STACKTOP = STACKTOP + 8 | 0;
    $tmpcast89 = $tmp243;
    $tmp275 = STACKTOP;
    STACKTOP = STACKTOP + 16 | 0;
    $tmp276 = STACKTOP;
    STACKTOP = STACKTOP + 16 | 0;
    $tmp277 = STACKTOP;
    STACKTOP = STACKTOP + 16 | 0;
    $tmp278 = STACKTOP;
    STACKTOP = STACKTOP + 16 | 0;
    $tmp456 = STACKTOP;
    STACKTOP = STACKTOP + 8 | 0;
    $tmpcast86 = $tmp456;
    $tmp461 = STACKTOP;
    STACKTOP = STACKTOP + 8 | 0;
    $tmpcast87 = $tmp461;
    $gvc1 = $job | 0;
    $0 = HEAP32[$gvc1 >> 2] | 0;
    $1 = $centering;
    _memset($1 | 0, 0, 16);
    $view = $job + 368 | 0;
    $2 = $imageSize;
    $3 = $view;
    HEAP32[$2 >> 2] = HEAP32[$3 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$3 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$3 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$3 + 12 >> 2] | 0;
    $rotation = $job + 360 | 0;
    $4 = HEAP32[$rotation >> 2] | 0;
    $tobool = ($4 | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _exch_xyf($tmp, $imageSize);
    $5 = $tmp;
    HEAP32[$2 >> 2] = HEAP32[$5 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$5 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$5 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$5 + 12 >> 2] | 0;
    label = 4;
    break;
   case 4:
    $margin2 = $job + 416 | 0;
    $6 = $margin;
    $7 = $margin2;
    HEAP32[$6 >> 2] = HEAP32[$7 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$7 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$7 + 12 >> 2] | 0;
    $graph_sets_pageSize = $0 + 270 | 0;
    $8 = HEAP8[$graph_sets_pageSize] | 0;
    $tobool3 = $8 << 24 >> 24 == 0;
    if ($tobool3) {
      label = 15;
      break;
    } else {
      label = 5;
      break;
    }
   case 5:
    $flags = $job + 152 | 0;
    $9 = HEAP32[$flags >> 2] | 0;
    $and = $9 & 32;
    $tobool4 = ($and | 0) == 0;
    if ($tobool4) {
      label = 15;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $x = $0 + 208 | 0;
    $10 = +HEAPF64[$x >> 3];
    $x7 = $margin | 0;
    $11 = +HEAPF64[$x7 >> 3];
    $mul = $11 * 2.0;
    $sub = $10 - $mul;
    $x8 = $pageSize | 0;
    HEAPF64[$x8 >> 3] = $sub;
    $y = $0 + 216 | 0;
    $12 = +HEAPF64[$y >> 3];
    $y10 = $margin + 8 | 0;
    $13 = +HEAPF64[$y10 >> 3];
    $mul11 = $13 * 2.0;
    $sub12 = $12 - $mul11;
    $y13 = $pageSize + 8 | 0;
    HEAPF64[$y13 >> 3] = $sub12;
    $14 = +HEAPF64[$x8 >> 3];
    $cmp = $14 < 1.0e-4;
    if ($cmp) {
      label = 7;
      break;
    } else {
      label = 8;
      break;
    }
   case 7:
    $x17 = $job + 164 | 0;
    HEAP32[$x17 >> 2] = 1;
    label = 10;
    break;
   case 8:
    $x18 = $imageSize | 0;
    $15 = +HEAPF64[$x18 >> 3];
    $div = $15 / $14;
    $conv20 = ~~$div;
    $x22 = $job + 164 | 0;
    HEAP32[$x22 >> 2] = $conv20;
    $16 = +HEAPF64[$x18 >> 3];
    $conv26 = +($conv20 | 0);
    $17 = +HEAPF64[$x8 >> 3];
    $mul28 = $conv26 * $17;
    $sub29 = $16 - $mul28;
    $cmp30 = $sub29 > 1.0e-4;
    if ($cmp30) {
      label = 9;
      break;
    } else {
      label = 10;
      break;
    }
   case 9:
    $inc = $conv20 + 1 | 0;
    HEAP32[$x22 >> 2] = $inc;
    label = 10;
    break;
   case 10:
    $18 = +HEAPF64[$y13 >> 3];
    $cmp38 = $18 < 1.0e-4;
    if ($cmp38) {
      label = 11;
      break;
    } else {
      label = 12;
      break;
    }
   case 11:
    $y42 = $job + 168 | 0;
    HEAP32[$y42 >> 2] = 1;
    label = 14;
    break;
   case 12:
    $y44 = $imageSize + 8 | 0;
    $19 = +HEAPF64[$y44 >> 3];
    $div46 = $19 / $18;
    $conv47 = ~~$div46;
    $y49 = $job + 168 | 0;
    HEAP32[$y49 >> 2] = $conv47;
    $20 = +HEAPF64[$y44 >> 3];
    $conv53 = +($conv47 | 0);
    $21 = +HEAPF64[$y13 >> 3];
    $mul55 = $conv53 * $21;
    $sub56 = $20 - $mul55;
    $cmp57 = $sub56 > 1.0e-4;
    if ($cmp57) {
      label = 13;
      break;
    } else {
      label = 14;
      break;
    }
   case 13:
    $inc62 = $conv47 + 1 | 0;
    HEAP32[$y49 >> 2] = $inc62;
    label = 14;
    break;
   case 14:
    $x66 = $job + 164 | 0;
    $22 = HEAP32[$x66 >> 2] | 0;
    $y68 = $job + 168 | 0;
    $23 = HEAP32[$y68 >> 2] | 0;
    $mul69 = Math_imul($23, $22);
    $numPages = $job + 204 | 0;
    HEAP32[$numPages >> 2] = $mul69;
    $x70 = $imageSize | 0;
    $24 = +HEAPF64[$x70 >> 3];
    $25 = +HEAPF64[$x8 >> 3];
    $cmp72 = $24 < $25;
    $_ = $cmp72 ? $24 : $25;
    HEAPF64[$x70 >> 3] = $_;
    $y77 = $imageSize + 8 | 0;
    $26 = +HEAPF64[$y77 >> 3];
    $27 = +HEAPF64[$y13 >> 3];
    $cmp79 = $26 < $27;
    $cond86 = $cmp79 ? $26 : $27;
    HEAPF64[$y77 >> 3] = $cond86;
    label = 23;
    break;
   case 15:
    $features = $job + 68 | 0;
    $28 = HEAP32[$features >> 2] | 0;
    $tobool89 = ($28 | 0) == 0;
    if ($tobool89) {
      label = 18;
      break;
    } else {
      label = 16;
      break;
    }
   case 16:
    $features91 = $job + 84 | 0;
    $29 = HEAP32[$features91 >> 2] | 0;
    $x92 = $29 + 24 | 0;
    $30 = +HEAPF64[$x92 >> 3];
    $x93 = $margin | 0;
    $31 = +HEAPF64[$x93 >> 3];
    $mul94 = $31 * 2.0;
    $sub95 = $30 - $mul94;
    $x96 = $pageSize | 0;
    $cmp98 = $sub95 < 0.0;
    $storemerge = $cmp98 ? 0.0 : $sub95;
    HEAPF64[$x96 >> 3] = $storemerge;
    $32 = HEAP32[$features91 >> 2] | 0;
    $y106 = $32 + 32 | 0;
    $33 = +HEAPF64[$y106 >> 3];
    $y107 = $margin + 8 | 0;
    $34 = +HEAPF64[$y107 >> 3];
    $mul108 = $34 * 2.0;
    $sub109 = $33 - $mul108;
    $y110 = $pageSize + 8 | 0;
    HEAPF64[$y110 >> 3] = $sub109;
    $cmp112 = $sub109 < 0.0;
    if ($cmp112) {
      label = 17;
      break;
    } else {
      label = 19;
      break;
    }
   case 17:
    HEAPF64[$y110 >> 3] = 0.0;
    label = 19;
    break;
   case 18:
    $35 = $pageSize;
    _memset($35 | 0, 0, 16);
    label = 19;
    break;
   case 19:
    $numPages121 = $job + 204 | 0;
    HEAP32[$numPages121 >> 2] = 1;
    $y123 = $job + 168 | 0;
    HEAP32[$y123 >> 2] = 1;
    $x125 = $job + 164 | 0;
    HEAP32[$x125 >> 2] = 1;
    $x126 = $pageSize | 0;
    $36 = +HEAPF64[$x126 >> 3];
    $x127 = $imageSize | 0;
    $37 = +HEAPF64[$x127 >> 3];
    $cmp128 = $36 < $37;
    if ($cmp128) {
      label = 20;
      break;
    } else {
      label = 21;
      break;
    }
   case 20:
    HEAPF64[$x126 >> 3] = $37;
    label = 21;
    break;
   case 21:
    $y134 = $pageSize + 8 | 0;
    $38 = +HEAPF64[$y134 >> 3];
    $y135 = $imageSize + 8 | 0;
    $39 = +HEAPF64[$y135 >> 3];
    $cmp136 = $38 < $39;
    if ($cmp136) {
      label = 22;
      break;
    } else {
      label = 23;
      break;
    }
   case 22:
    HEAPF64[$y134 >> 3] = $39;
    label = 23;
    break;
   case 23:
    $x143 = $pageSize | 0;
    $40 = +HEAPF64[$x143 >> 3];
    $x144 = $margin | 0;
    $41 = +HEAPF64[$x144 >> 3];
    $mul145 = $41 * 2.0;
    $add = $40 + $mul145;
    $x146 = $job + 432 | 0;
    $42 = +HEAPF64[$x146 >> 3];
    $mul147 = $42 * $add;
    $div148 = $mul147 / 72.0;
    $cmp149 = $div148 < 0.0;
    if ($cmp149) {
      label = 25;
      break;
    } else {
      label = 24;
      break;
    }
   case 24:
    $add160 = $div148 + .5;
    $add160_sink = $add160;
    label = 26;
    break;
   case 25:
    $sub171 = $div148 + -.5;
    $add160_sink = $sub171;
    label = 26;
    break;
   case 26:
    $conv161 = ~~$add160_sink;
    $width = $job + 448 | 0;
    HEAP32[$width >> 2] = $conv161;
    $y175 = $pageSize + 8 | 0;
    $43 = +HEAPF64[$y175 >> 3];
    $y176 = $margin + 8 | 0;
    $44 = +HEAPF64[$y176 >> 3];
    $mul177 = $44 * 2.0;
    $add178 = $43 + $mul177;
    $y180 = $job + 440 | 0;
    $45 = +HEAPF64[$y180 >> 3];
    $mul181 = $45 * $add178;
    $div182 = $mul181 / 72.0;
    $cmp183 = $div182 < 0.0;
    if ($cmp183) {
      label = 28;
      break;
    } else {
      label = 27;
      break;
    }
   case 27:
    $add194 = $div182 + .5;
    $add194_sink = $add194;
    label = 29;
    break;
   case 28:
    $sub205 = $div182 + -.5;
    $add194_sink = $sub205;
    label = 29;
    break;
   case 29:
    $conv195 = ~~$add194_sink;
    $height = $job + 452 | 0;
    HEAP32[$height >> 2] = $conv195;
    $pagesArrayMinor = $job + 188 | 0;
    $x211 = $pagesArrayMinor | 0;
    $pagesArrayMajor = $job + 180 | 0;
    $x214 = $pagesArrayMajor | 0;
    $x217 = $job + 172 | 0;
    $pagedir = $0 + 168 | 0;
    $46 = $x217;
    _memset($46 | 0, 0, 24);
    $47 = HEAP32[$pagedir >> 2] | 0;
    $48 = HEAP8[$47] | 0;
    _pagecode($tmpcast, $job, $48);
    $49 = $pagesArrayMajor;
    $ld$0$0 = $tmp219 | 0;
    $50$0 = HEAP32[$ld$0$0 >> 2] | 0;
    $ld$1$1 = $tmp219 + 4 | 0;
    $50$1 = HEAP32[$ld$1$1 >> 2] | 0;
    $st$2$0 = $49 | 0;
    HEAP32[$st$2$0 >> 2] = $50$0;
    $st$3$1 = $49 + 4 | 0;
    HEAP32[$st$3$1 >> 2] = $50$1;
    $51 = HEAP32[$pagedir >> 2] | 0;
    $arrayidx222 = $51 + 1 | 0;
    $52 = HEAP8[$arrayidx222] | 0;
    _pagecode($tmpcast85, $job, $52);
    $53 = $pagesArrayMinor;
    $ld$4$0 = $tmp223 | 0;
    $54$0 = HEAP32[$ld$4$0 >> 2] | 0;
    $ld$5$1 = $tmp223 + 4 | 0;
    $54$1 = HEAP32[$ld$5$1 >> 2] | 0;
    $st$6$0 = $53 | 0;
    HEAP32[$st$6$0 >> 2] = $54$0;
    $st$7$1 = $53 + 4 | 0;
    HEAP32[$st$7$1 >> 2] = $54$1;
    $55 = HEAP32[$x214 >> 2] | 0;
    $56 = HEAP32[$x211 >> 2] | 0;
    $add228 = $56 + $55 | 0;
    $ispos = ($add228 | 0) > -1;
    $neg = -$add228 | 0;
    $call = $ispos ? $add228 : $neg;
    $cmp229 = ($call | 0) == 1;
    if ($cmp229) {
      label = 30;
      break;
    } else {
      label = 31;
      break;
    }
   case 30:
    $y212 = $job + 184 | 0;
    $y209 = $job + 192 | 0;
    $57 = HEAP32[$y212 >> 2] | 0;
    $58 = HEAP32[$y209 >> 2] | 0;
    $add235 = $58 + $57 | 0;
    $ispos90 = ($add235 | 0) > -1;
    $neg91 = -$add235 | 0;
    $call236 = $ispos90 ? $add235 : $neg91;
    $cmp237 = ($call236 | 0) == 1;
    if ($cmp237) {
      label = 32;
      break;
    } else {
      label = 31;
      break;
    }
   case 31:
    _pagecode($tmpcast88, $job, 66);
    $ld$8$0 = $tmp241 | 0;
    $59$0 = HEAP32[$ld$8$0 >> 2] | 0;
    $ld$9$1 = $tmp241 + 4 | 0;
    $59$1 = HEAP32[$ld$9$1 >> 2] | 0;
    $st$10$0 = $49 | 0;
    HEAP32[$st$10$0 >> 2] = $59$0;
    $st$11$1 = $49 + 4 | 0;
    HEAP32[$st$11$1 >> 2] = $59$1;
    _pagecode($tmpcast89, $job, 76);
    $ld$12$0 = $tmp243 | 0;
    $60$0 = HEAP32[$ld$12$0 >> 2] | 0;
    $ld$13$1 = $tmp243 + 4 | 0;
    $60$1 = HEAP32[$ld$13$1 >> 2] | 0;
    $st$14$0 = $53 | 0;
    HEAP32[$st$14$0 >> 2] = $60$0;
    $st$15$1 = $53 + 4 | 0;
    HEAP32[$st$15$1 >> 2] = $60$1;
    $61 = HEAP32[$pagedir >> 2] | 0;
    $call245 = _agerr(0, 112488, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $61, tempInt) | 0) | 0;
    label = 32;
    break;
   case 32:
    $drawing = $g + 48 | 0;
    $62 = HEAP32[$drawing >> 2] | 0;
    $centered = $62 + 82 | 0;
    $63 = HEAP8[$centered] | 0;
    $tobool247 = $63 << 24 >> 24 == 0;
    if ($tobool247) {
      label = 37;
      break;
    } else {
      label = 33;
      break;
    }
   case 33:
    $64 = +HEAPF64[$x143 >> 3];
    $x250 = $imageSize | 0;
    $65 = +HEAPF64[$x250 >> 3];
    $cmp251 = $64 > $65;
    if ($cmp251) {
      label = 34;
      break;
    } else {
      label = 35;
      break;
    }
   case 34:
    $sub256 = $64 - $65;
    $div257 = $sub256 * .5;
    $x258 = $centering | 0;
    HEAPF64[$x258 >> 3] = $div257;
    label = 35;
    break;
   case 35:
    $66 = +HEAPF64[$y175 >> 3];
    $y261 = $imageSize + 8 | 0;
    $67 = +HEAPF64[$y261 >> 3];
    $cmp262 = $66 > $67;
    if ($cmp262) {
      label = 36;
      break;
    } else {
      label = 37;
      break;
    }
   case 36:
    $sub267 = $66 - $67;
    $div268 = $sub267 * .5;
    $y269 = $centering + 8 | 0;
    HEAPF64[$y269 >> 3] = $div268;
    label = 37;
    break;
   case 37:
    $68 = HEAP32[$rotation >> 2] | 0;
    $tobool273 = ($68 | 0) == 0;
    if ($tobool273) {
      label = 39;
      break;
    } else {
      label = 38;
      break;
    }
   case 38:
    _exch_xyf($tmp275, $imageSize);
    $69 = $tmp275;
    HEAP32[$2 >> 2] = HEAP32[$69 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$69 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$69 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$69 + 12 >> 2] | 0;
    _exch_xyf($tmp276, $pageSize);
    $70 = $pageSize;
    $71 = $tmp276;
    HEAP32[$70 >> 2] = HEAP32[$71 >> 2] | 0;
    HEAP32[$70 + 4 >> 2] = HEAP32[$71 + 4 >> 2] | 0;
    HEAP32[$70 + 8 >> 2] = HEAP32[$71 + 8 >> 2] | 0;
    HEAP32[$70 + 12 >> 2] = HEAP32[$71 + 12 >> 2] | 0;
    _exch_xyf($tmp277, $margin);
    $72 = $tmp277;
    HEAP32[$6 >> 2] = HEAP32[$72 >> 2] | 0;
    HEAP32[$6 + 4 >> 2] = HEAP32[$72 + 4 >> 2] | 0;
    HEAP32[$6 + 8 >> 2] = HEAP32[$72 + 8 >> 2] | 0;
    HEAP32[$6 + 12 >> 2] = HEAP32[$72 + 12 >> 2] | 0;
    _exch_xyf($tmp278, $centering);
    $73 = $tmp278;
    HEAP32[$1 >> 2] = HEAP32[$73 >> 2] | 0;
    HEAP32[$1 + 4 >> 2] = HEAP32[$73 + 4 >> 2] | 0;
    HEAP32[$1 + 8 >> 2] = HEAP32[$73 + 8 >> 2] | 0;
    HEAP32[$1 + 12 >> 2] = HEAP32[$73 + 12 >> 2] | 0;
    label = 39;
    break;
   case 39:
    $74 = +HEAPF64[$x144 >> 3];
    $x281 = $centering | 0;
    $75 = +HEAPF64[$x281 >> 3];
    $add282 = $74 + $75;
    $x283 = $job + 384 | 0;
    HEAPF64[$x283 >> 3] = $add282;
    $76 = +HEAPF64[$y176 >> 3];
    $y285 = $centering + 8 | 0;
    $77 = +HEAPF64[$y285 >> 3];
    $add286 = $76 + $77;
    $y289 = $job + 392 | 0;
    HEAPF64[$y289 >> 3] = $add286;
    $78 = +HEAPF64[$x144 >> 3];
    $79 = +HEAPF64[$x281 >> 3];
    $add292 = $78 + $79;
    $x293 = $imageSize | 0;
    $80 = +HEAPF64[$x293 >> 3];
    $add294 = $add292 + $80;
    $x296 = $job + 400 | 0;
    HEAPF64[$x296 >> 3] = $add294;
    $81 = +HEAPF64[$y176 >> 3];
    $82 = +HEAPF64[$y285 >> 3];
    $add299 = $81 + $82;
    $y300 = $imageSize + 8 | 0;
    $83 = +HEAPF64[$y300 >> 3];
    $add301 = $add299 + $83;
    $y304 = $job + 408 | 0;
    HEAPF64[$y304 >> 3] = $add301;
    $84 = +HEAPF64[$x293 >> 3];
    $zoom = $job + 352 | 0;
    $85 = +HEAPF64[$zoom >> 3];
    $div306 = $84 / $85;
    $x308 = $job + 320 | 0;
    HEAPF64[$x308 >> 3] = $div306;
    $86 = +HEAPF64[$y300 >> 3];
    $87 = +HEAPF64[$zoom >> 3];
    $div311 = $86 / $87;
    $y313 = $job + 328 | 0;
    HEAPF64[$y313 >> 3] = $div311;
    $88 = +HEAPF64[$x283 >> 3];
    $89 = +HEAPF64[$x146 >> 3];
    $mul319 = $88 * $89;
    $div320 = $mul319 / 72.0;
    $cmp321 = $div320 < 0.0;
    if ($cmp321) {
      label = 41;
      break;
    } else {
      label = 40;
      break;
    }
   case 40:
    $add331 = $div320 + .5;
    $add331_sink = $add331;
    label = 42;
    break;
   case 41:
    $sub341 = $div320 + -.5;
    $add331_sink = $sub341;
    label = 42;
    break;
   case 42:
    $conv332 = ~~$add331_sink;
    $pageBoundingBox = $job + 456 | 0;
    $LL345 = $pageBoundingBox | 0;
    $x346 = $pageBoundingBox | 0;
    HEAP32[$x346 >> 2] = $conv332;
    $90 = +HEAPF64[$y289 >> 3];
    $91 = +HEAPF64[$y180 >> 3];
    $mul352 = $90 * $91;
    $div353 = $mul352 / 72.0;
    $cmp354 = $div353 < 0.0;
    if ($cmp354) {
      label = 44;
      break;
    } else {
      label = 43;
      break;
    }
   case 43:
    $add364 = $div353 + .5;
    $add364_sink = $add364;
    label = 45;
    break;
   case 44:
    $sub374 = $div353 + -.5;
    $add364_sink = $sub374;
    label = 45;
    break;
   case 45:
    $conv365 = ~~$add364_sink;
    $y380 = $job + 460 | 0;
    HEAP32[$y380 >> 2] = $conv365;
    $92 = +HEAPF64[$x296 >> 3];
    $93 = +HEAPF64[$x146 >> 3];
    $mul386 = $92 * $93;
    $div387 = $mul386 / 72.0;
    $cmp388 = $div387 < 0.0;
    if ($cmp388) {
      label = 47;
      break;
    } else {
      label = 46;
      break;
    }
   case 46:
    $add398 = $div387 + .5;
    $add398_sink = $add398;
    label = 48;
    break;
   case 47:
    $sub408 = $div387 + -.5;
    $add398_sink = $sub408;
    label = 48;
    break;
   case 48:
    $conv399 = ~~$add398_sink;
    $UR413 = $job + 464 | 0;
    $x414 = $UR413 | 0;
    HEAP32[$x414 >> 2] = $conv399;
    $94 = +HEAPF64[$y304 >> 3];
    $95 = +HEAPF64[$y180 >> 3];
    $mul420 = $94 * $95;
    $div421 = $mul420 / 72.0;
    $cmp422 = $div421 < 0.0;
    if ($cmp422) {
      label = 50;
      break;
    } else {
      label = 49;
      break;
    }
   case 49:
    $add432 = $div421 + .5;
    $add432_sink = $add432;
    label = 51;
    break;
   case 50:
    $sub442 = $div421 + -.5;
    $add432_sink = $sub442;
    label = 51;
    break;
   case 51:
    $conv433 = ~~$add432_sink;
    $y448 = $job + 468 | 0;
    HEAP32[$y448 >> 2] = $conv433;
    $96 = HEAP32[$rotation >> 2] | 0;
    $tobool450 = ($96 | 0) == 0;
    if ($tobool450) {
      label = 53;
      break;
    } else {
      label = 52;
      break;
    }
   case 52:
    _exch_xy($tmpcast86, $LL345);
    $97 = $pageBoundingBox;
    $ld$16$0 = $tmp456 | 0;
    $98$0 = HEAP32[$ld$16$0 >> 2] | 0;
    $ld$17$1 = $tmp456 + 4 | 0;
    $98$1 = HEAP32[$ld$17$1 >> 2] | 0;
    $st$18$0 = $97 | 0;
    HEAP32[$st$18$0 >> 2] = $98$0;
    $st$19$1 = $97 + 4 | 0;
    HEAP32[$st$19$1 >> 2] = $98$1;
    _exch_xy($tmpcast87, $UR413);
    $99 = $UR413;
    $ld$20$0 = $tmp461 | 0;
    $100$0 = HEAP32[$ld$20$0 >> 2] | 0;
    $ld$21$1 = $tmp461 + 4 | 0;
    $100$1 = HEAP32[$ld$21$1 >> 2] | 0;
    $st$22$0 = $99 | 0;
    HEAP32[$st$22$0 >> 2] = $100$0;
    $st$23$1 = $99 + 4 | 0;
    HEAP32[$st$23$1 >> 2] = $100$1;
    label = 53;
    break;
   case 53:
    STACKTOP = __stackBase__;
    return;
  }
}
function _parse_layers($gvc, $g, $p) {
  $gvc = $gvc | 0;
  $g = $g | 0;
  $p = $p | 0;
  var $0 = 0, $call = 0, $layerDelims = 0, $tobool = 0, $_call = 0, $call3 = 0, $layers = 0, $1 = 0, $call6 = 0, $tobool724 = 0, $layerIDs = 0, $layerIDs16 = 0, $sz_027 = 0, $tok_026 = 0, $ntok_025 = 0, $inc = 0, $cmp = 0, $add = 0, $2 = 0, $tobool9 = 0, $3 = 0, $mul = 0, $call11 = 0, $mul12 = 0, $call13 = 0, $call11_sink = 0, $4 = 0, $sz_1 = 0, $5 = 0, $arrayidx = 0, $6 = 0, $call18 = 0, $tobool7 = 0, $tobool19 = 0, $layerIDs21 = 0, $7 = 0, $8 = 0, $add22 = 0, $mul23 = 0, $call24 = 0, $9 = 0, $add28 = 0, $10 = 0, $arrayidx30 = 0, $ntok_0_lcssa29 = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $0 = $g | 0;
    $call = _agget($0, 108728) | 0;
    $layerDelims = $gvc + 272 | 0;
    $tobool = ($call | 0) == 0;
    $_call = $tobool ? 108104 : $call;
    HEAP32[$layerDelims >> 2] = $_call;
    $call3 = _strdup($p | 0) | 0;
    $layers = $gvc + 276 | 0;
    HEAP32[$layers >> 2] = $call3;
    $1 = HEAP32[$layerDelims >> 2] | 0;
    $call6 = _strtok($call3 | 0, $1 | 0) | 0;
    $tobool724 = ($call6 | 0) == 0;
    if ($tobool724) {
      $ntok_0_lcssa29 = 0;
      label = 12;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    $layerIDs = $gvc + 280 | 0;
    $layerIDs16 = $gvc + 280 | 0;
    $ntok_025 = 0;
    $tok_026 = $call6;
    $sz_027 = 0;
    label = 4;
    break;
   case 4:
    $inc = $ntok_025 + 1 | 0;
    $cmp = ($inc | 0) > ($sz_027 | 0);
    if ($cmp) {
      label = 5;
      break;
    } else {
      $sz_1 = $sz_027;
      label = 9;
      break;
    }
   case 5:
    $add = $sz_027 + 128 | 0;
    $2 = HEAP32[$layerIDs >> 2] | 0;
    $tobool9 = ($2 | 0) == 0;
    if ($tobool9) {
      label = 7;
      break;
    } else {
      label = 6;
      break;
    }
   case 6:
    $3 = $2;
    $mul = $add << 2;
    $call11 = _grealloc($3, $mul) | 0;
    $call11_sink = $call11;
    label = 8;
    break;
   case 7:
    $mul12 = $add << 2;
    $call13 = _gmalloc($mul12) | 0;
    $call11_sink = $call13;
    label = 8;
    break;
   case 8:
    $4 = $call11_sink;
    HEAP32[$layerIDs >> 2] = $4;
    $sz_1 = $add;
    label = 9;
    break;
   case 9:
    $5 = HEAP32[$layerIDs16 >> 2] | 0;
    $arrayidx = $5 + ($inc << 2) | 0;
    HEAP32[$arrayidx >> 2] = $tok_026;
    $6 = HEAP32[$layerDelims >> 2] | 0;
    $call18 = _strtok(0, $6 | 0) | 0;
    $tobool7 = ($call18 | 0) == 0;
    if ($tobool7) {
      label = 10;
      break;
    } else {
      $ntok_025 = $inc;
      $tok_026 = $call18;
      $sz_027 = $sz_1;
      label = 4;
      break;
    }
   case 10:
    $tobool19 = ($inc | 0) == 0;
    if ($tobool19) {
      $ntok_0_lcssa29 = 0;
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $layerIDs21 = $gvc + 280 | 0;
    $7 = HEAP32[$layerIDs21 >> 2] | 0;
    $8 = $7;
    $add22 = $inc << 2;
    $mul23 = $add22 + 8 | 0;
    $call24 = _grealloc($8, $mul23) | 0;
    $9 = $call24;
    HEAP32[$layerIDs21 >> 2] = $9;
    HEAP32[$9 >> 2] = 0;
    $add28 = $ntok_025 + 2 | 0;
    $10 = HEAP32[$layerIDs21 >> 2] | 0;
    $arrayidx30 = $10 + ($add28 << 2) | 0;
    HEAP32[$arrayidx30 >> 2] = 0;
    $ntok_0_lcssa29 = $inc;
    label = 12;
    break;
   case 12:
    return $ntok_0_lcssa29 | 0;
  }
  return 0;
}
function _init_bb_node($g, $n) {
  $g = $g | 0;
  $n = $n | 0;
  var $x = 0, $0 = 0.0, $lw = 0, $1 = 0.0, $sub = 0.0, $x3 = 0, $y = 0, $2 = 0.0, $ht = 0, $3 = 0.0, $div = 0.0, $sub7 = 0.0, $y11 = 0, $4 = 0.0, $rw = 0, $5 = 0.0, $add = 0.0, $x18 = 0, $6 = 0.0, $7 = 0.0, $div24 = 0.0, $add25 = 0.0, $y29 = 0, $8 = 0, $9 = 0, $call = 0, $tobool16 = 0, $e_0_in17 = 0, $e_0 = 0, $call30 = 0, $tobool = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $x = $n + 32 | 0;
    $0 = +HEAPF64[$x >> 3];
    $lw = $n + 104 | 0;
    $1 = +HEAPF64[$lw >> 3];
    $sub = $0 - $1;
    $x3 = $n + 64 | 0;
    HEAPF64[$x3 >> 3] = $sub;
    $y = $n + 40 | 0;
    $2 = +HEAPF64[$y >> 3];
    $ht = $n + 96 | 0;
    $3 = +HEAPF64[$ht >> 3];
    $div = $3 * .5;
    $sub7 = $2 - $div;
    $y11 = $n + 72 | 0;
    HEAPF64[$y11 >> 3] = $sub7;
    $4 = +HEAPF64[$x >> 3];
    $rw = $n + 112 | 0;
    $5 = +HEAPF64[$rw >> 3];
    $add = $4 + $5;
    $x18 = $n + 80 | 0;
    HEAPF64[$x18 >> 3] = $add;
    $6 = +HEAPF64[$y >> 3];
    $7 = +HEAPF64[$ht >> 3];
    $div24 = $7 * .5;
    $add25 = $6 + $div24;
    $y29 = $n + 88 | 0;
    HEAPF64[$y29 >> 3] = $add25;
    $8 = $g;
    $9 = $n;
    $call = _agfstout($8, $9) | 0;
    $tobool16 = ($call | 0) == 0;
    if ($tobool16) {
      label = 4;
      break;
    } else {
      $e_0_in17 = $call;
      label = 3;
      break;
    }
   case 3:
    $e_0 = $e_0_in17;
    _init_bb_edge($e_0);
    $call30 = _agnxtout($8, $e_0_in17) | 0;
    $tobool = ($call30 | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      $e_0_in17 = $call30;
      label = 3;
      break;
    }
   case 4:
    return;
  }
}
function _init_bb_edge($e) {
  $e = $e | 0;
  var $spl1 = 0, $0 = 0, $tobool = 0, label = 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $spl1 = $e + 24 | 0;
    $0 = HEAP32[$spl1 >> 2] | 0;
    $tobool = ($0 | 0) == 0;
    if ($tobool) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    _init_splines_bb($0);
    label = 4;
    break;
   case 4:
    return;
  }
}
function _init_splines_bb($spl) {
  $spl = $spl | 0;
  var $bz = 0, $tmp = 0, $tmp6 = 0, $tmp66 = 0, $tmp134 = 0, $size = 0, $0 = 0, $cmp = 0, $list = 0, $1 = 0, $2 = 0, $3 = 0, $bb_sroa_0_0__idx40 = 0, $bb_sroa_0_0_copyload41 = 0.0, $bb_sroa_1_8__idx48 = 0, $bb_sroa_1_8_copyload49 = 0.0, $bb_sroa_2_16__idx56 = 0, $bb_sroa_2_16_copyload57 = 0.0, $bb_sroa_3_24__idx64 = 0, $bb_sroa_3_24_copyload65 = 0.0, $4 = 0, $cmp278 = 0, $b_sroa_0_0__idx3 = 0, $b_sroa_1_8__idx13 = 0, $b_sroa_2_16__idx23 = 0, $b_sroa_3_24__idx33 = 0, $sflag = 0, $eflag = 0, $ep = 0, $size130 = 0, $list131 = 0, $b_sroa_0_0__idx = 0, $b_sroa_1_8__idx10 = 0, $b_sroa_2_16__idx20 = 0, $b_sroa_3_24__idx30 = 0, $sp = 0, $list63 = 0, $b_sroa_0_0__idx1 = 0, $b_sroa_1_8__idx11 = 0, $b_sroa_2_16__idx21 = 0, $b_sroa_3_24__idx31 = 0, $bb_sroa_0_083 = 0.0, $bb_sroa_1_082 = 0.0, $bb_sroa_2_081 = 0.0, $bb_sroa_3_080 = 0.0, $i_079 = 0, $cmp3 = 0, $5 = 0, $arrayidx5 = 0, $6 = 0, $b_sroa_0_0_copyload4 = 0.0, $b_sroa_1_8_copyload14 = 0.0, $b_sroa_2_16_copyload24 = 0.0, $b_sroa_3_24_copyload34 = 0.0, $cmp9 = 0, $bb_sroa_0_0_b_sroa_0_0_copyload4 = 0.0, $cmp22 = 0, $cond30 = 0.0, $cmp36 = 0, $bb_sroa_2_0_b_sroa_2_16_copyload24 = 0.0, $cmp51 = 0, $cond59 = 0.0, $bb_sroa_3_1 = 0.0, $bb_sroa_2_1 = 0.0, $bb_sroa_1_1 = 0.0, $bb_sroa_0_1 = 0.0, $7 = 0, $tobool = 0, $8 = 0, $b_sroa_0_0_copyload2 = 0.0, $b_sroa_1_8_copyload12 = 0.0, $b_sroa_2_16_copyload22 = 0.0, $b_sroa_3_24_copyload32 = 0.0, $cmp71 = 0, $bb_sroa_0_1_b_sroa_0_0_copyload2 = 0.0, $cmp86 = 0, $cond94 = 0.0, $cmp101 = 0, $bb_sroa_2_1_b_sroa_2_16_copyload22 = 0.0, $cmp116 = 0, $cond124 = 0.0, $bb_sroa_3_2 = 0.0, $bb_sroa_2_2 = 0.0, $bb_sroa_1_2 = 0.0, $bb_sroa_0_2 = 0.0, $9 = 0, $tobool128 = 0, $10 = 0, $sub = 0, $11 = 0, $arrayidx132 = 0, $b_sroa_0_0_copyload = 0.0, $b_sroa_1_8_copyload = 0.0, $b_sroa_2_16_copyload = 0.0, $b_sroa_3_24_copyload = 0.0, $cmp139 = 0, $bb_sroa_0_2_b_sroa_0_0_copyload = 0.0, $cmp154 = 0, $cond162 = 0.0, $cmp169 = 0, $bb_sroa_2_2_b_sroa_2_16_copyload = 0.0, $cmp184 = 0, $cond192 = 0.0, $bb_sroa_3_3 = 0.0, $bb_sroa_2_3 = 0.0, $bb_sroa_1_3 = 0.0, $bb_sroa_0_3 = 0.0, $inc = 0, $12 = 0, $cmp2 = 0, $bb_sroa_0_0_lcssa = 0.0, $bb_sroa_1_0_lcssa = 0.0, $bb_sroa_2_0_lcssa = 0.0, $bb_sroa_3_0_lcssa = 0.0, $bb_sroa_0_0__idx = 0, $bb_sroa_1_8__idx47 = 0, $bb_sroa_2_16__idx55 = 0, $bb_sroa_3_24__idx63 = 0, label = 0, __stackBase__ = 0;
  __stackBase__ = STACKTOP;
  STACKTOP = STACKTOP + 176 | 0;
  label = 2;
  while (1) switch (label | 0) {
   case 2:
    $bz = __stackBase__ | 0;
    $tmp = __stackBase__ + 48 | 0;
    $tmp6 = __stackBase__ + 80 | 0;
    $tmp66 = __stackBase__ + 112 | 0;
    $tmp134 = __stackBase__ + 144 | 0;
    $size = $spl + 4 | 0;
    $0 = HEAP32[$size >> 2] | 0;
    $cmp = ($0 | 0) > 0;
    if ($cmp) {
      label = 4;
      break;
    } else {
      label = 3;
      break;
    }
   case 3:
    ___assert_func(162152, 3408, 164200, 103680);
   case 4:
    $list = $spl | 0;
    $1 = HEAP32[$list >> 2] | 0;
    $2 = $bz;
    $3 = $1;
    HEAP32[$2 >> 2] = HEAP32[$3 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$3 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$3 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$3 + 12 >> 2] | 0;
    HEAP32[$2 + 16 >> 2] = HEAP32[$3 + 16 >> 2] | 0;
    HEAP32[$2 + 20 >> 2] = HEAP32[$3 + 20 >> 2] | 0;
    HEAP32[$2 + 24 >> 2] = HEAP32[$3 + 24 >> 2] | 0;
    HEAP32[$2 + 28 >> 2] = HEAP32[$3 + 28 >> 2] | 0;
    HEAP32[$2 + 32 >> 2] = HEAP32[$3 + 32 >> 2] | 0;
    HEAP32[$2 + 36 >> 2] = HEAP32[$3 + 36 >> 2] | 0;
    HEAP32[$2 + 40 >> 2] = HEAP32[$3 + 40 >> 2] | 0;
    HEAP32[$2 + 44 >> 2] = HEAP32[$3 + 44 >> 2] | 0;
    _bezier_bb($tmp, $bz);
    $bb_sroa_0_0__idx40 = $tmp | 0;
    $bb_sroa_0_0_copyload41 = +HEAPF64[$bb_sroa_0_0__idx40 >> 3];
    $bb_sroa_1_8__idx48 = $tmp + 8 | 0;
    $bb_sroa_1_8_copyload49 = +HEAPF64[$bb_sroa_1_8__idx48 >> 3];
    $bb_sroa_2_16__idx56 = $tmp + 16 | 0;
    $bb_sroa_2_16_copyload57 = +HEAPF64[$bb_sroa_2_16__idx56 >> 3];
    $bb_sroa_3_24__idx64 = $tmp + 24 | 0;
    $bb_sroa_3_24_copyload65 = +HEAPF64[$bb_sroa_3_24__idx64 >> 3];
    $4 = HEAP32[$size >> 2] | 0;
    $cmp278 = ($4 | 0) > 0;
    if ($cmp278) {
      label = 5;
      break;
    } else {
      $bb_sroa_3_0_lcssa = $bb_sroa_3_24_copyload65;
      $bb_sroa_2_0_lcssa = $bb_sroa_2_16_copyload57;
      $bb_sroa_1_0_lcssa = $bb_sroa_1_8_copyload49;
      $bb_sroa_0_0_lcssa = $bb_sroa_0_0_copyload41;
      label = 13;
      break;
    }
   case 5:
    $b_sroa_0_0__idx3 = $tmp6 | 0;
    $b_sroa_1_8__idx13 = $tmp6 + 8 | 0;
    $b_sroa_2_16__idx23 = $tmp6 + 16 | 0;
    $b_sroa_3_24__idx33 = $tmp6 + 24 | 0;
    $sflag = $bz + 8 | 0;
    $eflag = $bz + 12 | 0;
    $ep = $bz + 32 | 0;
    $size130 = $bz + 4 | 0;
    $list131 = $bz | 0;
    $b_sroa_0_0__idx = $tmp134 | 0;
    $b_sroa_1_8__idx10 = $tmp134 + 8 | 0;
    $b_sroa_2_16__idx20 = $tmp134 + 16 | 0;
    $b_sroa_3_24__idx30 = $tmp134 + 24 | 0;
    $sp = $bz + 16 | 0;
    $list63 = $bz | 0;
    $b_sroa_0_0__idx1 = $tmp66 | 0;
    $b_sroa_1_8__idx11 = $tmp66 + 8 | 0;
    $b_sroa_2_16__idx21 = $tmp66 + 16 | 0;
    $b_sroa_3_24__idx31 = $tmp66 + 24 | 0;
    $i_079 = 0;
    $bb_sroa_3_080 = $bb_sroa_3_24_copyload65;
    $bb_sroa_2_081 = $bb_sroa_2_16_copyload57;
    $bb_sroa_1_082 = $bb_sroa_1_8_copyload49;
    $bb_sroa_0_083 = $bb_sroa_0_0_copyload41;
    label = 6;
    break;
   case 6:
    $cmp3 = ($i_079 | 0) > 0;
    if ($cmp3) {
      label = 7;
      break;
    } else {
      $bb_sroa_0_1 = $bb_sroa_0_083;
      $bb_sroa_1_1 = $bb_sroa_1_082;
      $bb_sroa_2_1 = $bb_sroa_2_081;
      $bb_sroa_3_1 = $bb_sroa_3_080;
      label = 8;
      break;
    }
   case 7:
    $5 = HEAP32[$list >> 2] | 0;
    $arrayidx5 = $5 + ($i_079 * 48 & -1) | 0;
    $6 = $arrayidx5;
    HEAP32[$2 >> 2] = HEAP32[$6 >> 2] | 0;
    HEAP32[$2 + 4 >> 2] = HEAP32[$6 + 4 >> 2] | 0;
    HEAP32[$2 + 8 >> 2] = HEAP32[$6 + 8 >> 2] | 0;
    HEAP32[$2 + 12 >> 2] = HEAP32[$6 + 12 >> 2] | 0;
    HEAP32[$2 + 16 >> 2] = HEAP32[$6 + 16 >> 2] | 0;
    HEAP32[$2 + 20 >> 2] = HEAP32[$6 + 20 >> 2] | 0;
    HEAP32[$2 + 24 >> 2] = HEAP32[$6 + 24 >> 2] | 0;
    HEAP32[$2 + 28 >> 2] = HEAP32[$6 + 28 >> 2] | 0;
    HEAP32[$2 + 32 >> 2] = HEAP32[$6 + 32 >> 2] | 0;
    HEAP32[$2 + 36 >> 2] = HEAP32[$6 + 36 >> 2] | 0;
    HEAP32[$2 + 40 >> 2] = HEAP32[$6 + 40 >> 2] | 0;
    HEAP32[$2 + 44 >> 2] = HEAP32[$6 + 44 >> 2] | 0;
    _bezier_bb($tmp6, $bz);
    $b_sroa_0_0_copyload4 = +HEAPF64[$b_sroa_0_0__idx3 >> 3];
    $b_sroa_1_8_copyload14 = +HEAPF64[$b_sroa_1_8__idx13 >> 3];
    $b_sroa_2_16_copyload24 = +HEAPF64[$b_sroa_2_16__idx23 >> 3];
    $b_sroa_3_24_copyload34 = +HEAPF64[$b_sroa_3_24__idx33 >> 3];
    $cmp9 = $bb_sroa_0_083 < $b_sroa_0_0_copyload4;
    $bb_sroa_0_0_b_sroa_0_0_copyload4 = $cmp9 ? $bb_sroa_0_083 : $b_sroa_0_0_copyload4;
    $cmp22 = $bb_sroa_1_082 < $b_sroa_1_8_copyload14;
    $cond30 = $cmp22 ? $bb_sroa_1_082 : $b_sroa_1_8_copyload14;
    $cmp36 = $bb_sroa_2_081 > $b_sroa_2_16_copyload24;
    $bb_sroa_2_0_b_sroa_2_16_copyload24 = $cmp36 ? $bb_sroa_2_081 : $b_sroa_2_16_copyload24;
    $cmp51 = $bb_sroa_3_080 > $b_sroa_3_24_copyload34;
    $cond59 = $cmp51 ? $bb_sroa_3_080 : $b_sroa_3_24_copyload34;
    $bb_sroa_0_1 = $bb_sroa_0_0_b_sroa_0_0_copyload4;
    $bb_sroa_1_1 = $cond30;
    $bb_sroa_2_1 = $bb_sroa_2_0_b_sroa_2_16_copyload24;
    $bb_sroa_3_1 = $cond59;
    label = 8;
    break;
   case 8:
    $7 = HEAP32[$sflag >> 2] | 0;
    $tobool = ($7 | 0) == 0;
    if ($tobool) {
      $bb_sroa_0_2 = $bb_sroa_0_1;
      $bb_sroa_1_2 = $bb_sroa_1_1;
      $bb_sroa_2_2 = $bb_sroa_2_1;
      $bb_sroa_3_2 = $bb_sroa_3_1;
      label = 10;
      break;
    } else {
      label = 9;
      break;
    }
   case 9:
    $8 = HEAP32[$list63 >> 2] | 0;
    _arrow_bb($tmp66, $sp, $8, 1.0, 0);
    $b_sroa_0_0_copyload2 = +HEAPF64[$b_sroa_0_0__idx1 >> 3];
    $b_sroa_1_8_copyload12 = +HEAPF64[$b_sroa_1_8__idx11 >> 3];
    $b_sroa_2_16_copyload22 = +HEAPF64[$b_sroa_2_16__idx21 >> 3];
    $b_sroa_3_24_copyload32 = +HEAPF64[$b_sroa_3_24__idx31 >> 3];
    $cmp71 = $bb_sroa_0_1 < $b_sroa_0_0_copyload2;
    $bb_sroa_0_1_b_sroa_0_0_copyload2 = $cmp71 ? $bb_sroa_0_1 : $b_sroa_0_0_copyload2;
    $cmp86 = $bb_sroa_1_1 < $b_sroa_1_8_copyload12;
    $cond94 = $cmp86 ? $bb_sroa_1_1 : $b_sroa_1_8_copyload12;
    $cmp101 = $bb_sroa_2_1 > $b_sroa_2_16_copyload22;
    $bb_sroa_2_1_b_sroa_2_16_copyload22 = $cmp101 ? $bb_sroa_2_1 : $b_sroa_2_16_copyload22;
    $cmp116 = $bb_sroa_3_1 > $b_sroa_3_24_copyload32;
    $cond124 = $cmp116 ? $bb_sroa_3_1 : $b_sroa_3_24_copyload32;
    $bb_sroa_0_2 = $bb_sroa_0_1_b_sroa_0_0_copyload2;
    $bb_sroa_1_2 = $cond94;
    $bb_sroa_2_2 = $bb_sroa_2_1_b_sroa_2_16_copyload22;
    $bb_sroa_3_2 = $cond124;
    label = 10;
    break;
   case 10:
    $9 = HEAP32[$eflag >> 2] | 0;
    $tobool128 = ($9 | 0) == 0;
    if ($tobool128) {
      $bb_sroa_0_3 = $bb_sroa_0_2;
      $bb_sroa_1_3 = $bb_sroa_1_2;
      $bb_sroa_2_3 = $bb_sroa_2_2;
      $bb_sroa_3_3 = $bb_sroa_3_2;
      label = 12;
      break;
    } else {
      label = 11;
      break;
    }
   case 11:
    $10 = HEAP32[$size130 >> 2] | 0;
    $sub = $10 - 1 | 0;
    $11 = HEAP32[$list131 >> 2] | 0;
    $arrayidx132 = $11 + ($sub << 4) | 0;
    _arrow_bb($tmp134, $ep, $arrayidx132, 1.0, 0);
    $b_sroa_0_0_copyload = +HEAPF64[$b_sroa_0_0__idx >> 3];
    $b_sroa_1_8_copyload = +HEAPF64[$b_sroa_1_8__idx10 >> 3];
    $b_sroa_2_16_copyload = +HEAPF64[$b_sroa_2_16__idx20 >> 3];
    $b_sroa_3_24_copyload = +HEAPF64[$b_sroa_3_24__idx30 >> 3];
    $cmp139 = $bb_sroa_0_2 < $b_sroa_0_0_copyload;
    $bb_sroa_0_2_b_sroa_0_0_copyload = $cmp139 ? $bb_sroa_0_2 : $b_sroa_0_0_copyload;
    $cmp154 = $bb_sroa_1_2 < $b_sroa_1_8_copyload;
    $cond162 = $cmp154 ? $bb_sroa_1_2 : $b_sroa_1_8_copyload;
    $cmp169 = $bb_sroa_2_2 > $b_sroa_2_16_copyload;
    $bb_sroa_2_2_b_sroa_2_16_copyload = $cmp169 ? $bb_sroa_2_2 : $b_sroa_2_16_copyload;
    $cmp184 = $bb_sroa_3_2 > $b_sroa_3_24_copyload;
