// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_BANNERS_APP_BANNER_METRICS_H_
#define CHROME_BROWSER_BANNERS_APP_BANNER_METRICS_H_

namespace banners {

// Keep in sync with the values defined in histograms.xml.
enum DisplayEvent {
  DISPLAY_EVENT_MIN = 0,
  DISPLAY_EVENT_BANNER_REQUESTED = 1,
  DISPLAY_EVENT_BLOCKED_PREVIOUSLY = 2,
  DISPLAY_EVENT_PROMOTED_TOO_MANY_OTHERS = 3,
  DISPLAY_EVENT_CREATED = 4,
  DISPLAY_EVENT_INSTALLED_PREVIOUSLY = 5,
  DISPLAY_EVENT_IGNORED_PREVIOUSLY = 6,
  DISPLAY_EVENT_LACKS_SERVICE_WORKER = 7,
  DISPLAY_EVENT_NOT_VISITED_ENOUGH = 8,
  DISPLAY_EVENT_NATIVE_APP_BANNER_REQUESTED = 9,
  DISPLAY_EVENT_WEB_APP_BANNER_REQUESTED = 10,
  DISPLAY_EVENT_NATIVE_APP_BANNER_CREATED = 11,
  DISPLAY_EVENT_WEB_APP_BANNER_CREATED = 12,
  DISPLAY_EVENT_MAX = 13,
};

enum InstallEvent {
  INSTALL_EVENT_MIN = 20,
  INSTALL_EVENT_NATIVE_APP_INSTALL_TRIGGERED = 21,
  INSTALL_EVENT_NATIVE_APP_INSTALL_STARTED = 22,
  INSTALL_EVENT_NATIVE_APP_INSTALL_COMPLETED = 23,
  INSTALL_EVENT_WEB_APP_INSTALLED = 24,
  INSTALL_EVENT_MAX = 25,
};

enum DismissEvent {
  DISMISS_EVENT_MIN = 40,
  DISMISS_EVENT_ERROR = 41,
  DISMISS_EVENT_APP_OPEN = 42,
  DISMISS_EVENT_BANNER_CLICK = 43,
  DISMISS_EVENT_BANNER_SWIPE = 44,
  DISMISS_EVENT_CLOSE_BUTTON = 45,
  DISMISS_EVENT_INSTALL_TIMEOUT = 46,
  DISMISS_EVENT_DISMISSED = 47,
  DISMISS_EVENT_MAX = 48,
};

enum UserResponse {
  USER_RESPONSE_MIN = 0,
  USER_RESPONSE_NATIVE_APP_ACCEPTED = 1,
  USER_RESPONSE_WEB_APP_ACCEPTED = 2,
  USER_RESPONSE_NATIVE_APP_DISMISSED = 3,
  USER_RESPONSE_WEB_APP_DISMISSED = 4,
  USER_RESPONSE_NATIVE_APP_IGNORED = 5,
  USER_RESPONSE_WEB_APP_IGNORED = 6,
  USER_RESPONSE_MAX = 7,
};

extern const char kDismissEventHistogram[];
extern const char kDisplayEventHistogram[];
extern const char kInstallEventHistogram[];
extern const char kMinutesHistogram[];
extern const char kUserResponseHistogram[];

void TrackDismissEvent(int event);
void TrackDisplayEvent(int event);
void TrackInstallEvent(int event);
void TrackMinutesFromFirstVisitToBannerShown(int minutes);
void TrackUserResponse(int event);

};  // namespace banners

#endif  // CHROME_BROWSER_BANNERS_APP_BANNER_METRICS_H_
