{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetReference: String;
    procedure SetReference(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdName: TSFString;
    { X3D field "name". } { }
    public property FdName: TSFString read FFdName;
    { X3D field "name". } { }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdReference: TSFString;
    { X3D field "reference". } { }
    public property FdReference: TSFString read FFdReference;
    { X3D field "reference". } { }
    property Reference: String read GetReference write SetReference;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractMetadataNode ----------------------------------------------- }

function TAbstractMetadataNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure TAbstractMetadataNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function TAbstractMetadataNode.GetReference: String;
begin
  Result := FdReference.Value;
end;

procedure TAbstractMetadataNode.SetReference(const Value: String);
begin
  FdReference.Send(Value);
end;

class function TAbstractMetadataNode.ClassX3DType: String;
begin
  Result := 'X3DMetadataNode';
end;

procedure TAbstractMetadataNode.CreateNode;
begin
  inherited;

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdReference := TSFString.Create(Self, True, 'reference', '');
   FdReference.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReference);

  DefaultContainerField := 'metadata';
end;

{$endif read_implementation}
