{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    { Set X3D field "groundAngle". } { }
    procedure SetGroundAngle(const Value: array of Single);
    { Set X3D field "groundAngle". } { }
    procedure SetGroundAngle(const Value: TSingleList);
    { Set X3D field "groundColor". } { }
    procedure SetGroundColor(const Value: array of TCastleColorRGB);
    { Set X3D field "groundColor". } { }
    procedure SetGroundColor(const Value: TVector3List);
    { Set X3D field "skyAngle". } { }
    procedure SetSkyAngle(const Value: array of Single);
    { Set X3D field "skyAngle". } { }
    procedure SetSkyAngle(const Value: TSingleList);
    { Set X3D field "skyColor". } { }
    procedure SetSkyColor(const Value: array of TCastleColorRGB);
    { Set X3D field "skyColor". } { }
    procedure SetSkyColor(const Value: TVector3List);
    { X3D field "transparency". } { }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstract3DBackgroundNode ----------------------------------------------- }

procedure TAbstract3DBackgroundNode.SetGroundAngle(const Value: array of Single);
begin
  FdGroundAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetGroundAngle(const Value: TSingleList);
begin
  FdGroundAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetGroundColor(const Value: array of TCastleColorRGB);
begin
  FdGroundColor.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetGroundColor(const Value: TVector3List);
begin
  FdGroundColor.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyAngle(const Value: array of Single);
begin
  FdSkyAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyAngle(const Value: TSingleList);
begin
  FdSkyAngle.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyColor(const Value: array of TCastleColorRGB);
begin
  FdSkyColor.Send(Value);
end;

procedure TAbstract3DBackgroundNode.SetSkyColor(const Value: TVector3List);
begin
  FdSkyColor.Send(Value);
end;

function TAbstract3DBackgroundNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TAbstract3DBackgroundNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

{$endif read_implementation}
