/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef StructuralComponentDCPopup_H
#define StructuralComponentDCPopup_H

#include <ComponentPopupMenu.h>

class vtkTransform;

/**
 *  @ingroup group_cepmodeling_components_physicalmodel
 *
 *  @brief
 *  The popup menu of the structural component data component.
 *
 *
 **/
class StructuralComponentDCPopup : public camitk::ComponentPopupMenu  {

    Q_OBJECT

public:
    /// constructor
    StructuralComponentDCPopup(camitk::Component *, QWidget*);

public slots:

    /// save as vtk
//    void vtkExport();

    /// save a csv file with informations : coordinates and references of the points for the moment
    void saveToCsv();
};

#endif
