/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "ObjExtension.h"
#include "ObjComponent.h"

// --------------- declare the plugin -------------------
Q_EXPORT_PLUGIN2(ObjExtension, ObjExtension);

// --------------- getName -------------------
QString ObjExtension::getName() const {
  return "Alias Wavefront OBJ Component";
}

// --------------- getDescription -------------------
QString ObjExtension::getDescription() const {
  return "Manage Alias Wavefront OBJ <em>.obj</em> files in <b>CamiTK</b>.<br/>(very few support!)";
}

// --------------- getFileExtensions -------------------
QStringList ObjExtension::getFileExtensions() const {
  QStringList ext;
  ext << "obj";
  return ext;
}

// --------------- open -------------------
camitk::Component * ObjExtension::open(const QString & fileName) throw (camitk::AbortException) {
  return new ObjComponent(fileName);
}
