/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:09:48 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.GCFrameAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GCFrameAlgorithm_ESTest extends GCFrameAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Kw{kS ia");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      float[] floatArray0 = new float[6];
      gCFrameAlgorithm0.getValues((-4040), 1, floatArray0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BDS,TcmdwwhX65");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(2048);
      assertEquals(256, (int)integer0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNotNull(integer0);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("hvF.+^L$o5%H:p");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.getAverage();
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BDS,TcmdwwhX65");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.getAverage();
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimilarityPairFeature.EmptyPairwiseAlignment similarityPairFeature_EmptyPairwiseAlignment0 = (SimilarityPairFeature.EmptyPairwiseAlignment)SimilarityPairFeature.EMPTY_PAIRWISE;
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(similarityPairFeature_EmptyPairwiseAlignment0);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(0, 36, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("hvF.+^Lo5%H:p");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      float[] floatArray0 = new float[2];
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(647, 2, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 645 > end: 2
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GCFrameAlgorithm gCFrameAlgorithm0 = null;
      try {
        gCFrameAlgorithm0 = new GCFrameAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BDS,TcmdwwhX65");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      int int0 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Kw{kS ia");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(2247);
      assertEquals(280, (int)integer0);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("hvF.+^L$o5%H:p");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize((-5));
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertNull(integer0);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("hvF.+^L$o5%H:p");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Integer integer0 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Kw{kS ia");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(500, (int)integer0);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BDS,TcmdwwhX65");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Integer integer0 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(120, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("-02-");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      float[] floatArray0 = new float[9];
      gCFrameAlgorithm0.getValues(5, 31, floatArray0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("hvF.+^L$o5%H:p");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      float[] floatArray0 = new float[2];
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(2, 86, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BDS,TcmdwwhX65");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      LineAttributes[] lineAttributesArray0 = new LineAttributes[1];
      gCFrameAlgorithm0.drawLegend((Graphics) null, 0, 3058, lineAttributesArray0, 1);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BDS,TcmdwwhX65");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Float float0 = gCFrameAlgorithm0.getMinimumInternal();
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      Float float0 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(100.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }
}
