# APBS validation and test cases

This directory serves as the root directory for the APBS test suite.  This
directory contains python source files used for testing an an input file
containing the input files for apbs and the expected results for each test case.

The input file is called test_cases.cfg, and the main testing program is called
apbs_tester.py.

## Usage

The following is a usage description for apbs_tester.py

```
$ python apbs_tester.py [options]

Options:
  -h, --help            show this help message and exit
  -c FILE, --test_config=FILE
                        Set the test configuration file to FILE
  -t TEST, --target_test=TEST
                        Set the test to run to TEST
  -o, --ocd             Run APBS in OCD mode
  -l FILE, --log_file=FILE
                        Save the test log to FILE.
```

** Note: If apbs_tester.py execute bit is set, it may be run from command line
         Unix based systems only


## Test Sections


The sections of the test file follow the following format:

```
[Some-Section]
input_directory    : /path/to/some-example
some-forces        : forces
some-input         : * * 1.0E+01 2.0E+02
```

* The first element describes the name of the test section,
* The first property is the input_directory.  This is the location of inputs,
* The followiing properties are test cases,
* The property name is also the name of the input file concatenated with .in,
* The property name will also be used for the output from apbs some-input.in > some-input.out,
* If the value of the property is 'forces' a forces test will be run,
* If the value of the property is a list of floats, these are expected outputs,
* If a '*' is used in place of a float, the output will be ignored. Some test cases have multiple outputs. The test function parses each of these, but if a '*' is used, the output will be ignored in testing.  Most often, the first outputs are intermediate followed by a final output, and the test case is only concerned with the final output.
     
