# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

__all__ = ['factory', 'openid', 'openidteams']

from apache_openid import logging
from apache_openid.handlers.factory import Factory, known_handlers

def register_handler(name, handlerclass):
    logging.error("Registering handler: %s", name)
    if name in known_handlers.keys():
        logging.error("Handler name exists: %s (%s)", name, handlerclass)
    else:
        known_handlers[name] = handlerclass

from apache_openid.handlers import *

