# H.2 What parts of anarchism do Marxists particularly misrepresent?

Many people involved in politics will soon discover that Marxist groups
(particularly Leninist ones) organise "debates" about anarchism. These
meetings are usually entitled _"Marxism and Anarchism"_ and are usually
organised after anarchists have been active in the area or have made the
headlines somewhere.

These meetings, contrary to common sense, are usually not a debate as (almost
always) no anarchists are invited to argue the anarchist viewpoint and,
therefore, they present a one-sided account of _"Marxism and Anarchism"_ in a
manner which benefits the organisers. Usually, the format is a speaker
distorting anarchist ideas and history for a long period of time (both
absolutely in terms of the length of the meeting and relatively in terms of
the boredom inflicted on the unfortunate attendees). It will soon become
obvious to those attending that any such meeting is little more than an
unprincipled attack on anarchism with little or no relationship to what
anarchism is actually about. Those anarchists who attend such meetings usually
spend most of their allotted (usually short) speaking time refuting the
nonsense that is undoubtedly presented. Rather than a **real** discussion
between the differences between anarchism and "Marxism" (i.e. Leninism), the
meeting simply becomes one where anarchists correct the distortions and
misrepresentations of the speaker in order to create the basis of a real
debate. If the reader does not believe this summary we would encourage them to
attend such a meeting and see for themselves.

Needless to say, we cannot hope to reproduce the many distortions produced in
such meetings. However, when anarchists do hit the headlines (such as in the
1990 poll tax riot in London and the anti-globalisation movement of the late
1990s and early 2000s), various Marxist papers will produce articles on
"Anarchism" as well. Like the meetings, the articles are full of so many
elementary errors that it takes a lot of effort to think they are the product
of ignorance rather than a conscious desire to lie. In addition, many of the
founding fathers of Marxism (and Leninism) also decided to attack anarchism in
similar ways, so this activity does have a long tradition in Marxist circles
(particularly in Leninist and Trotskyist ones). Sadly, Max Nettlau's comments
on Marx and Engels are applicable to many of their followers today. He argued
that they _"acted with that shocking lack of honesty which was characteristic
of **all** their polemics. They worked with inadequate documentation, which,
according to their custom, they supplemented with arbitrary declarations and
conclusions - accepted as truth by their followers although they were exposed
as deplorable misrepresentations, errors and unscrupulous perversions of the
truth."_ [ **A Short History of Anarchism** , p. 132] As the reader will
discover, this summary has not lost its relevance today. If you read Marxist
"critiques" of anarchism you will soon discover the same repetition of
"accepted" truths, the same inadequate documentation, the same arbitrary
declarations and conclusions as well as an apparent total lack of familiarity
with the source material they claim to be analysing.

This section of the FAQ lists and refutes many of the most common distortions
Marxists make with regards to anarchism. As will become clear, many of the
most common Marxist attacks on anarchism have little or no basis in fact but
have simply been repeated so often by Marxists that they have entered the
ideology (the idea that anarchists think the capitalist class will just
disappear being, probably, the most famous one).

Moreover, Marxists make many major and minor distortions of anarchist theory
in passing. For example, Eric Hobsbawm wrote of the _"extremism of the
anarchist rejection of state and organisation"_ while being well aware, as a
leading Marxist historian, of numerous anarchist organisations. [
**Revolutionaries** , p. 113] This kind of nonsense has a long history, with
Engels asserting in his infamous diatribe _"The Bakuninists at work"_ that
Bakunin _"[a]s early as September 1870 (in his **Lettres a un francais**
[Letters to a Frenchman]) . . . had declared that the only way to drive the
Prussians out of France by a revolutionary struggle was to do away with all
forms of centralised leadership and leave each town, each village, each parish
to wage war on its own."_ For Engels anarchist federalism _"consisted
precisely in the fact that each town acted on its own, declaring that the
important thing was not co-operation with other towns but separation from
them, this precluding any possibility of a combined attack."_ This meant _"the
fragmentation and isolation of the revolutionary forces which enabled the
government troops to smash one revolt after the other."_ According to Engels,
the anarchists _"proclaimed [this] a principle of supreme revolutionary
wisdom."_ [ **Collected Works** , vol. 23, p. 592]

In fact, the truth is totally different. Bakunin did, of course, reject
_"centralised leadership"_ as it would be _"necessarily very circumscribed,
very short-sighted, and its limited perception cannot, therefore, penetrate
the depth and encompass the whole complex range of popular life."_ However, it
is a falsehood to state that he denied the need for co-ordination of struggles
and federal organisations from the bottom up. As he put it, the revolution
must _"foster the self-organisation of the masses into autonomous bodies,
federated from the bottom upwards."_ With regards to the peasants, he thought
they will _"come to an understanding, and form some kind of organisation . . .
to further their mutual interests . . . the necessity to defend their homes,
their families, and their own lives against unforeseen attack . . . will
undoubtedly soon compel them to contract new and mutually suitable
arrangements."_ The peasants would be _"freely organised from the bottom up."_
Rather than deny the need for co-ordination, Bakunin stressed it: _"the
peasants, like the industrial city workers, should unite by federating the
fighting battalions, district by district, assuring a common co-ordinated
defence against internal and external enemies."_ [ _"Letters to a Frenchman on
the present crisis"_ , **Bakunin on Anarchism** , p. 196, p. 206, p. 207 and
p. 190]

In this Bakunin was repeating his earlier arguments concerning social
revolution - arguments that Engels was well aware of and so he deliberately
misrepresented Bakunin's ideas. Moreover, far from exposing the flaws of
federalism, Engels recounts a revolt in which federalism was **not** actually
implemented. It should also be mentioned that Engels opposed the Spanish
workers rising in revolt in the first place. _"A few years of peaceful
bourgeois republic,"_ he argued, _"would prepare the ground in Spain for a
proletarian revolution"_ and _"instead of staging isolated, easily crushed
rebellions,"_ he hoped that the _"Spanish workers will make use of the
republic"_ with a _"view to an approaching revolution."_ He ended by asking
them not to give the bourgeois government _"an excuse to suppress the
revolutionary movement."_ [ **Op. Cit.** , pp. 420-1] In his post-revolt
diatribe, Engels repeated this analysis and suggested that the "Bakuninists"
should have simply stood for election:

> _"At quiet times, when the proletariat knows beforehand that at best it can
> get only a few representatives to parliament and have no chance whatever of
> winning a parliamentary majority, the workers may sometimes be made to
> believe that it is a great revolutionary action to sit out the elections at
> home, and in general, not to attack the State in which they live and which
> oppresses them, but to attack the State as such which exists nowhere and
> which accordingly cannot defend itself."_ [ **Op. Cit.** , p. 583]

For some reason, few Leninists quote these recommendations to the Spanish
workers nor do they dwell on the reformist and bureaucratic nature of the
Socialist party inspired by this advice. As we discuss in [section
H.3.10](secH3.md#sech310), the notion that voting in elections was to
_"attack the State"_ fits in well with the concept that universal suffrage
equalled the _"political power"_ of the proletariat and the democratic
republic was the _"specific form"_ of its dictatorship. Again, for some
strange reason, few Leninists mention that either.

The distortions can be somewhat ironic, as can be seen when Trotsky asserted
in 1937 that anarchists are _"willing to replace Bakunin's patriarchal
'federation of free communes' by the more modern federation of free soviets."_
[ **Writings 1936-37** , p. 487] It is hard to know where to start in this
incredulous rewriting of history. Firstly, Bakunin's federation of free
communes was, in fact, based on workers' councils ("soviets") - see [section
I.2.3](secI2.md#seci23). As for the charge of supporting _"patriarchal"_
communes, nothing could be further from the truth. In his discussion of the
Russian peasant commune (the mir) Bakunin argued that _"patriarchalism"_ was
one of its _"three dark features,"_ indeed _"the main historical evil . . .
against which we are obliged to struggle with all our might."_ This _"evil"_ ,
he stressed, _"has distorted the whole of Russian life"_ and the _"despotism
of the father"_ turned the family _"into a school of triumphant force and
tyranny, of daily domestic baseness and depravity."_ The _"same patriarchal
principle, the same vile despotism, and the same base obedience prevail
within"_ the peasant commune. Any revolt against _"the hated state power and
bureaucratic arbitrariness . . . simultaneously becomes a revolt against the
despotism of the commune."_ The _"war against patriarchalism is now being
waged in virtually every village and every family."_ [ **Statism and Anarchy**
, p. 206, pp. 209-10, p. 210 and p. 214]

As can be seen Trotsky's summary of Bakunin's ideas is totally wrong. Not only
did his ideas on the organisation of the free commune as a federation of
workers' associations predate the soviets by decades, he also argued against
patriarchal relationships and urged their destruction in the Russian peasant
commune (and elsewhere). Indeed, if any one fits Trotsky's invention it is
Marx, not Bakunin. After all, Marx came round (eventually) to Bakunin's
position that the peasant commune could be the basis for Russia to jump
straight to socialism (and so by-passing capitalism) but without Bakunin's
critical analysis of that institution and its patriarchal and other _"dark"_
features. Similarly, Marx never argued that the future socialist society would
be based on workers' associations and their federation (i.e. workers'
councils). His vision of revolution was formulated in typically bourgeois
structures such as the Paris Commune's municipal council.

We could go on, but space precludes discussing every example. Suffice to say,
it is not wise to take any Marxist assertion of anarchist thought or history
at face value. A common technique is to quote anarchist writers out of context
or before they become anarchists. For example, Marxist Paul Thomas argues that
Bakunin favoured _"blind destructiveness"_ and yet quotes more from Bakunin's
pre-anarchist works (as well as Russian nihilists) than Bakunin's anarchist
works to prove his claim. Similarly, Thomas claims that Bakunin _"defended the
**federes** of the Paris Commune of 1871 on the grounds that they were strong
enough to dispense with theory altogether,"_ yet his supporting quote clearly
does not, in fact, say this. [ **Karl Marx and the Anarchists** , pp. 288-90
and p. 285] What Bakunin was, in fact, arguing was simply that theory must
progress from experience and that any attempt to impose a theory on society
would be doomed to create a _"Procrustean bed"_ as no government could
_"embrace the infinite multiplicity and diversity of the real aspirations,
wishes and needs whose sum total constitutes the collective will of a
people."_ He explicitly contrasted the Marxist system of _"want[ing] to impose
science upon the people"_ with the anarchist desire _"to diffuse science and
knowledge among the people, so that the various groups of human society, when
convinced by propaganda, may organise and spontaneously combine into
federations, in accordance with their natural tendencies and their real
interests, but never according to a plan traced in advance and **imposed upon
the ignorant masses** by a few 'superior' minds."_ [ **The Political Theory of
Bakunin** , p. 300] A clear misreading of Bakunin's argument but one which
fits nicely into Marxist preconceptions of Bakunin and anarchism in general.

This tendency to quote out of context or from periods when anarchists were not
anarchists probably explains why so many of these Marxist accounts of
anarchism are completely lacking in references. Take, for example, the British
SWP's Pat Stack who, in the face of stiff competition, wrote one of the most
inaccurate diatribes against anarchism the world has had the misfortunate to
see (namely _"Anarchy in the UK?"_ [ **Socialist Review** , no. 246]). There
is not a single reference in the whole article, which is just as well, given
the inaccuracies contained in it. Without references, the reader would not be
able to discover for themselves the distortions and simple errors contained in
it.

For example, Stack asserts that Bakunin _"claimed a purely 'instinctive
socialism.'"_ However, the truth is different and this quote from Bakunin is
one by him comparing himself and Marx in the 1840s! In fact, the **anarchist**
Bakunin argued that _"instinct as a weapon is not sufficient to safeguard the
proletariat against the reactionary machinations of the privileged classes,"_
as instinct _"left to itself, and inasmuch as it has not been transformed into
consciously reflected, clearly determined thought, lends itself easily to
falsification, distortion and deceit."_ [ **The Political Philosophy of
Bakunin** , p. 215] Bakunin saw the process of class struggle as the means of
transforming instinct into conscious thought. As he put it, the _"goal, then,
is to make the worker fully aware of what he [or she] wants, to unjam within
him [or her] a steam of thought corresponding to his [or her] instinct."_ This
is done by _"a single path, that of **emancipation through practical action**
,"_ by _"workers' solidarity in their struggle against the bosses,"_ of
_"collective struggle of the workers against the bosses."_ This would be
complemented by socialist organisations _"propagandis[ing] its principles."_ [
**The Basic Bakunin** , p. 102, p. 103 and p. 109] Clearly, Stack is totally
distorting Bakunin's ideas on the subject.

This technique of quoting Bakunin when he spoke about (or when he wrote in)
his pre-anarchist days in the 1840s, i.e. nearly 20 years **before** he became
an anarchist, or from Proudhon's non-anarchist and posthumously published work
on property (in which Proudhon saw small-scale property as a bulwark against
state tyranny) to attack anarchism is commonplace. So it is always wise to
check the source material and any references (assuming that they are
provided). Only by doing this can it be discovered whether a quote reflects
the opinions of individuals when they were anarchists or whether they are
referring to periods when they were no longer, or had not yet become,
anarchists.

Ultimately, though, these kinds of articles by Marxists simply show the
ideological nature of their own politics and say far more about Marxism than
anarchism. After all, if their politics were strong they would not need to
distort anarchist ideas! In addition, these essays are usually marked by a lot
of (usually inaccurate) attacks on the ideas (or personal failings) of
individual anarchists (usually Proudhon and Bakunin and sometimes Kropotkin).
No modern anarchist theorist is usually mentioned, never mind discussed.
Obviously, for most Marxists, anarchists must repeat parrot-like the ideas of
these "great men." However, while Marxists may do this, anarchists have always
rejected this approach. We deliberately call ourselves **anarchists** rather
than Proudhonists, Bakuninists, Kropotkinists, or after any other person. As
Malatesta argued in 1876 (the year of Bakunin's death) _"[w]e follow ideas and
not men, and rebel against this habit of embodying a principle in a man."_ [
**Errico Malatesta: His Life and Ideas** , p. 198]

Therefore, anarchists, unlike many (most?) Marxists do not believe that some
prophet wrote down the scriptures in past centuries and if only we could reach
a correct understanding of these writings today we would see the way forward.
Chomsky put it extremely well:

> _"The whole concept of Marxist or Freudian or anything like that is very
> odd. These concepts belong to the history of organised religion. Any living
> person, no matter how gifted, will make some contributions intermingled with
> error and partial understanding. We try to understand and improve on their
> contributions and eliminate the errors. But how can you identify yourself as
> a Marxist, or a Freudian, or an X-ist, whoever X may be? That would be to
> treat the person as a God to be revered, not a human being whose
> contributions are to be assimilated and transcended. It's a crazy idea, a
> kind of idolatry."_ [ **The Chomsky Reader** , pp. 29-30]

This means that anarchists recognise that any person, no matter how great or
influential, is only human. They make mistakes, they fail to live up to all
the ideals they express, they are shaped by the society they live in, and so
on. Anarchists recognise this fact and extract the positive aspects of past
anarchist thinkers, reject the rest and develop what we consider the living
core of their ideas, learn from history and constantly try to bring anarchist
ideas up-to-date (after all, a lot has changed since the days of Proudhon,
Bakunin and Kropotkin and this has to be taken into account). As Max Nettlau
put it with regards to Proudhon, _"we have to extract from his work useful
teachings that would be of great service to our modern libertarians, who
nevertheless have to find their own way from theory to practice and to the
critique of our present-day conditions, as Proudhon did in his time. This does
not call for a slavish imitation; it implies using his work to inspire us and
enable us to profit by his experience."_ [ **A Short History of Anarchism** ,
pp. 46-7] Similarly for other anarchists - we see them as a source of
inspiration upon which to build rather than a template which to copy. This
means to attack anarchism by, say, attacking Bakunin's or Proudhon's personal
failings is to totally miss the point. While anarchists may be inspired by the
ideas of, say, Bakunin or Proudhon it does not mean we blindly follow all of
their ideas. Far from it! We critically analyse their ideas and keep what is
living and reject what is useless or dead. Sadly, such common sense is lacking
in many who critique anarchism.

However, the typical Marxist approach does have its benefits from a political
perspective. It is very difficult for Marxists and Leninists to make an
objective criticism of Anarchism for, as Albert Meltzer pointed out, _"by its
nature it undermines all the suppositions basic to Marxism. Marxism was held
out to be the basic working class philosophy (a belief which has utterly
ruined the working class movement everywhere). It holds that the industrial
proletariat cannot owe its emancipation to anyone but themselves alone. It is
hard to go back on that and say that the working class is not yet ready to
dispense with authority placed over it . . . Marxism normally tries to refrain
from criticising anarchism as such - unless driven to doing so, when it
exposes its own authoritarianism . . . and concentrates its attacks not on
Anarchism, but on Anarchists."_ [ **Anarchism: Arguments for and Against** ,
p. 62] Needless to say, this technique is the one usually applied by Marxists
(although, we must stress that usually their account of the ideas of Proudhon,
Bakunin, and Kropotkin are so distorted that they fail even to do this!).

So anarchist theory has developed since Proudhon, Bakunin and Kropotkin. At
each period in history anarchism advanced in its understanding of the world,
the anarchism of Bakunin was a development of that of Proudhon, these ideas
were again developed by the anarcho-communists of the 1880s and by the
syndicalists of the 1890's, by the Italian Malatesta, the Russian Kropotkin,
the Mexican Flores Magon and many other individuals and movements. Today we
stand on their shoulders, not at their feet.

As such, to concentrate on the ideas of a few _"leaders"_ misses the point
totally. While anarchism contains many of the core insights of, say, Bakunin,
it has also developed them and added to them. It has, concretely, taken into
account, say, the lessons of the Russian and Spanish revolutions and so on. As
such, even assuming that Marxist accounts of certain aspects of the ideas of
Proudhon, Bakunin and Kropotkin were correct, they would have to be shown to
be relevant to modern anarchism to be of any but historical interest. Sadly,
Marxists generally fail to do this and, instead, we are subject to a (usually
inaccurate) history lesson.

In order to understand, learn from and transcend previous theorists we must
honestly present their ideas. Unfortunately many Marxists do not do this and
so this section of the FAQ involves correcting the many mistakes, distortions,
errors and lies that Marxists have subjected anarchism to. Hopefully, with
this done, a real dialogue can develop between Marxists and anarchists.
Indeed, this has happened between libertarian Marxists (such as council
communists and Situationists) and anarchists and both tendencies have
benefited from it. Perhaps this dialogue between libertarian Marxists and
anarchists is to be expected, as the mainstream Marxists have often
misrepresented the ideas of libertarian Marxists as well - when not dismissing
them as anarchists!

## H.2.1 Do anarchists reject defending a revolution?

According to many Marxists anarchists either reject the idea of defending a
revolution or think that it is not necessary. The Trotskyists of **Workers'
Power** present a typical Marxist account of what **they** consider as
anarchist ideas on this subject:

> _"the anarchist conclusion is not to build any sort of state in the first
> place - not even a democratic workers' state. But how could we stop the
> capitalists trying to get their property back, something they will
> definitely try and do?_

> _"Should the people organise to stop the capitalists raising private armies
> and resisting the will of the majority? If the answer is yes, then that
> organisation - whatever you prefer to call it - is a state: an apparatus
> designed to enable one class to rule over another._

> _"The anarchists are rejecting something which is necessary if we are to
> beat the capitalists and have a chance of developing a classless society."_
> [ _"What's wrong with anarchism?"_ , pp. 12-13, **World Revolution: Prague
> S26 2000** , p. 13]

It would be simple to quote Malatesta from 1891 on this issue and leave it at
that. As he put it some seem to suppose _"that anarchists, in the name of
their principles, would wish to see that strange freedom respected which
violates and destroys the freedom and life of others. They seem almost to
believe that after having brought down government and private property we
would allow both to be quietly built up again, because of respect for the
**freedom** of those who might feel the need to be rulers and property owners.
A truly curious way of interpreting our ideas."_ [ **Anarchy** , pp. 42-3]
Pretty much common sense, so you would think! Sadly, this appears to not be
the case. As such, we have to explain anarchist ideas on the defence of a
revolution and why this necessity need not imply a state and, if it did, then
it signifies the end of the revolution.

The argument by **Workers' Power** is very common within the Leninist left and
contains three fallacies, which we expose in turn. Firstly, we have to show
that anarchists have always seen the necessity of defending a revolution. This
shows that the anarchist opposition to the _"democratic workers' state"_ (or
_"dictatorship of the proletariat"_ ) has nothing to do with beating the
ruling class and stopping them regaining their positions of power. Secondly,
we have to discuss the anarchist and Marxist definitions of what constitutes a
_"state"_ and show what they have in common and how they differ. Thirdly, we
must summarise why anarchists oppose the idea of a _"workers' state"_ in order
for the **real** reasons why anarchists oppose it to be understood. Each issue
will be discussed in turn.

For revolutionary anarchists, it is a truism that a revolution will need to
defend itself against counter-revolutionary threats. Bakunin, for example,
while strenuously objecting to the idea of a _"dictatorship of the
proletariat"_ also thought a revolution would need to defend itself:

> _"Immediately after established governments have been overthrown, communes
> will have to reorganise themselves along revolutionary lines . . . In order
> to defend the revolution, their volunteers will at the same time form a
> communal militia. But no commune can defend itself in isolation. So it will
> be necessary to radiate revolution outward, to raise all of its neighbouring
> communes in revolt . . . and to federate with them for common defence."_ [
> **No Gods, No Masters** , vol. 1, p. 142]

And:

> _"the Alliance of all labour associations . . . will constitute the Commune
> . . . there will be a standing federation of the barricades and a
> Revolutionary Communal Council . . . [made up of] delegates . . . invested
> with binding mandates and accountable and revocable at all times . . . all
> provinces, communes and associations . . . [will] delegate deputies to an
> agreed place of assembly (all . . . invested with binding mandated and
> accountable and subject to recall), in order to found the federation of
> insurgent associations, communes and provinces . . . and to organise a
> revolutionary force with the capacity of defeating the reaction . . . it is
> through the very act of extrapolation and organisation of the Revolution
> with an eye to the mutual defences of insurgent areas that the universality
> of the Revolution . . . will emerge triumphant."_ [ **Op. Cit.** , pp.
> 155-6]

Malatesta agreed, explicitly pointing to _"corps of volunteers (anarchist
formations)"_ as a means of defending a revolution from _"attempts to reduce a
free people to a state of slavery again."_ To defend a revolution required
_"the necessary geographical and mechanical knowledge, and above all large
masses of the population willing to go and fight. A government can neither
increase the abilities of the former nor the will and courage of the latter."_
[ **Anarchy** , p. 42] Decades later, his position had not changed and he was
still arguing for the _"creation of voluntary militia, without powers to
interfere as militia in the life of the community, but only to deal with any
armed attacks by the forces of reaction to re-establish themselves, or to
resist outside intervention"_ for only _"the people in arms, in possession of
the land, the factories and all the natural wealth"_ could _"defend . . . the
revolution."_ [ **Errico Malatesta: His Life and Ideas** , p. 166 and p. 170]

Alexander Berkman concurred. In his classic introduction to anarchism, he
devoted a whole chapter to the issue which he helpfully entitled _"Defense of
the Revolution"_. He noted that it was _"your duty, as an Anarchist, to
protect your liberty, to resist coercion and compulsion . . . the social
revolution . . . will defend itself against invasion from any quarter . . .
The armed workers and peasants are the only effective defence of the
revolution. By means of their unions and syndicates they must always be on
guard against counter-revolutionary attack."_ [ **What is Anarchism?** , pp.
231-2] Emma Goldman clearly and unambiguously stated that she had _"always
insisted that an armed attack on the Revolution must be met with armed force"_
and that _"an armed counter-revolutionary and fascist attack can be met in no
way except by an armed defence."_ [ **Vision on Fire** , p. 222 and p. 217]
Kropotkin, likewise, took it as a given that _"a society in which the workers
would have a dominant voice"_ would require a revolution to create and _"each
time that such a period of accelerated evolution and reconstruction on a grand
scale begins, civil war is liable to break out on a small or large scale."_
The question was _"how to attain the greatest results with the most limited
amount of civil war, the smallest number of victims, and a minimum of mutual
embitterment."_ To achieve this there was _"only one means; namely, that the
oppressed part of society should obtain the clearest possible conception of
what they intend to achieve, and how, and that they should be imbued with the
enthusiasm which is necessary for that achievement."_ Thus, _"there are
periods in human development when a conflict is unavoidable, and civil war
breaks out quite independently of the will of particular individuals."_ [
**Memiors of a Revolutionist** , pp. 270-1]

So Durruti, while fighting at the front during the Spanish revolution, was not
saying anything new or against anarchist theory when he stated that _"the
bourgeois won't let us create a libertarian communist society simply because
we want to. They'll fight back and defend their privileges. The only way we
can establish libertarian communism is by destroying the bourgeoisie"_ [quoted
by Abel Paz, **Durruti in the Spanish Revolution** , p. 484] Clearly,
anarchism has always recognised the necessity of defending a revolution and
proposed ideas to ensure it (ideas applied with great success by, for example,
the Makhnovists in the Ukrainian Revolution and the CNT militias during the
Spanish). As such, any assertion that anarchism rejects the necessity of
defending a revolution is simply false. Sadly, it is one Marxists make
repeatedly (undoubtedly inspired by Engels similar distortions - see [section
H.4.7](secH4.md#sech47)).

Which, of course, brings us to the second assertion, namely that any attempt
to defend a revolution means that a state has been created (regardless of what
it may be called). For anarchists, such an argument simply shows that Marxists
do not really understand what a state is. While the Trotskyist definition of a
_"state"_ may be (to quote **Workers' Power** ) _"an apparatus designed to
enable one class to rule another,"_ the anarchist definition is somewhat
different. Anarchists, of course, do not deny that the modern state is (to use
Malatesta's excellent expression) _"the bourgeoisie's servant and
**gendarme**."_ [ **Anarchy** , p. 23] However, as we discuss in [section
H.3.7](secH3.md#sech37), the Marxist analysis is superficial and
fundamentally metaphysical rather than scientific. Anarchists take an
evolutionary perspective on the state and, as a result, argue that every state
that has ever existed has defended the power of a minority class and,
unsurprisingly, has developed certain features to facilitate this. The key one
is centralisation of power. This ensures that the working people are excluded
from the decision making process and power remains a tool of the ruling class.
As such, the centralisation of power (while it may take many forms) is the key
means by which a class system is maintained and, therefore, a key aspect of a
state.

As Kropotkin put it, the State idea _"includes the existence of a power
situated above society"_ as well as _"a **territorial concentration** as well
as the concentration of many functions of the life of societies in the hands
of a few."_ It _"implies some new relationships between members of society . .
. in order to subject some classes to the domination of others"_ and this
becomes obvious _"when one studies the origins of the State."_ [ **The State:
Its Historic Role** , p. 10] This was the case with representative democracy:

> _"To attack the central power, to strip it of its prerogatives, to
> decentralise, to dissolve authority, would have been to abandon to the
> people the control of its affairs, to run the risk of a truly popular
> revolution. That is why the bourgeoisie sought to reinforce the central
> government even more."_ [Kropotkin, **Words of a Rebel** , p. 143]

This meant, Kropotkin continued, that the _"representative system was
organised by the bourgeoisie to ensure their domination, and it will disappear
with them. For the new economic phase that is about to begin we must seek a
new form of political organisation, based on a principle quite different from
that of representation. The logic of events imposes it."_ [ **Op. Cit.** , p.
125] This suggests that the Marxist notion that we can use a state (i.e., any
centralised and hierarchical social structure) to organise and defend a social
revolution is based on flawed reasoning in which it _"seems to be taken for
granted that Capitalism and the workers' movement both have the same end in
view. If this were so, they might perhaps use the same means; but as the
capitalist is out to perfect his system of exploitation and government, whilst
the worker is out for emancipation and liberty, naturally the same means
cannot be employed for both purposes."_ [George Barrett, **Objections to
Anarchism** , p. 343]

To reproduce in the new society social structures which share the same
characteristics (such as centralisation and delegation of power) which mark
the institutions of class society would be a false step, one which can only
recreate a new form of class system in which a new ruling elite govern and
exploit the many. So while we agree with Marxists that the main function of
the state is to defend class society, we also stress the structure of the
state has evolved to execute that role. In the words of Rudolf Rocker:

> _"social institutions . . . do not arise arbitrarily, but are called into
> being by special needs to serve definite purposes . . . The newly arisen
> possessing classes had need of a political instrument of power to maintain
> their economic and social privileges over the masses of their own people . .
> . Thus arose the appropriate social conditions for the evolution of the
> modern state, as the organ of political power of privileged castes and
> classes for the forcible subjugation and oppression of the non-possessing
> classes . . . Its external forms have altered in the course of its
> historical development, but its functions have always been the same . . .
> And just as the functions of the bodily organs of . . . animals cannot be
> arbitrarily altered, so that, for example, one cannot at will hear with his
> eyes and see with his ears, so also one cannot at pleasure transform an
> organ of social oppression into an instrument for the liberation of the
> oppressed. The state can only be what it is: the defender of mass-
> exploitation and social privileges, and creator of privileged classes."_ [
> **Anarcho-Syndicalism** , pp. 14-5]

As such, a new form of society, one based on the participation of all in the
affairs of society (and a classless society can be nothing else) means the end
of the state. This is because it has been designed to **exclude** the
participation a classless society needs in order to exist. In anarchist eyes,
it is an abuse of the language to call the self-managed organisations by which
the former working class manage (and defend) a free society a state.

However, as **Workers Power** indicate, it could be objected that the
anarchist vision of a federation of communal and workplace assemblies and
volunteer militias to defend it is simply a new form of state. In other words,
that the anarchists advocate what most people (including most Marxists) would
call a state as this federal system is based on social organisation,
collective decision making and (ultimately) the armed people. This was the
position of Marx and Engels, who asserted against Bakunin that _"to call this
machine a 'revolutionary Commune organised from the bottom to top' makes
little difference. The name changes nothing of the substance"_ for to be able
to do anything at all the communal councils _"must be vested with some power
and supported by a public force."_ [ **Collected Works** , vol. 23, p. 469]

Anarchists reject this argument. To quote Daniel Guérin, initially anarchists
used terms like the state or revolutionary state as a synonym for _"social
collective"_ but _"soon saw, however, that it was rather dangerous for them to
use the same word as the authoritarians while giving it a quite different
meaning. They felt that a new concept called for a new word and that the use
of the old term could be dangerously ambiguous; so they ceased to give the
name 'State' to the social collective of the future."_ [ **Anarchism** , pp.
60-1] This is more than mere labels or semantics as it gets to the heart of
the difference between libertarian and authoritarian conceptions of society
and social change. Anarchists argue that the state is structured to ensure
minority rule and, consequently, a "workers' state" would be a new form of
minority rule over the workers. For this reason we argue that working class
self-management from the bottom-up cannot be confused with a "state." The
Russian Revolution showed the validity of this, with the Bolsheviks calling
their dictatorship a "workers' state" in spite of the workers having no power
in it.

Anarchists have long pointed out that government is not the same as collective
decision making and to call the bottom-up communal system anarchists aim for a
"state" when its role is to promote and ensure mass participation in social
life is nonsense. That Marxists are vaguely aware of this obvious fact
explains why they often talk of a "semi-state", a "new kind of state", a state
"unique in history," or use some other expression to describe their post-
revolutionary system. This would be a state (to use Engels words) which is
_"no longer a state in the proper sense of the word."_ [quoted by Lenin, **Op.
Cit.** , p. 319] If that **is** the case, then why call it state?

Somewhat ironically, Engels provided more than enough support for the
anarchist position. It is perfectly possible to have social organisation and
it **not** be a state. When discussing the Native American Iroquois
Confederacy, Engels noted that _"organ of the Confederacy was a Federal
Council"_ which was _"elected . . . and could always be removed"_ by popular
assemblies. There was _"no chief executive"_ but _"two supreme war chiefs"_
and _"[w]hen war broke out it was carried on mainly by volunteers."_ Yet this
was _"the organisation of a society which as yet knows no **state**."_ [
**Selected Works** , p. 517, p. 518 and p. 516] In the anarchist commune there
is a federal council elected and mandated by popular assemblies. These, in
turn, are federated in a similar bottom-up manner. The means of production
have been expropriated and held by society as a whole and so classes have been
abolished. Volunteer militias have been organised for self-defence against
counter-revolutionary attempts to subject the free people to authority. Why is
this **not** a society which _"knows no **state** "_? Is it because the
anarchist commune is fighting against the capitalist class? If so, does this
mean that the Iroquois Confederacy became a state when it waged war against
those seeking to impose bourgeois rule on it? That is doubtful and so Marx's
assertion is simply wrong and reflects both the confusion at the heart of the
Marxist theory of the state and the illogical depths Marxists sink to when
attacking anarchism.

This not a matter of mere "labels" as Marxists assert, but rather gets to the
key issue of who has the real power in a revolution - the people armed or a
new minority (the "revolutionary" government). In other words, most Marxists
cannot tell the difference between libertarian organisation (power to the base
and decision making from the bottom-up) and the state (centralised power in a
few hands and top-down decision making). Which helps explain why the Bolshevik
revolution was such a failure. The confusion of working class power with party
power is one of the root problems with Marxism. So why do most Marxists tend
to call their post-revolutionary organisation a state? Simply because, at some
level, they recognise that, in reality, the working class does not wield power
in the so-called "workers' state": the party does. This was the case in
Russia. The working class never wielded power under the Bolsheviks and here is
the most obvious contradiction in the Marxist theory of the state - a
contradiction which, as we discuss in [section H.3.8](secH3.md#sech38) the
Leninists solved by arguing that the party had to assert its power **over**
the working class for its own good.

Moreover, as we discuss in [section H.3.9](secH3.md#sech39), it is both
simplistic and wrong to argue that the state is simply the tool of economic
classes. The state is a source of social inequality in and of itself and,
consequently, can oppress and exploit the working class just as much as, and
independently of, any economically dominant class:

> _" **All political power inevitably creates a privileged situation** for the
> men who exercise it. Thus it violates, from the beginning, the equalitarian
> principle and strikes at the heart of the Social Revolution . . . [It]
> inevitably becomes a source of other privileges, even if it does not depend
> on the bourgeoisie. Having taken over the Revolution, having mastered it,
> and bridled it, **power is compelled to create a bureaucratic apparatus** ,
> indispensable to all authority which wants to maintain itself, to command,
> to order - in a word, 'to govern'. Rapidly, it attracts around itself all
> sorts of elements eager to dominate and exploit. _

> _" **Thus it forms a new privileged caste** , at first politically and later
> economically . . . It sows everywhere the seed of inequality and soon
> infects the whole social organism."_ [Voline, **The Unknown Revolution** ,
> p. 249]

So if it **were** simply a question of consolidating a revolution and its
self-defence then there would be no argument:

> _"But perhaps the truth is simply this: . . . [some] take the expression
> 'dictatorship of the proletariat' to mean simply the revolutionary action of
> the workers in taking possession of the land and the instruments of labour,
> and trying to build a society and organise a way of life in which there will
> be no place for a class that exploits and oppresses the producers._

> _"Thus constructed, the 'dictatorship of the proletariat' would be the
> effective power of all workers trying to bring down capitalist society and
> would thus turn into Anarchy as soon as resistance from reactionaries would
> have ceased and no one can any longer seek to compel the masses by violence
> to obey and work for him. In which case, the discrepancy between us would be
> nothing more than a question of semantics. Dictatorship of the proletariat
> would signify the dictatorship of everyone, which is to say, it would be a
> dictatorship no longer, just as government by everybody is no longer a
> government in the authoritarian, historical and practical sense of the
> word._

> _"But the real supporters of 'dictatorship of the proletariat' do not take
> that line, as they are making quite plain in Russia. Of course, the
> proletariat has a hand in this, just as the people has a part to play in
> democratic regimes, that is to say, to conceal the reality of things. In
> reality, what we have is the dictatorship of one party, or rather, of one
> party's leaders: a genuine dictatorship, with its decrees, its penal
> sanctions, its henchmen and above all its armed forces, which are at present
> [1919] also deployed in the defence of the revolution against its external
> enemies, but which will tomorrow be used to impose the dictator's will upon
> the workers, to apply a break on revolution, to consolidate the new
> interests in the process of emerging and protect a new privileged class
> against the masses."_ [Malatesta, **No Gods, No Masters** , vol. 2, pp.
> 38-9]

The question is, therefore, one of **who** _"seizes power"_ \- will it be the
mass of the population or will it be a party claiming to represent it. The
difference is vital and it confuses the issue to use the same word "state" to
describe two such fundamentally different structures as a "bottom-up" self-
managed communal federation and a "top-down" hierarchical centralised
organisation (such as has been every state that has existed). This explains
why anarchists reject the idea of a _"democratic workers' state"_ as the means
by which a revolution defends itself. Rather than signify working class power
or management of society, it signifies the opposite - the seizure of power of
a minority (in this case, the leaders of the vanguard party).

Anarchists argue that the state is designed to exclude the mass of the
population from the decision making process. This, ironically for Trotskyism,
was one of the reasons why leading Bolsheviks (including Lenin and Trotsky)
argued for a workers state. The centralisation of power implied by the state
was essential so that the vanguard party could ignore (to use **Worker's
Power** 's phrase) _"the will of the majority."_ This particular perspective
was clearly a lesson they learned from their experiences during the Russian
Revolution - as we discussed in [section H.1.2](secH1.md#sech12) the notion
that the _"dictatorship of the proletariat"_ was, in fact, the _"dictatorship
of the party"_ was a commonplace ideological truism in Leninist circles. As
anarchists had warned, it was a dictatorship **over** the proletariat and
acknowledged as such by the likes of Lenin and Trotsky.

Needless to say, **Workers' Power** (like most Trotskyists) blame the
degeneration of the Russian revolution on the Civil War and its isolation.
However, the creation of a party dictatorship was not seen in these terms and,
moreover, as we discuss in detail in [section H.6](secH6.md) the Bolshevik
undermining of working class autonomy and democracy started well **before**
the outbreak of civil war, thus confirming anarchist theory. These conclusions
of leading Leninists simply justified the actions undertaken by the Bolsheviks
from the start.

This is why anarchists reject the idea of a _"democratic workers' state."_
Simply put, as far as it is a state, it cannot be democratic and in as far as
it is democratic, it cannot be a state. The Leninist idea of a _"workers'
state"_ means, in fact, the seizure of power by the party. This, we must
stress, naturally follows from the reality of the state. It is designed for
minority rule and excludes, by its very nature, mass participation and this
aspect of the state was one which the leading lights of Bolshevism agreed
with. Little wonder, then, that in practice the Bolshevik regime suppressed of
any form of democracy which hindered the power of the party. Maurice Brinton
summed up the issue well when he argued that _"'workers' power' cannot be
identified or equated with the power of the Party - as it repeatedly was by
the Bolsheviks . . . What 'taking power' really implies is that the vast
majority of the working class at last realises its ability to manage both
production and society - and organises to this end."_ [ **The Bolsheviks and
Workers' Control** , p. xiv]

In summary, therefore, anarchists reject the idea that the defence of a
revolution can be conducted by a state. As Bakunin once put it, there is the
_"Republic-State"_ and there is _"the system of the Republic-Commune, the
Republic-Federation, i.e. the system of **Anarchism.** This is the politics of
the Social Revolution, which aims at the abolition of the **State** and
establishment of the economic, entirely free organisation of the people -
organisation from bottom to top by means of federation."_ [ **The Political
Philosophy of Bakunin** , p. 314] Indeed, creating a new state will simply
destroy the most important gain of any revolution - working class autonomy -
and its replacement by another form of minority rule (by the party).
Anarchists have always argued that the defence of a revolution must not be
confused with the state and so argue for the abolition of the state **and**
the defence of a revolution. Only when working class people actually run
society themselves will a revolution be successful. For anarchists, this means
that _"effective emancipation can be achieved only by the **direct,
widespread, and independent action** . . . **of the workers themselves** ,
grouped . . . in their own class organisations . . . on the basis of concrete
action and self-government, **helped but not governed** , by revolutionaries
working in the very midst of, and not above the mass and the professional,
technical, defence and other branches."_ [Voline, **Op. Cit.** , p. 197]

This means that anarchists argue that the state cannot be transformed or
adjusted, but has to be smashed by a social revolution and replaced with
organisations and structures created by working class people during their own
struggles (see [section H.1.4](secH1.md#sech14) for details). Anarchist
opposition to the so-called workers' state has absolutely **nothing** to do
with the issue of defending a revolution, regardless of what Marxists assert.

## H.2.2 Do anarchists reject _"class conflict"_ and _"collective struggle"_?

Of course not. Anarchists have always taken a keen interest in the class
struggle, in the organisation, solidarity and actions of working class people.
Anarchist Nicholas Walter summarised the obvious and is worth quoting at
length:

> _"Virtually all forms of revolutionary socialism during the nineteenth
> century, whether authoritarian or libertarian, were based on the concept of
> class struggle . . . The term anarchist was first adopted by Pierre-Joseph
> Proudhon in 1840, and although he disliked the class struggle, he recognised
> it existed, and took sides in it when he had to . . . during the French
> Revolution of 1848, he insisted that he was on the side of the proletariat
> against the bourgeoisie . . . his last book was a positive study of the need
> for specifically proletarian politics . . ._

> _"The actual anarchist movement was founded later, by the anti-authoritarian
> sections of the First International . . . They accepted [its] founding
> Address . . ., drafted by Karl Marx, which assumed the primacy of the class
> struggle and insisted that 'the emancipation of the working classes must be
> conquered by the working classes themselves'; they accepted the Programme of
> the International Alliance of Social Democracy (1869), drafted by Michael
> Bakunin, which assumed the primacy of the class struggle . . . and they
> accepted the declaration of the St. Imier Congress which assumed the primacy
> of the class struggle and insisted that 'rejecting all compromise to arrive
> at the accomplishment of the social revolution, the proletarians of all
> countries must establish, outside all bourgeois politics, the solidarity of
> revolutionary action' . . . This was certainly the first anarchist movement,
> and this movement was certainly based on a libertarian version of the
> concept of the class struggle._

> _"Most of the leaders of this movement - first Michael Bakunin, James
> Guillaume, Errico Malatesta, Carlo Caliero, later Peter Kropotkin, Louise
> Michel, Emile Pouget, Jean Grave, and so on - took for granted that there
> was a struggle between the proletariat and the bourgeoisie and that the
> social revolution would be conducted by the former against the latter. They
> derived such ideas . . . from the traditional theory of revolutionary
> socialism and the traditional practice of working-class action . . ._

> _"The great revolutions of the early twentieth century - in Mexico, Russia,
> Spain - all derived from the class struggle and all involved anarchist
> intervention on the side of the working class. The great martyrs of the
> anarchist movement - from Haymarket in 1887 through Francisco Ferrer in 1909
> to Sacco and Vanzetti in 1927 - were killed in the class struggle. The great
> partisans of anarchist warfare - from Emiliano Zapata through Nestor Makhno
> to Buenaventura Durruti - were all fighting in the class struggle._

> _"So . . . class struggle in anarchism . . . [and] its importance in the
> anarchist movement is incontrovertible."_ [ **The Anarchist Past and other
> essays** , pp. 60-2]

Anyone even remotely aware of anarchism and its history could not fail to
notice that class struggle plays a key role in anarchist theory, particularly
(but not exclusively) in its revolutionary form. To assert otherwise is simply
to lie about anarchism. Sadly, Marxists have been known to make such an
assertion.

For example, Pat Stack of the British SWP argued that anarchists _"dismiss . .
. the importance of the collective nature of change"_ and so _"downplays the
centrality of the working class"_ in the revolutionary process. This, he
argues, means that for anarchism the working class _"is not the key to
change."_ He stresses that for Proudhon, Bakunin and Kropotkin _"revolutions
were not about . . . collective struggle or advance"_ and that anarchism
_"despises the collectivity."_ Amazingly he argues that for Kropotkin, _"far
from seeing class conflict as the dynamic for social change as Marx did, saw
co-operation being at the root of the social process."_ Therefore, _"[i]t
follows that if class conflict is not the motor of change, the working class
is not the agent and collective struggle not the means. Therefore everything
from riot to bomb, and all that might become between the two, was legitimate
when ranged against the state, each with equal merit."_ [ _"Anarchy in the
UK?"_ , **Socialist Review** , no. 246] Needless to say, he makes the usual
exception for anarcho-syndicalists, thereby showing his total ignorance of
anarchism **and** syndicalism (see [section H.2.8](secH2.md#sech28)).

Assertions like these are simply incredible. It is hard to believe that anyone
who is a leading member of a Leninist party could write such nonsense which
suggests that Stack is aware of the truth and simply decides to ignore it. All
in all, it is **very** easy to refute these assertions. All we have to do is,
unlike Stack, to quote from the works of Bakunin, Kropotkin and other
anarchists. Even the briefest familiarity with the writings of revolutionary
anarchism would soon convince the reader that Stack really does not know what
he is talking about.

Take, for example, Bakunin. Rather than reject class conflict, collective
struggle or the key role of the working class, Bakunin based his political
ideas on all three. As he put it, there was, _"between the proletariat and the
bourgeoisie, an irreconcilable antagonism which results inevitably from their
respective stations in life."_ He stressed that _"war between the proletariat
and the bourgeoisie is unavoidable"_ and would only end with the _"abolition
of the bourgeoisie as a distinct class."_ In order for the worker to _"become
strong"_ he _"must unite"_ with other workers in _"the union of all local and
national workers' associations into a world-wide association, **the great
International Working-Men's Association.** "_ It was only _"through practice
and collective experience"_ and _"the progressive expansion and development of
the economic struggle [that] will bring [the worker] more to recognise his [or
her] true enemies: the privileged classes, including the clergy, the
bourgeoisie, and the nobility; and the State, which exists only to safeguard
all the privileges of those classes."_ There was _"but a single path, that of
**emancipation through practical action** "_ which _"has only one meaning. It
means workers' solidarity in their struggle against the bosses. It means
**trades-unions, organisation, and the federation of resistance funds.** "_
Then, _"when the revolution - brought about by the force of circumstances -
breaks out, the International will be a real force and know what it has to
do"_ , namely to _"take the revolution into its own hands"_ and become _"an
earnest international organisation of workers' associations from all
countries"_ which will be _"capable of replacing this departing political
world of States and bourgeoisie."_ [ **The Basic Bakunin** , pp. 97-8, p. 103
and p. 110]

Hardly the words of a man who rejected class conflict, the working class and
the collective nature of change! Nor is this an isolated argument from
Bakunin, it recurs continuously throughout Bakunin's works. For Bakunin, the
_"initiative in the new movement will belong to the people . . . in Western
Europe, to the city and factory workers - in Russia, Poland, and most of the
Slavic countries, to the peasants."_ However, _"in order that the peasants
rise up, it is absolutely necessary that the initiative in this revolutionary
movement be taken up by the city workers . . . who combine in themselves the
instincts, ideas, and conscious will of the Social Revolution."_ [ **The
Political Philosophy of Bakunin** , p. 375] Similarly, he argued that
_"equality"_ was the _"aim"_ of the International Workers' Association and
_"the organisation of the working class its strength, the unification of the
proletariat the world over . . . its weapon, its only policy."_ He stressed
that _"to create a people's force capable of crushing the military and civil
force of the State, it is necessary to organise the proletariat."_ [quoted by
K.J. Kenafick, **Michael Bakunin and Karl Marx** , p. 95 and p. 254]

Strikes played a very important role in Bakunin's ideas (as they do in all
revolutionary anarchist thought). He saw the strike as _"the beginnings of the
social war of the proletariat against the bourgeoisie . . . Strikes are a
valuable instrument from two points of view. Firstly, they electrify the
masses . . . awaken in them the feeling of the deep antagonism which exists
between their interests and those of the bourgeoisie . . . secondly they help
immensely to provoke and establish between the workers of all trades,
localities and countries the consciousness and very fact of solidarity: a
twofold action, both negative and positive, which tends to constitute directly
the new world of the proletariat, opposing it almost in an absolute way to the
bourgeois world."_ [quoted by Caroline Cahm, **Kropotkin and the Rise of
Revolutionary Anarchism 1872-1886** , pp. 216-217] For Bakunin, strikes train
workers for social revolution as they _"create, organise, and form a workers'
army, an army which is bound to break down the power of the bourgeoisie and
the State, and lay the ground for a new world."_ [ **The Political Philosophy
of Bakunin** , pp. 384-5]

The revolution would be _"an insurrection of all the people and the voluntary
organisation of the workers from below upward."_ [ **Statism and Anarchy** ,
p. 179] As we argue in [section I.2.3](secI2.md#seci23), the very process of
collective class struggle would, for Bakunin and other anarchists, create the
basis of a free society. Thus, in Bakunin's eyes, the _"future social
organisation must be made solely from the bottom upwards, by the free
association or federation of workers, firstly in their unions, then in the
communes, regions, nations and finally in a great federation, international
and universal."_ [ **Michael Bakunin: Selected Writings** , p. 206]

In other words, the basic structure created by the revolution would be based
on the working classes own combat organisations, as created in their struggles
against oppression and exploitation. The link between present and future would
be labour unions (workers' associations), which played the key role of both
the means to abolish capitalism and the state and as the framework of a
socialist society. For Bakunin, the _"very essence of socialism"_ lies in
_"the irrepressible conflict between the workers and the exploiters of
labour."_ A _"living, powerful, socialist movement"_ can _"be made a reality
only by the awakened revolutionary consciousness, the collective will, and the
organisation of the working masses themselves."_ [ **Bakunin on Anarchism** ,
p. 191 and p. 212] Therefore, it was essential to _"[o]rganise always more and
more the practical militant international solidarity of the toilers of all
trades and of all countries, and remember . . . you will find an immense, an
irresistible force in this universal collectivity."_ Hence Bakunin's support
for self-discipline within self-managed organisations, which came directly
from the his awareness of the **collective** nature of social change: _"Today,
in revolutionary action as in labour itself, collectivism must replace
individualism. Understand clearly that in organising yourselves you will be
stronger than all the political leaders in the world."_ [quoted by Kenafick,
**Op. Cit.** , p. 291 and p. 244]

All of which is quite impressive for someone who was a founding father of a
theory which, according to Stack, downplayed the _"centrality of the working
class,"_ argued that the working class was _"not the key to change,"_
dismissed _"the importance of the collective nature of change"_ as well as
_"collective struggle or advance"_ and _"despises the collectivity"_! Clearly,
to argue that Bakunin held any of these views simply shows that the person
making such statements does not have a clue what they are talking about.

The same, needless to say, applies to all revolutionary anarchists. Kropotkin
built upon Bakunin's arguments and, like him, based his politics on collective
working class struggle and organisation. He consistently stressed that _"the
Anarchists have always advised taking an active part in those workers'
organisations which carry on the **direct** struggle of Labour against Capital
and its protector - the State."_ Such struggle, _"better than any other
indirect means, permits the worker to obtain some temporary improvements in
the present conditions of work, while it opens his eyes to the evil done by
Capitalism and the State that supports it, and wakes up his thoughts
concerning the possibility of organising consumption, production, and exchange
without the intervention of the capitalist and the State."_ [ **Evolution and
Environment** , pp. 82-3] In his article on _"Anarchism"_ for the
**Encyclopaedia Britannica** , Kropotkin stressed that anarchists _"have
endeavoured to promote their ideas directly amongst the labour organisations
and to induce those unions to a direct struggle against capital, without
placing their faith in parliamentary legislation."_ [ **Anarchism** , p. 287]

Far from denying the importance of collective class struggle, he actually
stressed it again and again. As he once wrote, _"to make the revolution, the
mass of workers will have to organise themselves. Resistance and the strike
are excellent means of organisation for doing this."_ He argued that it was
_"a question of organising societies of resistance for all trades in each
town, of creating resistance funds against the exploiters, of giving more
solidarity to the workers' organisations of each town and of putting them in
contact with those of other towns, of federating them . . . Workers'
solidarity must no longer be an empty word but practised each day between all
trades and all nations."_ [quoted by Cahm, **Op. Cit.** , pp. 255-6]

As can be seen, Kropotkin was well aware of the importance of popular, mass,
struggles. As he put it, anarchists _"know very well that any popular movement
is a step towards the social revolution. It awakens the spirit of revolt, it
makes men [and women] accustomed to seeing the established order (or rather
the established disorder) as eminently unstable."_ [ **Words of a Rebel** , p.
203] As regards the social revolution, he argues that _"a decisive blow will
have to be administered to private property: from the beginning, the workers
will have to proceed to take over all social wealth so as to put it into
common ownership. This revolution can only be carried out by the workers
themselves."_ In order to do this, the masses have to build their own
organisation as the _"great mass of workers will not only have to constitute
itself outside the bourgeoisie . . . it will have to take action of its own
during the period which will precede the revolution . . . and this sort of
action can only be carried out when a strong **workers' organisation**
exists."_ This meant, of course, it was _"the mass of workers we have to seek
to organise. We . . . have to submerge ourselves in the organisation of the
people . . . When the mass of workers is organised and we are with it to
strengthen its revolutionary idea, to make the spirit of revolt against
capital germinate there . . . then it will be the social revolution."_ [quoted
by Caroline Cahm, **Op. Cit.** , pp. 153-4]

He saw the class struggle in terms of _"a multitude of acts of revolt in all
countries, under all possible conditions: first, individual revolt against
capital and State; then collective revolt - strikes and working-class
insurrections - both preparing, in men's minds as in actions, a revolt of the
masses, a revolution."_ Clearly, the mass, collective nature of social change
was not lost on Kropotkin who pointed to a _"multitude of risings of working
masses and peasants"_ as a positive sign. Strikes, he argued, _"were once 'a
war of folded arms'"_ but now were _"easily turning to revolt, and sometimes
taking the proportions of vast insurrections."_ [ **Anarchism** , p. 144]

Kropotkin could not have been clearer. Somewhat ironically, given Stack's
assertions, Kropotkin explicitly opposed the Marxism of his time (Social
Democracy) precisely **because** it had _"moved away from a pure labour
movement, in the sense of a direct struggle against capitalists by means of
strikes, unions, and so forth."_ The Marxists, he stated, opposed strikes and
unions because they _"diverted forces from electoral agitation"_ while
anarchists _"reject[ed] a narrowly political struggle [and] inevitably became
a more revolutionary party, both in theory and in practice."_ [ **The Conquest
of Bread and Other Writings** , pp. 207-8, p. 208 and p. 209]

And Pat Stack argues that Kropotkin did not see _"class conflict as the
dynamic for social change,"_ nor _"class conflict"_ as _"the motor of change"_
and the working class _"not the agent and collective struggle not the means"_!
Truly incredible and a total and utter distortion of Kropotkin's ideas on the
subject.

As for other anarchists, we discover the same concern over class conflict,
collective struggle and organisation and the awareness of a mass social
revolution by the working class. Emma Goldman, for example, argued that
anarchism _"stands for direct action"_ and that _"[t]rade unionism, the
economic arena of the modern gladiator, owes its existence to direct action .
. . In France, in Spain, in Italy, in Russia, nay even in England (witness the
growing rebellion of English labour unions), direct, revolutionary economic
action has become so strong a force in the battle for industrial liberty as to
make the world realise the tremendous importance of labour's power. The
General Strike [is] the supreme expression of the economic consciousness of
the workers . . . Today every great strike, in order to win, must realise the
importance of the solidaric general protest."_ [ **Anarchism and Other
Essays** , pp. 65-6] She placed collective class struggle at the centre of her
ideas and, crucially, she saw it as the way to create an anarchist society:

> _"It is this war of classes that we must concentrate upon, and in that
> connection the war against false values, against evil institutions, against
> all social atrocities. Those who appreciate the urgent need of co-operating
> in great struggles . . . must organise the preparedness of the masses for
> the overthrow of both capitalism and the state. Industrial and economic
> preparedness is what the workers need. That alone leads to revolution at the
> bottom . . . That alone will give the people the means to take their
> children out of the slums, out of the sweat shops and the cotton mills . . .
> That alone leads to economic and social freedom, and does away with all
> wars, all crimes, and all injustice."_ [ **Red Emma Speaks** , pp. 355-6]

For Malatesta, _"the most powerful force for social transformation is the
working class movement . . . Through the organisations established for the
defence of their interests, workers acquire an awareness of the oppression
under which they live and of the antagonisms which divide them from their
employers, and so begin to aspire to a better life, get used to collective
struggle and to solidarity."_ This meant that anarchists _"must recognise the
usefulness and importance of the workers' movement, must favour its
development, and make it one of the levers of their action, doing all they can
so that it . . . will culminate in a social revolution."_ Anarchists must
_"deepen the chasm between capitalists and wage-slaves, between rulers and
ruled; preach expropriation of private property and the destruction of
State."_ The new society would be organised _"by means of free association and
federations of producers and consumers."_ [ **Errico Malatesta: His Life and
Ideas** , p. 113, pp. 250-1 and p. 184] Alexander Berkman, unsurprisingly,
argued the same thing. As he put it, only _"the workers"_ as _"the worst
victims of present institutions,"_ could abolish capitalism an the state as
_"it is to their own interest to abolish them . . . labour's emancipation
means at the same time the redemption of the whole of society."_ He stressed
that _" **only the right organisation of the workers** can accomplish what we
are striving for . . . Organisation from the bottom up, beginning with the
shop and factory, on the foundation of the joint interests of the workers
everywhere . . . alone can solve the labour question and serve the true
emancipation of man[kind]."_ [ **What is Anarchism?** , p. 187 and p. 207]

As can be seen, the claim that Kropotkin or Bakunin, or anarchists in general,
ignored the class struggle and collective working class struggle and
organisation is either a lie or indicates ignorance. Clearly, anarchists have
placed working class struggle, organisation and collective direct action and
solidarity at the core of their politics (and as the means of creating a
libertarian socialist society) from the start. Moreover, this perspective is
reflected in the anarchist flag itself as we discuss in our [appendix on the
symbols of anarchism](append2.md). According to Louise Michel the _"black
flag is the flag of strikes."_ [ **The Red Virgin: Memoirs of Louise Michel**
, p. 168] If anarchism does, as some Marxists assert, reject class conflict
and collective struggle then using a flag associated with an action which
expresses both seems somewhat paradoxical. However, for those with even a
basic understanding of anarchism and its history there is no paradox as
anarchism is obviously based on class conflict and collective struggle.

Also see [section H.2.8](secH2.md#sech28) for a discussion of the
relationship of anarchism to syndicalism.

## H.2.3 Does anarchism yearn _"for what has gone before"_?

Leninist Pat Stack states that one of the _"key points of divergence"_ between
anarchism and Marxism is that the former, _"far from understanding the
advances that capitalism represented, tended to take a wistful look back.
Anarchism shares with Marxism an abhorrence of the horrors of capitalism, but
yearns for what has gone before."_ [ _"Anarchy in the UK?"_ , **Socialist
Review** , no. 246]

Like his other _"key point"_ (namely the rejection of class struggle - see
[last section](secH2.md#sech22)), Stack is simply wrong. Even the quickest
look at the works of Proudhon, Bakunin and Kropotkin would convince the reader
that this is simply distortion. Rather than look backwards for our ideas of
social life, anarchists have always been careful to base our ideas on the
current state of society and what anarchist thinkers considered positive
current trends within it.

The dual element of progress is important to remember. Capitalism is a class
society, marked by exploitation, oppression and various social hierarchies. In
such a society progress can hardly be neutral. It will reflect vested
interests, the needs of those in power, the rationales of the economic system
(e.g. the drive for profits) and those who benefit from it, the differences in
power between states and companies and so on. Equally, it will be shaped by
the class struggle, the resistance of the working classes to exploitation and
oppression, the objective needs of production, etc. As such, trends in society
will reflect the various class conflicts, social hierarchies, power
relationships and so on which exist within it.

This is particularly true of the economy. The development of the industrial
structure of a capitalist economy will be based on the fundamental need to
maximise the profits and power of the capitalists. As such, it will develop
(either by market forces or by state intervention) in order to ensure this.
This means that various tendencies apparent in capitalist society exist
specifically to aid the development of capital. It does not follow that
because a society which places profits above people has found a specific way
of organising production "efficient" that a socialist society will do so. As
such, anarchist opposition to specific tendencies within capitalism (such as
the increased concentration and centralisation of companies) does not mean a
_"yearning"_ for the past. Rather, it shows an awareness that capitalist
methods are precisely that and that they need not be suited for a society
which replaces the profit system with human and ecological need as the
criteria for decision making.

For anarchists, this means questioning the assumptions of capitalist progress
and so the first task of a revolution after the expropriation of the
capitalists and the destruction of the state will be to transform the
industrial structure and how it operates, not keep it as it is. Anarchists
have long argued that capitalist methods cannot be used for socialist ends. In
our battle to democratise and socialise the workplace, in our awareness of the
importance of collective initiatives by the direct producers in transforming
their work situation, we show that factories are not merely sites of
production, but also of reproduction - the reproduction of a certain structure
of social relations based on the division between those who give orders and
those who take them. Moreover, the structure of industry has developed to
maximise profits. Why assume that this structure will be equally as efficient
in producing useful products by meaningful work which does not harm the
environment, society or those who do the actual tasks? A further aspect of
this is that many of the struggles today, from the Zapatistas in Chiapas to
those against Genetically Modified (GM) food and nuclear power are precisely
based on the understanding that capitalist "progress" can not be uncritically
accepted. To resist the expulsion of people from the land in the name of
progress or the introduction of terminator seeds is not to look back to _"what
had gone"_ , although this is also precisely what the proponents of capitalist
globalisation often accuse us of. Rather, it is to put **_"people before
profit."_**

That so many Marxists fail to understand this suggests that their ideology
subscribes to notions of "progress" which simply build upon capitalist ones.
As such, only a sophist would confuse a critical evaluation of trends within
capitalism with a yearning for the past. It means to buy into the whole
capitalist notion of "progress" which has always been part of justifying the
inhumanities of the status quo. Simply put, just because a process is rewarded
by the profit driven market it does not mean that it makes sense from a human
or ecological perspective. For example, as we argue in [section
J.5.11](secJ5.md#secj511), the capitalist market hinders the spread of co-
operatives and workers' self-management in spite of their well documented
higher efficiency and productivity. From the perspective of the needs of the
capitalists, this makes perfect sense. In terms of the workers and efficient
allocation and use of resources, it does not. Would Marxists argue that
because co-operatives and workers' self-management of production are marginal
aspects of the capitalist economy it means that they will play no part in a
sane society or that if a socialist expresses interest in them it means that
are _"yearning"_ for a past mode of production? We hope not.

This common Marxist failure to understand anarchist investigations of the
future is, ironically enough, joined with a total failure to understand the
social conditions in which anarchists have put forward their ideas. For all
his claims that anarchists ignore _"material conditions,"_ it is Pat Stack
(and others like him) who does so in his claims against Proudhon. Stack calls
the Frenchman _"the founder of modern anarchism"_ and states that Marx dubbed
Proudhon _"the socialist of the small peasant or master craftsman."_
Typically, Stack gets even this wrong as it was Engels who used those words,
although Marx would probably have not disagreed if he had been alive when they
were penned. [ **The Marx-Engels Reader** , p. 626] From this, Stack implies
that Proudhon was _"yearning for the past"_ when he advanced his mutualist
ideas.

Nothing, however, could be further from the truth. This is because the society
in which the French anarchist lived was predominately artisan and peasant in
nature. This was admitted by Marx and Engels in the **Communist Manifesto** (
_"[i]n countries like France"_ the peasants _"constitute far more than half of
the population."_ [ **Op. Cit.** , p. 493]). As such, for Proudhon to
incorporate the aspirations of the majority of the population is not to
_"yearn for what has gone before"_ but rather an extremely sensible position
to take. This suggests that for Engels to state that the French anarchist was
_"the socialist of the small peasant or master craftsman"_ was unsurprising, a
simple statement of fact, as the French working classes were, at the time,
predominately small peasants or master craftsmen (or artisans). It, in other
words, reflected the society Proudhon lived in and, as such, did not reflect
desires for the past but rather a wish to end exploitation and oppression
**now** rather than some unspecified time in the future.

Moreover, Proudhon's ideas cannot be limited to just that as Marxists try to
do. As K. Steven Vincent points out Proudhon's _"social theories may not be
reduced to a socialism for only the peasant class, nor was it a socialism only
for the petite bourgeois; it was a socialism of and for French workers. And in
the mid-nineteenth century . . . most French workers were still artisans."_
Indeed, _"[w]hile Marx was correct in predicting the eventual predominance of
the industrial proletariat vis-à-vis skilled workers, such predominance was
neither obvious nor a foregone conclusion in France during the nineteenth
century. The absolute number of small industries even increased during most of
the century."_ [ **Pierre-Joseph Proudhon and the Rise of French Republican
Socialism** , p. 5 and p. 282] Proudhon himself noted in 1851 that of a
population of 36 million, 24 million were peasants and 6 million were
artisans. Of the remaining 6 million, these included wage-workers for whom
_"workmen's associations"_ would be essential as _"a protest against the wage
system,"_ the _"denial of the rule of capitalists"_ and for _"the management
of large instruments of labour."_ [ **General Idea of the Revolution** , pp.
97-8]

To summarise, if the society in which you live is predominately made-up of
peasants and artisans then it is hardly an insult to be called _"the socialist
of the small peasant or master craftsman."_ Equally, it can hardly represent a
desire for _"what has gone before"_ to tailor your ideas to the actual
conditions in the country in which you live! And Stack accuses **anarchists**
of ignoring _"material conditions"_!

Neither can it be said that Proudhon ignored the development of
industrialisation in France during his lifetime. Quite the reverse, in fact,
as indicated above. Proudhon did **not** ignore the rise of large-scale
industry and argued that such industry should be managed by the workers'
themselves via workers associations. As he put it, _"certain industries"_
required _"the combined employment of a large number of workers"_ and so the
producer is _"a collectivity."_ In such industries _"we have no choice"_ and
so _"it is necessary to form an **association** among the workers"_ because
_"without that they would remain related as subordinates and superiors, and
there would ensue two industrial castes of masters and wage-workers, which is
repugnant to a free and democratic society."_ [ **Op. Cit.** , pp. 215-6] Even
Engels had to grudgingly admit that Proudhon supported _"the association of
workers"_ for _"large-industry and large establishments, such as railways."_ [
**Op. Cit.** , p. 626]

All in all, Stack is simply showing his ignorance of both Proudhon's ideas
**and** the society (the _"material conditions"_ ) in which they were shaped
and were aimed for. As can be seen, Proudhon incorporated the development of
large-scale industry within his mutualist ideas and so the need to abolish
wage labour by workers' associations and workers' control of production.
Perhaps Stack can fault Proudhon for seeking the end of capitalism too soon
and for not waiting patiently while it developed further (if he does, he will
also have to attack Marx, Lenin and Trotsky as well for the same failing!),
but this has little to do with _"yearn[ing] for what has gone before."_

After distorting Proudhon's ideas on industry, Stack does the same with
Bakunin. He asserts the following:

> _"Similarly, the Russian anarchist leader Bakunin argued that it was the
> progress of capitalism that represented the fundamental problem. For him
> industrialisation was an evil. He believed it had created a decadent western
> Europe, and therefore had held up the more primitive, less industrialised
> Slav regions as the hope for change."_

Now, it would be extremely interesting to find out where, exactly, Stack
discovered that Bakunin made these claims. After all, they are at such odds
with Bakunin's anarchist ideas that it is temping to conclude that Stack is
simply making it up. This, we suggest, explains the total lack of references
for such an outrageous claim. Looking at what appears to be his main source,
we discover Paul Avrich writing that _"[i]n 1848"_ (i.e. nearly 20 years
**before** Bakunin became an anarchist!) Bakunin _"spoke of the decadence of
Western Europe and saw hope in the primitive, less industrialised Slavs for
the regeneration of the Continent."_ [ **Anarchist Portraits** , p. 8] The
plagiarism is obvious, as are the distortions. Given that Bakunin became an
anarchist in the mid-1860s, how his pre-anarchist ideas are relevant to an
evaluation of anarchism escapes logic. It makes as much sense as quoting Marx
to refute fascism as Mussolini was originally the leader of the left-wing of
the Italian Socialist Party!

It is, of course, simple to refute Stack's claims. We need only do that which
he does not, namely quote Bakunin. For someone who thought _"industrialisation
was an evil,"_ a key aspect of Bakunin's ideas on social revolution was the
seizing of industry and its placing under social ownership. As he put it,
_"capital and all tools of labour belong to the city workers - to the workers
associations. The whole organisation of the future should be nothing but a
free federation of workers - agricultural workers as well as factory workers
and associations of craftsmen."_ [ **The Political Philosophy of Bakunin** ,
p. 410] Bakunin argued that _"to destroy . . . all the instruments of labour .
. . would be to condemn all humanity - which is infinity too numerous today to
exist . . . on the simple gifts of nature . . . - to . . . death by
starvation. Thus capital cannot and must not be destroyed. It must be
preserved."_ Only when workers _"obtain not individual but **collective**
property in capital"_ and when capital is no longer _"concentrated in the
hands of a separate, exploiting class"_ will they be able _"to smash the
tyranny of capital."_ [ **The Basic Bakunin** , pp. 90-1] He stressed that
only _"associated labour, this is labour organised upon the principles of
reciprocity and co-operation, is adequate to the task of maintaining the
existence of a large and somewhat civilised society."_ Moreover, the _"whole
secret of the boundless productivity of human labour consists first of all in
applying . . . scientifically developed reason . . . and then in the division
of that labour."_ [ **The Political Philosophy of Bakunin** , pp. 341-2]
Hardly the thoughts of someone opposed to industrialisation! Unsurprisingly,
then, Eugene Pyziu noted that _"[i]n an article printed in 1868 [Bakunin]
rejected outright the doctrine of the rottenness of the West and of the
messianic destiny of Russia."_ [ **The Doctrine of Anarchism of Michael A.
Bakunin** , p. 61]

Rather than oppose industrialisation and urge the destruction of industry,
Bakunin considered one of the first acts of the revolution would be workers'
associations taking over the means of production and turning them into
collective property managed by the workers themselves. Hence Daniel Guérin's
comment:

> _"Proudhon and Bakunin were 'collectivists,' which is to say they declared
> themselves without equivocation in favour of the common exploitation, not by
> the State but by associated workers of the large-scale means of production
> and of the public services. Proudhon has been quite wrongly presented as an
> exclusive enthusiast of private property."_ [ _"From Proudhon to Bakunin"_ ,
> pp. 23-33, **The Radical Papers** , Dimitrios I. Roussopoulos (ed.), p. 32]

Clearly, Stack does not have the faintest idea of what he is talking about!
Nor is Kropotkin any safer than Proudhon or Bakunin from Stack's distortions:

> _"Peter Kropotkin, another famous anarchist leader to emerge in Russia, also
> looked backwards for change. He believed the ideal society would be based on
> small autonomous communities, devoted to small scale production. He had
> witnessed such communities among Siberian peasants and watchmakers in the
> Swiss mountains."_

First, we must note the plagiarism. Stack is summarising Paul Avrich's summary
of Kropotkin's ideas. [ **Op. Cit.** , p. 62] Rather than go to the source
material, Stack provides an interpretation of someone else's interpretation of
someone else's ideas! Clearly, the number of links in the chain means that
something is going to get lost in the process and, of course, it does. The
something which "gets lost" is, unfortunately, Kropotkin's ideas.

Ultimately, Stack is simply showing his total ignorance of Kropotkin's ideas
by making such a statement. At least Avrich expanded upon his summary to
mention Kropotkin's positive evaluation of using modern technology and the
need to apply it on an appropriate level to make work and the working
environment as pleasant as possible. As Avrich summarises: _"placed in small
voluntary workshops, machinery would rescue human beings from the monotony and
toil of large-scale capitalist enterprise, allow time for leisure and cultural
pursuits, and remove forever the stamp of inferiority traditionally borne by
manual labour."_ [ **Op. Cit.** , p. 63] Hardly _"backward looking"_ to desire
the application of science and technology to transform the industrial system
into one based on the needs of people rather than profit!

Stack must be hoping that the reader has, like himself, not read Kropotkin's
classic work **Fields, Factories and Workshops** for if they have then they
would be aware of the distortion Stack subjects Kropotkin's ideas to. While
Avrich does present, in general, a reasonable summary of Kropotkin's ideas, he
does place it into a framework of his own making. Kropotkin while stressing
the importance of decentralising industry within a free society did not look
backward for his inspiration. Rather, he looked to trends within existing
society, trends he thought pointed in an anti-capitalist direction. This can
be seen from the fact he based his ideas on detailed analysis of current
developments in the economy and came to the conclusion that industry would
spread across the globe (which has happened) and that small industries will
continue to exist side by side with large ones (which also has been
confirmed). From these facts he argued that a socialist society would aim to
decentralise production, combining agriculture with industry and both using
modern technology to the fullest. This was possible only after a social
revolution which expropriated industry and the land and placed social wealth
into the hands of the producers. Until then, the positive trends he saw in
modern society would remain circumscribed by the workings of the capitalist
market and the state.

As we discuss the fallacy that Kropotkin (or anarchists in general) have
argued for _"small autonomous communities, devoted to small scale production"_
in [section I.3.8](secI3.md#seci38), we will not do so here. Suffice to say,
he did not, as is often asserted, argue for _"small-scale production"_ (he
still saw the need for factories, for example) but rather for production
geared to **_appropriate_** levels, based on the objective needs of production
(without the distorting effects generated by the needs of capitalist profits
and power) and, of necessity, the needs of those who work in and live
alongside industry (and today we would add, the needs of the environment). In
other words, the transformation of capitalism into a society human beings
could live full and meaningful lives in. Part of this would involve creating
an industry based on human needs. _"Have the factory and the workshop at the
gates of your fields and gardens and work in them,"_ he argued. _"Not those
large establishments, of course, in which huge masses of metals have to be
dealt with and which are better placed at certain spots indicated by Nature,
but the countless variety of workshops and factories which are required to
satisfy the infinite diversity of tastes among civilised men [and women]."_
The new factories and workplaces would be _"airy and hygienic, and
consequently economical, . . . in which human life is of more account than
machinery and the making of extra profits."_ [ **Fields, Factories and
Workshops Tomorrow** , p. 197] Under capitalism, he argued, the whole
discourse of economics (like industrial development itself) was based on the
logic and rationale of the profit motive:

> _"Under the name of profits, rent and interest upon capital, surplus value,
> and the like, economists have eagerly discussed the benefits which the
> owners of land or capital, or some privileged nations, can derive, either
> from the under-paid work of the wage-labourer, or from the inferior position
> of one class of the community towards another class, or from the inferior
> economical development of one nation towards another nation. . ._

> _"In the meantime the great question - 'What have we to produce, and how?'
> necessarily remained in the background . . . The main subject of social
> economy - that is, the **economy of energy required for the satisfaction of
> human needs** \- is consequently the last subject which one expects to find
> treated in a concrete form in economical treatises."_ [ **Op. Cit.** , p.
> 17]

Kropotkin's ideas were, therefore, an attempt to discuss how a post-capitalist
society could develop, based on an extensive investigation of current trends
within capitalism, and reflecting the needs which capitalism ignores. To
fetishise big industry, as Leninists tend to do, means locking socialism
itself into the logic of capitalism and, by implication, sees a socialist
society which will basically be the same as capitalism, using the technology,
industrial structure and industry developed under class society without change
(see [section H.3.12](secH3.md#sech312)). Rather than condemn Kropotkin,
Stack's comments (and those like them) simply show the poverty of the Leninist
critique of capitalism and its vision of the socialist future.

All in all, anyone who claims that anarchism is _"backward looking"_ or
_"yearns for the past"_ simply has no idea what they are talking about.

## H.2.4 Do anarchists think _"the state is the main enemy"_?

Pat Stack argues that _"the idea that dominates anarchist thought"_ is _"that
the state is the main enemy, rather than identifying the state as one aspect
of a class society that has to be destroyed."_ [ _"Anarchy in the UK?"_ ,
**Socialist Review** , no. 246] Marxist Paul Thomas states that _"Anarchists
insist that the basis source of social injustice is the state."_ [ **Karl Marx
and the Anarchists** , p. 2]

On the face of it, such assertions make little sense. After all, was not the
first work by the first self-declared anarchist called **What is Property?**
and contained the revolutionary maxim **_"property is theft"_**? Surely this
fact alone would be enough to put to rest the notion that anarchists view the
state as the main problem in the world? Obviously not. Flying in the face of
this well known fact as well as anarchist theory, Marxists have constantly
repeated the falsehood that anarchists consider the state as the main enemy.
Indeed, Stack and Thomas are simply repeating an earlier assertion by Engels:

> _"Bakunin has a peculiar theory of his own, a medley of Proudhonism and
> communism. The chief point concerning the former is that he does not regard
> capital, i.e. the class antagonism between capitalists and wage workers
> which has arisen through social development, but the **state** as the main
> enemy to be abolished . . . our view [is] that state power is nothing more
> than the organisation which the ruling classes - landowners and capitalists
> - have provided for themselves in order to protect their social privileges,
> Bakunin maintains that it is the **state** which has created capital, that
> the capitalist has his capital **only by the grace of the state.** As,
> therefore, the state is the chief evil, it is above all the state which must
> be done away with and then capitalism will go to blazes of itself. We, on
> the contrary, say: Do away with capital, the concentration of all means of
> production in the hands of a few, and the state will fall of itself. The
> difference is an essential one . . . the abolition of capital **is**
> precisely the social revolution."_ [Marx, Engels and Lenin, **Anarchism and
> Anarcho-Syndicalism** , p. 71]

As will come as no surprise, Engels did not bother to indicate where he
discovered Bakunin's ideas on these matters. Similarly, his followers raise
this kind of assertion as a truism, apparently without the need for evidence
to support the claim. This is hardly surprising as anarchists, including
Bakunin, have expressed an idea distinctly at odds with Engels' claims, namely
that the social revolution would be marked by the abolition of capitalism and
the state at the same time. That this is the case can be seen from John Stuart
Mill who, unlike Engels, saw that Bakunin's ideas meant _"not only the
annihilation of all government, but getting all property of all kinds out of
the hands of the possessors to be used for the general benefit."_ [ _"Chapters
on Socialism,"_ **Principles of Political Economy** , p. 376] If the great
liberal thinker could discern this aspect of anarchism, why not Engels?

After all, this vision of a **social** revolution (i.e. one that combined
political, social **and** economic goals) occurred continuously throughout
Bakunin's writings when he was an anarchist. Indeed, to claim that he, or
anarchists in general, just opposed the state suggests a total unfamiliarity
with anarchist theory. For Bakunin, like all anarchists, the abolition of the
state occurs at the same time as the abolition of capital. This joint
abolition **is** precisely the social revolution. As one academic put it:

> _"In Bakunin's view, the struggle against the main concentration of power in
> society, the state, was **no less necessary** than the struggle against
> capital. Engels, however, puts the matter somewhat differently, arguing that
> for Bakunin the state was the main enemy, as if Bakunin had not held that
> capital, too, was an enemy and that its expropriation was a necessary even
> if not sufficient condition for the social revolution . . . [Engels']
> formulation . . . distorts Bakunin's argument, which also held capital to be
> an evil necessary to abolish"_ [Alvin W. Gouldner, _"Marx's Last Battle:
> Bakunin and the First International"_ , pp. 853-884, **Theory and Society**
> , Vol. 11, No. 6, pp. 863-4]

In 1865, for example, we discover Bakunin arguing that anarchists _"seek the
destruction of all States"_ in his _"Program of the Brotherhood."_ Yet he also
argued that a member of this association _"must be socialist"_ and see that
_"labour"_ was the _"sole producer of social assets"_ and so _"anyone enjoying
these without working is an exploiter of another man's labour, a thief."_ They
must also _"understand that there is no liberty in the absence of equality"_
and so the _"attainment of the widest liberty"_ is possible only _"amid the
most perfect (de jure and de facto) political, economic and social equality."_
The _"sole and supreme objective"_ of the revolution _"will be the effective
political, economic and social emancipation of the people."_ This was because
political liberty _"is not feasible without political equality. And the latter
is impossible without economic and social equality."_ This means that the
_"land belongs to everyone. But usufruct of it will belong only to those who
till it with their own hands."_ As regards industry, _"through the unaided
efforts and economic powers of the workers' associations, capital and the
instruments of labour will pass into the possession of those who will apply
them . . . through their own labours."_ He opposed sexism, for women are
_"equal in all political and social rights."_ Ultimately, _"[n]o revolution
could succeed . . . unless it was simultaneously a political and a social
revolution. Any exclusively political revolution . . . will, insofar as it
consequently does not have the immediate, effective, political and economic
emancipation of the people as its primary objective, prove to be . . .
illusory, phoney."_ [ **No Gods, No Masters** , vol. 1, pp. 134-41]

In 1868, Bakunin was arguing the same ideas. The _"Association of the
International Brethren seeks simultaneously universal, social, philosophical,
economic and political revolution, so that the present order of things, rooted
in property, exploitation, domination and the authority principle"_ will be
destroyed. The _"revolution as we understand it will . . . set about the . . .
complete destruction of the State . . . The natural and necessary upshot of
that destruction"_ will include the _"[d]issolution of the army, magistracy,
bureaucracy, police and clergy"_ and _"[a]ll productive capital and
instruments of labour . . . be[ing] confiscated for the benefit of toilers
associations, which will have to put them to use in collective production"_ as
well as the _"[s]eizure of all Church and State properties."_ The _"federated
Alliance of all labour associations . . . will constitute the Commune."_ The
people _"must make the revolution everywhere, and . . . ultimate direction of
it must at all times be vested in the people organised into a free federation
of agricultural and industrial associations . . . organised from the bottom
up."_ [ **Op. Cit.** , pp. 152-6]

Are these the words of a person who considered the state as the _"chief evil"_
or _"that the state is the main enemy"_? Of course not, rather Bakunin clearly
identified the state as one aspect of a class society that has to be
destroyed. As he put it, the _"State, which has never had any task other than
to regularise, sanction and . . . protect the rule of the privileged classes
and exploitation of the people's labour for the rich, must be abolished.
Consequently, this requires that society be organised from the bottom up
through the free formation and free federation of worker associations,
industrial, agricultural, scientific and artisan alike, . . . founded upon
collective ownership of the land, capital, raw materials and the instruments
of labour, which is to say, all large-scale property . . . leaving to private
and hereditary possession only those items that are actually for personal
use."_ [ **Op. Cit.** , p. 182] Clearly, as Wayne Thorpe notes, for Bakunin
_"[o]nly the simultaneous destruction of the state and of the capitalist
system, accompanied by the organisation from below of a federalist system of
administration based upon labour's economic associations . . . could achieve
true liberty."_ [ **"The Workers Themselves"** , p. 6]

Rather than seeing the state as the main evil to be abolished, Bakunin always
stressed that a revolution must be economic **and** political in nature, that
it must ensure political, economic and social liberty and equality. As such,
he argued for **both** the destruction of the state and the expropriation of
capital (both acts conducted, incidentally, by a federation of workers'
associations or workers' councils). While the apparatus of the state was being
destroyed ( _"Dissolution of the army, magistracy, bureaucracy, police and
clergy"_ ), capitalism was also being uprooted and destroyed ( _"All
productive capital and instruments of labour . . . confiscated for the benefit
of toilers associations"_ ). To assert, as Engels did, that Bakunin ignored
the necessity of abolishing capitalism and the other evils of the current
system while focusing exclusively on the state, is simply distorting his
ideas. As Mark Leier summarises in his excellent biography of Bakunin, Engels
_"was just flat-out wrong . . . What Bakunin did argue was that the social
revolution had to be launched against the state and capitalism simultaneously,
for the two reinforced each other."_ [ **Bakunin: The Creative Passion** , p.
274]

Kropotkin, unsurprisingly, argued along identical lines as Bakunin. He
stressed that _"the revolution will burn on until it has accomplished its
mission: the abolition of property-owning and of the State."_ This revolution,
he re-iterated, would be a _"mass rising up against property and the State."_
Indeed, Kropotkin always stressed that _"there is one point to which all
socialists adhere: the expropriation of capital must result from the coming
revolution."_ This meant that _"the area of struggle against capital, and
against the sustainer of capital - government"_ could be one in which
_"various groups can act in agreement"_ and so _"any struggle that prepares
for that expropriation should be sustained in unanimity by all the socialist
groups, to whatever shading they belong."_ [ **Words of a Rebel** , p. 75 and
p. 204] Little wonder Kropotkin wrote his famous article _"Expropriation"_ on
this subject! As he put it:

> _"Expropriation - that is the guiding word of the coming revolution, without
> which it will fail in its historic mission: the complete expropriation of
> all those who have the means of exploiting human beings; the return to the
> community of the nation of everything that in the hands of anyone can be
> used to exploit others."_ [ **Op. Cit.** , pp. 207-8]

This was because he was well aware of the oppressive nature of capitalism:
_"For the worker who **must sell** his labour, it is impossible to remain
**free** , and it is precisely because it is impossible that we are anarchists
and communists."_ [ **Selected Writings on Anarchism and Revolution** , p.
305] For Kropotkin, _"the task we impose ourselves"_ is to acquire
_"sufficient influence to induce the workmen to avail themselves of the first
opportunity of taking possession of land and the mines, of railways and
factories,"_ to bring working class people _"to the conviction that they must
rely on themselves to get rid of the oppression of Capital."_ [ **Act for
Yourselves** , p. 32] Strange words if Marxist assertions were true. As can be
seen, Kropotkin is simply following Bakunin's ideas on the matter. He, like
Bakunin, was well aware of the evils of capitalism and that the state protects
these evils.

Unsurprisingly, he called anarchism _"the no-government system of socialism."_
[ **Anarchism** , p. 46] For Kropotkin, the _"State is there to protect
exploitation, speculation and private property; it is itself the by-product of
the rapine of the people. The proletarian must rely on his own hands; he can
expect nothing of the State. It is nothing more than an organisation devised
to hinder emancipation at all costs."_ [ **Words of a Rebel** , p. 27] Rather
than see the state as the main evil, he clearly saw it as the protector of
capitalism - in other words, as one aspect of a class system which needed to
be replaced by a better society:

> _"The very words Anarchist-Communism show in what direction society, in our
> opinion, is already going, and on what lines it can get rid of the
> oppressive powers of Capital and Government . . . The first conviction to
> acquire is that nothing short of expropriation on a vast scale, carried out
> by the workmen themselves, can be the first step towards a reorganisation of
> our production on Socialist principles."_ [Kropotkin, **Act for Yourselves**
> , pp. 32-3]

Similarly with other anarchists. Emma Goldman summarised the libertarian
position when she argued that anarchism _"really stands for"_ the _"liberation
of the human body from the domination of property; liberation from the
shackles and restraint of government."_ Goldman was well aware that wealth
_"means power; the power to subdue, to crush, to exploit, the power to
enslave, to outrage, to degrade."_ She considered property _"not only a
hindrance to human well-being, but an obstacle, a deadly barrier, to all
progress."_ A key problem of modern society was that _"man must sell his
labour"_ and so _"his inclination and judgement are subordinated to the will
of a master."_ Anarchism, she stressed, was the _"the only philosophy that can
and will do away with this humiliating and degrading situation . . . There can
be no freedom in the large sense of the word . . . so long as mercenary and
commercial considerations play an important part in the determination of
personal conduct."_ The state, ironically for Stack's claim, was _"necessary
**only** to maintain or protect property and monopoly."_ [ **Red Emma Speaks**
, p. 73, p. 66, p. 50 and p. 51]

Errico Malatesta, likewise, stressed that, for _"all anarchists,"_ it was
definitely a case that the _"abolition of political power is not possible
without the simultaneous destruction of economic privilege."_ The _"Anarchist
Programme"_ he drafted listed _"Abolition of private property"_ before
_"Abolition of government"_ and argued that _"the present state of society"_
was one in _"which some have inherited the land and all social wealth, while
the mass of the people, disinherited in all respects, is exploited and
oppressed by a small possessing class."_ It ends by arguing that anarchism
wants _"the complete destruction of the domination and exploitation of man by
man"_ and for _"expropriation of landowners and capitalists for the benefit of
all; and the abolition of government."_ [ **Errico Malatesta: His Life and
Ideas** , p. 158, p. 184, p. 183, p. 197 and p. 198] Nearly three decades
previously, we find Malatesta arguing the same idea. As he put it in 1891,
anarchists _"struggle for anarchy, and for socialism, because we believe that
anarchy and socialism must be realised immediately, that is to say that in the
revolutionary act we must drive government away, abolish property . . . human
progress is measured by the extent government power and private property are
reduced."_ [ **Anarchy** , p. 54]

Little wonder Bertrand Russell stated that anarchism _"is associated with
belief in the communal ownership of land and capital"_ because, like Marxism,
it has the _"perception that private capital is a source of tyranny by certain
individuals over others."_ [ **Roads to Freedom** , p. 40] Russell was, of
course, simply pointing out the obvious. As Brian Morris correctly summarises:

> _"Another criticism of anarchism is that it has a narrow view of politics:
> that it sees the state as the fount of all evil, ignoring other aspects of
> social and economic life. This is a misrepresentation of anarchism. It
> partly derives from the way anarchism has been defined, and partly because
> Marxist historians have tried to exclude anarchism from the broader
> socialist movement. But when one examines the writings of classical
> anarchists. . . as well as the character of anarchist movements. . . it is
> clearly evident that it has never had this limited vision. It has always
> challenged all forms of authority and exploitation, and has been equally
> critical of capitalism and religion as it has been of the state."_ [
> _"Anthropology and Anarchism,"_ pp. 35-41, **Anarchy: A Journal of Desire
> Armed** , no. 45, p, p. 40]

All in all, Marxist claims that anarchists view the state as the _"chief
evil"_ or see the destruction of the state as the _"main idea"_ of anarchism
are simply talking nonsense. In fact, rather than anarchists having a narrow
view of social liberation, it is, in fact, Marxists who do so. By
concentrating almost exclusively on the (economic) class source of
exploitation, they blind themselves to other forms of exploitation and
domination that can exist independently of (economic) class relationships.
This can be seen from the amazing difficulty that many of them got themselves
into when trying to analyse the Stalinist regime in Russia. Anarchists are
well aware that the state is just one aspect of the current class system but
unlike Marxists we recognise that _"class rule must be placed in the much
**larger** context of hierarchy and domination as a whole."_ [Murray Bookchin,
**The Ecology of Freedom** , p. 28] This has been the anarchist position from
the nineteenth century onwards and one which is hard not to recognise if you
are at all familiar with the anarchist movement and its theory. As one
historian notes, we have never been purely anti-state, but also anti-
capitalist and opposed to all forms of oppression:

> _"Anarchism rejected capitalism . . . not only because it viewed it as
> inimical to social equality, but also because it saw it as a form of
> domination detrimental to individual freedom. Its basic tenet regarded
> hierarchical authority - be it the state, the church, the economic elite, or
> patriarchy - as unnecessary and deleterious to the maximisation of human
> potential."_ [Jose Moya, **Italians in Buenos Aires's Anarchist Movement** ,
> p. 197]

So we oppose the state because it is just one aspect of a class ridden and
hierarchical system. We just recognise that all the evils of that system must
be destroyed at the same time to ensure a **social** revolution rather than
just a change in who the boss is.

## H.2.5 Do anarchists think _"full blown"_ socialism will be created
overnight?

Another area in which Marxists misrepresent anarchism is in the assertion that
anarchists believe a completely socialist society (an ideal or _"utopian"_
society, in other words) can be created _"overnight."_ As Marxist Bertell
Ollman puts it, _"[u]nlike anarcho-communists, none of us [Marxists] believe
that communism will emerge full blown from a socialist revolution. Some kind
of transition and period of indeterminate length for it to occur are
required."_ [ **Market Socialism: The Debate among Socialists** , Bertell
Ollman (ed.), p. 177] This assertion, while it is common, fails to understand
the anarchist vision of revolution. We consider it a **process** and not an
event: _"By revolution we do not mean just the insurrectionary act."_
[Malatesta, **Errico Malatesta: His Life and Ideas** , p. 156]

Once this is understood, the idea that anarchists think a _"full blown"_
anarchist society will be created _"overnight"_ is a fallacy. As Murray
Bookchin pointed out, _"Bakunin, Kropotkin, Malatesta were not so naive as to
believe that anarchism could be established overnight. In imputing this notion
to Bakunin, Marx and Engels wilfully distorted the Russian anarchist's
views."_ [ **Post-Scarcity Anarchism** , p. 137] Indeed, Kropotkin stressed
that anarchists _"do not believe that in any country the Revolution will be
accomplished at a stroke, in the twinkling of a eye, as some socialists
dream."_ Moreover, _"[n]o fallacy more harmful has ever been spread than the
fallacy of a 'One-day Revolution.'"_ [ **The Conquest of Bread** , p. 81]
Bakunin argued that a _"more or less prolonged transitional period"_ would
_"naturally follow in the wake of the great social crisis"_ implied by social
revolution. [ **The Political Philosophy of Bakunin** , p. 412] The question,
therefore, is not whether there will be a _"transitional"_ society after a
revolution but what **kind** of transition will it be.

So anarchists are aware that a _"full blown"_ communist society will not come
about immediately. Rather, the creation of such a society will be a
**process** which the revolution will start off. As Alexander Berkman put it
in his classic introduction to communist-anarchist ideas _"you must not
confuse the social revolution with anarchy. Revolution, in some of its stages,
is a violent upheaval; anarchy is a social condition of freedom and peace. The
revolution is the **means** of bringing anarchy about but it is not anarchy
itself. It is to pave the road for anarchy, to establish conditions which will
make a life of liberty possible."_ However, the _"end shapes the means"_ and
so _"to achieve its purpose the revolution must be imbued with and directed by
the anarchist spirit and ideas . . . the social revolution must be anarchist
in method as in aim."_ [ **What is Anarchism?** , p. 231]

Berkman also acknowledged that _"full blown"_ communism was not likely after a
successful revolution. _"Of course,"_ he argued, _"when the social revolution
has become thoroughly organised and production is functioning normally there
will be enough for everybody. But in the first stages of the revolution,
during the process of re-construction, we must take care to supply the people
as best we can, and equally, which means rationing."_ Clearly, in such
circumstances _"full blown"_ communism would be impossible and,
unsurprisingly, Berkman argued that would not exist. However, the principles
that inspire communism and anarchism could be applied immediately. This meant
that both the state and capitalism would be abolished. While arguing that
_"[t]here is no other way of securing economic equality, which alone is
liberty"_ than communist anarchism, he also stated that it is _"likely . . .
that a country in social revolution may try various economic experiments . . .
different countries and regions will probably try out various methods, and by
practical experience learn the best way. The revolution is at the same time
the opportunity and justification for it."_ Rather than _"dictate to the
future, to prescribe its mode of conduct"_ , Berkman argued that his _"purpose
is to suggest, in broad outline the principles which must animate the
revolution, the general lines of action it should follow if it is to
accomplish its aim - the reconstruction of society on a foundation of freedom
and equality."_ [ **Op. Cit.** , p. 215 and p. 230]

Malatesta argued along similar lines. While urging the _"complete destruction
of the domination and exploitation of man by man"_ by the _"expropriation of
landlords and capitalists for the benefit of all"_ and _"the abolition of
government,"_ he recognised that in _"the post-revolutionary period, in the
period of reorganisation and transition, there might be 'offices for the
concentration and distribution of the capital of collective enterprises', that
there might or might not be titles recording the work done and the quantity of
goods to which one is entitled."_ However, he stressed that this _"is
something we shall have to wait and see about, or rather, it is a problem
which will have many and varied solutions according to the system of
production and distribution which will prevail in the different localities and
among the many . . . groupings that will exist."_ He argued that while,
eventually, all groups of workers (particularly the peasants) will
_"understand the advantages of communism or at least of the direct exchange of
goods for goods,"_ this may not happen _"in a day."_ If some kind of money was
used, then people should _"ensure that [it] truly represents the useful work
performed by its possessors"_ rather than being that _"powerful means of
exploitation and oppression"_ is currently is. [ **Errico Malatesta: His Life
and Ideas** , pp. 198-9 and pp. 100-1] Emma Goldman, also, saw _"a society
based on voluntary co-operation of productive groups, communities and
societies loosely federated together, eventually developing into a free
communism, actuated by a solidarity of interests."_ [ **Red Emma Speaks** , p.
50]

So rather than seeing a _"full blown"_ communist society appearing instantly
from a revolution, anarcho-communists see a period of transition in which the
degree of communism in a given community or area is dependent on the objective
conditions facing it. This period of transition would see different forms of
social experimentation but the desire is to see libertarian communist
principles as the basis of as much of this experimentation as possible. To
claim that anarcho-communists ignore reality and see communism as being
created overnight is simply a distortion of their ideas. Rather, they are
aware that the development towards communism is dependent on local conditions,
conditions which can only be overcome in time and by the liberated community
re-organising production and extending it as required. Thus we find Malatesta
arguing in 1884 that communism could be brought about immediately only in a
very limited number of areas and, _"for the rest,"_ collectivism would have to
be accepted _"for a transitional period."_ This was because, _"[f]or communism
to be possible, a high stage of moral development is required of the members
of society, a sense of solidarity both elevated and profound, which the
upsurge of the revolution may not suffice to induce. This doubt is the more
justified in that material conditions favourable to this development will not
exist at the beginning."_ [quoted by Daniel Guérin, **Anarchism** , p. 51]

Clearly, our argument contradicts the widely held view that anarchists
believed a utopian world would be created instantly after a revolution. Of
course, by asserting that anarchists think _"full blown communism"_ will occur
without some form of transitional period, Marxists paint a picture of
anarchism as simply utopian, a theory which ignores objective reality in
favour of wishful thinking. However, as seen above, such is not the case.
Anarchists are aware that _"full blown communism"_ is dependent on objective
conditions and, therefore, cannot be implemented until those conditions are
meet. Until such time as the objective conditions are reached, various means
of distributing goods, organising and managing production, and so on will be
tried. Such schemes will be based as far as possible on communistic
principles.

Such a period of transition would be based on libertarian and communist
principles. The organisation of society would be anarchist - the state would
be abolished and replaced by a free federation of workers and community
associations. The economic structure would be socialist - production would be
based on self-managed workplaces and the principles of distribution would be
as communistic as possible under the given objective conditions.

It also seems strange for Marxists to claim that anarchists thought a _"full
blown"_ communist society was possible _"overnight"_ given that anarchists had
always noted the difficulties facing a social revolution. Kropotkin, for
example, continually stressed that a revolution would face extensive economic
disruption. In his words:

> _"A political revolution can be accomplished without shaking the foundations
> of industry, but a revolution where the people lay hands upon property will
> inevitably paralyse exchange and production . . . This point cannot be too
> much insisted upon; the reorganisation of industry on a new basis . . .
> cannot be accomplished in a few days; nor, on the other hand, will people
> submit to be half starved for years in order to oblige the theorists who
> uphold the wage system. To tide over the period of stress they will demand
> what they have always demanded in such cases - communisation of supplies -
> the giving of rations."_ [ **The Conquest of Bread** , pp. 72-3]

The basic principles of this "transition" period would, therefore, be based on
the _"socialising of production, consumption and exchange."_ The state would
be abolished and _"federated Communes"_ would be created. The end of
capitalism would be achieved by the _"expropriation"_ of _"everything that
enables any man - be he financier, mill-owner, or landlord - - to appropriate
the product of others' toil."_ Distribution of goods would be based on _"no
stint or limit to what the community possesses in abundance, but equal sharing
and dividing of those commodities which are scarce or apt to run short."_ [
**Op. Cit.** , p. 136, p. 61 and p. 76] Clearly, while not _"full blown"_
communism by any means, such a regime does lay the ground for its eventual
arrival. As Max Nettlau summarised, _"[n]othing but a superficial
interpretation of some of Kropotkin's observations could lead one to conclude
that anarchist communism could spring into life through an act of sweeping
improvisation, with the waving of a magic wand."_ [ **A Short History of
Anarchism** , p. 80]

This was what happened in the Spanish Revolution, for example. Different
collectives operated in different ways. Some tried to introduce free
communism, some a combination of rationing and communism, others introduced
equal pay, others equalised pay as much as possible and so on. Over time, as
economic conditions changed and difficulties developed the collectives changed
their mode of distribution to take them into account. These collectives
indicate well the practical aspects of anarchism and its desire to accommodate
and not ignore reality.

Lastly, and as an aside, it is this anarchist awareness of the disruptive
effects of a revolution on a country's economy which, in part, makes
anarchists extremely sceptical of pro-Bolshevik rationales that blame the
difficult economic conditions facing the Russian Revolution for Bolshevik
authoritarianism (see [section H.6.1](secH6.md#sech61) for a fuller
discussion of this). If, as Kropotkin argued, a social revolution inevitably
results in massive economic disruption then, clearly, Bolshevism should be
avoided if it cannot handle such inevitable events. In such circumstances,
centralisation would only aid the disruption, not reduce it. This awareness of
the problems facing a social revolution also led anarchists to stress the
importance of local action and mass participation. As Kropotkin put it, the
_"immense constructive work demanded by a social revolution cannot be
accomplished by a central government . . . It has need of knowledge, of brains
and of the voluntary collaboration of a host of local and specialised forces
which alone can attack the diversity of economic problems in their local
aspects."_ [ **Anarchism** , pp. 255-6] Without this local action, co-
ordinated joint activity would remain a dead letter.

In summary, anarchists acknowledge that **politically** there is no
transitional period (i.e. the state must be abolished and replaced by a free
federation of self-managed working class organisations). Economically
anarchists recognise that different areas will develop in different ways and
so there will be various economical transitional forms. Rather than seeing
_"full blown communism"_ being the instant result of a socialist revolution,
anarchist-communists actually argue the opposite - _"full blown communism"_
will develop only after a successful revolution and the inevitable period of
social reconstruction which comes after it. A _"full blown"_ communist economy
will develop as society becomes ready for it. What we **do** argue is that any
transitional economic form must be based on the principles of the type of
society it desires. In other words, any transitional period must be as
communistic as possible if communism is your final aim and, equally, it must
be libertarian if your final goal is freedom.

Also see [section I.2.2](secI2.md#seci22) for further discussion on this
issue.

## H.2.6 How do Marxists misrepresent Anarchist ideas on mutual aid?

Anarchist ideas on mutual aid are often misrepresented by Marxists. Looking at
Pat Stack's _"Anarchy in the UK?"_ article, for example, we find a
particularly terrible misrepresentation of Kropotkin's ideas. Indeed, it is so
incorrect that it is either a product of ignorance or a desire to deceive (and
as we shall indicate, it is probably the latter). Here is Stack's account of
Kropotkin's ideas:

> _"And the anarchist Peter Kropotkin, far from seeing class conflict as the
> dynamic for social change as Marx did, saw co-operation being at the root of
> the social process. He believed the co-operation of what he termed 'mutual
> aid' was the natural order, which was disrupted by centralised states.
> Indeed in everything from public walkways and libraries through to the Red
> Cross, Kropotkin felt he was witnessing confirmation that society was moving
> towards his mutual aid, prevented only from completing the journey by the
> state. It follows that if class conflict is not the motor of change, the
> working class is not the agent and collective struggle not the means."_ [
> _"Anarchy in the UK?"_ , **Socialist Review** , no. 246]

There are three issues with Stack's summary. Firstly, Kropotkin did not, in
fact, reject class conflict as the _"dynamic of social change"_ nor reject the
working class as its _"agent."_ Secondly, all of Stack's examples of _"Mutual
Aid"_ do not, in fact, appear in Kropotkin's classic book **Mutual Aid**. They
do appear in other works by Kropotkin but **not** as examples of _"mutual
aid."_ Thirdly, in **Mutual Aid** Kropotkin discusses such aspects of working
class _"collective struggle"_ as strikes and unions. All in all, it is Stack's
total and utter lack of understanding of Kropotkin's ideas which immediately
stands out from his comments.

As we have discussed how collective, working class direct action, organisation
and solidarity in the class struggle were at the core of Kropotkin's politics
in [section H.2.2](secH2.md#sech22), we will not do so here. Rather, we will
discuss how Stack lies about Kropotkin's ideas on mutual aid. As just noted,
the examples Stack lists are not to be found in Kropotkin's classic work
**Mutual Aid**. Now, **if** Kropotkin **had** considered them as examples of
_"mutual aid"_ then he would have listed them in that work. This does not
mean, however, that Kropotkin did not mention these examples. He does, but in
other works (notably his essay **Anarchist-Communism: Its Basis and
Principles** ) and he does **not** use them as examples of mutual aid. Here
are Kropotkin's own words on these examples:

> _"We maintain, moreover, not only that communism is a desirable state of
> society, but that the growing tendency of modern society is precisely
> towards communism - free communism - notwithstanding the seemingly
> contradictory growth of individualism. In the growth of individualism . . .
> we see merely the endeavours of the individual towards emancipating himself
> from the steadily growing powers of capital and the State. But side by side
> with this growth we see also . . . the latent struggle of the producers of
> wealth to maintain the partial communism of old, as well as to reintroduce
> communist principles in a new shape, as soon as favourable conditions permit
> it. . . the communist tendency is continually reasserting itself and trying
> to make its way into public life. The penny bridge disappears before the
> public bridge; and the turnpike road before the free road. The same spirit
> pervades thousands of other institutions. Museums, free libraries, and free
> public schools; parks and pleasure grounds; paved and lighted streets, free
> for everybody's use; water supplied to private dwellings, with a growing
> tendency towards disregarding the exact amount of it used by the individual;
> tramways and railways which have already begun to introduce the season
> ticket or the uniform tax, and will surely go much further in this line when
> they are no longer private property: all these are tokens showing in what
> direction further progress is to be expected._

> _"It is in the direction of putting the wants of the individual **above**
> the valuation of the service he has rendered, or might render, to society;
> in considering society as a whole, so intimately connected together that a
> service rendered to any individual is a service rendered to the whole
> society."_ [ **Anarchism** , pp. 59-60]

As is clear, the examples Stack selects have nothing to do with mutual aid in
Kropotkin's eyes. Rather, they are examples of communistic tendencies within
capitalism, empirical evidence that can be used to not only show that
communism can work but also that it is not a utopian social solution but an
expression of tendencies within society. Simply put, he is using examples from
existing society to show that communism is not impossible.

Similarly with Stack's other examples, which are **not** used as expressions
of _"mutual aid"_ but rather as evidence that social life can be organised
without government. [ **Op. Cit.** , pp. 65-7] Just as with communism, he gave
concrete examples of libertarian tendencies within society to prove the
possibility of an anarchist society. And just like his examples of communistic
activities within capitalism, his examples of co-operation without the state
are not listed as examples of _"mutual aid."_

All this would suggest that Stack has either not read Kropotkin's works or
that he has and consciously decided to misrepresent his ideas. In fact, its a
combination of the two. Stack (as proven by his talk at **Marxism 2001** )
gathered his examples of _"mutual aid"_ from Paul Avrich's essay _"Kropotkin's
Ethical Anarchism"_ contained in his **Anarchist Portraits**. As such, he has
not read the source material. Moreover, he simply distorted what Avrich wrote.
In other words, not only has he not read Kropotkin's works, he consciously
decided to misrepresent the secondary source he used. This indicates the
quality of almost all Marxist critiques of anarchism.

For example, Avrich correctly noted that Kropotkin did not _"deny that the
'struggle for existence' played an important role in the evolution of species.
In **Mutual Aid** he declares unequivocally that 'life **is** struggle; and in
that struggle the fittest survive.'"_ Kropotkin simply argued that co-
operation played a key role in determining who was, in fact, the fittest.
Similarly, Avrich listed many of the same examples Stack presents but not in
his discussion of Kropotkin's ideas on mutual aid. Rather, he correctly did so
in his discussion of how Kropotkin saw examples of anarchist communism
_"manifesting itself 'in the thousands of developments of modern life.'"_ This
did not mean that Kropotkin did not see the need for a social revolution,
quite the reverse. As Avrich noted, Kropotkin _"did not shrink from the
necessity of revolution"_ as he _"did not expect the propertied classes to
give up their privileges and possessions without a fight."_ This _"was to be a
**social** revolution, carried out by the masses themselves"_ achieved by
means of _"expropriation"_ of social wealth. [ **Anarchist Portraits** , p.
58, p. 62 and p. 66]

So much for Stack's claims. As can be seen, they are not only a total
misrepresentation of Kropotkin's work, they are also a distortion of his
source!

A few more points need to be raised on this subject.

Firstly, Kropotkin never claimed that mutual aid _"was the natural order."_
Rather, he stressed that Mutual Aid was (to use the subtitle of his book on
the subject) _"a factor of evolution."_ As he put it, mutual aid _"represents
one of the factors of evolution"_ , another being _"the self-assertion of the
individual, not only to attain personal or caste superiority, economical,
political, and spiritual, but also in its much more important although less
evident function of breaking through the bonds, always prone to become
crystallised, which the tribe, the village community, the city, and the State
impose upon the individual."_ Thus Kropotkin recognised that there is class
struggle within society as well as _"the self-assertion of the individual
taken as a progressive element"_ (i.e., struggle against forms of social
association which now hinder individual freedom and development). Kropotkin
did not deny the role of struggle, in fact the opposite as he stressed that
the book's examples concentrated on mutual aid simply because mutual struggle
(between individuals of the same species) had _"already been analysed,
described, and glorified from time immemorial"_ and, as such, he felt no need
to illustrate it. He did note that it _"was necessary to show, first of all,
the immense part which this factor plays in the evolution of both the animal
world and human societies. Only after this has been fully recognised will it
be possible to proceed to a comparison between the two factors."_ [ **Mutual
Aid** , p. 231 and pp. 231-2] So at no stage did Kropotkin deny either factor
(unlike the bourgeois apologists he was refuting).

Secondly, Stack's argument that Kropotkin argued that co-operation was the
natural order is in contradiction with his other claims that anarchism
_"despises the collectivity"_ and _"dismiss[es] the importance of the
collective nature of change"_ (see [section H.2.2](secH2.md#sech22)). How
can you have co-operation without forming a collective? And, equally, surely
support for co-operation clearly implies the recognition of the _"collective
nature of change"_? Moreover, had Stack bothered to **_read_** Kropotkin's
classic he would have been aware that both unions and strikes are listed as
expressions of _"mutual aid"_ (a fact, of course, which would undermine
Stack's silly assertion that anarchists reject collective working class
struggle and organisation). Thus we find Kropotkin stating that _"Unionism"_
expressed the _"worker's need of mutual support"_ as well as discussing how
the state _"legislated against the workers' unions"_ and that these were _"the
conditions under which the mutual-aid tendency had to make its way."_ _"To
practise mutual support under such circumstances was anything but an easy
task."_ This repression failed, as _"the workers' unions were continually
reconstituted"_ and spread, forming _"vigourous federal organisations . . . to
support the branches during strikes and prosecutions."_ In spite of the
difficulties in organising unions and fighting strikes, he noted that _"every
year there are thousands of strikes . . . the most severe and protracted
contests being, as a rule, the so-called 'sympathy strikes,' which are entered
upon to support locked-out comrades or to maintain the rights of the unions."_
Anyone (like Kropotkin) who had _"lived among strikers speak with admiration
of the mutual aid and support which are constantly practised by them."_ [
**Op. Cit.** , pp. 210-3]

Kropotkin, as noted, recognised the importance of struggle or competition as a
means of survival but also argued that co-operation within a species was the
best means for it to survive in a hostile environment. This applied to life
under capitalism. In the hostile environment of class society, then the only
way in which working class people could survive would be to practice mutual
aid (in other words, solidarity). Little wonder, then, that Kropotkin listed
strikes and unions as expressions of mutual aid in capitalist society.
Moreover, if we take Stack's arguments at face value, then he clearly is
arguing that solidarity is not an important factor in the class struggle and
that mutual aid and co-operation cannot change the world! Hardly what you
would expect a socialist to argue. In other words, his inaccurate diatribe
against Kropotkin backfires on his own ideas.

Thirdly, **Mutual Aid** is primarily a work of popular science and not a work
on revolutionary anarchist theory like, say, **The Conquest of Bread** or
**Words of a Rebel**. As such, it does not present a full example of
Kropotkin's revolutionary ideas and how mutual aid fits into them. However, it
does present some insights on the question of social progress which indicate
that he did not think that _"co-operation"_ was _"at the root of the social
process,"_ as Stack claims. For example, Kropotkin noted that _"[w]hen Mutual
Aid institutions . . . began . . . to lose their primitive character, to be
invaded by parasitic growths, and thus to become hindrances to process, the
revolt of individuals against these institutions took always two different
aspects. Part of those who rose up strove to purify the old institutions, or
to work out a higher form of commonwealth."_ But at the same time, others
_"endeavoured to break down the protective institutions of mutual support,
with no other intention but to increase their own wealth and their own
powers."_ In this conflict _"lies the real tragedy of history."_ He also noted
that the mutual aid tendency _"continued to live in the villages and among the
poorer classes in the towns."_ Indeed, _"in so far as"_ as new _"economical
and social institutions"_ were _"a creation of the masses"_ they _"have all
originated from the same source"_ of mutual aid. [ **Op. Cit.** , pp. 18-9 and
p. 180] Clearly, Kropotkin saw history marked by both co-operation and
conflict as you would expect in a society divided by class and hierarchy.

Significantly, Kropotkin considered **Mutual Aid** as an attempt to write
history from below, from the perspective of the oppressed. As he put it,
history, _"such as it has hitherto been written, is almost entirely a
description of the ways and means by which theocracy, military power,
autocracy, and, later on, the richer classes' rule have been promoted,
established, and maintained."_ The _"mutual aid factor has been hitherto
totally lost sight of; it was simply denied, or even scoffed at."_ [ **Op.
Cit.** , p. 231] He was well aware that mutual aid (or solidarity) could not
be applied between classes in a class society. Indeed, as noted, his chapters
on mutual aid under capitalism contain the strike and union. As he put it in
an earlier work:

> _"What solidarity can exist between the capitalist and the worker he
> exploits? Between the head of an army and the soldier? Between the governing
> and the governed?"_ [ **Words of a Rebel** , p. 30]

In summary, Stack's assertions about Kropotkin's theory of _"Mutual Aid"_ are
simply false. He distorts the source material and shows a total ignorance of
Kropotkin's work (which he obviously has not bothered to read before
criticising it). A truthful account of _"Mutual Aid"_ would involve
recognising that Kropotkin showed it being expressed in both strikes and
labour unions and that he saw solidarity between working people as the means
of not only surviving within the hostile environment of capitalism but also as
the basis of a mass revolution which would end it.

## H.2.7 Who do anarchists see as their _"agents of social change"_?

It is often charged, usually without any evidence, that anarchists do not see
the working class as the _"agent"_ of the social revolution. Pat Stack, for
example, states _"the failure of anarchism [is] to understand the centrality
of the working class itself."_ He argues that for Marx, _"the working class
would change the world and in the process change itself. It would become the
agent for social advance and human liberty."_ For Bakunin, however, _"skilled
artisans and organised factory workers, far from being the source of the
destruction of capitalism, were 'tainted by pretensions and aspirations'.
Instead Bakunin looked to those cast aside by capitalism, those most damaged,
brutalised and marginalised. The lumpen proletariat, the outlaws, the
'uncivilised, disinherited, illiterate', as he put it, would be his agents for
change."_ [ _"Anarchy in the UK?"_ , **Socialist Review** , no. 246] He fails
to provide any references for his accusations. This is unsurprising, as to do
so would mean that the reader could check for themselves the validity of
Stack's claims.

Take, for example, the quote _"uncivilised, disinherited, illiterate"_ Stack
uses as evidence. This expression is from an essay written by Bakunin in 1872
and which expressed what he considered the differences between his ideas and
those of Marx. The quote can be found on page 294 of **Bakunin on Anarchism**.
On the previous page, we discover Bakunin arguing that _"for the International
to be a real power, it must be able to organise within its ranks the immense
majority of the proletariat of Europe, of America, of all lands."_ [p. 293]
Clearly Stack is quoting out of context, distorting Bakunin's position to
present a radically false image of anarchism. Moreover, as we will indicate,
Stack's also quotes them outside the historical context as well.

Let us begin with Bakunin's views on _"skilled artisans and organised factory
workers."_ In **Statism and Anarchy** , for example, we discover Bakunin
arguing that the _"proletariat . . . must enter the International [Workers'
Association] en masse, form factory, artisan, and agrarian sections, and unite
them into local federations"_ for _"the sake of its own liberation."_ [p. 51]
This perspective is the predominant one in Bakunin's ideas with the Russian
continually arguing that anarchists saw _"the new social order"_ being
_"attained . . . through the social (and therefore anti-political)
organisation and power of the working masses of the cities and villages."_ He
argued that _"only the trade union sections can give their members . . .
practical education and consequently only they can draw into the organisation
of the International the masses of the proletariat, those masses without whose
practical co-operation . . . the Social Revolution will never be able to
triumph."_ The International, in Bakunin's words, _"organises the working
masses . . . from the bottom up"_ and that this was _"the proper aim of the
organisation of trade union sections."_ He stressed that revolutionaries must
_"[o]rganise the city proletariat in the name of revolutionary Socialism . . .
[and] unite it into one preparatory organisation together with the
peasantry."_ [ **The Political Philosophy of Bakunin** , p. 300, p. 310, p.
319 and p. 378]

This support for organised workers and artisans can also be seen from the rest
of the essay Stack distorts, in which Bakunin discusses the _"flower of the
proletariat"_ as well as the policy that the **International Workingmen's
Association** should follow (i.e. the organised revolutionary workers). He
argued that its _"sections and federations [must be] free to develop its own
policies . . . [to] attain real unity, basically economic, which will
necessarily lead to real political unity . . . The foundation for the unity of
the International . . . has already been laid by the common sufferings,
interests, needs, and real aspirations of the workers of the whole world."_ He
stressed that _"the International has been . . . the work of the proletariat
itself . . . It was their keen and profound instinct as workers . . . which
impelled them to find the principle and true purpose of the International.
They took the common needs already in existence as the foundation and saw the
**international organisation of economic conflict against capitalism** as the
true objective of this association. In giving it exclusively this base and
aim, the workers at once established the entire power of the International.
They opened wide the gates to all the millions of the oppressed and
exploited."_ The International, as well as _"organising local, national and
international strikes"_ and _"establishing national and international trade
unions,"_ would discuss _"political and philosophical questions."_ The workers
_"join the International for one very practical purpose: solidarity in the
struggle for full economic rights against the oppressive exploitation by the
bourgeoisie."_ [ **Bakunin on Anarchism** , pp. 297-8, pp. 298-9 and pp.
301-2]

All this, needless to say, makes a total mockery of Stack's claim that Bakunin
did not see _"skilled artisans and organised factory workers"_ as _"the source
of the destruction of capitalism"_ and _"agents for change."_ Indeed, it is
hard to find a greater distortion of Bakunin's ideas. Rather than dismiss
_"skilled artisans"_ and _"organised factory workers"_ Bakunin desired to
organise them along with agricultural workers into unions and get these unions
to affiliate to the **International Workers' Association**. He argued again
and again that the working class, organised in unions, were the means of
making a revolution (i.e. _"the source of the destruction of capitalism,"_ to
use Stack's words).

Only in **this** context can we understand Bakunin's comments which Stack
(selectively) quotes. Any apparent contradiction generated by Stack's quoting
out of context is quickly solved by looking at Bakunin's work. This reference
to the _"uncivilised, disinherited, illiterate"_ comes from a polemic against
Marx. From the context, it can quickly be seen that by these terms Bakunin
meant the bulk of the working class. In his words:

> _"To me the flower of the proletariat is not, as it is to the Marxists, the
> upper layer, the aristocracy of labour, those who are the most cultured, who
> earn more and live more comfortably that all the other workers. Precisely
> this semi-bourgeois layer of workers would, if the Marxists had their way,
> constitute their **fourth governing class.** This could indeed happen if the
> great mass of the proletariat does not guard against it. By virtue of its
> relative well-being and semi-bourgeois position, this upper layer of workers
> is unfortunately only too deeply saturated with all the political and social
> prejudices and all the narrow aspirations and pretensions of the
> bourgeoisie. Of all the proletariat, this upper layer is the least
> socialist, the most individualist. _

> _"By the **flower of the proletariat** , I mean above all that great mass,
> those millions of the uncultivated, the disinherited, the miserable, the
> illiterates . . . I mean precisely that eternal 'meat' (on which governments
> thrive), that great **rabble of the people** (underdogs, 'dregs of society')
> ordinarily designated by Marx and Engels by the phrase . . .
> Lumpenproletariat"_ [ **Bakunin on Anarchism** , p. 294]

Thus Bakunin contrasted a _"semi-bourgeois"_ layer to the _"great mass of the
proletariat."_ In a later work, Bakunin makes the same point, namely that
there was _"a special category of relatively affluent workers, earning higher
wages, boasting of their literary capacities and . . . impregnated by a
variety of bourgeois prejudices . . . in Italy . . . they are insignificant in
number and influence . . . In Italy it is the extremely poor proletariat that
predominates. Marx speaks disdainfully, but quite unjustly, of this
**Lumpenproletariat.** For in them, and only in them, and not in the bourgeois
strata of workers, are there crystallised the entire intelligence and power of
the coming Social Revolution."_ [ **Op. Cit.** , p. 334] Again it is clear
that Bakunin is referring to a small minority within the working class and
**not** dismissing the working class as a whole. He explicitly pointed to the
_" **bourgeois-influenced** minority of the urban proletariat"_ and contrasted
this minority to _"the mass of the proletariat, both rural and urban."_ [
**Michael Bakunin: Selected Writings** , p. 254]

Clearly, Stack is distorting Bakunin's ideas on this subject when he claims
that Bakunin thought **all** workers were _"tainted by pretensions and
aspirations."_ In fact, like Marx, Engels and Lenin, Bakunin differentiated
between different types of workers. This did not mean he rejected organised
workers or skilled artisans nor the organisation of working people into
revolutionary unions, quite the reverse. As can be seen, Bakunin argued there
was a group of workers who accepted bourgeois society and did relatively well
under it. It was **these** workers who were _"frequently no less egoistic than
bourgeois exploiters, no less pernicious to the International than bourgeois
socialists, and no less vain and ridiculous than bourgeois nobles."_ [ **The
Basic Bakunin** , p. 108] It is comments like this that Marxists quote out of
context and use for their claims that Bakunin did not see the working class as
the agent of social change. However, rather than refer to the whole working
class, Stack quotes Bakunin's thoughts in relation to a minority strata within
it. Clearly, from the context, Bakunin **did not** mean **all** working class
people.

Also, let us not forget the historical context. After all, when Bakunin was
writing the vast majority of the working population across the world was, in
fact, illiterate and disinherited. To get some sort of idea of the numbers of
working people who would have been classed as _"the uncultivated, the
disinherited, the miserable, the illiterates"_ we have to provide some
numbers. In Spain, for example, _"in 1870, something like 60 per cent of the
population was illiterate."_ [Gerald Brenan, **The Spanish Labyrinth** , p.
50] In Russia, in 1897 (i.e. 21 years after Bakunin's death), _"only 21% of
the total population of European Russia was literate. This was mainly because
of the appallingly low rate of literacy in the countryside - 17% compared to
45% in the towns."_ [S.A. Smith, **Red Petrograd** , p. 34] Stack, in effect,
is excluding the majority of the working masses from the working class
movement **and** the revolution in the 1860-70s by his comments. Little wonder
Bakunin said what he said. By ignoring the historical context (as he ignores
the context of Bakunin's comments), Stack misleads the reader and presents a
distinctly distorted picture of Bakunin's thought.

In other words, Bakunin's comments on the _"flower of the proletariat"_ apply
to the majority of the working class during his lifetime and for a number of
decades afterwards and **not** to an underclass, not to what Marx termed the
"lumpenproletariat". As proven above, Bakunin's _"lumpenproletariat"_ is not
what Marxists mean by the term. If Bakunin had meant the same as Marx by the
"lumpenproletariat" then this would not make sense as the "lumpenproletariat"
for Marx were not wage workers. This can best be seen when Bakunin argues that
the International must organise this _"flower of the proletariat"_ and conduct
economic collective struggle against the capitalist class. In his other works
(and in the specific essay these quotes are derived from) Bakunin stressed the
need to organise all workers and peasants into unions to fight the state and
bosses and his arguments that workers associations should not only be the
means to fight capitalism but also the framework of an anarchist society.
Clearly, Sam Dolgoff's summary of Bakunin's ideas on this subject is the
correct one:

> _"Bakunin's **Lumpenproletariat** . . . was broader than Marx's, since it
> included all the submerged classes: unskilled, unemployed, and poor workers,
> poor peasant proprietors, landless agricultural labourers, oppressed racial
> minorities, alienated and idealistic youth, declasse intellectuals, and
> 'bandits' (by whom Bakunin meant insurrectionary 'Robin Hoods' like
> Pugachev, Stenka Razin, and the Italian Carbonari)."_ [ _"Introduction"_ ,
> **Bakunin on Anarchism** , pp. 13-4]

Moreover, the issue is clouded by translation issues as well. As Mark Leier
notes Bakunin _"rarely used the word 'lumpenproletariat.' While he does use
the French word **canaille** , this is better translated as 'mob' or 'rabble'
. . . When Bakunin does talk about the **canaille** or rabble, he usually
refers not to the lumpenproletariat as such but to the poorer sections of the
working class . . . While we might translate 'destitute proletariat' as
'lumpenproletariat,' Bakunin himself . . . is referring to a portion of the
proletariat and the peasantry, not the lumpenproletariat."_ [ **Bakunin: The
Creative Passion** , p. 221]

Nor is Stack the only Marxist to make such arguments as regards Bakunin. Paul
Thomas quotes Bakunin arguing that the working class _"remains socialist
without knowing it"_ because of _"the very force of its position"_ and _"all
the conditions of its material existence"_ and then, incredulously, adds that
_"[i]t is for this reason that Bakunin turned away from the proletariat and
its scientific socialism"_ towards the peasantry. [ **Karl Marx and the
Anarchists** , p. 291] A more distorted account of Bakunin's ideas would be
hard to find (and there is a lot of competition for that particular honour).
The quotes Thomas provides are from Bakunin's _"The Policy of the
International"_ in which he discussed his ideas on how the International
Working-Men's Association should operate (namely _"the collective struggle of
the workers against the bosses"_ ). At the time (and for some time after)
Bakunin called himself a revolutionary socialist and argued that by class
struggle, the worker would soon _"recognise himself [or herself] to be a
revolutionary socialist, and he [or she] will act like one."_ [ **The Basic
Bakunin** , p. 103] As such, the argument that the social position workers are
placed in makes them _"socialist without knowing"_ does not, in fact, imply
that Bakunin thought they would become Marxists ( _"scientific socialism"_ )
and, therefore, he turned against them. Rather, it meant that, for Bakunin,
anarchist ideas were a product of working class life and it was a case of
turning instinctive feelings into conscious thought by collective struggle. As
noted above, Bakunin did not _"turn away"_ from these ideas nor the
proletariat. Indeed, Bakunin held to the importance of organising the
proletariat (along with artisans and peasants) to the end of his life. Quite
simply, Thomas is distorting Bakunin's ideas.

Lastly, we have to point out a certain irony (and hypocrisy) in Marxist
attacks on Bakunin on this subject. This is because Marx, Engels and Lenin
held similar views on the corrupted _"upper strata"_ of the working class as
Bakunin did. Indeed, Marxists have a specific term to describe this semi-
bourgeois strata of workers, namely the _"labour aristocracy."_ Marx, for
example, talked about the trade unions in Britain being _"an aristocratic
minority"_ and the _"great mass of workers . . . has long been outside"_ them
(indeed, _"the most wretched mass has never belonged."_ ) [ **Collected
Works** , vol. 22, p. 614] Engels also talked about _"a small, privileged,
'protected' minority"_ within the working class, which he also called _"the
working-class aristocracy."_ [ **Op. Cit.** , vol. 27, p. 320 and p. 321]
Lenin approvingly quotes Engels arguing that the _"English proletariat is
actually becoming more and more bourgeois, so that this most bourgeois of all
nations is apparently aiming at the possession of . . . a bourgeois
proletariat **alongside** the bourgeoisie."_ [quoted by Lenin, **Collected
Works** , vol. 22, p. 283] Like Lenin, Engels explained this by the dominant
position of Britain within the world market. Indeed, Lenin argued that _"a
section of the British proletariat becomes bourgeois."_ For Lenin, imperialist
_"superprofits"_ make it _" **possible to bribe** the labour leaders and the
upper stratum of the labour aristocracy."_ This _"stratum of workers-turned-
bourgeois, or the labour aristocracy, who are quite philistine in their mode
of life, in the size of their earnings and in their entire outlook . . . are
the real **agents of the bourgeoisie in the working-class** movement, the
labour lieutenants of the capitalist class."_ [ **Op. Cit.** , p. 284 and p.
194]

As can be seen, this is similar to Bakunin's ideas and, ironically enough,
nearly identical to Stack's distortion of those ideas (particularly in the
case of Marx). However, only someone with a desire to lie would suggest that
any of them dismissed the working class as their _"agent of change"_ based on
this (selective) quoting. Unfortunately, that is what Stack does with Bakunin.
Ultimately, Stack's comments seem hypocritical in the extreme attacking
Bakunin while remaining quiet on the near identical comments of his heroes.

It should be noted that this analysis is confirmed by non-anarchists who have
actually studied Bakunin. Wayne Thorpe, an academic who specialises in
syndicalism, presents an identical summary of Bakunin's ideas on this matter.
[ **"The Workers Themselves"** , p. 280] Marxist selective quoting not
withstanding, for Bakunin (as another academic noted) _"it seemed self-evident
that the revolution, even in Eastern Europe, required the unity of peasantry
and city workers because of the latter's more advanced consciousness."_ The
notion that Bakunin stressed the role of the lumpenproletariat is a _"popular
stereotype"_ but is one _"more distorted by its decisive omissions than in
what it says."_ _"Marx"_ , he correctly summarised, _"accented the
revolutionary role of the urban proletariat and tended to deprecate the
peasantry, while Bakunin, although **accepting** the vanguard role of the
proletariat in the revolution, felt that the peasantry, too, approached
correctly, also had great potential for revolution."_ [Alvin W. Gouldner,
_"Marx's Last Battle: Bakunin and the First International"_ , pp. 853-884,
**Theory and Society** , Vol. 11, No. 6, p. 871, p. 869 and p. 869] This
flowed from Bakunin's materialist politics:

> _"Not restricting the revolution to those societies in which an advanced
> industrialism had produced a massive urban proletariat, Bakunin observed
> sensibly that the class composition of the revolution was bound to differ in
> industrially advanced Western Europe and in Eastern Europe where the economy
> was still largely agricultural . . . This is a far cry, then, from the
> Marxist stereotype of Bakunin-the-anarchist who relied exclusively on the
> backward peasantry and ignored the proletariat."_ [ **Op. Cit.** , p. 870]

All in all, once a historic and textual context is placed on Bakunin's words,
it is clear which social class was considered as the social revolution's
_"agents of change"_ : the working class (i.e. wage workers, artisans,
peasants and so on). In this, other revolutionary anarchists follow him.
Looking at Kropotkin we find a similar perspective to Bakunin's. In his first
political work, Kropotkin explicitly raised the question of _"where our
activity be directed"_ and answered it _"categorically"_ \- _"unquestionably
among the peasantry and urban workers."_ In fact, he _"consider[ed] this
answer the fundamental position in our practical program."_ This was because
_"the insurrection must proceed among the peasantry and urban workers
themselves"_ if it were to succeed. As such, revolutionaries _"must not stand
outside the people but among them, must serve not as a champion of some alien
opinions worked out in isolation, but only as a more distinct, more complete
expression of the demands of the people themselves."_ [ **Selected Writings on
Anarchism and Revolution** , pp. 85-6]

That was in 1873. Nearly 30 years later, Kropotkin expressed identical
opinions stating that he _"did not need to overrate the qualities of the
workers in order to espouse the cause of the social, predominantly workers'
revolution."_ The need was to _"forge solidarity"_ between workers and it was
_"precisely to awaken this solidarity - without which progress would be
difficult - that we must work to insure that the syndicates and the trade
unions not be pushed aside by the bourgeois."_ The social position of the
working class people ensured their key role in the revolution: _"Being
exploited today at the bottom of the social ladder, it is to his advantage to
demand equality. He has never ceased demanding it, he has fought for it and
will fight for it again, whereas the bourgeois . . . thinks it is to his
advantage to maintain inequality."_ Unsurprisingly, Kropotkin stressed that
_"I have always preached active participation in the workers' movement, in the
**revolutionary workers' movement** "_ [ **Op. Cit.** , p. 299, pp. 299-300,
p. 300 and p. 304]

Much the same can be said for the likes of Goldman, Berkman, Malatesta and so
on - as even a basic familiarity with their writings and activism would
confirm. Of all the major anarchist thinkers, it could be objected that Murray
Bookchin fits Stack's distortions. After all, he did attack _"The Myth of the
Proletariat"_ as the agent of revolutionary change, arguing that _"the
traditional class struggle ceases to have revolutionary implications; it
reveals itself as the physiology of the prevailing society, not as the labour
pains of birth."_ Yet, even here, Bookchin explicitly argued that he made _"no
claims that a social revolution is possible without the participation of the
industrial proletariat"_ and noted that he _"tries to show how the proletariat
can be won to the revolutionary movement by stressing issues that concern
quality of life and work."_ Thus _"class struggle does not centre around
material exploitation alone"_ but has a wider understanding which cannot be
reduced to _"a single class defined by its relationship to the means of
production."_ Like other anarchists, he saw social change coming from the
oppressed, as _"the alienated and oppressed sectors of society are now the
**majority** of the people."_ In other words, for Bookchin (if not other
anarchists) expressions like _"class struggle"_ simply _"fail to encompass the
cultural and spiritual revolt that is taking place along with the economic
struggle."_ [ **Post-Scarcity Anarchism** , p. 117, p. 150, p. 151 and p. 152]

So Bookchin's apparent rejection of class struggle and the "proletariat" is
not, on closer reading, any such thing. He urged a wider form of struggle, one
which includes issues such as hierarchy, oppression, ecological matters and so
on rather than the exclusive concern with economic exploitation and class
which many radicals (usually Marxists) focus on. Somewhat ironically, it
should be noted that this "rejection" in part flowed from Bookchin's own past
in the Stalinist and Trotskyist movements, both of which tended to idealise
the industrial worker and limit "proletarian" to that specific sub-section of
the working class. Bookchin himself expressed this blinkered perspective when
he _"dispose[d] of the notion that anyone is a 'proletarian' who has nothing
to sell but his labour power"_ as Marx and Engels considered that class as
_"reaching its most advanced form in the **industrial** proletariat, which
corresponded to the most advanced form of capital."_ [ **Op. Cit.** , p.
115fn] Sadly, Bookchin reinforced this debased notion of working class and our
struggle in the very process of trying to overcome it. Yet he always argued
for a wider concept of social struggle which included, but was not limited to,
economic class and exploitation and, as a result, included all sections of the
working class and not just workers in large-scale industry. In this he
followed a long anarchist tradition.

To conclude, for anarchists, the social revolution will be made by the working
class ( _"Anarchists, like Socialists, usually believe in the doctrine of
class war."_ [Bertrand Russell, **Roads to Freedom** , p. 38]). However, as
British anarchist Benjamin Franks summarises, _"[b]ecause anarchists hold to a
broader view of the working class, which includes the lumpenproletariat, they
have been accused of promoting this section above others. This standard
marxist interpretation of anarchism is inaccurate; anarchists simply include
the lumpenproletariat as part of the working class, rather than exclude or
exalt it."_ [ **Rebel Alliances** , p. 168] Ultimately, for anyone to claim
that Bakunin, or any social anarchist, rejects the working class as an agent
of social change simply shows their ignorance of the politics they are trying
to attack.

## H.2.8 What is the relationship of anarchism to syndicalism?

One of the most common Marxist techniques when they discuss anarchism is to
contrast the likes of Bakunin and Kropotkin to the revolutionary syndicalists.
The argument runs along the lines that "classical" anarchism is
individualistic and rejects working class organisation and power while
syndicalism is a step forward from it (i.e. a step closer to Marxism). Sadly,
such arguments simply show the ignorance of the author rather than any form of
factual basis. When the ideas of revolutionary anarchists like Bakunin and
Kropotkin are compared to revolutionary syndicalism, the similarities are soon
discovered.

This kind of argument can be found in Pat Stack's essay _"Anarchy in the UK?"_
After totally distorting the ideas of anarchists like Bakunin and Kropotkin,
Stack argues that anarcho-syndicalists _"tended to look to the spontaneity and
anti-statism of anarchism, the economic and materialist analysis of Marxism,
and the organisational tools of trade unionism. Practically every serious
anarchist organisation came from or leant on this tradition . . . The huge
advantage they had over other anarchists was their understanding of the power
of the working class, the centrality of the point of production (the
workplace) and the need for collective action."_ [ **Socialist Review** , no.
246]

Given that Stack's claims that anarchists reject the _"need for collective
action,"_ do not understand _"the power of the working class"_ and the
_"centrality"_ of the workplace are simply inventions, it would suggest that
Stack's _"huge advantage"_ does not, in fact, exist and is pure nonsense.
Bakunin, Kropotkin and all revolutionary anarchists, as proven in [section
H.2.2](secH2.md#sech22), already understood all this and based their
politics on the need for collective working class struggle at the point of
production. As such, by contrasting anarcho-syndicalism with anarchism (as
expressed by the likes of Bakunin and Kropotkin) Stack simply shows his utter
and total ignorance of his subject matter.

Moreover, if he bothered to read the works of the likes of Bakunin and
Kropotkin he would discover that many of their ideas were identical to those
of revolutionary syndicalism. For example, Bakunin argued that the
_"organisation of the trade sections, their federation in the International,
and their representation by Chambers of Labour, . . . [allow] the workers . .
. [to] combin[e] theory and practice . . . [and] bear in themselves the living
germs of **the social order** , which is to replace the bourgeois world. They
are creating not only the ideas but also the facts of the future itself."_
[quoted by Rudolf Rocker, **Anarcho-Syndicalism** , p. 50] Like the
syndicalists, he argued _"the natural organisation of the masses . . . is
organisation based on the various ways that their various types of work define
their day-to-day life; it is organisation by trade association"_ and once
_"every occupation . . . is represented within the International [Working-
Men's Association], its organisation, the organisation of the masses of the
people will be complete."_ Moreover, Bakunin stressed that the working class
had _"but a single path, that of **emancipation through practical action**_
which meant _"workers' solidarity in their struggle against the bosses"_ by _"
**trades-unions, organisation, and the federation of resistance funds** "_ [
**The Basic Bakunin** , p. 139 and p. 103]

Like the syndicalists, Bakunin stressed working class self-activity and
control over the class struggle:

> _"Toilers count no longer on anyone but yourselves. Do not demoralise and
> paralyse your growing strength by being duped into alliances with bourgeois
> Radicalism . . . Abstain from all participation in bourgeois Radicalism and
> organise outside of it the forces of the proletariat. The bases of this
> organisation are already completely given: they are the workshops and the
> federation of workshops, the creation of fighting funds, instruments of
> struggle against the bourgeoisie, and their federation, not only national,
> but international._

> _"And when the hour of revolution sounds, you will proclaim the liquidation
> of the State and of bourgeois society, anarchy, that is to say the true,
> frank people's revolution . . . and the new organisation from below upwards
> and from the circumference to the centre."_ [quoted by K.J. Kenafick,
> **Michael Bakunin and Karl Marx** , pp. 120-1]

Like the later syndicalists, Bakunin was in favour of a general strike as a
means of bringing about a social revolution. As _"strikes spread from one
place to another, they come close to turning into a general strike. And with
the ideas of emancipation that now hold sway over the proletariat, a general
strike can result only in a great cataclysm which forces society to shed its
old skin."_ He raised the possibility that this could _"arrive before the
proletariat is sufficiently organised"_ and dismissed it because the strikes
expressed the self-organisation of the workers for the _"necessities of the
struggle impel the workers to support one another"_ and the _"more active the
struggle becomes . . . the stronger and more extensive this federation of
proletarians must become."_ Thus strikes _"indicate a certain collective
strength already"_ and _"each strike becomes the point of departure for the
formation of new groups."_ He rejected the idea that a revolution could be
_"arbitrarily"_ made by _"the most powerful associations."_ Rather they were
produced by _"the force of circumstances."_ As with the syndicalists, Bakunin
argued that not all workers needed to be in unions before a general strike or
revolution could take place. A minority (perhaps _"one worker in ten")_ needed
to be organised and they would influence the rest so ensuring _"at critical
moments"_ the majority would _"follow the International's lead."_ [ **The
Basic Bakunin** , pp. 149-50, p. 109 and p. 139]

As with the syndicalists, the new society would be organised _"by free
federation, from below upwards, of workers' associations, industrial as well
as agricultural . . . in districts and municipalities at first; federation of
these into regions, of the regions into nations, and the nations into a
fraternal Internationalism."_ Moreover, _"capital, factories, all the means of
production and raw material"_ would be owned by _"the workers' organisations"_
while the land would be given _"to those who work it with their own hands."_
[quoted by Kenafick, **Op. Cit.** , p. 241 and p. 240] Compare this to the
syndicalist CGT's 1906 **Charter of Amiens** which declared _"the trade union
today is an organisation of resistance"_ but _"in the future [it will] be the
organisation of production and distribution, the basis of social
reorganisation."_ [quoted by Wayne Thorpe, **"The Workers Themselves"** , p.
201]

The similarities with revolutionary syndicalism could not be clearer. Little
wonder that all serious historians see the obvious similarities between
anarcho-syndicalism and Bakunin's anarchism. For example, George R. Esenwein's
(in his study of early Spanish anarchism) comments that syndicalism _"had deep
roots in the Spanish libertarian tradition. It can be traced to Bakunin's
revolutionary collectivism."_ He also notes that the class struggle was
_"central to Bakunin's theory."_ [ **Anarchist Ideology and the Working Class
Movement in Spain, 1868-1898** , p. 209 and p. 20] Caroline Cahm, likewise,
points to _"the basic syndicalist ideas of Bakunin"_ and that he _"argued that
trade union organisation and activity in the International [Working Men's
Association] were important in the building of working-class power in the
struggle against capital . . . He also declared that trade union based
organisation of the International would not only guide the revolution but also
provide the basis for the organisation of the society of the future."_ Indeed,
he _"believed that trade unions had an essential part to play in the
developing of revolutionary capacities of the workers as well as building up
the organisation of the masses for revolution."_ [ **Kropotkin and the Rise of
Revolutionary Anarchism** , p. 219, p. 215 and p. 216] Paul Avrich, in his
essay _"The Legacy of Bakunin,"_ agreed. _"Bakunin,"_ he stated, _"perhaps
even more than Proudhon, was a prophet of revolutionary syndicalism, who
believed that a free federation of trade unions would be the 'living germs of
a new social order which is to replace the bourgeois world.'"_ [ **Anarchist
Portraits** , pp. 14-15] Bertrand Russell noted that _"[h]ardly any of these
ideas [associated with syndicalism] are new: almost all are derived from the
Bakunist [sic!] section of the old International"_ and that this was _"often
recognised by Syndicalists themselves."_ [ **Roads to Freedom** , p. 52] The
syndicalists, notes Wayne Thorpe, _"identified the First International with
its federalist wing . . . [r]epresented . . . initially by the Proudhonists
and later and more influentially by the Bakuninists."_ [ **Op. Cit.** , p. 2]

Needless to say, anarchists agree with this perspective. Arthur Lehning, for
example, summarises the anarchist perspective when he commented that
_"Bakunin's collectivist anarchism . . . ultimately formed the ideological and
theoretical basis of anarcho-syndicalism."_ [ _"Introduction"_ , **Michael
Bakunin: Selected Writings** , p. 29] Anarchist academic David Berry also
notes that _"anarchist syndicalists were keen to establish a lineage with
Bakunin . . . the anarchist syndicalism of the turn of the century was a
revival of a tactic"_ associated with _"the Bakuninist International."_ [ **A
History of the French Anarchist Movement, 1917-1945** , p. 17] Another, Mark
Leier, points out that _"the Wobblies drew heavily on anarchist ideas
pioneered by Bakunin."_ [ **Bakunin: The Creative Passion** , p. 298]
Kropotkin argued that syndicalism _"is nothing other than the rebirth of the
International - federalist, worker, Latin."_ [quoted by Martin A. Miller,
**Kropotkin** , p. 176] Malatesta stated in 1907 that he had _"never ceased to
urge the comrades into that direction which the syndicalists, forgetting the
past, call **new** , even though it was already glimpsed and followed, in the
International, by the first of the anarchists."_ [ **The Anarchist Reader** ,
p. 221] Little wonder that Rudolf Rocker stated in his classic introduction to
the subject that anarcho-syndicalism was _"a direct continuation of those
social aspirations which took shape in the bosom of the First International
and which were best understood and most strongly held by the libertarian wing
of the great workers' alliance."_ [ **Anarcho-Syndicalism** , p. 54] Murray
Bookchin just stated the obvious:

> _"Long before syndicalism became a popular term in the French labour
> movement of the late [eighteen]nineties, it already existed in the Spanish
> labour movement of the early seventies. The anarchist-influenced Spanish
> Federation of the old IWMA was . . . distinctly syndicalist."_ [ _"Looking
> Back at Spain,"_ pp. 53-96, Dimitrios I. Roussopoulos (ed.), **The Radical
> Papers** , p. 67]

Perhaps, in the face of such evidence (and the writings of Bakunin himself),
Marxists could claim that the sources we quote are either anarchists or
"sympathetic" to anarchism. To counter this is very easy, we need only quote
Marx and Engels. Marx attacked Bakunin for thinking that the _"working class .
. . must only organise themselves by trades-unions"_ and _"not occupy itself
with **politics.** "_ Engels argued along the same lines, having a go at the
anarchists because in the _"Bakuninist programme a general strike is the lever
employed by which the social revolution is started"_ and that they admitted
_"this required a well-formed organisation of the working class"_ (i.e. a
trade union federation). Indeed, he summarised Bakunin's strategy as being to
_"organise, and when **all** the workers, hence the majority, are won over,
dispose all the authorities, abolish the state and replace it with the
organisation of the International."_ [Marx, Engels and Lenin, **Anarchism and
Anarcho-Syndicalism** , p. 48, p. 132, p. 133 and p. 72] Ignoring the
misrepresentations of Marx and Engels about the ideas of their enemies, we can
state that they got the basic point of Bakunin's ideas - the centrality of
trade union organisation and struggle as well as the use of strikes and the
general strike. Therefore, you do not have to read Bakunin to find out the
similarities between his ideas and syndicalism, you can read Marx and Engels.
Clearly, most Marxist critiques of anarchism have not even done that!

Later anarchists, needless to say, supported the syndicalist movement and,
moreover, drew attention to its anarchist roots. Emma Goldman noted that in
the First International _"Bakunin and the Latin workers"_ forged ahead _"along
industrial and Syndicalist lines"_ and stated that syndicalism _"is, in
essence, the economic expression of Anarchism"_ and that _"accounts for the
presence of so many Anarchists in the Syndicalist movement. Like Anarchism,
Syndicalism prepares the workers along direct economic lines, as conscious
factors in the great struggles of to-day, as well as conscious factors in the
task of reconstructing society."_ After seeing syndicalist ideas in action in
France in 1900, she _"immediately began to propagate Syndicalist ideas."_ The
_"most powerful weapon"_ for liberation was _"the conscious, intelligent,
organised, economic protest of the masses through direct action and the
general strike."_ [ **Red Emma Speaks** , p. 89, p. 91, p. 90 and p. 60]

Kropotkin argued anarchist communism _"wins more and more ground among those
working-men who try to get a clear conception as to the forthcoming
revolutionary action. The syndicalist and trade union movements, which permit
the workingmen to realise their solidarity and to feel the community of their
interests better than any election, prepare the way for these conceptions."_ [
**Anarchism** , p. 174] His support for anarchist participation in the labour
movement was strong, considering it a key method of preparing for a revolution
and spreading anarchist ideas amongst the working classes: _"The **syndicat**
is absolutely necessary. It is the sole force of the workers which continues
the direct struggle against capital without turning to parliamentarism."_
[quoted by Miller, **Op. Cit.** , p. 177]

_"Revolutionary Anarchist Communist propaganda within the Labour Unions,"_
Kropotkin stressed, _"had always been a favourite mode of action in the
Federalist or 'Bakuninist' section of the International Working Men's
Association. In Spain and in Italy it had been especially successful. Now it
was resorted to, with evident success, in France and **Freedom** [the British
Anarchist paper he helped create in 1886] eagerly advocated this sort of
propaganda."_ [ **Act For Yourselves** , pp. 119-20] Caroline Cahm notes in
her excellent account of Kropotkin's ideas between 1872 and 1886, he _"was
anxious to revive the International as an organisation for aggressive strike
action to counteract the influence of parliamentary socialists on the labour
movement."_ This resulted in Kropotkin advocating a _"remarkable fusion of
anarchist communist ideas with both the bakuninist [sic!] internationalist
views adopted by the Spanish Federation and the syndicalist ideas developed in
the Jura Federation in the 1870s."_ This included seeing the importance of
revolutionary labour unions, the value of strikes as a mode of direct action
and syndicalist action developing solidarity. _"For Kropotkin,"_ she
summarises, _"revolutionary syndicalism represented a revival of the great
movement of the Anti-authoritarian International . . . It seems likely that he
saw in it the [strikers International] which he had advocated earlier."_ [
**Op. Cit.** , p. 257 and p. 268]

Clearly, any one claiming that there is a fundamental difference between
anarchism and syndicalism is talking nonsense. Syndicalist ideas were being
argued by the likes of Bakunin and Kropotkin before syndicalism emerged in the
French CGT in the 1890s as a clearly labelled revolutionary theory. Rather
than being in conflict, the ideas of syndicalism find their roots in the ideas
of Bakunin and "classical" anarchism. This would be quickly seen if the actual
writings of Bakunin and Kropotkin were consulted. There **are,** of course,
differences between anarchism and syndicalism, but they are **not** those
usually listed by Marxists ([section J.3.9](secJ3.md#secj39) discusses these
differences and, as will quickly be discovered, they are **not** based on a
rejection of working class organisation, direct action, solidarity and
collective struggle!).

Ultimately, claims like Pat Stack's simply show how unfamiliar the author is
with the ideas they are pathetically attempting to critique. Anarchists from
Bakunin onwards shared most of the same ideas as syndicalism (which is
unsurprising as most of the ideas of anarcho-syndicalism have direct roots in
the ideas of Bakunin). In other words, for Stack, the _"huge advantage"_
anarcho-syndicalists have _"over other anarchists"_ is that they, in fact,
share the same _"understanding of the power of the working class, the
centrality of the point of production (the workplace) and the need for
collective action"_! This, in itself, shows the bankruptcy of Stack's claims
and those like it.

## H.2.9 Do anarchists have _"liberal"_ politics?

Another assertion by Marxists is that anarchists have _"liberal"_ politics or
ideas. For example, one Marxist argues that the _"programme with which Bakunin
armed his super-revolutionary vanguard called for the 'political, economic and
social equalisation of classes and individuals of both sexes, beginning with
the abolition of the right of inheritance.' This is **liberal** politics,
implying nothing about the abolition of capitalism."_ [Derek Howl, _"The
Legacy of Hal Draper,"_ pp. 137-49, **International Socialism** , no. 52, p.
148]

That Howl is totally distorting Bakunin's ideas can quickly be seen by looking
at the whole of the programme. The passage quoted is from item 2 of the
_"Programme of the Alliance."_ Strangely Howl fails to quote the end of that
item, namely when it states this _"equalisation"_ was _"in pursuance of the
decision reached by the last working men's Congress in Brussels, the land, the
instruments of work and all other capital may become the collective property
of the whole of society and be utilised only by the workers, in other words by
the agricultural and industrial associations."_ If this was not enough to
indicate the abolition of capitalism, item 4 states that the Alliance
_"repudiates all political action whose target is anything except the triumph
of the workers' cause over Capital."_ [ **Michael Bakunin: Selected Writings**
, p. 174]

Howl's dishonesty is clear. Bakunin **explicitly** argued for the abolition of
capitalism in the same item Howl (selectively) quotes from. If the
socialisation of land and capital under the control of workers' associations
is not the abolition of capitalism, we wonder what is!

Equally as dishonest as this quoting out of context is Howl's non-mention of
the history of the expression _"political, economic and social equalisation of
classes and individuals of both sexes."_ After Bakunin sent the Alliance
programme to the General Council of the **International Workingmen's
Association** , he received a letter dated March 9, 1869 from Marx which
stated that the term _"the equalisation of classes"_ _"literally interpreted"_
would mean _"harmony of capital and labour"_ as _"persistently preached by the
bourgeois socialists."_ Marx argued that it was _"not the logically impossible
'equalisation of classes', but the historically necessary, superseding
'abolition of classes'"_ which was the _"true secret of the proletarian
movement"_ and which _"forms the great aim of the International Working Men's
Association."_ Significantly, the letter adds the following: _"Considering,
however, the context in which that phrase 'equalisation of classes' occurs, it
seems to be a mere slip of the pen, and the General Council feels confident
that you will be anxious to remove from your program an expression which
offers such a dangerous misunderstanding."_ [ **Collected Works** , vol. 21,
p. 46]

Given the context, Marx was right. The phrase _"equalisation of classes"_
placed in the context of the political, economic and social equalisation of
individuals obviously implies the abolition of classes. The logic is simple.
If both worker and capitalist shared the same economic and social position
then wage labour would not exist (in fact, it would be impossible as it is
based on social and economic **inequality** ) and so class society would not
exist. Similarly, if the tenant and the landlord were socially equal then the
landlord would have no power over the tenant, which would be impossible.
Bakunin agreed with Marx on the ambiguity of the term and the Alliance changed
its Programme to call for _"the final and total abolition of classes and the
political, economic and social equalisation of individuals of either sex."_
[Bakunin, **Op. Cit.** p. 174] This change ensured the admittance of the
Alliance sections into the International Workingmen's Association (although
this did not stop Marx, like his followers, bringing up this _"mere slip of
the pen"_ years later). However, Howl repeating the changed phrase
_"equalisation of classes"_ out of context helps discredit anarchism and so it
is done.

Simply put, anarchists are **not** liberals. We are well aware of the fact
that without equality, liberty is impossible except for the rich. As Nicolas
Walter put it: _"Like liberals, anarchists want freedom; like socialists,
anarchists want equality. But we are not satisfied by liberalism alone or by
socialism alone. Freedom without equality means that the poor and weak are
less free than the rich and strong, and equality without freedom means that we
are all slaves together. Freedom and equality are not contradictory, but
complementary; in place of the old polarisation of freedom versus equality -
according to which we are told that more freedom equals less equality, and
more equality equals less freedom - anarchists point out that in practice you
cannot have one without the other. Freedom is not genuine if some people are
too poor or too weak to enjoy it, and equality is not genuine is some people
are ruled by others."_ [ **About Anarchism** , p. 29] Clearly, anarchists do
**not** have liberal politics. Quite the reverse, as we subject these to
extensive critique from a working class perspective.

To the claim that anarchism _"combines a socialist critique of capitalism with
a liberal critique of socialism,"_ anarchists reply that it is mistaken. [Paul
Thomas, **Karl Marx and the Anarchists** , p. 7] Rather, anarchism is simply a
socialist critique of both capitalism and the state. Freedom under capitalism
is fatally undermined by inequality - it simply becomes the freedom to pick a
master. This violates liberty and equality, as does the state. _"Any State at
all,"_ argued Bakunin, _"no matter what kind, is a domination and
exploitation. It is a negation of Socialism, which wants an equitable human
society delivered from all tutelage, from all authority and political
domination as well as economic exploitation."_ [quoted by Kenafick, **Op.
Cit.** , pp. 95-6] As such, state structures violate not only liberty but also
equality. There is no real equality in power between, say, the head of the
government and one of the millions who may, or may not, have voted for them.
As the Russian Revolution proved, there can be no meaningful equality between
a striking worker and the "socialist" political police sent to impose the will
of the state, i.e., the "socialist" ruling elite.

This means that if anarchists are concerned about freedom (both individual
**and** collective) it is not because we are influenced by liberalism. Quite
the reverse, as liberalism happily tolerates hierarchy and the restrictions of
liberty implied by private property, wage labour and the state. As Bakunin
argued, capitalism turns _"the worker into a subordinate, a passive and
obedient servant."_ [ **The Political Philosophy of Bakunin** , p. 188] So
anarchism rejects liberalism (although, as Bakunin put it, _"[i]f socialism
disputes radicalism, this is hardly to reverse it but rather to advance it."_
[ **The Basic Bakunin** , p. 87]). Therefore, anarchism rejects liberalism,
not because it supports the idea of freedom, but precisely because it does not
go far enough and fails to understand that without equality, freedom is little
more than freedom for the master. In fact, as we argue in [section
H.4](secH4.md), it is Marxism itself which has a distinctly liberal
perspective of freedom, seeing it restricted by association rather than
association being an expression of it.

Lastly, a few words on the mentality that could suggest that anarchist concern
for liberty means that it is a form of liberalism. Rather than suggest the
bankruptcy of anarchism it, in fact, suggests the bankruptcy of the politics
of the person making the accusation. After all, the clear implication is that
a concern with individual, collective and social freedom is alien to socialist
ideas. It also strikes at the heart of socialism - its concern for equality -
as it clearly implies that some have more power (namely the right to suppress
the liberty of others) than the rest. As such, it suggests a superficial
understanding of **real** socialism (see also our discussion of Marxist claims
about anarchist "elitism" in [section H.2.11](secH2.md#sech211)).

To argue that a concern for freedom means _"liberalism"_ (or, equally,
_"individualism"_ ) indicates that the person is not a socialist. After all, a
concern that every individual controls their daily lives (i.e. to be free)
means a wholehearted support for collective self-management of group affairs.
It means a vision of a revolution (and post-revolutionary society) based on
direct working class participation and management of society from below
upwards. To dismiss this vision by dismissing the principles which inspire it
as _"liberalism"_ means to support rule from above by the "enlightened" elite
(i.e. the party) and the hierarchical state structures. It means arguing for
**party** power, not **class** power, as liberty is seen as a **danger** to
the revolution and so the people must be protected against the "petty-
bourgeois"/"reactionary" narrowness of the people (to requote Bakunin, _"every
state, even the pseudo-People's State concocted by Mr. Marx, is in essence
only a machine ruling the masses from above, through a privileged minority of
conceited intellectuals who imagine that they know what the people need and
want better than do the people themselves."_ [ **Bakunin on Anarchism** , p.
338]). Rather than seeing free debate of ideas and mass participation as a
source of strength, it sees it as a source of "bad influences" which the
masses must be protected from.

Moreover, it suggests a total lack of understanding of the difficulties that a
social revolution will face. Unless it is based on the active participation of
the majority of a population, any revolution will fail. The construction of
socialism, of a new society, will face thousands of unexpected problems and
seek to meet the needs of millions of individuals, thousands of communities
and hundreds of cultures. Without the individuals and groups within that
society being in a position to freely contribute to that constructive task, it
will simply wither under the bureaucratic and authoritarian rule of a few
party leaders. As such, individual liberties are an essential aspect of
**genuine** social reconstruction - without freedom of association, assembly,
organisation, speech and so on, the active participation of the masses will be
replaced by an isolated and atomised collective of individuals subjected to
autocratic rule from above.

As ex-anarchist turned Bolshevik Victor Serge concluded in the late 1930s
(when it was far too late) the _"fear of liberty, which is the fear of the
masses, marks almost the entire course of the Russian Revolution. If it is
possible to discover a major lesson, capable of revitalising Marxism . . . one
might formulate it in these terms: Socialism is essentially democratic -- the
word, 'democratic', being used here in its libertarian sense."_ [ **The Serge-
Trotsky Papers** , p. 181]

Ultimately, as Rudolf Rocker suggested, the _"urge for social justice can only
develop properly and be effective, when it grows out of man's sense of
personal freedom and it based on that. In other words **Socialism will be
free, or it will not be at all.** In its recognition of this lies the genuine
and profound justification for the existence of Anarchism."_ [ **Anarcho-
Syndicalism** , p. 14]

## H.2.10 Are anarchists against leadership?

It is a common assertion by Marxists that anarchists reject the idea of
_"leadership"_ and so think in terms of a totally spontaneous revolution. This
is also generally understood to imply that anarchists do not see the need for
revolutionaries to organise together to influence the class struggle in the
here and now. Hence the British SWP's Duncan Hallas:

> _"That an organisation of socialist militants is necessary is common ground
> on the left, a few anarchist purists apart. But what kind of organisation?
> One view, widespread amongst newly radicalised students and young workers,
> is that of the libertarians . . . [They have] hostility to centralised, co-
> ordinated activity and profound suspicion of anything smacking of
> 'leadership.' On this view nothing more than a loose federation of working
> groups is necessary or desirable. The underlying assumptions are that
> centralised organisations inevitably undergo bureaucratic degeneration and
> that the spontaneous activities of working people are the sole and
> sufficient basis for the achievement of socialism . . . some libertarians
> draw the conclusion that a revolutionary socialist party is a contradiction
> in terms. This, of course, is the traditional anarcho-syndicalist
> position."_ [ **Towards a revolutionary socialist party** , p. 39]

Ignoring the usual patronising references to the age and experience of non-
Leninists, this argument can be faulted on many levels. Firstly, while
libertarians do reject centralised structures, it does **not** mean we reject
co-ordinated activity. This may be a common Marxist argument, but it is a
straw man one. Secondly, anarchists do **not** reject the idea of
_"leadership."_ We simply reject the idea of hierarchical leadership. Thirdly,
while all anarchists do think that a _"revolutionary socialist party"_ is a
contradiction in terms, it does not mean that we reject the need for
revolutionary organisations (i.e. organisations of anarchists). While opposing
centralised and hierarchical political parties, anarchists have long saw the
need for anarchist groups and federations to discuss and spread our ideas and
influence. We will discuss each issue in turn.

The first argument is the least important. For Marxists, co-ordination equals
centralism and to reject centralisation means to reject co-ordination of joint
activity. For anarchists, co-ordination does not mean centralism or
centralisation. This is why anarchism stresses federation and federalism as
the means of co-ordinating joint activity. Under a centralised system, the
affairs of all are given over to a handful of people at the centre. Their
decisions are then binding on the mass of the members of the organisation
whose position is simply that of executing the orders of those whom the
majority elect. This means that power rests at the top and decisions flow from
the top downwards. As such, the "revolutionary" party simply mimics the very
society it claims to oppose (see [section H.5.6](secH5.md#sech56)) as well
as being extremely ineffective (see [section H.5.8](secH5.md#sech58))

In a federal structure, in contrast, decisions flow from the bottom up by
means of councils of elected, mandated and recallable **delegates**. In fact,
we discover anarchists like Bakunin and Proudhon arguing for elected, mandated
and recallable delegates rather than for representatives in their ideas of how
a free society worked years before the Paris Commune applied them in practice.
The federal structure exists to ensure that any co-ordinated activity
accurately reflects the decisions of the membership. As such, anarchists _"do
not deny the need for co-ordination between groups, for discipline, for
meticulous planning, and for unity in action. But they believe that co-
ordination, discipline, planning, and unity in action must be achieved
**voluntarily,** by means of a self-discipline nourished by conviction and
understanding, not by coercion and a mindless, unquestioning obedience to
orders from above."_ This means we _"vigorously oppose the establishment of an
organisational structure that becomes an end in itself, of committees that
linger on after their practical tasks have been completed, of a 'leadership'
that reduces the 'revolutionary' to a mindless robot."_ [Murray Bookchin,
**Post-Scarcity Anarchism** , p. 139] In other words, co-ordination comes
**_from below_** rather than being imposed from above by a few leaders. To use
an analogy, federalist co-ordination is the co-ordination created in a strike
by workers resisting their bosses. It is created by debate amongst equals and
flows from below upwards. Centralised co-ordination is the co-ordination
imposed from the top-down by the boss.

Secondly, anarchists are not against all forms of _"leadership."_ We are
against hierarchical and institutionalised forms of leadership. In other
words, of giving **power** to leaders. This is the key difference, as Albert
Meltzer explained. _"In any grouping some people,"_ he argued, _"do naturally
'give a lead.' But this should not mean they are a class apart. What they
always reject is institutionalised leadership. That means their supporters
become blind followers and the leadership not one of example or originality
but of unthinking acceptance."_ Any revolutionary in a factory where the
majority have no revolutionary experience, will at times, "give a lead."
However, _"no real Anarchist . . . would agree to be part of an
**institutionalised leadership.** Neither would an Anarchist wait for a lead,
but give one."_ [ **Anarchism: Arguments for and against** , p. 58 and p. 59]

This means, as we argue in [section J.3.6](secJ3.md#secj36), that anarchists
seek to influence the class struggle as **equals.** Rather than aim for
positions of power, anarchists want to influence people by the power of their
ideas as expressed in the debates that occur in the organisations created in
the social struggle itself. This is because anarchists recognise that there is
an unevenness in the level of ideas within the working class. This fact is
obvious. Some workers accept the logic of the current system, others are
critical of certain aspects, others (usually a minority) are consciously
seeking a better society (and are anarchists, ecologists, Marxists, etc.) and
so on. Only constant discussion, the clash of ideas, combined with collective
struggle can develop political awareness and narrow the unevenness of ideas
within the oppressed: _"Only freedom or the struggle for freedom can be the
school for freedom."_ [Malatesta, **Errico Malatesta: His Life and Ideas** ,
p. 59]

From this perspective, it follows that any attempt to create an
institutionalised leadership structure means the end of the revolutionary
process. Such "leadership" automatically means a hierarchical structure, one
in which the leaders have power and make the decisions for the rest. This just
reproduces the old class division of labour between those who think and those
who act (i.e. between order givers and order takers). Rather than the
revolutionary masses taking power in such a system, it is the "leaders" (i.e.
a specific party hierarchy) who do so and the masses role becomes, yet again,
simply that of selecting which boss tells them what to do.

So the anarchist federation does not reject the need of "leadership" in the
sense of giving a lead, of arguing its ideas and trying to win people to them.
It does reject the idea that "leadership" should become separated from the
mass of the people. Simply put, no party, no group of leaders have all the
answers and so the active participation of all is required for a successful
revolution. It is not a question of organisation versus non-organisation, or
"leadership" versus non-"leadership" but rather what **_kind_** of
organisation and the **_kind_** of leadership.

Clearly, then, anarchists do not reject or dismiss the importance of
politically aware minorities organising and spreading their ideas within
social struggles. As Caroline Cahm summarised in her excellent study of
Kropotkin's thought, _"Kropotkin stressed the role of heroic minorities in the
preparation for revolution."_ [ **Kropotkin and the Rise of Revolutionary
Anarchism, 1872-86** , p. 276] Yet, as John Crump correctly argued, the _"key
words here are **in the preparation for revolution.** By their courage and
daring in opposing capitalism and the state, anarchist minorities could teach
by example and thereby draw increasing numbers into the struggle. But
Kropotkin was not advocating substitutionism; the idea that a minority might
carry out the revolution in place of the people was as alien to him as the
notion that a minority would exercise rule after the revolution. In fact,
Kropotkin recognised that the former would be a prescription for the latter."_
[ **Hatta Shuzo and Pure Anarchism in Interwar Japan** , p. 9] In Kropotkin's
own words:

> _"The idea of anarchist communism, today represented by feeble minorities,
> but increasingly finding popular expression, will make its way among the
> mass of the people. Spreading everywhere, the anarchist groups . . . will
> take strength from the support they find among the people, and will raise
> the red flag of the revolution . . . On that day, what is now the minority
> will become the People, the great mass, and that mass rising against
> property and the State, will march forward towards anarchist communism."_ [
> **Words of a Rebel** , p. 75]

This influence would be gained simply by the correctness of our ideas and the
validity of our suggestions. This means that anarchists seek influence
_"through advice and example, leaving the people . . . to adopt our methods
and solutions if these are, or seem to be, better than those suggested and
carried out by others."_ As such, any anarchist organisation would _"strive
acquire overwhelming influence in order to draw the [revolutionary] movement
towards the realisation of our ideas. But such influence must be won by doing
more and better than others, and will be useful if won in that way."_ This
means rejecting _"taking over command, that is by becoming a government and
imposing one's own ideas and interests through police methods."_ [Malatesta,
**The Anarchist Revolution** , pp. 108-9]

Moreover, unlike leading Marxists like Lenin and Karl Kautsky, anarchists
think that socialist ideas are developed **within** the class struggle rather
than outside it by the radical intelligentsia (see [section H.5](secH5.md)).
Kropotkin argued that _"modern socialism has emerged out of the depths of the
people's consciousness. If a few thinkers emerging from the bourgeoisie have
given it the approval of science and the support of philosophy, the basis of
the idea which they have given their own expression has nonetheless been the
product of the collective spirit of the working people. The rational socialism
of the International is still today our greatest strength, and it was
elaborated in working class organisation, under the first influence of the
masses. The few writers who offered their help in the work of elaborating
socialist ideas have merely been giving form to the aspirations that first saw
their light among the workers."_ [ **Op. Cit.** , p. 59] In other words,
anarchists are a part of the working class (either by birth or by rejecting
their previous class background and becoming part of it), the part which has
generalised its own experiences, ideas and needs into a theory called
_"anarchism"_ and seeks to convince the rest of the validity of its ideas and
tactics. This would be a dialogue, based on both learning **and** teaching.

As such, this means that the relationship between the specifically anarchist
groups and oppressed peoples in struggle is a two way one. As well as trying
to influence the social struggle, anarchists also try and learn from the class
struggle and try to generalise from the experiences of their own struggles and
the struggles of other working class people. Rather than seeing the anarchist
group as some sort of teacher, anarchists see it as simply part of the social
struggle and its ideas can and must develop from active participation within
that struggle. As anarchists agree with Bakunin and reject the idea that their
organisations should take power on behalf of the masses, it is clear that such
groups are not imposing alien ideas upon people but rather try to clarify the
ideas generated by working class people in struggle. It is an objective fact
that there is a great difference in the political awareness within the masses
of oppressed people. This uneven development means that they do not accept,
all at once or in their totality, revolutionary ideas. There are layers.
Groups of people, by ones and twos and then in larger numbers, become
interested, read literature, talk with others, and create new ideas. The first
groups that explicitly call their ideas _"anarchism"_ have the right and duty
to try to persuade others to join them. This is not opposed to the self-
organisation of the working class, rather it is how working class people self-
organise.

Lastly, most anarchists recognise the need to create specifically anarchist
organisations to spread anarchist ideas and influence the class struggle.
Suffice to say, the idea that anarchists reject this need to organise
politically in order to achieve a revolution is not to be found in the theory
and practice of all the major anarchist thinkers nor in the history and
current practice of the anarchist movement itself. As Leninists themselves, at
times, admit. Ultimately, if spontaneity was enough to create (and ensure the
success of) a social revolution then we would be living in a libertarian
socialist society. The fact that we are not suggests that spontaneity, however
important, is not enough in itself. This simple fact of history is understood
by anarchists and we organise ourselves appropriately.

See [section J.3](secJ3.md) for more details on what organisations
anarchists create and their role in anarchist revolutionary theory ([Section
J.3.6](secJ3.md#secj36), for example, has a fuller discussion of the role of
anarchist groups in the class struggle). For a discussion of the role of
anarchists in a revolution, see [section J.7.5](secJ7.md#secj75).

## H.2.11 Are anarchists _"anti-democratic"_?

One of the common arguments against anarchism is that it is _"anti-
democratic"_ (or _"elitist"_ ). For example, a member of the British
**Socialist Workers Party** denounces anarchism for being _"necessarily deeply
anti-democratic"_ due to its _"thesis of the absolute sovereignty of the
individual ego as against the imposition of **any** 'authority' over it,"_
which, it is claimed, is the _"distinctly anarchist concept."_ This position
is an _"idealist conception"_ in which _" **any** authority is seen as
despotic; 'freedom' and 'authority' (and therefore 'freedom' and 'democracy')
are opposites. This presumption of opposition to 'authority' was fostered by
liberalism."_ This is contrasted with the Marxist _"materialist understanding
of society"_ in which it _"was clear that 'authority' is necessary in **any**
society where labour is collaborative."_ [Derek Howl, _"The Legacy of Hal
Draper,"_ pp. 137-49, **International Socialism** , no. 52, p. 145] Hal Draper
is quoted arguing that:

> _By the 'principle of authority' the consistent anarchist means principled
> opposition to any exercise of authority, including opposition to authority
> derived from the most complete democracy and exercised in completely
> democratic fashion . . . Of all ideologies, anarchism is the one most
> fundamentally anti-democratic in principle, since it is not only unalterably
> hostile to democracy in general but particularly to any socialist democracy
> of the most ideal kind that could be imagined."_

Such an argument is just ridiculous. Indeed, it is flawed on so many levels
its hard to know where to start. The obvious place is the claim that anarchism
is the most _"fundamentally anti-democratic in principle."_ Now, given that
there are fascists, monarchists, supporters (like Trotsky) of _"party
dictatorship"_ and a host of others who advocate minority rule (even by one
person) over everyone else, can it be argued with a straight face that
anarchism is the most _"anti-democratic"_ because it argues for the liberty of
all? Is the idea and practice of absolute monarchy and fascism **really** more
democratic than anarchism? Clearly not, although this does indicate the
quality of this kind of argument. Equally, the notion that liberalism rests on
a _"presumption of opposition to 'authority'"_ cannot be supported by even a
casual understanding of the subject. That ideology has always sought ways to
justify the authority structures of the liberal state not to mention the
hierarchies produced by capitalist private property. So the notion that
liberalism is against "authority" is hard to square with both its theory and
reality.

Another obvious point is that anarchists do not see **any** authority as
_"despotic."_ As we discuss in [section H.4](secH4.md), this common Marxist
assertion is simply not true. Anarchists have always been very clear on the
fact they reject specific kinds of authority and not _"authority"_ as such. In
fact, by the term _"principal of authority,"_ Bakunin meant **hierarchical**
authority, and not all forms of _"authority"_. This explains why Kropotkin
argued that _"the origin of the anarchist conception of society"_ lies in
_"the criticism"_ of the _"hierarchical organisations and the authoritarian
conceptions of society"_ and stressed that anarchism _"refuses all
hierarchical organisation."_ [ **Anarchism** , p. 158 and p. 137]

This means, just to state the obvious, that making and sticking by collective
decisions are **not** acts of authority. Rather they are simply expressions of
individual autonomy. Clearly in most activities there is a need to co-operate
with other people. Indeed, **living** involves the _"absolute sovereignty of
the individual ego"_ (as if anarchists like Bakunin used such terms!) being
_"restricted"_ by exercising that _"sovereignty."_ Take, for example, playing
football. This involves finding others who seek to play the game, organising
into teams, agreeing on rules and so on. All terrible violations of the
_"absolute sovereignty of the individual ego,"_ yet it was precisely the
_"sovereignty"_ of the _"individual"_ which produced the desire to play the
game in the first place. What sort of _"sovereignty"_ is it that negates
itself when it is exercised? Clearly, then, the Marxist "summary" of anarchist
ideas on this matter, like of many others, is poverty stricken.

And, unsurprisingly enough, we find anarchist thinkers like Bakunin and
Kropotkin attacking this idea of _"the absolute sovereignty of the individual
ego"_ in the most severe terms. Indeed, they thought it was a bourgeois theory
which simply existed to justify the continued domination and exploitation of
working class people by the ruling class. Kropotkin quite clearly recognised
its anti-individual and unfree nature by labelling it _"the authoritarian
individualism which stifles us"_ and stressing its _"narrow-minded, and
therefore foolish"_ nature. [ **Conquest of Bread** , p. 130] Similarly, it
would do the Marxist argument little good if they quoted Bakunin arguing that
the _"freedom of individuals is by no means an individual matter. It is a
collective matter, a collective product. No individual can be free outside of
human society or without its co-operation"_ or that he considered
_"individualism"_ as a _"bourgeois principle."_ [ **The Basic Bakunin** , p.
46 and p. 57] He had nothing but contempt for, as he put it, _"that
individualistic, egotistical, malicious and illusory freedom"_ which was
_"extolled"_ by all the _"schools of bourgeois liberalism."_ [ **Michael
Bakunin: Selected Writings** , p. 196]

Perhaps, of course, these two famous anarchists were not, in fact,
_"consistent"_ anarchists, but that claim is doubtful.

The notion that anarchism is inherently an extreme form of "individualism"
seems to be the great assumption of Marxism. Hence the continual repetition of
this "fact" and the continual attempt to link revolutionary anarchism with
Stirner's ideas (the only anarchist to stress the importance of the _"ego"_ ).
Thus we find Engels talking about _"Stirner, the great prophet of contemporary
anarchism - Bakunin has taken a great deal from him . . . Bakunin blended
[Stirner] with Proudhon and labelled the blend 'anarchism'"_ For Marx,
_"Bakunin has merely translated Proudhon's and Stirner's anarchy into the
crude language of the Tartars."_ [Marx, Engels and Lenin, **Anarchism and
Anarcho-Syndicalism** , p. 175 and p. 153] In reality, of course, Stirner was
essentially unknown to the anarchist movement until his book was rediscovered
in the late nineteenth century and even then his impact was limited. In terms
of Bakunin, while his debt to Proudhon is well known and obvious, the link
with Stirner seems to have existed only in the heads of Marx and Engels. As
Mark Leier notes, _"there is no evidence of this . . . Bakunin mentions
Stirner precisely once in his collected works, and then only in passing . . .
as far as can be determined, Bakunin had no interest, even a negative one, in
Stirner's ideas."_ [ **Bakunin: The Creative Passion** , p. 97] Nor was
Proudhon influenced by Stirner (it is doubtful he even knew of him) while
Stirner criticised the French anarchist. Does that mean Stirner is the only
"consistent" anarchist? Moreover, even in terms of Stirner, Marxist diatribes
about the _"absolute sovereignty of the individual ego"_ fail to note that the
egoist himself advocated organisation ( _"the union of egos"_ ) and was well
aware that it required agreements between individuals which, in the abstract,
reduced "liberty" (the union _"offer[s] a greater measure of liberty"_ while
containing a lesser amount of _"unfreedom"_ [ **The Ego and Its Own** , p.
308]).

Anarchism does, of course, derive from the Greek for _"without authority"_ or
_"without rulers"_ and this, unsurprisingly, informs anarchist theory and
visions of a better world. This means that anarchism is against the
_"domination of man by man"_ (and woman by woman, woman by man, and so on).
However, _"[a]s knowledge has penetrated the governed masses . . . the people
have revolted against the form of authority then felt most intolerable. This
spirit of revolt in the individual and the masses, is the natural and
necessary fruit of the spirit of domination; the vindication of human dignity,
and the saviour of social life."_ Thus _"freedom is the necessary preliminary
to any true and equal human association."_ [Charlotte Wilson, **Anarchist
Essays** , p. 54 and p. 40] In other words, anarchism comes from the struggle
of the oppressed against their rulers and is an expression of individual and
social freedom. Anarchism was born from the class struggle.

Taking individual liberty as a good thing, the next question is how do free
individuals co-operate together in such a way as to ensure their continued
liberty ( _"The belief in freedom assumes that human beings can co-operate."_
[Emma Goldman, **Red Emma Speaks** , p. 442]). This suggests that any
association must be one of equality between the associating individuals. This
can only be done when everyone involved takes a meaningful role in the
decision making process and because of this anarchists stress the need for
**self-government** (usually called **_self-management_** ) of both
individuals and groups. Self-management within free associations and decision
making from the bottom-up is the only way domination can be eliminated. This
is because, by making our own decisions ourselves, we automatically end the
division of society into governors and governed (i.e. end hierarchy). As
Anarchism clearly means support for freedom and equality, it automatically
implies opposition to all forms of hierarchical organisation and authoritarian
social relationships. This means that anarchist support for individual liberty
does not end, as many Marxists assert, in the denial of organisation or
collective decision making but rather in support for **self-managed** groups.
Only this form of organisation can end the division of society into rulers and
ruled, oppressor and oppressed, exploiter and exploited and create an
environment in which individuals can associate without denying their freedom
and equality.

Therefore, the **positive** side of anarchism (which naturally flows from its
opposition to authority) results in a political theory which argues that
people must control their own struggles, organisations and affairs directly.
This means we support mass assemblies and their federation via councils of
mandated delegates subject to recall if they break their mandates (i.e. they
act as they see fit, i.e. as politicians or bureaucrats, and not as the people
who elected them desire). This way people directly govern themselves and
control their own lives, allowing those affected by a decision to have a say
in it and so they manage their own affairs directly and without hierarchy.
Rather than imply an "individualism" which denies the importance of
association and the freedom it can generate, anarchism implies an opposition
to hierarchy in all its forms and support for the free association of equals.
In other words, anarchism can generally be taken to mean support for self-
government or self-management, both by individuals and by groups.

In summary, anarchist support for individual liberty incurs a similar support
for self-managed groups. In such groups, individuals co-operate as equals to
maximise their liberty. This means, for anarchists, Marxists are just
confusing co-operation with coercion, agreement with authority, association
with subordination. Thus the Marxist _"materialist"_ concept of authority
distorts the anarchist position and, secondly, is supra-historical in the
extreme. Different forms of decision making are lumped together, independent
of the various forms it may assume. To equate hierarchical and self-managed
decision making, antagonistic and harmonious forms of organisation, alienated
authority or authority retained in the hands of those directly affected by it,
can only be a source of confusion. Rather than being a _"materialistic"_
approach, the Marxist one is pure philosophical idealism - the postulating of
a-historic concepts independently of the individuals and societies that
generate specific social relationships and ways of working together.

Similarly, it would be churlish to note that Marxists themselves have
habitually rejected democratic authority when it suited them. Even that
_"higher type of democracy"_ of the soviets was ignored by the Bolshevik party
once it was in power. As we discuss in [section H.6.1](secH6.md#sech61),
faced with the election of non-Bolshevik majorities to the soviets, Bolshevik
armed force was used to overthrow the results. In addition, they also
gerrymandered soviets once they could no longer count on an electoral
majority. In the workplace, the Bolsheviks replaced workers' economic
democracy with _"one-man management"_ appointed from above, by the state,
armed with _"dictatorial power"_ (see [section H.3.14](secH3.md#sech314)).
As discussed in [section H.3.8](secH3.md#sech38), the Bolsheviks generalised
their experiences exercising power into explicit support for party
dictatorship. Throughout the 1920s and 30s, Trotsky repeated this conclusion
and repeatedly advocated party dictatorship, urging the party to use its power
to crush opposition in the working class to its rule. For the Bolshevik
tradition, the power of the party to ignore the wishes of the class it claims
to represent is a fundamental ideological position.

So remember, when Lenin or Trotsky argue for _"party dictatorship"_ , the
over-riding of the democratic decisions of the masses by the party, the
elimination of workers factory committees in favour of appointed managers
armed with _"dictatorial"_ power or when the Bolsheviks disbanded soviets with
non-Bolshevik majorities, it is **anarchism** which is fundamentally _"anti-
democratic"_! All in all, that anyone can claim that anarchism is more _"anti-
democratic"_ than Leninism is a joke.

However, all these anti-democratic acts do fit in nicely with Howl's
_"materialist"_ Marxist concept that _"'authority' is necessary in **any**
society where labour is collaborative."_ Since _"authority"_ is essential and
all forms of collective decision making are necessarily _"authoritarian"_ and
involve _"subordination,"_ then it clearly does not really matter how
collectives are organised and how decisions are reached. Hence the lack of
concern for the liberty of the working people subjected to the (peculiarly
bourgeois-like) forms of authority preferred by Lenin and Trotsky. It was
precisely for this reason, to differentiate between egalitarian (and so
libertarian) forms of organisation and decision making and authoritarian ones,
that anarchists called themselves _"anti-authoritarians."_

Even if we ignore all the anti-democratic acts of Bolshevism (or justify them
in terms of the problems facing the Russian Revolution, as most Leninists do),
the anti-democratic nature of Leninist ideas still comes to the fore. The
Leninist support for centralised state power brings their attack on anarchism
as being _"anti-democratic"_ into clear perspective and, ultimately, results
in the affairs of millions being decided upon by a handful of people in the
Central Committee of the vanguard party. As an example, we will discuss
Trotsky's arguments against the Makhnovist movement in the Ukraine.

For Trotsky, the Makhnovists were against _"Soviet power."_ This, he argued,
was simply _"the authority of all the local soviets in the Ukraine"_ as they
all _"recognise the central power which they themselves have elected."_
Consequently, the Makhnovists rejected not only central authority but also the
local soviets as well. Trotsky also suggested that there were no _"appointed"_
persons in Russia as _"there is no authority in Russia but that which is
elected by the whole working class and working peasantry. It follows [!] that
commanders appointed by the central Soviet Government are installed in their
positions by the will of the working millions."_ He stressed that one can
speak of _"appointed"_ persons _"only under the bourgeois order, when Tsarist
officials or bourgeois ministers appointed at their own discretion commanders
who kept the soldier masses subject to the bourgeois classes."_ When the
Makhnovists tried to call the fourth regional conference of peasants, workers
and partisans to discuss the progress of the Civil War in early 1919, Trotsky,
unsurprisingly enough, _"categorically banned"_ it. With typical elitism, he
noted that the Makhnovist movement had _"its roots in the ignorant masses"_! [
**How the Revolution Armed** , vol. II, p. 277, p. 280, p. 295 and p. 302]

In other words, because the Bolshevik government had been given power by a
national Soviet Congress in the past (and only remained there by
gerrymandering and disbanding soviets), he (as its representative) had the
right to ban a conference which would have expressed the wishes of millions of
workers, peasants and partisans fighting for the revolution! The fallacious
nature of his arguments is easily seen. Rather than executing the will of
millions of toilers, Trotsky was simply executing his own will. He did not
consult those millions nor the local soviets which had, in Bolshevik ideology,
surrendered their power to the handful of people in the central committee of
the Bolshevik Party. By banning the conference he was very effectively
undermining the practical, functional democracy of millions and replacing it
with a purely formal "democracy" based on empowering a few leaders at the
centre. Yes, indeed, truly democracy in action when one person can deny a
revolutionary people its right to decide its own fate!

Unsurprisingly, the anarchist Nestor Makhno replied by arguing that he
considered it _"an inviolable right of the workers and peasants, a right won
by the revolution, to call congresses on their own account, to discuss their
affairs. That is why the prohibition by the central authorities on the calling
of such congresses . . . represent a direct and insolent violation of the
rights of the workers."_ [quoted by Peter Arshinov, **The History of the
Makhnovist Movement** , p. 129] We will leave it to the readers to decide
which of the two, Trotsky or Makhno, showed the fundamentally _"anti-
democratic"_ perspective.

Moreover, there are a few theoretical issues that need to be raised on this
matter. Notice, for example, that no attempt is made to answer the simple
question of why having 51% of a group automatically makes you right! It is
taken for granted that the minority should subject themselves to the will of
the majority before that will is even decided upon. Does that mean, for
example, that Marxists refuse minorities the right of civil disobedience if
the majority acts in a way which harms their liberties and equality? If, for
example, the majority in a community decides to implement race laws, does that
mean that Marxists would **oppose** the discriminated minority taking direct
action to undermine and abolish them? Or, to take an example closer to
Marxism, in 1914 the leaders of the Social Democratic Party in the German
Parliament voted for war credits. The anti-war minority of that group went
along with the majority in the name of "democracy," "unity" and "discipline".
Would Howl and Draper argue that they were right to do so? If they were not
right to betray the ideas of Marxism and international working class
solidarity, then why not? They did, after all, subject themselves to the
_"most perfect socialist democracy"_ and so, presumably, made the correct
decision.

Simply put, the arguments that anarchists are _"anti-democratic"_ are
question-begging in the extreme, when not simply hypocritical.

As a general rule-of-thumb, anarchists have little problem with the minority
accepting the decisions of the majority after a process of free debate and
discussion. As we argue in [section A.2.11](secA2.md#seca211), such
collective decision making is compatible with anarchist principles - indeed,
is based on them. By governing ourselves directly, we exclude others governing
us. However, we do not make a fetish of this, recognising that, in certain
circumstances, the minority must and should ignore majority decisions. For
example, if the majority of an organisation decide on a policy which the
minority thinks is disastrous then why should they follow the majority?
Equally, if the majority make a decision which harms the liberty and equality
of a non-oppressive and non-exploitative minority, then that minority has the
right to reject the "authority" of the majority. Hence Carole Pateman:

> _"The essence of liberal social contract theory is that individuals ought to
> promise to, or enter an agreement to, obey representatives, to whom they
> have alienated their right to make political decisions . . . Promising . . .
> is an expression of individual freedom and equality, yet commits individuals
> for the future. Promising also implies that individuals are capable of
> independent judgement and rational deliberation, and of evaluating and
> changing their own actions and relationships; promises may sometimes
> justifiably be broken. However, to promise to obey is to deny or limit, to a
> greater or lesser degree, individuals' freedom and equality and their
> ability to exercise these capacities. To promise to obey is to state that,
> in certain areas, the person making the promise is no longer free to
> exercise her capacities and decide upon her own actions, and is no longer
> equal, but subordinate."_ [ **The Problem of Political Obligation** , p. 19]

Thus, for anarchists, a democracy which does not involve individual rights to
dissent, to disagree and to practice civil disobedience would violate freedom
and equality, the very values Marxists usually claim to be at the heart of
their politics. The claim that anarchism is _"anti-democratic"_ basically
hides the argument that the minority must become the slave of the majority -
with no right of dissent when the majority is wrong (in practice, of course,
it is usually meant the orders and laws of the minority who are elected to
power). In effect, it wishes the minority to be subordinate, not equal, to the
majority. Anarchists, in contrast, because we support self-management also
recognise the importance of dissent and individuality - in essence, because we
are in favour of self-management ("democracy" does not do the concept justice)
we also favour the individual freedom that is its rationale. We support the
liberty of individuals because we believe in self-management ("democracy") so
passionately.

So Howl and Draper fail to understand the rationale for democratic decision
making - it is not based on the idea that the majority is always right but
that individual freedom requires democracy to express and defend itself. By
placing the collective above the individual, they undermine democratic values
and replace them with little more than tyranny by the majority (or, more
likely, a tiny minority who claim to represent the majority).

Moreover, progress is determined by those who dissent and rebel against the
status quo and the decisions of the majority. That is why anarchists support
the right of dissent in self-managed groups - in fact, dissent, refusal,
revolt by individuals and minorities is a key aspect of self-management. Given
that Leninists do not support self-management (rather they, at best, support
the Lockean notion of electing a government as being "democracy") it is hardly
surprising they, like Locke, view dissent as a danger and something to
denounce. Anarchists, on the other hand, recognising that self-management's
(i.e. direct democracy's) rationale and base is in individual freedom,
recognise and support the rights of individuals to rebel against what they
consider as unjust impositions. As history shows, the anarchist position is
the correct one - without rebellion, numerous minorities would never have
improved their position and society would stagnate. Indeed, Howl's and
Draper's comments are just a reflection of the standard capitalist diatribe
against strikers and protestors - they do not need to protest, for they live
in a "democracy."

This Marxist notion that anarchists are "anti-democratic" gets them into
massive contradictions. Lance Selfa's highly inaccurate and misleading article
_"Emma Goldman: A life of controversy"_ is an example of this [
**International Socialist Review** , no. 34, March-April 2004] Ignoring the
far more substantial evidence for Leninist elitism, Selfa asserted that
_"Goldman never turned away from the idea that heroic individuals, not masses,
make history"_ and quotes from her 1910 essay _"Minorities Versus Majorities"_
to prove this. Significantly, he does not actually refute the arguments
Goldman expounded. He does, needless to say, misrepresent them.

The aim of Goldman's essay was to state the obvious - that the mass is not the
source for new ideas. Rather, new, progressive, ideas are the product of
minorities, which then spread to the majority by the actions of those
minorities. Even social movements and revolutions start when a minority takes
action. Trade unionism, for example, was (and still is) a minority movement in
most countries. Support for racial and sexual equality was long despised (or,
at best, ignored) by the majority and it took a resolute minority to advance
that cause and spread the idea in the majority. The Russian Revolution did not
start with the majority. It started when a minority of women workers (ignoring
the advice of the local Bolsheviks) took to the streets and from these
hundreds grew into a movement of hundreds of thousands.

The facts are clearly on the side of Goldman, not Selfa. Given that Goldman
was expounding such an obvious law of social evolution, it seems incredulous
that Selfa has a problem with it. This is particularly the case as Marxism
(particularly its Leninist version) implicitly recognises this. As Marx
argued, the ruling ideas of any epoch are those of the ruling class. Likewise
for Goldman: _"Human thought has always been falsified by tradition and
custom, and perverted false education in the interests of those who held power
. . . by the State and the ruling class."_ Hence the _"continuous struggle"_
against _"the State and even against 'society,' that is, against the majority
subdued and hypnotised by the State and State worship."_ If this were not the
case, as Goldman noted, no state could save itself or private property from
the masses. Hence the need for people to break from their conditioning, to act
for themselves. As she argued, such direct action is _"the salvation of man"_
as it _"necessitates integrity, self-reliance, and courage."_ [ **Red Emma
Speaks** , p. 111 and p. 76]

Thus Goldman, like other anarchists, was not dismissing the masses, just
stressing the obvious: namely that socialism is a process of self-liberation
and the task of the conscious minority is to encourage this process by
encouraging the direct action of the masses. Hence Goldman's support for
syndicalism and direct action, a support Selfa (significantly) fails to inform
his readers of.

So was Goldman's rejection of "majorities" the elitism Selfa claims it was?
No, far from it. This is clear from looking at that work in context. For
example, in a debate between her and a socialist she used the Lawrence strike
_"as an example of direct action."_ [ **Living My Life** , vol. 1., p. 491]
The workers in one of the mills started the strike by walking out. The next
day five thousand at another mill struck and marched to another mill and soon
doubled their number. The strikers soon had to supply food and fuel for
50,000. [Howard Zinn, **A People's History of the United States** , pp. 327-8]
Rather than the strike being the act of the majority, it was the direct action
of a minority which started it and it then spread to the majority (a strike,
incidentally, Goldman supported and fund raised for). It should also be noted
that the Lawrence strike reflected her ideas of how a general strike could be
started by _"one industry or by a small, conscious minority among the
workers"_ which _"is soon taken up by many other industries, spreading like
wildfire."_ [ **Red Emma Speaks** , p. 95]

Do Marxists really argue that this was "elitist"? If so, then every
spontaneous revolt is "elitist". Every attempt by oppressed minorities to
resist their oppression is "elitist." Indeed, every attempt to change society
is "elitist" as if it involves a minority not limiting themselves to simply
advancing new ideas but, instead, taking direct action to raise awareness or
to resist hierarchy in the here and now. Revolutions occur when the ideas of
the majority catch up with the minority who inspire others with their ideas
and activity. So in his keenness to label the anarchist movement "elitist",
Selfa has also, logically, so-labelled the labour, feminist, peace and civil
rights movements (among many others).

Equally embarrassing for Selfa, Trotsky (a person whom he contrasts favourably
with Goldman despite the fact he was a practitioner and advocate of party
dictatorship) agreed with the anarchists on the importance of minorities. As
he put it during the debate on Kronstadt in the late 1930s, a _"revolution is
'made' directly by a **minority**. The success of a revolution is possible,
however, only where this minority finds more or less support, or at least
friendly neutrality, on the part of the majority. The shift in different
stages of the revolution . . . is directly determined by changing political
relations between the minority and the majority, between the vanguard and the
class."_ [Lenin and Trotsky, **Kronstadt** , p. 85] Not that this makes
Trotsky an elitist for Selfa, of course. The key difference is that Goldman
did not argue that this minority should seize power and rule the masses,
regardless of the wishes of that majority, as Trotsky did (see [section
H.1.2](secH1.md#sech12)). As Goldman noted, the _"Socialist demagogues know
that [her argument is true] as well as I, but they maintain the myth of the
virtues of the majority, because their very scheme means the perpetuation of
power"_ and _"authority, coercion and dependence rest on the mass, but never
freedom."_ [ **Op. Cit.** , p. 85]

So, yes, anarchists do support individual freedom to resist even
democratically made decisions simply because democracy **has to be** based on
individual liberty. Without the right of dissent, democracy becomes a joke and
little more than a numerical justification for tyranny. This does not mean we
are _"anti-democratic,"_ indeed the reverse as we hold true to the fundamental
rationale for democratic decision-making - it allows individuals to combine as
equals and not as subordinates and masters. Moreover, diversity is essential
for any viable eco-system and it is essential in any viable society (and, of
course, any society worth living in). This means that a healthy society is one
which encourages diversity, individuality, dissent and, equally, self-managed
associations to ensure the freedom of all. As Malatesta argued:

> _"There are matters over which it is worth accepting the will of the
> majority because the damage caused by a split would be greater than that
> caused by error; there are circumstances in which discipline becomes a duty
> because to fail in it would be to fail in the solidarity between the
> oppressed and would mean betrayal in face of the enemy. But when one is
> convinced that the organisation is pursuing a course which threatens the
> future and makes it difficult to remedy the harm done, then it is a duty to
> rebel and to resist even at the risk of provoking a split . . . What is
> essential is that individuals should develop a sense of organisation and
> solidarity, and the conviction that fraternal co-operation is necessary to
> fight oppression and to achieve a society in which everyone will be able to
> enjoy his [or her] own life."_ [ **Errico Malatesta: His Life and Ideas** ,
> pp. 132-3]

This means that anarchists are not against majority decision making as such.
We simply recognise it has limitations. In practice, the need for majority and
minority to come to an agreement is one most anarchists would recognise:

> _"But such an adaptation [of the minority to the decisions of the majority]
> on the one hand by one group must be reciprocal, voluntary and must stem
> from an awareness of need and of goodwill to prevent the running of social
> affairs from being paralysed by obstinacy. It cannot be imposed as a
> principle and statutory norm. . ._

> _"So . . . anarchists deny the right of the majority to govern in human
> society in general . . . how is it possible . . . to declare that anarchists
> should submit to the decisions of the majority before they have even heard
> what those might be?"_ [Malatesta, **The Anarchist Revolution** , pp. 100-1]

Therefore, while accepting majority decision making as a key aspect of a
revolutionary movement and a free society, anarchists do not make a fetish of
it. We recognise that we must use our own judgement in evaluating each
decision reached simply because the majority is not always right. We must
balance the need for solidarity in the common struggle and needs of common
life with critical analysis and judgement. As Malatesta argued:

> _"In any case it is not a question of being right or wrong; it is a question
> of freedom, freedom for all, freedom for each individual so long as he [or
> she] does not violate the equal freedom of others. No one can judge with
> certainty who is right and who is wrong, who is closer to the truth and
> which is the best road for the greatest good for each and everyone.
> Experience through freedom is the only means to arrive at the truth and the
> best solutions; and there is no freedom if there is not the freedom to be
> wrong._

> _"In our opinion, therefore, it is necessary that majority and minority
> should succeed in living together peacefully and profitably by mutual
> agreement and compromise, by the intelligent recognition of the practical
> necessities of communal life and of the usefulness of concessions which
> circumstances make necessary."_ [ **Errico Malatesta: His Life and Ideas** ,
> p. 72]

Needless to say, our arguments apply with even more force to the decisions of
the **representatives** of the majority, who are in practice a very small
minority. Leninists usually try and confuse these two distinct forms of
decision making. When Leninists discuss majority decision making they almost
always mean the decisions of those elected by the majority - the central
committee or the government - rather than the majority of the masses or an
organisation. Ultimately, the Leninist support for democracy (as the Russian
Revolution showed) is conditional on whether the majority supports them or
not. Anarchists are not as hypocritical or as elitist as this, arguing that
everyone should have the same rights the Leninists usurp for their leaders.

This counterpoising of socialism to "individualism" is significant. The aim of
socialism is, after all, to increase individual liberty (to quote the
**Communist Manifesto** , to create _"an association, in which the free
development of each is the condition for the free development of all."_ [
**The Marx-Engels Reader** , p. 491]). As such, authentic socialism **is**
"individualist" in its aspirations and denounces capitalism for being a
partial and flawed individualism which benefits the few at the expense of the
many (in terms of their development and individuality). This can be seen when
Goldman, for example, argued that anarchism _"alone stresses the importance of
the individual, his [or her] possibilities and needs in a free society."_ It
_"insists that the centre of gravity in society is the individual - that he
must think for himself, act freely, and live fully. The aim of Anarchism is
that every individual in the world shall be able to do so."_ Needless to say,
she differentiated her position from bourgeois ideology: _"Of course, this has
nothing in common with a much boasted 'rugged individualism.' Such predatory
individualism is really flabby, not rugged . . . Their 'rugged individualism'
is simply one of the many pretences the ruling class makes to unbridled
business and political extortion."_ [ **Op. Cit.** , p. 442 and p. 443] This
support for individuality did not preclude solidarity, organising unions,
practising direct action, supporting syndicalism, desiring communism and so
on, but rather **required** it (as Goldman's own life showed). It flows
automatically from a love of freedom for all. Given this, the typical Leninist
attacks against anarchism for being "individualism" simply exposes the state
capitalist nature of Bolshevism:

> _"capitalism promotes egotism, not individuality or 'individualism.' . . .
> the ego it created . . . [is] shrivelled . . . The term 'bourgeois
> individualism,' an epithet widely used by the left today against libertarian
> elements, reflects the extent to which bourgeois ideology permeates the
> socialist project; indeed, the extent to which the 'socialist' project (as
> distinguished from the libertarian communist project) is a mode of state
> capitalism."_ [Murray Bookchin, **Post-Scarcity Anarchism** , p. 194fn]

Therefore the Marxist attack on anarchism as _"anti-democratic"_ is not only
false, it is ironic and hypocritical. Firstly, anarchists do **not** argue for
_"the absolute sovereignty of the individual ego."_ Rather, we argue for
individual freedom. This, in turn, implies a commitment to self-managed forms
of social organisation. This means that anarchists do not confuse agreement
with (hierarchical) authority. Secondly, Marxists do not explain why the
majority is always right or why their opinions are automatically the truth.
Thirdly, the logical conclusions of their arguments would result in the
absolute enserfment of the individual to the representatives of the majority.
Fourthly, rather than being supporters of democracy, Marxists like Lenin and
Trotsky explicitly argued for minority rule and the ignoring of majority
decisions when they clashed with the decisions of the ruling party. Fifthly,
their support for "democratic" centralised power means, in practice, the
elimination of democracy in the grassroots. As can be seen from Trotsky's
arguments against the Makhnovists, the democratic organisation and decisions
of millions can be banned by a single individual.

All in all, Marxists claims that anarchists are _"anti-democratic"_ just
backfire on Marxism.

## H.2.12 Does anarchism survive only in the absence of a strong workers'
movement?

Derek Howl argues that anarchism _"survives only in the absence of a strong
workers movement"_ and is the politics of _"non-proletarians."_ As he puts it,
there _"is a class basis to this. Just as Proudhon's 'anarchism' reflected the
petty bourgeoisie under pressure, so too Bakuninism as a movement rested upon
non-proletarians . . . In Italy Bakuninism was based upon the large 'lumpen
bourgeoisie', doomed petty bourgeois layers. In Switzerland the Jura
Federation . . . was composed of a world of cottage industry stranded between
the old world and the new, as were pockets of newly proletarianised peasants
that characterised anarchism in Spain."_ He approvingly quotes Hal Draper
assertion that anarchism _"was an ideology alien to the life of modern working
people."_ [ _"The Legacy of Hal Draper,"_ pp. 137-49, **International
Socialism** , no. 52, p. 148]

Ignoring the obvious contradiction of _"newly proletarianised peasants"_ being
_"non-proletarians,"_ we have the standard Marxist "class analysis" of
anarchism. This is to assert that anarchism is _"non-proletarian"_ while
Marxism is _"proletarian."_ On the face of it, such an assertion seems to fly
in the face of historical facts. After all, when Marx and Engels were writing
the **Communist Manifesto** , the proletariat was a tiny minority of the
population of a mostly rural, barely industrialised Germany. Perhaps it was
Engels' experiences as a capitalist in England that allowed him an insight
into _"the life of modern working people?"_ It should also be noted that
neither Howel or Draper is being original, they are simply repeating Marx's
assertion that anarchism _"continues to exist only where there is as yet no
proper workers' movement. This is a fact."_ [ **Collected Works** , vol. 24,
p. 247]

Beyond this there are a few problems with this type of argument. Firstly,
there are the factual problems. Simply put, anarchism appealed to _"modern"_
working people and Marxism has appealed to the _"non-proletarian"_ groups and
individuals (and vice versa, of course). This can be seen from the examples
Howl lists as well as the rise of syndicalist ideas after the reformism of the
first Marxist movement (social democracy) became apparent. In fact, the rise
of Marxism within the labour movement is associated with its descent into
reformism, **not** revolution. Secondly, there is the slight ideological
problem that Lenin himself argued that the working class, by its own efforts,
did not produce socialist ideas which were generated far from _"the life of
modern working people"_ by the intelligentsia. Lastly, there is the assumption
that two long dead Germans, living in an environment where _"modern working
people"_ (proletarians) were a small minority of the working population, could
really determine for all time what is (and is not) _"proletarian"_ politics.

Taking the countries Howl lists, we can see that any claim that anarchism is
_"alien"_ to the working class is simply false. Looking at each one, it is
clearly the case that, for Marxists, the **politics** of the people involved
signify their working class credentials, **not** their actual economic or
social class. Thus we have the sociological absurdity that makes anarchist
workers _"petty bourgeois"_ while actual members of the bourgeoisie (like
Engels) or professional revolutionaries (and the sons of middle class families
like Marx, Lenin and Trotsky) are considered as representatives of
_"proletarian"_ politics. Indeed, when these radical members of the middle-
class repress working class people (as did Lenin and Trotsky were in power)
they **remain** figures to be followed and their acts justified in terms of
the "objective" needs of the working people they are oppressing! Ultimately,
for most Marxists, whether someone is _"non-proletariat"_ depends on their
ideological viewpoint and not, in fact, their actual class.

Hence we discover Marx and Engels (like their followers) blaming Bakunin's
success in the International, as one historian notes, _"on the middle-class
leadership of Italy's socialist movement and the backwardness of the country.
But if middle-class leaders were the catalysts of proletarian revolutionary
efforts in Italy, this was also true of every other country in Europe, not
excluding the General Council in London."_ [T.R. Ravindranathan, **Bakunin and
the Italians** , p. 168] And by interpreting the difficulties for Marxism in
this way, Marx and Engels (like their followers) need not question their own
ideas and assumptions. As Nunzio Pernicone notes, _"[f]rom the outset, Engels
had consistently underestimated Bakunin as a political adversary and refused
to believe that Italian workers might embrace anarchist doctrines."_ However,
_"even a casual perusal of the internationalist and dissident democratic press
would have revealed to Engels that Bakuninism was rapidly developing a
following among Italian artisans and workers. But this reality flew in the
face of his unshakeable belief that Italian internationalists were all a 'gang
of declasses, the refuse of the bourgeoisie.'"_ Even after the rise of the
Italian Marxism in the 1890s, _"the anarchist movement was proportionately
more working-class than the PSI"_ and the _"the number of bourgeois
intellectuals and professionals that supported the PSI [Italian Socialist
Party] was vastly greater"_ than those supporting anarchism. Indeed, _"the
percentage of party membership derived from the bourgeoisie was significantly
higher in the PSI than among the anarchists."_ [ **Italian Anarchism,
1864-1892** , p. 82 and p. 282] Ironically, given Engels diatribes against the
Italian anarchists stopping workers following _"proletarian"_ (i.e. Marxist)
politics and standing for elections, _"as the PSI grew more working-class,
just before the outbreak of war [in 1914], its Directorate [elected by the
party congress] grew more anti-parliamentary."_ [Gwyn A. Williams,
**Proletarian Order** , p. 29]

As we noted in [section A.5.5](secA5.md#seca55), the role of the anarchists
and syndicalists compared to the Marxists during the 1920 near revolution
suggested that the real _"proletarian"_ revolutionaries were, in fact, the
former and **not** the latter. All in all, the history of the Italian labour
movement clearly shows that, for most Marxists, whether a group represents the
_"proletariat"_ is simply dependent on their ideological commitment, **not**
their actual class.

As regards the Jura Federation, we discover that its support was wider than
suggested. As Marxist Paul Thomas noted, _"Bakunin's initial support in
Switzerland - like Marx's in England - came from resident aliens, political
refugees . . . but he also gathered support among **Gastarbeitier** for whom
Geneva was already a centre, where builders, carpenters and workers in heavy
industry tended to be French or Italian . . . Bakunin . . . also marshalled
considerable support among French speaking domestic workers and watchmakers in
the Jura."_ [ **Karl Marx and the Anarchists** , p. 390] It would be
interesting to hear a Marxist claim that _"heavy industry"_ represented the
past or _"non-proletarian"_ elements! Similarly, E. H. Carr in his (hostile)
biography of Bakunin, noted that the _"sections of the International at Geneva
fell into two groups."_ Skilled craftsmen formed the _"Right wing"_ while
_"the builders, carpenters, and workers in the heavier trades, the majority of
whom were immigrants from France and Italy, represented the Left."_
Unsurprisingly, these different groups of workers had different politics. The
craftsmen _"concentrated on . . . reform"_ while the others _"nourished hopes
of a complete social upheaval."_ Bakunin, as would be expected, _"fanned the
spirit of revolt"_ among these, the proletarian workers and soon had a
_"commanding position in the Geneva International."_ [ **Michael Bakunin** ,
p. 361] It should be noted that Marx and the General Council of the
International consistently supported the reformist wing of the International
in Geneva which organised political alliances with the middle-class liberals
during elections. Given these facts, it is little wonder that Howl
concentrates on the support Bakunin received from domestic workers producing
watches. To mention the support for Bakunin by organised, obviously
proletarian, workers would undermine his case and so it is ignored.

Lastly, there is Spain. It seems funny that a Marxist would use Spain as an
example **against** the class roots of anarchism. After all, that is one of
the countries where anarchism dominated the working class movement. As one
historian points out, _"it was not until the 1860s - when anarchism was
introduced - that a substantive working class movement began to emerge"_ and
_"throughout the history of Spanish anarchism, its survival depended in large
measure on the anarchists' ability to maintain direct links with the
workers."_ [George R. Esenwein, **Anarchist Ideology and the Working-Class
Movement in Spain, 1868-1898** , p. 6 and p. 207] As well as organising
_"newly proletarianised peasants,"_ the "Bakuninists" also organised
industrial workers - indeed, far more successfully than the Socialists.
Ironically, the UGT only started to approach the size of the CNT once it had
started to organise _"newly proletarianised peasants"_ in the 1930s (i.e.,
anarchist unions organised more of the industrial working class than the
Socialist ones). From such a fact, we wonder if Marxists would argue that
socialism rested on _"non-proletarian"_ elements?

Moreover, the logic of dismissing anarchism as _"non-proletarian"_ because it
organised _"newly proletarianised peasants"_ is simply laughable. After all,
capitalism needed landless labourers in order to start. This meant that the
first proletarians lived in rural areas and were made up of ex-peasants. When
these ex-peasants arrived in the towns and cities, they were still _"newly
proletarianised peasants."_ To ignore these groups of workers would mean
potentially harming the labour movement. And, of course, a large section of
Bolshevik support in 1917 was to be found in _"newly proletarianised
peasants"_ whether in the army or working in the factories. Ironically enough,
the Mensheviks argued that the Bolsheviks gained their influence from worker-
peasant industrial _"raw recruits"_ and not from the genuine working class.
[Orlando Figes, **A People's Tragedy** , p. 830] As such, to dismiss anarchism
because it gained converts from similar social strata as the Bolsheviks seems,
on the face of it, a joke.

As can be seen, Howl's attempt to subject anarchism to a _"class analysis"_
simply fails. He selects the evidence which fits his theory and ignores that
which does not. However, looking at the very examples he bases his case on
shows how nonsensical it is. Simply put, anarchist ideas appealed to many
types of workers, including typically _"proletarian"_ ones who worked in
large-scale industries. What they seem to have in common is a desire for
radical social change, organised by themselves in their own combative class
organs (such as unions). Moreover, like the early British workers movement,
they considered that these unions, as well as being organs of class struggle,
could also be the framework of a free socialist society. Such a perspective is
hardly backward (indeed, since 1917 Leninists pay lip-service to this
vision!).

Which brings us to the next major problem with Howl's argument, namely the
fate of Marxism and the _"strong"_ labour movement it allegedly is suited for.
Looking at the only nation which did have a _"modern"_ working class during
the most of Marx's life, Britain, the _"strong"_ labour movement it produced
was (and has) not been anarchist, it is true, but neither was it (nor did it
become) Marxist. Rather, it has been a mishmash of conflicting ideas,
predominately reformist state socialist ones which owe little, if anything, to
Marx. Indeed, the closest Britain came to developing a wide scale
revolutionary working class movement was during the _"syndicalist revolt"_ of
the 1910s. Ironically, some Marxists joined this movement simply because the
existing Marxist parties were so reformist or irrelevant to the _"life of
modern working people."_

Looking at other countries, we find the same process. The rise of social
democracy (Marxism) in the international labour movement simply signified the
rise of reformism. Instead of producing a **revolutionary** labour movement,
Marxism helped produce the opposite (although, initially, hiding reformist
activity behind revolutionary rhetoric). So when Howl asserts that anarchism
_"survives in the absence of a strong workers' movement,"_ we have to wonder
what planet he is on.

Thus, to state matters more correctly, anarchism flourishes during those
periods when the labour movement and its members are radical, taking direct
action and creating new forms of organisation which are still based on
workers' self-management. This is to be expected as anarchism is both based
upon and is the result of workers' self-liberation through struggle. In less
militant times, the effects of bourgeois society and the role of unions within
the capitalist economy can de-radicalise the labour movement and lead to the
rise of bureaucracy within it. It is then, during periods when the class
struggle is low, that reformist ideas spread. Sadly, Marxism aided that spread
by its tactics - electioneering focused struggle away from direct action and
into the ballot-box and so onto leaders rather than working class self-
activity.

Moreover, if we look at the current state of the labour movement, then we
would have to conclude that Marxism is _"an ideology alien to the life of
modern working people."_ Where are the large Marxist working class unions and
parties? There are a few large reformist socialist and Stalinist parties in
continental Europe, but these are not Marxist in any meaningful sense of the
word. Most of the socialist ones used to be Marxist, although they relatively
quickly stopped being revolutionary in any meaningful sense of the word a very
long time ago (some, like the German Social Democrats, organised counter-
revolutionary forces to crush working class revolt after the First World War).
As for the Stalinist parties, it would be better to consider it a sign of
shame that they get any support in the working class at all. In terms of
revolutionary Marxists, there are various Trotskyist sects arguing amongst
themselves on who is the **real** vanguard of the proletariat, but **no**
Marxist labour movement.

Which, of course, brings us to the next point, namely the ideological problems
for Leninists themselves created by such an assertion. After all, Lenin
himself argued that _"the life of modern working people"_ could only produce
_"trade-union consciousness"_ as socialist ideas were developed independently
of working people by the socialist (middle-class) _"intelligentsia."_ As we
discuss in [section H.5.1](secH5.md#sech51), for Lenin, socialism was an
ideology which was alien to the life of modern working class people.

Lastly, there is the question of whether Marx and Engels can seriously be
thought of as being able to decree once and for all what is and is not
_"proletarian"_ politics. Given that neither of these men were working class
(one was a capitalist!) it makes the claim that they would know
_"proletarian"_ politics suspect. Moreover, they formulated their ideas of
what constitute _"proletarian"_ politics before a modern working class
actually developed in any country bar Britain. This means, that from the
experience of **one** section of the proletariat in **one** country in the
1840s, Marx and Engels have decreed for all time what is and is not a
_"proletarian"_ set of politics! On the face of it, it is hardly a convincing
argument, particularly as we have over 150 years of experience of these
tactics with which to evaluate them!

Based on this perspective, Marx and Engels opposed all other socialist groups
as _"sects"_ if they did not subscribe to their ideas. Ironically, while
arguing that all other socialists were fostering their sectarian politics onto
the workers movement, they themselves fostered their own perspective onto it.
Originally, because the various sections of the International worked under
different circumstances and had attained different degrees of development, the
theoretical ideals which reflected the real movement also diverged. The
International, therefore, was open to all socialist and working class
tendencies and its general policies would be, by necessity, based on
conference decisions that reflected this divergence. These decisions would be
determined by free discussion within and between sections of all economic,
social and political ideas. Marx, however, replaced this policy with a common
program of _"political action"_ (i.e. electioneering) by mass political
parties via the fixed Hague conference of 1872. Rather than having this
position agreed by the normal exchange of ideas and theoretical discussion in
the sections guided by the needs of the practical struggle, Marx imposed what
**he** considered as the future of the workers movement onto the International
- and denounced those who disagreed with him as sectarians. The notion that
what Marx considered as necessary might be another sectarian position imposed
on the workers' movement did not enter his head nor those of his followers:

> _"Marx had indeed insisted, in the earlier years of the First International,
> on the need for building on actual movements rather than constructing a
> dogma which movements were then required to fit. But when the actual
> movements took forms which he disliked, as they largely did in Spain and
> Italy, in Germany under Lassalle's influence, and in Great Britain as soon
> as the Trade Unions' most immediate demands had been met, he was apt to
> forget his own precepts and to become the grand inquisitor into heretical
> misdeeds."_ [G.D.H. Cole, **A History of Socialist Thought** , vol. 2, p.
> 256]

That support for _"political action"_ was just as "sectarian" as support for
non-participation in elections can be seen from Engels 1895 comment that
_"[t]here had long been universal suffrage in France, but it had fallen into
disrepute through the misuse to which the Bonapartist government had put it .
. . It also existed in Spain since the republic, but in Spain boycott of
elections was ever the rule of all serious opposition parties . . . The
revolutionary workers of the Latin countries had been wont to regard the
suffrage as a snare, as an instrument of government trickery."_ [ **Marx-
Engels Reader** , p. 565] Needless to say, he had failed to mention those
little facts when he was attacking anarchists for expressing the opinions of
the _"revolutionary workers of the Latin countries"_ and _"all serious
opposition parties"_ in the 1870s! Similarly, the Haymarket Martyrs had moved
from a Marxist position on elections to an anarchist one after their own
experiences using the ballot box, as did the many British socialists who
became syndicalists in the early years of the 20th century. It seems strange
to conclude that these positions are not expressions of working class struggle
while that of Marx and Engels are, particularly given the terrible results of
that strategy!

Thus the Marxist claim that true working class movements are based on mass
political parties based on hierarchical, centralised, leadership and those who
reject this model and political action (electioneering) are sects and
sectarians is simply their option and little more. Once we look at the
workers' movement without the blinkers created by Marxism, we see that
Anarchism was a movement of working class people using what they considered
valid tactics to meet their own social, economic and political goals - tactics
and goals which evolved to meet changing circumstances. Seeing the rise of
anarchism and syndicalism as the political expression of the class struggle,
guided by the needs of the practical struggle they faced naturally follows
when we recognise the Marxist model for what it is - just one possible
interpretation of the future of the workers' movement rather than **the**
future of that movement (and as the history of Social Democracy indicates, the
predictions of Bakunin and the anarchists within the First International were
proved correct).

This tendency to squeeze the revolutionary workers' movement into the forms
decreed by two people in the mid-nineteenth century has proved to be
disastrous for it. Even after the total failure of social democracy, the idea
of _"revolutionary"_ parliamentarianism was fostered onto the Third
International by the Bolsheviks in spite of the fact that more and more
revolutionary workers in advanced capitalist nations were rejecting it in
favour of direct action and autonomous working class self-organisation.
Anarchists and libertarian Marxists based themselves on this actual movement
of working people, influenced by the failure of _"political action,"_ while
the Bolsheviks based themselves on the works of Marx and Engels and their own
experiences in a backward, semi-feudal society whose workers had already
created factory committees and soviets by direct action. It was for this
reason that the anarcho-syndicalist Augustin Souchy said he referred _"to the
tendencies that exist in the modern workers' movement"_ when he argued at the
Second Congress of the Communist International:

> _"It must be granted that among revolutionary workers the tendency toward
> parliamentarism is disappearing more and more. On the contrary, a strong
> anti-parliamentary tendency is becoming apparent in the ranks of the most
> advanced part of the proletariat. Look at the Shop Stewards' movement [in
> Britain] or Spanish syndicalism . . . The IWW is absolutely
> antiparliamentary . . . I want to point out that the idea of
> antiparliamentarism is asserting itself more strongly in Germany . . . as a
> result of the revolution itself . . . We must view the question in this
> light."_ [ **Proceedings and Documents of the Second Congress 1920** , vol.
> 1, pp. 176-7]

Of course, this perspective of basing yourself on the ideas and tactics
generated by the class struggle was rejected in favour of a return to the
principles of Marx and Engels and their vision of what constituted a genuine
_"proletarian"_ movement. If these tactics were the correct ones, then why did
they not lead to a less dismal set of results? After all, the degeneration of
social democracy into reformism would suggest their failure and sticking
_"revolutionary"_ before their tactics (as in _"revolutionary
parliamentarianism"_ ) changes little. Marxists, like anarchists, are meant to
be materialists, not idealists. What was the actual outcome of the Leninist
strategies? Did they result in successful proletarian revolutions. No, they
did not. The revolutionary wave peaked and fell and the Leninist parties
themselves very easily and quickly became Stalinised. Significantly, those
areas with a large anarchist, syndicalist or quasi-syndicalist (e.g. the
council communists) workers movements (Italy, Spain and certain parts of
Germany) came closest to revolution and by the mid-1930s, only Spain with its
strong anarchist movement had a revolutionary labour movement. Therefore,
rather than representing _"non-proletarian"_ or _"sectarian"_ politics forced
upon the working class, anarchism reflected the politics required to built a
**revolutionary** workers' movement rather than a reformist mass party.

As such, perhaps we can finally lay to rest the idea that Marx predicted the
whole future of the labour movement and the path it must take like some kind
of socialist Nostradamus. Equally, we can dismiss Marxist claims of the _"non-
proletarian"_ nature of anarchism as uninformed and little more than an
attempt to squeeze history into an ideological prison. As noted above, in
order to present such an analysis, the actual class compositions of
significant events and social movements have to be manipulated. This is the
case of the Paris Commune, for example, which was predominantly a product of
artisans (i.e. the _"petit bourgeoisie"_ ), **not** the industrial working
class and yet claimed by Marxists as an example of the _"dictatorship of the
proletariat."_ Ironically, many of the elements of the Commune praised by Marx
can be found in the works of Proudhon and Bakunin which pre-date the uprising.
Similarly, the idea that workers' fighting organisations ("soviets") would be
the means to abolish the state and the framework of a socialist society can be
found in Bakunin's works, decades before Lenin paid lip-service to this idea
in 1917. For a theory allegedly resting on _"non-proletarian"_ elements
anarchism has successfully predicted many of the ideas Marxists claim to have
learnt from proletarian class struggle!

So, in summary, the claims that anarchism is _"alien"_ to working class life,
that it is _"non-proletarian"_ or _"survives in the absence of a strong
workers' movement"_ are simply false. Looking objectively at the facts of the
matter quickly shows that this is the case.

## H.2.13 Do anarchists reject _"political"_ struggles and action?

A common Marxist claim is that anarchists and syndicalists ignore or dismiss
the importance of _"political"_ struggles or action. This is not true. Rather,
as we discuss in [section J.2.10](secJ2.md#secj210), we think that
_"political"_ struggles should be conducted by the same means as social and
economic struggles, namely by direct action, solidarity and working class
self-organisation.

As this is a common assertion, it is useful to provide a quick summary of why
anarchists do not, in fact, reject _"political"_ struggles and action as such.
Rather, to quote Bakunin, anarchism _"does not reject politics generally. It
will certainly be forced to involve itself insofar as it will be forced to
struggle against the bourgeois class. It only rejects bourgeois politics"_ as
it _"establishes the predatory domination of the bourgeoisie."_ [ **The
Political Philosophy of Bakunin** , p. 313] For Kropotkin, it was a truism
that it was _"absolutely impossible . . . to confine the ideas of the working
mass within the narrow circle of reductions in working hours and wage
increases . . . The social question compels attention."_ This fact implied two
responses: _"the workers' organisation propels itself either into the sterile
path of parliamentary politics as in Germany, or into the path of
revolution."_ [quoted by Caroline Cahm, **Kropotkin and the rise of
Revolutionary Anarchism, 1872-1886** , p. 241]

So while Marxists often argue that anarchists are exclusively interested in
economic struggle and reject _"politics"_ or _"political action,"_ the truth
of the matter is different. We are well aware of the importance of political
issues, although anarchists reject using bourgeois methods in favour of direct
action. Moreover, we are aware that any social or economic struggle has its
political aspects and that such struggles bring the role of the state as
defender of capitalism and the need to struggle against it into focus:

> _"There is no serious strike that occurs today without the appearance of
> troops, the exchange of blows and some acts of revolt. Here they fight with
> the troops; there they march on the factories; . . . in Pittsburgh in the
> United States, the strikers found themselves masters of a territory as large
> as France, and the strike became the signal for a general revolt against the
> State; in Ireland the peasants on strike found themselves in open revolt
> against the State. Thanks to government intervention the rebel against the
> factory becomes the rebel against the State."_ [Kropotkin, quoted by
> Caroline Cahm, **Op. Cit.** , p. 256]

As Malatesta argued, from _"the economic struggle one must pass to the
political struggle, that is to struggle against government; and instead of
opposing the capitalist millions with the workers' few pennies scraped
together with difficulty, one must oppose the rifles and guns which defend
property with the more effective means that the people will be able to defeat
force by force."_ [ **Errico Malatesta: His Life and Ideas** , pp. 193-4]

This means that the question of whether to conduct political struggles is
**not** the one which divides anarchists from Marxists. Rather, it is a
question of **how** this struggle is fought. For anarchists, this struggle is
best fought using **direct action** (see [section J.2](secJ2.md)) and
fighting working class organisations based in our workplaces and communities.
For Marxists, the political struggle is seen as being based on standing
candidates in bourgeois elections. This can be seen from the resolution passed
by the socialist ("Second") International in 1893. This resolution was
designed to exclude anarchists and stated that only _"those Socialist Parties
and Organisations which recognise the organisation of workers and of political
action"_ could join the International. By _"political action"_ it meant _"that
the working-class organisations seek, in as far as possible, to use or conquer
political rights and the machinery of legislation for the furthering of the
interests of the proletariat and the conquest of political power."_ [quoted by
Susan Milner, **The Dilemmas of Internationalism** , p. 49] Significantly,
while this International and its member parties (particular the German Social
Democrats) were happy to expel anarchists, they never expelled the leading
reformists from their ranks.

So, in general, anarchists use the word _"political action"_ to refer
exclusively to the taking part of revolutionaries in bourgeois elections (i.e.
electioneering or parliamentarianism). It does not mean a rejection of
fighting for political reforms or a lack of interest in political issues,
quite the reverse in fact. The reason **why** anarchists reject this tactic is
discussed in [section J.2.6](secJ2.md#secj26)).

For Kropotkin, the idea that you could somehow "prepare" for a revolution by
electioneering was simply a joke. _"As if the bourgeoisie,"_ he argued,
_"still holding on to its capital, could allow them [the socialists] to
experiment with socialism even if they succeeded in gaining control of power!
As if the conquest of the municipalities were possible without the conquest of
the factories."_ He saw that _"those who yesterday were considered socialists
are today letting go of socialism, by renouncing its mother idea ["the need to
replace the wage system and to abolish individual ownership of . . . social
capital"] and passing over into the camp of the bourgeoisie, while retaining,
so as to hide their turnabout, the label of socialism."_ [ **Words of a
Rebel** , p. 181 and p. 180] The differences in results between direct action
and electioneering were obvious:

> _"However moderate the war cry - provided it is in the domain of relations
> between capital and labour - as soon as it proceeds to put it into practice
> by revolutionary methods, it ends by increasing it and will be led to demand
> the overthrow of the regime of property. On the other hand a party which
> confines itself to parliamentary politics ends up abandoning its programme,
> however advanced it may have been at the beginning."_ [Kropotkin, quoted by
> Cahm, **Op. Cit.** , p. 252]

Ultimately, the bourgeois tactics used ended up with bourgeois results. As
Emma Goldman argued, socialism _"was led astray by the evil spirit of
politics"_ and _"landed in the [political] trap and has now but one desire -
to adjust itself to the narrow confines of its cage, to become part of the
authority, part of the very power that has slain the beautiful child Socialism
and left behind a hideous monster."_ [ **Red Emma Speaks** , p. 103] The net
effect of _"political action"_ was the corruption of the socialist movement
into a reformist party which betrayed the promise of socialism in favour of
making existing society better (so it can last longer). This process confirmed
Bakunin's predictions. As Kropotkin put it:

> _"The middle class will not give up its power without a struggle. It will
> resist. And in proportion as Socialists will become part of the Government
> and share power with the middle class, their Socialism will grow paler and
> paler. This is, indeed, what Socialism is rapidly doing. Were this not so,
> the middle classes . . . would not share their power with the Socialists."_
> [ **Evolution and Environment** , p. 102]

In addition, as we argue in [section J.2.5](secJ2.md#secj25), direct action
is either based on (or creates) forms of self-managed working class
organisations. The process of collective struggle, in other words,
necessitates collective forms of organisation and decision making. These
combative organisations, as well as conducting the class struggle under
capitalism, can also be the framework of a free society (see [section
H.1.4](secH1.md#sech14)). However, standing in elections does **not**
produce such alternative social structures and, indeed, hinders them as the
focus for social changes becomes a few leaders working in existing (i.e.
bourgeois) structures and bodies (see [section H.1.5](secH1.md#sech15)).

As can be seen, anarchists reject _"political"_ struggle (i.e. electioneering)
for good (and historically vindicated) reasons. This makes a mockery of
Marxists assertions (beginning with Marx) that anarchists like Bakunin
_"opposed all political action by the working class since this would imply
'recognition' of the existing state."_ [Derek Howl, _"The Legacy of Hal
Draper,"_ pp. 13-49, **International Socialism** , no. 52, p. 147] This, in
fact, is a common Marxist claim, namely that anarchists reject _"political
struggle"_ on principle (i.e. for idealistic purposes). In the words of
Engels, Bakunin was _"opposed to all political action by the working class,
since this would in fact involve recognition of the existing state."_ [Marx,
Engels and Lenin, **Anarchism and Anarcho-Syndicalism** , p. 49] Sadly, like
all Marxists, he failed to indicate where, in fact, Bakunin actually said
that. As can be seen, this was **not** the case. Bakunin, like all
revolutionary anarchists, rejected _"political action"_ (in the sense of
electioneering) simply because they feared that such tactics would be
counterproductive and undermine the revolutionary nature of the labour
movement. As the experience of Marxist Social Democracy showed, he was
correct.

In summary, while anarchists reject standing of socialists in elections (
_"political action,"_ narrowly defined), we do not reject the need to fight
for political reforms or specific political issues. However, we see such
action as being based on collective working class **direct action** organised
around combative organs of working class self-management and power rather than
the individualistic act of placing a cross on a piece of power once every few
years and letting leaders fight your struggles for you.

## H.2.14 Are anarchist organisations _"ineffective,"_ _"elitist"_ or
_"downright bizarre"_?

Marxists often accuse anarchist organisations of being "elitist" or "secret."
Pat Stack (of the British SWP) ponders the history of anarchist organisation
(at least the SWP version of that history):

> _"how otherwise [than Leninist vanguard political parties] do
> revolutionaries organise? Apart from the serious efforts of anarcho-
> syndicalists to grapple with this problem, anarchists have failed to pose
> any serious alternative. In as much as they do, they have produced either
> the ineffective, the elitist or the downright bizarre. Bakunin's
> organisation, the 'Alliance of Social Democracy', managed all three: 'The
> organisation had two overlapping forms, one secret, involving only the
> "intimates", and one public, the Alliance of Social Democracy. Even in its
> open, public mode, the alliance was to be a highly centralised organisation,
> with all decisions on the national level approved by the Central Committee.
> Since it was the real controlling body, the secret organisation was even
> more tightly centralised . . . with first a Central Committee, then a
> "central Geneva section" acting as the "permanent delegation of the
> permanent Central Committee", and, finally, within the central Geneva
> section a "Central Bureau", which was to be both the "executive power . . .
> composed of three, or five, or even seven members" of the secret
> organisation and the executive directory of the public organisation.'_

> _"That this was far more elitist and less democratic than Lenin's model is
> clear."_ [ _"Anarchy in the UK?"_ , **Socialist Review** , no. 246]

There are, as is obvious, numerous problems with Stack's assertions. Firstly,
he makes absolutely **no** attempt to discuss anarchist ideas on the question
of revolutionary organisation. Rather, he prefers to present a somewhat
distorted account of the ideas of Bakunin on the structural aspects of his
organisation, ideas which died with him in 1876! Secondly, as Stack fails to
discuss how anarchists (including Bakunin) see their organisations operating,
its hard to determine whether they are _"ineffective"_ or _"elitist."_ This is
hardly surprising, as they are neither. Thirdly, even as regards his own
example (Bakunin's Alliance) his claim that it was _"ineffectual"_ seems
inappropriate in the extreme. Whether it was _"elitist"_ or _"downright
bizarre"_ is hard to determine, as Stack quotes an unnamed author and their
quotes from its structure. Fourthly, and ironically for Stack, Lenin's
_"model"_ shared many of the same features as those of Bakunin's!

Significantly, Stack fails to discuss any of the standard anarchist ideas on
how revolutionaries should organise. As we discuss in [section
J.3](secJ3.md), there are three main types: the _"synthesis"_ federation,
the _"class struggle"_ federation and those inspired by the _"Platform."_ In
the twenty-first century, these are the main types of anarchist organisation.
As such, it would be extremely hard to argue that these are _"elitist,"_
_"ineffective"_ or _"downright bizarre."_ What these organisational ideas have
in common is the vision of an anarchist organisation as a federation of
autonomous self-managed groups which work with others as equals. How can
directly democratic organisations, which influence others by the force of
their ideas and by their example, be _"elitist"_ or _"downright bizarre"_?
Little wonder, then, that Stack used an example from 1868 to attack anarchism
in the twenty-first century! If he actually presented an honest account of
anarchist ideas then his claims would quickly be seen to be nonsense. And as
for the claim of being _"ineffective"_ well, given that Stack's article was an
attempt to combat anarchist influence in the anti-globalisation movement it
would suggest the opposite.

Even looking at the example of Bakunin's Alliance, we can see evidence that
Stack's summary is simply wrong. It seems strange for Stack to claim that the
Alliance was _"ineffective."_ After all, Marx spent many years combating it
(and Bakunin's influence) in the First International. Indeed, so effective was
it that anarchist ideas dominated most sections of that organisation, forcing
Marx to move the General Council to America to ensure that it did not fall
into the hands of the anarchists (i.e. of the majority). Moreover, it was
hardly _"ineffective"_ when it came to building the International. As Marxist
Paul Thomas notes, _"the International was to prove capable of expanding its
membership only at the behest of the Bakuninists [sic!]"_ and _"[w]herever the
International was spreading, it was doing so under the mantle of Bakuninism."_
[ **Karl Marx and the Anarchists** , p. 315 and p. 319] Even Engels had to
admit that the Spanish section was _"one of finest organisations within the
International_ (which the Spanish Marxists had to _"rescue from the influence
of the Alliance humbugs"_ ). [ **Collected Works** , vol. 23, p. 292]

Yet Stack considers this as an example of an _"ineffective"_ organisation!
But, to be fair, this seems to have been a common failing with Marxists. In
1877, for example, Engels showed his grasp of things by saying _"we may safely
predict that the new departure [in Spain] will not come from these 'anarchist'
spouters, but from the small body of intelligent and energetic workmen who, in
1872, remained true to the International."_ [Marx, Engels, Lenin, **Anarchism
and Anarcho-Syndicalism** , p. 163] In reality, the Spanish Socialist Party
was bureaucratic and reformist to the core while it was the anarchists who
made the Spanish labour movement the most dynamic and revolutionary in the
world.

As regards Stack's summary of Bakunin's organisation, we must note that Stack
is quoting an unnamed source on Bakunin's views on this subject. We,
therefore, have no way of evaluating whether this is a valid summary of
Bakunin's ideas on this matter. As we indicate elsewhere (see [section
J.3.7](secJ3.md#secj37)) Leninist summaries of Bakunin's ideas on secret
organising usually leave a lot to be desired (by usually leaving a lot out or
quoting out of context certain phrases). As such, and given the total lack of
relevance of this model for anarchists since the 1870s, we will not bother to
discuss this summary. Simply put, it is a waste of time to discuss an
organisational model which no modern anarchist supports.

Moreover, there is a key way in which Bakunin's ideas on this issue were far
**less** _"elitist"_ and **more** _"democratic"_ than Lenin's model. Simply,
Bakunin always stressed that his organisation _"rules out any idea of
dictatorship and custodial control."_ [ **Michael Bakunin: Selected Writings**
, p. 172] The _"main purpose and task of the organisation,"_ he argued, would
be to _"help the people to achieve self-determination."_ It would _"not
threaten the liberty of the people because it is free from all official
character"_ and _"not placed above the people like state power."_ Its
programme _"consists of the fullest realisation of the liberty of the people"_
and its influence is _"not contrary to the free development and self-
determination of the people, or its organisation from below according to its
own customs and instincts because it acts on the people only by the natural
personal influence of its members who are not invested with any power."_ Thus
the revolutionary group would be the _"helper"_ of the masses, with an
"organisation within the people itself." [quoted by Michael Confino,
**Daughter of a Revolutionary** , p. 259, p. 261, p. 256 and p. 261] The
revolution itself would see _"an end to all masters and to domination of every
kind, and the free construction of popular life in accordance with popular
needs, not from above downward, as in the state, but from below upward, by the
people themselves, dispensing with all governments and parliaments - a
voluntary alliance of agricultural and factory worker associations, communes,
provinces, and nations; and, finally, . . . universal human brotherhood
triumphing on the ruins of all the states."_ [Bakunin, **Statism and Anarchy**
, p. 33] In other words, Bakunin saw the social revolution in terms of popular
participation and control, **not** the seizing of power by a "revolutionary"
party or group.

Unlike Lenin, Bakunin did not confuse party power with people power. His
organisation, for all it faults (and they were many), did not aim to take
power in the name of the working class and exercise power through a
centralised, top-down state. Rather, its would be based on the _"natural
influence"_ of its members within mass organisations. The influence of
anarchists would, therefore, be limited to the level by which their specific
ideas were accepted by other members of the same organisations after
discussion and debate. As regards the nature of the labour movement, we must
point out that Bakunin provided the same _"serious"_ answer as the anarcho-
syndicalists - namely, revolutionary labour unionism. As we discuss in
[section H.2.8](secH2.md#sech28), Bakunin's ideas on this matter are nearly
identical to those of the syndicalists Stack praises.

As noted, however, no anarchist group has reproduced the internal structure of
the Alliance, which means that Stack's point is simply historical in nature.
Sadly this is not the case with his own politics as the ideas he attacks
actually parallel Lenin's model in many ways (although, as indicated above,
how Bakunin's organisation would function in the class struggle was
fundamentally different, as Lenin's party sought power for itself). Given that
Stack is proposing Lenin's model as a viable means of organising
revolutionaries, it is useful to summarise it. We shall take as an example two
statements issued by the Second World Congress of the Communist International
in 1920 under the direction of Lenin. These are _"Twenty-One Conditions of
Communism"_ and _"Theses on the Role of the Communist Party in the Proletarian
Revolution."_ These two documents provide a vision of Leninist organisation
which is fundamentally elitist.

Lenin's _"model"_ is clear from these documents. The parties adhering to the
Communist International had to have two overlapping forms, one legal (i.e.
public) and another _"illegal"_ (i.e. secret). It was the _"duty"_ of these
parties _"to create everywhere a parallel illegal organisational apparatus."_
[ **Proceedings and Documents of the Second Congress 1920** , vol. 2, p. 767]
Needless to say, this illegal organisation would be the real controlling body,
as it would have to be made up of trusted communists and could only be even
more tightly centralised than the open party as its members could only be
appointed from above by the illegal organisation's central committee. To
stress that the _"illegal"_ (i.e. secret) organisation controlled the party,
the Communist International agreed that that _"[i]n countries where the
bourgeoisie . . . is still in power, the Communist parties must learn to
combine legal and illegal activity in a planned way. However, the legal work
must be placed under the actual control of the illegal party at all times."_ [
**Op. Cit.** , vol. 1, p. 198-9] In this, it should be noted, the Leninists
followed Marx's in 1850 comments (which he later rejected) on the need to
_"establish an independent secret and public organisation of the workers'
party."_ [ **Collected Works** , vol. 10, p. 282]

Even in its open, public mode, the Communist Party was to be a highly
centralised organisation, with all decisions on the national level made by the
Central Committee. The parties must be as centralised as possible, with a
party centre which has strength and authority and is equipped with the most
comprehensive powers. Also, the party press and other publications, and all
party publishing houses, must be subordinated to the party presidium. This
applied on an international level as well, with the decisions of the Communist
International's Executive Committee binding on all parties belonging to it. [
**Op. Cit.** , vol. 2, p. 769] Moreover, _"Communist cells of all kinds must
be subordinate to each other in a strictly hierarchical order of rank as
precisely as possible."_ Democratic centralism itself was fundamentally
hierarchical, with its _"basic principles"_ being that _"the higher bodies
shall be elected by the lower, that all instructions of the higher bodies are
categorically and necessarily binding on the lower."_ Indeed, _"there shall be
a strong party centre whose authority is universally and unquestionably
recognised for all leading party comrades in the period between congresses."_
Any _"advocacy of broad 'autonomy' for the local party organisations only
weakens the ranks of the Communist Party"_ and _"favours petty-bourgeois,
anarchist and disruptive tendencies."_ [ **Op. Cit.** , vol. 1, p. 198]

It seems strange for Stack to argue that Bakunin's ideas (assuming he presents
an honest account of them, of course) were _"far more elitist and less
democratic than Lenin's model"_ as they obviously were not. Indeed, the
similarities between Stack's summary of Bakunin's ideas and Leninist theory
are striking. The Leninist party has the same division between open and secret
(legal and illegal) structures as in Bakunin's, the same centralism and top-
down nature. Lenin argued that _"[i]n all countries, even in those that are
freest, most 'legal,' and most 'peaceful' . . . it is now absolutely
indispensable for every Communist Party to systematically combine legal and
illegal work, legal and illegal organisation."_ He stressed that _"[o]nly the
most reactionary philistine, no matter what cloak of fine 'democratic' and
pacifist phrases he may don, will deny this fact or the conclusion that of
necessity follows from it, viz., that all legal Communist parties must
immediately form illegal organisations for the systematic conduct of illegal
work."_ [ **Collected Works** , vol. 31, p. 195] This was due to the threat of
state repression, which also faced Bakunin's Alliance. As Murray Bookchin
argued, _"Bakunin's emphasis on conspiracy and secrecy can be understood only
against the social background of Italy, Spain, and Russia the three countries
in Europe where conspiracy and secrecy were matters of sheer survival."_ [
**The Spanish Anarchists** , p. 24]

For anarchists, the similarity in structure between Bakunin and Lenin is no
source of embarrassment. Rather, we argue that it is due to a similarity in
political conditions in Russia and **not** similarities in political ideas. If
we look at Bakunin's ideas on social revolution and the workers' movement we
see a fully libertarian perspective - of a movement from the bottom-up, based
on the principles of direct action, self-management and federalism. Anarchists
since his death have applied **these** ideas to the specific anarchist
organisation as well, rejecting the non-libertarian elements of Bakunin's
ideas which Stack correctly (if somewhat hypocritically and dishonestly)
denounces. All in all, Stack has shown himself to be a hypocrite or, at best,
a _"most reactionary philistine"_ (to use Lenin's choice expression).

In addition, it would be useful to evaluate the effectiveness of Stack's
Leninist alternative. Looking at the outcome of the Russian Revolution, we can
only surmise that it is not very effective. This was because its goal is meant
to be a socialist society based on soviet democracy. Did the Russian
Revolution actually result in such a society? Far from it. The Kronstadt
revolt was repressed in 1921 because it demanded soviet democracy. Nor was
this an isolated example. The Bolsheviks had been disbanding soviets with
elected non-Bolshevik majorities since early 1918 (i.e. **before** the start
of the Civil War) and by 1920 leading Bolsheviks were arguing that
dictatorship of the proletariat could only be expressed by means of the
dictatorship of the party. Clearly, the Bolshevik method is hardly
_"effective"_ in the sense of achieving its stated goals. Nor was it
particularly effective before the revolution either. During the 1905
revolution, the Bolsheviks opposed the councils of workers' deputies (soviets)
which had been formed and gave them an ultimatum: either accept the programme
of the Bolsheviks or else disband! The soviets ignored them. In February 1917
the Bolshevik party opposed the actions that produced the revolution which
overthrew the Tsar. Simply put, the one event that validates the Bolshevik
model is the October Revolution of 1917 and even that failed (see [section
H.5.12](secH5.md#sech512)).

Moreover, it backfires on his own politics. The very issues which Stack raises
as being _"elitist"_ in Bakunin (secret and open organisation, centralisation,
top-down decision making) are shared by Lenin. Given that no other anarchist
organisation has ever followed the Alliance structure (and, indeed, it is even
doubtful the Alliance followed it!), it makes a mockery of the scientific
method to base a generalisation on an exception rather than the norm (indeed,
the only exception). For Stack to use Bakunin's ideas on this issue as some
kind of evidence against anarchism staggers belief. Given that anarchists
reject Bakunin's ideas on this subject while Leninists continue to subscribe
to Lenin's, it is very clear that Stack is being extremely hypocritical in
this matter.

One of Stack's comrades in the SWP highlighted another of the great Marxist
myths about anarchist organisation when he stated categorically that _"[a]ll
the major anarchist organisations in history have been centralised but have
operated in secret."_ As evidence they echo Stack's distortions of Bakunin's
Alliance before stating that the _"anarchist organisation inside the Spanish
C.N.T., the F.A.I., was centralised and secret. A revolutionary party thrives
on open debate and common struggle with wider groups of workers."_ [
**Socialist Worker** , no. 1714, 16/09/2000]

It is just as well it stated _"all the major anarchist organisations"_ as it
is vague enough to allow the denial of obvious counter-examples as not being
"major" enough. We can point to hundreds of anarchist organisations that
are/were not secret. For example, the Italian Anarchist Union (UAI) was a non-
secret organisation. Given that it had around 20,000 members in 1920, we
wonder by what criteria the SWP excludes it from being a _"major anarchist
organisation"_? After all, estimates of the membership of the F.A.I. vary from
around 6,000 to around 30,000. Bakunin's "Alliance" amounted to, at most,
under 100. In terms of size, the UAI was equal to the F.A.I. and outnumbered
the "Alliance" considerably. Why was the UAI not a _"major anarchist
organisation"_? Then there are the French anarchist organisations. In the
1930, the **Union Anarchiste** had over 2,000 members, an influential
newspaper and organised many successful public meetings and campaigns (see
David Berry's **A History of the French Anarchist movement, 1917-1945** for
details). Surely that counts as a _"major anarchist organisation"_? Today, the
French Anarchist Federation has a weekly newspaper and groups all across
France as well as in Belgium. That is not secret and is one of the largest
anarchist organisations in the world. We wonder why the SWP excluded such
examples? Needless to say, all of these were based on federal structures
rather than centralised ones.

As for the Spanish Anarchists, the common Leninist notion that it was
centralised seems to flow from Felix Morrow's assertion that _"Spanish
Anarchism had in the FAI a highly centralised party apparatus through which it
maintained control of the CNT."_ [ **Revolution and Counter-Revolution in
Spain** , p. 100] Like the SWP, no attempt was made to provide evidence to
support this claim. It undoubtedly flows from the dogmatic Leninist belief
that centralism is automatically more efficient than federalism combined with
the fact that the Leninists could not take over the CNT. However, in reality,
the FAI neither controlled the CNT nor was it centralised or secret.

The FAI - the Iberian Anarchist Federation - was a federation of regional
federations (including the Portuguese Anarchist Union). These regional
federations, in turn, were federations of highly autonomous anarchist affinity
groups. _"Like the CNT,"_ noted Murray Bookchin, _"the FAI was structured
along confederal lines . . . Almost as a matter of second nature, dissidents
were permitted a considerable amount of freedom in voicing and publishing
material against the leadership and established policies."_ The FAI _"was more
loosely jointed as an organisation than many of its admirers and critics seem
to recognise. It had no bureaucratic apparatus, no membership cards or dues,
and no headquarters with paid officials, secretaries, and clerks. . . They
jealously guarded the autonomy of their affinity groups from the authority of
higher organisational bodies - a state of mind hardly conducive to the
development of a tightly knit, vanguard organisation . . . It had no official
program by which all **faistas** could mechanically guide their actions."_ [
**The Spanish Anarchists** , pp. 197-8] So regardless of Morrow's claims, the
FAI was a federation of autonomous affinity groups in which, as one member put
it, _"[e]ach FAI group thought and acted as it deemed fit, without bothering
about what the others might be thinking or deciding . . . they had no . . .
opportunity or jurisdiction . . . to foist a party line upon the grass-
roots."_ [Francisco Carrasquer, quoted by Stuart Christie, **We, the
Anarchists!** , p. 28]

Was the F.A.I. a "secret" organisation? When it was founded in 1927, Spain was
under the dictatorship of Primo de Rivera and so it was illegal and secret by
necessity. As Stuart Christie correctly notes, _"[a]s an organisation publicly
committed to the overthrow of the dictatorship, the F.A.I. functioned, from
1927 to 1931, as an illegal rather than a secret organisation. From the birth
of the Republic in 1931 onwards, the F.A.I. was simply an organisation which,
until 1937, refused to register as an organisation as required by Republican
Law."_ [ **Op. Cit.** , p. 24] Thus it was illegal rather than secret. As one
anarchist militant asked, _"[i]f it was secret, how come I was able to attend
F.A.I. meetings without ever having joined or paid dues to the 'specific'
organisation?"_ [Francesco Carrasquer, quoted by Christie, **Op. Cit.** , p.
24] The organisation held public meetings, attended by thousands, as well as
publishing journals and newspapers. Its most notable members, such as Durruti,
hardly kept their affiliation secret. Moreover, given the periods of
repression suffered by the Spanish libertarian movement throughout its history
(including being banned and forced underground during the Republic) being an
illegal organisation made perfect sense. The SWP, like most Marxists, ignore
historical context and so mislead the reader.

Did the F.A.I. ignore _"open debate and common struggle."_ No, of course not.
The members of the F.A.I. were also members of the C.N.T. The C.N.T. was based
around mass assemblies in which all members could speak. It was here that
members of the F.A.I. took part in forming C.N.T. policy along with other
C.N.T. members. Anarchists in the C.N.T. who were not members of the F.A.I.
indicate this. Jose Borras Casacarosa noted that _"[o]ne has to recognise that
the F.A.I. did not intervene in the C.N.T. from above or in an authoritarian
manner as did other political parties in the unions. It did so from the base
through militants . . . the decisions which determined the course taken by the
C.N.T. were taken under constant pressure from these militants."_ Jose Campos
states that F.A.I. militants _"tended to reject control of confederal
committees and only accepted them on specific occasions . . . if someone
proposed a motion in assembly, the other F.A.I. members would support it,
usually successfully. It was the individual standing of the faista in open
assembly."_ [quoted by Stuart Christie, **Op. Cit.** , p. 62] It should be
remembered that at union conferences and congresses the _"delegates, whether
or not they were members of the FAI, were presenting resolutions adopted by
their unions at open membership meetings. Actions taken at the congress had to
be reported back to their unions at open meetings, and given the degree of
union education among the members, it was impossible for delegates to support
personal, non-representative positions."_ [Juan Gomez Casas, **Anarchist
Organisation: The History of the FAI** , p. 121]

Significantly, it should be noted that Morrow was re-cycling an argument which
was produced by the reformist wing of the CNT in the 1930s after it had lost
influence in the union rank-and-file ( _"The myth of the FAI as conqueror and
ruler of the CNT was created basically by the **Treinistas**."_ [Juan Gomez
Casas, **Op. Cit.** , p. 134] ). That a Trotskyist should repeat the arguments
of failed bureaucrats in the CNT is not too surprising in that Trotskyism
itself is simply the ideology of Russian failed bureaucrats.

Clearly, the standard Marxist account of anarchist organisations leave a lot
to be desired. They concentrate on just one or two examples (almost always
Bakunin's Alliance or the FAI, usually both) and ignore the vast bulk of
anarchist organisations. Their accounts of the atypical organisations they do
pick is usually flawed, particularly in the case of the FAI where they simply
do not understand the historic context nor how it actually did organise.
Finally, somewhat ironically, in their attacks on Bakunin's ideas they fail to
note the similarities between his ideas and Lenin's and, equally
significantly, the key areas in which they differ. All in all, anarchists
would argue that it is Leninist ideas on the vanguard party which are
_"elitist,"_ _"ineffective"_ and _"downright bizarre."_ As we discuss in
[section H.5](secH5.md), the only thing the Leninist "revolutionary" party
is effective for is replacing one set of bosses with a new set (the leaders of
the party).

[‹ H.1 Have anarchists always opposed state socialism?](secH1.md "Go to
previous page") [up](secHcon.md "Go to parent page") [H.3 What are the myths
of state socialism? ›](secH3.md "Go to next page")

