#include "FastwebNet.h"

#include <wx/string.h>
#include <wx/defs.h>

#include "NetworkFunctions.h" // needed for StringIPtoUint32

bool CFastwebNet::AduIsFastWebIP(const wxString& ipv4string)
{
	uint32 ipv4addr;
	bool bTmp = StringIPtoUint32(ipv4string, ipv4addr);

	return (bTmp && CFastwebNet::AduIsFastWebIP(ipv4addr));
}

// static
wxString CFastwebNet::GetFWCityFromIP(uint32 dwUserIP)
{
	wxString FWCity;
	// Al momento _NON_ e' piu' possibile identificare la citta'/zona a partire dal numero di IP.
	// per ora restituisco quindi la stringa vuota
/*
	switch (dwUserIP & 0x000000ff) {
		case MAN_ROMA:
			FWCity = wxT("RM");
			break;
		case MAN_MILANO:
			FWCity = wxT("MI");
			break;
		case MAN_MILANO_H_NORD:
			FWCity = wxT("MI H. Nord");
			break;
		case MAN_MILANO_H_SUD:
			FWCity = wxT("MI H. Sud");
			break;
		case MAN_GENOVA:
			FWCity = wxT("GE");
			break;
		case MAN_TRIVENETO:
			FWCity = wxT("Triveneto");
			break;
		case MAN_BARI:
			FWCity = wxT("BA");
			break;
		case MAN_BOLOGNA:
			FWCity = wxT("BO");
			break;
		case MAN_NAPOLI:
			FWCity = wxT("NA");
			break;
		case MAN_TORINO:
			FWCity = wxT("TO");
			break;
		case MAN_REGGIO_EMILIA:
			FWCity = wxT("RE");
			break;
		case MAN_TOSCANA:
			FWCity = wxT("Toscana");
			break;
		case MAN_PIEMONTE:
			FWCity = wxT("Piemonte");
			break;
		case MAN_VENETO:
			FWCity = wxT("Veneto");
			break;
		case MAN_GROSSETO:
			FWCity = wxT("GR");
			break;
		case MAN_SICILIA:
			FWCity = wxT("Sicilia");
			break;
		case MAN_ANCONA:
			FWCity = wxT("AN");
			break;
		case MAN_CAGLIARI:
			FWCity = wxT("CA");
			break;
		case FASTWEB_ROUTERS:
			FWCity = wxT("OAM");
			break;
		default:
			FWCity.Empty();
			break;
	}
*/
	return FWCity;
}


bool CFastwebNet::AduIsFiber(uint32 ip)
{
	bool is128(((ip >> 15) & 1) == (uint32)0);

	return (is128 && CFastwebNet::AduIsFastWebLANIP(ip));
}


bool CFastwebNet::AduIsValidKaduAddress( uint32 host )
{
	host = wxUINT32_SWAP_ALWAYS( host );
	// TODO: Add Banlist support here
	return CFastwebNet::AduIsFastWebIP( host );
}


