Update the Linux/BSD system with latest CA bundle and patches from System Update otherwise some issues may occur when generating your free SSL certificates.
Once completed begin with the install procedure below.
- CentOs: `yum update ca-certificates`
- Debian: `apt update ; apt install ca-certificates` (updates package if already installed) \
  also applies to Debian-based distros like Ubuntu, LinuxMint, etc.

## 1. Install from web: https://get.acme.sh

Install https://github.com/acmesh-official/acme.sh

```
curl https://get.acme.sh | sh -s email=my@example.com
```

or

```
wget -O -  https://get.acme.sh | sh -s email=my@example.com
```

## 2. Or, install from GitHub:

```
curl https://raw.githubusercontent.com/acmesh-official/acme.sh/master/acme.sh | sh -s -- --install-online -m  my@example.com
```

or:
```
wget -O -  https://raw.githubusercontent.com/acmesh-official/acme.sh/master/acme.sh | sh -s -- --install-online -m  my@example.com
```


## 3. Or, git clone and install:

```
git clone --depth 1 https://github.com/acmesh-official/acme.sh.git
cd acme.sh
./acme.sh --install -m my@example.com
```


## 4. Advanced installation

```
git clone --depth 1 https://github.com/acmesh-official/acme.sh.git
cd acme.sh
./acme.sh --install  \
--home ~/myacme \
--config-home ~/myacme/data \
--cert-home  ~/mycerts \
--accountemail  "my@example.com" \
--accountkey  ~/myaccount.key \
--accountconf ~/myaccount.conf \
--useragent  "this is my client."
```

You don't need to set them all, just set those ones you care about.

Explanations :

- `--home` is a customized dir to install `acme.sh` in. By default, it installs into `~/.acme.sh` 
- `--config-home` is a writable folder, acme.sh will write all the files(including cert/keys, configs) there. By default, it's in `--home`
- `--cert-home` is a customized dir to save the certs you issue. By default, it's saved in `--config-home`.
- `--accountemail` is the email used to register an account to Let's Encrypt, you will receive a renewal notice email here.
- `--accountkey` is the file saving your account private key. By default, it's saved in `--config-home`.
- `--useragent`  is the user-agent header value used to send to Let's Encrypt.
- `--nocron` install acme.sh without cronjob

## 5. Special case: Converting LE account data from certbot to acme.sh
If already using certbot, then there is the possiblity to convert its LE account data to acme.sh format.
See https://github.com/maddes-b/linux-stuff/tree/main/acme.sh .

If re-using the LE account created from certbot, then it is recommended **not** to specify `-m/--email` during installation.
