/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <dis/dis.h>
#include <sys/uio.h>
#include <sys/socket.h>
#define BSD_COMP		/* keeps Solaris happy */
#include <sys/ioctl.h>
#include <net/if.h>
#include <stdio.h>
#include <dis_relay.h>

SwitchClient *client_list = 0;

#if SYSCALL_PROTO
extern int recvmsg(int, struct msghdr *, int);
extern int sendmsg(int, struct msghdr *, int);
extern int socket(int domain, int type, int protocol);
extern int setsockopt(int s, int level, int optname, char *optval, int optlen);
extern int bind(int s, struct sockaddr *name, int namelen);
extern int ioctl(int, int,...);
extern void perror(const char *);
extern void bcopy(const void *, void *, int);
#endif

int
ReadPDUFrame(DISTransceiver * xcvr, char *pdu, int pdu_max, struct sockaddr *from)
{
    int size;
    struct msghdr msg;
    struct iovec vec;

    msg.msg_name = (caddr_t) from;
    msg.msg_namelen = sizeof(struct sockaddr);
    msg.msg_iov = &vec;
    msg.msg_iovlen = 1;
#ifdef HAVE_MSG_CONTROL
    msg.msg_control = (caddr_t) NULL;
    msg.msg_controllen = 0;
#endif    
#ifdef HAVE_MSG_ACCRIGHTS
    msg.msg_accrights = (caddr_t) NULL;
    msg.msg_accrightslen = 0;
#endif    
    vec.iov_base = (caddr_t) pdu;
    vec.iov_len = pdu_max;

    size = recvmsg(xcvr->s, &msg, 0);

    return size;
}

int
WritePDU(DISTransceiver * xcvr, char *buffer, int length, struct sockaddr *to)
{
    char *p;
    struct msghdr msg;
    struct iovec vec;
    int i, result;


    msg.msg_namelen = sizeof(struct sockaddr);
    msg.msg_iov = &vec;
    msg.msg_iovlen = 1;
#ifdef HAVE_MSG_CONTROL
    msg.msg_control = (caddr_t) NULL;
    msg.msg_controllen = 0;
#endif    
#ifdef HAVE_MSG_ACCRIGHTS
    msg.msg_accrights = (caddr_t) NULL;
    msg.msg_accrightslen = 0;
#endif    
    vec.iov_base = (caddr_t) & buffer;
    vec.iov_len = length;

    msg.msg_name = (caddr_t) to;
    if ((result = sendmsg(xcvr->s, &msg, 0)) == -1) {
	perror("on sendmsg");
    }

    return 0;
}

void
RelayPDUFrame(DISTransceiver * xcvr, char *buffer, int size, struct sockaddr *from)
{
    SwitchClient *p, *new;
    int found = 0;

    for (p = client_list; p; p=p->next) {
	if (memcmp(from, &p->addr, sizeof(struct sockaddr)) == 0) {
	    found = 1;
	    p->frame_count += 1;
	}
	else {
	    WritePDU(xcvr, buffer, size, &p->addr);
	}
    }
    if (found == 0) {
	if ((new = malloc(sizeof(SwitchClient)))) {
	    new->frame_count = 1;
	    memcpy(&new->addr, from, sizeof(struct sockaddr));
	    new->next = client_list;
	    client_list = new;
	}
	else {
	    fprintf(stderr, "memory allocation error\n");
	    exit(1);
	}
    }
}

int
main(int argc, char **argv)
{
    DISTransceiver *xcvr;
    struct sockaddr from;
    int size;
    char buf[2048];

    xcvr = DISOpenTransceiver(-1);
    while (1) {
	if ((size = ReadPDUFrame(xcvr, buf, sizeof(buf), &from)) > 0) {
	    RelayPDUFrame(xcvr, buf, size, &from);
	}
    }
}
