!{\src2tex{textfont=tt}}
!!****f* ABINIT/difvxc
!! NAME
!! difvxc
!!
!! FUNCTION
!!
!! Given the charge density of a homogenous e-gas, this calculates
!! the differential of the Ceperley Alder exchange correlation potential
!! wrt rho (includes relativistic effects see VXCCA).
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  rho=density in real space, at a specific grid point
!!
!! OUTPUT
!!  function difvxc=differential of the Ceperley Alder exchange correlation potential wrt rho
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function difvxc(rho)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => difvxc
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: difvxc
 real(dp),intent(in) :: rho

!Local variables ------------------------------
!scalars
 integer,save :: iprint=0

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: diffvc
 real(dp) :: diffvx
#endif
!End of the abilint section

 if(rho<1.0e-10) then
   if(iprint/=1) then
     write (6,'(/,/,a,e14.6,/,a)')&
& '***Warning: RHO very small in DIFVXC:',rho,&
& '  this message will not be printed again'
     iprint=1
   end if
   difvxc=0.0
 else
   difvxc=diffvc(rho)+diffvx(rho)
 end if

 return
 end function difvxc
!!***
