!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawdij
!! NAME
!! pawdij
!!
!! FUNCTION
!! Compute the different pseudopotential strengths Dij
!! of the PAW non local operator
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  enunit=choice for units of output Dij
!!  natom=number of atoms in cell
!!  nfft=total number of FFt grid
!!  nspden=number of spin-density components
!!  ntypat=number of types of atoms in unit cell.
!!  paw_an(natom) <type(paw_an_type)>=paw arrays given on angular mesh
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawfgrtab(natom) <type(pawfgrtab_type)>=atomic data given on fine rectangular grid
!!  pawprtvol=control print volume and debugging output for PAW
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  pawxcdev=Choice of XC development (0=no dev. (use of angular mesh) ; 1=dev. on moments)
!!  typat(natom)=type (integer) for each atom
!!  ucvol=unit cell volume
!!  vtrial(nfft,nspden)=GS potential (Hartree)
!!
!! OUTPUT
!!  paw_ij(iatom)%dij(klmn,ispden)= total Dij terms
!!
!! NOTES
!!
!! PARENTS
!!      scfcv
!!
!! CHILDREN
!!      leave_new,print_ij,simp_gen,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawdij(enunit,mpi_enreg,natom,nfft,ngfft,nspden,ntypat,&
&                  paw_an,paw_ij,pawang,pawfgrtab,pawprtvol,pawrad,pawtab,&
&                  pawxcdev,typat,ucvol,vtrial)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13paw, except_this_one => pawdij
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: enunit,natom,nfft,nspden,ntypat,pawprtvol,pawxcdev
 real(dp),intent(in) :: ucvol
 type(MPI_type),intent(inout) :: mpi_enreg
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: ngfft(18),typat(natom)
 real(dp),intent(in) :: vtrial(nfft,nspden)
 type(paw_an_type),intent(in) :: paw_an(natom)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)
 type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
 type(pawrad_type),intent(in) :: pawrad(ntypat)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables ---------------------------------------
!scalars
 integer :: iatom,ic,icount,ier,ij_size,iklnu,iklnuold,ilm,ils,ilslm,ipts
 integer :: isel,ispden,itypat,j0lm,jlm,klm,klm1,klmn,klmn1,klmnu
 integer :: klmnuold,kln,l_size,l_size_max,ll,lm0,lm_size,lmax,lmin,lmn2_size
 integer :: lmn_size,lpawu,mesh_size,mm,nfftot,npts,nsppol,old_paral_level
 integer :: spaceComm
 real(dp) :: VUKS,VUKS2,VUKStemp,vxcij,vxcij22,vxcijhat
 character(len=500) :: message
!arrays
 integer,allocatable :: idum(:),indklmn(:,:)
 real(dp) :: rdum(1),tsec(2)
 real(dp),allocatable :: dijpawu(:,:),ff(:),prod(:),veffij(:),vpawu(:,:)
 real(dp),allocatable :: vxcij1(:),vxcij2(:),vxcijtot(:),yylmr(:,:)

! *************************************************************************

 call timab(561,1,tsec)

 if(nspden==4) then
  write(message, '(a,a,a,a)' )ch10,&
&  ' pawdij : ERROR -',ch10,&
&  '  nspden 4 is not yet allowed.'
  call wrtout(6,message,'COLL')
  call leave_new('PERS')
 end if

 if (pawprtvol>=1) then
  write(message, '(2a)')ch10,' ==== In pawdij: several values of Dij (Hartree) ============'
  call wrtout(6,message,'COLL')
 end if
 nfftot=ngfft(1)*ngfft(2)*ngfft(3)
!----- Preliminary computation (only if pawxcdev==0)
 if (pawxcdev==0) then
  npts=pawang%angl_size
  l_size_max=pawang%l_size_max
  allocate(yylmr(l_size_max**2*(l_size_max**2+1)/2,npts))
  do ipts=1,npts
   do jlm=1,l_size_max**2
    j0lm=jlm*(jlm-1)/2
    do ilm=1,jlm
     klm=j0lm+ilm
     yylmr(klm,ipts)=pawang%ylmr(ilm,ipts)*pawang%ylmr(jlm,ipts)
    end do
   end do
  end do
 end if

!------------------------------------------------------------------------
!----- Big loop over atoms
!------------------------------------------------------------------------

 VUKS2=zero;VUKS=zero

 do iatom=1,natom

!------------------------------------------------------------------------
!----------- Allocations and initializations
!------------------------------------------------------------------------

  itypat=typat(iatom)
  l_size=pawtab(itypat)%l_size
  mesh_size=pawrad(itypat)%mesh_size
  lmn_size=paw_ij(iatom)%lmn_size
  lmn2_size=paw_ij(iatom)%lmn2_size
  lm_size=paw_an(iatom)%lm_size
  ij_size=pawtab(itypat)%ij_size
  nsppol=paw_ij(iatom)%nsppol

  allocate(vxcij1(ij_size),vxcij2(l_size))
  allocate(vxcijtot(lmn2_size),veffij(lmn2_size))
  allocate(ff(mesh_size))
  allocate(indklmn(4,lmn2_size))
  indklmn(:,:)=pawtab(itypat)%indklmn(:,:)

! Eventually compute g_l(r).Y_lm(r) factors for the current atom (if not already done)
  if (pawfgrtab(iatom)%gylm_allocated==0) then
   if (associated(pawfgrtab(iatom)%gylm)) deallocate(pawfgrtab(iatom)%gylm)
   allocate(pawfgrtab(iatom)%gylm(pawfgrtab(iatom)%nfgd,l_size*l_size))
   pawfgrtab(iatom)%gylm_allocated=2
   call pawgylm(pawfgrtab(iatom)%gylm,rdum,rdum,iatom,pawfgrtab(iatom)%ifftsph,&
&               itypat,pawfgrtab(iatom)%nfgd,1,0,0,0,pawtab(itypat),&
&               pawfgrtab(iatom)%rfgd,pawfgrtab(iatom)%rfgd_allocated,rdum)
  end if

!------------------------------------------------------------------------
!----- Loop over density components
!------------------------------------------------------------------------
  do ispden=1,nsppol

!------------------------------------------------------------------------
!----------- Load atomic Dij0 into Dij
!------------------------------------------------------------------------

   paw_ij(iatom)%dij(:,ispden)=pawtab(itypat)%dij0

   if (pawprtvol>=1) then
    if (iatom==1.or.iatom==natom) then
     if (nspden==2.and.nsppol==1) then
      write(message, '(2a,i3,5a)') ch10,&
&      ' >>>>>>>>>> Atom ',iatom,':',ch10,&
&      ' (antiferromagnetism case: only one spin component)',ch10,&
&      '   ************ Dij atomic (Dij0) ***********'
     else
     write(message, '(2a,i3,a,i1,3a)') ch10,&
&      ' >>>>>>>>>> Atom ',iatom,' (ispden=',ispden,'):',ch10,&
&      '   ************ Dij atomic (Dij0) ***********'
     end if
     call wrtout(6,message,'COLL')
     call print_ij(pawtab(itypat)%dij0,lmn2_size,lmn_size,1,-1,idum,0,idum,-1.d0,1)
    end if
   end if

!------------------------------------------------------------------------
!----------- Add Dij_Hartree to Dij
!------------------------------------------------------------------------

   paw_ij(iatom)%dij(:,ispden)=paw_ij(iatom)%dij(:,ispden)&
&                             +paw_ij(iatom)%veij(:)

   if (pawprtvol>=1) then
    if (iatom==1.or.iatom==natom) then
     write(message, '(a)')'   ********** Dij Hartree (Veijkl) **********'
     call wrtout(6,message,'COLL')
     call print_ij(paw_ij(iatom)%veij,lmn2_size,lmn_size,1,-1,idum,0,idum,-1.d0,1)
    end if
   end if

!------------------------------------------------------------------------
!----------- Add Dij_xc to Dij
!------------------------------------------------------------------------

! ================================================
! ===== First formalism: use (l,m) moments for vxc
! ================================================
   if (pawxcdev/=0) then

    vxcijtot=zero
    do klm=1,lm_size
     if (paw_an(iatom)%lmselect(klm,ispden)>0) then


!     ===== Vxc_ij_1 (tmp) =====
      vxcij1=zero
      do kln=1,ij_size
       ff(1:mesh_size)= paw_an(iatom)%vxc1(1:mesh_size,klm,ispden)&
&                      *pawtab(itypat)%phiphj(1:mesh_size,kln)&
&                     - paw_an(iatom)%vxct1(1:mesh_size,klm,ispden)&
&                      *pawtab(itypat)%tphitphj(1:mesh_size,kln)
       call simp_gen(vxcij1(kln),ff,pawrad(itypat))
      end do

!     ===== Vxc_ij_2 (tmp) =====
      vxcij22=zero
      ll=1+int(sqrt(dble(klm)-0.1))
      ff(1:mesh_size)=paw_an(iatom)%vxct1(1:mesh_size,klm,ispden)&
&                    *pawtab(itypat)%shapefunc(1:mesh_size,ll)&
&                    *pawrad(itypat)%rad(1:mesh_size)**2
      call simp_gen(vxcij22,ff,pawrad(itypat))

!     ===== Vxc_ij and Vxcij_hat from Vxc_ij_1 and Vxc_ij_2 =====
      do klmn=1,lmn2_size
       klm1=indklmn(1,klmn);kln=indklmn(2,klmn)

       vxcij=zero
       isel=pawang%gntselect(klm,klm1)
       if (isel>0) vxcij=vxcij1(kln)*pawang%realgnt(isel)
       vxcijhat=pawtab(itypat)%qijl(klm,klmn)*vxcij22

!      ===== Contribution to total Vxc_ij =====
       vxcijtot(klmn)=vxcijtot(klmn)+vxcij-vxcijhat

      end do ! Loop klmn
     end if
    end do  ! Loop klm

! ================================================
! ===== Second formalism: use vxc on angular grid
! ================================================
   else

    vxcijtot=zero
    do ipts=1,npts

!    ===== Vxc_ij_1 (tmp) =====
     vxcij1=zero
     do kln=1,ij_size
      ff(1:mesh_size)= paw_an(iatom)%vxc1(1:mesh_size,ipts,ispden)&
&                     *pawtab(itypat)%phiphj(1:mesh_size,kln)&
&                     - paw_an(iatom)%vxct1(1:mesh_size,ipts,ispden)&
&                     *pawtab(itypat)%tphitphj(1:mesh_size,kln)
      call simp_gen(vxcij1(kln),ff,pawrad(itypat))
     end do

!    ===== Vxc_ij_2 (tmp) =====
     vxcij2=zero
     do ils=1,l_size
      ff(1:mesh_size)=paw_an(iatom)%vxct1(1:mesh_size,ipts,ispden)&
&           *pawtab(itypat)%shapefunc(1:mesh_size,ils)&
&           *pawrad(itypat)%rad(1:mesh_size)**2
      call simp_gen(vxcij2(ils),ff,pawrad(itypat))
     end do

!    ===== Vxc_ij and Vxcij_hat from Vxc_ij_1 and Vxc_ij_2 =====
     do klmn=1,lmn2_size
      klm=indklmn(1,klmn);kln=indklmn(2,klmn)
      lmin=indklmn(3,klmn);lmax=indklmn(4,klmn)

      vxcij=vxcij1(kln)*pawang%angwgth(ipts)*yylmr(klm,ipts)*four_pi

      vxcijhat=zero
      do ils=lmin,lmax,2
       lm0=ils**2+ils+1
       do mm=-ils,ils
        ilslm=lm0+mm;isel=pawang%gntselect(lm0+mm,klm)
        if (isel>0) vxcijhat=vxcijhat+vxcij2(ils+1)*pawang%angwgth(ipts)&
&                               *pawtab(itypat)%qijl(ilslm,klmn)*four_pi&
&                               *pawang%ylmr(ilslm,ipts)
       end do
      end do

!     ===== Contribution to total Vxc_ij =====
      vxcijtot(klmn)=vxcijtot(klmn)+vxcij-vxcijhat

     end do ! Loop klmn
    end do  ! Loop ipts

   end if  ! choice XC

   paw_ij(iatom)%dij(:,ispden)=paw_ij(iatom)%dij(:,ispden)+vxcijtot(:)

   if (pawprtvol>=1) then
    if (iatom==1.or.iatom==natom) then
     write(message, '(a)')'   ****************** Dij_xc ****************'
     call wrtout(6,message,'COLL')
     call print_ij(vxcijtot,lmn2_size,lmn_size,1,-1,idum,0,idum,-1.d0,1)
    end if
   end if

!------------------------------------------------------------------------
!----------- Add Dij_hat to Dij
!------------------------------------------------------------------------

   veffij=zero
   allocate(prod(l_size*l_size));prod=zero
   do ilslm=1,l_size**2
    do ic=1,pawfgrtab(iatom)%nfgd
     prod(ilslm)=prod(ilslm)+vtrial(pawfgrtab(iatom)%ifftsph(ic),ispden)&
&                                  *pawfgrtab(iatom)%gylm(ic,ilslm)
    end do
   end do
   if(mpi_enreg%paral_fft==1)then
    old_paral_level= mpi_enreg%paral_level
    mpi_enreg%paral_level=3
    call xcomm_init(mpi_enreg,spaceComm)
    if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
    call xsum_mpi(prod,spaceComm,ier)
    mpi_enreg%paral_level=old_paral_level
   end if
   do klmn=1,lmn2_size
    klm=indklmn(1,klmn)
    lmin=indklmn(3,klmn);lmax=indklmn(4,klmn)
    do ils=lmin,lmax,2
     lm0=ils**2+ils+1
     do mm=-ils,ils
      ilslm=lm0+mm;isel=pawang%gntselect(lm0+mm,klm)
      if (isel>0) veffij(klmn)=veffij(klmn)&
&                +prod(ilslm)*pawtab(itypat)%qijl(ilslm,klmn)
     end do
    end do
   end do
   deallocate(prod)
   veffij(:)=veffij(:)*ucvol/dble(nfftot)
   paw_ij(iatom)%dij(:,ispden)=paw_ij(iatom)%dij(:,ispden)+veffij(:)

   if (pawprtvol>=1) then
    if (iatom==1.or.iatom==natom) then
     write(message, '(a)')'   ************* Dij_hat (Veff_ij) **********'
     call wrtout(6,message,'COLL')
     call print_ij(veffij,lmn2_size,lmn_size,1,-1,idum,0,idum,-1.d0,1)
    end if
   end if

!------------------------------------------------------------------------
!----------- Add Dij_{lda+u} to Dij
!--------------------------------------------------------------------------
! Dijpawu^{\sigma}_{mi,ni,mj,nj}=
! \sum_{m,m'} [vpawu^{\sigma}_{m,m'}*phiphjint_{ni,nj}^{m,m'}]=
! [vpawu^{\sigma}_{mi,mj}*phiphjint_{ni,nj}]
!--------------------------------------------------------------------------
   if (pawtab(itypat)%usepawu>0) then
    if(pawprtvol>=3) then
     write(message,*) "pawdij, LDA+U calculation for iatom,ispden",iatom,ispden,itypat
     call wrtout(06,  message,'COLL')
    endif
    allocate(vpawu(pawtab(itypat)%lpawu*2+1,pawtab(itypat)%lpawu*2+1))
    allocate(dijpawu(lmn2_size,nspden))
    dijpawu=zero
    lpawu=pawtab(itypat)%lpawu
    call pawpupot(ispden,nspden,paw_ij(iatom),pawprtvol,pawtab(itypat),vpawu,VUKS)
    do klmn=1,lmn2_size
     if(pawtab(itypat)%indklmn(3,klmn)==0.and.&
&     pawtab(itypat)%indklmn(4,klmn)==2*pawtab(itypat)%lpawu) then
      icount=pawtab(itypat)%klmntomn(3,klmn)+(pawtab(itypat)%klmntomn(4,klmn)&
&      *(pawtab(itypat)%klmntomn(4,klmn)-1))/2
!------test
      if(pawtab(itypat)%ij_proj<icount)  then
      write(message, '(a,a,a,a,a,a)' ) ch10,&
&     ' pawdij : ERROR -',ch10,&
&     '  PAW+U: Error in the loop for calculating dijpawu',ch10,&
&     '  Action : contact the abinit group.'
      call wrtout(ab_out,message,'COLL');call wrtout(06,  message,'COLL')
      call leave_new('COLL')
      end if
!------
      dijpawu(klmn,ispden)=pawtab(itypat)%phiphjint(icount)&
&      *vpawu(pawtab(itypat)%klmntomn(1,klmn)&
&      ,pawtab(itypat)%klmntomn(2,klmn))
     end if
    end do
!------test
    if(pawtab(itypat)%ij_proj/=icount)  then
     write(message, '(a,a,a,a,a,a)' ) ch10,&
&    ' pawdij : ERROR -',ch10,&
&    '  PAW+U: Error after the loop for calculating dijpawu',ch10,&
&    '  Action : contact the abinit group.'
     call wrtout(ab_out,message,'COLL');call wrtout(06,  message,'COLL')
!      call leave_new('COLL')
    end if
!------
!   test energy
!     if (pawprtvol>=3) then
!      VUKStemp=zero
!      do irhoij=1,pawrhoij(iatom)%nrhoijsel(ispden)
!       klmn=pawrhoij(iatom)%rhoijselect(irhoij,ispden)
!       VUKStemp=VUKStemp+dijpawu(klmn,ispden)*pawrhoij(iatom)%rhoijp(irhoij,ispden)&
! &     *pawtab(itypat)%dltij(klmn) ! dlt
!       write(message,*) "klmntomn", pawtab(itypat)%klmntomn(1,klmn),&
! &      pawtab(itypat)%klmntomn(2,klmn)
!       call wrtout(06,message,'COLL')
!       write(message,*) "klmntomn", pawtab(itypat)%klmntomn(3,klmn),&
! &      pawtab(itypat)%klmntomn(4,klmn)
!       call wrtout(06,message,'COLL')
!       write(message,*) "vuks2:klmn,dijpawu,rhoijp", klmn,dijpawu(klmn,ispden)&
! &     ,pawrhoij(iatom)%rhoijp(irhoij,ispden)
!       call wrtout(06,message,'COLL')
!       write(message,*) "Vukstemp",VUKStemp,pawtab(itypat)%dltij(klmn)
!       call wrtout(06,message,'COLL')
!      end do
!      VUKS2=VUKS2+VUKStemp
!      write(message,*) "pawdij: VUKStemp",ispden,VUKStemp
!      call wrtout(06,message,'COLL')
!      write(message,*) "pawdij: VUKS2",ispden, VUKS2
!      call wrtout(06,message,'COLL')
!     end if
!   end  test energy
    paw_ij(iatom)%dij(:,ispden)=paw_ij(iatom)%dij(:,ispden)+dijpawu(:,ispden)
    if (pawprtvol>=1) then
     if (iatom==1.or.iatom==natom) then
      write(message, '(a)')'   ************* Dij_LDA+U (dijpawu) **********'
      call wrtout(6,message,'COLL')
      call print_ij(dijpawu(:,ispden),lmn2_size,lmn_size,1,-1,idum,0,idum,-1.d0,1)
     end if
    end if
    deallocate(vpawu,dijpawu)
   end if

   if (pawprtvol>=1) then
    if (iatom==1.or.iatom==natom) then
     write(message, '(a)' )'   **********    TOTAL Dij in Ha   **********'
     call wrtout(6,message,'COLL')
     call print_ij(paw_ij(iatom)%dij(:,ispden),lmn2_size,lmn_size,&
&                  1,-1,idum,0,idum,50.d0*dble(3-2*ispden),1)
     if (enunit>0) then
      write(message, '(a)' )'   **********    TOTAL Dij in eV   **********'
      call wrtout(6,message,'COLL')
      call print_ij(paw_ij(iatom)%dij(:,ispden),lmn2_size,lmn_size,1,-1,idum,0,idum,-1.d0,2)
     end if
    end if
   end if
   if (pawprtvol<1) then
    if (iatom==1.or.iatom==natom) then
     if (nspden==2.and.nsppol==1) then
      write(message, '(2a,i3,3a)') ch10,&
&      ' ******  TOTAL Dij in Ha (atom ',iatom,') *****',ch10,&
&      ' (antiferromagnetism case: only one spin component)'
     else
     write(message, '(a,a,i3,a,i1,a)') ch10,&
&     ' ******  TOTAL Dij in Ha (atom ',iatom,', ispden=',ispden,') *****'
     end if
     call wrtout(6,message,'COLL')
     call print_ij(paw_ij(iatom)%dij(:,ispden),lmn2_size,lmn_size,1,-1,&
&                  idum,0,idum,50.d0*dble(3-2*ispden),1)
    end if
   end if

!  ----- End loops over iatom and ispden
  end do
  deallocate(indklmn,ff,veffij,vxcij1,vxcij2,vxcijtot)
  if (pawfgrtab(iatom)%gylm_allocated==2) then
   deallocate(pawfgrtab(iatom)%gylm);allocate(pawfgrtab(iatom)%gylm(0,0))
   pawfgrtab(iatom)%gylm_allocated=0
  end if

 end do

 if (pawxcdev==0) deallocate(yylmr)
 call timab(561,2,tsec)

end subroutine pawdij
!!***
