#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Heroes of Might and Magic 4
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251113.7

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='heroes-of-might-and-magic-4'
GAME_NAME='Heroes of Might and Magic IV'

ARCHIVE_BASE_EN_4_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_gog_0.2_(76223).exe'
ARCHIVE_BASE_EN_4_MD5='7737a4617848cb701f6577128b17fdc4'
ARCHIVE_BASE_EN_4_TYPE='innosetup'
ARCHIVE_BASE_EN_4_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_gog_0.2_(76223)-1.bin'
ARCHIVE_BASE_EN_4_PART1_MD5='fb953df444f1716b856db53d4c08520a'
ARCHIVE_BASE_EN_4_SIZE='1126546'
ARCHIVE_BASE_EN_4_VERSION='3.0-gog76223'
ARCHIVE_BASE_EN_4_URL='https://www.gog.com/game/heroes_of_might_and_magic_4_complete'

ARCHIVE_BASE_FR_4_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_gog_0.2_(french)_(76223).exe'
ARCHIVE_BASE_FR_4_MD5='d87e74674382d446332cf257ef6cbf74'
ARCHIVE_BASE_FR_4_TYPE='innosetup'
ARCHIVE_BASE_FR_4_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_gog_0.2_(french)_(76223)-1.bin'
ARCHIVE_BASE_FR_4_PART1_MD5='00c24ec39905f65ed033d8dc2a77e7b3'
ARCHIVE_BASE_FR_4_SIZE='1173753'
ARCHIVE_BASE_FR_4_VERSION='3.0-gog76223'
ARCHIVE_BASE_FR_4_URL='https://www.gog.com/game/heroes_of_might_and_magic_4_complete'

ARCHIVE_BASE_EN_3_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_(58571).exe'
ARCHIVE_BASE_EN_3_MD5='4f342558b1f93f4057666bc510127a3b'
ARCHIVE_BASE_EN_3_TYPE='innosetup'
ARCHIVE_BASE_EN_3_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_(58571)-1.bin'
ARCHIVE_BASE_EN_3_PART1_MD5='c82afd73219eb772ce21f5ab43ef34ce'
ARCHIVE_BASE_EN_3_SIZE='1200000'
ARCHIVE_BASE_EN_3_VERSION='3.0-gog58571'

ARCHIVE_BASE_FR_3_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_(french)_(58571).exe'
ARCHIVE_BASE_FR_3_MD5='27d3987a5001beff61176d39199b9284'
ARCHIVE_BASE_FR_3_TYPE='innosetup'
ARCHIVE_BASE_FR_3_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_win11_(french)_(58571)-1.bin'
ARCHIVE_BASE_FR_3_PART1_MD5='588b0ecacc6b91df76042af7a7667d24'
ARCHIVE_BASE_FR_3_SIZE='1200000'
ARCHIVE_BASE_FR_3_VERSION='3.0-gog58571'

ARCHIVE_BASE_EN_2_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(25023).exe'
ARCHIVE_BASE_EN_2_MD5='2694dfef6827142866fb778588966d8e'
ARCHIVE_BASE_EN_2_TYPE='innosetup'
ARCHIVE_BASE_EN_2_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(25023)-1.bin'
ARCHIVE_BASE_EN_2_PART1_MD5='54bfa42a4e23236729f8b0724216ee83'
ARCHIVE_BASE_EN_2_SIZE='1100000'
ARCHIVE_BASE_EN_2_VERSION='3.0-gog25023'

ARCHIVE_BASE_FR_2_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(french)_(25023).exe'
ARCHIVE_BASE_FR_2_MD5='4a90a92d637bc7d1af5354565ae5cd70'
ARCHIVE_BASE_FR_2_TYPE='innosetup'
ARCHIVE_BASE_FR_2_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(french)_(25023)-1.bin'
ARCHIVE_BASE_FR_2_PART1_MD5='46d1239b8491d3adec647a7526f763b2'
ARCHIVE_BASE_FR_2_SIZE='1100000'
ARCHIVE_BASE_FR_2_VERSION='3.0-gog25023'

ARCHIVE_BASE_EN_1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(22812).exe'
ARCHIVE_BASE_EN_1_MD5='d5e0a55e2bba4f0ac643ec1fb2ba17cc'
ARCHIVE_BASE_EN_1_TYPE='innosetup'
ARCHIVE_BASE_EN_1_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(22812)-1.bin'
ARCHIVE_BASE_EN_1_PART1_MD5='3457ead5c208a3d40498d6e1f08bf588'
ARCHIVE_BASE_EN_1_SIZE='1100000'
ARCHIVE_BASE_EN_1_VERSION='3.0-gog22812'

ARCHIVE_BASE_FR_1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(french)_(22812).exe'
ARCHIVE_BASE_FR_1_MD5='e15ec7a308ea442bfeeb3410314b39d7'
ARCHIVE_BASE_FR_1_TYPE='innosetup'
ARCHIVE_BASE_FR_1_PART1_NAME='setup_heroes_of_might_and_magic_4_complete_3.0_(french)_(22812)-1.bin'
ARCHIVE_BASE_FR_1_PART1_MD5='7abff7182f6bed3199d2b71cdd60d926'
ARCHIVE_BASE_FR_1_SIZE='1100000'
ARCHIVE_BASE_FR_1_VERSION='3.0-gog22812'

ARCHIVE_BASE_EN_0_NAME='setup_homm4_complete_2.0.0.12.exe'
ARCHIVE_BASE_EN_0_MD5='74de66eb408bb2916dd0227781ba96dc'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='1100000'
ARCHIVE_BASE_EN_0_VERSION='3.0-gog2.0.0.12'

ARCHIVE_BASE_FR_0_NAME='setup_homm4_complete_french_2.1.0.14.exe'
ARCHIVE_BASE_FR_0_MD5='2af96eb28226e563bbbcd62771f3a319'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='1100000'
ARCHIVE_BASE_FR_0_VERSION='3.0-gog2.1.0.14'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_EN_0='app'
CONTENT_PATH_DEFAULT_FR_0='app'
CONTENT_LIBS_BIN_FILES='
binkw32.dll
mss32.dll'
## heroes4.exe is not strictly identical for the French and English localisation of the game,
## but it seems one can be used in place of the other.
CONTENT_GAME_BIN_FILES='
heroes4.exe'
CONTENT_GAME0_BIN_FILES='
mp3dec.asi
campaign_editor.exe'
CONTENT_GAME_DATA_FILES='
maps
data/high_scores.dat
data/default.aop
data/heroes4.h4r
data/movies.h4r
data/storm.h4r
data/text.h4r
data/updates.h4r
data/x2.h4r
data/x2_override.h4r'
CONTENT_GAME_DATA_COMMON_FILES='
data/current.aop
data/storm.aop
data/winds.aop
data/music.h4r
data/storm_override.h4r
data/default.pbg'
CONTENT_DOC_DATA_FILES='
campaign_editor_help.chm
h4gsmanual.pdf
h4manual.pdf
h4qref.pdf
h4towntrees.pdf
h4wwmanual.pdf
multiplayer.txt
readme.txt'

USER_PERSISTENT_DIRECTORIES='
games'
USER_PERSISTENT_FILES='
data/high_scores.dat'

## Run the game in windowed mode on first launch.
WINE_REGISTRY_INIT='
[HKEY_CURRENT_USER\Software\New World Computing\Heroes of Might and Magic IV]
"full_screen"=dword:00000000
'

APP_MAIN_EXE='heroes4.exe'
APP_MAIN_ICON='heroes4.exe'

APP_EDITOR_ID="${GAME_ID}-campaign-editor"
APP_EDITOR_EXE='campaign_editor.exe'
APP_EDITOR_ICON='campaign_editor.exe'
APP_EDITOR_NAME="$GAME_NAME - campaign editor"

PACKAGES_LIST='
PKG_BIN
PKG_DATA
PKG_DATA_COMMON'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA_BASE'

PKG_DATA_BASE_ID="${GAME_ID}-data"
PKG_DATA_ID_EN="${PKG_DATA_BASE_ID}-en"
PKG_DATA_ID_FR="${PKG_DATA_BASE_ID}-fr"
PKG_DATA_PROVIDES="
$PKG_DATA_BASE_ID"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DESCRIPTION_EN="${PKG_DATA_DESCRIPTION} - English version"
PKG_DATA_DESCRIPTION_FR="${PKG_DATA_DESCRIPTION} - French version"
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_COMMON'

PKG_DATA_COMMON_ID="${PKG_DATA_BASE_ID}-common"
PKG_DATA_COMMON_DESCRIPTION="${PKG_DATA_DESCRIPTION} - common files"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA_COMMON'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	ln --force --symbolic $(path_libraries)/* "\${PATH_PREFIX}"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
